struct Presentation : Window {
  enum : u32 { StatusHeight = 24 };

  Presentation();
  auto resizeWindow() -> void;
  auto loadEmulators() -> void;
  auto loadEmulator() -> void;
  auto unloadEmulator(bool reloading = false) -> void;
  auto showIcon(bool visible) -> void;
  auto loadShaders() -> void;
  auto refreshSystemMenu() -> void;

  std::vector<string> shaderDirectories;

  MenuBar menuBar{this};
    Menu loadMenu{&menuBar};
    Menu systemMenu{&menuBar};
    Menu settingsMenu{&menuBar};
      Menu videoSizeMenu{&settingsMenu};
        Group videoSizeGroup;
      Menu videoOutputMenu{&settingsMenu};
        MenuRadioItem videoOutputScale{&videoOutputMenu};
        MenuRadioItem videoOutputIntegerScale{&videoOutputMenu};
        MenuRadioItem videoOutputStretch{&videoOutputMenu};
        Group videoOutputGroup{&videoOutputIntegerScale, &videoOutputScale, &videoOutputStretch};
        MenuSeparator videoOutputSeparator{&videoOutputMenu};
        MenuRadioItem videoAspectCorrectionNone{&videoOutputMenu};
        MenuRadioItem videoAspectCorrectionStandard{&videoOutputMenu};
        MenuRadioItem videoAspectCorrectionAnamorphic{&videoOutputMenu};
        Group videoAspectCorrectionGroup{&videoAspectCorrectionNone, &videoAspectCorrectionStandard, 
                                         &videoAspectCorrectionAnamorphic};
        MenuSeparator videoOutputSeparator2{&videoOutputMenu};
        MenuCheckItem videoAdaptiveSizing{&videoOutputMenu};
        MenuCheckItem videoAutoCentering{&videoOutputMenu};
      Menu videoShaderMenu{&settingsMenu};
      Menu bootOptionsMenu{&settingsMenu};
        MenuCheckItem fastBoot{&bootOptionsMenu};
        MenuCheckItem launchDebugger{&bootOptionsMenu};
        MenuCheckItem awaitGDBClient{&bootOptionsMenu};
        MenuSeparator bootOptionsSeparator{&bootOptionsMenu};
        Menu bootOptionsRegionMenu{&bootOptionsMenu};
          MenuRadioItem regionUJE{&bootOptionsRegionMenu};
          MenuRadioItem regionUEJ{&bootOptionsRegionMenu};
          MenuRadioItem regionJUE{&bootOptionsRegionMenu};
          MenuRadioItem regionJEU{&bootOptionsRegionMenu};
          MenuRadioItem regionEUJ{&bootOptionsRegionMenu};
          MenuRadioItem regionEJU{&bootOptionsRegionMenu};
          Group preferRegionGroup{&regionUJE, &regionUEJ, &regionJUE, &regionJEU, &regionEUJ, &regionEJU};
      MenuSeparator groupSettingsSeparator{&settingsMenu};
      MenuCheckItem muteAudioSetting{&settingsMenu};
      MenuCheckItem showStatusBarSetting{&settingsMenu};
      MenuSeparator audioSettingsSeparator{&settingsMenu};
      MenuItem videoSettingsAction{&settingsMenu};
      MenuItem audioSettingsAction{&settingsMenu};
      MenuItem inputSettingsAction{&settingsMenu};
      MenuItem hotkeySettingsAction{&settingsMenu};
      MenuItem emulatorSettingsAction{&settingsMenu};
      MenuItem optionSettingsAction{&settingsMenu};
      MenuItem firmwareSettingsAction{&settingsMenu};
      MenuItem pathSettingsAction{&settingsMenu};
      MenuItem driverSettingsAction{&settingsMenu};
      MenuItem debugSettingsAction{&settingsMenu};
    Menu toolsMenu{&menuBar};
      Menu saveStateMenu{&toolsMenu};
      Menu loadStateMenu{&toolsMenu};
      MenuItem undoSaveStateMenu{&toolsMenu};
      MenuItem undoLoadStateMenu{&toolsMenu};
      MenuItem captureScreenshot{&toolsMenu};
      MenuSeparator toolsMenuSeparatorA{&toolsMenu};
      MenuCheckItem pauseEmulation{&toolsMenu};
      MenuItem frameAdvance{&toolsMenu};
      MenuItem reloadGame{&toolsMenu};
      MenuSeparator toolsMenuSeparatorB{&toolsMenu};
      MenuItem manifestViewerAction{&toolsMenu};
      MenuItem cheatEditorAction{&toolsMenu};
      MenuItem memoryEditorAction{&toolsMenu};
      MenuItem graphicsViewerAction{&toolsMenu};
      MenuItem streamManagerAction{&toolsMenu};
      MenuItem propertiesViewerAction{&toolsMenu};
      MenuItem traceLoggerAction{&toolsMenu};
    Menu helpMenu{&menuBar};
      MenuItem aboutAction{&helpMenu};

  VerticalLayout layout{this};
    HorizontalLayout viewportLayout{&layout, Size{~0, ~0}, 0};
      Viewport viewport{&viewportLayout, Size{~0, ~0}, 0};
      VerticalLayout iconLayout{&viewportLayout, Size{144, ~0}, 0};
        Canvas iconSpacer{&iconLayout, Size{144, ~0}, 0};
        HorizontalLayout iconHorizontal{&iconLayout, Size{144, 128}, 0};
          Canvas iconCanvas{&iconHorizontal, Size{128, 128}, 0};
          Canvas iconPadding{&iconHorizontal, Size{16, 128}, 0};
        Canvas iconBottom{&iconLayout, Size{144, 10}, 0};
    HorizontalLayout statusLayout{&layout, Size{~0, StatusHeight}, 0};
      Label spacerLeft{&statusLayout, Size{8, ~0}, 0};
      Label statusLeft{&statusLayout, Size{~0, ~0}, 0};
      Label statusRight{&statusLayout, Size{90, ~0}, 0};
      Label spacerRight{&statusLayout, Size{8, ~0}, 0};
};

namespace Instances { extern Instance<Presentation> presentation; }
extern Presentation& presentation;
