# SPDX-License-Identifier: MIT
# SPDX-FileCopyrightText: 2004 Tristan Seligmann and Jonathan Jacobs
# SPDX-FileCopyrightText: 2012 Bastian Kleineidam
# SPDX-FileCopyrightText: 2015 Tobias Gruetzmacher
# SPDX-FileCopyrightText: 2019 Daniel Ring
from re import compile, escape

from .. import util
from ..scraper import BasicScraper, ParserScraper
from ..util import tagre
from .common import WordPressNavi, WordPressScraper


class IAmArg(BasicScraper):
    url = 'http://iamarg.com/'
    rurl = escape(url)
    stripUrl = url + '%s/'
    firstStripUrl = stripUrl % '2011/05/08/05082011'
    imageSearch = compile(tagre("img", "src", r'(//iamarg.com/comics/\d+-\d+-\d+[^"]+)'))
    prevSearch = compile(tagre("a", "href", r'(%s\d+/\d+/\d+/[^"]+)' % rurl, after="prev"))
    help = 'Index format: yyyy/mm/dd/stripname'


class ICanBarelyDraw(BasicScraper):
    url = 'http://www.icanbarelydraw.com/comic/'
    rurl = escape(url)
    stripUrl = url + '%s'
    firstStripUrl = stripUrl % '39'
    imageSearch = compile(tagre("img", "src", r'(%scomics/\d+-\d+-\d+-[^"]+)' % rurl))
    prevSearch = compile(tagre("a", "href", r'(%s\d+)' % rurl))
    help = 'Index format: number'


class IDreamOfAJeanieBottle(WordPressScraper):
    url = 'http://jeaniebottle.com/'


class InternetWebcomic(WordPressNavi):
    url = 'http://www.internet-webcomic.com/'
    stripUrl = url + '?p=%s'
    firstStripUrl = stripUrl % '30'
    help = 'Index format: n'


class Inverloch(ParserScraper):
    stripUrl = 'https://www.seraph-inn.com/view.php?story=inverloch&page=%s'
    url = stripUrl % '763'
    firstStripUrl = stripUrl % '2'
    imageSearch = '//img[@class="page"]'
    prevSearch = '//p[@class="comic-nav"]/a[text()=" Previous"]'
    multipleImagesPerStrip = True
    endOfLife = True


class IrregularWebcomic(BasicScraper):
    url = 'http://www.irregularwebcomic.net/'
    stripUrl = url + '%s.html'
    firstStripUrl = stripUrl % '1'
    imageSearch = compile(r'<img .*src="(.*comics/.*(png|jpg|gif))".*>')
    prevSearch = compile(r'<a href="(/\d+\.html|/cgi-bin/comic\.pl\?comic=\d+)">Previous ')
    help = 'Index format: nnn'


class IslaAukate(ParserScraper):
    url = 'https://overlordcomic.com/archive/default/latest'
    stripUrl = 'https://overlordcomic.com/archive/default/pages/%s'
    firstStripUrl = stripUrl % '001'
    imageSearch = '//div[@id="comicpage"]/img'
    prevSearch = '//nav[@class="comicnav"]/a[text()="Prev"]'

    def namer(self, image_url, page_url):
        filename = util.urlpathsplit(image_url)[-1]
        return filename.rsplit('_', 1)[0]


class IslaAukateColor(ParserScraper):
    url = 'https://overlordcomic.com/archive/color/latest'
    stripUrl = 'https://overlordcomic.com/archive/color/pages/%s'
    firstStripUrl = stripUrl % '001'
    imageSearch = '//div[@id="comicpage"]/img'
    prevSearch = '//nav[@class="comicnav"]/a[text()="Prev"]'

    def namer(self, image_url, page_url):
        # Fix filenames of early comics
        filename = util.urlpathsplit(image_url)[-1]
        if filename[0].isdigit():
            filename = 'Aukate' + filename
        return filename.rsplit('_', 1)[0] + '.' + filename.rsplit('.', 1)[-1]


class ItsWalky(WordPressScraper):
    url = 'http://www.itswalky.com/'
