// File autogenerated with /scripts/generate_tests.py

use uritemplate::UriTemplate;

// Level 1 Examples
#[test]
fn test_level_1() {
    let mut templates = [UriTemplate::new("{var}"), UriTemplate::new("{hello}")];

    for i in 0..templates.len() {
        templates[i].set("hello", "Hello World!");
        templates[i].set("var", "value");
    }

    assert_eq!(templates[0].build(), "value");
    assert_eq!(templates[1].build(), "Hello%20World%21");
}

// Level 2 Examples
#[test]
fn test_level_2() {
    let mut templates = [
        UriTemplate::new("{+var}"),
        UriTemplate::new("{+hello}"),
        UriTemplate::new("{+path}/here"),
        UriTemplate::new("here?ref={+path}"),
    ];

    for i in 0..templates.len() {
        templates[i].set("path", "/foo/bar");
        templates[i].set("hello", "Hello World!");
        templates[i].set("var", "value");
    }

    assert_eq!(templates[0].build(), "value");
    assert_eq!(templates[1].build(), "Hello%20World!");
    assert_eq!(templates[2].build(), "/foo/bar/here");
    assert_eq!(templates[3].build(), "here?ref=/foo/bar");
}

// Level 3 Examples
#[test]
fn test_level_3() {
    let mut templates = [
        UriTemplate::new("map?{x,y}"),
        UriTemplate::new("{x,hello,y}"),
        UriTemplate::new("{+x,hello,y}"),
        UriTemplate::new("{+path,x}/here"),
        UriTemplate::new("{#x,hello,y}"),
        UriTemplate::new("{#path,x}/here"),
        UriTemplate::new("X{.var}"),
        UriTemplate::new("X{.x,y}"),
        UriTemplate::new("{/var}"),
        UriTemplate::new("{/var,x}/here"),
        UriTemplate::new("{;x,y}"),
        UriTemplate::new("{;x,y,empty}"),
        UriTemplate::new("{?x,y}"),
        UriTemplate::new("{?x,y,empty}"),
        UriTemplate::new("?fixed=yes{&x}"),
        UriTemplate::new("{&x,y,empty}"),
    ];

    for i in 0..templates.len() {
        templates[i].set("empty", "");
        templates[i].set("var", "value");
        templates[i].set("y", "768");
        templates[i].set("path", "/foo/bar");
        templates[i].set("hello", "Hello World!");
        templates[i].set("x", "1024");
    }

    assert_eq!(templates[0].build(), "map?1024,768");
    assert_eq!(templates[1].build(), "1024,Hello%20World%21,768");
    assert_eq!(templates[2].build(), "1024,Hello%20World!,768");
    assert_eq!(templates[3].build(), "/foo/bar,1024/here");
    assert_eq!(templates[4].build(), "#1024,Hello%20World!,768");
    assert_eq!(templates[5].build(), "#/foo/bar,1024/here");
    assert_eq!(templates[6].build(), "X.value");
    assert_eq!(templates[7].build(), "X.1024.768");
    assert_eq!(templates[8].build(), "/value");
    assert_eq!(templates[9].build(), "/value/1024/here");
    assert_eq!(templates[10].build(), ";x=1024;y=768");
    assert_eq!(templates[11].build(), ";x=1024;y=768;empty");
    assert_eq!(templates[12].build(), "?x=1024&y=768");
    assert_eq!(templates[13].build(), "?x=1024&y=768&empty=");
    assert_eq!(templates[14].build(), "?fixed=yes&x=1024");
    assert_eq!(templates[15].build(), "&x=1024&y=768&empty=");
}

// Level 4 Examples
#[test]
fn test_level_4() {
    let mut templates = [
        UriTemplate::new("{var:3}"),
        UriTemplate::new("{var:30}"),
        UriTemplate::new("{list}"),
        UriTemplate::new("{list*}"),
        UriTemplate::new("{keys}"),
        UriTemplate::new("{keys*}"),
        UriTemplate::new("{+path:6}/here"),
        UriTemplate::new("{+list}"),
        UriTemplate::new("{+list*}"),
        UriTemplate::new("{+keys}"),
        UriTemplate::new("{+keys*}"),
        UriTemplate::new("{#path:6}/here"),
        UriTemplate::new("{#list}"),
        UriTemplate::new("{#list*}"),
        UriTemplate::new("{#keys}"),
        UriTemplate::new("{#keys*}"),
        UriTemplate::new("X{.var:3}"),
        UriTemplate::new("X{.list}"),
        UriTemplate::new("X{.list*}"),
        UriTemplate::new("X{.keys}"),
        UriTemplate::new("{/var:1,var}"),
        UriTemplate::new("{/list}"),
        UriTemplate::new("{/list*}"),
        UriTemplate::new("{/list*,path:4}"),
        UriTemplate::new("{/keys}"),
        UriTemplate::new("{/keys*}"),
        UriTemplate::new("{;hello:5}"),
        UriTemplate::new("{;list}"),
        UriTemplate::new("{;list*}"),
        UriTemplate::new("{;keys}"),
        UriTemplate::new("{;keys*}"),
        UriTemplate::new("{?var:3}"),
        UriTemplate::new("{?list}"),
        UriTemplate::new("{?list*}"),
        UriTemplate::new("{?keys}"),
        UriTemplate::new("{?keys*}"),
        UriTemplate::new("{&var:3}"),
        UriTemplate::new("{&list}"),
        UriTemplate::new("{&list*}"),
        UriTemplate::new("{&keys}"),
        UriTemplate::new("{&keys*}"),
    ];

    for i in 0..templates.len() {
        templates[i].set("path", "/foo/bar");
        templates[i].set("hello", "Hello World!");
        templates[i].set("var", "value");
        templates[i].set("list", &["red", "green", "blue"] as &[&str]);
        templates[i].set(
            "keys",
            &[("dot", "."), ("semi", ";"), ("comma", ",")] as &[(&str, &str)],
        );
    }

    assert_eq!(templates[0].build(), "val");
    assert_eq!(templates[1].build(), "value");
    assert_eq!(templates[2].build(), "red,green,blue");
    assert_eq!(templates[3].build(), "red,green,blue");
    let template_4_answers = vec![
        "comma,%2C,dot,.,semi,%3B",
        "comma,%2C,semi,%3B,dot,.",
        "dot,.,comma,%2C,semi,%3B",
        "dot,.,semi,%3B,comma,%2C",
        "semi,%3B,comma,%2C,dot,.",
        "semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_4_answers.contains(&templates[4].build().as_ref()));
    let template_5_answers = vec![
        "comma=%2C,dot=.,semi=%3B",
        "comma=%2C,semi=%3B,dot=.",
        "dot=.,comma=%2C,semi=%3B",
        "dot=.,semi=%3B,comma=%2C",
        "semi=%3B,comma=%2C,dot=.",
        "semi=%3B,dot=.,comma=%2C",
    ];
    assert!(template_5_answers.contains(&templates[5].build().as_ref()));
    assert_eq!(templates[6].build(), "/foo/b/here");
    assert_eq!(templates[7].build(), "red,green,blue");
    assert_eq!(templates[8].build(), "red,green,blue");
    let template_9_answers = vec![
        "comma,,,dot,.,semi,;",
        "comma,,,semi,;,dot,.",
        "dot,.,comma,,,semi,;",
        "dot,.,semi,;,comma,,",
        "semi,;,comma,,,dot,.",
        "semi,;,dot,.,comma,,",
    ];
    assert!(template_9_answers.contains(&templates[9].build().as_ref()));
    let template_10_answers = vec![
        "comma=,,dot=.,semi=;",
        "comma=,,semi=;,dot=.",
        "dot=.,comma=,,semi=;",
        "dot=.,semi=;,comma=,",
        "semi=;,comma=,,dot=.",
        "semi=;,dot=.,comma=,",
    ];
    assert!(template_10_answers.contains(&templates[10].build().as_ref()));
    assert_eq!(templates[11].build(), "#/foo/b/here");
    assert_eq!(templates[12].build(), "#red,green,blue");
    assert_eq!(templates[13].build(), "#red,green,blue");
    let template_14_answers = vec![
        "#comma,,,dot,.,semi,;",
        "#comma,,,semi,;,dot,.",
        "#dot,.,comma,,,semi,;",
        "#dot,.,semi,;,comma,,",
        "#semi,;,comma,,,dot,.",
        "#semi,;,dot,.,comma,,",
    ];
    assert!(template_14_answers.contains(&templates[14].build().as_ref()));
    let template_15_answers = vec![
        "#comma=,,dot=.,semi=;",
        "#comma=,,semi=;,dot=.",
        "#dot=.,comma=,,semi=;",
        "#dot=.,semi=;,comma=,",
        "#semi=;,comma=,,dot=.",
        "#semi=;,dot=.,comma=,",
    ];
    assert!(template_15_answers.contains(&templates[15].build().as_ref()));
    assert_eq!(templates[16].build(), "X.val");
    assert_eq!(templates[17].build(), "X.red,green,blue");
    assert_eq!(templates[18].build(), "X.red.green.blue");
    let template_19_answers = vec![
        "X.comma,%2C,dot,.,semi,%3B",
        "X.comma,%2C,semi,%3B,dot,.",
        "X.dot,.,comma,%2C,semi,%3B",
        "X.dot,.,semi,%3B,comma,%2C",
        "X.semi,%3B,comma,%2C,dot,.",
        "X.semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_19_answers.contains(&templates[19].build().as_ref()));
    assert_eq!(templates[20].build(), "/v/value");
    assert_eq!(templates[21].build(), "/red,green,blue");
    assert_eq!(templates[22].build(), "/red/green/blue");
    assert_eq!(templates[23].build(), "/red/green/blue/%2Ffoo");
    let template_24_answers = vec![
        "/comma,%2C,dot,.,semi,%3B",
        "/comma,%2C,semi,%3B,dot,.",
        "/dot,.,comma,%2C,semi,%3B",
        "/dot,.,semi,%3B,comma,%2C",
        "/semi,%3B,comma,%2C,dot,.",
        "/semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_24_answers.contains(&templates[24].build().as_ref()));
    let template_25_answers = vec![
        "/comma=%2C/dot=./semi=%3B",
        "/comma=%2C/semi=%3B/dot=.",
        "/dot=./comma=%2C/semi=%3B",
        "/dot=./semi=%3B/comma=%2C",
        "/semi=%3B/comma=%2C/dot=.",
        "/semi=%3B/dot=./comma=%2C",
    ];
    assert!(template_25_answers.contains(&templates[25].build().as_ref()));
    assert_eq!(templates[26].build(), ";hello=Hello");
    assert_eq!(templates[27].build(), ";list=red,green,blue");
    assert_eq!(templates[28].build(), ";list=red;list=green;list=blue");
    let template_29_answers = vec![
        ";keys=comma,%2C,dot,.,semi,%3B",
        ";keys=comma,%2C,semi,%3B,dot,.",
        ";keys=dot,.,comma,%2C,semi,%3B",
        ";keys=dot,.,semi,%3B,comma,%2C",
        ";keys=semi,%3B,comma,%2C,dot,.",
        ";keys=semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_29_answers.contains(&templates[29].build().as_ref()));
    let template_30_answers = vec![
        ";comma=%2C;dot=.;semi=%3B",
        ";comma=%2C;semi=%3B;dot=.",
        ";dot=.;comma=%2C;semi=%3B",
        ";dot=.;semi=%3B;comma=%2C",
        ";semi=%3B;comma=%2C;dot=.",
        ";semi=%3B;dot=.;comma=%2C",
    ];
    assert!(template_30_answers.contains(&templates[30].build().as_ref()));
    assert_eq!(templates[31].build(), "?var=val");
    assert_eq!(templates[32].build(), "?list=red,green,blue");
    assert_eq!(templates[33].build(), "?list=red&list=green&list=blue");
    let template_34_answers = vec![
        "?keys=comma,%2C,dot,.,semi,%3B",
        "?keys=comma,%2C,semi,%3B,dot,.",
        "?keys=dot,.,comma,%2C,semi,%3B",
        "?keys=dot,.,semi,%3B,comma,%2C",
        "?keys=semi,%3B,comma,%2C,dot,.",
        "?keys=semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_34_answers.contains(&templates[34].build().as_ref()));
    let template_35_answers = vec![
        "?comma=%2C&dot=.&semi=%3B",
        "?comma=%2C&semi=%3B&dot=.",
        "?dot=.&comma=%2C&semi=%3B",
        "?dot=.&semi=%3B&comma=%2C",
        "?semi=%3B&comma=%2C&dot=.",
        "?semi=%3B&dot=.&comma=%2C",
    ];
    assert!(template_35_answers.contains(&templates[35].build().as_ref()));
    assert_eq!(templates[36].build(), "&var=val");
    assert_eq!(templates[37].build(), "&list=red,green,blue");
    assert_eq!(templates[38].build(), "&list=red&list=green&list=blue");
    let template_39_answers = vec![
        "&keys=comma,%2C,dot,.,semi,%3B",
        "&keys=comma,%2C,semi,%3B,dot,.",
        "&keys=dot,.,comma,%2C,semi,%3B",
        "&keys=dot,.,semi,%3B,comma,%2C",
        "&keys=semi,%3B,comma,%2C,dot,.",
        "&keys=semi,%3B,dot,.,comma,%2C",
    ];
    assert!(template_39_answers.contains(&templates[39].build().as_ref()));
    let template_40_answers = vec![
        "&comma=%2C&dot=.&semi=%3B",
        "&comma=%2C&semi=%3B&dot=.",
        "&dot=.&comma=%2C&semi=%3B",
        "&dot=.&semi=%3B&comma=%2C",
        "&semi=%3B&comma=%2C&dot=.",
        "&semi=%3B&dot=.&comma=%2C",
    ];
    assert!(template_40_answers.contains(&templates[40].build().as_ref()));
}
