//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armalertsmanagement

import "time"

// Action to be applied.
type Action struct {
	// REQUIRED; Action that should be applied.
	ActionType *ActionType
}

// GetAction implements the ActionClassification interface for type Action.
func (a *Action) GetAction() *Action { return a }

// ActionStatus - Action status
type ActionStatus struct {
	// Value indicating whether alert is suppressed.
	IsSuppressed *bool
}

// AddActionGroups - Add action groups to alert processing rule.
type AddActionGroups struct {
	// REQUIRED; List of action group Ids to add to alert processing rule.
	ActionGroupIDs []*string

	// REQUIRED; Action that should be applied.
	ActionType *ActionType
}

// GetAction implements the ActionClassification interface for type AddActionGroups.
func (a *AddActionGroups) GetAction() *Action {
	return &Action{
		ActionType: a.ActionType,
	}
}

// Alert - An alert created in alert management service.
type Alert struct {
	// Alert property bag
	Properties *AlertProperties

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// AlertModification - Alert Modification details
type AlertModification struct {
	// Properties of the alert modification item.
	Properties *AlertModificationProperties

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// AlertModificationItem - Alert modification item.
type AlertModificationItem struct {
	// Modification comments
	Comments *string

	// Description of the modification
	Description *string

	// Reason for the modification
	ModificationEvent *AlertModificationEvent

	// Modified date and time
	ModifiedAt *string

	// Modified user details (Principal client name)
	ModifiedBy *string

	// New value
	NewValue *string

	// Old value
	OldValue *string
}

// AlertModificationProperties - Properties of the alert modification item.
type AlertModificationProperties struct {
	// Modification details
	Modifications []*AlertModificationItem

	// READ-ONLY; Unique Id of the alert for which the history is being retrieved
	AlertID *string
}

// AlertProcessingRule - Alert processing rule object containing target scopes, conditions and scheduling logic.
type AlertProcessingRule struct {
	// REQUIRED; Resource location
	Location *string

	// Alert processing rule properties.
	Properties *AlertProcessingRuleProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Alert processing rule system data.
	SystemData *SystemData

	// READ-ONLY; Azure resource type
	Type *string
}

// AlertProcessingRuleProperties - Alert processing rule properties defining scopes, conditions and scheduling logic for alert
// processing rule.
type AlertProcessingRuleProperties struct {
	// REQUIRED; Actions to be applied.
	Actions []ActionClassification

	// REQUIRED; Scopes on which alert processing rule will apply.
	Scopes []*string

	// Conditions on which alerts will be filtered.
	Conditions []*Condition

	// Description of alert processing rule.
	Description *string

	// Indicates if the given alert processing rule is enabled or disabled.
	Enabled *bool

	// Scheduling for alert processing rule.
	Schedule *Schedule
}

// AlertProcessingRulesList - List of alert processing rules.
type AlertProcessingRulesList struct {
	// URL to fetch the next set of alert processing rules.
	NextLink *string

	// List of alert processing rules.
	Value []*AlertProcessingRule
}

// AlertProperties - Alert property bag
type AlertProperties struct {
	// This object contains consistent fields across different monitor services.
	Essentials *Essentials

	// READ-ONLY; Information specific to the monitor service that gives more contextual details about the alert.
	Context any

	// READ-ONLY; Config which would be used for displaying the data in portal.
	EgressConfig any
}

// AlertsList - List the alerts.
type AlertsList struct {
	// URL to fetch the next set of alerts.
	NextLink *string

	// List of alerts
	Value []*Alert
}

// AlertsMetaData - alert meta data information.
type AlertsMetaData struct {
	// alert meta data property bag
	Properties AlertsMetaDataPropertiesClassification
}

// AlertsMetaDataProperties - alert meta data property bag
type AlertsMetaDataProperties struct {
	// REQUIRED; Identification of the information to be retrieved by API call
	MetadataIdentifier *MetadataIdentifier
}

// GetAlertsMetaDataProperties implements the AlertsMetaDataPropertiesClassification interface for type AlertsMetaDataProperties.
func (a *AlertsMetaDataProperties) GetAlertsMetaDataProperties() *AlertsMetaDataProperties { return a }

// AlertsSummary - Summary of alerts based on the input filters and 'groupby' parameters.
type AlertsSummary struct {
	// Group the result set.
	Properties *AlertsSummaryGroup

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// AlertsSummaryGroup - Group the result set.
type AlertsSummaryGroup struct {
	// Name of the field aggregated
	Groupedby *string

	// Total count of the smart groups.
	SmartGroupsCount *int64

	// Total count of the result set.
	Total *int64

	// List of the items
	Values []*AlertsSummaryGroupItem
}

// AlertsSummaryGroupItem - Alerts summary group item
type AlertsSummaryGroupItem struct {
	// Count of the aggregated field
	Count *int64

	// Name of the field aggregated
	Groupedby *string

	// Value of the aggregated field
	Name *string

	// List of the items
	Values []*AlertsSummaryGroupItem
}

// Condition to trigger an alert processing rule.
type Condition struct {
	// Field for a given condition.
	Field *Field

	// Operator for a given condition.
	Operator *Operator

	// List of values to match for a given condition.
	Values []*string
}

// DailyRecurrence - Daily recurrence object.
type DailyRecurrence struct {
	// REQUIRED; Specifies when the recurrence should be applied.
	RecurrenceType *RecurrenceType

	// End time for recurrence.
	EndTime *string

	// Start time for recurrence.
	StartTime *string
}

// GetRecurrence implements the RecurrenceClassification interface for type DailyRecurrence.
func (d *DailyRecurrence) GetRecurrence() *Recurrence {
	return &Recurrence{
		EndTime:        d.EndTime,
		RecurrenceType: d.RecurrenceType,
		StartTime:      d.StartTime,
	}
}

// ErrorResponse - An error response from the service.
type ErrorResponse struct {
	// Details of error response.
	Error *ErrorResponseBody
}

// ErrorResponseAutoGenerated - An error response from the service.
type ErrorResponseAutoGenerated struct {
	// Details of error response.
	Error *ErrorResponseBodyAutoGenerated
}

// ErrorResponseAutoGenerated2 - An error response from the service.
type ErrorResponseAutoGenerated2 struct {
	// Details of error response.
	Error *ErrorResponseBodyAutoGenerated2
}

// ErrorResponseBody - Details of error response.
type ErrorResponseBody struct {
	// Error code, intended to be consumed programmatically.
	Code *string

	// A list of additional details about the error.
	Details []*ErrorResponseBody

	// Description of the error, intended for display in user interface.
	Message *string

	// Target of the particular error, for example name of the property.
	Target *string
}

// ErrorResponseBodyAutoGenerated - Details of error response.
type ErrorResponseBodyAutoGenerated struct {
	// Error code, intended to be consumed programmatically.
	Code *string

	// A list of additional details about the error.
	Details []*ErrorResponseBodyAutoGenerated

	// Description of the error, intended for display in user interface.
	Message *string

	// Target of the particular error, for example name of the property.
	Target *string
}

// ErrorResponseBodyAutoGenerated2 - Details of error response.
type ErrorResponseBodyAutoGenerated2 struct {
	// Error code, intended to be consumed programmatically.
	Code *string

	// A list of additional details about the error.
	Details []*ErrorResponseBodyAutoGenerated2

	// Description of the error, intended for display in user interface.
	Message *string

	// Target of the particular error, for example name of the property.
	Target *string
}

// Essentials - This object contains consistent fields across different monitor services.
type Essentials struct {
	// Action status
	ActionStatus *ActionStatus

	// Alert description.
	Description *string

	// Target ARM resource, on which alert got created.
	TargetResource *string

	// Resource group of target ARM resource, on which alert got created.
	TargetResourceGroup *string

	// Name of the target ARM resource name, on which alert got created.
	TargetResourceName *string

	// Resource type of target ARM resource, on which alert got created.
	TargetResourceType *string

	// READ-ONLY; Rule(monitor) which fired alert instance. Depending on the monitor service, this would be ARM id or name of
	// the rule.
	AlertRule *string

	// READ-ONLY; Alert object state, which can be modified by the user.
	AlertState *AlertState

	// READ-ONLY; Last modification time(ISO-8601 format) of alert instance.
	LastModifiedDateTime *time.Time

	// READ-ONLY; User who last modified the alert, in case of monitor service updates user would be 'system', otherwise name
	// of the user.
	LastModifiedUserName *string

	// READ-ONLY; Condition of the rule at the monitor service. It represents whether the underlying conditions have crossed the
	// defined alert rule thresholds.
	MonitorCondition *MonitorCondition

	// READ-ONLY; Resolved time(ISO-8601 format) of alert instance. This will be updated when monitor service resolves the alert
	// instance because the rule condition is no longer met.
	MonitorConditionResolvedDateTime *time.Time

	// READ-ONLY; Monitor service on which the rule(monitor) is set.
	MonitorService *MonitorService

	// READ-ONLY; Severity of alert Sev0 being highest and Sev4 being lowest.
	Severity *Severity

	// READ-ONLY; The type of signal the alert is based on, which could be metrics, logs or activity logs.
	SignalType *SignalType

	// READ-ONLY; Unique Id of the smart group
	SmartGroupID *string

	// READ-ONLY; Verbose reason describing the reason why this alert instance is added to a smart group
	SmartGroupingReason *string

	// READ-ONLY; Unique Id created by monitor service for each alert instance. This could be used to track the issue at the monitor
	// service, in case of Nagios, Zabbix, SCOM etc.
	SourceCreatedID *string

	// READ-ONLY; Creation time(ISO-8601 format) of alert instance.
	StartDateTime *time.Time
}

// ManagedResource - An azure managed resource object.
type ManagedResource struct {
	// REQUIRED; Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// MonitorServiceDetails - Details of a monitor service
type MonitorServiceDetails struct {
	// Monitor service display name
	DisplayName *string

	// Monitor service name
	Name *string
}

// MonitorServiceList - Monitor service details
type MonitorServiceList struct {
	// REQUIRED; Array of operations
	Data []*MonitorServiceDetails

	// REQUIRED; Identification of the information to be retrieved by API call
	MetadataIdentifier *MetadataIdentifier
}

// GetAlertsMetaDataProperties implements the AlertsMetaDataPropertiesClassification interface for type MonitorServiceList.
func (m *MonitorServiceList) GetAlertsMetaDataProperties() *AlertsMetaDataProperties {
	return &AlertsMetaDataProperties{
		MetadataIdentifier: m.MetadataIdentifier,
	}
}

// MonthlyRecurrence - Monthly recurrence object.
type MonthlyRecurrence struct {
	// REQUIRED; Specifies the values for monthly recurrence pattern.
	DaysOfMonth []*int32

	// REQUIRED; Specifies when the recurrence should be applied.
	RecurrenceType *RecurrenceType

	// End time for recurrence.
	EndTime *string

	// Start time for recurrence.
	StartTime *string
}

// GetRecurrence implements the RecurrenceClassification interface for type MonthlyRecurrence.
func (m *MonthlyRecurrence) GetRecurrence() *Recurrence {
	return &Recurrence{
		EndTime:        m.EndTime,
		RecurrenceType: m.RecurrenceType,
		StartTime:      m.StartTime,
	}
}

// Operation provided by provider
type Operation struct {
	// Properties of the operation
	Display *OperationDisplay

	// Name of the operation
	Name *string

	// Origin of the operation
	Origin *string
}

// OperationDisplay - Properties of the operation
type OperationDisplay struct {
	// Description of the operation
	Description *string

	// Operation name
	Operation *string

	// Provider name
	Provider *string

	// Resource name
	Resource *string
}

// OperationsList - Lists the operations available in the AlertsManagement RP.
type OperationsList struct {
	// REQUIRED; Array of operations
	Value []*Operation

	// URL to fetch the next set of alerts.
	NextLink *string
}

// PatchObject - Data contract for patch.
type PatchObject struct {
	// Properties supported by patch operation.
	Properties *PatchProperties

	// Tags to be updated.
	Tags map[string]*string
}

// PatchProperties - Alert processing rule properties supported by patch.
type PatchProperties struct {
	// Indicates if the given alert processing rule is enabled or disabled.
	Enabled *bool
}

// Recurrence object.
type Recurrence struct {
	// REQUIRED; Specifies when the recurrence should be applied.
	RecurrenceType *RecurrenceType

	// End time for recurrence.
	EndTime *string

	// Start time for recurrence.
	StartTime *string
}

// GetRecurrence implements the RecurrenceClassification interface for type Recurrence.
func (r *Recurrence) GetRecurrence() *Recurrence { return r }

// RemoveAllActionGroups - Indicates if all action groups should be removed.
type RemoveAllActionGroups struct {
	// REQUIRED; Action that should be applied.
	ActionType *ActionType
}

// GetAction implements the ActionClassification interface for type RemoveAllActionGroups.
func (r *RemoveAllActionGroups) GetAction() *Action {
	return &Action{
		ActionType: r.ActionType,
	}
}

// Resource - An azure resource object
type Resource struct {
	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// Schedule - Scheduling configuration for a given alert processing rule.
type Schedule struct {
	// Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
	EffectiveFrom *string

	// Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
	EffectiveUntil *string

	// List of recurrences.
	Recurrences []RecurrenceClassification

	// Scheduling time zone.
	TimeZone *string
}

// SmartGroup - Set of related alerts grouped together smartly by AMS.
type SmartGroup struct {
	// Properties of smart group.
	Properties *SmartGroupProperties

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// SmartGroupAggregatedProperty - Aggregated property of each type
type SmartGroupAggregatedProperty struct {
	// Total number of items of type.
	Count *int64

	// Name of the type.
	Name *string
}

// SmartGroupModification - Alert Modification details
type SmartGroupModification struct {
	// Properties of the smartGroup modification item.
	Properties *SmartGroupModificationProperties

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// SmartGroupModificationItem - smartGroup modification item.
type SmartGroupModificationItem struct {
	// Modification comments
	Comments *string

	// Description of the modification
	Description *string

	// Reason for the modification
	ModificationEvent *SmartGroupModificationEvent

	// Modified date and time
	ModifiedAt *string

	// Modified user details (Principal client name)
	ModifiedBy *string

	// New value
	NewValue *string

	// Old value
	OldValue *string
}

// SmartGroupModificationProperties - Properties of the smartGroup modification item.
type SmartGroupModificationProperties struct {
	// Modification details
	Modifications []*SmartGroupModificationItem

	// URL to fetch the next set of results.
	NextLink *string

	// READ-ONLY; Unique Id of the smartGroup for which the history is being retrieved
	SmartGroupID *string
}

// SmartGroupProperties - Properties of smart group.
type SmartGroupProperties struct {
	// Summary of alertSeverities in the smart group
	AlertSeverities []*SmartGroupAggregatedProperty

	// Summary of alertStates in the smart group
	AlertStates []*SmartGroupAggregatedProperty

	// Total number of alerts in smart group
	AlertsCount *int64

	// Summary of monitorConditions in the smart group
	MonitorConditions []*SmartGroupAggregatedProperty

	// Summary of monitorServices in the smart group
	MonitorServices []*SmartGroupAggregatedProperty

	// The URI to fetch the next page of alerts. Call ListNext() with this URI to fetch the next page alerts.
	NextLink *string

	// Summary of target resource groups in the smart group
	ResourceGroups []*SmartGroupAggregatedProperty

	// Summary of target resource types in the smart group
	ResourceTypes []*SmartGroupAggregatedProperty

	// Summary of target resources in the smart group
	Resources []*SmartGroupAggregatedProperty

	// READ-ONLY; Last updated time of smart group. Date-Time in ISO-8601 format.
	LastModifiedDateTime *time.Time

	// READ-ONLY; Last modified by user name.
	LastModifiedUserName *string

	// READ-ONLY; Severity of smart group is the highest(Sev0 >… > Sev4) severity of all the alerts in the group.
	Severity *Severity

	// READ-ONLY; Smart group state
	SmartGroupState *State

	// READ-ONLY; Creation time of smart group. Date-Time in ISO-8601 format.
	StartDateTime *time.Time
}

// SmartGroupsList - List the alerts.
type SmartGroupsList struct {
	// URL to fetch the next set of alerts.
	NextLink *string

	// List of alerts
	Value []*SmartGroup
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// WeeklyRecurrence - Weekly recurrence object.
type WeeklyRecurrence struct {
	// REQUIRED; Specifies the values for weekly recurrence pattern.
	DaysOfWeek []*DaysOfWeek

	// REQUIRED; Specifies when the recurrence should be applied.
	RecurrenceType *RecurrenceType

	// End time for recurrence.
	EndTime *string

	// Start time for recurrence.
	StartTime *string
}

// GetRecurrence implements the RecurrenceClassification interface for type WeeklyRecurrence.
func (w *WeeklyRecurrence) GetRecurrence() *Recurrence {
	return &Recurrence{
		EndTime:        w.EndTime,
		RecurrenceType: w.RecurrenceType,
		StartTime:      w.StartTime,
	}
}
