// Copyright 2021 Canonical Ltd.
// Licensed under the LGPLv3 with static-linking exception.
// See LICENCE file for details.

// This file is autogenerated with testdata/gentest.go

package drbg_test

import (
	"crypto"
	_ "crypto/sha1"
	_ "crypto/sha256"
	_ "crypto/sha512"

	. "gopkg.in/check.v1"
)

func (s *drbgSuite) testHMAC0_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC0_SHA1_0(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e91b63309e93d1d08e30e8d556906875"),
		nonce:           decodeHexString(c, "f59747c468b0d0da"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b7928f9503a417110788f9d0c2585f8aee6fb73b220a626b3ab9825b7a9facc79723d7e1ba9255e40e65c249b6082a7bc5e3f129d3d8f69b04ed1183419d6c4f2a13b304d2c5743f41c8b0ee73225347"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_1(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d0c57f7dc0308115b1ea30e2ea2f7702"),
		nonce:           decodeHexString(c, "89cebdda617d132c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b797615a78d1afe74ebedb9d8948d82cf2bb586ed80146b96d41a709f689178b772dd342d29af5449694bf8eaf33a664a24c0ad29a12529eeaba478a799917ab4666de1b6eb2c7332017d67eea6fabd8"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_2(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "286e9d9e39e4024dea0c885fd6f7f107"),
		nonce:           decodeHexString(c, "586b6a1a8ac3ac0e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ca25aa9ef286a3cd52d101db01cdf0ce14c7add124f1b6a9a8b3a48c74989baf01f6ff704da7c5d5785b6e9c21914892102313e7a15cb2f9977a513ada0d3f242819aef2c1699b72cbd358c59435101f"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_3(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6b20dda65a96f564fc0253d38dbc290b"),
		nonce:           decodeHexString(c, "813e538d040d8dd9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "66b6ef57a3282838dea05d122ccdfa842dda19333ded2015d381394da38c8309a6e9703ec065335b116efb97daaac9c53ceb7a218ed0db61c3ba969dc629b95f5418eadfa43c58714fb02176bc0b17ec"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_4(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "32339fc82b655051042e3038e3161c4f"),
		nonce:           decodeHexString(c, "b252e495ff396be2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e95e4551a37e338faae4419e3a70e4c1e3d516be7e554cabb00007c591ba7cb6c3247889a9b08e46c6619f166d996e4e34bbf6cd8a354de9964de906041f73f2ade2eb82c6e82627d3257738c2821fcb"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_5(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "deaa9d0c2ca7a05cba12eeb7db24277e"),
		nonce:           decodeHexString(c, "1605e1d030d76ddc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bab5be6001da5951c1e7873f4e2be318e879370eae8a51ed8424ed6f12b2d294b45d006b1c2cd8c1ce047fd16f2fbbc09954a8b464cc986f23e86e1d9398d20780190aa5be0505cdfc826c7a01dcab99"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_6(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "589766be3c03b0a351a81b1203f944e2"),
		nonce:           decodeHexString(c, "928e95f8a3bc7452"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5bee2482667220462ac6d3c234f7333703c5abced2ff2ad91d52193e86a61cfa43be0b4f7e831e1e563e260178f23976b2f3e132356ab54567b37580bf9d751223fad7793f0ac11fc450817536116b1f"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_7(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "07cc4d22b010335045cca142d91494bf"),
		nonce:           decodeHexString(c, "4d5e842af4155d17"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8e13a574d17dc8b44382d3b263e857f50816755917603a07ca4987fd40340042a1e6a82a227647130304d73d8704fd9ad4db3ae42daaa55b1f93948e70c451a12724fed870e02a1a8ec4eeab716c6854"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_8(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6425624a98ab3018eb4ef827f5a4fbba"),
		nonce:           decodeHexString(c, "c1022d70155ef375"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16fd6abb10dba1659ed56d4296b65fe3f2449996bdb8eee5c94b249f04808cdd9563569a4152bd99a32592d35d6a4cc806c228284487fc1e088b178d4c8ecb6b0e3cfaacd7d39d754d8bd4e6662f44a4"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_9(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "01d11d2b631be240de2f41d10bdce47c"),
		nonce:           decodeHexString(c, "89fa32427410cc61"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4640a063e65ef0c0de97f98a39297219e2a1eceed7e6426199719911edbb3d06fbde6fbab83878e9ba9fa8e1d044f7a40f3627d7cfc49d17f101ee64f6b8c6e6154a01b4d39fb9ba6b33ca2c27f9fd52"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_10(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5e0a89b3aba1cf5ed94756083726de8d"),
		nonce:           decodeHexString(c, "b5d79162f73a5031"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cae7b2c25dce1c12e2c4f61b3e53155b9177e92bfb8faefc425d1cbb507713921378ed880986709bfbd7cda66d18dbe0732137a86d47b7e8223e345af0cd9a0219ba290040bc6ff44c1de5b16f32b933"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_11(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3b76d32d5982daf6e2164340941a1707"),
		nonce:           decodeHexString(c, "441bbb99a2668ba4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "63640e406e16b3b82723a6cb3830657b756fe61cf2ada96f667e0f2df0c9d33c6f164ee78d4976281a84d3024ff67074acecd65391a84aafaec9d6b088bc33616543b61a4c603e5a21bd39e2a72401c8"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_12(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "45fcafba2278bf8e6d437396f60f0e84"),
		nonce:           decodeHexString(c, "654de44e0bd6cb8a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7e2325cb2ced372b640c2496a3970cb7771fd494e40ae17239bfffd9ea2ab0ee74c2d3c369328a3b465e67bcbea86f50a32f9ff820505df5adbc032d3adb83581443877f85c60b3b701f59b1fc38c063"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_13(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4201db977ef90d08f017c8e38204c299"),
		nonce:           decodeHexString(c, "5bbb47efe9fa4cad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "101c7318e26693bc11d64b780e9b32d4d958c7475ab99fdd6fe86554dcef54ccdc2ca9f4ec355eb25d7b3f570ff95ec7abc2e9e2fb879bb045debf6c8a98ff46668c0de21bd8d4d18fb9e11550878e32"),
	})
}

func (s *drbgSuite) TestHMAC0_SHA1_14(c *C) {
	s.testHMAC0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5d80883ce24feb3911fdeb8e730f9588"),
		nonce:           decodeHexString(c, "6a63c01478ecd62b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9e351b853091add2047e9ea2da07d41fa4ace03db3d4a43217e802352f1c97382ed7afee5cb2cf5848a93ce0a25a28cdc8e96ccdf14875cb9f845790800d542bac81d0be53376385baa5e7cbe2c3b469"),
	})
}

func (s *drbgSuite) testHMAC2_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC2_SHA1_0(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "49058e6773ed2b7ab309c0949fdf9c9e"),
		nonce:           decodeHexString(c, "a457cb8ec0e7fd01"),
		personalization: decodeHexString(c, "dc477641d89c7fc4a30f1430197dd159"),
		expected:        decodeHexString(c, "4e891f4e281100453b70788929ec743a3c5edd9b81dc798bc93771368c39b612037b6f42f60c5d8924b646848151b0c295be491d4a28d1927deed523fd04d3d2dda95ed42166312e5c3392d22893b0dc"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_1(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4ccc7d83009a28db14e839176774d45d"),
		nonce:           decodeHexString(c, "9345358f336a1622"),
		personalization: decodeHexString(c, "e6db32976d9262b1d3dc487f22e1f5b3"),
		expected:        decodeHexString(c, "5a171e9f0065ece37ba53df81ac3d88054d53d0cb695a901e1a1ca91352420b508c461ac91095ccea81621b800ddcff905020f96dad2a50377d3945047420c3b902e8e361f4525c1d4bfa8af164925d2"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_2(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "fc7d0c3ef1c404ada968dae35581b6cd"),
		nonce:           decodeHexString(c, "31e0a46c39ce49dc"),
		personalization: decodeHexString(c, "14158a65fc9b3bc1ac04c7854493852d"),
		expected:        decodeHexString(c, "918494f47dadda22667dc1d066f44f3ccbb61d3f84b2eeab7d26f4e999aab94e79d282287ab76d4e3eeeef2ef79c2ad571382abdea55d5d8642f604f8f27f3f73a5bc1413dc87bfdf91da1c6045ec223"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_3(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1f0df7933dc99eaf7b284b02ee773ec4"),
		nonce:           decodeHexString(c, "6461fd762c595408"),
		personalization: decodeHexString(c, "abd1d8af4ae46d7e5f1f4e0b71b54edc"),
		expected:        decodeHexString(c, "f1eba7596c6c20118f86017ff86514d745ce7ea02c49719094e5c2a96d3dfa1dd5079b8eff8078ba9793900dba145a260e672837422c351c3f231c201dfaa21e48d3f7ee28bcd08dac680e80bf87ec20"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_4(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "09988a36abad74c3cf377db9c9200baf"),
		nonce:           decodeHexString(c, "6c27be4e21932166"),
		personalization: decodeHexString(c, "17b7a40f4c37894bc948456e37ad482a"),
		expected:        decodeHexString(c, "091e5fb9c6c218f2460c514fa215061460ca90cfb35c1a9f5ea125fc49aa0b2beb42dcb0fed865f8510c3141cd51d1b33216e2e72cebcabd3e1bc0eab201d8e72a0d1de1c2b7915a0cf242708092f211"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_5(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ce1934b6561ebaaa851accf8ceae5b0d"),
		nonce:           decodeHexString(c, "c587922ff68836aa"),
		personalization: decodeHexString(c, "602e9086f44d03ce61039c2e81fed620"),
		expected:        decodeHexString(c, "441da7552b2d45533fc924ea985fd4b0b95942fc7997a37128d3e96d4c2792b241dbe921d61f3898852d4f93740cc3649cb5279a7f0f09be3990e9ee599fb0717c308e7a939a441b5c3ba0cb8aa19647"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_6(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "58f1a9eb935fd08a4c3c894a06ad00ca"),
		nonce:           decodeHexString(c, "0576589700a4d50c"),
		personalization: decodeHexString(c, "b14f2a74cbe3881069f30507919c6870"),
		expected:        decodeHexString(c, "ae9c6b40d951aab9c2d9cb920a05f3e154898c83e392dfbd7ffcbe2283eb2b75842fa5e7bd9626ad12e814874f1966fea1eb817793d2eb0a9cb9270cc9aa4267118fba0c7b6fcf487a97ebcbadc67496"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_7(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0abf2f845295bb1dd283daa24e75fa08"),
		nonce:           decodeHexString(c, "c9e9202793c479b3"),
		personalization: decodeHexString(c, "f8742f44932bae2d65a032ada2b76382"),
		expected:        decodeHexString(c, "8847696e8edd2c7b751b780a6fc69d8434a3144593936943217465362b3c3f7b25b75149f7c69d10ecd169f00ed98b53e0e498af6d9f600441ee2c01a9e74ed845d24cdab4543dff7d1f7800a278671d"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_8(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0f9bc6935e7baf17d560931ec3e75d9f"),
		nonce:           decodeHexString(c, "da7b19214e0ffb9c"),
		personalization: decodeHexString(c, "c13bb26e9349a56866f821c10a2ae28c"),
		expected:        decodeHexString(c, "12a849651f310fbae04c4da4680a21a50a9889806194be470b8b111a32ea741794cbe725d98ae9d40c0d60c04c8b7b32917f9dc18c27dfb8c64579a176a2c4b23cc32e5237fa5f904ab1249aafa7cd88"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_9(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "79d96ff5ec92af9fee0af7effdc15ce5"),
		nonce:           decodeHexString(c, "6b9cbdfbbbe5b49a"),
		personalization: decodeHexString(c, "23d1288ae41e65e56e7b783f85ae8b47"),
		expected:        decodeHexString(c, "206c2564950995ac6ca6d2ad51e9cacd7540f254a335d6d7eed7ef17956949cb5d7d3f4e197e82aa4442d08d1d0f933e641f703be1be4a9ca5747e524687a7a034761493dcf2e1101789f135de5d3f49"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_10(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "94e852ffbff4f20078181221b5fbb804"),
		nonce:           decodeHexString(c, "8f3e95de313a52c1"),
		personalization: decodeHexString(c, "1841dcabae24c156a17a1d0eda6f8bb2"),
		expected:        decodeHexString(c, "15319b06c05d47deeaeab540e649cc6e2989843de07dcaa966d799a36902f72943585e2773912040185ac1efa060c6edecef800e3116c66ccfeeec9fe7ee70f3dae2ac1c0210310ea164f4c4402d2f77"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_11(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "473c743205bb375fad15f537dfeb402d"),
		nonce:           decodeHexString(c, "879754b2b4987cbd"),
		personalization: decodeHexString(c, "4f88f4db50a6806d6899f71981beec49"),
		expected:        decodeHexString(c, "46b0694bc8afc6d86dcb8b80cf8815104007ebedb06050ae625b890060c4dad3d9e2661042d26a3cfded0383829ddcf616ec84d3f32d307480caf0f87ba9b00e88812f5cb2a4e94e354092d0c50b9bc7"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_12(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "20208c9ac4830512786fce7ebde344a8"),
		nonce:           decodeHexString(c, "2cee0d7d7a5607d6"),
		personalization: decodeHexString(c, "2602c5f52c7ee2620486ce56366cc8eb"),
		expected:        decodeHexString(c, "b0bd2c0739ed1608848dd0e9c1db9f547c64268754af09716da40b2682fbc45f56de954cbce0d8a3f53eb2c3afac9e3afeab4038fe042c897786fd3da70f2d6b62b12981630bf30d76dd879e2926ab40"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_13(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3011c31a44ccfd1260ae9e431da41e88"),
		nonce:           decodeHexString(c, "3b1a6ac9060f2fa4"),
		personalization: decodeHexString(c, "6b36a1fcb2a2173fc7e0c120c2627a6f"),
		expected:        decodeHexString(c, "a781d9970c7272e98d941438d311cf7e80d2d56b29eb0b4b1c76d00908401ec5b4bb1c5f159dbf42ab30100933b1628faa92d2e25bd37ead4c3354c823013cd9e331bdf5e2c5c7d11d5bd9f50fd110fc"),
	})
}

func (s *drbgSuite) TestHMAC2_SHA1_14(c *C) {
	s.testHMAC2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ee6d57635e5ab4b3d73a2652c1443b32"),
		nonce:           decodeHexString(c, "296bfe331b6578e6"),
		personalization: decodeHexString(c, "4fccbf2d3c73a8e1e92273a33e648eaa"),
		expected:        decodeHexString(c, "90dc6e1532022a9fe2161604fc79536b4afd9af06ab8adbb77f7490b355d0db3368d102d723a0d0f70d10475f9e99771fb774f7ad0ba7b5fe22a50bfda89e0215a014dc1f1605939590aa783360eb52e"),
	})
}

func (s *drbgSuite) testHMAC4_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC4_SHA1_0(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "60fa9faa3d94146dde1d8a38a5173642"),
		nonce:           decodeHexString(c, "c5bc78e089d37797"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4952f3fac75b96410c1b44d902f7ef49596493754547f32168e4f1115d86b9e0fa4fe328bef656434e72f6c1e19cd8b6b4663423a903ad437fbe8e5636b295d7aea7b3066598e47ac0462a46b20d04ed"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_1(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "30be5f89a4ef4775248cb897c260f289"),
		nonce:           decodeHexString(c, "e44518d129b80fa4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "96b145ab45556c4d682470afa33ca50363f8c2d380e827d871e9a6ef9e9d94e86e49bf6318c9a97d73a205be12dc337b3000f468659ef50120a3a4115a0c117cdfb5701df5be06287a36049fa9d54683"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_2(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b6f8c09d68dd03b86f5ddf8893edd20d"),
		nonce:           decodeHexString(c, "930d5310b6612df5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3675f24bd39baae5dc858bf5084bb768e57be852ab511138383c0a02aca88f8e4fc64a479d913b8c7267e54e3303bb054407b4f25f76ae2b72632af5d21c996b286eeb03ee814b1ba4125e62e5f3f5e0"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_3(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "24edba742c3766e8a0578e950235b843"),
		nonce:           decodeHexString(c, "6ae1244c39d80ec6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "347a45833fe7f4c1efd252c0fc14e3ed1157155d8c740dd2e14037e5aaa6b1689d47eba89ffe6e0bb3f9941f62ac50fda20189fe381230351ac4f59b0828ea09ab3f5d215cec85296dea99d9502b9502"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_4(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "70564c873184a8dd7c7206abf391b61f"),
		nonce:           decodeHexString(c, "e986a1034e3c8d1f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ec4b9a050c7da7ce0718e2ab4c9841b40355f281c1a76d6c0678af8250a8164ff211573673e721a4f76100a695eb5a311d24cfed2a1ca3e773b11b5895a4176542c32b89cf32bff77481c10af961a3ac"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_5(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "64842e7c7e87c7350c9ba5854aa63119"),
		nonce:           decodeHexString(c, "3bfa1412e1022148"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "453745b31b89a58946f9bc07e70fd62e5df72d795239ca303881b7184c015270324d78f3609d92268554d2e0151838bc176705e2a28aa225aa4132fe6601f2a5d4a583e9212164cc4bdd388d057b2bbe"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_6(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eb4b7b585d73140e61b217f99fb875f4"),
		nonce:           decodeHexString(c, "389176e8dea28165"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "14c6cd926596737b2077a5f395ba2ee846499b64477945d3c6c303c8a08de66fb98035499fd6c35a180141a503f20368b4e8900a8f2f2fe14925c1861997ee2c0f4a9c8d38ee065dfe73812aea43356b"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_7(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "72a4289a8ee982fdef0bd7b54664f318"),
		nonce:           decodeHexString(c, "40ea4ac22ab6064b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "94f424038d90c186284df40bf1417c07070b045fd004a629f742019be0be9a1c8b36374acff5459188f26483026d472bbb679446ed2c1b6c5c4c65ecd67e90f3152450732db2e715a74495a2755664f1"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_8(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c3965e33a23b263405b2ed5e568872fc"),
		nonce:           decodeHexString(c, "403d8aa6c3e6ebdc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0631607bd3ba6687b6d8812dd4cb11e063c8ac83728f7e81aaf11e80bf044e05ac9b4f19492e3e02d0b0c15ddb036301b61e7a06b05c690a3892964ee87ea40ba937c7c7f6c5fe56f46e72d51d51c59a"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_9(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c957695bf87d6857d745adc436023945"),
		nonce:           decodeHexString(c, "8ea5c27e4611f76e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7aad79598f035e6b6cd7fcd1e56107d30e28e43dcc310348856c85eedd4aad0b252b6c57caf0301f0e6f56d5bc46b9c138483c0b837f3921deea001b238817fde421e60044f4c1958de1e53b43f6dd21"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_10(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "09fdaec5bb25fe9e1ae8df3f41947d4c"),
		nonce:           decodeHexString(c, "627d75c0d6519876"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "00e5e7791478fe28275b10f72ef3b76ed75f63218794b9838a6b276e9ed41d86363774dfb067980e7b89820905bc5cc4cced95f4b0f9f4ae3ef2ad8d925939d813dc1d461ceed5adc855306288793f5e"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_11(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d2325425101b1174d6d48c37fdd28568"),
		nonce:           decodeHexString(c, "beb06a1a2089717b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "77ecba51d4e396041ffd209739f4fecba7c33ea8ac3637dd8d19b05d59c2ffea67bdeb8d7770f4df1f7944bb7e60bd67a88f559dca42b85de8b451f5aab8bd57af5d42560869ea1ec4e0efb87ae968b9"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_12(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1c381cd09bd8bf1804a831af9fd4890d"),
		nonce:           decodeHexString(c, "ef6b1725ce5c687a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "34394bd281562940d2b00895f3614e5845b682515c203442590c7be350439c0124b3256cd2f3e6248e47e1f12483f79fe0925edb53c250605f75b640e41d6e64767ae31658efd54cef6ac67ec4234b41"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_13(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0bfdac88b626b8195de7b78a602a19b5"),
		nonce:           decodeHexString(c, "e6508fa2eadda030"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "83a8eaa1dd0fadf4bbe3e3a95a35d00dd7e7873c1853cee64ddec2c24ecb3b67ec1f0d179193ad11e9993807fe5057423fdd8b5bb1a076506cbba573c981cbbfad3c3e644624cc80534926577fb2b2e6"),
	})
}

func (s *drbgSuite) TestHMAC4_SHA1_14(c *C) {
	s.testHMAC4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f41d60edb7749acb68111045000ccef2"),
		nonce:           decodeHexString(c, "bb5fb8962ca3002f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "262821119be1ee0bceedc1bcfd04f7fa2e199b2a7522c4a3a98c4174e0ac4ddcf7323dee2fcf9fbd2fe26c4fad347f7199be105730441f042865aeef50b89c00aa661361b6a1f20849bc7c70aa294543"),
	})
}

func (s *drbgSuite) testHMAC6_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC6_SHA1_0(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ccd5c563cf7a63377a50c1613c916f0a"),
		nonce:           decodeHexString(c, "4a10bc36ae0dc7a1"),
		personalization: decodeHexString(c, "4dffb8b3662deb1ce7615badaa31db29"),
		expected:        decodeHexString(c, "cc2e9782fe2b2fbc869014032ac90984406cf8a90d51c8a540bd5fea0a7b87fb1f74e309e6012f81314736a9a284e740fd7d95540967b7c8b3c00db08e224bf49166f0c7855aa66a4c37f008ec85f556"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_1(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "29c3ecf108e961484ff8d70ac31727ff"),
		nonce:           decodeHexString(c, "cb6d67c43fefa178"),
		personalization: decodeHexString(c, "ef3de896e861a90665dab631a28d2660"),
		expected:        decodeHexString(c, "7b7306d5fc8dc8b99d51546d22a09346bfa273969db066a2c9a249d8a9ee1d6a5af7b65267eaa12b297882b10b4b74ca41cfcefb89bc727663df339e7c8509e7f330b96711b5e063ff06efeb6b3bd976"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_2(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1ac8ad13adde0db4639730bc990be05a"),
		nonce:           decodeHexString(c, "0cfbd5fe2b072303"),
		personalization: decodeHexString(c, "77a689c50945a03e809c942dc8260226"),
		expected:        decodeHexString(c, "3ac0bc009b7390a25a42cae20d931996324a02158ee7923c81d411ee086b799d023b4269d5e773284fcc88408c9a6e41e977f610f8f405d919613fa617bd04048eb8c0ac1663ba9eed9b5590b084110b"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_3(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f50f07ddccffd7db928183a88a3e6faf"),
		nonce:           decodeHexString(c, "bf3a5c486a87c89e"),
		personalization: decodeHexString(c, "58bd67add7fa081c3034c1d6e05af8ce"),
		expected:        decodeHexString(c, "76eabf6d4cde433854233cd2600b5dfabf34871d71c2c25582792170545613f53d8c5c0ac6859c7470431e2599139f902ef66ca09b017573e9fe71311e65eceebd705bdd1f04395062d9bf9a30876bfa"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_4(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "85548c8caa37dad152905b18d541ce6c"),
		nonce:           decodeHexString(c, "8b9537a556c8e31a"),
		personalization: decodeHexString(c, "a91111a11d81ffa5eb07de47456b5a25"),
		expected:        decodeHexString(c, "c77d8471e030334cea1c4f5efe314e7d354bace881b84147face9c60bcf0fef7f056a9aadc2692ec03d1c8c70b00d20b4044d19706869c212bd1e47db69ad1c4c27c525df0aa13ce4c6ad7853ceca104"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_5(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "43b7c1ddb10a2d1fb9c564be23be474a"),
		nonce:           decodeHexString(c, "fddb39943d1cb8a3"),
		personalization: decodeHexString(c, "36e732d9437557cf4bc2910492b7a17d"),
		expected:        decodeHexString(c, "e5576e48fd1cec1257068eb41b1f1a42efa21caa25d90526f553fadb28d65fb92215d2ccc3dec5be675730c92872d5a82e80ea76662c7dbbf52561c449aadd0e485f8e30cd0c3e5cc7bf857c75cc1236"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_6(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "94d3fa379fb01b342669fdfbff7831b1"),
		nonce:           decodeHexString(c, "af1310b01e6ba647"),
		personalization: decodeHexString(c, "203ba869bd4b3166887cb38e845e8003"),
		expected:        decodeHexString(c, "a46908d8fa56d12ff54531aea8cf011edfe567d90c396b40c8001b19b6a2e28055becdc8e6b89fb084f01d147285c3d7d1677d0f65ba1fd8c06ebc4b69c6456e16d13a9394ff166ca8f113b0d35bb94a"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_7(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "614ebbd4af2300f8ba40a525d5239165"),
		nonce:           decodeHexString(c, "0f1e54196c7d8e23"),
		personalization: decodeHexString(c, "2906741ed4d07ac73fb85e474e7da600"),
		expected:        decodeHexString(c, "cf472147a08866ba54c5291ae637a00dcadf484efa53142175caf67d476cbbfb29cfb096a34fffeaa4a69ef0fbfcbcdd0124989df4ccc4d4fe0d501f4cd91da531c49ef3f9b97cc4f5c30b6be3288bee"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_8(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8af695ef704e1cd1faa552d345e76e52"),
		nonce:           decodeHexString(c, "a304311bcabceaea"),
		personalization: decodeHexString(c, "94ad0cd4d4f60e42edfe7d0eb499208c"),
		expected:        decodeHexString(c, "edc832cbe218a1aba14aca5aa9a659367c94e5f8c98840eb1b713a683df9dcb8657751c73ca6091c482febb05c964d5079f1ea3b719da1dfc4c971200181e64e7b7e122514f23d7e9c1f8739fb992008"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_9(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2836f6474ec4d0e1ea15be3a60d6ce13"),
		nonce:           decodeHexString(c, "544da2336ab1453a"),
		personalization: decodeHexString(c, "334d9ac9dd4490a8e766baf167d12966"),
		expected:        decodeHexString(c, "66d0950b03741760622af56924e529298454e7b22d8d3a6b09d23e5e49380304c97e5ba4484b1bf8d49d58766594a5af997eed57b050e49d48a3d92f6b00027700bf2d198b4565c7b0c0cdbb376315bd"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_10(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b7fe628056bf891304a628c6dbfd5c1b"),
		nonce:           decodeHexString(c, "cb435893f644c63d"),
		personalization: decodeHexString(c, "b53b230221acb4ef9383bce5974649e8"),
		expected:        decodeHexString(c, "9b6a546349510864bee318e3b6d37a4164fd83f8eafc76048a94c65509360f22e4629bf916fca047bf6395fb6a8fa3c0ede74d5180d4942c83bffdfedacce46f3a0e12cc3ee8f7b36511cb5f1da6f035"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_11(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0a37c75bc808a90bc6b358b1df6be5ae"),
		nonce:           decodeHexString(c, "52bf5df812897d1f"),
		personalization: decodeHexString(c, "e43daccecb6c15f011c51cf293912994"),
		expected:        decodeHexString(c, "3ff419c6d50891bfc44c2f8e00532cfa74234d0427ea5537c4a1622b290a74f1c3170730bbe8f358cfb237e7dd50c03747ca9c56c6ac503fea6acf6338078d301397128e3d27839cc0f7054393144ae5"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_12(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9149a3fdb043cf4a58a0a6682cd0211a"),
		nonce:           decodeHexString(c, "6c6a87fd2a0873f4"),
		personalization: decodeHexString(c, "19c0436e4318e74789800fd985b8c096"),
		expected:        decodeHexString(c, "f01392ed90222a4beea745b0aae255bf78eaa226ff0a6c276bd835abd1d397680074e0035bef3667225ab22517381d38830b47337ee9ddf843481bfc867ef44df4e3c152eee85dd0f6377e451b513536"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_13(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a3e40c12c6eb6cf0f8b93dd45f02dd07"),
		nonce:           decodeHexString(c, "c697c1c060c90bf2"),
		personalization: decodeHexString(c, "1cf43d5e6cb74b0e5d70f9377eb4ea03"),
		expected:        decodeHexString(c, "cc002d549d5813efc10d16d3132fb5b394bea03109c9f11ab01a3178dc3350d9e1e9896846db60007ffdaa3ad530089fe4bee9380b807a19adf594466723ac98dcb540986ec6307f2b0b37d79366d0f4"),
	})
}

func (s *drbgSuite) TestHMAC6_SHA1_14(c *C) {
	s.testHMAC6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "cb89ced16e360d7a417f4c165cfe3e1f"),
		nonce:           decodeHexString(c, "3c9434b7d7e18472"),
		personalization: decodeHexString(c, "55bfc33da17f712877829b7f8a134e55"),
		expected:        decodeHexString(c, "705950e4790ada95b99ace57e31115610ebc65d755fe587eae8fb1aeae463bea8b50a278f45e61d3433272ec31b0d48afcf219f5f4a0adb20537be9c7cb65911df28976aed4b4278cc524639a1ca5f40"),
	})
}

func (s *drbgSuite) testHMAC8_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC8_SHA1_0(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bfa766e525d824db96ca32b4fe92d793"),
		nonce:           decodeHexString(c, "9a72e7b810b29762"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cdc76a2e0242f5618c69335e7a7cb82b3fbac60cbb8c76eb9d8ede01105a5a507aa13bd23454dd5faab287dbc1a7edc0162983936d8532e0131a1e80f59e3dfeaf75e6c28e8d049c95a3974047382b3f"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_1(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "92ce11514fbab1cc4ef748469ba3f6c9"),
		nonce:           decodeHexString(c, "3cc37ae299c2bf9b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "05e19153e1b8aa4c032abb176226c7b8d6f7638ca120dd755300d2fbc0c48a980c076f9f9c00224aa0b4d7a271c88cfab9a41e6a57afb2abe58d97ff7b229a7c4bdb4dc00bee87377742ecd508e40ee1"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_2(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7fa77653474a847f037422577f9682b9"),
		nonce:           decodeHexString(c, "41e1eba1cc019344"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "514a71380a77d4ecc664fefd584c70fb69e5873dcbd8f198f2aeedf0c80c85dd1bae49b2a2bef1d5e80458b2f26711f1bcf627363560b59ec848898c94060c829c3f3d8073cb73988d769899368f187c"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_3(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "09fcba90dd5d55421963620faf9f0c91"),
		nonce:           decodeHexString(c, "7b1a05f1e9ce9079"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "76c29f559fc06c3b924441a45e195c6a217151f21b809de36801e260e0c4be3f6ed45e7315ad7526cbead47b70274f5dce9ffae78a8fb535409820c58e89d8d83ce562d0c970bfb15f680f357986a286"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_4(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "218d7cbc38ade0cd245ed1d2a3c634a6"),
		nonce:           decodeHexString(c, "23d8d1ee77fb2a64"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2648b3639e9131f0b57a7bd8087d7d08cd7769c607be1940fbe99929124ef2721794b18212a5e5c2a4b8b3421e091b0a845f5b5752d668510ac2596b7c93a91f382f94a747a4e1d71bf7b3f3a3986e78"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_5(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e39498bfa4d98ca9b22b698aa1f63ddf"),
		nonce:           decodeHexString(c, "6476ff7308958104"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5ebb29a28822c2e7c7dffade16560af4be4b0138864a9d3f73b0833e10773c0c86d7e44166db49ec5d2ede42cb875990d5d7b4430dfc6df7a7bb4506b6e73446a14bc60dc6b19b51f73314eb08b000dc"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_6(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "acba480a9559ff9c61cb9ec7e8abb6e8"),
		nonce:           decodeHexString(c, "7fd83151ed1d2373"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "58b6519828e5668ea7b874429c1e54b261069f3e5674bf61a99c36fe088c7fc9447bd9775d5434dd75daa8066f0c621dcbf043a05e2774d377e31606ae982fce03d81a20969e71a16568bfbee0116e54"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_7(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6a1496d59769fd65bb498278d3baac6c"),
		nonce:           decodeHexString(c, "8de8ead8cedadbda"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c88e74a0177a5393e216980fe5d89350af0ec099a78543f30fef40a22d843cd0c3f1399c15231129bc2fdf27fb82ac4743ca8631161a886bb8f15b5f5183ed73956f29ef5a3151c14ed0b5d281b2d345"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_8(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "68ac7cd82f0c42f2759b646350891457"),
		nonce:           decodeHexString(c, "e17540c06311ea2c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "27302d645b6b4318e8f739b397b9acbeabdbc01bc68382972529ace95a27bd848e51286cf8fc87cff57280cbbe20584962d2bd757ccf60145c72f0de932c68277b7907a56f67b399c93a65f4780f6553"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_9(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2f14d50ac42f37fefa881d6f34c09175"),
		nonce:           decodeHexString(c, "ec7bf5fba3c94496"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ca9da0d8ba870c599ddadb8083d3ca7d13cc4567a997321b85d97a32c13c248c520a27cf01999050a4cfd7410f9948fbdfc9d588b2c864690e4ee0820f7dd9ac558702578f7d39ea059a7840fcd8cd27"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_10(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ec842160e9877dff8448a25fd19a8e00"),
		nonce:           decodeHexString(c, "5d46b4fc7108d5a1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dda69460e6ee719256562b53c9d2301b41245452dc27994b6455a1ad10e3e712d0f689b858fcd832910dc27accbbc5a5d5c0219c3fa265aaa1139815d5b4a75f2852e74c75c7d6b75b60a459902ed003"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_11(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eee3c4cb2459c382680e40a6135d4564"),
		nonce:           decodeHexString(c, "7fbdf557e97030e7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a64d31283b8db2abaadf7870f83177d8dc638da08b640f7f3b8faa134942d3d6001647a202a25c55289fbf68fea9f5b57e32da221e580ea5f3b2ac60114640de1ee4523bfc6457cbf271f9c55c0fffc"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_12(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "84ff66d74434cab61f40a73ce992cd88"),
		nonce:           decodeHexString(c, "64c3e72ab8e677ec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9fc91387318f67c9687e31050eff3bf0518df31b2315f682d47771a93608db74c8c567f2a8da7e2fc06e00b8a1cd2b89d1592fb29a4925e63828e6d22acf5a36587d50d02593bd8431026684ded816c0"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_13(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "78725941aad0cad65da5d0b7dc9057a0"),
		nonce:           decodeHexString(c, "577147770612020e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f9ce02ce66fe9f370e97eed7d86b01e0701d1b9ff21531f0f899dac067ff48c6d6d11790c2b0e6c6e8d3c993564a09b05a7f135751f11d72452238868db2f7c08c170ef7b918911556e13f5405bb9969"),
	})
}

func (s *drbgSuite) TestHMAC8_SHA1_14(c *C) {
	s.testHMAC8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5b6aaaf5c4e5acdacd2c0c14648eeb3f"),
		nonce:           decodeHexString(c, "353cc1174da7f766"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f7664dd99fb870dad1a45a4ddb870c9936fb42b3a063336e447f15703c5a95dd79eacd9f41cd0c1b4f2e1a45229aca140f463c1beab47aa0525e5bd6e1accf360bc8525430ba05fd14d1f008009fd586"),
	})
}

func (s *drbgSuite) testHMAC10_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC10_SHA1_0(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "042c8e1c6782d8f73d009068a75ab2e9"),
		nonce:           decodeHexString(c, "677b47c76e4fcb87"),
		personalization: decodeHexString(c, "14ed0ba096a31c15d23e4960989d188f"),
		expected:        decodeHexString(c, "9e1aa2125ec8f2198d5125fc84ddcf2aae63bd5f2b82d1d04e8e38068519fa15f711424e1597f4d3fd5d883539eb38b2df9d2404f5c4c2b2cd7161fc6b16661857fcbf7f495282cd3eefb733a3428f63"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_1(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "012e549615f628bdaff1accf34e67aa5"),
		nonce:           decodeHexString(c, "4ec7216881e013d4"),
		personalization: decodeHexString(c, "1917cec767e585d21f2c87fb8ecf8998"),
		expected:        decodeHexString(c, "0ef48d6825eb2eb7b5cf2fd27d04e75876e57989dd590a9670e96d53436f07e5ed6b3ff31b0c2855cfee5e633536cce00fb1d58213225ec604f1e6337ea50b7fd830c5c219ac6195683fca437f8c360d"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_2(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f6182e3bd5af9db1168c1169065c2e9c"),
		nonce:           decodeHexString(c, "c7d77e5617ea216b"),
		personalization: decodeHexString(c, "cb4c573b948f9c42bd159510850f3c0e"),
		expected:        decodeHexString(c, "2c0c8451b2906a4645d8fbd5e5d114eb6a8648881fd6e6283fbeea07f8adeaaee0be053f25e4c8611039b47d2243fd515f22341fd5b9a32f7eae4c93617b958dc52cff027b8e6571a9c77b3fc6e3d38a"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_3(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c53c031d335047819ba2d91848cedc2e"),
		nonce:           decodeHexString(c, "68a91905d2eaf2f7"),
		personalization: decodeHexString(c, "c1651f5931d0b1f0ef1a6a5247d6a7e7"),
		expected:        decodeHexString(c, "ba234a775d77b5eab1f86b34b24e12519e3021e6c4aa0660d09ed78c18969d90d148d073014ec162bfa3c4c2f1ae44ed3259b5d21f962accb659b9811650bde00d6ae213849ab38745e7457df3e41827"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_4(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "92d5f92b4d7ed319175b898bf7265ce4"),
		nonce:           decodeHexString(c, "02ba3243ea8ccf33"),
		personalization: decodeHexString(c, "a7ea09d20435fb095bea129439891737"),
		expected:        decodeHexString(c, "3f9e757dbf6fcd15ade10a025d39b5cbd95d0d95ad4ff83a771f3d1c5ced8e7c9b878d0a0ee7b7e4083a2c20af93eec52914ecbfbad346676717719bbbaeadbc9e7b546994c39eb365de83ce6a08bb4d"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_5(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b26878d986cb7a9a24ad23e114c23796"),
		nonce:           decodeHexString(c, "2c0736af4cc7a493"),
		personalization: decodeHexString(c, "c4b853b830723cc305bdccdc54c52b33"),
		expected:        decodeHexString(c, "39d24e7112a6d61e9c8bee3e81114d6562ef1253069a7f5f395f57230ca243a9cab966c0429d8ef9aaaf42ad99f7f1eed705ff0938c7c9bced04398d04518e387820b059995f23b1f0021240e3ad37f5"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_6(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1eb80342278e65a93bbab11e9ce4f335"),
		nonce:           decodeHexString(c, "8c1ad3cba58ee175"),
		personalization: decodeHexString(c, "68b626801dc8e98beb6fadf1bfb5e21b"),
		expected:        decodeHexString(c, "7d1eff0e42435bbfb69924231bd839eff608ca112079726ed280eb0760b05574a0962a9dc08937fd3cb6348a171022b1bb5f6ff0d1899ffd5b41d7d802eca0f5ab338b51ba23b63030568d9231861709"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_7(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "97d536a5b1473c0095e7bdca428cbcad"),
		nonce:           decodeHexString(c, "0429afa5f99a14ae"),
		personalization: decodeHexString(c, "5a5178b8b767570857f8ed35ddd54d1b"),
		expected:        decodeHexString(c, "9a5361931a1d6f327c47fc47320dbc21b0ddb149630877e2e190853c7bc61893152995225f3ea86bdd5be605a96d029f496575f08aa5fa6ca8348f0718253ecdbb689a779d3f16bbfeddb97c6419b615"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_8(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1215644d686cba97f1be48493cd18a14"),
		nonce:           decodeHexString(c, "ffc386c7b611ec22"),
		personalization: decodeHexString(c, "cdd3a57725dba43d8ccc2c0bef1d4d99"),
		expected:        decodeHexString(c, "ec30fd9087521b3e890a212329a5a85570e0723c352c16239fec39877393211a4ab913f76eb9f03178717e40b0f3f7cc6fc8da291d62ab4d9152992bc32949df0280874d455d47d257ee62aaaaf5f7e9"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_9(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "178bdeda669c11953434cae40f74a3b6"),
		nonce:           decodeHexString(c, "f6c34238fe691384"),
		personalization: decodeHexString(c, "f3da7f228d4a8ac7183a68e81f8aca53"),
		expected:        decodeHexString(c, "278e1015773790d2aa42b2c4ecc19ddfade99816e48b661b1ae74719817fdd24a21149494a5c2b3aea02c71b7f124184579efcbfee678b83afe5d7feedaf4612e26ce646730fd0828260a261787674c6"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_10(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7fee0519cda3f1893a6e6ec597d5245d"),
		nonce:           decodeHexString(c, "3e40b0ac46e758ca"),
		personalization: decodeHexString(c, "69f3db79a89e62370e583282a6dce5c1"),
		expected:        decodeHexString(c, "1478ec02c5b50f2d26260f00e01996208a1b92e19e7df9cbe265436344ffef4dc1a5390256d0e995b49cb16f2b6050b6d72b3744f98465ef277b2e1062d0c91636e5d3f4fa1cd872e18948926eb090cb"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_11(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "22582e33b126817172f564c942218e69"),
		nonce:           decodeHexString(c, "9541c0c884d445db"),
		personalization: decodeHexString(c, "8a9161291feca7b619dda96f1f95d1d4"),
		expected:        decodeHexString(c, "1d3047675d69bf0f4ce0edc6973c5026ae079fc4476767d230ee5ba70eb1e35f0d75587d994c3a2be9c8d4116fa0051b70eb16342831838d0e4607db0ddb41341488462e5661dfedad87c99bf71cf1ae"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_12(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ca085646c0a62e89b7234efd1bf44218"),
		nonce:           decodeHexString(c, "05d59e3c6db4078d"),
		personalization: decodeHexString(c, "1c5658b01974a5a7257f827244739636"),
		expected:        decodeHexString(c, "65daa28df559584a0e93486abd9252b6da3377a4a664e940e3f8c425ea5a3f6587db7a208e388e2ea39f8a82b0876e517d0a3b46156b70090cec0499fc9fe67ddf3787d2bbf038ad73edf135a6976322"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_13(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1c98e8206b14aba60d99e1c50f59385f"),
		nonce:           decodeHexString(c, "3bbf085009fee036"),
		personalization: decodeHexString(c, "39fc2e475db746dd67c15ccb522fb842"),
		expected:        decodeHexString(c, "9830a027cae50a265d8a7ce4d155be3bf12b828bcb594af7de85f7094f17c21494bd15e51e3d0b498c3ef4f8c4713f9c2feed42b1da4b9d08d1030a8cde51c3c7b90ae0e53023537b1adb8dc7481bcb8"),
	})
}

func (s *drbgSuite) TestHMAC10_SHA1_14(c *C) {
	s.testHMAC10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a6608d593372e785fa76a572b9621e42"),
		nonce:           decodeHexString(c, "9bee7502db25ae7f"),
		personalization: decodeHexString(c, "d0e8fa47aed6b67ca4e8e521f733921c"),
		expected:        decodeHexString(c, "3c649d295fd9b98082706f3f841f5275834143698c202da4c881c7d0a3c9995329a54d440fc4d21ab596e95e5b6651c6e7138b332c97ef771bc6e3b0b3fa09090ffb402ed1116d8395e5f1cfea3eae6b"),
	})
}

func (s *drbgSuite) testHMAC12_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC12_SHA1_0(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5ec7bd88120cb0ad77244b19274dacfb"),
		nonce:           decodeHexString(c, "c7a50a3d59ec51c8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b4f1bf1cc25784b7108e0a7062988baa39f5906e145f6035295fc29f574777de196a42091523832157830d88f89685b630e4fa187040d5a472b0a16ce1cbc41e753fd1d28c37036e065bf9051d6d0862"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_1(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c163707712457ca60c65b9e5618fec7c"),
		nonce:           decodeHexString(c, "5fb5b84a82ffeb63"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6df04dfe768cb4dcc29309b05041da2c6c141c22942c7884f2d900967d015a7873319e61e2ded42ee9df2607e13c0e9840322b8454cd9da874d1fe6c258b810adf83cdb7512d1f5642d5d992945b5259"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_2(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "88a5ef064182cc40df5a3b6d8bb34376"),
		nonce:           decodeHexString(c, "16900a58a910730f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3e44cdfb6d20d910463ef5df4f050fa91bd5c7a6a886650729978e9bf484a4bf7f2697109bbb78445cd4257b320aba2f26223906190282a4229c8631effe42dd2b2083a7b097e36a57aa0880431440fb"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_3(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "64ea885ed16a502511881beeceac0f2e"),
		nonce:           decodeHexString(c, "25a0cac3cf54d3cb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ad4cf605dad01c13cb54e0cd20e307d6941620a580d98ea653b60a8ba2dc2c11f000b52da5987030aaeaf6bf880f4ddf4fc73d6daba8751869148b72948db9a56122d9c76da9bee8b35e2dae2f6ad8f7"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_4(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2bb7251b9c609d7778a97a69ba2c5116"),
		nonce:           decodeHexString(c, "9bb22a4476821c70"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "80acba419686dcbcb80137c38ac2239487561a53d0e7b0a820514caaf2705d3306477b2627d54519f18dcdb53b807194b69ef4fd728a498114f44860465ce53bb428fbe0180c7faadc5f53bd195d549c"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_5(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "fc6fc4bed4600bfa12108d5b4c29e50c"),
		nonce:           decodeHexString(c, "d63a38c3d75afdc1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "88b2c0d43eb53965943f90819510fe9f72c8865faab25500492f21dd74b28eb68b12227445f4d57c3b1f64538c4dc9f71c9da5d06457e4f932b2a1fe1b4176b4884cfd1512d2707d538790495eccd509"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_6(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7028dd8a558b2e8ef1b31a99c7cbd922"),
		nonce:           decodeHexString(c, "41673e6aed43790e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c161310c687f23259d521ff1c8dcfb58ed5c219e2fb97708f627ca06d56eae38f6da079280accbe9b758917b8e064a2169884b1c106da6b5204baf819587ff63de1b14ff0b6e8a67e7bf074eb7c98b1f"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_7(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5256b720d1aaa7006ed9777bf748bebf"),
		nonce:           decodeHexString(c, "c396a5da5d3efb97"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "08cf26b11f0bd8fe27887a661a3f258ac963e83e4353a500529b89ea630b9a27bf54bc3ffb1f70a5c9d407e9ff1d708c96f52e56cf5c55521862d76357550d83f0fd529cfafeeb140d4108bf4395fc85"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_8(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "fea8ce85ec3d016e529f6fa8c9fc9aa2"),
		nonce:           decodeHexString(c, "eebb74bd7352eba1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "51bb34c212fd748795cacd926559ea4531aa97084246d74fafdde8055c360df20c8f45907afcc34e637702810201bc441071e707baa90f28a342ee9f6291497df6a1fff88b93794785b00bb4678da9f0"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_9(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eed4b9a341c4f1b234e30160ad692ddd"),
		nonce:           decodeHexString(c, "136ee68226c4acdb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cd4dd8da7b9218a7076e9cba47f3752eaba8b0ed168142c565e25bd30669a90e2e9e7b5dc7c398df147edd6f34fdd9a1b53de1538c01f4a81472bac8c0748d5a96ae3d9b3859ec8a0ab3ee9f07f57243"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_10(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f7480c8ec4a24aa42bc1b5842895262f"),
		nonce:           decodeHexString(c, "85dd29845e457646"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c0210b77f76c309c0963f62beda4e161bba95689b22be0517b2335ed71b5b9170cd1ae7ffb33494ca222a422dd4b0dc933fb379ca270e42bc362119fb262f4c116cc49fb91cd9dfa094f487bd8f19f5e"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_11(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d6eab3988d4dede3b15a7efe0525be38"),
		nonce:           decodeHexString(c, "3f80483a12d206ff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "315380dec9c6fe0f1c777e85ebd265db19227b3b34351eec0e72cd85bd631c72ae3a22cfa973fec74c67af5bbfbe7ac60d7fa219bb91c1fa627edc9682ec30c10d5f8c1be460f6b974d53939d3762a89"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_12(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bb334043d219c0dca576c41732c170dc"),
		nonce:           decodeHexString(c, "c8950b84272fc33e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "afd8e538ffe6b892b595da45cdffe799835a1bde1117fd17a9c7194880f1aae8fafcea80a49ea72ac8b2600430fd2c896c214762b04aa3e329812aa7a9cd19f2bf7d8b6c3df022117c4b8f13c9240e01"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_13(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "67c3f334ab77b6cb276861c01da995c6"),
		nonce:           decodeHexString(c, "0f7105d28757f1cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c8f8a34ab2b49e102cfd88675cc1609d305e0db5eb3dd9e31fe4401b3d3862d7c6c26ccedfa94c5a396e1e135f449d2cbba19b0ffb3dadbf1714c665e05cfb68901eaa67f37b5e27d95eac0e4cbf3e84"),
	})
}

func (s *drbgSuite) TestHMAC12_SHA1_14(c *C) {
	s.testHMAC12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1c3fc8de26ddc78651c9c2e4ba874ee0"),
		nonce:           decodeHexString(c, "ca6a2d3cc5495dd0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d00ff8d3b8ca273cf7c3650e36c892018c0f765da45ab5b902c5accb30ffe01a99d3b86752195dc9aa1232fc852790ef51860fd114bdc78ae02acb5ab2021ec726829591d623b0b66329e641c1f915ce"),
	})
}

func (s *drbgSuite) testHMAC14_SHA1(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMAC14_SHA1_0(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5e49a74886345e9b117f9614bbe51834"),
		nonce:           decodeHexString(c, "0f426b79ea3c7495"),
		personalization: decodeHexString(c, "67d609de0b54fa9a92f9251d9726948a"),
		expected:        decodeHexString(c, "b63513680a45c0dffee048e0b848cf974d5f761e5ee6703ea56eaca8bd301c6c293eb294248bbb1ce4c9b38e91afb76a72497bcd7699f700688f28ccccca4c9be0dddffa0037b8545864b8ac3d783b29"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_1(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6b1f7e4651cc692dadd3551f387ec5b2"),
		nonce:           decodeHexString(c, "98ab6ae4378c2de9"),
		personalization: decodeHexString(c, "d2265947f751952cbf7b2ec548466cf7"),
		expected:        decodeHexString(c, "24b722f9fcf5b86068898550886505b7b5997f6add8418e9e2d53f79f9f5f2d1ae590119b26f5aa60b4f27450fd0d355819a13f8d3db3385d9487e37f52b65e4cd77efd1c00d4a5a07660681737c685c"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_2(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "50ea9be56fdba8e1eb1a231e937494f5"),
		nonce:           decodeHexString(c, "e49c8d0e27102d0b"),
		personalization: decodeHexString(c, "35e02c00f76e70db54c62d9e59695640"),
		expected:        decodeHexString(c, "887e40a6535a39ecfd43232b0fa1654c10996dc2c68a90e5a5e7f4c064e253ce22bc4a0674b27e58f233bc3268381185702b64c35b9fd946461d4e630322f15c15751cd3be2e11d617cc4c374dd4cfec"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_3(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "24cb5ab8b0ef45cfd12a47689f547bce"),
		nonce:           decodeHexString(c, "a27c36776e84f9b3"),
		personalization: decodeHexString(c, "12067dfc22ca9fd7a417bb7b1ce74bac"),
		expected:        decodeHexString(c, "fb1bc7a75bb2c665c4e16d54f6662d3ca8a2c7522e2307a026963bc8c1cb675f3003a515d6692bc778d6d06d730c1f4c2b329d0b1a97d509d810ea04e93f24e9260aa0e3ca458ff203df50b216d5d070"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_4(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6024862593338c32104e15cb9b3e7f3c"),
		nonce:           decodeHexString(c, "e69835ef6a4b9b76"),
		personalization: decodeHexString(c, "33646094468a6aeb6ffdb0ed51fa816d"),
		expected:        decodeHexString(c, "910b888451135677f489a92e74386d9105c3e3ee0a237cacbfc7593513343f7191b8bf3ac024e8b08339f48d851af412f69d99ca79ec3f77ef515f1c50a3e8c76a68020eb7cae42f0b5c85f2d7867483"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_5(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "97ff32ce46d7b677ce0ced4328ac7380"),
		nonce:           decodeHexString(c, "5caaded67b7fc4b1"),
		personalization: decodeHexString(c, "52a347f8a748f6cdf00bd35c06cc9938"),
		expected:        decodeHexString(c, "6780be92c063e33829dbe1967e57259e874e1257b68c124d281830ed4bf701d04196e4ca5aeb4b9de3495563e10ef74dbe89700065852081634873159bb07b79a466798bdfd3991c1dd8f44229644246"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_6(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "10c5b4a8ba0ade3525deabe099cf8a93"),
		nonce:           decodeHexString(c, "8c5d4bce78945c61"),
		personalization: decodeHexString(c, "a71e5244ed23212e9a823889dec45311"),
		expected:        decodeHexString(c, "c39d0bf6772d31e6cbaed8784055441f26bab0e22e2e20e496182bc06603b0c625b199aa08ecfab23f525b8833e18e519a73edeb4eb95fac1597e950cf775e877ab6d5c4bdb3e68a8ef52ae4940266fd"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_7(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6267b5221bb5d4bf9175088b2b614813"),
		nonce:           decodeHexString(c, "44d4c8b9f43a289f"),
		personalization: decodeHexString(c, "3942ee8267758df82064dd072aa4b031"),
		expected:        decodeHexString(c, "67dc72ebbe5e277d382714734b6a76953ecf872b62e1715aed38540f8515e38e98a91ef6691abfd802c3ad419a3051686b503d5bf58e0bc9dc9cacd2a4972d5759eccb96337a4289a0b8af79804d0f95"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_8(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "fe17ad7b3253557a3753e18e2817a6ac"),
		nonce:           decodeHexString(c, "3cfca92eb552914c"),
		personalization: decodeHexString(c, "542c51c478d007182487d5316aaaa728"),
		expected:        decodeHexString(c, "4a7383a685cbeeaebfa9cb93a71b5fbd264aab74444a048d89bdd001e2d6fab33de0a2840a9f43b32ca0469e1b6d769332d1279929aa0f4aa2323689009166afa34c93c5f71f7c68801efa919b2b1831"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_9(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bb67d6bd268cf10f8ef5cd032a3e0337"),
		nonce:           decodeHexString(c, "95841be3247b1613"),
		personalization: decodeHexString(c, "2470df0fdd1bb5061e77f15fb4501b6d"),
		expected:        decodeHexString(c, "4a569282a106bd2c1a7c7a268c0a9bfbc63234d923b221239bb4359aca36fbc4892da7812b8fe0be8359f766b0fd5068242873c7f3660b6694e73a3c86264d1ece9f3607f7a0b8209045561472c89c39"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_10(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "10102cac1368c5b822b4a547392d14d4"),
		nonce:           decodeHexString(c, "a9597155cfbe324d"),
		personalization: decodeHexString(c, "153b8cb80f01c8f34d4b6e7a3491ae0d"),
		expected:        decodeHexString(c, "f2ea8f4897d24880bed508749ca4db5a14c78181020a77038113e96f1ebdcd76d57bcf94f7e88426f204ea591e44d090f269dd1c2daf529f73a5c1fd1c2c718bd3cac431111524ff875217927455a80b"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_11(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7cdc836a14679df8bea5fd69e8622aa7"),
		nonce:           decodeHexString(c, "913462dbb0232f40"),
		personalization: decodeHexString(c, "e77de726e424ddc68c24684e82909718"),
		expected:        decodeHexString(c, "41adf58187f1fb944653aad1e0bf32c27d19b1843f43298509e09d99b1c4e0d4b2656bde1fb4de43b0037c528b6c433d85bbee310c289d963e38cee2e4b7dc063959286a94e5e433af610fde78666665"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_12(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "38b2bb6b2c4ffd6d32ed8e44c29152a3"),
		nonce:           decodeHexString(c, "f7e32604ddee8265"),
		personalization: decodeHexString(c, "671e0039164d3f4763894ef7e0a6ae9b"),
		expected:        decodeHexString(c, "13c539e208831abecb6144f51cb34c3991be24b85d460ddb869a3cc4096e3a7ba89246b57a4b66678df2329d58c32dd9996fa7611d0faeced9ec361e22dcf8466ff8e7bf44139b6e68b04a8930b2de70"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_13(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "cdc703b17db7b05d14e751ae8a88ac64"),
		nonce:           decodeHexString(c, "a3e4f21b083fbba9"),
		personalization: decodeHexString(c, "97acb1789f970d21d417d4754909b431"),
		expected:        decodeHexString(c, "35671517954ea541f6d75a3b38da1e39014fd1a6dbcee4b5bfd723030734dc73387d771b22fda0b2a6d19980d1c7cec6ed69f6006519c1fb5aa8c2033b357a83a738771f3f5518f297f8cb6d1982684b"),
	})
}

func (s *drbgSuite) TestHMAC14_SHA1_14(c *C) {
	s.testHMAC14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d5029bcd6cdd778fd24c53edaad4cefd"),
		nonce:           decodeHexString(c, "84f7310a7ab653e6"),
		personalization: decodeHexString(c, "0fb2233c2cea27d17b6dd93bc4621285"),
		expected:        decodeHexString(c, "a2f373a523ac9f2524b059d0c23bcaa905e15948c7ebf71b6e82150aef562dae4003c1a8a3748cfd553d9a51a8f9450b9d569d96d897fed50eee23978e49b364c64db63fac9dc0fe9e8b58836aa04a74"),
	})
}

func (s *drbgSuite) testHMAC16_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC16_SHA224_0(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a76e77a969ab92645181f0157802523746c34bf321867641"),
		nonce:           decodeHexString(c, "051ed6ba39368033adc93d4e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8925987db5566e60520f09bdddab488292bed92cd385e5b6fc223e1919640b4e34e34575033e56c0a8f608be21d3d221c67d39abec98d81312f3a2653d55ffbf44c337c82bed314c211be23ec394399ba351c4687dce649e7c2a1ba7b0b5dab125671b1bcf9008da65cad612d95ddc92"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_1(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "65cdaa5ab147d0c79fdd02b24fc94d0e427f59ef9a31f447"),
		nonce:           decodeHexString(c, "458c6befe0c2cde5a58c6b7d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0d164682b5bb552a53a2a942373639d98576450ca632faebc15060691a4219467c5aa106034cd19a214a0a4f31d402e68c4c565f49b33b680d522ef25f541e8202be779730376fdcf5b7b58fd6ac959204a88f91008651d2c02ada82505f914d4d9b9aea7967784e5320e185e1248270"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_2(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "650996f1477112af7604386be5ace78232904315d99d87d7"),
		nonce:           decodeHexString(c, "2a06709d331a6f930b447cf5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d3341d7767cfd95640a107b3abaed7b4e1855b348e3ae5bcc53a0b0d49d4b4976837ec8f376f38327135578eca7ee583215bd5c79ebf499816f79afcc402ff1e9ffc4ad0f896761c9cff75050bf84baa194c355763b16b5d2648d480a2b48f22662685de39c7cee90aa0b6edf8062e42"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_3(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "898640ce467201a53e7731bdfb572977f7eb3e49050bc1e3"),
		nonce:           decodeHexString(c, "67ca74bf0a27376d339d09f4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4f5eea927023b4abab5d4d9944e84ca001ee081cbc21d4080e1534ee6d1d8a6f60361029ffa983bcc79b5d65d4aaaaaf98983de13ddde39a739f9d95878fb31f57f96184e5f2f3adf654a468c616237fcbc6b2c194e247178cb90294f631c449a01f1fe09c02587c460305be9fc71b5a"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_4(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fe405dd73956bf6ec875515eebd8c5ecd60553643da75091"),
		nonce:           decodeHexString(c, "4c83dfc93611d57390af7324"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d8ae0eb81913a190c439f8ffa56c06155a73f84b20608b2b2e9eab3061202cebad18ab8b3eba81672152c1c02ef573cd6e8623c392facb6a857425c6795cd7999c1e7f56f3fa9accca018076e0bfc106d075df98f5fb66f28933215e9276777dfc479e71a8d506a66197918d9b0f7a8f"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_5(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b06892f6f455afddc8eb60aae35b35a64f63b2aa85a2dae4"),
		nonce:           decodeHexString(c, "ef489266f7bc354f72d68b71"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fc10c03fc37d3bd5fba6591a97f6354a9ed8ba2b6806744432851f43a3ce6418e39ccb417b8539e349acea588e2abe5da06147c9825c6e50a31f8589a57ca3bfb10f0da9c8e89fe2e372b5af1cf96e0fbeec5d99228770c41a76e587da7d8764d5f235f5d1d6188d84ae61c52c2164fb"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_6(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9174e174e9e031f62b2e19ae5c0bef22eed7d5598e6e7350"),
		nonce:           decodeHexString(c, "4759a2c15b05c2473a721d26"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1962f2d473b31a2576dbd78022f4eeb974641fa2e9cb582f03ab741929f51f0f4663129e68ddc242e1c2ceafacec3dccb97e09527aff46b948f0abcea1451699dc3ae4d3fb5e04c84337e17b504af2fb5f1aa6ec0033ddf138a188ee162c497526563a67da8015275d89f0e1e902b2ef"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_7(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "eb1d45ba0d8951b7b1d7ce922b7d1f6e94da8b821940126c"),
		nonce:           decodeHexString(c, "9da5b0b4382425930743a051"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "306b1f733e6f69b6f26b7baa5441af4967a5cad8faad18029440aa989aef6024dbf3ba02dfc2c694dad6496ff760d72ae6914a4dcd5e3a443f4bcb14bf2b64986f35c32449f15e3084d46fadfa2ae213da6b26f787cef89b6a23084a929608a9f6acd8315808c29f8ae435a40202a012"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_8(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "78cdc1567caf2ff529ef8e3475c0fbb09a48b687a544f739"),
		nonce:           decodeHexString(c, "9f503948621f29686fb15216"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2367067d8ec189b0819eda34602768a0698b4b545c7d5214fad58c9787b89809b97f3af5f9349907d2954f8c0dccbdbe63cc019bde3a6fae10497ae57f33e91ed55b6fc4a83fe8a2463552796d5120da8066f7285a8388958817b1218e006d7fc617f453ad0f9217966a0731ba99f093"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_9(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "25f9ee24ee25ad3d29a974f8f552b178cb292b847a6be806"),
		nonce:           decodeHexString(c, "94213a6c0b33e25e29fd3ecc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "32fe251a619d164c217365b12a313a942b6a9c3df007751a5fa9f356412d1142c785c292e3dc9d0b1d77e080892e5d39b91c58fd142458c71182061920a0721db453a32fe7ffc8b2c20bf11894fa37d8f0e9463edd43a97f65362295119be03d5e06f617fdff6accaab8c4da72ac8f81"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_10(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0b644221788c266aae00a3b63a87f32ca96a6c32b116cd37"),
		nonce:           decodeHexString(c, "caa4f75ff5d7e56be3b4e20f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dc9245da77502cadd1a8ac4d1cf6a199c8e529deda10c87ab6c69ceea6fdef36d45f4d036021b93fe5b342c52fe1e71d81e617bebc58804af3109bab93dbb2e5c546e108bd0891710128b5e8e4a4f01df2003d038fec8cef426fad7f72dd5e091b4850e9bf4932d60deacb6e9ea3c5e6"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_11(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a6677badff70966a3cd2febaad7de7aa5849ba763789b20d"),
		nonce:           decodeHexString(c, "0a39b6c569261b826cdb15e8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e04838c970f5d7208a2a7310da893d65391666a5dc62d9ede71fc30816cfc3e8064ac59cc9aaf30283356078c812676ca20beb044a6d78db6c5ef9718a88559607f225002452c01459944433013cfffea84d6fe404fbbbc2d66bb50a2fa01d8a5d6e4ea9b402dc5256752461bf6fcb7f"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_12(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2301d8c053312db04882f4284cf8b47966c1c9b8c49de847"),
		nonce:           decodeHexString(c, "d0c11f14c5f70ce19346562b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b46246526b28f3ad7f6d8732ca3bfc40f005d97a519640a4ce728486d8bf830d661be5a97b11113e89096d9bf15cbef73ec28ac13e3fbeadc9bca500918bbe92ea23e131cc622dbffe2272db16ec5d4ca30e9bd986d1709ae22d10180514bcd11bd6218ea1fbaba101444945a17a4c4b"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_13(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "78644ea1b0c4c55c4addeb476fc34471ea2c4393697aa4f1"),
		nonce:           decodeHexString(c, "70726010c443b8e1c4a6b3ea"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ef1b41bd03ee8460d55759db65a4c97758f48e3a09127be04c7ed08bbee5fa5cf119929df42c187e2a347a8df99c502b693a7ae41946f4918d84686880ae29d6d8fbbc4fccc9e295876a249cfa59effd331994e84717b4c76637df36beb960761880daab3d43376341439af2ce8e33cc"),
	})
}

func (s *drbgSuite) TestHMAC16_SHA224_14(c *C) {
	s.testHMAC16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "71acb71235e88e3aa6d8bbf27ccef8ef28043ebe8663f7bc"),
		nonce:           decodeHexString(c, "f49cb642b3d915cf03b90e65"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "144aeb56a11cb648b5ec7d40c2816e368426690db55b559f5633f856b79efe5f784944144756825b8fd7bf98beb758efe2ac1f650d54fc436a4bcd7dfaf3a66c192a7629eea8a357eef24b117a6e7d578797980eaefcf9a961452c4c1315119ca960ad08764fe76e2462ae1a191baeca"),
	})
}

func (s *drbgSuite) testHMAC18_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC18_SHA224_0(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f6e68bb0585c84d7b9f17579ad9b9a8aa2666abf4e8b44a3"),
		nonce:           decodeHexString(c, "a43311d57842ef096b66fa5e"),
		personalization: decodeHexString(c, "2f507e12d68a880fa70d6e5e54391538173297814e06d7fd"),
		expected:        decodeHexString(c, "10c2f93ca99a8e8ecf225400c804a7b368d93cee3bfa6f445920a6a912d268d691f1788baf013fb168501ca156b571ba047d8d029dc1c1ee07fca50af699c5bc2f790acf278041518141e7dc9164c3e571b265fb8954261d92dbf20ae02fc2b780c018b6b54b4320f2b89d343307fbb2"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_1(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "85c2a5ca453e477b5ced164a6cdfc7dff9c2fc349dbba685"),
		nonce:           decodeHexString(c, "e4a5e79066e121b8e7bd5a8f"),
		personalization: decodeHexString(c, "68e0dfc8145a32d83cd41d76fc19901d0cdc7543755586a7"),
		expected:        decodeHexString(c, "fbd2ff764ba0214371e8e0604584368ab0e5e7887ea456965b62986f41d7cd2a969035b5d282bd59ee013b730c01ba419f5e553407041106df164187febe1e42e128a298a572f812f5cd5c67c3095b31a2b86c0f64c7b04823ca4ddd5e775e5bc1132de636d4f5ebbf319ff81a815fe5"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_2(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e7f28c80e8259b43f19ca54a01704a35f8498ef4f2634289"),
		nonce:           decodeHexString(c, "33ef9a168c0131db69e95108"),
		personalization: decodeHexString(c, "60593dbc4e031268eb06bcebe83b9c04b8c5fca69e787eab"),
		expected:        decodeHexString(c, "dde91517435ec8a37bb5bdf117ecebb41ad013830c04977c93ab0bb58ed069480fd75ec3957395f0d6f3ec4f524a24f66940ca3b43d7e91272803a56cfcae22b2a345765573f861d14840cc35f1e6b911a4b831caeaa4a9bba798c82a803dee10de853e6532463b359d07f8cc8ae2770"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_3(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1593a81d8c7c2fd04930b7549e1ce0b0aad740d686e7b972"),
		nonce:           decodeHexString(c, "304144f81754fb0a9924b5c6"),
		personalization: decodeHexString(c, "07b6ad022234b1c7647724df1646fd0f037fc60be15fc24e"),
		expected:        decodeHexString(c, "ea8071c8d8e32db997cab20ecf42ce4ea102cea5979a2569f6d60ea8b0cb1e252be78f6c78007e4a0e42ee7c8f91e12e1e394b8bf94de08b8fe6dd77ee8e7bf932c8d7c91a879d34c635c8b4ccd3b564bdb01bbd79f9648a0de72e732ac33fa04a6b283b4cab36780906bdcd208c8ea9"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_4(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "33b9aec94a326b9de5f111418d2a30900d2a9d1ca60ca10c"),
		nonce:           decodeHexString(c, "ee3213ee1270075b54dda450"),
		personalization: decodeHexString(c, "cb55e3ed03539bfe2b60f06a5d9b8a0dfc252632d94f0498"),
		expected:        decodeHexString(c, "910dec9bef9cd59c4eaab2e8a4e1f3ff796c230836de21dee4d7fcacb733c516149ae07b6908998139a454eac06899910fe80369cfaa397b6283d9a1e1dacda11dd6dbd819bf9937f1d675b1921583fd37438becaeb66801576e462f4cc14458d54801b63e3e07e1d454a321909e8e79"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_5(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ccea05506f38f222efeb575b55b1427f24462ce893503b85"),
		nonce:           decodeHexString(c, "8f259640b14a0740b4261701"),
		personalization: decodeHexString(c, "c1b85c8c907abc597fd0193deaa93d0d128e6dadf1547392"),
		expected:        decodeHexString(c, "7b75c82104d086490eec75aea3a548e2f09e72e87262842f976373ca3643d028bd0d39711e783605d65a0a75a126efb67ddc18a57c704c16c6193b168fd89c99a5653b033da90730920454d5549e2e5bd76c0cd8822f101a50996e91fe9d3efee8d7daaed50634936ef9d5825a4d08ca"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_6(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "10aca922f6daf58bfe2aaa25ccc266cce780d9316fc514e3"),
		nonce:           decodeHexString(c, "abfd6e8fb7db495635aa12be"),
		personalization: decodeHexString(c, "b64e51f0f2b0a2e36a68f0235621e9b1f44ad46003c911fb"),
		expected:        decodeHexString(c, "a2c002c29f2aaf575d16a0892a0c05b1065af44104876d571cdf7b1193dba7c810d216d4f1be1444a56f2137e08dca99e765df4df9c5997735b60845627d290f24110c260a0b3d26d813acbf196438dca33e8af84223e6e37b562b368ee0e88482619e534269b71972a88bc74aca7a04"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_7(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "43acd2920393eafeecf55f8b9fdb2ca607e677bd7a5966cf"),
		nonce:           decodeHexString(c, "02d25c09c3f44fddba39e18c"),
		personalization: decodeHexString(c, "f3aa9e7883ac3a29c8b0b585340ac7e94223fa549c3e3257"),
		expected:        decodeHexString(c, "69f44057771a92b0019f7f6e5d94d226d9cb144f084b5d3304e9cfe5c98cebe2655f0765cfce9d1cb00e3dc29c7f25731d9da33e9537fd58a8f310446d03fe2ebaf2db71a6fc96dd30276afd5b6627c3912e9b82dfaab899c83785bcbab0a24c6534991ef0dff4d076cd03b17c83c05f"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_8(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4ed7fcc29708b42d67d68c63ac8b25a90ca779dbf0c7a68c"),
		nonce:           decodeHexString(c, "ee8e62054d236ca19b20eb25"),
		personalization: decodeHexString(c, "271c11420f431cf629c82b6fbe67a7746c73ede5447611e1"),
		expected:        decodeHexString(c, "c4801020b3568c78db7a56eaa21d8c0af43cca2aa576d04e7d91073e5ec4fb26bc915101fd2e88727af43d9217ed2aaa84a400cadb94ace9d80989b9cd323e5923abe46dbbc37e59be9c88079c0bd79c950638a212f78a2b15e0e60b746628ac9454375de26cf5f4f6dd5f13ef2b0d4b"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_9(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fe355ae98956ecdc547fd874c44d10f6446640abe51b7f7d"),
		nonce:           decodeHexString(c, "fd94dbbb09eb0174b9803b86"),
		personalization: decodeHexString(c, "4ed22949f8454d2de680aca77317bfd60e7b4cabcc6d7a1a"),
		expected:        decodeHexString(c, "50a093814d2708355174ac293ff6bb3ff49db74178b0cd9e8b96185fed816f174a86a8fddfe7a9430876783c652f8d9bd1fdb39b6150a25a4e5752002784d09f40982acf67fc27e98503138f9bdd76740c8111198d6279138f04bd8de187113f5b72bc09164b8cdecca60bc002d73324"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_10(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2f51374b44ec63290afb879b82b9601903213ddf84856eb9"),
		nonce:           decodeHexString(c, "b58be25c11bb61f4beda20c2"),
		personalization: decodeHexString(c, "29e20d31c37eae481532c04bfb635fc370702c37bce02749"),
		expected:        decodeHexString(c, "8d962a05b45b9640eb8c3fec53c42356576f226f1105a99f440377cfdd393d9ad603c5882311a8f4433dde920580418b6de917b1def9ef0340d5495ff1df4cef4d32193d0f39f65f79790ebbe122f63531354c0e765cbac7ce5e185e73bdcd43a2dae95adb5ac10b34bcee909ae504d4"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_11(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e9ce04369bb6aa98e676ecc7adbb291f1d88062b0632a977"),
		nonce:           decodeHexString(c, "40590644da6089f1ddd0900f"),
		personalization: decodeHexString(c, "47eb87b07bc34ad3094a8ac55bd2f5543f6d83d864924dfa"),
		expected:        decodeHexString(c, "d9865e8edc0d19dc4c68305c85795fdda2e78342b29673dc4341f901569509d9fc9f9579feadb5576cb050e18cb617845049004007186f8d5e6e9f19655e15fd218f5c346055ea668e94736b1fb4a1f759dbeb4817a1c1cde4a6606edb929ed57179284da743f08836369743babf4d16"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_12(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b3b7f12ec69d825d366a473be79d49d52e33e1e578c85db5"),
		nonce:           decodeHexString(c, "e9ac6bedb660c46667d70ebe"),
		personalization: decodeHexString(c, "60b409a04c48179b4da05696ee5351b501f26a74337bba4b"),
		expected:        decodeHexString(c, "09fbe28bdd81a2f4c4fe2d44eb31f3b654fc0439333b12d7b6a839e9c0047dffb35f5e04fdeb9364cf11b6b435145e8435086641efd43082b3525252197dc4cf6b1cee744bef9171ea67e42d5f4c4551aae4da8e062b25ea0724355c72ae090b43e4613311530938528d015a449d26fa"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_13(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "616e5b7bab53e0f03a7e74d334767a927ce4bc0075525dd6"),
		nonce:           decodeHexString(c, "19a473a020da1c915dcd3b09"),
		personalization: decodeHexString(c, "059253c54f664cd68682db12ea6ea2bbf57b5ffa76b0a11e"),
		expected:        decodeHexString(c, "b0e456d5fddb763ca46103a4c63f3dfd9b0362293c57b1bbac9a4cecf0717d8a14a9c23a4d8907a2eb4dfe3d1355018dbed5e4ed7675db5db007d233a2f78287ec75210f708f8a169b6bd6825050122a21fd3d4274587fbf28be83993f66f143372c1d5eb1df9c63247b21f0886933ca"),
	})
}

func (s *drbgSuite) TestHMAC18_SHA224_14(c *C) {
	s.testHMAC18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5560084df2bb17f0c54b951d826f5027169503c6175be517"),
		nonce:           decodeHexString(c, "e8c5220ae48b0ca1412e9c74"),
		personalization: decodeHexString(c, "a0a1d6d3887f7ff9f13c85d6ae5af2c840fd85989b7e50b3"),
		expected:        decodeHexString(c, "14f629aee43f71b61d467ccc37de8eb6110ccdc65fff57ddd2e66707bb768e5de5df5467ccd55002815d306adc7b7d6b5d87c20d2922bf5fd3790282608457b69720be7d7affcdfecd173a741c7fc99f5f30f981b1bc102977a61f1515b923ba53cd87a37faaac12e0af613ba0972a0c"),
	})
}

func (s *drbgSuite) testHMAC20_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC20_SHA224_0(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bba743058788f9cc91a321caca494b3ba5c72744950ec788"),
		nonce:           decodeHexString(c, "8ca27f243ad670e805814af6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ddd4d2ec6e05f6876515d79fd6f1488b5aa61786a8b7ecc15f865eac437bb71b8d05d1e7e376f4857c3357bfcabb1ee3d933316dc4b67e69476c7d3fde0a26eb386e5d2864cdaf99022101aa383bf100d9d0519b6725540c5e1eaac71e4444dfe8ff8cf35eebb8fb5a804226a7044bcd"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_1(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b9850e5d7dee9ed1c6cd75c17f97a5f4547de22302442b38"),
		nonce:           decodeHexString(c, "d2e59541e55d3d9effc6b1db"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7ba9ea4bd21b7878067eba71ee78acf4c6d3387b97045940436eb731d534e543a5e14887af8ce33b0f6496555d8badcdf7e8d2c4d8de5489b4feb226d2716cfb90aee90fe189e67d03a923ae3f8afee786557ab1fc8386f94cac58f0986854b6cb6b2c90bce778a367eee0b15655bb13"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_2(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7204f95f19a279305ad41b9d0cb7dad7279fd6678ee3980f"),
		nonce:           decodeHexString(c, "67746832a7420086fe591a5d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "556364ff6f63208683fb53f18c0dd2db792577423745bda42437c1b33c73667cf257da823ee5080e0c103e6ec57b6e81517062c55989ce76c257808151dae8a2932cb78144207c15f6c9eb4fd57caf0101a74c1c9b42d375646997de7a035f3150433c4e912e12f975ab8494d49f91dc"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_3(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "748e2ae47a2c03365491374e7406c408958fd08e0467570d"),
		nonce:           decodeHexString(c, "3a0e87c3f6c19285981845dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e0475c909d0d13d389d0828dc50099d1258ac5382c68bba1abd2206e03bb7af7d40d1a01510f9bdf65cfac9efd047a736689296bccee5ff1a2e376cfcf44f96ed6817ca249353efa42921b0f8723d330877afa17296fae9856d628bff43bb929aca216a29a4c1d9e69df7570dbb3e5d1"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_4(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "dd1bacebf057c043d76d83f86b46fc764e2290e4d68ae537"),
		nonce:           decodeHexString(c, "e08d66b15f2c49f4889df2c6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "09bd632fadced576c3e0351873fa9539fdc499f41220b847301a8aaea2281c1d9b317448552fe262b822bef8779a132d66f9b27a320279fc92d5c8373f9aedd20f6c2a422a9f34eeb87587a1de6a2150faeb4403912bb81128c7409bb58a2261aa7ea47294cb5f5d3601e721cc000932"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_5(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3e894fa8f7e68a9456340088d6efa3cf3d2d80d96aaaa89e"),
		nonce:           decodeHexString(c, "def642aabea32a79ee0600bd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fa8c91477e50c20838c0edc8c882d4a76855b5e406665c26142bc4593a6d75998dbcc0865423345ab846da78537a915a94d60e3d2e2d1dc265c00b8c589131d82f5a2916205b42b7c0d0746f6b516357dcdd0dbea1ce7279e8879f79c0bed8c94ceedac2b028c14655c186d160ca138f"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_6(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "02e9ec23399fa27efd580a333ff8161e71a4f049f02b3655"),
		nonce:           decodeHexString(c, "8f4bb7f7e0e9f208462580a1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9ef5824559ce7832f6fa9932ee1e332f735d42a8c21224dca73205400f4e0b9a758b691956389b8ff78855084652fe29b5b77f56f22d14274e030e017f5c0d75b9b4ebd4d540d0a5f057946cf17ea6aaa94fadf6ad39c0de7a7ebef4e332a20b8f4f5ed1cf95620e41ffb6ec105a78f8"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_7(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b2480a2abbb49706d7ded682e76fafd53b8bf1f0a533590f"),
		nonce:           decodeHexString(c, "ba562cdde7e35c6f9c41f1e0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "723d464216a191a10cdaa96d4c9015fbd2f7ed29c8eee3280c5563353fed2c2a2b41fa51a72aa6211f3798adc271f7927e0bc31ef157d941829d43b27d008d17414c4dc2a3aed177f3cd3f7de16dc2c2e56aae74353ce2613286864f774bc2f1388c0284d964c095e7260c94bad47ce2"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_8(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4d07b701d5614b0e96ce8e31bb8ae111b635852fd55f188e"),
		nonce:           decodeHexString(c, "ef66012b0999abdf3e6fac06"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "53ca443e9c3a2e7b88312bb2989219b0ca73bf20167a5a68aa55622b7d3019094f3c1ac312b19c746b082fd2d74bbdbfed24526b0220ae13c3c11e66f7b2f7a0f5b3bba01c8a19d056780d49e79366cfb965690390607d7473ecfd9d48b73767e0098df0fe585b49fbeebeea121b07e7"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_9(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "573a180ee9c46067473e29a27a89e11973af9e061d80a908"),
		nonce:           decodeHexString(c, "f39acf7e26a154ddec7c76c0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0013711f1a3460cead54bd7cd0a3f13e461e5321fec3971a9c7ac8eacb97d9c373a5e0922b8d0eb5fc45c728a9f00486bbdaa2b88be2a8f9ea69cfe168a0060841192c0d7457ebe350eae30819d74ab3068a8d67ac28b29d6ef48fc24f845460706812a1b2700a53b7ce69b39fc9520f"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_10(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "168a647155e7849bb6e5405fa65fa2972fd869a16970912d"),
		nonce:           decodeHexString(c, "8686d17cf524ae8e4eb937a0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff6b061a4743a2b21f1be263e0e620715e2807c507a2d6889420562bdee79da662ad40983215485bc4155e0251b449b80cc787e34ba07a172cf4de74988545aa7ef16d00b8293a60eac04d9826220f37291d83b54b912dca8c0debd470801264aeb4c2327873cef0895a76bd0644c010"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_11(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c0e50ce5a5a5c7389a19a3f24fe7232bdcb4f08542cada1a"),
		nonce:           decodeHexString(c, "3d27e3b7542e7a9f88905c8c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b603a876767cc7bd88e9414a5a2f7699254aad3baf8b40c4415e468ab70e2490bf440afa0e2e307642ebadabc720ac2618091993049b6c5b90287d85c9f589d291911547ad2eaad5d31635af2d2b77eac3cf4bec600ffc4d43cf0526897564da9c10dd7a3bb17b04b19a64d3bb5697d6"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_12(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "41e85704f784e21622628ef5af301d9ab2bba7f87430d37a"),
		nonce:           decodeHexString(c, "d5619a9a2b58e223f6c256a0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ec42453176fa42d1b2c6778172d2df6b16f5e91e44f5cb1541dad058ae0abcb6b41da5689e649c5ab4022b4e5f56d33db70cef87adc287185bdad3400aadb294a79fd583ba26835ad58dcc640d15286352015cc61f07b875efcf7d00ba01f2302d20b7ea3014597f89b2dd9d13264fce"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_13(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f2c14695ba4bcbbaf6ceac7da25e075e47357ca5246aaa7c"),
		nonce:           decodeHexString(c, "8829afa614b4556f605a7e2d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "72ee34f0ba35b3e8ea058357b6c848503b0b754204f4706c54f532c14650093c6cb993c2c3982251610a6e09c354244c0ccd8ccb6d9fb4682cbb594547a0d3e69fbf12e6151208847baa6a748e56ea7807fce18af95ce8aee77dde17a7799d62eb91ca37d4c3903191560d82b73f569c"),
	})
}

func (s *drbgSuite) TestHMAC20_SHA224_14(c *C) {
	s.testHMAC20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "30efbec33ef98a928e9441af3caabb34cdad892669e88130"),
		nonce:           decodeHexString(c, "f77b7e0fcca6f8733e0bb0cc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "85f5368cb9f44474af6c4a159477c5cdd05eb0c0a37847bbb07e9a9c8f633ef2c3727d017f1bbfa89dba056062202f5824b3a493ab53a2a5fcf796d944577f1393d35f2a284453b2cbd8eaf35b9bae7b87c156cdf9cd0a2fc94ddb0d4842e3ab4b6c97089cac0e32bdeb32dd8233fd6e"),
	})
}

func (s *drbgSuite) testHMAC22_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC22_SHA224_0(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cc77c08df466a3f73d20f613e39ba50b5aee8cea3dd9da69"),
		nonce:           decodeHexString(c, "f9637f3f581c27e8154b9359"),
		personalization: decodeHexString(c, "24befa89cf5034a5bdfa39c6a7e405cba3f3755f38d6eb40"),
		expected:        decodeHexString(c, "321df4649ce0f94f53f44da95cf8912b35dbe7accfd075ef9b0e89c040d0bb4a1d41a2ff80f3e2ee099f87c4dd099725d0dcecf52bc082f9903b0cf0f1438443a9e25786aaa7e0bcea67f2b165755ff28eeb9b7803d1bee81e3f18c2685fdbc378b05b52e7a003f72a3ae8e1450b9883"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_1(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7685572080f06c46c8242862f877d58bddf4a5fc9d553d99"),
		nonce:           decodeHexString(c, "4b3574aee84a3d07f033826c"),
		personalization: decodeHexString(c, "69b6ddfc1327bde11e24dd793ea5494296f79a6a4f88f1b5"),
		expected:        decodeHexString(c, "48ff1e1d05637fa86d0ca93341f684dc94d238206f8cab1a5c6e4c32a820430eceddea0c293d5fcb613308fa230a618b690341d1ca17ae694a86666f1bf863351b8af6fb6e913293a610f5447711f0bbad01105090b2ac03d5691055dfa2fc6b5be3757ee4e2b8309f04e6ce8566f1e9"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_2(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "dffdc5240aaa288dc1e47afffa775231ed1c59fc9913fbd8"),
		nonce:           decodeHexString(c, "9236964c000396c803f7d2a2"),
		personalization: decodeHexString(c, "1fceb760271c306b9fb1c1f433d24862fa8798b3628001ad"),
		expected:        decodeHexString(c, "c2a591f58da6b01ff2e841958e4495d07f9641ff99d8ed056ea296dca602d0ee07ae4fa33f44d4e21dc0a266e3366f20d019c75d13f98bee7f5b024ccf9aa13f2068cf74f93af9df118decdc4e073df30ee90040963ea367b2704579ee395ee1ac83ee79681a4be4f01a4626c5f7bfc4"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_3(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9e04812cbad24f5ce80fa2b45ba880ec17b26fd10cce6020"),
		nonce:           decodeHexString(c, "3211900ffbb9045d3821c919"),
		personalization: decodeHexString(c, "b01370ba341cff79f7005f892be62a84060806438ad14311"),
		expected:        decodeHexString(c, "bb60bd21005a3dd93bfe77584e1367547d0e3144078ef05928ba3de70eb1e6be2d066661cf1e0552b0f6125111628c30cc123feb5a3c057fb969f25fa7c8b895c36a828cd627b56f46dc7a5ccd40ab8c8d8e5ed558605019c6be6d062fe9d86fe38ffcda42bc9708a4334f43a8d9f273"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_4(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7af6a521fdc55e303c53334a4effe014cb7ced725ace9ebc"),
		nonce:           decodeHexString(c, "e5713a9faf54f31ee96e52e9"),
		personalization: decodeHexString(c, "0d1d8a87891dd47d5488c0b52df2afcc9fc3986811ba4759"),
		expected:        decodeHexString(c, "8afdcc8051d4968751cce8fbcfc28b1081424d70314b836ab158576d8f1be9e6884053a5862020f1169722c8f7ca4523ab8b66a25e017673d04f0369203f6f5c7ac0ca5adabff91e97b1e43601378a4574ed6d3831fa16855df7715e8c92f458b509a51283cbf4e5ab0cda7c1306044c"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_5(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e513d483313d824143e0f2f35c4799a66b20819750faa3f5"),
		nonce:           decodeHexString(c, "479ed252b3663b51dc44fbd7"),
		personalization: decodeHexString(c, "242fe2b949d5d12b278676bf38deb79822cfa59a294b562f"),
		expected:        decodeHexString(c, "8dabf70ea50f952248625652852200310caf3761a8ebf382f17a572afb6e02f2050a5351fd917ed36733af9cbbff1cda0385c3c7966a3fd1fe82f18241a17e5b043a4e5986931d69c36ecd90aa383ecaa6e5a37cde917d944e8e2e2723850ad953049bd41787398a00637e5ba351a8d2"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_6(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "85cd18858cd605bda2f66c255189c528f467d0ff9601f4dd"),
		nonce:           decodeHexString(c, "024ecddf06232859beabf989"),
		personalization: decodeHexString(c, "68ca6f72bb3cb92d876b056d4efd21cefd4fd41e88a77773"),
		expected:        decodeHexString(c, "ac02806acf16d16b60548c81d90002f71c01888dab7ca7cc68e2f1c1b0c5347d1cd26738388ef5dfa44fdcff534a327103948a53df708a43388104d93f94d0462bb2b2409e21102b7cf4fdad7f97465ca2702ddeddca87ac01a3bf0167b0ffc6f123f5ca5b2bea4082369d09def70746"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_7(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e9b462858798475342df2b27362174685062f577f67aac5d"),
		nonce:           decodeHexString(c, "f134d4d2a09bc00ee34768a7"),
		personalization: decodeHexString(c, "7d610e3e8ad86587d205d3661f2d4054a772305df989da74"),
		expected:        decodeHexString(c, "0cbc76d53828951f2da32ee550fea0e38b8e32df618eb8e5355b5f5b2bcce685452bde3ef8e257b30e6186f0cea481b33d318c7a0a7f7efcae0cc789095a7111cdf702782142c025e21a128403d2105d1f2f1e85769a92e2e7087e3b271525ae9c83273f811247c3a9fa6f0918aae299"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_8(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bfc20fb89320917d77518a8e2321db89cbb6034c3e881813"),
		nonce:           decodeHexString(c, "10842875bb240b29463dd499"),
		personalization: decodeHexString(c, "62798e770aa2e7e91e66ce2da4ff5efca2f135045d682f1a"),
		expected:        decodeHexString(c, "487810965470f49f26d805bf9ac1c394a570891871f18c5929c2ac38ea49046405f032d4635dd92f4210036cd1dd80b1542333af84732d1d009c2cfe91b9a932620352f5ddbd6ccecaeefd75885c1184ffcd8ae9a11d51a664eaeda1b70962e7958f124d6d61c6d605bdf7894e3b3f99"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_9(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b6e6337e37b42b0d94366c6560f7ce1e92b9a12e8cb8920b"),
		nonce:           decodeHexString(c, "903b548fae74c2350e606816"),
		personalization: decodeHexString(c, "40a1421dd702077801c919e12652f8ce453037be618170f0"),
		expected:        decodeHexString(c, "182737f299bdc8ce28a1c201e6c81e2ceb962cef3ded74c95a82fbf008832c3619c16cf85dc4283b5aaa998c53e84855e7a86dd791e72ff9f4471fdd7d011d74198bf9f55cfaeea9d91f974dbe07d3b63ef0a3fb69833f19317f7842c0711c782987067176e8d93ef9d2c92b2f4d0638"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_10(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ee35377a65ed94502397a83b6a06cc459877a64b67a7c27f"),
		nonce:           decodeHexString(c, "39361bc989edda90588dd2d7"),
		personalization: decodeHexString(c, "1d5aef06c14332225fc27ea2999e492afb0398fcd5a662bc"),
		expected:        decodeHexString(c, "61c6a16349b39e3238983019da3d6d07d4fd6d55980af4167dc3894b5053aeee7cfb4c73d4b1e52dda71d49eb94ae0faec230d16fe652ce252679ffdb61557d3fc71d9448c19dbf85f2efc37722c9c4068caecb1bd7546b6c276a70ca3674b8aa975c3fa7a73b2d2068d13b33bbe441d"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_11(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "96a91f6f66cb26b19a38e1ccee4d1efa8385f12a73b91593"),
		nonce:           decodeHexString(c, "cf539ad397ff8455659ee337"),
		personalization: decodeHexString(c, "a83b6355b9a581b3fef4bfc35b8d414ee333929c5946f836"),
		expected:        decodeHexString(c, "88d3229c004bb57a0467e4ff6b0d580f539417f2b5cdb9e1ed376035d8980c9419afc658b164adc4b5574edc3552f037c0d086c2219b8a14ef1787f734fa5055d0208fdaeff365a383a5e1ac33cb79fc85155e8c701ae6e1fafcf208ee6ec594f4ae7c491bae8ca29f671d499f279e80"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_12(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "504d354c253e43f941a1cf4e9ad187e879184330bb06b765"),
		nonce:           decodeHexString(c, "2300e7738a62472090fe83c0"),
		personalization: decodeHexString(c, "4e8a5eb99a0960463a77b093d73e1883042be5e3b93e7d93"),
		expected:        decodeHexString(c, "231bf1de582a733c6fb10bb71b1f3f2d0e8e360b2b5d19e51f70cdbde9a9b11574751cb8e949508e891bf71deeb3720fdbd72fafac95630b345ebd73cc81e12ae29ad5cfb1aaf9b95e8b4bb143f4eb9141221cfb6b6756d086c770acc3b8c24e200ee985e4444004ca259553a107c3f0"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_13(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e6f8fc3993ebb29668d64f1fb471ee92c1aa1d946fa80283"),
		nonce:           decodeHexString(c, "b0eed241daae8d748484d0b9"),
		personalization: decodeHexString(c, "73e1ad4ee16e5c7865d4c2bd6d843075a4ed72d48380ad1a"),
		expected:        decodeHexString(c, "ad4522e99f7c6c00feea0280ed6d2258777809346ee3ce52c150f3046424b9510bf17d13ae48301b7d224510ba79020e5dd2cc04959062c3bd2740c8a4239850f4b1b64c296aab8a46fe5988fd98f3ca15984f36b45ead997b813ed4032df344f081ee7879c1a83386f775028e21cf2e"),
	})
}

func (s *drbgSuite) TestHMAC22_SHA224_14(c *C) {
	s.testHMAC22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0cdd3ff2d685c17a4211f54d45f7a85af293e9a46edeb10a"),
		nonce:           decodeHexString(c, "46f8ee037b927ec766de0aba"),
		personalization: decodeHexString(c, "e6299e0eb5826e498d873ac02892f01e02f6632101fcc090"),
		expected:        decodeHexString(c, "d86bfd8f9d80eda3bd43850ea6edab2ba4f69ac8eea623fd6bbd5c0c920620f8cc136b0170f0310a156271981a9cf7629e1b8f0759de1e99e20a0930ce3bb7dd2d88bc9172a56108cdd736dc529a6b99862bed7d543bdceeebf450020762652d520105f5c5cc3c9a6ebb64af2a7e82b0"),
	})
}

func (s *drbgSuite) testHMAC24_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC24_SHA224_0(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1a4b3584ff2a80fac650b6951bfb8ee871d8c57ba2e18155"),
		nonce:           decodeHexString(c, "67b2967d4bf065e82330de27"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "452c1cd1a5c9d0976fd10c8b6835b28349ac99d145d1f00309b846381707122c1bfa8a36f767df992bb6d230b7ee35543085e0f9cfa2f29212ca228ca5dbd5169ac4b97f1ad270e5f993d612d12643f144a492e05f2c8773b93b6c8436417900188a5700dceafa292d3599162c3263ff"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_1(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8d1091ff23561b8ece902f5a0b67a37fc3f2d63ccca851e5"),
		nonce:           decodeHexString(c, "b035839378c9fc410cb72b1b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d17c2a81342b2efb5e4cca2ba0593f9a0ce3f100f0b19f99bf195b8d4ca40ed8a03b2dfac74f225d8615b9a791e303d8ee874d278058433cb099585145a7deae70f92f173bc57a295e92da14b4f61101600593113c69fcd9ba2c184b5515eab325ac0566b2e4dd6e79a9cf1515872b6c"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_2(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "42b2a6e4b3ddae69443bf81498f8fb92a51b3f500d46b8c7"),
		nonce:           decodeHexString(c, "7147df6a69dc21bbc855b057"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dca346255660c7c07ac2427724551cf9e9ef7af3eb76abe3036b36a2d2de25df3425ebbe1188714ec215542fdca04ad469fbe7b12ddeaa370afc62610eebc2208efe7fe724897c175dd69ba0f000dfa4c371c5585ec80d91a26177f1947b7dee1f49ee10141691db118dfcf971d1ffc0"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_3(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f51f942cb2f700293aaadcd163eb63656f38b4cc7dcf51b2"),
		nonce:           decodeHexString(c, "f827f45ab5b8add3a19158fb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "59a7086f47293e334ba89e431fa5f40562f93682b516ec3c7dfa9bd775076b3657615fdf5ddcc4fd0fd859ce3b1a8faa8d98a9f47d3dbe1690b079ad85d71ee74ec16c0ab1cc87b9a242b2468237fc9d79fb36841783a1efda57d91a45ef27d5f7106bd68662bb9aad18aa70fc9dc554"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_4(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6d90d0ec3a3043ab5a42f3bf5c0e3298251c089b050a372e"),
		nonce:           decodeHexString(c, "62c90bfbe087b7ad6b94b7ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "72ae55f27c32d2dd2c4aa6fe85d50900c73c2e0f46e8e04de4f6a5b69969c70e27ee860e09619d26d34108d826bff285f796ee18abc5561ad333d310e6a3a957d9c92a4bef663784df1212997ba3e1432720e35b663630c3c612935a5d6779876200d9e3b4d06963bcc37366b0c40251"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_5(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5287978471d45ae1fa089b0def2d6b49b54be0708a8dfe53"),
		nonce:           decodeHexString(c, "e218dfbc430d4b438ab3fdf0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e38a48aa3a22c64d574c4f88cd65c6569c433c3d24454524397795030c6120a053768f0ca40958c40d6f53b07d8a43fd69eb0699c4143b7afbe297cce0562e5e881af715bc7d6d25a60cf0a94e50063836a6d91f5898b0a16bbc6739ea5307a0309800326abc2f9fc439ce2d229dce15"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_6(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1e9f424e39ee8e2a739bae6ec16dfa30855675cb23b2553a"),
		nonce:           decodeHexString(c, "28536e945486662c2c0c8b3f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0e0df3c867fe9d932801e4c2dbee521887097a93afbc0add63431f01d33dd8cff505ca80569f254f32791b8a7b08744c25b246a35ac9b5f2c271a27e17d6c45a8a33218bff749a041ff24f4ca49af70ee0cd131d66266ba7f48aac8c873273ad41b045cc5da575a14846d770147d0ae4"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_7(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "77002974c7bb8fcb393527eecbf58e200d11a9c420004508"),
		nonce:           decodeHexString(c, "f480a38a3ad62909321dad55"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "825902146cc12c31fce501eeff90d2a5ac5e08539c8d0e776aed57e6de0da7d781cb49abcc5f6b6a9242e892c3ea76f2a2ef02204f0b070ceb0a5c485a0e8e84b11efd0845dff3cde293c9c62c81c1118727fe698f3668611cd3846b0404c8b686e0d868b77f17ba9224bc3f58e865ce"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_8(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2a04f83196c1ea689c8a57f8aa6648a747eb2ba1fde550fd"),
		nonce:           decodeHexString(c, "cf4723d5ae1aa8a7e327fc7a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "43feb5a59648af2b23b95729d5387bf045dd918d6a2bbb49205f90aab25b20f6c7eb41f40c11e2665b310caaa67afbf4f7751ed911f55038f7e4393bca3004b0a0c7252fd60dac103b9b7ac2ead22ae4271ce52d67f8f406a5752bfe5197f2f44752984e59e6221538e78c63c9837748"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_9(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "21d8df582c9a17dc0d6df2d505c675a7ca2fa37fdaa8992c"),
		nonce:           decodeHexString(c, "dffd0d50506d5f4f572e825d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d7bc0ba5e60c8cf7558c4bc8a3e0405a913b8910f0dc935fc5acadc12149bb2deee1a5f80a81c7d902ee0bea8dfc7a7674f9043c3b29ea41504ccc2b240c1b01f66d363b03ecf52bdd2c5cfb29ce26a63cc162ffb66bd36c3cda913491dbf96ed960d1309b9256c04cb185210b861992"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_10(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e5e28d1d4887588fc400af05f9aaccb03be29cdc4c252bc6"),
		nonce:           decodeHexString(c, "1916a7c1e10c6758a48d5036"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0af6b14ea82c9b6821b7323d45a1ff3ee86f7929de4baca319a48b66e033190011e2293148b5a1b522a4c130acf983b2e87be798698cdf35fdab50629e7440594e7508f35e38a98a3f15b486b74c314b6eeb9a33eaf39e8033c0845242e07d8f1feb9fd45d32fe3195a7811057e6419a"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_11(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "79fc8f02948d201517b9946a255dd83f9b46048e38062351"),
		nonce:           decodeHexString(c, "5820501a892cd13ad820f522"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8a823efea75af7a40af02a0854d59b4244221099ac247ea28557a78e1ab67002d6bd6d9a85c92bd0bd48ea007e4ff9562bf4cf039d40d0e28c868d0967ea7ba50e6b90af4755999a9968827d8e8158f2c62ad97472874076640dbfdc1d3dd227b7feeff45fb2536f0d49c8328af4def5"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_12(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "df7d2599bc467eba6faf4d43c3b8034b81ef4a8ff2e5f7fc"),
		nonce:           decodeHexString(c, "879236a06a0a640064b09dc9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "23c77304f505fc3d25b4af24d1941d4ce8c04f122d22e1393177e9c75e5b2e11cb3a23bb889c44e750177f9c4fd0bbcd09ff3d6b580bfcee8982d742846145e1a44725a05b5ce31815cfdd90f59db8689373b8803f87253c22f036465c85a4b556ee9f8dea177d633906af53a6032ffd"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_13(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "49cfdcc0e60d5a39d5b1dcd889da0b791483aa73f4959a0d"),
		nonce:           decodeHexString(c, "22d6a6ce73d457bf2cd78013"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f880c0a1942c57065129ac7b4604ee4509f141cfdfc7e90ca2390b744f8169eef4a90d90f88d7867c5e6001bf58870b4ee29b83017c956e62f0895ac28631ca8f7fc9ff1c71e7f26643a709ebd2ef30f83f612824a94d3fe9f9845b814d817d48eaa91c246c4f401d54d94903d7d45ad"),
	})
}

func (s *drbgSuite) TestHMAC24_SHA224_14(c *C) {
	s.testHMAC24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c617061099a17392c3092d27728b35e59eb45814e9df9fa5"),
		nonce:           decodeHexString(c, "e1634c0d96cf91c53b063450"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f08234ed8621f1f551cf49ea60140313a71341f6886c484a06e74e64aba6f8ffc2cf1edd34cd93e836ab033fb0893e52e01da9b3104fe49584a45447c136222b1c1f1d3cf406a80ed9d782d2ae277790eefc5c06f954e654f7f283ddea79d2160cca1f63d0ad00eae9e882de34ba4083"),
	})
}

func (s *drbgSuite) testHMAC26_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC26_SHA224_0(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e839789d37a736a88d1bd2f4c87dd401cffeb5246a9f81ee"),
		nonce:           decodeHexString(c, "42c92fc6db45d2931676b2c4"),
		personalization: decodeHexString(c, "2086264c9ff9be5c2bf5318cae970635958166422bd14fa6"),
		expected:        decodeHexString(c, "b058f6a5b9836edacf1f83caec4d389189464d5b443f50f17191f94a0507fd905bf498340975e897f5e4ecdd6f6158d777139928724bada3d0f5b4f671f37869d58907af0ab9c70aa911101157983992d0d56d55801af5cc13084331268ebe6c0b5556fb97007bf67c48630f4a911c7f"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_1(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0ea2c82b18b911163b422282f9dac95b7dfaac5334d29b4a"),
		nonce:           decodeHexString(c, "6a83fea0e11425c05a24c0c0"),
		personalization: decodeHexString(c, "7532ca78cd321c48f7cbc2361c2446214970e0799e2acd51"),
		expected:        decodeHexString(c, "b155b82a6780d690821ed8aa2a73d058dec1b8970872625c8ee97daa47bf5af9f5e27a89a06b988afb128acc76208cc6c497270e323c740a8a20d35b712f4771787521350500872228ced8b999062c546121bfb778b4e8011bef854122fb82d6d45b9a0d3914d7ca7642d3de76c26996"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_2(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "dec13a7cae49d037ab66a93030bf0616eb10f2bd6f3f136e"),
		nonce:           decodeHexString(c, "fbdfa6b3fbb3d8a27f01ce19"),
		personalization: decodeHexString(c, "882a4db945637535726ab8f189541a06e9d2d8f0cd592908"),
		expected:        decodeHexString(c, "a0a2a590abee813c6374a01f28c4171553fa9f99167bf0d7ab01a799b4b6d8f3a2d662f08ed819367e442d5a5ada040e45d1d076a5cdedaface5f476011cb3d3ea9940733a68395188ceaf5352218c08b97b4e4ab6c912345d96684e49c2e0fa6cd3fac867c226e35301ca1f8eb112b7"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_3(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3356b274b94d4c72eb99daf36a9f40f4f31fb5dfd8930e81"),
		nonce:           decodeHexString(c, "c61996d830020a6044235817"),
		personalization: decodeHexString(c, "c304ba70a1ac4295aa7a932f17d0a3334ce383c644e2f8ba"),
		expected:        decodeHexString(c, "94b23e0d02aecead7adbc6dfff9243cb2a38771e919b98b9a33f9cd5dddda7b80aa5e9916fa698c72e2450b5795cd7539af03a699f91ff68dbe48423c0bb00f906da678649c1cf1af55aca64a57fd419d7a30fd8adf69a8c35c185dbaa921787d5c00187e172124ab42354bffe308431"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_4(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "19382daebb9bc8406913ca5350e8392b3bd8b283016c77d7"),
		nonce:           decodeHexString(c, "d23d79e1dc3117f287d23038"),
		personalization: decodeHexString(c, "b6415d575baf6a14141a36d7e9c998acf578140064d998c5"),
		expected:        decodeHexString(c, "96789132c221902c8f3b7802707177dfa69f101141e3565b6863935cf3ae7d5f952f0d5a737bed690a714f3098613b622206566bb986209e1a3f00fe24670b3b92c989224cffbebba02dc0d09c162cd9a7afe25c034308bc819278dc9658a8da59fca2272baf293f8e27e186d9b932df"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_5(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5434ad8f922c1c1c93d5fefe9bae2f8fbe12eb3396680e69"),
		nonce:           decodeHexString(c, "dd340b0f6317efd7bb01390c"),
		personalization: decodeHexString(c, "1403781717b3adec9299526de1e5fe76b93381b82c267204"),
		expected:        decodeHexString(c, "2e857bffc0907280cee3cbb6b9f16822147eb2cb2afcf576c9987e0d1c485bcff8fda87a371e1681d9a584fa447b4cae4e37af7429c798753d4e2acd6307faffc7db6a0b81c069c71eab5922ab6e1872cc0c0f0528605152a7835efb5325c11c0dc9ce9e00740c8f2e403943cf8bf893"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_6(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0cc10da97f81d9cd41390743e773edea0242b0decbcadc43"),
		nonce:           decodeHexString(c, "0057c20913afad8217178dba"),
		personalization: decodeHexString(c, "56d0a8710290cdb8f41aa12980c45b5f146c705ed75058bd"),
		expected:        decodeHexString(c, "e3897fee70be31a5d2223ac779f22902cbe76cc2c0f337f62d039cafbf541a23e0c8a4844853a671a587cc5348775247f833888443087cd402ddbc27786297ae7de5bf14ba1d2265d024eb4c11b53045b5adb186a4523b6fed3a28e5c7eeba4f8bf41322c72630726df7f6913226ec86"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_7(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "012474a6f096a70e3511343211106543a9cb3c6be46deeaf"),
		nonce:           decodeHexString(c, "31ebc4871a83dbbc0ec9602f"),
		personalization: decodeHexString(c, "fa3722640fec20fe71bfaa70bce50a6a35427b9ebef86f51"),
		expected:        decodeHexString(c, "784c27824d81cc95d3a307b7e65614f446682ecf9762e06854539c3367cc09884b3c4642ebbdd7b0cefbe5b83b4f22bd52af20a60e2d9bf0ac2b9203059a7b9d3f6de40c6dd8f1a84d915bbf0164e07be5a80cc1ae13b1d6375aacda9dc469dc3f7aea02be1db0a8efa0009bf08d0a8c"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_8(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ea6de830cc196b848dc7c05babca7da34a4f266b6d6e7f78"),
		nonce:           decodeHexString(c, "2b65ac25291f8140482d73d4"),
		personalization: decodeHexString(c, "6d8c625e496022ee09fb1779d3dbc07f0e1be6cfee78108a"),
		expected:        decodeHexString(c, "8e412b663a83ddd7aca7d9f118687fbba248ac0224fe4b6e1e8ab2e0e3553fb599f0c5d1f3883b178ae121dec34f27d89426f924de4f6a82ccaee6b5466bae13f14d3502e22c14215d1b71bf74feb8ab75343d228c3f083d8b3f4a355255cb286e17899a4f516a14beaf3d1e6dcbe1a9"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_9(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "20121d0ed093ddbbd1c400ec51d2c0f09488bd32db654c89"),
		nonce:           decodeHexString(c, "9a6160e20e6b1bc4fd00ad5e"),
		personalization: decodeHexString(c, "3ee55b010e4449b799626de4e78f11b1f3ba66c95c171d81"),
		expected:        decodeHexString(c, "bc7bf567f09e46cce33ef5013630024ceaed8d228b28577795fba73d539fa61b339faa0c3e91ee2789028016e723b82bda514f501bd585e57de94a02f31bbe7cbe160504cc28f84e96c13861fd93337d6eb61d78632044ec6f8dfaaef906d4cba9b511e8d40efb28d9c3e8962e097b9a"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_10(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "398c932ee4b1aa6503e6ab9f921f2b8340bfb208181427f3"),
		nonce:           decodeHexString(c, "029380cd030e5a2240276e61"),
		personalization: decodeHexString(c, "8908bff3d5d20051990e9419c168816e7b503a7d611cbf05"),
		expected:        decodeHexString(c, "302be094ff9249e2774cd22bcce924989e85ce7a8f23f247627908bb7ee72641ff0d21cd2ea2ea89032f73d54aa7c477a994083775fadb9789d46c7048309851101fbd70adff9535c050895f6213585ca2a69bf7d7b293ea183f3e2a3c6019289e0b5aed998e246090af0e00c26c0ef5"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_11(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5a3a85d2b93ca4bf5e37960da12b01ff5331d055a439e755"),
		nonce:           decodeHexString(c, "ea3934c6d853e6b210003157"),
		personalization: decodeHexString(c, "c7578c21d72479fac2ca4e09c946596dfecb4300f36a5aa3"),
		expected:        decodeHexString(c, "c58f3a02b2d4733d304bcfa41fd4fa420a1c063e221cf95d993a6fb941bed1b8ddfc2ee6a4d0ebdab393297b262cdda33a5723d9375be1fe6eb1bbc72360c381f2e6baf42ca72ecdfd5b63a8276c3a4b08c81de482f9e1ce9e28719548a7c32a676976f8b0a5726539527844c00daa3c"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_12(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4257218dc21a8e500cfcbeb8fa6fb0e3a22872d257d84514"),
		nonce:           decodeHexString(c, "1760652536bd7cbb5f0a118c"),
		personalization: decodeHexString(c, "dff57346d46a35df1303fe5f07dc71697d56e7363721f006"),
		expected:        decodeHexString(c, "f6bc7b9253f24ca334ba0c32daef8c34aec4b41b624dacddc9b8ca282be67eb0c61e992756007fb7fb7ab62de86cdb42ba8c003469ed013f3dab8dfb2569b34e69cbca52f1b562fed469f064acfbdea0ec2daa3cd8b767768f6d593c5e0cd198cc3ed6ccb8d6eac531a2e63aa5fe6e0b"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_13(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c45ee677a9b6888d24ac4cc87e88843274b34866ef7d73f2"),
		nonce:           decodeHexString(c, "4966f9a2c5de62ae383f9438"),
		personalization: decodeHexString(c, "a8d68661608d4f7114a8f7fcb94db2db62f23626514faa82"),
		expected:        decodeHexString(c, "0a4f8cd2ed510ddbd9ef73f6277884ababd61d60255a7f874f3559a22d137b882a7a56cb8ed471bdc82cf652ea401678ea412661a1a0637157f75b0fcb8347d073a2a5798cb7ec7843dbf480c5e9ccbbd8a2963e4a2894a9ee6aa229194859abc1119741b99230637665108b822afeb4"),
	})
}

func (s *drbgSuite) TestHMAC26_SHA224_14(c *C) {
	s.testHMAC26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3d313cc63caba556d7601cdefa066fced1073d661a95046c"),
		nonce:           decodeHexString(c, "fc382061e29c4047c6f05dde"),
		personalization: decodeHexString(c, "9b2eaa4c2a229cd2bc5de218aff95f6e5fbc7ef150bdb50a"),
		expected:        decodeHexString(c, "ad49119d6b4f25ba34050920fc503d3d0d331ac2535d916a58d781317fcc2b1117618e9105ce192651ea9e19fa6756975d207c662f2b464416d849cb67b9af52abeb84f80863943af99c7916e78317a091ba90714ec8620f661b41d648c15c06e822329cd7f145446c5c3630a4243281"),
	})
}

func (s *drbgSuite) testHMAC28_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC28_SHA224_0(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "476f962c4eeb614164d362c0017c48a43fe538feeea16ea5"),
		nonce:           decodeHexString(c, "51e3de54f3f2d727aa76976f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0293a8d499efa54d6a532b3b7e3a559cab82974072a4eb0d8a07e2944fa2ad7f067893646cadcf71813f38338551c26d1ea746a7313ac42a7f86384f20f33642effbf49339302702d4c0f4d1d83eb4e75c59d2e3be3c61f02bcaa3da262a72e81a8670059a004404fd9439e40419f713"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_1(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bfe84885903801c141d5b8ed54944d3f98190a7045f0cc0f"),
		nonce:           decodeHexString(c, "8abd859c9bf0708b2931470b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1bcd70dd666931f79b4a75655f729eef2e2ae2967ac299340df8766b6b18aea96c458ff98324f10d8427966dbf32a1bdeac1bb18fb2bed59903f4c451b10ea3f6d75589563d7b2bf5ff7ba8aa8d72d262b55696c218be577aacd1c36035578f23d3f1a06e8ed0e6e396b82bf228e2c6b"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_2(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "db5496a9249f4ffb57ad68cd8cd591383e776fee0ba209ab"),
		nonce:           decodeHexString(c, "e0623333ca49346613f6641f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8a7df25b58ddb89a8fba79a8f81961cacd40d165fff1da1f6442ec4d9115a2f32c57db0c696b9fdf02c45040d3e06f39b3164253a8784f173f0a033bfa3c62b7285fcc43f9d748e3ca5f126b0736488b9ab978234f3c5810fda543e371c9afadf0b4a50461f1d7b4aa6c9bd5553a008f"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_3(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bc563959caa44290cb41372e9fa7a5f26700af7ddada3261"),
		nonce:           decodeHexString(c, "c0a014fcae7ffaaa7f7a300d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dbb3be4c1413680aef0f240b7b7f75e96fea98a39591ad44153ec332b2f13480ba4d3cfd93f0d2ab849fdc19389475a4e9462f56d85937a58813a076258470fcd0883e77e24ef8f67b0580a0ae14ed446620fea0eb71b60b1b70d6392711f0427c319295a6bf96b5cc52e4e570fefaca"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_4(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1e8f4da6355c99108b8ad988224db84ec915e3050a9d8079"),
		nonce:           decodeHexString(c, "395656aca928e3ddf4e3a609"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "da7831295a245a683653717735e5075e86d8fa2e2fce6c78181830e79fd1ea28cc476ae2a313ac50d5f20dfe191f3e77ca6222ddd2beb06a7429ce3f02059fd4ea6b48e12ec7b2b4a8dad880d97db892c1e070eb954953f7a4a1fd79530dd6809d2cc45a6fa91bf38568debaa2d8326c"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_5(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c179157f5943260d6ca255b347020f467b94a435f60ba699"),
		nonce:           decodeHexString(c, "c5a511e14773972a65803904"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1d508b40acbc6316564bb9758495100ae265f34a9b32969cac46b250d2016f65152886da59801890e1e4af0f673e5cee3755e5be09d6121679577bc0a11ecd76de3f1a8cb7a88023b8c543bde38893adb3d2d73806fbcf4a6460b8da68f6fb81d7f1939ab5f6dc8f52e9c4a30a610f63"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_6(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a67549626af635b17a9d9f876a9f609f2faaa685e1d8dfce"),
		nonce:           decodeHexString(c, "a9a089e1cd938fc52d3fccdf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "999af9cabf96856d33f6c76d25fb7e26aef3a7b9b7f4ee95a378be081c3112db71613a4b157fe41adc99f036e2661ba623b95a1de71f8c07144dafe46788c152419f9242b92581f23bd179e975eefe4f87a793f2643c49faeb993271efc262b08c97b67fdd507973a34b2c0a5d35f414"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_7(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "89f7c49a3b568d133c4552018ae715d0b1c8875fa8e27636"),
		nonce:           decodeHexString(c, "21f9dab09392e7fa9d3fabc5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "300c2e55e78e8be8faa8904bdd1bd567a0d3531ab8daf479370d0121efdacfda8fabed4e78dfa14a42ea6d2c9677f6c7d475777731ce4f0f21bb3b1c200f843609d2b05d1a02a256c318cfb4d9aa38a8768135eaf1be100e86740e48381f98715b4ff397e2404fe833cdd21988c0cf7a"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_8(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a7bf882760aedbbf6f4e9cdd90698aad718b095e78ee940c"),
		nonce:           decodeHexString(c, "fbeae860ac5ea09d878e2977"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a091a067ff1e9ac2576b4a449796b7e8a0870a836077b6197f30c5bfe45ffffad6df0c1466b303b8521feb80a9a6910df93548d5d841fec1194e4c3c9bc59675007becf16c2b144e3304bcc4711a059e9687d4c1b3b09154565d2d3cca7946d445551f279f0e31b6afc9d458cb203c1c"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_9(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "65112a896f101f7bdf37773f0f238a9899a82657dc67e0e4"),
		nonce:           decodeHexString(c, "111f4f73f43c7852f3679d0b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e3c38940a1a53b3ba2fd18a4eb7e86e3af137863afe89b0af7015a1d6381cb994a97dec587e71576b1cab739bdc3a30d95bae3ac392fa517b4681ea1716bbbe44b40a9637e7bf83e1d2c89af1517d1e7598a4204917f6428cd49bcbda600fe2257874047c11d19a821b1bc3c0fff32e9"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_10(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3b00c75d70cfe93077ec922fb551edaa872224eb555c8b64"),
		nonce:           decodeHexString(c, "b15f67ca2af303e987256bd6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "35532bfee8f3cf34a998b3b97b5d2cf2e81d7c8862c60495c8474911b555131a3869b2033e439743460cc5c0daf4c914672d6ecdb5888a89813f58f950f4c1e91a8cccd76f641ee7762152fd2e2151381a2dded48b62298eff2b2dcf50e2631224a8480aa4f2777b9be75c903ce5105d"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_11(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9208f66adca82cf2493939e3e83e07599be808745059bc2d"),
		nonce:           decodeHexString(c, "91a6fad948f7823aeed70421"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4bd4e563081f6a8c07652991ce764a472d58788f137646be0737e7204ee13c3ffb4f4a08a88b2e1ed1fdc9050fa001bb83b2bb48faf0ff4a33b571f9508df26e5d5a84a8fd90b7f5b288493d18046067c01bbb30548a52117192895e0abf996ec676e148c3d1013a3df4052fffc7b6d0"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_12(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6616a7ac20360142476c3cd2edad8ab48e63266d18eb8472"),
		nonce:           decodeHexString(c, "a203dcccbdaa50c88555476b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e252d1fac3d3f356480eebb844f2cb8d2345ee0b069055cdf860142a220d820d944911ca25f9f5efc50a1a89f74d1ac078106ffcd5b073420f5049e32a8680a3e6b5d6c48703a67e0b8cf867ddef4f551447b4a02be59203b8938d88c902d38a94e67526e0a9df21c8b41ede44c640e2"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_13(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cba637ea1b6ebe05a14697e396b94df920adf1657b3fbc54"),
		nonce:           decodeHexString(c, "92ed0d7aa82507091a6de29b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3a9363e56704f53978f2b30888d9ba88034fc0acc4144ea4129035f7ffbb52e84c1847b3777182c132ba50092d15a29a7ea784eec8cffab1353194846e22355782cdb479e5df62d3a31978d01ee8fb23c76704e416bd0955e5007bd41914783b406607293577e42716e74e3fa81f9db9"),
	})
}

func (s *drbgSuite) TestHMAC28_SHA224_14(c *C) {
	s.testHMAC28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "47f141d1d0142d53c10628d2d1dd77aafc11ffe45f29b126"),
		nonce:           decodeHexString(c, "a1e958e036afd40059ce9639"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2096935329ffd975154c38a2c22e30ef12b7acbacd39868032d6eb31a596e617fc7e05026b3dae231f256ea94dd4ea4f05734eaa7916be6f846b0304ff0de389f3390e51641103e7dedee99e56d9455c80a7e10edfd2147a50b3864b05443a1646fccde2197af1d1d72ae3c2d4594218"),
	})
}

func (s *drbgSuite) testHMAC30_SHA224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMAC30_SHA224_0(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ec6d04a3c5e5fe627f143eccae0df8051d130e1ebcf3f7ef"),
		nonce:           decodeHexString(c, "aef3d3359581b8f21aa01856"),
		personalization: decodeHexString(c, "d8ab28a3527cd2bbcf40770af6ec5546870cec6511c2d97d"),
		expected:        decodeHexString(c, "8d98f91d2e9acc94c1d9cc1662a1afd58addbf0dedc13a006d2cdbaa9e0df0e98b78f9ff5d893549faf3364c68282cecd2a31252c598d3514732463b6d73e7e972fabe0ba2d8a754bdeaba3b0e5ef1035fa661f6f62e5f8b1161ac351084b50cc1f75deca2a90c9c77c458489a5e1954"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_1(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f1d31fe67dbaf10a0e4e6a97d4d643ce773be7e2a0013ac6"),
		nonce:           decodeHexString(c, "2ee61ba2a50b6db2a324e42d"),
		personalization: decodeHexString(c, "4b1f2056519b4439acca3f28e7d973c517c096c310e362db"),
		expected:        decodeHexString(c, "f5acd8efdf29fd6e3b0b16dbe20b71a6c5f735252c4951c06bc70d57ec21ada417ecadb1317a6fbcc074a8e3c7e2593a550b3071394048076ecedd8bd798323b2fda1a6257b39dec8aaa4ef048c96a20b79016d54037ecc8f2568c4f338f635a7e0405cb21554bd4cb8d4037c1af638d"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_2(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ac3fcb2b468aaaf59907f5e77a607c9401bb2b23fa4182ef"),
		nonce:           decodeHexString(c, "be792f858062ddbab75ed0ad"),
		personalization: decodeHexString(c, "6206da440125f222c8e532b2ea4f9ff4f1188bd7154af10e"),
		expected:        decodeHexString(c, "aba4944582fb65ca07b36f8540d7778bafcbeccb33261122e723c4373307f4541e4ca8b6c65eb57fae6138a42579954deb515e4d3aa31ac2e64246216a15ee4b4d8691982ebfb01552a354c0b946e196406ff12cbe8d8610311979377670ab27e9f07a6fc85ef97937322a791ef014cf"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_3(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "32283a9016b6689e23fd25b7f25d6044560218555a382a2e"),
		nonce:           decodeHexString(c, "a7b0d3f0554c275b17409e77"),
		personalization: decodeHexString(c, "c91a407090e025d17472f9bfea67727039e807b11711f1ba"),
		expected:        decodeHexString(c, "89cbd90018d8bed92e13f2f8e3553ebbc7d92ad9f9a2b522142f2d2fc9ba21d51743aac00f9ffc8600a923f241fe07a552096b20dd871ecb952d6146550deff5333f575146b98b87a86def57aa767c0de5d449a60cda8cd097d6e7ec426fbcbe6f226a7abaf4886e06cd7198465d9806"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_4(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "27aa5a89bfcbc8f45d630ef7039235a1491270b9ee12b1fd"),
		nonce:           decodeHexString(c, "25e2db1c4a48822932282d4a"),
		personalization: decodeHexString(c, "a7cf93362700094d138a3480f6d346ff43857a24cd5e57e8"),
		expected:        decodeHexString(c, "40d5a08d16ec7c88fa6d30045564d2dd4c34de6c9b79f5d0bf88733bcf1dbd20937d83385a4d2047c4f2667827747aeb4c9278f1bd995dcd7e9e1bf82b0b2561fb81ea5af2985a848ad585e6cf0a70d8b8be124b6428f7ded06dfe592e01d822bb594eb1914a8ab96896c21c1692eff5"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_5(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b4b85e046f08dafe63637c4850bb7948f250eb1bbd7b2d5c"),
		nonce:           decodeHexString(c, "7dd564f0a77bda9ffc15fcbd"),
		personalization: decodeHexString(c, "8913bdb42fe26b3568d402ab311201df8219071789d67f3c"),
		expected:        decodeHexString(c, "1e5c96141a57e6ae1e4e38256987429d9fd66242c0163f224b2e2b4668f20a26ae7ae5429a91a2c2dfdd187b5f48fdcd193e5031f359f91e7e5966d71d8b4f69e390b5055e794d99a3713d6629fa21603a07758ebee379625e289a2cee34676ca1612b953e4e0804016ad87332a7c200"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_6(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "50868f3a44ce812f81b55d11921834474d8ccb6c566f666f"),
		nonce:           decodeHexString(c, "88c16a2e721057136deaa738"),
		personalization: decodeHexString(c, "fb2ee927dcbe7e354720680ab0a2f654d37e75801c46367d"),
		expected:        decodeHexString(c, "345fe914a47637aa9188b30286fe334bb4a535ff59eb3a3773c6788a8f23a7a0a327885d02e0b99c1f7c20c80f945cc267e24d21ce2f1d672dedc65efb7dbc8170f18f05ffa092f8f46981db2fdd3b09083f846baa8a42cc5507af521661d821278694ef387dc71e39f4dd6fc334f09e"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_7(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1de742d420194d35cd22758dd9af62dd2616f922876d2815"),
		nonce:           decodeHexString(c, "d815e56f7227afc5d2b8bbe5"),
		personalization: decodeHexString(c, "f9cae04f2795bebfbfcf216d5bd9504e56e3708c87328106"),
		expected:        decodeHexString(c, "9407f9d4c6e9c87f457f3b8358eec03fade91b2ae164c5720167bd6e2b79341a05a2bee108fe9412d2d5c2b8dcd9d8973935886ac32eb030bb937e8b4023950fabadbe14d6395df3e88181d504e9337b39e2fad7428e100758780941f216b03122522ac54468417929a8419a52e8e6c8"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_8(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7ce6f11c25232a389a729ca6b348fe95e40b6d0d7b635a7f"),
		nonce:           decodeHexString(c, "507f510c0c4ca5b400f52ed3"),
		personalization: decodeHexString(c, "4c5f000a9bc259a30dfebf0a94cb46db36599df5f315366d"),
		expected:        decodeHexString(c, "70c016d2aa32ebe0dc02470cbc9091f49e626c835e651e456590d5b012dd0ad52e12eac46ce3a7ac06995bdebe44e51a6de373f5533004ceceff34ad26ac2f3959d0580ff40076dd193c8e3ddd3abe1353dd8280b7856944437aeb7a8444ddbb8e925c23f08f35eda55a6198eaf88a34"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_9(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6536fa13cfbb49ebc28daf8f4afe32eba911c855c7720b7c"),
		nonce:           decodeHexString(c, "eb6fd6d465013e0c09fa01df"),
		personalization: decodeHexString(c, "8e97deb1da5c91712ab3fcd6b2a3d2e2cf7ad121e21b6180"),
		expected:        decodeHexString(c, "348fa39ea0377d1225dfc5dbb742af1edfbb9a6bd6dfbf2a5084a351dfa04a002676931ad738ec6786ca5b1e4cef0bcbf10c6971ad8975e6929b2d9f6662e8adb95c85b8c9779276195f6a05a230ef2f1788443c959a665ef54a43142fb41449e5e4d72b7229f9635de0327354744a6c"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_10(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "098b2473b93ddbe231bfeed3189847a312bf31be93fcc133"),
		nonce:           decodeHexString(c, "42b193b577d8bfc1e0395735"),
		personalization: decodeHexString(c, "812cf649617f0fd152463cd898ebcbb9a95bff1ec387b9e4"),
		expected:        decodeHexString(c, "da4d2352096ea715bdf6ae24dbab334611e01153d1e0a18e6b70dd3f72bb644f00ee4f01e9616313fdeb02c9df8823d1a36e6c85b6c05383ec44cedc844c5647ef234fe67e1626831e8c3267304c2ee212383459dd9e2d091c014dab7689efa371cabcd950b13abe1b6e818122a0982b"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_11(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b6d5919c608b3fa0996f48f1051769e94519ece1375df47f"),
		nonce:           decodeHexString(c, "fee339b6117011a67777f269"),
		personalization: decodeHexString(c, "ed9ac05d62a4edbb359a4e80d4ab52660cf6d54f6e966745"),
		expected:        decodeHexString(c, "62f982f99136763a48abe593acdfe63f485ea69e6b0d2943f2982a5eb1c874649cd39cc7fe82b1ef385d0e66236234ff3e2f584c26a7f21cfde83c32689e125e52a6a53f8cf2369bdc6a6800d731f9df627291bd312dddd9b03e02a2e73f22700ac02b91f28353c90a0a3d941f4ea623"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_12(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "48e12559a63a103b22c4a0352a419e481b7f7a91d300a4dc"),
		nonce:           decodeHexString(c, "82a08743cbe1d070c61e5af3"),
		personalization: decodeHexString(c, "65e365b9c5ea8781e4a12bd74902f3702f6efb1cfe5b25b6"),
		expected:        decodeHexString(c, "6d86e32d1d7e4a7e4e87cb6970e09ac7e97ab35283b63a241378c417632aeddfa078decddeb709624f5912bf35e0cc11dde63b317f1694a9b6fd9533469a1649fd9310bdabd5faa02f8048826eb8d3fafec63a0d4c9cb221b35a92c3f1f50d9efca23afc5b5f7553e9bf6100f0ac42dc"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_13(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6009f2c9e3252a92663cdcda8116da1404d62078a6f1a124"),
		nonce:           decodeHexString(c, "49bd6047cdf3ad23323da8ed"),
		personalization: decodeHexString(c, "26c90b6cba78c7fc2e3a64f03f280a6b6d0e5bfafcfa977b"),
		expected:        decodeHexString(c, "f28b4424f6f7059f1741e600b88d9b2e1fd5f2e5cad1b121b886f00af6f1e10d337cc1b5a3b3b5ef6aa755f2160a66e78d841ab193e44ab90236e59855be7cdc9b71c63702f4c2bb6f15a8050b5d731c1a67c6deb7764fe29d6825e19009ad835f95015f7559bbb0e042c3e3867c9fa4"),
	})
}

func (s *drbgSuite) TestHMAC30_SHA224_14(c *C) {
	s.testHMAC30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "337343cf9fccf15a2bd2d7c6cabf6321e1a270250cbad4d4"),
		nonce:           decodeHexString(c, "82dfae196513724ae269204e"),
		personalization: decodeHexString(c, "6e01d897ae919812b8408f82edffcfed8db6df2e2cbebd95"),
		expected:        decodeHexString(c, "6e9bebf2e54d8da4e8ede97ce463239245ff1b021acf4441312ddba96d1f3d750bf2b9583a8aee76e2ee36a56d8e2fd4e11377d15ba3ad0876fd467c375a744240de0a7b38974e0e7b27c3917ce4e22f2bc78861f6f8b1fb42edbb1b0cb869fe5169527064cf2f38c0154082af5457bd"),
	})
}

func (s *drbgSuite) testHMAC32_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC32_SHA256_0(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ca851911349384bffe89de1cbdc46e6831e44d34a4fb935ee285dd14b71a7488"),
		nonce:           decodeHexString(c, "659ba96c601dc69fc902940805ec0ca8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e528e9abf2dece54d47c7e75e5fe302149f817ea9fb4bee6f4199697d04d5b89d54fbb978a15b5c443c9ec21036d2460b6f73ebad0dc2aba6e624abf07745bc107694bb7547bb0995f70de25d6b29e2d3011bb19d27676c07162c8b5ccde0668961df86803482cb37ed6d5c0bb8d50cf1f50d476aa0458bdaba806f48be9dcb8"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_1(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "79737479ba4e7642a221fcfd1b820b134e9e3540a35bb48ffae29c20f5418ea3"),
		nonce:           decodeHexString(c, "3593259c092bef4129bc2c6c9e19f343"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cf5ad5984f9e43917aa9087380dac46e410ddc8a7731859c84e9d0f31bd43655b924159413e2293b17610f211e09f770f172b8fb693a35b85d3b9e5e63b1dc252ac0e115002e9bedfb4b5b6fd43f33b8e0eafb2d072e1a6fee1f159df9b51e6c8da737e60d5032dd30544ec51558c6f080bdbdab1de8a939e961e06b5f1aca37"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_2(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b340907445b97a8b589264de4a17c0bea11bb53ad72f9f33297f05d2879d898d"),
		nonce:           decodeHexString(c, "65cb27735d83c0708f72684ea58f7ee5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "75183aaaf3574bc68003352ad655d0e9ce9dd17552723b47fab0e84ef903694a32987eeddbdc48efd24195dbdac8a46ba2d972f5808f23a869e71343140361f58b243e62722088fe10a98e43372d252b144e00c89c215a76a121734bdc485486f65c0b16b8963524a3a70e6f38f169c12f6cbdd169dd48fe4421a235847a23ff"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_3(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8e159f60060a7d6a7e6fe7c9f769c30b98acb1240b25e7ee33f1da834c0858e7"),
		nonce:           decodeHexString(c, "c39d35052201bdcce4e127a04f04d644"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "62910a77213967ea93d6457e255af51fc79d49629af2fccd81840cdfbb4910991f50a477cbd29edd8a47c4fec9d141f50dfde7c4d8fcab473eff3cc2ee9e7cc90871f180777a97841597b0dd7e779eff9784b9cc33689fd7d48c0dcd341515ac8fecf5c55a6327aea8d58f97220b7462373e84e3b7417a57e80ce946d6120db5"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_4(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "74755f196305f7fb6689b2fe6835dc1d81484fc481a6b8087f649a1952f4df6a"),
		nonce:           decodeHexString(c, "c36387a544a5f2b78007651a7b74b749"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b2896f3af4375dab67e8062d82c1a005ef4ed119d13a9f18371b1b873774418684805fd659bfd69964f83a5cfe08667ddad672cafd16befffa9faed49865214f703951b443e6dca22edb636f3308380144b9333de4bcb0735710e4d9266786342fc53babe7bdbe3c01a3addb7f23c63ce2834729fabbd419b47beceb4a460236"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_5(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4b222718f56a3260b3c2625a4cf80950b7d6c1250f170bd5c28b118abdf23b2f"),
		nonce:           decodeHexString(c, "7aed52d0016fcaef0b6492bc40bbe0e9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a6da029b3665cd39fd50a54c553f99fed3626f4902ffe322dc51f0670dfe8742ed48415cf04bbad5ed3b23b18b7892d170a7dcf3ef8052d5717cb0c1a8b3010d9a9ea5de70ae5356249c0e098946030c46d9d3d209864539444374d8fbcae068e1d6548fa59e6562e6b2d1acbda8da0318c23752ebc9be0c1c1c5b3cf66dd967"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_6(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b512633f27fb182a076917e39888ba3ff35d23c3742eb8f3c635a044163768e0"),
		nonce:           decodeHexString(c, "e2c39b84629a3de5c301db5643af1c21"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fb931d0d0194a97b48d5d4c231fdad5c61aedf1c3a55ac24983ecbf38487b1c93396c6b86ff3920cfa8c77e0146de835ea5809676e702dee6a78100da9aa43d8ec0bf5720befa71f82193205ac2ea403e8d7e0e6270b366dc4200be26afd9f63b7e79286a35c688c57cbff55ac747d4c28bb80a2b2097b3b62ea439950d75dff"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_7(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "aae3ffc8605a975befefcea0a7a286642bc3b95fb37bd0eb0585a4cabf8b3d1e"),
		nonce:           decodeHexString(c, "9504c3c0c4310c1c0746a036c91d9034"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2819bd3b0d216dad59ddd6c354c4518153a2b04374b07c49e64a8e4d055575dfbc9a8fcde68bd257ff1ba5c6000564b46d6dd7ecd9c5d684fd757df62d85211575d3562d7814008ab5c8bc00e7b5a649eae2318665b55d762de36eba00c2906c0e0ec8706edb493e51ca5eb4b9f015dc932f262f52a86b11c41e9a6d5b3bd431"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_8(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b9475210b79b87180e746df704b3cbc7bf8424750e416a7fbb5ce3ef25a82cc6"),
		nonce:           decodeHexString(c, "24baf03599c10df6ef44065d715a93f7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ae12d784f796183c50db5a1a283aa35ed9a2b685dacea97c596ff8c294906d1b1305ba1f80254eb062b874a8dfffa3378c809ab2869aa51a4e6a489692284a25038908a347342175c38401193b8afc498077e10522bec5c70882b7f760ea5946870bd9fc72961eedbe8bff4fd58c7cc1589bb4f369ed0d3bf26c5bbc62e0b2b2"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_9(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "27838eb44ceccb4e36210703ebf38f659bc39dd3277cd76b7a9bcd6bc964b628"),
		nonce:           decodeHexString(c, "39cfe0210db2e7b0eb52a387476e7ea1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e5e72a53605d2aaa67832f97536445ab774dd9bff7f13a0d11fd27bf6593bfb52309f2d4f09d147192199ea584503181de87002f4ee085c7dc18bf32ce5315647a3708e6f404d6588c92b2dda599c131aa350d18c747b33dc8eda15cf40e95263d1231e1b4b68f8d829f86054d49cfdb1b8d96ab0465110569c8583a424a099a"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_10(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d7129e4f47008ad60c9b5d081ff4ca8eb821a6e4deb91608bf4e2647835373a5"),
		nonce:           decodeHexString(c, "a72882773f78c2fc4878295840a53012"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0cbf48585c5de9183b7ff76557f8fc9ebcfdfde07e588a8641156f61b7952725bbee954f87e9b937513b16bba0f2e523d095114658e00f0f3772175acfcb3240a01de631c19c5a834c94cc58d04a6837f0d2782fa53d2f9f65178ee9c837222494c799e64c60406069bd319549b889fa00a0032dd7ba5b1cc9edbf58de82bfcd"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_11(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "67fe5e300c513371976c80de4b20d4473889c9f1214bce718bc32d1da3ab7532"),
		nonce:           decodeHexString(c, "e256d88497738a33923aa003a8d7845c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b44660d64ef7bcebc7a1ab71f8407a02285c7592d755ae6766059e894f694373ed9c776c0cfc8594413eefb400ed427e158d687e28da3ecc205e0f7370fb089676bbb0fa591ec8d916c3d5f18a3eb4a417120705f3e2198154cd60648dbfcfc901242e15711cacd501b2c2826abe870ba32da785ed6f1fdc68f203d1ab43a64f"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_12(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "de8142541255c46d66efc6173b0fe3ffaf5936c897a3ce2e9d5835616aafa2cb"),
		nonce:           decodeHexString(c, "d01f9002c407127bc3297a561d89b81d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "64d1020929d74716446d8a4e17205d0756b5264867811aa24d0d0da8644db25d5cde474143c57d12482f6bf0f31d10af9d1da4eb6d701bdd605a8db74fb4e77f79aaa9e450afda50b18d19fae68f03db1d7b5f1738d2fdce9ad3ee9461b58ee242daf7a1d72c45c9213eca34e14810a9fca5208d5c56d8066bab1586f1513de7"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_13(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a8e0bd90bdb12f7748ad5f147b115d7385bb1b06aee7d8b76136a25d779bcb7"),
		nonce:           decodeHexString(c, "7f3cce4af8c8ce3c45bdf23c6b181a00"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "320c7ca4bbeb7af977bc054f604b5086a3f237aa5501658112f3e7a33d2231f5536d2c85c1dad9d9b0bf7f619c81be4854661626839c8c10ae7fdc0c0b571be34b58d66da553676167b00e7d8e49f416aacb2926c6eb2c66ec98bffae20864cf92496db15e3b09e530b7b9648be8d3916b3c20a3a779bec7d66da63396849aaf"),
	})
}

func (s *drbgSuite) TestHMAC32_SHA256_14(c *C) {
	s.testHMAC32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "451ed024bc4b95f1025b14ec3616f5e42e80824541dc795a2f07500f92adc665"),
		nonce:           decodeHexString(c, "2f28e6ee8de5879db1eccd58c994e5f0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3fb637085ab75f4e95655faae95885166a5fbb423bb03dbf0543be063bcd48799c4f05d4e522634d9275fe02e1edd920e26d9accd43709cb0d8f6e50aa54a5f3bdd618be23cf73ef736ed0ef7524b0d14d5bef8c8aec1cf1ed3e1c38a808b35e61a44078127c7cb3a8fd7addfa50fcf3ff3bc6d6bc355d5436fe9b71eb44f7fd"),
	})
}

func (s *drbgSuite) testHMAC34_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC34_SHA256_0(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5cacc68165a2e2ee20812f35ec73a79dbf30fd475476ac0c44fc6174cdac2b55"),
		nonce:           decodeHexString(c, "6f885496c1e63af620becd9e71ecb824"),
		personalization: decodeHexString(c, "e72dd8590d4ed5295515c35ed6199e9d211b8f069b3058caa6670b96ef1208d0"),
		expected:        decodeHexString(c, "f1012cf543f94533df27fedfbf58e5b79a3dc517a9c402bdbfc9a0c0f721f9d53faf4aafdc4b8f7a1b580fcaa52338d4bd95f58966a243cdcd3f446ed4bc546d9f607b190dd69954450d16cd0e2d6437067d8b44d19a6af7a7cfa8794e5fbd728e8fb2f2e8db5dd4ff1aa275f35886098e80ff844886060da8b1e7137846b23b"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_1(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8df013b4d103523073917ddf6a869793059e9943fc8654549e7ab22f7c29f122"),
		nonce:           decodeHexString(c, "da2625af2ddd4abcce3cf4fa4659d84e"),
		personalization: decodeHexString(c, "b571e66d7c338bc07b76ad3757bb2f9452bf7e07437ae8581ce7bc7c3ac651a9"),
		expected:        decodeHexString(c, "b91cba4cc84fa25df8610b81b641402768a2097234932e37d590b1154cbd23f97452e310e291c45146147f0da2d81761fe90fba64f94419c0f662b28c1ed94da487bb7e73eec798fbcf981b791d1be4f177a8907aa3c401643a5b62b87b89d66b3a60e40d4a8e4e9d82af6d2700e6f535cdb51f75c321729103741030ccc3a56"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_2(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "565b2b77937ba46536b0f693b3d5e4a8a24563f9ef1f676e8b5b2ef17823832f"),
		nonce:           decodeHexString(c, "4ef3064ec29f5b7f9686d75a23d170e3"),
		personalization: decodeHexString(c, "3b722433226c9dba745087270ab3af2c909425ba6d39f5ce46f07256068319d9"),
		expected:        decodeHexString(c, "d144ee7f8363d128872f82c15663fe658413cd42651098e0a7c51a970de75287ec943f9061e902280a5a9e183a7817a44222d198fbfab184881431b4adf35d3d1019da5a90b3696b2349c8fba15a56d0f9d010a88e3f9eeedb67a69bcaa71281b41afa11af576b765e66858f0eb2e4ec4081609ec81da81df0a0eb06787340ea"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_3(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fc3832a91b1dcdcaa944f2d93cbceb85c267c491b7b59d017cde4add79a836b6"),
		nonce:           decodeHexString(c, "d5e76ce9eabafed06e33a913e395c5e0"),
		personalization: decodeHexString(c, "ffc5f6eefd51da64a0f67b5f0cf60d7ab43fc7836bca650022a0cee57a43c148"),
		expected:        decodeHexString(c, "0e713c6cc9a4dbd4249201d12b7bf5c69c3e18eb504bf3252db2f43675e17d99b6a908400cea304011c2e54166dae1f20260008efe4e06a87e0ce525ca482bca223a902a14adcf2374a739a5dfeaf14cadd72efa4d55d15154c974d9521535bcb70658c5b6c944020afb04a87b223b4b8e5d89821704a9985bb010405ba8f3d4"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_4(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8009eb2cb49fdf16403bcdfd4a9f952191062acb9cc111eca019f957fb9f4451"),
		nonce:           decodeHexString(c, "355598866952394b1eddd85d59f81c9d"),
		personalization: decodeHexString(c, "09ff1d4b97d83b223d002e05f754be480d13ba968e5aac306d71cc9fc49cc2dd"),
		expected:        decodeHexString(c, "9550903c2f02cf77c8f9c9a37041d0040ee1e3ef65ba1a1fbbcf44fb7a2172bd6b3aaabe850281c3a1778277bacd09614dfefececac64338ae24a1bf150cbf9d9541173a82ecba08aa19b75abb779eb10efa4257d5252e8afcac414bc3bb5d3006b6f36fb9daea4c8c359ef6cdbeff27c1068571dd3c89dc87eda9190086888d"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_5(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a6e4c9a8bd6da23b9c2b10a7748fd08c4f782fadbac7ea501c17efdc6f6087bd"),
		nonce:           decodeHexString(c, "acdc47edf1d3b21d0aec7631abb6d7d5"),
		personalization: decodeHexString(c, "c16ee0908a5886dccf332fbc61de9ec7b7972d2c4c83c477409ce8a15c623294"),
		expected:        decodeHexString(c, "a52f93ccb363e2bdf0903622c3caedb7cffd04b726052b8d455744c71b76dee1b71db9880dc3c21850489cb29e412d7d80849cfa9151a151dcbf32a32b4a54cac01d3200200ed66a3a5e5c131a49655ffbf1a8824ff7f265690dffb4054df46a707b9213924c631c5bce379944c856c4f7846e281ac89c64fad3a49909dfb92b"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_6(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "59d6307460a9bdd392dfc0904973991d585696010a71e52d590a5039b4849fa4"),
		nonce:           decodeHexString(c, "34a0aafb95917cbf8c38fc5548373c05"),
		personalization: decodeHexString(c, "0407b7c57bc11361747c3d67526c36e228028a5d0b145d66ab9a2fe4b07507a0"),
		expected:        decodeHexString(c, "299aba0661315211b09d2861855d0b4b125ab24649461341af6abd903ed6f025223b3299f2126fcad44c675166d800619cf49540946b12138989417904324b0ddad121327211a297f11259c9c34ce4c70c322a653675f78d385e4e2443f8058d141195e17e0bd1b9d44bf3e48c376e6eb44ef020b11cf03eb141c46ecb43cf3d"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_7(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9ae3506aadbc8358696ba1ba17e876e1157b7048235921503d36d9211b430342"),
		nonce:           decodeHexString(c, "9abf7d66afee5d2b811cba358bbc527d"),
		personalization: decodeHexString(c, "0d645f6238e9ceb038e4af9772426ca110c5be052f8673b8b5a65c4e53d2f519"),
		expected:        decodeHexString(c, "5f032c7fec6320fe423b6f38085cbad59d826085afe915247b3d546c4c6b174554dd4877c0d671de9554b505393a44e71f209b70f991ac8aa6e08f983fff2a4c817b0cd26c12b2c929378506489a75b2025b358cb5d0400821e7e252ac6376cd94a40c911a7ed8b6087e3de5fa39fa6b314c3ba1c593b864ce4ff281a97c325b"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_8(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "96ae3b8775b36da2a29b889ad878941f43c7d51295d47440cd0e3c4999193109"),
		nonce:           decodeHexString(c, "1fe022a6fc0237b055d4d6a7036b18d5"),
		personalization: decodeHexString(c, "1e40e97362d0a823d3964c26b81ab53825c56446c5261689011886f19b08e5c2"),
		expected:        decodeHexString(c, "e707cd14b06ce1e6dbcceaedbf08d88891b03f44ad6a797bd12fdeb557d0151df9346a028dec004844ca46adec3051dafb345895fa9f4604d8a13c8ff66ae093fa63c4d9c0816d55a0066d31e8404c841e87b6b2c7b5ae9d7afb6840c2f7b441bf2d3d8bd3f40349c1c014347c1979213c76103e0bece26ad7720601eff42275"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_9(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "33f5120396336e51ee3b0b619b5f873db05ca57cda86aeae2964f51480d14992"),
		nonce:           decodeHexString(c, "6f1f6e9807ba5393edcf3cb4e4bb6113"),
		personalization: decodeHexString(c, "3709605af44d90196867c927512aa8ba31837063337b4879408d91a05c8efa9f"),
		expected:        decodeHexString(c, "8b8291126ded9acef12516025c99ccce225d844308b584b872c903c7bc6467599a1cead003dc4c70f6d519f5b51ce0da57f53da90dbe8f666a1a1dde297727fee2d44cebd1301fc1ca75956a3fcae0d374e0df6009b668fd21638d2b733e6902d22d5bfb4af1b455975e08eef0ebe4dc87705801e7776583c8de11672729f723"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_10(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ad300b799005f290fee7f930eebce158b98fb6cb449987fe433f955456b35300"),
		nonce:           decodeHexString(c, "06aa2514e4bd114edf7ac105cfef2772"),
		personalization: decodeHexString(c, "87ada711465e4169da2a74c931afb9b5a5b190d07b7af342aa99570401c3ee8a"),
		expected:        decodeHexString(c, "80d7c606ff49415a3a92ba1f2943235c01339c8f9cd0b0511fbfdf3ef23c42ffff008524193faaa4b7f2f2eb0cfa221d9df89bd373fe4e158ec06fad3ecf1eb48b8239b0bb826ee69d773883a3e8edac66254610ff70b6609836860e39ea1f3bfa04596fee1f2baca6cebb244774c6c3eb4af1f02899eba8f4188f91776de16f"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_11(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "130b044e2c15ab89375e54b72e7baae6d4cad734b013a090f4df057e634f6ff0"),
		nonce:           decodeHexString(c, "65fd6ac602cd44107d705dbc066e52b6"),
		personalization: decodeHexString(c, "f374aba16f34d54aae5e494505b67d3818ef1c08ea24967a76876d4361379aec"),
		expected:        decodeHexString(c, "5d179534fb0dba3526993ed8e27ec9f915183d967336bb24352c67f4ab5d7935d3168e57008da851515efbaecb69904b6d899d3bfa6e9805659aef2942c4903875b8fcbc0d1d24d1c075f0ff667c1fc240d8b410dff582fa71fa30878955ce2ed786ef32ef852706e62439b69921f26e84e0f54f62b938f04905f05fcd7c2204"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_12(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "716430e999964b35459c17921fe5f60e09bd9ab234cb8f4ba4932bec4a60a1d5"),
		nonce:           decodeHexString(c, "9533b711e061b07d505da707cafbca03"),
		personalization: decodeHexString(c, "372ae616d1a1fc45c5aecad0939c49b9e01c93bfb40c835eebd837af747f079d"),
		expected:        decodeHexString(c, "a80d6a1b2d0ce01fe0d26e70fb73da20d45841cf01bfbd50b90d2751a46114c0e758cb787d281a0a9cf62f5c8ce2ee7ca74fefff330efe74926acca6d6f0646e4e3c1a1e52fce1d57b88beda4a5815896f25f38a652cc240deb582921c8b1d03a1da966dd04c2e7eee274df2cd1837096b9f7a0d89a82434076bc30173229a60"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_13(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7679f154296e6d580854826539003a82d1c54e2e062c619d00da6c6ac820789b"),
		nonce:           decodeHexString(c, "55d12941b0896462e7d888e5322a99a3"),
		personalization: decodeHexString(c, "ba4d1ed696f58ef64596c76cee87cc1ca83069a79e7982b9a06f9d62f4209faf"),
		expected:        decodeHexString(c, "10dc7cd2bb68c2c28f76d1b04ae2aa287071e04c3b688e1986b05cc1209f691daa55868ebb05b633c75a40a32b49663185fe5bb8f906008347ef51590530948b87613920014802e5864e0758f012e1eae31f0c4c031ef823aecfb2f8a73aaa946fc507037f9050b277bdeaa023123f9d22da1606e82cb7e56de34bf009eccb46"),
	})
}

func (s *drbgSuite) TestHMAC34_SHA256_14(c *C) {
	s.testHMAC34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8ca4a964e1ff68753db86753d09222e09b888b500be46f2a3830afa9172a1d6d"),
		nonce:           decodeHexString(c, "a59394e0af764e2f21cf751f623ffa6c"),
		personalization: decodeHexString(c, "eb8164b3bf6c1750a8de8528af16cffdf400856d82260acd5958894a98afeed5"),
		expected:        decodeHexString(c, "fc5701b508f0264f4fdb88414768e1afb0a5b445400dcfdeddd0eba67b4fea8c056d79a69fd050759fb3d626b29adb8438326fd583f1ba0475ce7707bd294ab01743d077605866425b1cbd0f6c7bba972b30fbe9fce0a719b044fcc1394354895a9f8304a2b5101909808ddfdf66df6237142b6566588e4e1e8949b90c27fc1f"),
	})
}

func (s *drbgSuite) testHMAC36_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC36_SHA256_0(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "369f0eec011db3db44971ab16371c7a8de327a4852bd34226e0f25358e296ce6"),
		nonce:           decodeHexString(c, "ca6043750aa99545d1597f71d583246f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b507091b56fc9e9cd90fe4c466b5a132615df2d4a18f73302f1d72a416b993c4c207388699e645f6048f595fbc7c356f85f683040a1ccc3155cfe4243f169f0f3e8b2ba5fb33b56a090e553342bd543134af325baa23e4cdd114c429253c8ff9a0239d95ded339e412e23983454dd5091822b1e2712b298b319ab3d4ddef3b2c"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_1(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "268d2f3751c52f9302296f48684ec9f2d88389bca90f78211047d723b6d32e32"),
		nonce:           decodeHexString(c, "7aad9b5479dc01a02087b6a8e12b7f1c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "429082b705e7d0f2b2faa9028ecbbae792ebbd1fd877e309f5288aacd58a42c2eee866c2d79c31b01501bde6c04ce92fbb40377cef98076f2b63912d3cdeaa5b075a572264509cd3fd66124744f6fa7a3be4ea6f5fde86abf79b22344d73716004c8409a79048eb9ec4a19340e26e0a9576d3964b434118ec715c5dec02984e9"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_2(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "05ccd9244ef0f0aeae3796ce9368696b90d1c4e2056e83190350e5036d9ac31e"),
		nonce:           decodeHexString(c, "deb6542edd7e754963553b70c0462133"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "402138cb19dd4d044293f81bad9ccaa453f6cfae406f0199d0f5c844674157752b01d6d330bf61772aa2235860387e7db28dffe437477cc7f684cbfbc3434caa366ea5ec1721a65ed8fc34b2158837f83dc7bc50acee11a3b7e21b55fe88e6aa9822c9103e6e43c974ee559245a1c7f2c2c43759ea443d62a9bbe3c5119cccd0"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_3(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "159a81340a1ad14c0e77e377c9e4da79cabc3fb8f3fea8d1fd830234d715fc7b"),
		nonce:           decodeHexString(c, "87ad56b811552f05f9839a15780b8b62"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "04200567248d099ed436b77b1fa29b36fa708152237ac96ce18e7b41be6f81e6106feb33527066b922356d477131b45372bb1853ccdec058733274237e2c5cce342136a7b6c1ba8ca52d55241a5a759f3f18dd24ebf37f44cd29c36f606855adc89d91cfa8c0f6909479d457cd26b7eaca3e30db3abccbd89621ffe2c0eee7f0"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_4(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "cb86a35f0e8aca3af38dc4eceeea21d52d43fc03d795e507bc47da9008acb0ae"),
		nonce:           decodeHexString(c, "05a5f1a5fe29bb529b83d1bfa727e341"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "45b03b3e8dfdddc46cafb4d9d5765a0b5bca694a73a9bcd6d0856076772fb7d99beb199b88e16badeb2dc018b7b343ff017a6b20f6987efd85d14e54ba27b68aa040d2726b3240af3b8848fdae1ba941fba58d30685428842cfd5ac1b1935341cc76433ef100c1c97fa9f11c81622ebc08515a53b707d4f2c57bf24c3b01af32"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_5(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "680b1088d2a6fbe45e629af37221e89605d6e285f80e53a8bbcdf6dee0fbb6a6"),
		nonce:           decodeHexString(c, "c61821d54b747e2c5287d086dd02e2e2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1264b7f3da4a3dc68cb09c40ac75e53488581bf4fc7647a907b381e140c20fe7c707d4bc23304ccf080272731e77bfb65a39035cde1260d58b117c8a240074d6b731f529a8ca72706f1f387e8c8d0a22726aa4c687e2c6b8bdae8204f80e6fa72b50ef2531de3d7adbef5bac4cc9056129ced057995149bd4f2d824add6cc446"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_6(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "53e83610917a79598a6f5383c2443ead0b3f35f3ec853ef81109c322bd601fd5"),
		nonce:           decodeHexString(c, "8211d8f173da228877d99f16f5f8082e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "46094c468c3513e45ba28c4f4466bf5e96c81962ea2cd7bd444d90ddedb16faae7764720e4ddb8755a56bd3ce81598f79b3d135c72f33cfc7a2db67aa0f7ce550b7b6285dfc9f7d2f9a79175c6c5a6e47a9d83c2841b0f8b6ec7d6b864a885abbdf24a516310b1c4dc8d399fc01ca0be7c709f3afb2a3e60290e6ea7f3410003"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_7(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "24286f08f6960927ac1c5a24c7b75c6a02f40a095ae42c6d4df844015bf08471"),
		nonce:           decodeHexString(c, "472072af39fcc2e1af9b4eb59e7d645d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a32ddffd7cb5e73739de87623aad024020a506c551228a465223affe3f43d034fcfc32130878e807c313cbb178be0a87b9f14cdab345b712305f7888aebf0c462755ba59cf6caba7b62185f9ac4b2f253954d94359752999f490b9435d9e1992c34b1ab6a4390547f3dff5517a4209da9fa5284e309b6f3f14f1cd516be3d8b0"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_8(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "da21ac05cdec567d217433dbaac74e3f9e5ac8039412e38b1eedf3a703086110"),
		nonce:           decodeHexString(c, "d9301860762979f2c042233fdd4db0b0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "48d4111eb766c5bb15591ee9af02c803cd04f3e59db467a6f9083d40d5a916f3092abe5f68297e999bd3a31b0328925417c39cc6232bfa9e74ff9e29dd07e965f52d5127cf1fe2fd3bbb9cd33a87ad2f23e9bbc3549ca69fd25b61462ab4a8e8bd3986ebfda89aaff68e99aea2dd1dc81aeda759e80105f5459207729670300f"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_9(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "36ca7fa625f0dfd939c8cd11192d9c6a364d57af22d0be45c3e5c6deb104fe73"),
		nonce:           decodeHexString(c, "b74646e6e03efe09d2648271305e8597"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "30edf9da91c2f9824b4c49d601b7df039481df61388766ad0967a665c8907bc57dc781cd007100339dd92c4a8e229998170d8cf3d592a89cc29a43b6b4288fae322f333bd34cc56b95015802c67e358b8d81e0e70578f4437ed4b031550bf6d5d4b58030fdff34841270476afda9b6376363100c3fd3423f5f8c1fddabbda653"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_10(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8df532502f4b0b721aabc640bf26fce2c0e98b9ce3d1b13c2366242c839716c1"),
		nonce:           decodeHexString(c, "a1250ef983c762deb1207f22b37c58cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5764dbb364f5bdb53da80028af9aedc7373630ccd1ff8a92fe4bf7b71660d1fdb30af2de5648316fe430baf4fa38673378c3a7285f603f3264546e3bdb0ad3db5e0d41ff507bcb61cc05d9e878186c489804bc79a2cb4d105662310682c47dd4636bc96b9e84261844854bbc835fba216f2bf3a5c9cd439a5351d037c601a176"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_11(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "86e62b68da31a62d1bb04d391cda1cc1fa3a167d8017e9ca056ad41dde790807"),
		nonce:           decodeHexString(c, "72a9fca5fafb7fc4d65a7d7932d1c1df"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "58f260156b6c82e536b1b250cde98636a1aaf4369ded6a469c6f83d47d371e64677b4c7ce85c2aa1c3addef187bf7c0845b019ae75b53405595b24f1cafff5734918dd2e36999c5cafbb45e72400ccc53f0defd01214800e59986c85d7fea49beaf7cd1340d42931c4debda0be70e27163b4c81f10c6ca76485961282066bfb0"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_12(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0ac25dffd09bd845ed6f213ef2e1da3bd17beb4ef00f55fbcc21448676617950"),
		nonce:           decodeHexString(c, "6a6857e0009ceb559de41cecad964265"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6fb0eaada52f5dd0a4c920fced2f86b1a7a1b549649ced0ac23afc336dea4de934dc812260cfaa33a9d111ea6117964c6a6647417da263645a560885e6cc9d3c2a1e0953a525e5df86fbd12df7f87cf632c5f54db554a07805d6977f8e29552c4935e9b2a2ef67276b40756a207162f1d44c90afacecc5d89185b6be4f83d0f3"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_13(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4bbafbbca804e6a4aafd89744558cc7758bcd01bd7954cf6d2940307dd9e0d2f"),
		nonce:           decodeHexString(c, "ae5dfda1271a218ed6cc2d03cc98ad55"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "49fd164513dc36255c799e2b86912570a7ccb6df9ecdf14d75894d4950eee167a87f3fef796fa71732d12d8aa0d1c09eef37ebbe9131b1e6aedfcb2248ecc7a86b3305aef3d56b88826feefed19f9e6a14068016f0f5ff902431f859fa148e5412518709c0bcd3088229ba66c96d7ddf40f07c077bb265811bef8198a70f7d9b"),
	})
}

func (s *drbgSuite) TestHMAC36_SHA256_14(c *C) {
	s.testHMAC36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "17da1efd3e5250dfde3ef1683bd9cf4d4432a2f223399664f7645763bebd5ebd"),
		nonce:           decodeHexString(c, "0b160c67b97d5302972b5c517bed5a7c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "859bab959dd16f2cddb05376b3d3e46cd13c191c18203bf3c0bbd5803cc559aacce48d88564166fd5f43c22d08cda1acd8004f36915739796a39ca96f8e7def14b58a8ee55ff72de7e2e2727389e027657447e32e47d4ea2f0fda48e86046d111cc334bebf4ee1019199c94fdb26169661cec0b0c47176cb5fb7aed8ad35afb1"),
	})
}

func (s *drbgSuite) testHMAC38_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC38_SHA256_0(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a8c77ba575b8468bb5f99220de43d466cdb1d91ac3253c3be27cf18f82520624"),
		nonce:           decodeHexString(c, "052b3c6dd0ee77fb8b0980c38ffa2cdf"),
		personalization: decodeHexString(c, "4f074ac6ccb7c21c9589fa223428af0e860ae31fe008ecbf520653b9be235ea4"),
		expected:        decodeHexString(c, "5769beeaae2879ca0d7227d2dfc51bd3b7ac0c82c9ccaae84b2db60aecc7e06bb5989418865424cfe75f7014b389a46870e222226e6c1a90a4f16208636f635076793b2ff8c99f93588ae0f93be1086a82f45c786784f683d529157268984d7c13add196bfa0c7ddb314ce9375b2c13930209c52ddae347d064ed5d811f78065"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_1(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "911f3206aef3fa424e5333519237cc7d59b71d40f97fc793c4876103a2d05980"),
		nonce:           decodeHexString(c, "ea7877e8a5b1a29a10c82ebc8f8fc3a9"),
		personalization: decodeHexString(c, "5fd33aff8724f27a9f56a2fb6d49b407e120f636279b58ce2bda77447a79826c"),
		expected:        decodeHexString(c, "9bf6d3f44c48c4b600980a1e1ed36f6554c74be9c97494c77a945ebba813664bba4f75d0993a1bfed4c41dded58fc655ab5d8ac59a120323e0543bc68a6ff5cf365123a940cef7c9e393e288477d5ce9ed3ab474fabb0a5d7a93618172df738eed1aec78ad209866453de33519a63db9424090a7a4df827a25dd53b3fbe4b6f0"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_2(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5326824ff5cc0597b46c0a162e841c5690bda10df74e483e4baca0623e43413b"),
		nonce:           decodeHexString(c, "b1f4f182a5ccfe00ddd245a4c8c0485e"),
		personalization: decodeHexString(c, "2f29b4ad28f722fc884943c1c12a586ff1ddd04db3d8695392a57385fc99115f"),
		expected:        decodeHexString(c, "994c14885e734fbd200df66c45a68b49451bc4b44406306452efbde9a8d411ecac912dca39593be82dff920d540495d63d10abe04b06ae778473109f39f5257d6a81bf63b7b77ab7dd7b21261aa41dddbbd1872bbec87a4534983892cafd06eaeb71db18ab5557949d6c34e63dafdd048bb4c81ccca712bdf9ad6fd70a6b48dc"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_3(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8adf144473335a79173d3af6e50965001a34ec27ccd567313c7bebdbec9f71d2"),
		nonce:           decodeHexString(c, "7065371d51d3285d6ea653494c308863"),
		personalization: decodeHexString(c, "0fdec2ca6179623406f594af0f662c675a7cb7d6fa65030c1c5a04fa4c89fe33"),
		expected:        decodeHexString(c, "c4fde769d5db2b89e2e635b08a187c2f9615787705c7ec82946474281366003617f186a4ad42ef51f6833532807b4eb7653d4317f7107aac1e311750931089ded92f9af5727dc40c99bc7035f0553eb1bb6f134312239cb682935c8715bea886424accf89ecc016ef67b805df6f4ff83cf758c277b4de9809bdf7e420b47c352"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_4(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c58faf114e4cf647c3a27189acf2d6346147b9b6aad7c5d9cca18aa13f513949"),
		nonce:           decodeHexString(c, "96e1b9425401337f46dbf9cd0ae076f5"),
		personalization: decodeHexString(c, "cbed9113b3b2170712a8ead60137461e72f46be14ba79fd0a70e48930d347565"),
		expected:        decodeHexString(c, "c5d2ce2fb4baa2cf5633634f3ccc13f1e81fddcad1c80f9d1fa3353264b03355763753ef4869766edda1f3dcb8f27d65398a5568e9a17cb5dd0e38e752b71896abc2bb6f945512b4307c0038c519641b9de9a88fce9c0b1a880e23bff0e7d1c56b5d2449bee84fcaa6ef301533bb0827d13cd14eba0a17e0a1e7820d4a98a82a"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_5(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "39723ac65fb657f3c273dabe094f9c4b69cef6cce25a2041e07e5f3d0c0c23cd"),
		nonce:           decodeHexString(c, "6906ad6afcd5390340d04dbc484b12c4"),
		personalization: decodeHexString(c, "ec987d4f7da75c0c6045a11180d3619c6db996c61116167a17c632d6141dc874"),
		expected:        decodeHexString(c, "fd6091b2ccf111d47c7540d2ab92e67243e104b6550b2aeb7ebd89b635f5a976890a9df7ca8b719cb4833cf52eae257eea22a731f03fb85798824d9991c72aca8ba856a767804b79a3b4003c2a82c930a4b840cc9df082ab473d185aba3bfb25be5cf7904f0912b8a1320c5ace8c6142e09b282d778a80c7406256a4872f2852"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_6(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "39120774b5e76bfdcd7a1d5c94b359bbbdfa24e7ca1ba37c8786e6e7d417c363"),
		nonce:           decodeHexString(c, "81d05d26b0af3000c9506ed5d1332cb8"),
		personalization: decodeHexString(c, "c36ff94e9777b742cbb6f7a1b7a25f1a64a3d1e343f153149b596f732e854d7b"),
		expected:        decodeHexString(c, "9970e7ac5858f7eaedce07f2a0c50673a91dabdb48de4ccaec668c3e9db5e394984a44d3b9ffda3c874deddac6a4bf5e72b0b083afb87d3fd0139f8de12d319363009d53cef0ae285c507e1f9fec2a080969af22bd52d37868732af7fe71be681f6ecc7d92b4264f6a7c11d5d04d0de40ad9b280f26f6656b56dfda50bbaf603"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_7(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6df7250981e3b5a74efec19f15ec73cbcb46ccdcb23519f2dcb2f9b855addf65"),
		nonce:           decodeHexString(c, "e0921ea03a36ab53544f2e7815890d6e"),
		personalization: decodeHexString(c, "a807fcb6dc1439fe7b4f9494e68b613e56a608a78595a466692387ab6983dc6e"),
		expected:        decodeHexString(c, "6adcd591650110a0ed81d6dd8c885d73d03add2d81e4d654b6c0a7b96bb6cebf011a1778b33370711f55795ec6d2e1938659c409251653fc4c643002863ae674517c44af69c44d1358ed84800c1c9e5bc79a534e3e1c1f207e5acd653ed964a319598d1d73d3040144927712cf554bec81d4665a50e3b252beab0f511e7361ba"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_8(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0ee55f1797b1498cf0ff8535cd3430613b6da15d1fc06a851ca8f3aac878ce84"),
		nonce:           decodeHexString(c, "220e692fe775885b919e1ad689ba6e7c"),
		personalization: decodeHexString(c, "0e849b31f01a98ad5e9245c7799f74936efe52d99427621e34dbf83c639f1dae"),
		expected:        decodeHexString(c, "1e9e523c79bfe89c2dca46664e3bcdab79a0a243bdc607dc752173cf99b591757faf7ad84cecfd1af10b5dcd5d76d5a8e41a4782e685db46bd0ecd3458cbeeb11558685d25133e20e5f613dd4a622a73baad3df1a80f14f98da1077a300acb0ce02bf55eae2346af1b7df7b97901d382371632594190dc42c944094bff2862f3"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_9(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7f90574ac55c4b3f10a9d39882a4ed1a9e922f25dee0779fd0a5839d5dec0091"),
		nonce:           decodeHexString(c, "914e40a201adbb144089f34c91786b1e"),
		personalization: decodeHexString(c, "26a55b8e95aab92a12b681bea7412f00a48d6b438f54da9c42f34ac5c31ae515"),
		expected:        decodeHexString(c, "0c7f925664c6db4fe5b6eb0b20b0e0bca5a704d1724f33b0fd55ed8c47caf5b77a224872bd77de138b64a8fab6b2c6610a4670d2a8b463288fe063418a19c7b865c876b66a50e8f5620f68cdf3f2108c920023f02a8b44fbb065b1d763659cdfc360109be6813fc63a14a5acf08c4d49d98732a13c8bb71555b0dcf51deb0871"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_10(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6da05910b7d742fbfa3296dec76d884c0591c4274b0b1ef7b8b556ab63c99a60"),
		nonce:           decodeHexString(c, "69beec7da0557e59914cecda553cb9c6"),
		personalization: decodeHexString(c, "3e1c544c43118a8115ff26152c57f43739eb5cc66f63d3172bf8732c25607cd3"),
		expected:        decodeHexString(c, "78829fbf89d5f7ac217c75c3d4b36500cc454c87547b53309814496c73fc4141e88ae4d7cb21bd0627c0531402ea16e48ef829737ec84694eeecc5c72132e76fc7aae325c01d8d38b62ae117f42e3d858521fac939241493cfc04f8a1ce4f49abeee9705eb50b3ecf076ecfc464a7bcd1dace6ff61b027c5e50941af8ea01f9d"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_11(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "90d67dcac6fadf87e691b700a4b6755f388643d9d46fffa91f9ede43e9cdb72a"),
		nonce:           decodeHexString(c, "b0e142d060c97f4bf4fba4663249de43"),
		personalization: decodeHexString(c, "3b1ade723ecd8a8cdb9de06e844f5bad612b90946002c8b07dbcf4cb989a7b87"),
		expected:        decodeHexString(c, "fecaadb4a186b178236e1ec2def4ced5f796b74bc3b0bf6f8456ae1696e267f1e10e21a27b3f1bdcb3bfa047f9206ed5c1f81195af885dfecf0ea28ba3df75a8f067164e72aa47a42c19b41f7562527eb27e99cd2381d49fa88db481183e1ca351de70526d2c6631ef50839a6775a3aa08c7f96fd1befc5cb7f20d28d031e37a"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_12(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "19daa51bfec63fe6f0d3461ad0e184bcc6231052e9b84d03d7fb80c691749e3e"),
		nonce:           decodeHexString(c, "323e269e7c69c02fbf5c8fc2ee6f7782"),
		personalization: decodeHexString(c, "caf1f074076ee7692d5beb895298caf38f0b48f5c6cf971b20db2ed5628409d3"),
		expected:        decodeHexString(c, "c1466592a415356d40de0a4aa72dde8cb1d07529fbb6c8380d5006b36cb3cc0092a34b0c380fc41818a58c81d7feca4755b88b887562f2b478a5ffba88fed5197da8422352e5cee4b92ca91ea2a6f5b7b01b89ea0204fbff2fbb5ae3273dd4aa70514da2ab9d43c4ec85ed33dc9d3e27fabadfccd558bf3fa34209d7ed4c994f"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_13(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3a741bafe59aceb22db401d4f26a7d746c5ed7d3f24391153448bd299a86a7d3"),
		nonce:           decodeHexString(c, "4d13731ee770540ebb919bd07df8013f"),
		personalization: decodeHexString(c, "efaab02851795f0c8541233d89135412734a628cb61ecb96b427398a6739bfd7"),
		expected:        decodeHexString(c, "0b34a9c51d82017ff2ba9b91baa87d5c4aef78aa51b1bb3851838e9ba1fa0e277fb533e02963a53dc1619807539e3ad0524a4db76a6be1b7b8bdec774464456edf97547bf40517cda7da00da503c133c633066420b9acd878cd3109ecc3c9995a3357ee3ca7004f70968271824c2a6f4dc2199066d9dfc3219439094bfd25d3b"),
	})
}

func (s *drbgSuite) TestHMAC38_SHA256_14(c *C) {
	s.testHMAC38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e344a3bf1eac434ca09e944efee161cc1673590fed203527bcff81a97368823a"),
		nonce:           decodeHexString(c, "2b653a89e549e3b1ee7817f5864fa684"),
		personalization: decodeHexString(c, "814146b3b340e042557b0e8482fcc496a14c02d89195782679172e99654991ed"),
		expected:        decodeHexString(c, "3ea100cf50c25d7b2ef286b5fa0720f344de2d568979e7349befa23589083e835205cdf6a4670722fff04260e54618c9c00af75cc26eee665b64e7e628ec4c56a8086dcd583681170f60d565bd97d0f416e4c231e281081b0fcd16c8db63ea9029abbfcb068bf57a36364aa9e27603f447adf337baa35f049a129abdc899f808"),
	})
}

func (s *drbgSuite) testHMAC40_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC40_SHA256_0(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bf834dd99be9d58e3f6eac7664be2922c5fbcc99b8337037398e72757452b5f0"),
		nonce:           decodeHexString(c, "179123b7c887982acd3b4a37f3d87283"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c46477fc8d4c9c2097826f24f66f65bce6888d9766ee2264661f0c32ab452a0f7b2d1705e2b22873a22fbae0ad599494970b2780881b0a89dbf237a5c5b868114ba2004fb737ba22985368ab2e1940369888f484e2d628c7426adefd35712dd52b91abe48132974cf97a545140d8820da92a6a301e3f27e6b3160b1f4c1dba91"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_1(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9e99d33410a8b2081814714ccca9997f8efa85bf47b3f44325000e7a26885e5c"),
		nonce:           decodeHexString(c, "fec5d7169c2af87b2075f8c7953a2302"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9be1e7e341343bf0497ca2af665f5b2ee7935be8e8e8b10f5fe9b646bd32b1876a634207338a670fda09b750ed589c56901e7111ddaa2158574d9f0ea4a7edb84559ef406167e107b0b49ae32a1a318d038fd83a372ab8e1eb04e845fb2330b5d3dab39924016fedc5ecde3022576c4d00c790a1cbbc60ba21878c73e50921ed"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_2(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b41e761ae51064b5f1bc3d77dfb4b4ceed1bc4bba7d4f821895b84081c31f75d"),
		nonce:           decodeHexString(c, "c7b8a8d8ae06daacf64cfb5da139a553"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "aea278ea3144b9ae4d7286d48e07ce674062417743b7d6be2ff8a9ddb39b1bb0a76a3d6e76950aec4fce2376eca7056f4897d8cb8799634ac8120fd75b78e6874774d040353493312007f8ac2c85ec046f9e54d6c54e4a64f708c97ed521628ace6d4811144daa0ba734bd89adc1553bb090e5dbfde7158d3b7e04187cb26ee7"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_3(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8d12298dea58e35585545ebb5f20d7da6a640d59c1485b38a60dc56260e9cf2a"),
		nonce:           decodeHexString(c, "81bff3acdb2c6ba76fa2cb029fa29cd0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c19ab18a2e671d589a4931fda6c835dc366068fd51dbab62c842b9846f706eb27344076ce772567e3633246ddd2594188cb5aaf7520d89e29707126152b94434a1d68fde56754d78234e495921529318d20965a19878857176f1aaeb4231c2cb535a4b54dd6b245ea5306b7c03b00dbf83e927228a7bf048f34ec3eaf3b0e7f1"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_4(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e1b9f54f7b16028caf1facbbf5a09d1da61508eb23848f9d3cb961dd082e0e3d"),
		nonce:           decodeHexString(c, "ed5606c8230f993a0ef8e30e4ac6f87b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ea858ab66ddd7c268a4a21aa7655430353ca0f12026e6c7792d6bbbcfc84ae6d59e478075881ec39d074c60a01eaa46e2d0663b323d9dd31471cec1cf858e5c4df4f0ade660bed3eee076b0fbcc09f7429eb756a2425e2a0435b1fba221189e2b28002370cbc85d4fe8db544f80e0abc5380f309a0acbb739cc07e7ad3808108"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_5(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "49137936175ffb835e80ef48fea9354bc018a86d23596d561073cac534f4bf8d"),
		nonce:           decodeHexString(c, "753563c02f45c9af21b815eafa77fc5d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "325efe5b6e98a1a0cfb52fbe5f72ff93b9026aaf908e0deb512c75535ba6f17ff446b4be926d946b559cf86d2d16960ff3407576701f7bc02d39b345877ff4ecbb463202c2bd4e32a200dcebff6b7379c954ba1a995b565fe4070bf0b181a800b07172e5a7afe1a428d2966b893ce671b3a847a38037af3066fc4c5631f39d4a"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_6(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4849a2df18e5d528c172481958e1d1ef53a608e213698af8ecdbbb508daba39e"),
		nonce:           decodeHexString(c, "c827f4b4cb07303066bc78d5521def39"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "00bc3d2b9bf7e56add8c25993c998ad35ad55eeae3a338a31334b60a4afadccb6cb8cd9797881bea849f8c914e1d25780e13d2e620b5e18930dfafbb2f362bdf8bf8ef040dab3b16718419ac27ca1bf7132ceddd1657d60cc63a7760cc8d463e30e3d2a9c7dc50478438a7d8289713d6934fe38865f039eba69fde55093067a2"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_7(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7fa540133452de6005b1d79c3fe87e4c50b942ecc21739253a867d27af439043"),
		nonce:           decodeHexString(c, "84fb3e54c85c20cdbddc04a4538c8038"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cd1489b14b1f9e784a5d11af4502740b8f1eafe07ddc818e7b0236bf0b340acd4b8bedb37a7cc7f168701c9339a8d3ea11597cb7d04d3c74baaabf1c76a1fc4e58bdd35237322ff3dc4fa613bf537dd1198d7ed2ed91fc71f0224fb8872ca75398a64a047fdb733c320d45bd662b0a61036e017bc9f0684b3e2e9a7ff7777ad7"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_8(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a541ed73fcc5fb2125edfb514eef05c4b2e55d68b0c03a9f24da4d78c57d472f"),
		nonce:           decodeHexString(c, "a81fdec163cb205cb8927020edafe7a2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6b36f4b229c6092d430fe2b413d46a577d90efafdd84cbfc9b9728cdfd5845c98f203ce507f7b618d3357217f7abd344396275cefa11bd9e572ce2d011abe66992c64b9393020c2305d45b6c4c50db4115f2f2b79f4659b976932d99fab0d3c5eda0c698ccd411ce9ea89c9f1c7970895889e0dc82b8fde4b67caf9299f1c073"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_9(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b43bff7fde71c178cbe11e7a1350c79bcbe619ac4b428ae90dc45427b962e6a7"),
		nonce:           decodeHexString(c, "1a1ec9ae03b53cb86362c6daebdc6214"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b358fa64b37fee910c5456767e73cba955b0768fc5d073e0c96b2072f55e1e7df71ef17ee04b6538d4045e930b65f666b7208f95800367fe74494d101d7f79388b939225cff4245d175a142caaa450ba15f407eff53e6978cc48b41ab6cadf158e94fe4a5821a8c71d2f2bc98c4f87d8d424d681924ca3615f15c1ae720c6b45"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_10(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "11603d301f43587b45021858a85ceca9ce7eec33baadd09ee073e9d12cf7dccf"),
		nonce:           decodeHexString(c, "d80d5cc4dffdaa05735079dd391ae848"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "05ac8bfcc06b4c6114e33d93f4d49616b58814f5906e28937ebf6316fbf96f71b6dc5bb73a4966e6a10a7f065a97171780e2204da4f7e43057181612ec2bc82ead92610552fa969b1f49cec59f1ced0ba5bd2285069efd6e4e0916786047037171664ddaab2584d18bfde5364d71e1a5d0804e36ffab26208ee96917ed19bf8d"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_11(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ded63893594595036854ac58a1ba4c49e2a262bd6a5bec530b8797dc0f491be3"),
		nonce:           decodeHexString(c, "267ed02edc56cfd991a510fb6d0f69fd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c8ee488d07eab1ef20504dd838c01003e6f2ea51aec3ccca927290bea289f44fa692b37766787ea91a3c5b48740f05ebe56c7cd225d8342a46b02064e321d90831384b301aab6213b010336841d09f04c9ee6ac4ecbf1cb932ec3b2fc9a15596d5b1129b67021de20077e975a4b8306d65c5adca4ba590b73483cdea53e87970"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_12(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9e520e1d515e4bec39f2cdd032cfa9bad9ce5541b107d7e6a616833beea72a40"),
		nonce:           decodeHexString(c, "3fdfe4b121b69dc292081b0edb4e68be"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a3e9f73213fdecbc0f415724c41fcd0f3426def28ce4593b8358a56adf980868e01069c54f9efc679c7320c9153231c394a07421ac162db788942ea01b5351776ba5747aa8bd19ae982816937e2ea556204656c582323b19103536db68122623b53b9da6ab8da8c77081ff746f354018840f45a019f308a1d77a3c5a1397bdea"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_13(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b5ced385bb14d96498b7c8f4d11ab929b482a2e6050a5d303348aa97f5265092"),
		nonce:           decodeHexString(c, "3508f53b7825951e10a770e826b7491a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "01b9191a5078fe1d330a97aff8ae937c7cb3f66c9764e200ad94696ffd70a9935ea14cb50a888548c413d8a1fa0e1511e3f20b6b87f58ee90497ef188fe6fbd4968d77c1d70129dc8f4cc83cc72bf986f4ae84656b92a50ca071400c7db3738c485151ef60e4821e0f4c5fea1c75831f5dedea51505ea2e6e327cdca133a6f53"),
	})
}

func (s *drbgSuite) TestHMAC40_SHA256_14(c *C) {
	s.testHMAC40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "32695b2c55839eb3a048fabedcae1f23bf0c7206280ba4ba0d08b9bd9f119908"),
		nonce:           decodeHexString(c, "01f2a4cf8a9311abe5ecf58d6661dc5a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4a4f44f418d585e03f508f2ff05345abffeafd75f610a957be7f3ccaae31ba28e69bf8ae441a405fdbc0ee761e39c76b69062f5a3866fc296be1ad306e6584ab2d250d717605c70a17c46a298f714e4e820c85a1fb84f4d61b9857a40c2902193ad703c78635a2791abe6abca6124229ed75827135c27f1a04d244e1d73ff059"),
	})
}

func (s *drbgSuite) testHMAC42_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC42_SHA256_0(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e50153d9d7114aa4b8535482f8c4c8f187e4bc12a59d35c51f3fae9970d1f778"),
		nonce:           decodeHexString(c, "1175f514a24b02cdbd1d90396f92c51b"),
		personalization: decodeHexString(c, "7ba1b78349569a81902cbf95b5127cfdcc5bfaa761c349f1930c62cf536abd0d"),
		expected:        decodeHexString(c, "924462b8099a1019cb8837342194ad10f24b3c70b0e3b7ed8f28063ee5ad34a725a3311557ec63c3044416e785739ed4ff386d6f5e5bf53d23c45f62acf725fa548b4c564e562a458424a63dab7771e4adb68fcdde2c250413bb7e95c47f117d7bfa85ea3cf7034fe52b2611fa5deb3f7be98e27b8e5adb83f97e897d4e0cada"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_1(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a1a7dfd64b0bb565b6965c23af2ec3814714d1a7af4367d249f3ef2c28e10d70"),
		nonce:           decodeHexString(c, "ace62601e397838eb0093b8bfceb04ed"),
		personalization: decodeHexString(c, "128886ac929d9c4d198cf29091ae013e3ba2aad3ed7c017f0da7dd9da478d8d3"),
		expected:        decodeHexString(c, "e7e3e99c793157becda566413ef21fb41e468c1192122f4f1ea6be51d946b99709235fe7a028319335120e0d60758f85fcc653c5570b7adca527be222a867e33c5fc90cc2202c43d036a25d88f0121a082fdf7d145ba95c5a675b247bdf5a3d327e67e47fb2dcf821faa9a907dab628f70a0e0c7bd211fca2606899b46c0cfac"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_2(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8eada77fc0bf869c8077a6b3aa697d4c818e398b309c4d9e73b77e7b43958f8b"),
		nonce:           decodeHexString(c, "4ae5f1dd363ca3f0a3e8bd65311102ec"),
		personalization: decodeHexString(c, "9328cbc2233821eb0b977426c07873661549488eb7aae957e0110e3762a46864"),
		expected:        decodeHexString(c, "821ac3c18dcd7bcd3059ed4bd02bb9623003a2b05d823f17d3c89394264af0a9e53ce44db9650a96498bdb21f270f854aab79c053af154c271a2ead59c74b8ef420588569a5c7828b7f3488069bafde17d60199224bbe3e40b177d40e91c4b748c4f5d43b634f2d7be50bf037b0f5385ffc54e050e89013b8a8a8a238bc5767b"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_3(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0edc07b780c304d8145a36ef567912244ab3c49c11d0ee4e324850f580bc7f8e"),
		nonce:           decodeHexString(c, "4044447c33e8a9349774d409ea04093a"),
		personalization: decodeHexString(c, "32d1710102b28da78d2cde1ae3a14e0448603dab18786a3a43be95562161b037"),
		expected:        decodeHexString(c, "9ba83f591a73bce88ea8a8cd1486d383c64af6667025b1ce4b930e389b017abab1df9691b66f7b57fd52320c3676fafa280e17fabfbdd5e567edd216fbd8cf1aab2c530ef7bfaa432305e38e3a8fb56094a4c6ea0708dd4c8b3820bf3b87e1d7381a10ac23926afd91baa45baccdfebe78822146b815db2ecc4deed0298bc8a2"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_4(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4fc150782f8aaa6ace45fc5128b8478cd8feb34d1cc3e14caa8508d8cd252581"),
		nonce:           decodeHexString(c, "fcc48fc6618359b700d2936114aea646"),
		personalization: decodeHexString(c, "f7ac2f0fa50fe11d397311c0387df50567004baded7941c0ad9633654a92ea00"),
		expected:        decodeHexString(c, "07e2a5d9d56680dc39f2d514a3ef48d39d3a8f024cd692d5bad864a765ca7a701016fecf9d01aa62e16ebd908c8a335f147015e1656ec1e646c12bae177797d0439794400ab7bf896577c64bdd1aa0aa3a0ffcea31891bb971e7d62a4b45c23489ab23cdd399ab6558156129029ea09b8273d0d9955054a4cee427988bb44372"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_5(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8eed1b9eb753ce303fe8f30c4d782345f27bc4839695b8bf8b558cc8b59b9a07"),
		nonce:           decodeHexString(c, "e42b1c108bfe505a5730dc69b8d2a6ad"),
		personalization: decodeHexString(c, "8e9d09e5c51a28ecce73442e47414ec907034f2dfa2f24db2c0a4f7c0424b18c"),
		expected:        decodeHexString(c, "29b59ee90517aefb8fb25e60a7a59ef34ee805d03be9b9cf30288b256f3e361ce692a7221fe115d6ea3cd35a812f3fcbaac6abcaf4cbd30231ebdfad3945846e2c00ae7b85cf710ca688609dc33a21eed8276a6a70bdae857cad6073617a7391ded6f74625392be49ba781dc14ed81aa5de93f99d357d71dda1a6be503ec56cf"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_6(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9f0bbaa33b7321608f0cb354add1cacd01ecee863282c8c30c58929f197dd877"),
		nonce:           decodeHexString(c, "d4388f2404c73dfa515f309757752dcd"),
		personalization: decodeHexString(c, "d6136b57bf0b8ef3d0a402b757cd87dfd8bc98af42cf6b64dc7251beeae7d3d7"),
		expected:        decodeHexString(c, "3e026fdf4cbe34a6345f809cb5d3b31cfcce13e02a7e3274e8fb054b60718933053098bc329d0f65743c6523d747655869d5b56400c7ddb6d73620bfd9d41d82b6da85ac1d4703c93c074431f709896c5eaca30cb95f8aa138f88f369e23ca600ccc3e245dfb080141efc2e2fcfde1ac40120b96f8b024a8d7913b498dba390e"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_7(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "abb007b472c21869d2571b412d2320cf7c0d080397d35e47c47a8ec10bd21cc7"),
		nonce:           decodeHexString(c, "59b420bf6ef70bc58d02a074e09f29fd"),
		personalization: decodeHexString(c, "e836f980a188f0189be8bf130ba6136ff71e0994863cafb25bb611ea875cfa55"),
		expected:        decodeHexString(c, "a2abb57a18401a54c9eac07a1f4ed1cd21f525f9a5795dd9bbe7db61621073e6c150804cc2dc11f0734ed8000062df0ce7c7448499687da5d21302f507f8c225166c23fe01eabfcb0f83448aa2da9111785b0ec3e3212694225f0f80426d39ad000fe904f68f9fb7d6851e929ddd12ca9cabe97d717d5374b7d60bd4b33573a3"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_8(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "831b39f472980c2cc0ab18bc0fbbf9dc2639c0fdcbf8bf1aa7b85192bf589f57"),
		nonce:           decodeHexString(c, "d3691ea3d137d7248f5592397bd1c6d5"),
		personalization: decodeHexString(c, "a08affc0d4262986cab581f602f6139e959960de35b7931ccdaba450185ff290"),
		expected:        decodeHexString(c, "c2359652f77d03118eb570b1d3e8c2525aba84e48dec6211a6062f346614abf249052b72d5b05880c3c9d40a2d05aa4211499a06eb4a4bfd011ba1d447c7e16b6b3cc061a9c40fcd6fec9f32173d2237a49a462df4fb2e4457c0ce94c29835351e1b3c68056d5819d92fd035fde6c8b0f52e5f327a9cbc7896932b8e526ea465"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_9(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c977c3a73ff79c5d7d3fdee8ccef4713e90d0a87f0b28ff65407bf1323b70372"),
		nonce:           decodeHexString(c, "9d5d1efade50b35415d190f295886fbf"),
		personalization: decodeHexString(c, "560277ab734b3865ce5a38761099f3aa38700a05e1180d30fbaa6250b8a827fa"),
		expected:        decodeHexString(c, "2dfc99d31356463ee6ef955e9382ae7b6dcf181f8b7ade07fd029ad6fea5e1f0b571c6eba513d3d8d8f804a8d723a76841e104c196e53c2939892a607e6dd02646d2f338db0380b62434c5d2d2785a173c3af5fd333a9f115a733645241056790b3ef7bd8c29f23bc9b63529b0676d0157512d74e56520bfa5fba08db56aa951"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_10(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "658565fbb879495ac5634af9f478d9f8409c9708591f802d0183a3036cf786c6"),
		nonce:           decodeHexString(c, "a39383adc3c396c0509662e022152899"),
		personalization: decodeHexString(c, "c60456ec7c0dc96bf947293076b5b1f8b6f7cef4289b225c3d99bd8b8ff5f134"),
		expected:        decodeHexString(c, "33c6898798a7e84ee023a2c935766cfe49c8c9d23675852116c322aeafc49ca0badc1d8fe271ab6d766ad16e1dab047f11a6c6fd4b54c5b6c5c33662322e7e226479f1f940c1a7576c8f6a9a5fd5ea6c76e11f7ebb64d4540d7f69e21eaf12e35c34725e5618b3fb5bf41ae34ee315d2cdb4ebe6eb7ff6187dc37176d6b444b1"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_11(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5f369d910ef83b28b012880db63b86d2139778c931a4fe9ed11a3cacc5630a54"),
		nonce:           decodeHexString(c, "9ccaa788611202abd00f6a230f36cb8b"),
		personalization: decodeHexString(c, "9f43246e07542b8b72a0d49648f6539cffcfdadd2bf364930003e58fd645c697"),
		expected:        decodeHexString(c, "114cebdded6802545f568a8a1e20a8ea7941735ce6a85a9f1310e70344dfda961211558af1d260c0485789d3d89376a15e4666110a6ee53860dab6a46100f34c771e97623db5c3ff19bcd904c5ab626139ffc149e82f188bc14f5680735eebeae410167bbb67cdf4d9f536f0479808e01540c6b3e16e9cc5754e7533c188c0c5"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_12(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ffbd8a4cb741b9f636b5a35b00be7d174ce0bd0c6c4807ad7425b8688511ebc4"),
		nonce:           decodeHexString(c, "43bb0b0d7ca0488aabf66cfe79cd4c78"),
		personalization: decodeHexString(c, "06dd817b26cd5cfb2b53058fbb36ab2934fc1b00fb2c25903f013b909ae6ba3b"),
		expected:        decodeHexString(c, "7e76c92d2973a0cd991dd65137498e86f551e57424cc655473de7cf8438a1740d1aade63e5c9b60451a8cbc1c3c6cfd520703bbe969093ee9ca2c96f699af61cfb649783c0c33d67b86451ffba9554a20c2c306c49622ee6e8e6b8681f6fa9a58a212d80d71c2d7fb998da1c4669567532287cfe67f653a678e61493d2eae1bd"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_13(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e742599c62d9baec6461daf2a28a77e354f1069e569029fd2c6ea32e56e52a54"),
		nonce:           decodeHexString(c, "231c786e778fc70846b56c7159611ad4"),
		personalization: decodeHexString(c, "41156ed56a74f98dbc311069d8edaf70a267193705c784b363af82cda9595570"),
		expected:        decodeHexString(c, "be34566a89229f4c9bfb43aa61403d48f59411f840d38061dd8b1331715d821b17200d2c7305196673a94eccfd99fcae5fb9e9a461032692ef5698c6634037525a661d84d6627f2052dc9a08d98643b555d4fcdfd16504bb7b441ac928dc4ebd74a4fa647bd853729ee525277b319450c104a88569eed42c2a2c1bcc3eda9aee"),
	})
}

func (s *drbgSuite) TestHMAC42_SHA256_14(c *C) {
	s.testHMAC42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8296aaf08f44bd70b0d219306e6242dc74775cba1793bf2b41b4c1de6519fbe7"),
		nonce:           decodeHexString(c, "3f9e88b93a6e69d070328c2c570c3be9"),
		personalization: decodeHexString(c, "bbe702bbd2265e73aa073f47ce55fb65902abbe51635b414df688c60868546e1"),
		expected:        decodeHexString(c, "0280555ba6b2379dce7cd56615d7d86feadb8ad995e2852a0607e663a34b1e0342c7bc649adcb204e271eeb87521591fad74b3bd841971cb100ae5f21599b732d8c5f9d578c1113da7034b580013720e62b1d013e28205d5024f8b1eb3219e6cf821792713354cf1349d32a64f32ecdbd7578c55e401fbea57f21ea3ebef0f9f"),
	})
}

func (s *drbgSuite) testHMAC44_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC44_SHA256_0(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0398eea9b1887385fdd440f46c475829e5a15d73e0fdc22e1d9290852a0fa0d9"),
		nonce:           decodeHexString(c, "9c7b1c1fa7491b8c7421854427ddc1c3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d2bdd8ffe6d840380f7dacc3ce913f10567b7ad40d3e319880c9ace504043d5158cb0679aa374ebc4d4693620ce9ea372ed9ac7b95d90a098467cd4b6f491c41d86ae365a4c0da37690b1748fbe76f5312da9399565cb691710c15e1e3a83b4e61f7e68c6727b9a2a5bcf752d11f80736a6f1ce1553e92d3a388ac83568651c1"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_1(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0ff19bb811df7ca0f547b5d9a6809b1a7b58d5d144426c00e924878101536924"),
		nonce:           decodeHexString(c, "9478e8b18fdc530a570852bbc3460cba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "848653b4a3d65f1e1811aa6da7f91d6826dbb22f636dcafaf62d966e86f5ce67f0e2b27bdb847373f44627426cd04ef27e79274edbb727912d89662376e5e1a831155f72ee61cc5a102dcc042a2144474649adc1244539e4be23ff49333544addfb9b64a97b81060d1ea2107b6cf883d25775836a8a6560bab1b50e8b688f930"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_2(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0236edaba4e5e27e90c96bdd78ead44fd7a2cc5796b8dd7b2bcd1dd06a287487"),
		nonce:           decodeHexString(c, "f86fa888c9be09b4b9f8c02d8f851e2b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5dffab11d90d4b9782a25b41caf73c4264953bf9531d066da69e8c6f84064d547904730ecc42eb78f21e9f2bf8df012d46257541182fa43e412853392abf33b5ca50126d5d3cea6fa887ede484f2173c8a65f7eae2e8479914328c44617b2bf57af9ae128f0482b0ede00715e58f1c3cf2d043d1c1c276d50730d039807e46d1"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_3(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "55a2fea78b19b685e0fae6d9bbd14ed528342a169ad494f2e4054e30ea54a36c"),
		nonce:           decodeHexString(c, "a63e8e20cbd540490639e98a3021c358"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "aad57f77c18631d5bd8744388ae6b47b975ddcc51ef39903d16e7e6aa90e0ca3d56b97c6992c6175782f92ebc57e0b9ec4f2c9f5489f96a63bd3c2d1f3c1e82c4417c24c7620b1c37dee5a6bae7e7a4d1cc543151e3f98e49e4024cf79c516398b3a12f3b55b12ad33a690fbc3c66fdfaa471396dff727ced7ab5a2f09a73dba"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_4(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "35f938fc8bbbdade64d95c50f75aaeca356a2b9fd1ec1719a94b8239081386ab"),
		nonce:           decodeHexString(c, "c8bcbe8bdf4532cc50947878d414f470"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f77873425fdedbf30e33b2442ff6763d2d041d3b838a66d26d469dcd6103e203ed7473a33b443fb8d2964bf9a02214bd14cf8938744c4ce28ea46e6f827c8917da407dbf2956d458281767cf0f7ddc973b16ed81c446d85d9dcc454bcffbb6f831109a1592bbfbe1556aa4727c5ec3be6a55a0282d6ee96e9e37845873d6b858"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_5(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e107669ceba4715a97d531d083f842993a4f217745387e79088b970be077d1b7"),
		nonce:           decodeHexString(c, "fe44cfa21e308b55b4575b4dd3744c68"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1d7870659867a1c0ebe35218e647a56252f73a1050083730aa293e9ead28149397bf5e5c7e8a6c6a336dff4442119966a0fd6502dc0de72274d04ff1acde4588ff25ac08f154e029f609dde8019ce696f83495725588f4edbcc09bc6c03d43a96a0436e1cfa0a3e2e4303d0f9fa481cf7f5b37642d7851cf5727ac41481c5c70"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_6(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e75c87acc72256b4c1eb11df060dc3fa21c858b737178dc61f907c57787b4d06"),
		nonce:           decodeHexString(c, "0487c6c9609f9de7db75b63b000c3af2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a87bd43c52d4a7c9f21f53fbe2938e59dfa8df09a2cfc110174ac4a66f01e95a341d8a2d5feeb24683852b2e123522c91c4833d0fec27aafe2e774f4c1c938336e05e6c7f2f3e0806be945ff2301a44b21bb8d6ca047a9d0db1b404f38c66afdb4cd495618a5c6e132368bb950b3cbaefb2323f289918f046c8c595e7925f6ff"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_7(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b1ca7743d644438cfae752bcbc1489622376ceb0e8272b3718ab0d71165165be"),
		nonce:           decodeHexString(c, "c3c5b30c0b4e599c7e710e6893248d55"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c08cef3165727b8d6c4cd0068501a6ec22df38c754cb0e1ada39c2f902db475fedc449c34c51229ec77c52a592553ed2ff4b55907fe16394b61f18693cca19902a692cb6737d0d3b740625ef86f0eed0b9f8129f709c8cf68374b031c887cce685d05d6e50675adddaee662d16c2e7c6a5e450f407b6c6db63d76576555849d1"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_8(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b37f987c7c36f253852ed7d07af677545364091187c0fa7111f03affe8f65bc1"),
		nonce:           decodeHexString(c, "6005e3904c94d629d161f81fa810b7cc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "84a0f66555383cf133fc3e116578335685471ba8b7e6876324f29d0f991e6e3413f0b19edf69dd60ac05d4d7d7189d11f9fa2eb3be1013eb59ff32c1d576408bbb11734d3c8538327fd4f20f5d7df48cc59a3cc985d8783ee2b6b12fd991b0658fd25764360071cc96dfb696bb4baccb61bb293dd6c26c11f0939bc5a4f6e774"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_9(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "416ceb8c2ce590b5773ba8ec82fc91122c58808273d65615f8ab023cdff77692"),
		nonce:           decodeHexString(c, "3d11888f43fc72e329719c8e09852b4f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "38e71d00732e20b2eda46b185e5a45647ad8cccfb987ada270079cb223cf4271618a41df6551343e093b0d5abbc079a406e2fa6cd955bb86789c4cb3fe42ff4ba82ec3f03329ff786e34e681ee26b35f7a8d764e948ec80f9f6d7cea6b939039961fd22806ae5a404febbf7e062745a0c64dd3e87922767309fbea5d1b58a7ed"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_10(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "34bbe706783662324f12047f1bdd4cdac8b09ec3e3c8a3faa48d0edc3a241042"),
		nonce:           decodeHexString(c, "1924993c64cd8395319bd45471502f5a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9ecc31d722e6764e358bb7d9aa2a278f784e2011f46df7ae633ae9427963a05e52857f11eca36b42e76a49366bfb335ebecfc61c9c0180f3d102a93472bd4564eb14ca40511d8e846f387b11a37aad97e08900431b303acaff746397bd0442eeb19af57f213c3233f3d8656f139518db4fad823ec40f2d7e637c57a0eb192d70"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_11(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6d7bd10ada2c3b56c42de6634dce1d34270f04f0e1ae89f804c90ef4b2dc8eb0"),
		nonce:           decodeHexString(c, "247373004e17d7704484049dd649e8d9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2d8f85b73c227092d44567e23ea45b90b674c3e29e9356a33180cff0c8dbdda915ecee403524fc484889bcb3c78713bcb3642faafd75fb32009732ed7dfe352528447b57b6863609a626631a1e84eba3dcc7a23cc66717ec1225e29c9774f8180a6de671cf5ad21a2fb2387f63b9974b47cec7027889310d41fe6c802f26026f"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_12(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f86bdd78fbe954f941790c8bdd1e650929c3797afaa092346faa22a91f6a1a0e"),
		nonce:           decodeHexString(c, "9b5a2d78c91bd9e28b138f0476666be0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b8083d6337ab2429b4301bc0b0e0344a63e4a11d7804b8a89ffa091b069a41664ed0e807f2a2a5afd1bc6c44b4d791c433a76a0de89bc0470365fafe11a82538e31a44c3e6e263e330873c3ce8f220dc239bef3cc06bf778d09219393957a1162bcd2e7d7c2d58fa8df2f1793b0ca773be634e5eb0d8204ee89b9c08add83050"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_13(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "675d0f1b40e76ca58a97fc167de10fde8fe12f9973584f843805c23b4ee569ce"),
		nonce:           decodeHexString(c, "d5e4b9857b535e5bddd172efb6fbba5b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dbdb9b0230e0e5994fdea825a92a123b18313894d83c24223758e76ef61b841062af470ad9e3de28d0a1a49731c72442df14fe3f63f4fa408cdc513dc31a8c09f68b127fdeea936231dac202cf2b63dd08083fb5a63f6f409d1e54dc055e11af8392efa83a0cbb68430286e8984aacb54c13f73f29490d7d2bcb7f956c58291f"),
	})
}

func (s *drbgSuite) TestHMAC44_SHA256_14(c *C) {
	s.testHMAC44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1006646f977b83f4d90870f24b3b72d0b4947037f7671a64ce3b52829506a519"),
		nonce:           decodeHexString(c, "5698d50f59c42b26339d218fc985a41d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "44ab1d22fd3a84f8847c33d0fb0aea66408d5181b8ea95416beddd9784d86d72d2851857b503253016036246cea11f2ad2bd18fe56508697a50b14e7c85bd9b002deadbce5ff9f72508b6ebce741dd7803a2d8633dbec235cccd37c089c9d747a52000ed4cc1dc8545ddb65e784a698bdc74a6ff4fd7b3dbed31a22f83b4fd8f"),
	})
}

func (s *drbgSuite) testHMAC46_SHA256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMAC46_SHA256_0(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "30197171d85c81d6526474b43cb5efafeba746119ff10ef2a96d9b30f40a354b"),
		nonce:           decodeHexString(c, "c634e60d27088ed0cab663af404706bf"),
		personalization: decodeHexString(c, "1f0977ef52e535260e4f5a0d749fc6b2e9752e0f10848ba939a8b1ec3320b333"),
		expected:        decodeHexString(c, "af1a3ad8c297300fd1a7e32a2d306f8265d287aa9fa1e3727b60200ca8786bb2e4e4a44cdd9e12ecf396fbc33d067c8167e202c5a524d0701b30be08697ec431dc497473046a61b69e3becb128c23d857c5f17442760eef220102d38be11e21fb4cbe5398267fae7de5aa3e29f79c30c70ee39a7c06e05874e7a2b8c1735d6ee"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_1(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "455f4d93e91d45a36faf6bbadceb021f446852e8a2228b5934972073a131e80b"),
		nonce:           decodeHexString(c, "49e1804270f15512d811c74ed9d5d905"),
		personalization: decodeHexString(c, "50b1bd2d3ba3be6d048e069cc8969ccbe8ba3b0dc7273ea0cdeabd5a779f446c"),
		expected:        decodeHexString(c, "b594d436422690f2bd83d304b5333756785c4851062f47e43f0fbaa89dfd0ab4a94faf7cbba5541bbcbcc2008aff50d88ef876c12dd8364235fd41240cb7b0908f980244ddb29194d06eb389960311396aef4e0641d95e9c26796fd793f15a51e69911109f41653e9738c00dddee21960854202743b9362a282f2216a43bdec0"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_2(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d10486ae771b1fffe1360ff70eaf5264272fb402162af835d6fbca194c4bcfbd"),
		nonce:           decodeHexString(c, "a269686bbfd9a3031da2fd5421da5dfa"),
		personalization: decodeHexString(c, "2611bff5b6484e76641625a1887b4844098fdea0ca73a65bf6aa89aa0e5fd15b"),
		expected:        decodeHexString(c, "6b44ef05d0650180b94783bc33c1c7c664e69ab5466bc24d6ef44ebebee15f7bfc22f42b34980aabefc737ed456fa903f651e73173d64987b7b2a54d8b25fecb69d74cba837aad4ceb6738f94a13c7eff800115b70b3e242b8ad46cc0972269239eb68d7118bfdd99bb1c4dd95f24f8956cb802a0c2cefb6b02ceea2c0a05a1b"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_3(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "76bc1536924130b36b83328f40adaa1f8fea9aa24809e2f1b1886e8421ac5a3e"),
		nonce:           decodeHexString(c, "cafb00f40e590ad87c2f9f1404bce230"),
		personalization: decodeHexString(c, "c6a45da5b04af67d0d1f5dfcb388e8ba51e675aeebea1a18578f51b2e7ff4fd7"),
		expected:        decodeHexString(c, "de051ac87331749acfa44341740bd5f67afab1dfc67ea340610a70900d049171ced410ed4d6225c706f0eae3599f399c633782957f93eca8f9b0afb94d342e8b8ee8b27fbb3467b75eb9f32239516b0a3dc0b8d0794f05abf149d7db416cf52cb73a8f97b6ed578e654812e514e6ead5a5058d8b57b704a8cb6a7c243f5f5e26"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_4(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a207dcf464ba938e1e9f03d3c4990702481cac85e3c831d74c0ab1e718636c6"),
		nonce:           decodeHexString(c, "ac9cbd6cd10c793d450c2dec09d42c30"),
		personalization: decodeHexString(c, "7620cf6a8828eeb4369c5f3841466d06b7ad38dc9de90293307b57632bf43def"),
		expected:        decodeHexString(c, "c4ca1ab0ad257e3de0879b4c8f4bbee4e4b22775e0f1709b8f7b1b30c962a6c867a8e49e1a7e8639c8d1510d51911f1b6dcf5c0ae42ce7f860954c3e954dcf20d0f56378ceb43ca4949deb4b7d8b287da600c6c31ff45bacc2f75c106734a0bd810865ce5d9f5d84a15fa942d271aad26d6ea9b263911a915715b0475e151102"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_5(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "df8aa843e8a06278e1ba51f529bd108e90ff710b6d8a0b957f63ec364c411ab2"),
		nonce:           decodeHexString(c, "1d20f877693716f5b2fe8bbecad9fc06"),
		personalization: decodeHexString(c, "509a42718c5d8f24ccdaa6a546eec3bce0f8fe785bf3c72146024e8e7c122e09"),
		expected:        decodeHexString(c, "03233972e3378a35c76171ff5847d111ed39114455b1354aefe1011ccad284c9e8d3dbcbebe7cf86e82387c0c025682887350796f080cfab3422b0e9ded3a60f274388a0757e32358f97c13235f01c803eddbb0bc3abad143dd050bdb0086b97f57d193a44e3d6adb2f0ad0aad2a45879ce13eee25e5615a39b570ecbe673348"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_6(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "aea9f1ab7f2a7b176f76a1d114688dc3a692158c2ba4fca7fc6285477fe8e6c1"),
		nonce:           decodeHexString(c, "ac2a7d31a95908a556bb7c75ceaa21d9"),
		personalization: decodeHexString(c, "78bac89b1cc0c21b32c2e24394e9385028c0986d4639b34130a6983a39010240"),
		expected:        decodeHexString(c, "2dbc34d5d949d830d0684c8a21049bda78aab9068f15be81551a5961e6be5c3dbfb3e8fdbfe131a72e69a2a68ecbc9b5baef8fb7c75ab1383c04aa681aeb5e170219ef60316d70d44076edb6e1f8dbd6094f4c7befad0138c6393e8f8363fd708efbc9610d6b1ec1a3d2bc458bb56b6a33960dfdfd381f1f7e4626385c7616d3"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_7(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "329cf7fb5c8905b7ed6a805eeae441318fd4f793c50c14a8aafd04d476109539"),
		nonce:           decodeHexString(c, "c9ad01bf21904253b76426d94634ea74"),
		personalization: decodeHexString(c, "b79f0ea558c4dd2e42bfc592634a92d51ef6c13154a6c1eb51c9d08557a1f6f1"),
		expected:        decodeHexString(c, "3d23e8d902f844403f15425d8a177d7e5bd7d337279f12e8df350459936d7fc86105a5f34c573c0c9554ff9ab663aba74c36f243a8f1770f80bff3f15776aa7db7815af6e9354782c0d02375063345a58bdcf4b838124cee8e810cf75430f9ac54ac5955fb7c79ed7c6341606e82138c131e6e1cb9ac6e0437bee5da68eb2c66"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_8(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "adf012e2395c2d53e3a6e3e73a1d5f83afe1ac065a75f6b20b45db14d0d12734"),
		nonce:           decodeHexString(c, "d729499703a5fb90f9b1d6c6989aa8a2"),
		personalization: decodeHexString(c, "e97021e3b7f72f5c6bcd82e654706e83fb409dafe4dd98f704f03c6338d6d24b"),
		expected:        decodeHexString(c, "cebe2a94bdc056224498fd95cd3ca676997da94839f3cd0de7a3beb0324ca13ff269db8027d0bb01daf4dbe55ceec325d34281955f425ab4edaf311fe85853130144c43ca1c42502c921d28a7b7721d32831c34d2ef9b9ba8dcd43650025a95afea2ab2731fd43fe9781835caea31a5cd178935f5a8374ce78a337725048cca8"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_9(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e29de9b2c5e069f3fc29339ac517e70d9b9309fce6076551b9e5f016567641c1"),
		nonce:           decodeHexString(c, "ba666331b85bb6d8a763df9d30a6c6b6"),
		personalization: decodeHexString(c, "67abf3319b242035460fbe09bae8df4f10600632a19295131543d270ba45335b"),
		expected:        decodeHexString(c, "df4fc7fefe67c4b59d29cfaa6538d1d6a7acd4ed0b6710dc7a98772af519b2d563a0b4840353e987606e32e02c6af4a43f25404ff4d3c98631d73b6412cd4c4f9aa13e3ac7decee2e4a5180675e04d6b34415dc9fab1216dcdc4ba219e9424d6c935c39fe4ddb9f5b4cd9ed40315b068a02b9c20fca9b898c5136ccbf30bdc03"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_10(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b2ebee204c7165dea375e9360f308be3ccd3801a71255e0edd1f42ba3ede07e6"),
		nonce:           decodeHexString(c, "486cb1ae920d332847d7019e9fc61611"),
		personalization: decodeHexString(c, "5f3bd6d419778e63caafd45178888777efd7b484a29e9dea30d450654e01e83f"),
		expected:        decodeHexString(c, "40c271a1dbd1dd069bcea65d9086b6b2723472a9e9bd6ec5e9ff479e8335e04d3cb988b0d0ed6d5b8768458a2aa1cf5d94a96b2c824a0690376b87c9dd8946f62699406e8fef8d5a997be8e3f63e815f130786cd5d4f3e500dc782263145911c6e69ffe406ceeb3e296594fce9041ad77a5b005158caf3617b8fe3bb0ae8f2e9"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_11(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bfdf29359846af38a24267ccb68bad50858b8b9ff47ed5fa8ccb99694ff9eae1"),
		nonce:           decodeHexString(c, "ccafbc9dd71255d1ebfa76617642d6d2"),
		personalization: decodeHexString(c, "71e50feaf0ed045972b44d80b599a2087fe250d266f1129e821f54b57d99ea18"),
		expected:        decodeHexString(c, "4988a75a728f9e89b3d68824062ba03f3bbc1fd651749ea8522de4b466f66f35dc202b2d87b8b05671cfa5dfa79347e621941bdc81329c3112bd520337ccab5cdddd2a982abaef5619d076251f5ca0b5e4550559ad0884727494105b40b968c071c3c506ebd72532585ba004db7c9eba61a0e30f2ee2aab8c5e5de1ff44a8731"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_12(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d10f709fc7674fcc37e77b3214308dce6c0433b4034edeae098564509688622c"),
		nonce:           decodeHexString(c, "63c3ab9f1b35626ce98ccb72ef3ad5fe"),
		personalization: decodeHexString(c, "d9ecf8f8e9f3bcab221cb29dba385737daaa57853bedda0cde26d61edcbcef3f"),
		expected:        decodeHexString(c, "3c5fe9b3caca83b59cbb33dacd55fc05021bd648dcc89c39226e0b6c81ec0053d99c4a68a627b41e62199de3041ae79c7ac46c7de92cd26643e5c472ffd1af0262d10c7f527aedd41e973f5698b9254e9883149f6041ad8b21934069543b408f2a66531d22d469144e945a11259e9e464f96d8feed8bb14badc11ac942a7dcd9"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_13(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d74f66ecb33efce890c4ee4aaca1d3438d82eb65ea46a137d0d42d5be4b13f93"),
		nonce:           decodeHexString(c, "bbc9981a2959721c7b439e42e00c1aa5"),
		personalization: decodeHexString(c, "91065f0c37c28fbcab2c1a883614eb8889dac50f53248834c7d5a3c2ad24d0bc"),
		expected:        decodeHexString(c, "e1c36e42016a1b38418d6f93cb6816cbae186679a4259369576b2b466d66efb49c81e611550398208a793d19f082fcc0ffa2567693fc63a6534028f5f707faf029b79d6957f6aa613a2462dde735cac2046d000817eb59362302ab30cc69c658a2e975f18c1862d5d0f41e7b1171fbb8de215f176afcfbabbf8c458c444a176f"),
	})
}

func (s *drbgSuite) TestHMAC46_SHA256_14(c *C) {
	s.testHMAC46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6cad4deb8e3c18f4f4265d845237bb0f9760b379292e363d5ce8e5bc243fb2fb"),
		nonce:           decodeHexString(c, "50f723edc4f658862758e149e7ae4f20"),
		personalization: decodeHexString(c, "39d43e627ab7c7a6d12fce4cd8c001678bfadd9d07d4086674e5d8bdef4ac62e"),
		expected:        decodeHexString(c, "02e68bf3f78812aa270619b307dc0e57b05b8310084ecd1914a67d93b77127e0b3ec40e359adc451eac8788ac708fde70575fc1b9bbfd291bf5b8d7bda7bcc23a0271ba0bb0e6d617132399bd6cedf5a9a683ea98b3b0dd3bc6d811e4f66c9ec751012992cf54e3ce474e09b31ba9c01ea231d4fa8f09441e204c4d3285c78d0"),
	})
}

func (s *drbgSuite) testHMAC48_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC48_SHA384_0(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a1dc2dfeda4f3a1124e0e75ebfbe5f98cac11018221dda3fdcf8f9125d68447a"),
		nonce:           decodeHexString(c, "bae5ea27166540515268a493a96b5187"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "228293e59b1e4545a4ff9f232616fc5108a1128debd0f7c20ace837ca105cbf24c0dac1f9847dafd0d0500721ffad3c684a992d110a549a264d14a8911c50be8cd6a7e8fac783ad95b24f64fd8cc4c8b649eac2b15b363e30df79541a6b8a1caac238949b46643694c85e1d5fcbcd9aaae6260acee660b8a79bea48e079ceb6a5eaf4993a82c3f1b758d7c53e3094eeac63dc255be6dcdcc2b51e5ca45d2b20684a5a8fa5806b96f8461ebf51bc515a7dd8c5475c0e70f2fd0faf7869a99ab6c"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_1(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "067fa0e25d71ea392671c24f38ef782ab3587a7b3c77ea756f7bd496b445b7a3"),
		nonce:           decodeHexString(c, "ce6acc722768ca0e03784b2217bc60e4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16eaa49510ffad8cc21ec32858640a0d6f34cb03e8649022aa5c3f566b44e8ace7c3b056cf2a44b242de09ae21dba4275418933611875841b4f0944a8272848c5dc1aad685935e12511d5ee27e9162d4bb968afab53c4b338269c1c77da9d78617911ed4390cb20e88bf30b74fda66fe05df5537a759061d3ffd9231d811e8b34213f22ab0b0ddafff7749a40243a901c310776e09d2e529806d4d6f0655178953c16707519c3c19b9aaa0d09fb676a9d23525c8bc388053bfccfbc368e3eb04"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_2(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9f76503e84727297bc7056c7af917a1c98baa725295457db4fcf54ed09af7f15"),
		nonce:           decodeHexString(c, "f39c46142b85a67b4b323594b7e97bde"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7d6a8bc5a7f057ceed6109bfac2486f80f81373b6b31d062aa1fad6d9eda5874867b9ef007ba5a92ba8f3fca624bfd9f7ee5770bbeb0391394fef783c16a7f003c06e5469bab03445bb28a2111def415d162e40472d3e5ae628c5c63170bb19f741c79a5331c883c12bca429f518bf71b14683a071b6c6e1e55d8c7a0f3942bc12a103556c49ca173e498b3b4a15027145cdaeb195bc8a7e1aa82ebdf6ecd516481a4d21f400d0d71b5894545888fee8beed80d3251647947f5abc4735b47fd0"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_3(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e242e5b3b49d87289fe02840dc742a2a6cd9490fe2cce581833dddb1edc0d103"),
		nonce:           decodeHexString(c, "f987f5de5c68cd345c81b032ea55f36d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3a858345dfaf00defdf6c83114b760ef53b131fbf14bcc4052cd948820eee78a11cbbd8f4baa308e1d187fced74cbf019c1080d9efffd93fda07df051433876d9900c1f9ad36ea1cb04989bb0c55fd6d01e46923f3bc8887ac00ebd4710212114165355361e240b04232df55a81add3fb363f0d4c9c5e3d313bc7caac7d49dca8517cedacf571fde9686ae93d901fb9b17097a638bb9899cfab0ebc9d1f8a43c2eed7c9f326a711d0f5b9cfc5166c9b561824cbd7775ec601ca712b3ddaaa05b"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_4(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "42cc17365f5ea5fd22bdc4ade715e293064d6794d82bed5b77c4c107a73de1f7"),
		nonce:           decodeHexString(c, "6d759e4b191ba01e0ed5dea788ab018d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "de06dee8c8fe453aa03ac2546c39f5cda12412864d52ed5cbd0d4905dd226746d50d1af9fd3e1d90de0f16295cb7f6f4d3271ef00564709df4b05eb9f8adc0f8e8522b05b9f32c37d8526813898b9f71db57fc8328e3b79144482e8aa55c83934d6e097e43ec6d0bc32edaf8c0e6ca449b2e8388b32b286e2d4f85266b0605fb99d1a647565c95ff7857bcab73662b7218719189d792514edca2b1d0cdcd9b6347e132ef4c323da24ad5afd5ed6f96d27b0f879288e962fa0baca3d5b72b5c70"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_5(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d57024a230b825b241c206f7b55e2114461ecc9b75353f12ac1d9ad7e7871481"),
		nonce:           decodeHexString(c, "fe401c320f74afdb07f566ea500b0628"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e8930bd55a0a5a6d83a9b3b2cde7085c2ae467ea4a2e65ca303697d492ca878bcb801769eb1b7ec564586ec8b36d350e192c4fbf03a98be0ddecf56d465914ba353ed7734d19a680fc4593d9234c4ac8c23b7dfa1e26b013f590cca43b9fef126121b4842496b11dea3ef5e981cb357341f03f92a546a62609236ded6f7d814456acc0596d555cbdc02cbd47dae2caa1897831ea464225922c6600a8bb92e711653067f83b21e1df054309858948c11a1399736fc8391c5b0fc35629abfa5650"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_6(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "059ded79125b2d56d9d52bcc950bf608d1a2373515dafcc81efb6588005a5722"),
		nonce:           decodeHexString(c, "d8f5f4181f9f2a316c93fdfbadf50e75"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "db65d2000632c3d7009c227e99c210e5897f4d7edae608a242b5a4f17708613f8c19a4dd65d6bc3ca57737c9bfdcca068288eea49440af768d1fc977c32b065bb71aa3d8c4d77c9e8e8a6166f332a247978a6c41ed253a1b68ad934a3416b40344a681de28638f00b0a0ffb75514c3f62253372f809906043de35e4805b8e962e5eb957f04212835f802b2c0b3e76c7cf239c89adf31909cd6224d542d929f9b20a10ab99a7c631e4e6188fe2ba8f552c9c88fdadb528679fe950431641b8f37"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_7(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4630406b475b1263b6078e93e5d4282205958d94eb97d1e66b429fb69ec9fccd"),
		nonce:           decodeHexString(c, "0dd9982c338df935e929c42fab66adaf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5d80ec072f550981bcaac6787c0488cc470406249ec80f4bf11050630227f8b5ac6b3b369db237d7c24a0980dffe8d3abd9b64fd4efa492349bd4eb6902edb94553546110227d7de5a864ddae8b9fed8de9f0df9c596e39de903fda323ee6f788831452eb9e49c5eef3e058b5bf84f61f735a93e042bb9e458df6b25f42a6eb8fb03d437cfab757fab4990c721a757eaa5e9048208abbcce6e52f177b20dcf52f1fa551a92b68bcdb01680855b8f79131266378cd1f0c2a4141c9675f01d1e48"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_8(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6ea9c6f784f12a9707ceac8a7162ee5381dc893ee139f8f4b4d93db266829db4"),
		nonce:           decodeHexString(c, "ae92bc52ff860d8ecdc9fc16bd070130"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "234366f1591cfe244956f9496cdf446e0d390ba64beaa066945b1b4c5337dded2619dd2bd0133a5d612bab7c251ab79e3951cb134894c422553fc8cc7b3ccb29c20adbf52dda35af779142d7efc735342db2ee067649fda25f3e8a74f8e4f6620cf5a17cb943602609cafb85bdf482873efa4c74928cc0d69444b72aa6bc72694a3a21c6a721aa4e0fccab0a98aef375a37a3e8a15dccad13b6d70b3483581004642d879804aa00cba207b51affca43490bb98f67953265574366ec3829e67aa"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_9(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5c13056be92a7f71236fcfef460298acc8595dd474310727f5ccb9a7acb2254a"),
		nonce:           decodeHexString(c, "c7226f86349e20e2aca737068ab0f2ce"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16d415eddefa4dc295a64adcbbcb8c6fe8c8f123c6b09dc08a56d723cff5978cc120fd0a68a2f4c202c220db372d3128ef52385d5786c12dfc6e60ecfc3461a09fa80453e2b1b6365eaeb4df602d192aacb25ab6b4a59689d4bf8d1c4c42a32779f62b06baca6461f154cf40901f5787c1aa2bf67cbfe7546ef5b2bdff20790d8c72d077d48c59c92d1af90a90ccfcdf643dd9d6cee0b1faf5f2f35cfd01d2077ced5e2d013ec1e09336dfab9d9e51ba9a3a2837306213bca2d79abf8dc3282c"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_10(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "38f08a099fc2d405c32d1e0f867e5450d5ee0d53783c31de9ddeae46d962999d"),
		nonce:           decodeHexString(c, "a01f13a43320c715612cedb920cf12eb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "079ce7a5b540cae96c2883e95acde3039048a6c45a2d259cc648639e7205392d91fa3ee080e615f1e0741a0e536c9e05844651b93461bfc547fb452fec61f853e1bd6e08eabd0cf1c5f84f85eca9d42b53d1e5bae51be5fd35189e4f1c02b843c6361fccf4ca6648bf30a23ccb8ebc16fcf158746eb39cd96f19d46707c001e11c4e0e8ccbc89fec66c69fc92843b6bb2ee1cc7595b65ba89ccaccd6130a8417faf705e8e203e90ee64ae970c409389b5cd0ca80a4e40b642689741691b20621"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_11(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0863c868c32442a1a64095a71ab6ae2f9e61c119b58dfa4f34efd26593bbbf68"),
		nonce:           decodeHexString(c, "bc407904c43300452dd4e61df47fa98f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "585334828cf531828fc7127fee0c926f85b8e71e8522ea921296dc62b83a09a00397cd45e0664d0f26fa24edd3e3d8ecef8fdd77ab22431d4066f0efaf3882c97f179a7060efe9e8cba5d8145bebd502c0e09ee791231d539983c08860d7783edb58440d193ed82bc77c27723381a0da45bb1fc2a609f8b73b90446e39869a5af5038aff603b44db9771113927a5297fdc3450eaa228e313afe43c31b0a95b476c5ca312b4f589f809749481722cea9990c02b647976aa6c6f02ce1e5e6ea6df"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_12(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a41ad223e41e2bb9c131ec945ca310600ab00c51f6e4fcddd803bd9ab9be8af5"),
		nonce:           decodeHexString(c, "483373838894d32745a81ba9d6967751"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "95ca31a7eeebdd2348cf1d43411d2c35faffdbcaed4052d50cf92f0e9d2e757686b72d631a56ca98b68215e7014cfed943abc1e13441c1d660f13adf2188d0975154e1b42a592a62a43b57f82cc21a428873a92fda83abe420efb5233140e4d6c7852cf81e85961fa5c606c5f33e06077f414b0f814cbbe50cc606bffbd474364e608825fdaaf5e74d862795539be8697e2ce05d71446881e3f65bb54ed95e941586988f6e0c34e1beef426696e9dbd9a214013d826a8c99a2a686d8402c583f"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_13(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "62a26c1327c0ebf8b40691fb4c8f812e81f5474b0c7db70aa9424110fee3a05e"),
		nonce:           decodeHexString(c, "41c0cf2e87210e34d0c6bffc269bf2ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6e20a00df1af37e6cc55e580ba21335111eb375395343618df7d630b9dc234496e3964cd45c5de34bda46a28964f6148704c30925feeaecae0574038434cd33c1dd943207a8dbdcd72dc9ecb76a25728b3c2a8ac13c1de3a126d7d43a46e12e0d0ca8991469e582b78ef6aa691b5a0e3e85cba7d7aea3c1e8e031674e85f5af36546eb2a0a28d4ffbaa316a9a6c944fce291cc0c235e8499882eb62b22b548ae07cf9430329e009f4443cb94f7a14e8661166b0d681dcec867205abed48145e9"),
	})
}

func (s *drbgSuite) TestHMAC48_SHA384_14(c *C) {
	s.testHMAC48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fd54cf77ed35022a3fd0dec88e58a207c8c069250066481388f12841d38ad985"),
		nonce:           decodeHexString(c, "91f9c02a1d205cdbcdf4d93054fde5f5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f6d5bf594f44a1c7c9954ae498fe993f67f4e67ef4e349509719b7fd597311f2c123889203d90f147a242cfa863c691dc74cfe7027de25860c67d8ecd06bcd22dfec34f6b6c838e5aab34d89624378fb5598b9f30add2e10bdc439dcb1535878cec90a7cf7251675ccfb9ee37932b1a07cd9b523c07eff45a5e14d888be830c5ab06dcd5032278bf9627ff20dbec322e84038bac3b46229425e954283c4e061383ffe9b0558c59b1ece2a167a4ee27dd59afeeb16b38fbdb3c415f34b1c83a75"),
	})
}

func (s *drbgSuite) testHMAC50_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC50_SHA384_0(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2cd968bacda2bc314d2fb41fe43354fb761134eb19eec60431e2f36755b85126"),
		nonce:           decodeHexString(c, "e3dedf2af9382a1e652143e952212d39"),
		personalization: decodeHexString(c, "59fa8235108821accbd3c14eaf76856d6a07f43383db4cc6038040b18810d53c"),
		expected:        decodeHexString(c, "06051ce6b2f1c34378e08caf8fe836201ff7ec2db8fc5a2519add2524d90470194b247af3a34a673298e57070b256f59fd098632768e2d55137d6c17b1a53fe45d6ed0e31d49e64820db145014e2f038b69b7220e042a8efc98985706ab9635451230a128aee801d4e3718ff59511c3f3ff1b20f109774a8ddc1fadf41afcc13d40096d997948857a894d0ef8b3235c3213ba85c50c2f3d61b0d104eccfcf36c35fe5e49e7602cb1533de12f0bec613a0ed9633821957e5b7cb32f60b7c02fa4"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_1(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "023f5673dac29f62245510d0a866629c43c64bf35a0bad30f1270050876cfb1c"),
		nonce:           decodeHexString(c, "e80b615a5a47ecb51217a46079e11fd3"),
		personalization: decodeHexString(c, "a6f797b155d6da01f5d155cb7291442e1b82d4190e93e279fe5b4aaa7d04ecc0"),
		expected:        decodeHexString(c, "507b824443af5db28f746229e03ab00c73cc3ee4956aa14b33eda00dd2b9b645c132dab7dcdbc659c8ba0e1a3575fe7dbc7cf9691f9b714acb1b33bef96943003c992f661e04fe9e8b9f648f4af9a58a45b08b8fa7fa3704e6bdc289abbe14a8c7e1747a52ac916c31ed079de0b900672e658a201279824d0d75ae35dbdd43aeab915653765d83e46f347fcb4fe3321fc28abd2d0d26a662661582ce21b6dc4ea6d1b236e9692a83c8ba0fb299157b80623ad4f448d25d57f537b10e5e30f80b"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_2(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "96b5bc16ce0d101b90d54da6c4b3d85a70ee19d54cf4cde3d048afb5f758a6b5"),
		nonce:           decodeHexString(c, "2ea2c10c16feb71cedfab9bfa9e462f8"),
		personalization: decodeHexString(c, "2ff415e2432d2e6c4279910a5e56c0f5354a5af0099132d891943b4a8901ca6c"),
		expected:        decodeHexString(c, "ecebe717afe6dc08dbff3ed626bb06de0f9784283b70e378dec19d4fbb50e61b7be48ceb69851b2bb94641aec5027d53d314a96500a9bbb38a87c9aa42ebeb96a23cf29a0fbd5e48b399daa1b24dbdc85223f24b7d77332bb1a137ec709d27c008c709696cbe44bb2fc19fb10a2fad4ffd8a9d89492a939f2268d1557f44b6a64e2a57887830fd8bca1b6306aaedbd7f3f476b827995a1ed121388497edc7e639c87d092f6591a45b5647c6c091c15ed39f594b7fc4ae92331f96dd8e17be970"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_3(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "364a833a283a3e0b8a5b681daa50df96d806d4b54828f2b016de5d88597e6287"),
		nonce:           decodeHexString(c, "d98cba8fda464d21aa1cfb7b26b9b226"),
		personalization: decodeHexString(c, "35b0e7534014dc2d7eb0f20ff78a69d5548d0a64122d4936a6ed177fb3ec66a6"),
		expected:        decodeHexString(c, "df4c799cae37173a81c545d019ffa336ef2c039a5865af425e5b60bc3d7202f4bc1aac5a84022bf4088061abd5c39d0fb047ba80163eb5dc8b9dd515948f16915832c6f76b45acc25b9c01e7f70955c0eb51bf50f00b24bb8e7ff53bd7c051b53d8b1a837a17a00355d7eb21e43b2b5b249dadced37d06e7047c2fd12012705a59d051afd26245ce3a59acb4b996b718c7dc1ae964bf12b1db02fd6c06ac2fec6ee5deb02c2c830110e9bbbd3c778a136b646ce2a0738563555a89409c56b81e"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_4(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bb4d38c775acdeed663256abb747ec25182bc16efd0de02cb4b05e4ad4749c92"),
		nonce:           decodeHexString(c, "be6f1e856e423a8f3bfb0c0f27ad8210"),
		personalization: decodeHexString(c, "21591e796b7e68e7913fefbef4872af9c062f21c8023c0dbf47e040c3aed3733"),
		expected:        decodeHexString(c, "12575776e1b9f54b0fbc39e85a77b6912160bace4f1e9f049e3a1c5bcb452cf9be42ea10c028c3cc249401ac236dd3baa53ff327735435f4869d3289bc9465ccf15f826e4e4fff099986bdde0d09bd12e3caddcf452eed6ca1206ae4561b84770a9cc6e962567304ef79d8d3608529a3b5e4067fa83c8c35a06f1855da5f5ea7eb106e4c60181d12ba00cfbf7eac60bda00571d95c45c9d75c43b42e27a238aa5e0f02bbd96cde59a2e572934a99d05c399ffdf15c65f173748734c51999a29e"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_5(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f9d041d24158f480600c3747cbfd868c3f7e9ac7f74b3760eae5320839e4f513"),
		nonce:           decodeHexString(c, "0f8477d88b1d914c0d8b375d089a4c83"),
		personalization: decodeHexString(c, "b148049f4093f0032c7f105dae219aa9e3f70487ce3a6b6ecd99429f66be5406"),
		expected:        decodeHexString(c, "84c58bf473061da92fa8d56aab3a75598428f18dca504191a51746eb5fcad8f784eafac5ea81d636d579e330baf7db95c8d706432e9f585e84da090c0eb40dcd819bf10e0d5b8600150d186f732af50b431c596c920eca742e6555129fdf5df96b44005083d7a33087b150d63529bee4b6e1ed4189ae2d93cee8dc671d47c0e74ba04218dfe273484a4bb59a57743ea56843d516ff2c72ef9841996d31b0d6c5beef367a6b44cc84cf4d403a06b40406e4c9f47da401e3cf31412694e6164dcb"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_6(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c18f511ffc3479a59357c17c2fb3d1e0e6f0edda4c8b567f2413323c2037f2fd"),
		nonce:           decodeHexString(c, "140fb0cf33eb59526d8c0dbd216939b5"),
		personalization: decodeHexString(c, "7387aa3b0b3d92afb29761d3d5ea16e32a68297b9ea6751e1d54c8612f6351c1"),
		expected:        decodeHexString(c, "949bf03868563c7d1498c69c327686682656374b2efdef6342e69a388229c580ca2217a9332d3ae77c2d1223f5dedf4b34ec50b79d5baa7283168ed7cbe71c6c3c9193bbe01b76e011c39d2d462017c2c74b7e698fa2140e16886a9ec0fc6c36decbae37537638ccf17777f1cfa49d2c2c7ba3aadd0a1565d61942de94aa6fa16ecafc2dafabc9082f23e75a0e2f8f79d1c0a15ce57fef7655f1a4fc6fc4d4a694bf6ca9e333959f35ad354524f614905c6a52ef8f524cdf01c5fadadf207772"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_7(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6b09295110384eb56726f61474bdc532fdace31ceadb5fc23d587356cfac7433"),
		nonce:           decodeHexString(c, "8ab6f9d89394b907edb646650865a3fc"),
		personalization: decodeHexString(c, "7cafcb4db31ab411c396015b8bbbc990607e08bd1cef3337dfa0e295ae024f9e"),
		expected:        decodeHexString(c, "e51bc5b3a6bb2a2667f5d62c2ff9902dd07b566870b4c14242627da7581449ec985739cdc2bb5ef036033fa798112ce20df06d46d61aad7121b8282fe7556bdd363cdabbf47184e55edd85ee0b7b0be17b9a7f822f4d8906465b525c16385d0899b6c27728ff2a600870aef65f58f9d3777e8987d86e59fdb69cd232e7289fc75cf2174304137f988a17b60c57af84cd8e556aaad458f511fc0b3009516435c0c60098f35fb6a4a90d90bc6071d38000703ef57cbc19d6b78a0f797f3ba044c9"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_8(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ec6d0f68240f5c47e822d9088364c6cd03ca53808162b4f06f5956da65290946"),
		nonce:           decodeHexString(c, "f4d26653d079e50604f836c1d798243d"),
		personalization: decodeHexString(c, "b40b5737cc76c5f6d1df0f13bfbac7e26f92aa933125705b6197d9bedb11f2e1"),
		expected:        decodeHexString(c, "207833cf65599e1406ddaf3452f060c872099cbf7483f1f7f14033490f7258ca5fd7f5339f914498b6e61fa426cb872c880a9fda9b8ba590cd8006b990af7ad412f60c8b2ad969c2f9cb0e9d005943d4dd2dd7af9699046ce89d6405597716d43b9ad54641c2278b04b2bcc5b8ecbcd5e2044e4e6ec5a628605fcbd67249e813bb769d7df01b60404d030e69e9672b4fdeddf82a22042b83ca036578b69f9a0ad9702bcf95fe846705b49b0a0795dfbc4f671e0158ded6242bd8f8fbc2410c46"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_9(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "df59ac224e4ba1b6dff348f17bcf9c5a94a3235a54f2799a6cae29d8654b79d1"),
		nonce:           decodeHexString(c, "8b09b444a28a7d537e1a2bc89e95abd8"),
		personalization: decodeHexString(c, "14a0a91e0cfd63ef5fcbe2e8c7a44bcf5769c9f95b6c50bbe9d3b48b82a09053"),
		expected:        decodeHexString(c, "656438e7738d441b9ac116361e9f26adc0e303da7889cf559841b3e44127318edd356051bd0b3ecea78feb2b928227921a0c183c9f56bfd11ef31b28da6c78f3891d8ae1804bc158fa56e8b7a1a46be4954de493ef65a7f9beb46949a323a04e944034db30b19cebd8b70bfc155882ddfaca1bd5acb981c2c1b3e0862c6234d13093ddbcdff15129d586fc24ea2fd20946fe45b467bbbc77a6b6973eb6ea02994607c657eec29e4c4b3915cb730db056babf1779127047b401e25f97f606063b"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_10(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8da1ad6810c1d6b7ead210e48f51c370d4520547a330a4d591e61a9847aa0434"),
		nonce:           decodeHexString(c, "63f69d1b237999fda9b5697f1e7aaa07"),
		personalization: decodeHexString(c, "291c536dac72409e31e71cafb1b5f55c14421b2c7a44d792cfdc663dc8f62692"),
		expected:        decodeHexString(c, "c2bff571554c26bbd4442fbb3b0f8eb4db09840337658a7425613e0fd4f96e60da39b250c3a77379a53325a56ec02248c4d67fb9154e3b0eb8972a3109aed531eccc027705b267d2b9c037da79860d76e5e980b5b30b7ea588fa221d24d973f6d4c625de65123e91613a1528cdee59993aa827f319a759412f20aad6c50fa79a3debeb346ad92809470daf228cf344e09f03c839a28d580a2b3d7050685ef51e95649aba7228a2f0c82a2dfd89cae6ce549e8b27fd46f02feb473645765018ef"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_11(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5e8d6571f514519de6c4c0a7cc5b85df616735b8dd09c3bed2377499aaabb296"),
		nonce:           decodeHexString(c, "a9b2c94642da10e8fa737cdfb3129334"),
		personalization: decodeHexString(c, "6ae29c71b76fc48f14a3d731a0f6f276f73e7672eff631dbb1d22b06463bb236"),
		expected:        decodeHexString(c, "5cadc1264314fb4bc7ed7fa74bfa16aefa624bf2fd60c992d0cba10429c56e0028ebb430b1a1c6662a9b3c7f6de244ca000ae63db9570f1aa3e7ffb1e97a9d848021d8e632fedc037712a29abec4063b9d57c60738f0af0b1aab3844b03f7aacc65d38bec91a11b7c3bf8d970f01e00fed9dbbe9e2e499a21c72a7c5a22864125133ecb073a4c9f6d9fd46024f5c1ee7fa447209afa6ccef1f97ae77ca67fca5959dde209d2597f87af6e154408579cec42c69fa9b7cc075ee3e37ee3d91ad9f"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_12(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5c9481b2642855fac8931eccd1bd6c5a05b560a55f96d37e865f057a95812d81"),
		nonce:           decodeHexString(c, "fe65c84c96a990eb7a302b58de723cb4"),
		personalization: decodeHexString(c, "b6a61b9a31207363d62c0b88f1632290f4f18feb41a6dedb85b7450ff9157016"),
		expected:        decodeHexString(c, "9cc77b68e1ac23fdd2e2a6ff697053f816bb48b39b1162f7aa3fdd2dd1867f68b13980c9e5989d4631b7983248501731326bd7bf6e967b3dee7d2d5625d3cc2e198623af9f77f86103491ebb4aefda5c333b51557b8f643e6d6c593fd7e27e4bccca13140f6129cbd024de076e4688567fd7e41dc7b2bd0bd9b3e966d5d3c461502221b52b001a4d2102894da04172efb900171a0eabab1fd134217580cfc33a0a94edc0bc132af91d048c6f5ea4e34ebc9686a99f81d19118ba4da63ae3df7a"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_13(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c43f883d0adc2b56984d4a497a8ad76813a01df5a0ba22b53144763b65c7bf3f"),
		nonce:           decodeHexString(c, "6f722e4ceac59966a6e44ed898e6109b"),
		personalization: decodeHexString(c, "769bace2c263edb87101743673724ef67a935e1ae9cace87202b6015d20fd9ca"),
		expected:        decodeHexString(c, "ce61480953190453247d091838dd80117f7f85a7e9a1237c92edf10cfa26b423735788b1e89f33625480d9faae57112ee62c8e4840475a6a738018ad3fd4a77efdd8f15ffb621c429419b6adb20431fd35f9d62fb33d500b87beac4856aa4971eb89710576b609ecfe758f3682dd316e7ee9d6560b444c2446656c8941dca7d6eaa70fdf8a70f18386ee5d4c86738bc261c0e8e5f509dabffd0425a86858ea3c71de5be98570dabd80a37b4f7f954002727c0b712e58693603c23130a45e98df"),
	})
}

func (s *drbgSuite) TestHMAC50_SHA384_14(c *C) {
	s.testHMAC50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d083f7f8c65374627ddb51582b3a39e2bf074508d5f28ecce25787f386058de8"),
		nonce:           decodeHexString(c, "afafaf2ad7e6449308e176be01edbc59"),
		personalization: decodeHexString(c, "ddb4ced192f52bdfa17aa82391f57142ac50e77f428fa191e298c23899611aad"),
		expected:        decodeHexString(c, "b978826b890ce8a264bf1ad1c486aaf5a80aa407428c0201dd047fa1b26e9ea9ff25a9149215b04c2f32b65e007e0059a8efe11481926925061c748678835c0066f596352123f0b883e0c6ab027da2486244da5e6033953af9e41eec02f15bebdb4e1215d964905e67c9e3945ec8177b8c4869efc70a165719b8e1f153c41744d44d3c56a15822d522e69bd277c0c0435fa93e5e1bc49bc9d02aee058a01a04580a6cad821e9f85cf764fc70dfae494cbfa924eab0eff7842e3541bc29156f6b"),
	})
}

func (s *drbgSuite) testHMAC52_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC52_SHA384_0(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "26876e6c5336438fc1d6a42db8556b79ffb40ddf54d911204bfcf9815b6a587a"),
		nonce:           decodeHexString(c, "529c6636613073ca2834bd49ec6e9e70"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "de4fc87a1cf14ef0d8024e50ec1644e2166e16efd4b9104457ca038df0e293e09091c9a5a4cca20eec3b4f4d9dedfcec1fad477b995ad5b75c178987ca07b827a354010fea51c2197fa395dc2763d9828cf24fc8d23dd0caaa5cce877fa7b53e964ad64a7b6f4f00a23edba52999b2d636178b458e1b32174ae53b88f01f661c225a2efdd41a747d416c2b4293e06ff0fa8819fc0a81be85bc9dad4d657d220a2fcbf1747d4403b90e8b5aca1abeb5f292f3cd56d7d52d87c1b768c1efa1f159"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_1(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f7bc822d9dbd992050bbe7ce63d75f533d563c679ba79af2319e2621bdbb3a62"),
		nonce:           decodeHexString(c, "2996479aa1eb7b1ad7ad3757ad00690c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "818b7b5362bf5ecfc1a3c9cde98b6c0992c89c10e6e4db7803b855cf1684f195d3e5b688748d0784adc2c17837e7ef90fe89969900d99305b005f7d065adf32d4aa329891c47c92de7ecf212d68de1620a833aec9c25ac2e2c5cab6105899d3dbbb8d2f72188f2aa971029bfc2e35feafada371ab261eaaa0cb07ba718ddc2650927c715bb15b1a9c90e885a4601f492f42c885ab44c6c0dd55954b7776a1446d4b7156b806e4251357b8b98b965f52aa89a9d8fee3b6792e5464196fede4ef2"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_2(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "949d284af749288f9b212fa0f614be223231f23b5a808dcb4a681a6963530a59"),
		nonce:           decodeHexString(c, "fee00892bf66979b20ae63aed253b276"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4677563d7f97cf3e0f306c9b4d25637bde575b50f194ace05f4b4399d402b1ed509766acc0832e83aebad0fc0e3498cbdd5679b83fb144b2872531407604f069f52920a0882d543b552f076af6f1ea30850ea19adb70a258a72e8a06efd4662992c0f5f084ba3a51655e65b6a38ad7ffdd411889170c12c4f2caa32e41a88840d2be66e33a80143c9a0e4128d033bc83b005980891ee20b5564f7b376c3163160b5f3c467ceb57c1cc6b0b7db504c76bb6137997d8d8abf93658b3427c7c966f"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_3(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "35a2f9862d3c5d1854e45acc410b8af3531140bfd0ac396b5b9aad54d37d42f2"),
		nonce:           decodeHexString(c, "1ab6cd08babc134af3e387f67072ecd4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9f548d7d53d72bbccec2712dce82fb5c9004ff99d36817a2a026930574f8f767a653adf82f1013177c0acc6ac53e38ac1d8cc1869f5aff5876a0b11041d362579aa2754c0f77595e8ebfcd842a6c899c81522443516747b77a398f0eb134257cd57356db5eebd5aad023baaa0952c1cb1dc5221f9fb5ffec519bbb62b0f51e36097e442d8ffacc0306702480ae68dc79332941c72492ef1198438a291ff02e4edcab40423b14377b04c3253c3da40af9f1047efb7a6ab314f04014ebd787733d"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_4(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d263f0f194705e76f7999eae32bd273adb72cec1d6bdc5bb4f36ab71d29a0fdb"),
		nonce:           decodeHexString(c, "c0883f1977acbca45ebbf125c3dfbe98"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1a5b7ecebf9ffb969ce8b2d564fab9f713d9efac26e5b78e6b0e95f8270f754ade0afbcaf0352c7dadf68a42086a04aa346db4f082b06f945821deeb252f51961d161262456702c8fede5b122ce3073a64aabc617461f231b72332fc2c9fd459c99ce60064ef3f8b43b318ac9933810bc0481065c624da47af64839f1ee34b46af2cd2d6d2ffbbbad78d0076532d0e6ccf4c7c05d516bca844106831d084b4b3ffc78429c571a55657c954a81d6fa7b4ff3a8cda6d346915344bb35ad6a04f31"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_5(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "63deb4d3aaa7f72938a1e8736d2b8973aab624c8a22c313a8391318ed321c866"),
		nonce:           decodeHexString(c, "2b4bb4ad4a1732ed5ed6f8b3e7c86a4d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "681571bb60bb0f420cd55335aa989a17bcdb124e25280ea74179f7179da5fb8789276ec5aacfcd1369d31ddc2bd42f3c30d9555d529ee967ca01a27ce5f16967f3fec2575803c0b5dde71e9bc9bc4c4ec68d8c4c2caad24bb00144f76b41f0563bceed75f07a7a089f6e6d01214a9ee435c6d4b12087edf0773d33e84ce82fb3b376f7bd0c537d28b659040f92e8ed126734ed9f9767e9ad08305ea1045e243f9336f8f5876aa832e10ddaa65901883afd139c4d60291e0fc25d01aec8d10173"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_6(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bf942c2dc6ea6c13114cdf0deb79647965122d158dda77643d7001bd1bd29906"),
		nonce:           decodeHexString(c, "6130041df0c0b3456836b7cdacf21489"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "627f48a3386b67b9b26281d25f9a63f1e31ab02b4f54f777e4efb010d5adf57a31a74e933d38039477d74a80a695200d0b59fea4277f291f4f4223ecc5cedc023136658badde9608035951884956e471bae6b93799af10273460f1cbfc4289ba6ea5245e1e9d13624bddbf24a6f3669f81eb8f8490c0eda9a7698b66f743a8f1f2e1f29b8f99be0c260a59f5f2210b57b44ba3cab90d5b983fd3608db5b5b75e935fc246523aaabf9b90d9689bf744144aa4c900b5bcd6735d7808e12959d40e"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_7(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ec994004c471addd48523971bc232c4eec91548f1a149ca3119a9c9c444d4542"),
		nonce:           decodeHexString(c, "5cb34f0f0f24caaf965ecf734c120e5a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "89563d7c337798fa0bd9cab2c782658233a8cdf9ff42f1824e4d0858e8e6a02ce3c0fbc4f96519211563b934bee1a23d8848055327218646d1599775b1b03777382745e6876a35116f2dbefc5a96f0efc584887e49966b8e0dedd726cd11ace6c5a57e9fe6330d94a50ad020a4254ee5822216c4ddd122c085f0bb17c4ef680c83ee832ac9788eebbec6eed83f55e6fda1a1860db780366fb007369a0e08f594e19d104f7599c615512c5ea7fb2e736c39c959e6519288987d6e1fb17674db8b"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_8(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6fe36237f785b1f1f423486cde5ed636f8a3f63764b3374ac78e07100ecc8f08"),
		nonce:           decodeHexString(c, "17dae741f00878fc5749c1b91467e196"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9818398c6c6ecf6cf2689bf8ace75227d906139bb6445f3a290ea1280e796b2a2809eb5b73311029bbb3542902ebaffb2e778b0106683326d0f63da777d4d64533a5a3e1db014e491e8408d9c0826ba560dfc89626c9de8da1b8de7f38525e9b947f600f6ada514758c9d2f9a2c30af2fe133c29b4673087129384b5354373dd79dde1e09d9866b7db13d3b6f8936ffbb59d9e7036281d5c67a819527d85584f31e341210772d1d92d9bbd6da162512183fd9fbee285f8ab1aa3c37424635384"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_9(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b3dc10a08bf993887e6f832c863002179269053a902ddb2f8be64de85a75e2ff"),
		nonce:           decodeHexString(c, "6a73b04b74634e5402f3675e92c51fec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f76d670ae68e656bf15f418fb608734d5a729e8ccab91f3e1e026b741cd4db1a146c95dd6fb40a5913cc094af37d42f9420e747ff9fb9993b554f4b4c576134e29ba167178d00051c50ec8db6ddab31849faa888d51e3172f7dfbdf5511d71a9e421c63fd328e06bf24c4488b89a8c12860b4f50dbaf4252932f4fe1d7714c79160822e6b09326e8ab0f6cebfd37b7b53aa63c74eb23f9b76b6f88445ccb2776b64517f0c4460a3b989c280c04a833e14c45b4970c692e0c11a6b9f7980d87a3"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_10(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "081804a3b207c53e2dd569fb43e8f3a1d6c8e4c7d6dd929f640f9ca404b7a392"),
		nonce:           decodeHexString(c, "a95a8412e7f34bed1ee81f6d4a118774"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d5e4de0d78fe49c8e3524fe3e3e8f040689f40278027b677c750fbc8ca04a85d9da9ef0104e5f77a923e2bb16ebddc2e75d0ff1d5dfa7ede9d8b346e427f3b80ae3034b696563f6e2a6222567e7935cafc82b754a920a84d66855f17f07da945e9aae60c58fc8506677729874900cf90aa0887b1aa25e83855040b529c1846739e6de886c2f72542bd159812402bb5d89b0ccb2505abb97802e748a25a879a28d3c4275fe2c2e63ad88e6907f405066e60362bd5f06a45fe42549594d4e68830"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_11(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f5d86fd2539713d7e3f781b2d923ea5970ee621fffcf0cba495fff1e5ba901bd"),
		nonce:           decodeHexString(c, "7d3e11364599ed19cf455b8a450355d6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0f79515263336ec096d018ada253f63cfd5c69a4f65c3893087598ec0a2e8a569243fcb4767d9dd94a1e6cd8fab2cdc4cd7d6dc8015b14e739341a7715d8e2c699bf9b2310cb83bc16db43cdbb2ba02aeb1acd34ed0b35e29cc109d70b62d5f2ee171bd1167600c88d2a2f08379a2107778508d9ae0ca6fd5414c3bbfd02458445790354ed9429fc4307678f448bca3edd50bafc64dc48441286f14669a5c6691c889ac4f7b89fb146aa30e6747c8838d48be30fc483d74345a3de5e7100a57f"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_12(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4e39ed4180d9f4cb5fa769f483b3b9febe6e17d98ad1b76e0ebb3289106070e2"),
		nonce:           decodeHexString(c, "26998b626c94ba599a3fe052252de22a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e4586c88e74825a0906523ef8f390829620bdf3a06f14b93d6383e55d39353995f8cf5d3251cff72caad6d109eb4b0f4dc853a80ba9bc49a68586b07e9d4dd18f31d9a2c8920dd8b905ff58df378a2eb5070c417abd65169a250b35a82344978793bf072217a652b7ef419d55447ddc349f75b5f252c36378d2f4b35de0ee0cc3aa6000ca7e6fac5bbe36af85523b705a91d2efda5d114abf51e6e63bae08280ab019c6cc6a66d91c4d3c9555fb92b79709cc2f55d1cf86322c5089490bed82c"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_13(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "40dfe11932d986451b0ed314510977e47c22df026dbc3187e4c421b4c8b905a9"),
		nonce:           decodeHexString(c, "9ef4615b4e45760341286b6f3c210c72"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d2c4243b4165bd5e9a5c9057c1ce4c65f149f45719e07f2df87980083868eb48068573ef853a4ea84a3d18ac6fffa201d0fb7d20ad2934a80b4ef9dbe472ddbd7893cfe1fd9e947ec05e370772f865c86161ca0ba57e2fa85b6350a4e6dcad350f44cce5f3f8e0a9b53da9f9db98b2317220bce777968a05e5a31a35b6b57335090ff4d002ff384f4eb5ac9203ef0a67e3bd8004fe90817e3f2bc671b7444b768c79fed4c5cd6d0f7566681200756a0cad121d0c32341aff8787a8c621aef4d7"),
	})
}

func (s *drbgSuite) TestHMAC52_SHA384_14(c *C) {
	s.testHMAC52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5f28c73baaabbc09e8260df3b3577c21f2f02be057bf49d2e73098ed5ff67f89"),
		nonce:           decodeHexString(c, "8c2f85b546903d8d4c10fe4549c3f673"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1563c678f1b072813888970996af33c2a6b70b8dfd2e146c46df0616509382062fc9c72d223ebd555f4d8892aafd7b3b61619559fe3d3e7b5e83c07f422eeac912ca7d8858a2d25b966a8b34348b8ebcf44a4651edb9cf5a886e383b01423322ab3002edc8c936aef869d7638f38ca6688c308d2a17fea0ded21901d8e9f1ff8508762cb1dc7e700970938a0ece74c1c2d1801230ea785165d62a7ab0d6d59caf36b30be8e2e1f691210373b7a2866e32ba4b49b6a2f9cc9b80aa1340ef5c76f"),
	})
}

func (s *drbgSuite) testHMAC54_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC54_SHA384_0(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3d8c838b13b1a2ae1624200fb734273e99d7cfd1f5664ddc0219f843bb989ecd"),
		nonce:           decodeHexString(c, "86a712402f94e31a77c4ef90f62a63c1"),
		personalization: decodeHexString(c, "ecf3b9deede92f0db083c357480e5aa35052f04e978a1244a7510db146d7fbc1"),
		expected:        decodeHexString(c, "560c30e54c104655e740855b42ef4c1f1b4a4258b9b8848d872b983e95feaef1bf5b90d0ac269e68127296ca822f5df9db241326ebd6a7ba08c356884162551e396f2507107f1877a253d3ab772a9793e0cb568e7f0a8a66852f5085840c9df500be130dfbfeb4a5fc8b67b36511a865d4d5446a7e1dbb8e6370eefe8b3a7b19120198a423c3780608bdef537191b05cea2322eeb16b5e58e047cb647a2aec836f050f241f3135cde6d0ff9ad413c3420f13be4d410fb16f513af41e3dc7219f"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_1(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ce4ad450a33d1ed41710164acd23563a6a0bcd8aef890ddb5828537f15069e59"),
		nonce:           decodeHexString(c, "cd09493ff51e749b4fe30f59fb4ad542"),
		personalization: decodeHexString(c, "0515e1a57e69ca196748176ddc4e3d2d36aa1976755fbc06d8874dd9debb36f7"),
		expected:        decodeHexString(c, "41e75940f9b806fd1cccba476b0f6b9ed6197d38d5e8e1f37a9b9d2f595973381ac51764ce540dbc33223a69b8f8dec7af0ec55f073cfd938264576d92c16b1467af6ce9ca7bbfc08a017e5706beb658b921335f03d5b270decb19f51e73f4554487cca15dd4141f23c2642266798a71d6b07bc40a6bda8f1d3783f50ef5aa0b6d4ead3622c841fa01ec626982722890deca6ab049c3b2e275521af1ab59afb5c9d660fbfc03ade21f4a89403deb6de6f0e433ce2c1fc03f2d8bcef9d60127aa"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_2(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a245a692d7a3e240eee4f4ac059f213f7bb649d58ccfed3182968c62d39369e2"),
		nonce:           decodeHexString(c, "058ad8521a26ed89b55e47c737f1a4c7"),
		personalization: decodeHexString(c, "6811a882b926875a484853cdef9738c212ce0661fa63012968a14239ff411d89"),
		expected:        decodeHexString(c, "b3d0c6015d7c7341d324ac1a17be3ae63e9132f17c9a48db50a75a36f7562061079c716b0ba0f5ee6f82c404ebd0b6d9de0c1697ae261d7e0d4f9f43ed32665fd4e182dd813548682aafbddb92036dadac28667e474935ea5e221fa16716018c90ae60dda369b20676ff7f5bf0f130525c2b0dd8e467bd0dd4f62b0f69bd988284d539f1861d767874bb3ee2ea6211090de81f1687ada0152500474566d9abfac236535e4d6d6b2c39ebc79782c7134f56527744df5b32a44bda3432987914f2"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_3(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9eafd49658cfd5a9873ab83282076677c8bd7ea1b3c9ca92181978824ae486d8"),
		nonce:           decodeHexString(c, "cede47939738975ac2853ac07eb8a18e"),
		personalization: decodeHexString(c, "8272c97255b3dbbe53ecca41250013454b329e537b78c4af82562bcb00bc7e86"),
		expected:        decodeHexString(c, "6a51b8fa6fb18fc3957c8f7f9828a216fde6f1a91b05d8030882dec9f4b37dbd5ec0f4cf9ba2ab27c9df0a65ab1e795ef830d13a1c89ea958d5dfcba302e34d72ec8435abadd874b9772ef3e53d297f63ae3f902b3df66b0aacd540207aeb772cf6a962ccc7280f90372efc036b20b829c6a6acbbc71bd078f6b2bffb37095333f551a7f6f68649c8334d7f673bd223fa00e2af7549a9289db8746ebcbaffd8bfb59b58b9455cf049a6e02a4b476ad5e6e7b8c891c6a8adc1a5a279d0f4ff5a8"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_4(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "58a28e11822bbe1a41e32a8be1d27e8de9668381c6969b4dcea864d70d7bc367"),
		nonce:           decodeHexString(c, "794a3f1067e30c754dc96102a436b9cc"),
		personalization: decodeHexString(c, "3347257112059266fb1a4359e8350479aec27b4116eb18699fd5495e4a3a166d"),
		expected:        decodeHexString(c, "1f4a0091c2648cdf9d4be467edff582169a0b6b73da859015cebac9bd2200fdcc9b109b6b703b35c238ad1551ad4fb45bdc0b5dd4c4814158c1c7641b94e51539dbeb8261a818afa68fa5abdc50eb9e173472709e9686495d2072065963665df41b94a7a94ed0fbb5f9a6cb851a530e87b451ae39c59f437ed16ba324221935317f256055dd63b1631a1ca6d4e6e8915dd79b0250d83a3cfb117eb299cbe3c41f6708e27d62c8959df445453a1c8282f87cd9078104d9e2aa83d3c34b00eedc4"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_5(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1c644ffa4e1561af95be8b59a4aff572bc345cf942f6e8c1ead6d2b35a39fe5f"),
		nonce:           decodeHexString(c, "fef59f8881294588c486e6be0cd177f3"),
		personalization: decodeHexString(c, "dd31fee7a712a0d422e9760dfee0b08e09bdc1a2b335620a7aa1bd520bc0ff57"),
		expected:        decodeHexString(c, "4ec5f212b020ffc80182ec4c8766bb7ebe4b152c225303cb1e17ff6f3319af5bd6d78dd5c4b6a7bc3f457fc1bf73ace8a5d83d046d6964b9cd47102ca4139156595bac84043adb5b017db046504d7036f2c5430cd9a4496f60d041e1f11a08bb716dc53e861a18ac8547e5f1a93849d70d5c0098215b1b231a52f1ddd8cb1eefe6f746603caf5e9eedd35bc0c1139949039f725861a768c02708c4180c5c83d4488cb37fcfbafbda3c2764c3a9fd97280a9f2dbb285340c9001378b43df93d37"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_6(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "861ceb71a8bf4f9c972bcd4a0303c31c3839957d14f97fdfeb44ee3e8a6943ff"),
		nonce:           decodeHexString(c, "ef359fa8a16d7ac5eaf8b705f8802166"),
		personalization: decodeHexString(c, "7759db318373f0b45ca5b569479be3dbbd44313bdcd1cf674dbdce501b5c5289"),
		expected:        decodeHexString(c, "96b7fcdc5767af289128acaffcc46a7f0b40a2c661300563880065ec38009898d44ebfbe3dab1ded3768b5a13225b1a24f541ee5d8effae22be4df2d1c78b09fc087ce29808fb0cf3ff6638d03075e62100ce032d8e171bc742e9e67a60f4afb5e77c70376c52988cd5979ac3840bc432d63fbe8f783669c23007102bdc733b2fd39f3e26af0f9da035ffdb84d2d802a544457b7e762b490c1f2ee13b313f7861c6d666ea82425252ece54e9f82b06172fd1df73c78a37970a6ca9c5f34cef5a"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_7(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8e6cfeb8efe01efa18f46c9cd2441f23869999ffd385470928e15f3aa00d4871"),
		nonce:           decodeHexString(c, "b3a364dec4842609ce8b32ce50d66a61"),
		personalization: decodeHexString(c, "681a398b9a1b2ca78566f60bb39324cbfa82dd9194059c32f9ed3bed1e710513"),
		expected:        decodeHexString(c, "a6dd28b76f702ba30eeb580e753333ec6b5dc15295d7ebfd488274a07e73cb3a3c99fce2d51e84797466dcb9c8804ded9f7d1cbb912c18c2ca84ea18e2d527e6081c30460c2a6780ba09fd9721ab28a337960c9c8b923908617c8ee36baaa8cad6cde150fa31d201b164288378a221e95aa798155943d567f9e57eb0eef77c35d382c2d0453d46e9d5b8c537db0acb7fe1b0c890f9ed3248a171b8f96cf65e79e735f0abf6f63011506f0b596f89ff2de1d3a016a9aa92cbe2469304da4b4913"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_8(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "299acf476d2155f4374624a8ba35ef3103fa6e56cc3e2ed445cd90913a70da46"),
		nonce:           decodeHexString(c, "5310710dded27361c092b77cbd923a4d"),
		personalization: decodeHexString(c, "5bacb4ccfe5a822ca5e371eec873ee668427bbba80f30779c1b86b3e62a7e7df"),
		expected:        decodeHexString(c, "661f5ecfaa8b55b344d7325c97d007a3b12b8a1b6d26c6ade00c1f9addd9220b6b978523bab0882c787a6cd8318d8d3a0f98a006092317f9d82a52da07eab0e1d3070c464df8d10a0d9827fb7e776e4cb2c8851a539fa44cfeb7d9c489e55107356a49c309fcbcfed9c10d084330f55d199fa9d9f9dd0d70dd4bdc0a9325351528174dbebb304c85e35a6214a261448d9000de9ee19c81e3e73715201b3880c89193bafef03cb4d7610ced9021dfdee8450e410eeb3105db27b98a8b77bcd4c9"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_9(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c7212588ee610d8a6966eeca406989c3c46ab0bac021baa07db4d2263f00fd26"),
		nonce:           decodeHexString(c, "1990f704b819461b247c77ce9b16201e"),
		personalization: decodeHexString(c, "d06e1f51e9b5e6e657c44ac158039ac0629644000a460807ed5a6bb95c5cb8e5"),
		expected:        decodeHexString(c, "a8a625d9573e997a6bbd5cf720e23debb78943f8273460b9582e79b4243184101df5e3054c217fa3c105b0548a37f256668fcca3b4332c147891fcc9ea1f29119de2e4d1c2949c85f0fadd2bd3e8456455bf8b51d60e0d7f6464334475fc881645c10b8cfaed9f5c811e2b1d9cd2a49ae2555cbcd419b44508b569ea43f549ce9da27ade3947d3b6973653356281237311f0ce16e68935fd046c48275a7ba17de6409f6bb26678cb58fc12d8d71d47ddb6e03153eba2c063d46135ee762b27b9"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_10(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ca0e42da77a3a29b3cd9952f931ad932700df526e895389d5b25fb1147d03b05"),
		nonce:           decodeHexString(c, "8c9e53664bdd9b75330718e6379f3758"),
		personalization: decodeHexString(c, "0c25284a3f6306402bbc96f67449e0075a1437469ddf922db84df16f9be3e976"),
		expected:        decodeHexString(c, "1607d57308a3c98ad91001667cbb5db626fb77eaa2dcdae8e1657e46d920d708f01d733814ca952685b18d972e62c8fc799e7a2e2e0262405505fbf5436287e125a6b19d4f7180cf5c3f96f211cbfab4627a1c7d8ff9f7534f79b22f3d3adcf4fac015974b4f982d81ead08f9d7d31d474294e8fe519d00d70c983d775ba4709fd283750c86458944435d2b8a5eaeb090995851c321939c3d8dacb69cbe374a0657817638dae1a1e950e7fd9f085cd1198900ef05607adb3f0f515417220ebe9"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_11(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c2d015ded06a0d382af18aadaaa67a91b56779e13786f530afa2a694913b5180"),
		nonce:           decodeHexString(c, "0e74ecdf06f0779e6868c7d0004ee3c4"),
		personalization: decodeHexString(c, "c39d1fba53cc1e066676bbabcd1cfb941d2d9562991ae9fedad3aae98da0e61c"),
		expected:        decodeHexString(c, "969e37a4609a25ff5f1cbdb98d526b47ddd966ebe5cbe94c50fcb7250db8649ebce6a9c61e9891a8935968eeefa92c7b11ee3565f672f3df8ca1c6c17fa9a0f13200775be4ce7cf76f40bb60ce2b2690901eae1ae4ab9b3c2a36039a5cd05ca8a942e44bc8c99b170f7f5cf442240dd4d59b7fd85ea6e4fbccac9cfca8a804bfcba19c9b289157550948885014bcaeb289e023b8dedae477d3a02f2d95f07a54933c0cae71c516a74c783bcc268d2bba56fc58de91ba8c834de2a075a77ef0c7"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_12(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3d968a89b6944455c45a0edbe57e5c26a1b7cd4c1c0703b5b0fd49ca9b767255"),
		nonce:           decodeHexString(c, "b402078ae154a901061d1a0ea45af2c8"),
		personalization: decodeHexString(c, "eba3ff1115cbef18d89fa59a112c2e31870207201a2719edf63ad55295c10373"),
		expected:        decodeHexString(c, "da7f439008741250e7525f61e1e980d662fdf3c396062de34d77d08b4b8fc5beccf0584875255647e0ad95a215c1293309068a2efd9bb13245e5baa1ac5cdb2b143a94e8853972fc9de5567794d8940b01d06407700b5dd1f498a05093029c56fa62e825597d7a25d1d6fba75a3d6254d2e759a2493468b7c402cf42e0e94b5ea8ab58e30e5d1594ab00145c65ec6c0ec2b535b81e2250cfb97f51a89f8d61faf0008151204a3e7521c21fe82901f5aab457d0f1f5456dd6e0cdd4bd96968b1b"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_13(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "912ee739f45caadd545abfdcca38f8b328ed1b08e28935ffad84ebb2450c4646"),
		nonce:           decodeHexString(c, "cdbff46667365d6e74e5b32004114ec6"),
		personalization: decodeHexString(c, "0c64323183aee41ece9cfb9aa5fef5767fe42242658173b339c5b8bca1b94a0d"),
		expected:        decodeHexString(c, "ee116564835e608ffd776fb64056ab138e5f59f36b801c3d4ca900fde853c317641d60bb693ebda975fac51f652ef4d4f2c20c059cc5466e5279a235f7018243f86fa1e6b649661c84c9e58a876d31be278a50ee9c2de361cabaa1c3a7e085e023ff3623a7a689c8bceec13324a161669d258abf728e2c557753d26697327dd827af827543e50419909a5a95e214219d1115ee4d85bea60e89c7e3c15ef2e45c417020a0a28d5b1da139edfdc238bdf473fb16d1bb03d609f8de4a93c6b96f9e"),
	})
}

func (s *drbgSuite) TestHMAC54_SHA384_14(c *C) {
	s.testHMAC54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3a4e2cca3a98a1ae21ae00c5a2c8a68cbc11f5130fd9a88302fe9df9c4612c0c"),
		nonce:           decodeHexString(c, "d28f752f6e466e3fd9595fd380fa14b6"),
		personalization: decodeHexString(c, "232727310fdaac541b182497e5240dc2623a36b4efa7a912ab3ffaf9939c2336"),
		expected:        decodeHexString(c, "3bc26201261930bf3dc164d25287e41efb47c07c8c5c0adf3e86613435df202116331cfccd4e07c9ef008c62d4199d937221a17dc97be2043270ecc605d3d48c609cbce3aecba3557dddb304f440250b2c9fd78838483e2d5a2b22015b97869b891f9e42afe21df5fbb8dfc9061468c70c63a14b6dcad9ccdeced41d021dc0ff47821415e8793d34377258d9d6629b9e396b9d6b8bb7fc22e03ecfd4890d16912001cb7ed002e33a595052ddf7b991c5607ab93c220b2122783d51a8372a223d"),
	})
}

func (s *drbgSuite) testHMAC56_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC56_SHA384_0(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1c18486f4e6dfbbb1c0957e0847fae335543ed5372e246d9b570e636eac32483"),
		nonce:           decodeHexString(c, "03b567b8344c6bf6e0eefd978f8871c1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "12a3f6b00d380b795f375dc6c7b4732c1bc0e6e4936e58f4a8542c6b3fd37f3071d3741b53c3019022dddbd662deba2c6eee15c1424dc17890c872db84f44f3434574e5ce78fd5bf4eff394e3ea46a51eb10b0f70884071a740f554145032a98550491b5f947dcd28f0117a477465c1f0d678ff1ea9a1e183690937400659a6d01b6ab1feabf8e50ba88572ec16f15504272650c344ef9c55b8ef35f5212ac27c8af7fbe0cf2b54ebc277282867945d1a6b3f15e50c63dd70c724de6bc36b359"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_1(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "700f47567c8fb2d678e2f6278ee7523718ed22009fc63f45c815b5be4adb99a7"),
		nonce:           decodeHexString(c, "44f50596081eca8f134f4e6b0b9e1216"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e0bb2784066bf4a178149510b11a95f6e9c1e53a4e84220c81d7ed36c4e83475b145f9c4eda65c40d811200ad47bf9ae6c28388565df70761fe3d738335a1ca1839a130abdc31ca771cf76b79a17083f4eab6d36b66a54162caa810172e7d67a28d838de92eaf44f6dc41bc02b6d57b00ca9319c98397faa8912e229de7cba69011a73bfe7610e367d5fe9eb11608988c9b002f23e143b9f99e83d86aab7c3a0dacf6fa02dfa0dc397f2dd2bf7f656015b1ed10005922b36643b3d4ea2ed608e"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_2(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ea21baee5676e92d793a916b49156e0e24f4c06b1c20e754d15bd2b98b3afa13"),
		nonce:           decodeHexString(c, "984b4c6c4cced8495caf74c5866aa10e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "40e3bb79f2f3f76a29cd019cd1cd3d1d44a2cbe4da25a7c06dfa3f8905e272c0ef80b0cf2430cd7c7f0b182d447449701b80f840ba09c9ce4575588575948b1be930d8e44b0979136f09424ddb4858a01c0b8845c1a26b8f7c1a1cff4e2cb0eb6eb22f6fcac07f641535481dfab9080cb9306dd80f0e1f63909e8cf23b5bdc70e93ed1be4bb5673cf71b0d830ffe4702c86c523bf51ef9a6881f9af8f606e320fc36dc73c163b6fbb52d0b094f94b38cb48578a793915828d47f2780653eaec8"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_3(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fe8b2f044f52fc0f068fe93aa6f4024b6820c29020f7ea7b1ce96e3c814b6a9c"),
		nonce:           decodeHexString(c, "ca88bdebede91d024c45058a6f921445"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0350b4be4eb2309e4cef8f2890b76f6a6c5e96ec53494612d0a079a52e795453761653a73cb149b08686ecf20326d185f8478ca5b5d73eb3ec495267ad7c35a78fd424b1ded656e69db2175d03edc601185876b9451c48c39417c2dfc19aaa7dff60c6a74db52ebb5960879400400451ef7d9b3406d822ed340f576f89e4c72b484161031947f284cb0c87730adea276eaa877cf0c4df3d198c20953c5c2ee9befdc51ee9817949beb339d37ab21e73ac61b4b276592ae08fad37b43c67fd785"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_4(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8818518f921df409f6f0fa1404b988b4d883ab5837cc6b8686b8b48783b15f7c"),
		nonce:           decodeHexString(c, "6602439de339c11b7dc013ffbeccec11"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "98744227792c825a927a713a72caa1d94b26c6f3a52fbb9486fc39325ca021215815def57d17097b4fcd834b31ddd2cd88b38e81fef5f5ce2d57efd23043160467ed2e36a3504b1b316f6254665b5af9765e3d05ed01c2accdf573dd6bb97d193c99269da8ba7e338b0cc22a26b4725feea2411f77a13e12eb405aab939aef7681874cc02f3f024344ee6c340a6ce7357f54a76eab994de912ea25348d63104569f36ce63f1d9611824d08b7dc1191c23df88d6ab61ddf3e74fceacd13771820"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_5(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "327a439db3e8fac78c5c4dba3da6bb267d4876ab84f07b00b86e66e5107a186b"),
		nonce:           decodeHexString(c, "0249ace151b41111042dd74dfecc2f10"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "86c687e5bfe842bdc1ad283c3c7c1a60b3980a0e9ce9eb9980e717b19c4fbbd561b77367234698f8e1b89b098f1d602470491642ed716d3140f08e44c0bfd953e720b532ed60281b8360dc68028d70947ff25464f3bfc19b82fb3406c7c3b15c3e59e624501c5c085f80cfeb739433b8384a333fb68ed40ef6760e5a9370fbccdffe565226b9df4f59b28f277a5e40de20b51be8d4d1f3399e1764629eaee6e5b6d162780043e3d5b4f0d73bdffb11c222616e932fd80f16c359617774304e70"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_6(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "83922a8bd65ac85978008f4afa5e73451daf787d5ca34c080e6e683f0fc9f456"),
		nonce:           decodeHexString(c, "e722cd83333f3741691953d7b566f4f3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0a2412287f1fc5f1b9126cb5dc82ee7d996301578b60b5cc390a2fd6ef77b09216ef42b60b2cf1d7dafb34d6ece8efa735674fbf9bf2e8ed611bc53ceec23550241514fcb5954270fd37a1b468779265a60346a7cb431cef6ce72f7ddf5c55e387aa7dc29d66bad2e26986edd4d959696a408a9986b1e53c84ca1a2fe3eb3a4e517e662eb12a3cde9325e2543842ee4f1c9cd65b07b2304e305b5c8e0c1dbd7d1c7a6bf962751b7aaf706592b9fefedbf3fbd888596cb8d50d0f04a8040a7bd3"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_7(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ea8989f5b43902e20288c438c2cd35bef2e4dd207bbec3d2015e70b9b5524ad1"),
		nonce:           decodeHexString(c, "2bf759438a5d451ff19422845735c736"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "44d5a315d0a0d51917335a71cc9283e36aed8d00bf944a108873d709d9dfb57efdd47d2a17f1b81530fcd871e2dd30742913c447ce95e076b64baefbbf3f9ba86399869a4fb6331ffe7d317244f6be0788dd520f0f9028b01debdef53fff9b9af2116d227c447e9dc3da1d1393741d6404c5ba7121f777bd3876b791183164acb32d8c33667b5e5bec5d987baebb28df3192859d83ed2ceffbf74ee7ab97762c90a7cd17c5c7cfc1fb22bba009e84cab3d59bc7ca9b19f467aeb12f58736bc02"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_8(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4e38b53df75dcc50b95f36e41bd5a24dcd9aadc980c64e68386fd86294bda3a6"),
		nonce:           decodeHexString(c, "7bc745a77981fbdf7500218754d62660"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e10ea6a3b1bde7bc1a301c81e3d016e189dd7729780239742bbd93b3c982ba3db093d9e8335e7d5ec632c98ce0654d0071442099f8fbeaf9d0ed46e151eab5b9da788d0b89fbb348bdba41eb635c10cd6b73b2f5433708193d73d691b849b1475c7c74548b6a5de08d1456e2ad813b0ae57faec646d51609d6c486c15f0ff18090d94cf9a6999895c24aa09546422d7d2e8cd739b08bcd605fb709884e06359d72f01c47d258b975232ba2528abfe8f28f36204a0a14507b4accf57836e9a722"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_9(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b8f78540c699f13b00312eea671a91a37ed28905f3196b1ed4a1e494f3ec3693"),
		nonce:           decodeHexString(c, "6b85ef4eec4c39c65d8b90cdf0ff1960"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ec4bd7958166f008e197e743f5e6a831f97e402bac958ac5e40508c33a51a6463af1a76119ec82c4ba7a1689d3f7cc9544f231a4a6b034e96911a62f005deda1104619d7e96694c0ca68aa8624cc3a577f798ad8f0d20ba4842fcc8ba90ce708413e183654387e99c20172e4aec8faaa504fd53c8d8064e97187917efa51494b1a7738a135d7cffe390a31b11d78845f7871b5ff2de7f0d2c1f249a66b4fcf51db7654fe4f8393f7641d9bad2609ba6a0e7ed6212d33b92e742588db5a07cc99"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_10(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "784d53c3bc40b4338d3fdf294306e8f53170d60512aaac21a7fd67caa9369be6"),
		nonce:           decodeHexString(c, "9326d079e84cc1a48868bf8791416aa8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b9e624193d5aee01d00e3a48612c75a8a51bc1c7bd1e487ab8dcc926b7683beda0ccdebfbf67542099bf88c0257292580153fa7cd4a42d680260922655307199b4f3130a2a79b5b1eae59b01b8adaa744d3f5fb21ae2edb469d58288388f31043e80b19ed16f205426397545ac88c570e795e2e88ca797283f898252dc80dd89c31f34cb08a3de620107e3d103347d25e27d0dabfc2d3a2aefa3a2481d30bedd9e3f1c92f6526a1d47faad3a3af5b4ffba9ab4113cf893461fb5d9aff730b9f3"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_11(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7be3e68883ac15c82bc8c38bd93b79c0af39d0cd23c2095eb026c4a6d360befa"),
		nonce:           decodeHexString(c, "44bcb78f61a5e7c32706bbaf2ad6711f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1b1c30249a3b3758237e31243323f65ea7997579eea6d839b65f35797b754a34845939879c7840eec536ae328ee5e8e3876cc0b0ef412fb74ad98d6d987bc9cce8389c2e5adf5fd1f1c8f2314f9fa1ee05d6cf3232c391cd8ff8d3a08cedf1cb52988ffe58c2e7310ffa807fe97468ba9a9ca8e32d3fa0fa0adf62419a22300a3f2db66238f564457d0135d404f239752e650059177840b33b6b77a4de422320e58d195e5cca9e41c753e7be6c8b525efc447e7546bd19e91a387ccb0aa6f665"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_12(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8c7fdf4b71829495d5de18adf6823107e0e743462e77b7cf48bdc9be0524f1d3"),
		nonce:           decodeHexString(c, "70a13ed80e2480107c2c5bced30e4d90"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a9990b3ab01338e03de3188a4abc84f2ebb65ac8cb1c57d263eebe5a56607e552947bc756bc036e4826f89daca5851ff7322db9e8135a1e2ebbfd206f67ba43e059a32f75358b7402ce12b4c377c750acc5598aa8721b6ef2413c2295c10c3a84cff68c6250ae0eed541e20f420d2c46fc5928efd526ce19fef408304723a54cad2f40e97c5ff93f41fa6dd8114499c0db409cb70acd58404a6f02e5a9004d6dc062db2895ed14285a3f972cc6f4f611348d434387e0e937e4b7beda8a3bbb20"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_13(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c32ac6afd0c780418d98420990bcdf63e80e5bcbd5c9f79f91695d031f9fee22"),
		nonce:           decodeHexString(c, "7d66b3d83ae22021f383d0b19d6eb52b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "606e2a9b9bc568afbda558856cc305acbbc1a99d0087df4dec2d1cf8cada9596c0276b19a4e48f7ad83f45fcc995e4647de927c0002e9117e44308bd20d62275a74f2bb0d9c2f1c83fdd999039f21d073cdf0a368bb963b86d0fbc478bd860dbfc10e54d121efbe2f08853e7c7628ec7d8c97289529088fcab8404ba0c657480f7c581dea23fa172b05e389182ff3bf434b230306fa451e67fcc122b32586f0f8ff3b6e3a7cc9c060f917a96a59c6fc270f654e8500f6e5ef84c8a47c296bd42"),
	})
}

func (s *drbgSuite) TestHMAC56_SHA384_14(c *C) {
	s.testHMAC56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "57050c5fe58b2a2a0eba0d3b9c08a9b285e1180d2a297e0a9ad20740c6fa9f00"),
		nonce:           decodeHexString(c, "fc309209936c569a1367d45b212a9a50"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "288668476b39814edbce5ed91951cec398ba2dc3bad76048df5fb1a2a680519c217ec4d57adc0251e1f8892a866b142e0953353bc2dd207aa2703f81814d26a60daedfe94d97de6043ed5f3bd957b7516681827f7a36d1b2a87b692c67aba050bc38b5e84f65f07d70cc34549f01aa390c5fc8dd01304fee7378e62549738e3f710ee6a4e32db3f472e1c2ef1e803e57a8ea992f389f0823c922bcea8b00ab844e071579170baae90839ffd5e00844ec343b02db090847cd323f8a68f0dce64e"),
	})
}

func (s *drbgSuite) testHMAC58_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC58_SHA384_0(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ef634a2fa208c4b3d286a7a0d9c5c0cade45c18b4b80a0cc52160c3c4195a22a"),
		nonce:           decodeHexString(c, "4481bb6010534f61621be8ed36bab024"),
		personalization: decodeHexString(c, "c4771aa90866ec257ed00bb4a26ebbcd0434fb480c1a1e2965bd5b7508fadba5"),
		expected:        decodeHexString(c, "f098fe063550997cb83ee2d782fced1bcab43b601fccf4fa127cf9dcd86df6fea36dd7aee7ba7adaf2642352d17a815090ce64ce8b23ab55f7e170655d1625ea25f46b745830c8af777ad4b5f06941459ca7cd23c84dc6dd55505e4af6e518d80cc39a1abede7a2adb7d8aaf89f0f52e7d75ad975cb256d489b4cfd0f493e99785e30f01fc0463f671f0889a086e3a768b8037a538d13c708c0f9ec5957c2aa69ceb5552e13d5754e3b8f36a582a0d2d103453c3ad6e5ae6fa0c606efbbe6fe8"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_1(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "66c7826a288db41060521a95bc955811418ff87d97d142bc5411d4d8f7e3e32d"),
		nonce:           decodeHexString(c, "dfdbec93e22a3b159cdeabf30cc015d3"),
		personalization: decodeHexString(c, "3c5f09d775985c5dbd27b360e4ec15cc2433eb125d699c181ba54bac7eaeb40b"),
		expected:        decodeHexString(c, "74f9087067f3ecf19b9d83cf22ef7742c9af476e73c14c8c5fca245af503545c62d071d1d5bdd028b44c3b18d2680b1a2401357a45361f1625526ce3814191580ebbceb724d099e727b71e32ed5af196fda4fd997b6f994e63dd953ba7f8dd874c0a4815b2457e16420936d795bb350a6f9de5504a81a08e4d81034e96ff9c41112f83dcd04e964ecca37bb59b23a96bd8a2db684349339432f6405834b90889a3eeaf986a312e59fc148dd85d6256b3e9f9214f0e011f9c4bfabdc84a284ac4"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_2(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "22c6ecf7f834b3d23cd974255f5e664d9e6e00ebad971e02daade9cd3e82c8e8"),
		nonce:           decodeHexString(c, "361773240099c21ea1d62dc377556432"),
		personalization: decodeHexString(c, "0e1cdefa5c99dce4638734ed9495ff4a43a9b33ffb146752c3c034605f4e58e7"),
		expected:        decodeHexString(c, "ff53c742ac1f0a45f9321b5b21310a6270922237ec22e39ef1299b72a3488511732cf3bf436bfc66e3c4e4e5ce171fcc1aae339d5623e9f728d3739f1c48edd087d2fc6e21f5648f81de39377230c75dd3822d8d060ca9725dda80907e3ce39544cf5b4cd48f8d1aa4900dde5e70263b044142a64dac9f42aed4833c5b861e1630268310b44826b021224b53768e5ceb6b186a4af15e494753b00c45681480360cfb260e627d17a2fc6e492a5447a6d99c87853a57c1d2ac4f2ab187d7494e94"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_3(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1358aa2df891f990c5b4750a607071245695e9b49e9e0eb755094336282da9cb"),
		nonce:           decodeHexString(c, "d7483c29db6943e3a757586b9a45fba5"),
		personalization: decodeHexString(c, "76694a8784ec67185bda5bd02ade54165ebc2c43cabe60810df08e7e6143fec5"),
		expected:        decodeHexString(c, "d5670f81c1acc1aaafc6f8157a6ea9f74b49c14993ef3f61396998df5ddc1efad0060c8234f69bef6c9a56485f98ad42e28e246ca7e15f352130a184fa7bdee46cc1f4598e7a39d9b31a47b47ebe9d1b3e745451176bb3361b6f502b0de34ae134c276f322c817df3ff4ade40973b7736aa2c2470f0da45e25b7a80ba187de4a02e17b0a5000bece919c01c77062dcfd21dc76adf597eb50a31018c953a0829db44a3ce577f244df490d1c47e5783d5c71805c70de5bbf540a91510d9d1a3bd9"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_4(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "01933cb95bd72dc97cd3a5fe722f17380df95e0c5fbc4091f54e96b5d70449ca"),
		nonce:           decodeHexString(c, "e8d10bfce84b7ecccc94d2de813c4f8c"),
		personalization: decodeHexString(c, "b07921836c827387d4afe21757f54dfac551b892f249e63b8ea6da57267a1d77"),
		expected:        decodeHexString(c, "356aad872ed2097374fe24c7d4d9e754c97ef6bfde2e72cf8582b0cd0bd544511c6c2abdaf8728342297ffa197c44463973616d87400ae81a972b17b2c90baf692231db7b2224fbafca3f3e5f89bd887379e0c4f7665eaeefcaecef34c64558586623003c65d2cd53c6997db448fd178eb04c4dda35db9c2a6c2402858a8bb19bec8595c0c29e57e5a5cdd71e76f215e7415d504d89b0e9ffa9939d08815f82fdd8e8accc32441e4682f8da07d0b1516884abd64f2b5daaad14fc195943beee6"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_5(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0eb5b221daedf44d9404bff9407d85271b3a517048b954c50ed0f7c1bf937344"),
		nonce:           decodeHexString(c, "187de3ebf99990df365ec1f0b6c48536"),
		personalization: decodeHexString(c, "63db9544f60c8b049e3525cd399b7269f5fca85d43b1c6aeb39375015792defb"),
		expected:        decodeHexString(c, "5eeb2050b17895ae2c0710fb3d5770e3ac1a38eaf2e49b41c0f69baa870785b102a9305c224ff7adf0aaf8c7bd8b7a3348de3e038d2c79bf418e4d34603bdaa3647b820775e5b4e9e5a538b62799239be75ffed8bc7b8b675908b3aeecf0baf1ba7bf2b25cb8b2717f21be6a794355c300f16b24d935b312c01f56274f565b4ec0155cc50b9b6b15001874f9cee05d424df2e4910e59594b86905dd86ab04cffc5266d2513d7880c2f04cee5137d2ac58aca52d5cd96f1455b97218fc4962cf4"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_6(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9ae14cdf2214c2e74c1f8e5e2b8cdaf0dba057c65793f9cc51f39d83f9b85133"),
		nonce:           decodeHexString(c, "622db66870ce2852cd0d08df8212688b"),
		personalization: decodeHexString(c, "6ea4afc062670c6f07714a4006b4ddea1dcfc21da7e660884a8c41c4b23644d0"),
		expected:        decodeHexString(c, "682de9f80c901263a6898f269a1fff48cdaf5d52747144f9a6cdba09110a5c8c36bd78d72322012a91d7531dad52042934fa80808e0fdd4167d39dfc674c24d0ed0f98a5e45ad04417d58830a31f0c73caaec8f21c89c905a20ae7048aff5ca67a5403f8ea3ec9e53699507f1baa5cf7841cc8f1184fa092b094e99ec8f951291a7c381510ce456e7b56b0ccd39468de88346e430cf6ac6f81b2909fd867c7a10a1b51ce3da3c0ecc1a3769696c886f1bd819b393952366412b5ea5de823d2fd"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_7(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2d855f1a04d5f65f69986e7a1ec6c58ed7dc4d3f03d67dc9293f0651d2d48275"),
		nonce:           decodeHexString(c, "25f04000c06d2953d4c254a920ec0010"),
		personalization: decodeHexString(c, "2c0a3fc5373bbc75a150a9e360ff82abcb855273d5486802966fa15d9a5463a7"),
		expected:        decodeHexString(c, "a0589d24d5eee689b18ae972c7d886cfee95dd50527db32de1fe43685cff3214e97be1041084aaa280d5b15af19e361cc9dbb664880128ef7945b4691dba1b8a5d228e505bc51ffcb194e0c7f2c1a1e302a72d73185961e291f9aa4fd58ec7dc4d68dfbb95d0b4291a8c17fccd641e572d9a042143fcf5ce47790736e8c9949ae2c23e685d2958a78fed2c4ac861af2e0542ee0e82779592a9e238a69169c2ae34500cdcbc20d42d36fc57031ecb60e63e44b6f81bdae3d186fc02e8b7e5d7c3"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_8(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5230f6a45cbaf86ec55539c1e20c52e589ef93c733db397335b7bce9b3871537"),
		nonce:           decodeHexString(c, "aa67dc753f0701833f0b283b2e9aabad"),
		personalization: decodeHexString(c, "c62c19e84b7c5fce42c8748eb698107cbc28832b3326af798ab3c1b6d5101f15"),
		expected:        decodeHexString(c, "91703c6eb85484755b70ec923ae93919a884dadec0cc7c5dd4fa64bb6513c5c187570fe85721116c5a6f421c17785d3f68d826e17826e76383357b04d72c7eeb00350eb6d39f284df65c1cda404e21745f92375f6e6734cd9d188b4cfefea738924ec5968fbf6a15ab58bdc8940683d9382e77b4dc8e7b3a7cd52bf789cb8bbc1e27373d2a803cdc051ce84f823fb0ab20e85f290e3f17d3c030b83150b135815d9f5eff9ef2c81c5ce728c2d259bbc2a3c1764f65ea0426484c2c3b0b518e37"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_9(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "90b5046853057797c2f89d73d650d9bca3ad63454aef960399742ad4e91add09"),
		nonce:           decodeHexString(c, "c6181214992648ed4826e04218a3a588"),
		personalization: decodeHexString(c, "48d37716832a3d7049c66fa7db241d0a5cbfe8040ad30fdb606213b6ebcfab7e"),
		expected:        decodeHexString(c, "f445fc941a77b13cce20248b2b5b3ec45a8fdcb041886c5cbbb2bfdf1275e6e34ee6a76bb5ff0937f2875b76fa08bdc31df426f096827fcc56b098fa4076310bfad22c9b98b652ddb207beb4b1392d6db353adb7582b73f2bfa2bb46d7d585e11525b65cb95de2cad9869480c27a043bf17d796d05eb12d01aa0b0638cb413e4a6ae54d28c274548706d829ac5d28e0bf2dcf9903b2b987a7d2d6398c52a3f740ab47464c8e6eb93106ff7d0db419eaae38f9cb7989e7770f398420412356136"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_10(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f86c8479d39fa3bb7b3dbc4e84659fc710d16cb2183c3d3c4e1d5427f9a7556e"),
		nonce:           decodeHexString(c, "44a148f52a8efda2f54cc2988562d7fe"),
		personalization: decodeHexString(c, "2ac8374e7b10ca0ef618ab2db2001326a07fb663320d9768c8b8333e53ec13f3"),
		expected:        decodeHexString(c, "a4c612e877cd6cbcb8dda0a216724cb45005124fbee148a2afef7cac2430583af259e361ebf9f7d00766bcceb5b2f7507f134c724cc69b1e2abed1e361890cffa3ff2f81de8da2176503238bcd9b51b6897663552b561bc2b3719d4f7dff242218f8d0b51b74c323c698e0f52c356f09b74f2105b0304429b3d89f3cbdcb7fda2dc84ccf2d6c7ad87f75a9ef73ce407eefca8eee21895cb4914508325449fde43bc77f3fdd16d8c769f2bd36e07f8dfbbcba896b15911c4b0143a5ac6b6f4795"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_11(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "523d0904f258ab2eccf2232bd5247112bde507eb613bb29a40e92b86e2ff2797"),
		nonce:           decodeHexString(c, "f4509136b780496145a5d7789e2c280c"),
		personalization: decodeHexString(c, "feed7c9680fb11a17b423dfa55e26cfb367a45fb2e0d63f4dd806849181b896c"),
		expected:        decodeHexString(c, "4a3d83e002acbaf108f6072ff014a2c0720b50bd8de178a6b9259361ddf351c6ce1825cd4de14bf9aba71ca04e1f276fe732dd3cfaa33f35acb32bdf868ebce6d4aa1589180365473f40e274de6ed5c46341cf51e45a70caa4f49d998561bbbcda258248de3eef656bbd07ebe90d96b9771b249e765e2d3c295c8ee8fd9faae20eba7af26e924eaa101945ed0ac839ef9b6f23cf3d03245ab8200ebd75b70d080fa8379bd3ddb7a6c3428b7ba640b6ee065a3a56b86b0802d1ff5b1880022643"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_12(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d75ffb7da2b4f46e313b1e8ea625a499c8b082f9f3c26d66899aa524d9832a4d"),
		nonce:           decodeHexString(c, "f8d729306ef7649ccb14e9c3c6513e4f"),
		personalization: decodeHexString(c, "294bec06c13c3ca2f2ac34dfa7dfa8c8a8e6483358642b4d4072e314a4df1120"),
		expected:        decodeHexString(c, "0594f3da2e175d8c9a83e7fc2f76dba53ae1e125a7986195479a9a19e59fed2d19bdb2544b623dae9c47394c0f57d9e9e37f811b409f4e391182b16720a460f52989c8aad9c8afd0efdab460563e4651f6fe599ef57c98db56389fd628712ef04edaf636e620ed6b5bee623d1f45ba4480424de884ef03bf1fa9f0b722f3d211534da8ffbce10765d10b7649373070e3e354810029f9c63ee7a217ac33bfb4797500edd958cb2929646ceb26cf8d8d159865ee5fdad7aa43481499dd970fc630"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_13(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c4dc5f712b53926f8f1f7b2af39d480320ba1cce56e39f722a10f0fdbb6f47e3"),
		nonce:           decodeHexString(c, "04fce136460f211fcedfe60f4a218d78"),
		personalization: decodeHexString(c, "85f7692af420b7e0c0ec1afcbb2b46b9972c3bcfc51cdb4fe84f2fd01d11376c"),
		expected:        decodeHexString(c, "28a3f1bb8cba67e70acb682e49aa22f6a51f8abb7f7138dfae88fce3c9c3132732fd5bedf074301c9604aaef834c5900b90195c2e081e941fdd6f6d6d10122dbc423849ac2fc14a2cf1bcc0f4248c9bcd3fe25f34e975a4cf7b501aa4903927f836831b239000d26fcd6252e863a1dcda3eb72467e284d7b5b78bfb035d5e5226e6ca6b5a9822d0f805f1a6576f64a37cec35d539a99e9b419ceddca816e6d706bc75f72e568d7721e9019a7319b19f65c1736523e1c277f101ec9ee7677dd6c"),
	})
}

func (s *drbgSuite) TestHMAC58_SHA384_14(c *C) {
	s.testHMAC58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "446956dff7fa2b038629e16041915d58c0fc9214312878958abb87bbf3259dba"),
		nonce:           decodeHexString(c, "e1609138b91637917ec170fa3c3fb278"),
		personalization: decodeHexString(c, "230db2e57b87e910cbab26fbac7fa93a65c07c1ec004c74637e346c2db63288f"),
		expected:        decodeHexString(c, "fa58f2e96776b4aa079dbfb49d81d8abfcc30d459caeb45dec4f1766fdc3b234d52cdc5337ea770e71a28cc42c82cbefce896d1fecea5a5290300208aa79b5ff97d2091498d749b66a9e5b2da7b774567ae9f83b87a8417b1bd089935e575b16618ffe8ec04b91fc9315968dc395fa2bb8776133d3ede95aa89ae675881b26ca831fa5fe6cba800d2fed1d509353e8cba6f007cf3c5e0b9424cc034e1c817d5f7326764f5ed1d17ddf8900977a0172dfab50bf4819a67e4c1af4704f59eda3bc"),
	})
}

func (s *drbgSuite) testHMAC60_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC60_SHA384_0(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7ec861a971e4a5171531bcb60e13109d62f91392b8b24ef9af0413bd44e3816b"),
		nonce:           decodeHexString(c, "721f6aa183b04847e45cbca9c84a4390"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "015cb92b0ceff3fec9dca022eb53cfed0f5c066e2bd2082801c6a5d3112a1df8ca2a9748cd190e95ccf2a5a86d0ea164c25cd612a4c4793b3f4fe17348d6db7f11b02a2a1708c6aa4b3fbececb8db1e4ebbe5231f078e9b841a768c5b5a3453c30ed3d21632bfe0caa92d8ad00c34e36eb90cefcaaf4bfd3c5d23198bccaaa224f4bf642de696660b2ca7b1425e57ae8cc30925b940b593921a0503155c586c2f4b4a9c3499dd7f977184f89a6b53bf847c08a0a8f4d5ebdc18aa2367bdd1d43"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_1(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "76ba96536c4976bf307766cafd308229adbbac3ee4bed239c83531840827ca05"),
		nonce:           decodeHexString(c, "f56479f011e2c46dba76d738a5bb3d09"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8b23fe629ab734b6204932ccd9ba02a20f7293c55ab271f7ebdde54af9543af9b071b27e48b83641265ed15961a35926a7830e808444eef27a9089439ed278c11af894c63184f2f8fb4923f1da2b414eeb3cf7414b99edf65afa1a02ae0c3376e525aabb7f7abd363b2cbd68ce94183455dc10e2b92b4870cfe35fe1aca83b6a916f791b9f642a20ea8ba930e2f8b565f316cddbd020ac94da9500021c3218864da7f4cf8533f3538d19902622ca7819cf725e4be5c17973cb3ac8487d2f4bfc"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_2(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b821a3684d176480f41d12c444d85ad78a76aedf6647277618d793fd03e9cb7c"),
		nonce:           decodeHexString(c, "e7836140aa4039b91be35524a5accacd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c943054f1319c1185ec71f1641ae7ef7d2ccd073b710dd7e85702464314d88f5d5316553a72a906f5d99897097ec87617a483971063dbfd88c495aa974aab3f633b62a73f95364f90dca491731ea87b308403821136be078de3fd88baaab9348c071bbdebf9d0a9515083613fe8e067a7d2b9bbee8a70b464878ebc95da6b7239e87ed1c5c27a06db189f05aefbbb87dbfb9978a24f4644a96bcf7f836af08447890268e8e786b4e0ce1fbdcb9e548d905d1b7fe8a3a69f95965504665bbf198"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_3(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fbf6e4827e10a380cf9d417714a1a9e4e8f33228ca56bc2e16d0b4281576ea69"),
		nonce:           decodeHexString(c, "cc90c8f06c891546ae3827fe35dcd427"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0819f6331d9c831ff9e9428fcc762386a4ef1cac711a29f726181abc2e2bc76b958b534e2030f80969cc277c1a02189621139eff9d9fbbf02572dc4d6a8025fc96ccc24135890f0a1b2f921ffc4ef94e2c06430d0e32769eed898eb274ac19c9aa00b41886645f55f7cd86cc42a98797538376caee380b50eae6e0398cc967a8debdafd16b8cce27773806701c5370e894a67fcd559e437c8425413466df7116b61ceb155539f26049f5e59f1f1214fe0d7111190d437168a9977e1c7ed716e9"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_4(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "69cc8d57ae9479c32dbe51ade985eb3b6e6544f32c95a7774bd83631a4cb3cce"),
		nonce:           decodeHexString(c, "c27e999835c4b348f433cef33e0dc9d7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8ab9505d1c4cbac5618faf7eb0bac480417f8810069bd8413e04c0164b96c5435199cf6e40b684d7ff4dc1b7ba48634d004bce718c996aac58b8169b86899cadb8470198bef3c7f0710e641683f4e048027b4381e551c505014918e4aec94dee56bcfa08beca3adc14bfeca86ec722f2c360dc45c26ec73cbe6638b2dc49ac13a1625a66229d5327cc037b7874c9b3082a05839400c6b18f19e1edbca2e249a816dbb0979b4566d481d0d493f5281c1acb070234b9fd876e42363059d89bc4c6"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_5(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bf13f2521b5a6e715effab45554a85d5e70b059c35b1dd997daf02246ddf385b"),
		nonce:           decodeHexString(c, "aa94f820b0c56ef0b1b5899955643e04"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cd8be0723808d583df5232df652bea57f043cdc004f8edf18ab7cd53b75b0627b1d6affbd8e7f27a8e8098cfa33a8b34f21cbb99fc2298d7f12e90155da1014e36d74781f1c48549496099b4a12b5780af05aa9cda3fb7b3641f30e2160defa2f59f1e8aa754a9fa3c0f31a1b7adff1eb3149bf6f6219e834cced5fc1ab357c0400797e969b2a11ca37af17342c77d2b4aa5e7fe49f3ab530de0041fe785216865aeff18989e9e7859174bf39ca811bc5cf8d4cfbea8683ab007ae6f58dde898"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_6(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "877a45679277a32c3dbe08285702dc3b799c344e9bf05f3621929fa48208e06f"),
		nonce:           decodeHexString(c, "4a33c7167e2800193222a29139792f31"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "885700296f0e10c506228e49ad393458112483d894f449f41afe8181814d06bc248f1068c0236b4326db64b9d12d302b2c5ebe57774fb5070e56b83d283c7d7a1e6045caf62e781dd5243ea75013bfdba0c2eef24b632719cf590012e6685dc8f9811370abf51c15013ca66b0e2164aa7d95ef00cdc12695313dd68534cbbb783ed37f7ca116fb3c40c79e869f9cbf13c294987c7dafb1d4eccf8934c769c487f1e593e316f91530ce3c6ae0fd9b9c7286f2d99b4262f55269b97e4654bbd575"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_7(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bddff6b625e8af75ff95d00371f098f98e7e46a9fc1c58225370c989c04790cf"),
		nonce:           decodeHexString(c, "53fb18229c3180a01b27cfe06d5ed81c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "98281f2145b514dc3baa0f153c06b65d17a856096c28da6bb63a5ce72ff2a7991c1b2e56c54feaa872d203faa11b67e4746ff28f8d0720ee44eda590a235b2935a6f6eb44e4b99db7e4b06ed929d76bc3ade6d051e78f568c1da530715b2977ffe34ad73496d92e22b2adfaabc70504c5b07b254434f69fe77e2fe8e4c281159ab5ebbfa27fecf585f5e1ca8350dd8af08d614eb9c2ccfd23a528240d4c18f1e38a2f0899a7756f1c933af46a20d191aa3ac98031f46398f1d31101c8b7c5bed"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_8(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6b9100a1a9f7794cb91a4839f0652d3d6145a560c902a65a2ed04fd64705f806"),
		nonce:           decodeHexString(c, "991cca4ff903c7c11b5aabdf3eeccceb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2a023a002385b786889ad4e90ecf4fb8feec1205ba22bea0df1186805676c89edf8816dbc74fc2c6f4f9cd99d5ed9d5d513119439706b45a4f694d765ff0258aa61ede082a0a07374a8b31a3e60059cd0554f6404d316c80ba2c1e48bddddcff7325b23eab2aff046b3d77b88cc16add5187f5c6aa21c60cde458eef4985bd458cadb7cd6e72073961267c76c4ed5210d6d3656f5212785e81e3d5dfd7f9ceb1be685051f18a942c914fff5b22eec72365158de583079594aa075e0805387919"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_9(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0e4213f8305d5f79a03911e56f92056ca972740ed13c7c443003ea1950a752a6"),
		nonce:           decodeHexString(c, "8e9d8602dd03e0e48efa3d2262799bf5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e6605936700593052d366fd6270cbe134004d7eff6b0e4d5b795dc2e592ed01529ff6454ee51c4e162d713ac58548f022ab327a7dd528c7e1a03b1fa780c6d642d18b2de50a572b5df3aac3b4ee2705e26387798a097dd1b3bfe91f171fe9e84a6bf8f40fd8e78b042dcfb84e502c1cb2fb8d90aa9160dafbba1656557cff61e9c778451e9ff608c6729b1bfce1586ddc2e02c1cd5eea75a3dbbea1edfe5c3366d731d1e8f6bd8fc6988e34904f546100e80bbb9b2e94aff5276844ff97f116c"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_10(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "800b8899668cb039c21eda997426aaad014ff6f75c31bf43fe4e6c351096b535"),
		nonce:           decodeHexString(c, "2819a2a2438a3f345d13ea74a0eb5560"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7da447d31e9708332427820e939182a22fe9133d141fa92d1db3b27ac2ca062f738b54ec52b6d970bdd64791b8fd7f7311934a46926e2856963ecf28de4319ae2802259d35a8a40ca4d334fac9b434efe9e23f8d004d7375b04c2ce7bd8f18ab31f820f435a116b78a9176ced350f3dc04afb03d83e05ab877116ccc55efc80a75c9199fbb0389605d581e1a995f38211e71b892555cd5632e8a27d23db41397d0a9f9c715e5b27f784d7c20ddbcb93708f17656ec77d5fc72ca3b5e91058465"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_11(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fd1d6c0227e52fdc2bc487cf684b2103c1b67ec452424da6da6e073d4b0b14ab"),
		nonce:           decodeHexString(c, "97a121a6f769277690ae2d1584e602e6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0ae6343c01a33dd566c695fd8d89b8d940bfca8b8112fb2d217378a47e85eeaebfc95260336216538be1bae906d5c945ddf9fe4beec588d10e2b6e35cafc4956d408d67a522ea4e0ea71409b71fbf85c4aa1490e0ed60a86d9b4aa0af730671c2d5a754139b07999db03922468fc22b2773da21c3af92e9da846d53a6505095e657b45021109bd1e89ffaa243b07d7eb7f372bba7b3bbaac12cf8919a2f7acf7d2b47b16321ff9de306bbb1209fa521c5d30e9b3aadea89ce8500b2c1f04267c"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_12(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0665e58153e45c179d7642324c07af0d8987c79b41b87e2d562c3d93a0f7124a"),
		nonce:           decodeHexString(c, "38d46ad28aeb68dc18af6d5e20248e49"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ce68def79d3e0526d56c97f95d415632a4df57ab187e264dd63f488a6692c65c1bff9a0315c3c5613b9efaa34bd8f778d0cc6f686a791cf95eee2fde86f197a71a352fffe6ca3d51fffdda29c9b926e95863b27491e0358c5c090ca858b876062260e459c7fb304aa28b82ff4739f2b1cae2462d0e2b65cba9b672a5d971da523b197a6c3b364343f97e40abe4a06f68c80e62ce8b49d0dc1341b2488d7471208d1c007ee17d6d8eb84cb38666e810abcf3cf94742a757b5e4a4be3d9b830d3f"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_13(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "76d73d310dd5e098a1e5b4b1fa695845742894c8af70a435cb2471c242f880e6"),
		nonce:           decodeHexString(c, "0d5df7286df0456f6e7c57a4f2b0fc06"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1ba858b861bdc4eb4ccd356564fb145a49008ba0c3fb47813b11271cd65df113f9a123f0769b6a3c921ae0cecf25265256e36e287ed2cf389ebd7e29aab0bb74214304aa6ca9f10ffb7471e74bf61cbeb7ab1be1717a6daec94e5c2cadbadfc71b5dec408debb9fc228e43af3377d91dcff956cbe39cd34728e7f259f51dae4c75b13b89131056eb5380fea3ba5a8ed462553bf85722a3c5348f7d8a26caa1168776d841b6a1b2d7ffa9a36b4977fe9a50eb915c4725611534551cac5c3ea3a5"),
	})
}

func (s *drbgSuite) TestHMAC60_SHA384_14(c *C) {
	s.testHMAC60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9168436a8600415b83062125de0ce6a998090216dea7374af08e6d3becba054b"),
		nonce:           decodeHexString(c, "94206c91dcdf9c7c3f3571c703013419"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ef12bd2b6dea20cd197ea9eabd98eec1a2943619cd2a96dd16a6c5485435e00c59570ff14d7d9fc09c99ade0e5ec12a84c0a8ccd5677fa9b92295eb2a620e8a0400bc9ad8a1ac1aa4969d8d04b77ad59b81d95cad75358698107dc8a2ff42adbd679ab29cc29cd6ea756f4c4e60c271c3134c48b5d5aedecf011e73c2663ad1cafe57120cc70137370760c350f4e9c0b8e9b01c9acaaeb56094434f4f87c67a5b5f674783204ab0d0598c06f0802a05ec97073c005f3c9f772fe0bb449c1cad0"),
	})
}

func (s *drbgSuite) testHMAC62_SHA384(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMAC62_SHA384_0(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c226c99e0bbdc88687d0255efc80136a3e76a5fad39e4f163f954365000ec0ed"),
		nonce:           decodeHexString(c, "cd4b4f1435bc949900b6524b55d78eb7"),
		personalization: decodeHexString(c, "e885aa3050cdb3afa838e5ff7c813c04b0095465b4ba6c4c54f92cac717e53ce"),
		expected:        decodeHexString(c, "2e978624cedfbe0b48f9dc21e4ea31d58c517bcffb0e8da48aa402c275a120d132f80502400be2f8c33d3bc16f677a901d4a9c1cf48ff7a558ce901f5c14039b4473385ce69010e3ebf5454b71b11ccb9cf1851c2707d1c56e30615261c77888886fce04f312dc5d93e8ca758538d2520fa92aa59e90924ba8d8595a40734c0d7feae97ae58ea2c418543dbcc30c2478b06245a7336a3c9e3ca8943a4fba8701442ecc88fe3b84e3eaaaaec1efc033e47bea1cb82a2a867ab121746226667481"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_1(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d0a1d38a02881ea4e112344407be2055f96239b39f0751a1ed267f6a77207444"),
		nonce:           decodeHexString(c, "029eee3c270d1b4e8e0a19d73983cc3a"),
		personalization: decodeHexString(c, "5b768d026f40ef55ed66e19834d95304b9b6972a40dd3c43766acb87914879c5"),
		expected:        decodeHexString(c, "c801e38dfaa17b2185b61cc12570450884dfa272a67ebf4820592fce70a9eb2cb2ed13fbc39dd935c54cd1a8445d70c6718424db84e6b5e76a6efe6c1f86fc51327b72d38efbb6af9d3a1eaa9253e3b72c994d939330e5eb47c87afe7312c47719d09616095aeceb4680042944554b3c7a8b58754cbe2581b91040d546422c2fc8934ec905154358f45f73f66b9dd8c6cdfbed1269e0e73eda25f64c0f5c82a43e852b6f92a98e62ae1dd8387910c2f352a314242ec736131580799702b3f232"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_2(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "69631db949d342739b49fb8220fdbea39e5ef5329cd3244816545bc3c9b94c00"),
		nonce:           decodeHexString(c, "06bc4c7b448b9c389a35d47197707301"),
		personalization: decodeHexString(c, "37ba849d3ec78b5ff44487b0bbce6edcbf7b1737aa99b632ab3020f5d9834a49"),
		expected:        decodeHexString(c, "573bcb166baa08cd384bfddd7ca98de22af6e5c4013478765cbeda74a2de6ec21a66b40bda796a8131d9f56725b6f3673f2374b0002d1e23ae0c17571a71702162d2ae1c0f4dbf101e38eb6dd91d8a7a6782e46f39801792d754a0394ee38127e1f3d6d759b584a876743149bb124a887614c30cdc7842b4d48d80d6a3fed5c96d2f6b30e6e183edd0357bb16927332a78f55c79a9dc7a3f813e3026a69d079b39c31a44a6b544cc3d84b21f8805d8db97b4ca75760ad53cf2c9d0e4e468e382"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_3(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "866bb09d74ff6d9ed788def6fc410e70c755051369b77e103da9ec1a8da78476"),
		nonce:           decodeHexString(c, "d83d6d5a3f03e7f8297b9cad98be7068"),
		personalization: decodeHexString(c, "7b06685f6db8fa2e16dfc704b810e7fcf88440d25266785b3e6650df42fd1add"),
		expected:        decodeHexString(c, "d8c4d3f5f3dd127d56b721b5752f8741e2f484448002e1372e5c30ebd2522bc58034489fa7d095d8311521a3e05d698d3121b30ccaaa4990ba16c79d121f1df2da7e6a9fad52d851b29060cfd5b134c2a610d7ca710f49741f69a10842f1b407cc968645f9bff967297ae316f262da03be788faa4b67c7f2bd421fd85a0a9bad8e15dc4db371365d391d60c30be40e86eddc8a3235fd6e64b98fc8b2b04f83f2f1399d6b2f49b2ba03ece6a73a4c65ee93df15db5700cbdfb57384e1029010fc"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_4(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fbd6587801700d3f27e437dc2f016d3533f492b38fc34fe8e9fca7d898649c86"),
		nonce:           decodeHexString(c, "48f13df7a179cc6b1135be1c09811b51"),
		personalization: decodeHexString(c, "17f3c855de72a34275288699d056dedc0ac6ffb6e679743598af9e08049a4d12"),
		expected:        decodeHexString(c, "41456396fcecc8623e5592de93ca0b9d3eb8a3ec2484b1846fd2dcba50f8493ec2ab6c9d004800b82be94dab61730d82d6a0c6273fdf37067f7d19ee137b462b8f80df50f92d2937fb2aac183e24f06d384bd62f883cdd35972bfb1767d41f44a1324b2db89b1192e005fe3b8dd1dc3704a57519994de304e4ed4baff4143038c3d7a857a8b0e252d63d1f1451d313edf45dcd1b7493da67633e24e293badf3929e09a6552900eb709d92b6f61d325448efa3a1956426f35a5397beba63ad0a3"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_5(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cabc1f91d773df45e9486463a14bca91a7a81fff5f878e1b9fbc55fc75b38ab3"),
		nonce:           decodeHexString(c, "8299c3957b3722e2612d05f888bc41e7"),
		personalization: decodeHexString(c, "a819b53f9e30c48ad7e25d10f5951380c4d2b132fbcb429c7b33b5aacf261cd4"),
		expected:        decodeHexString(c, "8c7c38e525169c374671fa388beb792f52e2ae9a9523fa730a51616b1e8588a84d3b739d3a60e4932df41effbdf6de7b771d67c506371367188e0ac8d1526f53e1881b5aa13f9853a2fbcc03bd1650957501b85f760239e110714a22b9f8f29335abc98ca68540a6eacc42679980cf40fac0a53a9808cd3d21ac5c077c4a081ac6ffe9acd5ad7f44816375ebdb0f7936bcb74f6f5493f2825502edd4bec79cda16f407026ce092bdf56830d00677843fa19d3fc7b0f0462ae937f09ba7bfe131"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_6(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6701625b6756e0a8e8de1d0b9dd19212319c3bdbfe9f297bfa037a6fadfc2754"),
		nonce:           decodeHexString(c, "2a03a06102767ea29caf9d097699ce9a"),
		personalization: decodeHexString(c, "89dd6daec1ce4112061ca7f2fbdc60f33812aca9b6c35ef488fd0696c086af45"),
		expected:        decodeHexString(c, "cde347b70312faa4526626c1cbdf0d9519abde1120e9b6cf773481b0e4b402729561a81a8f8127d316d42bfa0bff2799f87445fa89220c206a0a9e4700c95b99a4fa3f77704f3b513b2b8ab5c84664c1dd7e30834d9d7a0e27fdd9922a311cd9474bd5e824b586652a5a792886f427974aa4673efe1a5ab6391179277a2f3fe4308516f1a7ff04a075a1fd3178d4e1117e3cd3fb8bd3d666d5735b7b4362f5ba784453894ab9625c1bfc121050d22ae6876ff0fb5688853d2e4acb064d66ec96"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_7(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b67d67c81f6bafa0cff2843581cc474afa2ba45c09a26d8a03daec1f7a60c560"),
		nonce:           decodeHexString(c, "ef06c7bb28bd8aba6de1562a2491ba88"),
		personalization: decodeHexString(c, "99d8c88165f6c6d9a7d86e557a9f527240bed0849074e3f8a9184907dd8bdb78"),
		expected:        decodeHexString(c, "db591fa371e527beedaaf1d68acbb4a0a0d97f019c7fe41363ecdaac4374f5e1ceb54796b4934ff3bd316d498d5858c8439f99babf20a0f3ebc95b5ee54faffb19abfdc2b72306f5c8ba90bd07b33ce583fc4c01fcd622652c26ea70081ae26a09d10ad4656cd9f2f2039ca8984babe2e2d9ef912e250fc7449af58568c7ab2e2208230680db786668a21e36531fa4d427bde56204232cd6e54b936ebd010fa630cd631669df347c3fb4a1c653a518ac4d65d6da36699da39332acd4fb14e9f7"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_8(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1263b3bf29a25c9adbd52709ec333099f4d26adfb9b3356fe24fcef8bdea882f"),
		nonce:           decodeHexString(c, "30c58470d8e4d6e4978b47e867bdab98"),
		personalization: decodeHexString(c, "900fd212a376dac224a175095d392d3d9e493e52f16d588d435be5b69bccd67e"),
		expected:        decodeHexString(c, "d938c0cb81d87be4a7df27d93fea45a92f6826a27a7f7d32edf15fb60382df18f4b471b52a60f2a63872438d8da72645fa98f3293ae6764c2cbcff58836497f73cddd83b1d8e216bd54fa8af3020d632dc69f812916f5df354a72f3d9d8fabe0eab9fdf40d3a2de6906e6ea6d50ddc1359ef384d2212cc0b8d82ae03fce1e5096d1f8311c7b6237b1a3cab7b40694eca12015e39a41a1c5cd30b351182a5392e0d27ee757c1de7ebd5627bdcc888774bbf7494103e7682c157c88b6adca638f6"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_9(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4dd16486f7e86a2ed5ae8b3bbc2bd537b2d86dc8bc86ff1344fed3ef0c97e07e"),
		nonce:           decodeHexString(c, "fce9abc0dc444c8bb2ca2a955a7ccd42"),
		personalization: decodeHexString(c, "5dda276a294d8116fe0bde3da82d25cde25d9f5eb9e9753a8a28c5d65816837b"),
		expected:        decodeHexString(c, "4b4859fd7138ea1ee74695fc36e44749b37a21a5b736b8cfcdaed7a079ce2ed43367715725c60986f31ea5f0978e5272602b36ac27deb4467516a32f9c095d081d3f7fd94f024d8fd88ed0ebff3bdb8a31ffd0fe48cb68eb6d3b8780a92760ae6de81b3b215242dae2f033f089fd979934922151cd32660fb0a2a4bbed7eec7eecffd352079ebf56d80c23912fd6355bdb5f7f5dd63f2aa24afdc18c875a05cb543ca333758e2d8375ad34207110591b0c46d2ea552dd027ffc5040367fb00fc"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_10(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ea159b4a9efe984991f9ab6b94b41d5c8c077efb6466c24039c66e1099bde478"),
		nonce:           decodeHexString(c, "0e4df51d15cca504555458577e645887"),
		personalization: decodeHexString(c, "6ee0cbc6e341b8032105d7a675c56a24afad41abd7f5e716a089f84c1f18794b"),
		expected:        decodeHexString(c, "f487e93d0644f2f77e65af549082c1b2c8308d05cde1fbf5bf70a6f38eada3a2a21c38fd3f0c363aec51c7c101d8f5acaa61d7ebeba7072284947703e65612ee1d629dc365aaeee4683e6ab25bca4f52dddb7981d72d526d9aa368a2286b698ddec1f7df3c91b0512d70f4065ee920005acdbc115a628b13552c668e83382aea91b6414769fcaf44c9ce97eac2fdb6bf4da02fce62498d7b9af2a52b0969820041cac60e816b7d4d641ae6c4191db479f1d4de867b4be8dc53db1753d4a0f92d"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_11(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0511f38d07e8590b4db94e962039b90efd3c5ade0b43bf2762a4072ba22b073e"),
		nonce:           decodeHexString(c, "84bb72969a96fc7b96a5c929ad2bc00f"),
		personalization: decodeHexString(c, "bc4bb885d222d889701bef54ff198ebfec28b4c346aa25a206dc00df6977d655"),
		expected:        decodeHexString(c, "658b2fe36e25a450c860bcc8ae3025480d14df174e2cc313ed721d3ff11e7b0e94b7161e7d31cec796060c28cafbc8c08cb5e0615e4c37f4d78a2b08f43ffb2d0b54a6b269c04a12c26173e268c297619e89b726d11c340135fbe46dabc249aafe3c1a69b45b16bfb3bf2652c5980b1f82bc7bc8668fd1e6bc14c3a900ee223812ef9201534516c0082a97828abadb49b0d71a5e0e2dd4c9226b32559486626c6f7c0483a56ba876dd65a49f5660ebe47ee143eefd471174e48ad9b47088f587"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_12(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bef178f2e5d4a9d1d06c7b9259f07cccfbe10df897c58bb151003dc7ee6ce28d"),
		nonce:           decodeHexString(c, "a7b4db39f27f22bc9d525e00b20b68cd"),
		personalization: decodeHexString(c, "d28af3d0ff436488cc480ebc15845ae1ed7f61964b49379ed5a409bc50b3141e"),
		expected:        decodeHexString(c, "1cae8fc50d5054ab8ef4a442091d00cfcd5c69711d59effc0d96d9faa6bbf3f43436abe3443009b29d793646328d0befd1bd9d0e14e7f148789a84597a7f83e73a43991e9df0f93d7c0ea32995d30925f832240f97162fdc1ca4a36052e089e2b6bb1493d64a25336b221dcc391290283459d9a70bdaa29fcedee59448614f004d411ce7ea51ee1c21980b94ae8cb8301af79107b6e55492ea82f4b4c77bbca160ef9d547ee2623b32404dcfcd00ba45597127f10fc2f6dde1e2877ee738b920"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_13(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a3be3f8ffce66eb94ad04be74d17d7fa9fae16a8e2738e0845fd9c9c8654bd73"),
		nonce:           decodeHexString(c, "f4cf725d0cc2ae9e9d4b6e04ad251514"),
		personalization: decodeHexString(c, "d00ae9ce52f8a9515acc207b96fe56abfd5f89ffe55b52d046afaaba56b09444"),
		expected:        decodeHexString(c, "686960f59b4af2d35f747eb1de19640f01a3f6ff19ec754ce9bab583ba2f4ed6fcdd7ff5e5df802a98a93ab28c4437aaa8b6e343efc608f0b7162eaedb6047fa2ed394a3a4c2571891b0a4f8f7439383881bbea1f5ee2acb40598e10b4d77f86a1616632ccb2edc6fdd6a42c972e9db1925638d83a19cee00b7a43cba278e2d56d9e9ce328b04f0e89d75880f374c1da8b2cf1361aeb6d6aeb881aaa63eaa3328e5f2a6e442c545c050a4255eaa2bf4fe812bec04cb9d98b7daf3ddb081b4849"),
	})
}

func (s *drbgSuite) TestHMAC62_SHA384_14(c *C) {
	s.testHMAC62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f40b9117c9bf9058139acd5bbc51267d091643c3ea487a3e948475f629bd1843"),
		nonce:           decodeHexString(c, "733bf048e5b112426979a9879b6a0c10"),
		personalization: decodeHexString(c, "58d91008875f51d541c6fbd626a49a798dc51d9cf2e8588808e74953392800e7"),
		expected:        decodeHexString(c, "1794335e21606d706dc89ace28c60a15c0c9f108f5ac882b103eb62e225de749285e5fb0be98a5bdc26e3c998ae418306380941d78acb7c81b91ef41cecab328332ac7404ace0ea858e7835534f778cab3e3e4eff043742e4f7d4d5725bcdca0b6be7ddbf79e57fcd1d5a4279f074a599abac2cd281ec6784e29d9399f5ffa8def3252acacc59844c0c24c20d029a89b4407e0b5cbe9a8d51241dd36bb82c400ec4571dd1baf831d58fed3dde4ac7f961be6ebc18af6bfa922a32b81ea11334a"),
	})
}

func (s *drbgSuite) testHMAC64_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC64_SHA512_0(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "35049f389a33c0ecb1293238fd951f8ffd517dfde06041d32945b3e26914ba15"),
		nonce:           decodeHexString(c, "f7328760be6168e6aa9fb54784989a11"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e76491b0260aacfded01ad39fbf1a66a88284caa5123368a2ad9330ee48335e3c9c9ba90e6cbc9429962d60c1a6661edcfaa31d972b8264b9d4562cf18494128a092c17a8da6f3113e8a7edfcd4427082bd390675e9662408144971717303d8dc352c9e8b95e7f35fa2ac9f549b292bc7c4bc7f01ee0a577859ef6e82d79ef23892d167c140d22aac32b64ccdfeee2730528a38763b24227f91ac3ffe47fb11538e435307e77481802b0f613f370ffb0dbeab774fe1efbb1a80d01154a9459e73ad361108bbc86b0914f095136cbe634555ce0bb263618dc5c367291ce0825518987154fe9ecb052b3f0a256fcc30cc14572531c9628973639beda456f2bddf6"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_1(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4cc8214cd7e85a76bfa735bbbfce926c0323fc348de6c05ed1800c2c8f58c6b1"),
		nonce:           decodeHexString(c, "001eb1f6b29b35242a3f8fa2e90003f4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1efa15d644e1bdf34eade3ff2f5e9ca45203ccaa1e534ac9b4287a846b71292b03102286d99f2be64b898fe909238f540ebc25f49522f60ef723a4c428ead530a97c62405cd5d9ecc54ac5baa47ac4f6195d637833f462d21a659b4903d9cfa6c9fd4512445f9abb5782899a6bb64592f3c2b3c745b18645301fdb09a6a331e9fb6d9654fc79c14ed83ac1684c755b9cb209885f86ff290a71f08a848b960152f05b1aa8566bd382ddd45521062831d7a0fb3a8bd8e112a91b5960690cd8585c1aa104514e3b9cbf52f6384e84c27bda2802fe9fb952cbf2bd607f869d0aeaa6b136c6a5f6e9b0522b6019b7ba6af6cff99fda612e024867decd8c0c6fde2034"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_2(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d046270e6b7997cd5f4e9ed1193e55382191f78547a660854cf60bb03d039a39"),
		nonce:           decodeHexString(c, "50cd147a3445f6d32d14cbfb9da0c327"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cdfa9441aa5eb11fe3ba50528ed731c9ff9e70b78da075d00c52d0e281e3a868f66a53a2a6a272d7e0b1a32b6339f8afd108bb9e66b04c3d6bc069b7e01b69844322df7deac66e605a9e2f43665b7932c67c418a77a4c9a302782d0e735795755613a1c5e90089f759d780fb3a984dee4e06ba3dc5a8c652549587d975e586a98ac6aba6563e2767f1a379261b9dd37992ea9681881ea7933b5c64093234c849142ced85bbe5956f527d46ef091e4d18df2a6102621a91bca51bf7aa4b242414dc16e74ae59dfe560c19dbe315e7f98b11086bc26e336dcefcb91c4828682da90d3921336a45fcd36ea4d1213a13213a132bf20aa1a3991b60b65de7ab9cc656"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_3(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8c7c80b169160c78104c205e4492a9477e6f7ba1c3bb4daa86d222deb6241bfd"),
		nonce:           decodeHexString(c, "2d2dcd5c40b46fa553ca6a2f6be96991"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1658a7552e4cc98c228072801f9ba230123e7f1f7dca7ba839f440e5f7570fd29c38b86a2aaca04cc87a56205b41d19e38998b47d0ffbfbd9bb56a6eb31bbfdce8d01e8991b82315c39f60c222298160e8d9f14b1a6038d8eaf15eb7310b180a8e2e8d05ef028782b55d4782d4774160a39896d1a896823f8b92a99abb546ef02cf189200a1a7a2fbb7019e4d8a935224c20d11a18e0d8890549666f6599c261532b036051cf7a65dd33bc0aeab8fa2ac9ed520f6dd893b9dc3cd3b87d02a0543eca0bb52c58b7ac4ab3f00171e21dfd3363229ed362f960d8a5fd06af5caa86018f9dce81ade6234a6992bfb9e2660d08a103dadd7d9ade4c45d691aa3799c1"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_4(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "cd394508d86c384c0c998b58cf7017b7124269428e4cf39519b5815cc2d88734"),
		nonce:           decodeHexString(c, "fd2cbc87c79063db588d90b9cb1569f3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7c4de5fa97362e63e52e790fb66d4b067e8cc1742975ba6f9186295832d31c4e0c97b7dffa262b93b109621044a4bc89c9fc82211f5cb763974eb3a816fa7d7853577bee1c36c2c36aabe28559d5bd85691c3e3bd610e61e4c3b76e167526d1331459d8bf09ceb403062cc97e1229eb3a70af6049d291aadb002786e7d21b81c87fa68a51a1b9a89394788bab70783a88c883ca17eceaba455f357c611fb279e38f67e3c27c5ade5f95721fa79fc2da1bd44ca7f304161359da4e45d7b847672bc185ba502123a802535dbd167b2c93bf901626e23fcaba03c4f89625a930caaaa30400645680e5931e094aac6f6467b90b13c2be9c98744f89d113151cd2ffb"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_5(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a14be417001030f6a9c543f829715b075d0efd8fa35acc7eed02a1401c6f59df"),
		nonce:           decodeHexString(c, "c87b8b9255e62fcda6a35e52fa4a6f9d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ed29a49be56e081f5b6abcd2ca1a16dc096071989de72a39b8bd544d2a2a2db5c886c0c29ce454cf60addb56cb4f28f959ccb7163280ef81e48dd2a02024c34a120301d359f03844d1af01f485afbe7c9b17288cf345172290fdc44e124670c5ca9e8590df6f9f63d60849c62d3921003532dbe3e3e6bdd75d28211365f6c489598a99e605ca671ff91552b5916ea9e12259723c0e1a633be34932d0c816c30b519c79656a70368b28fadaf5eb32eb6e47e00b04f152ace2eafc9a3ebd3b1b3795ad85e0897e46ab57c361fef2908041d365f73180b505ae2426603decd0b7dd33e2f7ac885aced4194999602d4d62a984233d0696fff86f7fa7a6cf993fb7e5"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_6(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b8ceee088f3b13dbd1e7cf230449f246a456f504d63fd4288838a50ab76576a3"),
		nonce:           decodeHexString(c, "f400502913cf57cb2341c5e6a63fe9fa"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b4fe3f6caedf4ac7b93fb1c2f316bafa58487f28a37b8400fd1f32c963b04cb3c7eb601d0dd8a7e4538b14030fb0e97794c617366ca827e3afdb0f714983a6a72b261db8bf98d5fc48fb55158661f987d08e952913212717cf204a3e8cf1177f63e2a46d920ffcec4b580a1361253a689bf765200f4e90dc6b34a56e10cfdbf932fbc3b75da1d55cba0c5287f552d883763b83acdfc7fc9d762f79774701f7ace701f0b26c67217e022bf6b6e0602e0d68cb1377b5ebccb9a8e41188dd1dea662663e8aa093787d6490a4e887a34a27309c64c40e4ab2f0acfec4a1b8d419d99fb578aaa82da9166a7d7873e27226db20d313e868bcfa4fe3854d6fb34def7d6"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_7(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3c1e8a0199786fc268ee0ca0c0446d7363bd781069cf3a3faef2592cba06ce1e"),
		nonce:           decodeHexString(c, "70c7c691af73d6d59addbd6e3f646d64"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "06f44bebc2c1736b5cee283e530bb877b28651d70983c272a10efa80e3794ee428644048d67245dd3ca8b769b6bb192c9468a9fcf2b71c417283713d39e800225ba659c3273022f5177fd7867173f457f3bb66ff2c2e7bb2574dfee54438e35c98506c178d35259b04e7c541016f5c2d980074b4ea865203ae2e8935d745a02ab5cce04d233cbc18719b1900f2e7e98229b851d19fac02fa6e5ac1bc973b20a17509739bd989d4ef5a66fd9e19e3ceef2415b498843e93631b2b168167bdbb8db313eef4c9668d5001cb34767ee41db872163987c3bdc144637b52dcb767ffc19bf44fbad487b1eeae7957b497fd59a95f0988315eba73ab7206542f31c49267"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_8(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e8a0925bfce66dee7e6a54fe0311d259bd7f7a22b8576d64840cc51c731212cb"),
		nonce:           decodeHexString(c, "1763365deab3ab82de9996e5c8570eb9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "63ddfd70508cfa247408ec231d56df7905f65b62e5e5a8309fff5239620faa0f055d7b8fdbc648ded78fd567c3141e1723d197296c92d43fdc18af0c4a54fcd52613286c78ba7bdfd0fcacc7b11b374739088323ba95f30872d77b6aad21228253133d76d29d0d742ba349956fe71e8bbf3fc7186a3f85f144a9040ceb0529a713583c1fcdee756d0130b38df0964bfc3b669fabb6ec6874d17d9ecda9fa567890e42540185eeb3497ba8db80b803f63803442aec14735e9eda177484ad61bf0c76c2862b7691b4cc74efbe35203f8cf4f24aaaa1d831030f28eef8b49e85b249e6fe835964d53aa74de6a31424ec3c833f4b8b39559934bf5f23d4b1d450bc3"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_9(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c493ad96bb20b2480bd3122b4b1ea51379f5fa2bfd8bc0fed4080995b162c609"),
		nonce:           decodeHexString(c, "b6d6197f432c8597163feb9c5439525d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "764d3e4459504b490eb1db7b5ab8e6413601e449750534f4c4f70025026f87217010eb14705eae6e513796c7f20ecace32a063238824b3fd6956810066930bf425a1c585221c8f61ac64aeccfe8a3e33d164d02d5434e9e594b7ff451601874d268a2fd8de9922c36e67d8146fe553889a15f624d499a22f5109896758f30bb98f70eac11da1ad48e99bb4422acc5b97295094324eecf530525c1ba150886d053c84004c265693a4419602e5e59bf120de6ff054d0c7c96bc14e9b5fe1290c08ebebcda21744c04a2e78964cb2b52f8e6a70930fd1ded1f0edbda4deff91a3310019e967df3fdbfa228bec9897412a748201649328b7d784851fcb5ac1251f8b"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_10(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1e868c5fe4b59e6d4249854226bf1120a74386ea590e9c35c58d7ccdfad56d71"),
		nonce:           decodeHexString(c, "dbf557da684289e96cbdd66cbd9cb879"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2032963be29c0d24c2631b1cd895124b9801a4d5c14c28fb34cbfb1c2467134f499153e2a3ec817cc4b2e4e06068ae78f5696dcee99334b0b51e9f29e56a3d3fd5c65c4cc70e10f9e0cea2572c28ec4afe0896d7689322d3afd931ff836be485f78aa179100d43d910564dd1adfedcd32e3e7e53b06c0a46a90b1173e4a5152cd8aa38f2a7e329d01c0b81e62be6c9fc8d1ff3db08f8c31c1e77c5d7fae619555c0e02c658486e35f27a7d58ce63b9b152b9ff528ab6a6cd9b59240f5a7b6b52dc3f6e47f9daa2cb8cb525d6760cf409ebe2c7641c3c32e330545bcd73da9eda20b7590d84831d4bec807a56994259bcd2fe28105f2d7fcdb3eec523fdef7044"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_11(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "55bc1c7358dc334b26412ab472dcf4210740cfa0ea688812d8b1a7fb257b979e"),
		nonce:           decodeHexString(c, "dbab14240cf59fcc8a7007553ac480eb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6a9d30d4ca97dbfc2d2852bef044bbfb95ac253b27e588c67fe179f6adb81147cc1cb6eba6a2c4afd6f8b3f1c8d45b51af1435ebf1ba8596830314353c9b4d8aff9620dba0099fe0a1ea417b97fa4c28491fe6d2a619172127f18155840f90456bfbf1e7ff587fbe566d6b8eadd6ce594bfcbabedda37858a7610c8230f594861984dbf1e3ddc9eccc8b9d2ec3cba1306d178f7677ed399b10b995b3ea55586519e5730e52ee8880ef0e63c476f2a80d77c6ba802c47e9174297b27520fb027d134e17cfa6f99d59cc5f53737cdc2e663e1ac59bf74a87ab1064e9acd4811c0406ec5a29a081bd0efd1e557d6b6c9c7fe6131c5c00fae82339a1fb90d3be2b6b"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_12(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d894820d9cb243859447cd3a3f6cdd125a9c4faece6ad756d288a15c5d24c39d"),
		nonce:           decodeHexString(c, "776c5ea9838c4c34f39f12c1a9df6700"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ba23f7aa0b7f6a93bc0df32e68e78786fffb5acd7fbc2864468568753e3ddf31fc2187b20c229d0d0b261510f6442816d2226024b57306b474079c92c66a00be482fc104cdbccef0450b3f2ce94f6bb6a5125e0774a28a2a083f802d3c45e9d4253295f80ca4bc439f539a7f82eec6fd450bd196ab468ec6902752dced44ab557fcd3f6a72c47c0f18cec6545ac669cf432e2db308d70a7394ec772a34f14f26d7bf7d0bd7e4437248618efa2c08adc7de9231ddcc976ef8bcbd11be54dd17ca9fa515fee6827bf5efb602fe8f1cf5d67078b17601803c5be05c24edccad2837d0be191f918d6dc62742241728a8690db5836c2045ec9f8bfa87b768f4febf2f"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_13(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "17facdf2fca2e1134674ea8e8daa609b4477f415c6a13a5c157f3fb7727dda6d"),
		nonce:           decodeHexString(c, "3c1dd89ad63e781588e4b3f8cb1f2f6e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f472b4c20bf07c170b3c8eb682469e88680d1fa5561d72b864c5c438c95c4c8a3e61f89fc30d5fb4e843e5ed1230778b48c467fa46ebfb7b56220a610483827f3f7f8ac307f8aa57a68922a06c8fa5de732a0d05835cd48690a2b3f734e4b7e74799ad774579a9eb296112f3e2bb68551af0e9e0e5e0bbb219ccb6c78459dc68a3663987156a50e72aebb219a1e43b5603dbd8055bf1e76a4468caee86489ac9a1a9a66ee7b193484ff3bea84341b62dab124a43e38945cfc99f2c4c15590fe180bb3e6eac544483aef710278213a83da85a38b6d140f33654c9d4f6b8ab3eacef1c57fd2237dbe8adf23b3aef6ab30327ca119b9e1e95ecd068aafae0d07a08"),
	})
}

func (s *drbgSuite) TestHMAC64_SHA512_14(c *C) {
	s.testHMAC64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2c13e44674e89aa105fc11b05e8526769a53ab0b4688f3d0d9cf23af4c8469bb"),
		nonce:           decodeHexString(c, "700ac6a616c1d1bb7bd8ff7e96a4d250"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f778161306fc5f1d9e649b2a26983f31266a84bc79dd1b0016c8de53706f9812c4cebdbde78a3592bc7752303154acd7f4d27c2d5751fc7b1fee62677a71fc90e259dfb4b6a9c372515fac6efe01958d199888c360504ffa4c7cf4517918c430f5640fedc738e0cc1fcec33945a34a62ca61a71a9067298d34ac4a93751ddcd9a0f142748a1f0a81a948c6c6a16179e70b6f13633fd03b838da20f81450b4fdc1752e98e71296f1941ca58e71b73ea93e99a98f58d0892fa16de6a16c602036ac857dd75f9ac2c9185932103db5430e80cde9131e814a0bf3f3e7a2200a7152424472fd27f791a854f29aecc448f8d3fca3f93290266df3193d9e13e08907ab2"),
	})
}

func (s *drbgSuite) testHMAC66_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC66_SHA512_0(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "73529bba71a3d4b4fcf9a7edeed269dbdc3748b90df68c0d00e245de54698c77"),
		nonce:           decodeHexString(c, "22e2d6e24501212b6f058e7c54138007"),
		personalization: decodeHexString(c, "e2cc19e31595d0e4de9e8bd3b236dec2d4b032c3dd5bf9891c284cd1bac67bdb"),
		expected:        decodeHexString(c, "1a73d58b7342c3c933e3ba15eedd8270988691c3794b45aa358570391571881c0d9c4289e5b198db5534c3cb8466ab48250fa67f24cb19b7038e46af56687bab7e5de3c82fa7312f54dc0f1dc93f5b03fcaa6003cae28d3d4707368c144a7aa46091822da292f97f32caf90ae3dd3e48e808ae12e633aa0410106e1ab56bc0a0d80f438e9b3492e4a3bc88d73a3904f7dd060c48ae8d7b12bf89a19551b53b3f55a511d2820e941640c845a8a0466432c5850c5b61bec5272602521125addf677e949b96782bc01a904491df08089bed004ad56e12f8ea1a200883ad72b3b9fae12b4eb65d5c2bacb3ce46c7c48464c9c29142fb35e7bc267ce852296ac042f9"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_1(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e72d696d4dcb41a42d89037487b3eb01d2ddcf0407e4daa0b8ff562461eb6f83"),
		nonce:           decodeHexString(c, "b2b01fb9732601f3573c6831aef09ac3"),
		personalization: decodeHexString(c, "8bbb235642f8caed49700463168ced9971a0204b981025bee41c72b76a965d51"),
		expected:        decodeHexString(c, "8e5cd2a91ea113072623b787ed37454fae2c1905a725be3b124bb243057794dd68325a5d8bba5d6c7796d91cf682587ebe91f6beb33c5cd60b00940bf6de57c7fb082b9ba0e5b44e021be6d45099ea59367291a733ca50334f0315d52ed267af1b98e5be59359a0b9965727d92aafe4c92fda2c915cfb5a378c7a717f743a3524fddf5a48b1e7e113fa6e94b76f4e13fce3cc18b970f2ed1c34bd622611c979b6a9712c4447c3e50a7bb7ae30a8bbf479dd4242a8c4d1492c892107bb4ca695e3c790c9799bc6ffd563ebc3a4968accfc2085ab576ca6e9bfb2904a357c2cfddb55378994e5e4b36008cacaae024312fdf036a097f0fc1d3f9e75fe7cff74540"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_2(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8d6ff3e3fe6808bc796a73957b19d758b257fab71dbb4e39acc2fafb01f88e98"),
		nonce:           decodeHexString(c, "2e2b74490e062044975d6b1885f61ec7"),
		personalization: decodeHexString(c, "b5f819154ed5442d5547771af76cb6333d7f35e6f3e1cb03b22d09e601eb8eec"),
		expected:        decodeHexString(c, "9cb257ba9d77b95e5bb2305424116eedc126b9a8654e56942e282da3823c09d9cc1c4b9c4975f13f9138e93ac75c4bd552c81d41d6363466cf2a38e2eec9294a93630dbc9d7ca89a0725fc7e41b0e55e8999279df88fb579dcc500aaa97d78ae354496048ad47d0b0285bac5e5f6e9bd50c2d9bb6f06090b3835171533d2105fbbb3762b2e33bb75c5f7c89cfb809858244526f8de3aa4f611bde41059109e8ff21b81392b55b9867523b4a4cf5dd74c23a2066f9b26225cace5c5822888f7f7dd233816ec3ef137852945fc6648b4c7cf11fa744cdf62aeb02ec2e68c29c071c84883472619da2680068aec82700cc1cec0dbae8b740b3be7c4b6c972c62998"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_3(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "138a1a9408cd7de6c1796910145263e5816d377cb9949bad0927f9c61e7fd18c"),
		nonce:           decodeHexString(c, "71eb585159831189707ac6b8b6f80100"),
		personalization: decodeHexString(c, "9c0ca722c55c19694df96e70f941b5b230efb1fccc7a7abe0c471dde92a39272"),
		expected:        decodeHexString(c, "976e1a19af964502177d27b09458e3beca6e9082ce21721d31b7241795886213894f2e3f9acc23af6aa5eae7218d00871dac9e237cde1dd9654c1e893bac47e9444f4dabd26d3dcd9f11a68b297956f135df32fc3470f7b01383c506e2a2fbdf1c387c4ce684592fd4e5be0469a29c8031cd1ccd002edae3bea44c93695241296d472783df68e5ac7a62e33a5a74f70fe45252f88309b7f3603f43a5a0a823cf6f3bd8670d50663ecc326aed709224b60fe67ed29860b31c8161d416dc5cbca1c16e69cd7ce41a77cd465cb810f2b5963d15e352715fd5e6175c68125fc8e107d6573ea89db8b34fdf93e2e173cef77746e6142c8e5c44dc288ce86c0710a04b"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_4(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f4010441edc99d524f6caa660c180e25afdd09315f2a495ec003471e1f79bf0a"),
		nonce:           decodeHexString(c, "13bc6f04d81b25f4d4c9321aa3fa58b4"),
		personalization: decodeHexString(c, "37fbbb3fc5aa698084184ecc8e8b45212dcf851e6e4f2db8f775d3f759ef0c4c"),
		expected:        decodeHexString(c, "cb3a853a930cce84703c47719f6d609fce15f903a887f646c0781606f6f926765afd7411b4fc44be350b14cfff04383e4930eb36f94329033cd5f21d467fa74ca1a3c61c94a290bf6753809d8e7b75431d9450361613b16d6be55c392cbcb3d4212ea42cb341878cb268f3daa87c73297a807e35b82458cab693ec9bf66f43328ff1c4e727998d841a1d1491ad55c08522e5c69f19233fb4a8b11e937c55afa38ef5e0ac74b6f856902501a2558663f453d069c291d762da968298d596104580d80bf0787ce4a148dcda5ffc4b47c653f9b7bcde6cbd36dce707738b114d5f6e488b17b63f402c99d0c2b4dca40ef3d05025e50f87fbad86468ed5c08599bfdb"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_5(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "64179b56a75ce27513f0353e10a5107b935293af96799112448fb5787d9949d0"),
		nonce:           decodeHexString(c, "f38d2f6e523ca3ef7429621db65a37d6"),
		personalization: decodeHexString(c, "f0cfd2400dd8d5e857e5878fc811a5c9ce5e0097184ccdc57c0f96d5a66020c3"),
		expected:        decodeHexString(c, "b79591df35bf97c7f4731ded3eefcaaf9d0033bbb0741c0c28aca622e211491107ba9b9645ed325ae18a7aac6160cee4e34f3d3a44de58af0f5fe148b3c93fa37fd2f98e1c3c46a216bfb78d2636dc6b89501ddc315ca16eaa31a818b2fd100a47ade02234096ecdbdfd0997a3c7a4481815665b9a41070bb1bd4d7d9576957421d3b9b75d0e06419298aaacaa4f77afccecc7a67d59295aa0122197ba72b115b8d6960fa7c6c801785734f716b36805b97d4416baa1ab16c190bb8095b0c9e1267f1ade79791333ef6e442c681134dc1ff4ea547a89b84fee3bee0cb481f0afc3d1d2026add34c44f67dfce9c01ffcd443d0d5eaea00b60d0cb2ef4fad1dbef"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_6(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c21f2ca0d103186755dbf2d8470c0282fe11824f0873cfd7935671d3af749ebe"),
		nonce:           decodeHexString(c, "961df3048132b35d39bc1f96e21672b3"),
		personalization: decodeHexString(c, "d040489ad6f484b13be395fd99fff34706cbf96867e614cd6c91554d61231eee"),
		expected:        decodeHexString(c, "a91bc36569a590e5dba3b64e896b21625a8555f71ab77f6f348d2d787e19594046a255f265bee7171100f2db39e3a5d966fcdd88ebc127b23b1798da44e03006a1987a4f5c8af3d83c220661b3c1ac45c5e785d96075681b2b19da1d5b0d143f3cf43c8010523f08feb59360d8a3dc12f101f2542d9fb0161696914f96cd1db573fde8957da6d7e9821032d9fca00f657c326ec0418cc3c60ae387e13894126fce27573ebdc1694853c5eb3bf37f82a5bd59b149d36cb3d408216315fecfbd2cce84f9e5186f24557c3c93827f6962b90fb1f49260250a55bb443c327e03e4a615be0bd5d290decc7fb6813d8b4d8c5619745cfaa1302987f2139ac71448aaf6"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_7(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b3679d82e8a26b602835fa5b780e9678d8a84cbcac2cd6a66174a9c6f68d86cb"),
		nonce:           decodeHexString(c, "c4b1bcdcc20888953f8ff22363fa8a5e"),
		personalization: decodeHexString(c, "c35fe47a7a0c8f82af93ec7dd162aeb423af44aa71b35d299d561b65640e43a1"),
		expected:        decodeHexString(c, "4fb91c1ac25546550d914c1bca10943f0bc2d6785d11eb28eef7b138b42a248b7866eeedee2a00772d3ea216430344af63e896fd0731e93ed7e06e96024385af563cc80cbb27df9285219b1abc57949c580b3d7b7b2e956ec2375ea5069c89ca50602494fbaf80b06424fda851a7576806dd18cb8c96e11c746b71e272c09eae0d3e1a5e14d46a4f09ce1520c36aee0e565f3093e703786bb109a4362620eec6108c0ae71abcb8e3a46e9907fa74522cf47f81d743ff4766b7ecf81982340e573a2893636ea8072373a628abe72e78fa22785e607d4fd6941b6b58da5d77517e3cd6d228b67b49b408b7b67c76ff126da818ba19e4dc36ab647f3b3bdb3c9e19"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_8(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d120f00e06be42483e026e4be88267ca2f8c1b92f3a8342fd460ee5f2f162bf9"),
		nonce:           decodeHexString(c, "e851a711e87dd4ce719d660de2988754"),
		personalization: decodeHexString(c, "28b9fd7cbe714602be7d7d8a159db5e72cfdc8ad8f25cd18023da801466bcd2b"),
		expected:        decodeHexString(c, "6912a14bbddf7b5fee9d8df4e06662b8856bcb85ed0dc70061c0951b46ff4a6d9fc49eed01f71a9155b3f03ec31d2bf96d0cd5b961a36cb702c9cbb4a938f3a5cdbbd22d4a94f12434a706362897617f25953d6f62243cb3b8cb21877cf74899d5285a5b7fdc8fe18f49bc7f0fa4d200e8c98ee38884e4ab56ff8e31dd2420957c016b3a3dd65f6cef4b440d1a4f4dd38ac774e0d06e4d32bcd1d25aa54417f6e2be37096fe6fe6b2e08863ae1f03f9c7f584ccb5790d085647a1ef6a39614b208fdce993294bbcf2b66692d41a9c71b91fa0183486d70b3ce17c8d3b6ed8a3eee804ead37cb8b13fba5858eb9ee7e44b4cd9f5d1e063c33e15046bc080bb3f7"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_9(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "256eabcc37aed36ee6a5e288f6a96c28b8554ae987eea487a87f7f1a3c93052c"),
		nonce:           decodeHexString(c, "9dceeb5a5749f26f4dfde9ce42908d33"),
		personalization: decodeHexString(c, "0aeb442729544bdfdaf0a0997e12da31187d92e5491eeb19a9d0a5b8142f4017"),
		expected:        decodeHexString(c, "729f91d238cbbcb0001d55967c9e33765db722ee3c1acfb58d67f630b24ed6ea612d45b12db152f082bef94fdf1e370bbf1388c26ccb6e5d2567340897cc11efe1c5f87213a38a4f4a8fcf0ed25647e800a5b67b67558f0dad71e560334b15f294f780d837819cbbf068b1855b3cf62d9cc9db854e69efeb82f71d4877fa3af331f9d93c4a44f8f034fe667ecc71114202560f4131002638bb97fd28cf8843b5aada3d173fb1a0f9ddd444bdbf902e4b1ae6530dd291217a26d0c3bcc8a745f1475473197f85de47c3c2fb0cc7dd3cef12296dda7d5f16b62cb2bde59b21d29c0e1c700fc513522b8cebe196ae36542f48abd8c6a0f75cd2da045221037ea8ff"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_10(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fe4e42ca7246202e31849eb9becc217a8ba475c289d36a96879afdffd0996e07"),
		nonce:           decodeHexString(c, "26346eb244156cbc6cb297d3f57ceb43"),
		personalization: decodeHexString(c, "8f75e9cb9dbf8636d5ca1a08e5def41e9c773de65bda450e025b3947d198fc0c"),
		expected:        decodeHexString(c, "952ecf7252536ef906e1c4a9d4d0fbe5696a574487a9192445b9730d96ec2bebf57c9fb3ff1203011ef221625f95721611b10ff4eca17833ce11c4ae6f2155d1954dcdcf17d4d9252a739c99e085c3a6169585fe1b2523388f0690392d30f153d2fa75d8dc12fb8f235cbd83d5d1d0f883bf2f0dff0bc3ecb490fbee2dd09be21cd63e56c90dc92552a7819da8682c1676ee432e1e6c85cb8928b9997ea4af23e7d5dcceaba634cfc31541133c2d11cda92aa858d7fc98940fe4bb6865f8986b27ccbe9889f94cfefdf5e7d7c9667dcb91ef9095daa86a27df13a4bb8afb32d4bc5273247c29a93b4eb53c0189308585bb83baf9b6ce76d995838e035aeee907"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_11(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b18f4e2614719779660fdfbd342f37b944141c5adc2346c4e37733a4da6fd2ba"),
		nonce:           decodeHexString(c, "d849c315f51034df3c7bd39ce4f4ddf7"),
		personalization: decodeHexString(c, "7b6c82ea24ddf29ae2fbea9c9e284506288abff2059c07246689618d3e6ecfc2"),
		expected:        decodeHexString(c, "2cbf77930162fd93a9becce1b29e5b37a9b401b8e7875f650204cce39ce74592686e274372be83c1ede3e7901d4e9fadc5d1b9f58e03e7db208feca9573dd3e0f39967922309fc7e065591b59e6cd7cd4aaf836882d1230320e22f0326c629afada478708125c4ad140b3054c9d4a660811a40df01d6f3d0acd7a16b69b10f388ce317fd795b8336a141a3c3cf95f30035567a58c66a08806c8523984bf18d75bcdd67a6c1f9fc464e939c913ba02d28fa465042e1151adb914bce52048544ff6835d1f81aec6c42f005f592772e751bc7f64ccadc276a1754c382e1355958e435fe2a096818171b644084c702ed4740bbad7f536aad0bf47b3c1fffdb3e214e"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_12(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "14c817683e8013e1a3a56e46bcca485cbf386cf85bc45d11817264b0809919dc"),
		nonce:           decodeHexString(c, "9fecddd4a2d910ff5ee139f436af231b"),
		personalization: decodeHexString(c, "13145848e593be74e8d9730be55c9b98fa551eab55c364127b16b4a295ca15ad"),
		expected:        decodeHexString(c, "4a16be29fd77ac3e0b0754ef030b0702209be0bed2e2292059d5d9a07322050991991d482689e71921fb4f0d189be688fffd4eff001d78e2fa28075101c55ac98f4af065b9fb34df0a1db10ba41c5efb241e2acdf9bb65fa5051c6d01cb8a0d683b001c034cce35dae98197b3a6945b31f3eb1342cf1a8bb6e528dac01c7f0350253029a1ad0899801bca276bc5eb3dd92a712f2e99b21b81deadfc23ca053822b00f0ed0cad1b2367fd3f1bf50a121d29f4a95305877aea757456c852c2ba2af9da8cf3f8a68847749d6ffe8e115291f999059109f2ef4a1299798d2d04bada29088e9b886cf839c71cdae58b5a4d17818ecc05dfa09d7431f471f79abe0e66"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_13(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "bd5263fad2fa0c4caf9b2031c27b1328bd30fbb88549d528fb3227994a012ffb"),
		nonce:           decodeHexString(c, "b37e0aa74649ab01627fe3663d28fef0"),
		personalization: decodeHexString(c, "e49c8fd4b2d1676096f937a0674ce41f2b960eb53e4b35d01212adb6b1ded917"),
		expected:        decodeHexString(c, "f5dd013f8eea8fc48a2a77600cac576dbab7919c91f2d360749ae7369f184fdb428d3575ff97574b8727ad20dceb04d116030b8c3ad2ee54c69e6e01fa1580cedca2949641067a2845f6fffd1909ae2e520b9319ecbbcd6c10afee1ac1e4630cdf6c7f66c233eee4e7147f0503cc4179a5047668f198b69aac1a715480602df33c8383ba3b9cd179c647dbb5d5d1bb20c9bec9d933d75ae6e9c256df9eef4ae2ea062583b6619d45f2fa684d4fb6535c381478c2204e2f448018e9fcc4184d40c3fd02f8382c6f856be5ccbba36a81c7789efd1ebc4b71f99dbb7c002787f9b2cd4a20dc6444b808dfb8654b00afbd1f6595668de0b52dbefa298ab69687a50e"),
	})
}

func (s *drbgSuite) TestHMAC66_SHA512_14(c *C) {
	s.testHMAC66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e9e4f59e1a5fd43acbe20923907227b2790efd1a2118106b1e4823588c525423"),
		nonce:           decodeHexString(c, "fff1f2e2ac117af8b2cb023f0dd6c6ea"),
		personalization: decodeHexString(c, "0a4c2df69d6c69df0a9c58ab7c886ed9db294f5fe98eb066fde543b409ee91e0"),
		expected:        decodeHexString(c, "ae35e947a538e7da73f944b4dea689c064b144b753fe597369e58ec4868099c0f000995949e82dc3e5c00555a2cfe48c8a87e87ae5e7402e2b1679e413cc556f08796269ef3ea83d6a49116349a31710964fb2f936cccf249472eab3267cc1ca0073ff4d964eefc82dd1559c3737661f8b206757a64c756680fb7ab6be8cb433b93f21a04c1e99c777ac26c1f34918794085ee593ca27ae991c53d141e52f90e7872bbb036dce78e6a33e2d638360f9c15d5746d6ff13c1bcdff1cd01749fa51c3c72e68c0ce57423d4915abe84c15cfb3301d0c3b8ffc6a1962c1fd981790fa2a3da60d70e8e8557e4b2e7458ad85f5141ad46e1db751893e8327c8197571e8"),
	})
}

func (s *drbgSuite) testHMAC68_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC68_SHA512_0(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dc01767ed6527b8775e99fd5d46dd33db0ec2ebb393acf59b080510a657954ba"),
		nonce:           decodeHexString(c, "174e0ed454d1b57021fa980f4597ea25"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3de906b138662897b8a5aa00d8cfaa364bf70143d1de088a6f38b610c8f4d2a20c107c9f6d277850fa5f50007744f90cda0e20e3b140f9aac249a43ece99c574245ced90e6023ff5bf5bacee6656866db3fd72a209c79fd9829e3c63a7f46f0d31398e189331f93ec97ff1554bf0739c18abc1cc1dca1d8a8a5ab243b7355223ea6eeaddccc0972f23a03291b28af9303c21c0a1417529471c6adeaacc659554e8619b03fe6112de5c72162dc6e1039cf05141fa88be6abddcd2f312167e86773e52e73336c6404b44820bdc14ffa6f0e8f7149da33743fbd2c89dbd0e75b6bd9ce7703b337031ab51f5137fe1508567340fd11bf4b51f34032385f1287d4af1"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_1(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "197c8b09c20500b2ff9095142c4629becd3a131ed17b99940ab31a53762226ba"),
		nonce:           decodeHexString(c, "4579a3858564901928fed2a75c98f32f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c33b2418bf4d66f49ad1c05102686c65613cc3602d74aa4e5c611873a337c0fffc4c8ccba9c5ab56c3c9cdfd9be3c0da039bf08442cf2ed4af5a9fdbedf0d66001192bca2a2a5dd5a49cf159e2a5ff00066eec08b99312f84033e6e6f24bc5d908cd9d19e6314bfebb98bdf431c9779d0ee7d15cf9ee7e9baefddc6c6625500911d2810a0ec794e28eefcd0fd76590419933e1a1e077cb2860975762926eb206e1eee8f1a6eeba762d7ff6056a37c56649b034af7c976432cc63e672dfd4b564bfd4898de6ae7944789199e700c64a78ecd1b841d206a7c523040f240001829363809569dc5e90762c5c63a5147fdcf6f31beb60151ed54637c73d6df4a93aed"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_2(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dfe546e4148a5d0107f3dc9f735936d87f5ffbd694158d140ff04fce96785e93"),
		nonce:           decodeHexString(c, "943f71ec131f0d6abe5098a00a93321f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8290a703f35fcec670b1239fee36a0059fa0b3a355cda9bc1f824ec616107edf4f101d9d8e7979892ae17a3cedfbc9c13a938335d61414f20308a4afb94846bc8ef1729cd35fca10f0bb975cfb554f8723cc51e9356d13c083fd5954a0e4346823dcd5b5ebcb0e21b788609bd88fe40354dfcdecbdd97d08af772351cb919e3d19ee65444f1269dd790cdac4ee88b026770eaf75c8018cfb7526a1c4efbb9a870287e6a0ed8dc8e67124feba54baefe721ce87da82743e4f185b7f591ef67506ad43c50df769dcb68965808d246f294461d4a55c9a148998572e6ab52bf574a50cc60129b1bbadde86695e3c5d4d21ba7f9e4beb432a39ba85dce836b16452a2"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_3(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f81566d48684aa031fa29e7a8c759dd08f6666b13692776361ece56e92bc3c2a"),
		nonce:           decodeHexString(c, "40b04432b8979914f3e0e19b9d3c01b6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1799a737c4436d32e8ea5662541c2ff628c2f293aaa7a463f6566e52d78782c88a34c505e36f29f351d2063880b5b8c3fc99ed9e02ee62496649e1401b1e151fcdbb3dc76f13b209044fa205d050603fb1197da58e7a1a3c3edc8c4b6adc230239a120b71baa6a272624c67f0eafbe6daa71c681eaa67b47227daa1ba058f399440c421dde47ec1b8211d5c57c7bb82c7448a3491b6209a450ac1e0856363fff9afecdb065051021c6b9f0e7a010d1022af4ad396ad1d164894e1c077fd83b71d55c12f9b41bfec2023998f43a2457cd55bd0fdf0a68258fde7a6fa13beb1070a5183145a2d7b88786b443deabd15e594dea1f1eb72d556178e0c74701773739"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_4(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "36afbb34419c0396505235be6de69861e8902bf1c70a3e2836b97998cbac8b38"),
		nonce:           decodeHexString(c, "d45450d4c1e1c3cc4be7379b0938cc37"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e1dc7fb2c7d11f53a88520928b127cc0e234c1ce3d593bb05967ab2600a1d66b0fb32e70b9985db2f6c14999f3b9faccb72c318e07f9d7770f3a0ed33f2f822e36a5db463cfadbaaab7ec75e773e8d4b5497ac104e23e199e1284c4f1f9e75322ebecbe659bd564ed808f815ed25317a7e5c770eaa40b63a529634a0cde0eb1bab761a91ef260eb4cd2c5e2535d8b51d272ea7251de7c9741c9b3d1ab95d1fafc7ecda61aa8aba1afe220c0fdf3cb22234538c1d47fd0921244b11b55e54aaec9e883ce542f238aa1f746c09be9bc8b4c09116730269115cc649c1abf323f3c1beab4601d402a49d35763f1ad49c7783faccf1bdeafc02beb34a6d247b6ff33c"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_5(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5eb9dd00469067be59bd445b04152b85576725c3395d7c413c723990b9f56000"),
		nonce:           decodeHexString(c, "54b1b9129eca3d2db0c63e4467a495b9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2fa8957e56449eeb60e0cb78e9a00a31842b821ac67e8c883f6be54e8134666b30011f6ca692f4694d663e8542ec824369faeedd281ad710110687092cff0f72990ed35cd942fc5626bd58bd4ca6a5043cce4db8d4e1dec5924bc9f9f2471b1ebc952c73629e3e53bd88b432b6930fd33e9c03daba84205793cc6c34d3e52f244efcb0e0b6335d14dbc4941bad32a8c69d750a7a91509a0ac714d80b2a0e28e14e02e5e5785906b94fa153b7abd1e0dec4b4fd00c073ab6acb6f705c07f8d7239caf3809109c78461d7ddb334edd0ef9902861ef98b7d7ac418ed9c24d2fb7c4414e25794ee5165feac3611caab8945541af42f77cbd0d7c118a077ade186972"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_6(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "42f551fb6533137f40758d00c3b5b81058281f7cbc18ba5f40aeddd31065ec7b"),
		nonce:           decodeHexString(c, "2cee96d6c3eef1c9ed1485cca77725a7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3fd4f97eedccf2e2eddb37caaaae3433e5585c9fddf32aa601c68338554ec84f16aadb8e808e194c4f090defd53ba7c362aa70cdaf8c014543f4b11ef2a3a70f804422242d646a0fa234ac64719cdd7589835d49eb0bd2ada4b6ee458400974dafd17b43a9e5515495d0ac650fbce449e79db7842815beac2137d57b6edcf121389861d85b9ffe68143cc06e4afa9cd9639b45b310acac933160d7f0699a6df9e04b156acb02c43d5d729474bd28559de2f02192dacdd790ac550bd6c9afefae91ae3924494dfae1ce356a7bcb188da65be4eb0c356516246ef1f4e031d6247c61790b267dbf8775261e11cdae2bf7998bbce7c15c7ba5bb6b7857e7494dcd87"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_7(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a9e9d5d06014d240d427ff79fd0c6d314b5d4af6fac5c0c238a62f9224b3edc0"),
		nonce:           decodeHexString(c, "b01fe9f159783d29824bf8055c646c93"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "60d46361f9b1834eb8c103422f3cbdfb243120cdeef6270806039931112aa45d4baa38791cca6b5eeff982a3aa7a2b2627502365644e4a6dc5a868785296bf3ca101e9bab6bd4f03b2adcc870ff9987afeddd9e6ba1edcba09f79192adef6b561c5c36dbe8aeb196da9a2384259583f6d40aeb54197f0291e5b70a34aa559558358b88f5786cd5822a1523dbbed83314882c5083aead0ef17c2ca94e7322142706cac212a5521f6d4f881ac61128b13e327f4b5e81c6bf2649b01b40645edb9aca61ebc58290db9f46eac6cb475b5c3a9e481a80cd98f548031c99e46f41d85456fa87f824e8164b408dcf1aa14fa3f9ff236f11e1ebc86c3dfe0e97e5d60018"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_8(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a160a99bc9baef7d5ec8be75bd005d094e431f555fe4d49d3f1f41fcb3a07736"),
		nonce:           decodeHexString(c, "b5d170cc69ee34ee7ba73f35646512cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ce66754bd42cfe4ad5fbb8a0283cffa51dbd56da7326786ed7c5eb372a046dfb9ef6906c438eee9a21b78327073301c994353c42ad58db488e28004cdbf5c0cc9bfe75aad76be3c81fd72601fccbd580c2186d92ecdb25dc13973337f4876d6aabeeafe1604f1cbd5fbd804a6b15ee1e3d9987986941a4ea51c2d461364276913c16c580e12f51bf4444b5c0e4ff9f4b797cb850a9cc562c4e39e3240a196816638c5e62525f880dd57b1808c54d59f55b4f92d0706b08b25b77284544c91ee987452849d019a65a38ffe3511e0431e7be6207e88a1cfd989185906815fbd4c421e31c7f6cde9ed3139a87a5e08930e44aad1294451e0ad8f89978a1379cf7f3"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_9(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9ec905ee3602c95906f6084b8cf69a8be76d268652035370cfdf13a871a85f86"),
		nonce:           decodeHexString(c, "a7764c145e668435e219dd8cf9cab23f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1996b8d7bf0d43454d61239147a8b32a27d73e0b1c1d8bbf8ab5b751bba9cc813d8be80c0ac7d71ce30bbd5ff5b1b17c12413a169af3d081f8ab1739048a0d2c1c2e24c5e44b0dd7225eeb227610af83a4a271fc31da57213eb6d938edcc2da5e712210202a09020ae24967e271677adeb2dfe6347cb6573e413dc20ae7ebd151acc91a255dc5153be1f6dfbaa4f2b7704d557592961d9847c5d8302469b02e3ca07cf331b9e61b9ec64efd32f3405319506b772fee3aa1d2ac2d70303d47e193e0e1ac9c8565861a5d7f62e515d61f770e2ab3fed00b3f9e713058322586914d69491fb4515cb2c5d21cf07c710cbc4ce362383d084c857e73f62c58f76567b"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_10(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8dbf9b093d9a190ea8d588a16b5ff2f72caa500a3cd55e0a0b7aea0ca5c41731"),
		nonce:           decodeHexString(c, "a5087104d6327761d61843ef45cbbe88"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4b4ed879c2b1980112e0f4e627eff8f8c7d210f2606aaa2f7d26422c3e4dd3a66623ee501b702ae194b7ac258613e87f248bf49b40d0df4427142185d2e94b8e14570a00efcaf59ed542454f250475cfda7a98d1c1450978336f613f704dd9cb87b132ab60f24a51a1e1d815ab7e1d96967bb255dc5ac351238053602fd774b9223e7f079a423ef7b0a8ec9a71e222825ebe3c817ded31c2e6c68e9ae26feec7e75fd04157f60a25ad6c13734ea8ffcbf426dd61f4adc1a15e0693b420afc3035f7c847766430792b4fc78a32377a808c82ca7a2abc3c8370a3ff192014ffc819b5e842596cfc46d0c79546ea429f744f5b1acf603e65fc472d592ca07c8d19e"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_11(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "222e8db3a1b1a95497aa0a141277d9c9c643d0cae5f47d1f58cc15c8120cefc4"),
		nonce:           decodeHexString(c, "5836e4a886163ee0b2966ae82117b48e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e28b5015a08bb7b427bb90d734089a277eb749803280d5edd578fd4ab6bf48c3c6ad69176c116b3d98452e377c08bc4c2d06f552db3258c0c4062a498e22c438114dd312353e47444f4a3e393109fa4a33fd183b599ac0f7290726f9589f24a266e6214dbd0a165e22b277c88047ce9aba14f0b0912920560c89c658997590b4e18e7bd5989e956b0a4a05791c920adda109c598458209965fac49ba908be37301ae4f32691334975860014d63cd8cb4e12ea1052ab6b6fbf2728caa0d14321735a0a5064fa134276b7617bd081938dddd2fa5380284be2b16874b3739748d0aaa79c420d1a48a1ef860dec60e9a1ee0348854670eb289a36c6c844ec37164a2"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_12(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c648e453f220fd4568476502b7260069174cd037157de9021346e81695a0f310"),
		nonce:           decodeHexString(c, "f38c95d2dd89f2f83a26125306249bce"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "43a9a34282ff596a085abba35356affec9178ede69c2abb61b6f697f8e88c1c89a1585a246e1ba6bab4f9ef2d886bf570e7e17b587bb5a65bdce7c23372eff0a56e66689a000c0d30620678accc0196eca5c3b28d2d7ab89e8919e8ca6cf646797b282062d7c61dc6bbb540b635117c75bc5184f821375b9a03a67f43675158a8a528b730ae0c1f35839a2301f38c229d40890efb10a68f727f8b92064d82dcabbceb764311a1ee66010b5e61cf1b68c2ccf20d15d8d50601f91bb75c5a86448eb230de12d598ddf15ba5ad9b65ddf9c3e6ffdc3708c1768a4cc2378e0c5dc16b9321a5929157473108ea4fc1d78825a6f8815d7a392572ac0e6334b496a218a"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_13(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "19306c387a4da3de2f76013cd9c584dcf5e91a85a6dd35c0f25f2862a785bc0e"),
		nonce:           decodeHexString(c, "ca0ef920312aa7c7dbcc510f9fd0c29a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9e13d3d914923d8a6f3d182cb8b17bcaa961ac018af69a716fe9c95f091c7e15877892e001e2b6d656306cd8359a96638bb4a56f156b4a80a1ac65d2cd284c1374c7b54cce9718f364d40a6bf90ae9ed8b8fad347212cc4546b4ca8e19c3119b2723c190d705bc56e3b2b34e6340ffe919d94dc531d7ef5fd69e6aaacad96a1b2c5278c8735f2caebdd3ba69a779a3c8b53d03428221307eb026f9269d924d5db129c8b6c680000bf868cf65a6732975dfd31276cfd96bb98727b55470ec9391f345c1c2371b3333f5b4ebed9910f72e638dae62bab13caf126fd0e90de9c51709aa3c6975a915b34f97f0598cadf90aca49e961dc5b2b32afaf0801fe481561"),
	})
}

func (s *drbgSuite) TestHMAC68_SHA512_14(c *C) {
	s.testHMAC68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1436be35237c34bac5b5b36b24c998380883fb52621daa420112cb57bc84745c"),
		nonce:           decodeHexString(c, "ed884f91a94c1b0a51f316df776283af"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c74ce568f0c465e79ef3700857cc8857b74ec8c075cada3f2698ff69569318b130b5b079ac5b69814d057097b0a107a546b011db601b2f7aa1708effd6479f383d7d484a5df76b63f1419eb360991475b2cd97590a1887487a76cd6fde7764cba5f101e4614c635ba7b1e18724a0a8fb39ca0948bffc441b6aa0216cf3c28ae6c06a24ad1bbe68970e06884d3b68325a3d7c1dce9a2fe87d565dccdcee7c62ed32b577763f510f0029a99530209628359bedf4bbfed1a13c222692d8cae60ca736df834a6e316db27642ed5839d2e11716a5c06e8d067e8548d7ac0687da801d292e2a6f414d7470d2e72261188347878d18e00fab3d4c15cb4c4a73cf963437"),
	})
}

func (s *drbgSuite) testHMAC70_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC70_SHA512_0(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c07c9e1d2a0f0b5dc0b4e9a0cd47caba5d2669e393656d3bbb8830e3a1d456f6"),
		nonce:           decodeHexString(c, "c925484deeb0c02e1ec7a38ef5e36794"),
		personalization: decodeHexString(c, "6252125662bf914498ec710dd31f0605278245e955e9533099ea9afb0ad6ef63"),
		expected:        decodeHexString(c, "ea3ee991336bf6581121965ff6a6283014f5c523d1dee5dc80e2721eb83a45b987d3a8abfa55ee72ed6cc2068588a6b8caf25fec88ab5f85ac642ba24e8414ca1e707e3d10f7908b186a82db2b68ce58fb47b670730bad51f8680d59e179f032de3a0f79723b933673264098fb1ec8f3793eceec7131cdd562898fa091571df4cd5e32026e7889fc8b659e90eab98baa2cb43096c352e58066ab913f05e728136a83d24e76b41c21ab6822c4ca4c04e14733a1dfd2b71a270b528346315609139005194b7f3d07bf28108af97f09fb374a57bb9aa7680cb9e78e2160c972e938ffcbabf12b971011ab7c1a91703d3c1c394463d907545c82623a3ae1d2af3667"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_1(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ef6b4f56c5db9f685e6ec380c464a4dbb95cf606f084586c58672b15d053d64a"),
		nonce:           decodeHexString(c, "e16ff3c7a87dcefd6e10de7911ca6ed9"),
		personalization: decodeHexString(c, "50802dacbd92284106b984a2e396fe6bb812d99854e400089aa90cd5f144269c"),
		expected:        decodeHexString(c, "879ebdba3b1b84207f6fec1a1634ca18367ceb5965f19e27e5ff68560a37604b9735adfc9afefe54a5fa2dad2518256d3c1df4df770f674bb7344b10930d1216af13a34605177f083b4e33709681def353db5af5a299736697222ce8b642e11c745ae8f0cd1b76f4ef769982defc93c1c70ca94ceb83f8886859ead2f726e3fe2f4bca26af14cc7709143c45a6a5b958d91660ff8963fe17ef2a8a9de834021298368291e2a84be1ab767b360d2c949a97261d69886d6ab0722f45c95598cf3080cd1c80afefdcc671cdc5ddc447342226f17579b49811bc247be11aabf9cf7ebb3c792ba2ea78bc0a790bd100389acdc0b4fcbdc207a90397ff3cc1797ba3c2"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_2(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dda85b63923ad8ce2bcb0b4b6b3a84a214b9002bb495c1ff8dd0c827e7a7666b"),
		nonce:           decodeHexString(c, "5a8694dcc941d12b4d493c19cd570de9"),
		personalization: decodeHexString(c, "2216173dfb01b06b657de3436d0664a388f808b60756149be8abdceee6f4cf2e"),
		expected:        decodeHexString(c, "9207bef177758af5c15d7d3966830b6ef24b4637b6add27942c6d424e2ea88f019c0461248d2617b9465a83b05dd41d7068a7a504c8db20ba0764e06b94b90c6bffa114fc60edd4800d5f58c423da2e50bf5da0726d33c26003711f12a7b0d6aed1011352a959d4bde66ab19102a18afd0a5fcfb609842592b91b00a287671d86779d53dc68e1d9cf60377319e338d3f55825b46bb5b7b98bd463ca8f15d2aca6085f213a51fb35d5dca650a27b4063089a354e6aa2e56898d638c2e344a3a0b4127a231236d2007a79e0020751f2b8a39319b98ec17b6c15a4223af59ea5c476f963fbf5169cbad65bb871819061df647a304fa3455efb7cb628c2dc208c208"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_3(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dd3ad19720c1d6c4879fa48ae23714bca5a1d66c0954931869185b48dbce099f"),
		nonce:           decodeHexString(c, "48c5d647187ef550d19146ee9cb698f3"),
		personalization: decodeHexString(c, "18f7902106c00d137e6b15a4bed0b4accfe6646128ee8823ac669e24179303df"),
		expected:        decodeHexString(c, "98f4bf7e10872da726b3f51faeb78e7526dca37fb55a83b50b774e6104e451cbf7f369bc34373bc13812bbe7d85e0c1237ddd0d88894cc93610d9511b8c703aa337cb32a2a36f876cc262e2952fe9428b92c387705b6a0461e8b5c7674a69d6bc60db0566bf269c989ca014edf9e9a4b03179506cca38808f3f7cfadb64f3e803c343a86285fa12038acae76447185fd501d5a2e6d28fa115dee82b51dee3f3fbfe25e773d251a020f563aec137c70039b2fb19280dd6af9ff02b637bcbcd9e797f26106906f9592538f4c2a9dcd48f1ecb38f7c2ae448f21170ed80535ba1a8f54d75e4d716a848a27d49fd046862dda79f1988ba90e3ddf6b5986ff969488e"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_4(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5e2d0af8be964d1a61be969defc7f60a06814b957be5cd8ca15664f497794b71"),
		nonce:           decodeHexString(c, "2eae930008a2aabe1f198c85b8a8d6c0"),
		personalization: decodeHexString(c, "1199ca7cdaf509f81d91ffb82fde7c046ac4656d3b5dd0cf1074fb5038347e49"),
		expected:        decodeHexString(c, "88daeabbe4e2a2569535426d288b9ccbad2cd69560575ab7a41059f59f8cfcfbcd0e2014407cdb6704b017778d5212cb1ce4e32d644c3b41202013f56853be5339df4213982c4af9ecf7159354277e03618b7e43d1f0598e8989820d523f656bf1fb337b50c983c90b05f87f4f758f0f087bc6699332efc4674661362f6a503374016808ad6f40497e4bb0e114d42015725d9b19f864fc3c5c5c0ec00b8053a578538da3e137c0b4be7bf851f106e2d95fcdd7ebcb1375ad3c73c9873e70081f699adaf7d84ab7030e3b223170c051b8483f23159e98ec9220e84c0077dd6953d407dfb1e3748b3eed11e50ca7a39f89a003ebf69e803ee20d60a6ac192195d4"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_5(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "92ca3d101093735e51f6fd573831b25999b1a5ce1c097e4f77f4aafa6b4c80fe"),
		nonce:           decodeHexString(c, "d72dbca1fee829ae441d39da0465e172"),
		personalization: decodeHexString(c, "22e63e6682ce40e6680f2cc9d7a9ad1a596fc6415cf064e928bb1ab72df2db0d"),
		expected:        decodeHexString(c, "a5e34c0e957adb585c30195b1273b68d4cec0b345ed1bf59411733fc384d62d47ee2eede9fcd4e62781b7c2a03d5edc49d2d199f20a0942f26d97426e5c689bf7b6b81332ff8b4f9ec595e604a49c5752761c97b3d592ac04701c561a580460ff11351cb885c34834bc46d0584ff4fa9b449fbd9d03600dc1bd622c4e4940bb6a64f4ac7e71e8c23d52e1c348eff5b9b7f8b8f1b95682e53e8972238273956723dca7ba68e0e680d756d6acb4dab55d8a11e3c5b4c79d4b34905ab22c43c83dca629d84a14bb5bdaf18578b24d7c82b4661b4b17e77f733c9adbf798fbae707e7b73c812a60833d9c95d974e396cba4272f1310f6dc0ac1bf5d5a823f000d533"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_6(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e1d4f840d1a01cf5e3baf6eb6aab35c639f60571275f1c115eecad9ec2758f8b"),
		nonce:           decodeHexString(c, "f5c70fdd75c0aafbf443d897d31f181b"),
		personalization: decodeHexString(c, "1a4cc8a65d133ed5e0548f770277d0e3eadfff3c24f09e00f15f1f0ccee00d4f"),
		expected:        decodeHexString(c, "a194fa818179426cbd54eb333c2517054cdf917529d3a9e589f27dcdf99fe3c342b95f4f79806c236f786a38bbe110a8693563ab67ba6568b45e309a6d245b1f87ae2d48ab1d3ea36cae52eac12b44f4680f2d611ce9c72f56663fd1e36fe45aeaee8d4e996c1f7d38aaebb0b531e2d663108994ba31a2ce149d5a32452377e05dc4a413df8dfb10b3595df855e0e07c2a347331e871c0b00139bd0a2ecd715a4a5a4e85239f466c779d96f44de09142bc40f3a48390f9606d65386a214d99932b0ed3be2af18bb0de0d05e8a875334e62291ae6c0b91f39fc1586dded2d2fb318f2d26d843332218798faefe3e9e3425502efdf010d1dcbd32f6343f3c85f1b"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_7(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "53f51d0b68808fb3624fa264a1fd9256f59c248dbd04f90e516638f95f91f58a"),
		nonce:           decodeHexString(c, "67fe6aaf8f40159e194a0cff0162ded0"),
		personalization: decodeHexString(c, "6aa803389ba0af55905fd1873fffc6c9453034a363dba07bee0cae6f73254fec"),
		expected:        decodeHexString(c, "912f5656584c52f95a4a503e26c23b99fe2dd4b96fb03e8d86b29d780bb55a0086b3a77a67ab163c56abde4ceb6a68c4b06eba82371f587ed043739e12cd6e722a6d73d01495ed89e35dddc2b794ae7155179c609dc4f9a7edefcb4c92e1025aff94a9d24b7d84d70139051a5c1e6ecf2db9da2f6bbdfdcf613dc98f9008d444e5cb59b17dfa7caca4621568f897f77c77a5d85eb4f60465cf8f58cf5d37ffbab4d6b1a56136ad14543e015ff7a225bacf8781525e96c3e31b8da29c6805572620feef74b20360764fbbdd06233f1a94905c378c66ce86066c12cb92f8375fbf14f4fb205de70ef7ed38b28932fe186bc10f6dda1c73c20e18718bc6b59b39f5"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_8(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "47369855076e8388e990cc50d9eabaccebb582e6c369a99b6060424fcc23494a"),
		nonce:           decodeHexString(c, "afc19984384c07a8fcb59c8e63ba97e5"),
		personalization: decodeHexString(c, "088a77b7655f59f2dba8fbb3aed15499e13342d66c7b0655cfb1b1395c725b44"),
		expected:        decodeHexString(c, "6f084fc8c0b936aaf49e1a98f3a96846735895ba71b246a837516b6c678b5f6a8b9a091fc6bab3307f428e97eaab850e5cd014e7fc356e2af6c8d673fa58c1bd201fd8be3f38759d109bd06d6452786d230700ceaccee38fb0de9dd05a5f9d0a64dc447ba63f92d93c58464f5a14026c4e2d83d8af8da039839552dac49fe50ca95fb38ef1dffd8ae4c1ba5640621c087118f8d71d69cca33cbcb58742a16eb90bdfa51238877e55bcdb018cba252e26f222272a6c267c28be26db945fb4f0cda1c0b4ca281fa2a85b2625504609fe86005b9e71237bf50c31cedf9e13ef022d6b348873d9f5eb3cb9a980e063d76c9e1baab412eafe3f6980e560fe6d8efcf8"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_9(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9770de601e4657b3746637e5599a79f4ba210bb03d8805fba3fa1f2f26737592"),
		nonce:           decodeHexString(c, "148dc9db3e1e58a31fc21e596dec2324"),
		personalization: decodeHexString(c, "5bffe17060a51fe205385ac70c9634873cee14fef7ce2fa8970f7e9ffba450f8"),
		expected:        decodeHexString(c, "30339e731f1f4fc03c326affccc77c23678f6ddfda53b944d9ccf8429b4ff06b36f77e5e0fc378d083c9381e8de0a24285aa3b17dfe2ce7f3fe591afdc0e9a91e9a90f69566d104bac8086781e543487f652d77f836462b01a3c5f1e8208ec43f6f7aa78bced28b9de9b1de36a468630966c0762e31f6fb8b0d07a86210ec395aac19c5a4f3661c9f7de171106f656f705ef14e7f30d3bce37335ad53093f5dfc1971c39a0fece8259800d1b022de76cf250bf5d2a22ff62227a8a4176f9c8308bfae7fa68c1fbe7b2027254c39a161ba4280e38785f664afeaa3ab2df3c99c28939378c1864282715d16335c8e75a085d7f389aeda6c26c331683fce2d01ace"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_10(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "381ec64f6818df09b9295dae3adabcd409e6302d5434f15f37ec9e5223f08a05"),
		nonce:           decodeHexString(c, "deabba7b30c167c6e6876b63983163a9"),
		personalization: decodeHexString(c, "698f68deb716fa4258dfa3869119bfa258b0645f9742bcc362988251276659fc"),
		expected:        decodeHexString(c, "3533a7cf3cc1aa7b16ce6be85d863b65734649b6668fd63dcbfa92a320af14b6f2bd01008e6a7a2232f36b4891a566723d63c4915ecc00915c96b0f50bc999d3ad4783b8e3d6157b5204d46b2d709479a2c5059ff8e78cc156fa8b57cd51ecde4551263397bf097a3d659bd257c9b1b3ace8d062007ef7595b2a25104aa50aeaa870714b47174e4553af3ae88be087e821bcf44ea0770cc8591a115f47d89a712fcc6707380c48a5b121c15cae84acff7adcf5fbc1d9abd47eade80e6eee46246a28b5da9ff4521ddfc1cb6b34d1ab4ee79fa18eba29a1bc7c10bde98653e732918b6176ad764f3ea31543240beb406c473f1e60f6b20ab383be850ddf581cab"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_11(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "93c686ac3e6a7d9a4b70fa7152354f3eab1641bc3afa7b4fe4629d94613d359d"),
		nonce:           decodeHexString(c, "2c0b9cfc3c188fd6e16721ab5186626b"),
		personalization: decodeHexString(c, "86602b7ab3e2c375c39eb6419b3e43463ac13824ca92f138f8d4f774f81a93e8"),
		expected:        decodeHexString(c, "47abfa2d8ae584ef51c493c4f852c9d198b64a6ab238ad10fad1ae468d4b79fdbd5f37b217e91992dfef34ecc1198218ab9d7cfdcafa7fd53aec3bf4c04be52f43d660805f559ac5d9a6b7a27fa6a9799bdc7a00adb6617816060691391070f102c134d0fd1687148413efd2d4215ea5e2fa18d270fba542069634f2255713466a4086c09318043934a884ee2a1dfea4a77017883402a222d5ac3bd4dbfefa1131cab7f2590d339e848065a82f6a3cb366cfa0d6a8582cf99d32e89473cf7a7d2db63e964e48557a1210499beddd73073028cabddf737a8ab9b7ea17f4ed7bfb94c80f03f5f0e5ea64f4b59eb4b3dfa0fc1701c3a2fa7e588b0d4e9586560256"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_12(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3aeefe3b75307aff285d3fe8907f123a9fbb748232a11ef6bda3c12c86f20228"),
		nonce:           decodeHexString(c, "98de460f9c004152bf9920414759fc2f"),
		personalization: decodeHexString(c, "e3c7a127cfd509cd8944f762c5991d9de53c7e37673f2208486c3bbf8ab50b98"),
		expected:        decodeHexString(c, "10b72d019296b20db00cc383abdbaa2b69bb4cf3296c4fbf82fdcea190d09115455cbc79bc2a373dc04fa52758fd21e1012e86f4b4ff6ccad0dfa1e5a27b619e62fece2eb9b6e65c5aa5fe22867304d46971a6365e33f60821cbec79546010433c7771e911a15c2726ad039680011bba5b6779bf107b98c596e4acc36de55e8db936e512318c051950c60f1ff4273bae501b2b325f375c3ec10a4f0d076e6be9a146851e661465692170037b01c49d17ee9c8e42545c5d6ab58ba1fa2c7322e735bf70c1c8266673e8dad1cca8e6cfa1e601be95917184677b7534dfd2c6f1640821cc675794b29fcc71df517cee4ae6efe95d2fd866939aca4400ea374a8acd"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_13(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "bee32aca74973a8b63b36cd8ac04a68f36484202c6249ba92cd33a1379ee2e6c"),
		nonce:           decodeHexString(c, "a5d175205ef0278c9df481f882d482ad"),
		personalization: decodeHexString(c, "ac5f8a3e150849a818d0170bcc772e0397b7c70cca37a466fb774bca78e4d708"),
		expected:        decodeHexString(c, "22104a4798cdec3742e654aaca8122f69437867fad058e34e840bf94d460b61e2d7aeb653ce8c8723c00df1b4f77eff3a70345c1a2b3fd601075667b5cddeec75bdea28a5066833f40b50d7350b12a5cd93afcf19b353d06083acdd05f8c8b64542c3ab2b4ae1283df7fcdf747d3b0bbb3ec3345a0f8fcd156692a4a2e6d887c8f3da7289282865f4d75e0ac46cf06b4a93fc0f7ef19aab22290104095cc1f94b03688c7b3712491b9ab2990c204120a22e6b08e1bcb3ea7550262fca5bebf28b4e062e62085ca87f96d259fc17da8cc0f30236265668e2590a68e8028417e4ba0edc1622a6f1b4d8bdf9519aab87beb2f89888e8b3bd6a0d42107653a69427f"),
	})
}

func (s *drbgSuite) TestHMAC70_SHA512_14(c *C) {
	s.testHMAC70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "cba112f4a75eb3dadb31a728f3ea66ee4671e971a313e6516ab3b3890f7432de"),
		nonce:           decodeHexString(c, "70916df78dd9ea799230435b3e48686b"),
		personalization: decodeHexString(c, "bf755696adb9c92839798798f836b063cbbe987f0163ef3f4a97222c888f5da0"),
		expected:        decodeHexString(c, "411cd8e76e711447e8a93ca95aa3aac5e51f559d65a8385a15e71877ac8472a347d9d453bd6761655711ce2133900d28e41cfd1292d28848646e5cbdcac1e60e49e62aab169b1735e701e38d65ccc073f277972ca85444dea86c19c0c08317dbbeca4fbd5d4295c9da71b89623d0028cebf1ab68fd0aef5b37e76e2e0b3e7f72eee04c01b6afb180b1fa0c370975526b788ec4db076a16a798671451af3e20d323684e232a25d78aaa8ee43f734f1555bf0a324053c7c895dc3e098621e189962a914f486cd7a5ff330f39316afb762b1a06cf8b593ca00d7edf739e2e6827a7af662f33bb09fad09d6bdb3a565f2bd32512c79927d390c79a1cc6db968b13a0"),
	})
}

func (s *drbgSuite) testHMAC72_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC72_SHA512_0(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b8986abc6b50516023dec0e7781e93b4b03848dde5e52228d294554df1c2bb00"),
		nonce:           decodeHexString(c, "f33c24a6daeac094c1ccd55cf361977e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "95b7f29293e4a8f8482708020c7ecd95dcf05cdb3df4a4483b686419c74582b9e98edebf5ddc6bbf9814f17f6d46eaa90cf3c13ee1747377a882483729b3adc9cfb3f7d4c0271347521aba7396f100bfd57083718effdc69930a6ab962afea0275c667c7152f088f2019c44b416eab94ff01c243b158676068e4fe44168073e30167a57a4ff8cf8010cb3bff991f4e93e70db1e37f40a7a82d4faccc3be32b9135d027d95ac543b632a310620a02e3b470a254e9dc98c4e99e0136a104312639809fe0dd94ab03a2eeeaa43ad232e3793b4aa7b0b78767d11c85d2f87f7849ee2d7189f1e4e5b8b08bac8464454350f1e06e7b7a5570071521a7b7b3b722b8a2"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_1(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "91c55c82bbd72be09529ee915eb2c9cd13c7d2d892aa2d4bfefb01e427c348d7"),
		nonce:           decodeHexString(c, "9d117b412eb74a7959bae27760f40e2f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "63ccf23c51a7a4b0c2ac4491b8d38ec2489236597a554da8436f5b4dc1eba5087f8bc8a4f01ae07bee9e98e571de0120b7b6d2f6dcce99993a669437e52b2b2c98b0f63db9f724b42dd182fadb69be98ace37f12e1d27ef95f8a3018d8948a20c6b45e3931f659a27ae20231ee323d45d8de5ac6d8464a2712d73cf5241d0040c87129be676689da5f90bd50f5617baf6986d1b9d2f691f6bec73508b82164384b65472ca5f0e6390bd983c8ec75a3707a9c019ab559a7a6e89ddcb9254a89bd413a037948b94e6de4b191a251366de1fd8813b5dad261545f868ec907d0525f1201c62bf1a673b901b3d9d44a362f3d2c7cc3a760b2c9948764f8504cb29a69"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_2(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dde440ac558146a64d1e2c2f87eb87478e0bbd74e136e689f3d265256e241477"),
		nonce:           decodeHexString(c, "fff859ca9364614d9b5863eb66241c8d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "106f18c8ed2c030f51b4e93558dafe67172b90d87ec55cf2bbe05ae4e5b4aa1ccc48d8e394474c7df81a1c251fc7e3e6ab3c19dfce7c295f254bf11cd7b111b78ccd711fd87eb3befe8fd7eac04bc74c9c5973d4d1e49a6906fb89bcc7596a2d5068aeb44750029a2527ebca0be10a1a1cf6bfb07d76424fcaaff1a363723de6b4c0e5dc571479bfaf2867fa367d7d959b948f45b195ec62132223170f8fd4afcedc7a00d27e61fbf700f49d75dbecc39a9ae57e5f3912afcc5332e079474c4b9e378583c55e3b6f073701d887b2eca9bd847b6465318b1a449e3eb10b0471a7777253dd183c61805b0d8014467c6387fc32d96d4eb52ba83d3db2f28ee05a2b"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_3(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1345c9f6856380372ce69dfeac4ef92df722f03ecc518641706a051745da310c"),
		nonce:           decodeHexString(c, "3bc180fbc657cef9407b75d1b54cb1e7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c83d6366f2f83627b33b3c656a259007a0077cc81b898dd4d61df0c29a2373fa40437510f34a5752e25d70641936f47a37c760a653372e557220d2315815542b7146f4aeb3ee9f9ae20ffd438e252240d8b2e08b0797d4cb1e066003b76dcc678adb112a82b7a3ff1bf8c65452b302571d5fc02ad3f32272a6a386e3c977e756ecaf2d3d02e8cc093b862897ce2e5e948dd8f734d55fb17b07c16d6e709d79e6e5f55f9ecbe6e273a17d45822ecd0ffbc3c6c414a0f9e48e47a93fe851f95034bf26dcbbd1ceb9393eddd6af5532b4890b492217fe1f88befd804b6ee1dbd4deafe0d267ebb3d3b8811ef3a56cd6a3de86cce946640857a30f2f50bf2b49cd81"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_4(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d732d597e8a0422d76f6e50efa36e3730f59e3ecf79e315417a51f227541c05d"),
		nonce:           decodeHexString(c, "def492adecfd386c3dd0182ffef8ffb4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ce4473c4d793faf305df6e140dc003789a07a30baf67ec1536f7aa9a7cc1f471a04bb9572136c171de8db565f2699136e27b99df40edda1feffcc2dc69105dc1cc28ed89b16043e11e4bb3d5d7f6a1c2af9a2682c50059ecfe1703aa75246f6e0f6059c3011c52a572851a9b6a833aeb9ccf2849dd17fbc9e83a038462ec9ba2237ae49abd362d3e8741bac32785296ddd9fdf65686123f8bdd880299a491e9236353321bb61251582c2a101a236b94656af99ea28697369e5e94b00945f8a78407b9a8271f3e2ab4c782c13a5e5be75537adc659ab2d163dc126460e9f6985dac8a43fdae67502239c85f634fe48064222ab8c3e74e71f8170a4c1c6c5f5951"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_5(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5c03a20629e0853b273a8c5e8f89203740133523221903a50b03ba6234d6625c"),
		nonce:           decodeHexString(c, "45501a3fb480211f9d2b905ea7594986"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5faf1daeb0830553498d82ac172c0772d8dd27da798244ab2c6757b52e0e0a296778fdd919b39878e97a22db985d2c6d68b67b73e6e43fa9fce011500aa9145ba44b118ceca3d563281fa4eee23f7664d07f1882ee5979974ad726d37f43bee6ee7a16e033116c4ccebf1f65a859754716c43b98021bd588c79bfb1926db0c0211f7461be4b273f1a762fa978b04151709734c8d6429c9cb2dfb25784c9576847c48433f7b97675acb5df1433509f074e0877bbbd4e85aee338c734e53f06ef895f62224333465c35e6edbe0075d9daf3c0c8e1bf690460bd716792a6f78f0f47a408734317f6ad5b1d48754c24faba2579bb49db0582dd4ea5e2b9ccfda0579"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_6(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ceb630090ef9282f160d091a8e72b664783dc3fb75991f3ae1f7c6f73a2af906"),
		nonce:           decodeHexString(c, "7c00f71bdf80b23077f1f5b023c6e2d3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2c8416d3b2e9a4d1d613b5e15d8a11d47893a625cede12d0a72b2b3bc51a20898fa3ba2277b5a6aaf1533cf89de5bda5a4718a303a6e34ae7faa1ab282b96057459a743be70c4d966824ebdf872682ac4a28d24ccec49c5a8e001e33bf56f01a0d33c11669d75133e8711b763463e40462a78fec1f92859306c3515986a56aa3834dc6e9fb6adf4c59519f288c80519491f1c0f3ce10d06058ded3ac519918156427884b431bbc13d3aca7d10e0674733c55f727e18d84a5de635d92fed7bd08957434367e803fc2c8f33cf41068bbcba158bb28dc0913ad6456c3f5208413795909c47e375292b7d4e2e23a68df5ae3c5850b18b216991079ae32a211c95da0"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_7(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "76b7040ddaf267ec9336ca11549bf3ca5b7bb0a8e5f9f5d8590ac8b6cf7ea1f1"),
		nonce:           decodeHexString(c, "0dbc66c634c191cae0b2f868cd1e3ad6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2895076c2ab15efb5ae7d61fe578f78301bd35cefd33f1e752a5bcb18a65c197479efee3b262277bc7af37bb6b3a2e18a2e801be374745eaffe26064d0dfdf7fcb173ab4ab5ad3bbf99c27a90cd4fc874b0dfb729981ec0d0087594d191f353f454e8e764b920630b4a9821f1137164f50f5d29a3b2d85c592d6a01bd3d3647cfa0e3b3c010039b91d567f8e8f71bf35b23bca871805ea6a3148189c28e703d4f87e34fe52d759019994b7ffd6aedfd4eee6f05c96a46bb7a3550967c7fd016538c6fd35708b4f74b6c4505e0af52a221af880d89be0ad1e077c94e9321608a11d4296c3d2506c6ed3dd7497934068604bc3f3d8dfc7590f78c88ee6bcac3ab9"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_8(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "576e23bd76a4db151397ba4f88fdd359aa2bbfbde4d1f5faa3341ef472ca552b"),
		nonce:           decodeHexString(c, "49e936bf613e20debe5dd21c69109806"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bc35bdf36345602ddc9659401358ac23b4077e3b27e2655d521c6c41ca8b3e895f572a175e6916a38a6844cd5b7004b5fd30972bb2ecaa1492c694fc951c84b782b3acbf5e4e492d200ff5f0e445d0a0a0e6c98a8b9af6e29dd22a4947bf3476c04112d157636acf3f01286bfa9326b0c6c1b150273434349a4e2fc4241d1c70e50c2b60552bb608b37825f5942467e407f8c97a0d41c6d6687b26a8518d3faf08fd2a2f2ad770d3111bc0d4feb84a17aa0e94fc21fcab1027c5dacb66c8b6a47d93aedfc2dd9736eeab146196f9f689627958886f2a59436f652e5385799cfd2a68b3fe7a9f5e3c3393113c07274d4779569dbc00ae688990354387c0bbd93d"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_9(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b1a179214be05736fa7347df9c48d5e232daa8bafb3d4f97200af85efcd4e3d7"),
		nonce:           decodeHexString(c, "45e7d8d1df1cce8e4c7b8440497523b8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "434171f3f7354d83fec4db3d3661c711af86509600390f65a9bba8e441012ac77fcdf571d8ccd0cfd251912ce649fc54635a058ae7ee7cb6f569b23f878ddba61a7697f460e38886b6c87748d681e92f0bf9fee069518c54e8ec68e97f8a37abb2ab3a52229486150d58d18d1adf04c0da18681aacffc5aa930c3917b363d5d09563a551d357c36f0a4cf8ae1ac19929483f38cdf6622e6920eb59f53f2adacc373d7de0d44fa850de05c8a6769cc62fa06b1613d8027d926858aac39b6caf61d2d29435aefd106910234b1cffc5cd44ea7c09980e0841c7de8cce4115d5aa570b842a66aef9e2fb79be1a5b80b4d8e16bf6580195d88855896a781f7818de65"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_10(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9246151f2e277d5a46b79d0974eee76bd6a47b4d0464e01c00155697bad29380"),
		nonce:           decodeHexString(c, "43e6b81c6860e213f058e63d2f3104cd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e72f3fc80993eb5c3cbd9b1f5012b53d33e7c7fb10cc4371ad20f1b80945e41b4e7114130fc5d86aa3a2869cc28c8401708d6a52fee5e8fa610ef5f1bed0b3e6392a9d238d714cb4d177858508b0623ca80d8458509b12e2b9bbb45482c68199a9fab0d3b3c9144d0685b88200720fc0a58095603851397ddfab4b1fdd014aa893fd3821680cfa9fdbd356a62cb59939401715cd2ac1f878fe78b4754a5f0c8860c6fbe554a95331264ae2b5f918fcaba26b32c1ee5dcd9722684e7f5d7f18c42a1855ab7e2b504c6af919d3fd2e3b0de2022afc88b8e9082fae2949389456f323ecf76ba43074de7256b00ecbc0ce278ecd8024c37e684c1af05814ee2ad34f"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_11(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2eaaed64e3c5b25e11944f9cb797c659faf2f4ca559d318b42bb6020ceca3928"),
		nonce:           decodeHexString(c, "b9cdacedb393b03add28bee49ebe58df"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ea1ac99b43133c3c5d6976cf339457798ac8f3f087b12539fa6b515257d91937750e3bf4bd800789422ae7d8fe7f117ebfe100ace693d25029a60d094cd9d8a35fbd19883f029446c61d38da1b11644c3c144694e66a8c082fdb1b84789a53cbeebc0b4261d441cc9c5875bac228b4ce26bc4fe4dcdac5deffb4e5067b20c70dbc24c3f240d92a405de0292db868da057f29797993ae95cfe3a1545892984123ba34b8fc7b3796012666d749c37f019144dc9b7b4143b3af16724641dbeba733ea1658e8d4ddd35025e3aa162ca9c53ba39aebcb4ad9674556fffa6e6c6e0294f6924e585bf7d0b2a3d96e849986a7ea567584e6cb5f05bf6042092a484e3da9"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_12(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "65b20851e9328b872e0cd0fb8c609f12bc533b8790273f32f4d87d1c652db2d2"),
		nonce:           decodeHexString(c, "dec1dc60443d1026ff9d6bf2da30786e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7dd708a70c37e5dbdc566137ee13a57d56ba0036f0b0a348aa07f468305cd41faa670a2e7bcc67549f96bad30f886ad093f7ff0598abcca9d6e92575d968aad1ba37513e60e3a4086d1e18770640eb4cb3941b26807f4eab0f83ff3d4a0e5aa386d15604f775951bd68f3000040560175466ab53f4e9dec4d2d9f06bc749d77b3f0bf7933ab7ddd991853036aff2a7426e3650204b1d91042a5671ba814c946276ecb6277ee51928bb78d2d1ffb3575f6663ecc654adf845a1476e5313c62e3f44d1cd5f3ff909bd1efd46ba6211327199cff6c260b221c198f87a70031b85893e91e47c7179116b646754886c72f6cdea09b19027763fe77192466c722f7122"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_13(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "99a904a6549341d4e0fed855a64efdea701858a6f17ff86ee53c267b6269f61b"),
		nonce:           decodeHexString(c, "4aea3da4fa7c79e41c60b8f75d3e043b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e256006dbd3e4f916687f875cbb071ba9acc6df7b416bb55ff5eacdbe96cbaa01d1e58e70d813012e5ec02f8c681884e5e80b9089c1b43e6189c257d98c13289c8e7029153f4d3b1981cfbadb42aafcca26f20de807b40c239d77ca7cd47f3f4c9e0f86e5304eed35aa3cb11fe41a313268c4654b4cc9b6ae4e044997e5aed8d433e691cc2d82ae725c76af08609a853cb9ed4ea468dd3dd4eb919b5e796102916fa217d9c3097d52fdb0a0985d04e4a8ca0fb13a1fa7152f6d6776e4f245b3c3593fb7ab6a464c2ca05be4e25b6ab48326030b4692438e316d2a5704d0dd577978c75c078101d6552d8ddab17d360c0fc962b66e763b2f856e49dad9caa941d"),
	})
}

func (s *drbgSuite) TestHMAC72_SHA512_14(c *C) {
	s.testHMAC72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f5ee32b61bd57a4a4d51309e846f636560a8bb2a576c65d37a3f715ff1878014"),
		nonce:           decodeHexString(c, "c638557dae4f9ab6e078c61d54d0f566"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e929e6c5c4a629c49fbb8623aea903ea129bb6484ed542cf940dd97bedc292e8bce924ef0cc57fa9b50b17b82618a840375874735560aea57e4e9701e4ecd0e812d1bf9fdecf67f431e4d7f6f455dfe4bd3b9a1553c574b0bfbc933a31580319c97682dd990c7081b711c2fa67a4eb54472be39f634c5dd901848c012c309c43f34d189a72c219acf8ca393d3f2cb292d62bb4d5e88f2b6e5e0422dafeac17415af623473f26ec24e65082123db9b9c00dbce3ca1942269fdf66f14add6c486a00527a39b050c2f3a6bc461e750f6e33236de198742284998bff98b7b3f6566e66679b3d8a1e63561fb5f8228867b8ff92230a9f2a6b9427821b6d55a359994d"),
	})
}

func (s *drbgSuite) testHMAC74_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC74_SHA512_0(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "edb77aba67caabf66d3c8d413dc36566b7dd33c73d63e960ada87cdad9dadbee"),
		nonce:           decodeHexString(c, "c978a652b5e6ac2a190904bc40d6756e"),
		personalization: decodeHexString(c, "9b383b001677ddaf1170ad611a6290243deeee5d66800c4df57d9eadea09a427"),
		expected:        decodeHexString(c, "44c890c4ba73a795eedd9166cbde015048f77ff2c66fd44897f6336885bc7549e624f203ad2e89765859d1189d09658e19e4a30d929a896db54df1ad5c3fdd8b87b8e5f90bae3bd9e9810e3cefd816320a80aa8b2ddec800c422befceaaf438005ae24a35568047298b136f47d832fef5ef8a1d53e8a6f1f89ee49fc560f80112f7d40859ab8c7e2e4a4618da79b9968180e461a15e341a20f4e180ea4b2bf01815b161182a282c9524daa408fccad1e9801daa13f1d4804bdf396fa46bf3b0be4ca9405c7a637616212d96a47c484e15ee6e62293b2ddbfa1ce675c93e6d893ae33a66abb7f1a54f7bd23e53907c75297cac66317ad5abb00006de77bf9d9b7"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_1(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "08f94b7b7ceebf999c850a6b83d499b045c421ba32569a81451d19ca4203d841"),
		nonce:           decodeHexString(c, "9d59d755eae840fbbfd9a37e9e02ef07"),
		personalization: decodeHexString(c, "d5550e16a863843f4cd187bfb650f683adbb44c86d50ccc21f3e7630db3335f0"),
		expected:        decodeHexString(c, "a2c62c753a64e44e34be03981037275ae9244b016d05a2c9a63b36fc611c82d4ecd819c1d3910147b25b7bfbee0236ed6711a4293825c5d57cc1c58af1ddcfb8df533d81b613864577936a84c88c267b02521e17b481d61ce19c70ac625952b4b7900bd3e21b66728406a7eded21499d7088aa60cd444a95915ce7767228c9bc4953d53f46d90f67e736bfd7dde2442ed01182253aeb8ea827f3049faff9c210e99c4b33ea6e623ef7b6d2c975c374ddce64f63860bc3c9db27015d23d97c27b90bef3088cec88a3d0d905eb1d11b32596b6b35281bedb3acf36f61feab9dd9ce9fb299f7d78e50404640827851222cfac558fcca1848da435bef281c739cd27"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_2(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3de25b41b5149c54af8241645c5b763c035217d727727bc3eb48dc50b2154192"),
		nonce:           decodeHexString(c, "0da29b48baf4f732099e4eddd2fb96c7"),
		personalization: decodeHexString(c, "abd5ea43928042b4618c2a8933185fd94801c6cc2e30f855e403cc403d306356"),
		expected:        decodeHexString(c, "8595e3dea6d7b4849c1280fa4ad3b99f78922ab1dae43869272396db1097045a66cca3234639798dd0e4e3cdc07154ebf4424de58627eb42724e0ced746bc7f87695d2c911d551bbf9270b9ccaa0b2903db71d75f6c3ad764e109d56d19d388da0b7d921fce449e8667814a9cf0c4115a01d81e49ea117ca1489b4f8c02961c9f9118b0f4159269b40fab430ac65d9fa924d0bf64499526807c8c917de331c519be4df2f1a653934fc6a3c39f4e2b4c8484d91bd5199a72655b9d54d813552eb55136d6821fbb4c48866a6ed9bc3ae1625b5ff5e7bc1d43a251972d2b397fb0c0e9def966f9760d98ee995acc744b9ddd707f42f27b8d8d91eed8bb0d4813f6d"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_3(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1752d86ba9b212382357f36854099c9b7f9cdc49324b5b1997bd89827d80009f"),
		nonce:           decodeHexString(c, "7327fcb73b868a9cbfcff006887e24c7"),
		personalization: decodeHexString(c, "00275a675d26641f1ab35a7528984a8dca8c97ebab8eb6eb28cb66fe84221ff2"),
		expected:        decodeHexString(c, "b81c15c53d887dcef3f883a7d59d4c9c9a0cc12e025dc35edac3bdfddc103075aef3f64a51082bb4192acd3506c485ef3860c3064c58189464540a81048492bbdd30bf008bedaf29c0da72f074dcd1de0a960ec0ba7bd14d9f2387a613c3c90b1641ddd7c3fab4dc87690d29d0e04ff239234f863d82411931e2ffaa1d145f659309ff4a812ebd0b42e73493236540a5f01eb1b16d9b708c096308696fe0e6ebf082b8056cd52fcc5c3dca38d63a6cac9c511bc868a4d66df93474ea8d2927edd1e82860de415aecb983891cc2fe543a2ace004049a9e093e04d4f70de538532665168811a460b266dd67bc690c85978be0a842b39d3b2dde330f2f9a73afb87"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_4(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "beb782e041c9d9a5b139e53d8e08143e0068542cb2b7e5db08499b956eb8a886"),
		nonce:           decodeHexString(c, "cb85d7488309f168aa876d0734d3ad5b"),
		personalization: decodeHexString(c, "afc9951f1f4a984a9a8df813305d0fd3522bb403964bc59a74a81ed0c85c2310"),
		expected:        decodeHexString(c, "bfaa34c4fff641c7aaaddd740fba23c411e1d8b42fb3352c1727784880625d1e361c27aada86e9576769428746007526d5557e391dfdc780fe07ed6efc11867b09445ad1b7e2e2b0677347b9115af686e260f5d931b2018853120726670d5614c6baceaa5af00c0820ffc2a05ecf892f86ea228a8be5fedea5d92a8da790bc124dc9088e39c40ac841d10e2d62447be7d20148e4e82dfc84d5d43a47ed3720a4d3b2c2bad818d4a3aadd5cd82d8f7efe0b78f9968470f2e68dfe00c0d58f9c8d907b39416cbb649aae921e813991665b26cfb454065b0f29783509dfdddbc9ce44c117bb21a38c99ad566ff606fea27d2d9e67b4c052594922245e414c1e3275"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_5(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d5bf7d62d00accf87cd381fbd180da753d77295d2686363694a701c488ab0c41"),
		nonce:           decodeHexString(c, "6b20f1e0dca4e33d41ad2e1e9c208f31"),
		personalization: decodeHexString(c, "eaa87c33076d80188b5fad9b2a8a02bf86444c44da180b96d268b8cfb1542390"),
		expected:        decodeHexString(c, "06526cd25183a00907d645d24335e149ca77df7f85e92748a7a87b61feba04664bcacc26bd3b1ea915ddb05efcc0afbfe9b0a589f059a8e683bf69223dd192bd88f3e2aef159d330bdcb594db1570d66efc1ce9815190e482dea0f49ade057e3877ffd9a09bcc026bf4e067f7c142b0745af14202172b20b22917d040d222aa88ab06258bc05bb9fc82127737f1469ec9a09adbade7a0633bd17b7fbebf6d77d49b53c1504fa1d4916dddaddf929481530d56b27d5380d102e922b359721e94d6fa3bd3f28246b9dd92c1008368c42bc62848a8d190ea63fd5564551576158ec1bddf335e3a4bf9b46766a187b3092b2992e1e6fdc946f037de5a8b2d4e90c4c"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_6(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5a85a9bf855fdcf49be93d2526a919a4894c0f3aeb309d40f207901ecc0fa28d"),
		nonce:           decodeHexString(c, "602a3e7262dc08315232d907ad1f59a6"),
		personalization: decodeHexString(c, "e5e345b3561349e4d63dd0fad99ee220d9e619c88d5cbdcb4450534346a34b27"),
		expected:        decodeHexString(c, "349fde44edd84d380e8874188fa96cad5908b040c45555b819feefd74548efb4bdaf65d70d8df66ffd0ad8ed1164d45abc8d7d13a0e8e926223e154c21315dcf682d8ae7fbb4b1b3152b4bb847864935987a23b3598b1fff783bef3285d42ca902625e5512a579a221bc901ad42e256d4a6d9731ab506c31d4f415a3be31c1922812c4dada6aa41f2cc6b2093665233c67e9a4330972fdf37b388d8548ca0662e144032b4b6a2e0c2eec6aab7d7c0ba1358e2e0b301bbe416bae5acc79736f43668aa9e5371ce07c39779b2d13e25042db12d60e97fe1dbb5bb2c50d84fd1b151a3f2b1ab48a994354d2ca1f472904ea744cf58dd0b1319bf99a37da6f7fb994"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_7(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a2b343ca9c9f9529ff55e63ee3ae949a7b6b503746dbd8f7d6218ac80c0bf9b1"),
		nonce:           decodeHexString(c, "75cf81e0cfc6e785f9726764aa4645e8"),
		personalization: decodeHexString(c, "a59dd29cca65bd03afea186a4954ef29206731fa886a48206ebf7fb6927a3e48"),
		expected:        decodeHexString(c, "d6cf433eca8f0666456bafc8aef685dd0e754809484c24ebe02540eb23aa1347b6c7a50e2dbefe708721b4faa6c789a1bd6713ee9cf90a1ebfea3c3aeeb140cc98632ed1243f54089c5a1ad6e417b07aa2fb6c499d4a61243174c710ddf884f6b4852150ca52b9b720e4695ae896fcce789bbdcdf46a294c745d87d396fa9672e7bcddc44bb3f60c311a188666cf8881372df9f8d5e9c043ec407f88c820efa189256d7c1c7cb80041ed2adb12bde1e0d6c859436c7477af255b142cebeb166e1620e90a7678065c4af0701b56076417723756929b11b2eff02db9c453ee8dddc972cbba1609582bda90a0ae87a66939937e4f77cb1d377232b4616239516ff3"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_8(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8ea56a01e2005c37c31497fd29737ea3b4526dc41437fa458f0b5832ac20eb62"),
		nonce:           decodeHexString(c, "d943aa0cd94bd4978aad7c73780334fb"),
		personalization: decodeHexString(c, "1a42ae9e19b372b72c1b531514a053ea1a78666c16923df2f2e79e6180006efc"),
		expected:        decodeHexString(c, "d6a2ac0a8ad361cfd21fdaabbfa801a355b11b19a1ef8bb273c4467186df3950aded4e5da688d791b82480f8f153da515624273839c737e104d45546e3ecd93a6dd264632109c64514a54d6269e4b532451ab5858f5822e1f591dbff0e059b7f3d4008b568a4ad5da523310a5b26d8db5a567ab4c4a06152113ee8f36a219630391c5dff713f1533f5bc008799156260d6651a40d37ba3943beed438ca200c4ce9fa7ded15c7f603ef42525a44a11d58ee5822085d5b20ab20e7edec9e85b547bbd69bba771ab4c3ff826dc431d6989baf43c9b6290e49d03c8b9994f84f8a284c8cae9276dd0ff1f5b667557c23d6992ae9fa10331b7e9bae6a8b91522215a5"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_9(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "519b1945befce5d1e96187884347ef9b3cd4e5071cec80fb51c98c67c453c442"),
		nonce:           decodeHexString(c, "2fb7d601b274bbf70e993d28e0ed8e72"),
		personalization: decodeHexString(c, "3b80d6282d60ddc94765a1bf565f7e852dc1f02fbdea78b69618adc620c1f40e"),
		expected:        decodeHexString(c, "84dd67414dcf2958a46055de4fc10ca01c25e6cb267382474a5b9d2f1368a57304c33775099e503f95ff1210d4a67d2096c10f1ec3bf20d743fdd76ebdd256dcff2e0cdc5a33eeb53ba22ef8a4fe3ca9d6cbaf80827256b43817cba35a348b8c98030d0533137b503f32d3857aef2dbb28d77971795aba9c13083f60de3384a521b57492708a4acda3a7dc4b23186835f03692cb31e1de591f52e6e75e7859bceace3e1777ecc049f3998a70144db83ea86fc064e95efad6e35b4106c297bfb2755f7fb30addc540c89a5a8851174ce22fd1b7e836fa05e4808a1a407ba0afb3532c6cfa8f0e927d958a51a59c82cfad3f871d52e14347f156288f7993dbb6a0"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_10(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "83cc514fa8ab6bdfb3336054192fcbbdf1ef556c3324934cb37ab2560fa335db"),
		nonce:           decodeHexString(c, "af261aca6c9304f2da6aacae2dc03883"),
		personalization: decodeHexString(c, "786925c06d3c492a86815236ccdcc4accef343c8f38ef3ba5faadfc85cb8cd14"),
		expected:        decodeHexString(c, "8d0e4fc80515d2e3eefb3502227dab5ee4351c91dd01044c7564fe8bae3a73dc08e9ffec5c8eb9f5445c2230956cffd13276dc2567026602a3f0e7ffb355073dfa01730800e6936425a8d26521e67fa309c426cf70a4929f49cf095e792727197ce0d3c9cc1ef4fae13f10893dd9746c7fb50b5e796dccf7cba63fa906a55d5dbf069fa62ebef09501dfce2f5256589cf51c36a01b14a81d0cac61d72c7a9b8d4af509ec7d950a137da62409a71c61328ff3c7494c6267c23a535f592e914ff17a6d9f5d0c8115373db101cec89f5bb8540e1156603ea965c8728c3c6f80728e5b998aa272941c06264605606b666b328dbe754f3f208b084cc7ad8ae7c7070b"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_11(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "14f2f83aa5842c9320e1a3ff8dad7c5e4ba0862790e3558a2c72b2de80f7f79f"),
		nonce:           decodeHexString(c, "74eace5391ea07e06086ac349312fd7f"),
		personalization: decodeHexString(c, "42aad660a98483d4c1b67bd7e21d0bfb68ff19c6ea8f752e8083777e5f619bcc"),
		expected:        decodeHexString(c, "babea6d83335979e5a00ce624eeb176c3cee353b0a54fc527b3e8a0cc50adf9ee0b1c593fc7eeb9172360c13269f352b589870275b19b653c486c1ec029c115e138d9f87a4dea41f68166f8d4f42c6c7db7240c43209fac2a6f4c51c942b5c660a04d39d9de739ab559f3ec36dfdb742a32af806d408da4f786fa2ed2035571a21084965c6d6954cc12cf222a94b6f38791bcb2add8318495c9acf19c7ef57e410d4abc49c290309a5dc7baed2b07cd6198e0790819bd9a877c5419c863e30ec51a761d042a9734a365d90795c24e26802d20ea0f716524cd4a0ff51d477d0576576edf380c19df4f02adeda7be181225af4531e8ab14507460604bb343cef74"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_12(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "00fc95fa83856472b00b768fc708a33aa34f2ed9131806db181c866afd1462be"),
		nonce:           decodeHexString(c, "d83ab71ea108ea16515709e570e254d3"),
		personalization: decodeHexString(c, "fdbb2d6bbc8a928fe4517ee72aee729d0eb1271ca81af6a5088238431ceb7095"),
		expected:        decodeHexString(c, "c081d6b891989eb071bf0a0b71c474907265be63e377a09da9a960242031dd90975980facd28cd796a682204f82283748bbb5fae826fd9ca93aa1bd0defc349de351f7e6f20e21a0ab8136228698035aa25fcae2167118fb45209290df4e6913d0ab1c86d3c9fc6f6e0060888298fc66ee23654c084126579ec84695f3a186f5ebd25785cb46e9a59e255625e2818bad169e6f7cc74c534d12364370faa8a6361f9e7bf555d67e7242cdb938040a26ed80606fd06914e75195d534726318f07b8dba65cc62319e0888712ee6538689d59bea3d885e0726295f219d6592dac0789f804ad13ac299f740bb90fe4931015398a6dd5e9fda6341958111fce25e4041"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_13(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "38dacb8077d4db34f11073e2eb9010dd02dc81ecb8ff3eb9b734f64c48e53fe2"),
		nonce:           decodeHexString(c, "af14d0a2076e6a24f5ca02486ac730dd"),
		personalization: decodeHexString(c, "28dc06090ccea62ffa3118dd24bf603ff69953c457dfdcdf1e9faced7d35e768"),
		expected:        decodeHexString(c, "5c587214e8d8da5b7f02254ffb5a22010a67dc6bce57c87f0d0c06e055cab7ccb833f90eb0138a33c5fb4b0d0360004cc24fa15ae5dcec1338a8233479a31d9ee03f9ea28e78495e6abf4541b17ca14207beedde6055c7f2364564e62a91df25da12f61efbf2c22e88d75a678e4895cddface074fb2b516506d0d5fa65c84d2e839bf043a865065c79f11087f7aed7b116c99a4abb3766d73e0829a1c1ff1388629c1e323eef58c49a7e0a5755f81266a67214e56509b1bc46319f6c7ca9255125dc1befdb475ccb600a871ad705d69855db4a664ce644701f044630a57c2ed719335c5b45cc82e4c57e1408adeb7d748199a4ba60f56642c44090092d88c26e"),
	})
}

func (s *drbgSuite) TestHMAC74_SHA512_14(c *C) {
	s.testHMAC74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5f0d1e9762c2724d5f95c91ae417ec0bdc4646ffb3ed6a880f4380d514caae6e"),
		nonce:           decodeHexString(c, "c600da30d68cddd9b823433845111880"),
		personalization: decodeHexString(c, "8896ff67866ff1f59c8e5074d91e6b9112410c9b6a1eefbcf05a1b8c7123dc89"),
		expected:        decodeHexString(c, "ad8150de910a0bbdad0a674d032919ac3304d5977fc43ad5d5b1fa9be46f22e94f5c2747db228315b0d0505867fd97f9b1582f97b4693ed542c416df1847a85bcd4ad07d6348a4df78412e3df4e675def7f44b1895a8a2156c811040a46198a863c0107aebc3a426b4c2b9ac294b227d323879a70cdf7ceeee7f6f51f102c3ba4ae9a7343aff295b664c869f2c2d6e4396362fdae7d9b5eb0802f37ff7a3a7f1c944044b1bd9b21fbf23f191c6f538398164c2d1b67390e7b059b1c9f5bb031b89a23895ac65770182c8072fb0ad4a7be055d9a4653d08e6b22a61ebdfb66adec2629030f47aca70a06d68c9e1c041ceb2dc9bcd1ceaf61655ef7bbb1653f3d6"),
	})
}

func (s *drbgSuite) testHMAC76_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC76_SHA512_0(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b6218db4a23ba91812f0bcb425335dfa82535f62f580091442c9b84d13520512"),
		nonce:           decodeHexString(c, "0af3420dcb3b3c9fcab87faa4b8d424d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4a7de883632c3994a36a9ddea329a9de611938d1ef7664d253e5521aaa8351fb2b0dfad134ce0265c244fe0bed3a3aa92f0d1a9c6acef83f7de0ab63f8f1c3d7fb0ba92789ccbea0d623d6c13fa105f6193899a01058581c75076fc3b3e4efab80a43bf44d001c04d8d506736ab1f89b19e56964d7963c05b9012eee267a724455ab95661b8264f617be5bf9cf3f802faef499e678f4ad60bd4d0ecdab530e509c3892e285796ffec16d86944d680f9798c1d3ee68723d027a30ac4a24cd786d4d831aa7d513304dace72161c247206c87a19138545abb73e9f3d152a633db771b8fc44a30ef80cf51b72cbb2f3c6aaa4d269d21ca261c4e37b738a150de07b0"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_1(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "40136bc306788c4cefdb176bfece4f36a6394877701bffd97c3ab18bd612570a"),
		nonce:           decodeHexString(c, "ffbc7fd2c6642875705ef4fd03626c48"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a285cafeac40e0f69ba54aad2ce4729c7dfce5986280394d21415ed3d01f42d058f6398cf8f0b66b1d106633485079ff222bc776320f545bd14dd1493558475c47bea679ed53bc467cfc074e80172ee4ee1a69219e9e0a363e0943bab755e321be51100f86c2699999ffd1e28c0a2cd5aaf39ef1a0650e0d2836ba8019b459f37c46a1aad8ebcb428212571d3311c5d62566786e802d8c332e23edf9520545b6862b9bd5c1c3956b469732ee9c613fdedcab0b549456ffefa53f861bb6b2a2b88ebcc6e0bdc46e599d71508029bd38da75dc3c25e72bcb005388928c65bbd95c1a5c998ccddd238f61cece503db24f29e7c9a8cf9e65ff6a1f3d1593212662e2"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_2(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a7b5fb892d79e492e2c8d71a0102ee88fe3f59b8e4ad9cd1d81b060fd8003971"),
		nonce:           decodeHexString(c, "7cc6a54858c8cd55f2fae01c56697c6a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a470511f2b6ccc5165bbbf869c310ce23938ab12c43a41f7948d33a82f11e80488908d06e2af77fb0f20afecdd0ea10066b620d31930a6bfaf6187957b6e6f81b55d2e1326961c9ca81652a9596dacb4902ff4884b58c5a36b8c05aa3c13b67d27b30ceddebcd53fd8b4378ccd8d6120542647b6890c4d02caa295d5ea456496113d3a08e3fac09111eda6a045a3772bdbc70a83493d32a3204247c616de698107aa903721fd735e9fc54192e7c8bf4a6cfd4c4f905a9378b4d675abf7767c49fbff7fede516f55a291023cbad78de62eda3626e31c1ea8cc59a675bacdd28c03aab810681ecb2e56304c238fe24a1c77c9e6e3418d037a775f6e92a70698fc8"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_3(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "69b215896f256a733071f69845c6cdf74b9691e7763441de0e773a31e66443fe"),
		nonce:           decodeHexString(c, "066baca0590baa636f46ef08f5a692a3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "01c9fe0a33ed105dca11803a2383c6d40b47a5eeaae652aca48a13e45ebada151ca8d67ddfa80695072eb6008265976e7a0ddb1433067d9f713f0a227c8790542a8fe78d7b22473e54bd4a8b5616db0201f1e9038beb957bfdad898b1c23e8af9c2b7fc2c9f96c6e6ffdd2dbf573cd78a6c340ec42d8be6025f86e873c596631bc3477848566ffbdcbd68b9e76cf38d96f4f01d8afd3962fde3da68a030daeb0034ee83fb292c1c869d9238af670a5dc4d6788205325068cf1656b4375687ab032a362deb0f80e6aa6ccfdefe4f98f77709bc8d6b6df8324a768dcba833f89538dfab26ed2e4ee631207000658343e45655ef5e75825c7810079c8092f905193"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_4(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6b1e50fbfab2832c10f5d700df82a557c65e02c76c93989f55440ef504323926"),
		nonce:           decodeHexString(c, "2237e475dad8bf250e39186b8ea84c81"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1ceedd14783c8de93a55f78d671ab637df79aad2aa6c27a25e47adeeb972b70c03695bf3868e06651a58fd1bc9b1edd48d8a9f235d24dd6a75f62e70b27e8bf3e6e3f50bb86bff965c5e8825054ea8bc99b92f78daefbaff65ce19b509e502ae7e1c7d64780e9daa88e8080ead7d99da186c5862882b696159b9ebd3119cbd6d5f59d0ba28123c86bf9400a32f3328b11c1907d818c9d50686e3431b2787f0c1e5e193c2353f9ffaea36bec23a0b81e79d9421bcc7433218d4ace4fdf77afe3653557698bb1ec92cd92fd6e3e819b907b1d3b17108a119522d85b62cb78e52523ff53a8917f4794f2b588f20ef0e6d270900a67db64c06d074761220b9bae365"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_5(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "569558ac4d144b413ccfd7190456fbb9774bfe794f87c8287fb1d9793c10f4e0"),
		nonce:           decodeHexString(c, "3dac59142e1618546d5daf95d3fea0fa"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cb4a6120b3f246e8823342bb72b0e1fa96870c444046e9118626aae0e127f79a69895508a0e40b2adfe07ed0f92c2cf72787886298350983ba75577bc7c3ae4f30d66bb1c5da0a544d0e49edc45f2b7d89179e55c12708055340f1588f2b10ba3151e4bfe88cabbe5076a76b6c747064f770343ed9db035aa3ea659777cefd8c14f19711f2516b5d4ac4228e060f256c1824f795e194f9f19d828cff81c60368247bbbc343c72eefe28dc01d9cf15d81f47c0691d5ed67a4c499aee5ae7b09072bde7699f4eaacd8c4c2d1f6919021304027b1a513bb65f669b9451c234011184513b2703dc090461419c20c7fcd58ebc82de98335e0eb504008c0d30e8d7b0e"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_6(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "27fce7d15031d5dd6880083d1ec5c2a3e8625b8c4c0dc0d7d438266ec7de5689"),
		nonce:           decodeHexString(c, "c59e3bcdc1f6e31367e7b8b958eaa7d4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6da842ae1a45995da23d6e3b5ba2c0ec56b21624a2fdac824f3fb3b04fe416054796e2f06977838cc4f68d74d94410a1383d58c8a044429ee74e82fb4ece69a05e805e03965a757d58b66a9f4d224f41c35758a245d68889d60fe7651442b546bd34f8aa01dda206bb1b244d20243cf1e012b786b1992e0366145598ff19eb05a7e6386af08f41a77371bffa59bb69d5207c122b8ab6ed9efcc35e22bcaf7fa20725b642cc5384f261b6a853f3171f9782c50783ccf3d29bc699c565b8c380446bdd9b3591a60cfe455979de800af20b7b9b2014dc7d010a890c95c8bf41ae4144e5a764e0b067000e3a7ea325e387ff8915c13dc48874ab3399669c6580e42c"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_7(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0ca6f97189498ec6ac12e2e5cd37a07822b4477871483af627b4c765da5161d0"),
		nonce:           decodeHexString(c, "f279ca8bb4ea4c7136f0ad8fca7b7d86"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cfa3865020689702cb30dde9f5901000146b9b3afa92b34a88ef926071c5f868c7e5006ae33dc38ed990006f3d7ff1b3d412a325527effd32f416e19394d435043d3bee05166f22b8505fdefb1f28053424be60457833f988cb426f4a8279742f16d2163a898ef6a08c85d5fc77a8b127efbb118d0b1a3c288c29e8e0a299c9e13d3935ab6ed39a8a2dc222ae897da1e34ab65a158f7bf01ec8654e39761fa3809a16aa6078e42bcf57562d213218849c27a929743e7b2c40f6fc72b2d78a3f11f9a7c1831f02593f36e0437dd6fbff652f7f0d956eb9579b6d178f5b34ecd29825028c04810fbff369fb0b65cd23205ba939bf78dbc0310ba15e20ac7b22d24"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_8(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2823011f32eabe40c1131b36c9f001cc28f7e86f15db184124c15e26b8d01914"),
		nonce:           decodeHexString(c, "bd4af70749da0f3f64a915dfec31e50c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a0198acbe891a7acbda52fbe35181c97d58d39844fb2975c96eb0dffd606092e691048ba65295bf2db16aac82b094a93667fd18c23ad5c0b564120237d3c56da6eba0d39cc4d8e023ef15e7ead8e241cbb8d0b2560bd444b84ab3c85c1eebce0ec40fccf680f2c4d440214125a2735d889da956dc3a895c7a69f07854f962f354e67524ed18863ed71d3e77816bf460b171fbd81b0a7c364c0f6ee18d32d7543a13cf5a7d7b992b8bca523e0de92fab578f980cac24d779f806565467702f75021652287a96adcc9f420e2acb22528ca77013501d9c7e5764f625f7edaa52a26b0ff184f343bf24477cc54c893c1434f7bf38d18efcf255c397b9a70fa0b64df"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_9(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "15dbcb3de71426dc0aea3a0851e7390af9e3bac12e1db58dd931d4ed2d9682e2"),
		nonce:           decodeHexString(c, "d87baa587e87d5b0c32d734dff92d9bd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ec3246fca162a62512bc4ad2239270b2b0a98b25f6a7bf0aeaf80099c4c2da07e33fc1d58d41d85df68113c0d0decaa92a3838de2d99f807d615b2e969669422d9d52821315baccaf3a3630b2a7bf7f2c75a59948974759f6bb53d21ae9b981ee54261168d707eb45c0e0f7332ba702f1be30873a96f66f164ad4e78ba0ba3e5fbef4caf4b1d807e7233380f34a6d48013763bbbb5c6c16a83366dbe061b480ed45c8901804b117de73fc892c819ecc42951b130465e30f4c54f0112ad62f7b1193ec0c7725ab6489d343178b212e74ec147d3fd520a9ad9db384073b22a6a478f64b37a2e76cebea0e246660cf80536145719eff348558a72e84eb50245cc15"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_10(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6a36ca9ec24741c1389ad722a350c61008ce53432c24365cb6a60de26fff37a4"),
		nonce:           decodeHexString(c, "50a4c1c05fc3893876e627976e1ea388"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c54305f7794a66781bbafcfcd1a5af259fa3a8b4d47c4e3ececcbbf80f885fb50dc93dcc507fa9109c238bc724289f5e3c765ffb4289ed0fd9bf7ae050c0154d11413997e61789c8bb806c61f4002a63bb2ca21bac9ca65abe92d0594da90c4e122b6ca9d0d4db29265783defa05ff40ff1e6c5089e8c1133d85d8de6f5cc20699659ba4d93e076086bcddb51bab709004e0391bb932440c951ee064de58795c14eddae19dc7ec8e2f2d168e90da41ea4892c348983ea07ff9b961f4a09f6a9aae232ce69760a2d240546b19c0fad337c764a480c9b6150b3db83f9c2b65ed4221433554e5cdc6bb18982c11755717c10f4f1c7cb7aa9d2f388e04a052f41474"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_11(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f42f1d6f989cf2df671516b14a9a5d72a4825ae220e52b058cd32d09802d9dac"),
		nonce:           decodeHexString(c, "985aec205afa866c62d988545950f210"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "65b86867a230ae4abc0c4e4d8c6836a13c1b289145df5111dd75a2c863823e77fe68925696f51e9e9e3ecd8d81ef2717ba90a537f7f48d8c242e4494bda43857314893a53dfc887ea27a3f8fd809bc536e6bf484430ebe45ada15426b5d2d994549cd800280654b29ee75730b8d533c081fc63a97b1751f50a33914ed84f4037f3e9b41c2a6c7b6e438b89b08e55fbd1040d289c2068d9f7529fe459ae9667201e2c421abdfaeb52cf0f242040b6cc5c8ffb5d42f65c71d842c6c7549a4334afba7ddbb36cb98f7c02a985a54ed270b730949db4bfba95034caf778cc9e6ffc90dd9d151e12d62cb400a44e2d5d2cbeaa33814d61a2875396ab2d62f27caa380"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_12(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "52c8842778efd89fe5b79bbc171d48f3406c5d8ae9021e6ac2baeb843a665fa1"),
		nonce:           decodeHexString(c, "ae7456e2aab8f0e2a0cf0fcfa93f2773"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6a8df38c7526e114d111b1fea1306a6cc3553817a8250e2aa6104a83d2dcbc8dc93022b5e8c8f975df44aa07b1cee181d7f13164d1fe7e1ac7dfb1958edba6602d5bbcafb7230f27ba2c9ab4ebb8e27db12799432ce3b2556bd8ede157a669e05a3c892098d428b077cf6dd11bebba9cf344b50bb27c301eecb26dcf38c3d8d63f838401324c9b3eae291ae9a3260a417323f03c75669853acf9c36b646cc2ce6258c6504322fb5b799865a94cc686c82cb66f2dacb7bef9b9223c63c3f2633ea5d77015ceec773bc1ff81329e182a51a49c0a28cbb778588fb4548f1bb118fff6ec374fd90249cf2e01a0706e7251d23fa2d282848b533f2a0bdf0d99ee8220"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_13(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "be378ace07f021f5a253200be49caafa203ea2fb5e2be0e08a10d1ae70c213b2"),
		nonce:           decodeHexString(c, "651416a658d6ca7140322a9b79e66b45"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "307212bb8be68ebe8bde498bd83356c4fb38452a83532e2021f3f1d158c9e9eb8b1594c03d09f313f56037fb9e5f44707a570ea56b55e34c60eb4ba4e2c40bff8f79883e4657be3fdfd587ecc64303f89866896dc9fe6b28025dcb47ef6d49ac368f069ba4d274f93ff58bb7cf90f1e3b97f03ffbd727414e22dd26dc96aaac40b61fad8247ed21554c02f4ef8ad32518c5548300540c7eaabf194c46a58a08f4a637b77521d0d4829cdd3f878e7b44287dfefbaf027374c8c7d5ff35e2a455ba528572b993151d6b5a2cd1d87579182d348e497c9796a7375be6791d6b95c3d5fa6b75469f62dcae70a2c736cd5e44a3d44797975f39614873e3f3ab1b2ebdb"),
	})
}

func (s *drbgSuite) TestHMAC76_SHA512_14(c *C) {
	s.testHMAC76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "60da58990a377a615436ef43b1199f88c7a4629653dde2350a4c5115c42e52f6"),
		nonce:           decodeHexString(c, "592033d0de138ae7082c03553e3bfdf9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7a770dbe8e1d3af1dae5b93acd9e6f1748a4a6a88229a875d23b37665e0cc96d888dfdc428a32cab378a9ebe22409709cd9d11f0c751c08d98eeac13b6f76f0f51ccea254cae23177c3aa207c59b5ce221b93442d037256d553275a6c4b5c83c1fe555a630e37d8277e02c050c19e145a71ec98b96ae3ae44c9ff87c4501c1ff7fd5231510ac9df623b3fb178e147f07d1fe02b48e877cba89a822c91b5af56b71d60116c49f80d87656144854909a7d718b5aa8f071f18357c2c9f9b6c0fac3195040f26b86aa936fd35ff37287aa140cd01ca6c5e577d815790d6fcb1a57569d23e801e2eb2b669ae7cf17d87f9ee66e0b515bcab09087e111da199b6a15b2"),
	})
}

func (s *drbgSuite) testHMAC78_SHA512(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMAC78_SHA512_0(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f85649f8a8c01f8a2925f7e93e356be0fbc75206d1ce2f7e04a14257c3338a48"),
		nonce:           decodeHexString(c, "01a8843b7a3dc0b1cab5f7c8b001598d"),
		personalization: decodeHexString(c, "91022d072824cb580ac07555c90a31373f2dfc272de60d3bdbc0612e175874ab"),
		expected:        decodeHexString(c, "9f40affda9c797363a7b058d7f5b848f0ba366808e7a87ec94894091ca0818dc387a8ab249af3268a9b0c95f7a781d3c7ba613460a2a5f8ee4bf9ed237afaef69f046e163799794252d2c9708ea337b8bcc674c5016172c50d6de9d941f496cbde4a4e7abcdfd42a989119224ea7f3c4727179f42bbb54466f530e4394cf18c15b548ca610511800b39da69297a46ed1b237722c6d50248245f7e90f343617aca44b6245c99a714f719e324c2fd4b95e84b3f7d3212986dd7f51f60e38d1a077398f5af31adae8647bc920e6a0c865a297bffc88b407a24e2d2aead0e711fcf96b83bbede5bb35a5f9b0dc5e2376a693afa9070a4b1aa86dec23e6e597a74237"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_1(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "58b81001b76e248d9a4eab5e7371a97dd0992bd4ed6de18084b2321b8c292b30"),
		nonce:           decodeHexString(c, "d4e9df171d09a7b93949907ca65fd5b0"),
		personalization: decodeHexString(c, "a36d996ecf48058ac850d66e56d812e8c58ec0d89a30dcf30475d3830c4a33c4"),
		expected:        decodeHexString(c, "22d8e1f50c301208c5f198f29cf9f97704f2df46f662bfd7bd2883c22b49ab5d7bed1a2b6cf0c55a0aa0b695c52695b57919dbbe8381fc56e72553158e10ab59d4e682dfc3a07199876c266dcbe07735382d8ec079ab4ef5e622a2329092cde45c53f71aebe43b34990f55ad037eb33a87abbcd3ada3112ec43b9bb20b61bac549733222313de2bd91d532f1c17bc3de3fa34f7d3aebb2b59d6c8b90ce211e184fbe54ac0cb97d7a03e057a6bf69c4deb4f11cab49bcef323e9ca2eca1f4dec50a02ae1deea1d56f037d53da03da870dde13ac7a084d1e2aa4f095b3cbb1276a4f5815cde03a1ead7d5ff87fe7453cc603c0a1d1f6af1eaedec35835a6ce0c9b"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_2(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e2743de1bead33b91f0fa01a64e2dc2175749260d4475dc1c4652c6192ff65fb"),
		nonce:           decodeHexString(c, "952e8d0d03b09130e4df1de0f8de4484"),
		personalization: decodeHexString(c, "b187c33f16414734eb500c3c3230d3600c4b4251c2c44085b7a585c86dc713a3"),
		expected:        decodeHexString(c, "7da54694edc364dcaf51bb239b82b3a8956264bd1279920b34f6a7a33395900b49180e38f0e97a2b1c5b7fb11bb1e4672275cae66a007ce88d0decfca929766c2c07e019eb94ed00094a5e72a82ddb00badada39d4eee8900dba0e71ba29750641908dc4b4eec95ecc3b49cc9df72ef5ecfbd1fa8c9eda509301222f9267abb4893470a75dfa86f793db4fea9bfc1de6c637c2a29d6c60272a521c10304bcbf595cfa632798701da4d50eb776d4dbe01865a8471c58e2cdbed14f083d6b4ed3cbafe1b2ccafe82e73151a8299c3a04d36eb713dd47c9f4d306c0e503026d7d6ab6c4789078c8c95ff5abe002b4bb86a369b91b4ef23c6afc0559a2cba4ff53ea"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_3(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "aa1cfe4c9f03a9990c2dd55c0775ec36f3daf3d64873ef843692b5887b7d7a4c"),
		nonce:           decodeHexString(c, "70484796fff90a01cfc2168d1d0f5ed9"),
		personalization: decodeHexString(c, "21b468ff6f1e92ca410177941ec0bea74990555071cb7d7fc0844fb24cefd511"),
		expected:        decodeHexString(c, "72ca74671d10f6aa0607c3abf4e86f022af34cd8c32cbc274eff9bd38bcd4b79c64b09e68f44a3b1c6592b7f458f743f99a3971becf6acd974792dd5812d473891766460b028f3724036496188bfd2fae5d3bf734d2503316db5c9b408496e9d99712dec355865c240d3209c1793fcc815df057ffe555d2bbf47e7370031893aefec6ef0e71d137e16c416dbe52df3b98f280f5e6b29636d7d9bb0999139fb5e46bfec53bb22c8fd68d2a15df7d4e1a2c813ae363bf3055e6def008ae16343ded598a0c08548801189ced03e6f81b31286dd8e3eab82d648b6a9fe5aa6fa1f951789cf4f5815e10188d2d9755e04f283373ce7da806cd92935aea243d6a566f9"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_4(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2625400a6130e77fa20f0b7c58cc0f9d0f22ef5ea54e5cfa6e6e648933d62322"),
		nonce:           decodeHexString(c, "dff0eb02fc7ce93e4be2e294a24509b4"),
		personalization: decodeHexString(c, "cdb1072fd83114ef83323ccb03d702f68a550d7a0e8b153a95eb9f771a271861"),
		expected:        decodeHexString(c, "4fa6071756afe972853072ba73e203773937f7d6e1dcd7982c37ef7566369e27add7889b32ed2e2c2669d00633c22d91fd98f2223789681fd3b1d93a16c2278b8e4007286dc1273e5abdce7845f87c066a59b0d8152f9c13230ce488f9cf00e7c3e1e0c3719e6087fa251e8bb4ddd3e778c6149a14db3217f172a8bfd656bfe6fe2c4960768adeca843f1f36671b722fcc62dde8b2e0c5765c6232ada6a4504b21f350786d0879408d8979e19a3aa16f0ec47df3d0836296fb88363d1fbc687bed75f14ccceafb185ce90c2b0f5cef3247f1573e822c19b1b9944204d42a6101326b127262b7023e89824a3f2d4fbc4c072ed3dbb7325e77eccc70cd82218f43"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_5(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4943e0c725cba7ac3bba16d1de3444eb367129fa38d1bd6e0032ec1b3e0b767c"),
		nonce:           decodeHexString(c, "743775b879b22ba24d0b08ded6298ef0"),
		personalization: decodeHexString(c, "1d8d1abc5f597648889bc220040cfe3bd49ad771ebf7ff2ffc9a7bb8ce2cb285"),
		expected:        decodeHexString(c, "1cd45a83f0236d70908291a0cb24e8af67268ba14492c0ee4f7f736e48a3da7c5bc80a0aafb54ab028907477463d7587a11c59cf2add25aa799fc39290c2284da916790985dd1d842421a24186aec5acad4ed5e511dab8c28f2a2a0b2449d1aaeb5265e5df2e708e761a42df5304dc92dd2c10028cbdabf5f21c1cf572cb0d55c194a273c166df5dce469ddaef537b3f5e72b6ec8c3f32e2a69d90a640ed3f219832117615c209251a467f7343df9a6fb891c6646f01f896d83319bec63cfb0e36d35d5b554f08a0635c3605d51f9e7cb8c32cf69cf3cbddb02f68c321ae08cd185de20256c9c78efd667a35a3c423e6a0d83213fe0acc1a11693b641037daec"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_6(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c90ef2a9a1cf4936689ec66acf771e3b0faaabbae4af866d4595d20823d04df7"),
		nonce:           decodeHexString(c, "624caf43c3fb18b0a9b9b7b56245ce60"),
		personalization: decodeHexString(c, "ef05d14650114038c30f441f8484301d2442f6b9167f57f1f2c0a77b5c91212a"),
		expected:        decodeHexString(c, "f89763a96ebbc1c4b5d5730501dd5a5910a9b907b1939442562ed880bca94724f9392d31eced9bb670cf355d5113a78f6b6993a85954c8e52d450f14815e8d25f3c5af5e0791fc9f94220994d58b7e3decdaa01993428bb597f1129c7c9a0643c413d0696df191ab0b18691c77e79d5705ed144a3b54ccb3e025f4f71d62cbbab9aca0804b15325d335a35b8ad9d06435ca2b847fcf45a2bd0afc95583cc11dd66f63596c9a81ec1244a58aee352b59cd4173e1b5b51e88f1d64ed887dc7c23efbf7ef49e34bc1324e91d17403052741dcd7e1e5a866ce3e2e424096a4c67ad818220a36a4ef8379f7650a2e49a953fe488202f1a95fb55a929b0e3261f181b7"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_7(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fc9e6a14f9614e1430dfc99640633f2195e35532342ccede226e0896d0c07319"),
		nonce:           decodeHexString(c, "a43c19082988a2a1609150d903106415"),
		personalization: decodeHexString(c, "ec6f5aea1cff91b0b798b1247a2e79bd62173d8ccdb5daf9492b3958ad82c48f"),
		expected:        decodeHexString(c, "852a9d864504846fda05677c567bd9fff95221e620b8473c5e51580697ae193d7bf1f3237fd094363bef04f9231d95b8531a837ad43c7ff18d165acb2502f9e645460e06e2da19bd10c2df17ef2a6c0791921d74f72f91db4f80484f4fe3eb0aedac4e6417cef76e75c68c041be290f955a6121499842549ea9251bf892107614a1ee94110ca401c096c5a88adc4b39bfa5f821fb980b6e6455ee75cfdb8cfb31756565c3c836cc8e96b537080facd6c4c38c5d15c405e904a9d708e92a626cec63a5f88e3fb2b597348a7798559d612fce9013e6cda53b8eef61d5c874ea030d377639f93f3c83b5f7f634da201ce392d9799102ba9ca4c6126dd9fb77b33e1"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_8(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a5e0b94b0efb6e1df2b691bdd3e15d68ba602e25a4e1fa7b17fe124f280b722b"),
		nonce:           decodeHexString(c, "3be26657fd44368efebe93c16b230e4f"),
		personalization: decodeHexString(c, "652fce43407146c069c6d20e557eb75bbb7c72c10afeaffbdb9ff4bb6b2d0558"),
		expected:        decodeHexString(c, "bc9379fca8507d562434c8d54d35dfece72c18197593480bfa7b63b262d79667d8184c9026682b4a42b73ee237ce5ff46d8cf58df4cd7f145ba4ae3964838a787f353f82c7ba02f9680b0b72bd37473dc98fea004ba5f3b87c193170f00aba61d16eca612efc101c9db916d9ad9f34c20595a4df87106b952b9d3d47f3ee346f150e8e4e21d1d3892008ed163c0cde88a6d8d6d6ee7aa2511e15d583e3f286462f9d3d13966f955898d0c0c7a369e886caf2c3df6d41238ba85086e47fa78028f3dc01545834dc73b25509ee6577a6e8f159c70407bb7b05ca9bfe2580e8ab864543fbe67c286230dfb3c792ad050e79ce16ca3fabf73387e85a68faa44ee95d"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_9(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "77f4fd085853b3b577b1b6e10190fe7f1aab5adbe80d8298b9c0c6d5bf695232"),
		nonce:           decodeHexString(c, "d472daefa0831117e7b8f3f667c5508c"),
		personalization: decodeHexString(c, "c52f79e56dda5affe2fc350e3b6aed9cf7de57f2005e1f2f003a90f1cb175974"),
		expected:        decodeHexString(c, "2b37c3d8c45efa020eb3f84284a93c5207b25b71c002d941528ca0d98f7ac42a72f55f1ecd13ea74a296d3e231e453511a496a0dc577252cda49b4e48056ff71cb4e309495d459d6c9fa2e6502f3ef39a06ec4dafc9f14405f14c3015b6ad7bdc9c1077aca97dc7974996c925c66a98b15fe8aa355ce3426b1af68df85491d46da2be2dc58e166edc60216520f18939cecb381d3d4efe70d89f4e4be3c93f11f5be68729f48ad9e501b327146087bb161ce7deaca44622bdbcb50efe8e076fd2e9cc3902cbaefc3abedbb60cbf24ce332a00bf7ff8ec7a2cc81d6669b9957d15d68c03e1308550b7041ce77c95de5cded1382124896b2dea1254af1e93ed7be7"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_10(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8b9e3283cc2316b6955171a2a3de5851a56ac2c3e6de14166fce6ce0d24421e4"),
		nonce:           decodeHexString(c, "8f2caa11450b9c6676d35cfc83e3a1aa"),
		personalization: decodeHexString(c, "55d98ce73f316177ca27dbaca3fa25111c19fac26fdc224adf71e46c33d9e076"),
		expected:        decodeHexString(c, "cac7b77c2664ab953a413557f03b73ba499a7ba627acd4bb81b1dd77198e17ffbab3393e83cf39a56353b387d312791f89df0cd9b4c3bb94eb43d8f34f95a4d2485609728f2fe4fbb4280c35c18a1bb5f5d4f7457eb4b79dd13ae5e3f39ea592028fc95f165cf7024813dbccb18651740146276293d8a45af3d7315978a610c4891134096701bb8cebd9a4bbe0685c06f12f8d98f825b84429ab7363a04043ae9aa5732274194db7bd6517029a92ce11d57710d2152fd877c563b9dbf773930a3e50326a84fd880b24bc142744b8a8b4d0661a008684bebe8d5dd682fab88b90247fea58ee911c6c8719dbc25bc95ec4440f50b34eeec9514264d05633a63862"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_11(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "63740fe4ea180a767ee3ae551a0ba9f87fb93e511830188be1da2f5a3256db07"),
		nonce:           decodeHexString(c, "2d7f7bbab9e17b0eed3d6fe126b49af7"),
		personalization: decodeHexString(c, "dc61dc0b522a10dec7869d396deb1ef849bfa93604299519a520516d0e673098"),
		expected:        decodeHexString(c, "85eeeb0897db47806534ca3cc1b700625e364196dd3dc4fb771bbec51b7e5aac09164d0cd6cd6f67bfe780b656d162cb8a9d9b5a9ddac9a3a38bd1fc23cfa41a17a4271239bbfd604845866f4b515fb0e9df75152d38251f5f50f6b4d99835eae72a518eb83c2e72501a3af9b4cdbd374134f6fbe6401cf592b444be6629af1bb1378b09038a01f459bf95daec141ca7639247776e44cf0ec36c8e494f91f4cf3bc0da212437279992f0986b8f5d592c8f64c5baf2e97ce04983af1639b90ac350a84a9bafd4e659d554dd29e5bd128468675e2c264aecc332a373655704e005144ec1d8efd8e1f5c915b78c2f8ce413242d788927aa8b3f66574750fac7fafa"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_12(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5be0278fdd81b7a4a0eebc3528bbe5982ba4084415152dee27649c6bae0a6b0b"),
		nonce:           decodeHexString(c, "afac0cd0520ad32657e543c27bb01d73"),
		personalization: decodeHexString(c, "265d72a4f0a1f93c91f72c755e9386626f1f0afb86e0bc341dbdc67859c176cb"),
		expected:        decodeHexString(c, "c056c7acec0c2fc67e8a66cfe62e26d63daf7dcc5bf1300f6ee44c818a35fd99ae13d16be2ed0b96ee98aead005d1b0c8ce10bd72a02045608129c12c02e6c0828717a60717bbd2238b88ce40c1255f7d41bc42f44276a140aa4f917ed22896480d81887b79f7e9bf066d28302816cd4c8493917de189caca99276b239f17fd040f98951ee2323601435f008a377fbc71dacbd1eabf80a55b5398a141201dd9ab2b8376ff39bc5ec15e21a260ec2445910dd2413b69dbb77883bb0b538afe8fed0e10ca5f195ee5365289b928b0d6c55f375b32f4e056ec7e0c3457ed9fd9ea8d8ec623b172b2ba5dc178e3f63c29765a5d793ff774030c41691791760cf3b7d"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_13(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a0bc0cd27d6d11f9fdbc9191f0ca551273742c3d83e0b10439326ae6458fc3d4"),
		nonce:           decodeHexString(c, "08e08a673d0f1678b1564e7c6f1695d2"),
		personalization: decodeHexString(c, "dc5c4cdf1531fcf69c55bece5c291a96ce9330a86737770fd5452c1e77d2a5aa"),
		expected:        decodeHexString(c, "e8d1173494b8f4f3066361ed8f16d75fecb9300df59ca8b1357db17f20e669166bfedc14f19aa7d492a92311ec01212b9bfb7cfe7ccb4834d22c0a14d8366b4adab29f2eed561ee261ed617fc3bc031c364e348b46579b2f4c9c2266e238168d9c20c8b353de83c2152e7865625661f7fe4f6c722fb6471127ca7b03af48cc107a1341cf9a40c2279a49cbcf6b4da179173dde4f217461aa118bf5a8a57f5ee4775a79995bd20d1895b71a18d8a373a29e53e286efe7e0db356e343816a114099bd1c621e14b2a44aec76ad84b572c6922c3bdbb4a606f09488061a8ab85c9e2032769f2ef444b5505b1a5c881350214faa716b7b0991e60b6d1076f16a2edfd"),
	})
}

func (s *drbgSuite) TestHMAC78_SHA512_14(c *C) {
	s.testHMAC78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2fa23531e11329997329d273d454ef186bffe879fdf95c8812533e4b8027df87"),
		nonce:           decodeHexString(c, "0a6bef6b736129740978e31c3fa279e8"),
		personalization: decodeHexString(c, "a5ca2491479bda16341b2c14339a5307fc2e2f5df4fa625e0ea351a95a14f588"),
		expected:        decodeHexString(c, "df587647f8d440a6c8034e757cd47f28d0e58f8aad9a047cdc8a70a8b1cd0d8185240d47bc5d2f4657205ed218ec38307e68efad94714630cd490b939719a4a07ab994793112c021969a8c69872903315c74b00b677648673e5883b5f46e075550092914cfeab05454226ee3d2154698f368bfda0b8b99eff5d111c1649a0f7e67ec0f637c6d3466994d655066a95732590e521ca055b048dbafd219be1a04fcd047c3722c4adf29ebd8486e7171359292e11ac6b740b4d51093383d64d2a45e51115c689ae29357366f2013eb9b420c6bd069d22c2110182e842eccadae81797a5f57d9ff47311f094ea0a25d7e329fcccb93c28b92ed85ccc2d690a84f2b2a"),
	})
}

func (s *drbgSuite) testHMAC80_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC80_SHA512_224_0(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5b3b225c13bd5d7bf9aa8ad7ff170697f6492670ff64b5c0"),
		nonce:           decodeHexString(c, "d53aba6178eb4db03d022e56"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16b4152d7f20ba956d3a788e33c644128f82d368e85f125d1c2618f6090f4a1b20c30335e836447549a662c7ca14d4612cf490a3e83927d2255ff398673394a6cf9b3eb46765d51ea1e487f8355249de965d37b7f035240501ead7d2b2dc35b0c6d41fb54f0e9b4bbf513e96871b705d"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_1(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "755b38d5ca8047a5c9682b64417fd2ea12b92a065997dec4"),
		nonce:           decodeHexString(c, "990e8a9283563ee6f1a3b9dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "33b7c05d2fe057191ba2721d161e6d90524743b0e3b8604fa12f16e2f8d683482e789b7afe7ec8e1b86e3dcb6edaf1bc58f50e558bbb3beb4072306eb3568de3aecab1bee824746c2252f6191235962ddbb829a6cfe49ecef5d0a0ec3ab4f6922705330ceacf05034750100efa7ba389"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_2(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "6123e1f18c60e78a726a885cd6b3d5529e0255a0ffbfe522"),
		nonce:           decodeHexString(c, "f660ea8ea57def22e03f6bed"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "347f041021494bacf6ef510337b78184c12d9ad2b680bcf1afe3ff7670f9fbfd6331a14daead42f58b8461fd1d98e1b1ac9e0a844bc4c849e83cb5724c107d534587648c66bdaed7a8b48ac8f03b12e72768c1a340e7800cb8f6cbda6b8691ddb26a9ea09d73a7a78b3a5876e58f9d5d"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_3(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "057a02a79da51dd68aa05e51b135b89521fa3c020b0213d5"),
		nonce:           decodeHexString(c, "933718889255b54a14527722"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b9e3c4fd5cd56fd62ae134f95bfd9015e0271feda314704cf8f901f5e48e60582d116d7930a4f4718eb08cba45b997a5f5b23902f5c11d81b09708320a5735dffed23a4c8e86541c90f7a9071092650339fd855697278880e3be3ce0ea96865fc778a9dc011ba17e2471ed9c0ffed719"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_4(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "04d39a39d5211c50507c3b1526f341f21946d4e7ddf5c4e8"),
		nonce:           decodeHexString(c, "36282819330e2eac6ec7a555"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cc6c02ef46520c4e38da46fed766f7b6c7243ae04ccf14355dd9ed4d56ba0feebb2b86395e7e4d1cf3d7f0f96e888e6cd5f54d54bd817949fd94b30badeb09c28e93db797a5732512b6e03755f3e477ac747d9c2aa06d632786254ca5fe8eb302d85a3966d5852e5b8decfebab4396e3"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_5(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5a47d6b4c3b01665d06bf3241c24008d46256e2f18b623a7"),
		nonce:           decodeHexString(c, "3b88528d2f62853c6f17f27f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4d1add998ab87f871f3d2dea37e153937d5dacdf71f082af4070a4e09316273cba38cd8aa70543d218dc29404f54aec97f609d9ec3e375dfff76df8095b112d0b3beab9165b494bff80baac6253ca711d085ba30a0773f3ddc52647f8356b1f7d5927c237e9f2aec99b44399450e4227"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_6(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5736ca8684b9c5b17e2e67b130b445ca694da7ace0c19f44"),
		nonce:           decodeHexString(c, "1b689c4c8e459e13a0a5c585"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "208883b80e043db8b45bf838237179a2c8cc34609b58894f727c8c6b7815b9151dd48fe43d7b60525c87f31e9d643fece218372df433a85da0df3c3c3855032cdc8faa9af2b2c884ec4c60877d68e16d7d1ff863c63c404ec5c741729ce1ece7e4f2dbd3117b7bc1b830472f1e5a4b81"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_7(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7a747648c0545287a5d9fa58e8c442b750e3524c2e79134a"),
		nonce:           decodeHexString(c, "c6a70b28fadf6fabf03ae303"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dccb525a08c96d73593ca348f04e67a0a1a0b164026d54dd80032241809775c76fb6aed2fad971512086cfcd3f3c27deab1be0dc27511bbbab205a871eaecdbe66108ac6e5a835e759995f56e2728f15c5b0ca60e3728d949508151b750331f361ac0e5f97120c5a3085e217c70aa9dc"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_8(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "38538bc7646a54e7bec0db7dbb75cac62a3633af0ea6a384"),
		nonce:           decodeHexString(c, "2df888e3cba9b202e67efe5c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "882997aed0e655ab1bdf52ce88dbf743643c1ec62b369a22e9db7736b8c0b7fdd2c69bc6fa634fbbbcb92c47692f0bf47b6aa1aa3b5a7790fdf8f019a069dbf668e9774ce90da48c2000b6a7aea67301ac7a83da7f33008aad78707ea37cef5a506ef7b2baba74c39725f49c67b40ed9"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_9(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dd1804090cef1708aa21829c1ba692d343b298c99513841e"),
		nonce:           decodeHexString(c, "00d8bc1b63d36447dc443042"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "057a2fa4ebf0a0c78a3f336cca70b91dfbf166fa000437bba6fd3f4dcfea1b202a866528a9f9a20ff7f6210fbdb261d4676f8359156d69403745dc9837c86145ef0ee4c0937eaf0fa551a4a1414d6b401f48922e86debcc5b25550574393e0acf29e6c807d3a849ab3e6a5748f22ed07"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_10(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1b32d8674dd31f4449b462da7b12c3a6abe569731bf681d6"),
		nonce:           decodeHexString(c, "62757f4fcdb4f807efd6319e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7cdee95ab127bb4c8d77b87fa93562f431650dfcdd75ae7ee3aeab17312a51397edea835451fa163f07c04d5b05fad51d087953f97f231ad10e7cad0b200da3a70a22c918eab3d1931bce6159f2a3b57db69006c0887739cefeb811169d5a0ccc25546e513a538c99dd280dda3cae025"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_11(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "451e3420a0bc88c199fa98f007feb386aa9310c900d5bbbc"),
		nonce:           decodeHexString(c, "0d739bca00f34d94b2048157"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "012af91cc3143c30cfe67edec181509fb616b0bd708806ae5ddb7348ee3cda760474187419d84f2565b65113436ad0567c05c9b7c82996c336db22b8bb8cdb2f918c1d1d21c93330f5e7ce4217755d1b0e701d7de4ca9ccd8647a9ef0ba39e8eea9f6357dce29758c09f5df7a2f853de"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_12(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7333d146d2668fdbaa608a759b04b02fd931921e324bf1a3"),
		nonce:           decodeHexString(c, "8b80d878513b59dcf6340a27"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d444d620441d2256e112d19314e5577e6dc586608b5b8c6f4c3174e7b59ccd30db1daf7c571d3ea249c6fce8b58f6b13d03d2f311cdeb6ca8336ff922cc23923013f38e2dcdcf4ef8abf3accf3f5fe789d254be337116dfeda04d967967bd6e7a80e92927d53fd6c2d45dc77dac0f677"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_13(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "acf49affa9806ef751aa8dc2af66573e09cec323b458e7f4"),
		nonce:           decodeHexString(c, "bea35dd49119484e28a150ae"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "98b367faae684aad1bedfff48b754ea6bc950c631ae7c7a2522c55ae2d47ca6b4c4ae50fa136b7e774ce63ab46d216943328608682edc650c7571271af6c87abd0b6a80e922fa3d293d4e9bfc6539b4f29c55511600baf2cf37345a98156a89ed14e214cfd80d525e57a3dd097442f71"),
	})
}

func (s *drbgSuite) TestHMAC80_SHA512_224_14(c *C) {
	s.testHMAC80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0cac1d970c06da6f224d49e5affec0fe338d0b375b66687b"),
		nonce:           decodeHexString(c, "1fb1df257951ce8fc0cf12a5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7d6e2be5aa574b0edff39ea938e94143ed92b287262891dd2a6c9193b0237e8fbe10056e15785bd818e548452792a31c728acc14ce2bce9295d3776885018a57c8580a8e7df9a34ea960e0b39af4510711320528fa7a0badc6e25a0eead8cb091c404f626343c63d40044055ee9f9e35"),
	})
}

func (s *drbgSuite) testHMAC82_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC82_SHA512_224_0(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7779b338c6daf3a808bd6d4d4f8c9dcc417858c5b9eafbdf"),
		nonce:           decodeHexString(c, "4c3e8a78c4b6cc08add21f48"),
		personalization: decodeHexString(c, "3d3d654bda5319f1f33a8b961bc4d81725708f49295f4810"),
		expected:        decodeHexString(c, "f7417860534c53c0b76d2661a4d7f2a73c3079e257708afd4a098666c6d923e61cea1a402b00359a375f5a2548261e3ffcf6905138fa1e5844a3ffe4807840151ddf8b0fdd779ce2fa4eb2dc69867322a942b3fa379f8e660c4b9cd8f4fc8d054ecd9a3e1976d48116b6227e48f3ebd9"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_1(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "78127871105b41bcab8e2fcc0872c6a349f79bc4f5de99fe"),
		nonce:           decodeHexString(c, "21e680ad4785b31e1c7e196d"),
		personalization: decodeHexString(c, "c16204d3d686bf094f8ec7adc787582385753fca97d58031"),
		expected:        decodeHexString(c, "3226aeadf9dbf8539b43f4090f617c3c9e2af46a9d23cb8b0100c9159e65e6c6c868ee6e129ec051a80a8b824cda03f01870dccc286a8b5eaa83973d418c51bb9636711974123a1594c9684e9048b58bc1afd7aac73af08d39741f364ecca224d10bcda931f1780975de6da62ea63acd"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_2(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1b46250422517fa0a310728a513e16d7f5bdf1cb08957de7"),
		nonce:           decodeHexString(c, "c04fc923b05357f50949be63"),
		personalization: decodeHexString(c, "c13565a9eb0eb4e3c37e52d376004099c317d59d7f16bcfe"),
		expected:        decodeHexString(c, "e9d487826444ddea533fa320b5b6614c626f81a21293a46a426bf122921a453406cfe78b520af28ee242ccf01d9bc91c9b0e536a63cdc0dd7b2e9ced5522b8b715a60090705eb294f1f24c419b7b07e4e87ac437ae42ea50c89fe6a1dbadb4a8ea7cb208649a44fac99924a160599ba7"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_3(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f1a475541673e72ad1d8c87591ce76d2b10ddfa6a37b2a87"),
		nonce:           decodeHexString(c, "bc5fa0485791066f00109616"),
		personalization: decodeHexString(c, "c419f9f1ca9e1d9a581249bf304f8bcdf6aeb72ac93cbcdf"),
		expected:        decodeHexString(c, "534d83f1fb149ef6f907923156b300850be81acd35adb1ad57727d1c45e70a04ef8333c41579af2762aae14fa9084d95c02322854b0b5292e582a724e8f579ce69503558bb547e88ef1076c88b83cef5d90620cdb9f03e1106d9efa10400f721a712b3dbac020332523a4e3517cd51aa"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_4(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c9573801888e1ca2533db8e29b63e3563cb2a92c3400d4e6"),
		nonce:           decodeHexString(c, "6a34b5ca69c275641a7dc02d"),
		personalization: decodeHexString(c, "1a9e250392d2f10e6941879f52c1ed99ddc1dff67c747156"),
		expected:        decodeHexString(c, "1f41ced1a5b39d1c3fc4b4f56c4ece55e9838687359d8815e52137c653a0645629e9874fa1ae2bcc4cf5956b7c07b9b5979f8cb7dc4dbd472e8b2538dc5b03ae0e7ccb20dc44b1a5c5965357fc08bf4d80efc8b53cecdf31a2495813df49434e21dc87bfb206e01aac1ddc01c64c31bf"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_5(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5cd50643670d4416392de743674915df1e1935949f0e4f89"),
		nonce:           decodeHexString(c, "7f51ac7a050697e871ff8c64"),
		personalization: decodeHexString(c, "662803dcc005cdd5132b31e26dece6be6769b63a78c74e3d"),
		expected:        decodeHexString(c, "0457a933c41047631701928096f4e658d29d4ecad3c6e20ec5d6601b48375b1031364aae14d850f41a40aff32611ee03888e452adcf1659feffe6bab68c4cf561e26242f19feaa466ed3c3d76a985fea781aa7a0ba9eaedab04930a01fb3297131fee25bd8c0ba9cf004ac411f828b93"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_6(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "ccc57ad67f97d2cc0fd5832c22aff1d1dc9434b9dcd91b7f"),
		nonce:           decodeHexString(c, "5280496f83b449b8418744fc"),
		personalization: decodeHexString(c, "90bc8d33e5f5c2811c763223b1d116344f2040334d4735e8"),
		expected:        decodeHexString(c, "eb62f1dfc617444e7269021d955edaa4c2e8c5aa1f151617dd6cb4c1015f6bf7fc07b36e91f7fc677a78c91a06867781418ccaaf0f2b0ac2afd97400cbac72248f86c5b7c93d5b32dc5cbec6239681d6fd6ff2c191948b8a9c1702b0e3c155ba7a9135d43109c1dbd7d720b20b0a694b"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_7(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "20b5e9a31f2a548bb7107288d2f5f969398c5fc80b26fe10"),
		nonce:           decodeHexString(c, "16c1e60cb5fd3016a07ab45d"),
		personalization: decodeHexString(c, "d48ae24de4378a50597017aa749310cef92244622486e05f"),
		expected:        decodeHexString(c, "3c7bdd5caac4a54523732edba53dd8af20e27c7b6ab3c0be214c2d202cea315dedfcc1d385ca8edc2321877d10477267876d2118c8c0bf7bc1eaddaaaa1dd8ce771344464366d3c3cb07b1baa256788a46375095220406921991e26e5212317b796e327840ff0548dbb7ac89ced0c664"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_8(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7bda764fe1ea9aa3fde49d0e7359ed0f90b155ec9bc8b21a"),
		nonce:           decodeHexString(c, "1d555eb180a723a638422a29"),
		personalization: decodeHexString(c, "056d7e15879e3c80b2fea17434ab7ad596375756d984b620"),
		expected:        decodeHexString(c, "2c23eaea5ec8f17898b080f203af9992df99f37dae2a475d966076600ed62add0dd70812e203e7c4beacc370846c935d6e5363131b84eb5b4189d3a83729ce2ed4ba30a7b56e6be640ad32a613e301cb316e56b9ae308f27544043d7aab18ec356640bee179e3a6d731616c4e33cbedd"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_9(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d72a48b27af5caa18e767ce1f338d1f69e75b26ec2cc5bb7"),
		nonce:           decodeHexString(c, "59076bb91969ce4acabc3a9d"),
		personalization: decodeHexString(c, "e1eb9ec1932197d0de11fb000ec037c1b529553861d4fda7"),
		expected:        decodeHexString(c, "a7e62143e2419cb5a068fe99cd4f55d965d9da42bcf6870ef5b28e23961c5b31bc5dc1f0c2e298f41d3f75c5c70cef3aca70697662a2821474504604e32205620ffea2a6769ef83e22ced242d56b7e57ec20bf9dc0f504da10dcf563d551b8d89efe868cfb91f8e354c2166dfb13f3b9"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_10(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e27c86f2ade75590f5433fce85ad3da496af421ffdd51cf0"),
		nonce:           decodeHexString(c, "7f80ff9bc0ef064e19033236"),
		personalization: decodeHexString(c, "eb249b714f641102d1f24d274c3267c32f5ed6e4d32fe5ab"),
		expected:        decodeHexString(c, "36717fcc062701f88960fbd209baacddb62dff8403edf016ec54e36e7d6d3b392b955e4d6c0099890c8354c2b796ae81e0a5276298a39b82901b62252d3dc97538a47d2eacca41f9bf7893504375bd47ef482948891390ba7ab9878e9fbad69c6b576b822e2e46697b0051a8efb096f1"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_11(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "107f6c39a6cd5c119408ff2a56efafd487dd994eb9ea79ca"),
		nonce:           decodeHexString(c, "9f07c0e473afeba57423af15"),
		personalization: decodeHexString(c, "ecd1ec1d7af4b2a13a603bba80ae16b9af1c7f56d80e8b01"),
		expected:        decodeHexString(c, "e6cd1028751fbce6dbb60d61b6286820bb201f10f696b37b6dd504182c6110c9888cdba5d0e2acd1cd5fef18bf6fb802bdeae46b145db0894848012c838aa6c0d7899ba5867d3af52d89ac1d7711ba5cd953eafe917f35a6ced3ffd2fe5c2f266eae20c77c5e406a3d9818a8339d5786"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_12(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "888f7757e59da40cabb86ec5c931688a7f043d8f7f283ad4"),
		nonce:           decodeHexString(c, "b7c5cde1289b62cc1c004fb9"),
		personalization: decodeHexString(c, "b9a4f1b1f34126e5e8f27920d70db25c381836edf73f08b2"),
		expected:        decodeHexString(c, "b21e6dd34373a7681cc23b524e7b25fb540ca512435d4c0dc93dbeaa495e70a9b4629eb383ae4b275b59021b27fb4029f5de45801f040471764fefdcce0186b56f08274c7e5af0d2590f75ebedb1671fb5fdae7466e13f851f52d9f027102be0bdce66e01849c229c5c42635060aeeef"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_13(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1cd10ad0a015083c3d6f24ff837e51b3be5692d51937fd27"),
		nonce:           decodeHexString(c, "1411349dc6b43dc7534cf42b"),
		personalization: decodeHexString(c, "a85c155a5cdae4ad4fa5a1d3f0e691eb9b038463f259800f"),
		expected:        decodeHexString(c, "491313791ce732b82e535011ef3435ff8aa547c2caff104a665f1b87934808b3afef4496b93a3c002febc94cc465c772284080ea9ad47abf7f560cf0a01eedea733a3ee6bf38eaaf83e3213245fd337973235ecc46325be7660939c614a1a230feca0a5b08934fca989949cdeae83041"),
	})
}

func (s *drbgSuite) TestHMAC82_SHA512_224_14(c *C) {
	s.testHMAC82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "440f9526897f79d20473708adea88954a4739d7878a45926"),
		nonce:           decodeHexString(c, "7e2f3e4427d00de41ae92bf6"),
		personalization: decodeHexString(c, "2e8bc8edcdb3dfdd451542fbc68481b30964fdf8a6ca77cb"),
		expected:        decodeHexString(c, "df949beb9b33d2c1522cf6fdb3206cb10b58411ba9e28a4096cda7662b69d23e0da2be9557b9a3b5a8d67db4d616ae9fda3a7e0a8516196568f7a81474c0264993b141f14066fbfc29da724e447f6e503385944e902510f0b3971f7bffc6a6a202ff88d8113bb222b104055f427fe770"),
	})
}

func (s *drbgSuite) testHMAC84_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC84_SHA512_224_0(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e3531d9061eead2c3e6156d734c868058ee1106d6fbeda03"),
		nonce:           decodeHexString(c, "49f1adbb9b0434e43b35f61d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c83417e540a8b865e1fc67010f7c3ee53fbc7ab1476af839ed6a68b6868da3df1d7bcf0a391d64a8355483a13001973e6c41c7ef67775908e7722d33d74c3c1f1f4912054cf45907c44f63e95980d3b9431f693257742de46a0110d13e3b4a950ae1beb960827f01970a4423d1ff52f4"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_1(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "759643955856b089da414cb35ce5fef778e8b841eb4928e1"),
		nonce:           decodeHexString(c, "d67fe75c275c5181e9707cb0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b10bf0361c4c0bcdc332c2823ba4cbd5a467919209a8d26162706b7a9847d629329dc7b89a309d260d386196383925ec51abba83904d868c5b28d144ee493fc572ebcb76ec896e545b9e128d08d92b7e403c30d6255a8b61329303fc07e1d53924242aaa666eb75de6c917e41bef5359"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_2(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0d65675d08778de1c87ea1cbc25cf043d25a445d7fa4ec5b"),
		nonce:           decodeHexString(c, "04a0474456542589eb16aef6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "79c04cf6b5c19cc58233175a9f013acdc0f4133a44fbd2acd239ec7147880dc21abef48adca501cec91cd55aa5c4d7dd4396b8975d5ba94bc878e99eadd96cbdd43487fb238e7c88dafd5d6671a9dd7fce815227a87dd837bfe91b38023eab6c3b2c63f91d76008a4fd4d7af75700737"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_3(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "648c10d494a503cb365b9d9c13c4a773a45bba9283198219"),
		nonce:           decodeHexString(c, "b494706cd2655da2b91d97f1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "52912f08ad3531ca54ca395b3a82f03be22e5986a820a712831eb6fb040c4eef906216c752240a53a31d0a9fcddc00875c30ec7eb97149de5a407b1cdf7b44e1e8c50b5f5e9edd8074bd55a124ffc7d87b15446ce4c02ab3b6c18a5907fc1b19a910e71b3b83b708deb166d0668daffa"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_4(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "ef089c54bdb8662eb33221a4ef4f17d2c94cbd10e409d6c6"),
		nonce:           decodeHexString(c, "5cb151a90e401f0a950950f6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4f4a23bbd8b8c854f071aca737baa6248f9e83ecda5ed5fbe9d1f783ae212f75efb298105c405669eed22452b69127a67b6c29173f6ad3b484cf9d79d0a54c9d5088e483ddf2ceca1c92c3a58781281716f4df7c1277327b26954554bf606a1ae2adde82658054ac65d8fa65216e1852"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_5(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "210bf15ad5605cd9941fb8b309c3814abdff496b7026bdef"),
		nonce:           decodeHexString(c, "6f6ebd64164b864c44c93168"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3fc9b64ce46cd25cf6914b3af2962d45cbd8eebd8c5d76fca762172cacc32f86657bec562e325fd7b108adbeacac976b496882dbd43292773cdbe70e8f327d4c96c9ea8148a867d2b32acba33f665984e5ce9e4a70a5ddb534d66677864a0ff1769313bb6a7906e34051beca587040cb"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_6(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5930207a31b4c30034c413ddb8e45369b800f3134707065b"),
		nonce:           decodeHexString(c, "2239d9ad0ba0982832dd94e0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5155a1838cbf95edbcfcf08a66e5cf5f84ab4c80971c39d1bd750f1aef0450abe49ed45ad4a2202330e46f39ca3c95bf09296873e2655d17437925cb9d224c6999a7e21ec60960459f3e8eb4b0ef3f400a8bc741ea14017ef9d6e76094d7f48dbc87f9736c3e1c41f6de94ad2f6f9b36"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_7(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e3c43fa0c7b8b0a983f6029bb588da7291249eb39cd6bbaf"),
		nonce:           decodeHexString(c, "9a03150a7ee282422b738cc9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e9f7d7481f9c8e751f7d6932bac17beca50ab599bb84341dfdf85af59c59a4011fabfd91e9c7d20936243709f1a54fc895cab112bc08cd2ec405164f2a8737b2435a89fb9fe9a963b90dc85f0a4b572221b4384d872ba42a85cf3f4afda8a12ad58366c674cf26b3d39ab29b557315a6"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_8(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "6b9ef81228eaed4e83874f3e0a77601a640b62e9893e5985"),
		nonce:           decodeHexString(c, "5b895c59177332a152203c51"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "addfd3f666e9a55731b7b7657f9fb140f1b87ba509a4cb6e1d67bd5ebee7c91e045551ee10ea346752bfd4ed598b476ad842beaab8c4d5713433689229c183f6e3779b1bc0f03bf1cdb0d5ba9601caf12525b63f2c71aaa46d98910d20c40fe246f4733d8e380ed2b7bde5577e053c04"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_9(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c53db93a94584242255e96b86198688aed0c6412df909d7a"),
		nonce:           decodeHexString(c, "ff540600f108783e8b0a1090"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f47462b296c558efdc0e06d2f4a4e389ce6e0a8d5b18ecdadf7c903f8b33817a2b28638e4e1a6caab9ad9dbf6b5c78060852cf20ed4934bb1b9498be2738175b03ea8b360b030bcac5e7be9e2ff4906a100df7e145ef7d4b5214ee688dc94a8231a24e221832884985ed6d4bcbd2010a"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_10(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7f1f29c7e0d1c2696c3ef8dda22b3d85d3ac800ab3dcf2d2"),
		nonce:           decodeHexString(c, "10f84345eefb4de9437679ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d1fc4d2f9edf1af5ec6f46e6774695385bb124dca4df58dbd487fe043e4ee32d9fa0e4fbbbd48b1a2c7d5a40ad3d442f99b19e002bf41a9f2140a9b0960f4350ea4ee2e54d838dad4bdc9ba579b4d48b3476855df21fffa361b7e48bb3da4555e5cf3b013f0a9c2bf799cf9e37789df9"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_11(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7f11a3ea8986e157d398cf9d8821e58ec54b03c074a0d695"),
		nonce:           decodeHexString(c, "e1542d2f485d8d38ce6a0e26"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a1be459a9aec274670ec0551c8d7eb04a17e641209fa9ab023f4cb1e4e239d8b514fa624420ebbbf48ca41c6d185429fe8dafd2bc2188f8839248c0cb3c446961950ba19761083d7ff3dcdb64643568faa93b17501518fd3b28418c8cb12e758f87bfde156743e16c14dacb805274c69"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_12(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "382488fcb96104b16a3f5a022913d67a5e9292e42f983d03"),
		nonce:           decodeHexString(c, "e42e979ea87b26e284e02fa8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1524934e50ec2aa9fa500c942b6be91928e2b74816707f3b13922fe423a00b9f3f08af39afddc4166e43d8cfe67c21ebb81b9502ed635415601dd27b3c975105efd690e3700330803dfd6833e1e080c22f2fd49e63bcfaa75c55d00e5ca32d80f075de00bf475659064d96da16bf54ab"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_13(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "591bedd004dbd24dd8aedadf9e06ce459ae797c2c5ca1d58"),
		nonce:           decodeHexString(c, "1901a9199ca809fb79d003e9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "96fc7b246e91af2e3d53ee09661cec50462717ae0d46bb07419b3587e8966f36c49cdfb65a4b93c9272f992006d93428a48ac73806d848ee7869d06069f5039e0b4941c28f56610d727451475dc3ab8a8a997f65ab1092038e45e4e95c8ab434a2ddbf114805f889b788f43fa8365fd6"),
	})
}

func (s *drbgSuite) TestHMAC84_SHA512_224_14(c *C) {
	s.testHMAC84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "04c61e5cbd79804118267ee1c76db36b71b042bf60a1c891"),
		nonce:           decodeHexString(c, "b833be09092d4755ee6118f6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0c4663313750b12daaeee80cb28f097cbe6f50df2022f9ff02a51fb373da42411c5856a136e9645e99e69aee273726d146e3ef4e546273eeca52b43c068887148b7197143f5b9a4c55d4b0544907ee9ad2f181d1b37742d1479d39e78e47505603550d2b28bc1d151a50bbac140988ec"),
	})
}

func (s *drbgSuite) testHMAC86_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC86_SHA512_224_0(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "964605b6d66e9a5292d9d31525bebf746e4389a2ddc7896f"),
		nonce:           decodeHexString(c, "bdf90e33bcf73335ffd5b6c1"),
		personalization: decodeHexString(c, "edcbfc33b078bfe6b4176e5be38218d55ce79f2a66116a5c"),
		expected:        decodeHexString(c, "54c7c78469d75c95ac0745d19e9c119a227adac9654beecf7bd9e450e99a2f18cbce799aa3191750ef33f3374fe55acc8a3f6dc0bb25fa2dec93d3567dbde2d7b97db688fcdb693d6737e5f5cf749b8e9be61061c2e568053b59d061f397325262f67f2226f020a2efbf7a35f0b7ab67"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_1(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0258db537a8e9c1d23bd71b29bcc1a613c5e9c709cc2ecbf"),
		nonce:           decodeHexString(c, "0b465ca6fb62ea62929ea550"),
		personalization: decodeHexString(c, "fc4666d977ee84a698a3d9d0218d67d1f8a383582dfe34be"),
		expected:        decodeHexString(c, "85501828b47fa6214fbecb914c95a8a0d66c1c934bda76a1bad03c87cd3e2205e5989257eebe32892dffbc1ba5ea3fa59cf06ab0fbc30b0b16265e68bd726cc03f4539227ff2ed3cde6c4b0f922176f05ac4fc2135814f9c72fdf1074793503e276b6d724fb4a9a2317dcaa1d90cc111"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_2(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7e52360fcb0515224dfa9667da4f81a0f1e0939d6600195a"),
		nonce:           decodeHexString(c, "6b4dcd641c9e0222a198d0dc"),
		personalization: decodeHexString(c, "6c6924fdbbee036fc28e0a81e85e40553067eadb80ef0125"),
		expected:        decodeHexString(c, "e6edf2d7bd306163075fa29dcd4febafb5444a491de16fd48bcb41b5145825a3028a0be45fac95dd22f6ad54472115aa6956855b6ff451fa0ef1c772f8e6781d888b02e6d40250bc2ff3fe2441c69f60387e8830f74ac49ba5dda06719983b34d7455827e30093268422670f23722fba"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_3(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1c3a96b0e8678021629a617f91f72799226bc752ce3d1ed6"),
		nonce:           decodeHexString(c, "33b0ae9c091a4071539709f3"),
		personalization: decodeHexString(c, "4de61783ce5ec63f8463e0060090bc344d7f8a67e4bd1bf1"),
		expected:        decodeHexString(c, "3985215aa5ac4626d4b0e6810b018bc3499844a257a51e2eb9a1ff14df93bf1966ad825f11d088163703819cf3a60faf7ca2b82309cb879206571e2606e26828a054bbf6cf0591b7461d167b6db830a3fca4438c2b4bdf3eb9e4a6dce82128c5248b0172b22b1db4b002dc54414c267c"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_4(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "94dd060cf231cc665c6da4c9e2567631561098def0e1feae"),
		nonce:           decodeHexString(c, "0367559d20ae369046031853"),
		personalization: decodeHexString(c, "46e690d7bab0331edeec345b74d7df0a44368d066d71afc1"),
		expected:        decodeHexString(c, "a0454c64d8705e792dfbbedd8767a647846e269715813750f3843d8ed4339c7e12b6477340bfac2cb6473d0dd0b6042d9ef4d4c93c53f8901af5888f703a8522f944ebedbf4f84b3a3ad8edd1ff4b764c287cebb20b77d989d8cfe4abba7446604dd6393b6c89926b6ffda462610522f"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_5(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3ea5b0eaf326fa080ddbea65729b06494bd066d6a47287f2"),
		nonce:           decodeHexString(c, "03d01cca4eb32fe2e439d472"),
		personalization: decodeHexString(c, "93df3bec33d9b3ad7cd52a3055731fc0dc28941582fb8acc"),
		expected:        decodeHexString(c, "6a1fdee1c3ba9ddb5969e01e601eb752c26b586e10e58b6edabc70af65870b203db1e8d1de547d9cd42c6d7b5b202adade23d65ba2b9abfc7406d11a7fcfd1a157ca7f50aec50c729f44b9d8e13ffc86ba7c34d9d769d9ad1e2794d100ccb2b413f7daa3a462c5dca629afc3e1988263"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_6(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "69b194b5b6ccd5718f3b86eecb545cec907b2e6127ae9fcd"),
		nonce:           decodeHexString(c, "d7a3946a8e18be90b16d71e4"),
		personalization: decodeHexString(c, "187369638adaecef00ee0b98f22616ab0d16c0d4585984ba"),
		expected:        decodeHexString(c, "38bbc7f20deb9e7511eb0935c4d05520f86e51f36d1fac7207f2fa46f446296e3f88d327d04f1d8773bdeb41208d64debc2fa22a5def63cf3ad9cf43afb6c56f6aece59bbc06b2bf9381dc98e323fbddaf92e98dd34771f153e69830e56cf031cfb12124df669c50a0c16091db2a25a5"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_7(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "070481a6cc60841845d8ea7a1f2bfe6a739809f51d81f723"),
		nonce:           decodeHexString(c, "20076e507774e4389c938c0f"),
		personalization: decodeHexString(c, "8585a41496f00e4636a9f749701b8e4eddda2a2788697a33"),
		expected:        decodeHexString(c, "3f696485a1527a0451862cf583967ab643805532d177953353f45735abe53cb4949f4a5ed7a5a16615edd787b91a58fdd62601126588d7eea751f7d4e1c68e60accc8111f1b32122be63b546ffffed4e78c8fdde3e1e7a9de80a87f2c448d0b2f1f2279eda99dc805b4a90551dd11a4a"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_8(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0987377b837d2d1974ed89353eaac47b1203820a44bbb47f"),
		nonce:           decodeHexString(c, "1248a40c04dc13c12c4d2820"),
		personalization: decodeHexString(c, "f3b51dca8e1f71495e889f31267e0002f9ae2795f7a088e8"),
		expected:        decodeHexString(c, "f5c9f13647415e38dbcf51d9fa59fa255772d7491a25e1ba9fb28e371f7e342a93f9165732a0018daa391e572d997bbe182a7a5dbf14182aea5e00ff461f91af73b7d9bfcc0090618e874169e0933f4761d1645f23624535d5bc6acb290ed75be21fca0840c7011ce482e7471cd3ff8f"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_9(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "ed5dbe15d70905fbebfddc983222354a56deee50bcc7ed9f"),
		nonce:           decodeHexString(c, "1b0c08e6b9cbfe408288be42"),
		personalization: decodeHexString(c, "a9850055c33bbb3171eb5191363d586a0feafa3b7725e15d"),
		expected:        decodeHexString(c, "a9bd2a135e13f46ee4bbd1361186c9111170dec4204f74119fe0754cc94796f417448b7814e6a651dfe89417e5ea4072f6a68f90fae052fcd2de131392dbd8df1c18e33fe02f860ab4676afbc946a7bab81707ef91455430952a888ce036561768ace89a4c4dbae3f3ea3705f25a4e3c"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_10(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e0affd64dbb37e7e3a8d497b4e2165f192736b6bce012d04"),
		nonce:           decodeHexString(c, "0e3acd9ac2002c119b40c0ba"),
		personalization: decodeHexString(c, "abc6d1563a710446da2dc79010c19382e9b53d146bee5f69"),
		expected:        decodeHexString(c, "0fd5021b2aa099973f5ca8cb457b6cd43e95ef033c6f32d1bdff2a4e74b09cca325a464613d15155b52ade80beb1932afaf1a70a0346317bf8d6b6304fc25149c9829605d6f8aef9af3e0e59d5d91d05a77e135f5a101698222456a91b6812976b1553e54c7b8e8fe55627f881b4bc96"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_11(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "83ba814f77180faf0c62e7ade044528360406d501428f160"),
		nonce:           decodeHexString(c, "ed146ddaaef8f87227d0a031"),
		personalization: decodeHexString(c, "dfb64abee8c98592f4697c521d91fad6dc563ddbff54792d"),
		expected:        decodeHexString(c, "9302d1859f659cb3da6a77954bf767697ea30547c815f92afae27679a7b3828c04341f6f5d8076c935516eaf6fb180ffc5cd24a3a1c18ef0af604fd60c21c585a2ab6b8e309ca8796344018b8fad59c10acca5c8077165d7b42bd23e51bbe9fd5bb02bd7f1e56fa462122964cd504173"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_12(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1c0b42ac60d38a2f1f5341f7f3c1bfb1012baee20b48c354"),
		nonce:           decodeHexString(c, "e3b6b51e2b2aaddc1fce75af"),
		personalization: decodeHexString(c, "5874d0e0629018ee07aecff06bc0ff40c8af290ed80a9675"),
		expected:        decodeHexString(c, "a778bf7bfbc3aad8bab72cf82a389c60310a105357b522b6961665b262145b4e2dcb436fe4d796cea8b76885a18b9b33e1b8b513758c6d26dc8660d780ccc01c7e52f12255df50b2fad5711324d963b5238d98d4294f32212cc0f809c4455e007a6aef445c1503d1ff364d726c04dd0b"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_13(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "523ff413f291ff6bb96de180b81f4eb9c0a01e791663d80d"),
		nonce:           decodeHexString(c, "5180eedae67148170d37a105"),
		personalization: decodeHexString(c, "7847e7a278f2f19986c00c7d26b7331c6e0a600218b67bca"),
		expected:        decodeHexString(c, "b7ab143c7d7a34c86c9da733addf6033ac582c74596eba1e5d30ac1a77f90e7dc7938a99f717afc877eb7abe6723b7b5821292a9013c6e06814cdbca2d0a1fa73c927b9f74abcd3b7227552e82eacbb2682f6c755a97bfdce54a24e97ea8f7a35b0610c1cb87059ff2d65f16dd8563ab"),
	})
}

func (s *drbgSuite) TestHMAC86_SHA512_224_14(c *C) {
	s.testHMAC86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "454adb53a146aa9808331cb86e8c0d94495f4c0b4fe5c716"),
		nonce:           decodeHexString(c, "4b729a67449bb5675a1f9d1f"),
		personalization: decodeHexString(c, "9160b7c96fd367dd7d378e82be11ad1827c7661d76bc1fb4"),
		expected:        decodeHexString(c, "1d7ab4500d99a18b8be2ffb8177c869059e25f1ffbddb36694fa8561da1d71f86a38accb1926339f6dff71ea8ed104c3518e62b00e520c51a096c1c62469e56b139e6384e982588e748a8074dccc51d558d944868e2b8e1dbd68bd83c663447590430ebe15c64aba4669d1a4a784d8c5"),
	})
}

func (s *drbgSuite) testHMAC88_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC88_SHA512_224_0(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f34daf1a83be8c66db78a1771484682b2a2c1a85e8432ca0"),
		nonce:           decodeHexString(c, "264f964fafffd3e9b525c43d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d93a091f24b41ab722834c6e03f33acf5f5d6c9f9b2a9f4c16da15fd25c82f0ebde303ed57dc58b84b0c0686322f474d5843da8f6f70c20905babc28e57e99b71dccda26f7b037e40874d995a284a98dca1ccec7a42487f429b22b14fa25ad32e370137e1091be2823af1a9d354d848b"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_1(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "abd1f62b43c2b148d0119136785c1a049a88bfc8d2a97ecc"),
		nonce:           decodeHexString(c, "8b63f7a40384fddd5d34f602"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "358b7a12b1f24bed4bf127d7506b7280b7575c3c15abb52a54ee45caea8331033fec9e4533a28f0b02aacd19977a0486197f7679065e1ee7746d150bcbd52495a7d9eca7fec9bb3222555b81bbc4be9efb852e6c12297390a1eb2afe967c202599d41b447bbe62e762f567b62ba6572a"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_2(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3e6363995147f6e32565a406b066c60f1d2b0d4530b7b49d"),
		nonce:           decodeHexString(c, "a01827f1f2ddf5eb2ed15718"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fc53f4beda45aba7bb67a576116f3d6cbe9e276b5c4d2c469a817affb34f913414cc1e03cd64f16c2075e6a17e4a4a44e9ce0d9902ae81303e243301a91ecd3ca1b74a4b655688e300b746d28909f5974cbdab82fb89cbce2383d730a8d81c32b15cedaf89447705faaa9b8708bf4786"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_3(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5e1744a97efb29557d273002e81056fd8d754f4a7c3660f9"),
		nonce:           decodeHexString(c, "c0dc51d382eb857f3fc0811b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0a0e20eace858a98bf9f4baeb1138ee8130d4b6101da0dbc12e984a1cfdcaed21ff0c9bdac3691cfbae4b6e2de6d2c1d256ca37682515b63e4c62ce2dcd99e431c0b5c867010c6c505941cd08be8cb7aec27e35cc8d84da00f8cb0d2d24662ed2717aac9566be8b26548a619b454317d"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_4(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dbbc8cbf7e897db6ff62a6c64e023f0927ef5dff4bc3b8fd"),
		nonce:           decodeHexString(c, "0e7b9ba5b8a36b01b1c560d9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fea381e30f28f97d3d16e9796fd43f72b1a87acb6d02eeb960bd39bbe79e3bc98933ea2b149661ba9493ab1a2aa22bd8bf75011d83740573f5af1fc92e5eef36e93ed07291acf7258d94e35943f599c3aaeddd3588743671aa50b902030516e6b9038702ab54062db6378d79558fcaa3"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_5(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c9fbdf0830e7ad307fa89df168f23c3a95a8a1e3b5bad17e"),
		nonce:           decodeHexString(c, "76cc2507ffa3428a0088a9d8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e0daf2da44c336a28f1612967549202425eb9d30dc34add82953fdea7b05c0461fff620edcffb57173cc13d266e76092eae7a2aab5a4bd6ec94c6c12c0e2af6ecaa4c074fad05531328d6314378d73e1bedf2fe41dd1d98a0df0d01c1201ad5a5ace9be833782f9d67c43a3783e3b98a"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_6(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d47012dbfb4c45cfc21bfbed79b5917a298ee998585b0675"),
		nonce:           decodeHexString(c, "083068b359b0568db28dd99a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ebacd13148c69c7e42cadbfce6110dabecc4c4087dc025c92b33f1a5ff829915984b9d378421c5aa87add7dafc326e930aad3f094967ec9a031d3db47817ef4498c68de615ee0023989690de975e9cb703479667914637e8337093d4a0fd0e70bb0f7a983d2e57a3060298cf563fb661"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_7(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3054b8a17e7949165920f40fce3458d329ba2f9a49aca375"),
		nonce:           decodeHexString(c, "f4029752726c79d51deaf5e7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "99aa6414d7e91bc8e6ec4dbeaf741eb9177ab4018af383e0d96e738dcc79ca83c4559d51194fd226af1f63a498d3ce1cc41074eaca6d2f2cdce4126ac674d3ffc1e7451dc1dd51145b04cf888e3643a0aa90bcb2b75d4e2ba36994b1cf2850cdfa89c045bc1c7e883a80b749e152ac77"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_8(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c3b37b4b1ce7c944bd5637010f959d1fdadedc644dc34c32"),
		nonce:           decodeHexString(c, "9a538928aab74e7cbe4bd6e9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bab320c1755cd8f47314d0d2aad63c02641bc6b72f45f4d02091a4ce8e7cf0752a830065937a78604d9fdf2a0b9704d183cc49dfb46bd8c3e6c965de2876ff096d4d4c80c791e7fa65f6c4125fb38fb3f2ef92cab84967286b50288e0663de1e1c100e536ef9df21d2ff3e47246d527d"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_9(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "413af08b97b5495aa62337b8109b6e1fdeeab59177d42b67"),
		nonce:           decodeHexString(c, "c6ee4d3e71c0028f07742fc3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4c8f6be540ea40de222cfde738091c3b3fe729b6655bd9a429c8e5563e68d1ddfa74222b73af3308ed0200594183812deebcb4f2d378b09ba83f9ec048db66dde72b2919e74c1440df1be32d52ff9bdf3220d5251e30144e62e0e159d4110f46314611acb9f1ac9e4eeb2c2aa9e3752e"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_10(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e99ac5c23a0dd8a908fb1b6f17a419b6420db16fcde8eb79"),
		nonce:           decodeHexString(c, "60d304ecc143c1f6f96446c5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f1795784ee4b5f4adff32c7fe096c06a6aef21b34bbe37b13f9e65ace09ac02bb5f1c66468b24dc3a982800c892a1fd4290da6106c0600f38ff86b56c03c618555025bf878a5e4eec1a917fcad02d2792ebb6be145f7be473dae3c474f65534903120d67192613fc6478aa19a5c1f97e"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_11(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "ccfa4192729261c658f0aba93fc082d26c749246329fd7da"),
		nonce:           decodeHexString(c, "95caa0b8fe92a179963cb10c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d75fdde8c95fa7190a8ea4c99fa20a9d821427e793cb36dc473409d88658d411fce08f7d51f2f20c9bd007867d7f9d83d990f649e14f127800b6d4a486d652f1f289d30cb4dd792a468b2426d232330349e80225445dd03d5af8f3bc7d15e8a15f640461b2d27d021770af134226a657"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_12(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b4aead96654b757651ae06d08d5bb6589182549f67a1c215"),
		nonce:           decodeHexString(c, "38e1494f9bdf69d8dcfb8776"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1106e5764c291c0e96497e34617e78f638db0bfb5e7f178afb0b8e8b9c9fbfd75b1e7a078b6fcc5f1116af05e957645dbed437753bb88e0669360edbec79980263c506494774e52ec1cc8d67baffff5bc9d7f5ea8188f920ad96139e0c972e88b96010728be9d19d00d797fdc433bff7"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_13(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2f74593b03781fd063eef41aaf7bef35d202706ad25a1da0"),
		nonce:           decodeHexString(c, "afc3222e368a6c23fc23236e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2e7f69773be1e8ddecf37e6534042feac5cd50a3550750819604a1cf3972147ac28098450df577e6b776be072a58f75ce2dd88888f39b94d0d4b39691f4db783b7e1084af8b95239bbb4fdde63648e27c8b4c3bc322782233e2306f174cb37da630eabe55ca092ac534c91026f28cad5"),
	})
}

func (s *drbgSuite) TestHMAC88_SHA512_224_14(c *C) {
	s.testHMAC88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b37ca70fd13538ef74c5a3c7ef00a78705919446954ec43f"),
		nonce:           decodeHexString(c, "3ecbdff8cf33b50788dba82f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1bcbccc535fbdc8617575d46ea5a9cef2622995dee19aa4b998325dd8d0935957170f6b18219354cd2759ba53c9c1f380586070db0c89979a581ce1e00ce38855e123dc3a2dc9ce74bc3b6e27c9603fb87c09a1d90bb540d267d456f5457daf0920a13119a2b805f9b97b154f80f4bbf"),
	})
}

func (s *drbgSuite) testHMAC90_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC90_SHA512_224_0(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e3303a4ae7679c7b2e1b11a6cc53ec57da6320feab0a8574"),
		nonce:           decodeHexString(c, "23694cd207d292a0e2117d1a"),
		personalization: decodeHexString(c, "cc6815b0a2a72096228bcad19b160a094f38079c33843408"),
		expected:        decodeHexString(c, "a55de90e2072d5e33235270532805a32f7907a9f1e7909821e38457d4df4390320485df395d0b4ac7419ea76e83298751029185b29141e46436ff62e99100b48ccb7435ae39a2efacd728e30bc53ea13dbad1c2a7bf64888a5a5c27f5ba1967565a1eedb3f6f4c22b0d0bc26b6b39576"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_1(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4f5a764f19f875a1318198bb8b349a30c08553b899eaaec0"),
		nonce:           decodeHexString(c, "45a0f4f8aede6e5a1f41c81f"),
		personalization: decodeHexString(c, "56ca0141d40f38214bf5df497051111586a8f17a55adfeaf"),
		expected:        decodeHexString(c, "f62df5d4b080486fb75d4650294daeeaa43b48e08eef1cbd84c8eb8e1e91fd14a3f7015fae775b029cffeaa61d6fbfc23540886948549e47290f2ec83808adb5aab8d1a6188d478478e782988c4ff005ff4b14998aa86f2740408799550687c8f1752c98b556c65349deea6f1d803e9d"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_2(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4c909fddc98bb2dfae170a0aa0782fa172972b6ea85b7bb7"),
		nonce:           decodeHexString(c, "e22e1471e95de620ef6cd726"),
		personalization: decodeHexString(c, "91862754f5827026f2b06dde98f78b98a1482ae85e3f6f74"),
		expected:        decodeHexString(c, "169d1dc8766ab63d65b59e999daaa8487e961a1d28974c7cb361c93f828d20dc11a64d7d144a310a7244add3ba2a4a12dc92811efc35c8586e7dba7a5d01ccea640e9851092f1a5fef963eb5729fa93cb27970df0ca196034a9aa3888181b229f5ea265c850f082839cceb924ad2c099"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_3(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c9715b284991515bc3012c55f5b4733d80ed0ab0377e1e23"),
		nonce:           decodeHexString(c, "c662f939921a00ccfbd60e43"),
		personalization: decodeHexString(c, "ae3969bd37f76b5e4b1826d108f71288315c91176727c6a1"),
		expected:        decodeHexString(c, "951aed814cb927e4d7927d8e927f63a6c8ce9e11192a7bd28c8d54cd0b1cbbf57d3211ca349724f2600a11be482c87cd870953249926ab0f124b6ffa0addef4f1146d47b56968ec4b04661261abf97b412ccfd4329508e906c512b1485396a976bc103b769dcfee6d4640ecbcfdfeb31"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_4(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d25a87f9e2be0d53143ff7df4862804d17dab2dd8cb1f124"),
		nonce:           decodeHexString(c, "c46dab3fa9ba41e5be509ad4"),
		personalization: decodeHexString(c, "3177026124d54b96aca5f126c49cebe2410f7a5a3bf9be36"),
		expected:        decodeHexString(c, "231b1d2b3179d2173d2691300367393c40cc251027d1c08cd808fa6c735b27af004b19d9e520589a5b3dca9b482721916ce24b5252af6d4e4381d9bb74c189618753adb7fcf62881addb36addbf9b5cfa8d1fe6dca27e8526bbe35aaefac2b9f1a01bc8800b2631b63823d02af1ab85d"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_5(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "281600a07e9c2c4e12c50b245ce68f60eb8724a0fdf8ef0c"),
		nonce:           decodeHexString(c, "2009644fda9876d69dcf8515"),
		personalization: decodeHexString(c, "2a2ea4b3974f2199e91d640cd02211c2abfdb0a475aca283"),
		expected:        decodeHexString(c, "fc950fc6f1e2daf6710f334d6cf6685506a80170f78648aef58a86961466cfc19bb686e26d8b4441459d3ffa6afed7d4cbf657cdb2da1a76df1fde3b1246dcc49f83897f16f8a58eefde54556953ce1ff032f048d7fab9c2764c56a5636c97f714c1dcacbf6b922268e173a7a2585906"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_6(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7ae676a4b451734da237d335b62fc5be34ba4ab7a30602a7"),
		nonce:           decodeHexString(c, "1eb6319e8e94d08853f918fc"),
		personalization: decodeHexString(c, "6d1236fad9a2d0de231a41e6bbe378a8dfac61edbd419457"),
		expected:        decodeHexString(c, "b784dbdae689a78c95ffafa2e711f7402013012249f1807a931131a09ccbe070971e36c9221de28fb86784f9552b619ab99272b73227ef3707dbf3c54c91b3ef7669a8e3417ea498c066b4ff1643e2bdb3155a33afa2bc849c179fbf94da4df319a4cb07461c1725d38b6f1860aabc89"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_7(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b1f256a885b84dc228ae9aec33937e6f368b318422dff436"),
		nonce:           decodeHexString(c, "9eba9038aa20761962600868"),
		personalization: decodeHexString(c, "0dde17a7bf2ee703801319babd44882394b5ff239928ff37"),
		expected:        decodeHexString(c, "353d850d24acc856d403ff3b2b7d28537ccca984df0bc6cf76ac4f429998f5d9083ad9eb3f571eb420580b97b152a2027b97e520090eaec8726b587dd14bcfa29a216c3432ac8911c8e9dba88b2a625244e6af66790c483bcc86999a06034a671f65d229a630fc88733e66247449b0cb"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_8(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5f341c5dff9f4e360c0863fcf17f152ccbb88139cae66bc6"),
		nonce:           decodeHexString(c, "8b00a1baa5b8cc65ad9c9971"),
		personalization: decodeHexString(c, "fdfadee79f09cd11763e0d37774dc8a741cf50efdf63e481"),
		expected:        decodeHexString(c, "e109796934a01dc76886e6ea067760028899a201194673a42b4396e27c8550bff9959d3b68e5c43f70a23dada1b55589d9eb487f8034891b28c915f57f9717fdedbe2711a73aad2336ec9d213f3d5451119f70e0ef4f943dd156dd4f1059f917570343f2df84e9d5880c8d4088658e0d"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_9(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3175c146dcc471af61dc0332ba34bb423c5fbfcb7d5493af"),
		nonce:           decodeHexString(c, "a4e244f41aa276be01336b54"),
		personalization: decodeHexString(c, "b75abe441053dc92d9f2af0762cd07ac7b3f64209d45977f"),
		expected:        decodeHexString(c, "b8d12b6fcf72b2822afc28a6e6ddc5282f882a2c91fd3d1459dd5644c35de19a864898bd5cf425f809123f1fe74f622100463e9a73304afdf91b38b0d84c4bbf743c68ce58bb5ef4484b3942ca27953441138366a851d6ac2c97b58020cdaad931d2b66b64eb054140b2beb8b60aa502"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_10(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7b6e8cb381d57c2cbb817fb717c430e0c0ec4c4223bd4978"),
		nonce:           decodeHexString(c, "82a7d811338ce2f1e55765cd"),
		personalization: decodeHexString(c, "6d818e590a7892ad20320a8da5986fad0d6dfd2639c18d27"),
		expected:        decodeHexString(c, "5b4de2b9a7cc34469b68f110c49a5c86134a25413e192fa0d3d6149c4ab2e257a081477e3a9d0c504db745183fbe21c9d204f3ff2f5d30f666a575d3c14563a449f70722a9002f8e14d15ef750fd8560d48990e9f650b15795535ea430a33d7c2c3f8ccbf4ae2e6496cf45d61c841440"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_11(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e56b1663085d4409a5c6b7ba1b9be6008a785b2ee8d35d0d"),
		nonce:           decodeHexString(c, "70fbe48f4878432a6885c39a"),
		personalization: decodeHexString(c, "8e8a4f95f6d590ab664fc95b962ff9de01d0e962355869a1"),
		expected:        decodeHexString(c, "7d96b91fc1b62ae0705261822116461a359417ac266e8fed4786748a0e7b6d662786a86c59c538f38c7a72349a5592d29cc726e843f9cf5df0c75a09f99fe314ded0431abb2a6e0c41c50b7fdc4a3c8e464c936c1fca40f76cbf52755082c19c58eb8d0055350c9bd7cc12e425c40a4c"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_12(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "02ba1c8b09584647170c5eb8f1d873c1051432b5a5b3fb70"),
		nonce:           decodeHexString(c, "b80b42d3ea625b78e58dc502"),
		personalization: decodeHexString(c, "919476db346ffdbe0fabbca46cbeef65866816c7add8b57d"),
		expected:        decodeHexString(c, "941d6f2a3187ee3a031a9033e6182655b49df4cebb26697611a551f785758ccf0206e89ed2fec100de0955e7f2995672f047e54c89f23054c96a8ee7eacd6085dae74a2928f4a180cbe08fdf10309da2ce3243ded1c3e02ce06d9c07cef5683305f1945df63e378e1bfd4d665b2d3d9c"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_13(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b1769e3445ac80870d8bc0fa973bcc1bdad10d6ddc79599e"),
		nonce:           decodeHexString(c, "c4bf61831c5c2ebace04846a"),
		personalization: decodeHexString(c, "ccf622319d28d73a9bd96f5e475bd113e3e2fe08a0c91125"),
		expected:        decodeHexString(c, "2e87b375d519248457e0a13fb76765d7690835db7b54e794976df1d448a0050e77cbf6119f393d2f30e9f6b308196874d9123de6b6a5884668518b8014d28aa08095de75bba6d905c0ebc909735871afbb1ff616cd8de9e2741210cbf9e49928332f0c508006b01cc8a0efe453714591"),
	})
}

func (s *drbgSuite) TestHMAC90_SHA512_224_14(c *C) {
	s.testHMAC90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "20f5f4e9177f3aea0ed784f29e6ad3d98b7ec22bd6813386"),
		nonce:           decodeHexString(c, "98ec3ae036755323042c08da"),
		personalization: decodeHexString(c, "e6f24d96c8d11cc68e72f56ee7e345c5a0083509821fdf17"),
		expected:        decodeHexString(c, "f5a9d375a58d1b337d245d29b7a9e352cbb0fc950276e042d075a71f4bc43b65b063bff299c670adfc46db39c4303adbbfebcea1df964c27d33cbfe4d46567475abff4f357252ff7d05ed4ac34e6ed14c33c192909426654d604736f3bb0ba01aa5e0454d60dfe8aa5b2df3a52df22d4"),
	})
}

func (s *drbgSuite) testHMAC92_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC92_SHA512_224_0(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c4fb3cc673584f65aab31e16454639870855f1214eed7389"),
		nonce:           decodeHexString(c, "6118e3772d3661abd2a4d253"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e76605f95067db702989804341c5d89b596a938da1dde2e95b704e5d52856106ad9c9dd40c3cb2a0a146007bbbeb33c6ce6a73247179246c2c62e4eb94047f19be976badd1fa2ba3fa2ba8e8390071dd745c384005de7d4add40e86d9814ff338963f99c04e2b8049d6eff177762ea15"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_1(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a1c83f9dce3f598779cfaee5b35b44a186b0400d69ef65ce"),
		nonce:           decodeHexString(c, "873687888999958af6c43026"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "267acc1abf128cf3e6000a5663a2c8c391e0048091a0ba3bf8a7fc26bd0567ef8017404939041ba15a02fcce30643351d86c59e4841e0e37ff1747a555d74b61ca2ddb06c502aad9d894a2b1d3d538294d7c3cd30885418d8657010ec1311e2d1d81fe00482620cac965989ac4ff81da"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_2(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8b237ceffa56cece738386c02ebb18564e6d8f8d95933694"),
		nonce:           decodeHexString(c, "295515a03cbc5549328d1402"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e4571e6875291e55dd133d815f8f79c2f16787c90452978144ad7f1c86f4f626a42c661dd8dd3f89c56f01638d13f08fc12c05a934f518f5ec8067b81f6541a1744e653a903275345c932b7f75c87e28eb27f0efd4424bc73ff099cd69ed1d19bfceab1a00de7551cbc0a17b28e94e91"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_3(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7108dd77febcf9c9622ce18d0e55eb133185d01d0eadaa46"),
		nonce:           decodeHexString(c, "9d91b9c79cfd327ffddaf258"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b9492242ccb9de427f72fc0f335c8b6ab4923f77a1d6b77c66c9160bd50c79ef52338f35b526da4d5cf57391976161c2501294fff25dd539020fee8109e1841b28697237adaae555db963a36b7e5b1becd3c0e477ab8adf0ca27f6560b1e21a4005322c800c03ac12b0a0f9e32044e94"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_4(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "35a71f1f1477262fbdeef3c6519b4c8cafeced619247f0e0"),
		nonce:           decodeHexString(c, "131c28c430e082e247fbcc33"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b75094b8c9cebb7c162155287b2d8154833ad04c657eb1afb3f25ae88a0445bf549b4c4e211cd4390c9bc5612f88fa5825907a93aa0042bcef14b5a5c1930bc97f1f6bae6943eada1f0a70c5d4f20a2ed62fa11cbe48f46f267dbfda6d9617518dc0d386fe25f1f706778e7d9eedb349"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_5(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "6fa7529f51970267e12691bc61d751ffba248097523b6307"),
		nonce:           decodeHexString(c, "c3daff5b85a277b8cb6602b4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "00af923a2a59b73aa75bd60ea15b5c442b781514e18b9013e38424a2317b730deecce9e78181fa1452c6dbf2e22c76f17ae1525bf97ed277b1837f9aeefde422185eb6ca4b56e4b0bd3ab4dd45e77376af2058f99e863c92532dbae96d35039b9d6c530843d1df37361ea0fd039f0a71"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_6(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7fe4876c24e1984d3cef2d39363cdbbf3d62314afd38d15b"),
		nonce:           decodeHexString(c, "1c7aa72ba39c93dda32e8216"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "55350dd355aebb35cda8277553fdca6899db0db798fe65192e496efc7ad7c4d12f50987b505e7857d39ceaec843f6ffb6df5036b9f9440003d1ff3cab3aef5808a99fe59eeed048eba61d0f7add2986167edfe7dd77b5dc0151b57338673f3120cf051e7daccee9780cedeca18c71c5a"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_7(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1ab7a896159cde0950808fa4634e047c8ea3b21cd65385b9"),
		nonce:           decodeHexString(c, "7c5dca71d1e6d7db475a0eb6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e255fb01e7810ced3be9ea0410b85a576171ecff2ba6e42b48bd95fc7199be084500ab32db29ca0df32d47a0d9cb31ebe33f0c0cbd9d3fc88a6ec455b601e0317ff4654a0826cf76a8ae1f82037f0c3a9a0711ac8ade55a5dbc8ad5c291f6a4a2d413f7178cd5e5b1e20a6e055ce6916"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_8(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e5e0eeda6c10d7399d4373cc1763fe7497a6dcefdef3117c"),
		nonce:           decodeHexString(c, "f834f84ae5c5f575c9051b19"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6a5c5e29af39950a974779f9aa12b22b7f4508d81d6af68d96f7766e1ddcbdb6a8e49407148f7b4ea0e536db358654b4e6697d6857eb1efa611731612dad3e69774a5b9432afc8c666f495b104ce3e8bbfba5a58eb3ecf2a0837c533ebac232f7e14353c27147109becdd86f03ebed7d"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_9(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9e33d60882a7d76830d4e09bd3875a7c79a70dcba6809a0a"),
		nonce:           decodeHexString(c, "a42882e1bc97ae2cd31cd651"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "280573785ed687dbb9089b9dc400c943d3be6a1a9eb23a08030193e8435630c2cb580c79c103623aa8e21b1b88a658a7ce1e95fcd30c6a5551d46302c9424dba582ea57204f7e9d5e5ce28fc705b3e454f9b1c93acc47453f91c69c3d1f1dbf2e003c7b784164df89105248d39a9fa9d"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_10(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9f0463cdf0a570013618750020f3624150c7e450a72982fe"),
		nonce:           decodeHexString(c, "3ebe6ca51bc5917b8e813890"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d12634c4bdf03b793df7b5a958a7fddbfdfcc8014370c95197166582eeee86db1aa4c29ed27fb76136644192ed4bb95b8f45ac8c3cc0f5fdb1d2ef897e22effc320eeca1fe8fcb0d4f40505143222760bfebfa33eba2d1cc3b68715c25a2680a404200780fcf3637d7b0159c3f76673d"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_11(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "af16fec8eb451e1fe943ddd6b024f9b2c900da9a51a34cbd"),
		nonce:           decodeHexString(c, "d521f835d68b4e7935be1bdf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "56368c7a9f8ce117cc775cda0508117f0be43cfc2bbfe9b37237d8e9b4f430c7f1a589f4663a837525b514388388d93c37b2ecac465c958e0aa0404552ac5ef18b5e8eccbcda175347f05fd497b205eb3565a84cf8918532f0de2af9098d1f673472f98dae065fbc95755cfd7c463c5b"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_12(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e1cd2895c2bb7f08a17cf1ed43edf63a1079683dda7f1dc4"),
		nonce:           decodeHexString(c, "eca177fe86d8103f3ceb80fd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "52fe64e3a895c3e03c5a1c822f00412472ec8dd33587b986efb16351717792c5b9de7992dc53fb48ce19e8e46e95187fafa8eeff8e2b6b82382b5666e5fb10218c00f5fd154a7f15d589d24c932eb6d906ecffe51091101e609795a2945ceef68eab4de6f8e993adaa026a29e37dd07e"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_13(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "de09dbae1769318a11934f3a60e4585d6b4d3651a3fe9438"),
		nonce:           decodeHexString(c, "15bc228bb7450f10b4541fdc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1a9f338f8a8ecfa40b7dc768025516eb4fd067fe9a3d3169bf1a613c1c04e21f53bfb102069cc077b7fa88a3934d522e95c4999893e0b8df84367f2488d5d6d32bf2cb53c67d55875ba5c90a4faf62f6f6071367ae33d1ac856807cff9e58b2510d391f1686c1891a9013c4416cd61d9"),
	})
}

func (s *drbgSuite) TestHMAC92_SHA512_224_14(c *C) {
	s.testHMAC92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2fe6d7ec78f76820cd88c41a5a958c399c7ad1619406caca"),
		nonce:           decodeHexString(c, "1ed975755cad5e4c475c5945"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e34b31db083e58516cd60ead2e5b0d39e4a2bb47c2436531c0e700e484c27d3d233d10d1ea6c58148149751f24155fcd258f384d61000da88106a0205d693e4ddfbb5c35f101ff15e531e9ac4a988c16302a962146a3aba9af5c505697cf9aeb7bdb8c49c281458acc33ad4010122aa5"),
	})
}

func (s *drbgSuite) testHMAC94_SHA512_224(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHMAC94_SHA512_224_0(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "540474a887a098daac97c42f0818b64d40b8eb47149fccbd"),
		nonce:           decodeHexString(c, "eaafb1519bad0b672da5d22b"),
		personalization: decodeHexString(c, "8181206a69385a76953a51d7e5edff3157ef41fd08c41402"),
		expected:        decodeHexString(c, "e7103405a5564138ab0909761b6a06b7e083d294c495317c8145a58162d81d1d3a09b80a3be99da51855b87611384fd171e648380d02f23989db0ebb42d2968fefd7662eaea94077dc1778b867c69033d3ff83fba96b57f303fe68261f48301bc9a8f063254a185fec9a180e6bb5aaea"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_1(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bcaf9aea03649886a7e783417032bc48f0bc3c77a6c46124"),
		nonce:           decodeHexString(c, "6ca3fef89c7d9c299b493368"),
		personalization: decodeHexString(c, "9eee0eeead1781d38ee6783630d3e65d9db9d1c9ab731e71"),
		expected:        decodeHexString(c, "ad5d0a53acae54aab7432409ac7b46b1c54ba410ff60079dae18df059a644b0610cbc5bd37ee01ac4e40e16ff6972e3157f952784d98b50967c8ae75a36b85cc830f6fe856bcb0ed4baedf93e6b55fb68e3a1414532e4a7297ba7e3120d5365655653d79207eb76b459088b16b4f07c8"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_2(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4ee53b9b089cf133e5e162085d506716cf37a5f0aad13135"),
		nonce:           decodeHexString(c, "8e6f882967d17ac775e2326a"),
		personalization: decodeHexString(c, "805c3ee2d07d3826289cf5ce76a4f70573f13e1b1d5ed514"),
		expected:        decodeHexString(c, "bf21bd026307a1c2456029bad6a4b19fbf18337f3a6498d26379ac147c0a59b721e640b499da797062a309eadd378c922983a7ace3ceef05a86f882cb38ee714473f48c5088aa35c5db7fe7d30933aabe57ef2df9f94eda15772f3b28fe1dceb661e708d90e764d870865e65e747cd44"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_3(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "37488795638f53d944c091548b41ff84e1f59088658b57b5"),
		nonce:           decodeHexString(c, "992ff3c60155f91dc00909ca"),
		personalization: decodeHexString(c, "eb5cd8ccca404221791d4d9c3fa8d561c4b7b716f3e267e7"),
		expected:        decodeHexString(c, "8be432e37dbe2cf3fa18ee66e1fd5d065963e15330960c0f80cbd040bdd2178996ca946ebf9f84bf5373225022e789836b7a7a8acbae99bf689e1c73fc7f507822fcffb456c0bc9bf4f3167d8042e09266ef10e92dd522d0029fd642c65f300420c1f94e727f4a6bb1e2ec6ebe7e7822"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_4(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "37300fb491848475c02d54a5301ab519ee0a4f79f2f45f3c"),
		nonce:           decodeHexString(c, "81f001ca36ef52bd88d8e3bd"),
		personalization: decodeHexString(c, "0754e254e5cf74c59997909046293ce030bbe3bafe69c7c6"),
		expected:        decodeHexString(c, "00b002b819002e67e15667f067441e7b3f1a5504ae548be606e58c0ae30f1d26f71d81a0db5a25225b6036847d25af79939aea8c4f0bc3541b9ede8a0a5a9a3f45eaea96d88f6fdc7d395818225b60a3fcac49515a540fabac74cdf57c73bc59689d19d98a9f313e2581a784284894ce"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_5(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8f251f01405589464b7e05e73459fd3432e10a28335347e5"),
		nonce:           decodeHexString(c, "cc63c71fec0170aedf8d537c"),
		personalization: decodeHexString(c, "2116b9245c27ea748e2137a52334c918f36c1a64a6c7464f"),
		expected:        decodeHexString(c, "290e95a1278b4f7504dad0231e4733d736698f4222430682ca18ba0aff31073e53d51c70046f12b1b6a14d74247cf1e3aff2a0a1ced96bc1ebae92e4c09bd810e354ab268da3150c3bd6d9df62d5ea6cef9c49163766992b52b137c40946478290941e9238c7a2da1a0b00f4cc4cecec"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_6(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3613593f30ab411023c92b1a1790e07026632c1e00d70661"),
		nonce:           decodeHexString(c, "853d8aaeb7848393f43eb566"),
		personalization: decodeHexString(c, "17227dd8912f2506f849413c870519ae89245c426f2a2243"),
		expected:        decodeHexString(c, "450ea8ff0e69e88bd799f446c506d7157d92f0b62d12618089765eb35c45415c28c608342f0e3e6385afb9da049275da25ced9ee04508588461ec5f502625c2ecc5bf6b5c33e646ad4f6a6ca98774c23585216812229c069bc7e3eabf7584c4a8d50c4a1184d95f77a121f6c1b9cc175"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_7(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "762bbbdd8acfe5561274e27d2be46164863ffe556d37fd38"),
		nonce:           decodeHexString(c, "15c70ed7de9e2c385391f0e1"),
		personalization: decodeHexString(c, "cd60cd237f33e40b3b37062dfa56c1cfa90b21c549c48d79"),
		expected:        decodeHexString(c, "51c49e156d6fb62706c79a67b336a0c00aca33d390c483c46996057a9210e5c2b3bdb10c5fd08b1f4140c6eff0f0cca9617f1d3248370521576c51a5e2c30cab28b7e92e2c5758641ffc2a72efd065a57460a81e4dce6b47dc3b56482e024bfdda01c07d0aef4229c7b10247cf8b4ca1"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_8(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "20b5460e9de84c54c032a00281aae28244c00dad68090aec"),
		nonce:           decodeHexString(c, "1d4b21fee75f3fced9c0eaa6"),
		personalization: decodeHexString(c, "486c4f79ac8d0e50c606a4f918fa237dfadb748557d230db"),
		expected:        decodeHexString(c, "89e6e16d7a504bf60f8fcc96ff50e50fce259255d1b36293957a6a377c0dc949fa72d38ccfe19290827fb1dbc98527cdc1b1c75b5faa281a84497d871767e67e3f37396f7e50187cba2b4035bb9b9b4d8783bc4ec610f458ae88f37a40ba0f385569097eca4b40a0220f8a5f4b172c70"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_9(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "97e55216da9e733d2d305316f447c21ad0073979e9782818"),
		nonce:           decodeHexString(c, "f2ca8e35c362794c9746d415"),
		personalization: decodeHexString(c, "409eb3662ca4881d28eb316d8c278feb6281916c44eb3bdc"),
		expected:        decodeHexString(c, "aa85c42dbf91cf07b753eefe8ab560b9b0ff2d2c2b49a45eba03db5c7d562ac2c2db7daa54be6e75e87896677b9ebd9ff91ab035d865fb75aa6d418c098a9506fffc74fcdc5d2a74e7352df990ceb38eae5719837539c8a132f2c535cfa1bb69cd6d4eb6f40874397e1c8938f6fae444"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_10(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "28d50a878bcd630b30233ac8fab1fb97050809109ce9008c"),
		nonce:           decodeHexString(c, "224cd9fd557fb7bc5c804078"),
		personalization: decodeHexString(c, "4bc7107510317ab16ef3d2a640aff47875f95a92c2314aad"),
		expected:        decodeHexString(c, "23d37ed9f748e0b51c0613a3d2e4428ec8e8c06e551b029c43c8555a2720a89de0c3b533301e21dea1d6893eefe77466ccc518d1ce48690f8478a23ee4e1fc8486039d2752fcce5b9d6fdeec286c441f6b12d8f6a8d39154db12c71e38f463359f8db1c1e68a61fdc0ba0866aff438ee"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_11(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "59427cebd6bb51403dc4e3b98fb2d8161577b97df8da6cf3"),
		nonce:           decodeHexString(c, "0a0202a23a48f3a04b6869be"),
		personalization: decodeHexString(c, "80527604f7206108389b0d789c2268039932d53e09878902"),
		expected:        decodeHexString(c, "5cf701785ed71ef72e2575055dbf277c28ef352c74ad35952c4a1456943c0ff02a29d88c333da21186c0a96a4d96c8875b8249aecb5785ac1768eb1da0325563412bb7d8e2252de3fcf87100b3f5da9b4d6b369ca978944080911cb60066960036985e33cff514a30f2483f2cccdac15"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_12(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2bd867d7229b5a6acc918b27563cddcace362cbee8d7045c"),
		nonce:           decodeHexString(c, "2a6a7d5de86270d56d36f209"),
		personalization: decodeHexString(c, "9a002cb5218f84b74413a35df313344fa2961c59a76d0f33"),
		expected:        decodeHexString(c, "9f682ee53c84d4d4a49500fc42112173d0836cae6d7c89c8506ad77da295732d61dffed48c47be800399acc02c159c8979f37ab875442db6c983fe846da97c7ac9bf38b70f74d52c2efabc38728bdbb05df0f469ba933213e601d680efcfae6b397dd13e37d4d371cd05f850374d4e0c"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_13(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "02ae1981aca084a3634db99df57878d6d9d43f7d89658f67"),
		nonce:           decodeHexString(c, "dce7d387c7662b1f9d7575d3"),
		personalization: decodeHexString(c, "26975bcd40635e64f1d37495af4da7f3e4ea6b9374d59e09"),
		expected:        decodeHexString(c, "b08036bc931cdc272d4c4c66894203320e28aca6b5ae174b5b820832563c0be15c4d5e3468c3397b4f960d73e6f5a4166b5491cd9f431ed43fe2700380c6c848a84bd82ce69439dca77971fa402f7b720caea84f6b64eac5e7e744943eef6c421448867555a133849cd7edc7576e3b8a"),
	})
}

func (s *drbgSuite) TestHMAC94_SHA512_224_14(c *C) {
	s.testHMAC94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c3e01806777c3a435935e3a3b55110bc54a1fed09cad0e08"),
		nonce:           decodeHexString(c, "4fb71fac56d2aa35d7fa44d1"),
		personalization: decodeHexString(c, "ad66fd02b6f6e30ce521ae0d783236c75cd3699696475ac7"),
		expected:        decodeHexString(c, "4b2df98ad411407c1dff07b5c08e97ab501fc20ad191794dab73e9b4dce62470b3c70d75f07848f436f16a8c63ac31a75525bd928b5c76218099ec940e3ad193eecdbad834557e92602d7daa6e3eedcbccbc4d0829c8e1c7e59adb95ce928bb138870566eb27e4725191a9ebed50304c"),
	})
}

func (s *drbgSuite) testHMAC96_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC96_SHA512_256_0(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5b3f146867c87388fe04fc3d24f35626faf66baf9d8c5d0facb2aaee8bb4e466"),
		nonce:           decodeHexString(c, "175857ea77de3cf4113001a1aad3dc23"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a78701c0446bf9cc04f34719e6b4a269367e250b5747b241c5ac3b70e946b918f4d9f700c9a975eb0b5ab4f72a479c8ff6098e346e9fe4b5926a41982fe1b80bd49961ef154851b49c6abe7454b0b9ee27a32c460768008922daadc9e06553cfdda852dca6565b18f5ea9a98b96dc411b2a949c61b2114dbb657948e4f76b42"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_1(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1666a317326650cc54fa44d79fb12f2c92d25571696269091cfc2a29cb6596e3"),
		nonce:           decodeHexString(c, "b78aaf2eca04378633a5ae675e13b040"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d736aa8a0de24e6c52abef711f1e1349db056bf01e483f48a6166b4547c523f33fd006162bdd52f2c62ae1dbe3a2c58b938d72d8a00eda9242d57a155ff8a2d41522c0328731d52a97230af74099c0bff068aca1dcc4d9df7b9995fcba22c0f2b936fa8e70e1a51c79cdbf1bec25b43c56ef65295a58db537f3f370296f11923"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_2(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "2009dd7821a3585f99a4cd2f457f24229b53d22cc89182246ca5db6e69487c71"),
		nonce:           decodeHexString(c, "77b1b3f5360d813f180b06a5fac3ff52"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b5f8d9152bc11357f68b84c5fb327988f4342097d3fbb1d93e1a3a2f24cdee67c55eb8dfeeadeb217cd5c2d09a357b95f47823d2684320788a6eb96cb1f8bce99062abbcc85a03fa94b31ff2d69dba146b0e9c5e90c36fcfc0b63e4daff8029d24f0a636434d4a1caf28995a361163c86827d2064652edec5426c1e0980e810b"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_3(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8fd8dd091ccef6d09a2cf58c82527e580a12a447f142cd5ea720fda937e28087"),
		nonce:           decodeHexString(c, "e3181e32ee2401be0e3b6b860eafac88"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "754cb5db3d50e40ad74b2b622120b6326d36979aeb8cdaa5f81ae18d2a5e89b8d648a817159181b635fb93baf102eb492dbcf1c3e3dc652971bb5b45025a893bdfaa4c1c25e2dd31de50049ed6ec6d80e047bc459c7686e1a731841d3ae5b605957a26c44956d5549ddbedc9ec5cc7c92b3cf707bec475075d0fe35ba0009f7f"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_4(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6db89e68a2655e75d59f95de5fe3d2b74407b4f46884d1e8f137732f054b8119"),
		nonce:           decodeHexString(c, "aed46a379210fec6af9c77410a25e2b6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7070edce2f109a33036d2e5728c2a45b459285d2f7eb16e20fbd6fb490a5fd61c61be9ca45ce9fd09a4dae6c053f31591c8e64c494bd35c13c259bfacf36b6db2019def01cc74e7596a57aabf4467ad4998218e0264ced67cfa37c6ec50b131a5cf6b9f676feb95a0647865af7baf4f49a3a4bf7692458025e25805dd19c9933"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_5(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "435ef8c310049da6e111246eca1bee2227bb8228d71f3d623d23aa0db0ef31da"),
		nonce:           decodeHexString(c, "2c55bd5ccbf346b71d6e7f4b2756a270"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a439e798d74920d9209072e57bec34ea4fd5fb03510b44e01a499556ce11477aaa4381f66575102282a4a5343216363688e28c0a36613701f3f57a168477a8e556b2a14dadee9b153b035b8ffe589fe4c8d582f7c604e72a786eeb6fb0fb37eeee3175335e652158b15a8fe6cd38a0251b759e6b40c075e37e55bb4c42dcad64"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_6(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d45d3b017c2e0ce9981b77271012e475eb91a757f5ff4f51405f5cbc26d85032"),
		nonce:           decodeHexString(c, "b4b4a4131af602a8d729a25d0fd5c2b1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1a0890ff41f543326a18610c59567e9a6b0754d6af94e2bcb7347e5d1331a7e7c6174d9877d5f54de708b970e2f8e1e3c5d9347f2b374121d263b3a904eaa271bc9bf42ef26821fe10cb6f0de1e7bb552a2632ba84dffa34e5cee1a188f22210bb4f8124beadeadacffb8847211c3040065776935e75281a0d418116be0e3ca0"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_7(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ad54eda3845c0aac7ad5b4ec279c62bf582172e3fabcdfca15b230598dc486e0"),
		nonce:           decodeHexString(c, "9d6cd0bf5d3f97f53b5a4eef256aaf04"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "33086e0efc780b22322cba0a43cd0fc8bb97276c2aa510337469cb8ba0a07455208cb7fc586865a67af37784bca6ba032bb470c23cca4752fa3f82cd7ae511452d43e5d389de0a1b599856619670b4720e2b931f528a288b98c56e6b0c7b2cf06299c14d28ac830bd4845a59f5caa5276ce447cdc6bf3068ea017108ea8e8df4"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_8(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c67e8e52ee82a9b13b1132fbaba7fe6210bb31a003e5a3356a4b28faa5f2e408"),
		nonce:           decodeHexString(c, "b847901b4687575cb72b3275b06f0444"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "51226367fc26700d609d4b01ab33e51c6a882053c38551bff3531f46611c1a7305351ec487b49ecf0dcb642367ab5f51cd760201bcdf72fd38d08f3c645d34aac91714b870d3f0f8ed9ff7be78c820d438df3b846efa538752ddfdea4b2540937397eb5e457c426ea7650b7ed26620acaf3f2691bee931723f21b2d169b9347d"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_9(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f65e250ed53484c77c364c65c0fc1ec3d9cba8e43bf2625cfd3bc6135615529e"),
		nonce:           decodeHexString(c, "0de3f7b52f56b0b7b6dd31678b08e02f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fe9adffe781e198629a7716b22dfe1399422f1115eeb1622e343f5431ae5763811c2b18d3a9cee915ba4436238730867c3a48533ffbce8a9594042b93d94ae2b57bc926709a7a338ec1d2379cc37e88509f8b95a8ea8cb9d99a7f1c1bcb07570f873459a111f3c5b0c02b387fcca1abac0ce5ea6ee4e83dcb2feb601b23c88e4"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_10(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "91998ca5d4dbd8295b61b40ea79b77b3fbed7b479ec112b9fbec73e9eb1514ae"),
		nonce:           decodeHexString(c, "6a5fa647a4eecd451aa58d94e5add2c9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3f60e74271dad63be38e6193bad496670d0512f3fe55c7de8f7c7f6e2d1be29eeb9b15f3d1fa01c167d6e66f1baf31fb4890aa76d0799fdb6bc0e5793df50c2ad193c2c570692d09fa6cfc8fe0ba0c13481e9f2bd7d2873638179bee35d1a64af60f1d7165ca066d25cab6e96d0a1bdb0baec12617585271b5111e3b1e7c5157"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_11(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d1f062384b3edf86ad129511339d270d05c17b04c5f71d58508c94df92167a7d"),
		nonce:           decodeHexString(c, "8165f59c1b683c5204d544c7197c04df"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5cb24f3720849053bd9c398e76edf3ab6936005f1e4f8d2428c9d05f7b1d45ead572c01502fb2afb8c19cf700125896e6e798c2ca8a2ebc74fdb9cba1f60f2abe83d5037faee4364cce026e310c25fdb16a9cd002281230be4fcf1c9fa1cb3f386834ee3cf19a554825cb332cdfb1eb04d52fcd01d1bce690797dd2ca7016879"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_12(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ef27ded40795e5cad4412949b351c7164ac4cf814ca72dc0074d366432b3e268"),
		nonce:           decodeHexString(c, "83392a8b16f873ea57bdc63ea371e315"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fd824e80924215cfadf3028a5ea3a5bfc9f78023aa4ac8ca97f9ab9015148180765b4850f6e62c7242437afb9b34659ebf5f0c1163f36285f9661f3db9044a848dbe850f65c8fdae88bbeb9db3e8c03103b4e927534982e9071f4d34a1e44340287c7c6ad0f94c9a163ad35cc98b218762743587a2b4e89b0f8caeff7869464d"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_13(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a5c4d5a722594982efc03c0e34807b6480b96518527603394bb2d79810677b48"),
		nonce:           decodeHexString(c, "ba916273e88cc91febf21eb79fc84d98"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9c06959e1b051a6e69b8605cc9e44d1dc4c63f8767416d14c39c26eb2fbc01ceebf16d163a0106cfe4ffd8e3caa6ad58d04cba95562b7613b9e0a2f8aa0a10e93d6bf9b30bb41c31e4ebbb399504ccc8016623fac5f5908f8ba7339e6c5ca9573ee058429c44f537dd384e3592ad746de441dacd4cfc96cc4169c32cce4627ba"),
	})
}

func (s *drbgSuite) TestHMAC96_SHA512_256_14(c *C) {
	s.testHMAC96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7f422e735bdf349e4f51787571ffe061ec7e9181fa0b6a342e36611da25c1a15"),
		nonce:           decodeHexString(c, "b09d8dc6997bcb567cfd788d0e06483c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b83bb6e99b0a5237242711e27779d05d2157402856f9653542f1ce52b1a7463e13d5c92309a06d8a78773ad70504b64ff070c2e6afa4ec3662f2729cb7552235b79c18e08354e334474f238ee74feb7e892d5701543f418cd7f2f5533437d9901dcc54687816f16eb7341b1707c6310a2085dbf387044a78fed850b42fe9d8b4"),
	})
}

func (s *drbgSuite) testHMAC98_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC98_SHA512_256_0(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "dd8dfec2a638c28cc592fe8251d3194fbb6e61aa616ea5e97d0f7fbdcb86373c"),
		nonce:           decodeHexString(c, "b1374a4e92d9727022a751b8bcc161c9"),
		personalization: decodeHexString(c, "e08910e9bdcf94a44129e70ac8d51bae004460be9209fbc4fea6e58677c0ba0c"),
		expected:        decodeHexString(c, "6042b14ef02ce94944d88222ab63fe31cc33f9d263507897b0c62290b0927618735364adb6c79384a40b5856f3cc97d7612ba3775844c64339922bf56e66a29666f1c2b2fb190605e90eb758c07628364ca08a11277b8d21476526201af6270ada6434ac9979b5f824387ff370c7e4b3357b589bfb4a85b4beeb005f933650dc"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_1(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "fc411e7845d97150d2c95a0175f5ddf669c8b500f07026082c0c59d2da32d7f3"),
		nonce:           decodeHexString(c, "a2093fbef410c3e32afce740e4e60200"),
		personalization: decodeHexString(c, "51aa4bb8db57866fa3949d57425803be4944f6bbcbf99cd1b56bde050581fa3d"),
		expected:        decodeHexString(c, "3952ae32d30304db6e71536da7bdfee6ee3819b7a15a39b328f8f70b119d11e6254e8f06634e0267c994685eb978dae49994f51fa93ebe6742e2f17086afd7288230bbc2b96f34a6355d0795403e0e7dab5e7f96c76717ec11f08b1aa8aad01dd92d44263099df863d56b7500e1d9fb367a37e16c89abf312825cf1d5ba7f4f6"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_2(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "3b03c7f8e50df0114104dcebbd170461d71037f804b544912b2db16783341ba2"),
		nonce:           decodeHexString(c, "63058a60cc2440b8e2103b955a3ce7fa"),
		personalization: decodeHexString(c, "37e673c5f2fcb73eab99bdbe85c5428fa5f2b048120442036e98b0523791eb8c"),
		expected:        decodeHexString(c, "df3d636415279b81b915833ec2479a7cd32b8780219a56dfe4735d760125235b366484f4b576b8cfbefcc69882585b393d21f8f743e3aee8d879aef8ea4bcc0005d29c0a69f9c00cf7cc25c688de98e24bf11447847fc42ad16c94f58856cb1419a91a1c79e6cc2a36121b1a38f099d6dcf9af1fa63de6e3b0021d9613694a22"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_3(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "62889775bfb695f3382f0c3065936f2ca0c8e3f36d3dabbc3fd42e840341d43a"),
		nonce:           decodeHexString(c, "6e9417a995f808b88ec3f993e5357c4a"),
		personalization: decodeHexString(c, "a9e295ad98021c6535a4cb357a54f8f5a117bd2737d4ea9853de82777966c9e4"),
		expected:        decodeHexString(c, "258c5c20c10f4439f89fbc0aeece81f821613f24237c6b6d0ea8bfac3203b9c2b8f63f7254a86b567030db17c315eaa0de97cbb24718fda33e0b919b24b2982ff796bc4018b71621c53feddf939020309cd58f7cbc345faa234274dafc21e65aac143455a56e4a617ec1d8a33a726178c06911d5dc07a646267ee4b8d561b15d"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_4(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ec7661dec7df316fb840fc76ac8d71903f6310759eadf95f7b9cdb0ecba20421"),
		nonce:           decodeHexString(c, "fb6b67d61c6b28360eb88e6f5c9350e8"),
		personalization: decodeHexString(c, "e6488489e7fac11d46ec82fbaedc5eb7afa5152e0b8a829a04b89e27bac1c51a"),
		expected:        decodeHexString(c, "7b90a1cb3d214f54e91c2fa61a69ac9ecc6e43041dd7f2d0d47e763992a06719390aac0e6ce209b7f5a17c5f171409a66500c623849e3d957263e38fbdd89f01cd457b461390bd9ab1f9df5f704e6ad851cd83fbb3a151a8fb8013a6f2e096a6268f466390aa65ee58a68391f756b9825b84c2cb624bb1c7b2c39f775e2238e8"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_5(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f901f337e25bf8e1bae97af692a73401faa390ba957b5bc5133292a87882adb9"),
		nonce:           decodeHexString(c, "2d9afe970688acf45e291bd510c93836"),
		personalization: decodeHexString(c, "18660d66f4f07931896b7fe198fa87ec82b25506b400da4ab318625eacf71518"),
		expected:        decodeHexString(c, "928ee49e1e18b378e9fee6f4f16bf5eef588025169802dfee70227c7e57ae7ba8d59353fb0e1e51676e40921487baa3b840b5f98dd162e64d929b8d81417ffd449e3355db1d35acb082a537455bd0092dbfd885b093922986291cb265acbcbaaa41f8b4f98ac671ebfdfa27c38c41e4c8787484b8ff99c78e4f97525c3f0d785"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_6(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c24f0a26f18e7b826c81d50827a31ab7c7212355cb55aca952023fccca8a7898"),
		nonce:           decodeHexString(c, "fc3ed4a7151f9e12dcc63d4a73bf37a7"),
		personalization: decodeHexString(c, "a0b65d0f1c232c1a389d7d0d483d9c2627b70f4494d26b7bd87bfdaed5664cbf"),
		expected:        decodeHexString(c, "4c3af91cfcdf0fdcf7c634827be028d8645ae10ad640f9007ab0a890a8ec8b1749ca963d1f2fe50c982e20d409d0c7c64beec606c5b3529a8765a6d3340681554176e9445e9d4a65d2317c5db8584bcf5d2221422282f2b1ae3d9476d0dbb5bbd90d6e8b16ca0d47d8599bac225f67ba2832745fc0e1678b2d7074089fabe9bc"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_7(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e6c70f5c233a609c41f940b17133e1544803a5c429b2bbb5917d9d31af83caca"),
		nonce:           decodeHexString(c, "7a0bc455e12edfeb33e49d1d011f51c5"),
		personalization: decodeHexString(c, "1cd40e196df5b314cb554a95cdc58e9f1be896c7e61f51f1e1f38bfde47c0309"),
		expected:        decodeHexString(c, "877f3d2b98d694a0d0307eae5ca3ae4690ea725a748bf53f26b16b637d24f2113a51cb531046f92a487d880f9a2ad92f66a1e8cea4aba46c18878b03fac98d07e367f10f7ca0ed9c44eb50111c9b18c43e00214fc90a2d7cc0e5865b7d8826974dbd1648086cff3b38ee948f3790b64f066d883061551f9f6745bfccaecb6783"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_8(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "62cc5d526f4309f879ec33204f26b94354a83b555ee21e4136f02c09d3af9432"),
		nonce:           decodeHexString(c, "22fe210e3b06e853b5f00a6b27b8c869"),
		personalization: decodeHexString(c, "61d3e3f488b6d4a97cdb4833b97e5a1dc3556e9898248ab83af7b7addd2efcf8"),
		expected:        decodeHexString(c, "a77671353d8f4c9326d4cfe1b7fe4ff9e3921be4aaf58335137d3ef136750a3a963069f2e816f4b46fb40414a63dee8fef0aad87ea5bee17a48fee71e262606bfdef3a5991c7e1b3f1515aea637935c2fccace54360c943d96bc46910405a94df6d16e78f77bd7fd4c9cbef9f051908c601ddcd35a6b768dbde202727d03487a"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_9(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4f7d29aec8ba6438d89c9830999deb28215680f7abf29e7e84a8bb6a9f4415ad"),
		nonce:           decodeHexString(c, "4571e9f72258e7de7801cd80122d093a"),
		personalization: decodeHexString(c, "86e3bce95d32dbc308ac1d0a1a233868da91ee2ae436573462a2f603bef82b6f"),
		expected:        decodeHexString(c, "1c7bdb5e2f91e38bc7ec08ccb600ab630af47a81dc1b9a25dcbc4921d48c844c9fe4f7f1d097b4bf63ba6bf54179d12ea384ceaf86b58957ae833c2d9c715d50eb9ccc41408319dc0d25db24b4fbf5fb906282d6f75d15ab37d27101cd62da4b670260ff2d421359af9c53437587f5e12a800208b91b61bded901c4772f8a731"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_10(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7569982669b99fbcb79d23381bdab6399820a204dffc405463f9b769493a50f7"),
		nonce:           decodeHexString(c, "aeddade62e85511b545953897a945c89"),
		personalization: decodeHexString(c, "ff2003fbae431c470937fb68007fb36247f40f23a8c5623aef69e8c094fd64ab"),
		expected:        decodeHexString(c, "019fcaf920f3ce2e2bf7c3247650cb8555aaaf8f0a0033758409cc9dde00458cbe2bfc118285d86664ad665a9ae8c6437d1a085b820e5bcf2461b7715415a463f7472348679f84f6c9afcdf93d65394db23513c3efe3c45783d7c153039e9584a3f9b63c323df37d73d781516b0d68e2fb01a80e477ffed6e5c14ef772db6ca9"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_11(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d287d43e20034609aca0083e55332f0dff6d6877e646cffa3c8248f22478af70"),
		nonce:           decodeHexString(c, "90b2c63497deb7698e84f71d149e8b39"),
		personalization: decodeHexString(c, "dd537701d7d89bd7f8ff3f1b76a84b15c706eb12601798f9badf64fb52fcaa42"),
		expected:        decodeHexString(c, "0641cf15cd88530f05b902fef84b4be142ad686905002a21cf74ebd5626d564c5786a835e01a669c819d63fd15bdaa97d55523bd431d23dade44029d6d1e6c374c62ea408a674f877d8eb638b6f270af0b9ead6806cc19f9b10261b0b7500eceaac56869e2b2a9447b65f75c7228720c1530fff4150aa7b82787880a183d86a3"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_12(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "698831f2aba2be5b651bb40850a2f9d1aed8ed8ed180f71012a52643d38cc04c"),
		nonce:           decodeHexString(c, "4bd3beaddf6280ef1009109868afe8ff"),
		personalization: decodeHexString(c, "56e05ef424777b7bfb75e755e70fef1186d4103872aa5cdf35af81ba4b00a2cb"),
		expected:        decodeHexString(c, "2684818725306a95c04b38e0dae52ee97b3c3c85b61053c9aaa59d656b64af1d8ebbc47787c17024c54b6f90232a9010191ec63092b85ea57c1f62ca48500e4099ad3c8b80e01951bd14445c5b37623d44ed8c64db9ff3bcde5d8ca0abe0baf3717fba2bcde261866fe149a2653a4e230a449df539e0d79f6ff8fd4b99f8b3a2"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_13(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a95fe69ea1e020ee75d4cdc9a29a8ecd7c543a7dc8bf3ec27586e45f4e5ee2a4"),
		nonce:           decodeHexString(c, "fb1af7987f30edd626ba0cf8e55ad96d"),
		personalization: decodeHexString(c, "9e448d98496494a4b510adf2dadd5f66b3d4a5d8d81fb5c8bbd7244838c4d882"),
		expected:        decodeHexString(c, "6374dc751a4655d9d6990729d70d25ce147c01556fc3f827c63783a517a0c6b033af4c1325bfd49e98a38b6cb6bebc139664508b91d2775f4ba03de149b84f8eb6b7dffd8db38af1dc8b38e0aa5ae36b791d365b08faafb9906d2755e279a6e1ab912d4628cb79e34847cd9368abcb5b390017bbf3594959bcb04fa8c5a5c449"),
	})
}

func (s *drbgSuite) TestHMAC98_SHA512_256_14(c *C) {
	s.testHMAC98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b2fb9d9bc5ce30966b7f2e6a6458e2f2f6e72ce857fba052b5327ede9ec2492e"),
		nonce:           decodeHexString(c, "06b7b75d18365f4957489a09204b2672"),
		personalization: decodeHexString(c, "9e32f001033eba3bede220d4f351ce110e6ee2eb0b099ce54f9606a21d80b1ea"),
		expected:        decodeHexString(c, "508333114a0abd5fe10327daa0f1342c66569d912a64d8ae89227d0d8ed5b4052cf84f0c38927d88dc0d7c476e747965adc9579a4603a36566a1730f55ed7b100c1695f060674484781682ee629167f7adce89885ff04d722d960d0297d2abf79bd3338126c2d356a91bfa588f80db7ea365bf181fa5370c478a04d05a515b78"),
	})
}

func (s *drbgSuite) testHMAC100_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC100_SHA512_256_0(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "58d74d3439883b3706641fd77df6585d9189642bf35fde681415b88dbe739c97"),
		nonce:           decodeHexString(c, "24be10c3e7e66e3ef092293c573791ce"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6ffd1d09fedbbef493a0148c027e21f5c849ebf4aa22cc3ef5def034db12d02087f2320eaa9d4846ba2a1a2700127de263c773eea7d7f28c80e56fe9a17e1170993f96be21dfe0d899bbe537982a890a3fc6fc504026f396635f85f7c7288959f52b8bc1733797e6f20f04fa390939f8396ced1cbbd98330068002b9ae76528f"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_1(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "aecef1ca16cec592aa6ad0857b8632ce3ea58c1b7683fcbead4c200e9b8d86a3"),
		nonce:           decodeHexString(c, "f3c40f46569c1640dafd7ce04980e25f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "35ddb613ee1df8604d3c57fe63415312d735e39b822f32dcda3f5b36f48b28eb1dc4340c102a10f3eaa3c7d5d80c4ff017e9be4b7bd364146352db99f4e2c8c230211923d57ac97f37a16360fe41b853a94c272dc714188136661dd4f94681da70873c4279838756ab0eadac03048168c89934573281b209df3bf113fca13551"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_2(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ea2c4de790dc599bf6b0004f38cebf029d5bb309d270dee4cd17c5f63f2c1f58"),
		nonce:           decodeHexString(c, "d25a01c86bc41b09a96db5e26e6e7268"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a39cf0b6a58827112425a2a3173e7217fe5c12b91405b695e1869a8cc7b03b446085845223e4fb759a06f4fc06af9a256135ae0b2e2fdb7c960cfe98e245d045780775c7b572f3708409e0e54af3af6eddc9a6d526be10395bfb7828f4a83c3ae9ee1fd39af9a1344b24139ca76b7f797aa26806909786d805dbeccfc58ab4e4"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_3(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "56847911794d3e0aae716c3fea9bb7934c20a74cc6c49185e4b8211a6f9baf97"),
		nonce:           decodeHexString(c, "bb80288fc7310d0bc949d9e9577cf5bb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ed025df4673fe9abc7b71cdeb3562331bee52de9881fe1893ca3c5775aa4888c6156dbed89f43ac03589947edc37dd0054579fd9201215df95331c7b8d76a444e1fa7d0e805e10666cbf96a223c4302e10090889f57c9fdd4c5695aecc63f9d4bff88420b67abc0456ae4647d784b1e7cc0e107b9037f81bdc815fd37db9a53e"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_4(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e0c22f7c9ef6d333496daf66dbb2f66bed05603214baa0c8c26998168be4f136"),
		nonce:           decodeHexString(c, "7b91eaba77c65d5ba50acfbe7ad4021f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0f879fe9f07fc22fcc048037f710268f18c7e5c48c400239e6e14fe1bb21a85d475e4d85191c63c8873f6ca5950c5f888760e9aced47f7dcc693c53d9f1ab05cf95a7d1393e16b9137655da54534dba399bc4fa69de64ff72ee64c17c8c7a8a5b2e143d9395c86ccd29d244ffe7aeb516aca23baca299125eb7d62c2a0e02830"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_5(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "50849e29bf46faf1fcb6b5a89f0b4c440d37c01c6704e766fd9806a0645dc77d"),
		nonce:           decodeHexString(c, "c5482d9931cc99add1454f5be5b49a82"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "82fdf574adedec8d26b8ea8da77d63b1dde7d4887800bf928c52381b7320b45148e04617d3b002dee13c182133bbc087c57654df708abbf3eec2243c8d6dbc890ea3692a3f49a07b4278be4dd39110084987b7b9b3617f2ebf4ef899a1f602642f7d5a6ea2c8a67f511648bc1ef477e583022d6672c44d142e0cea69ad753cd3"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_6(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8f997669afadfa1eae9975c796674c43e9114623a9b4cd11a2878755ac92f570"),
		nonce:           decodeHexString(c, "6c6e904acc7585572e0f22977589685d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6ff95048e306e0d0a4735c3d42c617ee737f7aade9aa3dd2c10a2129e4771dec06971de0d2239f804fed7f5ef30aa7355d64fcad2c096ccc3be6e3f1ac86535f238b0b6cffc564a2c0b83dbd994662cf1fbd734ed7ef7904874aa4c72122bd50ede3601a2d8e208acf0d554f99431f68e70bca8f14d405a86f3f4a492e4eab06"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_7(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e2564f88e03f952c9e763d5559cb6df1f1697551fa7fe77755f813e75ac9e0d9"),
		nonce:           decodeHexString(c, "8ce0e8e322b0dbbca3bfd27e784522b2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "abbbe509fe028adf25e56f01a09e4e36c80f46e6c0952637b2b5f6a4cb2e2e11d74b2230d6ad34861feff352c7f7b34fef02892a1c716d2793c84a9642d09083b8e42f37300167815a52b5fd8537bf9c491c6766f36179d9d41e6d6486ce37dcd192de93f9b91eba29604068adb3c0d82d0ce7141e26a778eaca4233d448a907"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_8(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "053e0a70a8282ffd496aa1e23bbc08f8ad63d6f8bb3384bd85e6bd7d73dc7459"),
		nonce:           decodeHexString(c, "278a4327261c8ee2b66725d665a58176"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "db1d35fb48642ea3e8fdb42bb013c8517ef79e20c0339f2b5ef81f24a36373b9e3c7accd087f34530b74cca912267c622ad990bdc7bd38b75b9ca04f5d17082d1457725df57c520e80386555b227a1ab6b124b610ea1ca5257a513a0a040d9fba3f6ff02e298c571c6941c9d85276716dc1ce52e757eb9099c8d799fb00bb93e"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_9(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a95cabe12de3ffc140075da1b7656f7b1b1dd52b9e27a21a7f6b14148a80fb18"),
		nonce:           decodeHexString(c, "a0b919685ab73b2f5645c92f32d1516f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "51a716db9d578dfc3e53067707f5adf0113a95d531f66c45eeae4e83bf00f3c776f001da09a6680274e522afd7dfc4a84eb34e0fcc4977079885f9180b663e2a559be765dcc5cdca9d2a6c7cf5e1301fc291a98126d70e4a6de8f09ac8bc59a730f7fbbec0d6241c69aebb77999c730cc52125628e40ad15520741af2fc53ed9"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_10(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "195801f6378b76ae85ed81a4e906414d7e434cd46e3368cd9a2d6877975700e0"),
		nonce:           decodeHexString(c, "e349cbda480925a90d2e0b88af171d79"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "35eebcbbcd48aa8ab40a6536e65c10ba8efc6e889d29e30d463cdfad077a55d6108f5c175302a5e7cba3dac94f82ec311ee8e6b73e13fa15115b4baa2848d1f30f1aeb8efa716a350627c85371ff744e8e305d851b3bec0a2530a10ee77e63695d6ab0452d6c78a5198701e048370e96fccbea803591f4e099bc0e801255b774"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_11(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e7c5655c8f504efaa3d7467b54b02a5443aa2cd6bb075a7f665c01b38fd28c9a"),
		nonce:           decodeHexString(c, "86e2ee751854af6852367d2871b93e65"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "050b98d3de20130121733a0197760251176b28c5108badea03dd1ce0f4a8f74832c9e7813a507a6c2dff80eb2378a0d26c79300ff3dc3b1729df762ea50a709b87d97b138e9fdf7981eac418cb8830599e806040d514acc6da5040293bcaf46aee8f4eba69e8690aeb56f414e55910102aa2d4c5dde2e58c3625ec68edccc90a"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_12(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "13f1e2a631cc4697302c85ec96aeda11d19caeaaf42dbc57487cee53b54b4e03"),
		nonce:           decodeHexString(c, "dbcc23386960304602da9c2cdbc8186f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5c6e47247e68c6da45dae4925fd2071cf3e4910a2cc77675951cb1ae714763ad8cad934ee7cd985f36aca2571f9505e9effb11e93428389ccb54a04138ed59c24fb900c9b59e0f07406d611b3e71fedf5262e48bf4e8c9c38cf1a7c3c43b54e78a3a35049e1d90145f45cc203e8c22d2530c62a225356e0b38236fc7cc38b455"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_13(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e285871f4c6e631e6411272e9275b12ae74908c292961089b8ab137df47e819b"),
		nonce:           decodeHexString(c, "8441c048965d3b8585a5ead1adb08212"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d28a4c73cf6daec844ff20a3c4f642db65a7b5222aeaf0f99a34d65277e626d0c76c4fbcf2a8c94c4d9d213907e27d20b8b201ce8b05a5aa47e9053078173a7f640a5ddfbb05158a70f36da1a058cf4f451f2591ad17071f38e097ab1ac80cd2b782461b82a29ac5c5703337a21cc3eccae86da1abb1e192cf6c889bdb729fa5"),
	})
}

func (s *drbgSuite) TestHMAC100_SHA512_256_14(c *C) {
	s.testHMAC100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "df6edf960abe3aef5f50741907c0171906c0837ba3bfaa3a1044fcc4f19ed21f"),
		nonce:           decodeHexString(c, "ff2558bec3e5377c12697c908d629952"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9d68c2674eac76f3ccabe1c6c0bad96d5fbdcb1629c939e397eefbcd2ec2f25803fbb9aa72db952f7fedcb290da99f34c0fdd637c37dde1446d475a61c38c3fc5c1ebf9541d136cb02a43b2646df7ee4bd0d9191157dac92a33f401f089ae15618624fc0baf707409aa2f80cd5d0676612c2667aa420acc6e016e6ba3f63c686"),
	})
}

func (s *drbgSuite) testHMAC102_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC102_SHA512_256_0(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d2a3ac96c06d87d1f6299e98a3ac43cd163917490ef02b652d8416fd67c0274b"),
		nonce:           decodeHexString(c, "a9c06352c760c84614eba4b66298f306"),
		personalization: decodeHexString(c, "be420c590d13494cedc74f3236313d940bc0cfc4738c885b21fc7d60ec9bc49a"),
		expected:        decodeHexString(c, "fb66b8ae25159fa61631277b47db3bac31a337961ac46eaaccae5902dbd356dc73fd06e21b23683ac17f1788b2b60e7899122995fb25d016b936d9bae58f1e06be96a1e615bbdd49fdfa79e3df8ac4cca1f066d555893e2fe4360d16db886721ac8a5e401934f8f5190a3750b00b2a4629beeff767d3f4270fc1fd68651401dd"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_1(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0f78c24cbb1e44c6b9ffa66ce7e89270ac1c7bc88716340e7f53c4d3ff7b65f4"),
		nonce:           decodeHexString(c, "90509da07f8be8a0f625fc12e89b7643"),
		personalization: decodeHexString(c, "cd4856cf2a61aea4fda4bada702f0be2f15a460bd1a690a139fa3515974fa9f1"),
		expected:        decodeHexString(c, "1f3781b65456151ae296b7e3b2e82c9292b8d97c1249a98657491e1eda382bbd1a337bf1287a22d1b26cc7151f7a2d7a6ec64d0de57c64a6d1fd3272d1f43b1de46959862fb85b134977502c291ebe7c842f1116e34dadfc3a130c1bc80923dd68432ac0d80aa1c35b51df05951be928692513a26dc16975dea4be0b35280b8f"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_2(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "33ee8d0dc48c2609347b59433e29bf1685e7900c423d1ba1752c9be5842abfab"),
		nonce:           decodeHexString(c, "7a01de38ee0d06c62b431a672078da60"),
		personalization: decodeHexString(c, "d139ef8ed22c9887c3d9acdef3ffb1634712f02160760c61e0d4d1ae9d57e066"),
		expected:        decodeHexString(c, "b96adf670697106396486ffc5be9b133a95606ef89777dc82da72229e151c2d5d186c33e324388e4d4d07142d3abfa42a9ccce503846d8db21f911f3882fb17f52044f26eef88109f83ac394a0cb28e52f102b32dd75ea4f6218c2a4fed29afdba8be324b2fe1f206ea2257359b3830b87a63560a7649f5c22ca1e607f92361a"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_3(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "989eeb516274ef8398807ecb36647152b31f37c318c182869ec6a66ed816c33a"),
		nonce:           decodeHexString(c, "4a495af0f210b6552ea2b51d58c84d35"),
		personalization: decodeHexString(c, "38b59f9e9add62089d478f5e6e26a6a8fe0769567c89ffdae1a299c6950d8092"),
		expected:        decodeHexString(c, "feb2acc2ea034d48c43bedde72e7431949ceead6e9de09c838a9017421c707d9f39871c1f328a5deb843e66b87bee6772ee3332fcbdcad92600831c53f2f439d4128e329a6c0cde6ad891598fd3f1fd937a563f655388cab7361da2064f2168c25c325201415a99aeb6096b0eb7ab9597a781685b93e4562ff4e5f2e562774ea"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_4(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "fa5ba9b71ca33c1ff844b86b67266ebc58916c3683fe8ea67ea63c5a860f69d0"),
		nonce:           decodeHexString(c, "baaffd637cc0e1363f4ec182c0fc9532"),
		personalization: decodeHexString(c, "9b9a6b6bf0dc0f909857a18b5bb7959d94977b0ccc07acf8d81ed56808297f17"),
		expected:        decodeHexString(c, "779d4e6ecd49870015078134c5b2489c2d4eb5e1ebd80a4104f21735e49ec6a07aac01f16c41d9fd1546cb6e0b6540d6a14be4041868333d020922be9e16f83feca6bdcc656de16984434e87e98de46b15b287531fc415e27ab4dca0e5baf8bde9a446c8b35007c300598c6b34c076fa6f7ac8233c9e47d22168b66206b56640"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_5(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "67beb75bf701e1b63440efe5dd9ebfd4516cfda5def6c7240f649857dbabb28e"),
		nonce:           decodeHexString(c, "657ff5fd8f368e77e09189d018e807cb"),
		personalization: decodeHexString(c, "648d618b13f9fd5fc571759951a9b089b4c31b1a7c59c2e2e1724f00637eb3fc"),
		expected:        decodeHexString(c, "cda8e01dd85646262d91f7bfa2e30c19bdbb106a5e9278f4e93a73a2b37636dc56a6a6cc9b83faa00061eece4979cedbce65c5692aa771fbb23a8017ecede8ba0a3213a809d5464461cdfeb3dab4b0a16b6fd38726008a6b499b5f3169662ae471b4339cbb889f9a5fafd4c55ed24d97f501c5c980792b9e6ac1a1a0d1ff304a"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_6(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "2b902a0df62bd4b046a8d7cac27c8047c406af0da014f4bd0727603b258c365a"),
		nonce:           decodeHexString(c, "76b57a7957308bc9624e32c413300819"),
		personalization: decodeHexString(c, "70c04d9287432eb3f92e782d4e8904404220c489c0bf6498b77b579e063f1464"),
		expected:        decodeHexString(c, "01abf0c89105731ca9fda10be989f5e10867b71e9ee7accce928b4dec9be4ed4c4714ed0b8d1ed080e1a3ad57266cbd84b6e3fa03931958c6949abb8c553d381b749eedfe54658362b7914fea1bbfc17e8b88caca7f88024699091e67ced6349b7a54ecc900e6821b619ec257153217184baced2e14224c0c4dc1a96d1403de3"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_7(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "67d42bbb560b8b4e018db9ce142f59cdf8bbd1724b2e4889c27efd3300c508b2"),
		nonce:           decodeHexString(c, "d84840fbc1baf2d5c0cb8fe433f6aaf2"),
		personalization: decodeHexString(c, "d40fdf1c5843b15716320ad9aaae1c79c48ce15fe64b526f625c2333ed195a0c"),
		expected:        decodeHexString(c, "c6614bbf77c586c3d8c91b45fcb7e024c875eb562ec84f0ff32bd75d888de6a5753078395dad486e74b6d4f333dcbc4097777722298e2d262e6bb995eff347291e65f979e4f276829ea816fc5faa3c16ab9b28c3f03b4085a221d1f0e7d0f4c9df1f21c195c330a9e45717fdbf3e9d3fa7baee8b0723c1e1aa782f38f6ab8b0e"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_8(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4f7fd8298c723f3450819017b77558d4086284d168f88ef204ae0ad1115aa476"),
		nonce:           decodeHexString(c, "5b3eba417cfcaca87786d4f13e30f7fd"),
		personalization: decodeHexString(c, "7c4f834b82af1d274e3ca578db6fed21a1145e314baa720a80eca83709e58469"),
		expected:        decodeHexString(c, "064d9bed03f2b6a913909617cb8958fede376f40b79bc289a5ed5720dfe1910803e938da32ae9b4488dfd44c37b702f4f9078a8e1d42fdc06512de3fd049abeba02f93e91c4f137fcdd4521f0bc423a6ef9b5dff26ca12145be58690288d4702b12f542b912d70de076842f292d8809a027e10a789c1165bdc20769afca83f0f"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_9(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ccd39c303f868c0dedae792109e09beb74be295d1cc1896c7d4e0f58c2e5c8a5"),
		nonce:           decodeHexString(c, "38141f323b8e483d80a4ddcffb0b2dc0"),
		personalization: decodeHexString(c, "b49d2f4b3ed163cd69d9979a87f8b63c4f109e902740cadaeb16059f1d4db435"),
		expected:        decodeHexString(c, "6e9c45f99fc8b5601306a52469ee1a03a342fa3414ef707cc201dad1ef1dae5dcf93bf55391427a9fb6029e196c3c2c8c29e0bd8c97fe54070db7dcefda57aa13acc85cb3f3f71ff3f8981dd6f0f07fbeaaa406e5461637d2b4e294927e8d5b269ce70579cb6f468448b6c9490c96c6679b7cae601519a48e99ca860a675fd14"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_10(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5a9de4a21e89be4c6f691a535228772eda42308b33e33f3cd88bd6dc28282287"),
		nonce:           decodeHexString(c, "1aafaa319281d69b8f54f401d6a663ac"),
		personalization: decodeHexString(c, "42ebaf1828e0ea2a2e047fbd16fb4a9e6b7aa678807238be93dc16950d7c94b5"),
		expected:        decodeHexString(c, "dea796adac8845f6511310b4f0165561518fbc7e3442f34c8fe7c658480c2a101440db31d7c79736cafcd2a0c400ffbd37b8fe73ab99deba474253d206553904c14e8455e5e26309148a023abb3265a8fe67d08dc9908091101263c3420b051b781e3b76a9a3d3c4cc67282a3839b14732662edbe59875823845d15b4d16ac15"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_11(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "20b9ebc6c44f05b7aaa1bf52ab8928bd2833a388383f90a618f1057b69115c13"),
		nonce:           decodeHexString(c, "3070100b757e2bc99bc1701ae1fdd608"),
		personalization: decodeHexString(c, "3aa37972201eb96286898a6c232824fac8853053e4621c39a5331ceb5ac26017"),
		expected:        decodeHexString(c, "5c368bd5a1b056d349788091d51bb821ff7ff6a8fb2e194775f98bf0bd76a9b48c09ece83efd038d2db6b8940b07b689cdb630aa7f6f723eb81f83c48f73dc9cb75a10df2b5206382028acf5edae415f0a3ba007ee6575dcde6ea22b9df58f8f6cb513269c65ef8829abee30a66a64dcb373c2f087cec36877ec569eb687589c"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_12(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1f8b5afe164dcad4d00e630f612ba16b62f184e431c397c88ef693140b624449"),
		nonce:           decodeHexString(c, "e4489952852e75c0b0f7ca90ab8ec9e3"),
		personalization: decodeHexString(c, "24f073b96d710243c12fd16b53ae7183a2324a0244ce00a35528fd74578fbf9b"),
		expected:        decodeHexString(c, "da30b36dee2a788e90bf72de6f4deb6614d6db16564a2d3394373ff051a49b93e576697d67f8b74d5774d78446f856af153a95933b1ed4dca5c4de42bee6b9b377934e50138a8feee927b1d65e58703ab4b37aec90f6835a6d73310f80d6e95b021e63bcda1c9677eaa099db49cdf684bd025296dbd3cda954c963a04a31af31"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_13(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5c5de88e41581e1cf18faa16d46751fe1da33a7bf5aa5c12a008fc65af9de205"),
		nonce:           decodeHexString(c, "c519ffe7dd49b70556063777218dacf5"),
		personalization: decodeHexString(c, "efee6a025fdecfe1f6a31ef6b2a2152a0de53b65faf8e3444435896398fc39ab"),
		expected:        decodeHexString(c, "8cf44f07902ac42105a60ee44fdc2aaf0dbe5f911e1735c3d64a56c893f4e7a189519c7ce4c1f3ebac95a061aaa0cd80233ba60fc888c0d971093af745fd5b47d86b680bfd67e50ad9b8568ecbca94696a124c535556ec5dda3b197de1da3db9cdb56055c9b54d6d154d2b1d99b37035cc2737eb60b4eeef1be60d83f4f7cdf0"),
	})
}

func (s *drbgSuite) TestHMAC102_SHA512_256_14(c *C) {
	s.testHMAC102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "41e0b160ba753b912c728d3622338e5e6a7669e2e65b6af57ae203179ad3de95"),
		nonce:           decodeHexString(c, "2c4c4f3a953e551746f7e258821d24f6"),
		personalization: decodeHexString(c, "676a9304a3f744c62c7f5048f2137982c89860577cfcaf0d855514436ff8eff2"),
		expected:        decodeHexString(c, "7bde8a5a34538655ab2ca26d0447eff3c6da298b3fa53ff0526eeeebaa4a876b60e47ca544ae30ccb00176ff84920bb4e4a4ebc3cf74b9cf8cd8ff9f7b11266a3c9bf918c458760bca6368ddfb3522edbc61ad14f2b638294e51d82e617d8c0c631aefbba50dbcd1a0a88963c3d63959909ce2cc669924d7163b01cac468c0d9"),
	})
}

func (s *drbgSuite) testHMAC104_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC104_SHA512_256_0(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9f465b884dcf655c921842200344234ad4059886ea5d08158b32f4f82a1bcf01"),
		nonce:           decodeHexString(c, "a50ce7d89327c88aa76333692b65ff44"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a277a715800aab77ed59efdfa98ead15ca7c566dc4a788b66d8fccf2eccdda9db7c635b171842cc4f04cdce20add856499bad172b5b267cf863369a57eee5518d6d252c685d8932c50a9e0b2493ffb6cc9caa3f6abf9a6845561d9f1ec042dbd0312fb324370abecd4c740e453165c6f26096ab49ea1008b99a63f6bffabb03"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_1(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b18d53ce1cc26f77ccb09f48d2de283e4fd1ade79a4e1297863e3f3244194e0f"),
		nonce:           decodeHexString(c, "8ba1a44d4fd7221ab66f1a3b6dfecc02"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3856de3c07690074a53bd17f76e3f620b0d7952fa257f0ec0ec2c49ee4a906fba86db39f743e9b65cecdc3e77cddee806798277a8ef09e4c4ea098ac20b2403fdc31dc9f8a62831d61ed5a203324e0fe020b99433d1cc3b6ca60587e2a5eab17ea9feae2f8794673d65d19a87912fd4f87b07ff440953fdc1f52bd0a801585b3"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_2(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "02893f95e806c2406474f357480b7100642fd60d5285d6875edc99484d3f2ed8"),
		nonce:           decodeHexString(c, "cc2240591fdd1eb068b927e4d026eeef"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c9c78c2ef52694e85e3fe6b9fb4c87f08ea15617ea974395ce073138f05fd7dac7103f0801d22595960c691167c39273cf95718b9abffdf643ddb0bbf2e3ba74ffbf75782335c6e0ecbe6f16bb71c4b8fe83d34beede6a76e7fbd7852ecb0c1d2f33d54fd7a378a6463b7f934ecba0ba53f01d7583ad1a2a9c9b4df356b3f73c"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_3(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "77ce1d534c97621f2ee80744e1d9bf2377616823d2c7cd167b7f8696d52b5cd8"),
		nonce:           decodeHexString(c, "f31804771016f0ad9a31c480872f70ec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cae5ceab734bd0a7d251ba6a7a45c6c7d59a4e68921bbc4b696da1f89d78fe0653aef44d9fdbf088f5ae4d3bd32c8d32ab9b0f64d57d2923f76ca0491b45e87eb668ba157a17e96a17b593d34fcca39a5ff9469ab321aa19baae4a1f2e59d122df8793e6f2934dd976cf7af9e2ae998c87edda134dc57e69e45fda3be20ed568"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_4(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0a566fc2d734d538533a0ce4841fe1d10a44edd77cc66be1256298b1d2511075"),
		nonce:           decodeHexString(c, "b83a69f6a5faa05de81c41d0fdfff4f0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c9673a965bd6415428ed1aca9e689feee8b305d93077eece568f01fc2b2d9fbccf516a6dd7006337852ed3df1414f18d56ad77b90e49f3466480da4a569af87f3fe82e43fe254caac034cf9ae7f51c42bf36f5f073e71c087558535431d80ef65825d8a13692091bb0625eb9bf8b0c7d6a68860e9aebdd8fb21ec4e92f10f2a6"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_5(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "3c0cc07fd3164979ff8c50fe5ff0781cb8045c2e8c15a2b2dcee237da7f7c340"),
		nonce:           decodeHexString(c, "7025cc3ec12722eba6356986c8254eca"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ef9273fdd863ef56f6def6136d6ddd86dce70f3152f2d8ca7e01088f00d685b06bae2488ccd2838ef23021a1c4c7a1930d85788f8651a83fc31babfe719f7ac9b24c5ef541aeffd6459892fd97f0787f77a751a11e3a166518f11d334a9d1de8013a96c852d37b6f4133422282b08df20bcb3d7fa077ce82e323f1873fca5722"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_6(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7fde6b41b786e28fb708534cc71b9a5781410289c4c008d1cd33537c5f5b03ce"),
		nonce:           decodeHexString(c, "4375a24ff20ed56d10e657c5e7fa195c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "153c1330e828df9ace5c766e85acd82cd7f6b014b606ad1fbec25edcd83258cc1923a35f348a03db77c69ade5caf8acf231a587a64bf452f624f5321003d66b1855524eadc4aa1a377ca912c7bf2a20f76999d70214b8c73cd69425c5b40e872c4e0d4e0e5ca4c32449d01cfde062456b95c24bc8f180e2a575c2b6e07639f75"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_7(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "078abd36f77395b6ab942fc4d45691a0a6a8fef6e2d6f0fe99979c91f4598adf"),
		nonce:           decodeHexString(c, "e4249f9fe55b428199e3b9fa7efe4e08"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e73a36fdd9dfaf858822cfc7ab9de5c52f2450673b7a59b883d7409e230f416c6f60842677af5fb0f57d5507353637de66fb009ecc3d3b4830fa73d7d43f140c6b1359efe749177bbf776e30a054399dcf3faf44fe68756aa20830837a4ebb69d2d625c3dd1fe7d30faf7d523d92099479f15c3f925f4c22d9a2534ed4ad8314"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_8(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9f1c1629856c5d028a2b9f8f388a119518a59840ce26d6b532c86406695fdb9c"),
		nonce:           decodeHexString(c, "a44fa5fa6ac291bc784da9248fa27afe"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3280d36bac6030472f9d0d1ce66ebd9e65d9c529a8539e3d3ed756d9165b94f4a596f390baa999ccbc00228953aa3a37c090065cb2d8e9719a386450e172d30887ff28f59a3aeb71df6f8122509dc81cc42ace912897cd14becfaeeeb92fcba3092c39e0c53b3a067764c2e20b059b04ba483afa3112a50c5508fbf458d6f599"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_9(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "81d0d864601e76ae4dd377a6f54a79b7a13d179b3f470e1e785b8105a8228793"),
		nonce:           decodeHexString(c, "c8446ff557901336a5d18ed8fbb64193"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e5b64ca94576b22d0d4aa9d808f6bcf7c1568d5999dfc410c53a0fc54f21e293548e7659244a93096946d2eb21de54d687650d9edef5e0e1143a14e739d18b7348fa34cae1a1f08f180fb1d58bcb42b36052aab903b50538e252c4fae93abdbb5c51d2d99cceeaac2350e7ad1d94215cb945123c822de752cfe2db51b5ae8930"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_10(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "670ea3ac9da691881cda74715653b392309999842e8481c4d403418b37f6ca60"),
		nonce:           decodeHexString(c, "f22b88678125f4edd9c9715a25a222fa"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f25feac8fb189e38659feae84539c62627ee4efee9eb3c959555ea1e0ca7ffe63bc5ddf9c0f71b0f4966269cd1a965be66d5851be3a649b9cd9ba8e06d432765d4baadb16eaef1d3d90b762b6e185cba792fba08b34b1018416a6085689f60d849cf0d739411e1d8f0f535afb16e48c08190392562b74aa7f400e036fe72748c"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_11(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8eccd6292fb4ee68fa6bbb3be6e995c5bea9e9d7d9b523ea214b2083b46aa1ff"),
		nonce:           decodeHexString(c, "ade93e693636defb359273bc99f5add7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d33d9e8b04dae6800ec065a352d2cca3af2c68d7a2f45381a9d98997855ea0392c1a553d0588605729638fec424d0749e53fd267776241a7c06203fd619982c1cac4e48c84a835e034f1e6367403a95f6aa8188a116f76815d5a4efdf43ae89f4c5d48454c4e956bdf2d73524b4c4b9cd92dee7487cce7939fb89dc4e0aa071f"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_12(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9b32c52ccbd66508477ac950ddc43e26d4be7ecf31f5f9d86edd3349039b1b90"),
		nonce:           decodeHexString(c, "2dec9d80c3abde7cc94f07850d8ae7a4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b00c87fef5816d4707554240a13c882892d383042448a8d71b5ca250bed0f90a22be791135f81c4bb8ffed83f45e0f4c32ebaa1dd6f9992c101784bd7202672f88e7a0eb52cec64f2a2013ef82f04d64bab346f4bd948e75ba922c1ad469975659f82089763c143dd8f872cc4b0d3f02dcfcb4de868434d0ab6d6c5ead89150b"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_13(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4637a3f3f9443a915c249cd7a83b8151308cd86c80fca2ba7e45cdaaa44ac1b0"),
		nonce:           decodeHexString(c, "096f13ff358095cf2052359b95ddd5a7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f08e0bb490c0bda177686efc825381d1b363cee7a7e9c007d279a773dfcb0fd2b56048fadad1c7e9dbd0f79666bd5c68c4d64a0e2a5ed5d32c74e1bb6e6588f2c382e886e5138d57ad8ba7b31b119d3106ba15e396c878388b96ba57b70e496662a23592d36fc42161453d70a4fa1306c971207c0c44a96c0da7ca40020b37ca"),
	})
}

func (s *drbgSuite) TestHMAC104_SHA512_256_14(c *C) {
	s.testHMAC104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "abc502a99b7c3cf14262f6b036925a9904105b019592a2a6be26d71fc42c7444"),
		nonce:           decodeHexString(c, "40a212f9e1a5aa54f2c7ed4ccf631c9a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0e747d83e2104367beca697db9b6bb994061d82aae7b1564f6a0911a1f599084a7ca7c94e232908d41df93a6b416e76146a53b490afb552124fc0c2087cc45de96390565b58f913b5dddbc55dcdd2617ea27858ae7c7748b31d832fec0fafe84594ad7b693cf972daa9521ad4134867339536ed5cdf02a758e40d5d96802f4fa"),
	})
}

func (s *drbgSuite) testHMAC106_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC106_SHA512_256_0(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7d3291d6d076d9e6b3a071290ac9ed8d361111dccc2c601c041d1fb24eb9ffe9"),
		nonce:           decodeHexString(c, "85e9cf73b7dbfe71bfdf103d465ee8e3"),
		personalization: decodeHexString(c, "4b20012ea864d2ec2f931ac12078d57a5c034f9991f01b495d9afc70fe13ea88"),
		expected:        decodeHexString(c, "7b531bbfe9176edfe963acdadde9a28f85db1a40d6e898f2764b4aed5ea67925362266ed3bce1e5c4053c011cda9e2a7c46681d15ba493fbb96c75b89907e2f7755f3db8536fe188a7c46484afed6f2f822449700644c9bdc5a24a1cc707d5d4e993f02f39718e866b8360c7e24095b918c1ca3e3f45ff3191ee80c21eec0c8d"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_1(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0e05b73a9fe19c76ae180b9c02318647b6c55cd589df8bf4c822ab8e0ddd6882"),
		nonce:           decodeHexString(c, "e6ea875f5c9b333f3acfd73c869128b6"),
		personalization: decodeHexString(c, "86f0debf8b2423693597a36f58db2c0b25a67d3b58fd9cc0597323a0121258f7"),
		expected:        decodeHexString(c, "a9a66c8f04cb50992d44d471af7718b0c79fe5d2a9fc3568757f72a94c95fc737dacee237157e6f38ec4bfbf6491e09cc1609887db5dc5a5e386b45ffcec6e8747f26023156afe6febb12e2c13237077ea24d46d7f314e1468afde13d8fdc7f9d9f8b6d11a209c1e732932a227f2a403b5a2f3e25fbb14aa088a14acf5fe7311"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_2(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "70a1f74dabd03952df7d3fc226be8ab3b3986242a889b17a596bc06e964333fe"),
		nonce:           decodeHexString(c, "facece933b1bdfbd9ea73af227480e15"),
		personalization: decodeHexString(c, "2d96a92212d66216e5a928a7453a4b13a985a8817934ed788e694a10788be77e"),
		expected:        decodeHexString(c, "ff3c9c4f19be369d3954453c0ebc0f6026913ef9e8518a553ed5909cbee6a9b2589347f77b04510a31d84f9c3578f95b0bd67c5843b0e1ac4be8179225a74c9d681490eafa0032883dc89e481043a7a315cca9a3df836fd61baa1e02d5dd02a94dfd1ad66564c46c0b61def767a8a590c6e97a4002bfbc016181741b80d429bc"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_3(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ef6ce3ccfba08d79c79dc8bb6f2f8eb10f290143511ae9b71a7326d7e4d575c9"),
		nonce:           decodeHexString(c, "771701a66a88b411c4b6459be6ab5e31"),
		personalization: decodeHexString(c, "2eed07a152d24f7ac3b76289bf9943c20e266dc2d6cf8013513d57e12c62100b"),
		expected:        decodeHexString(c, "6ebd8cca433cd07d773ff61cbcd6fdb54d6a1dfda56c818cdb49fa1028f20dcc96a16d2231f8f3d9b6656544697e91d1d06590974a430796a9d13b817bdd1446ea80bab76b45ccf8c293a4b8d359449ebfe9b71c6284d7d0c63295700b44e9c40688dff997f4662afa4a8132f33174d2111db500e629badd2275783640ac1e3c"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_4(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "641a1c607e6cc3c3af24718920a5b4c6b6d4e531175df6d3561c35f729a24534"),
		nonce:           decodeHexString(c, "6e36da6668ce4b9b3843f893f47f28f0"),
		personalization: decodeHexString(c, "471e8d2158f963c1419a402afb7b4b9f3a1872dcf1a14acaa4fd7902635bf95d"),
		expected:        decodeHexString(c, "0aeaa5bd2a6c00d13561cb185216799fd9544b867e6cca43931ce89030a5e095e4dab9f343554d344c55369801e74464d173036dae9c1ca6d94a057c49f5f39d9fd5ee193c2d36c73f9d2d33c016437f129311ff6e489761bd6b7b8c60cba9fcacdf848cdbdbdb918247746a3a7434024e1977f697c40fc128d5ba14ac0fd76b"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_5(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7122ad64a4822ee6adefedb4d337fa92d7fd48d81507b87a760d6b37a0e100e5"),
		nonce:           decodeHexString(c, "0203d0fb9f1a9ae9a44ba86b91152548"),
		personalization: decodeHexString(c, "d7bf3d8dcfaa8fbe020cb4b9a8ecadc05581c14475f933630258042454000564"),
		expected:        decodeHexString(c, "e24b2aa865c8e7f542f23f7ce2053325b1218bf9a47a306697e02699e23530754097fd8bbaba09d506f950d3e6f71810beb58c560c91d827f07dc6cf5fea6375eea833c37d60480e9430f90ec10f370d24687d5d2ae32a4245a3928ac39ad3d61989217bdcd46314235265e6584d819927030e7a051b270fe247d4b5568d829c"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_6(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f5b861b5ebcecf356bc5d2c03cfb8ba189daf6cce5a3a24f90c2f7d6d8555ed8"),
		nonce:           decodeHexString(c, "30ea5c420bfdf54b800714a0ac847c8b"),
		personalization: decodeHexString(c, "7795cb039bcf99cd86b17436ac4284cb7cf5abfd0008bc4b2f156de85e194d02"),
		expected:        decodeHexString(c, "9a58409e95ddc0e109635341b294068c9a0ea7e05a1eacd50f1d24ce82c76d715d9efcbb05afcd7c5ac67be14dd6a47c18ba346c8ba8459b2283d5f89763ce84ec8f975b800e835b18476ebeb67aafb3b5688ed5280267f3eb4e03c9e61c07d974d2704acd72d0863b0ba5d5ff30628c0f5277946693494f2d1128949375f606"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_7(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1d33127bd3f4c528e087da8bdcff8c4877a670cd2dfb174dafb9186c1e7d269f"),
		nonce:           decodeHexString(c, "cb9fdf934629bc19f888c9b059330844"),
		personalization: decodeHexString(c, "101d8e44a16f1368654c4beff891ea3a0931363492615b2c2918037d44a9cdc6"),
		expected:        decodeHexString(c, "b9c3381e5552fe02c26c4e43710be67f22f004c1a649fa216f0941958a71337c3412886129ec129cb9f6a762cf08262ab2dcb0e66451f09f989eb06a290000b0f80f347da535d7cbaab14e6df857e82e32e80196f7659404afc6c65b571c827d33520eb0755e2381ec8c09989e401ec112649cfaa0bfd67189c64a53461a86e2"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_8(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ab98afee5eb805593ea3413acaa93e6180830f97b75a3fc91b58b736be146a2a"),
		nonce:           decodeHexString(c, "806e7ffb3d81cef8a885ce3e96c0e7d5"),
		personalization: decodeHexString(c, "8e55e5cf1597bc5df1dee0861920dd53904756079f41b353b9a0b7a3f3c424a3"),
		expected:        decodeHexString(c, "b6979a7fea87ac176aa9f443830bca91cd15ffccaa66c9c8dc951c7704fd411847e57f98b556a88b3fc434ca28a32a9f3f6c1064a157aff92a8f3b2539d9b14a02707555a6310e9ed65e558dc16481e37fec86c5d8e76e2f955929fb500d5310b7925ec02b1138d3ecc03f6417bfbd08337d570d06e2ab0416c907dbff8d69ac"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_9(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c65c7861159bcfd3f41fe8deaaeefff7d72471acad0bbe1cf649213cbc714d1e"),
		nonce:           decodeHexString(c, "da7d7a885d4f2a70e6e7a63f65692617"),
		personalization: decodeHexString(c, "4a60014f03fdde58489d4c69bed27c77ac0f5954ffc8035c38ca428e7fd5ac32"),
		expected:        decodeHexString(c, "a30e5be5b7659ceba62f403e0cc4205f66eec07f573d76d06289ebd1e95ba05b397524fe09521c2b43b6ea515c56c14396c90862809233830f30ffe42737161cabe63bb506b3809f490d144822949e91ef90799c121158c3a05168d1bcaa9e0fcf66036af4fad1212b96831959b1927f34ada29fe1ed5893035fb9775a7df94b"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_10(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "dc6199df22e79756e118c614c47a9c1f04968865c23220e975fcced6055ad950"),
		nonce:           decodeHexString(c, "11106c761eefc1027b92346f87747967"),
		personalization: decodeHexString(c, "df50bbb118a5d2d90a4b6cd6e8bfcda33cb05c9d96cbd462fbe5f788f670b261"),
		expected:        decodeHexString(c, "b46bd92d1c1b066801eb2de82553ad94f349a9807f685816c63d8a2df30b7d3e64f455ad7ed6c2ea08a0efdd49edb2ce47d07f9b6e7c1f932a95c17ed41aefdf7a134f46ea8ec4bb4032bcf9d6fca6d0c5a8cd008721c24a84dc0befc273ef30baa66ab0e16010e31cbc786cb1590877b5cf966e4a4799233420ef9e25627e8a"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_11(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "03d29e87ef3a123c7badcfd46f097b4ce64451951548e738c3c2cad94578ca61"),
		nonce:           decodeHexString(c, "9d4806651f69eb9aa98d7faee7168dca"),
		personalization: decodeHexString(c, "b84ee132ff8a937fad8364d7d7ae104a1d3a5d1c372d71dc2ff66f9800c5ea1c"),
		expected:        decodeHexString(c, "b0865ff00606e9c00ea87db396b68fff02697eb73974674f301af4b25b638d49e77b585af645e1cebc0a52eccbccb97440e9557b3ab27bd35e7524169810154830ca6295dfe6c1a9e19bf742c03e091f704c98029a44140a59dd45de7a9af35c2bebab8825f053d6bb36e0e00948c91a5eaa92077b1e5e0e97721883ef1f268b"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_12(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9c551d477a9d1ae2d04b0d367db759db079cfa3fa4584e0f664715c8251ca0d6"),
		nonce:           decodeHexString(c, "56d34aac48cc7215f15912307a9bef55"),
		personalization: decodeHexString(c, "e0ef0bc324051ee3edff8f371ce45b3259d5fb90b051510b4fd97d12943e5bac"),
		expected:        decodeHexString(c, "760ff9435000c1122c31d6a9d68d94eaa10b2ea4b1f0fe1f7a8025592ce59927d39b3531410a5c677381749df30e64074cd3e9bda5d1b10484287ae603d45201944f115edbbf15383bb2867bc69822a84973d59238cad311a47e664749c96bc1f2c76e01a5738172cd51fea7bf2fd7e814f4a03763d9316e5bcac3b551e67edf"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_13(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d5a74baab8601262fc7f10f213567cff06b2e56b7c55e9a833cda5f5d0cad004"),
		nonce:           decodeHexString(c, "a961a671739d2de3bed64bdb2227066f"),
		personalization: decodeHexString(c, "5a85407652d846f446fb84071413b1d23ce2c04daf8f530e2c140074b385c15c"),
		expected:        decodeHexString(c, "d57263867580d234ec9a507a3fd44b09c749ff649e80c6990b09e5c770f088c2b56d3b2d0a0513d3cd7a917e3abbe102ade7c88b6772544971fafb4f09679659d0fc3447b43a39e6fb7f3107ef50b68980b313b364d3c9c02f8803da0c425f6e963feb5f087fa51128ca96e1ab90fc86be3fa11ee4c253ce4f4a386e734fde9f"),
	})
}

func (s *drbgSuite) TestHMAC106_SHA512_256_14(c *C) {
	s.testHMAC106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "bf2cc11cc54e247811897e1242274b4f4f52018ac60b73fe9df8972d3104de72"),
		nonce:           decodeHexString(c, "d5aa1d24b7c7564f6836f626bcc6d32b"),
		personalization: decodeHexString(c, "4ef1e00dcda9e893d066ce48cd291258a29e0a234796c30a6465079cbc3d3aa4"),
		expected:        decodeHexString(c, "43da46cb7b737ff7617715e3a8aa4c42d8cf1b62f32ea97d035514a10798f5bcaab550eab684cfbd5c8d3e1ce6d9fb026812e647ae6a50d3d8da8e9e2f1d5f7fe550e7e0b88e146925f2aa64690e1a5a5de152f6421837c15337efa80fdedb0a4754268bb83fcf0281b05b3885dc64b87f1da61b1ab219779ef44a1399b992ac"),
	})
}

func (s *drbgSuite) testHMAC108_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC108_SHA512_256_0(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "fe9b6c2334c269a392c5ed8a4ff77d06fe922fb7bf9ab4c7352aaf0de6da776d"),
		nonce:           decodeHexString(c, "fb7f12b4df9a75bdb7ed921104199b5d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ee11a047215073a239e03437b52771b10e694b7631f17e0150dda9a9691ab0a6ad81bfd769ff917a70e236b5bba1ca72619d53adcf842a4b6fe83b3e59b8f8d1a1669c817d2610c24eab7630f6f938c6730cf48d4994e60ad7c53176ca8d08c3f6469ad5f606ebd55c52eb24dff018e1fb9b56cf09142f07caea0f34f5e00b0c"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_1(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a2db33f32c048711482db06db1e5d3af17ac7426ff1fcb2701900d482bd945c0"),
		nonce:           decodeHexString(c, "b563cbeda321e919668666dc7e162a4a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c9c222e15590a4f3d82dc165433a0680eda7c23c063e4ed2caa7b86ab780c35a59e5d5225b6eea60b3a704f5ed52f8e350fb2b0bba5307c950496161b3a11df5b0eece7061bc2491ed3be81d4b0e461d8392bda2461e41e0da9d85c6ac7d15f1214b9327596e871a1f3ee556adc6b6d6fe47ba5d2aa6937e4118de8c29220e4e"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_2(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "88a069a5db6a3313256c23461393abffdbb11d3c5dcdabc7bb78edb39d1dea03"),
		nonce:           decodeHexString(c, "ff6c48c66d2e0357a72dace011d92ec0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "84d08a17413d1727443b8b72c961fa21c4f093fd657173c733a67f19066ae5d32abdf00e1456206783f4ed23c4f4928371b6faaed5149a0db3adee0ab8ecc47080249d5b3c14d90c47c543a139d372e23b1746774ba1315df9cac29350e46732b2177e59c9e0ab61e6d6b8a71b6f60a65ee9c50a35d76d2e0e434f2a693be919"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_3(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e3641e0796dc42033faf67f1e1d609c645563e76bf2bec43cc8cdaa9fc41077e"),
		nonce:           decodeHexString(c, "6f90f968df06e204469e818c9225c148"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff0a095631436e6a18f333bd44a16a1cd4080d139d4f7b76e4c1542206f32fc337c49269bad2f1151ab653a4e7eb817874de78f9ef9577aac9613dbbbc47bf0f2fc5c897dae6a3d9e7ce17a8c4ed3b2d223888bc40065f99c94d4d45320c6454fe185146be4bdd435eb5a62c65cde2fe11d876a427324d1f2cc4f4e3af528ae0"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_4(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "db7ad0ebf06ee1e9f49a7dddb8f628636816d7ac328a01079e03ccc9219b5b81"),
		nonce:           decodeHexString(c, "4a44b8905e98a49d430b181ae2c1b6dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dfb897020ccba8f056d1f47adaf9b6b888092fd5daf6fc9d10d599c4f970edd825d7c56ede6ce0a3e923dfa157b878da91777727c45d14f226ecb0603a0f0fa977c7c460bb4c5fb1c178df61f9080c9b05b1d8efeb2a54f7a3eccd4ce895a05e4c3c86e431978a1a89b0fc8f9cf26aab4366b0f7ce4f3dd4667b894662f5a265"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_5(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "92c00ef70eaa84528ace8f35c42618cd71c72e99559e41356a42c91d29160090"),
		nonce:           decodeHexString(c, "b7dacfe6a09f6bb5a588bdc50edf66c9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c0e06b14db9ebafa978370be67a59ac9075be6c3ff621747397145371ff21e5da05c30e71b6a415b41216e7351a00e00c543c112ce3a8feb1cb8fe9741c6d31ff03870a801c006e4f57d89fe4fd7b493e9778ed6e4673b0adc16d6c47da7b7cee80409cc8574a07f0ad46105e71a5e7dba1bc9f85345d517df8ec53948cce316"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_6(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "479ddf4478411867824f86b18c159054be3b48f5c655cfa7fe6da514b26bb974"),
		nonce:           decodeHexString(c, "62547d3daf0ea4647d09d40faf09f5ca"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8e24fa8cbc3011298eb6fa07445c74522aad747a7d6167b87eb06246b9656f79c1baf974b7d7aea9daac4d2264abf78dd8e5ac1050087da3d9a7a063b7466994519a3a26e4016fcb4a383798174ee81923424e372bd83a00addcb710ac4a2117e84d0502d68ab5d75d904d2e92893f46ccecfd37168fafdec026c88792b2d811"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_7(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "3f4cb58417d504cd23757e6607dd3a94e716e510617830caa1ca6b1a5e114a73"),
		nonce:           decodeHexString(c, "e6212e3bdc78a7b3f4a610a3bc3919e0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "59532f9b5d6703ccf9e1acef2cc4c6ddd4de929793bb03155f80d9e11dfa9d031fcf571003bb720b800e2f8fd0ec919c9b6aac84e4f545292cce04024e950c7cdd6b82cf2c91ff96e8486a8876d542a7b5e8c3eaeb8ec35be5014b5d481a821116c1e8d92301f18317b03dbf1334c4e5e24d4b411734f190b1e34b9da22eec02"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_8(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ce49b19e177d0dc4984611c5b9df1f9349cc10d2a7793b67b57bb95e175d10e0"),
		nonce:           decodeHexString(c, "fe1b91478f1facebf85bf51992b44f0f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4e73c6806eb381de46b6c69aa5a35c09780bb426da1a17a95dc47e4704145a28486605d9b8b3cabe7508e1c7b8374ea1ef5004152a992c1d6907c1fd6d869de68dddb79ae2deab7b99eea5064b61fff3cf2d2a5af3298fdfeb56071e054581a370ce09dc78de5790af133fba9bf01a21dd7954c3411244b2230cd85e3f1dc37a"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_9(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "be930d99ed2a925d47b90e89ebf312c9f71a3b1d615ede518c4eb9c1bc93f2ec"),
		nonce:           decodeHexString(c, "cfa1e14da2b436fc3209c9a75e451f10"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6f31186b46098ef0a750e5942031f3e0d1965d17b2e10f2544bb406e4a3b6e5794f8d06ce020a4384c11bdbdaeb6f62d5dcc98730c7e6158ab72e4bd0210c9ee2b97f2e0542c3ef4d8feea856778465d10382c6655df2c50d0718fc6d952cf5d980d9d2d9cf00a31eab2f0e8661180865590a621dcdedcf9e54d938370bddaf6"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_10(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1164a7d7f1b9d9a0598852e85c0f885689f52020035a5e93ac558d1eb85a18cb"),
		nonce:           decodeHexString(c, "d9ebee23642b2c052e342ef82c6eea20"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "51791e3d9825428ebd42c10c3f6dc092ca07d6fceec0e9548640f53e10a2d294d83d05f08d106a66f00bcd5133b11c89ae4c90bf44a31483066e810c177d977ebeafd3c89daf86514f3782ff9249fa61e7d1b1797f8993441beba0cd8509068c25bcff8bae8d9166b344ea33533137a7373b435423d2704a456a22ac8d633dd4"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_11(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e1d85c9e21dd1309460b37a5e284f38bd64b2a7adc8cb1291ad4c31d44e57f20"),
		nonce:           decodeHexString(c, "aca3b5b40fdea71cb2fa83f46ebbbf1e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5986bc351e62f8c5f3e7a8a74b264090b0238697c30667031caa494417205d464e46b8793b9b312c28c69827cff253342af64ac21567e17a42c9ab4dbd556449359f9dc3eb7e552a1d90f93b8df61d1896bcc8600085505b10a37e94316567df57bc32f484deb52a3962bdcce0344deecf7b828564e2cf3a24f5b8f346fabdac"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_12(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c400074480f73ca5f473ccd30955ab8f171b7e0ad44058143065ad787c50bee2"),
		nonce:           decodeHexString(c, "421d249079f8dae96629250123934c35"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e540caa7a63383c62625735b8fbacf538b97040b69f141154950e144ee15530f0888dde3892901a7478617ab66e80dd4f40707bc5bf91fc68fec2186ec6ef34dd4c545966fcdcd1d52506f3c6024d34d788ee72270905c3378719c0ae37e49cf3956fc3a8e88fce4e9d75222d6ee980eb4af921cb7d9d484be2e74bcf168e3df"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_13(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "65ed3ceadd308e43a496770ac71904e24f8024466d9fc2c6d754b72149a93d7f"),
		nonce:           decodeHexString(c, "64da0dd9275d2386c96e144ebff60ac1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "098ecac859110d81b02268ed8598a006d440f8897116cc336014f5bd5a02d2eb7e0d2837c1f6fb8512c1ec2daa83c7069586f87bb620ff11c19b6d4a731130b1927c9df11cf1bcabf53450667513b68e8b7c479dc689822cde4596d59b8b081cdb4e971f46d4be88f6bed69d4a2ac6c6c3a7a790acb807115dab459d69423e90"),
	})
}

func (s *drbgSuite) TestHMAC108_SHA512_256_14(c *C) {
	s.testHMAC108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d233eed6e4a43436e4418ac071bf9ec00d463d0568cfaf7b4174f96c1f6b8564"),
		nonce:           decodeHexString(c, "ea8e646e88f7fd6c8e590155df15558d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "314dca793ee1eb0dbe48bedc324b557966ac7a17b900bc4167ab4b65fe6b34ae625c200c4e21428ed258fe28b99c31cc4e8f9eb93a793c3e33fb0b75a2595a3201d939dddfa27911ad6f731894e16692343f25de291da89570a257a95cccb42f7d9820afa9b35d16664f95a2099ac929683b7480a4d1e34291853047ced3302a"),
	})
}

func (s *drbgSuite) testHMAC110_SHA512_256(c *C, data *testData) {
	s.testHMAC(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHMAC110_SHA512_256_0(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9fdfdf86578c372fb12f4a9bcd04684d97f2c0cab75a4ceb7397140a936455e6"),
		nonce:           decodeHexString(c, "e389044699da28eb6daedbd8043054f5"),
		personalization: decodeHexString(c, "a085ec7ba7eb41f226d265dadf847cc6580912c88e0c3d070ae2612c198caf4c"),
		expected:        decodeHexString(c, "aec18c76acb66a216d82b899b3a37e6ea9d7f4026e23b7412be1d911237deb73b1e786fe1f3b2466a4a779f5254ddf63b6d67aa10fe90f269ecc652ddc54a0208d26cb0ba690ccb99fdb82fc58862d59df81e53c70581d5e9f44d030f08ea7a6a5634db45a6eecef32b5b385792bc86d8c5c3f6de3f440e2db59b6c3e4c11137"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_1(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1ccb5d261c074fc9b3ed6eb695e2fceba19c6e93464e00300a7aa919c5717c07"),
		nonce:           decodeHexString(c, "5a129b9a9cd9d4cfaaf25ebbaf8da3cf"),
		personalization: decodeHexString(c, "cef872a687d7d2650aad3c493bddeaefd28bc92678380e6dd4df71fe7a087ffb"),
		expected:        decodeHexString(c, "57e8d94c5c508432992c35f0228566ffd0ccaec647f1e090e45b6be57b4c72d87d150e18e6769c1381f092e2c8fa6068611d1b673951b7617a7a6758ad6b4d75191c088f18e25373d34d40b1c27016e642ab3ab393fd25f36935d9f665f03878883ff08aebbc4664fce81d2db609357b6eea4c9536c711f95fcf7b02aac0da25"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_2(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4c03c532d19fbce23d4a0b04fd1bf6ec33fa12d1984cb2af2e0c3774b2435dcf"),
		nonce:           decodeHexString(c, "6e83bd488d911bcfe0ec66aa357808e9"),
		personalization: decodeHexString(c, "301bc9cca2d1752e2bfe0c688aa201f2873ea05f9c5c0c304d40583c090b6210"),
		expected:        decodeHexString(c, "aa0a5817c0a23543ce6fc5f2bfbff12696a02c162f21a987404d1e2766a6126e138e6b2a96ab0ac1920f9bfb53f8c8e85520760897f0039adb1a1c16747e37a9f422d01afa63ceb328659f1c754ae364bce90979dc825d81c147775ce1e48057d1837718fc3253df2381d063c879848c6f6e052aaf13a99ab3f320853b091a42"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_3(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "00b1524d7d8e35c40b64059769730ef3dcbfe07932d6b11a615c9181f168a64d"),
		nonce:           decodeHexString(c, "2d4a3c33f08ffd39204a72e9ea7bc101"),
		personalization: decodeHexString(c, "0cf08ec2cd3bcd8657dc1ec4834076a566179b33f6ba3db637f0d59a315f9448"),
		expected:        decodeHexString(c, "316c5431b53ff132a99e98665743f54c095ee43bbe741f0cf5210cbbec5de543744a5c9307106d20e5c3b12e49cec9512276aa3f3837a7b5be89b9b0324837726bd055e3b202188e8231cf4d2aa94b2bad23fdf97e2eb346ac1b5dfb1d78c21284396e246e172558d03f43529e4dda6cf36b0600d44d3de1f8def14333f066d2"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_4(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "cd3d56688cf437c7999b168573921d954eb462eca6614666c89548a95ef9e930"),
		nonce:           decodeHexString(c, "ba94b86d13b201a4df30797fd11c4b4a"),
		personalization: decodeHexString(c, "f4e5752b543c1f24711f2c7bb975c2efde94490ee0740ffb3460e3f08d866acd"),
		expected:        decodeHexString(c, "99bdff22f33c0ff01a419bf009dae223aa969ed6cc0b5f3942d2b138c989de793c060f9a08b5e0b91fba1b35ca8c5ca17a5f56d0eb8637fa691e3bc0e83e8eaa3ed682a82a8d1fc94357e236842455fa015a37bc5c689973caa5f22160373ed9abe7fb9346fcf55240cd5431938413bcdb376ca9fed0bf7adecaffa8059f98b4"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_5(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "80f85752aad0dfd7a44993e0d7fea2a5a55472e9678f0f9075d6ec17cbbd913d"),
		nonce:           decodeHexString(c, "e1d8c1d83d7e175f7b73370282a504ad"),
		personalization: decodeHexString(c, "c03ff07c165571fb5c0abe1fc853c276eba511201854111642d54c5d5b323400"),
		expected:        decodeHexString(c, "b340bbd7cee2749b30395d1bd1fb73e822f3d313fd0ff052ac38175093b0a783f773a26e8d15ba17f0ede833d15ae1ff1e5f5f47df9b749e3009becfaa1af482c67cf1a1fb3b199d5ea85ccd2ee617a909395c45b4b2dd0d414800690176a574f25b92085b6dc6b55a9207e086cbdaa09a6c2006d30cd09150fe9b341c75bfa7"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_6(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "944099bfdab971828aa58667801a65c4ca9fd85f76fc948d775ddf7e07c0b410"),
		nonce:           decodeHexString(c, "9a019a09ac7cd8075233781a3cb10e9a"),
		personalization: decodeHexString(c, "3d5069db480166847db296cad105c3ecccd9d4d0257d29b2258a1d97d4d2b50b"),
		expected:        decodeHexString(c, "d45a2c1a254fcfa5cb869f07167f6089613e70c3e1c4221cac011941e395801b0ef92acbe0c6dd4625b5b545475360d54974fef96308c66962c3fb63b26491112f7df4272f0fe1a858942d4077608f75ba37d268137169d74b9d42985b52b260599137128d6a92344691cd3a87e02df19c1d4b9230e6e61a8f554e615b0d3f5a"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_7(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c90d15bbc18763f30764f3f8da44319a5d0b705304f5f3d8aed090fadf356be2"),
		nonce:           decodeHexString(c, "6f145afbcf79452eda4c55284dab6487"),
		personalization: decodeHexString(c, "b197f0bbe7108ae12066ad85aba7c16bbd5e4ba982bae27feb5053c6b2763183"),
		expected:        decodeHexString(c, "e6a52d64c90906fa5a632897bd43da3592ce4263f3eea522abb2cecfaa230ab0bf086899e91034b8825d6948d4873893616ada207b78bdb7b2f3d85e0c2417619107008279b6d0c8d22031cad5054629fa21683b38e687a3c8fb9e4e75d424ea96bdbcd58c2338fa11075d8d7394de88b9c56fcb6f7890314faef791fa4b3472"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_8(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a248d90f95bad902bfa6978aaeef35ac6b0c394783fa5f2f69d60f9c6985edb5"),
		nonce:           decodeHexString(c, "0fbe4f5ac6ce7210bbeb767e85a5aa7f"),
		personalization: decodeHexString(c, "9792b45a2589f9eee5dcc47c9ff69ed1b1144fe28f55b721229d1afe2341c55f"),
		expected:        decodeHexString(c, "63877670656b316cc80936783c85c6aab613c66c7363f6cd34e217d6358f08479617c17c95ee572bfe60968ebb0d027e4080e32486827603b1c62f3df1c6643dc8f66aba05681254e87a34543acbf059888c910580b370e5f7e741bbbb1ce0160585d6c78cc880ef6b0418df90a99be046ee77ab83aa7d3c29d540747bf1174f"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_9(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8eb3bc188fda796926a3fa760ace26be81665b71b4a6bf8c474286af5bf5619f"),
		nonce:           decodeHexString(c, "3d1e8fa6193bd09217785c4e43ae03bd"),
		personalization: decodeHexString(c, "d6eec95d0756662ea762c57edca973393d583f6c78e8c0b4188a6154c254c067"),
		expected:        decodeHexString(c, "a0b24e9c22062dc09fe4043719f2c236091fb17cc4393616828596a5d1f317ac381967a3f6484f712cdff45a884f2b1abd68991b77c081c714e3fb703e3645dcc04f297d4d53345a59786d5b53025703d7892b93ad1be3419fdf7482d651ea9c31daa3932e548179f1ed6829e9a122f4eb2fb58a91b0d8a14d9a5881b7f20cce"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_10(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "3dc0860de27fdeb10d93dab4a29e1512a9be16800e2119128fed67d49962d970"),
		nonce:           decodeHexString(c, "a936b72f8ead41cf0a64d4aecfaf6881"),
		personalization: decodeHexString(c, "074143740c4c610701eedc3256868ddcead24cb6c43a7230f6c7e5cf864dc927"),
		expected:        decodeHexString(c, "a0793dfa61790fa40425edbdaf34aa2af679d0bbc0db95a29f9cf3d908269671f2fc79a3273b6605a7bd2be4d14e5e6f9c5277692872e07a89716b44371f1d2d58acceab7fa3dcd35480a6d8e60915110f03f1b0b1c1dce4b7fda9314cf5cd950a9f27744100936404850fdbafa674f11a0dc173630f7b15b247d702b6670858"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_11(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0af7649298924c7b03b0b0630671ee0c5bf099f18363e42d9fc2532e250967f8"),
		nonce:           decodeHexString(c, "75927ba5576ebd2b96d3edca5137f2f7"),
		personalization: decodeHexString(c, "a583fa1d0acc9d41ed708bf33a746b830d5429a9a887568dd33d5ff7b9cefa4a"),
		expected:        decodeHexString(c, "43fd478d2eeb146bb9263e3bfac7e48354375917dd9b65e4163d3a3702799fd44d76b6fb3b4e898d44448862a2e5c0738c6708685673748283ede5109a47025689f812132bf927fd66998dddbc52015a1234807d98ce161fee0f4ee49ed687eea1427c63f48ae41c03e87d882066afce08b568adba56eaf3fd9de0828fed780e"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_12(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5807ffde10a973247349fc5d30c31d1b65fe6e83fc3fab4d518a92541e370b25"),
		nonce:           decodeHexString(c, "2802a5b3bb5418e5ab8853f09138e1eb"),
		personalization: decodeHexString(c, "05d48f94ea51e6ce46294b63639286c8234de5536b9af08e6ea759ca006a4331"),
		expected:        decodeHexString(c, "35f578ea52643e3b550fad130e1abf2b2b4bb2d1c7a67b0beaf8a2db46e56548fb4ed534e3be97fb5a08f95bc0304b9625fe9598cf2256f337cd4f51769841f7fc7e00ff85e0137dd2315853eabe82c284a2daf79feb5e34ac7ea56183c4a59d8f981f15c8483be3fdf1e5b0308f330d86b0df36a36a0f46a6b4ecbb15ec7eb1"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_13(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "58a27ebb2f5f18ee96b2618939b3a321d6d1999b1ba982bf6a982b8a3f89c150"),
		nonce:           decodeHexString(c, "0af1ede5632a415b59d48d17aaa8e8da"),
		personalization: decodeHexString(c, "6fe5d697a91b5a8b7d85ee5184e454b327ec1c31705630f905b52616109523b5"),
		expected:        decodeHexString(c, "387182355689879c431524dc669735876d1216ebf7b9d854a6d140e4abee55927413f68de690502563d3c87cf3697177d208e9b4085fa0c55e865cd29f8719bcdbe243185c71c944c7dd6f1852f96368df20f64d5a5a1f7786e56c167f270301087eaf5ddc09aba8447ea5740cf0446994a5b9ce64690cdea63594da144bc76e"),
	})
}

func (s *drbgSuite) TestHMAC110_SHA512_256_14(c *C) {
	s.testHMAC110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "154ca210ca3b1b04e1145760dada6e2f19b8047344de87bfc0655ce8c82ddb64"),
		nonce:           decodeHexString(c, "4788964160bb81d6f6c2675008b05410"),
		personalization: decodeHexString(c, "c56e284ac65798010eb7bd39ffdf49bc25fc2e663e90ff93f73c97e65ea82935"),
		expected:        decodeHexString(c, "683493fb3c6ba0ae0c42009beb39fc37a9d235fb3fa00648ce4d60b4d6bdecdbaa1e2ca0c0fc80c53f6f8ceab31c3c42764b8f23c4cda91743be33e0a77fe5a4297701bdec6b2a5712e76c64bb8b7e03a257c140cd8aafef046b049303679a7904f029444d92d673107bdbf769fc1130429ff64b527b0ce2420e2c70e8998ee8"),
	})
}

func (s *drbgSuite) testHMACGenerate1_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_0(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "32c1ca125223de8de569697f92a37c67"),
		nonce:           decodeHexString(c, "72d4cc4f0544d409"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e98cc8e0f8eb84d1911c1775a5703bb"),
			decodeHexString(c, "593aa3a300e5c907a011dd5a3dcd77e2"),
		},
		expected: decodeHexString(c, "942909a9d380aa5d4e3af69093a8fa513ee545b9bf9e1b81c5f30966db3e5cb52f8b1b6fe440d592e5fe4a972c36aa498035e2442f82910c5cd095c7f4b4c7e7555c4669cca481cdfbfda167b5d6f8d5"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_1(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "172a2d24ef128dadc93e0b74f277e7c3"),
		nonce:           decodeHexString(c, "692f86e6ca5e1117"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "93b4a1fdbf9dd30996298804dd86c0f7"),
			decodeHexString(c, "69d792dc9b6fe1601f31a68e4d007187"),
		},
		expected: decodeHexString(c, "13f30b4698d6e973556c3f92dff6241bbfbde300ed58d07fd5f64efdcd0c1b62ca3de6358d505dcf972fdce20f7b891c4cab493721d80cb108fcee915835b02dea33041b38e28252c30a71fad85878e6"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_2(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4a17b8069ae3a74d77c9c94514ba90cd"),
		nonce:           decodeHexString(c, "2abfac0002d2c5da"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cc39d1a2a425f00e220d721fbfd5b6e5"),
			decodeHexString(c, "1ccee25f5868e863a05b72d744e64aeb"),
		},
		expected: decodeHexString(c, "d787b355629779ff2916397d6094f44dec06337571ccb0abf5a17b6cfabe00557894e9ddab8caafef467faa4514582b5073e7d1d9fdd6fa34c565d1aca23742ed4e87133253a9664ec085bc6c76965f4"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_3(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d60c4860d9ba3ebb64e2095231e07792"),
		nonce:           decodeHexString(c, "ba6b5e9e22e14043"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "776273bb22f5e62a793692127bcbd785"),
			decodeHexString(c, "8795e45f82160cb1096a509fd3572f92"),
		},
		expected: decodeHexString(c, "3122c1d3a6de8b25fd180b159731f975f78601360155e43f694b289822a25948d2c20a673f181be06b59c566960339f25015d2acbf5c7d3f68a2bade779e00faa24623c1313da888dc8cee901fa05573"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_4(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "494983c04581b811e0b2b846c54bd318"),
		nonce:           decodeHexString(c, "24bd70fd182558f1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "935200a7edf1e2903581fedb7c04533d"),
			decodeHexString(c, "49c0133cca2457fa7cbbd4c68cc5e78f"),
		},
		expected: decodeHexString(c, "0fd2ec47fa2e31326ee9b894fdd6224818190168640d91a2a0c247b1e27ccfa343e9370d182d95b2b5bd74b4b09c44d04094364a6fd02ba70ee2c55e04d65ad9c6da65b9c0742f9fb5ca95daafa48df1"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_5(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "77ea86ce59f2466e55ce2057e7855035"),
		nonce:           decodeHexString(c, "c09295c02f1c51cb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f36d65f22b5afd3f51e13ea38dcff555"),
			decodeHexString(c, "6b613b56e470b5c2c30c30aab9a772e1"),
		},
		expected: decodeHexString(c, "41cd8ef82609012d33b4e5b51a39ec17eda4317962627796f7845045920becd7caef56d4a2c3a8e849e299babe92367ef34a8910bebd498248ccc2b3f5f63920b31cfe856973e15e48b060871a9cf9a7"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_6(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2dffb03703023f65b757b7ee87899a14"),
		nonce:           decodeHexString(c, "a9c8ce788fb2bddc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "da42b213071252adb755a6cb24094c17"),
			decodeHexString(c, "c83fc2beb60a7ee9b374f3fb7bfc8900"),
		},
		expected: decodeHexString(c, "8f54271e3578e60e8989e49f5b426e1a0296afbfcc7da0ffbdd5dea71ec6b339b6d866bd3756ba745e42c8cddf997cac5fed72b33ac81e5f4d6f2d15f030a41c684552fc94d48c0d97323ef7eb656857"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_7(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "890e7323502313bc7d617805360d5968"),
		nonce:           decodeHexString(c, "b6c68c0280cef5ed"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "257f1f60cf2d36924c3e7b6e4cc35135"),
			decodeHexString(c, "89235cc472c6e2e1e92c70324459a9d3"),
		},
		expected: decodeHexString(c, "55283453e82662c8d92f54cb4a5d784e83b1b3527bc5e71a53f04508172eb5156ba2a9ba92116cdaceed17118c7637af4b574d364187a52cf0c20d768da518021c3d95cb5ce6bc108b1bef19bad66677"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_8(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "167ce6bad165eb640eebfece7ca6690e"),
		nonce:           decodeHexString(c, "c5c6b5f8c7fa9304"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c0e7ef13138ec4a7d52baf8592484ca0"),
			decodeHexString(c, "472a47e3fc098c7cb92fb953a26e25c6"),
		},
		expected: decodeHexString(c, "e2aa2650c84be79ec410ff9bac93e5caff8a46a8c39495856ff64c8c5399e81654ba90c8a8b26cdca2810ce68e4ab646e50a1f6fa7a829cfd72c9a61e1a0b415c031067dcd417baac9553cf7d84a7742"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_9(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6b8aeaf70460e83a124899d705dc0900"),
		nonce:           decodeHexString(c, "acd811698669fcee"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "94a53808df5ebaa7693934d7fda92b95"),
			decodeHexString(c, "4d4e7d88f44fe556c5ccdc56f8b2f098"),
		},
		expected: decodeHexString(c, "165aae6bcdd799fe325ddafce3b645900eabc87552c0bb47ee2eb6ad51462a8a4f4498c4bd24fcfc46de5d12351143d5a838060f617258c218035a4f29fb34a54673205b2e1b362991693d7b99972954"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_10(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "00f30f92bd44a9b2b04a6cae67533ed8"),
		nonce:           decodeHexString(c, "5b4ae1335b98109a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "77ec4274fe5f8f22dbb4a1ed6050811e"),
			decodeHexString(c, "ef041b6516825d51bf76d2f651a55576"),
		},
		expected: decodeHexString(c, "8c664357b01425668ea5daf07a2b5b8c50dbbd71d9f48c50f275a02b6cfc4717eb7db286fa49f17d05d44230f7d82c251a6f0fe0a2add5d2cc9a92a527f63a9bd3c8ec93e9a404e0829629c5eeb997b0"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_11(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2eafeebb58a2fb54474280112c5668d6"),
		nonce:           decodeHexString(c, "1be2aa4df98598af"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "389a36ecd687080a5d2cace8a326f03a"),
			decodeHexString(c, "495965bdbbb1bb01ba61191e9dd4b038"),
		},
		expected: decodeHexString(c, "f17db045b0af4913d79f99e018c1f726f4fe02f08477cccc0d6a068a808bfc6ccb797e6022dc3b99ea18086a56428884110c49128a51e10c15f6ecbfe0a5a1e97e72a578fefea6c66c436c91a2b6395b"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_12(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b6497197b783d1f493a6430748b45932"),
		nonce:           decodeHexString(c, "895ea2a9d8204f5d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ac26665e796d1b00951c725da88d992f"),
			decodeHexString(c, "5f08c7951106dfec5096d90097449cc2"),
		},
		expected: decodeHexString(c, "170b58ac3342a968c96aa29f1ce820debe7934d9db46216c03ae3afd304188cd38b6208e1cad5fce5c26179a30a8771015a99d2902d51899ab0c42e0b400d18f1e89411248db96f9d62b466f828de150"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_13(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4ffafd1f20dd38699bfca029c0558483"),
		nonce:           decodeHexString(c, "fbeed3cb29aa0eb8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "96abfcee883d8dcad967c071c12dde19"),
			decodeHexString(c, "9fd7cc292cd55d8364862f5fd675c08b"),
		},
		expected: decodeHexString(c, "5e8612c6ce8f5b6838a1e4fb9e14370fb2d66bc885f6fe8a3ff232f16340c2af58eb2734494e0ce920f36046b7a807f4b55caf3a45bdcaefa4bb23f352601c0769749f0257428918b931606c7b395135"),
	})
}

func (s *drbgSuite) TestHMACGenerate1_SHA1_14(c *C) {
	s.testHMACGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "89a6f070afad5ccf4d117c4e44baa2c7"),
		nonce:           decodeHexString(c, "b28941fa7e828c04"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7206a271499fb2ef9087fb8843b1ed64"),
			decodeHexString(c, "f14b17febd813294b3c4b22b7bae71b0"),
		},
		expected: decodeHexString(c, "49c35814f44b54bf13f0db52bd8a7651d060ddae0b6dde8edbeb003dbc30a7ffea1ea5b08ebe1d50b52410b972bec51fd174190671eecae201568b73deb0454194ef5c7b57b13320a0ac4dd60c04ae3b"),
	})
}

func (s *drbgSuite) testHMACGenerate3_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_0(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c27f80b1d085dd15cb163f0336d07745"),
		nonce:           decodeHexString(c, "7ecb3f32a90242f7"),
		personalization: decodeHexString(c, "4deb622a31b4c530348b5f08008fb7ee"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5a84f94804e2d04ead773d2a324b34d6"),
			decodeHexString(c, "226d9f4d720f580c2be44d4eaf2ec8db"),
		},
		expected: decodeHexString(c, "6db76a0a003a64dec6801dd3271fae8a43aa8ce2e0d205e3830e267072abe28d2a6f707494d15638559fa4282843760daa90eec5d2865ea11e836e60345160d5112445ab1754b578b55471a1d9caf275"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_1(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "517dadbd6e20fd83aeaced197732b1d5"),
		nonce:           decodeHexString(c, "ce221a60f8210685"),
		personalization: decodeHexString(c, "bd9911bc192da45c00c47d5ee079473d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "33254154ffeb4983d27ac08980ec4943"),
			decodeHexString(c, "349db52f09422883536d11ac4aaaf7ba"),
		},
		expected: decodeHexString(c, "dd7be811d3a9fdd194e8f8f18b35e1d9f1788844c371d811cb898ebc561d000cc285afc8f486dabe37d6c85e614d3d196c544ca560ac6e0337b0700e1ded8fb28903e66329afdd589308d56c50d73803"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_2(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c763149ba95e7d054da52e4d3d062872"),
		nonce:           decodeHexString(c, "53bc2f43ae7c9da0"),
		personalization: decodeHexString(c, "305d6aa3c6148a0eb2e91b9385de5903"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a36918edaf5add6f0f81d3f991ee30a1"),
			decodeHexString(c, "5c65b09e744317db86d78aaefa66af44"),
		},
		expected: decodeHexString(c, "5560d27fc55b885a29a449a1f8835966549c4956ebb0393ba9fe748e74a5a303f1478bb3e507a9daa1159dd8dd6d171bff2e3830581d7f6fdbccd91a8748d20c1d981cf909c31db6eedf5587722ac257"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_3(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b479a14d125fe4601053989439f85200"),
		nonce:           decodeHexString(c, "e198df756aff7543"),
		personalization: decodeHexString(c, "8f590670f88d8c2c713d63643f93ba55"),
		additionalInput: [2][]byte{
			decodeHexString(c, "cda7c7ee77e667b96ef0ba330c9ca6ac"),
			decodeHexString(c, "a60fd147f6cdfb408d160e388c20d8d8"),
		},
		expected: decodeHexString(c, "5f088bcebd816551c4b22c3024aeab2f75c906dc8fd0ab0c80055e0445c1dc151a06df81bd39b8535261a7a5dcedc7f9b17c062ee6f120f2099f2ab5aa93f27a08d7b5cf1027e26adf54a520916c2cb4"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_4(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bd46fc253e9334d4aa8bdff5e21c12e2"),
		nonce:           decodeHexString(c, "61515159b01a4516"),
		personalization: decodeHexString(c, "1735486e5ea8be74fa158b2fea8e5cad"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c3517d58cdbd0262655174cc1d1eb324"),
			decodeHexString(c, "404f7b8eb461d077368e2ff06ddb4189"),
		},
		expected: decodeHexString(c, "7f1cf172b67ec7c566c9e24c071b79b5a4a135a369ded5e78b8cd2467749e30c401bf176d88cc0e05a587bb2b8ed09206bb314df59009e88a01ef007e61eba2e40093aa003dada48314869c0f3b99d50"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_5(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "600a31b8f55c85ce27ece4705e6fe8cd"),
		nonce:           decodeHexString(c, "17a01e7827ec2383"),
		personalization: decodeHexString(c, "6deef06a079ad2062e77dba21fef6441"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ca5512ab329ee941b22f327fe0dad499"),
			decodeHexString(c, "c1ffc97289d8d363729daa1628a2c735"),
		},
		expected: decodeHexString(c, "a81cf5563940ffbbee9dbdcaf7db1e7e53b427fd3a0e795c35a1b8eb6f6316e43b804690a44897e0f42fbdfa8c9f1777024d2a530eda994ed038de60b90602545cef99b69f371f79619babda9360c665"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_6(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f38b0cd16e9434da916b63e8b7ce1a91"),
		nonce:           decodeHexString(c, "883ec208c3baf76d"),
		personalization: decodeHexString(c, "534799e3fe51bc370af6568072e2e579"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9520ad24a61d29716342d2b7bd35dd45"),
			decodeHexString(c, "c4e92d6da37a9f6236a396f352c53c86"),
		},
		expected: decodeHexString(c, "5dc0b3bebde5bac6d4d24ec08f1510dc88e1e06c97c3031dc9519f3392e83a09e1a7db99b2148d992a928bb5c1f68265086f7a84e697a7a0aeda4b41590606ed139063def46fa2a625657b17f18845cb"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_7(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "06a5e76d0ee90ed0206a07a914dc2079"),
		nonce:           decodeHexString(c, "6a8a2fb2c0ebbf14"),
		personalization: decodeHexString(c, "2a49312af91926a37b5f7c009e8047ef"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0cda72090ebb007ab27156957e64e7bf"),
			decodeHexString(c, "24695b221f42a5be6d4399c6444c4aa3"),
		},
		expected: decodeHexString(c, "2b0aeca45ed44ca34a2fc741c5e4e2091e115a4148e71bd8fa90588e32253ffcf360df213b48a19f6f45186b67dcef6327729ac8f3c08d658de89e71539783fb66ae834455407e7827114317299835bb"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_8(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6c12df5d2ba1f6a6e1e733baae42daaf"),
		nonce:           decodeHexString(c, "eb47cc188d1b0be0"),
		personalization: decodeHexString(c, "f510139561b292a7a1a0292b7de4b162"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f57a0c1dc69eae7473394ad1b950dc61"),
			decodeHexString(c, "9dded4779fab0c8843fa693146837689"),
		},
		expected: decodeHexString(c, "2be15d2ea87099a8c0430ba8e9451208a898379da075169568196f656eadbab59637c1f949b4506a851ae0394e135542137bd0daf1c188decfce92f6ef2396aa5bb125cf3187230ac81c3864632d9234"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_9(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0e6a7843e29e5f16d2bbb4021d6389ae"),
		nonce:           decodeHexString(c, "692298b9f62ad22d"),
		personalization: decodeHexString(c, "f0434f112699d116cfa7eddad486c544"),
		additionalInput: [2][]byte{
			decodeHexString(c, "146eb042377cdf6a0831558ac17ad971"),
			decodeHexString(c, "b29c26d483fde8489263accafc10d698"),
		},
		expected: decodeHexString(c, "ecf0812aebee7a452339071d9906709fe00fccbb0d94cc101b507646f554ebf3602459a4f20b82325b0e083ca189f59d68c5753dbe942643f07c7afcde99f9d0cc2883923cb80456fcedc535bfa7d647"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_10(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b6bc57d663b671868265fdb756e142fe"),
		nonce:           decodeHexString(c, "6da9c07dd0821c6e"),
		personalization: decodeHexString(c, "f43c5223bfe726a3164afdcabe931eb7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ddf419d8e074a4ff2daf06a1adad4bed"),
			decodeHexString(c, "e0862e71c4ac52194cd320d196e446a2"),
		},
		expected: decodeHexString(c, "4f9b9e9aab493571160c732881dc358f73a08450a152124775e559889a9298d034ce1882dd2116f4863f1524393e1a3f1aceadcd9c4163dab7c543cd375c3f4b61ed72475d1812017ac83bf22846d14c"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_11(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f5649fc184f33c63cf8484011fa27578"),
		nonce:           decodeHexString(c, "c1651fcd1a0780c6"),
		personalization: decodeHexString(c, "153f7b2c9bc9494a20ed0bf16b97ffdc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6106fd4fe0e1d894837ba8624cebbe2f"),
			decodeHexString(c, "fdc2988e6b358929645d27594fa98df8"),
		},
		expected: decodeHexString(c, "49130a750b4758e7e8dec8d82bf66ae771d51181c33cbba9d84093ee4f83f6e3aadd3f40fbcc441fcf90ed83b83c9d9671b9092907a36231ec3e2c56775c5699fce16abad104b291dd13f67ad4e1ff4d"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_12(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "fc3dfb2f29b649391437aff692076067"),
		nonce:           decodeHexString(c, "1e470ebf09e8fd68"),
		personalization: decodeHexString(c, "4e7d48fe49ecefebed749979b965d8f6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ae7405de4957947dc09fb1be2227c763"),
			decodeHexString(c, "3fa22158d9bb1948c64102f3ac00bfed"),
		},
		expected: decodeHexString(c, "ffb49be8c714b502595da9248248fb009eace24ff77d298dfe8b05efe6441352213bd236bdf4b3de34fee35b051747f4e549f69bbad8c729f3b5cf2db29a0ab6aeb590857e0f48babff3a9ea3e4079b6"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_13(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "32018afb07a6141e9a6badda9b647f65"),
		nonce:           decodeHexString(c, "0090ba3475d0149b"),
		personalization: decodeHexString(c, "fa92f66bb7a06a1652d4084c15d2f778"),
		additionalInput: [2][]byte{
			decodeHexString(c, "13c32c456c799cf0808e00c6de7efce0"),
			decodeHexString(c, "693728213798dde84176dabfb50434d5"),
		},
		expected: decodeHexString(c, "12c9d6683e6ebb5136253db60b39b3203f52607e44d13ae80709cdf2fa61ff5befb0838f544e39e135830b573ac5a31b7535c0a2502370400906658e6b1e9a0f5755f360d9bff68fa55ad628b49a8937"),
	})
}

func (s *drbgSuite) TestHMACGenerate3_SHA1_14(c *C) {
	s.testHMACGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3e325daab3301856044f416f250b6161"),
		nonce:           decodeHexString(c, "e447e63d85ca084f"),
		personalization: decodeHexString(c, "a9d2a53dbd7ef4b9150dd0ed4d002e56"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4de6c923346d7adc16bbe89b9a184a79"),
			decodeHexString(c, "9e9e3412635aec6fcfb9d00da0c49fb3"),
		},
		expected: decodeHexString(c, "48ac8646b334e7434e5f73d60a8f6741e472baabe525257b78151c20872f331c169abe25faf800991f3d0a45c65e71261be0c8e14a1a8a6df9c6a80834a4f2237e23abd750f845ccbb4a46250ab1bb63"),
	})
}

func (s *drbgSuite) testHMACGenerate5_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_0(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "84971398a188485e5b7cc7e6edaeb2d9"),
		nonce:           decodeHexString(c, "a59f89be8be20996"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4bc60fdfc7c3a681bbea21a19032f4ce"),
			decodeHexString(c, "5ab2a1abf2afd8f8d83821b35d082cd4"),
		},
		expected: decodeHexString(c, "39025bb3d8f2340a86938121fcf4f1e9ade448fb8ec99374f0071c8831d7be9f5fdc53098db5beb2dcbd9c96adb2ea2eddb0433cbe4d8786e91624917ec8588d5bf33c91dabf378e9a470410ecb6a51a"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_1(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "12b32ee74192c2bc8078e5984ae7a1bd"),
		nonce:           decodeHexString(c, "08d8504a65bae895"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c8d38b4d3965a26930d4986d3c7b21b"),
			decodeHexString(c, "a6d2d727b4075fe3176360b40115c31b"),
		},
		expected: decodeHexString(c, "1b200b444739f85ac0db8a2bebeb19ddded23d59acf0489281c4730fc48eac1beef189fe148600355dcd4138c71d3b89b1126249be6e851fd70995b9dead88b5d9df08aa7544964ecbd2dc12267a25c0"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_2(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "27ec9e41e4e109db196ecdaadeed9fa4"),
		nonce:           decodeHexString(c, "d4aa732c88c78a4e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dd4d1a94affc29b358c60c73a2ec4149"),
			decodeHexString(c, "5aba178b3078646eb594b800ef5d2a69"),
		},
		expected: decodeHexString(c, "fee36418c7cc1f48dafcb76149fb36d54541f73977c5f1b3431c1f3be1ae433b72bfcebe96ae054ce2f73185a3e44e98ae968e02e235775a04e4349c03ec7a4f910c3213a0dc4be26e7065cf5787d3aa"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_3(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ac8c43cc931afaeb75f541771b6dc7f7"),
		nonce:           decodeHexString(c, "9e0dabc22624a0bd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1976326c21cfea84d91d13cbca0373a2"),
			decodeHexString(c, "becb97721e7d6cd382af066bff11831d"),
		},
		expected: decodeHexString(c, "82640e81f53ee842182d62f4f38d8622ec69f9ec4feb9af26cb81f5ceb027b979402c5e5fecdafa2eb7b8bc08c8e895684f4bc319c8758701f3835d58fbe5a31cd7b4bdba9970fb0b17ea37d3e693fd8"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_4(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "70953edfd1f48092f958b28d86bb1790"),
		nonce:           decodeHexString(c, "0ead495965341fa0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5357e6f2a3cd2861c44462cf89b7a347"),
			decodeHexString(c, "8d97d48dd9cf537c1ca1532b554f0021"),
		},
		expected: decodeHexString(c, "1ffa8f5b68e29c3da306ea98faa4efdf5199005aa8584bfee4252534d509f883320ebaeeabd74511766ea485874b499ce539255129acc039f59cf1116a101bdc733ebf50c2d31108b3c6610e86cba975"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_5(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9eaca437bd80412cdce32f446e6fb284"),
		nonce:           decodeHexString(c, "e61d9d24d7054d2d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "86283863fa1047db98aceea176631a5d"),
			decodeHexString(c, "a8d0245c143ec7f5f1f1d09a57f48335"),
		},
		expected: decodeHexString(c, "a92b842fb7441ad1b398528a732ddab7bb15754db43efd1fed23b95100e8956785f1f7d730c87067212d87b11ee17fced34c9e69081f8a8d9a706fb16de866231284fd0be6df95320e1aa69feb98418d"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_6(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a3031414cf6d26ebe5de67fb2ef7923f"),
		nonce:           decodeHexString(c, "1fc9c1220f6e31cd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ca8cc025cea2c5331a83ecb3bce6d7c7"),
			decodeHexString(c, "d8d64e55886b34f2cd727e4a37759be1"),
		},
		expected: decodeHexString(c, "d480ffa034cdcf73e863c64dae95d2b3c49f5b449d6ce3da0758f3fcbd7aa5b4d632a74dccced921c08fd39b2df12d5b29f8d02ca3ab471de1cd5aad664892e93cc2826cf46e2d8a944d3ecd26cec814"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_7(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "729e2ff2cca01f2578e4b52c0c6fe3d3"),
		nonce:           decodeHexString(c, "4e1f920fc2c97823"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e59487da8c1725ebf3e6501196ffe63"),
			decodeHexString(c, "782f02945567c9383703607a6bb484be"),
		},
		expected: decodeHexString(c, "cbf5d87829f87a12a261da9a9aef54c493fc0471fd2bc57064af3bfd0657cf0e82541b88822a993af4cf377bd4f2f7a9d0eebf0ad7b8786434f322cda6688c4dd254dd4a450ada1a6e25c0890672384f"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_8(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "37c767d4db84fe8c88508ae9c4ab6a0b"),
		nonce:           decodeHexString(c, "b5c893789185da94"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d37210842bd501e2082f2fc318b716eb"),
			decodeHexString(c, "173992ad99c21c954e9d5299b6e53e13"),
		},
		expected: decodeHexString(c, "5e113e6668e356f07431e329922fe872511465b6442d200eb70792c8d0b75f70043f3be94bb147744cfc6a8a39df27e4892303021afa2df27bef3a63202b91c6a3854c98511c7496663fa83d32eea34b"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_9(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "17c19b32a8b2aaaaaead5b0f4c8c6304"),
		nonce:           decodeHexString(c, "1d4d16b8f8821a80"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2a5c3e50b8ab093eec5a01561434a14e"),
			decodeHexString(c, "aea9183348a707ae27f91f48a1df9cb1"),
		},
		expected: decodeHexString(c, "fcfd5181eb4d1abd5b7ef55be72fabd82ebf3c8b6f2543d8f2a843c46b9981c502add61eb90c14a905e0cc4ae4e39e9a9f354647f440ac73751d47273f67083f7c1308596fbe0865fed3819a0452024f"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_10(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f85f8411b1bce47aa600d1eb6cae91e7"),
		nonce:           decodeHexString(c, "243d5d8b79feb8b1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d3ec04f5ebcb3c19599dd38014e38b88"),
			decodeHexString(c, "67f2c2f1103632c70c41d89024ddc2cb"),
		},
		expected: decodeHexString(c, "666746eb52de69630249d484fc1cf7dfff944ba9ce4c53b637e0bbe5abda3ede79e7e9d638e0464b4e7c5f937ee26bb968aaa8f99eec60fea9dbe088e510beb1b4f2debb388e81e8e0ac4dc085ec3e4a"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_11(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b1d64019e69e9b3d31be5fe1cc2feaac"),
		nonce:           decodeHexString(c, "d091d095f6383cce"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "56c1c22ff63b2306a5d3ae30efdb020d"),
			decodeHexString(c, "09bbe719b03a8cb1183d5a5dae9fba7e"),
		},
		expected: decodeHexString(c, "d06dbd3ef365531af05b59cc63a182d41b5211d7f831635961456a8c6c6bda76651fd3aaa7c52d0167981d88e680fd08814072fec146f9d67ad415d085074dad1ab51b3254c48b08fb5f44b3641ddbc0"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_12(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "79d85a22febb793162910b9b9df5d2b1"),
		nonce:           decodeHexString(c, "2ed972839ac5eb88"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f0eedb8bb43657e4690f4f1a80d19300"),
			decodeHexString(c, "3f4f8cd7d1c92136129f463bb6e28ff1"),
		},
		expected: decodeHexString(c, "70f58a7155c36dfe0b3ff75cd004415bed6ebf58b0f5945914c4a30b4a03db1bb5ec2da66c49f3dbb3519eee2e15699c340e4ff6f555ed53c278730b49e95f6141bb0ca6d54176e816b8b0da264ef9a3"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_13(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0796e15cbc696f3677b86e88b224da53"),
		nonce:           decodeHexString(c, "b257ec44739e378f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8adaae564b20644317f1fa9b263f92c5"),
			decodeHexString(c, "3218c4a32b9dd73e865eabf014026497"),
		},
		expected: decodeHexString(c, "d4d042d00815694e28ce7aec58af1d5d7bbee38a64b1b5be258fa7495c3f8e1ecb356f0d71f3f4a064e54b718361ec773b094b0c473331d91c8e9429d66a2234fb66a2365e299d61a0c48497e8f4fbb4"),
	})
}

func (s *drbgSuite) TestHMACGenerate5_SHA1_14(c *C) {
	s.testHMACGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7a41f0155e6562e5775c72f3c4d5d7d3"),
		nonce:           decodeHexString(c, "525b6641b2641cfe"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b4894bbb6435ffeb710bf5ae440bd744"),
			decodeHexString(c, "689fb48c27983ededdd56d5a6b2c0345"),
		},
		expected: decodeHexString(c, "dfe8a9e17b938a1782fc3dba4f234dd9c9e36b67b28e1d901ca6b3628689aa4d2ae6b005ae3ce97e0d1e645da2710162294606ce51638b91e9c46d8f7f4f1a217e44c36b560f78b0541fececcf49b9b9"),
	})
}

func (s *drbgSuite) testHMACGenerate7_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_0(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2e46d1465016ed9c8e97ad09b64135b9"),
		nonce:           decodeHexString(c, "1f767a37dbe161d2"),
		personalization: decodeHexString(c, "9cf5328f3c83d9106633ef72969db870"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2cf2385a1c08820f116110ece73d5c38"),
			decodeHexString(c, "e276ba7a39aabaf7b6ac06b3e625f228"),
		},
		expected: decodeHexString(c, "a34e465c7cec4a4425e74ee9ff00afd03c38ec23cc42275a45e2b9b1688e0346c831db4e876b26ec8a0941d8822ea2493345b647f47d62f5a4a1175a68c931938c504b10bf510e84e1d1b7575ce60392"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_1(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "57a0130495639fe36ea031a4712d6f8d"),
		nonce:           decodeHexString(c, "1511d09f3c4423db"),
		personalization: decodeHexString(c, "06c68391122a4cfccfd3213e1ddd0217"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f40e72070d55cc04837b00620ea049d2"),
			decodeHexString(c, "1370babced8c74778fda2b7196a3e3be"),
		},
		expected: decodeHexString(c, "f83977567a81ba5ab9183ae22b8f74dc56600c9ceb0c356bfa538da363cd4cbd23df38209ee318a824d555627e4d92ab67f419908ce874863bd3a14175404b59ec024eb23953241d057044366ef5c92f"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_2(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "22f1aabcc1dc1bdd3ca4d543052f1ecf"),
		nonce:           decodeHexString(c, "0991d99eefc2e214"),
		personalization: decodeHexString(c, "b1da6e0615faa3a3332986e3110d7bb5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1cfae24633f47b1be98f613de4aae9b4"),
			decodeHexString(c, "acc5e271f1effb59954c59ae3c48371d"),
		},
		expected: decodeHexString(c, "9c39b50e672525f5f55cdcc5a6db5c12e0a2659b6066a0e5206c8355e5ea050e3d25d7758e4295cbbb7407ad8cafe6b18248100a7b44cf46789a8204b89e0ce61863b8f668ea1a85bb17d1fe784163b4"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_3(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b1c1c8b29339f45baa8844a836e1744a"),
		nonce:           decodeHexString(c, "330bdb95c9a75071"),
		personalization: decodeHexString(c, "005db9cba44937b96c2dd8fc2ede4f19"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e7c66f46e635ba70e13ec802eb680600"),
			decodeHexString(c, "e042426aecc7b6dacdcef259ff1cb974"),
		},
		expected: decodeHexString(c, "6268591ba5a4ea9264f2fc084ae0fcf29cc8510cdf13d1cdd6dedea38fd1233cfcab9a516fb1ea87d2be3663cccc7be45459e7250236c27b4c2ba2ad93f9b162d7a217c90d0e72367aceb2b68fef6972"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_4(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "869f7dc29af9b337707c9ba6b53c096f"),
		nonce:           decodeHexString(c, "a591976c911e9b93"),
		personalization: decodeHexString(c, "7ffe89547e750bc81c58bacc420a3d01"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d2bbfd8e2746021fb96e6f193f60d5a5"),
			decodeHexString(c, "f7e90688db62f547f9a663d0bc36a881"),
		},
		expected: decodeHexString(c, "c5131771deeeeae61e527ef451c31268ca81be89876626b7c939c5853f73bc4563c5990157baa59cbbf9bc90966ef5dff107d9dab2c728490195742e7870f9355b7f6b34e222b026ebc6f66b1cc08b2a"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_5(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0ed5f3590bdf23d6bbda155607512a46"),
		nonce:           decodeHexString(c, "0fac870d3d0d10a6"),
		personalization: decodeHexString(c, "7779c7095f0e3217148433212b514ad7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b4cf127f7694c84882a7a2bf2ad82f86"),
			decodeHexString(c, "9812e2fa754d8d84216bd8ec8590e070"),
		},
		expected: decodeHexString(c, "49c672a8b8ada4637c85ad3cc8f34ccf65ee8a52080b40ffdbe123974667716f220a6b8d4325a2233c920df62c6af9332b5fe0fb4927096fdc5fcb0582561c6a5f2c2c02a21b7f00114e37eb841fc2e0"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_6(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "45b88571f1f6a5078e8f55a64fd65cfc"),
		nonce:           decodeHexString(c, "21b460e9d18d8b0a"),
		personalization: decodeHexString(c, "5f8e745b4cfe2b389ae793dc549651c7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "60807d1ed62addf0b3b99aa193b2ae69"),
			decodeHexString(c, "7bd3ebc62ed27255e890eab9bdf1f48f"),
		},
		expected: decodeHexString(c, "f276e92a70dc952274e97b4a6f21033fe9ca3c8f6b3351e5b9bd7bdfee10fe48fdec4207ab0ba2daf748546a1b41f1885b2f5c72fe8bfebabc2070630eb4510f56155e9f56cd28f34d2a7bbd1537fd35"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_7(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "644ecaf5aa69da3b77b193e98ef39a04"),
		nonce:           decodeHexString(c, "da34725b826a7658"),
		personalization: decodeHexString(c, "b5eb33eda5ed33589fb10140d7fee099"),
		additionalInput: [2][]byte{
			decodeHexString(c, "09e5f533ddd905216fe33fb7c56b61d1"),
			decodeHexString(c, "81b42cfea57b3b23e42f9a76693fe3e9"),
		},
		expected: decodeHexString(c, "97e86cc710f4f5cb03e5647aac699fe9470daa8f466020e68aa6b6650d1e5087e60ce0327b76810baaa6b1e5588d7b64fc4601951877e6026d1f193073bef1366cf3c8e70a8dd8b4f8008c92a5dec8a9"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_8(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dada9abb0f4971c5c1729f770ea65c5b"),
		nonce:           decodeHexString(c, "a71b797960511bf1"),
		personalization: decodeHexString(c, "e2084322989327d6c7cee24debf5ec6a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5258eb6b1ac6e0d7fec82311fa25203d"),
			decodeHexString(c, "98830de1787e18f24b5ca2c06710ba88"),
		},
		expected: decodeHexString(c, "6d1f6ff3ca5784dfa4fe330a6b34176a6568d2dadb61487afd1b95e8b074804550d4fb68cd5b2a3fa418cdbe1ee4969653f30fbd535b96cdf84ea8fcdbb4eac328a046a4d31d2e1aaff732bb0a081702"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_9(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "409b34c37f4d2e5dfe0a05074c386087"),
		nonce:           decodeHexString(c, "7f73cfe2adb07794"),
		personalization: decodeHexString(c, "5de4a53e8aca5cbbab1b3066d715dcbd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9a7edf9398b24c1d31f2666b9b9d779a"),
			decodeHexString(c, "0f155315784d676aefb7f5eeb62a0949"),
		},
		expected: decodeHexString(c, "03f0404283d046fd43a2febfae41b2611fbd27676917d22bdc688d77917998175eb1d14ad63adef5aa8f5bc94a7e0cc50c31e2edff8899c8ee34abdbadc4a9472b093efa5c0414681965e52a802a0f93"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_10(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "494fdeee3c3a1cea15a6f6143ab89e7d"),
		nonce:           decodeHexString(c, "4a93f9e8a360c74e"),
		personalization: decodeHexString(c, "2b473062164ac8c4a86a6f59c476666f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "dedcf5e809deb64f31f4d3fbd8076518"),
			decodeHexString(c, "1c9726d1393c3aaf1742fb4e5fbbc869"),
		},
		expected: decodeHexString(c, "905a4f69d059fdc164a699deced281fe946aa55f7dad003e2230ac913d7deb2aef87ee37d14aa32713f4d3a080bcad96aaab08aa2a7dc4d028d9783b0e1bba64bc5a01e34e6caa52f4bb2e7652adfd6f"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_11(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c37b632eba47b37068dd1468f882a805"),
		nonce:           decodeHexString(c, "73fb2c8c738d5dce"),
		personalization: decodeHexString(c, "e8e74095cc1ae4bd3caed78c884322a3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "327d9a42a643908553dfce12419a52b4"),
			decodeHexString(c, "87cbd71021cb4a019b0ae3b069aaa860"),
		},
		expected: decodeHexString(c, "c0ffbaf2331fe683caca2dbd984c1c3d0bdebadc0d4156c85290c9fc8cd4578a6c4637ed0c7952ad0155e59c8adb824a2d9dc76410c2722f134846b31da96444973eeed9a07f6a1205dfea448bf44752"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_12(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "804d2a4a5795145a38f7a9d692b35b96"),
		nonce:           decodeHexString(c, "053f8cfb46065585"),
		personalization: decodeHexString(c, "8d57d0622ee09b751bfa6ff2c724d887"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7aa24affa982e7506b48299c566d84bd"),
			decodeHexString(c, "8f0705827ae4704cdc4519b4159d2231"),
		},
		expected: decodeHexString(c, "2a2e0e2a5567ee6aab61a6bfb17d29de3f406c3235bda1073e5ee061d0b9fc5e24a085ed5724813cfd7594730aeff3e64a2b8b0a9d40ec62f2b461b34385827fb14b8355b9fb9939d0e046e3b9824e9c"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_13(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a1a878881fe14aebf0200de12a35d42a"),
		nonce:           decodeHexString(c, "7c82be726a835f7f"),
		personalization: decodeHexString(c, "a94a268dffb62c4c2dad1f6b40bc4e52"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9a8d19dceae983564041ca7b0585ecab"),
			decodeHexString(c, "133c0dfc3586e405a0000e0ba3bbe7b6"),
		},
		expected: decodeHexString(c, "b06db3a831f7b86e423b4de951c477fee22f8cfb539362084b8aa5c1da9cd23479678f40e9419fa21e4391dc8f616907ee1851addec517fcefae47dea07b364c9d2a6592a3b43439e17d2621fd6da02f"),
	})
}

func (s *drbgSuite) TestHMACGenerate7_SHA1_14(c *C) {
	s.testHMACGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ce9057867cc50a1169569761d70aa88a"),
		nonce:           decodeHexString(c, "372c31f9ba8a99ec"),
		personalization: decodeHexString(c, "86acb354abad884d85c37bf8fb1c6a82"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ee4f3670c4671f128cbd743c408bdd1"),
			decodeHexString(c, "38f8003e8fb8c119534a2c3400a87f8d"),
		},
		expected: decodeHexString(c, "fedbb1636b83c5cc5379c9aa4d1319df6d30770e469c2f7bd65b4b74d9bc880d520e11b2c3642a7c4cb6d6138d1d92f716317dd762c0a841e56e7e0226971a7f470e918d44b4f374f9e7e3b5209516d3"),
	})
}

func (s *drbgSuite) testHMACGenerate9_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_0(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9e66c1fc6886f1a84237d721be6c92b4"),
		nonce:           decodeHexString(c, "e0db993d92e0c85a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "978a1a8a9d6c6498d3536c7b41353fc8"),
			decodeHexString(c, "24826f2c58425ddddc71d796c6a57314"),
		},
		expected: decodeHexString(c, "94a0cfacf2989cdb19873989f8e86739d5bf3afc392b7211ade4cb127e6e18a6398132bd38d5c327211a3554d24a8036cd99d50005087779c67276196578b4e35ffe11931077aede78869d1b9ff72561"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_1(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b8565f257fad8812578cd2990dfdd8c5"),
		nonce:           decodeHexString(c, "f51c7a9029855727"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3fd4c7015e0b7b306a3fba2ae8d0608e"),
			decodeHexString(c, "7e8dc861242e508b0d77f37498ee8cec"),
		},
		expected: decodeHexString(c, "14c233eb1cd922174f6cb1b82481079b8ce6d8893c3c16e7ff75c2c05e246acf45fafce47165759fdf22e88a497f3a7ae9490d0ddb70ae2a84e366bcd02ea844bf4a6e47432025326a04fea07a6a0a63"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_2(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "68d5425a0e31b17d6a9c0a86f9531aa8"),
		nonce:           decodeHexString(c, "cc68d1be9927216b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "61443cd0eade23310f8f5baf711eec1e"),
			decodeHexString(c, "c5bf53fe4c02f92bf4407272a24d4b49"),
		},
		expected: decodeHexString(c, "d5262498e9fc05359bfabede33c4f6bbe694b660568f643763e7c1b3f5a4dbddace7cf8c79bb0fb39b3c042a266c999ef5ef993bd12d20992eef2125363dc4c9277e5fe12ce58a6b371f20bb565ebe39"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_3(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0667638a456f0e259ae466b6717d9fc7"),
		nonce:           decodeHexString(c, "a56f17dc6d536a0e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9f9bf58fbddc2a46225049b3073a04bd"),
			decodeHexString(c, "6c18eddc0893e73e70656851dfc7b83f"),
		},
		expected: decodeHexString(c, "04437fb577a897b5093794845b74b29079a9ad5de13736495860d57b3a677ee228013db9f8360cdae829411a2b4b6dacb6afb74808c2409b3732e7cbf94367b2cbf02bc2f7d8808a03edc5ec08de2d6b"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_4(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "501533f7849cf3a9087ad9ffdf331490"),
		nonce:           decodeHexString(c, "aadb2ace7e079e02"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a3800ef525b3b5b3559d11ab3ae63738"),
			decodeHexString(c, "c3699b14a20e1a24cf4b4778cf3f30ba"),
		},
		expected: decodeHexString(c, "6a18c13785be673be7f08ff46ad79c13f824bf23988fc028d03d739e09ac16dc8d91fb1b242b5c610e8abb2def1d8c22cde1b70e7f59c5392d544bc0600f890835ccb58db841bad89fa8e0236fe01be6"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_5(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "486cec72c53f9cf14493ebf4e5b94bad"),
		nonce:           decodeHexString(c, "07c1fbbd5669b51e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a543305abf590408c163420e4b82044d"),
			decodeHexString(c, "5fa086f52cd1cfa6e7c791025ae3c8f3"),
		},
		expected: decodeHexString(c, "3849b7dd20676d7c994a807a5a90eea088859387632f8a9753c2fc1ce1dfa9f4f1c088898b731a29c54d571f034b96e37d8f65bae67c117213dc943cba3405d84290055b2f2d6f67d0ad60097a5c2556"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_6(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "59864fc6051992871c3cbff05df5fb78"),
		nonce:           decodeHexString(c, "adb94619e96fcaa5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf3c0c8aca346a6726ade353d3c27ec0"),
			decodeHexString(c, "c9e780c2d9af4f14c1189ea1ddf32f6f"),
		},
		expected: decodeHexString(c, "72c02fa3609040bd97a220ee02a0431d421e28fc62ab49436e28a9d6644177f06d005047a186d29962134fb677b2efced14140da676d7175b8d66c231de87e3d7bc98ad6221b27dd228a1ffd37d4c3fd"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_7(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a7320c2a974506a8f6668f7df465d5ab"),
		nonce:           decodeHexString(c, "92c5d91db0c0ecab"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fb57906891f92d0a28ccaeb989c1a605"),
			decodeHexString(c, "d193e3199c9cf3c9a06aeebbcb916039"),
		},
		expected: decodeHexString(c, "f137664231ea31fb33387e0d85d414e1162944ad7655e3892bad7e1392270defcd9326a37dbd49a2212f4efd6d8209b190ed3323cddbcdd32700b688ba785eca0b397e699ab9b38484ec27899668517e"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_8(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "aa832d6d61b476d84b305c62d70295a1"),
		nonce:           decodeHexString(c, "43fca3d2bd71625c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "03a0cd32aa84d6c0e27f534072aaaba0"),
			decodeHexString(c, "29bddfbd93bfdcfa360f2b265ca4cd33"),
		},
		expected: decodeHexString(c, "08f0a32e483f905f1d7c0e4a5379f801fc09eea908aa343cbf65092ca038a2a18fdc2e28a251af4b176904a6f6681fe90c60c7efdb9bfb2f07a18f4a8fe1d29b11e50c61e3e77cb63897f72768b70a1e"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_9(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b16199af13f67d2e1d7116d5439cbc24"),
		nonce:           decodeHexString(c, "e457f39562bf2879"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0ad042679b50df22db3524f305844eee"),
			decodeHexString(c, "db8a6bfcb4bbbcc237c2910cabf857ff"),
		},
		expected: decodeHexString(c, "081f6bb91a12784e505b6b70bbedb94d31dd1e6a536dd438507af07078fbd52a7ebc7cbb234b1d36d97fbb232c19a029b834a3bd744052a9b0684b3f54550464985a03d7b1a869cff4c4214a4eddf69c"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_10(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1a87ce827097fb2cf7f647e9d4f7e1b9"),
		nonce:           decodeHexString(c, "6653fddc19852c6c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1516c1e51382a92e4c50f79e8d15e00b"),
			decodeHexString(c, "484858b3063cfcaa96eb0a35bcd0aa5f"),
		},
		expected: decodeHexString(c, "33976057f1cee34c47b99b34f4f0c603acbd55afeb1a2af4057424084305f40ae3e66edff18a0b9c78732f0a4e75c6316145a2f6432217ed89d5c758a64d7c94c21b0ab4daf293b4bdc1c657c2a21ef7"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_11(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "816de0fa49585cc03b3dd872dd4b5e9a"),
		nonce:           decodeHexString(c, "2ec77b957f041fbd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "278b7035cbe66cbb62f6f889169b90bf"),
			decodeHexString(c, "3179734240b94ddb4ea9408c3b881634"),
		},
		expected: decodeHexString(c, "47f4293beedfee7646296823898803f64e75c1903d4adad302f52828f78f377a11197c203556a8bddcaf07052346f2f63821b4fefccd5586edb3e42c3e440d1c1d771c455b4a87387327835a90f58d29"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_12(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dfa7b352a12272e4e73e695821684529"),
		nonce:           decodeHexString(c, "03064231e58dd00a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c5068492e672a25807d99feb92c7efff"),
			decodeHexString(c, "b17b041a785c9d5d7758954df5b8eaaa"),
		},
		expected: decodeHexString(c, "039f06a342d27607b94bf72a1cb7bfc06eaf4acd27a2822105544fd4fc5611c62b93cca5f7e43de59fb1890dd7b90ec115ee6a003a316a2e320d7d67c4a2ce7767561ad0affaa5c7e43493bb96c14145"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_13(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "973b3fd4d03b1b31977850f55e0fa2bf"),
		nonce:           decodeHexString(c, "49c927702f726b90"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0a7985ff1ad019aeb2c4177399bd8ca0"),
			decodeHexString(c, "05d5f836c929ab7840b01e97d3637aa3"),
		},
		expected: decodeHexString(c, "02467667e66aef03a95114d3c97880f0d64ee98600e2332e60ecd58dd9e06844971bca4bfe65fc06e91103cf802f3a6fe6499a19696797896db585a32c1bdb5e1ade83914e6799ea41245b3162723031"),
	})
}

func (s *drbgSuite) TestHMACGenerate9_SHA1_14(c *C) {
	s.testHMACGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a6f43539adfab40674ecc38a4a3cb7f7"),
		nonce:           decodeHexString(c, "2563816402e9a386"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4eb5c1192fa86b355237b5a8bd43ebf9"),
			decodeHexString(c, "7323d1a6f983b7d16df6b0aa9d14adb4"),
		},
		expected: decodeHexString(c, "cd41a0d7371b2eeb790fa8335660385c418ba84507ba94d1d1015b3353cdcad556993c19388461fd2cce38cc9fbc00e707b18dea9d712ac0616b443b23aee8131c295a1a741ffde36b2032bdb8ae2f6f"),
	})
}

func (s *drbgSuite) testHMACGenerate11_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_0(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "395781cc8e4f9edb23827e941890bf96"),
		nonce:           decodeHexString(c, "1130d2546d7d7f90"),
		personalization: decodeHexString(c, "9b44ac5e40c0588cc281d3eacd48db0a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f5cbce8c4aefed405abbc2c230082972"),
			decodeHexString(c, "ac6eb276b884027fcf1ff10c7c1606a3"),
		},
		expected: decodeHexString(c, "be1bf64388be36f069eb5f88eb587a7a91ae6d7b2c74dfa777ab7589196110577f12ebc73c2050528befb468db93bdb4c1020068c81162154550720b8d12918ab7a37e3b371349a2e3455704070d1bf4"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_1(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "51251ac73a86df514e0c971c3e3a1fc4"),
		nonce:           decodeHexString(c, "66d581f9d0306725"),
		personalization: decodeHexString(c, "b9c4a558d71bfa722481e0c0d01c7b5a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4a38cc49b0b49c70bd7c6dc847dc536d"),
			decodeHexString(c, "4bd1dbe9d8f783eeda0bcc2de942cef8"),
		},
		expected: decodeHexString(c, "db53e4ef8c0f07fce0427e8b2a3c3189cf8de8fa9a614dd07773474b512b390df3821f7ca9eb855047cd832e35e7043560aa9d208093725f85cda4f0f011924d2fb7ba8909a4e9d1e5cc270626f7c90c"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_2(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6d4b93974bc805ff68eb614d360a04c9"),
		nonce:           decodeHexString(c, "8891f9e7a0e66398"),
		personalization: decodeHexString(c, "07c90bb88817427849cffa336a007673"),
		additionalInput: [2][]byte{
			decodeHexString(c, "97d40b4dfc4d3c2dae4745bf806c5a2a"),
			decodeHexString(c, "b6325ae18ab95627c1ca62a7bc9bd201"),
		},
		expected: decodeHexString(c, "27dac72aa66bbc55cedd8e60ef0abb091dbc8994f3dac856d0a53ed9cd37587227003d76a288a4c18e5c617b0310a3865a9bfa28b91ded5f513a833001653cda0e7e2286327bf7908f5b69370a94c021"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_3(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "09ed2b11320062b64f5efd5a32adcda5"),
		nonce:           decodeHexString(c, "a1096303faa72334"),
		personalization: decodeHexString(c, "e7fd5c4f07b9a2140aa0dc38e40433fc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8530e77b80d4fe108339503477e9db05"),
			decodeHexString(c, "1c050b08664b731c2af0a94d1885fef7"),
		},
		expected: decodeHexString(c, "de13d0810b89ad9335e99e693c5b60f7745d24755cd6686e1e8dbfe43c2fd1c92cc22afe5dd0009c07a4f2c75b669222069f2b380f24b75e3f67ede5b145956d345a00e623ca89b5148ecff5b32ac54b"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_4(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7c6ffa1a98dc40895449a2e1b52aee99"),
		nonce:           decodeHexString(c, "502fcd0d65fbc300"),
		personalization: decodeHexString(c, "da37ded34f1d122cd5f84d96e94a5743"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9bf0c256f0a6da19ceffe7fcc19bc483"),
			decodeHexString(c, "766f33235868a866a8715766ce18c2b7"),
		},
		expected: decodeHexString(c, "400b225604d672aa52bb10de6b5891418ce04f03552179a5eb9c3b715acee26d7291f3884762fc4c7e286f8fe9c88a3934e97b4d63da432b4b64dc1ed3c7990f423421b86139848a7f41b2a074de732a"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_5(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "37cfad7c080aacb7b8b128b604875c8e"),
		nonce:           decodeHexString(c, "7258f12b264dc52c"),
		personalization: decodeHexString(c, "7f4860c5c2e8cf85fd222fd94f3f62a3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "657a660856ba3fb4a4c9bc4d4ebde43b"),
			decodeHexString(c, "ebbb0370723861eb7a30ca54f66391d6"),
		},
		expected: decodeHexString(c, "39427b5d8bf7d7edb76639f44c4f7891a173d5b3733cfb18055108a7dd1616abf2e1fcaed08e905073c5561f6f1a652ab073d51c48733ab1897b82231e49068f827a239d5420c0db93603fe5b25b47bd"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_6(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7cb29063e19682699f43e0692706ee6f"),
		nonce:           decodeHexString(c, "5eed287eaba2a9ed"),
		personalization: decodeHexString(c, "c7bf51ea250d877be79ee40a2b307da0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "72bb22bd9c69291a2f4c808ae932990a"),
			decodeHexString(c, "99927fa92f19b363eace031005fd5ac1"),
		},
		expected: decodeHexString(c, "c356ad9937bf66cf1f89964ebb7ee56ce2b6b2485d01762f5cafd10dbcee20470991d5b71797459e74e39a7429f8e7662ae9428f6ff0c1569a478a2f8b792e3da4ae5efcfd39b5ae5c3036aa6bf33751"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_7(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1429a31cca0e5208f7f5f137970c77ef"),
		nonce:           decodeHexString(c, "58b2e384bb27eb26"),
		personalization: decodeHexString(c, "102c8946a835168f063cfabbcd9cbdbb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "955c8883d259660f51eea217c7a5644f"),
			decodeHexString(c, "699dd0c00f8115de647a0cd9622cf8f2"),
		},
		expected: decodeHexString(c, "9582eaab608ec13f000c8446e9beb4ee8afd740b5e1c84760ee66f03867f92545ec3cd4e363e3b9e7775790f9d4c827e6095a1569d55ce744e654da3c4257dd518bd5b362fcd119827a10ee893f92530"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_8(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "851e7b2cfee37e3aab673d4783fbd34d"),
		nonce:           decodeHexString(c, "b68ec7489b72f146"),
		personalization: decodeHexString(c, "a508efaa12a0852bc2ee6ff247445fdc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c014eea6b2a6f6cb3c95a5a3d750909f"),
			decodeHexString(c, "fa1f383fa97e4fbc7149f41cbb8b322e"),
		},
		expected: decodeHexString(c, "3bd8d7f5eeacb31423bcd15165783b065eb5ed222cd2b949836d08cf3315b31bdfbf88044d55a2bd201e6b55c3518c16bf5f50c31fd4f5d2292927816dc40cb07796508c41142d9d13ebe924154f0b23"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_9(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "493f87823d37b2de87999a6f8d81e624"),
		nonce:           decodeHexString(c, "bfb6fcee09aa1056"),
		personalization: decodeHexString(c, "70f7bd3167c5e5146050ee5d2cc2037e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "07ca42e34252d6ada280eb2e97d7fd93"),
			decodeHexString(c, "1df64e42fe23b9c04721757425bb4670"),
		},
		expected: decodeHexString(c, "f62e9c9486d469181951fca12454ad31a691fc8d0efb8857787be2cfa619dd161fffa204b5a56638c6751a32f56fe874f8e97ce268daff078fbafb3b5aa324f117d8f4866a91ff25a0729d4d98a7838e"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_10(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d8f78f44dab7ad3ba201244355622a4b"),
		nonce:           decodeHexString(c, "088cc74e5a96cc2b"),
		personalization: decodeHexString(c, "8589f76f13989e12871aebe6e781b377"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4de39d14e5c2155c0f5edd635819049c"),
			decodeHexString(c, "8668158ff1d7d950435a42cf93216a8d"),
		},
		expected: decodeHexString(c, "46f450014b594168eac0a023252525d8b3d04275b5b8c32eb764a094a339aeda594993a96803bde46161ab79c72278b01b63b687de2ef15b1cb7030caf5255e0a3635b50e3e966649e80fc6bcda7a3e4"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_11(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "86922b8bb0b3a05c39585114f99b0ac4"),
		nonce:           decodeHexString(c, "0d9a57a72bf85bb6"),
		personalization: decodeHexString(c, "75d62935b7ea694429fb34a5cc493889"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8e387a9195b09a62fc5274478594d989"),
			decodeHexString(c, "32b7b72e48d31db05f063fe70753fa2e"),
		},
		expected: decodeHexString(c, "4bc46578da450e26f0125500f9798ad50509820e8e534ea61089062c3c8f6026048ffda5677546549ee218f86d2a4bc0ea0ceacf21e0f090144f412c36f70acbe785f38f5a80078dbca1410a0a180c50"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_12(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5fdd8bbe36190c6b0dbc1299ac97ebdf"),
		nonce:           decodeHexString(c, "b81e2cc176e4dc49"),
		personalization: decodeHexString(c, "f629c8f6f55820ba33deefae6c155ccb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "87a216dc0dc9e4e976272d045e2a0150"),
			decodeHexString(c, "6115f3da6224d53b35bd0ce21974cf75"),
		},
		expected: decodeHexString(c, "7634ffdc8fe0b0e474506fc16c7c04e0dbaa72557082a40b2a13b2cd371a2d288ab09de3a9db5dac4b3a86d854db4811d1e9403bd5ee17ad64d4327964ac4eddbb3ccd3ac98e46f0aeef618da11cac87"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_13(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a618e67dd74626b8009054f325839902"),
		nonce:           decodeHexString(c, "fed41d27a6e16b0c"),
		personalization: decodeHexString(c, "ca0ae9a874b49faf09cdc1a061e76105"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8dbf94e1a5537658cdb89fe0fc64738a"),
			decodeHexString(c, "24e28c7c07398a04a356bb2c3b51ec34"),
		},
		expected: decodeHexString(c, "d198c5c3f2698cc86204f0fe160b1a125275f0af472c3161c79a523dd86f585baf2acbed3be454780697a2eac6370b173ade6363735541dbb5e9e318504668f2bc7c09f467988cad5fbc88ab657f963d"),
	})
}

func (s *drbgSuite) TestHMACGenerate11_SHA1_14(c *C) {
	s.testHMACGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "cb4556568f9f296ba5eab8ec24144a6b"),
		nonce:           decodeHexString(c, "f906b9309da2dca3"),
		personalization: decodeHexString(c, "dce3e4ba41a0827085a6956f66e389e7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d56ade0d74ea34577eb12a899d18d382"),
			decodeHexString(c, "ea83bdba8490ffd136def5f7d9240c59"),
		},
		expected: decodeHexString(c, "cd3d8174d8af97387ff02707d2757ce685ffb5d8dd91d95b8af4a3a757f9321b0e908096cd1321de0599640b7d81f43606b12e029ae158ed568ce1db429be75285c655e15f88da859f09b4cd843a0b61"),
	})
}

func (s *drbgSuite) testHMACGenerate13_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_0(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1d4ff3bddee2a714e2a360cdeb64bb81"),
		nonce:           decodeHexString(c, "70eb607f343c614c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "85b2444cef46740218775311718b3bc4"),
			decodeHexString(c, "03af762e2412050770648c20535a413e"),
		},
		expected: decodeHexString(c, "7061cebe3a4628b9ed38b87d5e693c7e7edf3e275a47f302f09dc8e1f04431fe44a386066eef4bce5b21caefd28f572f8cceeefd288514e7691f6507ab2641984763b08a24b4635f58682f4490d8acc6"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_1(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d732557a454b388415b9a9bcc97ea588"),
		nonce:           decodeHexString(c, "241255a5fd2c4e19"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "03d8f3bd8d1969b1ff66d2d648f03cfc"),
			decodeHexString(c, "b758cef73f14363647aaadce56c13cbe"),
		},
		expected: decodeHexString(c, "0e99118cdcf7b2ac91f4f2fe09bf9dc067b3a3c1d7353afd903d7918930b4bbc45101bb9852384388b86c14032e26b9bb5831e303664836c6301119748faed7b6cd55a7f88da95ac65d385d956de4301"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_2(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f23f9cec6dc5a4460ce9c8ac25726bfe"),
		nonce:           decodeHexString(c, "160659bfe9c598b3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a24e4bfb8a46c466bccdc832c98587d3"),
			decodeHexString(c, "0fdd6412f7131f0f1e5d1d352d788876"),
		},
		expected: decodeHexString(c, "ebe388231f9b7808269810919c6cbabda7daebecf25d23ce931b68a51612a489ec5549783cbc321b302edfd2fc5788f2c334ed6281929bc8206d4f2717b427a3cb2b409c19c9ce3884f6d50086bba7a9"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_3(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "94188299f1039810c304cf0a549d1e70"),
		nonce:           decodeHexString(c, "c1da4789a61ea63d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "17a3d30cf18a4c0e8f6211fc27e056b5"),
			decodeHexString(c, "3f06d3496243b3bc8c776fbcd6285d5e"),
		},
		expected: decodeHexString(c, "f01f922b83266f8b1c96121df16c39d80b55e9e7d5308fb714a6d600b26ebec69c642ba019ec163603b0010e0ee1ab1bb4a30085dde7917c7f07ffb5a844faa6de7939e58f844becb4dc4716e32eeb3f"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_4(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "89d9ecdd493901d7700b70f4fba5c817"),
		nonce:           decodeHexString(c, "93116eb0f3df7247"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7dd119c797812c5085d7092f0167b6d7"),
			decodeHexString(c, "29d0ea4b1b9301e192586282bbec3f03"),
		},
		expected: decodeHexString(c, "94c588f3d4aa3f2453f0a9e63a7edf0a94ce46d12127e1e27dc166eedf21150b4cfbaf80407d2ab935374a3acb6e5f75de2e04bddce90ff225b2fcd373f4f6b4d076bdd552eaf3a96fab871fb526a4c4"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_5(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d020eb4b0478746c5804c68227b60814"),
		nonce:           decodeHexString(c, "844dd4f7ac813181"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a8d4605e66ce047b44f0a76d919ab5bf"),
			decodeHexString(c, "06d226f23ac745ab70be56e74bf16b89"),
		},
		expected: decodeHexString(c, "4ccea9f3451410865736c8f39de05962c0885184b4c71440a1e100d30eba1a925a6ddd1704c386bccb2f0aa1f77e5c0b2e9699a3b53bce23adb3021336a2072fce0e474a10f2cb830bf4dc233296fff0"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_6(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "87311cd6d41577311776791af27dc2ba"),
		nonce:           decodeHexString(c, "eccaad0013620831"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cdf6407aad1625c62b065aed10ebcc29"),
			decodeHexString(c, "a5141fb50a2e115a2a2686fdfc5b25ed"),
		},
		expected: decodeHexString(c, "e601d837d8cf49023bcacc62f634f21bcb55550c9b8d55f15393c35204f4595ac2e3d260f20e134502bcf302ad47e4d8403688331eb6c521e899fd74692ee898dc8cbf69fa51630908198e09acff2f0d"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_7(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "04fa2f6a61d05de96dad12574b087146"),
		nonce:           decodeHexString(c, "de7f002889d01f48"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d6597fc82de2ecd3380caca446d7e3d2"),
			decodeHexString(c, "47e9a32664362d236869a12476572b43"),
		},
		expected: decodeHexString(c, "ff4a17a93948653b824349d62497b8ad72f67c5739a83e2ec0172e3d45fa5abad453107fc6b9c1ba7e4bd4e1ef463515bbccc713401df29b59163b452a6467d0a5fc74cd36b7e49a74d1544705cf4b0d"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_8(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "88ff89c822ad204be55f50929dabeefd"),
		nonce:           decodeHexString(c, "c571e9d7a8a8137e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb80c92547056ffb54dab764078b0929"),
			decodeHexString(c, "b41b013e9df8aa75d473509f12767bd6"),
		},
		expected: decodeHexString(c, "c0164827454fd6a46e2877365cb5b192f1a3b2620d0ac4651921f826c99b7ef1e4559bf7210fdd23c278f13f8796de7c2991336bc1beb66278b93a76927a283eef4096cfb326493f7bee4d61f2906e8c"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_9(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7082d4d2d49d5efe4c9e8fc04d3bdb42"),
		nonce:           decodeHexString(c, "2a091022cfe39827"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1893242827d291f3ea31cee285881aea"),
			decodeHexString(c, "cea09fb6617b651665969773bc5ae2f7"),
		},
		expected: decodeHexString(c, "6a7e1e8dca50262bb55902cbaac9ad59d4b48da16cc19b21a2263d997b907dbfc40982037da336ca28cf0a688b954c49bfd7671562a9e96a2aa38d8bf5a0cdb36fdc2fac5a665fc43ae1ce6beedef783"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_10(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eacbfb8680be1198807a5bf035b477d8"),
		nonce:           decodeHexString(c, "d8618a289b4c1787"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a262ae1dc1dbcc02911966c1566a3ceb"),
			decodeHexString(c, "ed8af1b6720b9ae9b986ce20ea8de984"),
		},
		expected: decodeHexString(c, "0c89041374d951a0f1dc8b9250e746077e385f667cfee92beba7f5e4bb212d046180359738e1a22c095f89cc978e33d9ffcd5ff496c2a45123c47a092ff4c8528d693a78e0c7bf551bc0bb7bb7b686ef"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_11(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8013306edc8c1d6ce26f6ce87956549c"),
		nonce:           decodeHexString(c, "dc4425101b785a46"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b717ce62a16e4d6d7c90c1229b9ba46e"),
			decodeHexString(c, "fca6f456fe7ebe27dcebabde41578f93"),
		},
		expected: decodeHexString(c, "6635f4cf9b477e962efd6d2fcfc89ca0f99c964fdc179b3df576afdf4699fdbd67d420fe3729f31d91da4c75c42ae95ef0acd64be3e62e9efd3587b546d7c6af9a766698d899abb0afc2bd1526856214"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_12(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f8e7e522ad80fcd885d96ffbdedd340e"),
		nonce:           decodeHexString(c, "b42c724936e6a73c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8d935a10ac6cb721195989cc1c2275f3"),
			decodeHexString(c, "49c840a81aebd952abd28074f0391bc3"),
		},
		expected: decodeHexString(c, "5dc34245a9dfe5352e8558c6b5ee8981d944c099cdd7a390287679e55d77a0855ea3977a63471c25a085b84663bcbffc646f723185d22a59cc19ae1f5a0eebcb57244bad8086af5e00c2f64b2d0f9b12"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_13(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c086baf5e2e28621e14bdcf66455f4f7"),
		nonce:           decodeHexString(c, "73b45761be4c62d5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f99b75aabfee784ad4ead7ba30fc3339"),
			decodeHexString(c, "7f61cc8a39a51e8c13df50933875a117"),
		},
		expected: decodeHexString(c, "402ccd84d20d1d5feeaa9f0c0a216751d1d1633a986537e557bdfbd0125443c22c9a5acda5373e8c14d2c918c591259fb1bf35145bcb55135fe8ffb3fb21d5bbfa8dc4434fce3b3a676aa57a5f949f0c"),
	})
}

func (s *drbgSuite) TestHMACGenerate13_SHA1_14(c *C) {
	s.testHMACGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f4462d503ad505e0f39fc5faf4243d03"),
		nonce:           decodeHexString(c, "b0a135635aa32174"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b180d77e0ef217268d2d4dc9d4a9532f"),
			decodeHexString(c, "b192957f3e98f7595768d00834eee1d9"),
		},
		expected: decodeHexString(c, "7d4791ccae7980ad19e5d8eb8932ea8ea1756710349ab8b771558cfe471a278dcc263b737486179a4ffad12d5311d23912c3a46f07152808d288be2dfd2b315fc4f6df6418029be52daed643dd3c6110"),
	})
}

func (s *drbgSuite) testHMACGenerate15_SHA1(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_0(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ecdf8b8636add7acec544cd3ed61449d"),
		nonce:           decodeHexString(c, "fd08166fb3edaa55"),
		personalization: decodeHexString(c, "c6cfae798639034096d373fb05e7ea66"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3ced5b730332278cdffe927b09fa8386"),
			decodeHexString(c, "5f957a87c8945af77daccf356cf1183f"),
		},
		expected: decodeHexString(c, "2ff3e68a48fdb0a5384287a0cc4e6efb6568309ddd9411838c5fb61cbf916cc881b1cf0461fd7631d313225fa42c70d529b59319767cb50f794f4c790da2e188fc252c16ee0ff72fd35d2392cda0163a"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_1(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f08fc58f52ea05607dac4fab29c03faa"),
		nonce:           decodeHexString(c, "f81b8500f163bc87"),
		personalization: decodeHexString(c, "2019786852dde5df70af52ef4ae45adb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ff0b7bf79fe5215f8cd77b53425e8a73"),
			decodeHexString(c, "ae98464126b1d6fcb005b9c302653a00"),
		},
		expected: decodeHexString(c, "3ad0f37b5bb09fae80e7aaca91b92a37c04a177c5ff35593812567193c7615f65db70bf48d4dcb067c80532df8b91db8ceb7f956acc69c499ddfed76ca28e0612936975a3db82877f531a496740b4463"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_2(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "55a0511c439c7d2bf57f24e72631bac0"),
		nonce:           decodeHexString(c, "a1902df77b611e46"),
		personalization: decodeHexString(c, "b5ff703e5ee561ade96d6ec9cb852399"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c46d91c9174927f3910cc2a6bf7b136"),
			decodeHexString(c, "c342c914786b86985d06f97eca1b09eb"),
		},
		expected: decodeHexString(c, "995acb5a585073cac82d5397c2dc6f32864a4a55284f57acd0aa008fcdfc533859a34fdca12b5eadf0ebb88692045521a4b003be7d382e9c2df8ef5cd6f7b86c75f6bda74c99c07d2bbf8255eb018953"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_3(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f0e444a5c5bccd92b7a4447d0b7a8f33"),
		nonce:           decodeHexString(c, "6ad11519797af228"),
		personalization: decodeHexString(c, "31ec61272a7de660fbe54b3d813ab02a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "84f648d11fdd386dbb9f356d5ff6396d"),
			decodeHexString(c, "7bac281eecd8ea9fc440520fcfac3d6c"),
		},
		expected: decodeHexString(c, "21f5863c744843eae2582e2496e8187d2a1283553f4ec2af652af79fcdd46eeb559b82e0b8aa8e1ca482d20d7875473a90417d1a1331f7ec2ae61c7e51369c48833bfc3c42c48acc84c92bb49fcd9c6f"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_4(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c9bcfae1f6183ef17bd28430ddf76f7b"),
		nonce:           decodeHexString(c, "c4c17b0222afce01"),
		personalization: decodeHexString(c, "623a8f3be2ab7af2a27a1731e6d78c29"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b9ca73212f96d6530e276f773cd9ddc4"),
			decodeHexString(c, "1fa9dbcf819c2000556786452999d3f0"),
		},
		expected: decodeHexString(c, "ef2483673e7fa559e948f68c7ee44010f915d2ab416f62caba7ea7032091ad5ac52164039ad95517202e3451007c39f73b457cbac320cc1f23cdd247301f02163366de26b32932606d346057fe20a917"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_5(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "581594493c98a498afd58188a8dccce7"),
		nonce:           decodeHexString(c, "ff37dbee91e5833a"),
		personalization: decodeHexString(c, "105f07329f1be889302ce0ab97e2359f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fe21bb1d9100ea6e5c7f86019ce933a6"),
			decodeHexString(c, "a9d96cbd83d7d2252da3db8b58747396"),
		},
		expected: decodeHexString(c, "008c173739751c8a06e4ddd0dafd5b39feb7942e24a0331b4dbfe598dff251636f49d92017e67badefc308a16f319803a1e4567cb55f92f6bb28d3b7a50f289f6c2a46b548821b6891fab108a3ca3109"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_6(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "50173e83a2a00f28ab36a062e11279c6"),
		nonce:           decodeHexString(c, "37a896dc2ce1ea66"),
		personalization: decodeHexString(c, "0cef11cf404712fc16d3ceef337082cd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6b385190658328bdc12bde2ca1a58669"),
			decodeHexString(c, "67e68c79b41343075aabc236ad81d13e"),
		},
		expected: decodeHexString(c, "98d4ac286364d8b0065d85884a92abbec558accd791c1508899f99da1d810833e1de6db45a638996fb0f4b74628fefd7544c5d032fcd459509092543c4986f4b47ee9c3aba4ccca7d146d9407c13301b"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_7(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "44b537973561a17adf0704ccfd896b8b"),
		nonce:           decodeHexString(c, "12118c2a2a398be3"),
		personalization: decodeHexString(c, "1964328cc10a307a3a841a916ef8a14b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "814873646eaf96fb3fb8b41fda381c79"),
			decodeHexString(c, "5b81c9a952f49b753890889c9c41917f"),
		},
		expected: decodeHexString(c, "58ddf616ac8d74e9e476e2232d2a4f1d20d3c1fe805fc9ddfc86b69189b505797e9c376221e9f4754fd18e45c27a291747513b6867565048d47ac9180ee4aa0695a2309bde567578d4c28cc2fd2a1db8"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_8(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f43834731514c5f2c376092325d2775a"),
		nonce:           decodeHexString(c, "dec7fa004bf80241"),
		personalization: decodeHexString(c, "79c27089f8b37eea234ae0520a9132bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5b6ee749feba913358c399f1f8892f75"),
			decodeHexString(c, "03c9f312da912ac95336867614978cb1"),
		},
		expected: decodeHexString(c, "4d02077441e5d123e279ea243aa8b38dea676280d30400dac7eaaebd0affd2b7380046e8db3b0ce68f5f2ab4f90cf3b476039e4063911e3e2e7046ee64175d919d729edacffe30cae6237948546ae4a8"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_9(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "024254d5e87006bf6950699b2d4890a8"),
		nonce:           decodeHexString(c, "06bd45e54f2b997f"),
		personalization: decodeHexString(c, "05d97e092abf630c1caee2efd85cf0c5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d16a5458f1adaf690b45c828904c2b6a"),
			decodeHexString(c, "ce4976405ef50a48b89b6f43985220f0"),
		},
		expected: decodeHexString(c, "4eacd1c4c49b44e6116e027fe47eebb840f1602782449b57b111ed937c763f7a782ae1350140614df4ac6c53e9aca11897220d4c297df616c4825dc58f157866d0caf6e56886e5707f69d0e9000f1091"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_10(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8c5454259ca8aef362e8efa35c9f3b11"),
		nonce:           decodeHexString(c, "728a4ee0d2128440"),
		personalization: decodeHexString(c, "2667a9d636da6351e40948668673f4c1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "203012453323970b3b91444d6c7102ca"),
			decodeHexString(c, "4efadb9ae54fbba80cf2efb590d810ab"),
		},
		expected: decodeHexString(c, "6f2df271c1c1949e9fe6b7ecab9efe02ee816fa3b09e93bdbf7ff4a8a19b98f4bf91c5aa483ccadd69347c5c582ca7e24b533d0bc40df5b831b9ef0b211317c6574f7943e713ba262649e7561e6c6386"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_11(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4010ede8d2e7d59cf74716df74616054"),
		nonce:           decodeHexString(c, "ac406a56911da77e"),
		personalization: decodeHexString(c, "0af27561cce5f5f1550b7075a6342ead"),
		additionalInput: [2][]byte{
			decodeHexString(c, "145981d2453db5b43ab3624865099307"),
			decodeHexString(c, "f9fb41d07ef241b1aaad338698413116"),
		},
		expected: decodeHexString(c, "22689fc95dc99c3204c9c78470c6db6817ce7e0f868ba59f787fa6d599d592e1b171bea843802931902c537ecd2df73c3dfd0e73435d702284a8da1e82d15c79c06d421c99bc2e309f237249dad8065a"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_12(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0bfd37c2065b641164f4336580653ab1"),
		nonce:           decodeHexString(c, "9450667d44ecf118"),
		personalization: decodeHexString(c, "94ed9615c421287d3ea4df7fa35b53f7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d7a3b4ade238820a17ac17dd0605b85c"),
			decodeHexString(c, "92b78f69065b1378c6995d5108361c21"),
		},
		expected: decodeHexString(c, "e78e815006a80ad1ff8b30fa0da3fba6a44c1dacf37ccec85f930379882589a327b041bb794238356b791492f2ccf13c3d266984dcfd49bb1957bf3fd247aae6815094115ad195056289f1e6d1566bf9"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_13(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "086a5ed9fb52ec937c8d811a6d628ed6"),
		nonce:           decodeHexString(c, "da42ea961c3122f4"),
		personalization: decodeHexString(c, "24068772d8c4e0448dd4709cd65125dc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5da50f9d3b7bd02faf4a6dfc909f36ab"),
			decodeHexString(c, "7fb0214a9b6646c07283091d41cbd730"),
		},
		expected: decodeHexString(c, "47b6bcf1cc3e206096cff1d4def748aaa803c0910602dba2bdd19afaf1d2a9c49e9e464fb36864d67802caaa470685bcecc229bb0402b99122005cdf28acdab4bdef9e1d23f97d6da6c88ddecf037c70"),
	})
}

func (s *drbgSuite) TestHMACGenerate15_SHA1_14(c *C) {
	s.testHMACGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3f87d9e1951d8d9df7733a6cf1b3471a"),
		nonce:           decodeHexString(c, "5dfe594ad6c10325"),
		personalization: decodeHexString(c, "673abaf005b0ca394f8de8d040aa4728"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c9a1481cd25c537ba57750d594afd25f"),
			decodeHexString(c, "51e29804f9d079f3074ec398320b2a70"),
		},
		expected: decodeHexString(c, "cb3cd4510de88f8081d8989c2679f76387b7d2cda286b75d659a3ab7c3b2ac77ea00366e7531c1c9f4f8e60c845c5d2a5e05fc999621d011deac3f28cb447a37c2ee815f7f5be3a571d153475d6497a3"),
	})
}

func (s *drbgSuite) testHMACGenerate17_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_0(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c5c89c26ac4ca8b1106ba90a8ef4d6d687dfd88743caa5fb"),
		nonce:           decodeHexString(c, "afa4745d9c1f8371120b10c8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d3483ae5f9ed97efd3f852e4a6f20f25c947a03f39a4b75c"),
			decodeHexString(c, "2cd523c5958cdf403caa61abe5c4739cdb9d40152f0e769a"),
		},
		expected: decodeHexString(c, "1fef4e6abc2778d1c3e3ce00fdb5eae1ebebdd5cff0a7087644c8565d1e8b876b2c05264ca81498468851fc7b9e5a2163a06f377d2ed754c095adc59dc015a77edd69e4eecbe48d9dc127eedfff5cc73ae38127ae3a518fe7fa5abd1a9c53eeaf144420873341e2efa3d81493c69b04e"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_1(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6860e44bf582db9818ffbe4c699d4218965c29f463d7a02f"),
		nonce:           decodeHexString(c, "e1f36c8442b0a5d103def7a2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e9f598357109e2a532dc980388b8a5991256166d67c3bc01"),
			decodeHexString(c, "58ebbf7402be041724701e5c0132abe604c11a62a9de1d2f"),
		},
		expected: decodeHexString(c, "52fad34b27113c146595a6740f505bc2d3edf6618975cb9c4a5155788eaf08b96d232610d9b4ee06264fd92f319df5a52b8f9e31b016a6c21d27d31d9d42bbb7588a7142f26ece3ddf211c8cf4530947adee302aa71c0d7fe9060c1b25f1c1f2e053598a7fb72c4db55fb1b02352d60a"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_2(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "27b9f78ae07821f2b5625c8fc3a03ceec4fc8062be860c2d"),
		nonce:           decodeHexString(c, "b20403dd88a8751dcad56158"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1b6c848fce706abd73612dd3fd421c1c7ce9f4c2d0ecc670"),
			decodeHexString(c, "14a43645c1b6ae394f795af6ca2e9084e7e707f3f2cedd7a"),
		},
		expected: decodeHexString(c, "33c592017af545b3a9cf3419ce1c604e9c7c687ebf6418fbef47ec96e61f1951068eec9b60005d24574313f04ffc16c30872ec83e41e248e3d5c6951930d6a88b8931d5502d1142ce50676b3adf48453d1a008189658db8511d19a06ac97b4d5cfac19b54e8e6b899d501715f401ef85"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_3(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8d7cf5c2e360ef755c1e9f5b7a44a1e29f09cee7ca44e159"),
		nonce:           decodeHexString(c, "25ffe9a47b2d55fd7750b356"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0e691c9a435939c615f0686eae88e090ba5c4b3f5e6e00c0"),
			decodeHexString(c, "1e3a452295617e5a9e6f78256d2781feeb3812753b4aad9a"),
		},
		expected: decodeHexString(c, "a307569d8adf3f7e6ee4567a5b2bd338badb9234e7b27c92429ffa75e4c56c0529fdc6c15df5d47c46e3d2eeadcf1b9e93a5dd6cde99a82f04b0d97f7a3bfd05c0e1d8370987222310ab18c980ce48b2679361c3d9011dd355a9b06337c054ee37913d5f4dd30d1fc942cd733a0fa5f8"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_4(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1a0d2c734918c539c1b306a464eb6b54f92e958e8636032a"),
		nonce:           decodeHexString(c, "ec23ba8ae817bec48384461f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b8ad9e613a891fd0db89571fddda77827382e406cd3cdf7e"),
			decodeHexString(c, "1e172a708aa4ffa3618ff0d7b1f9ba341f4811507851dfb4"),
		},
		expected: decodeHexString(c, "674df1f3095d6c87bc54dd9b2aaa2c786bd50e4ddc02493745d820dad8552131fb3e389e99b0709478b65d4268f2a3b468a8447dc572a6ee024be6be9be9d428c12cc92894d15dd1c959d6222dc9ec30478c7a0b57f5bd8bd53868b98d7674738b54cf74100ae215693babb6db3b3890"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_5(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "95a30a0ca779a4038ea920cccfa4cdd814ca17d560d53a75"),
		nonce:           decodeHexString(c, "cf170f4712994f9bcb2efb74"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1da6c8726bbfa3c8bee6dcff6f76f2d55d60527c4f0db26b"),
			decodeHexString(c, "595ebd903a596a1f12175080185bd94c2336eb8dd29a387d"),
		},
		expected: decodeHexString(c, "317c19cf4a45b8cf3f645da084ada54d1b1f81379152424fddad22a6dc9bd22841e0c4c5a36bfb7879eafbd1a939121905a938ae034c7fc01afb56607e35f895f46f13e91ce4e8e75b6a87a1e5544e18eb194fd6754b06885ac05e332a05ed436e889965e405e0f2069b04b40ea0f635"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_6(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8af8930562510231a592a72587fa6ad7c234e13304696590"),
		nonce:           decodeHexString(c, "7642fbc785c0b86cba844f0f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9ee7b221064966582dc836437b82386f5204a302a4179079"),
			decodeHexString(c, "473d917f5b66f0f6e3fb4670ba08c2cbd2ea765b46b10838"),
		},
		expected: decodeHexString(c, "5c2fc9cc7148dbe40a692b3636778eb80188949d198bba3e8355386b78b54bfb963f5f2d9202988da20ccbf336a7c737a66c90149b9e8e306477151c4d912f7c61e872de0d0e47701cbe765864de536d599946b8bd65e4d89d4e61deb53de9974fbbe634501800feea100fea573e2e50"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_7(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2b9554ecf94c7d647a4e117f43326cab54466eba56a09a52"),
		nonce:           decodeHexString(c, "741b2445057c491935c067d2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0144be6978dba85aa645d793c1881dc2deb1bd210811ec9e"),
			decodeHexString(c, "1cd265f3812568274b643954c70923a76dfcc9f123360111"),
		},
		expected: decodeHexString(c, "f7459b0c23966dc1a53e0c6406c9e78ebe728e3484224cd88b6b2ea554522e75eb4a1c8a3fdc66561426464f50b8d0ff95b266677d91776b344a820eb4fd7d554678300558011a7cd85d22e92dc8ec2c2fa15c6330ba157c3e71728304447c1ad4d64f3da4fbf26d92e1e7c58a1b289c"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_8(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "335ede8603fcde78ea9869da2dbcab4a6e72f1b53439f308"),
		nonce:           decodeHexString(c, "5d06b856e627411a9ce1c297"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ededc73fe268935c10832c463549f8204a29cf0fe00a4d87"),
			decodeHexString(c, "ef1b8a80dd49d2c263999ddc0d5a1d9205c1b1c66239fd80"),
		},
		expected: decodeHexString(c, "05bfe97c398b1e33ee1c547c0edb5b654b7060b76604195440d06dd2f614a398c6c43f1803893c4c8888bedecdf998367cf992301a25f24c263f5d36bbfc6fe8b839cad293b3617c1d2c60a814bda0359e3f717fa80fc7324af8827d438c88642754b39b10d18cf5bf42f11177a0bc6b"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_9(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9b0275d861117553ecd3c4d7cfe762f88df22c4c4190dac8"),
		nonce:           decodeHexString(c, "e0be5872818e2dd765261d58"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cfc0b07082d514425b17ce3cb334ec62bc1b3be0be58ca4b"),
			decodeHexString(c, "d3c70ab5ff7a364a9e6dc75132ac67e0d373fa2df301afb5"),
		},
		expected: decodeHexString(c, "09fb41bcceb016e754795e1cce582f0cae91d7bb50245975eb75274819e1e4dcdfbc5e2f13fd26b9a9f9e945cd807ffec4e275681ea7bd33eae13efd8a01edbe02562e77b44b6312f416c3dd0be64f2bae0ba4b9bb36fc3a44841d21d8b3571c0ef644d88cf3cc3c851b256a15f4d716"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_10(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1981c3f9ca58fd10e8377a8d0eb3cf02102aab6f7a033af3"),
		nonce:           decodeHexString(c, "135533d9fd850e29ecb8dc9b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f9978ba41df22894ad5f3849c1bdf21f7bbc0128c782e79b"),
			decodeHexString(c, "b4d57de5e18d393273ee9f3ef9736599c6d639f437239219"),
		},
		expected: decodeHexString(c, "fee23db2fcc71624fb39f573e33a1490efc7230c27e9278188251634f9c045bcb26e79ece6a173491475ae44a957c4269570f5469234ca8b6873cc973c8d97178c58cec658a352bad0d4c6001cae5664258db59ad76eb6304d166267eafb46f4dd536a914fa6d1ac58317e7c557d4653"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_11(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c10d4e521350f7cd1853576d03c4bece3e58c8c740859e4e"),
		nonce:           decodeHexString(c, "16979499ec1365fc073736a3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "78b245520153baacc66846e7a83a2a925f892d4c2ee63c0f"),
			decodeHexString(c, "c8ca7a33de5991d44d7ef7da2d3368cc2cdb93895c394d41"),
		},
		expected: decodeHexString(c, "f92c15f5833800b28dba2d134d4dcfc41abf72f5a700469551e8ccb83bdb0772d14d6b26ba6978169e3ddbe5f214d57930dfcad719bf10d306749246d2624bedd4a18d327b8ae6bee67cf0bfb5f649824bbd0440f042146b95a83e5845ced69a55ba055d5dfc7183c3bb28d61312d274"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_12(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7608b5617785995a1f7144ee5229e4f9c138e418bcc3b5e0"),
		nonce:           decodeHexString(c, "61a422e8cf875f58650e996d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "961c2d33039e60a2871e1f5b82097f6b1cb03836dba5f440"),
			decodeHexString(c, "b18cb52d3858ac5bf59f216a28c0ad49f3dc88c67b5870e0"),
		},
		expected: decodeHexString(c, "4b0313ae873ce5ebf08aec160416492e4c4c797a5017061ea42aefa0685ab19b74a7af11f019b9fb63072b797f7ea3354efd32c4abd1e866405a319ed2fa13fc81019d61326e70e503141b9c77b4879a45e9f36f101dbfff4359147282ef814888fee81640def25f551cee41d12609aa"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_13(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fef7a43fea2ff1a0f624086985e535778d7a73dbc47bc23e"),
		nonce:           decodeHexString(c, "9da92edd5d2f273cdbbc0251"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "836731a57497a69e31f8db4f729774ad65f31d968dbc55a8"),
			decodeHexString(c, "bcca96d808ba98bb50e90afe58fc88e95dc14c3e90c56004"),
		},
		expected: decodeHexString(c, "4f2c64ecd146689064fbf4fcffce2a2ab3910e72ec4faec277f7b9e9ed510381312b01f21650e175ebe9c45c11e977276f13be015243a0cd16a191abbac6462ba96e4e4a1120b28083da933419e8c8f03099906eb1ee012ae291104c6530f51b5e32e6631cab8ef5aad68c0045255ba9"),
	})
}

func (s *drbgSuite) TestHMACGenerate17_SHA224_14(c *C) {
	s.testHMACGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "00197c70b2f0d3e98e4b387ec42a65c4106a1689ab5de611"),
		nonce:           decodeHexString(c, "01ee76f4b5e530e7efeaf964"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "03015311cddd0961ec7a74cb84d835c058a69b964f18a1c1"),
			decodeHexString(c, "5e0d99e0e7c57769a43ea771c467fb5e2df6d06dae035fd6"),
		},
		expected: decodeHexString(c, "72e8ca7666e440ac6a84ab6f7be7e00a536d77315b119b49e5544bf3ead564bd06740f09f6e20564542e0d597ac15a43b5fb5a0239a3362bc3a9efe1ce358ddd9d4f30b72e12ed9d78340c66b194beb4b12e973213931b9cfd0ccbdf540d2c36ce074e2beac7a4ddac59e06e4c7178d3"),
	})
}

func (s *drbgSuite) testHMACGenerate19_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_0(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e4547261c9dda6bafe9fddf435a80ebc96354c7c2c8847c5"),
		nonce:           decodeHexString(c, "d26c6e73a967bfc4ebaf8613"),
		personalization: decodeHexString(c, "42849dc8eec611eaa49252067fa60d7d7267d711dc35b576"),
		additionalInput: [2][]byte{
			decodeHexString(c, "815f50fc233f157f96ad0627c355bce407b269dca91af661"),
			decodeHexString(c, "775a1c9da6f58d4eb95b27935ecc01dde31ff17ce2e4e65d"),
		},
		expected: decodeHexString(c, "25adb777523a80a6dbb6ac1fd08e02bfc4b4686cec5efe3ae9aa2d4469eae8c9c3693fdc8e0fc107720b7789ef7331e23fe3799412ec86857ffbba515a5af4d91013b2f17669421c822005b4747942790a11a24c4974f27d54de69727b0ed507b6a48a9d6c53f93e2f3d33df73dd643f"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_1(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "06d677001d9b3c97fda4d09778aee3de131b4123696b109f"),
		nonce:           decodeHexString(c, "81bb6b0d7fbcab3c5842bb83"),
		personalization: decodeHexString(c, "f99638d2d4365b662cd83ab4e6a7bbb624e6c72b7b38e81b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "20b7d56f6222bafeeeee59dbca1933d8086218891f3a9bfe"),
			decodeHexString(c, "9de4f2847fe239cb1a3df4b8ff64c25d7b0870f3c9ebe3a3"),
		},
		expected: decodeHexString(c, "e18ff19837ce21e68944659321311b8584dd515ed8a6a1f2b0ac06e69009c3d0cf0489af876201efad962cfd1ba54f540b94131d788d3fea797c4bc079593bc7932baa70abb145a355741a98c584f0fa3298b8310b01e1a6debf5359d7d02b1a6c663100acb56975450bec20e91b736b"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_2(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "abd38c0465cdfe018f36ffbb7a0ee51d67675ab4f0f1d1e9"),
		nonce:           decodeHexString(c, "3418bb4cdf6499a371af4d3a"),
		personalization: decodeHexString(c, "9a07d5571d841e3c1a9eb3fb48cde3b3e080e1c2e0db6a6d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a392f79022aebbec0c82b981293627d139dfb5232eb490b4"),
			decodeHexString(c, "f5ce1f6b1e6715c49bea42ff439fdecd9b3b7f2e578133cc"),
		},
		expected: decodeHexString(c, "885c54ad25992fc38260498d6f4d8c73d6159af5f7efef06174da03afcd8384cb28690fd9ded1d26e2dff74aee4dd0c47a0d99c6fc1ec8d8faccbdcf6fdb12a528564ad0d8131bcf5222d7e6c69c52da1acba01b721c98ac5a33725111f12f6d8100009d7cc9efb7ad8d7d95ea4e620d"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_3(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b52620e58e0b52b8eed0d6a6c5f4ff6c1483c61fc41dacf7"),
		nonce:           decodeHexString(c, "2bf475b37d068d061d1edcea"),
		personalization: decodeHexString(c, "ef0d233de00d24622b7d4ff4215aa720787fe80aaeb65d7a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "81b735acd3dcb13e65231c2d980fb40ca850370581f230d2"),
			decodeHexString(c, "b2302d024d92cdaed4b12f79b0aeb20c98b2321710fefab2"),
		},
		expected: decodeHexString(c, "ae94204670196baf740768f97b3a095134b384afea667fd90a77a16c8ae390a732ff49a3073a27db0f7a2c8ad5d7cb527d334a37abf0472f292a20f2a28e667d7c9e9f7b8fbdd177f36bf92d66223aee3f712b6c9b064e07ab96f6a77613ea55008fb4f8fbcb2f1ccbb0da75316c1faa"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_4(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2592a5ed86ff64b9b4c1fbb81222d1bfbc53f3a639571ecc"),
		nonce:           decodeHexString(c, "356084058b8855237da15c50"),
		personalization: decodeHexString(c, "a626c51ec99e72431485d2ba027ed9cabcae7b86116abe4f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c430876552d28776570923c6b74e42c3210f01104006bf11"),
			decodeHexString(c, "fe2ebc239690a4eb18a0b5e75d08831cc2eb07c982c63973"),
		},
		expected: decodeHexString(c, "005045ade7cc15467b5ea784649d9804540a842ffba4db8d44df4f44c69480bd4fe965b645aed09d62190daeb2693a2192aec3d71453a8218e4700201ab922ac35d241d95150b47cc7a051897be4d958f2da5c2ebbfceb1c550cb67b32ff83ce4fd845fd826a0d2469b506f5158765fa"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_5(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "376785f5ff8a82ceb0aaeb010533cc1089059ec583c302b1"),
		nonce:           decodeHexString(c, "4bc47e2cb8c2711839ce7f68"),
		personalization: decodeHexString(c, "6d345e248339e893f75696c039ac47e5678696fd489a393c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b0f3fa1131c3fdd5c7fd2de93931e45a66fa030422ac65db"),
			decodeHexString(c, "c66341e3f9fb82e3ba85f229fcb7d34457e4a6ba8396b548"),
		},
		expected: decodeHexString(c, "b92d17e1be94b0385a8cc3e16189811fef7b284a1b0b6b2520fde79af7826c745e746486a70cd8dd9930b163da75f7eea7c216e758d9ed6c745dcd7bde19bb9382c1f7c37cd15b703b884d7d452c255b25048a836844c5ff28aaacf733a52c28904b36e1b51729d7aed81d601c0872dd"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_6(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2cc2557582c5a90cd2ad0c4a5578eb0bbc9bde41b126e46d"),
		nonce:           decodeHexString(c, "8e9c3563341ba238414eb628"),
		personalization: decodeHexString(c, "9d2fbb9153e3ffefae0770c79de10db069a5ff9f50e31787"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2e54e32539e27ef76ac1eeae2e30c2385647652e20903b39"),
			decodeHexString(c, "1f4e01255908c3c8049521f8972c01ede7dc76c425c59640"),
		},
		expected: decodeHexString(c, "7d6ccdfab33f322898c470be02d8257e0e952dd10f407b3a8eaeeba47c541d968d79eca29e15541c1505fe4f19a41797c9ca2280c06261fe9d0c58bab65d16f5794b57566b8795c38c7b43d4761c8fd107beb95147a0fe61ae8dc31e25eb2957e44c0463ca7c1b589ea587f0cae1428c"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_7(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e670f896326b76034e43cd85f6f6f11fe6582d3471a8eb88"),
		nonce:           decodeHexString(c, "d37a2302de010aac0e556860"),
		personalization: decodeHexString(c, "5e218091abee1960ef81f4d5a80415e388bd0cc79bed70cf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7cf84b9ff30dbd0f608fb21646d7c5b542fba50adb38d5df"),
			decodeHexString(c, "c1c4aabe7616a4c97a4dbdadb08a9b63c6e10cef8d463fd8"),
		},
		expected: decodeHexString(c, "d8fbd557fccf31829b5ee11b05d0353e725bff15fdaac94d21ce95d40eff55edd852b264b515ec6384e2d28d014e47a2df0d4f56a4ec79309b06affc62915e231d62d02bfc60220c72b7ca7ba5671f882839b791ef534e707a04e5274c1011f7941fe1075a5d06a47af9fb2f65c1f211"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_8(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0576bb2d4c663b781193509251e2f76b0a8bb792e7944960"),
		nonce:           decodeHexString(c, "0c2c154feb70cf33ca942508"),
		personalization: decodeHexString(c, "ad15e4fce9f4dea43c12ff9f9d50c963b335a01332541154"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3c8a4d6ab96cebf9d02b5663dcb0e0db23699623455cd4b5"),
			decodeHexString(c, "43d2d3a8d023fa1785ce4781a15eb20ad787685a47da08f0"),
		},
		expected: decodeHexString(c, "a68e648cb07da2eb795a8c898c8631e565f33c2fe9c35e686d6f85fef145446cb79bb6d17bdc8224bfe437468a9630ed03c517caf1226c278ae510c869d67d50b6bf1cb378a34035041f290d8dbc123650ab4fbe5cf6074ed0ba90e45d9a8ae08566ea3d3a00ee3741c8ec8f56dcc78c"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_9(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f597ce05b9a5b1cf3847bbd4171e5085384cc256f77ac615"),
		nonce:           decodeHexString(c, "73b435726cbd538b93de9f55"),
		personalization: decodeHexString(c, "573cf859f8fea05f16c6d03cb4e524b91e917f39eeeb1d68"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2a842454870c3f7936f8036b453d219557ca341f261d2519"),
			decodeHexString(c, "7afd8cc269899acd88f5c55af29fb0c4ce678a0d8ebf924f"),
		},
		expected: decodeHexString(c, "8162c16c1ce3d5c6b7c96f0281f4220569a882277935752b86e7d3f54646b276cb77ed96da73799911fca3d19d34c1f0b21068a472afcb77410412eff2abd03c753a009ce02b0e995477546366020294eff0ef0da66f31a413313e2774ca04f09a4d5076e0e85ca97d5bb6faac4c0c27"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_10(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d5b5374fe143035c4fea41667bc8bc7d46000998cc82ab32"),
		nonce:           decodeHexString(c, "a0040c705e01f9b354e8f16e"),
		personalization: decodeHexString(c, "ed8bb219e67515874c5b9e3f6ae6e4dfa9c42d1e69204e8b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "70f03fe6e78cc34ec1678b2708fcd8ae3300183ea15ccfc7"),
			decodeHexString(c, "9c641d7e73d1a2b819e113747d74a979b74c444ed36b7391"),
		},
		expected: decodeHexString(c, "d50df8e3e17c0f5e19673ba2097d1d0c4cf7a9def7465a5b91ac8d49ae1b6a821fe9efde841ec9064555c0e2d6cdfa41f1089f22a5c27090c5a136660d1af586a1e131a853f19bc3c8f4c79aa09e39c2f22b4456c667ec907e2a4124218665e7cce50399ae1e19ba9c2399f470444839"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_11(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "74d7c8c9b170e59e4f128c8df1955838df5c8071a5e85439"),
		nonce:           decodeHexString(c, "d71e785c68b37e10efb39c9a"),
		personalization: decodeHexString(c, "be3d54203a1078d051519137774d5d851e81be026155eb78"),
		additionalInput: [2][]byte{
			decodeHexString(c, "23f7b6758d79de580ed3eb995fc173da74939837aa8d9eb4"),
			decodeHexString(c, "6f0d5a333ddea0d38362df0dc3ebaa2be2fe5825ddb0ce84"),
		},
		expected: decodeHexString(c, "4462fc32110b25b3797c5cafaad830e8a4346d9270fed98b30f1345a7a8dde19bf5365d6f3788e7f715feb2762af263839c8c8188908c61120743d977d71c51f6324d887bbda380fc07eff09a31c2332e7b1aa1692c59c3379db95fc21cf711c004c4d385fe14f48f2f2a31bcce6aaec"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_12(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "eaf27c3f69279fd523c0c3a1da5fc4f01ed64c27ffcfe3c1"),
		nonce:           decodeHexString(c, "c596482f5baae1434e8c687c"),
		personalization: decodeHexString(c, "b038829fc95dcba8645ce40a306491c893f48139ae30a071"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fbbf7abb8cc2612eeea6d9463efd55c47245e01713332bd6"),
			decodeHexString(c, "ccd7e81f529de1ff4e65fc63d34c262ffde7ee49e6707197"),
		},
		expected: decodeHexString(c, "96dfb7445057633b2f0deb69135d10d0a2dc53faa9cded55ddfb8edc63f5424f8fec7627597a30328177dde7963f76f9e5412b5b440256c6a3f0c7c7fa02ca49e19ea176abac013696e9d529f65e51d4a7348e42dd254bbf19d9632d6c875b8ecd7a4139f1bf020a159d2a30af8d645f"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_13(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "319cbf2b11b37c831c654b6cec2570dc6d7abeeab185272a"),
		nonce:           decodeHexString(c, "518eaef30faa5acf5c8b254d"),
		personalization: decodeHexString(c, "9effa141f7466b659eaa50c32c8e683c2640f54027ab6aa5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "63b3acc237588cdf41c0d4bef16c4890cf3d458fcf1de8ea"),
			decodeHexString(c, "573d6a7960aeccc3280a8aee4d72e587e9d196b7b270e329"),
		},
		expected: decodeHexString(c, "8a568086fdd9f01206a5aaee34d253bbc9339112d3170699b9a1392e97062d5d0f16240114dc1789269217c5b4b2974895b20903890f7dacfef46fa4a4d02891c70425ab3b42f53d72f852faf3713ac7b8207dc453279f4df345091b8bfeb54983095c2d190358293ba507bdfdc39b24"),
	})
}

func (s *drbgSuite) TestHMACGenerate19_SHA224_14(c *C) {
	s.testHMACGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "56f3f5b08da10ead0c986dd2ae5553e4b2eeeb47ad5d2219"),
		nonce:           decodeHexString(c, "7b12b89b4a871c51c0d85554"),
		personalization: decodeHexString(c, "96c8630a1f4187fb0794601cf51e7e333e71756a0421ff43"),
		additionalInput: [2][]byte{
			decodeHexString(c, "875e5bc9548917a82b6dc95200d92bf4218dba7ab316a5fe"),
			decodeHexString(c, "4d3f5678b00d47bb9d0936486de60407eaf1282fda99f595"),
		},
		expected: decodeHexString(c, "90969961ef9283b9e600aead7985455e692db817165189665f498f219b1e5f277e586b237851305d5205548b565faeb02bb7b5f477c80ba94b0563e24d9309d2957a675848140f5601f698459db5899b20dda68f000ccb18dcd39dfae49955b8478fd50bb59d772045beb338622efa5a"),
	})
}

func (s *drbgSuite) testHMACGenerate21_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_0(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8ad37bdd28f6b39cd2d62cbb226cb52c7c9e4e7158e74354"),
		nonce:           decodeHexString(c, "8a537aa573111a710ebedb9f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "66abc2c8559314d27f080a2b608b220c1cc3c581cada3a92"),
			decodeHexString(c, "fb193d70991547bdbc0b4b0e753412176ce727ead9bc3a6b"),
		},
		expected: decodeHexString(c, "91a8a12810058b6a9b1e5f86753b257f6e14afd7415765458fbe131bb17a55401062c6a1253dd40c5a6df5c79bdedcd205e584eca3bdb62608976b8caa2f57ea3a6305a84d8018340ef410f1cd13c214e7c80c5da348eca06d37469758fba4a322ba7c9ba791e037067f01f4bd7d741a"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_1(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "71556baf97112569f7ce185bde939046d7c0da75256c6838"),
		nonce:           decodeHexString(c, "70f7798dcf87c5dd469188a5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b2d8b249be357d29ecfa8846130408ba92e4c375e2a18341"),
			decodeHexString(c, "bdb135172136b8e495620fa1bf00b6dc1096743f654e0a1e"),
		},
		expected: decodeHexString(c, "b5df532fc5640df7ec27b1064cf9fd82999e9e13594c76e7b37b4879272deb5d25650ffb91f03e4207a52460a51f46810669732abba63689969726ed48b5fc911eaf2da52b4d731d3c5703fa41c83752d5121328f7bafed472bd484d13308809a80e0998d6c3504ab5b935c67e303e97"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_2(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bace0437423f99453d4bab253b7385f25cac5529a74a55d2"),
		nonce:           decodeHexString(c, "e0070add2bfec0af44a5ab92"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ad0931a66c8eccb069b18794d871ad801709b10fcac63333"),
			decodeHexString(c, "25be43136f84f69506d946b7b8cbfc14c137d65daac9f6a7"),
		},
		expected: decodeHexString(c, "cb15d0960a48246f38fec77e0bacf22461cd337ae77418742c3a5f6f745f73d9608b52b2c64b5d24f736278655d45cb975b03e8698e74e08b52f402a1828114a9256cb22c55bb21445da8c354aa8001caf14167daf4dc6093f9aded313ad6433af48a8291e9f9d529f32825a77717c54"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_3(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "98acac10c00a8a20d80234f05ed900420e092f1a52a66a3f"),
		nonce:           decodeHexString(c, "75a0856c873ceabcc3289025"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "39ef8410458ab56c92dc0a3bb4fb55ab2b6366cbd10232dd"),
			decodeHexString(c, "3cb5cab71f8c1059e6e58ac5135ae9411a2b22e578dee61d"),
		},
		expected: decodeHexString(c, "34d345bd8c0f32713ffac93e2ad3df5c50134876284ee3d6002a6a69dd66a903b7f05ef52c582e34259680e80b15f459bd0da3848db49422223e072ed542ac2b0d172e71b170ddcc77c355eea7e8a00789501f09ae3ea928b76bfc8329a6ac66023dcbcfb82be6ecae29472f83e2e5f2"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_4(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ee5ef00aafb26dfdbad0943029a5b82e7844d6e838252ff0"),
		nonce:           decodeHexString(c, "d32ddb64875d956b1141d891"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "17642083b7135890eb32fc0d75cf3db618e84ab12b9964cc"),
			decodeHexString(c, "8bf2232106450da94adfa30d7d6f51c712845a50ea33fe39"),
		},
		expected: decodeHexString(c, "ab35022268031ab65ce726095b2b311d1fe744e4229d6ab03cd79eac3fd93099ba00d0021a95f40ac86a46fda4041c27b0ead485ef4d91a8b3fcfab4031f762a6746516161b0f998194a4a5ca902e905e79e67b17cc70be2f8e077290a575a7504f55c47bae81dd732e036aed18f6e00"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_5(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0ddfeac713fb4e00565c0315aaa80b54b09f8ebf8f94cdbc"),
		nonce:           decodeHexString(c, "dec892f0d33775e66743b9b4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "984b87667149b02521d1fefe9238bb843f9a9392af304b19"),
			decodeHexString(c, "6d269fb9d218e1e932bf7a8a064b9252c8e8bd15e91928e7"),
		},
		expected: decodeHexString(c, "d8a6470420e87e87eea6508e48953268ec481f70047214c3c1049be0fd0d41d04a8fd8b25751297f6bd2a3ff74cae96bf75666e179671055443c0d487edd76f3a7dbe70bc430ded72718853496dbcc57d6dd3685593aedd2c14fb70203e9bd84ec7531de1451c95fd2bbd4bb1065cdf0"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_6(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2c0cdd5597ec0580c57fbb70a86432a736ad44a8e0ae8f22"),
		nonce:           decodeHexString(c, "9857f254a4bd2b819b617fac"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bc662e9e8bd5c069172b688b39f74f368c44554c09fb2c12"),
			decodeHexString(c, "0b95de4012b602c98c1767a0f0a11b4c85df71e691d7bdf7"),
		},
		expected: decodeHexString(c, "96adc9cf7562b8fd344eeccbb91c73441f7691a9c58e7b61160f93cc142fd440b038f48831da2b6343b40ca70c620cbd6d3c5509cae8ca3be87380af58d1d271abbccb56c2ff883ab445f30914271e25b88098c412a64c15956d0ad7bab12ccff80e0a97331af5c21cd6b0018e63cf17"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_7(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "96275ad546f4706febfb4e983c56a27d742edf3f92e7177c"),
		nonce:           decodeHexString(c, "d7534695bb16adc11621cbce"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4abed05763ae67b4173e31708bef17f4b0bc0a75a6f8bf1e"),
			decodeHexString(c, "478b6a8aef8f40de30c0b0c320140a739c914d5976540153"),
		},
		expected: decodeHexString(c, "34ff8a4cd818b7f870895416ba60711775b10b090602717bacd8ccb94f2b751e0b2a364c9fd66ea1bdc4d57f5b3ceb3eb30512d31321b48ac41c2abc30025272904a934a3187128c95f224821db1ec657901bcba19c75b4b64906c9c12c45fc80b4694e3a94e580fdce95c9cd3254bfc"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_8(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fd72ec0a165678f3ae47b074b1ae1b056b1682b7cfbc1c68"),
		nonce:           decodeHexString(c, "cc7af6fb09185c0c92e90db7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d9da5d76ad4ed06cbf2f827455ebd12383f870d13b7434d3"),
			decodeHexString(c, "67a85292e710ac97c19f89daa4b0c0315bfbbe71ae8e99c9"),
		},
		expected: decodeHexString(c, "ee2b927b0d53e70544475aebf23f5bf2547f5a4f013fb68b56349c76bbd26983e9c662daf6280b9fd01f979dbf2e68bdc17e17c866618b93fe0f6e05d9de6d4a97783cb6516f6338345c7153e0fef538163e1622b07c377e4ccfb0b9428cf62df2e2869ea5e94d4e1f04d81c3666329b"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_9(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "15f6299979025dd6dfdd87fe2883f449446ae9a8b013dc52"),
		nonce:           decodeHexString(c, "40e2360188f8f02055fb965d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ce54fd58debee248473a1ba98917542adfa9523c71ebba82"),
			decodeHexString(c, "1ee2c747db56b8388399fff174b35accabad494918dc9a3d"),
		},
		expected: decodeHexString(c, "2caf6ba1df44f8c5525ec6b81c22e8c66926a65342069dffb8d1dfc8a39939b5667d2d24d8c715ca7cb41f83eac1263efc6ca8fd8bf8ff2387e716f154a8832f9fab9d2e3174cc1e7cc6bc06b583b75bae5a93fe063e18866d0f2cd2a418ad4b06d98ed330d5c10cf8eb0a7d2d013df5"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_10(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "73fa0c8c227664d091a6e809173b1a7fdb502dd8de877bc1"),
		nonce:           decodeHexString(c, "7d5ab4dad7976c0fe9ffaf13"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c88d5f61e9b23d6c440195fae62c4dc992be1323c7a77c1d"),
			decodeHexString(c, "7918b3c108b6b21301625499611da496c1f6abb8b6bce9d0"),
		},
		expected: decodeHexString(c, "a0c58c212296636b7e1134aea8c9cf71fb2ff33a1266ddc8b635791a00b50ea8d9b2fb912614a3866bd0557767a23d85fa7b71b1164d2bb3b36e2b97f5ddf94a30ce29da682e5575b9bf0deed7c780349c5eeb7fb39c00a73f97dcccad748d7a98e445efa1091ae7d911dad929fc0645"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_11(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5f6b6db4db0f5d9aa8e8f7bf5dc07bb188ba16c104979a3c"),
		nonce:           decodeHexString(c, "a183ff25816a11805f761c62"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7abd7bad51e1ade5b2da0b536c8d589c682df09ecd634c5d"),
			decodeHexString(c, "03a31694a8e68ba1463551380717db35f43702135c74ffdc"),
		},
		expected: decodeHexString(c, "5bd753bfd322db90ceda38f2e7e914766be456b6d774d9952448ed6ae79cc6e5490a42896fe95cce1cbafdc18c43065e35492affc776318b3e1cb7371afe9e3f98d09c0a3ef5a8ca8c893ebb0055605d3025a0bac535fa3945b0e302f7c4889c4f67c943032a387e06557155d62de880"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_12(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0247ab3bf3e64cd450b605e07b9ca806bdf6bcdc7e5be087"),
		nonce:           decodeHexString(c, "d5908c90f49903077d5ca9df"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "822829af2bc971c062e0e72e122331f67523c4fda4e6b59f"),
			decodeHexString(c, "b74dab0782913c9f6c191a4b5c8e5ff4c533d2897d9f4ff2"),
		},
		expected: decodeHexString(c, "70a729135b2098c38aacdd074845aa66e7d8b971da5fa03d519f51a09c19848aa1d9cedebb0388eb3c2cf1ea34eabfd2cc3f96bb7d4b7f057c8daae2a8dbd81f9936eb001fc54554d4b0093a7412c370dabf0f884d6efc62826f6f50b8966445753406ae0d12f5f018243781ce4e0e46"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_13(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "154e09ce03eb313b6b37a50273f61fd829c987495f848e3c"),
		nonce:           decodeHexString(c, "6baa744eb875635fbecd1043"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c64900dd98479781a1ed32a2c3bf2de48408648ff8bbe7c2"),
			decodeHexString(c, "aa40b7eb8381ac8a70dbf84ca9e68f526d3ff10c4aa9be79"),
		},
		expected: decodeHexString(c, "5fbbd2c5224f8ccc954869b141abbe26cf0e90d02f19d8a5a54a4fcd4a62eba01071e0970c89857f884ab1d018ee0d31bb88ddaaf9aa59d2c7b65de619b0d7b4760336fa1e926aa5697a5be474ad42017f3484a40d3b1aefaeae523f9384e58ba9924dece6685c76c05920992787acfb"),
	})
}

func (s *drbgSuite) TestHMACGenerate21_SHA224_14(c *C) {
	s.testHMACGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "34bc96e55d3b0f3fb83b2755b7e58363113da2fa0dca7dd5"),
		nonce:           decodeHexString(c, "d6db4281d219135dec4b01c8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5c15fa9dc77d6fec5f7a4a3e4a315c05de2b5e46efe54934"),
			decodeHexString(c, "fb65ede490ee01a1c100ad5e23a20f91b45adf1ddc15c590"),
		},
		expected: decodeHexString(c, "98cb3191831dc79334e8e37d5246600f822aaa40964b91f345b9df90929db1b7bdea96dae9aeb88d05fade5ae6c29aa8eeec7fdc96e654c5ea41ea01e3104ca4d287bb03005feab0bd1f85e556bb6bc46a2227b14fd94f9e6cfd0341cfce951851feb967968d6cc818f364345b715bbf"),
	})
}

func (s *drbgSuite) testHMACGenerate23_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_0(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a454d24cd8ab7aff528fd2a4df6313c760aa40a5fe23b0aa"),
		nonce:           decodeHexString(c, "bad23d7e66ef65668d11dcd4"),
		personalization: decodeHexString(c, "6c09c1ed75318b7e621547cd9d84d98cb27a18a4144469bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "aaf4b7b16eba92693dfe6203260243ff531262230791c4d5"),
			decodeHexString(c, "d7fe7447c154387c582e913a82505ba381fff66008f13d5a"),
		},
		expected: decodeHexString(c, "0b20f3849a3f0324b477f3f925bf4739c544419c225e2d5b46f4d1b625fcfed15bcbadb2661c012f2c66dd13de1aa52298473cb026c316b1c808baf72889145b1e2927048f72d7e4e8dba1a7250edfa66179b9abd4283e823fe371269971c1ace40f90b6493a6e73670b7e5503f46c89"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_1(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3bc7f1773fe1191695b3fd9350589433ca2c617951bbefe5"),
		nonce:           decodeHexString(c, "3d4fce3431bdd8e06f5c5182"),
		personalization: decodeHexString(c, "39606af9aa0c1c455ae72393a36c55726111f5560b4af998"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8b461996671bf413d4b898ae968777624b174aef9dc8cad4"),
			decodeHexString(c, "087fe5dcf0a0403fdc15746950f20e393e73db916e964dfe"),
		},
		expected: decodeHexString(c, "f189481e192a67998847dfbaeba1e71517aa11b22f1d9cdd65d3e62ac44bd3a6a344c1ad4d4628c12d9fa72b29c61f8ca8e3eef37d1e4cde51d7905d6314b39e9bf513b24cd24068dc57db263480ecc7eb528de332d7c21d6cb43c7efd3a8caf48a4260968c1e33366587a64de8e254a"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_2(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4412a6bb0840a10ea6f1fc9543226f7f26c0cbc7965a9979"),
		nonce:           decodeHexString(c, "d52f7a302a957fc4c4fd6706"),
		personalization: decodeHexString(c, "064f8a9c4276339d22f31db30a00cc781bd1c0340f2721ab"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e88ae1d4a3245eadab582b21c1522d8a3d93faca3823cd44"),
			decodeHexString(c, "4fd482fb3641e626ade6d9d94a18303c6b1a7ea629dff0ef"),
		},
		expected: decodeHexString(c, "a29b0cfe188977ca00ff72993bbf1d7cc4446d6781ae091bb32a8deebf1f546c2571968447a85ed52c019bc0fe4ab0b18b93170b295cd897200bd3f5321f51b09e7607aebac79e2342dade99a4f422949aa97872a07f317cd9d1482ef397c6354ff2019dab5f915234aec6721f556e69"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_3(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f8200b1a9d49e0a7320c05d14fa77f3528077b043b2d0f6f"),
		nonce:           decodeHexString(c, "f83a3d3f55e9496d4914bc22"),
		personalization: decodeHexString(c, "ae356cf25b715ec1fb158f51b21c934c22eb5495858ec019"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7d25558e3ed1135f26b78ec98fea2c9d62e8f76dde73de67"),
			decodeHexString(c, "4aae0d3a2f693cbd913ba68dfc3f5cda385a07662b65ec94"),
		},
		expected: decodeHexString(c, "edef6c0324f5f1c360fd0eebf6ea8906b7d378510fbce36ae5cabed186eee6efb4443dfc6b84d5a5cda22bdd24eda444073a148b66587e5951f40ea58d947d474adc7584f5b6a34ce94b6113ca71319f7f83723a0acc57e638930cff1d72fdce1eea4f8cee25bb77815553872f10fd83"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_4(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0da057cc5f06459395c6ea651ca7baefe8887d2896a836d3"),
		nonce:           decodeHexString(c, "742f6ff826f86b169283be9d"),
		personalization: decodeHexString(c, "823532fb5b1f75a967483715f56546e254366cc774f233bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d8260f314d9d515936d765ffe21a959751a893efca455d06"),
			decodeHexString(c, "a5615ad8f003973b9a7605eab80439c8aa2fea56386aa396"),
		},
		expected: decodeHexString(c, "71f5efaa35338feaeb52bd12b7961214adec8bb9c30b751453ae12f4b706b21de5c0c0701d4f5ef0cc2763fd10c10f2a856403f6c28b78ca62cb7dbfa19b7eab7351e92727382e339c7a7c44578dc0f3bbf4475fcc1d17a7bc2f6de97acd7dbade74f317923af035219d85cf2b3c3087"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_5(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2f55b2b823ac366f4d06dfce6d081dbb3a00ac466a2bb77d"),
		nonce:           decodeHexString(c, "00642c8032c0e44418ca14bf"),
		personalization: decodeHexString(c, "6a8cd0ebbcae6ee434e37c586f7d7983d3d57ee6750503a3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c94083c6bf2799c97144f4a8240957c4da177054d56f1b7d"),
			decodeHexString(c, "2eb6793d47dbfe0de54ada5afe34e8f61584f5bd75094ed5"),
		},
		expected: decodeHexString(c, "50d6b4737a9e5365cb35ac37ee157f2dbfeda1bf05cd1b6be50dfea46290f8e178215949f5f1e3b6cbd9b4fa47384a9fd58571ed2e664bee4577b6333721a72007ad563e4cd9096ae6e61a016a6910b1c832c23277730ccf246c284861ddf4c3722cc9e2872040660088c97f71c1e039"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_6(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c703a60ccebafa633b920b5de2a154b9fa4940973f3562c6"),
		nonce:           decodeHexString(c, "32b3afdc67a7092a61f13e16"),
		personalization: decodeHexString(c, "5a975900ea7ad8e778d24c6c347d09a58e8d084033010ffb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6275f07d22aa29f0fb4b78f545320f1a7ecab71140fa425a"),
			decodeHexString(c, "bba4afb2b69201234eacace27ee6d77a5920cbc509da66d0"),
		},
		expected: decodeHexString(c, "779dbebdec3601f11322ea9d0857c88974f2c8ddb77e2444b46b31a7f65d3b949462bdda4aac94f689d44467b049c718b93a8451a9068dccb75f7ea9c6c60726299b5794c4746840dcb770eb3e45347dafab6980e6839c55b6f35ef87ae1e0915dd8e843bdf3f0fe38b5ce66d7bf38fb"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_7(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "eef0b72f2b96523a8dce8f19fd4f2a7d041615f9dc2d30bf"),
		nonce:           decodeHexString(c, "019647a36f43d7d36183dacd"),
		personalization: decodeHexString(c, "6387a9efd6df19065a93cc64fbfb7e3e26a8966f0fcbabf7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "76d848401dabae20bc1504c2a44c950c8ee01f76df2b57ca"),
			decodeHexString(c, "ae05a4147ed24eb84c90506310d0a231e1fa9a2fc618c503"),
		},
		expected: decodeHexString(c, "2f95615371c773aa030fd255ad19cedf4ce6d50fe4e6d231c82e687792b35a4a10a48e4d88918baffb03bfdf137553db576b0afc99d4a370a2fbb2925f1110e72ee3b5960543af4c1141d303381650d29aaf024040cd70503fce0ea41794d8e67ba7615b0ae28a0614e26d33b063d9f7"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_8(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "68442c7db00b0d360a86709d1bdbde023724730bbbc2eaf1"),
		nonce:           decodeHexString(c, "e3e3b777747fd8bd4690a9da"),
		personalization: decodeHexString(c, "184cab9e9779a367e1fa5888d6038ce5f6702a998465e9ba"),
		additionalInput: [2][]byte{
			decodeHexString(c, "442ba6a8567f3002d7c7f94398f23aa7b3b0647f116d9c7c"),
			decodeHexString(c, "2d830926a4cb5683a308593db5d6034f8bc94f3bdbd88056"),
		},
		expected: decodeHexString(c, "d8257fecef134d22025eb884a8b93e67a24227a62ba8cf6a4a412317cc27d7e2c6291a42df02a82511853ada9e4b75f2f8beafbb4c788e607fd9f988e8e3feca807c35141df39ba2d692ca182c5e40861880bd6d8648a8d65722bd65d87e14d7449e0d70927ef25929a03a915c4fd806"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_9(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "328b4809643931688c48b0737969554c5a29752d8493603f"),
		nonce:           decodeHexString(c, "9010cc0138e491197b28e87f"),
		personalization: decodeHexString(c, "3451fa995bd9e975535abd0354cb4056f97c6b785057f3b7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4eadc6391b639be2b0a556e159a17b5731b1469766758183"),
			decodeHexString(c, "afe849042ccd9b7d24a01996a9a0a3bf5b8b723ba36b213f"),
		},
		expected: decodeHexString(c, "f6f1baa1eb00e5cace4c83296f4bc87f4214f3ae9f635d882f3d2ce7e759c04055d90728181eed28fedfad593ebb8ddc2212a8f24da13684e751f6845fec92596a4ca85c1197746c9063781498640ca152ca90f309e78c834c98814a6918033d1528983bb8b8bdb7485a3d6797d24773"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_10(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6087021a7d6524764fc44223dc108961f90529b8c08f991a"),
		nonce:           decodeHexString(c, "a532653ea4e091eb7ebafd2a"),
		personalization: decodeHexString(c, "513cfd915f4bc8fd35c90bbfc7ed2f67b21f0c73a430a402"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f0fdeb937d463ee039ae72dc536efc7946ded185abd47962"),
			decodeHexString(c, "2e85f0a2c540af36f3803e4c90bf88118ef7df7368250345"),
		},
		expected: decodeHexString(c, "6431c3c5a0e0adbf88a5ef1d7a618d1b10763d0dfe11dbba8058047630d30c0c40e45c116f88ba352f47d051d6ed1c6b55fdcd3ce1699e89bda7a3c29c209da9eacc7ecbb783799bd6c17d975f0cd40e1a812fdf12d46a7a4df879ee7661f3799d794c635664a466dd00a3217cdbef59"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_11(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a20e88ca7f57ca76295114c7a7521e38a427a9fb5b7a137f"),
		nonce:           decodeHexString(c, "ca81453c651679646daf9e0b"),
		personalization: decodeHexString(c, "23b423fac0d765ece85f1a9282f8e97c5727205ffe667dcc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8e64128bbd64c06fd983272721b0069a7656874910cdaef4"),
			decodeHexString(c, "cfd615a8abe010af9b11ee2d9ff99b15558992626b15431d"),
		},
		expected: decodeHexString(c, "390a35d348edf975dfcf2b06327e436145435fe5491dba467a0012e74172b029063ba96bc5d3f0df9ca6759ed275126ad09b5a999723a9a25f3496b0cb2a3795287da0edac6b07ceb1123d43de721ac10ae4353915d41c3b153a7a8a9acedef18eeb3f4093485a44e43cd0c51a435be3"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_12(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5701627b7979c249837577eb75abf823984f5cd0a4c400a4"),
		nonce:           decodeHexString(c, "1e02e2426046c34959b1f23a"),
		personalization: decodeHexString(c, "4bee7c103ae40e5ad80a6ed9c8585d291c49fb40c294b31a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "04bc2574d5beaf8711a127a6fc66115beda575d76b206d62"),
			decodeHexString(c, "83f45f0ddd859bcee9ae599758a0b7cf9713221f9b3f7826"),
		},
		expected: decodeHexString(c, "bda8062291bc4432ea63712f305396ec06e8ad5606781710e2a8b043030c91810b06bddc53ab24b41e273232c7755a13e255f22e1e0f55d9ba62b845957bf7c9d7765b9051066ec2aa5032ebc2e627c34723b5f9245e3c88d90f28948c91bbee6a5889d4aef514d4c91803cf87092b2b"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_13(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "affafc143621917b595694ecf1b9c6b7be988dd4e48db4a8"),
		nonce:           decodeHexString(c, "c9bb6a309658de582eda2c99"),
		personalization: decodeHexString(c, "f6e8a7d60dc77065820cfc97ce0f2f033bf2dcaf199a88ef"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c19e97bb79c8508750186932c6fb6573e4770c611cf57830"),
			decodeHexString(c, "0ecf65a8035adb6346b9f942a4e2170c30a47d36326712eb"),
		},
		expected: decodeHexString(c, "f539cc2e2d0ae7d822edce1cc54fdef805c39f5820ce61eeb47342dafe02f383fb68c6f9e591b41107da8b27ad92b66d85ba0ad02772e199f7a8685a6ca591087cc71c7ed383b0fbcd53f63ddd5ebc7886a4d46568aea167d44e6e3b9d9fd2f831e55c2d6b4a807154b8cac6ac4f18b6"),
	})
}

func (s *drbgSuite) TestHMACGenerate23_SHA224_14(c *C) {
	s.testHMACGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0142a6db5e49eb931eb3d1dda211b959e46a6c5df36fbf72"),
		nonce:           decodeHexString(c, "c77bac27755936b4026d7cc1"),
		personalization: decodeHexString(c, "a1de24491d19189e21e332d2f57981f00124f5b8b177f588"),
		additionalInput: [2][]byte{
			decodeHexString(c, "82f895626afb606f335f5f050f0fdf3b45275e0b451774f2"),
			decodeHexString(c, "d423d43240cb6461402a7755f247573f24fab496e00b2e5d"),
		},
		expected: decodeHexString(c, "b32c753900d4a0a0650d35d0fc918b3aa5f253d4381598ed475147f32c8b002bc08678e45bed1b9b519cb9729972886f85e581c75d3c2c9fd6ced929be29aa3befcd1d3fabefec590ca55612c1a0409446a01398d0e4775a548d118a32f29b0dc29530329d2a7656e5d3ef66db2b9726"),
	})
}

func (s *drbgSuite) testHMACGenerate25_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_0(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "04fe18c01c70eb0779aa73572144d0b81954768a73e70ef6"),
		nonce:           decodeHexString(c, "d8d2773dcc931ec0348bf07b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "52d9163da92b7c4fee39e39f8d310623e16ed1864e284de8"),
			decodeHexString(c, "adf9b40f7b95d919a3fa3d8d3322f305413db70045f19406"),
		},
		expected: decodeHexString(c, "4dbd5d3e1a0cbabe3a5d6c275215e2de672436ec7215b628b4af5d4992c9fe32ccf75e812c3ead43717f553b38950ac35e68e057fb140d3e977e25eb9613b52537349b2f922a90ad9e92c67b2d3116322d9cbfd554dbf011272b0d3d9b4c1efa9c87d249e1b2e5ce152b46cdb19b8af9"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_1(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a6a2043c9d5a35edd3a87c3ef76d680fd4e0792f0d0d1029"),
		nonce:           decodeHexString(c, "a74e9ce171fdcf713695ac77"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9ce76390991b8c56a252c3e9355adfd0dc21f642701c431e"),
			decodeHexString(c, "5b08193168e52f4565eba98f798df4ca8170fbcc47b158f9"),
		},
		expected: decodeHexString(c, "7fefda34735500595b8bba1652d5d86ed5426707efb50631de3cedc2417f44879a641f1165fca2395577ab62a4efd3ebac3820cecaf83428ed882eddc6ad577ae0e4d29cc712e504cd015232180ce9d0b062dc554688f25bcd5e3b79e9b906a11a0ffe122c8928410f0639cc1dfe699b"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_2(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3ceef6b6a4ca6aef15044374a5a2258f482f0d41c933a162"),
		nonce:           decodeHexString(c, "e9820df285f44ebd5c0a7458"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "87f498a2c94e4a8591555a966d85aee0a186027de0334eac"),
			decodeHexString(c, "3ec1f65ee04953e563ea5ab65ca89bd2d8337fac2a93774d"),
		},
		expected: decodeHexString(c, "9a9b0a9f6fc51233e18cc47e2002c463bf6ece89d739071852e1b2d532bfcd7779e88d84d22e0506b57a5c032dc89d26eb4840a48ddf3a65dc5bc31383cc2c638379749cc33c826b1cbba5cf425361314db2204c47d3dc0d38b6c017fb733445b95730ad7bc557484ff29833198f64ad"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_3(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c25aaa8d76c66f0ce021a388a6dc8bc475aefbc2e18ea001"),
		nonce:           decodeHexString(c, "4e22fcd37f19f936e097dcf6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "44dd1356503c99dffe7d8cf211643c0d629f7ad1d593656d"),
			decodeHexString(c, "68509fc262f191ea95208c76c9b84f9ed182a168490fb1c9"),
		},
		expected: decodeHexString(c, "8b7775c0632da15ab6c8c56203b87765625204ecae760f01ac19431ee4a58fa458ee565e5ef54d834bceab6a67d0831466e7c15e63da2adb6bdb16e469dd9f460308df80476d32e2ece0677361f07f3241f2ee93e39310a60cdad7fdecb4cae022e48bd2fed69d7937e4b200cfad478a"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_4(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "aa6a6c7083031e4e4e67af56f2e9287734b1f4112088f696"),
		nonce:           decodeHexString(c, "4e9e1b17f3756c23370c6d00"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dbb5237e3d8184b077a159f8498adec1da07205f1df5a927"),
			decodeHexString(c, "ca99c2672b20e6aa37aa2d8db5650ebb2dee685614f7d43a"),
		},
		expected: decodeHexString(c, "de90ba7686bd82f034daab63f4b0ae636775a36d6b83715655f055647d365c3e5dbe6ddede8d05dabc74a5f04214399c606c26213a5167dd0060bf71fc8d7660addf442ac11546f482602b66a883011a39b23925ccfa882f2fc4af178109d056d0ca962083a2c10e5442f86976a9e828"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_5(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0114a3d59ec9e8d2ab2ef6ac509a6ad739ca4aed1ee2d515"),
		nonce:           decodeHexString(c, "027d64d479bff5c27b100bfe"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "392a993b8e5f6d1f1dd0ab0e8a88d13cfec95c785fa0b384"),
			decodeHexString(c, "555d0b602dcbea92b5653467b0d96cc9adf792e7555e826e"),
		},
		expected: decodeHexString(c, "3e9a92f64afe5caf818e2df55085c7f11e87457007bd3feb5ce47d299ee9eb0688f08a1590d4f3b02f9655f683b743ecba6b601054e0f59ae68d713a17b8491387fde3d09a2c121175aa3b0647cc7af467918b876437c8bff8c1fd44e81fa968d907e1823eb31ba6acac0cbed087f7a5"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_6(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d45cc7d8ef81027104b1e477607310cab779a6e756524905"),
		nonce:           decodeHexString(c, "ffc1d1c455dfbb64cfc72486"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "081da5764e197d2231d8408467001d9fc62af0864aa3b585"),
			decodeHexString(c, "1ceb8e1ba42123046c5e985e440e2d3defa794ce8d02cbcf"),
		},
		expected: decodeHexString(c, "ee691cf740efef2619c839c0df42d54446f2d718ab1d24ab9e12d740b2d3138543141bed82442e509436e6f424cd00042b8eaae417ee84badb11fea087297d44bc4cd05cdd22cedb1b5b8e336e0bca8ce00712d573d480a81144dd19c08a71c8f5ff4fffee8b157566cf146280ad93b7"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_7(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "394316fe580f0777e846b4b9b0f320353c6279f337d52c22"),
		nonce:           decodeHexString(c, "096fa0305f4c34bfd499e6e7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "286c0e78e078e116649cda0a60cce145eb73f0ea2157a505"),
			decodeHexString(c, "62211e071dd9ca0b74bc31976bb0278e1e3147581f2222b5"),
		},
		expected: decodeHexString(c, "07561a1c877000f1a5821e01fc5b4085fe12f23d6be447068aa955153bc2994ca036b8e4fcab23ab2d61296c76c53350b88b3ac0431fb30123e5cc36fdbc90aa377ea143b0c615c39c6ab1e5d1ac26a2a381fdbbb66d319095ad2a620eff824343dba67fbc83e1e2ce0725e9915f26b4"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_8(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1c08eb8091f6699c50fb280daa9ad51779f8a1f436281747"),
		nonce:           decodeHexString(c, "a84fca5456c589c805c06f66"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "efcb121a2d96a8b238b16e3a9e3994e54a929ebeaa22fd3d"),
			decodeHexString(c, "7b794fb66048297ed44d089ae7811578ab93efaae5d0c9f5"),
		},
		expected: decodeHexString(c, "37d83fc06dea430f2a3b20397191dab5cb6845fb519dcf4a558ff6678c271dafa3ccbafb803facef82cf5f2529b5276214bc5ea0b9a1542c72fe50d97c4ad106a246363176126093af34752d148d88d9671411a34ea06fb61da15e320a3c5643fa2fa54bc56b4a5aceb0475af112946b"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_9(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1ba96258c4e4306aa3600b9a8f0c521109a46d08dd1a8375"),
		nonce:           decodeHexString(c, "5ac982b29fb102947c51de9a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9f0d1c1cfab6ed13f74b814f63919b71fcdf10d1df05ae38"),
			decodeHexString(c, "72070d604caee6225a8c907717d359dc2d02a848ddb7eeb7"),
		},
		expected: decodeHexString(c, "b08abb3405ad9594952c4cec6165f9375c9827c1cb8c58e9c79eb6b944a9c5e363db9dda5dd7b3f7c6035cccdd614dfbaa8c548560c06f4393722da3fd6ae06b483931fb508c5f95202aeeb839d94338ac17c2ef0ca82664b00621edbe9be46c9815381a5ec54a484ac11a0a88c0d21d"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_10(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d7bdc1ebf496da1eff58e5186a1d7a035e76a8ff2f83cf0b"),
		nonce:           decodeHexString(c, "d54a573539d9c188ce5dd91f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1d7f360c6ad4d4ae2a7aba058132a0ba932ff13fee459285"),
			decodeHexString(c, "563368ba97764aa6dfcf57ef31eb913b025f5c9c4f9f56fd"),
		},
		expected: decodeHexString(c, "23db14b9e262aaac695bb33c48812582fcd8ae9b26bfc5e92c247c33343a778d0a1de9655df624959795a042160b46d920bc9bfbfa42c9e0d03311753cfc26e9b391e196391ac399f9bb31c03ebd7ad2c422d8dd37707d3281abe9e9485dcaf08555fafc8b304b46bcd567e88b3a03c9"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_11(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "93d14e6200b3ed2a8d4a7226490da3ba6936a2f4fcba1c70"),
		nonce:           decodeHexString(c, "2bf76ffb27bbbb020953bae0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "facc4663ff63ae7776765043497bb0dda1884f9aee4f81c9"),
			decodeHexString(c, "55bee081a8d3e334c1b3e33a6d0a0eba93048d908b2bbb4e"),
		},
		expected: decodeHexString(c, "159d0613e4fa05800c320f3ce188d40440f367ce7a71e3ce2b14e7a5e5a6a106bcfa46184533dc6a5aef114765845f06b2b53152ff370d1b4da09898e25000a3659452ffac0ee6efc6b0a14aa88aa5fece158c53df5778da435e850cb31c7b18372d7358b2a0d3db7c606f9d0d03f884"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_12(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8caf36ee5a6e0c2bf1ed2666ac4d7e94cef284ac243568a3"),
		nonce:           decodeHexString(c, "1be6e893542305eed4574b77"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b3afa95380eb50ab1f8942148a9254373c7f07f1347b3c73"),
			decodeHexString(c, "dce3c8a1e10a064876d120bbf354e3cbaab455f3ddcb3a71"),
		},
		expected: decodeHexString(c, "b4cf8f0b89d6f93aaec9fffa072a04f817dec9228df08f424c22e431cb45c3836ecf5ae80982b36c4b7d7a03798344066fb4922663c6eec0771adebc5aa20abd84490733831e7b707c73778a395e7af07943cf73354736c06098a9180eba242b8b2043964c189dee9f1fb4e233eb8b3a"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_13(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1fdba6009c876e2ebd04a907f38842468d9165406be44133"),
		nonce:           decodeHexString(c, "6293d81c807811a26ae25782"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "65806ae51630678cf1a7fa6f1091849b7678324443347dea"),
			decodeHexString(c, "5747fdaf1d4be67e6edf9321030bb328458b62ade8a491df"),
		},
		expected: decodeHexString(c, "aa6f56f627f3a5de4f2beba08590cfc8e89ed39b87194743049b8cd66c640c7d66ec20750341776a75956d718d454e58f87c2b402bde4487d2bfdf17e25a57484d66d95dae534e3e92cf298bec64e6b772df235b2b653dbfb549256f9fc556fcceae6d9f671f524352c834d9ff997eb3"),
	})
}

func (s *drbgSuite) TestHMACGenerate25_SHA224_14(c *C) {
	s.testHMACGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e2370bba6e4af0791a98c2a2a5d73b2f1951bd0bb0b1a5b9"),
		nonce:           decodeHexString(c, "601da7b3cf9856a79eb24723"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "857ce19dd6e8a45be185875f1a98911062045553e8d28ac2"),
			decodeHexString(c, "b5f1998f0fa38145edb86ae4d569ef4dc2e0aac0a815d3b1"),
		},
		expected: decodeHexString(c, "8f0d978b24bae2a0665beaddfa61e8896ed7976432bc4f7c444699e30b8da1ecbab8990bab9d0d72ef6f6b0b27ede12dc171a43a14092d57e3999cee71b1356da5f29b17fec227ca2a4887bd990fa33e1e01c8a9f900ffbeb300cc5ce9d7d2e25a44fafc07e34acd61d425e0d36fb0f4"),
	})
}

func (s *drbgSuite) testHMACGenerate27_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_0(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "022a4c6703920a5689df3afb8334e81baecb4fb8f3c6191f"),
		nonce:           decodeHexString(c, "8e686ec6b19acc2f5e669f3f"),
		personalization: decodeHexString(c, "a1722895c6cfe54ff7b171298f9ba76a0e2b5ed99fdf683a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9f9b8a01381aa5d3723dd9c40c76b597e36eebacdc1e7e42"),
			decodeHexString(c, "2ec442860656682e7f186aea817cdebea3bf887326cb955e"),
		},
		expected: decodeHexString(c, "cb73479eb95c8a22459a9537cb835f68d57102103ee369c8ad78d6a90f1476c420892ccb336a214dbb209a5347e427a5d680ff2181bc709f1039f8183ccb102cd275d179a807c99936832972ce652712b0fc2f3ca16c1dd941f797c1e1d81ea0792e126f4ef29726fd73e8d685cc7628"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_1(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5cb8edf12ef46abc59dfea601102d778e076e68ad5dbe4a4"),
		nonce:           decodeHexString(c, "265792a997e7acd615426258"),
		personalization: decodeHexString(c, "360f42fbc785e003e4c242f1a97eacd4d1de88614f89ccb6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1121e26ddc2ef9a7a69d44cb380e8a91c4fb1f935ee59215"),
			decodeHexString(c, "cada711ac36e8ecaefa4528fde8796771e17e7cfd767c003"),
		},
		expected: decodeHexString(c, "049e621331992cffee43fe70d1838b392687bab762f14a76786daf5dc8d6ca0b2af3f048c3bf9b2af49c89c9c7748e0fde8da42ee8d820e0d705c9c70a3c296a182454ef116b50c458cca219032e7c5928315aa401ef0afc3cf679a62aa0c031de0af094c022ee95650f7d9a69c303b9"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_2(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "50162c1feea7ab594626a8fe9711c86745106ae7e14f378c"),
		nonce:           decodeHexString(c, "631def7bff27c0e3054071a4"),
		personalization: decodeHexString(c, "eb1560537c45a751136dca5c1672b006524234aae8da0302"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ba520e5e707043967cea95168828f0a918d05e46db7838a"),
			decodeHexString(c, "69d548527c7f36226d339e64fe66746b0341f2c7c2a5b1d3"),
		},
		expected: decodeHexString(c, "d670c6c28adfbdfd8d5e55ccbcd2421098b3369078a9222080e737b8f6b9c0875316010f3417f9eb1e009fb9942dbd39fd7b504473063f4aeae5feae49843fcdbf15ce04cf2b0d367d925470b0051630c19ba65b2c55db39be08fe1c272f343fa95e51096e09fc20f255a8a4e8cd580e"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_3(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9aecda215824e5d271680ef252af5224024301ec79950591"),
		nonce:           decodeHexString(c, "6318b640058df9f89218001e"),
		personalization: decodeHexString(c, "11a33b3a3c7ded4accdf7b5b8b1b10653710abd111ce4db6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "06e4f817a340e346d084d7705de6c3c5af500dd65f65385e"),
			decodeHexString(c, "f3e26425719bd4574f29198a60d7a685bcc15e82d2be5c57"),
		},
		expected: decodeHexString(c, "ccce37199cf030ee149b04e66852ff5187942174854b41e64617c53793d679c9820855d022e0620603db0bf1a39da25c9b4ed5e6545784c0518dd0b8471090ee7d0d7f8a02d4c084291b57b82cec5d1633257a98b1bb3d4dae76405c989eeadfb32303725086d7a51b9c7ff19f274511"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_4(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b1b4f960a8229eb924b963d27b476e18592084a1dcfdd21a"),
		nonce:           decodeHexString(c, "373bc05e7b0b9a30ddba9e27"),
		personalization: decodeHexString(c, "20f41ca210bf19798181c3b9ab6e699929cc5e75eb9ef710"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5b116d567417ffa5881b45abae9bdd2f99436bcab8dd7592"),
			decodeHexString(c, "6ba879343166cf4c3770e3d521afc957ed6c6af1624c21fa"),
		},
		expected: decodeHexString(c, "9eb9e267c76f449c22f9d2de68f4741d4676d269eadf60b9a8762c8e60131375b456b530bf2b4adac3976453af4e7edc6d3f50237a2774346f0c57c9ebb50979bb5147a114d55a45f375abd4bdacab53f9b5566af7aefe6e262fa1c2919b978ddc71385ad3aab88289e81dc796135ad0"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_5(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "79019616b51e0cdb2853b6037469ec5c4041c754847b90a1"),
		nonce:           decodeHexString(c, "ec784efa9dfe6971c1cc8e55"),
		personalization: decodeHexString(c, "7d395c2892559b4ae1b48dafc9e5c5d3c0ada4ce5face41a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "17c03ca3bb1c022a7d5542384eb533cd6c0348642d73fac3"),
			decodeHexString(c, "88d1ec5ae9dbf834c2702d369c2d1e9898e46b0b6304b31c"),
		},
		expected: decodeHexString(c, "15df85c25744fc8d7e7454f57dd09894bd31677e310ea83cf698521eb9874648225b804467e6538d99b36a3d9b9c83ee17fbc74502edaa1f7a81018226ca884868fb60239004b0923effa4f1e26b1345fd8bcc90d4c2ab6c7ec50142e493cf49d659cf90ecd54150dc0fd9703a292680"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_6(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "070a0106f92374d62f299758e69ae583f842ec72af44d970"),
		nonce:           decodeHexString(c, "0f093c2db27472a83e260826"),
		personalization: decodeHexString(c, "28f13ad3dec908373d08b33d3bde86e0a54812617ce6c09f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c7fc449d3f11377c71d9166c04ed1b0071857ef0d9fe8fe7"),
			decodeHexString(c, "9f6f91519e9a7c6843237797f1d227c5e9cf56a67898f3f8"),
		},
		expected: decodeHexString(c, "419852b29cd03c1f38d5fc09bf71f45587f2efae5edf856d1c99b66c83cc7f630b9317ee2ae9659ae1958d5dfded5ebba0a8a030e7d30b4028ab95d0b2e531a86c618cca87d0275389f9a0274312fd9425e5dee6f09def20b733bba07f07b8ea08f68d88d8ba3926a485494153fa4c61"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_7(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "64dfd94b910f10e4195ebc69e9681ce3ca4dfee16692aca3"),
		nonce:           decodeHexString(c, "631f4b1026996f8cfcdcf575"),
		personalization: decodeHexString(c, "076162ff8bb0a469c61af3dffd4f74df8cbd5b708e08730b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3fac3ecc0c79a92dc0d4a1cbb3a9a83d16245eee47ff0efd"),
			decodeHexString(c, "6b341ca2ef428b54a1ba9ba6fff4187884225b8c8c281c3e"),
		},
		expected: decodeHexString(c, "2c2fb0c6a281525c0261a32b5e786574b4e4b5d6f0d56c3fd25211722f4459dcedd912beb885429ab1041f8b372c343fd85937e18be07b0b50d376a431be83cfb6d17b05a9a8051247ce9a72010b563e7855116da31406fdbedcbb673b939b19facdbe0eeb2e8a9e8ba674e4a8a6d3da"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_8(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3d99701d332b175c838564569dcd34b939b26bc5115d38b3"),
		nonce:           decodeHexString(c, "f996619e6da316ff30654a11"),
		personalization: decodeHexString(c, "624fa1183b896862b3a91d97d3d41725a0aafaab37cee49a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7cce65dffcf965ee145980387129bd583ea14924c6a8b485"),
			decodeHexString(c, "32a96ba7c738919bc70ddaf7e56ede000581745cd2d03cec"),
		},
		expected: decodeHexString(c, "710222ee9e0842e124b28c181e4516251d6f9b056153f6e99317ae923fbbd7edfecceb88f6972367f9d0b37895f8aa3b770e27bddc880cfaa684ecfecab130358589cb39580df3d02a5a6314bcff18b42189f05f18118f48a28ef6d97311cd37b7982dcfbfd23d098208cc04c726e8fc"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_9(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "09d68ab04034c996e0e5e8777650d7e2a92275d7b53a5a59"),
		nonce:           decodeHexString(c, "f0f7e8cd33d58b343e80f51d"),
		personalization: decodeHexString(c, "f7bf58d397bcd6bcea308aec59efa4eba816e78bfc6e6e00"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0bc458e7a535e904327963615229f32e1e4d161ee5a169ef"),
			decodeHexString(c, "57f2ba3ca160046f4be60a9a06435f6563df283aeb2ca20c"),
		},
		expected: decodeHexString(c, "0691a9cc63f0f085333555830149f4cbd38c533c5f19f6da8e7cdfead5985d72995f4dfcbc2d0591e22272ea82d3771a2c0f0917ffda91615f1473675ccf8327128672853e2fba30d87ddfc35294031ff4407c3461fdb2285c08c13ab197f8cbe262a8def84832cb12d156bfe812bfd0"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_10(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7c2563d00e707f404d1b64671cda1d682a8b0e016915c5fa"),
		nonce:           decodeHexString(c, "6cb720fe416b4936f6a558df"),
		personalization: decodeHexString(c, "79a7332689b27c25d555a4da362247da22cfc4b050891b4e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b078de49137002c94594754fcd5e87d37dfb3ed443e0a534"),
			decodeHexString(c, "980a9816f5054a51a6d36dcc57638fb328be2511642c2041"),
		},
		expected: decodeHexString(c, "5da237db4ab10c582af1a414895e1123db3332641213fe2b98b6bc0fbd0bc5223d4bf9279e3c9d29cc3cfe87f2690d19f1ef1c59c81a362c1279231be9c4bc11aeec2b3850278c2de9811b450e60dc630303196bf6396f1a56ff9c253ba73af07aedcca761571e9e705d3eed8c07a77e"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_11(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fa5e2962dd0b9865309ac777b82f71908b8b26e7d64a9d58"),
		nonce:           decodeHexString(c, "7ac03535459ad4c37a4dd6a1"),
		personalization: decodeHexString(c, "7ee7f75c5406360d50a484e0236e2144011701740238f7c3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "25cca4922fac43959104249cad6b5c70c703c760ac81350d"),
			decodeHexString(c, "5fcca95cca560af454b26f7790c9753a448fda278b4fb650"),
		},
		expected: decodeHexString(c, "230c6111b9e211f39f54d8d4a8c1bf0a01263654f13e8dfdcf1e7d4724e7f3232c5fa1c246eee098621d6068a794ed5579cc8c32340efb49da83c0d649ff508ce963c0ecfba1a17af432e35d95b153470fa0633ec48f7476b47a1be6f3c432209e1fab9f544cf6ce56d3dc58aae26c82"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_12(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "057fd61e010f1654f6de8e2630c9125a829089ee9cb75e08"),
		nonce:           decodeHexString(c, "f302d50c96452760b2300db7"),
		personalization: decodeHexString(c, "ef35cdba4133e492226f777c6549582b946a55c7f33a801a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a2bad98d0ef95eda7854814d4125dde5cbceda380e000513"),
			decodeHexString(c, "65c7fad6b33db5314b2a5677e08f2b82fd5b32c82dfb87d1"),
		},
		expected: decodeHexString(c, "b62867a85e60a8e56910f86cae706f601e8af19e774fbdb1fbe6fad540bba5cef4b6ed3dc30d6f1431d9b39800112c271ff96a3cacd596cb246deea7a19a70d026254ea4a741b6fab456538da412cb0de7de93d67cbeabcfcbc8cd7ae83cd97dbaa6f77be17e79be36e563fabbdacd77"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_13(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "988cbc2e52b0a36eab9706c7489fae942d2ab0f22eaf0305"),
		nonce:           decodeHexString(c, "9d1ef6c55654a18bf23a208d"),
		personalization: decodeHexString(c, "58b59b66d938016543dd33df1ca9297f9d88fb77ed6c482a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c225736dbe448c61ea7160fe46c93b1ea1ee1e8b6ca4b3ba"),
			decodeHexString(c, "4f641f932289a3a71df6fccc3ed27103eebbf6e350c58d9c"),
		},
		expected: decodeHexString(c, "482b711fffd2002377d900ae25a0feae2e5e6e8e4461bd894b68a9ca9dbaaac40df905585a7e1b5da1bcddaafb71f1fc2091b9c690442f32d7aac8299cc9e982d596a160844c9294424b68772da017b2e136a40db3cd6b6261c6b57061dda5e98730803026f35c9ef2b20f230f9aa48e"),
	})
}

func (s *drbgSuite) TestHMACGenerate27_SHA224_14(c *C) {
	s.testHMACGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a1c84e56a24acad0287f56a89ef64c0f2e954e368394eda0"),
		nonce:           decodeHexString(c, "80a078b026818b775885dea9"),
		personalization: decodeHexString(c, "9b2df6661739c99a27e4a063a838be615b4cb5b4afd118ed"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c9aac7bd9f15385facc344dedcfa754bc9f4f30277a3555a"),
			decodeHexString(c, "42de701acf5622b30e7672bf7115043a9912c1758c1b316f"),
		},
		expected: decodeHexString(c, "972ccd5aa60966bac39aa9c891c7c513244efbfe3446fde6806cee991851f1e4b3d4a4a0c04b57242deb4f53d27040879562fc5b32621b46a642f3c84063c5195faf9b78ed92145821ae554d58325b03d60e11461adaa8ac87876559e1cbe47f7b5c33a8311294b0e54a44c97d4d2c9d"),
	})
}

func (s *drbgSuite) testHMACGenerate29_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_0(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "57ed9a49fba2571876acf0dd2bc02b89c5580ce818441551"),
		nonce:           decodeHexString(c, "488bb9f803f1fe8f5bd3fdb0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "af56a27f7cb757182919b32bbe8e04476e89458122244fb6"),
			decodeHexString(c, "a4e6fb9e9849521942f6ebf0dd8be54ac527834681732820"),
		},
		expected: decodeHexString(c, "027bd4ba165cd02c702b29a091a3a41704209da5ca6eb8289abbb6d7d7b6ee3590111c17971f7c527dd193ccee331c4e35e466f7af854fbc6d1af36c9a2e1f402c83a8baa1c481dc7702fdadd846760d5d9748c7747e6222822d322656b0787e4b0d1505d4212f302aa296588b2eee33"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_1(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f97eaf2cea50200708716bd2b231896ba0844b4e371efa72"),
		nonce:           decodeHexString(c, "f10beae03ad82e7bf049837b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e5fff751d7a3d606ffe1e0f2d9afe25c8d91b5d830dc6971"),
			decodeHexString(c, "8f0606eeace7453bde86feb1f75de6ac185261bd892d333e"),
		},
		expected: decodeHexString(c, "a9256a7271dafc6509dd7f384469a76aba8d2f4fc72ab4da2e3925c744f96e3625e954dd27ab4050b535cdb8cf91da0811fc8b19386e850ca4ec545e3a13aca725a3af6592de9ec99c1d427d25ac044dc29b041abebe511011f6facf447355c1af072f01b4cde8509f446f2e12b91619"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_2(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8cd5d75231ca8e4792c83d7fce6f88cf08f5ca6e5993ae84"),
		nonce:           decodeHexString(c, "d14a6b389365c5cdad41f80a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "502cdc2c3644d478d1600da8f1c5e8bb63b63baea6de1a09"),
			decodeHexString(c, "36fcb7bcaee267608d3a8184f5c0851c7ba1d8324bb7718f"),
		},
		expected: decodeHexString(c, "b7712adf83aff24bfec8f752160fcef6c2a0b91778932c86b799dd18c1d9ddb6234c16667438f98b7ab9ab56072ef02d1beed2dc7a31a4ae75c9ff0ee8791e1783ebf121e3178dd9bb67648097bccb7225aff421369ffd96eb124fffecd03c9d2f7a435755dd3e11f5aa4d95beb9a665"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_3(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7a8a818fb69ac1eacf63b19967e49f0b7547775f5223d248"),
		nonce:           decodeHexString(c, "8d02f1ff4e39f5f282702b71"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e21c1f74db73d31df275ce1c8052fc3976abcffb47aa5fc2"),
			decodeHexString(c, "4f5047dad6802910e7b2d6ec22002508c611456bc758cf92"),
		},
		expected: decodeHexString(c, "04074a749d03cb6849ae7125cc4ac98f635b283732e22a4807b0681e558f471d9757e97cd33739b49fa3634cee0a6f7475c9e4d180a576406ae1112e8e711f581743a8b8db681867afe238a61b3ed6a941e64dba255151de2ffc30febb11a5c0bf042b672948cc5b78a58af48e7655ee"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_4(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "144128dfd03a9e5710c7a87e0612d5676d85e6e698cc955d"),
		nonce:           decodeHexString(c, "8815d69679f4af3360839f63"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f46a0b8d495a26093620d31d048be723c3cd362f0822960f"),
			decodeHexString(c, "1606abb94a27dabba952e0528cff03c53052d70988321b2a"),
		},
		expected: decodeHexString(c, "d9516de14de47c0497a615f8a2f24638464e275ff098f412f73fc76ebb856f8c38fc4ffd028882ae7a6b93f3dedcb2ff427bb37572bcf1f85975cf15da7a791def2ebb1522b96c85e2ccfdcfbdad10fb82ffd8bc255f822eb0b483d2b00ac4c61c6eae2b9fc0ccaa2599393bf9f7b762"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_5(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e7f51ad21fbdf706d26bd2103890d8ee5827545468a48c51"),
		nonce:           decodeHexString(c, "f86f36d35d2d9a1690634c55"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ff6052c815247cc6414c0c1786462a3e8604d7dc73a7cef0"),
			decodeHexString(c, "096ee77eb9ab1394e5cc1f9b9a98974256432a211dca9e51"),
		},
		expected: decodeHexString(c, "c61380c7f75081b8a3d5782a5fdd92b82a9967cd278b79153c478f73e9b88b9a6c669f02ef0e6ded7a3e4a43db39cd68cf4129c5cd8c4eab9776d90617d51cda2cf26f4884c1218552f2087b67af531c1b7f3aef5dcaa22c7bb5162ff999d81fc69e1964561ad3a07b9fa6844ed49b13"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_6(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6e3134d888f819cf669d8c92861346b2463511e7cf7f62ad"),
		nonce:           decodeHexString(c, "4438ea59fa6152be195106ea"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e5dedd87e5e29bb24ac2e61cc5c65148fe3df609de3f342f"),
			decodeHexString(c, "1d11f10e5fc673406a399fdf9189cbcb6751617baf4ad5cc"),
		},
		expected: decodeHexString(c, "da1d8418abbad9dededcc9332fd405e649b7238def5313c7b9a6287eda75df3fde1851ad1f4ea99e0e80958373c6c365a19ac3679e15cc07f704a925c76fc78405ad78bc2d193dff60ba57f4e2d715b3be2d7f11102751f300b7200b31e5221b489b6f736fe042e283b5cac173b9451f"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_7(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d90dc1778098c574e2fbc186b203cb8cc017ce8cbd313749"),
		nonce:           decodeHexString(c, "caefb6f0b71739bfa7aec315"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "925444c097b593a33d53d08a29b5cbcf785642c43a6ec875"),
			decodeHexString(c, "eb838df62496cd815efcec2293d131fc6b77855998721613"),
		},
		expected: decodeHexString(c, "8dc7b7567de8ff7a1a375a4c8c621dbf3ea360e63e081c66a7a86cebce2d88cee483657217b21d023e44fb1252c8c83de4a74249e00879d60c3a357bf1c13dd9a1a167c5f1c012db386646751e4c35675c4bea2bac2a7eee550cd8e759295e523279c3eb88a85e63c85e509c029152ad"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_8(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "eba72f4fd8f29999f93d0407cc412760137dd5f483bc985f"),
		nonce:           decodeHexString(c, "c9820bb038d062b396aaf824"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "89bf37e6a1b5500144f29798eb72f1dd4a976c855cb41c3f"),
			decodeHexString(c, "717a3811f9e7d687a02b90fabff2c7e947d344f43e49ed2e"),
		},
		expected: decodeHexString(c, "6bf825e0be465be76cac3d7c94c908cf9a880a955da7b0c217a1aeb3e1460e5003b5d8a815defbf8f6a896f9395b201a9bce861409e99123227da146aa1d864773481f63aba0c19e6070428ba6a5c05cb235929abf65bfb4a478643744e4afa6aa1530459f21c9cead4843cc9a330d02"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_9(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "56e2c5f09d263e60d797c30945d92df3aefa0d8ce29a273e"),
		nonce:           decodeHexString(c, "91127569f164e04c1427b2d0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d6a0db341d30ef5988c9e6fa7b444f661aca4ff963e94645"),
			decodeHexString(c, "43d236a9d17fb6cff6d492eb1c82d2606f9c622b1618bebe"),
		},
		expected: decodeHexString(c, "2bda1094866b868bf8b100b3ca7a3ca043533a665ac4b1c63d13dc198d79fbc1d919729e6427a692d5b15108ed6401235ae286fce4c2c531337d378bc4a631388471ea83dc027eedfce1ce8311891636525d0104a8d76eb9df8e47b8c64c1eda0c773d8840dbc19ff51bcdc416e77002"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_10(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8aa38e5726c98f290dd015d9087132c5e16dc98eea740ff8"),
		nonce:           decodeHexString(c, "ffa02fd0693919009200b02f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "67d976b2adb1d83e950442d729411924abdc3fbb761c7cf7"),
			decodeHexString(c, "c2d44be44bd4a4440d459ba25d767777edad914427825873"),
		},
		expected: decodeHexString(c, "8d19b2a51412ee64a32a2233657e16715cfcfd2704c4a037c4e30efb0ee7f0c191a8239779b58d5779c342dd44462682cb06db8a09380ec188b7039b1a20441f6c505b65d4f92e31e0bdb3bed1305f1e3b4fb45fe97e68579f140fbaec6c6102058c4ac7f35b562602dfe5cdce2d3cc7"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_11(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f1b8973320e94d0f142f26c497bcff03e934b02abf151a13"),
		nonce:           decodeHexString(c, "3defcaf4a83b45bda6d73251"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3e6c1264d8d62e3dca2e4dc3fa7407f42c68db0b81df6763"),
			decodeHexString(c, "d4195a1edde9ea61da98cdc2615fbba972f281c9987a29a8"),
		},
		expected: decodeHexString(c, "c2a184935fd1b02602a1b68b5046d894a5ad5d66535afc55ed1b10a8e716e7b777410c30517b294250d3cd8a1846bed1d097ae60a6c837210fdca052be42d6c4e4cb5b3ca6ed4f9e69861661d3346eedd9515afe7916edfe7ad9b5cf1dec4aee962d4547039d53e5e32a16463f7d7fe9"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_12(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "de70f82db3356421f41b6658e0f9a7a3cac77de47b7350f6"),
		nonce:           decodeHexString(c, "815776b7591f0d222259030b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5a98a404604feec43818b62a5a917054915f02b2744fb942"),
			decodeHexString(c, "42f5e90130281ef9d547da757bbaa496d15b574e170b54df"),
		},
		expected: decodeHexString(c, "0534e51c3cb4b7a4c2936899d4be18b300e6aa28f6c7e8690f6647f8fa089e97c66dae0b37a4cc03a3aa4e292037efbe2bcd14d4204610499faf43d40d44ec9f149d66fc58d9785aafc51156abf13f34015d8d189bfc0f1a06e44fd45a3a30251a9495a096c19fa01e0252065f820872"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_13(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3c46f1ba7201b00b9780490818edefb0de90c4f92729e064"),
		nonce:           decodeHexString(c, "57e98935fd7b1d57925632bb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1b305372315f9c2c97b9f55dc955e400fc192a179bc48d59"),
			decodeHexString(c, "3f62ad9fb61380cece220ee03739a7b060f8fe64e35db483"),
		},
		expected: decodeHexString(c, "092c0b0a9291f782fabd28b82137294d2ccb3198bdaad49b2ea34b8abcf0f5618db6baed9b821eb9fc3598ff44b57b2a0ec113f3110a36066e964f2b403135cb248dbe127625e5ee3252abe5fd2c2168fbb16436986b984f46683b68ca23bd847dd5b9d6ba875df7a92d367e00895268"),
	})
}

func (s *drbgSuite) TestHMACGenerate29_SHA224_14(c *C) {
	s.testHMACGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9a92ccdb098bf070241207bd861d895a196d7ec4931c5528"),
		nonce:           decodeHexString(c, "aace9acf257721de5c9ea06c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "49a758a4e0a8ce69aa2e5f9b7940c6fbcbfc4fdc91165e4d"),
			decodeHexString(c, "9c8ebc02c3d92d33112a15747b6367b8d6db3447cb9be2af"),
		},
		expected: decodeHexString(c, "70cf10825dab6c1abcc1532a1b2bccd96f0638d02eedb40a7ebf97093f5d0295b6bc74d9e48290ab39260d684effcb401427a4ca62b971e5a31f06c14a9f8e3851c3e79dfe129ecf8a8e185ee58667e2b692474a0d5f0a39f9d794adf1cd71c1266563dde24dc944661acbf849fe69fa"),
	})
}

func (s *drbgSuite) testHMACGenerate31_SHA224(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_0(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6e4d2940460dfbd41e1c73042d21f62d633592c44e83edce"),
		nonce:           decodeHexString(c, "365a5cc795f7dab209136655"),
		personalization: decodeHexString(c, "c851f06ff7019f42a82ae6676bd40564d4f9bbdddb80a195"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1eea9031fb42e7a502836aa6137f05d493333d6b6e3cb863"),
			decodeHexString(c, "b234cda369720bcfe49d09acf7d90f8a8d468d5f3fbd95f8"),
		},
		expected: decodeHexString(c, "2be579cb4182fe2a6581da62357cf15d210a13c0319a19547f908ba85f4323822c877a1ab4a2db438adfb53a77ba61b56b392feaa48d3a4026fcdd4f9122da04c36844a5390f0896b637240529e8338760f50ac6a5c97e69730dc70193e9e2a587c7d0c8f60b9c3c5ca1d2a1835ccd4f"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_1(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e350ff0d2dfc7287bceeb35890a8c15d38dde52b619ad874"),
		nonce:           decodeHexString(c, "276d551d78fb5fd9ca975733"),
		personalization: decodeHexString(c, "26082fcd908f3abe2aa84d994ededf8644074f4533b0c30d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "82deda3adf693b1fe188fee404172fe7f04e7e5006710cc6"),
			decodeHexString(c, "30c1b7ad057fc6aa6d88b8458b108fea96fb0fbfdd40f77d"),
		},
		expected: decodeHexString(c, "0503dc0006ccb729fa9ed9c8f126504d7b61a42a3451cbb6f5b0df877af083083f1a0caeb07d770c96be4a98fdac5dad75c2bb6ff3eef5a76268b4080b3b52666cc476170b17b96610da63dbcc8183d966fa1cb608f393f87c09ef37a0976fa88fbc2171f82631964d17722091259a8c"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_2(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9e43d636e8546d2b308d1b8d63b8a2b4b48d792d74f75d78"),
		nonce:           decodeHexString(c, "04d72917fb0cdb3b04685aef"),
		personalization: decodeHexString(c, "0ebab05bca590442a477decdf924b72ab69a29fca394db21"),
		additionalInput: [2][]byte{
			decodeHexString(c, "83ff05444ed46476bd7edb540943c2d7d6da1ccbff1be85f"),
			decodeHexString(c, "026ac29b358bd73ec4e4fd25c2ed282dd355716082136d65"),
		},
		expected: decodeHexString(c, "f4c39d38ec72d5bc8055f2987a7f9027d0a208ec54aa80db92aaac6c5c95984f34c6d546be242c4705bb61a1e9c52b45cb7aa3aa4ac9d9fc20fb37d3ae3a826761035e6becb79275126e1b85470824a1bb8857b4d54255783e80ed6dee3aa9e0417717ddfe694b79da325c53a66f4027"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_3(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e7dbc930f11c47cad1c811b43f1edb1d101c2754de24bf9d"),
		nonce:           decodeHexString(c, "5b3bdfbbf1e8cf7f14acb1b3"),
		personalization: decodeHexString(c, "4355af238b6c7bb775c5330f78c17462348ebd258d0257bd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5825bbee0a7289c7e1d4849f0a5c4876946daaf0a2c5828a"),
			decodeHexString(c, "d769c70dd273146606de46a518af3a8313a23b1d13efba62"),
		},
		expected: decodeHexString(c, "e2ad257cb76b72edcaa0be8bd98cb768ed88387a30acc5210ac62ffe4d655f3c1b12da9d43104a0c09c48a6410baf9744ce26291f2f66668532438cf6fd21b5fa2caf9314f452f8d0170cafadf450a8916f3f95a65997c439fc1aca0329df2793e04f3ff53e57df913329c74a2e078d0"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_4(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7252fc8ed77209be35d42b771f5007bff64ca5fa84f8eb95"),
		nonce:           decodeHexString(c, "cf279739cd16cccb67acd2bf"),
		personalization: decodeHexString(c, "dc303e18ca804ab2b496bb45cf7ca9c524302d086adb3548"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2ee0a4d9eee2a4ca197e5a43de6b8ab2f29838b980cb0a42"),
			decodeHexString(c, "2d522785f489fa25913a5760f92551f3218c2591a8ba99a8"),
		},
		expected: decodeHexString(c, "065453e6406da76a74064afdb6427145bfb7af78f727006fcf98935a7bd49e7abbdbb971e3003790b3813f702b9c7d2126afa2842e592bc3ae97da02d0ee65ec7388d3937d10367e46abb204dbaf132746c14146fd1795d4390edd9e861b595a7b059426a049fc554928b4e28b9cdca3"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_5(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f3b4ea208a73b1e7cd50a69eabbc0e87c9199ead23fded93"),
		nonce:           decodeHexString(c, "0de6252b958c13f09658d31a"),
		personalization: decodeHexString(c, "a1486d7937f1b1689d2cdeeffe889efff4b083e31cf32cf6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "eba813f6d050984235906af01b1ef86347a8bb4ec013949a"),
			decodeHexString(c, "94d64a4be47b0b817889033911a058f7d35486359b09831c"),
		},
		expected: decodeHexString(c, "1dcb678bdc3fce11c7a1298fc1d5ddbb3d338280b1e8f0b769e6e2373880cd3219fa51d103ef5ab1b00027b9d82a5da47aa1cf6dbd8aff93a7835bb99ca3bf9989ac6f7f25051b6a6fc3991df95cb24c2f1011296f2793ec08a84d50d2ac9db92c0e17c13c96db3433c28b3990165a18"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_6(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "67ca2dc211e366b804a09507909e414173c5969809b6891e"),
		nonce:           decodeHexString(c, "9e02c896c54dac88bb7d203d"),
		personalization: decodeHexString(c, "2621394152ebf2b2cdad3589bce8fc6f1e1e368fdebaf33d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4db685115fc893e24a913f2b68a8c01ec21bcd7910f67fd1"),
			decodeHexString(c, "1a4114929206b34d25883c88c1ab7d6aaac1a8e2143a959a"),
		},
		expected: decodeHexString(c, "77c5b6ebdd3801e3f53344e19ef48e06e7a1be24a553c48687e943928154494c07fe4439732629115324e7d0443afd360c0578e3917a66a2534f52576662b0b7494e7620d24ec00491e79aec4f1ee1f847ddc115399504a0ab0e51213ee4c4189273d5f8969246d3f0d823e00d665ae5"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_7(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0f00a5e8745b3a1b4f94cf750984b096d6b009b7803b7c2d"),
		nonce:           decodeHexString(c, "533a354ffe79aa47264946f4"),
		personalization: decodeHexString(c, "9111a440fdf9bf9d35112665be775f911c03bdaa88d91319"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6f2421cc1eaa8337bb3cd46e1258ce746a36f23f3fb828b2"),
			decodeHexString(c, "93a6e1b05e44cb09d5ba34731f9db7d813083cddb0143016"),
		},
		expected: decodeHexString(c, "11f174162271d85eee49cbc2abfd21ccf5767d3d7c496d8ec4d05e953576948dc5d5607a92c950dbcce1cf9bee799d21fd80a79699c5f8d48d45541184da907ea8e558df51b2841f2bc6b3cbe21b408b2efa67ea46cca6b6f8d0a0004953c542127d0aeda2c30cb9846b261f07efd5c2"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_8(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "27bee9d9c7dcf0706048a9ff4e89a8a543a6176e1165f018"),
		nonce:           decodeHexString(c, "b290f7fc0eca4967fd8b9b91"),
		personalization: decodeHexString(c, "b827439cd5b23ee1d2a59b74338f5630ee8fce0d872e1c66"),
		additionalInput: [2][]byte{
			decodeHexString(c, "222157e5488f3b73773f424a243c879184fa178f35c01ddc"),
			decodeHexString(c, "ba1c25441c4c07bafea1c0a33f9a80d5dd121bc6e56fd3c0"),
		},
		expected: decodeHexString(c, "25977ef6eef6e05db9f7fb78512d43890bb85be9567e268439cd9a296ed863c9f7cdcb9153fc0e35c5d3c135f2cb38c5247cf7fc69f1def95e4319644578492b8f10c5158e3eedeea23037d1f2043858daf7e508cf72125965f406ae8e646b663ea4173a8bbaf8bfeea829bf0d157a26"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_9(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2834539e3fa297082059e7b26ebee3ff38fe12756f044da1"),
		nonce:           decodeHexString(c, "fdf297a9bde8d2c507df4b77"),
		personalization: decodeHexString(c, "3c6602a01cae08d5eaf6847394e10112f72b723c49e47701"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1b987eb9b82aedd4c2ae942335c13c75d6389d6f4159f7cc"),
			decodeHexString(c, "fc7ab0489cc9ebd563b262bea427b82c2da2eb754c7a0b56"),
		},
		expected: decodeHexString(c, "03a8c8966c47075bc7d9c6859c8891b9face30d09b6f7e5c4e108391db5c271ec55fd4f3d91a9e7172bf352232c5e4f92816f13457a7ae09d1bfb1fa2c34fd229cea72707d6b74190ebb4bb1d1d076a08506d25d123257c42cca749eb613d430729daa2c8a9461495d86a6539a222e00"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_10(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "95e91b1792b10fe833b644f5235c6b90791242570e67666c"),
		nonce:           decodeHexString(c, "529b02bccff35643134915a2"),
		personalization: decodeHexString(c, "109b4317810b510ca5b318416d103b334f156c6670a16d98"),
		additionalInput: [2][]byte{
			decodeHexString(c, "db2dc2227a211da34c58b977e6ab45877e641751287f5fc5"),
			decodeHexString(c, "8c85677eb8b70cd69ab5f8ad7bc26025e5971d13caf92508"),
		},
		expected: decodeHexString(c, "757643093c0956fb4e3ea5e90a0ca0ddbe1fcba6a5de312701900a1d9e34c8bee72a2029e8a5a59d25ed2105ef36dfa58fbf91dee667d31d9981d1e3bbaadd1c5a4abf40cf7e232d344bcd44d74efe79e6b23155211197c3b6cba26f4e145948ab1b8be0d999188184a0f3a275c1dce0"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_11(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1a5884a115d4ecb53f95b044ff1e46039d9e4293f0992f4c"),
		nonce:           decodeHexString(c, "7bbf646f678a09e762649a7b"),
		personalization: decodeHexString(c, "441995088e01a80ab65449a091c053b4e0c1e48d27c88db5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1ec6df1a1516e666de0d83c53ca726b19823ea77459ade8f"),
			decodeHexString(c, "c3131ab7a7ad85fa9cdae86f34a79584c19a9099416d3e43"),
		},
		expected: decodeHexString(c, "620c8ea5139338b809d6f2f5f6420e39efa2624600d4a577457365c72e7b87dcd891e7b4e73fb1c27c423511a70374b73425f25b2c86ee760ff86bb49a43b3f984a501627a0f6b751077134652ab19951073f249b3151e572ab8d65801f4a5aa88289dccf5b9933f73a8c847f7b3a86c"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_12(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2547200c9ef949a3d50326e987162f40f7dbaa5f8d21612e"),
		nonce:           decodeHexString(c, "abd90db2b48a25d576b9e773"),
		personalization: decodeHexString(c, "23c858d23feb4778c66d1e7109acca9080e9a0b08210bd49"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4e57767fde19a96ee237bbc7e28f48c4fdd048ad735d218b"),
			decodeHexString(c, "0a380d485a4c3accffa0d08304cf502530bbe3dca1099326"),
		},
		expected: decodeHexString(c, "e56547912d6a028e59577fdeb26c5e69243cac13a3798b21c79749607ecd255e4aa403cdd51d0d717aa8902716f7fdcb1fa0f3c382651578e5a6c6bd568a6e9ecec6de7df5f7888ca9a007ccf48dbceaf27061a8e66e65a15158c26336e311d6f5eb496781c014bdc8420dbda6661ffe"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_13(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "46c98e4b13b41118b76f59e336c71589c93bdb09fa9b2828"),
		nonce:           decodeHexString(c, "fe9b134a2fd031d93d0c3084"),
		personalization: decodeHexString(c, "2b4e017f69170a987effc607b71a360e5d9ad3a7bb3583ff"),
		additionalInput: [2][]byte{
			decodeHexString(c, "968512e2d6612878b68e2716e7fff3d43965c8a2c7f33c7e"),
			decodeHexString(c, "d229b9445b5f07c690ea1b0e4d7fdd740d464ce501ebf47b"),
		},
		expected: decodeHexString(c, "1a685f050da9ad94dbeb7bb94a73c42475d914ea4b3a04b23bd816c88ef50a123a361c6b1ee5a318bba7665f37566e764a5054c18014e5ffe2aa72aa34c5f41cb49e75cfa1440af9156576dcf181d95c83af8b042ea74c12a3cc6d8ca63a8fe1f71cae17ccc8768bbd2c3bee147ab460"),
	})
}

func (s *drbgSuite) TestHMACGenerate31_SHA224_14(c *C) {
	s.testHMACGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "73546ddd5480d1f70142ad1def9b254f04b7970d056bd160"),
		nonce:           decodeHexString(c, "08779f86558a964cd8ad3b06"),
		personalization: decodeHexString(c, "e0475a33b78746e89b835a353fb294ca4c2c9d2ef861a6be"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a58757b98280d90e84d6cf4e2fa89c01a9e6aad22d6cff0d"),
			decodeHexString(c, "a3f5de1ec6d0ccd39fa153899f0c1a414106a2aa182acf31"),
		},
		expected: decodeHexString(c, "b1797707f1217d81c8463b44957df350dd139073b056c50d1c912fa111f9cb488bfb7d2ec6faebd078171cd6b71171ae33698ff96c7225d7fd36ddcfeb2630464974d12b3e03877bc73ce1a2f89aea7ff7ddc8ac85708b35dd94d3972875e2d3e7237ec33871e99301202b52e2ff89db"),
	})
}

func (s *drbgSuite) testHMACGenerate33_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_0(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d3cc4d1acf3dde0c4bd2290d262337042dc632948223d3a2eaab87da44295fbd"),
		nonce:           decodeHexString(c, "0109b0e729f457328aa18569a9224921"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3c311848183c9a212a26f27f8c6647e40375e466a0857cc39c4e47575d53f1f6"),
			decodeHexString(c, "fcb9abd19ccfbccef88c9c39bfb3dd7b1c12266c9808992e305bc3cff566e4e4"),
		},
		expected: decodeHexString(c, "9c7b758b212cd0fcecd5daa489821712e3cdea4467b560ef5ddc24ab47749a1f1ffdbbb118f4e62fcfca3371b8fbfc5b0646b83e06bfbbab5fac30ea09ea2bc76f1ea568c9be0444b2cc90517b20ca825f2d0eccd88e7175538b85d90ab390183ca6395535d34473af6b5a5b88f5a59ee7561573337ea819da0dcc3573a22974"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_1(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f97a3cfd91faa046b9e61b9493d436c4931f604b22f1081521b3419151e8ff06"),
		nonce:           decodeHexString(c, "11f3a7d43595357d58120bd1e2dd8aed"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "517289afe444a0fe5ed1a41dbbb5eb17150079bdd31e29cf2ff30034d8268e3b"),
			decodeHexString(c, "88028d29ef80b4e6f0fe12f91d7449fe75062682e89c571440c0c9b52c42a6e0"),
		},
		expected: decodeHexString(c, "c6871cff0824fe55ea7689a52229886730450e5d362da5bf590dcf9acd67fed4cb32107df5d03969a66b1f6494fdf5d63d5b4d0d34ea7399a07d0116126d0d518c7c55ba46e12f62efc8fe28a51c9d428e6d371d7397ab319fc73ded4722e5b4f30004032a6128df5e7497ecf82ca7b0a50e867ef6728a4f509a8c859087039c"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_2(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0f2f23d64f481cabec7abb01db3aabf125c3173a044b9bf26844300b69dcac8b"),
		nonce:           decodeHexString(c, "9a5ae13232b43aa19cfe8d7958b4b590"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ec4c7a62acab73385f567da10e892ff395a0929f959231a5628188ce0c26e818"),
			decodeHexString(c, "6b97b8c6b6bb8935e676c410c17caa8042aa3145f856d0a32b641e4ae5298648"),
		},
		expected: decodeHexString(c, "7480a361058bd9afa3db82c9d7586e42269102013f6ec5c269b6d05f17987847748684766b44918fd4b65e1648622fc0e0954178b0279dfc9fa99b66c6f53e51c4860131e9e0644287a4afe4ca8e480417e070db68008a97c3397e4b320b5d1a1d7e1d18a95cfedd7d1e74997052bf649d132deb9ec53aae7dafdab55e6dae93"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_3(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "53c56660c78481be9c63284e005fcc14fbc7fb27732c9bf1366d01a426765a31"),
		nonce:           decodeHexString(c, "dc7a14d0eb5b0b3534e717a0b3c64614"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3aa848706ecb877f5bedf4ffc332d57c22e08747a47e75cff6f0fd1316861c95"),
			decodeHexString(c, "9a401afa739b8f752fddacd291e0b854f5eff4a55b515e20cb319852189d3722"),
		},
		expected: decodeHexString(c, "5c0eb420e0bf41ce9323e815310e4e8303cd677a8a8b023f31f0d79f0ca15aeb636099a369fd074d69889865eac1b72ab3cbfebdb8cf460b00072802e2ec648b1349a5303be4ccaadd729f1a9ea17482fd026aaeb93f1602bc1404b9853adde40d6c34b844cf148bc088941ecfc1642c8c0b9778e45f3b07e06e21ee2c9e0300"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_4(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f63c804404902db334c54bb298fc271a21d7acd9f770278e089775710bf4fdd7"),
		nonce:           decodeHexString(c, "3e45009ea9cb2a36ba1aa4bf39178200"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d165a13dc8cc43f3f0952c3f5d3de4136954d983683d4a3e6d2dc4c89bf23423"),
			decodeHexString(c, "75106bc86d0336df85097f6af8e80e2da59046a03fa65b06706b8bbc7ffc6785"),
		},
		expected: decodeHexString(c, "6363139bba32c22a0f5cd23ca6d437b5669b7d432f786b8af445471bee0b2d24c9d5f2f93717cbe00d1f010cc3b9c515fc9f7336d53d4d26ba5c0d76a90186663c8582eb739c7b6578a3328bf68dc2cec2cd89b3a90201f6993adcc854df0f5c6974d0f5570765a15fe03dbce28942dd2fd16ba2027e68abac83926969349af8"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_5(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2aaca9147da66c176615726b69e3e851cc3537f5f279fe7344233d8e44cfc99d"),
		nonce:           decodeHexString(c, "4e171f080af9a6081bee9f183ac9e340"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d75a2a6eb66c3833e50f5ec3d2e434cf791448d618026d0c360806d120ded669"),
			decodeHexString(c, "b643b74c15b37612e6577ed7ca2a4c67a78d560af9eb50a4108fca742e87b8d6"),
		},
		expected: decodeHexString(c, "501dcdc977f4ba856f24eaa4968b374bebb3166b280334cb510232c31ebffde10fa47b7840ef3fe3b77725c2272d3a1d4219baf23e0290c622271edcced58838cf428f0517425d2e19e0d8c89377eecfc378245f283236fafa466c914b99672ceafab369e8889a0c866d8bd639db9fb797254262c6fd44cfa9045ad6340a60ef"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_6(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a2e4cd48a5cf918d6f55942d95fcb4e8465cdc4f77b7c52b6fae5b16a25ca306"),
		nonce:           decodeHexString(c, "bef036716440db6e6d333d9d760b7ca8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bfa591c7287f3f931168f95e38869441d1f9a11035ad8ea625bb61b9ea17591c"),
			decodeHexString(c, "c00c735463bca215adc372cb892b05e939bf669583341c06d4e31d0e5b363a37"),
		},
		expected: decodeHexString(c, "e7d136af69926a5421d4266ee0420fd729f2a4f7c295d3c966bdfa05268180b508b8a2852d1b3a06fd2ab3e13c54005123ef319f42d0c6d3a575e6e7e1496cb28aacadbcf83740fba8f35fcee04bb2ed8a51db3d3362b01094a62fb57e33c99a432f29fce6676cffbbcc05107e794e75e44a02d5e6d9d748c5fbff00a0178d65"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_7(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "95a67771cba69011a79776e713145d309edae56fad5fd6d41d83eaff89df6e5e"),
		nonce:           decodeHexString(c, "be5b5164e31ecc51ba6f7c3c5199eb33"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "065f693b229a7c4fd373cd15b3807552dd9bf98c5485cef361949d4e7d774b53"),
			decodeHexString(c, "9afb62406f0e812c4f156d58b19a656c904813c1b4a45a0029ae7f50731f8014"),
		},
		expected: decodeHexString(c, "f61b61a6e79a41183e8ed6647899d2dc85cdaf5c3abf5c7f3bf37685946dc28f4923dc842f2d4326bd6ce0d50a84cb3ba869d72a36e246910eba6512ba36cd7ed3a5437c9245b00a344308c792b668b458d3c3e16dee2fbec41867da31084d46d8ec168de2148ef64fc5b72069abf5a6ada1ead2b7146bb793ff1c9c3690fa56"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_8(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a459e1815cbca4514ec8094d5ab2414a557ba6fe10e613c345338d0521e4bf90"),
		nonce:           decodeHexString(c, "62221392e2552e76cd0d36df6e6068eb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0a3642b02b23b3ef62c701a63401124022f5b896de86dab6e6c7451497aa1dcc"),
			decodeHexString(c, "c80514865901371c45ba92d9f95d50bb7c9dd1768cb3dfbc45b968da94965c6e"),
		},
		expected: decodeHexString(c, "464e6977b8adaef307c9623e41c357013249c9ffd77f405f3925cebb69f151ce8fbb6a277164002aee7858fc224f6499042aa1e6322deee9a5d133c31d640e12a7487c731ba03ad866a24675badb1d79220c40be689f79c2a0be93cb4dada3e0eac4ab140cb91998b6f11953e68f2319b050c40f71c34de9905ae41b2de1c2f6"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_9(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "252c2cad613e002478162861880979ee4e323025eebb6fb2e0aa9f200e28e0a1"),
		nonce:           decodeHexString(c, "d001bc9a8f2c8c242e4369df0c191989"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9bcfc61cb2bc000034bb3db980eb47c76fb5ecdd40553eff113368d639b947fd"),
			decodeHexString(c, "8b0565c767c2610ee0014582e9fbecb96e173005b60e9581503a6dca5637a26e"),
		},
		expected: decodeHexString(c, "e96c15fe8a60692b0a7d67171e0195ff6e1c87aab844221e71700d1bbee75feea695f6a740c9760bbe0e812ecf4061d8f0955bc0195e18c4fd1516ebca50ba6a6db86881737dbab8321707675479b87611db6af2c97ea361a5484555ead454defb1a64335de964fc803d40f3a6f057893d2afc25725754f4f00abc51920743dc"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_10(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8be0ca6adc8b3870c9d69d6021bc1f1d8eb9e649073d35ee6c5aa0b7e56ad8a5"),
		nonce:           decodeHexString(c, "9d1265f7d51fdb65377f1e6edd6ae0e4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "da86167ac997c406bb7979f423986a84ec6614d6caa7afc10aff0699a9b2cf7f"),
			decodeHexString(c, "e4baa3c555950b53e2bfdba480cb4c94b59381bac1e33947e0c22e838a9534cf"),
		},
		expected: decodeHexString(c, "64384ecc4ea6b458efc227ca697eac5510092265520c0a0d8a0ccf9ed3ca9d58074671188c6a7ad16d0b050cdc072c125d7298d3a31d9f044a9ee40da0089a84fea28cc7f05f1716db952fad29a0e779635cb7a912a959be67be2f0a4170aace2981802e2ff6467e5b46f0ffbff3b42ba5935fd553c82482ac266acf1cd247d7"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_11(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d43a75b6adf26d60322284cb12ac38327792442aa8f040f60a2f331b33ac4a8f"),
		nonce:           decodeHexString(c, "0682f8b091f811afacaacaec9b04d279"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7fd3b8f512940da7de5d80199d9a7b42670c04a945775a3dba869546cbb9bc65"),
			decodeHexString(c, "2575db20bc7aafc2a90a5dabab760db851d754777bc9f05616af1858b24ff3da"),
		},
		expected: decodeHexString(c, "0da7a8dc73c163014bf0841913d3067806456bbca6d5de92b85534c6545467313648d71ef17c923d090dc92cff8d4d1a9a2bb63e001dc2e8ab1a597999be3d6cf70ff63fee9985801395fbd4f4990430c4259fcae4fa1fcd73dc3187ccc102d04af7c07532885e5a226fc42809c48f22eecf4f6ab996ae4fcb144786957d9f41"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_12(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "64352f236af5d32067a529a8fd05ba00a338c9de306371a0b00c36e610a48d18"),
		nonce:           decodeHexString(c, "df99ed2c7608c870624b962a5dc68acd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "da416335e7aaf60cf3d06fb438735ce796aad09034f8969c8f8c3f81e32fef24"),
			decodeHexString(c, "a28c07c21a2297311adf172c19e83ca0a87731bdffb80548978d2d1cd82cf8a3"),
		},
		expected: decodeHexString(c, "132b9f25868729e3853d3c51f99a3b5fae6d4204bea70890daf62e042b776a526c8fb831b80a6d5d3f153237df1fd39b6fd9137963f5516d9cdd4e3f9195c46e9972c15d3edc6606e3368bde1594977fb88d0ca6e6f5f3d057ccadc7d7dab77dfc42658a1e972aa446b20d418286386a52dfc1c714d2ac548713268b0b709729"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_13(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "282f4d2e05a2cd30e9087f5633089389449f04bac11df718c90bb351cd3653a5"),
		nonce:           decodeHexString(c, "90a7daf3c0de9ea286081efc4a684dfb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2630b4ccc7271cc379cb580b0aaede3d3aa8c1c7ba002cf791f0752c3d739007"),
			decodeHexString(c, "c31d69de499f1017be44e3d4fa77ecebc6a9b9934749fcf136f267b29115d2cc"),
		},
		expected: decodeHexString(c, "c899094520e0197c37b91dd50778e20a5b950decfb308d39f1db709447ae48f6101d9abe63a783fbb830eec1d359a5f61a2013728966d349213ee96382614aa4135058a967627183810c6622a2158cababe3b8ab99169c89e362108bf5955b4ffc47440f87e4bad0d36bc738e737e072e64d8842e7619f1be0af1141f05afe2d"),
	})
}

func (s *drbgSuite) TestHMACGenerate33_SHA256_14(c *C) {
	s.testHMACGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "13c752b9e745ce77bbc7c0dbda982313d3fe66f903e83ebd8dbe4ff0c11380e9"),
		nonce:           decodeHexString(c, "f1a533095d6174164bd7c82532464ae7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4f53db89b9ba7fc00767bc751fb8f3c103fe0f76acd6d5c7891ab15b2b7cf67c"),
			decodeHexString(c, "582c2a7d34679088cca6bd28723c99aac07db46c332dc0153d1673256903b446"),
		},
		expected: decodeHexString(c, "6311f4c0c4cd1f86bd48349abb9eb930d4f63df5e5f7217d1d1b91a71d8a6938b0ad2b3e897bd7e3d8703db125fab30e03464fad41e5ddf5bf9aeeb5161b244468cfb26a9d956931a5412c97d64188b0da1bd907819c686f39af82e91cfeef0cbffb5d1e229e383bed26d06412988640706815a6e820796876f416653e464961"),
	})
}

func (s *drbgSuite) testHMACGenerate35_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_0(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5d3286bc53a258a53ba781e2c4dcd79a790e43bbe0e89fb3eed39086be34174b"),
		nonce:           decodeHexString(c, "c5422294b7318952ace7055ab7570abf"),
		personalization: decodeHexString(c, "2dba094d008e150d51c4135bb2f03dcde9cbf3468a12908a1b025c120c985b9d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "793a7ef8f6f0482beac542bb785c10f8b7b406a4de92667ab168ecc2cf7573c6"),
			decodeHexString(c, "2238cdb4e23d629fe0c2a83dd8d5144ce1a6229ef41dabe2a99ff722e510b530"),
		},
		expected: decodeHexString(c, "d04678198ae7e1aeb435b45291458ffde0891560748b43330eaf866b5a6385e74c6fa5a5a44bdb284d436e98d244018d6acedcdfa2e9f499d8089e4db86ae89a6ab2d19cb705e2f048f97fb597f04106a1fa6a1416ad3d859118e079a0c319eb95686f4cbcce3b5101c7a0b010ef029c4ef6d06cdfac97efb9773891688c37cf"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_1(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c2a566a9a1817b15c5c3b778177ac87c24e797be0a845f11c2fe399dd37732f2"),
		nonce:           decodeHexString(c, "cb1894eb2b97b3c56e628329516f86ec"),
		personalization: decodeHexString(c, "13ce4d8dd2db9796f94156c8e8f0769b0aa1c82c1323b61536603bca37c9ee29"),
		additionalInput: [2][]byte{
			decodeHexString(c, "413dd83fe56835abd478cb9693d67635901c40239a266462d3133b83e49c820b"),
			decodeHexString(c, "d5c4a71f9d6d95a1bedf0bd2247c277d1f84a4e57a4a8825b82a2d097de63ef1"),
		},
		expected: decodeHexString(c, "b3a3698d777699a0dd9fa3f0a9fa57832d3cefac5df24437c6d73a0fe41040f1729038aef1e926352ea59de120bfb7b073183a34106efed6278ff8ad844ba0448115dfddf3319a82de6bb11d80bd871a9acd35c73645e1270fb9fe4fa88ec0e465409ea0cba809fe2f45e04943a2e396bbb7dd2f4e0795303524cc9cc5ea54a1"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_2(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a33288a96f41dd54b945e060c8bd0c094f1e28267cc1dcbba52063c1a9d54c4d"),
		nonce:           decodeHexString(c, "36918c977e1a7276a2bb475591c367b7"),
		personalization: decodeHexString(c, "6aa528c940962638dc2201738850fd1fe6f5d0eb9f687ff1af39d9c7b36830d9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "37ee633a635e43af59abdb1762c7ea45bfe060ec1d9077ecd2a43a658673f3c7"),
			decodeHexString(c, "2eb96f2e28fa9f674bb03ade703b8f791ee5356e2ee85c7ed5bda96325256c61"),
		},
		expected: decodeHexString(c, "db2f91932767eb846961ce5321c7003431870508e8c6f8d432ca1f9cee5cdc1aed6e0f133d317eb6990c4b3b0a360cdfb5b43a6e712bd46bca04c414868fab22c6a49c4b89c812697c3a7fbfc8ddf10c8aa5ebf13a09fd114eb2a02a07f69786f3ce7fd30231f22779bc8db103b13fa546dbc45a89a86275281172761683d384"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_3(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5f37b6e47e1776e735adc03d4b999879477ff4a206231924033d94c0114f911b"),
		nonce:           decodeHexString(c, "7d12d62c79c9f6234ae0314156947459"),
		personalization: decodeHexString(c, "92d4d9fab5f8bf5119f2663a9df7334f50dcde74fb9d7732f7eba56501e60d54"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c9aef0d7a9ba7345d08b6d5b5ce5645c7495b8685e6b93846ffcf470f5abd40d"),
			decodeHexString(c, "50d9d1f5074f7d9f1a24a9c63aa47b94da5ba78db1b0f18e4d4fe45c6875813c"),
		},
		expected: decodeHexString(c, "20d942bbd7d98700faa37e94d53bf74f2d6bd1d8c95c0b88d842c4857797d59e7c8788aeeac29740122f208f703bf35dc32b0035db0648384feb6aa17a3274bc09b2d2b746c5a06fd82f4469fb86131a49482cb7be7d9b4b95042394cfb18b13f333ec0fe5c227bf1d8f33ecb2e42e358b6c3e034cb585331bd1d27f638029b9"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_4(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2311c5afd64c584484b2729e84db80c0b4063fe9ca7edc83350488d7e67264a0"),
		nonce:           decodeHexString(c, "6a6dfd975a0dc7b72df1f107c4b3b3a6"),
		personalization: decodeHexString(c, "2abd870ec5fe26ed14dfa57a3309f920131b70580c3639af2645cd1af93db1b1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c6e532a3b25653b6002aed5269cc2118749306e736bde039d4d569d4f967773f"),
			decodeHexString(c, "5e7d26c4da769c373092b2b4f72b109fe34bdb7d169ea38f78ebae5df4a15759"),
		},
		expected: decodeHexString(c, "cacaeb1b4ac2305d8714eb50cbe1c67c5a2c0bbc7938fdfdcafef7c85fc40becbf777a4cfb6f14c6eee320943a493d2b0a744a6eb3c256ee9a3763037437df9adce3e2260f0c35e958af0edb5a81debd8bdaf2b8bb2b98b9186e5a222a21609ff58df4cbe1d4898d10d6e7c46f31f5cb1041bfd83a5fb27d5c56c961e91403fc"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_5(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "362ece9d330e1172a8f9e50258476d0c79c3ee50346524ba12d970ee3a6ef8c5"),
		nonce:           decodeHexString(c, "cf11bcb4d9d51311ceacfca8705e833f"),
		personalization: decodeHexString(c, "abb5a8edde02e526449284ecc31bc713383df3ed085f752e3b6a32f305861eed"),
		additionalInput: [2][]byte{
			decodeHexString(c, "746302ab1f4a86b17546bea762e929360f2e95c7788a63545a264ef997c8c65e"),
			decodeHexString(c, "b907c5b2a8833a48e56e819228ce9a050b41b3309f5ca37bed720311d92b33af"),
		},
		expected: decodeHexString(c, "73c7131a558350590053580873ef956ff952f2aa6ff1bea452e013d1bc2afddea2311756dbe756e63ba6258480c48f3f6c1319b5f572f67ca530af09e39413d1d432bea8f89206619618cb0e7c88e9f2033639d0eb0efc20616b64f940da99b88231984c3fb23f19e890576f555fde394dbd4351f17a7ffd5c369379001bda03"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_6(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "cf614bc29946bc0095f415e8bdeda10aab05392f9cc9187a86ea6ec95ee422e1"),
		nonce:           decodeHexString(c, "77fb5ec22dc0432cc13f4693e2e3bd9a"),
		personalization: decodeHexString(c, "e4ce77914ffbc5fddf1fb51edfafdc196109139b84c741354135ec8d314c7c43"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e1e83ee1205acaf6164dc287aec08e5b32789e5be818078db39e53cad589db51"),
			decodeHexString(c, "4e20c0226d5e1e7e805679f03f72452b5bea2d0ba41e0c12329bf60eb3016dd1"),
		},
		expected: decodeHexString(c, "838fdf1418a746aa52ae4005d90c3fd301f648c5770ffef2a9f3912e37a93850cc4b8bfcce910aead0cb75958823b1a62e283901c5e4a3980e4ea36257458e2e4953555819b8852a26489b1d74821f80c9908469b43f124ff7ea62497c36159a47353098a1b9ec32e54800d6704371cc37f357ad74aacc203e9b6db97f94d0c4"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_7(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a8da1d3e233f393fd44d204c200202f7d01896e72c5ac652940cfd15b5d4b0bd"),
		nonce:           decodeHexString(c, "0a112b4cb0890af0a495e0f49fcf6874"),
		personalization: decodeHexString(c, "d2e32799bc822b8d033299bdf63dc35774f7649e935d25be5b10512c430d1bda"),
		additionalInput: [2][]byte{
			decodeHexString(c, "920a82d76fcd2cd106ada64bba232b7b2344f3afe6b1d1d20ee8795144571009"),
			decodeHexString(c, "eeaac5878275372025f8231febed64db6a11273c3c00d625fc80a95f18ad7d3f"),
		},
		expected: decodeHexString(c, "5f6dae489b53d89027b2cc333c700f090152d77b3eaf01d47f56ce6eca9893ef877b4cb560fab0fbdb34e3d1c6cd8480b33c053d2661a10aa531df4961b97d659c7492584236582b3fe701055efa59c328194cd1e07fcffd910d9ee01b7b9e8c8fda7f7ac01a8e203b8b26eb8078a9b9a5021562c44af24089e3ef84c1d5a6bd"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_8(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a77b1ed4ecaa650374e1052c405f1d88881c25c87d13dbe1334d8c1a847fa76b"),
		nonce:           decodeHexString(c, "05c143e2f145db216fe7be9ed23635d0"),
		personalization: decodeHexString(c, "b5c750968ff09ed251d4a1c05342ac843db5246b19045728a634fa4f6e752e54"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ff5937bcd01a363696bf8e40adc8e4ab3e56dbf7e7d09451c99e538785fe6697"),
			decodeHexString(c, "4acb34eea8266badcf8f6557a0eecf3eb4d7a295c876d6175598cb66a388efb8"),
		},
		expected: decodeHexString(c, "ec13eadfcc84e77d2a2efa1a2cd8b1355587cb27feb3d19d75b37f0446333ddb8236e751c63b7a6e595ec24a25051a696dbe8c062dd8896d1446db228a2f10e8094ee07e7ee648ed6bebb2f5ec5aae24c9c640665c28355cc11c116795ecc070790f7fdfc4398900311b6695d5da0175091ed1828d2731085bfb4a20bd86cce0"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_9(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "491686c781e83eb4e21d9989e8d718100b0d21a2c56295888baef1a65f219651"),
		nonce:           decodeHexString(c, "499085296d21065feabf3106101c8d6f"),
		personalization: decodeHexString(c, "d208a72f9ae34f0817669fb04f49239dd31700f3dc9a93db8d75fb79f9b686c1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9ffc61893a293a864008fdd56d3292600d9e2ec8a1ea8f34ac5931e968905a23"),
			decodeHexString(c, "4ff3a397dfdae0912032a302a5e7a07dceca8d9013a21545689319b7c024cd07"),
		},
		expected: decodeHexString(c, "3c258ebf2203fca3b322ad1b016e21c7f5c148425f81e4fb0a0e462dce9dfa569c37a006527768297a5b68461b08912642a341b88c85597e30e7561206886098c4e2d861f11513f0ffdbbc78d3a2dd60c105abbb33c5e05ae27081b690fb8b3610917aa9bf1a4ad74481b5ff8334f14e5ad6a6a1eb2259476078076fb7e3a992"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_10(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "36a5267eeeb5a1a7d46de0f8f9281f73cd9611f01198fdaa78c5315205e5a177"),
		nonce:           decodeHexString(c, "b66b5337970df36219321badacc624eb"),
		personalization: decodeHexString(c, "c2a7b164949da102bece44a423197682ff97627d1fe9654266b8527f64e5b386"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a977e2d8637b019c74063d163bb25387dc56f4eb40e502cefc5ae6ad26a6abdc"),
			decodeHexString(c, "c5c9819557b1e7d8a86fa8c60be42993edc3ef539c13d9a51fb64b0de06e145e"),
		},
		expected: decodeHexString(c, "b471711a4fc7ab7247e65d2c2fe49a50169187187b7978cd2fdb0f8318be3ec55fc68ed4577ad9b42cbb57100b5d35ac86c244c4c93a5b28c1a11c2dfe905d608ec7804dec5bb15cf8d79695534d5e13a6a7e18a887ec9cf184da0cbbc6267f3a952a769403bafcdbb559401be0d8b3300ea7258b4026fc892175efd55ba1a67"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_11(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a76b0366df89e4073a6b6b9c04da1d6817ce26f1c4825cad4097bdf4d7b9445e"),
		nonce:           decodeHexString(c, "773d3cc3290176773847869be528d1a4"),
		personalization: decodeHexString(c, "1bfd3bcfb9287a5ad055d1b2b8615fa81c94ac24bc1c219a0f8de58789e0404a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "edd879fa56f21d93029da875b683ce50f6fdc4c0da41da051d000eed2afefefa"),
			decodeHexString(c, "f528ffd29160039260133ed9654589ce60e39e7f667c34f82cda65ddcf5fff14"),
		},
		expected: decodeHexString(c, "39d1ff8848e74dd2cdc6b818ad69823878062116fdf1679942f892c7e191be1c4b6ea268ecdff001b22af0d510f30c2c25b90fc34927f46e3f45d36b0e1848b3a5d54c36c7c65ee7287d325dfbb51b56a438feb6650ce13df88bf06b87ac4a35d2a199ea888629fb0d83f82f0ea160dc79ed220d8ef195b9e80c542f60c2d320"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_12(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "46571e1df43e5e141235e2a9ec85bb0faf1dc0566031e14d41a2fbd0315653ec"),
		nonce:           decodeHexString(c, "b60ef6a3347967519aabeaf748e4e991"),
		personalization: decodeHexString(c, "759fd8593e3688b23c4a003b655311770d670789878570eb3b155a8e6c2d8c45"),
		additionalInput: [2][]byte{
			decodeHexString(c, "033128460b449e1accb0e9c54508759ddc2538bc64b51e6277553f0c60a02723"),
			decodeHexString(c, "a5e4a717240bdeac18a0c0e231a11dc04a47d7550f342fa9a7a5ff334eb9327d"),
		},
		expected: decodeHexString(c, "9d222df1d530ea7f8f2297a0c79d637da570b48042ecddded75956bba0f0e70b271ffa3c9a53bada6ee1b8a4203c22bfde82a5e2eb1b150f54c6483458569422c1a34a8997d42cc09750167a78bf52a0bd158397af9f83caabe689185c099bf0a9a4853dd3cf8b8e89efebb6a27dba873e65e9927741b22968f2875789b44e01"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_13(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d63980e63bbe4ac08d2ac5646bf085b82c75995e3fdfc23bb9cc734cd85ca7d2"),
		nonce:           decodeHexString(c, "d33ed1dcae13fb634ba08272d6697590"),
		personalization: decodeHexString(c, "acd0da070072a5340c4f5f4395568e1a36374e074196ae87f3692ee40487e1df"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f567677b5e12e26f3544be3da9314c88fc475bf84804a89a51f12b191392c02b"),
			decodeHexString(c, "c01cc7873e93c86e2bfb8fc984cfc2eab5cc58eeef018fedb5cba5aedd386156"),
		},
		expected: decodeHexString(c, "b133446f633bcb40724bbf9fa187c39a44b9c094a0a0d40e98977e5466dc2c9adf62a5f4551eeb6406a14658de8a0ed7487c3bf6277e811101284a941745ce16176acc875f1435e14161772fa84609e8123c53dd03cbb868030835c0d11d8d6aa04a1b6f908248b028997737f54735ec4ed7a81fc868199ffb61a779d9340334"),
	})
}

func (s *drbgSuite) TestHMACGenerate35_SHA256_14(c *C) {
	s.testHMACGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3d99f9b7ac3a2fbe9cf15d960bf41f5588fc4db1e0d2a5c9c0fe9059f03593fb"),
		nonce:           decodeHexString(c, "411f504bb63a9b3afa7ffa1357bb48be"),
		personalization: decodeHexString(c, "0bb5ebd55981a25ba69164da49fa92f2871fd3fc65eb30d0f0d0b8d798a4f8f2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "288e948a551284eb3cb23e26299955c2fb8f063c132a92683c1615ecaed80f30"),
			decodeHexString(c, "d975b22f79e34acf5db25a2a167ef60a10682dd9964e15533d75f7fa9efc5dcb"),
		},
		expected: decodeHexString(c, "ee8d707eea9bc7080d58768c8c64a991606bb808600cafab834db8bc884f866941b4a7eb8d0334d876c0f1151bccc7ce8970593dad0c1809075ce6dbca54c4d4667227331eeac97f83ccb76901762f153c5e8562a8ccf12c8a1f2f480ec6f1975ac097a49770219107d4edea54fb5ee23a8403874929d073d7ef0526a647011a"),
	})
}

func (s *drbgSuite) testHMACGenerate37_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_0(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8ee1df3d864bca351263fa00489d73d4a14c92f022a7cc2473695f4aa28ac496"),
		nonce:           decodeHexString(c, "7772269c9b6fa377349729a2a20bc1a6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e60fd2e75dd0693ab0cdd0bebcf39be34aa2eef17f186e40c97426e91ddc3fbc"),
			decodeHexString(c, "45daae78c6ff1b619460be949b6c6d02e1daddccd6839a38d5f631ac704886bd"),
		},
		expected: decodeHexString(c, "0d44fc2c64abf7e2deb1d4796e244afcd2cbcf543b52c5756b7395eef49480da5a0dc060d7d6b0b5beb6655ed67d13e903e8731b482fff8bb8abd96323a5b4e6b342b1d665fcba0fdd146d41afe3c413fdfb90883170afa62a1fe81d0dd2ad87b2b7db73ef15c5cbdaad876e3f279a0702f6f19a5f523615557aedf62e347d5a"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_1(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5045965f5a7792807b5000b5ddd7fb4505731c8a54fdfaa50b15cc0f8bb554d4"),
		nonce:           decodeHexString(c, "f647bf05ef60f0026786cc892d995d3c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0135cb725e9d586f9915d2957c2314db77dc87a29da5706e79ebeca8aec414f8"),
			decodeHexString(c, "a9dc7482c99a81f802e9cf5e1e010aaa897ef6cb87136a4fb1d565b6a1e3ede6"),
		},
		expected: decodeHexString(c, "0096cda80775920aa62f9753f364c8d644fa398a6236b294e288ea9dedf18cffd0a44633bfa01da886b4ef9e35cfd4bd046162fdadd85952e16ee277456ed1ed4d2b1e6127b331070b275933005300af629af6e311bc58771cd79872eda4c8c1ff01bb6a649b864669f1f8ef3bd48def515ac543b71f791b228f63a83d72eded"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_2(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e1c86f1381aa66d04ef5ad4bf37d616a4f6643173d1255ce9d2d2b280e32b9f3"),
		nonce:           decodeHexString(c, "8d95c6f153a33d023f16a0223fb850b6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5a1ac82649fe40758175ea2190388ae4c3892a77b4b6b7d3ede659ed6412d85c"),
			decodeHexString(c, "f33df558c6c9ff6725f693dae66ae82732c9533ace7a205a76204a730bc703c6"),
		},
		expected: decodeHexString(c, "0396c538b6c78416194759be86aeec309e650fafda1a3dd3b42fd53bee870636643e74c8ad6e2dd66ed8c523773ae73c67307ad9a38ff8eafe17047a5065416ec7a7074e32ccd0614d835845d21ad8b730c3c45636e5e7076d0609d6f418f4288e543886cd873c115b173dab45cf5ed1ee571b130a5c16c5321442513adb06a3"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_3(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f6c342ee8c1ce21c48ef23b7fbb81f09db4a4ba40f9530ac91651d01157cd773"),
		nonce:           decodeHexString(c, "8e5be622de1332f4fc7809d223122793"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "786e9d9fc8a4e69d7debb4ccbf01ccd1cfc01eecbef81e33279f795f0d93704d"),
			decodeHexString(c, "85a54090284c779d8efa30136defd6ed23313591899cf45165e5e96965e2e9f9"),
		},
		expected: decodeHexString(c, "72d4e84f08ae57d9caab729e3023b470aeaeb6c8d46e850bb214e54a4dc6b657577b9328eea54fe3f4ae031a8b510d2f2155dcff10d0aa50f6d977c297bb3569c62c178c3cf6eeaffab9af262bbd6ede1d376bd79260b8cdc4e65c32861a08c4f6a2fbd77a21fb2e4cb01602c978464346e28020ddf06dac7bfa6c1425fefafd"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_4(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e2f4cf8d27ae6f3d13f623c86f9b89d6a4d2ec565a14cdb598cc398bee759e54"),
		nonce:           decodeHexString(c, "4c9ba98dc07febbbb0953e5255712933"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e87c78debf021b4109b9145e7aea28e37cba6dc0809c89565bf9e445ccfe7a6d"),
			decodeHexString(c, "ae6637919e509dcaa8b8988aa1a6d84748888d00880d2057d0aa3799f76ce85f"),
		},
		expected: decodeHexString(c, "5edd979d099429df7ba93da29fd559adf961a7fed541fd6618132a2cff323eded1e4729570a690204a49286da6f22744f45bc52dd7704277fa2583ebd79eec34b2fb9ee548ba150c2cd8245380363b6af02568848b2c4d363fab81d8a50ab7a93b7a4c5ba518717947affc2a8cc7115881687fbac9e243a6a44b72d0ce07bc45"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_5(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c71741d9deb8d267439ad9b02898c8c86bb7c1086a4f849599415ed0e0ed32af"),
		nonce:           decodeHexString(c, "cc01057e084bfb23c304f84b9fb74af2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e0ae8cf8decb7cd7ce0362f3cb9745684e3c545380ae4c106e6017a6b022153a"),
			decodeHexString(c, "691a785a96d36f47ab61a913990f8fa2c2ebd613f965585c328512e2b8875032"),
		},
		expected: decodeHexString(c, "7ba7195b9589ee57c78bdb3c0be0b73aa60cf6ddce6203d4b71290714c034c11477f39ee3035f2c2c67b82b259a12cfdd94b25f1c9ec003071c749f9f49d6bf533046b41df288ee8a9f2c0d5141008b38736c881df2015d471952e04c0b67b1998100186e772033ff0c8e9eafe5b16ae5833691dc261b87fd9394f494af7b91e"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_6(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "113117270694c3bc4e71ddf24b247d1444102b8e59a60a881e237cd608dad285"),
		nonce:           decodeHexString(c, "3d0d8bbfab7f44da510bdc2b3bd82011"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d77151e85c753fa98da13045d3336135919f9b935f63b0c2b2329d48211c08cf"),
			decodeHexString(c, "584f76c57a870b6a56ad16e1e352232790e95d84aa9e9d09ae90aaffbdfcc451"),
		},
		expected: decodeHexString(c, "04ccffc354bb0a1cfb278af71b9a42f178aa766e2bee8b462e18d8a1c9498ec661137e194bd165b7113fb258ff04b11fba53406ad44057f692446cc688faea61863c35e7e962d8dc48b6facd6d94838c64450b1f7ffd49239a70bfd8de7522cd62471d4c9717ae1a501a7c7449ec1b2a8c8cb95a7e3e59fab4ad9cb9bb7bb38d"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_7(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dea80aa984bfab5870a28877c225fe071f087f82098a7678d4e20a7366a5ef32"),
		nonce:           decodeHexString(c, "b80f9014c996e080662d2508dd5aa4c0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b235f3e8666c052ad84806fb10049d17dd789e2c20772c8e6b626c5d18ce58e0"),
			decodeHexString(c, "958e83f41081db21e38aca7915ac89504f96e62e2eb5d307ab95729194135063"),
		},
		expected: decodeHexString(c, "f70d390f57706633d37e5d9a084856fb4bc15b979303869f3e1dcda73898df876667825e85b873ebe05d56113779df1f396e36e4de1710425cc05235401e08b1e55fb07775d2ba525110cd7bb6c810e57320b79e3498da92a913fa5e85ca0a3c779095d03dcd711af791f4495f0d82366124c08482ae01105fe0ad3a030efa7a"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_8(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c54de4b970faa4b67cb09d9f3ca85e95b4130ba12789aee27ac6c428a6eca4bc"),
		nonce:           decodeHexString(c, "85cf6aa08e0415b3e9c1f305bc5a2b0a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cc191b16b837e94f33e202ad65df8f69fe34ec204eec82cadc617c6df1af4089"),
			decodeHexString(c, "6622b70c3fea83c21863f154a08fb186bc5ed9f9fcfe214b727f60e77a07aa72"),
		},
		expected: decodeHexString(c, "1420839289f6be0af1ee01aa5644c85a58c7b9183062e2e40a2987aca2ec6c83dfe1fb3d3a578b644eff81ff5ee3722046681d1a5f81b72a05deca4747b4834e5fb2561027ea226db7b7eb7d8c7927219eae1b33509e94397a7ee756edbe28d203174d66db85911f81f381e15e3f4cb826dcb19af9ed214017c919a6e666cca6"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_9(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f2e16396676fa0d34d853ce0ea226c3871832a48df511c225f711efc3c46f58f"),
		nonce:           decodeHexString(c, "a8bc3b444cc8396f1a08022f63be4d05"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1edda2649c50714fbe61e15cf061c38460802230aedadbe3906b0923269e1149"),
			decodeHexString(c, "9e43abc3d3a481f09bccdaf457da96581bc7d4a65d8af5952eda35e9d01a847b"),
		},
		expected: decodeHexString(c, "bfa514a6126212691aef3a7329f9e1e636b80d376b15758ae489df619ff612ae9d208e8c5030ccf678ab8d4aa841580556d1f91128cfe8998e43880eecd6204dac4874e04b9a359eb2f73921e1b4f0361ac1bd6cfa357e29cec4ed35716c1366608273e295a6a5b97f811c1d7db675ad8573b59b8418771d6215e2c282b1907c"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_10(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6a04d1a90b7666e632cf1d18dbb0a6c7c1d20aec7f9c7ea42fc947a149329cdd"),
		nonce:           decodeHexString(c, "79e323dd7bc28b2bbed53a80e200f903"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9856e5aad41e622f04f2934ab423aee79b649bc066bc9e70451cfc5e65d2d6b6"),
			decodeHexString(c, "a0a0aaf2201c2d12d803b3059d716c27da58041486d9ebe4e20dd1cca09859e1"),
		},
		expected: decodeHexString(c, "8ab2ca3d82615dc53c1eb64f16f369819661c04d0a8bb56dbe5848d154cb8c30aa771b466c916e691e1f5d7564783bfdcbe88b8608321b6b5992291a33b05ebc0e5124efc370a5973011fffffb9905dc92bb1ccefa617f9b033f32e62a842ba7fdecd6e0e49cb858e24eb82bffcbbf63fa834bde4ba80db32bc21bf339eb58f3"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_11(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a99cbd7d274c6d3115ac939ca67d52d0f43ab38fb354df110264eb7d462be1ad"),
		nonce:           decodeHexString(c, "9dfa25936d6a1952c9a2e0bf530610bc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9f41713d7b6159022f093e3aace39fd3239033eb40f959be0e353388b23a8596"),
			decodeHexString(c, "e41b10f633dc719ccb209e6ad26ce3c4623dd6fa40e959fa7704280fc447dc90"),
		},
		expected: decodeHexString(c, "d7cc54165ee2d4fd1d89f9b025dba0bf6c3172aa7f756b6af2048ced3652e97c0241d0e8836b2d919ff43885362f53cd7569a51afa668b2dbb4dcaa23fffeee4dfa10f951c1ebddede97b8cdd5f207707030d16eaef87ae64a98df90fa3974d45ed6d604d3633a17ae90710a39e889eb62f448746a781e94f577f1085546d243"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_12(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4fd0335159cbf717b8c6f4520661cc746836b661719f975647872658d160d440"),
		nonce:           decodeHexString(c, "14b6fdb19e6be030009d189fa3155eec"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fd94b41909b6e6bd5b966073411a54529abce0ca7b96d36d9d5ae0b252938f30"),
			decodeHexString(c, "c20650a1d9ded8e981335bed144373041be44c7c7b0c3681df5cf6a319c0cc0e"),
		},
		expected: decodeHexString(c, "1653ad31fafddc0c56f0609c11d3d97100dccaf0c6421ca552cdffaa9d50d3fe325162589c5c20824002ea9f69d2585f8c7d75f7032b60c6053507f1cabef8f498a6766d7b1d0c7c1137e3b9f8dd06590cd4132f1fae40537ec6685fd67b801830781fba5a395081dc41ac29248710ec279ff7dc07428986bb6b520b4e822602"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_13(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0a8bf98c5c06576c361fa8d2ad062fa285b449547cfd6b07683a9f1b7b5c9441"),
		nonce:           decodeHexString(c, "8198f6a486f6ace1ebefb650d4fb1cc4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "02ee68246e71cb327a402a7c93e681e23f34cfc32ffd215fae52723610a5c19b"),
			decodeHexString(c, "fe0d83222c1ff9dbfef2921a391206ad8474b0e04b7534eeedd3a05dfc299c9b"),
		},
		expected: decodeHexString(c, "9d222c7ac62a830f7deaa90394a73e0178f192c94e1781e8dc7588a9723f7d10939445e5d0529cecc8fc383bf9e5885eb6430706eedd7b99f918659d397387e9f71204df344230ad958c4a21aa206d2beaae2d45f1435c31d648536df00c8ef9b5f52b40700524e2728f510b2f6d8678339d23861999fc8ba2b96bd08bcf01cd"),
	})
}

func (s *drbgSuite) TestHMACGenerate37_SHA256_14(c *C) {
	s.testHMACGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bf25cb51fd828de8f406d2ae16de1e4e9e4c46262518564e75cd7ae55a5cf04b"),
		nonce:           decodeHexString(c, "6203d68117aa20b980b6b515ffb030e2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "50687524beffed38fe27963340483886645153311dbd4d10d86e7d6b260e0c4b"),
			decodeHexString(c, "1e3ebe4a54c3092d540ad2898ec3be1af84a1d515c013632402ffdeede7caa8b"),
		},
		expected: decodeHexString(c, "007139a46072d9dbb6589b8ecf5f287d3aebb13b480ffcd6e95f0b2f916cd99e75f30a21971298257a80c17e9e41f8e0874dc9da8f6c18007a6e4cd5971df083ae62bb7b9f1bd4926f17e5574535f6009c0068b4ea3a50e2ba6c6aa6c7729fbe8ba58b4b795740ff6ae2f3d6fbe3e06828080cd1dcfb11771ec98ad9e0bac0b7"),
	})
}

func (s *drbgSuite) testHMACGenerate39_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_0(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "191c4f0bb2853d9392dbab6defc8ca2eae6cb47d9a412d0490db7d08244cb70f"),
		nonce:           decodeHexString(c, "9044a8503b55ef8f40063fcf066994cb"),
		personalization: decodeHexString(c, "914fbe6c98771f1cec56223e4493505a31dcde5f9700a121be232c044f06a10f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b57d926494b263f4ffec0190e73ac6699e1e40f162b5a6098d3a53a18dcb68b0"),
			decodeHexString(c, "275e7cbb53ced5fb5f063ce257d36e8319b64c89fd728f78701cc8168fa4aaa7"),
		},
		expected: decodeHexString(c, "2cf8b9a153666c8655aaaec79a233d4d715117d62d2ebc1902faba663717b9653a40ad4776bf492706751188c2461487e47a6567370b4946e455bf5caefb14e5d8fac20d9c54bde3235e9406705fee3eaab9a1ac4da9497f98a457d1de4bbcefdbf8d72ecafe52e481d140a360fb1a3f5404f3a2f8a361a792bc0e5ff7430bbc"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_1(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "66952a80d175c4c1c9088df2651bf38cf458fa8f6bccadb72a7d28a5634ccf05"),
		nonce:           decodeHexString(c, "e1e98ef65bead7ba5a99fe28cf0b18bf"),
		personalization: decodeHexString(c, "6135d7e64f7fa25226b273e5f3ece934f67aa7c91e71c2d10206731d8cdbc789"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0e35d508e3a21cc189fee36d60f5b7f0307e404c0f8b33d9134a10fcd3bbcb08"),
			decodeHexString(c, "cbc3ad8d3f044ac8e1eeb6bcf34a698f18c4bcea3ab66b76db92f5ec6b378398"),
		},
		expected: decodeHexString(c, "9a2a6accdbc9e2257d7c3379d2d4c9b4814237b993cedbd71a3d1ecd36245edae35415a123ac50f6b8f9cc7ee9043caa37187a24a6e3f7864765f22031ed0f5d87707c4141589a1d837440cd3fe3ec810ce1dc590b0454c8f45ed1c5ae1aecc8cc7272710f396cf0861fbdcea112d03ec2644fd201e012095f6f08fb4a91e516"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_2(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fd2028bda30cba426093d2a4daea714793fd994175a745665ae2a4f73b8c6f1d"),
		nonce:           decodeHexString(c, "48a7d049d27b573c93d8e1337de0f3d0"),
		personalization: decodeHexString(c, "00c8167deb963270bbc42587b70c040502e62c898d9ee5703b8d06df1b33aec7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ca9b267490a8e529a7c7bac1fd524973983858056ab7edebdbbe21d10380432"),
			decodeHexString(c, "8bc8bbe8a26b6783611cc8ed2b758b9b892b0c3b8b8054927e5f5690f20350cf"),
		},
		expected: decodeHexString(c, "0e282478de0fc1b158bf477b58f9a28590f1a5898f0449d516252fd6bf0bdfc6523eaba4497a24d37f69845ca89d25ea727971a6ba46effdd3d2af71de84af3353f092f7ee6d68e51a5da3fce18a67b12914a99126eeef8052ff438898e8c52929bf87fabca66c890abe8b28956f51a85f21a5a1dbda62dfc806a85595a6d506"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_3(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "66e593c788a9489289b73ec3a9d763b251180a995b31ba5e330a86e698208604"),
		nonce:           decodeHexString(c, "25aadd63fd7863fa353a352adb7041bb"),
		personalization: decodeHexString(c, "dd994fb735c46a3173b2ccc874982c86e178c4c35b286f30940f64846ddb50a5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "65a8fdc7be63f403e56245b5221abb40471cf6b03c9a4c9914a8647fef34dedb"),
			decodeHexString(c, "929767a2ae876aececb1ae633f2edc928b16de16b2ba12755ced6a6addcdd95a"),
		},
		expected: decodeHexString(c, "ac67f75eab0da1c905637f87ae0c8d1acd197d26f474b4d6b6570da19d37b21ed394cc187687db391b8d9cf6046c6e4bf85f0f3d19af625b2a211bca589163d6df971ece248e10fea8ffd334fc6fd310fad256cc68323d6fe82783047b18b05f3acb46abb7eebccfa084c8f2e8eda74d25544a929eb8830cac9e34713874bb64"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_4(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "60254f58a67a400f417e849b3350f226dde79de73df115c32def3f3a0e5925a1"),
		nonce:           decodeHexString(c, "9c550f7d7adcdae3ed5bff7063a3df45"),
		personalization: decodeHexString(c, "67d1fa64675fc618b5ca7b98dc2fedfa52a426173048c06bc9a3e73c70e43299"),
		additionalInput: [2][]byte{
			decodeHexString(c, "750f64b0c9458bcbb991dc638802e0ec1ecdff6fb8537ea028cce9788fd1c07c"),
			decodeHexString(c, "45967cbeb58fdea27bc77b8313169279a233a6b24c559c07c8606a3f775f1009"),
		},
		expected: decodeHexString(c, "8c12dbba5021242725698329f5ceab818b523c8fd01c4644568495a3da06ca8d4b0c04d3219ed72020f271e465e66f1c001964aff3ac0a7156e604269fb278bbff1ba413ba2bbc88ce32c47ab085523e43473356c7892c174d18511a540111d5955421f4c090c1f6777dc2293e2f6b855be62e17b6bb6aff8a72c20f107e53a1"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_5(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9152351bd6ee422e7cc23905a84e9df973da9b9ef6be79270b25953b2ec81543"),
		nonce:           decodeHexString(c, "52c8f3b3c1d4ce7b2e4abafe7659fe3c"),
		personalization: decodeHexString(c, "ee6b13a50f5cd452ea6fae660d9601e7d016bca025ca02bf67b91427def585f7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c526fba80085c560436416d85a55ce289fa690693c789e3cbdaefd7733d3669e"),
			decodeHexString(c, "54b5609d580a3f8c8ece8e65c3d185185fe33de9f62dbdac5c76acbf31d4850b"),
		},
		expected: decodeHexString(c, "ae8091d02534162bc8db5c5f180234dd7f379a63c9ff8e0c6a36326beb161f889ee150f283456bd6a6d1b4337b1f988e744335bdc0fa1f29ada54abd1ee0c37c6bf9cac95965485a752fc2613f91d51eacf8ab44a6124624da5101ea1a9fd1b1d779905ed820e7ff2f848c8baef4c3e41c6f715eada4f05366bfd80a1b471fc2"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_6(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d02d4e9a40257703e5eff98648f7e533e41dca57a8eb78ea69d475e7a3b005e6"),
		nonce:           decodeHexString(c, "b6716a283689b9b53a75eb8bc260e0db"),
		personalization: decodeHexString(c, "4cfff605bcdfbc934d8af8d9aee2148983ea754d3eb8946a642c8efe3dcf5bb1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "da7d751dc4de039add6ae6191375636b6800c108edbfbbb1158ae1c2d491223d"),
			decodeHexString(c, "327497ac302dc8d156801e24fe93b3cdbd3ac805358dca693640b4dc0533c360"),
		},
		expected: decodeHexString(c, "e34f023e0daa7c3a1e556f1596594ea78ff023b6752e6362e6facf98299f2aea069b9a78ed1599cf49e29e6784bb6545b04977c7920502dc6187d63fa845ab4036a739c5c16d9efe699b7a3d016f2ec0898a837f056c63b3d4eb99bc2b4e1e5b02e55cce68d85bee1f841c6a922f052a3b1d41434f6bdb48927ed794d01850b2"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_7(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a479b7274d73dd187c52864333aa73ab4d8552539cc1d451ce746f41118c0e8"),
		nonce:           decodeHexString(c, "da8b0333309c81271d860d00834f5667"),
		personalization: decodeHexString(c, "9106f9df83eb13f2c14b445e9a2026b5c6000b34afe2516249aa3012d5b595b7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1083a1771d4d035d9906245cf46e00bf07f9470f766033056501669cd9097fbf"),
			decodeHexString(c, "7b2572fa64aed4a0790311419363056539c93ebbb7732bb407fa43e33a55e0e5"),
		},
		expected: decodeHexString(c, "20f198b797555605e3c0607beada5e704f951f468d5ad9a2ba1a4283d688a4c26c85b6783eac4ad3ad284d6d0af75be668c027432a57dd7cefe76c8c1122e7c5ed7e72c3ccea44d5ea85e1831e1d27b461974cad2cb52f699c664d592819ddd0b90a0dd793a09468fbf7b3db64cc3819e6d9c46798f88428441980121df615c1"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_8(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "046c6e0caca05f66b7c7b0965c64429f1dd7d383b64d03d86ff0655bf41cf616"),
		nonce:           decodeHexString(c, "559d2dd8a47b0bd94e23d28c14126b5a"),
		personalization: decodeHexString(c, "7324a958348d97cb437a1799f097eb2be287558525b102f4921910ce671b0bbe"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7fc8abf7349e5e735f72166142436591c0d4cf6379bceb2371750bcc616c2ef7"),
			decodeHexString(c, "0e6bf7c49078d25f2873e5304c38d232a99c5a5bcf5e76d87b156fa89b750b9a"),
		},
		expected: decodeHexString(c, "cc3dfb7dce2277cbf912cedc6b0543a9fa942fe23c1c7e755724e28d51038d12718bb0d417c731b8e733059b3031e5bdb7b478ae01fc5065ddba94f32d26e9cd524501242d3a99f18c6247f7316be5ae4a03fdd01514b55a22ac821bfdcb82c6b38bd8d5278995d021e0d81d40a35c6fc483ee08c93fb12a2ecb0073f34fa22c"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_9(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a026ab58eb641ab68dff0cddf3b2e07b5cfd9b5f03388d83779add9ad1d447f4"),
		nonce:           decodeHexString(c, "c830a9faf3c3c6b02031fd664633d12c"),
		personalization: decodeHexString(c, "d8840fd34420044938f1bb9258cd0d3404f2d12ed06547542087b1a5bcc21754"),
		additionalInput: [2][]byte{
			decodeHexString(c, "94c14a30b3900aeaf3a0064f8a9cf04dfa70242f3c6aa27428f33fb778e4cd2f"),
			decodeHexString(c, "f4e4c509c219e723a6170e761d7dfda0bb78ce74b953810864c13c3bb6d939d4"),
		},
		expected: decodeHexString(c, "569004db5e2d08287141a62483a3d7874ab668927fc87f4d864f4a92d5121fb47bcacfe09bf7f23fb181395e7d7d7e634ea221a7df5875f13ebde451c296f7c61b4ff5bdfcb2f013bce81df30c2c2f4f1e9f05a78ed90e86cc727765e4b25785ef3225757764fadf059ff3c7fc3e175e37daccd99122597eb92c4aaa6a27629a"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_10(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "22bf25fdaffeec3cf89b615f77d78a271779277ea9706b917eb4d9106bb1430a"),
		nonce:           decodeHexString(c, "4622f84512e9ae07ecdeafa56729bfe4"),
		personalization: decodeHexString(c, "2454a3b2aee313d76235c56af4de49cfccbfabe5befb3e39ea75c6c2aac564d6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "382fba6725b8dbc099f5bfef572723a69283af910df07346b72dc8238c8c7dcb"),
			decodeHexString(c, "98d591352b329d12eef10c23771d90ebade36f16d2b33957befb5e48d24602eb"),
		},
		expected: decodeHexString(c, "971f8a8b9357cbc521b7fde2c16a8f03958fc6470a794dfca80a0032ef9da7c757f955198620e8941094f3b3e3491ded94375ed262f7f42dfa74b671a15c157377fc319c293808c1932b52655484477d19cdbf23e1e90453722a1d61f9f83729c13f74dc1030e1dc5401430d1397381e33efb408a6d657ac297cbd59c61d8a72"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_11(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ada68accc624c8c30c7c5a4d8442110ed7c45a8d6a645693f322d0b4a5beb2d9"),
		nonce:           decodeHexString(c, "e5f2972bfcfa1122282754fc7b3348cb"),
		personalization: decodeHexString(c, "87806a8c4bc013fa85f3cba02a75eaba5f815fb7ad681c98602dd13c91965281"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9adbd48f9bf04a815556017772d2b0a82a2558a16f2b5d9249931a3b8f17341b"),
			decodeHexString(c, "6296a548d31454e14bfc630b4f5fba7c0801f47b16ecb5850e870ac8e9c8ea77"),
		},
		expected: decodeHexString(c, "e5511c5a8cc82892315eae52d2f25930fa03433178ef6173cd4a4128ba9baaf264bd00fe8b1a5ff1d68ae9ccd83f092078c70605c585a4dd1391cfa211ab8fa8bc21c7cad7292b56e0f6185914ebe1b9241d7b51d78952b936455d1a93234b61b4ed47bc7a63d8314f841b16a600c4f375a06deb29f8471a2aa7f7ea8eb34205"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_12(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9779a105bc750feeeda774b832d74a045383b61969d264fccd3be63298295c36"),
		nonce:           decodeHexString(c, "c5415f6853a1b3bf8aa3e15efb452421"),
		personalization: decodeHexString(c, "39cab707205a5d4a4967cb9c5b96604723df6633e3b65600560717015e529ff5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ef1badc8726464042660724afd2a35b61342e215fc8b17549f8ed470a78489e8"),
			decodeHexString(c, "2d2d26f781c0d3393422afd14f90aa74036b0fa585e86c68e36749cf6510ff22"),
		},
		expected: decodeHexString(c, "be0dfb331ba8fa326bd7ecaf2768d3f9efb3a329e26db3dd3b56a1f817d36b240b22ec81ba0db533a98ecba3148de7f0c23ca4f719851208ca3f11cf2380cf757271066257763aa16b804dff1433a2eca3f5b85f0898191913ae2f35212663bea731c123fa8b9697b77cf70b31f559d9c5946e7a5d5ef1f568c4e9180755e13f"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_13(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "590566793eaf2b1deea85296d189a9b9709c42f072a4eed2836bd8e73b537940"),
		nonce:           decodeHexString(c, "c2ff757940d823c72f1fc5526e7c810a"),
		personalization: decodeHexString(c, "dab526476eca7b485bb17c3109e5dc98d24cf605954c39385a5f813cf3c0171b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "65d03afd4c553ed446abbed2a0dbd7c1bedef4c4d4de6dc41a59489e9fa8c61c"),
			decodeHexString(c, "8006e5f77ac2f0613d3b4cb7a7a2eca552a7b6751cf2c23d58391a5712c22da9"),
		},
		expected: decodeHexString(c, "637590a008a9b8d1dfaf6c95b015e57680bd611093e1c4b7dd102ac7a4918614dbee4c801447a91ba5bac589b30382b031d8c0106fb804b67fdccceb3ab45377e89422ed8b1859b8849eece53e29d4793b9a3af0a645173ce380afd99d5e4a8e922c7f6dd1ab3f5752fff2834ae8fa37ac6b221ff9e4e1d58241506180e0a325"),
	})
}

func (s *drbgSuite) TestHMACGenerate39_SHA256_14(c *C) {
	s.testHMACGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8ca489bdb9c34722db712d7d63207fe78bb6ab645bf7ff7c8ccd7acebe555368"),
		nonce:           decodeHexString(c, "2419a6bc6d2e57792264091585427677"),
		personalization: decodeHexString(c, "8f8642092eacad449117d08fbeb49d312f69e3b4658c2dc94c1c0e4d913aff71"),
		additionalInput: [2][]byte{
			decodeHexString(c, "95f6df9905b652de6d08399f61956acf943fe412bc71de60d6b69881f8814b90"),
			decodeHexString(c, "87b818568ed80f7c2e8f5b5d7be403f8badf9fa0e716aaf1d6409957b242aa07"),
		},
		expected: decodeHexString(c, "45b5182f313a26008bb4ab82f68a12e7c783c243ba1ac6d8bfaed44ddddb607f964ace9c3505d59ef5a3691143a4845491661a1dff8ac4de2e56b54e263ac3aef86966fd656b5a65d4f3b89731d50fa919663bd5691678ee5f8f499e84b1822bd0b91409b62cf98c176df7e812513f3252d25d15fe13ef9f253af477d16bcfcd"),
	})
}

func (s *drbgSuite) testHMACGenerate41_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_0(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f3428ae375e688496eb2fb0cd772f429a2ca9a76c032d3c9463cb50e0b5890a3"),
		nonce:           decodeHexString(c, "4cb6959e2fca6e7d20d4fac254f8a7de"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0f5e71a5804e9405e4f8676aba4aacfa4e727e0815a80b90f581fcfba078f842"),
			decodeHexString(c, "7f80c2e83cb9ece1648b04730a6cae9b8f7cea3fd5e2372324100f9642d26f4b"),
		},
		expected: decodeHexString(c, "7df486701b3a8e168094531aca081818d619697bf6c52e65a507a8a100cfd3a12d6fee64707840af7d08ef76d5cc16485157887800bb1dd5193b99496dd5009c53050972ff006739f198d86f9815fd014e54d4dc0f99b364aa77b74ad98c33dc3d007229de7a9a131ea388fc838ac966fc52f4924382ec288fc80d20b046df3b"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_1(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "994a0a73b6df92186f4b1ca970cfe343729800f24047ffdc8927fc828bd522a6"),
		nonce:           decodeHexString(c, "9d85ca8f29bba4f1c01363542e183c31"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e9817932f8d67a67106bd4554c34a1a0a9e6a8daea41cfa17d94843c9b22bc33"),
			decodeHexString(c, "2fb1acc70dff1cfdc6e9d5f5aaf54d47ba35d65bf2a753a42031933dd4831c4f"),
		},
		expected: decodeHexString(c, "04820d0328afe9fdaa1090d8406b4da05d715cf7d109d548a8bbda5252fecd9444e1a5440f55590e3c4d9627f819a50f85f0718dc9e52a575a3b8299ae692fd85aa0012f73ac1df36425b1d3e4d2fb829c2d268492516f648968adce04670e94112dcda0a24a3b20f2afb719e0c29c0de3260a0fa4866bfee297acc9aa5f1578"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_2(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d4af86308ed748abe5d167b5e909beec78dba45b2bc843688ad306ce11b4e013"),
		nonce:           decodeHexString(c, "3c0463a033341482d9a801d48f5dae8e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5b76e99c5cc24ca3ca6d3a2ae00929bcebe1d447e05402aabeb655fd5d0ec317"),
			decodeHexString(c, "9ef2a90d6a55b002a2315c7619102b22cc237f6f57ea1939558a0efdbe77862d"),
		},
		expected: decodeHexString(c, "3e459928d4dd84b7e260b4c61ceae1cd16cd4eefc0fef1ac60a470c6ee2d42c90212dea44a991e0c9958601374b8c189fef1ccef875ae6edc7ee8acbbb9fd8e16e7911a62055e07264494a236508c44006166df0ce858b0d7048acca802ee2f4cbe9d07a4185ee6e389364dadf33cc341412d6d95d6d56c937af61b3c8efefbf"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_3(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "04644f5f4409cf4cccdbdf82fe0c18f2bc402d20639789e7b6910ec8d29a314c"),
		nonce:           decodeHexString(c, "9697c728062baceabd2a07d88afca4d7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a0b73b5b1a0027e57b8b2b1a430eeab72eb714dc08d95077e001587cce1f82d6"),
			decodeHexString(c, "ac28cb0721f8487112a1530b09f2842f0b77381a7b48cc297f32e24363006c23"),
		},
		expected: decodeHexString(c, "602b4925c876c3eb47da8311da030f54354d168cc3afb980ecbce27ac4d87ce85f646e649c3b3e881efa63fd3525a5e27718bc2c29efd5c4a452747e49c9815750b4bf969b4b3e85ca131eb60596b7c32c7208b293bb62708368a079af6134d6dccf6a50cffda785798b9f80146b353727cedf9e6bb9e25a0217ec55ac1b5b9c"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_4(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6a67d9773751e7a143ac8f5a99c633f7178fb241a2269cdbb3c0b32bc649d503"),
		nonce:           decodeHexString(c, "ff0ff303e0e567dd7ddd4b252eef9708"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "57257c55ca2fe1a8a50a20e635109abf7c5850067a520268efad2cb418193888"),
			decodeHexString(c, "92cb366adb81fa8c21b665a7c5fce7b6c9f26c3b21849a38b02e90bfacb5bb56"),
		},
		expected: decodeHexString(c, "6feb7f47c9d43ebc493adf05b8cb3fc21184e424a5b5276978d8ceb2517f872683a55e6f19cb03bbd52b75b7c532b0e9c07045f4e3f432219807a57c25e937475e2c40b4f488dda434693e122f6dddf3934aa1038bf7458cbcbfd53e8aa51ac84463d11460d860205f72fc1a1f11d9bb8b333a3d2d887388da5c4d3d99ca52d6"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_5(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "08aa05db8a9d5b1d61ccb8498dc7a5b6256f7cb07eb4b3d661de84e710dfd232"),
		nonce:           decodeHexString(c, "a0fcb7f1b7c499586d6b3c68240202fd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a80a861d9c93dcd4b3f9771f55d32737fbda4a7de39c0b7f12af1ef26167f49f"),
			decodeHexString(c, "650bc4f4e76c8c62532fd851d775b8ec0427eb7ee47d0fa811ae43b4b8e8be58"),
		},
		expected: decodeHexString(c, "6b4203d79b7c8e591668b0704356e32c67ad3914e1789e372f420ce6a08af752a45aaacfb8e6e1384c98528b00dbf10012c94e2df67b47ccbf8f346e7a5f8c6881bf50fea7abf6c87e27f9619e33a325c891691b735f92b4efcf47de939495e3f718b05bad728ba85d5ace789d6bfd149d472822524822a333c464a82a305b76"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_6(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6ba11a9dd7d9d46bd77e95a199cd4cc34211cf3ef98b2a9b3338d06a9df80e65"),
		nonce:           decodeHexString(c, "6885b88743e571edcd7cb1c2062bc178"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "acb78b034b56232b6251c0ef300cff4eb74913409ad9d761084b038c6e84dda9"),
			decodeHexString(c, "961679305c08c76dfbb8f246a14814e69b0e6b1b814c52787b70b64a8ba669af"),
		},
		expected: decodeHexString(c, "159b2530a2ed2bf561ad577b2a86bb0fe69e78ad6dc533c1da61f8ce40f3610921f2cc36edaa07673869a36676bde3ae95886e057a372843716c18fbcf2b175414b443852544d83489bc2cea194131f47e3a222478450d2a332144ea5cab1c3ef06d3e86c8a901a8ce4ce822f0d6aad20c02377500d65839460588cf455a2313"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_7(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1643caebba4994f361aa30ebb7bfbc05269b94bfe04460ec17198d34402c3e3e"),
		nonce:           decodeHexString(c, "57d6d8dac11901483be9edd9a142829b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e1984dfe543324ee3d01290deac012dd2cc8885defd80d50cc172eee873b2ff9"),
			decodeHexString(c, "5d67e46e7d6333ab3a2f0fe92e8c8e544106a1d707a3b1aa7a318de3feca27bd"),
		},
		expected: decodeHexString(c, "4b5068ba8aa425b779987af553e226168d30a8fb8c11e1f016fa11a0d481ced23d2d8d72dbd4f2371cafa7da2b6058a3b2f4b6d195b3e803015e49ae84ef4b1fb76f60009fe0a99363a99a4afa621f8d9dc88a8ac6c72421f458ee53fd555ed8175b169ccba11f37bf43402d4671b30e70a03bfbec40ee38aed7840415e82f4c"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_8(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "04f03b4059da6f27ee002be1293f9bb847e815725937a20a4b4ddc14cd205868"),
		nonce:           decodeHexString(c, "caa8372e9c756eee3e866e06cd1d8635"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7200badfd5e0b72a2a811b885c640dadc83934045abe6a75abcb4a32e4644295"),
			decodeHexString(c, "9da5ede4dd0f7a19a18fed57682962ed280a1cc5d1f4f31ce75709f85b28874a"),
		},
		expected: decodeHexString(c, "250c97b743594cb37645b07bf1b5cc2b647ad7e833ef409558ad6898773f1288cab24598e326bea0732cbc0ab50c7eab9f7d104a4efe726e25d04d43dea5ecbcfa1c03968a0e6b9ed38dfaeccf2aec4e7e86a99098e0d5166768af280b0dc7d70efd0a758af3dfd35fc8332edfb47c70d0d802e09ec5feff3d3dc5688f6d14ca"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_9(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d5fffc4f57c7b4e45a9b7bf5fef3553c4cc8dffe6e57d2efc0bc324f1900b7aa"),
		nonce:           decodeHexString(c, "2a29436352fda465c64c49680d0fa169"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0f4531bb7d1e47cfbe675c85a77361fdab2a8938dc546ce60a21535590a972fc"),
			decodeHexString(c, "147e0561311ee6787004c40028e9d00798fedd55b7a4cc68d67a9cc44537037b"),
		},
		expected: decodeHexString(c, "0a4261eb4f92e279c13c2a598f5f1652b42893147bb56379325bf135efd275599cab58b1f5e4aeb5d6f0887812cf129a08f7295d77257057c373043a63317466418b3a7531d7c021e46e9b1228e3de2768a97b2b13e4338854ff575725a6c668d43267e27f42f3227a618c815744419da141f4d190874cf45277ad4dca5af077"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_10(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b36567bfc7f655ca65d92b623ed689cd21cc6733dafe6b4d3fe2ad51dccca2ad"),
		nonce:           decodeHexString(c, "e06e4c4fa61ad7850a4effac4da4982d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4ebebee72c9b6f2bd24e8eba40296fda003c09664d12db55860d1f088f7c6402"),
			decodeHexString(c, "65cb123c58f4e38d0f81d9dcd60fd29903af2a67b11df7d23097108d70211a89"),
		},
		expected: decodeHexString(c, "4b487111edc0e1f9a4cb1afc9dcb610c8fe9d48848678bf8a96adc4c934d6111615b5fcc4c239087ce3fe54301aa1c648f3ded4eaaab4c04372f0d2082f726da8027657561ae4b2cc8d651d8099506a31b5a8638547966d69506638567ea10e795681152bcb4e9c167b77a01b9b44c41f3361d247654b295c770d427f445e363"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_11(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bbefdf9f55f4255c7b51563a21eabd43b368c14e1a931a3ed599c393f4f0f884"),
		nonce:           decodeHexString(c, "91557e5e2d7e7d10288c9a6d3eeba345"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c8f142b5ae906928f263b32eacc42dfc09e4edf7661364c621206d3cb81d52a9"),
			decodeHexString(c, "8963c3defb02e45c4932f88d14861dd337b158f2816e19b2e8755b3a0b0aba6b"),
		},
		expected: decodeHexString(c, "44b7f0912606cb938008500512dd286d90dd12d4419405db5ded4e617fd249cb7c1224bb9c4d11515546065f5edc5bfe7fd2d8ffdcbedf22bc30049a2d7e550650a49dc65e7e941e6429728ae5081d2ba1061b404aba6b15f713694ac653497b8a52c7bb55a415547e964d4b487f8390b151f6c5e485f426757f0d739f4aa565"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_12(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "daf8f8a18cb7b0aeb4e9868352c1eeadb819411d7c06ae0c9687d76ed48b3ec1"),
		nonce:           decodeHexString(c, "489c0582257a88bde25f7f1328d16e27"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c824e701fa84122ca549f4cb07dc33efd7eb8f36a9adc449352a2d38cadc39a0"),
			decodeHexString(c, "2efc4ec1d7e1cc02e63d7396ebf91bb624d7c743d2acd5cca7c4cd8c82d26245"),
		},
		expected: decodeHexString(c, "62532b66b5233431874ced72210b676424bb9d4950a366e8c334c505fad419d20ad3b1996a3709ac4e165135c4c3198d3d7340d6c700658078d5182a7dd684d165fd095ae1001deef5d7eff9924ce975ae588e625b7799ef9ee437160129f54f4625761350628b56dc7a38cb04b0fbccd2fc67322228fc179d064e3599080a35"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_13(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9cdc0c9d7e25fe80cb61e3745989498511dc4e5de76833438941c947aca3b1f3"),
		nonce:           decodeHexString(c, "3b81cd9b6082ec5a3d222c14db62f65b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "90c13afc65a139b48374b02e91232223bd9ca319b9dd26e920d277c939e9ecfb"),
			decodeHexString(c, "a68dee224c30d58bb869b3d84aa77f7eab4d4d1e8130012a0d443f9be9a643ae"),
		},
		expected: decodeHexString(c, "c5920441447b8ca365787feb8ff92ffd18d7f28fe7a8c726172c95d642ff3d5b38c4a9f09e72b7c095e73d2ae7d01ca4d9719c318cc1311ea7cb2a40bc8a1d75e4890508bff48fe74da84e657779c94511d608154e48cd252907d4918a36f1f20ce52191cfd9c8f36d48d24b25b81636524b191b86349a5a4883bb078e4f8ef3"),
	})
}

func (s *drbgSuite) TestHMACGenerate41_SHA256_14(c *C) {
	s.testHMACGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "26c7b96f47802510f0a0ed22eccd26c39ae56638aaec9a52d90d1887297999c0"),
		nonce:           decodeHexString(c, "09ffbde5ef15ad645b4daf2b5bf8bbe6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2e51dbbfda8c92f2c838bd85ca5dfd7f35504fae1ad438431b61c2f0625d5201"),
			decodeHexString(c, "00f507a359585778988b6bb6b91f23d4ab29d2adbe632e4cd4646c8cd5f1b76a"),
		},
		expected: decodeHexString(c, "b7adbbf07414551464711ad9a718315b0587db2782d34179b70b4c0e323a91ad9de40933023e3a6be71cd50dc58953ad1bf66354bc45dcd9ea23682d487b43903a8f426182536e170af8b04460c586d8ca56e4c307ab7116d8130634dc9a58e1c3077bbddd6bd58c8a0fb9b18c4b839aacf5fcd711c611db120e6a605745e86a"),
	})
}

func (s *drbgSuite) testHMACGenerate43_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_0(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ea4da988e6c5f0685a587bcba36eabab586a87e2d724708078bb3766a80546ec"),
		nonce:           decodeHexString(c, "9221ed63f8003b6e95f7fc8043f5b01c"),
		personalization: decodeHexString(c, "93dc2c6b8499308ddf040ccf81464f482f09ea44be246f8c09181d488c28606d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "576cd452c79649d871d061bd8e1d7ffbac4687a72e25158c9e1dd87f7194f571"),
			decodeHexString(c, "c30f97e178b95ea29c60f9220bb23b15e9f0dcfacaedf1e825907327d732b0b6"),
		},
		expected: decodeHexString(c, "13ac0a60c6ff5a08f580bd1c039172fced4079a0dbe984242e7b0e113ef6694cece20e53162ec533d1fbef12eed5a10a8b12829188baa15dc52883c9a8317e9c084d3e075221035241ec050b0bd498e5e27fd97df86c22fbc5776d2edc273ca930c0a95877f4201378bcc3173556e9be46b0d55b340de69612c844166c10327f"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_1(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a850b5711449f79f3468e8bdf10df2bed8467546aba6229f257d8bc01b17c051"),
		nonce:           decodeHexString(c, "4ccf750d53e8c3c41dae2201da36a948"),
		personalization: decodeHexString(c, "b664f6ca0987d12db7074a892aa505369499f58fad3973416df415b87ddac56c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f63be9c8490da4996c7d551a9de46dcd1d1bbdf37ad5883749cace9d9f6d9db8"),
			decodeHexString(c, "752dd42b510678dbef74468c1a26558a67f271867b3bb8aaf45b98686ea70af5"),
		},
		expected: decodeHexString(c, "afbea8efd4d50447e1ece2fcb60846b72ea50cc0c46c5afebaa747afe45f03cd2070c9334ee42d10e358dfb378c898f0031f38f5cf5545916cb2dc0b318f491cf3a3d3393a87753b2512cd8163aea85ffe6082dec5ccaa6a6ef85a7b9733cc323ae8748b4c712c273336186e867504b3c7b2468c726fc77917c2280ca0791d1e"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_2(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4d49d3e490132f9330a3b8ed731790da8480f03299e3843920086dbd173ae72f"),
		nonce:           decodeHexString(c, "4d68d064a0baf5834c72bf66472e2f6a"),
		personalization: decodeHexString(c, "4487251a3bef7e408649f03618799af364a3b47f8f804f7d60c2d3b20c53f5ac"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c3745c6eb7669599e2c89a7c6f1c295b5b7373057816a182fc78bc8ad7693a32"),
			decodeHexString(c, "dca71e4c0b76c68118f14cb026627420b27fca09e213db84298032013c285b62"),
		},
		expected: decodeHexString(c, "a93e832e4b542cdc70208e42039e5064201a2ecdc528f609bec2d2695c30c5dba25d43968ef5870d546fae739139f33bb1eb2d4d6b31bdd2d1c52e89aabb45548e1c2cbcded4f9c9069e31a08e5420b3197d9cd70ba625dae9ae41fac18b1886c442b4b5b15c7b64cf80074350bb2f02d62f88b5452133e9567966ae1a3c7331"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_3(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "604f43140ad6c4e8360395a1c5b98f7e86cb8ee78dbe5672c37f58ea24b07fe8"),
		nonce:           decodeHexString(c, "9344f2f41aee9a7741291f7b55d11e92"),
		personalization: decodeHexString(c, "bb981dd8e390829577a610589c401cd41ac4f03271c1987ad30422779599a01f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "48bc9ffc2a1d545180f01ffdbb638af85e532679dffa92b776697e8177c268d6"),
			decodeHexString(c, "4b373c488c7b79479ccc6a4c56a3c1eb1e97356f46c3aeb5bff61b8749fa372f"),
		},
		expected: decodeHexString(c, "767a4152683e8be55b2bbeec6f7a2dda214b7708dfb4eecd064d520e90da7682a89629f6da97e40e1f7c9e532011fa28f42396be604193f7f44221507a24991740c66258bf02f0f3d9431aec19aa76cf5ee2a5744b05c6dc343f1ed270a4b9ebd5326475362b852fe5b44694db8e4c47f847da927a09efd07c80595443fe66ce"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_4(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c90218e658ac6b41dfa4b2820a758c024b6e0cf9abe2b999aaa1e673d8ac81c7"),
		nonce:           decodeHexString(c, "5656251045f3f94c6911a0b238039587"),
		personalization: decodeHexString(c, "bf315bae9e0e691138a15547a692c774a5ffd96b08fae9408bc6ebf94f2dc32b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2e17034a7a3197f62151a691422d66cacd84e39b8626a922f09e6c1e77fe27d7"),
			decodeHexString(c, "dfc297a291dbc6c5dd17cb3b1dfb759a21f58f8333379c8db2bf0de97cca3ab5"),
		},
		expected: decodeHexString(c, "1a799a11b051c6a6fe6d921c41f64c56d0dd84f0c137edc770d37f9a1a787a1ad67d8f1c990776aae08af7c0b9179db8270940db11885b910a1ec502e2f5d66d6c314b7ee65f0ba4b177ff980480af28dfd3709e2d3cc6974ae4c11b9f97b9eefbf32301776422cbe3c9fcf24a19f2e2a3007946303f3700097d872e11febe26"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_5(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8554821e05a966e51cc86d3d0312a94f125f89fff56ab97e0f9db5c746d6f5bd"),
		nonce:           decodeHexString(c, "b208b9d94c4ce82c86b7e5ebbe769c0a"),
		personalization: decodeHexString(c, "4b0e5786ef6cbe46d759aa648613a922ae1c326d4cb8ce741bc1fa81b8f8ac8b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0cd90d16285fb69771d76e031eaabd5f7b9955f717aa00307c4c65dae4bead32"),
			decodeHexString(c, "f03bfff7cdac519ed1465e749177caeaef7308dff57ef41fbf1cd32b8d9b286a"),
		},
		expected: decodeHexString(c, "0dbd52be12081e08c12b4147393db622132ea3deceb140aadafe702252e967c340a4a13f27c72def4b4dd68a12cf9b6b8546226ab2c57b9941c010a572eea0fba9a8749b6e876278695aa73f68cf7a8c86bb52dcbab07cacf19e3b84d2f1c14eb51ae396b6ffac4c93bdb4a3c9e486f2641a37aa0493ed07c70ad3b505468190"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_6(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "021f275f7823b872012c18aa92acb01be5cfcc6d44a4b35cc24659f2e12183c3"),
		nonce:           decodeHexString(c, "ec63898f606538592702d5eca2e4ff4f"),
		personalization: decodeHexString(c, "7f94ad23ba6d54db3d587ef06bdb50dbd4354b33d3d9d03e26fb5117497847d5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "39902b10b045cd42a42286c12bae6f3bdf57f143060c8bea80ae961d46e275d4"),
			decodeHexString(c, "fcc239dfad229994fd6d3cf35e46fb14c1381c259086b41fe719312aeafd3eec"),
		},
		expected: decodeHexString(c, "7acfc3384ced24f616bceef72b052a99f5c2eee9d724b92ddd9a6c466e7df7faf060cc5acaff127a05b5dadad29f6eb8b79c1c07403f609a88a947c5e7d70de1021d19e33bfb68439ea106b434c756a4e687e2602e4407c712eaa4cda2154180128c3ad918b8a9eecc1fd7d52038f0496e38d1ccdedeba1c514c7169762e0038"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_7(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "477e1c8515f368946f5c8b6bb111516d4b756113f37dfe9fc3ecce2efd8b5dd2"),
		nonce:           decodeHexString(c, "a1a6e54762942a4a1dc0d58fa7895bff"),
		personalization: decodeHexString(c, "52dfdde18386885d2b2fc42f98d9d718ae54d31a5a090f8866c5fbaaba90156c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b10900a8968e7b8e117c22d9d97b1fa6c4df0f0a8884d620fcc99c64d351efd4"),
			decodeHexString(c, "72ddcac7064ddff0225f61685af77dbf0d3c73ee335f1cec00da8824a0e03f8e"),
		},
		expected: decodeHexString(c, "6cf275475f9258e86bc31b8c98fa4c69c602371afd32c2222697f2b60f4cf998d59e18ad7b14d44d0b90294b1f1539a912e0f17641b747b5661b5831dcb664ed643c2f4b66f46de05b5f5fa727c64986aebd7093792869e1a251088bb475d1eb6538c4021abbd39d0f774c6cbdb41917d83fa968d96e840faaeb8ed5c11e5206"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_8(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c02380281fc7b8a24e4b28b4e558106bb131efb72fc90cfa38f2c50b00162224"),
		nonce:           decodeHexString(c, "b73690893ac8350e9e2f27967be1a07c"),
		personalization: decodeHexString(c, "4f40a4f971f777ebc4417b6347cc3ccc434d8c7357fae77c16e730fd78b92f86"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8baa40a4eea9e71bdcb642881c6013db16410b6069670f80c60b6b1e8bed8b9c"),
			decodeHexString(c, "421bc6d1fbf940beae669199dd4e9adeb7ea76692f18dd616fb847e450ba83c4"),
		},
		expected: decodeHexString(c, "2b601faccc83c5c023c8a64de29d9065ae372de49405c6283c7cdcd70baa8c5ffd4a072615f2c476b5382b785453bdf1f494dbcb9a678e2046693ea0afb33a63f5febfeb40785daad8e9306bcca89a1399a47ffe883871f55cf0b2b86f375f0bb844234f9ddff66645037b0c8771843aa3b83193d1381faabf013a9a6b34cc05"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_9(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "44c9d13606484d13512a243105405dd124bb31aa2dce7c924acccf7d309f1b09"),
		nonce:           decodeHexString(c, "d8ab01b10063d71c93e3b49244960b0f"),
		personalization: decodeHexString(c, "60a7fbd174c0b4f92fdc3469e1130ab6dcd6dc5a74228a82646ffa0349a60749"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f8515192bce0fea888b7c58d70d37082a3abbebdc7070430336acb4217eac9b1"),
			decodeHexString(c, "068740da4e58c1797760a6790b53822057da817b8ccb99ab77ce49a570352828"),
		},
		expected: decodeHexString(c, "dea55eeec42a4dd2a881c7bdf6059621e2f1ed611b5cd716a7a0e03349c0e74fe71488e2fb272a8a56425ce4d971dc0cab2cab5e8a1e7e855aa33681dfb63b5a30d0f1844deea2ea60ccd5a351fbf1c94acaaae7feb995ce036262b344b0ce964cdad5e3c1cbb9282febc6a298c597ee4bae512861232897200d7116ed10661d"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_10(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3d7b9004662fd21fedbf04b917c6e349c1bcd86e320e87556204bde436ef1c85"),
		nonce:           decodeHexString(c, "7d4fbb77f14977030ed74ff43ad6d6f2"),
		personalization: decodeHexString(c, "d421c84dd0807921503eadbdcf326a4ce0808f342f941e24076a9446d34eb712"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bd7dfc2285ca27999f9fdf7428d59ee77b935cf7412882ec0006cc61f36f01e0"),
			decodeHexString(c, "eda136626ec38aa374b434fdd986e90025ca470fa45e0f4748375806b8dbd38b"),
		},
		expected: decodeHexString(c, "dcf27906dbff8f710a2092d9ace4ffecb9f1d1d4cb104f1d3be76b17ca18aff4db574d1053e2e3437aadb1ad3159547a77b69e4b708bbfe60942e6c2d4efe2ea1bf8150ba61c159e9de88b6b9175390df2381f58b938b83b8f71b115ddcd5471180e4dbce79e815baa6b0a4a3e137c5488b231ae396ad170fda7fbb44bab99fe"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_11(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9a937114e00f83915386b3e66701ce6b1ec7fcde6c302d7383b1218121e38a3b"),
		nonce:           decodeHexString(c, "e24546426e524e670af2188c5360be16"),
		personalization: decodeHexString(c, "ba876365a4a86fdb0af9069c733d4a9a962de2ef2d04b4cc1ac2a50fdff70dd1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bdf92fce03cd2691bc9224c9047890bd0977759189d193cf36f3e7e99e230dbe"),
			decodeHexString(c, "df6aa525733889f65a4a2debc2f08576c22750c4722cdf820b691ec101fdfc5e"),
		},
		expected: decodeHexString(c, "02dec2be8df5d686f391373da54fd1dff7720cd39d2e3eccd85db0d4986cd316cbe0e843f4cde7a90c123dbba566880f009d04e29b51defe3cf30b12d10b8de01b3d86cdce4a16b1142f8e4aa132a18b7225be7be818a14b894608dd9e6476c87b558f3ddae530af49dc16d530e92391b00b828db9b6e49b68258a0e0cca4fef"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_12(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "76560236e3c6c548ba1fc39efc8d952f911e46a297bfb666681e836e5a5baebf"),
		nonce:           decodeHexString(c, "006cef471ce415d5ea83a95c31009194"),
		personalization: decodeHexString(c, "01f0711a8e1164cb97692552849c2a1c9443006f5d22ff2d080f083eb1020c1a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6796a8fe3f9414c5e495b732bd7c4b60208ecb7b318f1d14fb0a197d6a21c6e6"),
			decodeHexString(c, "e949913f3b2f545db51d38d512a0fff24a19d6fb6a2842ede621e357c8c80164"),
		},
		expected: decodeHexString(c, "65addfdd398662599e452ff5e5e690deb62ea73b9d453ff2ca3d164f85677e0beb6ab9dcd7ee9ffa3293d7f0375bc97c87d509e650702dbea33f43961ceb49adc2ecc85d165d53e734c65bffdebcb9d881bd98f8b339c530b267f31e2f28574ba69b5ee3e91cc898dcb9492903bcdb7d08169d007b5a30b14b641d69fd9aaef8"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_13(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7e47e637a043f06e574fe6a718267f0bb5e16bb8e342c7a2e6b2d76ef9f10299"),
		nonce:           decodeHexString(c, "a7564f36c172bec0d2fb2760a7edde1e"),
		personalization: decodeHexString(c, "825e34284577c8b62a5606a9046200238c78ce32e11869ffbc83825e1989cc97"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8ccc4e243c650f3e56bf49e8858ba5f36e0f5dda3aec49bd624b6ca7e832980b"),
			decodeHexString(c, "a2f614aa755f50b7777c354f97ab6ebb9376fe008f10923dff3bd4da6848aacc"),
		},
		expected: decodeHexString(c, "bdf43d744a41c83b45977a4edd5e701dbb913191db52c023cd4be9b03d6971561547a77021926d9f6aca5924e633b7c5503197d47dbf6d412fc28f176f53c5a50d792ecb8cc7cbb5713057bdf17d492daab67c6cb001edc86def7570d356ff83b37f643ff427aecd01133b81d43f6a15e95c4a1b04cfdb614a1724b75f73be70"),
	})
}

func (s *drbgSuite) TestHMACGenerate43_SHA256_14(c *C) {
	s.testHMACGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "517f160ab174f63da837f9ebe5545396f7e78a4171a73a76c6c2244b0715fdf3"),
		nonce:           decodeHexString(c, "b02adc63c0c8790454a6a9d01664dd51"),
		personalization: decodeHexString(c, "f21e5f51f5e119e17a5ba061fe5aad0628c3789f4df3c0d7025b43a5fb155481"),
		additionalInput: [2][]byte{
			decodeHexString(c, "38684dfa6edbd61e464e49f7d01932802a5a5d824db6b1df6087e84a8ecd49bd"),
			decodeHexString(c, "4949b08a12656c497cc6760791982c0d4e674b0f8a14be730a91689ee77e981a"),
		},
		expected: decodeHexString(c, "fda39bf8dc1aa785422281dec946bad99d5ead17cac55d47bdb9bd0a80a72f3c611f92bcf29e3e45475426a7a9f139b755f332cf75035b047697f4131c9bbc9ee825ede9a743b14f02dea122194405864aa2b538ed5cdf40ecf81e02bed1556ce0e7974548f050b084b8f3626c0fb2c7272d42cdcb039af4c7d957e285b53b5b"),
	})
}

func (s *drbgSuite) testHMACGenerate45_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_0(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5643776352534d25cffa8f62c071dda1cf6635008aca89aaaa574b564536e3bf"),
		nonce:           decodeHexString(c, "f79149ab6cf92a106931e51f0541c689"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "125edfcaa0cfa26f2d3ade21f3c7b273e0c4a9211b5b6c9ffafcef4ed1cc9112"),
			decodeHexString(c, "c1fc75f96f393df228685e1ae71539b7d7db0de05887bbdf6236e465b0014458"),
		},
		expected: decodeHexString(c, "52e2a447da5e55d0116aa47e1dafa35aeacdf777c70c3bd6291af7e5a600c5190541669e344f5d2094e014149132743bd8d18c8938399cbb3ac9b99978b4e92f96d3c3a9b4c6ec90bd9eb45d1ccb7935488e490feeaf23b44c6d9d8d99f953dfb67e3897cd03050cf4d85c8c3f124a4c8b90e1bba98f7b9f12898917fccbf6cf"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_1(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c912bb219548b23346f5206f0a66f16698d70ad1997801b9b709d3428cba6d5f"),
		nonce:           decodeHexString(c, "d1cd49802816d55dd41ea08aea40cba6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7703e37fbf2d23995b393a762c7be95315ee0a2f73d17aba55c7fe58773880ab"),
			decodeHexString(c, "e53e736d6ec5558fe50979d280fea1875870826a0cb9cea3cb23bb9b6644258e"),
		},
		expected: decodeHexString(c, "46579bcfee4077dbe7d25255a276a0a57e18797ba395cd727e5114c5b24474b25ab0e19191071492a30bed3090862ea8e203c4a1cbf41d9c48bf5fb51dda7817cebe0cfba43fe7a0f12c24510b9b2ec318b35bedce221ad3353a22e4a5ccad12537d5e5bd77b481793a5788ba6376b751c0134f14d924744ee2c01ccb76fa33c"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_2(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "df3d1d0388742b4a5c010a5a21404311e7753881ee1ec4e2652f00c30b92f520"),
		nonce:           decodeHexString(c, "faafdd9e53737c2678020b95d0c3f7c1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0644dc5880ed92852ed37f8d87f6c6dfcafd6def4446fa0eb432c14cddf2f10a"),
			decodeHexString(c, "d40f131b0e02b1c74cc5e0ad8859cb26a47f996ecb60f2ff8a277760e526d8df"),
		},
		expected: decodeHexString(c, "10f6d23f911b851815260eb8e3fb0ad141bb5f03c830d9d355b021514e483d5608158c4dce73471a31772b864e9250c72b1ef9545eae39acec4af0dda8519607657b5fb39818d725a4ed33c24453e8fb1e8d4e471672b346c0c20b8ed5e0cd356ae809cec1f73ae7529f6e88f321395854f61c35157bcdaf21bf52f2ab51cbef"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_3(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d788812e4e17649951c02c187b15f09fe847e123e7266f4aeaac710f6c3d1625"),
		nonce:           decodeHexString(c, "03cc7c29a190572ea7dfc48294f56878"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2ba83c739f5893d3afe796774c4966509626fda16bee8330c247c012074ab5a7"),
			decodeHexString(c, "47bf4d370178e2ff4880b393ff7ddeb0ee09209b191440e37c780cf4924964ad"),
		},
		expected: decodeHexString(c, "356d211018519a4969fbd68233bf76cbd2c5abd855f2b0abdbafafc3b47f4825c1716b2fdaa1123c2ac1d4f34bd3da754b0aa48ab13823838da5b33bae7caff78ef6a66e5c0c77326dd8f54a5e0869bd2cb0d7204d63304c13d13245ada1df9a97331004d785706b1d0bbf1b6b1de68d370dd125d7951df23f0edd10ae79506f"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_4(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2b6f323b758a84da468d1008e780bc828c8b649fe6328134cfdbc39e19eaac59"),
		nonce:           decodeHexString(c, "17bf7faaad250b6095b85811e82ab79e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "53b4b3e55643f43475782328cbf1e916918da2c2e0c063c54e0a3183e6c3bfcf"),
			decodeHexString(c, "c05ca07aadde27c2eb484648accbf2d34e82f24d08b2ba12c316f2a8c30daa91"),
		},
		expected: decodeHexString(c, "8859aa86fc6cc4b8e55988643f0a2a7bb346843f0d58e3755fc5db925a10a75614a9e246e649fb616d60887645313afe5d0f9c8287c765117418282da310ef1e7b8b43a482da5eb2bf7584b3dc07de022d25de9adb262be5b1f1566d7a94e357765bccfc5dc044345efaad1110b4f5a27e77c503873bf305c42f589df611c880"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_5(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "de116198e5250bfd31ce835fa29f1e559ea333b14127fed0df323342a5d29b28"),
		nonce:           decodeHexString(c, "d7a01a18fa49389b04b27643f2ef1fba"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d85f784b477dd8aba132cad83fd99748aff3572cb04e32530bb7daa937bca506"),
			decodeHexString(c, "78fe739bd0e0b330eb6e98679a9068376b62f95fad49e9627d1297c9de55fe7c"),
		},
		expected: decodeHexString(c, "0d5cc0d9659e8187202ea0bf60dd2f09c29b49598606ef5b0ac4a2f5cb7dbac334dfb56d70a676b4e2f17afd87ec9e277fa089f033616194a2628ecc7ad579f74ffad5eb1becc06e4f30b08673d9b1ba0ce9107bddcf27f44a1f92b5ad6ed6e9ab3f54f9abcfb128d404a1d267a464ec75e880a108fd49501aee99f1a2a6cc21"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_6(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3df5c20c256be660689ba6accac5adecd5f53342e19064c73bb50c5399bfd13b"),
		nonce:           decodeHexString(c, "b354dadec57e7ce6aad195e6bf3ecae2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3520a90f6fd4a937e59a06e8efa102e7912d0d9bf75c097013f8d7d19343bfcf"),
			decodeHexString(c, "79e15cf2c0e4cc093ebaab800a9800a48f2a2e6f6c42cb896022f6364cd768b7"),
		},
		expected: decodeHexString(c, "42a72ddb7f4fcdd6c881d6e80451d2e7a69abe8f526b222b62dc826b19734ab4bf59d5e79be1672b93ae761b6d63f44185a07a03538fc011d9881cfa2fbdd5069041c3b078208ff4c3e3853fe67f5637bd80df5f23ba76ef07a2655a0f188b5e073fc767fe66a4610764182abf50410ac870fc3078a1ec21e52da984e9a08d8b"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_7(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d7c7dd4af3480bd34e28366c21ccb2a03dd7015817a69de1e7e4388fe9e88523"),
		nonce:           decodeHexString(c, "3452fe913fb5177cca02e65d991a25b6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c4b1de6ca48fc3332114ee93f1734f1ecd694cb7e40f0dc9ae770a8607b5df97"),
			decodeHexString(c, "835df8e83f7a03573946e21e3fe58e6e7906301f4493b7f682b84e60af680c4e"),
		},
		expected: decodeHexString(c, "c0162dd685dd8e73a586332dcba95807e45a3682b8908f3f211e24243b50a34125f988eb442d52e09f003cdcd4a3caad2017541c006f0a79909cac5103d4fde05fcd2b58bf005afff016ccc310d5a85e4992beb7b8356ab4041a2de38d0981c49dc00cabdf7508d73c92bd68792bdf619e1d735bce469023eac891579e08b9f4"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_8(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "741ad501296d3f18680655d5ff88efe7db6e917af6d26df9bd20895a70381d11"),
		nonce:           decodeHexString(c, "8281033e701a290c81edee11571297ab"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "90221d164e9b0db5fcdd9e48e0515dd578a837de7897055fee7b8d83887b3ecd"),
			decodeHexString(c, "85f8198b9258b2855286c1327d54062ff733c0e5a9c3a6f9cf2a2c85e4808779"),
		},
		expected: decodeHexString(c, "d7e7f32d8b6a82c071094879d15d12d96c3ac653fb555ba6946a11664d01a554ed82c0fd550e6b0151cc3aeba5768842878c049f2d2e2dffef1d5efeea2e27e76925e094c7091edf885c14e9700d46000f2959abb7f2f5d29886d857a18d74000f91bcadce8212835379522083ecd5a76a157bfcf9a7c822949927c3472c30d8"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_9(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "561a4330c56e459bf7fca66a3ae97be126fcd81f56b497d4f0c03d45313515fe"),
		nonce:           decodeHexString(c, "8e0e519bb591cedfb5754f10757b4a2a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c052616877a19a2447f447bda00933695cb17ae4a983eba2455079e7505dfd54"),
			decodeHexString(c, "1a77a9fc49455e6a7f267e3720708f2b8921dcc6b672b58bb4721b1e356510f2"),
		},
		expected: decodeHexString(c, "50d61b225bce39edd2fe26d521fb0b7254e9055cb08dacab76dcd3f2baead3b23adf875eee062bb37216dd7e94718797ff1fc90a1015cbeed501375a48a24372a067662b280edb96386cfc53cd437c3c016a03f2dafeb4c39e7f340f991b7796b081fdef69cfdcac950f81b93a235b31713fa9ca05398c70e8811bbf5979d749"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_10(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "38434169f568fb1e1836a62c85631acd8f5be3dd64a09f6f2309c777398d4c34"),
		nonce:           decodeHexString(c, "c7fe254cfc90e1913be7df63b7ef07bc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6a6f43cbd8d228c1e14788868b59f68deaf5f77c6416dcaf4bef267a79266a9c"),
			decodeHexString(c, "e06a05f1f4e9f29d17df2fc030a1abbf85c63530726d0f76dbac51f535f0ce67"),
		},
		expected: decodeHexString(c, "15c039bd9a7626ca6426f763ec09e0c0ad166b56ebef62a4b4392f272610f96df95cfece3659a24ee6b1e403556e0e30e2a065986fddb111542ef49b0eb2e15f31ad14cbc4dbad5d2abadd26a7007d18bae0d916fc33ddce158e97133490c8bf6337a329e581f1992b10efb9859667b083cda53af45ca784c374197f751be856"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_11(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8311a7cc5af8b85c0d129552cffb9ed9a172c0d9ecd6a3cbbc8b56e8f14bbd40"),
		nonce:           decodeHexString(c, "57977e3d5cc96c26c177b8a6e969362a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1f86c630850e2bf070255c511e4edfd0a63ddc96bd072df784e550a165f58b3c"),
			decodeHexString(c, "c1f971acbbabdf5571c90905243e579193d79c259d570671b87f71652cc85fb9"),
		},
		expected: decodeHexString(c, "3ef4cb4fcdca24583810ae7e892b790c03e370b3fe6627cfb3c1b1096494c0d51e264e5cd278e1faa915726718fd781d961ff9d765057b8c500793602f65e01b52039b61d881686af9a47feb9425f3842ba821352b66a52c60fc4be92d6b9b20cb1d04f29bc5387f941c6f1db60986d901cb4c2a95a3822b247519afe2851fef"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_12(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1c3d1f251f06a6d0c28e2a25e72f5c5cfcd41e18c73eac703fff701884fd9782"),
		nonce:           decodeHexString(c, "ab94d19358ba74042ab5050ccf9be51a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5f670e2e7714f4c89242a58544e674453b695fc39d779894b9caf55d9631e063"),
			decodeHexString(c, "827fb33374e4815e0771b07f590251c1d5ca5a69bb235ea2ad886f2956a8f751"),
		},
		expected: decodeHexString(c, "0cb69773c7c34c9c03bc678f33ed6e74da3226b43f5e8a4f25515ef723886ccf09b1bc07d468752d846f50244d86ba25ddcf8995d645e7c2d086689bb08bcfd52a983b0973235699125b21cd85f4f1648b21b05b0e2e7eded2ec5864170de8d0b0de46611270c916673f126ce59931be6692528421415f8d4a8266714bb04559"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_13(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d6c7079504c53d5fcb5ff68d6694e6168e8ace2d6e1516f89a0bbf0483c359d7"),
		nonce:           decodeHexString(c, "011248ede6a732704a05de2388764f1a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4a121966c13a5bfaf4bed25120bf307010bc1bd3112b64ef0c00f3cfb2d25644"),
			decodeHexString(c, "2a57c3cef57878a846db8858449939317f4c5767ec381836fb8c363a6e3abbec"),
		},
		expected: decodeHexString(c, "8530e5eece0c0844a18a5f0e85cb10ccf5f706f3fe21ebf841412ee432795811def6fcce30303ee764e3411ed6398b6764431736f53c6dc5fdb627c5d6392e47d20f15ac39128c1fb93bd117f2fa13cc76351b1d01cd4f87b35a3506e0002679beda64044947ec92a1ec5e8fc761281e16ddc0cd43b48164b2eff7796fe3a499"),
	})
}

func (s *drbgSuite) TestHMACGenerate45_SHA256_14(c *C) {
	s.testHMACGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7fa0633aed9d622d26ab60779879c9f3e84aea2313f996c9558f934724db2d48"),
		nonce:           decodeHexString(c, "76cd330bb81ae68860d2abd0c7bb533c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8d72118578abbd90ddbe6115ab10b499afa26c2360eaf6fa118ba590ac6717c3"),
			decodeHexString(c, "6ca4d45fcbd0c7e964557b2bd7622a528b4722335b47383f7bca004b7cd5cf04"),
		},
		expected: decodeHexString(c, "360d9ff3111c6b713fc641b571b582770991885f2fea806a485006a1b4f41ece4ce83dcabfd403edde77780c044c96e85ce5d1f1a368ad881a64be8c41e87f0a682ab67170ae05a24b08b4a9178d13ac9928ecb3b5e23e745d93aaa5f111c335c77cb9a5c3da8163cb428fef60da737b884105ae57616637b0e40bad9594bd51"),
	})
}

func (s *drbgSuite) testHMACGenerate47_SHA256(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_0(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f074a8cf417a9a4c4aade25f530567fd7a1410a074f3b0edd664bbc430ddb250"),
		nonce:           decodeHexString(c, "d3c0823b6d28a42d5f0fc01496d32859"),
		personalization: decodeHexString(c, "972527fe90601de9d13a050c7e49d556d0de6b0e75e0619807ade2178eefe47d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0dc678372c9f24230d15acd1d36b13294c58b76f2847397fbc32dfada12b8e51"),
			decodeHexString(c, "59874caea33944638e1e11fa3626fa2bc26d4502120c17e0e198d04f9ef0ff95"),
		},
		expected: decodeHexString(c, "79db15ff50059ce58dcd44553f5cb6a19554cf35d2b64c869336a797cef93b24c64b716aaa11cd82dca0143279ed7cb2698d7cd726241ca17b5ce6831b08ae84dd57f95b11c07f7fef1d381eb0b7fd535b902ccede73538155f30100fd13ff007806b367f5032561338a92541f441725eab17996dd58e9870025d98b4752b547"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_1(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9f5c9900211626b17c06b5539432f6c30d925e222fc1dcc466cdaedf1f727c31"),
		nonce:           decodeHexString(c, "a1e46afccd53e814f782d147c82af202"),
		personalization: decodeHexString(c, "92d6864dfdb5a6382de645eb55c243192e828e49f5322e4a769bdef2bac063ac"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bde8ea0bdb9e9deaf5ac5b8f01f23eaaa1f6ee439d477668192e2d53427251d6"),
			decodeHexString(c, "a746193e4731f565a4b9eb0d9a9d8acc76c7f7d6838de3ab758ae8936257a485"),
		},
		expected: decodeHexString(c, "734fda58d20881a190d29007c82d5bea9af04dca8e916182e3cf1ccd07d4aca11410a92643325d85f63ab26a791dcd3100ae814d2299c6f6afc662d246003a4975b85e0d032b0c8f485b4a3008df9579d5e2f7e0626923f46bcbe5e693590359ad67d5a45b0baa7c77bac396d66081bfda6b7bb71acd5a6b489812447ae63b78"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_2(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "79edb0af741348294208242c92b8dfcdf9e99fd20996b2b0825a35af7fcc177d"),
		nonce:           decodeHexString(c, "3a69da52b49809c566876b77b13539a3"),
		personalization: decodeHexString(c, "5f1cee7ff01c5fe1d182ab7c4bc7bf84a50f16f0fcbd4ff08eb13c2e3743965b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e6d9361dc5093a8c5a0ae402811e166ac006f5f6408b5209c8de263cdc268db5"),
			decodeHexString(c, "ce7b94831a77ac8b37118fca378e90d786a767337289b3a83e7f797148cfe223"),
		},
		expected: decodeHexString(c, "0b9bca1a9601da23e903891753125484532172b85d3ed22c1695349a7cded86f374b1339398208e07ca63885808c5f8f775b15a379f9efaf107ec5ffd9f763a0ddc68c54e612a89ee864158d3be45597671ba766acf2c47e8c96ccd146eae4c0ab608c4e8ad5c63b0a66e3ce6156a05ad63d599306be4831107151c2cfcf8476"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_3(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "882dcaeecf17349b31d7bbbbbeb9c85270b705b46e7a5b60519d8df30f17aff5"),
		nonce:           decodeHexString(c, "46e777807732a55950af791ca1ca5fc8"),
		personalization: decodeHexString(c, "f771698092ea1cda1c6c232d0641bb76886c6df8ebda39e95c7f573186f4cce5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6c54bf9fd6e48c609846b8a6787e7406db2610b9838599d361be009842301c35"),
			decodeHexString(c, "23b208e7c5319cb7b37fb8e84638f684d5323779a7f4d3518939f95b00d93705"),
		},
		expected: decodeHexString(c, "037ab6a81bb8b468ecd17d6d09196236df1442ee8c61cd2734873fcf9a7e56d95e86ced82b1bc8d93e67e33044fbaf67fc389d4f46612d8b6ea46468aac3237607403ee3f59632c7a0fbbad6f1fa7e66463b969e6944a33c56a8522812aed5bbae582868820576d90cfc6e80c159ea1a7802e367f674d206bb950e8ecdd2baa4"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_4(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "11965cda20767ce8f8c5ab4c9b10cf589324c3a9d6a277d27d9c5c4c93c6517b"),
		nonce:           decodeHexString(c, "1798523cc23aafb99a554b24a0d5e45f"),
		personalization: decodeHexString(c, "566d51c543e9cf828a659200862f1a2a4994009a58ebfc8f303b0852e7f53343"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6458534c476ab44c4e742a8de3bdbc576b45a880b1bd1ef97c99ce33636aafad"),
			decodeHexString(c, "feebef75b94448968acb6d79a3830c7b1eec03838bf623c50070b9a99982c83b"),
		},
		expected: decodeHexString(c, "fc6be50d4f8da8be8dba73b5e6286f9cf8fdd6fd686e84b03ec5e1bad1dbfcb190fe333db6dbf72babf0d9cdd5182201d69ded39451f8910b01a33365e37ad8a71a40f5ce10d2dab6b06d134f1f3130567ddbce3d2bc17931d60925b8542de1a0a3b1b2a4e2491dcc18ebafe4e095274c491d09cbcd90f7790274c5ec07bcb33"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_5(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9c0693df87f400f82f61cb47cfc2d672fe41e1cd2e17418ac1d51dfa4d8bace1"),
		nonce:           decodeHexString(c, "dfefe5a66bb369d1e788b72a860b41c7"),
		personalization: decodeHexString(c, "cf4bbba8b2427117775663f84c77bc37160ec54e68c6aaafeecc967206a37b54"),
		additionalInput: [2][]byte{
			decodeHexString(c, "122ae7294c193b47c925ccccae778772355fc621be037973991b429c8466a2ce"),
			decodeHexString(c, "bf5a7c27b41bd872e5cddefb2f606aa836019d5c347950960ad9bff41f302f0a"),
		},
		expected: decodeHexString(c, "e3dad2408c98a142b27659e9c7f0ee269d8b0cd8caa62a5e6704ae2c4c908a19d3097421ae6b6d309a4009181a14fe083451ffc9bfc31ec1b5ce33a0d3f4ad311c2db315924667024b9d54e1750c2366aad08fc9dcea9c043239212bb7263fc86ffae6113aa9451fcd1be848fc781943ae014c13e28a66b824e32e8926027bf1"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_6(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5dd98a23c155939634161903f2b3da3fc31a18fc1c5acaddeba1fd08a08f0faa"),
		nonce:           decodeHexString(c, "c7ee4ea3efea01a22ceba03f86e323c8"),
		personalization: decodeHexString(c, "43501b961a81bc4458fd9dc15983f4aba6cd9a11600294a2bb8e0518d2ef5a6b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7d146d124643ab686e9bf2187b88769f2443d6dc16fddfe413f9b187aa2e6b8b"),
			decodeHexString(c, "6dc7b364bdc9659e92b7b935432519bf44906fc79c3e178e688d98d7f1c78a55"),
		},
		expected: decodeHexString(c, "48ccf3cd5a7250191a9644a76b42a56c1a44ef05e32cad5069beaa74235e6e79c279a555257c17ad939e00f813a4571839d20d14004f18ffba309195e729e51d09840df3da1590a765791c8c9b92016ae861216f61107426860235f97cda7cf390aa441e504f386d3fe6b2f0d30b11a794866ef180745e0f0f42c0e74c16edce"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_7(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0bcd80d942263c3372f8f4257ff5d35bd564a12dec0c7e8fbe1cd1521e26875f"),
		nonce:           decodeHexString(c, "41db7a98b2be3678a76ba981e44767b8"),
		personalization: decodeHexString(c, "acac5ec7e76ea7a7a770437d77ca74ca9e364b20fefb02be3a3c2811c026fed2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6025b0b767745acdc844877b2b1b0bd669ee857dacc9842d5735ef734060d18b"),
			decodeHexString(c, "b41bf3892a914dc493098c74059517ec5506302fbc01408c0a0f3e7486b54711"),
		},
		expected: decodeHexString(c, "fb4031b08172dc6bc1b4957e10364e622ef2b86ff16125d31f8dde69cad49fedfa5d6f45adfb8242b374e48120405fb984f6af9fb4b53dcf2a78c6d073ceaf8136dcdf0b26ab9f7f32a3dd5c87d09af57d51658fce62258324a0f7481b31b1f423621e89301c728144d3edd91b071f199a4dd9f2ea4d72c21b90e833cf848c92"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_8(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b2747fc3131b61d2c3c8e6d3e8807ee1dbbd0d0795c1b8e2253232b9dc4a4c70"),
		nonce:           decodeHexString(c, "84e66ffdf6040a2ed22e549b688f14e8"),
		personalization: decodeHexString(c, "3ff1b7307b93a2fb6fa87729159e39e63e3f1005e056ccc09a50deab679a8d23"),
		additionalInput: [2][]byte{
			decodeHexString(c, "70c27cb8a98da217165e5946a4c1e5764b8f77f4f3c5bef85c2d150f8afcf664"),
			decodeHexString(c, "0dcaab2b2f2b51d74a1497da0950f40ec41eef100273519ef2d305bc1bd4c1f2"),
		},
		expected: decodeHexString(c, "3196508c7f7fe190613022ac30266193dac214ac4dca2456f33ac717000499d4afb5a336642c79d187dde196d1cadf507506e34ff8126cc065f024bd8b2ef70e6613e55a0cb9a1edb0971eb3bd843140bd84767b582561c27ca65cdd06e6e9360b9c7a4a5cf7fa2ed2807142af0fd4e75afe124de44ef9ce7782894b47a5c53f"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_9(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "79c40f253a2265a659f7c127904df1fd4851c149df7820f6d82ca8f886f7ca82"),
		nonce:           decodeHexString(c, "2066ac2491c6f46f3f6845ad64987aaf"),
		personalization: decodeHexString(c, "bb3cd677f58abb5dc58260547800a101413f6526f229b7a9bc707d4e0fdb9447"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3ea9d3f993c25a2291d0dee81434353e97f445b8eb21af2482024ce83100a1f0"),
			decodeHexString(c, "0498b70e31590717779f9d8faba5c86cbc6814c1c7aecdd4487249901ae43e7c"),
		},
		expected: decodeHexString(c, "b9d881038b23e35fb23bd80c7354cbc96e2be971fb38ac478702ef904789291b7b6c1002548df5749e78ab495623527967e37698b84090259ebb06bdd47848d4240591396ccecaba1ee19e3b8c9245d36eaa72a070ffa1b3f5a84071ed664d567715139974917c7929a18a12d0c14058538a38c488c9c4fe9eaa95a412301684"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_10(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a5b77a8e17178ff701a35996ed4f55d952e4418e5a348eab4ac9703c6011fa3e"),
		nonce:           decodeHexString(c, "92ddadc8c640b32f840863a5eafeec4d"),
		personalization: decodeHexString(c, "78286d39fc5180844e86a24d675e583514b7cb83ec691f537c5a3c79c73ed4a9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "484bb51214755c3eae593ece170e6ce0149e76040833d8dd4d5a9def84bad047"),
			decodeHexString(c, "add105ee47ef06f5d5bb01013a349170aaf2d5f7f5d5ab811f3b677050dbecaf"),
		},
		expected: decodeHexString(c, "d37a8eba004f3541308646ca57c15cb75e7d0aedb56b7bf59600c1e3f6dfbea78becf175b5e0121e096de9d5654322c0af2db301bc0acca5cdfae5122ceb9c79cb9f6dfbfa37731b2100127452541c65d57313e25619b609fdde38eb502288cbad874f8356e67ab7c217b513670f600432513e234d2b4aacb44bc417f8deb857"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_11(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1a27c3084aae1e055174e8bad8e8366cc1add1a14c74f507ce849274332b003e"),
		nonce:           decodeHexString(c, "ba672516904ce5e8c975d7aba6059228"),
		personalization: decodeHexString(c, "6e28f38655ec1275a61e5cab038e3383bcfcd59674e02908daeb008213596b35"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b216ff71bd86ef02f4234a08a8eb8e75a1acd20182fe668ff7503249e7618aa1"),
			decodeHexString(c, "2bca751093d5f73ae3097d84c08872a4c6a0d31c56d6b10b181ec21484b54021"),
		},
		expected: decodeHexString(c, "ad052424dd5139802e198b6eda26a2eb6298b567bbbc831fedb8638815d2b719d12fec0e2a24de8cdde0322ff930110b10b850f8af9d35f0883bf9fe01d14e13c660fb9868d3476fe5b110f486122daa9b93a760c75a50a92d6fe742250868eeccfdd0449bcb5dc2eebcf6859b703610b5431646f2f1420b3691528c5193d5e8"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_12(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b5019df2c59490eafc352c76418aa5d04c253427b8cab96b008d21a2dd9bf532"),
		nonce:           decodeHexString(c, "b963166dda387bbe831798a8eba4368b"),
		personalization: decodeHexString(c, "b0c6a491682245f21ee9ca783559bed4b499b7eda3a789bf209c9e2ca67f3388"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ea1edbcb22877f45e3a285a5d8a5890ce8768f4ce2d9ffd8c95635d4c0af50bf"),
			decodeHexString(c, "98c93e01ce7ea9e64a604c5b55c61ee2a0e482d796bcc388355e06f0f42888d6"),
		},
		expected: decodeHexString(c, "8755b0aeaa9a2050e4ca9cde67fc0a57ff3f6657d02dced9e9d40a7cbebd6abbcbf57895d7b821b51f9b3efbcc4b19262fe013de30d309e1d8b70995fbcdb2ee34551688e819a6d697a15894b9e29012fe477f487b28c3b4e90a76c0f976c75eb6cd1f4b4d8b839891e0cffe1c6ba51f258dd83764c0cb87b3c39802760e0467"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_13(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0f2c30aab056b778b82676c4e862780fe31649f4d1fcb8fc0cd7fdb76b27423a"),
		nonce:           decodeHexString(c, "7e92afd284532c2966bff91f67499d10"),
		personalization: decodeHexString(c, "d68fb207bf5afe47051fa40f82cecfede1ee011cb7a5d08adc21b3aacb9a6553"),
		additionalInput: [2][]byte{
			decodeHexString(c, "99f65d454573f1b5d3b419efcc80c29574154650e0a5abfdfabe8556c18e9245"),
			decodeHexString(c, "23e5a72d637af785a74c8c3b96d85ed373afc7fa0468f905c497f0f47c737c4f"),
		},
		expected: decodeHexString(c, "0b42774734a3271975049deaa9e34c3dc2a601b169252520a8f56bb663f8e1638e81cbe2dbeb8f669dfffb8a8be697b2689ce90abea735a675168ca5670a568cea3b8a1f08838a5e47c4c7c77f94f3464fa7b46a478e323279d9e4f01b82251e252ecf93faefdcecaff4052cc10ed87f95413893e350bfd692c7008a3a9076b6"),
	})
}

func (s *drbgSuite) TestHMACGenerate47_SHA256_14(c *C) {
	s.testHMACGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "774804cb3530deecfc477e3f47d57039aab2f1a2dc133584a358b5d73c164092"),
		nonce:           decodeHexString(c, "3bd0ae797ecb7c0780e758c64ca0d61b"),
		personalization: decodeHexString(c, "9b7ccbeec10758cd0a3a8fdaee6f3989832e44bca7763f59e838c612521d3427"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9ba9285889d50c27bdeb4a830a5b3120931a53980b30643557444718cb2d47cb"),
			decodeHexString(c, "0f8716df331067b8ccf0e5b90ff79dd0f962acc69fc5f89c593bbb84e3501ae2"),
		},
		expected: decodeHexString(c, "9d2c0053a0fd3f9be1fe33db214f6f2d54aca573e0642bd269f1b1ca23c42a1e85c73449830673cca14feab4d2686814edbd90c325e0fbcd5a2d7ca75334dbb113a13a0bb4e838f6724c74dddfca8c2bfb903c362d3ea82acd60d01749f6dc01fcd6708009a58ee9cc57a0d089095efae66aaea68ac247cf6aa8808d1038a109"),
	})
}

func (s *drbgSuite) testHMACGenerate49_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_0(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5e919d353357671566d2c6ab6e1acd46f47d0c878fe36114d7fea9fecb88a3a2"),
		nonce:           decodeHexString(c, "7efca9e3d1e1b09d7f16832f3af75141"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "442f17cb3cb1482a19729bfd58f46f6ef16285554892c01b0718968d6e011082"),
			decodeHexString(c, "f9557c93eb841bfd7b5d4b71da928efcbe3f55e1870493ef90d16eb238380d65"),
		},
		expected: decodeHexString(c, "36902134f1989cfe7eb518a56c06aada98997d9bacd04aee21f879a57b515ca3b5e0c2d5fed05ca1a8b054e8c46b389d9d9186feb0abe8e2e60b3a267281cc5b4b7341116ced35a0e07bc2b0330bbfd8b07f07248fa6d8fc5c9df13445324162bdfa22a91ba71453ab123c92f91c70b8bd540b3b180b11ab45ae2c59e57c7c43dab7576594959a96eb502d182267c86576b1846ccee1a694cabdfb42e0c8214192efb502926fa3c27eed020b7cc8866a5af9d838a57e78bf7acd230e1f4d8361"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_1(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7a5d1efc9b7043060cabd67de7fe22740bcd6a8ceb355d69f118829a2b3c9200"),
		nonce:           decodeHexString(c, "6a5633e613f8769c1114b1822ffb5408"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f2ad962d992434468681c644587639901ff74e2bbdd8761961ec34edc4a0c36d"),
			decodeHexString(c, "75aae0d1bca9484c89fc4de3d1b34275ef0656775f3f8c96f2bbc50401aaa718"),
		},
		expected: decodeHexString(c, "5ca21af4b399db38f8b74a406aace69f994691f2765bb9c47b240000152739e059b163cd007de5f28bba17e485fcf9ff6f41f76e93998510e302282cbdbde09fe8b1a96187e57c9a3df94e2e748f20026476ca682dfa890b478f7a21f4927f74f99aedd9ae782ba10fcda1dc34c31b4f784722e01cc4679737276f56df23c5bd8c6985797b83c0ccde2b4c7a65c652745de7fc8a235ad7ed0f456f1e7568b2dad475f0bc46f02a7f35c05cfef9d0e2c773ff895e291a2cfc2424b106096d8864"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_2(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "611586ee40cb3ca4a9238ce112a237449bba5422ac9b18ea53480875334d8fa0"),
		nonce:           decodeHexString(c, "26da9d96c4e87f94b2f9a7c261be3edb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2f835c336a3aa0019b0bf940c24643bc8fca58c9cfa6509aa9241de9e0e1a046"),
			decodeHexString(c, "1911a59c5f2568860ae71e803688889dc44d14ffb0d93e324c39f32d95c1c3ea"),
		},
		expected: decodeHexString(c, "27bf42f50476d8a2cc23f455e9ef477cb8e9c90f2e97c8a483093ebf55b2aee02e0356cff919e2ec9811b42c73498a6c2b96aa5b761ef7e715cbf66ad2e3ff8a6c92419dbf2e653ce70a87b51e26d9f607eb25b45b91f947d0026a38977143c8bbd94076e663b9cee35505b48e453e7cca83e540975ae8a53f26390aa63aaf1e2669410cc83427eea09428776a2d520eebd170602c52dd491c98042018a0372a0b39cb565cbe5e474f927f91515a6a7444fdbe1d89d8ae2c2482a0deb8ff236d"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_3(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "85b1e5da599efd4a20ffcefd4737fa3ea1d2b14be33861c2a4ac3ac2a49d3947"),
		nonce:           decodeHexString(c, "b14cf18f4ff426cb6345f1a7653e9630"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf5bbf98d8577077b0b84475dee0f0e9aa95eedd1d916507b5233b688bcc856c"),
			decodeHexString(c, "b333ec111e1e7d78c9ac916e420704832539d2db46aca3bdc4732e8ce72b5e80"),
		},
		expected: decodeHexString(c, "4773d32a9fba37acc6900f3ac70f6978ff1e40039d6e3286c264fb7fc59f1bfe0188c7979380c8922bdd0e363c8e09a49faef59ea85a9f0e400b94c74a8a50687e4e51e25266eabb86276f22628d0d2e19c5696cd221a9b80f94045d001ca4c20dc916ca0ff22c93a41fc822912dd7e247927fd45982e94d3d1fde77cbe78beecba830b753079326ae33274f13fb7cd875e85fb5e9e703e61cbd41bc4ad47d7b4d14afc873a39dd810ad8eed95adff8dce3adb7659b7c1d4e3f62403767940b4"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_4(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "50f986f6efb413fba3e8e0beb84d4948c2db0661ab8e064d9fee8b3c2f0a910f"),
		nonce:           decodeHexString(c, "c35d37512f88bdfcfde797a21a006e01"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "37c7b08222ba63f2136bb28f5ec09b9a899b56371615be41bef49a0b640590e4"),
			decodeHexString(c, "4a1e34a5d60ca08e3e6c0f1b86547ba2d12fa293275e7d75f83a0b846daa48df"),
		},
		expected: decodeHexString(c, "e27738c6fae66125fcaf4e725a0881d5a450fb5b02a55057d6cb7babd91d502c4f4a8431a83352f47ea8e5fd7e815f5080d144318a1dcbc755e0b935785cd5397955da22e3ff633b34a64ac72b2e6b7c51e78ff553731e6e8da911d147a6e05b36b74898cac6d3171bc8650e445ffd19ede2aa8218be17671321c186465d852dd80d73290546b88ef7a978b41c4c549e9c7fc6ef86e47084778fb5aed5d41e794ee0e700b77c0314a307b10df69daba605f3fdbe2dec708ba0b20d6b650befbd"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_5(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "641dbcbf99b61437c2bf65a13dc3e0324eb940335da123870d9429636dfc8297"),
		nonce:           decodeHexString(c, "9d0cc913c73e8a6321fc3eb9e973c0aa"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "72580c11a87ce6b4207908aaf5bcaaa1bd217fce3e8bc0726568c64639b70767"),
			decodeHexString(c, "cf9f4527e074b72be735558dcaa1fc82f26ae286bf944b49649f769bf6faf49f"),
		},
		expected: decodeHexString(c, "345395723d048c2270c0eac990498689bcb862a4996e82995b4e7169e671eb03bb2242c4669c874c1aeaffec58aa653c7d7431abd1650f0cbce8cf5db8316693f3ed501fd9b48c1a44b34f7878aa386d65afc31f94f908a322b03d06c2a1074a03bd2b579cafb0f7cee6d6934588ae1ce9e4ed37b03737c553ca19af4b46b5e43767cee2e459ab91407df6cfd13a6f186abdb148b85a5f49bf92ac6674fb055c7fe123e9355a0d33de281c03a56f91891dd496dabfd6eaa6fff6c9cfb4e67c44"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_6(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b9c305ada943a64a2b00494e869f9a640173eb1c2518dd9be93abc3c93c7e6b5"),
		nonce:           decodeHexString(c, "bd0627a199d15f77b188824df00d5997"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ffc6760f9af02d35666275c074eda03f53dbcb5690580bb25768a6566b328dfb"),
			decodeHexString(c, "f26f436a820ef71597b75134b8d9dca6e9a6afd9b429222a4c9c878f3b92716e"),
		},
		expected: decodeHexString(c, "e5413a234859511cd837312bb31aac4d31962c5f7f27aec47417f367ca99b8400a4287e60412fc356cb40d96ddf5cb801285ebca42b2f6fe4a711451c1574174c58dccb2cd3342b7092a196ac7d2881a08e7f5de939ccc8f4eedc8f867c81aa88655d96ae50f618279d5009ba2ac4b1df4e63030cc0ec3541b6a94bd9a2ae5d1fcf4d847114a783c997a7c6b9d549010bf7b649abef692cdea3aa8ada14574e0f78b7fcbe17b587ac14980e40264d6de030e429586593d5ce3ae571f95454dcf"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_7(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9875dbf59b760eab9998bf3341847910526d10071dc179f96081dd793a600193"),
		nonce:           decodeHexString(c, "6881e7f39075cd382293a1aaa8c845d2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1196583a99afe1d377b344585c8252a0690704b8f7a2b7582387ec91a60fd7e4"),
			decodeHexString(c, "20147a88e0f9f1e8caa8cb14488c9b5c38e5520a36ae913b4703d15af27218dd"),
		},
		expected: decodeHexString(c, "c808f6f296683d26208359a766fe61bc70ee8b6ed9ffb94ce269578fb5568fe2358d603638324b63b29bb36ae71a542e38ee69a2b93ad7e4a887a27a2852cdcd541a5fa6d0c8b087aa1185bd5788256e7d95c2aa2d5c11407b7bf762f416b01d8e747c45298f875200a2e67679d6d5ff7a7c0e50a010690b1920df1baf0afcfaee7ab0862004e23b5aa1ff47b8273d503bd74a54e7b39ac7e6d6fb0a594d30531cab8a67b22783470a65f24faba1c231b3ba45efae9f0be04e2338529cfec008"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_8(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ac92a6c791aba0406d6ea8255c3c0901eb711a424501c2c2c847076d78bdcfc3"),
		nonce:           decodeHexString(c, "266b7c3bc578c7501daac6dda8366d4f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "13379a77d84a0c4cec95e62ac4c8a98ceede0d89b8bd317352a95300963415ed"),
			decodeHexString(c, "04d47ec89a3e1b7f22580167331225a00ff258da72446241a6c09c517ee4d48c"),
		},
		expected: decodeHexString(c, "c2e6528584c6dbec436ffec4075fd3aebe953fdc0b46b4b225a3c2886e60d21879e6ccce3746d881f6d80e33876afad439ab9f68fcc458492de12811fbd57ac49d868754da19279b4c0a38979201a588884def5677392dec97cafc94bccf8914d9f78575711bb6f2adf4116db91c8b54e36e9ac2f5e01caebd300acd7bd45eada69d20f1b4139013a8a614069315a1c99137a6f23e38f91c210e0c156c6fb498056e823dc41a05348ab43c2f6f4ce188d4e05a13d38f8025731ac1670949a040"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_9(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "63954ac7a0f989a458d2b4a6b7013dd66683624584b545060bd03a57b92822ef"),
		nonce:           decodeHexString(c, "422764bbbc35fa5d40d34145afe44bec"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7b25d875dfb03333cc27b9d4286d00a85ea5921f4b8a4717b957349eb3509053"),
			decodeHexString(c, "8b70d28c5c80086c0cbbd01337ad45297af271d4bafc764b0fc5705700cd419d"),
		},
		expected: decodeHexString(c, "297752e61c4ebc4e1c68391335e2cdb49b0f19dafe359e451f8158fb7958d32a98455a852002d8f05169f438816ae6fccba1eae4d1fdd7a1176b04831d7ce892f711ec825062ea1c6b12144bbd3a0aca7f92520ebb87ac6045d2ac3a4a74fa559926f0daceb59d44fdb39f5fc3b877f34241531e863c153286f3f1b2ba2db4e2c8e2344be40c2a7a8cd01daf168696ce19f83ddb64d50e2313e78c5dfcf077f25e5b4d6f687279119ce856d4131a63ad133cedd020881939bf70f82eabfe46db"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_10(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d0944e0a3f3604a588271c8eb65913ad9b07ee2b29620f8106ca70ec10aeb896"),
		nonce:           decodeHexString(c, "bc9b2b519c77fec5fc419e953ceb0be5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d58593f2488f0a292ab552dac006c94b20ff500dd57af32be808921a5ee251c1"),
			decodeHexString(c, "ea9e579c9dca67f07ffd67d2483ec1fac3d2ec22fefff73c7ac9f125888d7a4b"),
		},
		expected: decodeHexString(c, "ae736da6632a7d8bdcc9e279cb7d3f9101a8f7dddeff253277d1d99b45c76a1a5c193334e912c3dfdff1bc389b209c3b29359a4ca53765a1e40cb900c6055d8a285cf63ebec79b46019efe95d5199f215f11961f3319d225bf3d60734fbfbf3593ab105cec2a17e308af469b3220ef7f055675396d289e6f4f8009881c8a2b4e9de88d53ad13e8bed8b38be6d8988f615b4590fde3d91caf50a86eac3fbf29924743145803978d261132b5975a9f108499250314e098e57c56e2f9327307cff8"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_11(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1ef53464bc7a441227a27ea7b5c558dbb3f509aaf880213cdef7e8f6a1d287c1"),
		nonce:           decodeHexString(c, "73cd5b3148d46c48c83c5cad3ccc1f50"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b052a66992fd8a8cb02c593edfe4766fcbcd3505af29d698e1f4db398acf717d"),
			decodeHexString(c, "37333448311c2c6edee19aadb8f1036cb60cff2a945c1a0ea087713bff31e915"),
		},
		expected: decodeHexString(c, "4ea7054659cae1cc178ef431aebb64c2c8dda3a965ea940a84c00d9790e2e3a33521395cc4d49038994aa4c7dcaf0b52b44375d93b625ac2281991a85a5acebf3de552355e17b3528faf39d392fed981400f28540f5ca64a4d2eeb952c88856c8f7388a49611810941b46b1000ee4a8aaaadcd39944c4abca9110fd6580093f9303f86a6e129d56b5aeff5422c2261af33523cc6a174e0782e13a026c003c17430b8371bbfc3d51c3e06fbdc30769a278b109238bbe383cd5523053fe589b72e"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_12(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "14148d69d583d4c1758c307e0eb0b762511165823fc54096f9da5513e87df53b"),
		nonce:           decodeHexString(c, "96a7be8d31b8a38f24a82d846b0e13ef"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e05f81f6402c52dff5c221a2f191155bb56abe160ce7dc8a6bedfa029195a612"),
			decodeHexString(c, "214777e3faee7d953b5c796675e106d50cdc12836b3114d14447ae91cea3c1db"),
		},
		expected: decodeHexString(c, "eb0497b32af8a91ed3959c31b079b8cc5c39db3100913332fffbb6b1d5ebbcdc97d6e67c934f3336197c9b730d80995a7d7445e36cf3047cab22895f244cac803eabd001eb1ff5d5645a803c41ea6dde6c972b47de0372ce901667d03e2e02aa0a5aea809e0bdc7430440365908418ce6066c24191ace05d6a797ef9b94409989cacbb9d9ec31f3cf0112b72e1420b47e0c184a8aacc214d55a0d5e0869d09303e4014de0430c07380006ea75984e6c32b06067d7d7b931e2b74666b4b569f71"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_13(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "27d47020acc3a80a55149fa0ef43f684843ba89fda4bff1c29d20baa2b219567"),
		nonce:           decodeHexString(c, "80569b7fa0c4078d9ff71a3790f1be3f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c03ea0b88e2f9b53f902b22746bf4dde09439c190a7a638e3cb990d86739dbed"),
			decodeHexString(c, "3ef05e71487cdbc209b5ab6e808e55f0a93bcc02df766b01c1c1ae5875b1023e"),
		},
		expected: decodeHexString(c, "3ee49e2a58d800d922cfb66284da84bbb5944c85f194d95f1156b673392132a430e47ae74f1ed7c1d0e632d8cb604c88777437d8f37e7d0428b834555a96800540bf5bce6f430328fd328baf4b22b7f8e663c1d8583bc0119248588840510e11203cf47dfc4f6cdf8344170a341fbb7d93999ba86be3fb94d9c03922fd3d75e3fd5b42365aa62606e352676b2a0c51fb030d8d5605e8ac6bac2b4f8417d8e060148e3d4ba67b31e5e704d866bc87741ba877d12b10e8a9b37f3feca908fe1fc4"),
	})
}

func (s *drbgSuite) TestHMACGenerate49_SHA384_14(c *C) {
	s.testHMACGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "88b6550d49182ca7321d8015f780121223a93343dabaf21978ee2818e7bce659"),
		nonce:           decodeHexString(c, "1d32b48eb4642069adcaa5986224e6d3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "809639f48ebf6756a530e1b6aad2036082b07b13ed3c13e80dc2b6ea56e70a04"),
			decodeHexString(c, "3395902e0004e584123bb6926f89954a5d03cc13c3c3e3b70fd0cbe975c339a7"),
		},
		expected: decodeHexString(c, "4a5a29bf725c8240ae6558641a6b8f2e584db031ef158124c4d1041fe56988fdaee91ca13925fee6d5e5748b26cc0275d45ef35abb56ad12e65aa6fe1d28a198f5aa7938fca4794c1a35f9a60a37c7360baf860efd20398c72a36b3c4805c67a185e2f099f034b80d04008c54d6a6e7ec727b1cace12e0119c171a02515ab18ea3d0a3463622dd88027b40567be96e5c301469b47d83f5a2056d1dc9341e0de101d6d5f1b78c61cc4a6bfd6f9184ebde7a97ccf53d393f26fd2afcae5ebedb7e"),
	})
}

func (s *drbgSuite) testHMACGenerate51_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_0(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c2feb900032f2cca98d3f60536f563d8ac9af5fb2e90dba36c371c0a1c58cf5e"),
		nonce:           decodeHexString(c, "4a60f2be0fa13b8266b715be8aad128c"),
		personalization: decodeHexString(c, "8e6f9be0c692648072d19c750804b10e2ec313c8013abd363de7a467787859f2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "72f54ba3f8e71ad69a040bb8493283acfc8815f17dbcea220ecd68372a2dffae"),
			decodeHexString(c, "adce8157ef60482841dd2ac5ac512bf7649120c1dba81ea75f2a70b7512bb6f3"),
		},
		expected: decodeHexString(c, "e76e4326ac69ddbc6b2408c529b05a96425c65cc65671601191238e9434d2a0147f3a25ce9b6818774f5263c92459bca421d2b492f9a9c2971359baaa1426d6e2c36d8924f39d02ee2fb5502c4e0b206dbe9aeeacd508abe6c055d547b5f9f35de4fdc9c05a2c63ad699a3a7e265598b8f40a8a295d7376b88c49af9edc790b8a5ee221e19877616678e2a5135d7b3756109200439d9ec8bfe0cc5f3c334ca9c022ab9192d5d554dc7ae76af1dc06d814427f46a7cfa2dcc62f4777d07ebde7d"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_1(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ad500edbe28b9a4338b55451b81c652797eb48fba753c186ce0aa9ad02a84ea2"),
		nonce:           decodeHexString(c, "c995b7ade6de0fb4ec97bcbd61b711d5"),
		personalization: decodeHexString(c, "5770c41832a4cdc4039a8c332a4b45e7a7b2dabb678ccd2e56452aabeab14925"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d8d5516d158b41cb9d66566b88064900af78183f765f2f72a19548fb797377b2"),
			decodeHexString(c, "60a3a01a72e6b3f33a0c236db08237e7d656bdf4bab1db57ae23b7305569dea5"),
		},
		expected: decodeHexString(c, "c5ac3df66bc664e8bf84c758c7926992f0e8a03cd3f3f5fb8277c85b4da526601e8131f9d205f35594e101a86fb83ccf4c1e98c8e609062256701ff2132e337cb7287f0ee2e8fe3ef11ae703d7efe52e63cf89119ced05950c55aae6c822b6b0a8e1b91b537e5bb2de165a4b5b43a1c41fbfd65fff9bc5329d303caca84f5d1fc6acacee622623ed5dde36aeda0816749557c924d6ed26cd80e456fd0ae2146477ccb63a203fe16ac1d0eb2d12b6a2cabb21d412422e95f2df8ccdc23b4ef0dc"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_2(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "51a29bac53961792077e88ed3603d33bd1f51b3fdb2b5cd1ea131c6f643af65d"),
		nonce:           decodeHexString(c, "e81eb2e260396d2a69b4184c4eb98a15"),
		personalization: decodeHexString(c, "72e5285b92c4ea4458e8a2159687cd46e7df9c1f4513d8b72cc88be41c2e1522"),
		additionalInput: [2][]byte{
			decodeHexString(c, "16a69f7aee34c567595f3d362ccbdbb7b9e9372c4b1729fbb80d9a089eee31a4"),
			decodeHexString(c, "825197262a43f6523182f0a91005d70b17d81c2bb692edfd02ab988130c7d5b9"),
		},
		expected: decodeHexString(c, "f63f531c242a295d7796c3b4844fc74821af5a53e0e7ae822cd8a7f9de91e6164164f3448fd7d18feafb97c9500e0625d501dcb3927e6fb39ef65dd9586d157076436452bd3066cb30d1f47dc0a3ffa5f2e9ab4e183018b40a82b39b0d170aa21b05600eefea906838b95456e04cf046808030a56951d2502c5eb6271228905ed08549bb171d6c0408d88250785f42e349ce1d9e74a6cd0360a008ec804e7ecdcb4d1fe24aa5a18cbb65f4de1619a29c6062b409a386ea6f43e60adb9ea3dd28"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_3(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b30ff9c6e5b6bd258f1cea0fd5ef9adb81fbec233ff2fab01e79b7422878b2e9"),
		nonce:           decodeHexString(c, "50604e10ab80ddceb9d2b968d0d37ba9"),
		personalization: decodeHexString(c, "e8acd4b380aace0b27572057eaa947e10e6b49516140139c74a1d4f472221dac"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1d2ded0003521e2ba6a4a3e732e0949c1d858fdf0925fedd9cfd7f603e0e692a"),
			decodeHexString(c, "688ac5e7b4400d962c106fd2ce712a1cda6a0b8ac5196ad727f9b882329a3d5a"),
		},
		expected: decodeHexString(c, "c5208fec1d67517311a42bec07782ceb247e9c818e4f5f3bd160c9e53d462b61884feb278cdc8f64e22f59d27dfa98d3a90da8c7c5ba28ca40bd0d18934595a376553d1a8a19de07a83e2e9db42748c982cbcbf4a975c20084ea9cc6c6a41b571faf66b364e4b7e4d32efc80c30b219da1c02a1ea02f6922adbc31a057f999605a2d827f10907835c2bdde4157d7bf2906a0ad27bb72f113c6ec4f23631a2b8517bbce91b560d90d73fbf0699bab21da23e27cfec513bb5e375f50108197d664"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_4(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "56715dcbaa4f5bdbd157bdd950d1c1b46c1f4f8d7818ab321d72c0ff3c0a9280"),
		nonce:           decodeHexString(c, "64b0439f7bf021dcdc7febf2126e5432"),
		personalization: decodeHexString(c, "cd5547991b525f7795e075a59af1701375175bd760db99d316b91463f87f7f3c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b2e4f02f1c14866f538eddab402356ff3b405abbb9154e88b98483a83be70f7c"),
			decodeHexString(c, "b8db321ab30285eee7f9e377ad62def6caada447d00a4ec882081daafe2ec009"),
		},
		expected: decodeHexString(c, "7ed8c2be58e3553eb65508377d63d7f24518d1a7235dd4c740bd987dd8bc1c1e3ca97a69a37dc9a270ad88989e4868e6cf8e4cf01703c0b1eb6aed8c3f8af431d819e68b6947ae134d360d87e33668cdef0e45e11f5cd79329ff95ed00e4a6952750f1574f489394b5fde3c6f07311a1e5d9c4e070a0943ef9d4a130a9e4b0a80c256e96ca5042961766874898ea0f772b78d1a33e866351a4eb425b822b5ad596cf249bce8ccd6dafb334b71a503fce2c8fa3fbac9943910ce5ff02ebbedde8"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_5(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1c60a31760019e6a571e2987e57e19adbc1accf3edd44e501061cbec331b197e"),
		nonce:           decodeHexString(c, "b68d0fa8fa5e3071d6f8b7c9c0a3c35d"),
		personalization: decodeHexString(c, "d4d84dc7311096791dd9c9d7f2cd291071f877afd86b9644427482d09ac9df64"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6473f4430398d7e5a2d218bd05e6aedac1e317269df3e4705d56c22d6e7abb0f"),
			decodeHexString(c, "379649b56a46399b9ab5f3880e1a73993a58cf52821d3cac87890aa0e6322a94"),
		},
		expected: decodeHexString(c, "d34152fa12fa341d0326a525aa838558630013857747f02634d24e9deec2da12f52fb405e7f1b973dc2d982d26eb2ddb4b49c35a9308b06809171dc990a4248e6da0c329a259f495247b9fa8c73af06604db7b629168e34081696a043977dd29a3c0362d5895f9aac24bcba58dd74078ef6f8d33eac864f2e6cdc479da3d224bad8099d011e914b6ccc3631a7369586e18c71a4087de0d47a7c29a09c12438c7de2d4b47768f47685b742c25b860e716c31e2afe4ce6d92bc2fb9f34400602f9"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_6(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eeccce7f7edc52f0e2559250be36526cd1839151a77c59d527f66fa24ea4d86b"),
		nonce:           decodeHexString(c, "3fb298c8d72b6a0a8e191b60259d1fc1"),
		personalization: decodeHexString(c, "26d35895723ba3d431991a0e6fb2154ae5bff7e58609c926ee3269afc5cd631f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "227b9a71a6c17ecbf627161fc627f8f6f1a28ce39772b7a3d36064e2cc6dc4d5"),
			decodeHexString(c, "eb59f780c5a955e1355dfe15cc4a4e90a6ec75584e63bd0de734399f47b95070"),
		},
		expected: decodeHexString(c, "78ac77657dc56b23e617a9b38168da945c1cf52b6062c2b10f1d7a3814d9b9efa5545da050b0db5a65a2d2d2e02fa12e97eb970fa8e83c524bc809d675e0db35c9762323f327f1edb9b534ce16d02519750b41ebe51f747e9da43fd1afc60e46c7aba72e15cc7a22fad19ed55189f287a14737483eb6b32d966c3e3969d8198f01f2ed841f20d7d2e156d6285a29e07f6d7fff42bd575806c4092522b03e0d1b8df0cc88f5b82d24a7fd0feff6ada03a60ef2541a4ab041a49aa973c7163bf94"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_7(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "86f8104a081c9565dea5652f20145a068dadff125debf818262d8931cec6ba93"),
		nonce:           decodeHexString(c, "7fd5b51affcebee952fb67f29f197267"),
		personalization: decodeHexString(c, "c7ba5ff828855e6e78fa1732d63aac1f49701ff7ac1f3506e97941f998b4e9d2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6917bca15db53a5359e5c4d30ab4d37fc6a1bc660faaf2e74864cb4aa52e0e02"),
			decodeHexString(c, "eea8db0cfc04f8de14d6053442b5b4f8733f822df4be5966a0de8b0f7d2036f6"),
		},
		expected: decodeHexString(c, "562b8b2fa3bb15cfc3f7e57f309e31b13c790c928ad6b32a005f5431c28576c5706c4ac0dc2c7a4435bebfa06571278f485932bd94382efcf727b300b230da9b9e9f377d2659ac75dd8247351d5ed8185effa0f255a2a2136e63717e0265d561a34c75ecee1c774c25e33fd938696825686acf9a419c1da3fa1ce8f695e231087aa0927dde6ab487dc61291ad4700c5c608fab1a418f6b30ff97b8b8f01ef8164287849a77b21be5d11d82d0c19056e07d59a30f6c576705c6cedcb9f22d3a8f"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_8(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0db6f73ab6d31ddf8f78d76961310d68f081c9e6d5985e1883978c2dec48d9f5"),
		nonce:           decodeHexString(c, "8875ab658b3a8b795bf464af9470a90c"),
		personalization: decodeHexString(c, "d886936ad36549a10b5dc5d6e21203abd75ad63f826794b4adaad45a70424c5f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "76993d3bcc32546430efa30e3b30acc34c7672b6e18c7e2e9a1f1cc26f7f7a22"),
			decodeHexString(c, "54c72cf3457e6f5f6b35dc14167fee9383c44c867f233ec9d81f187bce438c0f"),
		},
		expected: decodeHexString(c, "c3523894d273c85d605d39f5b89e3388afad8c20787897b903d8db7e3de7590340174be3abd7598daba7806ab934e0feca02bbe66282d469ec01476bad5ccba59fc14cd9549bf4af49641f4326b1052b179c89194d21bec0501c97ef2c24aaf045fd348b765910fe92c0039612e37baad2445b57d9db6c1e550adf6688a79b117f6b7a37e0209d89f194a1bfe1ff2e3b28f0454b383af8872f32322bd5313a3c9ca48d33eab7c3807bb98f8f402c43b99b2176f0b33be08c7e84c86b26e971ab"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_9(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3b1ffbfae6ec54a175a80a33c8768fb60f2af9ee2b8620c4e800a17fb9241ae4"),
		nonce:           decodeHexString(c, "7f77da414f67b5d7b24dd100355d2afb"),
		personalization: decodeHexString(c, "0d50cf61e2020a909ba6e36ba4d0a394579d3e4377cd4bf0068967e8d0fe7a78"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5d4efb3f6e6503c5d85a1c43398d0441ce8aefafaabe2f6d86988a24e033f502"),
			decodeHexString(c, "cfb6156a1b139abf21c73001240997ee1a8cad91a4bd777c0372c1e8fcfd3fac"),
		},
		expected: decodeHexString(c, "d3ef776c8d77fcc5e947bf53e0be11777e69c7dce138f24c1a3212d1b6b932580371479b7619fc82f029d92969628f810b54a8fdab8eba799e750945f3545f6a96226bc760ad736101516efff5d8581f5864b38c29885d39843a4adca17046e1e388c890542988797b576da64804eb4101638328d3f8bfa398ffaf83cb7290a2cfd39ead13290ae773a8958b33914ca02c8ff6a069aa25ac8b36f6f0f1dcd8f1c5fc838083a64ae7ae11b85be3a9fa80ed83949b622002e91776273fa32d6cfd"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_10(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "19767ce1f18aea366539642fad400a03a675b2f3c0b1cfd49925e535b2c27790"),
		nonce:           decodeHexString(c, "43c5a1c57ef550acae733729516aa62e"),
		personalization: decodeHexString(c, "6bfa882c1e895eeffbb85578182653c022a4703091529780c075cd482809b990"),
		additionalInput: [2][]byte{
			decodeHexString(c, "11236df1dca3de6e3e3a57d2741d1b77f15f45b05beb47cc500100b31188a42d"),
			decodeHexString(c, "98708a88fafae56c4f6fa780c6c0e33ca8f2592983b5ae607146cd6e92204416"),
		},
		expected: decodeHexString(c, "b6514a3779dcef2c9ea0ed7ddfa808d045c5907314c358302ca32b2055987a38ef601637cdcf77b1b8f7eac479f8f18972013c2e1a6dfe612e8a586dc529ece486505534c0ff3dc0b2049a0e46d7ac504a1fdfaa9b08d9fa017c5803415fa391ba7eeb576fd6ddba4404feb46e7cde56e090dd280be5edba7d6df9c5ba7d3454bcbd4d443b08fb51a117c1d5916f225dcd6c1c3fe2b2880f4d42962befe3ab76bdc086e29381dd985206e3e00ce722c9c040af5ff4cd4a8183b446d91b310845"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_11(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f63292bab50668eb14b83975422a0c853fe55714a9edf9d8a817ba0b2f26ec40"),
		nonce:           decodeHexString(c, "063a86ee3c79c694273342a02f68ecd0"),
		personalization: decodeHexString(c, "3c525956838e26b77b8cfc37f024ec398ed825076dbb749cf49a7d868c201e6d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d9a41b47c3bf8743099dc8fd228f77dff01ae304761eaf57d751e11cf094bef1"),
			decodeHexString(c, "b790c37dbda20fbeafe9d1339a1151144253bdfbffe17ba87240eae49c606bf3"),
		},
		expected: decodeHexString(c, "3586b63315020b3ba1121314a0fa6c66d57de0ec44abeef7b7325e960832b7944cb0a81a747ee5c5d3163001536d3e5ad2ec869b0e5ceb14aee2e6915073619528c1421b59b80254dfc3cab0584898b0bca72c76ae25f52b7405b9dad38cb2b841e1d6a34fc5b277129db49928b2f6c0dd22900ee786ec128164ed12eb324b502499f1c5c89be2101901476b39c56034cc293e320e63a3e019186d4eaf9a098136e8c0ce7f6326f84ec95992dde2585ad3945a9534aa2954b8c15a48e3324d76"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_12(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3df74683f298ba48648714e384989145c1b84246736dc275636809d64c75ff60"),
		nonce:           decodeHexString(c, "3056e703c435eacf21c0bb152d9fc2a0"),
		personalization: decodeHexString(c, "371217ca2337db03c4d06714624fa11f90d5dc575bdbe12a457c610be066dc2b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f26b9cac8df57a33e4b5868c36f2b9322994a98269dcbd7956b93d147dd0aa27"),
			decodeHexString(c, "0a6db86c3abdc39878045b8fc2d5f0f77a8e298efdacb4cb9f74762fc23b96fc"),
		},
		expected: decodeHexString(c, "ff5252b7a39460a73094b9d668b53d1932243caa885c0ecd850612fdbe7e46cb275d079bb75a6b050191282ccb11ef255d52cb763618c4b624560d79bb9a5bc99319783de43c152e7aa7c4cd879a75869285320a9b749c897bf07220cc1bef1edc494bffa6ab93dcf839dc15f6f2e508b9e216e2a1786b75abfb01bb7bdeda722b47af895f551670f9562d9f9b78e98ee7ea5c5ca4f836af5bf153925b2aec055eee8164edf3f7b72e24b1203cfae1834705f74cac8c6043a3c2abf6bdf28fc9"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_13(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "53d70692f0f4dbda23d78660f0f08c7e70ca94441f1440348f76108874d13ea1"),
		nonce:           decodeHexString(c, "4652725abd1a94d315364416c90e662a"),
		personalization: decodeHexString(c, "6deee916ad660811cf05b5652f32df4e97f544ebb57762617359159cc9a425c2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "acda427eea1c8c6791be6e4d2b60be30302abc84d5c5a13be7d510004b8710c9"),
			decodeHexString(c, "d27d7f598a14205c45788665cd062135b6b65547d3188959e38ab675401d2b62"),
		},
		expected: decodeHexString(c, "f77f9de60e95da3f1d0d67b5dde29b31df59ce980ebdbad7b5e0a0051fee39e1d6fc4311f21efa016039bb05f3b009b223be6f2c007b468388a8a19bb468c7b82cc93dab3e160b2b72fda1240fcceea01c2638e9c8bd2d1ed9ff9b55bf69fba4b6ae8e694c150896ac6233b75567993f9a9adf25ca0f0835b9991ff4b8d3f4f1a3e4c5f9866d98b7a75196804f996492a61dbab5bf72f87658e2300a1b0777ef7f43ffe8962f6b6708d2d91dcdf6b430cfaacb3289f74cb0f67370bcc9af249c"),
	})
}

func (s *drbgSuite) TestHMACGenerate51_SHA384_14(c *C) {
	s.testHMACGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "85186650694f742c3f5f228f943788f05602d4827518908fd09a1fb445d8333d"),
		nonce:           decodeHexString(c, "b2d65f376d48c66eb9e0498999e1ff49"),
		personalization: decodeHexString(c, "499928c41841324749143be9cc769899c38d6f6e6933e56898896fabcd802931"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9574ca51f21865c2fb0efc75cc9d90ec5e9c43104979cd64d00ea5544ea01c96"),
			decodeHexString(c, "c0df840a18d7584b62c70b2f057bf824168edb673cb517cd9dac89a0fc80c9b4"),
		},
		expected: decodeHexString(c, "b31e50202f883a8563cf129a0d5f8a33abad79d8ec8a97167ed7fca778e5892480617cdf50b5e51547f7ec1bede35020a311572c61e33e9c82968e8f69586daea3dc19063bea56503f8ca482918d229949acd6f1c52cccdc5f7f4cd43602a72a5375f3aabfd2834ee0494823beada2daeccbed8d46984d1756fe2207ca92186b506115f6de7d840c0b3b658e4d422dbf07210f620c71545f74cdf39ff82de2b0b6b53fbfa0cf58014038184d34fc9617b71ccd22031b27a8fc5c7b338eeaf0fc"),
	})
}

func (s *drbgSuite) testHMACGenerate53_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_0(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "62ebb24eca06186c05b826aaad2aa51f15af60b5f67ae495a0191f91434fa537"),
		nonce:           decodeHexString(c, "f003879106f41d940f4f6f898714a097"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6483e2d4b227201b9609ba30086405c2050aa02f36ef135739dfd3435fa93558"),
			decodeHexString(c, "6c2089692cd0a67b498424fa54f6ad6842b5d34626ee299dfb4bb4d63f942a3d"),
		},
		expected: decodeHexString(c, "2704c3ee59dee5d5706cb628f79a1efc140f7136bea8e86d423b40bdd9aa593f5fcf64b4af633a664f7e8ccb581819d32c202da5252cd56405b4996473d156700c99443b5d0dcb6b54c1860a8e7f5f5c7398ac6382c7699e8c3f477cbde5885bd6a9d5907923e8a4f0099c88cde1d7705a41a272ad9a38a1175efc97d3b71b84f22d3b0cce3d1e312961cbc33a24522dd8c98de65da91c0c9023934167cff68dab4c5d7f16c910e2d0b8874b3e75550284f754ca212cd7e691825ca4547da456"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_1(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f3d4c946892fdba3b23baa720c06444e34efe30d1db15581d5f45dfc59c04049"),
		nonce:           decodeHexString(c, "df6b5e90b78881803b8a3df73fac0c08"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bb12247ceddca5fb0a570e0765d405d40af5ff72ea95e9a919d2fb9ce849082e"),
			decodeHexString(c, "26e4caee61172df5fba3c3091a27d4eb3878c32b6c7bc40c78d0de7bcf40c9d6"),
		},
		expected: decodeHexString(c, "3f8e62a0a85b13fbd024ae94c52a9cf778a5a8027cb46fa58fcb346dd71ea3b617afb5cd971da5244e96cebd31d789caae52f7d5e8efc4afb813a6950cce1705c2ead8de6f0e4e6043264b2fb958389f48382c0885f4482e140201ecdf3b678427c5ab07184505747a02b0ea53a7d917fa9ee8a7aa250c5435768815a900d1f0f3cf5ae5fb39921e9c15264a14b9124aebd62b96c354c867e590d2b04e414e3bb1e0fc88d823aeee189c10b75aa200f40817bcc8c0ea9a2537431ba32df858a7"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_2(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "893ff8048e13ec4aae35a8f261bafb6a8409dee911a2bf9ec3d6cffadf6674a9"),
		nonce:           decodeHexString(c, "a994bacb9ea65c5bcd8718163c1ff927"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fcb46c16d85039fbce1140cc43caf000e07414aa9f796cea532e6811526ef9be"),
			decodeHexString(c, "d1a953139aeeda6419742e888ffb001bb0b724ef8703e5a17bf3e91eca5f1101"),
		},
		expected: decodeHexString(c, "c3d408d988b413b5378a63aa90bc5771a47e6f5668a1270eda593d30e5979352789aa71489d8b991f55a3f3ad0aa6d0c751f7c82559d0acb768f95f7e10e74d21bb54aa680849a41086fd452b0798e475ba5a20bcf13e83e7a40b4532470a677ae2e173b9bd873cf2e682d1128f00e8d26279049a2c2059d0cb87e48a50ea159c9a3fde6d8e0095da79e3e7ebae25dac67d2f5d7d668c4261ede42c0b906f445e1984badc8cda8e79f8742253e54e7ea5a71b177bb59e0df683af46464aad970"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_3(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "03c256ec2ec0f2860b511c05dad74bd8a19ed41bfd01992bddd40c2bd0c7e306"),
		nonce:           decodeHexString(c, "fa7568f856e3fdd931c27cb32295060f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b93d57cbbc837704a1fa827eae13860c99f5a678b6638302f7a87d288ce01e25"),
			decodeHexString(c, "d4c3a02ccf562abe26720dec088673844d340cf4044cf6e9df08404b1e22a860"),
		},
		expected: decodeHexString(c, "74c05cab4d6f8b201ffd6e7639744af5c2318cb0cc7330a0f564b20f608945b6829259e053a4e9e130a9345451780906c8a273d5f21b54dd894386a318bb8accf151e957851b7a9c1ed38f7a2f2d8809abd4c6a8df47aade5bbc717237970cda18451e1eb215f4679f5d48c3f35a2017fcca89da5b8f2c9161a7c6311d5b8bc6ba8f897ba39517b5d46a6418620ef936dd9571cfdfa60f54645421ac51d9ca1c0f46c87f795e49a5a6e13dde458e7c6671166f4b445518f580a71249d251f699"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_4(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c8e1db988eb9f4d323a570b9d112b6c4797c20adc2974d69c6ebe4522d89f219"),
		nonce:           decodeHexString(c, "a48fdb886617cee124f8f871768cb6ff"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e513b0e4f78a66e30fb5a58693d1ae636662ce7dd4549f059e8198fc657053c7"),
			decodeHexString(c, "cf7681d93770f28d3ecf433afb5996f1af45b317733e7ba7f8b9400147e2c5a6"),
		},
		expected: decodeHexString(c, "24ce04bd31dd19c28b04d00c0b60eb8b0f38bf804d3727ee1d8fe55f7401960b6fb3bcb729baaa6722925c311910f186454ccca438c01fc9a744ab329819238181bd74c1696e5b0ae5a91c9109e76dda66fed6638ccb26424c12dd1041fe95e627d600f05756a9dbb5c21bc239a60b56dd4c857b826f8cb434e39841c7cef93c4bbc84514eb7ae8b1c0c0b712286c1ed105392788d97e772227428df55ddf009ecc579d12a1a3760587ffe4212e182b06099f2dd41a46625b45245dd0b90b290"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_5(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cf9485bb0722b0f7c4eea2fd0803d091aa580a94f6b381173189dd086d62eda8"),
		nonce:           decodeHexString(c, "932a4bc330290c41cd5cac29b1f377a8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "21fb157190c749153918bdd7c109c921958d2d52f2001d28992b30f71e3ca9a2"),
			decodeHexString(c, "d21eb68721e8299d67ef2487482a78f13ffb5f7903683b6bca50e3594966c0bd"),
		},
		expected: decodeHexString(c, "e26a721c80b02f9af013665c5bfd036342b4457c2e5160e687c4e1ffea31d1137a49c1c15ae6b91df9a4736c0e0a41fdef44a7bb031f31bb041f9fcb4ab8829acbf45baece5b0a0d30a402fce6b958793209056b9f15a374cbd61e7c39f8e774a986c2929a659be9a7a4b27c38c880ed330200c8ad5e88d70dd9b67eb0971e577d2341dd56eecd6adecc59db1ae49b898dd7c88929cf3b242a2d0c23d9123503eb1254087fe64131c9747f8b4461008422a1ac0640c1c7a94295e537d34e76d1"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_6(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "36ea4a8984b22ce3c29e8e9fcb139925a8588c2d8a779d1b4a0678ede2a0307c"),
		nonce:           decodeHexString(c, "38f098d86068e3e51a1bc42792503204"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "43e2b1ed65db38caa124f8c3fa55f8d7e9233acc09a9243852847458bebb3ea1"),
			decodeHexString(c, "0b8bae69d568a82fcfa9c3550a2c251cbe97e21a7ab46d8b21409810612230c2"),
		},
		expected: decodeHexString(c, "c01be0a9f5afc8a79b7364995c048ca91aa54b2184d596a99aec552232a3c8e14f6a472751d8e1f0142fcc2ec70916422ae7a5756cb0cd344af926417615a2f8476a09ed917e111efa3454945fa132712b4caaa0ac21c65f05e2d6abfbaefbac04959b5386d4c2fc6f817c372a057088b9379c05755c9c90d5ce0c936a89c824047f2e27703b103bd9dd4e924fa7f0fb8c17cd8a2295b2241c4e19c209785acb88e64f8de201ba6cfb7d823b7afe7762777ab5f106b64b47274815d34ddc1831"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_7(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6b4c8418bac43ec55e67e1bd326a269f6f07ecd0e26e7ea9f8c3801693f5d140"),
		nonce:           decodeHexString(c, "f17d963379dac92619b2eeba2722d402"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6a9e1c3143e34fe108c82e3be6d77c320c8e645eebf320f0df64d5aa4be880b7"),
			decodeHexString(c, "cf2e1d8c5484acb5ac496340feb1e797d523b5036cdb07c5a2bf913fb492c3f7"),
		},
		expected: decodeHexString(c, "d9bca67a13517efeb1ef25dbba66a4780d32f16243b11a58cfb3d69b557a9463151590c7e40f8049db8df3b13d9b36560023cc40101e94a2db342e857c9a9ed879c67ce4977038744ff07cbaf7987bfd9b63f8fcb14101cbde0bb7d26132292d0d0d957ade5091dfd161d78b99110dab1c40816a30cf976ff9460d9420e3c110a82570972708ef162bfacaba62d93c424bc754fdecbf8ad95a81ccefc76a6cd943c48156decae06305e7a781f38218b0d7f7795f70d8b09fe8c0ac49335f7819"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_8(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8b2eff17d531de72a8763d63c16027c217052ca321dd1db60deaeebae810b2c6"),
		nonce:           decodeHexString(c, "8c5a39e606fff833d4ee2d409b101efd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "db87d8bc10cd391e143e78ec5e1b51e9e33935a652d9b878adcec8a9c027a19a"),
			decodeHexString(c, "5105f07bae116d056626642e4e2220e9cfaff7acb917ee310e0dfa18787ab83c"),
		},
		expected: decodeHexString(c, "387f7fd397133081eb230c6b787e252a0074bd06169e86039c9443822e741b5c3740b159b5d4416ce6f262475ef8c7a8f85ae5cd1e7b49b51059ef819a7771418a8254befad60f8bd74cbe178f34621d4fb3bf4f1162cf82a2ee4dec54ab7334a0ed4fa4161883dc8a55e646ca06562f605c696b8e25086e56a3d6f2c44b2c381a0ad50f3021c7123064a62faceeb209b8d1fe0a818b54e468866cd5e5e1cbedcfb3d5a8da1c9f924cdadf7cdd6184150d902bf6260116921f51d4f175e16097"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_9(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "73572014f58acd41a507321ec56f1a1ea80f2415fb6acf1bebb0cd326c29533e"),
		nonce:           decodeHexString(c, "3f7a7ea2593ea0270e57c81d4ee8fd48"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "676845489c666b033a96640cb298e46cb63a0e00fb1bff9e8d866021d3a01259"),
			decodeHexString(c, "4bead56cd537b9de0cb0a45b86a1e0da6524e6d0ec7a9918c22f8a79d07882e1"),
		},
		expected: decodeHexString(c, "5a90506005b5b45b983f667d57c5946df51e27e6949ae999cdb23c6478bc9443437f91eb1b66ec36e68a593c361baa2ec0a5787b35f412167202371bcfd694f9384adb628c8356bc183dbff40e3c291e0c7c965cf66eccbf27f0174615eabd9adb4481428c1ba2fc1dfd7197eb7b99dfb4ecbb4dc23b663fae6be5c7594ff56f87f658d4aaf89aa02e7fcc59b98b0ebab14c33c73b82805b7d1582bc89822561c214896e3cbef8b5c6f693ccc5e71d7297e0a5771f7dd184af416e88bc2d2832"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_10(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f065ffc9ad34025af4ebedaec453542355798f59e38d5f2f774c9f2b2e275445"),
		nonce:           decodeHexString(c, "254ace0f50592f76b935a0c363251d13"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6e1fe2921fe0a965c1c07542a32828ba8d33a18cf4a817be26931d11e3cf7c1e"),
			decodeHexString(c, "aaa0e94ecfedf60d871aa4eb3d7e1520acc3229701141c16af0d64d66e033185"),
		},
		expected: decodeHexString(c, "e2154a38f44222b66ebab4879e164bb83dfd44a7e4ace9ef5d269ea4b4fafe809c198c3f24dc32af488777e8e49ab1dc45e6e77136334aa1a3bb5a96193ba879d4454ac5fa236a96e252b72a0d39b896a947620ab4730d617006f24ce45198a42209491824994a3d4d477c3c9c365cc2c01e490f16030b3d27b2a3387fd69a5a8794262ffc98a00f3e2141f6e08f1749cf76bec952ea03cb90c3621cd680a47819981960f1db179aa13f314c1efec8654a92297e9e3ad7925f6d6e538581a387"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_11(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "526505d862fca5597370a98fa11a57ae6834d33e39ff2bf388d4ba0d6031b08b"),
		nonce:           decodeHexString(c, "b0028d2372e811884b5cba8d93f8e75a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "05622481ff951cdce6369a771ae1c7ac3a9a8241185cc1bb26cbdce7609a7058"),
			decodeHexString(c, "3ca8ff7ce83ff9bd1e13f0a048bbbb07f3968193b3e842ed3b12d583b203a60a"),
		},
		expected: decodeHexString(c, "7243fd41bb710525b1934a9a15e91bb7f48d044f449abb6bf8462a80ced8bff52febab1cf921c3624b112e56c34e09de2c8c4a0b281bf50085b2414be9a1515ee5990a430e61cd4e91c0e4c27910538aff996673d841c713461c68e66e7081dc55dde20428292198abec7f13da9990596e44882f271f239ef894ee72b056e4ecae1830a03fa49bcbc26d8ce07e80976ae7c0ec7f567d004a4047360fba84d47b82432502a685acc07cdbb487ac2d83205c84482bef7d65a121533451ff22eb41"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_12(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "70aa28a7f25d610abcf55bd2993d98ca26b3e17335a001007c3d6d3c82df5821"),
		nonce:           decodeHexString(c, "99183b198e03e79e0600da5e09485399"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dcede896405bbb26e6fef3569c894367d8878a1f092f516b568bfef6799c371a"),
			decodeHexString(c, "3d73c345853ed5945da65e43513673f773e436be1aaa681f1678558bee65cf0a"),
		},
		expected: decodeHexString(c, "12287cc2b1ae1e41cdcf74394fc6aa17277189a950b548f1c204df13bfb3ca3ea862cc6e145377e0a986030ac387a24580989ce8af650d3d17359649648323eccfe955d8c9c591480f27c670a00c01749c139c8307072ec484743be8dde791b0496d663cd4426bc6b6339b565be53b85b2be0bd3fdf498b61da7876c76a7d2d035c90ff7a2ed17a26e5bcdc498389fd319da44030c8a36f39d034179a5a82c3acf73d3c9ff9851ef80bb17e13f6abdb8713f04e7748b8ecf8a5af10e0f893e22"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_13(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "86038c7e900813e50d45e5280171a3a71a66405ff28608dfc4ca895c998bc04f"),
		nonce:           decodeHexString(c, "ac58edbc686abde8c368b36a97690521"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3fdd34967ac56776116576e467142c77f6bef74bcc8af8a368529f50a13e74d6"),
			decodeHexString(c, "0f9aa920a18e305916bd0eee770a510728710dd7b78d9ff736fcdf682a1015b1"),
		},
		expected: decodeHexString(c, "a64bfbd4b9bce3773baf172cde3f68da426dd6e4ac8c806c0170e0d028913f4f55eeaf1b18ecf9748ff4f0d40fff963cdb2d4369ad4490d2222fb0991c138e117e2b6a0beb3aa7095796dcb58671772ae737ee5003b67403d6e7bbfb1f9b73e5eea81c229fb7898db28ada4314ec70ff7bf26aa5dc9d9e1fbd05698d35387386d70a9d1112e09b6f2004f645f650b97d44f7191f3cfc5d0385407d369331226754e6b17bc06dddad5aab80f20a9040f1f78ad3090de9e5315e8b59bba8302435"),
	})
}

func (s *drbgSuite) TestHMACGenerate53_SHA384_14(c *C) {
	s.testHMACGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1514a977bebb10858a934df7cc34da90e283e3def25299f43e36025b92dfbd70"),
		nonce:           decodeHexString(c, "857a61b0cfa5c0fd647d6e8dd679bfb2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b5d9cb4b3709adf297462f1aa8875c9f84bc39e323b8fe1c0df269344e5035ff"),
			decodeHexString(c, "5e47728cc468e0d2c6b6a90a20f83a9f0565716af54844552988f1d8c3a83eb7"),
		},
		expected: decodeHexString(c, "548c3496135ecfa1119098ea2d862d421af024a844c37a02142e2545e4ff1038f4b73c7f6b7d0fba8f92f292cf5ca8fd57dbe7ce129423e0ddeb1dffe89252dd6b50495c88f350bb77e08c8be409064f7e9cb751aeb779eae30b7c471dc41365f128d22474a7e90a9953e948642001f8e6ba8f91d250d8b4c6407892cd96b12e5d94e4d7608e6c11604357436c8d1cc07a21aeb58d396f413a31f72af1ac06864ba68c04e0c25971c1315f5a8c5c04fe252105fc822452d0cf66f86af13d613e"),
	})
}

func (s *drbgSuite) testHMACGenerate55_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_0(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9c4a7f1cee91c735a698c2ee8b32f025086a03ef762c0bf29cfcdfd290240904"),
		nonce:           decodeHexString(c, "4cc38e77f47c469ef0518c03d93a521a"),
		personalization: decodeHexString(c, "043cde6d441c20b48d8493455f3b963edb5dc42cfca9bc9dc097b0da059ac135"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4befb6b5fd63e30baaee6d29aa0049fca44802d241044e61f25a0f9f1132b038"),
			decodeHexString(c, "17466d9beaea6732e199fb1a2f48020f0e804a45211c200dc500db6b51f90bba"),
		},
		expected: decodeHexString(c, "f488c60714f020b01b820fd5f7b8e7b908734a17100e100daf7f3e81dea708308056aecde94ba9a9eb5303ebe45427ca928522b0bc1ca8525eacb525fdcbbb8aa7632d119f740a5a5abd77529dcd0f555bf50e59a24b855e180adb6fe382d737fc76fec081b98081106932e1f64aaae912a69f5370dc287f09ce53c3de2c0a71fdf6c3fcf0baf241b68063bc13d6ed8fb2ec1687016c68acef80b48e98be7a35b92c199685784e444ab6e7a233d611e764112ef6806be22cfafb94341e79fc15"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_1(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8e37c709efa3a8adcc433babdcae3bddf0d3beecd933af87c66eee45386024ff"),
		nonce:           decodeHexString(c, "11f327a64d39084283bc1ad8a0376181"),
		personalization: decodeHexString(c, "8b72244a0e189cbbaa8cfc19c8a72a8285ee4e33f3a3f15fd537392fb093287a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "baef5972f9ed48597a94aae8869db4affcc34c3219e46c7f733d282a2496f00e"),
			decodeHexString(c, "e3758dd41c305049b5e272a6add3cb26b7ee9417f8d74e330095f0bb5b33928d"),
		},
		expected: decodeHexString(c, "9fb95381bfb55c0d0585fd2e75fda22ad43bfb0996186b3a89c70c8addad4fa6b1a5bb2c4fa50bb897604d8f4ea10be851d4fed5d43765a5d68a8216d2b6d0c41b480fc415f5bf0e2adce910ab6cfdcafb8c62ce73af7827d49eda5913dbcabb502a23b025867310f426d67957aa096c8e9b97e41f0974a2ac1c5495dd1028fce7f953d12f4601a298b1923e88ba4f3eb3dd3e5212f770efec82f84bae5b7befaf00f6fad747c878d22168295569ec1dda8ca49a2ed33c6f9eddb389f8d412c8"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_2(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e33188a0ff90b430fe56051f94dfc6ee84037f82ee3c422a8f7194eba1c2926b"),
		nonce:           decodeHexString(c, "b629040f73d845ab33d092e5d954a75b"),
		personalization: decodeHexString(c, "8f996ebdac1611d632643a44e2d9b5603463746ac2e678b708406f6cd96f8bd4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "810f71490df34b6d0f4816f285e21a43e6b55f43876268603cc3812374766e36"),
			decodeHexString(c, "ed26329e514d5c8c740cf05c3bddf88608bdb7953f01ce8f00a9e9a06bc13b60"),
		},
		expected: decodeHexString(c, "f9a8b3f0e16882d7ecd7b979a85ef4f8ccfc19c2b3eec990e5b65d5610fe8efd1debcdb5b7cffc4a92aeac9c5a11dce67ed391e7ce2e9da632be84fb203bddcb63de2f1036620ffe5ec6e85b4551c366539b6e4416f7a1d44f91adcb07807df47730022a7f6d124cafbc774b300f0964eab2a9ea058285d9f9f6af16cd3a6b920f3ab85a12b48ddb42593f2cae56582edd3e3cf413192dc21a3f20d1c1fbeda89b785ac89cfe1fd10219604406f05edd07cea23ed814c75bbb91426f5599a808"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_3(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6da45724992ba90085a0986b24d6fe1ef77f0712ee7cc830ee69ae2d733c56d2"),
		nonce:           decodeHexString(c, "04d161e1881b09a555eff91d2185beae"),
		personalization: decodeHexString(c, "9a60291fe9f320e96c873023a47a831de3984a6410295d558001889b17565cd9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9ec3b7ee3c743e64f0f673e54782ef59dba6a6ca52078cde70da7ace645fb01f"),
			decodeHexString(c, "529a343cf84e2af344301e314e0e766ddcb13daafb3f7a73534996f85b5f462c"),
		},
		expected: decodeHexString(c, "f725650dc59584cd6ee04eb233d3771ff8177c2532977521de3218fb545b84b21726984b72586b00c087b79fdf9e8dc26f689354ff4f1d2dd7b42ae8d9c04d815a5fc7d8b6785e01b10b9f43750374692924783138b54a7252b9a6d741dba653235aba45674ee0dafd15b6a203aa6cfc048b5ac0b4313b3b7ec17fb9fae9bfc9bd17344c6e7b98816845fb9597bfcd6e8d40f01ca91d87e50a2cdd2e14f81f3de2ea115141fea030b47a98e21aca914068e38191389a94155d7708f6aa5f4111"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_4(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e9985ccbed72b91cbb5e1a46400ed033a7085c1c52579ffec223a768c7fbaba4"),
		nonce:           decodeHexString(c, "db103f830eb174734584331f9690bf7c"),
		personalization: decodeHexString(c, "d048bbd7f144d4aabff87d2cb547dbcfb5ac0ed73ec7cb017e238904ed958f3b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "60faf7cb810a746eeaeb28ce7baddef8e0fa4954e965ceebbad5008927563f74"),
			decodeHexString(c, "916e8c9e766df6f458f0d81b38992e490199a770795af2853449d825a18b178a"),
		},
		expected: decodeHexString(c, "8953e8f8afbddf4c41ebcffd943375a7bd525db5bb586a1d3862e8163b6293fe267f044c887586dd031db36e4a941c6d9b4bad5e15110c488a84b8dba638456269e7a08686611ddafaf7fc1c766a4f46174c2895dfe87e594592a9edf27ab67cb781b12b2692aea11cbb150bf5496e533956e503e1293186cea536cbb3dcd4b50efed5020a6668c7f66755df83e29e83d08dd404d87576be26b8490dd681888d3ad9270e589b8fc583261b734fd16224cece0927f27d103a508354e1140ffcad"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_5(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6ab09ff6979841bfdd77d233a6aded9581956458c0c2effea998cb3563b9e13f"),
		nonce:           decodeHexString(c, "7ec8b20fb3fbe33784d1320237718cfd"),
		personalization: decodeHexString(c, "4de40daf7a43aaf1c132529f5605f97951538c739bda59125c1902b36a7afbf2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "af4c8130e8193b4d23c0f3ef11621a285eb8ec119801282d6e455e1a485bd2f6"),
			decodeHexString(c, "52ce2a212ab940fcaae1edf647da13872af620a1d8af9ae32f8d6603a9a11a56"),
		},
		expected: decodeHexString(c, "b4364042f2a28b353dab347bd81bee069a00e003f2159ac5e9da6c9b05d535e829fdfb3788d448757e036541686a5248b79fb04fe37c362ccc19096066804d8952357606d357712dc9a6e15c57736befa4208c41ddc1ceef236efdb06e423c020be96baf5aeb35f94f13d363e0ce936b193861d8d4bd026907835278ec86dc970e81f0c46f795599f80694d691a691fc4636a7264d38b7b65d3dd36b313345cca89a62361af1bb6c91eb71734ce572a30978f6774020bcb26dd2cae8daf15659"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_6(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "661b65402f7556733dea9b83adc0ed0c21d66f3eab84647daaeba7530f27bac7"),
		nonce:           decodeHexString(c, "31db85561ddc9a0647b2da0fb3668a80"),
		personalization: decodeHexString(c, "b7afef14b800513eff5cba58038702aaf3224d75943f8fb888f74e45622dc2dc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "13e0bebca5f99716736b6beb7523ca84f3f5ba0c405bd20d490dc7080db3afd4"),
			decodeHexString(c, "b478a3daf7687405a0e20c8280bed3c14b230f1d4dd0e9472c948ac2246c4340"),
		},
		expected: decodeHexString(c, "f4bceed43662ac668c5cbc6a9c3d0bd44d50ee9bf8fe2668c487d5e4425ffc3db0e660f891e4f9883b841cbf036d25d533dbbbbfa01ac4d190b54fe35f585d85da386ba02be022e93e71c7de875ca2e769c2b324a2d63282b9c1d6ee2d95394b11d1391dc05f1120d16d4aa262241058b7fb6c873779b4d632573b307752b984cdddf5f3e9e789a10e58b874e64da23323d7e731b41ae980f9c11ae45fb6ea317a42af759fd8fdbcff2d34d2605fbd2901af4e3fa321ef0bd53e18b849f21180"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_7(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4b0e29719bd4223673262342caa1ea6b1e18a600f91bb39fd2e77e0d96e57b62"),
		nonce:           decodeHexString(c, "d5ba0066f547e0c5363e287ecd8fba42"),
		personalization: decodeHexString(c, "9f540579b05abd904f5d75c0e8921e6dadabb5a0e44db560a7f03820d5a7eb1c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6bb7571dca82cfdf45a5edaffb993adebed53f206990cd898e16261c8bd95a6e"),
			decodeHexString(c, "2510cb7fe7ef4cf7c69e9c396afa35dcfa97ab8960e3f795b91a0d8a4f8561ae"),
		},
		expected: decodeHexString(c, "9ea14969c373ba4190f7e6a95f9b73c9a009074d4d81f82be5af6d6ad49a572a8850b86f93efa6f06c79449c1411297c17921fc95d7188beb5ce6096c8fb0a515edd7ef32a0bbc2f372484525e6c6a51045cf068a3519811f4cc7d6ee5a3bc339d2d1b2c550455538dc3afc3e9b3ef85927dde4a968212265596285a40e5160e65e08b842c3f9e82e28d0e594c33ece7455688da678d7be395df515971732e22483656fb57f30d0915542d6a99758d797471d9b1da999aadd8af26efe57389f0"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_8(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eaee806076cfe84c6c5fda80fcfcc92f09431977685027c64953ce523bedefa6"),
		nonce:           decodeHexString(c, "c5eb6526b3b2e6b640370be7987c520b"),
		personalization: decodeHexString(c, "60ddf3ac0890b0180ff2924f310662c7ba73ec2051af65fca86918c15e3b2d05"),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb13346d00f34e8e8b25db172ea8efd0e7927019fb30af33d6d4b52b582a0cee"),
			decodeHexString(c, "fd44e8f382296eb8c17ccbcc2edccbf12bd162d052bc1bcbf9199332d1047b27"),
		},
		expected: decodeHexString(c, "a235e1b8ce4a8d1dfc20e148641039e389485417a0ed2d712cf901a2b578a762a2ce58af3b30073f9ecad3c813bd585c9b8888c94dd6dca085dc71d8ebccf4b7388e360bb1772b09ff380fc517ba980f40788b3725a402ee229b66b76d9c48db098bedec0410e2223549659049700e363f8612bdda67de18c58f4679f8d5af022a7bfd24449a926a3ec4e4dab532a88e3a1932804713fe00f2eda4c652d18e861cc65fe4ecd90d252e4d884650e9a3be5a75ac6953434dde523a4971f2596046"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_9(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8005d9db2b56ed36b3dee590f01ca83d2755097f2afe47fc8e7842a74d440660"),
		nonce:           decodeHexString(c, "0920c9b95399a51261c62656c60bd782"),
		personalization: decodeHexString(c, "09aa3cc1f3a5600bd324bf452cd2a902a49094733d963ddfb78eaadb96805a73"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e26ef8542413fe828876ba76efb14134409e5f70fc76c9b4c80c0b258d3f7257"),
			decodeHexString(c, "b02e484a10b5d1ca640d64bcb07d094bb8d47efd2efea25658a12c10ef5e8dbc"),
		},
		expected: decodeHexString(c, "f81392b0795df1bc3d0955f231d3d64044bf13007ce022fd64f903d923fc1c720572f111d6cae234a19830086558e82d2e0162f6ba80f26271936bed9298228da55a25dab03a8c92db0caf38350fea839671354006ed73ab84cb6967e0935e6dd06debaec6f883927bd00e371d1e1130c9e7b380429bee2663b35435c4fcbc3695c6b06071e83537f819e1baee8f9dc3c49af49f2e2897bda7a5731a40eefc775f99a2e8e1164e4bc6b26b0f84a9f9114a5556a13bf706722f2d2ce90f469550"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_10(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e326266e50f1e304eadd0c2e3dd81db72a32fc9437ef8e0fc2b77f6058f20699"),
		nonce:           decodeHexString(c, "2ef476d1bc540ff6724fcd92ebe5d55f"),
		personalization: decodeHexString(c, "a389dfa175e7531c21b211deaedca81de96de398b7b31e22781682e5f3976198"),
		additionalInput: [2][]byte{
			decodeHexString(c, "30ec0a026fb30795c49bea9978492b6d38af22ef0e0464dfeb2eef8579c52ec7"),
			decodeHexString(c, "8abfcf6f0a4104e39acbbc0be07e6dccbb820812b2fdea977e033815433eabeb"),
		},
		expected: decodeHexString(c, "2d8a21901671b78eaeadb3d876ac0408aa43a373ac49629ed82705632cfd9cae9c934fe49a658c0d83ba27b803398cc1cec7cc55c68fda6b472430ae614f3f256c8b09a904899cd8ea8dbd5d2686c28f91c904349581071f56a3d34b7f4a24fa21e9327309e96bdb6b40240bb90080a124aadaa7d63299c189bd45f0b2752c4d3dd9716ed9ed1ac33c99db39470c98b30ba36404b1248f31986411ca500257cfa8cebe6eeb1f80cff0c2f3940f86c443de1ded1f268707ebdea39bc7bf839efa"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_11(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0a5805548a372be592deebe0ce7b2d60faaf64a881467c2c736087b0f5646d33"),
		nonce:           decodeHexString(c, "daa36d9cd46c6a56e4c4e660add04f92"),
		personalization: decodeHexString(c, "9540828f07a3e41c9fe311cfaa0ce1061f2feb5d7fa26332779551051290a878"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d0aa198e0f628d12433f928f3ea098bec8d1cc1ebccebf7bfc5f5bcfa7598192"),
			decodeHexString(c, "93e8c30b320417e8365d77f14b955a5fb66e01718b715001faa0cf2e7e20317e"),
		},
		expected: decodeHexString(c, "ca7d9cfc9bfbe3c2bd778ad41af45165b51f4df197d66935d91c87eb4f6967af68ed8f216122a5efa693c4487996a99022ca38e4cc3e5ff51381f1e9e5454dd82cb18f444bdf7230c7fbf070147e353db51db91a66e4801b1f88e7d0da3ef86083b6c488a154146b57e1c14d6e9d694f3b2729eb557ec3729c18fab731d0f06aa1004f500ae5d07405f9fd0e1ef034dd45e30f60ff651876c1a5ef6a3565e5ec8a307827c0678dfd21998373df08f403437aa1ea60a505c291b965157aff4064"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_12(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "81fa7898cbb2de53b18834ce7defa42cd33be876a67dd9a9ff7e9c94d05b16a5"),
		nonce:           decodeHexString(c, "889292012ecd0512ec6a34a0463ee256"),
		personalization: decodeHexString(c, "76e142c7e33baefab8adeeada934e33c369b518e8c1e65502b8df5e05aa5de77"),
		additionalInput: [2][]byte{
			decodeHexString(c, "327f07aaaf092fbc83225624f3f35efee19eabe6171a8ea6af80b405134c2d55"),
			decodeHexString(c, "e4e4678588af6440b15f37a4952761c5c8c1dd1f6028ae8bbe5c73b8f7b4e7b4"),
		},
		expected: decodeHexString(c, "b1f4cac331eb1b35e53f134b868b2ebd317df782bbb438f9d62c822914b6a51a186683fab33773054f203d8647efa86ef88a1c925fd1525f47014c02747c2e3547791343c407a85c8fdcead5687345dde7c5cf0afb1c88eb65375199e1b28758bb47eece3edd2bc8dcdfabd227b3785fd113ec7111c1787786e208f1411dbe46edc1fb9647dbd419c814c339935ebcc202bcb440864848c7d0c176f89f848c59c4f7b0e2e9ce602fc0ca9dbbfb4341425eef29c8bfe29bf6b7b1648c6b52cb2b"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_13(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1c34b5eb2e2f4cf4907366e590f05a5c6b53c1ce978f3089c50374ee4e80c66d"),
		nonce:           decodeHexString(c, "aa0a92fb97e78f86f8ed296e50439ac1"),
		personalization: decodeHexString(c, "ce60f571a5a7fea463773a721814dc779d9ad5453bb4821f25ac8209dad5f733"),
		additionalInput: [2][]byte{
			decodeHexString(c, "46992edaec1bc3f258c6f5c905c692d5db2e09087678cd849ce3bfa13ea822cf"),
			decodeHexString(c, "ebcbec558476020faa67a7657d5311e2276dfa18c6b5e974688cc8d32634e0e7"),
		},
		expected: decodeHexString(c, "43b5ab88a780c1b271b50dd3f01e6d2f5f48d202d2c3d327d7e43f8c8e43dcd54e75ea4e036cdb5c1fd731f680bd755a0d5a6eaeb46a53a9a376da0b9540bc309f0c420e243c1672da4e5d7afcfe19989e3877b87e86c6f470519129f582f53e70f7df0206f4f84d5295932fcb89d71c474e0c33d00afd6d15c4e87e1e307fc9095bcff1a0fd843bf9d2e9ccdf0e4a4c74b06d464f4d5d37e87da95d3162c2acf07fef59bca3016ba34eb7ba95a3ae30a16f3ea979e0533e8d3ae811230494ce"),
	})
}

func (s *drbgSuite) TestHMACGenerate55_SHA384_14(c *C) {
	s.testHMACGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ae4ac3569dd6295316b275c0207514b791ac1524a8def8187d38cb3a9fd57394"),
		nonce:           decodeHexString(c, "fcce28e19fe0194a146a08a4585e2dc4"),
		personalization: decodeHexString(c, "2f44c809f5f7ac6ccc7d47e6f05e7bcb7e176bf5e00a5b51178d1c94b23d1415"),
		additionalInput: [2][]byte{
			decodeHexString(c, "50ceb01860d60ed119f101d5c573b5db00402dbb03885a09e8d326156fa180a3"),
			decodeHexString(c, "01e09092bc892916c29f7b515823f244d147d4b16976cebd6a76a37ef6e62998"),
		},
		expected: decodeHexString(c, "6f1379c44d8131924c9a78286e80ebb34604ad78b531e795cc30c4f0aee422e4052f201ba226bc0c2aa3ec341fcbb5a87e24b91c36be7dda62addba6960df1289372e9677ce030555a9bd1691f559b8ff787dafa35cff5dfd66a2abd83f81552a82ba6ca7d21c438483e60fd77f93bc109f5be802035412c2af2873f5cb186b77dc055c0e0b27b16b1ef37de0b81fe63c4074a7cc8c3d27f71a992b5468351ef8b84a7b3e8f12458ff670d1381d879feeb1cd3b93436580c86bc2c33f27448d4"),
	})
}

func (s *drbgSuite) testHMACGenerate57_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_0(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b86bf722bea4cefde43ca6bfdefdb01d171282049024692f4b34d423a9f89225"),
		nonce:           decodeHexString(c, "133a73e70733a68a3be1a0035540c3d9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "87c1d165b3978619b7de30e5b7bb85127af50ec6ecd03e7ef7f2568e83692e4a"),
			decodeHexString(c, "509f071cae9902d6a01a0f7c69582e4b683f74fc53fee94d07901fed8af026c8"),
		},
		expected: decodeHexString(c, "64d9821c6bd450e1f8cfef31d06b9a9c8c666b3b6ede62fb35267334d59a24da2f8ce4eb863c5119a7104443a1e9e22b1d7b37b7d672797fe87a6b228813c7faf21bc5c1cd23584d05c19c93b8ac755d5444fc5c85e37de4aecb73eda4a947261f5141253c369fa2d1a7298631ea60567a6c93ffd95b017d0be5dc4c99aa5a33be2273f8552c20dbd313ab60f53bcf17569303f6930b83fac947984dd82b23c612df58b5d62b98340d54b071d6a22b42b7fac93be3ac810db659e8110812c0b9"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_1(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e58a82e5300f366c0c56afd704f666177194632c024653a6c39fd78e14f43edd"),
		nonce:           decodeHexString(c, "7872fd68197ba366520c3a50b60f74d4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9494ef44d55aa8502e12cc24ef2658091bcb3a15850b25367007c7e6c04d0ee1"),
			decodeHexString(c, "559a4b4fec44538947a45abef2b55a21ad7f5b9188681a1b308693916594f5f3"),
		},
		expected: decodeHexString(c, "280be8ff72f15ef75de01f605c83e45a36c0cab3a8efae98453d291a297e8b26473864472e1697832d2e1129d76f6240927c747094ca2f8bc653d2988c31ace8822d3656f5e513288e874c25695237fc6fc7007d01eae56690893703ff8369e498c9671059e09306bb270b5ac54c4a7881ab27b90e92e8a57c225ba371aa7f813f2f2563b9865007080cc278d0db3ee06e95b3af26342232a2232f80041df18aba5a1fdb906cd2f4832e3e73cabfca53bef1d2ee69379d73e1f658872e7fdf3f"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_2(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3e8c5de27d9a29562d4462f9923b09dad0f9b1953275d92d9959844804673e7a"),
		nonce:           decodeHexString(c, "54fa44767542034cdde939d2796a7adf"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9679e7d730c110b139c42196ce1ae63b604bedd098e377130873b840a753047e"),
			decodeHexString(c, "d2d33358f1e90cd1261121e7036dba3c36cd18a6b7beb4a82d1e47c69abd8e4d"),
		},
		expected: decodeHexString(c, "e6c73af620465244ccf62f5b4151da39fe4885529b3c905243f7753d8767678aaafc7379f0074b5743425715d091fedfe33f138841d7c07195ab0d04ece6419cf89056f0477f3abfa638856abe3e740ef6a25afa319b8e56d290a385b2ea2e48c20743d850f7b7797ad80d42ac0f1f104e432d2a9e264c9e6c19908916c40c465ef9d3e57a7b311154a03da4c5cce6ff74192175027773b2c8b9950a032a7a41e9728513aec144f0ec937cc12dc2ad2a4f0e00048b54cdf81378cf7c169ff252"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_3(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "901d216a32a2cd2555833c38b175ee1f76b58ca0ee28b4d2409054840b1c9795"),
		nonce:           decodeHexString(c, "2ad40293170b525f211bc7c04476ca3b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f91d7b74aa21580cd6bc241d720999db1d573c6df97ecf6460aced64be2353a4"),
			decodeHexString(c, "2bfcae59d9f250e5aec2781c52153247d9ad4c44078be1195c932cc101a20c66"),
		},
		expected: decodeHexString(c, "b9dc17e4db6a48a73ef74f16f3cdee4cfd1a08fea0ef10131a4f02aa85dd24b7eefb0474bef0dbb0b738032c964ea0e710c9cd47d790e25b5d5ea2b8dcc277b4e3404beac530385b083e2265c424ebd9086e2dd3bc39cdd3a3d0e719b04e60f9d4cc567cce0d9be2a57b5d82cd5c917b578bef85d1507de6edf496c7a3d433c26b73499beaf4ff5cfb51e89b83649f90db99e58253312efd8c2a7ded3e9f97ac13eecdb4a5c2d57ae236f715b1c74ea2af7b2a19b8426a40f573a07320315cd0"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_4(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2e27c3184e58d0e14418fde81f62773dc3aef5b60d829df57a30fa8168242dfa"),
		nonce:           decodeHexString(c, "69798e95a322ea454baf0c30c8e11379"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "89369f0fcaf68f8b5588314f396a28115f24479def507afdcc62d7fa5ec1812c"),
			decodeHexString(c, "12434493d808760462382541a6d9333ab968c989bdf39353c5b5c396fb972980"),
		},
		expected: decodeHexString(c, "ca94ea6e77ba78c42d2e36c513f9e1ec38858e0d14017c7e0950fdd8137b3cf773b24c4e4ffc18bc4dff859081a8e4d64333fd1ac3242107cd1f08acfd4b9ace7b1eeb417fd4f1464b5c27929a1473c36393d665c83f621397bc71851af6708f90e75a711b6b482ff0580cbb36295db0db086cd081bc80caa8d37c0560a54dc9e343441b9045b95bab35a50c2d2291bde8bd0d96d63ce6b9be958f3c3f90d1be1336a2ddbd6abb997ef9218c0baa3f4f9cec03c77c7642f2b744db6a395362c7"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_5(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "76bb91e695eb0321720a517c3267b293ab311f4eaec93b6909ff0d3d99346b5c"),
		nonce:           decodeHexString(c, "8594960199b709a71157c64b084a0af8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d20f33c405cd9606ceaea8184bc2c3a30a4180b0ab3bf24dee503834e1fce563"),
			decodeHexString(c, "434d1c5e4f04c0f998a60e214fd9d13f10591c2cc3660e29f9455483e2b2a306"),
		},
		expected: decodeHexString(c, "43e6fac40318590a1c9680b5e739ad821279ef551fba7509c48efaa560f109c6707a223434b9da000ae43004f0542b8a9d48bb51068aaa046998383daef71cb0c10ee5cbe1a52b64cb65c5604bd07984b6efc5c2bde92f1937e02b9467ad8b55e70001fca6b59652ea3451d3da9d31a981c27b592d674706c047588b7fe67d087e049d93de46a45f8d24f0142fac2ec140f8b3c6f2295952183928921f93ee9954b14bbeb5e2a88c87b7582824b2273ebfd4f62bda6e28db22b2fb173e133373"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_6(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "dc34a49a2e4d1222edce9e87088397e625b09a16bd331bc10fa07399cebff43a"),
		nonce:           decodeHexString(c, "abe6e879a99f1c467105f7fd331e92ba"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8924c8bbf9e72d1eaab9322755982007e2fe18cc645256069bf36ab3352dd655"),
			decodeHexString(c, "d6a726312e14b9e2fb03b9720c6d966a7c5e080b6bbb4ffcb1759334ecd823e9"),
		},
		expected: decodeHexString(c, "7b9469a5db5c11545a565b370adc239df6af835de75ff321bb991aee3fa4e98abc67873ed89b215a716e1ebc9088d9069cdea6bb8f8832c93d8beb9988f1d59b6188516a9c9df72fae420ce0443086d2e33bafcce6f8acb558c08f945c4109c6ba7e4b22a825fa9f90b15f61ae28b3aa076f2813fece691e5376bd6379e76a54384953c9ac54ff39890316881cf9afbe8cda1bc9516407ae58c6f0adac3fb706b6fe0a882facfab3d5cfdd0deac27692b14d7afd4a9f0fa771276de27551c479"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_7(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ceb82c3f876951ed4e0f2acea748e93ab37ece0d110e8df618297c8db8d184cb"),
		nonce:           decodeHexString(c, "f8ed30e8c1401eb6db5be4d47ebfd4b7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "70bed533ffa03856ee96fbee70155fe82823d3e40e940c49a5da9ef14fe95b1e"),
			decodeHexString(c, "a54c96173d3c2322f122cb0f3b13d6b2dd45f72b050d675d7e14de6eea934cbb"),
		},
		expected: decodeHexString(c, "091cf354f4d40678b532e5397217738cd5206d6621ed55f397aaa75c599630ec9fb662283f3bbc9218aa808a4ef56a61e4fcf3be9f36287ec457198f86a37649814bf4c0cb62e25a35ee65fcb9defd0d05986981d99e5f78378aea246f532b32d3fca7599e1ab0ef561d85a93ac86934528c5f07e3db9c2701ff44b948da62e7b6e61c1212574df0c66b213f1807019535c6ee79cf4ed2902f2f5c069ed57288a2636a5e05734a041c72292388552b9dc06d646794b8437829c6c2f0a7c1f6ee"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_8(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "37290e324fc44a8bb09ecd5fe8bffed382580dfdd3c23e3a4b43d91d017598ae"),
		nonce:           decodeHexString(c, "0cc4b3e487a1d8f9da80d391f9ee8df2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c8315083c39a6432ff119377dd3fa42d56b892b2a1cb19e90db21517db1f1003"),
			decodeHexString(c, "61c03aaecff7e56e0724b3cc28903436493d12a7104bc6f1c8a3e4edda317596"),
		},
		expected: decodeHexString(c, "f1bcb21912fa0f73ec9a4155ac53ae6b056afa8359aa3ee563604ac820ca3b230f4207f857d1c1a018639ddfd7dcb310b28564571f5f0bdba6a1fb34c461267e59b853b99f696714a33a12f584a42199d8e62f1e3ab59560dc7778b2299c25341e66d90592540ebde6bb10d9ac3bffc43ca6a058fdfda1b7fa3d26915601bcdbd1ff19150bd428fa820332c575db788deddeb4741ff0b9f882ba3b27b11bb4e023b64e405f8d1afa96aa1783e6011669491831f89f7f3a69b7037d1e4532e6f2"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_9(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6ec400d8311623e5ac8c1734ff7db9b97177fd105279db9820fa90f3320c84bf"),
		nonce:           decodeHexString(c, "0f4f7df9490978b72f5e2fdcf32fc331"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1fb87fae83d388c30bf6c7fc1ac9c407bb666dfc7dfbe634b4a6a509d3f17bb3"),
			decodeHexString(c, "334b409a84456d5e7d8e8fe8d2ef3df3d491b9fd3ef037ce7fb74ce4fa515f99"),
		},
		expected: decodeHexString(c, "728196571ac1200d53ef168bd8c3adb6288772dac75416e390488297893190dfdc0e80e251f0e6118642af27a3e6e86630bc5f4afe930938e88e478e393599965394e6d16d75cd1785aba5401d5768ab061fb4723b67700c574e5885bc5771075007a6811520c1a91b1c853d764136c26c91e742bfd1e033b5fe40429908028e81369bacf8baa019e0b6c218b7a6d0da0372c59b40661cd41341a6b0ee97c594f301c3617c35c58e092283bb11f52754a00547b735c75b2e45a18882961bcef1"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_10(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b9a4469ce59ba2eaf1ab63b090039a1652d09fb3b794d35ce13c5130972c3d05"),
		nonce:           decodeHexString(c, "766dccac327092b5d3b78a7058da2037"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6b49aa49bb6e08782e6ea26fd7eed0a60f40683516c1b7a388a7028dee1e50a3"),
			decodeHexString(c, "ad2dded6c6e22c34c475253f58b6ec266acd90d5ada6fb8e6b1225c2678d030a"),
		},
		expected: decodeHexString(c, "2a8db9fd0c00f56bd85e735aedc131a91d497d2f006d22f43e61d3c3de477b30ce2b5a4c7d5b86467857ed10123a13ea63da95403a46504e662f759f3e438d576b36ba11a6158606eccb68a3ac654b418342ea0e6dac1a5449d2199ffd7c3a3cc5a7bfd1b76161dfa7f6091ab454a317abe3e42ebb146dd022aba462e70d7f033bf3ac0af586543952917fa912bcf33151bbb432aeae008aca12a4098d0a07d66ec252ee8f3876539d6718328d8e43f6794b2358bf0396359f0214e23557496c"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_11(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a49b6e419b6523481267fb89ec6c1fd4c7ca95d34dd48adfbf3ade97e2a0f684"),
		nonce:           decodeHexString(c, "426fd29a58a75d73062c39b5223de523"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3e5d3ce245b2a7dd5342ee0df9ac54c5989a5c57e39b07708ccdfb5799b389aa"),
			decodeHexString(c, "e0a191eb18aae774234d58577436abebd9e5cf8c1a8d1c19515a66c8e5dd6f32"),
		},
		expected: decodeHexString(c, "ad5163bc5a9f444286c69deb5bf4490ecb79760e75b07f2d5841c3ed0002d01a55cb83529c5b3119e2eede1baf1f8d9489e6bfdfb7071e03d4f62d1cb1710e1125da8c275a6f076e39c7e75e662c97f23625c5dbfd7ab795da6d0cc204ed7434f2189f6bdd2036e2cdd56917086f9cb33b3707a82f848c510cefed7743e84c1154612abf8858e67173b9e4458509c8d3b8aa98e9d1939fd1ad77c0a41713d75d7e9b6512a0345f06d4da43d6cdd499682b16ca7c066fea7dfa79385d31208074"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_12(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fe6e09efe4478174e5578be98924610a3a3ddfa3a4888a3a0bea7f1d69ece799"),
		nonce:           decodeHexString(c, "6dde6c79096b4573e10ec6773607d6a7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8c863b6afc67d409ed2fb258192e68957fca5860f1ef11239b7a174627a4b053"),
			decodeHexString(c, "d597a278bf4288f12729e5eead1b695eb54c5aee7ac2d23c06332153dd45a823"),
		},
		expected: decodeHexString(c, "1433af934a88673aa5fdeeb4625eb84d78e131db30bf3c1fff60f766a608e8a09f80daf10b4d960fc6b08ab22622ee8192c2265f911ec25998eeda6b6e5e1c8752aff6e5e2975c4cb909dfbf0b051bffdef58ce2c59fe0ef0f6fa26e69a7e33ea8af396fb243e712cf84514ae52eb5d9d3937038086dcb1d3fed46499d3a22e1a1c7c7e5da73f1c51fdf5a49272c5fbd1a70a6c2f9bc14d61c20090a00d1c16a349ab7d1c3c2bd1fe01974f46ce785ea373bc99bed24577e056ce5ae13d56ffc"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_13(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "74d3adf8f006a0cf4a24219af0c67ca28ecbb59da663b80773cb1a950cb21a65"),
		nonce:           decodeHexString(c, "13691948a3d6de08e972e773af602af5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f9d03c7e2937e359d154e074bdfc7fda3a247bb788f52282ff450da1a4253762"),
			decodeHexString(c, "5f466bb3dec44e3c14d8b4cd68ac3a826eb19bfe613bee4befb779acf6f59d85"),
		},
		expected: decodeHexString(c, "da5088f6676967bddde61d4b60211060352c2d0f20f2362d4137b9214025b30c995a299fc91717bfef5e9ab6ab2872bbd9c1e958f9178a4119385ee50574b832616948e195a0a8aba8a72eb8362f4f1560e923c50ccfd996d85547a22ca06ab799a62c816b71fe85c8b77ec3e912968479adffe5c96db340ed01225bc8ff41191dcbf743ea50bce2e29455ef39952c4193f373d95b01afd8a091aaf3416ea0e83ecc3a781188e3bdc2440d92224ee1dbad947d9e88b5138b710764bf841c51ea"),
	})
}

func (s *drbgSuite) TestHMACGenerate57_SHA384_14(c *C) {
	s.testHMACGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "23c4788c9b32fc0123695a499251cfba0161f3ae38e20958d006a59168163c64"),
		nonce:           decodeHexString(c, "f8509371ee17ae28920718ab2ba6451c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a633f5f05ed8b09b70683a9f9a8e998ebf843b68a039dc3aa40cf30a5f997f02"),
			decodeHexString(c, "9a57c6be8c1d992bcbd599952bd94a755d7ad686698991d189afd11cb88b9f53"),
		},
		expected: decodeHexString(c, "ae0fd8a1bf6f2f53f9e81ecf6f40ff6a36fef58a3f157b6a435403e48da4e88cab7871bfe2233b92afd228bfe3117d7cff0798225a901663d51f0491109b9c631dd6d32c5bec2da321b8e64ebaced87a27f17f67082df944fa94acc6c557fa6816001642e38b7d776c631212b782f71aed6db760f90e0de8e81baaf4d419170362932e6c319dab948749b331aae41b4cb3267da37c9233c36d65d5482c8940387498453b226af485a37ea16bd9e4f938618f70aec97e8c1430a8d8b6aae396e9"),
	})
}

func (s *drbgSuite) testHMACGenerate59_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_0(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5d9c7c53665a68ba61f71f9fadb42f313cd10f19a69b28c2b957c92ebb6c1545"),
		nonce:           decodeHexString(c, "504a6dc7a2ef385a6681312243762e7e"),
		personalization: decodeHexString(c, "53160857089ccfda7edaa84d173b6d24b42a7eecfe9925838a55114a1d8a08d2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f7fb90fc9a10c4cfeefccc4bea86b16216df007e51678ba9043abeb2fce23bfa"),
			decodeHexString(c, "1121fe8826ddea6657cf0c5a99c91f00ea399057fd0f8540ab2cc0841a3f09d1"),
		},
		expected: decodeHexString(c, "aea7c37843a0bfab822cb5ea276434fcee305e066f8ce385f275f1d2d091d4addbaaa91addddb8f122c945884fd227a3657215e98fb7764e7f8e541d3fd13d214e4fcd626990a96fab2b71b64dbb46a313bddd8146c10aa3941f1b30973ad70e928cbd4ad35ea3b1e2983312a343009474609d36ad0eb0cd11558fb22c09ad9a4ab7b46b748d5854a137c6e09e1d04f6d3724d78450c9df562655c773d5cb4958ccc1d2bf3c1a48811a04617941248b7170e9dba81ba39846e5f1dfeed184890"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_1(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8dfc0fb16e2869cb5fc140f6ddfe91837b6e80309b797b68c30d6b7a8640f292"),
		nonce:           decodeHexString(c, "b254a718ee5c778bb132cf91616ab577"),
		personalization: decodeHexString(c, "8242f4ac8d4048f6d7326d22f2c64ac8d3fe74e5d8519b6aef371063fd8e12c2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ecabfd632c829db2a894ef8ea37a86f5027bb8975c8f8b0ad05a0d129d172590"),
			decodeHexString(c, "3c593346a485f2339b4e478af7cf94941e2b09749e7a88a728ba1054dc10ff68"),
		},
		expected: decodeHexString(c, "5cb6b5d3da70440889809ec0099013dbdc6cad5d79ea84cd676b6a03fc6ca5c329b4dc03909286bb621dc70e5cbcd726e735eea49af2042bcc8c26f41d4de58b5a535b37d06f89c64c480baabb74d1c685c61e1ac5187617f56057b08b1bf3fcb479d4c212b6d5474587819a0c92f654568ffefa02ce74698c95c7a6ef21583c27b9beacdec4de668b4fe143d77b671d45285296bd7b68b91fdb8c81bb589d2b6a59b4cf0cc1da8fa6007989e04628bfae06fd4c3e465168354be129b3568508"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_2(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "93fb949646b69de6fd6a088792f183a27c93c60d4ee292ff2a33d24432e9fae1"),
		nonce:           decodeHexString(c, "f4a62bb91323a10c82d31a1026e3d4c7"),
		personalization: decodeHexString(c, "9907b9bc86e0469896c4ae84ba62f742bf64c0740c249d466b7fa2089417600f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a93305a129f43d39676478084f0e156b3bb1423ded3293f464fe7d4c1d59586b"),
			decodeHexString(c, "ccd11ff83be2aa88f5f856592654dae6cc84c7d6acb115e0414dd230d20776f9"),
		},
		expected: decodeHexString(c, "0715305913f94b159611d2a1694095ac96ae54b04bb5bd73ddb5ebb29f15421d9ef81397128b9c4d8b74c924d1083e886c6ad9ce325396cee8cbdeab26ea09317184e57f5259afb812bd03b484287eae184070529f720bf4771a52e570428fcd6971e7e8e0cff6ccd669e8d6e8cd56dcc41a243ad3b64165600ca3e2de836665098e51c03bdc2f50a435ebaf0b17bbb4639b486c9ccaae4ec270b7bf7253caef62ead9dffa4fa0ffa9a5b3330228793a333c1c6648276939a3dca7ba1c9ee2b0"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_3(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "59aa99b0e4a6252c6383e799bb25a6025de181639acb1a425c4487559423b128"),
		nonce:           decodeHexString(c, "2e7cbb1c325c09068d175ab31a6066d6"),
		personalization: decodeHexString(c, "5616119af6b34c8ef543a6f70250b86f5263bd0f30838584100446ac15a96ecb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fa7d975f1bc0239d5195f935fdcbdc14f98d80b56eba681a6e682527c36c70df"),
			decodeHexString(c, "eff019de592f4dcc731b455f097079d279fb25b8d11f0a193f90ea425a34acaa"),
		},
		expected: decodeHexString(c, "42fbb3c28e7aa943c9f06a7da2179145a7811ae12588b8be865627a020fbf0dd99cb2fd79bbb42df6b1d91d1039a1ae7d68a7c4be02db6d24c5f63140afd010188f39eb8b74d4737360ceeb8885d4ed8a03dac5b6b2248a0d8994498554d79d28615547b0fb30fc34e8dd23f7d123585a44e2285f58181d0a4da00f19ee5af283d1564a79e03af42977e063c531efe3acd35bedb469ca94fcfb45ee66f25abfb142854a6e28f004e7eef73e2e5bea5c06c2c7e00ce5793a31f6e533bb84396d8"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_4(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "688c64470a51b1c68265fb6b0dace0a2481b4a27ea3dc7147746e33a53e8714d"),
		nonce:           decodeHexString(c, "63be1e439905100adb12a6049944dabc"),
		personalization: decodeHexString(c, "42257ee863c8229e9f9c9c82d2892930fe0a3b30e0f9a6953293a89decabaef6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d4ecf65a968839631f651b34eaff76ac33b6b97932e8960c5f958c705052f1da"),
			decodeHexString(c, "1023cdd5b7240582b8f68d552a95ecece66fc28052645b8873460ee493c7d6a0"),
		},
		expected: decodeHexString(c, "facdaf480300d1801e014ff7a1d9e37534c580b623b9be1ee6f24874d2ef5c695062b22b1041a7e67b26a191e39a4a75d00ff7b49a059081906b2d062f58cc019b1eb61345b7da93e68ffcf387def041dd7ec24bede8ecaff0b8e9813ce34706297e09e06755134bd242c86c378b4fcfbf55dadbd33cfb0317df267deefa8a009b7cfd7c693676e7dd818d0460ecc70b81a9085da1efb7d1c162fc86d53c9dc70fa7586f1c25d574395afbe2262dab2625a445e3216346e0dcfd4be388f7623e"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_5(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "23fa4e2f46e3cb221dd86dae48e7be4353ca762cabda028d30bde00ebb8ab51f"),
		nonce:           decodeHexString(c, "931ed9ecbce7ec9605b70a81ff15f700"),
		personalization: decodeHexString(c, "f5189f0fc5eeacf22b56d3e1591bc8f9700d8df5c55ab46a405b7599c4877703"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7457277860b1a789aef6273aa8b76d4fa78211c3183bb19d359e7b15b2a92910"),
			decodeHexString(c, "a448b76609e8a5aa826e4d856f8ab5c83da8ae09ff5e005a28bcd76012f7c4cd"),
		},
		expected: decodeHexString(c, "11ab01bfbc67db080a1323a3c98e08a3c53ff171132798cd0dede1f3e091302689cf7252a91ac83572bc485b3c4509b69b2bbfc33b9e976f97ed337d765e9ed6e88a6f731211f9d4efab22f4b818162914bf55ee3637541d988bcf5a7e73c6ec16a5def6d37c020c5b2236e7b2ac60c7f39e16a99a6fed6102be2752182c2b92fd54321bcfa0a473cbc6e1428d015d56cc69db9df2592010578796a439cb87bfb6380c9acaeca9747cfc99ec0922a725cdd5444c52d1b7d40cbb92735f97126a"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_6(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "da401bc7dd5d32fc10552a71464e69bbab5a3c078d8dfd163105095d7a8b9102"),
		nonce:           decodeHexString(c, "016de70335e530d98a67b53ca0ab21d2"),
		personalization: decodeHexString(c, "a9b7138dfc2c3a0ae525b52be361ae29a34be5f565eb7767ce864de669d6c878"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f20333a35d035b1db11a9c0dee8da0616781d146a7768505c7c9d6238d425ef7"),
			decodeHexString(c, "58d80e76efaac6196a864b0686437f8f37fce5ebbeac730def8e6d86128ea0ee"),
		},
		expected: decodeHexString(c, "3f68928bbce71e4cc5d00aa20f6aad2fbcdbcb3758693f73b520a38ab8263cb62da057d2743d6582ab02c2ca6e0552e8ed82bf50e1256b19e73e69df72a9a0beb35a0167d52ec60d172ed32a919063ca873da14013cc2f153d44a92b05be03e9116c07b78f2997d266f9def541a03401195a54e96afd06ce63b24c3948be82976f2dbd82f87fdb68231b8ccbb401b51b7589fa39da6d23415e5b61d51edbd765c8ecefe82fe7ac4d5f3be17d04595b25ff0058735c1e28c701a53cbe610b213a"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_7(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "923104612cc5f070f1818ac997078fefa47fed6a738de0f2f0864cb408d62f7e"),
		nonce:           decodeHexString(c, "0f4ae717b33e3918a5f4012ec393a89f"),
		personalization: decodeHexString(c, "f994df70505979458aa58eb16fc61144122dbb35ffe994144769c706ab1215bf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "31cc002b31d02fefac8e4d4bed276168194a363defb6dd9eabf5c393326e5959"),
			decodeHexString(c, "15a67594dcace6eedd0313cb3d0588246c881fec7ff1811e66828bf6ff8e1cc6"),
		},
		expected: decodeHexString(c, "3005c8d7ec50a45669c1cc96f72ea81fd655d8217ff33aeb3dfd8e88558fe135d21176315bcab35daf059789494719f74985ec2b6b5d3a4df88bb06ee1373f3403f3b2085beade29a1adf3eb6653717119865787cf1e78d6d5aaa74f4cbc02daee0d72cf24088fbae885c26101d1aa94420d491cf7022c84ccb8531c7f5985cb3bc0ebe1d1ed6555a35b9f87d0233d175cf4510a27bd2e8aecf3a3b23835a974502d0ed968e895e8883279bed8a1c921cd53317d599531feb1909bcfe3e301a1"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_8(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a350a44a16d275555a788eb51bb26bf55728accd72c923f0fc94aeb709461361"),
		nonce:           decodeHexString(c, "7f85cbfb9ff1667d994f97ebc7a68718"),
		personalization: decodeHexString(c, "4375dcce5f24a8b83bed735df6ea8fa3c844e2e047de1ef39e1c7934f7a10e0d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a9a95100efabf115d1539a9af5ca407a49b10eec733e8bd29d6ac3658dad2cc9"),
			decodeHexString(c, "831c5d7c1b33a8ef19f0f9aaca3d8cd39ed407792615fb5e1b1a8a31d65ce828"),
		},
		expected: decodeHexString(c, "ae851a841531647e0a46669bb1b47989f1984a20f338c0af1ed1b6796be8a30665122601b7e494b27ef5582326d2b1c22a9b4e2d193392423226986dcad99adbcbb20c1513e4b80c7f6b2732475e5eb8a62c35b0e549da8fee0172a666aad8170a9079e368f1b41bcbc2901bfb4ef8c65d93beaf98fe75db6113c18cb111b3d8ec719b12ff74cc08c95202952a9253694f232be8307d7e13c860d318e8e20722680c1558d30fa1288435c0d94b6e63554d3af91a3e86fcb7825e97692fdaf3bb"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_9(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cfb2ffc9697daab880ff300b2d0a41c28b099b3a704fcaee1ee0ed33ed51e157"),
		nonce:           decodeHexString(c, "e6646b09e52fc6a43b15346fa6919590"),
		personalization: decodeHexString(c, "d6f092bd1110ff92d9d814ca793fc2b974b02e05c24588f453486f6725bccc39"),
		additionalInput: [2][]byte{
			decodeHexString(c, "929624cbf5c2a47f75d6d9d7610b7ca68528fd4aad2a3e87c912513af40c5d72"),
			decodeHexString(c, "c4e1cfb35bc1defad7585f72ec46d2abb1ca8725109de9d11ef7194868db0596"),
		},
		expected: decodeHexString(c, "8d177aee91b7e512fffeadfae92c257d0e86ca70a9f7f5950463fbf624586b994ee1eb181ca18f8951eaea7d48730dd3aef54ec44a8392a256da56111cb2efefada54d40a8eb196413b434a166636bbc38d2dd10364ee30543c1801a573b2ca7cdeac3af2d283742facf280fee5abfedf407d8aded0472ab0737472068dcb4a3a1f1e0eba9beb9f4c59eb8c6233cf06c545a2ba47703969da7635813b484aa2116699d8e6580a083bbf8b1340649d6c1ed2d262d67d91c1bfa29b125ec46f5bc"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_10(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "450f27b3254d5f8fc52b388706eb184ed91770ac1ba3b10ede029efe079d2789"),
		nonce:           decodeHexString(c, "8d745aa6d6ca92faa65d4563bb8b5138"),
		personalization: decodeHexString(c, "fbce615973a829e1bf32910a7588bc43151bbd28bc4bed214aac784a64cc7795"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5584acd4db527b639779c21e4feeb5224db0e5a8d00fbabeb3515150aea1ff28"),
			decodeHexString(c, "e236d5f4397e50cc5419d63e6c546f5da4f20977f849f25e600a6f691dd69234"),
		},
		expected: decodeHexString(c, "6c8c81fbf78c8f756f9fc6cb0557c41177bc6be6f860dbd10da4902c8e1f6d8139fdf5efda03d794bafc9daa88f0f27b6a68fc8f74798dfdb40b4f4d1b41230ad1524cdfd9fb417a9ecae336aa0061aea424c9b004daa943623b60349e4507854dc0cbd222a938c86f767ff4f6ceeabd95a1892a61fd194c53e2ba75b327a541be8724fc2cb8274d23923ecfc3bf13e9664d45894ab2cf5dc0af6728bd85f89f352479cbd4e2fc35d55ecb1f3078609e8e79c265ab36b1aa11222c0e9a9e073b"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_11(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e704e75c58530dfe375f46afff04c60b53bbf6064eb422900a30ceb7b9eab5dd"),
		nonce:           decodeHexString(c, "6d08c287c8908dffb673aae381d8f0ef"),
		personalization: decodeHexString(c, "9e10fbd7d3829947ff27c2795042c8f3de0bf2303fcdace14204f2b1a121f0d5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf3f1a6f76aa442e467bac41b72ad8dc9f65f72f7d819cb80368ab0cc9377d35"),
			decodeHexString(c, "7b0b8726a4ae3e2db51722679c2c546887ed6c23c591f69ba04d3982bf310777"),
		},
		expected: decodeHexString(c, "4d6e50d77707246a660ff4c30fba80bfd5d50a7fc6589c8ce01298a9ad41a49aaf278d6b624bd321e8e44dbd4f72810bf1751bc5c8b7c2abbe5f02ca4c89930c586956e868553c65dcefe424eed6c1c73837f38d5b723a0ed13ae9d0e683f7c67df42a8d5bbf164ebcfc9574e00f715cac1e2165d7785ed6c16dff50c52ca3ef8e4f90b6fc6f631367680cfcc528afb2fd44b36e65bdc7eac1b84e89d6926bc67f8fe597146d24ff2e11d1dd34fa194c457c150cffe32cafa58fda63e0733e59"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_12(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "dc2b1d58051bcaaea2f7a244f3487abd9dd13132e48020c084391177f37090c4"),
		nonce:           decodeHexString(c, "e49f14c3805b94ba08f6314eae58312a"),
		personalization: decodeHexString(c, "432a8166d184b5753d5665ff24e57724e9b420304ad1bd86d687b8b5d23fb604"),
		additionalInput: [2][]byte{
			decodeHexString(c, "26b43b327aad2209a2ad4b5893ff91b24384048be2c60f905183f61bb3a99f66"),
			decodeHexString(c, "6d28a5f4dd27101c04943b1814e8f56a72bfe11c456a7361843ffc0a4c3d275b"),
		},
		expected: decodeHexString(c, "54d2bb638335ef4d30bf03f1d87e9c356bce1db6f48954ed79c0f5f0d350b8a84d6e9d58eeed77aa371eb3838c379f815fcfc0fa94f2f6c6b656afcfc7c6a6c32556a4609f88c6717d35cdd1be5de5ec6000b3fe25ee549d8263721196ac643490cad2cc2198b7988139c2976c0fc1d4a159e0013c952394053efdeabe4b58e62af9e6729b4ef520942a0abe5ad7e1653e7fe4e128edd6f759cbe769d196de2b6b1348019bb2117813e2c096f74778cbc428a1c03fbdae977e156de1748e89d8"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_13(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b01a11fa180c8f7c4246a92f8bdef73b7b02cb94bed5d3bddc9a71fc52775b6d"),
		nonce:           decodeHexString(c, "9cc2f6606a9facf1b9f6a174fa7856a4"),
		personalization: decodeHexString(c, "1390fc090b015654ea800b2a76a51ba197364872bd572e5569a62b02e781f3a5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "411cb153516e88ac3047d42554f130cf1f5e4584eba05b12000d57ce26092183"),
			decodeHexString(c, "181671639b100af3c7a6a8e4c52f454f13c7842b9dc8363094a83489b0af3bd9"),
		},
		expected: decodeHexString(c, "0fc49e77d42dd4e21547be63dce71228c5778f5846de734f7b41a736e8ea78a0f7e128dfdb56b21eff43f6bb7bfae1757815ba39a20f9b63035402c3a98833cf0624d68206d67c4aa20b89b6cf0fcefef25a8c10dd32bb4eaf80cf29221ff2cd4d2bcb7cde45a1c7068232f2db003dd391b546c2fc70d2e8ea381c9ec130ba0fbd85eae32a9eb7a1d600372babe998d80d7208914d56c6b5d078313e6b8c9df8a729efdad73fca37c68c53898bf59425460a9034fbbded5b7c738dc2310bbbb5"),
	})
}

func (s *drbgSuite) TestHMACGenerate59_SHA384_14(c *C) {
	s.testHMACGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "43c8625576b8f3440c13d936134ade09d6f87d3efea33a2b8df97730c8ef5687"),
		nonce:           decodeHexString(c, "4155f20d1c3dfabdca10fff13e8e8c80"),
		personalization: decodeHexString(c, "bb10eea932e1189909516dbee5d579c363b2d78068dae2c87439ac6fa8717651"),
		additionalInput: [2][]byte{
			decodeHexString(c, "32f618446311f03a0038dae07e85e19006a55b69501d764c241f683be50f027c"),
			decodeHexString(c, "d64a97650e2f25362fd711c7abb5635672e16a02a1dd5ed8a181762e86f4f5be"),
		},
		expected: decodeHexString(c, "54ee53e6d18e974913ec235a37a706868f217af33b25e8e5369d90071be1d01035ca331b8514f3d6186a9ec62b1e7808b7fa22859eea21e4b8113ef770772561eff7f8b6ac22125d002f6ba9f53b235f7d85dd5b601787201ee1423de5d971b2e758b3955a048b50f118c01122a8e657f69a63843bea00a46c4fc2ebbae36adaebfe3e6c9b1c82e498d3fe48d332ac1bf31ab4c80830086c8ee4b1ea190f8e269f74cd760f5a29d244064d09c1bc30832482d5205e35604a388250a7a196ec74"),
	})
}

func (s *drbgSuite) testHMACGenerate61_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_0(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f550a73ade2a81e2aac6c4fb3fff7591ea1b0a3b1f3729665b328322d65cad39"),
		nonce:           decodeHexString(c, "9699a10c9cd9ff305458d0dc98ae5754"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ca00085218dae0c745b6c97a71d46aba8becdbda6b3ced2c138d6cd666a83593"),
			decodeHexString(c, "95f0300cd33da989c68e7af53e0b99b242526f6ca3ac96dc755f553204db895e"),
		},
		expected: decodeHexString(c, "7c13c680f872b693769b80684dfea1ef9b175c18992dccf1209246d090c538b0c74cc09e8a81f24af51e03e87620b6084f948688666fc66e9e2e2ce0f74ebe404b80db2549c35574c9b5a7bb1aea8edfee08d8d711394e301fbcce81d71c051d0e6d1635a8f58f6cd397ba6986495d984e1eeba844fd1c743d920a6ea80abcd5d2367419999b17c5d7bd05fb26b6dc37620b5c56f28bb0dd8f4fd2df28ef072b23e12b4048e6e92a14bf5c99fd67cfecf8eb587d31e86cac2e96d6d65e49733c"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_1(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4a8c46491abaee69859e568def790f61e8ef5795bbc1313c7f6a04573c4250f0"),
		nonce:           decodeHexString(c, "bb91875f71c4814fbc3b74254bcaca90"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "224723394147830a34509171940557c265bc7c15012706cb7f2596d4e919bbff"),
			decodeHexString(c, "a391db8e3da2c01271d562a377b84e7b0b42f45954d6d99155b17288c81a5a12"),
		},
		expected: decodeHexString(c, "f529737e0f26492d7b56a4c08eba591ad34e433917671ef8234d05c1520b8e69023853a0639acd3641c1f461c841ae2cbe6d4f543d8053083c093797fdb79bd4608d2c78d4fd9a82deb3be23180c5a987ad9b9179e9245e384096a4a410c72e8808bea70076a468d8f18ced06a1f91051d66b683c8cb1e55ba7027245c6a8a55a67711e2cfb3f63d7d530b8308976a6492f5259a87d0b3ec9c5ac509b2c25949ba3551a2b9c8f231a092438487cac50a173039633d05c67095745e2635864498"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_2(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "907fad5abc0391eb2eb52a33a94440a25a4eaa44510e14ef693c9ec00766f422"),
		nonce:           decodeHexString(c, "b9ee4f24128363519e9574bfa40194da"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b34bb91f6e63a2ac02e2d1f6fedeed3a7f5a87c84469fbc0badc14396be6db73"),
			decodeHexString(c, "b386a9db2806d42123390a899783282ebba3dd55a7722574deddbf31949a663a"),
		},
		expected: decodeHexString(c, "d48d20346fcb3fe1933090bff111ced621699782492cdef6eb4dd13d797f0b6b85c60cd4e9c54e7c3ef86e0c81f2d69155cd20455aa5fba6326b084f1b5b6dc6536f8cafe34538fd8c5dc084236cb707fe9463890abb7d3338a3a869698e9d5a2f03b12fa83fd361eb4c324c4a734336369a92b3429ab2f2463b1b1e01c61ed2fd8abe0462ec5c0d0b34521563a58d031fef357e778864d00f2bf5834db33f7c2f0ce1b39a22fb854fa2bf9125067be15f0a3779dfc9b016bf480b31698677a3"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_3(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0e335b6733af1bb5cdbead51be3adf5d9404fae9d5c2532e18a4a75308d32510"),
		nonce:           decodeHexString(c, "523a7a194ea46c97dedf8edd4ca01c40"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "44c47974894c61a1bc5c7cea1016e3731202265d23f3a44f4c60054cfff9caef"),
			decodeHexString(c, "086fc6c5142b1b8bba5647199b7a6c0a855efefcef7553ddcd90721af578d9b1"),
		},
		expected: decodeHexString(c, "96cb6b4ea71d2fc2c905ce111b2464eb5fe33aaa77c15f468ba02eaaf45128051b2e972ee7e9e042039cbc6a9679ac50a2a6c277c26e6edfe9068062ef4a3ad88af7fe49da0b92547e8670402650e001b2dd966f2a8f663e97510fcc791204d0d0ec780ee3951484b74f7f455b343cee97503617af207eab2229678ae96b984388eb098411633621e6350e5d192b67a7d6a512820df34171f737c4d896016c192d42f8e5b1dee49c7144ebfeec641aee385b20b2fb3668d06fa0cdee2662c4a4"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_4(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d8f8e9ed7d147bceaafa2238fecda0549f900d2b4fe50ab4c97b1f4234cd9f05"),
		nonce:           decodeHexString(c, "801879444c78dc7c4e66008c610003f3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3082526b235f490feee994465d1fd59e357fadaf486afef08e9227b4b09dd80c"),
			decodeHexString(c, "4517a7b5dda48239a92411a41a613c6b887f264b83ac9279cd49e27200823feb"),
		},
		expected: decodeHexString(c, "82f87a256ca3d2e496d697dd52c62d8e89d55175c36dd0b25d7e7b4f58e544d5e989b4a4db9dc29ed9d9c07741f72becc532879759bf17a1e954da4ce83f573114e7cf7364d79e1e31a9825111715bff637b23a58fdc7eb6fb196386d5a8b5abf18becce3d97db59af82291ae2b647724fa97681eca62b2fa2edfc8570986a963dd4fd9d238ed8d519c1bcd14dca43bfd6ab26803ea7fd04756e65b3efa048eb892eb887f85405a0c86573167f64e62fab598a0f89431e44746a8ae9abb361f6"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_5(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "86c8225a2c1bf4da6c8a1e017cffce3e2e9be8321ab1b9322da0ecc53eb8529b"),
		nonce:           decodeHexString(c, "05258ab2e5834f2f5ae255cf828422bc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c31f94ae4c0346c36911224f7de28923d38658a9a991954dfa616014c000629d"),
			decodeHexString(c, "290c37203c95d9259d4d6e13f10584df40dc5261d7e2706cd0db032de7964bfd"),
		},
		expected: decodeHexString(c, "08bf5fafd9e17aac1db7a50bb7e9080577d45de81527ac8f8aacb5e3d8971318ddda9762eddc386dcee82a4af97d6c790c4651be9950661a9b521f1fc71a92475e98202595541cc75a9863146df2bfcaf6e5effde1cf816eca3accf22918732bd768c01ea5e31a67f6b069f4f59dcec43314135bb863da9f92f11d468f5ce40bf9a72ff0251c54f42563f383fde78fd558491131e2e2fe8d9c78c56602cc0fca42ce76fe5360c273b6b30dedbf5b96afcfeb5b1afbf55c2f5cfd520c1a5d7b6c"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_6(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "676bc936e201ed7ace38d38442eec8ab8b56728732c78f50d2c5c7b651a60388"),
		nonce:           decodeHexString(c, "39671aef736140a276208c9443bbd056"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "72f9ae3bf30332e1b6655cf55113202720dba5bf69f0c9a7bb2d3fe99ca028a8"),
			decodeHexString(c, "9c134c8b6ae178e4e72b05569e9a1805fe43393463c02e6f6ac845030317f1bb"),
		},
		expected: decodeHexString(c, "d32a85fda8427aaaa2f9f78193ef5291426963cfefe0442437779dafd35f32b91d091de472d90b6ed94eafc3940a81a68df200ce1e4a3712ab34ffcccc618970afc96f084883e56445b137033fff7113e8191c8b98a0ff24100af1587eee09f3bdd9218d6c58868be6cc7ac9ff874719d05752b91fdd4fb170ac811a3c52d7269edfe26449938e2a47b08f37ecbaa7598088c331fd45b6db2921ad0b42aacac4f95732e7ce8fc943b2676d22a509988c826a8fe0f5b200982bbb5631eb549ea6"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_7(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "83985d33fd3f7a61d418892c79e568fa62d6c7ae33cc49743062f824a387eb81"),
		nonce:           decodeHexString(c, "1e750139896873a61a22845d998d7a01"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ac2a8ab5f56e379a6d567637024d0cc59573b426264c825aa00ffd33b806abc9"),
			decodeHexString(c, "64559d045f264318e570dd79986cbf8fea8f5311b03a83c7561d5f896ffeffe3"),
		},
		expected: decodeHexString(c, "bb3d0b1d4c8ae2d13203c3af720ced143a51c2c095d0a2a4b0b83d3886ba1f3d763514914836b5912f65dc30cc2f61fe973dc4389dc8177874677e63aa45f01ea27854c6dd0a9eb9dc9ed5a2b8e002e5de325d50308c64c7df1960d8438e732f8c436eac2444dd50d9dc0136bc589177fe1f1a9782a219800d1b8a9fa4d36e0cac9404c1e30db227a1956c3db519b0efc3d07de0fe863b46fe9b1d21683b2661de4d85e8eafed5b0fb9e899db59008850185a39d50eac34e7c187d882572e128"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_8(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b79b06ea08a86b871c3a10b70749c0a93edb753e1eb442f6243d48df55478c30"),
		nonce:           decodeHexString(c, "45ca1eceb003819b6c2c9c3c96a22846"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8f45a1ef8745b46a258a4273838d8d22fbf3a753583255107238fdb9017004bf"),
			decodeHexString(c, "aade8a28b63cfdf042406b6326aafbf7baf88eada200ec8d807149cb9a29d876"),
		},
		expected: decodeHexString(c, "250038ae86852681851a211915786f766792179a7a32e949261eca18af237a65cb1ec6ccb45e2c1a8e4fe213a4db7860f2143f8eba763a94b94fa30f1436851b7fb211ac26347113e673f4b7bb52a7fd1cd33c01f58a6853d83641e5bd5a7447d0b97abecfd03b55a74514ffd204d79de8086c262e9068c5c004cfd3bf6528eea9ca7ef2f6dc4ce334506edc55d4d32359f1ddbf696320fb4822ac1cf1c79ecb168f9c3781288fc304f299a7f66271c308bd3730ff7b0d380a13baa342a5ed95"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_9(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "00d626c3ca068c64dc073c1c4927085275414a06daf9a66f16ff039c4a3f2c96"),
		nonce:           decodeHexString(c, "e059cde80adea5a2dfb7f6d888ffe9e1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "384583b9652d8eac7d2c8eec19a14f8f9f7ba0bb7791ed8e026dc39eb7566c82"),
			decodeHexString(c, "46b2bcb68a7264dadaa4d6391688117f103c0856bd9df8f825672e80391657fc"),
		},
		expected: decodeHexString(c, "ec2e0678b67c881f8fbbd892a8a513453ad8cfed5aa98f0b2e88f1b21f0b6c172329ae1651506ff442f5140c867308db9fecfb906095d9c0313e036725a15b63a0d3c6ba631722ef345b2a3bc4d870c4e3dfbfcb9cf84336cb680906225eb0a8051d7a36f573953b80502058373eb737a168a29eb68d4ae8cc9217fc62cb64c939dab72510e74e637a0741aeb554f364557f483ea3f1f2028615b3852a4b2fd6dc3fd0669682220d7e6dc73bf4a687cc7aceeb8b80860d4de7dd437618a24ac1"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_10(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c35a05e26d716baf236e8a695ae328e2788a1846a5fd2c2fa04d91f4904cc951"),
		nonce:           decodeHexString(c, "b75c87f786d01ee1500c678a89218b71"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5ebb9f8ff05744163076a401ea1f985f15e61e334f97f6bf3e7cb233ab10f2af"),
			decodeHexString(c, "7a7860b2782fe04c0095ff2f3a0613f81c28942bf7a8460c1c6a832408f9f292"),
		},
		expected: decodeHexString(c, "8ab7021f328c92a1e5a1ea643c5deb9d0a0584fff0ea0a4cb560532e3d083525b846a3ef4042bcf90c595b36480f4f575196fa573e858605efe08f7da9f6e9d5baa22624255363312a2879aa997f69a3e834727b79212f8ae8c058450ebadf7d24fd8d08bad38b1fde9e9f04e6b9645d9a63f8972facdfae5aeabb71208f708373be24679881bfbcca4ae4741709bbf75063419bfd2a079e0b386adb8c7bade05295901aaa0287fa654abccb26f0bb611a3957808e0db94bdc463bfc4ba35679"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_11(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7094eb8f4362d3c682b9ea841c5f3f4fece9684cdf90a64648a308263f960b0c"),
		nonce:           decodeHexString(c, "6cbe49f3bc3f91a1aee6034ae57938fc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "356af1b365a70be97aa88058c12b1e2bb6d75905077caabd13b1de7c44f92de1"),
			decodeHexString(c, "73aaf6b2171a959899af57f66b312129275e3926bebc7af3a1fadb312e313a0f"),
		},
		expected: decodeHexString(c, "a455e30a961d0e545e7060e58957ca8f8171208992ffb69a3ae8ee9aa59945020a1776a3365a622b82df14b9ae163a457b1cf9c325138bedc8cac7dbfcef896b2df29c3db67d622b53b52f06ce11c7b7b9d41913c0ce951e5b6e91385d43a728e1795c16a6f305cb1af6894f08372490f600139685f54d9b3a6d8253cf1a2c1a47e5c843676d0911f326fcaabedaf9295e90d3ea8cb667fb223d08a2e220db2619f1864d6d50922f031d939dcb68d8a73e8fea3136da0988a113c77b7d89e179"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_12(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ec581c6bab9f3650e4f81986d226c7110754e56b55203e3878a67ed363abe0ab"),
		nonce:           decodeHexString(c, "edfe66023c6ea2e240dddd067dc2ff82"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "24ac39fad4e1c34c1610ce79b8d9f429ee1b2a84b90e51b0aa1fe70a2f0db259"),
			decodeHexString(c, "3133186792cc1697ee64e4ead8a25212e1c8aa9facdb0ba32905576fb94fcdaf"),
		},
		expected: decodeHexString(c, "294e71ba9f8b9c0ed24a79ba9d3b97843ecbe28c203fe5a11d00a91bbce3557c8786f540cdb1dc3662ffbd7238a56b9b8a422d2d8c689f5a1ca64cc888edab463c1e788b89f063bc6b78a19fad19e7df5c0e4484f864228862b0faa43848fb1a03e87d41a852313283d96dcff87c3138918e08a669c9ea2ac75e83037901b3b6cb109fc1daf38439ace1ef104817f47e009c2635612fc3a26c7d4f7d219388f08bf2f71b79615dd5940dec1237e40e34ebcf01213c355c87c7114233038fce11"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_13(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9771c148e73b526145fb7cd020d8d1290b44bd6e9bc419ddb63afe8b93c9235c"),
		nonce:           decodeHexString(c, "2b9b1916d36006ceadefb73ce791a240"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "66660895abe90ed678c594c40a48d3e267a8cfc55c934d862c53003423dfa804"),
			decodeHexString(c, "293e651964044844ca10dbd2d28844a9343a978e6406e14819478da868145055"),
		},
		expected: decodeHexString(c, "d803e3e953aac1115a9768aa223d05ef99e81decdc1d288e84942d66681f866b7431763367e0cb5a8d3c9d0bb06b8d032c70005315d5afdb2a73fc96a2dbb759987a6a6a10e1e80246b66808d704c42e1f64e0cbc976b6bfd0c45088c64636e7ce036dc8063e9bcede4116b1e6eb44733946f820713feeb892e584dace4fc3da0dffc40cc2ee5bec8bce062f634d3d7edd969d42267f21a8b153f6ac771d24d2440574fc4a15b92ee0035e809a0ea9e790ae7a8ea9c4feabe36bd0e89821a1e7"),
	})
}

func (s *drbgSuite) TestHMACGenerate61_SHA384_14(c *C) {
	s.testHMACGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "15b572a99520a823420e4223ef85ff32250d6977f58ae95b1ed004be62ffa57f"),
		nonce:           decodeHexString(c, "bfd8f7be44b81fc23cc1a02b30b9021f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb9e19bb6eb7b714dc4d56243897916364dae7bb3861a4697d7d3f2b149db843"),
			decodeHexString(c, "156d12c7a1d0af2cb9f2d0610cedd9ed3b982e77bf4a9dc1ef0f71284b751ca4"),
		},
		expected: decodeHexString(c, "d3b0b0ac5150afdb3d9de12d2c8a7d45109436ed9c316aef1d1fc5bfba1cd37cd750841146dd08320539eb1678962e990f7b7662b44b918447e173672b873b8ab0348306cf6ae2bcc6756036870745436571763efde334dec5be7bb9920629a36cc5db66e8824695cabecb8bf092858e095a2a520eff140f483ec528131c850a8eaa48d8c997fbc810401ca378666d84020fd34af77fbe1152523e979560708fb15f3b7981e333ad4ee8c2fb6021a562f339616823cac5998cd919f82d43f41f"),
	})
}

func (s *drbgSuite) testHMACGenerate63_SHA384(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_0(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d7dbf40b15ce2ed99981e548230f2b0da3db0f89a19d35f931545cd6f631da41"),
		nonce:           decodeHexString(c, "cd0d2912a9f40d0a10573e65aa23d33a"),
		personalization: decodeHexString(c, "89e9f6570f95e59234f850cf572f2e82dd9b898c77b83c466674075227a51ade"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b263d5355c94d9c9dbf430d763ccdff333616b955bdadefb7bd74d3d08a16ba9"),
			decodeHexString(c, "32dc3f4b48126cac341695d1974c67bb343f0e2d1e2550f701b2b611ae3c942c"),
		},
		expected: decodeHexString(c, "1ee4e48d8332ed174ee3be9010cd5c0258288b7b952c14d0e1e365a675fc6087e39e7e40fb2ec07691e40732aac1a1cbf5b0e6c551fc17f81be729b1596eee49586d2604c8587fbc0acc0006a73fb84f90680e135d9e25a087a6910a82d93d8d5026415981ec8d1e6b3a12e25d6295fd5217893e50d5e57704ea5d221f8d0457fc4de51d7c5421d5af63212050252252d9fe1ca5421c1e0a2b262ac206f1407e000a55877bd5610bb5f543fac0de3b5834fd265e34358b37fad97aa404649d78"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_1(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8a236b8c0cfaab8a9c0809064f164d07c183a7b78703eee797d77e515d0da612"),
		nonce:           decodeHexString(c, "47b2b3e33e95b2f3c2b8f8dea0c207e0"),
		personalization: decodeHexString(c, "443ed6fa3941e0b67a107c6545d41bec3cd75746fbc910507e2f75d9ea2f7795"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d71b802411bd0694097d27dc059cc512c38612147ed1cba292dca30de102f719"),
			decodeHexString(c, "13206242a65ef05f616543ac3bb308ddfcfca210a3dfe06e627acf60db11c50c"),
		},
		expected: decodeHexString(c, "7cae1fd9f7308208bc2c6f98b3a5a05c4a4d0250c759d2be6dcdb54c1c597b7b301d4cea849126fd6d724c240ab165d8b75b81cc7120d2f727c9b0c0849e32611b79751d175fa7189d096eee7887b53afb625b4e543b67681942eb98c871a5ae4d24e8db5cf477f6109186a0a2eb64188abed1eec15513d2408fcc5e97d8b99b06e65491f6a15854091b10ebf9fd9fcddb5d836a089849467f3a6fff40c1640696ca1cab392f3dc24ccdd9568d971e67ae452d36fe8a320e6d9a9bfd03f499f3"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_2(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d433ecd48f0f8eec52abd23c7201244fea49c4ba16b684d402e4e8e391938405"),
		nonce:           decodeHexString(c, "3d96ab5c95f13aefd4d63449c5f64fdf"),
		personalization: decodeHexString(c, "f0dd0c4b1b25c923665109c02605451c55b7eb07ed3ccd0591f2a912fa3ddc6b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "306791fe4783249348ef2303ac68a8d1e53b2ddc03c5004a5e7ba883fa251152"),
			decodeHexString(c, "e4eb15bda8ff4ef93d3ea03748090b835cd93bd6366003404d4d8277c5f1e76d"),
		},
		expected: decodeHexString(c, "8780007645be1c9c288091a0393823026ec2c0ff9fcd61f6fb9eaa01b56b7b9cddecfd51e7a6263fe321e6edd12c17fcd5d036af711ac26ebe5f9602076b0334d055a1a399334571f6ecd5898c20011c05c153731dc31077679f558a4e1e75de4b7056d5ba5edd721eee2a18a8a74c4c12b80f80dd8f81f41e3cb42d654e302a96abe294d8c648e8c577be58a9fa8ff4dda2d4192f1ff3b0319d8f9e0d50a30673a0c20b83e7163375c48a0b85ae9b46cdc7eb4ae318230f0b8acc19ce908201"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_3(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f13704506d90cae5638820e685496d08364b60f210c1e3cf8edfc662da150897"),
		nonce:           decodeHexString(c, "dfb760948872f8c2001531d8102d1cc9"),
		personalization: decodeHexString(c, "ba7a8b96d6b005582dc14bc9dbf6e3a34b02431a6fc7e3c95e6215d92a882b30"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c8daad23ea5945eb738ad2c1ffdaed89ffc3fb23a192ec8f33fdc2fca6860399"),
			decodeHexString(c, "70c9db40ba55f426d41fa0ea2aabe40d4d7c859b497cfe3aaaea39d221e035f1"),
		},
		expected: decodeHexString(c, "52970c4b998d5837de02b3dbab4e6904cfd0315e5d46752c5cc977da79858b2ff798f0c5b5651fd91f95624a9f5b9375066e1d4705daca5df32c5022c589f58c8eabded1c03d0e195272c5f1595fa5e8979617f6b40a19398af3157585e346289c43e416b6129c64dd64f3079a15f71a824e10d832018590f8af828117952e783c4dfc2b27c86bca3dbd644f5d448bc195216e7c279d553f7078fb24f3251832c0ccbe0bf2331047c63f68b138561187b27a4381a2ca52279eeb680bd112a896"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_4(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f6e6912160ac922377567d23314dfad6fe63858acb53d29eecf2799190c76803"),
		nonce:           decodeHexString(c, "9c79a142bdb9db4d16844b37f4c1f6a2"),
		personalization: decodeHexString(c, "24133ed4b4ea655d010cbb09de6aa7ec2f307635d139a76a6f53134328ff16f8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "66b1ac9156025628e845e4d16afe9c29eccb473fd8b0a76dd20d3aa44b1eb702"),
			decodeHexString(c, "401b86a2b4271d27c7ece175de3e0ec606c125a3645ca65180ba096bc7f7f6f4"),
		},
		expected: decodeHexString(c, "aac448a6846ea837589de9c75b80e5f0f73b3aca9c5ca35a0a6992152ffa4dbda84aab40950255aa814b1e37fb628604c14fb8e93134cd02b78af6320fefe27dedba5af0202cb4b9b6afbd33623f3ef650eddc4105e898ac2e2a2a29ed69005bd7402f6b882df98ef90433c263e0e746d3f54ae278f9232ec1b6d5f1536f87536ce06f4602e6fae888b8859f76938b5aa458abffb636f098fc47c62f56d7584d762c5d3effaa26bd68f897f98500c74b84ce7ccfd5bca08fc3d4d8947b00571b"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_5(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "81b3c1c4f9750b1d0e70c92c28d20154fa6deacca86f3126180ab070e235ec37"),
		nonce:           decodeHexString(c, "efef7473462f8ff6d1cca84534060bef"),
		personalization: decodeHexString(c, "b3ad0c14ff8819c295494e80f0214014f965894dc14441ad2aeffe51e3afe150"),
		additionalInput: [2][]byte{
			decodeHexString(c, "503e69b70f62573f2436766503937b4980343d9659e8d8904025db535c75aa7f"),
			decodeHexString(c, "43fcaf436abc01a27be29dc8a6bda725fd8a61f761dd9fb789d2f14e26787be5"),
		},
		expected: decodeHexString(c, "272a34eea7a52e5c010571fc7309bdf297358f22d5054e10636f19dc6dc20ee9c7d311832184f8f358cad9f9c4b24bd6aae1f79ca917bbdc2ce82e1bd239015f745060ca8bd70c205ad25ae1188192b413e93e8785f8102b9a93dc5fe7be3e2ac0b33820461e9f7727ca40dc422eabe48d6d32165705da68ce4af6f92b1cde8417a0f03f957a1532a5d6edbbde3aaa5fdc31ef8ef23bb2328dfd41d21aa9ac34b3253d11db89621ca9026849d6054d743e86996bd0f3deb53caa56f9c5aaa97a"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_6(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c74f75725410f6dc88724e1d4042e65876d0c07cae476458548e9924862bf1fa"),
		nonce:           decodeHexString(c, "1aeeed8e5b54d980d76cdccdb282617e"),
		personalization: decodeHexString(c, "1ec1e3299f2d935db01aeae77e24e4a12c7acbf390bd061cf97b9cdfea49403b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "89f75d89d4e6f01bae5ca0243ec0e4db5b1294243eccfa7a3879b393590c4c55"),
			decodeHexString(c, "d7623a2e811e3759fdb4111e9975fd718e014a4645b4cb39ac88d6d950d2382a"),
		},
		expected: decodeHexString(c, "76c2ac9498598843353bf369e5b2466681efb22415c891dba3706a15fc92cbe9959275766efccff5925e40caf156f3a2ba47f20397a877b89c4715b72b9673305d7a6e7f04f40c5d9c7b8bce66097a69ab2148cfa4f37d138f012b627a0c2779dddf42012c96020b0520f576e5a7f121687dcd0c4ece1282aa0d46634a881aadefded803cc125625f309453f65f16cba85d03b083ca6d603de271760187213e2985d1f09dd7c6e7378ea5e54c2c1568d11cfe4f94420c7472783eb8999ba5f0f"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_7(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9986c72fb73e9b17d2be1a899258135ad3e8bbcb3825698194e6c5e36c335fdd"),
		nonce:           decodeHexString(c, "8746f8604bd75b089ff33cc30e6e2a5f"),
		personalization: decodeHexString(c, "b125be003e38c2d40043a26fe22d24bc93e142b86a7821a6fef68f72edd0547e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4ae69b086b45876efdc54cde13919e12705539ac595cfa0de346cec54c5a6dcc"),
			decodeHexString(c, "13da91d9a02ff0a2527c4c9370896e734d92f92c9568bec22e268dbf76e913c0"),
		},
		expected: decodeHexString(c, "bb21f51cb988eb1c3f83467719b42d2adef2d07d24aae2f09d090424c349bc616a87ce7cf7dfec8a4a2651edbca628f6b07e73c25756d3ed67547e723d0f0f619aab1bc775eb509e589844c8e28ca868bb95d79f88828fe7f19a76e3b49a77e40d7fd32460f00a07b8cdc9573ecbb125ccf677208dfc2b49d816d8ad436e568b3b086b7fd5491101099c6f56fb8f154eb52be4f17756e482cc59108a79b0cb1ce3b43e619c1e14a84c6ac93f5fe20ed0d809282462209536c105c08f345e715d"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_8(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6f1e81d2fdfc2f40a8454ec91407665c0771347e18860b4c3bd79e133b2d7eec"),
		nonce:           decodeHexString(c, "ca7ec8767baf20cbd123153b6e80015c"),
		personalization: decodeHexString(c, "7e283de6520ff84944a760dc14c2d1b976e5a09c0e227a59499b4ddd83a102b9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "aca28f2094a28265e538ba59b4a0c8984198312b643e93cbad5e7b8aaa8c8120"),
			decodeHexString(c, "62049e29ade953bcd8eeb7051b8803aef7a98caefc540d4e4fbf08e067d0291b"),
		},
		expected: decodeHexString(c, "a481248a2fa67f1defe4e9d4f26304d30004565e4880e4cdc37e7eae6d1ae91d2c052856764317af5cb89847742be85ab67c651d654c8f6f6f4e014734d6018330b91c763c39fe95b68e071740818f50705572a2ac391f007a7e23f6a12abeb03779ffe9520e9f0f840cc13d4a94b2946ea4a69a63dabd2622b8c00d65e2131ab38ed82ac8b4a33429aa6d844dcc6afd507db02bb67112023e014dc301b75f9e821d3e212ec2a34bde5b64497824f2a54651b7291e009615ad57968b96e6afc0"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_9(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d00f31999a8aefcd4aab14b74c5190a5e4037a6661ef1a4e107be81d3f7ac922"),
		nonce:           decodeHexString(c, "c80f10d28a578d4c458a21aa58096ae5"),
		personalization: decodeHexString(c, "ecd8172e7f6e23ca272a69fb2ea23c9ee85d763e567d5f6a684a0c12ef851bd1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b63e4f662b9d9107281da4e19e8f6033ec47dcf02a5c5bebf8148492a948d4a2"),
			decodeHexString(c, "24d1da3fd579cbfc9496d9ef3fbd7b72012b3289b9f132316eba13cc79def6a1"),
		},
		expected: decodeHexString(c, "685d45e702217e797a0ee0fe271c1bdf72915ea61f2163f8544d8ab41c6cefdb581fd98f522bd656192246314dcd6f3eb8c7c82c36e1b82ae4c48165d44e86382148b0842ac2c3fda2c71930d3f569a4ed6a4b14a8cba82204fedc496362c23989e6065e134106691849269b1a4aaf3dfe98cff1a8c18fa814eedd6c7c7893c567b9cb45f771142029c3e0956a57ce682d707a95c19b3da7c273fa8da3edcecf596cd48614c930e068e8d277a3dfa43a4fc0c7db01c68db594e7c2304ade4663"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_10(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b53b275d9b54244c06d34df0eecdadeda53dd6ff92e85b311d6568b10eeaeae5"),
		nonce:           decodeHexString(c, "9969ea5738114a585c6cd0e24e24f1fa"),
		personalization: decodeHexString(c, "47768926b26609fa308ff521e231adf334bd02a5d9ddf2fdd16d03a0ae808e79"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0739bf3fe45a9ca6e23aa21b1d93fd77174b1d86efd10d711ed7ef7ae47a57b1"),
			decodeHexString(c, "297557d197e9ae02eab318f74dacc2df93fa2e71d208676710dc023375f8969e"),
		},
		expected: decodeHexString(c, "33bcbde29d969891e8e1d0169b7d293ad3d08ff0b2ae01fa97b9a4b5fe37aa676ee185b2ed0f9cec1371aa9c426690c1a66b64a2c1aecfbcd539eb2ab56c92a0165516bfd373a62a8be55da9674cd6a588bf586c6337d95c4033c2c436e329904604322c44b8a6ecfe67e4cccc37cc4c853aece7d1fe59bb54536d1299802e6c9e9c7697013baa8de8af29db409a3f65a8af607d97a17f4ebb0c0165e722710d2c92c129a58a138d9094f60f6f5b681db68336b172124d4e8180a241232686ad"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_11(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d187322d390c6922639ebf3d752ff8f47915305de1d7c18f7971b5665b8da6fa"),
		nonce:           decodeHexString(c, "cee12f48dd46d0664205805ecd8d5fa7"),
		personalization: decodeHexString(c, "cd8abaa08a4a7437b5f3a9b3866b3b272bd4d1c44aae4dc4d599f7f2085fa6bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3ad2274683ff6b05259e36a057502c4db82691daca42377e746158d0cebe4abb"),
			decodeHexString(c, "2fcdbe681d1f708b9e75eec0edbcacd657c036c5fffd0f7b0c760be0e9cdc1e3"),
		},
		expected: decodeHexString(c, "ecb870f15f54798df68c6d05dab67d58b450714476df7cc3c8ab8951b6a2e3fe35ad68776099590b7b044e3a07f048d5c954cb341b25373b35abb0811f9d62c296207a9e83265b75029410c68a43e5d8c95681d5efc6b0a83336490ec3732160d42304b553abc20a860c5c4ba53ebc48c8b8d279543258392e401c0ebfe90c4e8af45db6b59de3cff448a718be9ed0e18c2d1ec87f6c43c02ecc5cd66b50620863f3b05059571e2abec9f3de02dd0ea44b0cd7eae5dcc13fd1b4c361b3d580ff"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_12(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9eacb323374fb7fc53f544f055d6ccda36d558510d26c0e534c3210d720b6e18"),
		nonce:           decodeHexString(c, "005d9fe8b8b6d24c7f044e94b17cbe0a"),
		personalization: decodeHexString(c, "9607f55daca672230e4eadf1faf9ae3909cc0d7ebf1f3ade0ee23a543a0b373d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b181ec672657e92c751d758a3bacb384066c7724392b52aa72785a2d8b106693"),
			decodeHexString(c, "b14813333c1b08f7cb0c20f35f6b3a7972c44253ab13232029ed909d2499798a"),
		},
		expected: decodeHexString(c, "fb22d70f1230dc59c28e253723e37736eb8391f30cdaffd6b9cfc468aefb29132073ed59c64435c78a9448618991b7d0ea6278fb884df827abc33c8274f90bcb10112a5b530e019a2d253b4681d7a1ced1b63f20f016d2d66bfeafe2dd54b761c7518ace8774f1561c12a2f75cc4d2f2bebfedc3ebe9ca11d1d7eb8c0caeadad29d1bf89728bb5892a8b23c3ea191ce49340afcd34b31fb1b761e00b08ef8f8539776f3a76e6b68bdb01168f881b63bb235bd6f19aa9c0bb16c573987e87c885"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_13(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f78b3eaf8d24419d05877476e5d52a980020aa7b326d7a432d04565a26aa9e31"),
		nonce:           decodeHexString(c, "672edbcbdfa8966c975ab8fa058a6df0"),
		personalization: decodeHexString(c, "83e33d7b81f7b7fd5134c59a8662378e9042ac62c53ec8f8b13cff211f2bee6a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "61e80c2e4b5984b9453ef5df4cdada8a62ecb98a119b58ed1cd4fde05cd36055"),
			decodeHexString(c, "8e7b596f642cf2d7b2eb7500be3735b3383a275437872f7efb0ef8a30cfc2caf"),
		},
		expected: decodeHexString(c, "013f8b67173ed28713614eb5ff2ea5fd8e3e26af0c0fe62ef6fbc3a2544a881b6361c39f54fb758563c3b12309a55938811aa8dde8402ad344ff011c38f747750a172cb5504e8cf348df31cedc918510ded429a410da929653980243f825b2c325b8642261cd9c932dc3b87a13dd8f747b812bbb2f39675d6a0373e69bea510ebc3bf01b5ec948c2c86a6fb5eaab9bb48819b108360d66951ebd0f70b6b07df971f29223eb708478ef49af854e7e6efdc683a605c59eadfd18a7a7ae82739e65"),
	})
}

func (s *drbgSuite) TestHMACGenerate63_SHA384_14(c *C) {
	s.testHMACGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "23b249425f65cd337f1037064fdb3d01b8749f3cec8f900a8a38f4f43391f3a4"),
		nonce:           decodeHexString(c, "63b6cd22486d4af49be336afc6b4b884"),
		personalization: decodeHexString(c, "95603884a75e3884acde7152fcaf69fb9a44303451826422fd95c894928db74f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "73cd5580972f69bb4b0d0cd8915a5b594c3a9fa40b82d6b37446dff4c014e715"),
			decodeHexString(c, "304c2001d8bfb9f1b23f3b336db9f5da17752cbaba782d8932d2641aab4c34b8"),
		},
		expected: decodeHexString(c, "5771705c788e15fd5f656d4b5555d532ee4c48453be651a69c30fa706abe7719d9842028c667fab59aab97fe64a6140baa5d42dbfb7ecd58f2ce557a7b8b2c01669232e0b8bb0ddc6ef8dbe627ec5b370ec74553640982a14bd38ad9824b9651b717f8e90f539c42d04f7cff648c38b26abf38dd2a777348a4c2872f6551ef0f9e148bec810025779e7cbe1055cb0250a764fca5a1feba53bba64b7ea0c4dd3d56a7e6b4f8a157264e6666d356fe5a7a29fde7f4391662c4e69f471c21c6beeb"),
	})
}

func (s *drbgSuite) testHMACGenerate65_SHA512(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_0(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a3da06bc88e2f2ea5181292c194a10b3db38a11d02ac2f9c65951d0c71f63e36"),
		nonce:           decodeHexString(c, "c74e5e3d7ba0193bcd6839e9ae93d70d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dbb7270760d8d262557807ce746ff314fd06598143611ab69bfc7e10ca5784b3"),
			decodeHexString(c, "8cdea882f894e5fdc5f0a0b16b7d9ac8cde35ed17bcaf2665564d4ee74059e29"),
		},
		expected: decodeHexString(c, "cb706b90e88380e5c1864458454027821b571dfeba0da83f712efb107b8752099514ef87b4488fbfa3508a00954bb03090766d2bbd399e71c86c7967a4e8ded57095a29d4cfa01f8d28c97e81a4cd4fc5be7fb32a0d6c230cb8760e656b74fa7e18e2063ebee5787958b272fc5de93f0d6837e55f0c360dc593c88fff30a428cae37ded52f825646e04133a19790c304e4b1f040e10439c5edf454e6f71b23eeb43cdbe7b0634b8e283a97806073f7f28a43de2d0d969b3eda380c185b785b9101dc905025c9cdb499e594de0f0d3eb41922c20994fe2c403dd5bf01e4b2c3ee6654d6ab9cca7d4d5ae59525a796119547eae6a3cbf8ad0e9b1de3c4d5a804e4"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_1(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "462cb274b7def1ac0f9db135c8fa2e48599cfe2badf2ae9f6d06886b25dfb0cc"),
		nonce:           decodeHexString(c, "250461f0dadd9e23cc6c08ddf4ae12b9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b087ff5e230284aef4c90b5f9c48fec91b486f3d936d422475a2b12ff47a05b0"),
			decodeHexString(c, "150a4ca383c3863d9ae3212de9ab9da7442fcd5367af157714d74c149f69eb9d"),
		},
		expected: decodeHexString(c, "12d4740dd0c5356fa76cc441f9088e361d3e636dc7b1ee27a26e28218eff470e28f51b76540939d624cacf2e3facf0967e7396a42017f68789e53f4b1d216fbae675801b8869b06d173d42126bf88fbbfef60aea6c4ba15538b2d64f8f22f389ee35e01e4ea88fd7c9e4d10c145a5f6e4dd33a55f2cafbd5f56856ea945b3b596b4900cf78936732bda49a52bc5a648c6561f48b820699533d48ff04eccd81aaa5bd25fa277ef314026effe2e65a9c38d45832cbb89579535782bf6299327339591a3e66d82aef6fcfa0a21b6b50a398b737a83a6a9b34dd46f3d15162dfa488fcadd18dd06f856f6d6c4cac2677eca641bd4e044ef4cddf6c95f1725fd8c606"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_2(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "727337765db704e7b9d23dd139e63b5ac97adea990b7d04881b6b2de045c974a"),
		nonce:           decodeHexString(c, "0265210aa4e336ac32f4b0a428ff272a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "48b452cbaeb990b6ca4ba64ae8f2a91d792ab83ad499093d9c4566ed8c7cee9b"),
			decodeHexString(c, "e7e32096873180e03c9f7bb33c5af4edc3fb9a36113275839302d40f0890dbad"),
		},
		expected: decodeHexString(c, "21c7d4c258778dce67f1a134670b8595dbbb0e036ae78484d7953f280f1faa5fb3bd213a54132a089a9d6f1376ca8b7064402409187acbd5de7e4d7146c1f02f73087a6c62ca6a7e736900a9e4464af0351bcb71b2e1f1cc07440cd74f50a61757f0b3bbb91fde9c898e62a9cec3dcaca0c94d5d0a8edac0f82b3c99b65d736884ffdd23fff1d9d6e8199254e784514fe3c34db51a86eeb06ef7dffcfba9f195c52cc4b2db53e0a6b1bdbed68d85822c6c03571482fdb6535eee1b6e26ce7d33433d3a1271c5b93ce9a31c9d7c805e3635e79682fa5f8e7894d8d16ead32e3fe8c625174a12a7b8623c0000a75c506cd367bdbc4e3da3b462938875050ff2271"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_3(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8ce3f77c4ba4f40d4eb3e80d03f9b138bea725d44f7a47f4a1f7ee3afb45c2a0"),
		nonce:           decodeHexString(c, "e8fa75683ba03964a8e3312ccc6e1b66"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "83260430843b586cfa50ab51120ea5675d63402074d45b0bf80dfbbec74fdc63"),
			decodeHexString(c, "0640b6427bdd6ead525962b228392b3c28abe131719feb0c0f738288ee87acbb"),
		},
		expected: decodeHexString(c, "d0a402dac648f7a53b5ffbebb1f5e6a12998c999809007f357dc568d7c653bd3b4da793d6d7ef802338eb36c7e4745655001f700c4ca68cda07d726dd088ed9948b2d49d8b50a72530dc9daa3387cd69ce32ca49dfa6cfca98f8a8b641c929f84c5f4045579dbfd3fdcd997068bb0f905f9a4a00accf06a483282e2eb99b94d78be46e07dc87903208bac0fa75323920997d9c4f9c0fa4cca5e6b1d69fdbfae8dbb52d659028387472c1a54283d074954094ae11bd3aa97360073ee033d7008e63b89e0efa4788eefa96ab726af4c2422b7472fa1efb7d95bec93fccb7351768625de30d9f5377610026b6f7f9568a9659644c7e68483672ca9ac8d0994efd68"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_4(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "96b0d3b13a65ae1010bf40e6e2dc6e6585db8fdb8fbd2b272611e51c62e1111a"),
		nonce:           decodeHexString(c, "e93babde207a42980c9ac9018ab01153"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b67c2ecbc4d4c46c3573883b61311a2655cdff0e01a12a20ea0cfa4e91034c2b"),
			decodeHexString(c, "9ca69103d5af577da056d4d5e95f53be87aae4689918bdf0d011789f2ccba9b5"),
		},
		expected: decodeHexString(c, "63f05a9815c2671298e9caa06b0746767fdcc00884eb1b30e53b16593508bb75dcaff9932230913f9b62cd0361af168993ce7b6b967114e2612c8f9c376104633ad4eae2e968e455b96d1d5ed6928eee9acb21bb8fdee7bf525f143dcc624a66ad42f1bdbafc19b165284f2c771edc57dc9092ffae6ef8acb9f8fdba496607c54b07f3ff4d1721f45db43f8ed5c695716b405b57034cf4f87ab487a01057ed449bd918093c532fe85015f0c5856cbd7a440c33c7968dd25330f78b66248873959967e307f9c9697803e8b0939fae51870ec533ef7d17e227dcb68ccf270299e65ed8483b9077831e010e9dda3a50ef7b008a0762c8ac5ef42b7e2ecba450d7d6"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_5(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "49913e04b653d82abc54cbddcdf898c409819dbdda4af93bc97b434dd1e31970"),
		nonce:           decodeHexString(c, "6504b1c76f34ca6d9dfb181c7057ed8c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "68b8f6f749ad588ff2c7477fd7c55be648134d57be6846674f2659d75785c39f"),
			decodeHexString(c, "cd7b2d7b24070e501843f0caa20666fbf963760893f4e277d944991ec965fbe3"),
		},
		expected: decodeHexString(c, "67ba01fe694d8f9621d47be0dd9119b8654d028e4c095347629afd02e96fbe6e4535d1666ee0331a6da79e703571ea0983a0d02051bd95dd130c7733012424b79a0bdfbcf72c9cb0c6d6ee408e2f0de45cb084d8182d1b8b4d389b78d0e3fbb7f3c8891ef522f077851b2463bdf1399d178dae3299a43b00f48cd1068e17f42615bd506878eef5fcd5951c24641b58f7a563240abbab5779db1e44bc2c66dd48ea7e746660042bf92b727d622bafebc05de309c24824ddd1d9ae86034a8694ae5962f61ab6e76b435c9dc8b370d708adc4d6fbbfc44644da3f4d4f24d3c95d958de143531c84b188445b6840775726c87b1b058dd8c14e4648973d5a91a152ba"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_6(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4687135763568418f6f30af400d37d794f712b10a42087fd832d840b9e8b1f81"),
		nonce:           decodeHexString(c, "8dadd1aba09e78a1925ecd9ee0d106f2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ac00dc729c5526698fb80f685ffe93e9c25bf93b22424c15c20043e1fcafbc7d"),
			decodeHexString(c, "948555d8a6e0473a769b7019e6909a8565e386a624a47a1f9c96ff5e6609a894"),
		},
		expected: decodeHexString(c, "4f09384ba8a34f819a0d4473c3387f74299753fd16e386be51a5ee70d1b164be6fa53a3face06379da2d961bfd6ba21eb437bc77b527960352790bbc978217549006e7409b86ee97d6a042957d27a02fa5f04de94791bcd7d02cc6798bc66d3b6cd887f2a984224b3c279382558ff64459703d93b40fcdbaa7abe1bcdf0b95f4c6ec6583a86a41f837c6cbdefee3de4767e330cb2f4a0d8915f192f02c1ebfc78345f80d5e0f21185c647376d588991486ca9a8fe5c68d0b71a5f81b08bb112c56f69c89412f0282eb1bed0d05c959608d1eb6b1eb4a76a76ae927cfd8d651a651fe83668f24bc0d19e5de86813b16bfe8c771dc9f16a7d6d0441b3278de136c"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_7(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4ccc3c6cd73101efb7833ce1195b28b3aa3e5628db02be166f2a7f6bf7e8efda"),
		nonce:           decodeHexString(c, "d5ff3f1c375ef981336af28252756647"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8396edacbe629826be44543bece17ede600f7f877d1138af5e83c3ec44b8b0de"),
			decodeHexString(c, "98545ad6268e604fedeacaa10b727ced0b0e284a00c29081a41c0d2e3675bacf"),
		},
		expected: decodeHexString(c, "c37ef92675ad963cf41ee5c14d882698082e8dda5a0ce9d50b8409c9f0d30d3294c7c625ef29c33f395de140405a6f9cd9d737a29d892b67e90427af24e200bc9cc7b5d920aa8a93d8ddd0b6f69cc98e303ca3a512b3d883ec542403d58bab1b4232c31696e72a764f2dc7b278bba02efdbd5413a08563833ef7a283aa6e5ab221d1ce5c7dd14363ecbeee879d157b6aefc8bfd2acc004d19eda7cb4b382e54bb725705b3f52ca5be08df445d8f6eb46353ef26217bd3c1b508f049e810fabacc0a75d717b2bea9f63cd8d2fdffc27322eafc98e7de18a911ff44cd0e5864e0897f0550e3c48674d11dbecc9d6d4c42f7592fba440608ad479ed296a6ea6b1b0"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_8(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "85ef33038e0bee3e40ce8eefd3648e89c521ad537b0c8003617824b08a154b75"),
		nonce:           decodeHexString(c, "c89f036845a6f24fb9a15513ed28eda2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c675110a2bbcee5c6096cfd8f363441e3473664cf09577a95996928519a9292"),
			decodeHexString(c, "f1db097abed76cdbb1fe6aaba94bb51c2af8f43c5cdd2eafdf6b40a234d3897d"),
		},
		expected: decodeHexString(c, "beda7162fb3e07d96a5796f091388995894f69a59f06a0c7c8eb704b5dfcb82f7171d34628b116e1ceb0b180e6052d01fcb13510edd4050e15d6a8bb27a5bbac46d8847972f2638967d53d5b7752452bbf0bebb953a4e40212ab587b8e74a9599021c93071ac55a08feab70ee040c3cf32246857167f13473d20a38c8d6d364da4d1f043e24a65b2dc58ae2a56215a34081fe91bd554edf86a7d582b227316662dac6a71693806545760060fc1a204df40f1b5df92c7b0561507ecd95609fa5317bc43b1e9a40880a230fb4deb79cf4a7a2b97beeb9cd4c8c841d4ef2668d870eaa11f2fbfa0fb899a424f1600bd46778136dedd147f124dde4d64693233462b"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_9(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "77a48fcd8cbea1be145a65c9e20cbc4e660dd439c7ec7e2dabc6f0430c5ba716"),
		nonce:           decodeHexString(c, "182f05e834e84e89565714fe8ccf0de6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1b838d460961b8f1623667fb316772cf50aa462ceeb58c36e2a6482ce7aa9f9f"),
			decodeHexString(c, "ccd4048bae7f8166c35e932cf3a09feb2f97dbb31af61a3fe5e4edb881ba6930"),
		},
		expected: decodeHexString(c, "af5afbb8d60d77c36c20a8f4c20b68ccd7fddb703d1ae83b5981605c4483e4f092329bd75aaeeb6fb4e6552540bd772edba5e5a96dd227acef73241257fe8774f757c673dc3370423de5a85b9118b5aa98682db6a89f520174a25e8e4b71f83ef432a91ddd8f69c1431c40d282d7e789427f18d9c5673131d5d3797d1335ffda64319d642f5ea5c1641092893a4008f076b649170916a03e06f0854848607c6c44a9f27bd3b17b293a914a86139e9a1b11c8652eae3757162f9f7161a2ee6f412a40002781e8fc8b80242331528225e70b9b23c6b2c970db12eab61bc290fec9b4c6c13d6454d7336f439d9b4b1df59248ab84e3a79d7f37df07e88c20f9ed92"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_10(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "71cea1ba7a7dc792ca33288ccfb67570d9b1eab34e35296209db20c6676f174d"),
		nonce:           decodeHexString(c, "f4e062d1f660522881aeb11a651581f3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c9667d28614fa05f112ec31487cdb3d925f2cb312202f7d85695a8f7336573b9"),
			decodeHexString(c, "6363dc485ddb9bdd61db33fb1beae9bfe2d0e7788a86b50774f8658bac094214"),
		},
		expected: decodeHexString(c, "e62486e1dc854f90b803635c1718f075cecf7fd44d1d304d0127979b83bee5e4abdae9076fc5ef89f6435e4b72cee056372c603f16beed39a2adf6ddc2577b32b29396db81e9ce57fb67c2525c2a59dea259ace4a7b6560ee20ca8e3f476786c34466ff5f6b45ccc916477f6fe96e7e4be23867a9ff9fa07609d9d8a5db7f5e1a068ba9b9c82bf72e76d17f73518affd5c58368232bcafe65096962c561617f489c8d978cb28676d8932a3c3489eb0f2f48a193826ee785dc850e41b0ced359ecd2636d96e83fdf8996617e6a39e141c124ad1e2e5fdad27144e60b56ed70d91543f3046acc831a6d56926ab1635de7e04a149958c9365a53c144903d7ea392c"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_11(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3a23653a34334db7d3abbf747d9d47d6b18589ab3516b0600bc93517d206a1a9"),
		nonce:           decodeHexString(c, "c74a51766beec0563db655273d5dbcf9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "89922f45e6637e7fcae0a98d7ccdcf36650bbf7fe3253b7716014047a0983e98"),
			decodeHexString(c, "5d7519b3f442e1246185e1e7a56fd37473f18824f3c9d21656f54f1fa8d2947f"),
		},
		expected: decodeHexString(c, "fa40b69397e13d5f1ceaf294fb1d3a15db8b345286e5359bbffe5cd743ebab412845a9f5e4ed8481cea178d7b647019a7729c264220991c3ae276f82d6c33402f061aabd2e28cfed64565cc2d7f1774e26281d0808b2857d1c144d5aa36944a38358181b28b9110470601204076c02ed44ef411cd6a75fecf55225eeb3ef4f1717d3f5cdaec83f5defe835d2a236eb1a8f00167a727329163eed34b3b34bade7896e2d0de1db1b15c7c2b173ee8d4f0bf77f8e8a973be61e107daf240b9b7edbc599469b5f40e98c0d2d40b048ce4462cdead7e8f85d175a1f39f8bac61ec00f4cb4c8081201ca6319984264adca745b1d0feb471b5d8fa35bded03357fcd7e0"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_12(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "24cd11e75f2b0ab60c5b7a35020d716cea2e4f5b7748327c0cf355b118051893"),
		nonce:           decodeHexString(c, "34889dc3198f13c36cf7beb42b2a1a6f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf9571fecac5d79d65617a885815703de3459cf739db097f8ff2ee557d0b0745"),
			decodeHexString(c, "2282cbdba64ac2a4053c070efd1dd0638fc31dff97dfa15f76bc077bf173a821"),
		},
		expected: decodeHexString(c, "1b0466ae577c0b9e943616437c24b9d32ceeaec15bc83841843585c6255534a4a71ac96698f628d907255894f6199f6d7bf405afb0e46359ae0dec788ca52111950f8adf88d324f5b9a76d79e67c3581b0cf0318901332883794398e6aea0f7da1f55f30ca34b11127e885e86d787f8f8b3a1342d71f3738c8445707e0dea687baf759b261eceb4d661ec9bb006e9f08aeb1cc0357cd8df526943d71a6d73c9ae80ca69fcc3004b91dfdb2b6b8d0424c1cad81677d510ac7a51c1ce6f02b9ab41466e37ae0c2adfc63b31fc2e4693e467d3384fe359e9f0fd0f4d08f4a9037f3fd5495d895b6ed4121cca037c6aa87a5ccc5b856ee6151a900459ff0ea77550e"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_13(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4931d76a7ceb2238c1f0ed76be24d2fe1a925d1084a392fc8c43d93535da0e93"),
		nonce:           decodeHexString(c, "51e52abb58a9bc34c46f254b8313d387"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "92a8eb05034555680bc937d0d958e820b09785009e5e05739f29d9af17a63976"),
			decodeHexString(c, "d37465a30f837fe05f04f6b7ad4bb1c83bbae83f9c78f027b4831f5e2ad2dd78"),
		},
		expected: decodeHexString(c, "a61894d3c30081c7836dee8506cb97bf7bb4e56a8a94c72d9c8b6900b69ea68b30c41ad33dd21554361c171cb959c555bb668436293e3f1c103bb72509e43f2baa19742ed8c2d3eb9d0790c845097a7f0b2715b3d127a7f043c4b265b4d6fb4b9af9edd12427e1b5c8b680a135a315761aa4a9ed598a7620f335fd595c40c933696cf95b7eca55e8520e9154f69e3446ea4fc3b69f36fa1ae7eb456b350c93a1ebde342bd4578142d8338268af1c240c94457888d045d73196347318f89e281865b826837ca79da5a6dbc81569c42da475d97ab5501a1b13e99058c40840958331bb73c78e5ec90aa0464b9f603f11bc4baddc28b71c42282176654458d2fcaf"),
	})
}

func (s *drbgSuite) TestHMACGenerate65_SHA512_14(c *C) {
	s.testHMACGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ffa596ed725daea92273519c279d0a26be7f77cee1fc4fca44dc99b97ad8125a"),
		nonce:           decodeHexString(c, "3172e5a36ebc671df1fcaaa54bd7218a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6cfccdd8253cc5b284701ef8d16f8888f79100373a7df50f43a122591bbddafc"),
			decodeHexString(c, "5795ae5be47a7f793423820352505e3890bac3805c102020e48226deab70140a"),
		},
		expected: decodeHexString(c, "4a398c114f2e0ac330893d103b585cadcf9cd3b2ac7e46cde15b2f32cc4b9a7c7172b1a73f86d6d12d02973e561fa7f615e30195f7715022df75157f41dc7f9a50029350e308e3345c9ab2029bdc0f1b72c195db098c26c1ab1864224504c72f48a64d722e41b00707c7f2f6cdfe8634d06abe838c85b419c02bf419b88cde35324b1bfdaddff8b7e95f6af0e55b5ff3f5475feb354f2a7a490597b36080322265b213541682572616f3d3276c713a978259d607c6d69eec26d524ba38163a329103e39e3b0a8ec989eca74f287d6d39c7ceda4df8558faeb9d25149963430f33b108dc136a4f9bfa416b3ceaa6632cd5505fe14fb0d78cf15f2acfa03b9c307"),
	})
}

func (s *drbgSuite) testHMACGenerate67_SHA512(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_0(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e97a4631d0a08d549cde8af9a1aae058e3e9585575a726c76a27bc62bed18a4b"),
		nonce:           decodeHexString(c, "227221d5fe5a5db9810f9afe56a3ee78"),
		personalization: decodeHexString(c, "94084b11d55e0f9c2ef577741753af66ad7a25b28524b50ea970105c3545e97d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "24c81d4773938371b906cf4801957ac22f87432b9c8a84bc5ac04ad5b1cc3f57"),
			decodeHexString(c, "c8c878451e2b76577c36393ca253888c1038885bbfdacd8539615a611e2ac00b"),
		},
		expected: decodeHexString(c, "761422dea283262998c0ffffefc77de2d395c818b9cf1ac2bcd1153235e0d8b63199c51e195135a75f1f87b454484ecc560c532c7ba5923c9490a423c177453459d81efc38ce2939226043cb733062eae303a009b48ee0cf3c7e40abe2b57a70a6062c669a9fbff20b4c94b4ecbc5f744a80d7be8134359581d441da921737b1329470b214f3e679fb7ad48baf046bac59a36b5770806cdef28cc4a8fd0e049b924c3c9216e00ba63c2ff771d66b7520dd33a85382a84b622717e594e447c919926a5b2e94d490ee626da9df587fed674067917963fd51d383e55730c17a124555e2e46e1395c9920d07dae4d67ffee5c759b6a326eec6d7b3ba6dee012e4807"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_1(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5c96609e9de807efed31d3c2d63e284be5c44c1b5ab84672664de8d8d8e2f818"),
		nonce:           decodeHexString(c, "1b95a5290fdafeb05dc902a9a7bd639b"),
		personalization: decodeHexString(c, "135aafb3bbc89ef1e00a2a35ef32f122b7511cc55d86e7822a34859b630b4d29"),
		additionalInput: [2][]byte{
			decodeHexString(c, "115774904a953af07936e3efdcf6054b4c534dc8654f563bb10610444d30625f"),
			decodeHexString(c, "4705ec7525e63919f7483fe76cdf7397b19f22d2a9d54b6cf0ff9abcf0a7c46d"),
		},
		expected: decodeHexString(c, "ae2cfbb29fde23e8c22d77d7a50ba66798da93be4e49ef78b38c9be2411e2d8a9954eb29fbad0a967c51b26d8d746801539aceb32e2459d07baa994869d3b6db2c88fb9d7250fac00de8f79990d501ad985590031f7c45a00cd9b6d1b5531b238f3a31d33237c40a3da31356171cafd52cbb7929e32b38fe523d8212de801f554348a3cc468daca70e05affc9af97f172aba00b2acc50d7dcb5f0ecbce741c71a65c657e9d0f250c44f73865962b1a0d19738e9ffe9f17c3e03363bedf5312c444375529fa8df9dd72b7c09f20c2ef37abb93e6fa57cadbcd7b23036bb9924fcfb9bf83b09ea360fd3988639151b1ab22939e9ea1cdc413f7a2cf04cf2778345"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_2(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4cbbd0538535994cf00354ff8609ddfd04e80dc4174b9542cdab52385dd968dd"),
		nonce:           decodeHexString(c, "bef8157a6e3f26f040229a450f8e564f"),
		personalization: decodeHexString(c, "ed81729d1aef522f7bf9c127207d8a680ce4432964ed4025b5bbb12964374f3e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1259073b57358935b7149fa4349793c5ff28d3ce98b483ec48986aa285451abc"),
			decodeHexString(c, "b350a4e931bb5db50a866aa3c01ead7d48d5859bb97b675e77ebb844ac832eb9"),
		},
		expected: decodeHexString(c, "215cca589f737df48d60360c4806ed548d44938c2bf5b1707310df987edda51e5092a7d9ca4955303ac59bfa980ba6e1819ed1141978c3d7df1125f5c4abec5b15bb8f5fd0edb1f26bcebea5aa7c8d5d32e8a5b608f609d9dfd765074b23cc524596a91226b726d899e42bdee0321eeb2dbaf63d33cced6890c19b466636df05072f007ae60a2364dde7f82315e3e30e63258b8abd12f18b6ab3d384cc9349e56dff00c3f53a86a301aa7205394199d32382096f6cd9db9646a92e73c3fd1e53c28a91683031c1ac72bb85af50be669d0e1d7b05a3bf1fc9720025c1e39e1f09d18d2e9247f726ac691a1c2321a667e6bacd7d77a57ce46397db1a91e7908ad5"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_3(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9b2bb0f34e6f0a31eff00e6604e6ca77643f69895877f77197a06e2b42bf047b"),
		nonce:           decodeHexString(c, "3c1ee55a2a28fb3579324a54458310b2"),
		personalization: decodeHexString(c, "895e7060956784e5ea113ca785214bcf608e2a53c175e6edf5b78f1ad90e67c6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c0b1980d57fb797c4907aad1fb5662bcc8d6ee30f6bed951e77c11d1893346e9"),
			decodeHexString(c, "af3357fd21fc04d1d1bd162b94bf129c45d41fee90366a180d98d41325336b5c"),
		},
		expected: decodeHexString(c, "50941cc105c694dd26d5bc73c08399168a270428ef594a6968fde834e889cfbbf0a80d7dad65d2fca21ba8019f1011313fe86983a555fb3ccb643bb771724e04114f3266d72c2e1a75363aebda9871c3bafcee3f389ff4c6f1f1bb5e6da5389e04f2822da800cb058da9cd698c65d54b16e7562c83506b632e4b5c7a78d6e36ec307e48cfec4fbc3ca3dd67ca95f9bd7f1d609e0a6d8b5bd3feef00e0c4165e77da84f989210c78daf633aef657855fca26b832994000f980c21d355db10f71f9cbb8079c48aeb673c5ba097a325d9a89e05bbf960fed4f8eb097cf37f61900db8171685107d53f85bbd8c1a4a1c7045c8b6e3a8a2c4114542292555585a090d"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_4(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9c8306c6941098408c56518a44d3075c22e02f19a6041d2e9c4e296fda435db9"),
		nonce:           decodeHexString(c, "17c99d538ab65f6f1bfab0d479a1833a"),
		personalization: decodeHexString(c, "3a80e9f5b71b242ae07ce7b617057dabae189c5468da2cf049b5b529abc877d5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3c151e92dd3121a8d2d11604632df00cf90706d3e843737445de0f2fde1ea924"),
			decodeHexString(c, "f53cb5fe673201f5eaf4115382d48ba45be405b37a31a56e41d1d76202038b06"),
		},
		expected: decodeHexString(c, "9bf31156e54d7142490e620afec2217931fb2389215a3609b384b0551bb3c9d90c3b3053054046a324db9b34633e41b66114bfa7ee86bbd22d08d53e349a4dc875265b32151d3e475df348a22d5226478184f372b0ba3be92ec1b284fc66dfa3609463214b6b468b29478acb0c55e1d4674882cb75e3eaa3a66ea0f4d7b1a571206a761d636bd3519afb6f05a0f1b6bb38c00bd68530a6c9b445b6b4a9c7457a055627b606f4508ed676fb5ba0d27589b7f464271c3e561215905c50ec48f5ddd1b8549e8d163453083db96c7ec8eeedaf6804369e76760b08abcca937c497900be385db8804b443e8a1489b8f3e3e4cf367dac3e15cb8e95cdabad04f08856c"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_5(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "87a8fce521df0a2e26f1b1f9c7ec9e98968474915a085a95cbdca7d8c669e08a"),
		nonce:           decodeHexString(c, "69b8c3c3df07f9ada368be448938bf92"),
		personalization: decodeHexString(c, "b1bfaead04743bdcfdb193d32260918ff803abbcc0d5ddc50439bd01f6e42a3c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "12a07384e9c74fb3f33df1a089dddb7d416151a0270d0c0216e085f1ec4c249b"),
			decodeHexString(c, "9b42567093112cb5889703b77b4b372276b5bbccadf86eeb9ef6d3cd395b2acd"),
		},
		expected: decodeHexString(c, "5ba662260aa0f743a33a9b552ce41d93335a855a55df11b870efacb7f75e39c978e730acce3664c814ac10fa10989fb00a39b584bb14cad2c02c309703c8ea8768d479d9b4e17402ee38cb82c5f4d80125f3e674ac1adb919cc8a988f79f531b08253fbad0a1b27fb1997a4e2c7bd5ff3abf66281e8b60987587327a9101b76cd13771e23ee2f02dc339589b9aac4f5af740afdaf494021c3504fdda8f93f77cdd8262df7d4c48f85b6eb03a7e5279db4d18f645a63eb6f53f9fb123c53a78686f0113a209b6eeef3b10cd4489875a07af863c467f25b69cd13b8e72847465fba025e25fe7bcb41745369f255df0eeffc3e5f066815ef7715680b104e20a7e9e"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_6(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "69d667bde79e41cb78742426ca5ebd48086cf1ded5cad7293fcf910e5ab23cc8"),
		nonce:           decodeHexString(c, "cad75bd989c3ffd05817d1aaa5493c05"),
		personalization: decodeHexString(c, "5f72346eb50ea82cb111d5b3c91dc9b7c61c92fa1a062177d513fb616b1226d5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0465b8aa89d9cbbe8e1cfa2e64e64b8d1f5dbec7f710a6d37fce898e3f81e57b"),
			decodeHexString(c, "173135f31c2320cccf513e88a21f2d207e00cbe4330d2f550e0be77405eef47a"),
		},
		expected: decodeHexString(c, "34a08d7a564515a918bce93cae084f27a558f6f214c4bc9169dbf507c3f11d02ec97bdfd777960f6b4c4543c1e14456d0079215320ab607e04b7519090ebaf3a5fbb0d7a3fda1af6cd8c5d785524bdba75abbe50e3d58e5f05f8f6b2c2570f1178acd2f4c11a7b1b8b4ebe4ddb71a85bf19bb2fb25241374530cbc6c0605066e1129a2d398356cf2ec2f7a286c5b869c702aced63f4e12f39b7ce250547a922872c36268a3a4649f6641987bb7c6baf1a3e82cdf04d11160ba11c5a002cfbcf4a8698286ff318ec01fc2c5f6664e50561991a533ad183a21e7b97e0052b0350d213738b0c6e5421a524845a861f539930540cc40c6ed78c46be9c122e7974d35"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_7(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f1f6e5a55fb2180de436d48115aa1aa38a6242eeb0959de3690f259c1d8395a5"),
		nonce:           decodeHexString(c, "862d1ac4843404d25215c83bca90f44e"),
		personalization: decodeHexString(c, "f467ef083c745a1bfc9be44f1d468b2518e3ff1c0cee6819fdde354d4071b17e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fdda9f0888c4439cded15a768300d163c1e326ee5571c22ab95ab3e44b1676d2"),
			decodeHexString(c, "6b8d60c565604c8fa8d7adaf0b07ed268a491fb79794d2770356e191daa1cb50"),
		},
		expected: decodeHexString(c, "55d0788614b770f4b8c3d3ac0bbf628f294ba2fd16612b65d0f469ded665e3c8b82c95db80cc6b410b5a6e624151fc50bf02f279ffabc19dd094cffb17ba44b11209b923df326db14eee35a8bf1eca3807afae918206e844e517eb32c207342008a0da742e734433867fd86fd89d27ec6e51a9db3ad1adea645fdc57179c4b71de8b455ae00efc09328a0bffd8c61e3880c007915997daeed4adba61b44040f6f9b6c6427e1c23357c8f7e18b5c974b3c34a2fd5cb5e70f48df2d10c1deabd987f8390bb33858d9a5133a7bd798b1c7741729b8562fecb3d4831e9ce101de192d64bb5d757cbb21090d669afc5566c1d6e25586678b5f2fc7d6c6113ac4eb54f"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_8(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0db9d437153149e101d5818b263b975735994dfc33d8b3f158a05760867757ab"),
		nonce:           decodeHexString(c, "438a5024e1d43006226018c378af55d3"),
		personalization: decodeHexString(c, "275bdc5fc78b0d8afb5c8aa5f7854c319a81bb8cc9300210a9990fb7933a352e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "809da54d1830545672f180fa3e0441a0d3fe472e7cd7a6d707fee5af7e9b21c2"),
			decodeHexString(c, "ebe66cee6efbf583c881a25e346ca7d99741dacfce0d8785c659e92774e26ff2"),
		},
		expected: decodeHexString(c, "878a3d109d814ff4a4935689ca96b3d444bfcee9edfcd9031255ad2538871027273bad5225864e84f3c2afaa22a40e7f6793abbc49c8b0ddc7b30d9dc7b408888e6b98f4bc79e08775b599661ea4b50669132c21272f8d17fec9d1e5310335b0e6480d7075c830a44ea528900f99de61191b5a006ca4340356dbf20c62e8ffd0577d623146b12937e84a6e17c0ae08efd339c9aa979c7e21e9c56e019f7e4f375bb601b1a83c21f27a554ec05191794befe514dfbff5a3c9a0a9c80bfe9b6adc7deffd31c70ba13fcf170abd6bf3d384381e0a31fa9c81b1bd207ea2e0b4153b6a1252a9f73f19f6f099fda0f87baba99b9711a00b5f50ad88d3bc1c4e806467"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_9(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4106f6ba6a291fa54e4ecfd9fa61b961554e4e8e03e19d9bfd82bd35c3471e8b"),
		nonce:           decodeHexString(c, "c5bdcd2f810079c1bbfe906929e88d27"),
		personalization: decodeHexString(c, "5a7e61b86ca70939e64af613a667695c7c915e667c79998e76e55eb33fef6d86"),
		additionalInput: [2][]byte{
			decodeHexString(c, "86c7d5883aee568aa74d25782019fbd6f5acf4196752ff3d1dd96ec1e7436424"),
			decodeHexString(c, "3a5d80e739f5a30e6bb507d82b60ff987d5bd9cbbff4b47daff278a3252db3ef"),
		},
		expected: decodeHexString(c, "fb146146f828e880c6ec7ab5a65fc8ec4e4d7d975c6d7c0a9bc7ce041f49799b11e235d7ac5a4ec4eea721c3323448e686ae96579233ad698a9d6fe3f5b37d87ccfce640192dcdb51c7bf35404c90b705bd97482d95d1c3e3a40152c86ab923588842ab02f4d922318a7fb84453b072c749a7f54e8ad005c29c48af6f01ecdd8fac13295e42b2077c70c7bf54e214317f98003e4cde07755e95c91f1953b29b3eecd49dc753e74aaf2b1c83feae87428be6a5aaa3261f0f65491e04c1fcdfd5481eadab68f057df3c83694c7451fded86a18470b06f1779c38efcac54b576e99eced3b5581eb5c9f7b3340ad5667d1f0d3fead8b9484a032d5f74d900fd64d10"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_10(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5d1fcdabb70dad1428c8be291720c92b8565f331ee3438d79bcddc968efedcdb"),
		nonce:           decodeHexString(c, "9319f5ee91124b93b965d504211fef04"),
		personalization: decodeHexString(c, "6c8c8a066c6208dbc18a40a30b9f689048877e038bf76d65acbdde7ae4c566f8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bfa2e9ebe0d70d3b62cdbd78c775a62e0e22fa75f168123a336b66b9a2b68c06"),
			decodeHexString(c, "e48b5245ea241baeb7f665a9daaad662d7b2422c3e3711cfbed81d73691864ee"),
		},
		expected: decodeHexString(c, "1586e0761c4a39013dcb552a0e363e709f4303c0e575653c9b240be7449ea26e4bb1dc93f06ec958b6c06217757fc550b356c135063c00fce9d856aec0edd20735b46b7c9a8e7df780db3072fc2b314fa5cda653ba3690132f10d30ee94c8458846be75659ef3868086bcf54ff55a8db1ea65c3e747a8ddab3f2304738e0c75adfc10c23ba651ccf0de64a39cab3beef667f466391a61a87a981afe883f09c4edbd3eae98d51cd3e7b31ee179f8a4e10feac96ea210a4b8415c9f2cfeb2bc8bf51f13801dc542ba1badda1c30141d72abb1bbb35c9bb481d91db5691c44bf3526a02d0bf776304a951858aa2fcf3f45bc656abcaeea94cbdc851a914b4b3a3ea"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_11(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9fc58d0785adbf033ce6642dcc9a861df44a35e89d06b346b165074a048b5009"),
		nonce:           decodeHexString(c, "94b4c0b3e27306b8c805c97b0ea14bb5"),
		personalization: decodeHexString(c, "e02f7a856266195fb5f4810232cd5c71a4465e1d95625c01e8e7eb69c63f6796"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7cd18b8d035b57bd01464280abe891b7faf55f9ed9910d9a148b030340c67cdb"),
			decodeHexString(c, "918c4d43fecf993227f7c120d239a30d3c315602800d6d58b9e9e0715964cfa3"),
		},
		expected: decodeHexString(c, "b8a3581eb4a208d1ab8f0e84e9ff3d2e0ba57703a7b5be2e4f3a3ede2e2519f5e6068c28c41171446cfbc40b48a97bc7a9a1e4d3b02f48fbf55b1d63da7cbc5b7a95f354afda273dbf5bf099961db4a4c5f296286dc0a51091a522398973d5527b2e55e0523c21fffdd0dd38527bc45959d5a711d541634e3139577312d678421eb37553c127beec64422316e48542a906cd7efe0d96eae3c4f2db7666083d9365a76cee4a207d712ddb04bf775be29ed9f030eade4537961737e3939a19e0769a3a8b96d055120c49925fe1ebc4a2ad54468421dd5465e8761b3e2e384373a971e408dd3a54907538a7d887986677eb192761959a4293523f81647a657aaeea"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_12(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d43927d1e633fc3433536cd03617a97a3a10a7ecad3f0c781602829f8ec7feb2"),
		nonce:           decodeHexString(c, "dd5922f2a2dee51db93bcf35100a8364"),
		personalization: decodeHexString(c, "3335a02aba1ea28d2e56973e21109e0adfb5068613c447e625fd83a8d0e34494"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bfde33c52407d3137123812c4818ca1e4b61878b8f9dbaec47935e3948a88d0d"),
			decodeHexString(c, "42597cf03bbee0e003d8677159918f5318402f7329f08e1d93c850e2a2a2f1bb"),
		},
		expected: decodeHexString(c, "e53c7d0b376a94809f472961acff314079014958935cd67acc476abdd919a43cd3f7d1462d0d6e628ef5d0c8e04a6d243838c61ea36b015e84d7ad59e49b45c9b04f6ec78687ba47156e429b2fb6dc2c0da4f5677d1f689cd28612cfa6d95628c26b5b3e01186153a1c25c02f5ce5fc287623358687d2034347b2433ffc1445a2d93cb0103ccdaf0c585f7f4e7d41aef310be127208b3da90523aceac5fa13ffe77eaa4d1fd058957c8dd2f355cae7f9e3d8f29ec7099599ba6c755689d53d6ccd84e33407a066506d97decd7e306d22ca6e0faa7b94f91f4eb004422ddf9dd6b1f49b6400ea55d40e25c67103ab50bcc92d100e89ba569b6d51aacddf02daf1"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_13(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0bd69ce9a0a66dffefba83ae563e8df0fc6c7d7bdf491bf52cbf3f3777025cdf"),
		nonce:           decodeHexString(c, "92b32217f550a1fe735b8519b44b040d"),
		personalization: decodeHexString(c, "820da3187bc879cd1f40476fd9677f3b67e02b35b6632ab68891e25f10555b69"),
		additionalInput: [2][]byte{
			decodeHexString(c, "903b882de013695b4683316ffbd7c7809288d54c72e369f70cf172bff85e5629"),
			decodeHexString(c, "cfb5f494e76486ceef12dfe1bafd6ccf9b0754d8d2306fb0c41c0f4e921317ef"),
		},
		expected: decodeHexString(c, "ebad5e5a358ceab806ae5590d80bc0ba5d4061f49f4cb79a8a9da4fd1e8cb8f41cd8edc657c5180d18e62da2b53a50085b7e18b957eaf4edc975ca9d43e380434f51542dcfa947c322c708f3d3593c520717230df17f9341f02a5596b2058a27ba23f72a862b391be884570b22e20c80dd20d0a935f068465d554c8291fcd88eff608e92200f90cccdc82cb5697f0406654d9582e8db54225aaa28697bf2c4f47eba086a575298b991098c212c9e8d95bfa48f7e500c7223d9cbffd1df6f725909ab6e9aa837ff9e69158af434d18e5a7f99d1aaf10931f380d88344ad841064130cae50edf8687615743735f80457a228475bab7559015c4f45f91bdfa31d87"),
	})
}

func (s *drbgSuite) TestHMACGenerate67_SHA512_14(c *C) {
	s.testHMACGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "45784684d6004731689e33e45b344d7b68dc4fa841133cb2dd65c4b326dffa90"),
		nonce:           decodeHexString(c, "1109dfac2e48bf17f2fea33b412dc653"),
		personalization: decodeHexString(c, "7c6f4675f7a0b8c424d5be9e809efa305493874d9a950cb343afdfb64e77ecb5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2b2dbe3834d8be93f1396b19be83bd96823dd82740da71c5eeb7b21865021884"),
			decodeHexString(c, "49c322fc1bec86d3e20628d9bdc1644e6f5e0237c7c694746bfee32a00145696"),
		},
		expected: decodeHexString(c, "9110cec7d07e6e32724bf043e73021b3ca0e4516b619d036ac9a00914e12f01ece71989f55c1caccd542c60a9cccffb91e203fd39dca2d92c8eb03ee7ee88abf21dc6891de326c3190f25ee9ab44ca72d178db0f846969465b25a07dcc83777e6b63a7f9f1a8246dd31ce50cd9eb70e6e383c9ad4dae19f7cec8bfe079b36d309c28b10161c28b8d66c357c7ee01f07403a596366725fd5bd3a5de3cb40dcf60aac10635615b866ae633fbdb7ece41695d533757d9d16c6d44fd170fae77c15b7426ed6ec8c9d6e9245cd5e19e8dc3c8c7e671007ce8454413bd07407e8a2248bee95a7669db6ee47377b4490a6251abb60cd4e2e404ab88aa4948e71ecec50c"),
	})
}

func (s *drbgSuite) testHMACGenerate69_SHA512(c *C, data *testData) {
	s.testHMACGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHMACGenerate69_SHA512_0(c *C) {
	s.testHMACGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3be441b063a22fa9357d7ca654dd26a6d955a9a51c8bea4d65cec0bcc105edf3"),
		nonce:           decodeHexString(c, "228a8e6924f558da846e42c3e1294566"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b50a072e1abdd8f890bf20064f5148ff22c5b2eb16e6f2881d5c51be2f8ffad6"),
			decodeHexString(c, "963a1fa213aa42f9f007205cb03b045a5d64e8e0f5e3a36844b6cf64df78cd65"),
		},
		expected: decodeHexString(c, "e0d38d3c2c4502c0b8a9f2b31d18d181879ddc8857d0ece5a780d8cc0b9950d4629a69623bff6df09513f88c8865d5a9ecda0787a90c1220865005f2335cbd386e76e14653e2c9db306e7a03aabfaa4f5ede248a4204690547c36f12e92d244836b28c0fb477a32effa9927441540532f6d0b61e450cb49b8874e857525491f0dedbbeeeb1abc1014abdd764bd8caf68ee748a08298cb62c89154fca983f484b5671bfbefb0f899ccc0fdca4024181a44f494d010d09f1f95725a06c8ea0bb0b2a4e0301c9f4acccfb031f33264a07eb0bb0fd20116bfdcd0fd79eb2b34cda757d0ac04c2ab7d4733231177f1d2f726a214a588fef154125e6e57a004fc54975"),
	})
}

func (s *drbgSuite) TestHMACGenerate69_SHA512_1(c *C) {
	s.testHMACGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2035d88e64d9466873131beaf6cbf3453b134184985725801273630f12d95366"),
		nonce:           decodeHexString(c, "861ac90b63ce73983f8a080ae0a65abc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "18aeec56ba07544e9ea60824d87d6a399ef112f6f6308c19465e559e4d9cf7f1"),
			decodeHexString(c, "e5809dcf5dd95bc13fe99f0fe94742c62ed6d8d91a690d5ceb8c9dda1fdf854e"),
		},
		expected: decodeHexString(c, "af01130e63bfd0e6b8a0cd5ea48b83dba4a1b0838bfe468c197b99f20a07761cd35c961d92c33f09914f1012054156f7cbc2334f89c67ba52e1cff9cdb4b55bc70e239cf8e5a93138a54202d71dd09684b37872d38cfaa03737157ddbf4ed49f8d828ae8785123849631f75d6ee336f0019c56f94c27b745c95731cff204c21f416ded920d483254cd4b5e6379b911e00bd48cebc97043d312039c0d45eaebf9ceeecbd5732d7e154feb91163cde82fd991d1bf96a639a85da1c08ad202bede11cae576e9aa02d5fdec20b3861198ff4aa9b5e180f5a8473de8a7108167b3319802fec12cd1d2ad2f3b5ad1a30f380c0e626f08776acc3f6cc4ac720e6b3497f"),
	})
}

func (s *drbgSuite) TestHMACGenerate69_SHA512_2(c *C) {
	s.testHMACGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2b5435f668155b6f33301f7014843925954ba18a3896c917c7595f8bfa54370c"),
		nonce:           decodeHexString(c, "6fa079fc6d57b301c0a43a97fcae6d2a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5f3a28f69b873d551eff06f5ad0c461a2708e760b45c23e83b12a9ead6a5fcef"),
			decodeHexString(c, "afdb3929500c23411cb7375fa422d5c951215ddbf456358265df0a66ad54c183"),
		},
		expected: decodeHexString(c, "ef3d42ac07b4e662bfded6b76b476a92a0b4535c4d02b241b3861439f8c3c27edc869414c323ebc78008e1f26e2021c8fb38dfc4f5601b2520df6c277657939e7d03e0b5862f327b48c072a64b99a41d703dfeae41fd833cc617861d1855c309d76e5834915b87efb0f86becee399f3f8c7a8dfc01a1d62284a54eece9413b6b6d4c392cbb44cc3f2596cc6555fc349b50ec0201f0cfe8a4f96cf3d5d1dea005e2c73f3e7eb85f148aea3395a634421025274a23d7de7cb73857517127ccaf310bd90bf3d64c028a2bf37eaab9832d248919114173344d789efd67bae89769e0c0cee047fe250e1ee6cff4892fbf690142149bf18e445beb431ad34798433e5b"),
	})
}

func (s *drbgSuite) TestHMACGenerate69_SHA512_3(c *C) {
	s.testHMACGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2a5a13ed0e320e894edef847fe8a83581e147701b7b98aaa2ee76b4d2a66399a"),
		nonce:           decodeHexString(c, "a93eb301506d1ae415ea92e1eb870cde"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "863ea314f0d52544140d82cc8bc615b223edebc7d130fd805e9a32ca7089e7c6"),
			decodeHexString(c, "f5d33b1506afe6f7701370ca34572930c21c465608b443db98594f7f0f44b8d0"),
		},
		expected: decodeHexString(c, "f16d6ed1993b88e5c9809cec08a3b67a8237eac65f5b10e8e80aa764684eaba31190bc222d4f5ba4c5e207b03d758389a98b6a74b74cfecac38218b685f5ccf449f718c527b10ac19591ec74f41096d8a65e5ed6588a8b54c6f942a8c3074d1efae44085b79ef96d9837f1e4ead7a8b02e95061419f948532921384320478d2b75d00da24605d73613b2c5ca2431039d2e6ac74f13ed043f6607ba0366adbb97009178c991d3e66a58cbe5ac5388c55a5de3b1a4fc5739261f6e9a50c4f764c29e08bc2ae0ac4333a97992b4295da0d06222ad86eab0890949453befc3abf103565af6739a1536828bca6332b8935c6688022658ef6c628bdeac85c3fe4f8d98"),
	})
}

func (s *drbgSuite) TestHMACGenerate69_SHA512_4(c *C) {
	s.testHMACGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d91b0846115fd4cffd0881fba7fad9dc43aaedac2c585ffcf928f4f95ae5ac95"),
		nonce:           decodeHexString(c, "0c21ffdb57b959c4561abfc4960f4383"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ee0d67f52101e279d4647bffab48e16135f0c045c2d8792833b262cf33c921a2"),
			decodeHexString(c, "7b2f1ae4964d4b8985cf4a19a0dc3d4d9bd83f0c988106ff677fa749bd6aca98"),
		},
		expected: decodeHexString(c, "258b3d74bb8099a26a1393588d079dea4df8038a0341027a396727078273c86e0c3a6b264e4ec09bcd5315d804d7d4bd4e6a9d1540e82aa3b237e39