// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/streetview/publish/v1/resources.proto

package publishpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The processing state of the sequence. The states move as follows:
//
// ```
//
//	    +-------------------------+
//	    |                         |
//	+---v---+  +----------+  +----+----+
//	|PENDING+-->PROCESSING+-->PROCESSED|
//	+---+---+  +----+-----+  +----+----+
//	    |           |             |
//	    |        +--v---+         |
//	    +-------->FAILED<---------+
//	             +------+
//
// ```
//
// The sequence may move to FAILED from any state. Additionally, a processed
// sequence may be re-processed at any time.
type ProcessingState int32

const (
	// The state is unspecified, this is the default value.
	ProcessingState_PROCESSING_STATE_UNSPECIFIED ProcessingState = 0
	// The sequence has not yet started processing.
	ProcessingState_PENDING ProcessingState = 1
	// The sequence is currently in processing.
	ProcessingState_PROCESSING ProcessingState = 2
	// The sequence has finished processing including refining position.
	ProcessingState_PROCESSED ProcessingState = 3
	// The sequence failed processing. See FailureReason for more details.
	ProcessingState_FAILED ProcessingState = 4
)

// Enum value maps for ProcessingState.
var (
	ProcessingState_name = map[int32]string{
		0: "PROCESSING_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "PROCESSING",
		3: "PROCESSED",
		4: "FAILED",
	}
	ProcessingState_value = map[string]int32{
		"PROCESSING_STATE_UNSPECIFIED": 0,
		"PENDING":                      1,
		"PROCESSING":                   2,
		"PROCESSED":                    3,
		"FAILED":                       4,
	}
)

func (x ProcessingState) Enum() *ProcessingState {
	p := new(ProcessingState)
	*p = x
	return p
}

func (x ProcessingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[0].Descriptor()
}

func (ProcessingState) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[0]
}

func (x ProcessingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessingState.Descriptor instead.
func (ProcessingState) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{0}
}

// The possible reasons this [PhotoSequence]
// [google.streetview.publish.v1.PhotoSequence] failed to process.
type ProcessingFailureReason int32

const (
	// The failure reason is unspecified, this is the default value.
	ProcessingFailureReason_PROCESSING_FAILURE_REASON_UNSPECIFIED ProcessingFailureReason = 0
	// Video frame's resolution is too small.
	ProcessingFailureReason_LOW_RESOLUTION ProcessingFailureReason = 1
	// This video has been uploaded before.
	ProcessingFailureReason_DUPLICATE ProcessingFailureReason = 2
	// Too few GPS points.
	ProcessingFailureReason_INSUFFICIENT_GPS ProcessingFailureReason = 3
	// No overlap between the time frame of GPS track and the time frame of
	// video.
	ProcessingFailureReason_NO_OVERLAP_GPS ProcessingFailureReason = 4
	// GPS is invalid (e.x. all GPS points are at (0,0))
	ProcessingFailureReason_INVALID_GPS ProcessingFailureReason = 5
	// The sequence of photos could not be accurately located in the world.
	ProcessingFailureReason_FAILED_TO_REFINE_POSITIONS ProcessingFailureReason = 6
	// The sequence was taken down for policy reasons.
	ProcessingFailureReason_TAKEDOWN ProcessingFailureReason = 7
	// The video file was corrupt or could not be decoded.
	ProcessingFailureReason_CORRUPT_VIDEO ProcessingFailureReason = 8
	// A permanent failure in the underlying system occurred.
	ProcessingFailureReason_INTERNAL ProcessingFailureReason = 9
	// The video format is invalid or unsupported.
	ProcessingFailureReason_INVALID_VIDEO_FORMAT ProcessingFailureReason = 10
	// Invalid image aspect ratio found.
	ProcessingFailureReason_INVALID_VIDEO_DIMENSIONS ProcessingFailureReason = 11
	// Invalid capture time. Timestamps were from the future.
	ProcessingFailureReason_INVALID_CAPTURE_TIME ProcessingFailureReason = 12
	// GPS data contains a gap greater than 5 seconds in duration.
	ProcessingFailureReason_GPS_DATA_GAP ProcessingFailureReason = 13
	// GPS data is too erratic to be processed.
	ProcessingFailureReason_JUMPY_GPS ProcessingFailureReason = 14
	// IMU (Accelerometer, Gyroscope, etc.) data are not valid. They may be
	// missing required fields (x, y, z or time), may not be formatted correctly,
	// or any other issue that prevents our systems from parsing it.
	ProcessingFailureReason_INVALID_IMU ProcessingFailureReason = 15
	// Too few IMU points.
	ProcessingFailureReason_INSUFFICIENT_IMU ProcessingFailureReason = 21
	// Insufficient overlap in the time frame between GPS, IMU, and other time
	// series data.
	ProcessingFailureReason_INSUFFICIENT_OVERLAP_TIME_SERIES ProcessingFailureReason = 22
	// IMU (Accelerometer, Gyroscope, etc.) data contain gaps greater than 0.1
	// seconds in duration.
	ProcessingFailureReason_IMU_DATA_GAP ProcessingFailureReason = 16
	// The camera is not supported.
	ProcessingFailureReason_UNSUPPORTED_CAMERA ProcessingFailureReason = 17
	// Some frames were indoors, which is unsupported.
	ProcessingFailureReason_NOT_OUTDOORS ProcessingFailureReason = 18
	// Not enough video frames.
	ProcessingFailureReason_INSUFFICIENT_VIDEO_FRAMES ProcessingFailureReason = 19
	// Not enough moving data.
	ProcessingFailureReason_INSUFFICIENT_MOVEMENT ProcessingFailureReason = 20
	// Mast is down.
	ProcessingFailureReason_MAST_DOWN ProcessingFailureReason = 27
	// Camera is covered.
	ProcessingFailureReason_CAMERA_COVERED ProcessingFailureReason = 28
)

// Enum value maps for ProcessingFailureReason.
var (
	ProcessingFailureReason_name = map[int32]string{
		0:  "PROCESSING_FAILURE_REASON_UNSPECIFIED",
		1:  "LOW_RESOLUTION",
		2:  "DUPLICATE",
		3:  "INSUFFICIENT_GPS",
		4:  "NO_OVERLAP_GPS",
		5:  "INVALID_GPS",
		6:  "FAILED_TO_REFINE_POSITIONS",
		7:  "TAKEDOWN",
		8:  "CORRUPT_VIDEO",
		9:  "INTERNAL",
		10: "INVALID_VIDEO_FORMAT",
		11: "INVALID_VIDEO_DIMENSIONS",
		12: "INVALID_CAPTURE_TIME",
		13: "GPS_DATA_GAP",
		14: "JUMPY_GPS",
		15: "INVALID_IMU",
		21: "INSUFFICIENT_IMU",
		22: "INSUFFICIENT_OVERLAP_TIME_SERIES",
		16: "IMU_DATA_GAP",
		17: "UNSUPPORTED_CAMERA",
		18: "NOT_OUTDOORS",
		19: "INSUFFICIENT_VIDEO_FRAMES",
		20: "INSUFFICIENT_MOVEMENT",
		27: "MAST_DOWN",
		28: "CAMERA_COVERED",
	}
	ProcessingFailureReason_value = map[string]int32{
		"PROCESSING_FAILURE_REASON_UNSPECIFIED": 0,
		"LOW_RESOLUTION":                        1,
		"DUPLICATE":                             2,
		"INSUFFICIENT_GPS":                      3,
		"NO_OVERLAP_GPS":                        4,
		"INVALID_GPS":                           5,
		"FAILED_TO_REFINE_POSITIONS":            6,
		"TAKEDOWN":                              7,
		"CORRUPT_VIDEO":                         8,
		"INTERNAL":                              9,
		"INVALID_VIDEO_FORMAT":                  10,
		"INVALID_VIDEO_DIMENSIONS":              11,
		"INVALID_CAPTURE_TIME":                  12,
		"GPS_DATA_GAP":                          13,
		"JUMPY_GPS":                             14,
		"INVALID_IMU":                           15,
		"INSUFFICIENT_IMU":                      21,
		"INSUFFICIENT_OVERLAP_TIME_SERIES":      22,
		"IMU_DATA_GAP":                          16,
		"UNSUPPORTED_CAMERA":                    17,
		"NOT_OUTDOORS":                          18,
		"INSUFFICIENT_VIDEO_FRAMES":             19,
		"INSUFFICIENT_MOVEMENT":                 20,
		"MAST_DOWN":                             27,
		"CAMERA_COVERED":                        28,
	}
)

func (x ProcessingFailureReason) Enum() *ProcessingFailureReason {
	p := new(ProcessingFailureReason)
	*p = x
	return p
}

func (x ProcessingFailureReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessingFailureReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[1].Descriptor()
}

func (ProcessingFailureReason) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[1]
}

func (x ProcessingFailureReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessingFailureReason.Descriptor instead.
func (ProcessingFailureReason) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{1}
}

// Status of rights transfer.
type Photo_TransferStatus int32

const (
	// The status of this transfer is unspecified.
	Photo_TRANSFER_STATUS_UNKNOWN Photo_TransferStatus = 0
	// This photo has never been in a transfer.
	Photo_NEVER_TRANSFERRED Photo_TransferStatus = 1
	// This photo transfer has been initiated, but the receiver has not yet
	// responded.
	Photo_PENDING Photo_TransferStatus = 2
	// The photo transfer has been completed, and this photo has been
	// transferred to the recipient.
	Photo_COMPLETED Photo_TransferStatus = 3
	// The recipient rejected this photo transfer.
	Photo_REJECTED Photo_TransferStatus = 4
	// The photo transfer expired before the recipient took any action.
	Photo_EXPIRED Photo_TransferStatus = 5
	// The sender cancelled this photo transfer.
	Photo_CANCELLED Photo_TransferStatus = 6
	// The recipient owns this photo due to a rights transfer.
	Photo_RECEIVED_VIA_TRANSFER Photo_TransferStatus = 7
)

// Enum value maps for Photo_TransferStatus.
var (
	Photo_TransferStatus_name = map[int32]string{
		0: "TRANSFER_STATUS_UNKNOWN",
		1: "NEVER_TRANSFERRED",
		2: "PENDING",
		3: "COMPLETED",
		4: "REJECTED",
		5: "EXPIRED",
		6: "CANCELLED",
		7: "RECEIVED_VIA_TRANSFER",
	}
	Photo_TransferStatus_value = map[string]int32{
		"TRANSFER_STATUS_UNKNOWN": 0,
		"NEVER_TRANSFERRED":       1,
		"PENDING":                 2,
		"COMPLETED":               3,
		"REJECTED":                4,
		"EXPIRED":                 5,
		"CANCELLED":               6,
		"RECEIVED_VIA_TRANSFER":   7,
	}
)

func (x Photo_TransferStatus) Enum() *Photo_TransferStatus {
	p := new(Photo_TransferStatus)
	*p = x
	return p
}

func (x Photo_TransferStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Photo_TransferStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Photo_TransferStatus) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[2]
}

func (x Photo_TransferStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Photo_TransferStatus.Descriptor instead.
func (Photo_TransferStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

// Publication status of the photo in Google Maps.
type Photo_MapsPublishStatus int32

const (
	// The status of the photo is unknown.
	Photo_UNSPECIFIED_MAPS_PUBLISH_STATUS Photo_MapsPublishStatus = 0
	// The photo is published to the public through Google Maps.
	Photo_PUBLISHED Photo_MapsPublishStatus = 1
	// The photo has been rejected for an unknown reason.
	Photo_REJECTED_UNKNOWN Photo_MapsPublishStatus = 2
)

// Enum value maps for Photo_MapsPublishStatus.
var (
	Photo_MapsPublishStatus_name = map[int32]string{
		0: "UNSPECIFIED_MAPS_PUBLISH_STATUS",
		1: "PUBLISHED",
		2: "REJECTED_UNKNOWN",
	}
	Photo_MapsPublishStatus_value = map[string]int32{
		"UNSPECIFIED_MAPS_PUBLISH_STATUS": 0,
		"PUBLISHED":                       1,
		"REJECTED_UNKNOWN":                2,
	}
)

func (x Photo_MapsPublishStatus) Enum() *Photo_MapsPublishStatus {
	p := new(Photo_MapsPublishStatus)
	*p = x
	return p
}

func (x Photo_MapsPublishStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Photo_MapsPublishStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[3].Descriptor()
}

func (Photo_MapsPublishStatus) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[3]
}

func (x Photo_MapsPublishStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Photo_MapsPublishStatus.Descriptor instead.
func (Photo_MapsPublishStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{7, 1}
}

// Primary source of GPS measurements.
type PhotoSequence_GpsSource int32

const (
	// GPS in raw_gps_timeline takes precedence if it exists.
	PhotoSequence_PHOTO_SEQUENCE PhotoSequence_GpsSource = 0
	// GPS in Camera Motion Metadata Track (CAMM) takes precedence if it exists.
	PhotoSequence_CAMERA_MOTION_METADATA_TRACK PhotoSequence_GpsSource = 1
)

// Enum value maps for PhotoSequence_GpsSource.
var (
	PhotoSequence_GpsSource_name = map[int32]string{
		0: "PHOTO_SEQUENCE",
		1: "CAMERA_MOTION_METADATA_TRACK",
	}
	PhotoSequence_GpsSource_value = map[string]int32{
		"PHOTO_SEQUENCE":               0,
		"CAMERA_MOTION_METADATA_TRACK": 1,
	}
)

func (x PhotoSequence_GpsSource) Enum() *PhotoSequence_GpsSource {
	p := new(PhotoSequence_GpsSource)
	*p = x
	return p
}

func (x PhotoSequence_GpsSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhotoSequence_GpsSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[4].Descriptor()
}

func (PhotoSequence_GpsSource) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[4]
}

func (x PhotoSequence_GpsSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhotoSequence_GpsSource.Descriptor instead.
func (PhotoSequence_GpsSource) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{8, 0}
}

// Upload reference for media files.
type UploadRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to FileSource:
	//
	//	*UploadRef_UploadUrl
	FileSource isUploadRef_FileSource `protobuf_oneof:"file_source"`
}

func (x *UploadRef) Reset() {
	*x = UploadRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRef) ProtoMessage() {}

func (x *UploadRef) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRef.ProtoReflect.Descriptor instead.
func (*UploadRef) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (m *UploadRef) GetFileSource() isUploadRef_FileSource {
	if m != nil {
		return m.FileSource
	}
	return nil
}

func (x *UploadRef) GetUploadUrl() string {
	if x, ok := x.GetFileSource().(*UploadRef_UploadUrl); ok {
		return x.UploadUrl
	}
	return ""
}

type isUploadRef_FileSource interface {
	isUploadRef_FileSource()
}

type UploadRef_UploadUrl struct {
	// An upload reference should be unique for each user. It follows
	// the form:
	// "https://streetviewpublish.googleapis.com/media/user/{account_id}/photo/{upload_reference}"
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3,oneof"`
}

func (*UploadRef_UploadUrl) isUploadRef_FileSource() {}

// Identifier for a [Photo][google.streetview.publish.v1.Photo].
type PhotoId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for a photo.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *PhotoId) Reset() {
	*x = PhotoId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhotoId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoId) ProtoMessage() {}

func (x *PhotoId) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoId.ProtoReflect.Descriptor instead.
func (*PhotoId) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *PhotoId) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Level information containing level number and its corresponding name.
type Level struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Floor number, used for ordering. 0 indicates the ground level, 1
	// indicates the first level above ground level, -1 indicates the first level
	// under ground level. Non-integer values are OK.
	Number float64 `protobuf:"fixed64,1,opt,name=number,proto3" json:"number,omitempty"`
	// Required. A name assigned to this Level, restricted to 3 characters.
	// Consider how the elevator buttons would be labeled for this level if there
	// was an elevator.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Level) Reset() {
	*x = Level{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Level) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Level) ProtoMessage() {}

func (x *Level) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Level.ProtoReflect.Descriptor instead.
func (*Level) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Level) GetNumber() float64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *Level) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Raw pose measurement for an entity.
type Pose struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude and longitude pair of the pose, as explained here:
	// https://cloud.google.com/datastore/docs/reference/rest/Shared.Types/LatLng
	// When creating a [Photo][google.streetview.publish.v1.Photo], if the
	// latitude and longitude pair are not provided, the geolocation from the
	// exif header is used. A latitude and longitude pair not provided in the
	// photo or exif header causes the photo process to fail.
	LatLngPair *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng_pair,json=latLngPair,proto3" json:"lat_lng_pair,omitempty"`
	// Altitude of the pose in meters above WGS84 ellipsoid.
	// NaN indicates an unmeasured quantity.
	Altitude float64 `protobuf:"fixed64,2,opt,name=altitude,proto3" json:"altitude,omitempty"`
	// The following pose parameters pertain to the center of the photo. They
	// match https://developers.google.com/streetview/spherical-metadata.
	// Compass heading, measured at the center of the photo in degrees clockwise
	// from North. Value must be >=0 and <360. NaN indicates an unmeasured
	// quantity.
	Heading float64 `protobuf:"fixed64,3,opt,name=heading,proto3" json:"heading,omitempty"`
	// Pitch, measured at the center of the photo in degrees. Value must be >=-90
	// and <= 90. A value of -90 means looking directly down, and a value of 90
	// means looking directly up.
	// NaN indicates an unmeasured quantity.
	Pitch float64 `protobuf:"fixed64,4,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Roll, measured in degrees. Value must be >= 0 and <360. A value of 0
	// means level with the horizon.
	// NaN indicates an unmeasured quantity.
	Roll float64 `protobuf:"fixed64,5,opt,name=roll,proto3" json:"roll,omitempty"`
	// Time of the GPS record since UTC epoch.
	GpsRecordTimestampUnixEpoch *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=gps_record_timestamp_unix_epoch,json=gpsRecordTimestampUnixEpoch,proto3" json:"gps_record_timestamp_unix_epoch,omitempty"`
	// Level (the floor in a building) used to configure vertical navigation.
	Level *Level `protobuf:"bytes,7,opt,name=level,proto3" json:"level,omitempty"`
	// The estimated horizontal accuracy of this pose in meters with 68%
	// confidence (one standard deviation). For example, on Android, this value is
	// available from this method:
	// https://developer.android.com/reference/android/location/Location#getAccuracy().
	// Other platforms have different methods of obtaining similar accuracy
	// estimations.
	AccuracyMeters float32 `protobuf:"fixed32,9,opt,name=accuracy_meters,json=accuracyMeters,proto3" json:"accuracy_meters,omitempty"`
}

func (x *Pose) Reset() {
	*x = Pose{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pose) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pose) ProtoMessage() {}

func (x *Pose) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pose.ProtoReflect.Descriptor instead.
func (*Pose) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Pose) GetLatLngPair() *latlng.LatLng {
	if x != nil {
		return x.LatLngPair
	}
	return nil
}

func (x *Pose) GetAltitude() float64 {
	if x != nil {
		return x.Altitude
	}
	return 0
}

func (x *Pose) GetHeading() float64 {
	if x != nil {
		return x.Heading
	}
	return 0
}

func (x *Pose) GetPitch() float64 {
	if x != nil {
		return x.Pitch
	}
	return 0
}

func (x *Pose) GetRoll() float64 {
	if x != nil {
		return x.Roll
	}
	return 0
}

func (x *Pose) GetGpsRecordTimestampUnixEpoch() *timestamppb.Timestamp {
	if x != nil {
		return x.GpsRecordTimestampUnixEpoch
	}
	return nil
}

func (x *Pose) GetLevel() *Level {
	if x != nil {
		return x.Level
	}
	return nil
}

func (x *Pose) GetAccuracyMeters() float32 {
	if x != nil {
		return x.AccuracyMeters
	}
	return 0
}

// IMU data from the device sensors.
type Imu struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The accelerometer measurements in meters/sec^2 with increasing timestamps
	// from devices.
	AccelMpsps []*Imu_Measurement3D `protobuf:"bytes,1,rep,name=accel_mpsps,json=accelMpsps,proto3" json:"accel_mpsps,omitempty"`
	// The gyroscope measurements in radians/sec with increasing timestamps from
	// devices.
	GyroRps []*Imu_Measurement3D `protobuf:"bytes,2,rep,name=gyro_rps,json=gyroRps,proto3" json:"gyro_rps,omitempty"`
	// The magnetometer measurements of the magnetic field in microtesla (uT) with
	// increasing timestamps from devices.
	MagUt []*Imu_Measurement3D `protobuf:"bytes,3,rep,name=mag_ut,json=magUt,proto3" json:"mag_ut,omitempty"`
}

func (x *Imu) Reset() {
	*x = Imu{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Imu) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Imu) ProtoMessage() {}

func (x *Imu) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Imu.ProtoReflect.Descriptor instead.
func (*Imu) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Imu) GetAccelMpsps() []*Imu_Measurement3D {
	if x != nil {
		return x.AccelMpsps
	}
	return nil
}

func (x *Imu) GetGyroRps() []*Imu_Measurement3D {
	if x != nil {
		return x.GyroRps
	}
	return nil
}

func (x *Imu) GetMagUt() []*Imu_Measurement3D {
	if x != nil {
		return x.MagUt
	}
	return nil
}

// Place metadata for an entity.
type Place struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place identifier, as described in
	// https://developers.google.com/places/place-id.
	PlaceId string `protobuf:"bytes,1,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// Output only. The name of the place, localized to the language_code.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The language_code that the name is localized with. This should
	// be the language_code specified in the request, but may be a fallback.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Place) Reset() {
	*x = Place{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place) ProtoMessage() {}

func (x *Place) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place.ProtoReflect.Descriptor instead.
func (*Place) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *Place) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *Place) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Place) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// A connection is the link from a source photo to a destination photo.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination of the connection from the containing photo to
	// another photo.
	Target *PhotoId `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Connection) GetTarget() *PhotoId {
	if x != nil {
		return x.Target
	}
	return nil
}

// Photo is used to store 360 photos along with photo metadata.
type Photo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output only. Required when updating a photo. Output only when
	// creating a photo. Identifier for the photo, which is unique among all
	// photos in Google.
	PhotoId *PhotoId `protobuf:"bytes,1,opt,name=photo_id,json=photoId,proto3" json:"photo_id,omitempty"`
	// Input only. Required when creating a photo. Input only. The resource URL
	// where the photo bytes are uploaded to.
	UploadReference *UploadRef `protobuf:"bytes,2,opt,name=upload_reference,json=uploadReference,proto3" json:"upload_reference,omitempty"`
	// Output only. The download URL for the photo bytes. This field is set only
	// when
	// [GetPhotoRequest.view][google.streetview.publish.v1.GetPhotoRequest.view]
	// is set to
	// [PhotoView.INCLUDE_DOWNLOAD_URL][google.streetview.publish.v1.PhotoView.INCLUDE_DOWNLOAD_URL].
	DownloadUrl string `protobuf:"bytes,3,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
	// Output only. The thumbnail URL for showing a preview of the given photo.
	ThumbnailUrl string `protobuf:"bytes,9,opt,name=thumbnail_url,json=thumbnailUrl,proto3" json:"thumbnail_url,omitempty"`
	// Output only. The share link for the photo.
	ShareLink string `protobuf:"bytes,11,opt,name=share_link,json=shareLink,proto3" json:"share_link,omitempty"`
	// Optional. Pose of the photo.
	Pose *Pose `protobuf:"bytes,4,opt,name=pose,proto3" json:"pose,omitempty"`
	// Optional. Connections to other photos. A connection represents the link
	// from this photo to another photo.
	Connections []*Connection `protobuf:"bytes,5,rep,name=connections,proto3" json:"connections,omitempty"`
	// Optional. Absolute time when the photo was captured.
	// When the photo has no exif timestamp, this is used to set a timestamp in
	// the photo metadata.
	CaptureTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=capture_time,json=captureTime,proto3" json:"capture_time,omitempty"`
	// Output only. Time when the image was uploaded.
	UploadTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=upload_time,json=uploadTime,proto3" json:"upload_time,omitempty"`
	// Optional. Places where this photo belongs.
	Places []*Place `protobuf:"bytes,7,rep,name=places,proto3" json:"places,omitempty"`
	// Output only. View count of the photo.
	ViewCount int64 `protobuf:"varint,10,opt,name=view_count,json=viewCount,proto3" json:"view_count,omitempty"`
	// Output only. Status of rights transfer on this photo.
	TransferStatus Photo_TransferStatus `protobuf:"varint,12,opt,name=transfer_status,json=transferStatus,proto3,enum=google.streetview.publish.v1.Photo_TransferStatus" json:"transfer_status,omitempty"`
	// Output only. Status in Google Maps, whether this photo was published or
	// rejected.
	MapsPublishStatus Photo_MapsPublishStatus `protobuf:"varint,13,opt,name=maps_publish_status,json=mapsPublishStatus,proto3,enum=google.streetview.publish.v1.Photo_MapsPublishStatus" json:"maps_publish_status,omitempty"`
}

func (x *Photo) Reset() {
	*x = Photo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Photo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Photo) ProtoMessage() {}

func (x *Photo) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Photo.ProtoReflect.Descriptor instead.
func (*Photo) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *Photo) GetPhotoId() *PhotoId {
	if x != nil {
		return x.PhotoId
	}
	return nil
}

func (x *Photo) GetUploadReference() *UploadRef {
	if x != nil {
		return x.UploadReference
	}
	return nil
}

func (x *Photo) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

func (x *Photo) GetThumbnailUrl() string {
	if x != nil {
		return x.ThumbnailUrl
	}
	return ""
}

func (x *Photo) GetShareLink() string {
	if x != nil {
		return x.ShareLink
	}
	return ""
}

func (x *Photo) GetPose() *Pose {
	if x != nil {
		return x.Pose
	}
	return nil
}

func (x *Photo) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *Photo) GetCaptureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CaptureTime
	}
	return nil
}

func (x *Photo) GetUploadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UploadTime
	}
	return nil
}

func (x *Photo) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

func (x *Photo) GetViewCount() int64 {
	if x != nil {
		return x.ViewCount
	}
	return 0
}

func (x *Photo) GetTransferStatus() Photo_TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return Photo_TRANSFER_STATUS_UNKNOWN
}

func (x *Photo) GetMapsPublishStatus() Photo_MapsPublishStatus {
	if x != nil {
		return x.MapsPublishStatus
	}
	return Photo_UNSPECIFIED_MAPS_PUBLISH_STATUS
}

// A sequence of 360 photos along with metadata.
type PhotoSequence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique identifier for the photo sequence.
	// This also acts as a long running operation ID if uploading is performed
	// asynchronously.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Photos with increasing timestamps.
	Photos []*Photo `protobuf:"bytes,2,rep,name=photos,proto3" json:"photos,omitempty"`
	// Input only. Required when creating photo sequence. The resource name
	// where the bytes of the photo sequence (in the form of video) are uploaded.
	UploadReference *UploadRef `protobuf:"bytes,3,opt,name=upload_reference,json=uploadReference,proto3" json:"upload_reference,omitempty"`
	// Optional. Absolute time when the photo sequence starts to be captured.
	// If the photo sequence is a video, this is the start time of the video.
	// If this field is populated in input, it overrides the capture time in the
	// video or XDM file.
	CaptureTimeOverride *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=capture_time_override,json=captureTimeOverride,proto3" json:"capture_time_override,omitempty"`
	// Output only. The time this photo sequence was created in uSV Store service.
	UploadTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=upload_time,json=uploadTime,proto3" json:"upload_time,omitempty"`
	// Input only. Raw GPS measurements with increasing timestamps from the device
	// that aren't time synced with each photo. These raw measurements will be
	// used to infer the pose of each frame. Required in input when InputType is
	// VIDEO and raw GPS measurements are not in Camera Motion Metadata Track
	// (CAMM). User can indicate which takes precedence using gps_source if raw
	// GPS measurements are provided in both raw_gps_timeline and Camera Motion
	// Metadata Track (CAMM).
	RawGpsTimeline []*Pose `protobuf:"bytes,7,rep,name=raw_gps_timeline,json=rawGpsTimeline,proto3" json:"raw_gps_timeline,omitempty"`
	// Input only. If both raw_gps_timeline and
	// the Camera Motion Metadata Track (CAMM) contain GPS measurements,
	// indicate which takes precedence.
	GpsSource PhotoSequence_GpsSource `protobuf:"varint,8,opt,name=gps_source,json=gpsSource,proto3,enum=google.streetview.publish.v1.PhotoSequence_GpsSource" json:"gps_source,omitempty"`
	// Input only. Three axis IMU data for the collection.
	// If this data is too large to put in the request, then it should be put in
	// the CAMM track for the video. This data always takes precedence over the
	// equivalent CAMM data, if it exists.
	Imu *Imu `protobuf:"bytes,11,opt,name=imu,proto3" json:"imu,omitempty"`
	// Output only. The processing state of this sequence.
	ProcessingState ProcessingState `protobuf:"varint,12,opt,name=processing_state,json=processingState,proto3,enum=google.streetview.publish.v1.ProcessingState" json:"processing_state,omitempty"`
	// Output only. If this sequence has processing_state = FAILED, this will
	// contain the reason why it failed. If the processing_state is any other
	// value, this field will be unset.
	FailureReason ProcessingFailureReason `protobuf:"varint,13,opt,name=failure_reason,json=failureReason,proto3,enum=google.streetview.publish.v1.ProcessingFailureReason" json:"failure_reason,omitempty"`
	// Output only. If this sequence has `failure_reason` set, this may contain
	// additional details about the failure.
	FailureDetails *ProcessingFailureDetails `protobuf:"bytes,23,opt,name=failure_details,json=failureDetails,proto3" json:"failure_details,omitempty"`
	// Output only. The computed distance of the photo sequence in meters.
	DistanceMeters float64 `protobuf:"fixed64,16,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// Output only. A rectangular box that encapsulates every image in this photo
	// sequence.
	SequenceBounds *LatLngBounds `protobuf:"bytes,20,opt,name=sequence_bounds,json=sequenceBounds,proto3" json:"sequence_bounds,omitempty"`
	// Output only. The total number of views that all the published images in
	// this PhotoSequence have received.
	ViewCount int64 `protobuf:"varint,21,opt,name=view_count,json=viewCount,proto3" json:"view_count,omitempty"`
	// Output only. The filename of the upload. Does not include the directory
	// path. Only available if the sequence was uploaded on a platform that
	// provides the filename.
	Filename string `protobuf:"bytes,22,opt,name=filename,proto3" json:"filename,omitempty"`
}

func (x *PhotoSequence) Reset() {
	*x = PhotoSequence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhotoSequence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoSequence) ProtoMessage() {}

func (x *PhotoSequence) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoSequence.ProtoReflect.Descriptor instead.
func (*PhotoSequence) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *PhotoSequence) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PhotoSequence) GetPhotos() []*Photo {
	if x != nil {
		return x.Photos
	}
	return nil
}

func (x *PhotoSequence) GetUploadReference() *UploadRef {
	if x != nil {
		return x.UploadReference
	}
	return nil
}

func (x *PhotoSequence) GetCaptureTimeOverride() *timestamppb.Timestamp {
	if x != nil {
		return x.CaptureTimeOverride
	}
	return nil
}

func (x *PhotoSequence) GetUploadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UploadTime
	}
	return nil
}

func (x *PhotoSequence) GetRawGpsTimeline() []*Pose {
	if x != nil {
		return x.RawGpsTimeline
	}
	return nil
}

func (x *PhotoSequence) GetGpsSource() PhotoSequence_GpsSource {
	if x != nil {
		return x.GpsSource
	}
	return PhotoSequence_PHOTO_SEQUENCE
}

func (x *PhotoSequence) GetImu() *Imu {
	if x != nil {
		return x.Imu
	}
	return nil
}

func (x *PhotoSequence) GetProcessingState() ProcessingState {
	if x != nil {
		return x.ProcessingState
	}
	return ProcessingState_PROCESSING_STATE_UNSPECIFIED
}

func (x *PhotoSequence) GetFailureReason() ProcessingFailureReason {
	if x != nil {
		return x.FailureReason
	}
	return ProcessingFailureReason_PROCESSING_FAILURE_REASON_UNSPECIFIED
}

func (x *PhotoSequence) GetFailureDetails() *ProcessingFailureDetails {
	if x != nil {
		return x.FailureDetails
	}
	return nil
}

func (x *PhotoSequence) GetDistanceMeters() float64 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *PhotoSequence) GetSequenceBounds() *LatLngBounds {
	if x != nil {
		return x.SequenceBounds
	}
	return nil
}

func (x *PhotoSequence) GetViewCount() int64 {
	if x != nil {
		return x.ViewCount
	}
	return 0
}

func (x *PhotoSequence) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

// A rectangle in geographical coordinates.
type LatLngBounds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The southwest corner of these bounds.
	Southwest *latlng.LatLng `protobuf:"bytes,1,opt,name=southwest,proto3" json:"southwest,omitempty"`
	// The northeast corner of these bounds.
	Northeast *latlng.LatLng `protobuf:"bytes,2,opt,name=northeast,proto3" json:"northeast,omitempty"`
}

func (x *LatLngBounds) Reset() {
	*x = LatLngBounds{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LatLngBounds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LatLngBounds) ProtoMessage() {}

func (x *LatLngBounds) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LatLngBounds.ProtoReflect.Descriptor instead.
func (*LatLngBounds) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *LatLngBounds) GetSouthwest() *latlng.LatLng {
	if x != nil {
		return x.Southwest
	}
	return nil
}

func (x *LatLngBounds) GetNortheast() *latlng.LatLng {
	if x != nil {
		return x.Northeast
	}
	return nil
}

// Additional details to accompany the ProcessingFailureReason enum.
// This message is always expected to be used in conjunction with
// ProcessingFailureReason, and the oneof value set in this message should match
// the FailureReason.
type ProcessingFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only one set of details will be set, and must match the corresponding enum
	// in ProcessingFailureReason.
	//
	// Types that are assignable to Details:
	//
	//	*ProcessingFailureDetails_InsufficientGpsDetails
	//	*ProcessingFailureDetails_GpsDataGapDetails
	//	*ProcessingFailureDetails_ImuDataGapDetails
	//	*ProcessingFailureDetails_NotOutdoorsDetails
	//	*ProcessingFailureDetails_NoOverlapGpsDetails
	Details isProcessingFailureDetails_Details `protobuf_oneof:"details"`
}

func (x *ProcessingFailureDetails) Reset() {
	*x = ProcessingFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessingFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessingFailureDetails) ProtoMessage() {}

func (x *ProcessingFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessingFailureDetails.ProtoReflect.Descriptor instead.
func (*ProcessingFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (m *ProcessingFailureDetails) GetDetails() isProcessingFailureDetails_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *ProcessingFailureDetails) GetInsufficientGpsDetails() *InsufficientGpsFailureDetails {
	if x, ok := x.GetDetails().(*ProcessingFailureDetails_InsufficientGpsDetails); ok {
		return x.InsufficientGpsDetails
	}
	return nil
}

func (x *ProcessingFailureDetails) GetGpsDataGapDetails() *GpsDataGapFailureDetails {
	if x, ok := x.GetDetails().(*ProcessingFailureDetails_GpsDataGapDetails); ok {
		return x.GpsDataGapDetails
	}
	return nil
}

func (x *ProcessingFailureDetails) GetImuDataGapDetails() *ImuDataGapFailureDetails {
	if x, ok := x.GetDetails().(*ProcessingFailureDetails_ImuDataGapDetails); ok {
		return x.ImuDataGapDetails
	}
	return nil
}

func (x *ProcessingFailureDetails) GetNotOutdoorsDetails() *NotOutdoorsFailureDetails {
	if x, ok := x.GetDetails().(*ProcessingFailureDetails_NotOutdoorsDetails); ok {
		return x.NotOutdoorsDetails
	}
	return nil
}

func (x *ProcessingFailureDetails) GetNoOverlapGpsDetails() *NoOverlapGpsFailureDetails {
	if x, ok := x.GetDetails().(*ProcessingFailureDetails_NoOverlapGpsDetails); ok {
		return x.NoOverlapGpsDetails
	}
	return nil
}

type isProcessingFailureDetails_Details interface {
	isProcessingFailureDetails_Details()
}

type ProcessingFailureDetails_InsufficientGpsDetails struct {
	// See InsufficientGpsFailureDetails.
	InsufficientGpsDetails *InsufficientGpsFailureDetails `protobuf:"bytes,1,opt,name=insufficient_gps_details,json=insufficientGpsDetails,proto3,oneof"`
}

type ProcessingFailureDetails_GpsDataGapDetails struct {
	// See GpsDataGapFailureDetails.
	GpsDataGapDetails *GpsDataGapFailureDetails `protobuf:"bytes,2,opt,name=gps_data_gap_details,json=gpsDataGapDetails,proto3,oneof"`
}

type ProcessingFailureDetails_ImuDataGapDetails struct {
	// See ImuDataGapFailureDetails.
	ImuDataGapDetails *ImuDataGapFailureDetails `protobuf:"bytes,3,opt,name=imu_data_gap_details,json=imuDataGapDetails,proto3,oneof"`
}

type ProcessingFailureDetails_NotOutdoorsDetails struct {
	// See NotOutdoorsFailureDetails.
	NotOutdoorsDetails *NotOutdoorsFailureDetails `protobuf:"bytes,4,opt,name=not_outdoors_details,json=notOutdoorsDetails,proto3,oneof"`
}

type ProcessingFailureDetails_NoOverlapGpsDetails struct {
	// See NoOverlapGpsFailureDetails.
	NoOverlapGpsDetails *NoOverlapGpsFailureDetails `protobuf:"bytes,5,opt,name=no_overlap_gps_details,json=noOverlapGpsDetails,proto3,oneof"`
}

func (*ProcessingFailureDetails_InsufficientGpsDetails) isProcessingFailureDetails_Details() {}

func (*ProcessingFailureDetails_GpsDataGapDetails) isProcessingFailureDetails_Details() {}

func (*ProcessingFailureDetails_ImuDataGapDetails) isProcessingFailureDetails_Details() {}

func (*ProcessingFailureDetails_NotOutdoorsDetails) isProcessingFailureDetails_Details() {}

func (*ProcessingFailureDetails_NoOverlapGpsDetails) isProcessingFailureDetails_Details() {}

// Details related to ProcessingFailureReason#INSUFFICIENT_GPS.
type InsufficientGpsFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of GPS points that were found in the video.
	GpsPointsFound *int32 `protobuf:"varint,1,opt,name=gps_points_found,json=gpsPointsFound,proto3,oneof" json:"gps_points_found,omitempty"`
}

func (x *InsufficientGpsFailureDetails) Reset() {
	*x = InsufficientGpsFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsufficientGpsFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsufficientGpsFailureDetails) ProtoMessage() {}

func (x *InsufficientGpsFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsufficientGpsFailureDetails.ProtoReflect.Descriptor instead.
func (*InsufficientGpsFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *InsufficientGpsFailureDetails) GetGpsPointsFound() int32 {
	if x != nil && x.GpsPointsFound != nil {
		return *x.GpsPointsFound
	}
	return 0
}

// Details related to ProcessingFailureReason#GPS_DATA_GAP.
// If there are multiple GPS data gaps, only the one with the largest duration
// is reported here.
type GpsDataGapFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration of the gap in GPS data that was found.
	GapDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=gap_duration,json=gapDuration,proto3,oneof" json:"gap_duration,omitempty"`
	// Relative time (from the start of the video stream) when the gap started.
	GapStartTime *durationpb.Duration `protobuf:"bytes,2,opt,name=gap_start_time,json=gapStartTime,proto3,oneof" json:"gap_start_time,omitempty"`
}

func (x *GpsDataGapFailureDetails) Reset() {
	*x = GpsDataGapFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GpsDataGapFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GpsDataGapFailureDetails) ProtoMessage() {}

func (x *GpsDataGapFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GpsDataGapFailureDetails.ProtoReflect.Descriptor instead.
func (*GpsDataGapFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *GpsDataGapFailureDetails) GetGapDuration() *durationpb.Duration {
	if x != nil {
		return x.GapDuration
	}
	return nil
}

func (x *GpsDataGapFailureDetails) GetGapStartTime() *durationpb.Duration {
	if x != nil {
		return x.GapStartTime
	}
	return nil
}

// Details related to ProcessingFailureReason#IMU_DATA_GAP.
// If there are multiple IMU data gaps, only the one with the largest duration
// is reported here.
type ImuDataGapFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration of the gap in IMU data that was found.
	GapDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=gap_duration,json=gapDuration,proto3,oneof" json:"gap_duration,omitempty"`
	// Relative time (from the start of the video stream) when the gap started.
	GapStartTime *durationpb.Duration `protobuf:"bytes,2,opt,name=gap_start_time,json=gapStartTime,proto3,oneof" json:"gap_start_time,omitempty"`
}

func (x *ImuDataGapFailureDetails) Reset() {
	*x = ImuDataGapFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImuDataGapFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImuDataGapFailureDetails) ProtoMessage() {}

func (x *ImuDataGapFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImuDataGapFailureDetails.ProtoReflect.Descriptor instead.
func (*ImuDataGapFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *ImuDataGapFailureDetails) GetGapDuration() *durationpb.Duration {
	if x != nil {
		return x.GapDuration
	}
	return nil
}

func (x *ImuDataGapFailureDetails) GetGapStartTime() *durationpb.Duration {
	if x != nil {
		return x.GapStartTime
	}
	return nil
}

// Details related to ProcessingFailureReason#NOT_OUTDOORS.
// If there are multiple indoor frames found, the first frame is recorded here.
type NotOutdoorsFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relative time (from the start of the video stream) when an indoor frame was
	// found.
	StartTime *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3,oneof" json:"start_time,omitempty"`
}

func (x *NotOutdoorsFailureDetails) Reset() {
	*x = NotOutdoorsFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotOutdoorsFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotOutdoorsFailureDetails) ProtoMessage() {}

func (x *NotOutdoorsFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotOutdoorsFailureDetails.ProtoReflect.Descriptor instead.
func (*NotOutdoorsFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *NotOutdoorsFailureDetails) GetStartTime() *durationpb.Duration {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Details related to PhotoSequenceProcessingFailureReason#NO_OVERLAP_GPS.
type NoOverlapGpsFailureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of first recorded GPS point.
	GpsStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=gps_start_time,json=gpsStartTime,proto3,oneof" json:"gps_start_time,omitempty"`
	// Time of last recorded GPS point.
	GpsEndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=gps_end_time,json=gpsEndTime,proto3,oneof" json:"gps_end_time,omitempty"`
	// Start time of video.
	VideoStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=video_start_time,json=videoStartTime,proto3,oneof" json:"video_start_time,omitempty"`
	// End time of video.
	VideoEndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=video_end_time,json=videoEndTime,proto3,oneof" json:"video_end_time,omitempty"`
}

func (x *NoOverlapGpsFailureDetails) Reset() {
	*x = NoOverlapGpsFailureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NoOverlapGpsFailureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NoOverlapGpsFailureDetails) ProtoMessage() {}

func (x *NoOverlapGpsFailureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NoOverlapGpsFailureDetails.ProtoReflect.Descriptor instead.
func (*NoOverlapGpsFailureDetails) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *NoOverlapGpsFailureDetails) GetGpsStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GpsStartTime
	}
	return nil
}

func (x *NoOverlapGpsFailureDetails) GetGpsEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GpsEndTime
	}
	return nil
}

func (x *NoOverlapGpsFailureDetails) GetVideoStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VideoStartTime
	}
	return nil
}

func (x *NoOverlapGpsFailureDetails) GetVideoEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VideoEndTime
	}
	return nil
}

// A Generic 3d measurement sample.
type Imu_Measurement3D struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of the IMU measurement.
	CaptureTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=capture_time,json=captureTime,proto3" json:"capture_time,omitempty"`
	// The sensor measurement in the x axis.
	X float32 `protobuf:"fixed32,2,opt,name=x,proto3" json:"x,omitempty"`
	// The sensor measurement in the y axis.
	Y float32 `protobuf:"fixed32,3,opt,name=y,proto3" json:"y,omitempty"`
	// The sensor measurement in the z axis.
	Z float32 `protobuf:"fixed32,4,opt,name=z,proto3" json:"z,omitempty"`
}

func (x *Imu_Measurement3D) Reset() {
	*x = Imu_Measurement3D{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Imu_Measurement3D) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Imu_Measurement3D) ProtoMessage() {}

func (x *Imu_Measurement3D) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Imu_Measurement3D.ProtoReflect.Descriptor instead.
func (*Imu_Measurement3D) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Imu_Measurement3D) GetCaptureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CaptureTime
	}
	return nil
}

func (x *Imu_Measurement3D) GetX() float32 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *Imu_Measurement3D) GetY() float32 {
	if x != nil {
		return x.Y
	}
	return 0
}

func (x *Imu_Measurement3D) GetZ() float32 {
	if x != nil {
		return x.Z
	}
	return 0
}

var File_google_streetview_publish_v1_resources_proto protoreflect.FileDescriptor

var file_google_streetview_publish_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x3b, 0x0a, 0x09, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66,
	0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0x19, 0x0a, 0x07, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x3d, 0x0a, 0x05, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe3, 0x02, 0x0a, 0x04, 0x50,
	0x6f, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x0c, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x5f, 0x70,
	0x61, 0x69, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0a,
	0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x50, 0x61, 0x69, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x6c,
	0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x61, 0x6c,
	0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x14, 0x0a, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x6c, 0x12, 0x60, 0x0a, 0x1f, 0x67, 0x70,
	0x73, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x1b, 0x67, 0x70, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x55, 0x6e, 0x69, 0x78, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x39, 0x0a, 0x05,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x75, 0x72,
	0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x0e, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x22, 0xe5, 0x02, 0x0a, 0x03, 0x49, 0x6d, 0x75, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x6c, 0x5f, 0x6d, 0x70, 0x73, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x75,
	0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x33, 0x64, 0x52, 0x0a,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x4d, 0x70, 0x73, 0x70, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x67, 0x79,
	0x72, 0x6f, 0x5f, 0x72, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x75, 0x2e,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x33, 0x64, 0x52, 0x07, 0x67,
	0x79, 0x72, 0x6f, 0x52, 0x70, 0x73, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x61, 0x67, 0x5f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x75, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x33, 0x64, 0x52, 0x05, 0x6d, 0x61, 0x67, 0x55, 0x74, 0x1a, 0x78,
	0x0a, 0x0d, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x33, 0x64, 0x12,
	0x3d, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0b, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x0c,
	0x0a, 0x01, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x78, 0x12, 0x0c, 0x0a, 0x01,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x79, 0x12, 0x0c, 0x0a, 0x01, 0x7a, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x7a, 0x22, 0x65, 0x0a, 0x05, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22,
	0x50, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x22, 0xef, 0x08, 0x0a, 0x05, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x08, 0x70,
	0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x49, 0x64, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x68,
	0x6f, 0x74, 0x6f, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0f, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x28, 0x0a, 0x0d, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e,
	0x61, 0x69, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x55, 0x72, 0x6c,
	0x12, 0x22, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x04, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65,
	0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x6f, 0x73,
	0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x42, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x61, 0x70, 0x74, 0x75,
	0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x6a, 0x0a, 0x13, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6d, 0x61, 0x70, 0x73, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xa5, 0x01, 0x0a,
	0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11,
	0x4e, 0x45, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x52, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x43,
	0x45, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x41, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x45, 0x52, 0x10, 0x07, 0x22, 0x5d, 0x0a, 0x11, 0x4d, 0x61, 0x70, 0x73, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x1f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x4d, 0x41, 0x50, 0x53, 0x5f, 0x50, 0x55,
	0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a,
	0x10, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x02, 0x22, 0xf6, 0x08, 0x0a, 0x0d, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x68,
	0x6f, 0x74, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x57, 0x0a, 0x10,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x15, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x10,
	0x72, 0x61, 0x77, 0x5f, 0x67, 0x70, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x0e, 0x72, 0x61, 0x77, 0x47, 0x70, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x59, 0x0a, 0x0a, 0x67, 0x70, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x47, 0x70, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x09, 0x67, 0x70, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x03, 0x69, 0x6d,
	0x75, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x75, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x03, 0x69, 0x6d, 0x75, 0x12, 0x5d, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x61, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x0f,
	0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76,
	0x69, 0x65, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x41, 0x0a, 0x09, 0x47, 0x70, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x48, 0x4f, 0x54, 0x4f, 0x5f,
	0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x41,
	0x4d, 0x45, 0x52, 0x41, 0x5f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x41,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x10, 0x01, 0x22, 0x74, 0x0a, 0x0c,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x12, 0x31, 0x0a, 0x09,
	0x73, 0x6f, 0x75, 0x74, 0x68, 0x77, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61,
	0x74, 0x4c, 0x6e, 0x67, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x77, 0x65, 0x73, 0x74, 0x12,
	0x31, 0x0a, 0x09, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x09, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x61,
	0x73, 0x74, 0x22, 0xd2, 0x04, 0x0a, 0x18, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x77, 0x0a, 0x18, 0x69, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x67, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x47, 0x70, 0x73,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x16, 0x69, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x47, 0x70,
	0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x69, 0x0a, 0x14, 0x67, 0x70, 0x73, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x67, 0x61, 0x70, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x70, 0x73, 0x44, 0x61, 0x74, 0x61, 0x47, 0x61, 0x70,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x11, 0x67, 0x70, 0x73, 0x44, 0x61, 0x74, 0x61, 0x47, 0x61, 0x70, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x69, 0x0a, 0x14, 0x69, 0x6d, 0x75, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x67, 0x61, 0x70, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x75, 0x44, 0x61, 0x74, 0x61, 0x47, 0x61, 0x70, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6d, 0x75,
	0x44, 0x61, 0x74, 0x61, 0x47, 0x61, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6b,
	0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x73, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x4f,
	0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x4f, 0x75, 0x74, 0x64,
	0x6f, 0x6f, 0x72, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6f, 0x0a, 0x16, 0x6e,
	0x6f, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f, 0x67, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x70, 0x47, 0x70, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x13, 0x6e, 0x6f, 0x4f, 0x76, 0x65, 0x72, 0x6c,
	0x61, 0x70, 0x47, 0x70, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x09, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x63, 0x0a, 0x1d, 0x49, 0x6e, 0x73, 0x75, 0x66,
	0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x47, 0x70, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x67, 0x70, 0x73, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x70, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x46,
	0x6f, 0x75, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x67, 0x70, 0x73, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0xc7, 0x01, 0x0a,
	0x18, 0x47, 0x70, 0x73, 0x44, 0x61, 0x74, 0x61, 0x47, 0x61, 0x70, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x41, 0x0a, 0x0c, 0x67, 0x61, 0x70,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x61,
	0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x0e,
	0x67, 0x61, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x01, 0x52, 0x0c, 0x67, 0x61, 0x70, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x67, 0x61, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x67, 0x61, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x18, 0x49, 0x6d, 0x75, 0x44, 0x61,
	0x74, 0x61, 0x47, 0x61, 0x70, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x41, 0x0a, 0x0c, 0x67, 0x61, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x61, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x0e, 0x67, 0x61, 0x70, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x0c, 0x67, 0x61, 0x70,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x67, 0x61, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11, 0x0a,
	0x0f, 0x5f, 0x67, 0x61, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0x69, 0x0a, 0x19, 0x4e, 0x6f, 0x74, 0x4f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x73, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3d, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x84, 0x03, 0x0a, 0x1a,
	0x4e, 0x6f, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x47, 0x70, 0x73, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x0e, 0x67, 0x70,
	0x73, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00,
	0x52, 0x0c, 0x67, 0x70, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x41, 0x0a, 0x0c, 0x67, 0x70, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0a, 0x67, 0x70, 0x73, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x10, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x02, 0x52, 0x0e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x45, 0x0a, 0x0e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x48, 0x03, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x45, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x67, 0x70, 0x73, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x67, 0x70,
	0x73, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x2a, 0x6b, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53,
	0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x2a,
	0xca, 0x04, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x25, 0x50,
	0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x57, 0x5f, 0x52, 0x45,
	0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x55,
	0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x53,
	0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x47, 0x50, 0x53, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x4c, 0x41, 0x50, 0x5f, 0x47, 0x50,
	0x53, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x47,
	0x50, 0x53, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x54,
	0x4f, 0x5f, 0x52, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f,
	0x4e, 0x53, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x41, 0x4b, 0x45, 0x44, 0x4f, 0x57, 0x4e,
	0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f, 0x52, 0x52, 0x55, 0x50, 0x54, 0x5f, 0x56, 0x49,
	0x44, 0x45, 0x4f, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x56,
	0x49, 0x44, 0x45, 0x4f, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x0a, 0x12, 0x1c, 0x0a,
	0x18, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x44,
	0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x0b, 0x12, 0x18, 0x0a, 0x14, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x50, 0x53, 0x5f, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x47, 0x41, 0x50, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x4a, 0x55, 0x4d, 0x50, 0x59,
	0x5f, 0x47, 0x50, 0x53, 0x10, 0x0e, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x49, 0x4d, 0x55, 0x10, 0x0f, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x53, 0x55, 0x46,
	0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4d, 0x55, 0x10, 0x15, 0x12, 0x24, 0x0a,
	0x20, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4f, 0x56,
	0x45, 0x52, 0x4c, 0x41, 0x50, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x49, 0x45,
	0x53, 0x10, 0x16, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4d, 0x55, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x47, 0x41, 0x50, 0x10, 0x10, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f,
	0x52, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x41, 0x4d, 0x45, 0x52, 0x41, 0x10, 0x11, 0x12, 0x10, 0x0a,
	0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x4f, 0x55, 0x54, 0x44, 0x4f, 0x4f, 0x52, 0x53, 0x10, 0x12, 0x12,
	0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f,
	0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x13, 0x12, 0x19,
	0x0a, 0x15, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d,
	0x4f, 0x56, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x14, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x41, 0x53,
	0x54, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x1b, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x41, 0x4d, 0x45,
	0x52, 0x41, 0x5f, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x44, 0x10, 0x1c, 0x42, 0x88, 0x01, 0x0a,
	0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e,
	0x75, 0x67, 0x63, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x56, 0x69, 0x65, 0x77, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x40, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x70, 0x62, 0x3b, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_streetview_publish_v1_resources_proto_rawDescOnce sync.Once
	file_google_streetview_publish_v1_resources_proto_rawDescData = file_google_streetview_publish_v1_resources_proto_rawDesc
)

func file_google_streetview_publish_v1_resources_proto_rawDescGZIP() []byte {
	file_google_streetview_publish_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_streetview_publish_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_streetview_publish_v1_resources_proto_rawDescData)
	})
	return file_google_streetview_publish_v1_resources_proto_rawDescData
}

var file_google_streetview_publish_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_streetview_publish_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_streetview_publish_v1_resources_proto_goTypes = []interface{}{
	(ProcessingState)(0),                  // 0: google.streetview.publish.v1.ProcessingState
	(ProcessingFailureReason)(0),          // 1: google.streetview.publish.v1.ProcessingFailureReason
	(Photo_TransferStatus)(0),             // 2: google.streetview.publish.v1.Photo.TransferStatus
	(Photo_MapsPublishStatus)(0),          // 3: google.streetview.publish.v1.Photo.MapsPublishStatus
	(PhotoSequence_GpsSource)(0),          // 4: google.streetview.publish.v1.PhotoSequence.GpsSource
	(*UploadRef)(nil),                     // 5: google.streetview.publish.v1.UploadRef
	(*PhotoId)(nil),                       // 6: google.streetview.publish.v1.PhotoId
	(*Level)(nil),                         // 7: google.streetview.publish.v1.Level
	(*Pose)(nil),                          // 8: google.streetview.publish.v1.Pose
	(*Imu)(nil),                           // 9: google.streetview.publish.v1.Imu
	(*Place)(nil),                         // 10: google.streetview.publish.v1.Place
	(*Connection)(nil),                    // 11: google.streetview.publish.v1.Connection
	(*Photo)(nil),                         // 12: google.streetview.publish.v1.Photo
	(*PhotoSequence)(nil),                 // 13: google.streetview.publish.v1.PhotoSequence
	(*LatLngBounds)(nil),                  // 14: google.streetview.publish.v1.LatLngBounds
	(*ProcessingFailureDetails)(nil),      // 15: google.streetview.publish.v1.ProcessingFailureDetails
	(*InsufficientGpsFailureDetails)(nil), // 16: google.streetview.publish.v1.InsufficientGpsFailureDetails
	(*GpsDataGapFailureDetails)(nil),      // 17: google.streetview.publish.v1.GpsDataGapFailureDetails
	(*ImuDataGapFailureDetails)(nil),      // 18: google.streetview.publish.v1.ImuDataGapFailureDetails
	(*NotOutdoorsFailureDetails)(nil),     // 19: google.streetview.publish.v1.NotOutdoorsFailureDetails
	(*NoOverlapGpsFailureDetails)(nil),    // 20: google.streetview.publish.v1.NoOverlapGpsFailureDetails
	(*Imu_Measurement3D)(nil),             // 21: google.streetview.publish.v1.Imu.Measurement3d
	(*latlng.LatLng)(nil),                 // 22: google.type.LatLng
	(*timestamppb.Timestamp)(nil),         // 23: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),           // 24: google.protobuf.Duration
}
var file_google_streetview_publish_v1_resources_proto_depIdxs = []int32{
	22, // 0: google.streetview.publish.v1.Pose.lat_lng_pair:type_name -> google.type.LatLng
	23, // 1: google.streetview.publish.v1.Pose.gps_record_timestamp_unix_epoch:type_name -> google.protobuf.Timestamp
	7,  // 2: google.streetview.publish.v1.Pose.level:type_name -> google.streetview.publish.v1.Level
	21, // 3: google.streetview.publish.v1.Imu.accel_mpsps:type_name -> google.streetview.publish.v1.Imu.Measurement3d
	21, // 4: google.streetview.publish.v1.Imu.gyro_rps:type_name -> google.streetview.publish.v1.Imu.Measurement3d
	21, // 5: google.streetview.publish.v1.Imu.mag_ut:type_name -> google.streetview.publish.v1.Imu.Measurement3d
	6,  // 6: google.streetview.publish.v1.Connection.target:type_name -> google.streetview.publish.v1.PhotoId
	6,  // 7: google.streetview.publish.v1.Photo.photo_id:type_name -> google.streetview.publish.v1.PhotoId
	5,  // 8: google.streetview.publish.v1.Photo.upload_reference:type_name -> google.streetview.publish.v1.UploadRef
	8,  // 9: google.streetview.publish.v1.Photo.pose:type_name -> google.streetview.publish.v1.Pose
	11, // 10: google.streetview.publish.v1.Photo.connections:type_name -> google.streetview.publish.v1.Connection
	23, // 11: google.streetview.publish.v1.Photo.capture_time:type_name -> google.protobuf.Timestamp
	23, // 12: google.streetview.publish.v1.Photo.upload_time:type_name -> google.protobuf.Timestamp
	10, // 13: google.streetview.publish.v1.Photo.places:type_name -> google.streetview.publish.v1.Place
	2,  // 14: google.streetview.publish.v1.Photo.transfer_status:type_name -> google.streetview.publish.v1.Photo.TransferStatus
	3,  // 15: google.streetview.publish.v1.Photo.maps_publish_status:type_name -> google.streetview.publish.v1.Photo.MapsPublishStatus
	12, // 16: google.streetview.publish.v1.PhotoSequence.photos:type_name -> google.streetview.publish.v1.Photo
	5,  // 17: google.streetview.publish.v1.PhotoSequence.upload_reference:type_name -> google.streetview.publish.v1.UploadRef
	23, // 18: google.streetview.publish.v1.PhotoSequence.capture_time_override:type_name -> google.protobuf.Timestamp
	23, // 19: google.streetview.publish.v1.PhotoSequence.upload_time:type_name -> google.protobuf.Timestamp
	8,  // 20: google.streetview.publish.v1.PhotoSequence.raw_gps_timeline:type_name -> google.streetview.publish.v1.Pose
	4,  // 21: google.streetview.publish.v1.PhotoSequence.gps_source:type_name -> google.streetview.publish.v1.PhotoSequence.GpsSource
	9,  // 22: google.streetview.publish.v1.PhotoSequence.imu:type_name -> google.streetview.publish.v1.Imu
	0,  // 23: google.streetview.publish.v1.PhotoSequence.processing_state:type_name -> google.streetview.publish.v1.ProcessingState
	1,  // 24: google.streetview.publish.v1.PhotoSequence.failure_reason:type_name -> google.streetview.publish.v1.ProcessingFailureReason
	15, // 25: google.streetview.publish.v1.PhotoSequence.failure_details:type_name -> google.streetview.publish.v1.ProcessingFailureDetails
	14, // 26: google.streetview.publish.v1.PhotoSequence.sequence_bounds:type_name -> google.streetview.publish.v1.LatLngBounds
	22, // 27: google.streetview.publish.v1.LatLngBounds.southwest:type_name -> google.type.LatLng
	22, // 28: google.streetview.publish.v1.LatLngBounds.northeast:type_name -> google.type.LatLng
	16, // 29: google.streetview.publish.v1.ProcessingFailureDetails.insufficient_gps_details:type_name -> google.streetview.publish.v1.InsufficientGpsFailureDetails
	17, // 30: google.streetview.publish.v1.ProcessingFailureDetails.gps_data_gap_details:type_name -> google.streetview.publish.v1.GpsDataGapFailureDetails
	18, // 31: google.streetview.publish.v1.ProcessingFailureDetails.imu_data_gap_details:type_name -> google.streetview.publish.v1.ImuDataGapFailureDetails
	19, // 32: google.streetview.publish.v1.ProcessingFailureDetails.not_outdoors_details:type_name -> google.streetview.publish.v1.NotOutdoorsFailureDetails
	20, // 33: google.streetview.publish.v1.ProcessingFailureDetails.no_overlap_gps_details:type_name -> google.streetview.publish.v1.NoOverlapGpsFailureDetails
	24, // 34: google.streetview.publish.v1.GpsDataGapFailureDetails.gap_duration:type_name -> google.protobuf.Duration
	24, // 35: google.streetview.publish.v1.GpsDataGapFailureDetails.gap_start_time:type_name -> google.protobuf.Duration
	24, // 36: google.streetview.publish.v1.ImuDataGapFailureDetails.gap_duration:type_name -> google.protobuf.Duration
	24, // 37: google.streetview.publish.v1.ImuDataGapFailureDetails.gap_start_time:type_name -> google.protobuf.Duration
	24, // 38: google.streetview.publish.v1.NotOutdoorsFailureDetails.start_time:type_name -> google.protobuf.Duration
	23, // 39: google.streetview.publish.v1.NoOverlapGpsFailureDetails.gps_start_time:type_name -> google.protobuf.Timestamp
	23, // 40: google.streetview.publish.v1.NoOverlapGpsFailureDetails.gps_end_time:type_name -> google.protobuf.Timestamp
	23, // 41: google.streetview.publish.v1.NoOverlapGpsFailureDetails.video_start_time:type_name -> google.protobuf.Timestamp
	23, // 42: google.streetview.publish.v1.NoOverlapGpsFailureDetails.video_end_time:type_name -> google.protobuf.Timestamp
	23, // 43: google.streetview.publish.v1.Imu.Measurement3d.capture_time:type_name -> google.protobuf.Timestamp
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_google_streetview_publish_v1_resources_proto_init() }
func file_google_streetview_publish_v1_resources_proto_init() {
	if File_google_streetview_publish_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_streetview_publish_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhotoId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Level); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pose); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Imu); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Photo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhotoSequence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LatLngBounds); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessingFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsufficientGpsFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GpsDataGapFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImuDataGapFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotOutdoorsFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NoOverlapGpsFailureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Imu_Measurement3D); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_streetview_publish_v1_resources_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*UploadRef_UploadUrl)(nil),
	}
	file_google_streetview_publish_v1_resources_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ProcessingFailureDetails_InsufficientGpsDetails)(nil),
		(*ProcessingFailureDetails_GpsDataGapDetails)(nil),
		(*ProcessingFailureDetails_ImuDataGapDetails)(nil),
		(*ProcessingFailureDetails_NotOutdoorsDetails)(nil),
		(*ProcessingFailureDetails_NoOverlapGpsDetails)(nil),
	}
	file_google_streetview_publish_v1_resources_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_streetview_publish_v1_resources_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_streetview_publish_v1_resources_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_streetview_publish_v1_resources_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_streetview_publish_v1_resources_proto_msgTypes[15].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_streetview_publish_v1_resources_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_streetview_publish_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_streetview_publish_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_streetview_publish_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_streetview_publish_v1_resources_proto_msgTypes,
	}.Build()
	File_google_streetview_publish_v1_resources_proto = out.File
	file_google_streetview_publish_v1_resources_proto_rawDesc = nil
	file_google_streetview_publish_v1_resources_proto_goTypes = nil
	file_google_streetview_publish_v1_resources_proto_depIdxs = nil
}
