// Copyright 2018 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.3
// source: src/main/protobuf/analysis_v2.proto

package analysis_v2

import (
	build "go.skia.org/skia/bazel/exporter/build_proto/build"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Container for the action graph properties.
type ActionGraphContainer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Artifacts         []*Artifact         `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	Actions           []*Action           `protobuf:"bytes,2,rep,name=actions,proto3" json:"actions,omitempty"`
	Targets           []*Target           `protobuf:"bytes,3,rep,name=targets,proto3" json:"targets,omitempty"`
	DepSetOfFiles     []*DepSetOfFiles    `protobuf:"bytes,4,rep,name=dep_set_of_files,json=depSetOfFiles,proto3" json:"dep_set_of_files,omitempty"`
	Configuration     []*Configuration    `protobuf:"bytes,5,rep,name=configuration,proto3" json:"configuration,omitempty"`
	AspectDescriptors []*AspectDescriptor `protobuf:"bytes,6,rep,name=aspect_descriptors,json=aspectDescriptors,proto3" json:"aspect_descriptors,omitempty"`
	RuleClasses       []*RuleClass        `protobuf:"bytes,7,rep,name=rule_classes,json=ruleClasses,proto3" json:"rule_classes,omitempty"`
	PathFragments     []*PathFragment     `protobuf:"bytes,8,rep,name=path_fragments,json=pathFragments,proto3" json:"path_fragments,omitempty"`
}

func (x *ActionGraphContainer) Reset() {
	*x = ActionGraphContainer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionGraphContainer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionGraphContainer) ProtoMessage() {}

func (x *ActionGraphContainer) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionGraphContainer.ProtoReflect.Descriptor instead.
func (*ActionGraphContainer) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{0}
}

func (x *ActionGraphContainer) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *ActionGraphContainer) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *ActionGraphContainer) GetTargets() []*Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *ActionGraphContainer) GetDepSetOfFiles() []*DepSetOfFiles {
	if x != nil {
		return x.DepSetOfFiles
	}
	return nil
}

func (x *ActionGraphContainer) GetConfiguration() []*Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

func (x *ActionGraphContainer) GetAspectDescriptors() []*AspectDescriptor {
	if x != nil {
		return x.AspectDescriptors
	}
	return nil
}

func (x *ActionGraphContainer) GetRuleClasses() []*RuleClass {
	if x != nil {
		return x.RuleClasses
	}
	return nil
}

func (x *ActionGraphContainer) GetPathFragments() []*PathFragment {
	if x != nil {
		return x.PathFragments
	}
	return nil
}

// Represents a single artifact, whether it's a source file or a derived output
// file.
type Artifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this artifact; this is a uint32, only valid for this
	// particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The id of the PathFragment that represents the relative path of the file
	// within the execution root.
	PathFragmentId uint32 `protobuf:"varint,2,opt,name=path_fragment_id,json=pathFragmentId,proto3" json:"path_fragment_id,omitempty"`
	// True iff the artifact is a tree artifact, i.e. the above exec_path refers
	// a directory.
	IsTreeArtifact bool `protobuf:"varint,3,opt,name=is_tree_artifact,json=isTreeArtifact,proto3" json:"is_tree_artifact,omitempty"`
}

func (x *Artifact) Reset() {
	*x = Artifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Artifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Artifact) ProtoMessage() {}

func (x *Artifact) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Artifact.ProtoReflect.Descriptor instead.
func (*Artifact) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{1}
}

func (x *Artifact) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Artifact) GetPathFragmentId() uint32 {
	if x != nil {
		return x.PathFragmentId
	}
	return 0
}

func (x *Artifact) GetIsTreeArtifact() bool {
	if x != nil {
		return x.IsTreeArtifact
	}
	return false
}

// Represents a single action, which is a function from Artifact(s) to
// Artifact(s).
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target that was responsible for the creation of the action.
	TargetId uint32 `protobuf:"varint,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The aspects that were responsible for the creation of the action (if any).
	// In the case of aspect-on-aspect, AspectDescriptors are listed in
	// topological order of the dependency graph.
	// e.g. [A, B] would imply that aspect A is applied on top of aspect B.
	AspectDescriptorIds []uint32 `protobuf:"varint,2,rep,packed,name=aspect_descriptor_ids,json=aspectDescriptorIds,proto3" json:"aspect_descriptor_ids,omitempty"`
	// Encodes all significant behavior that might affect the output. The key
	// must change if the work performed by the execution of this action changes.
	// Note that the key doesn't include checksums of the input files.
	ActionKey string `protobuf:"bytes,3,opt,name=action_key,json=actionKey,proto3" json:"action_key,omitempty"`
	// The mnemonic for this kind of action.
	Mnemonic string `protobuf:"bytes,4,opt,name=mnemonic,proto3" json:"mnemonic,omitempty"`
	// The configuration under which this action is executed.
	ConfigurationId uint32 `protobuf:"varint,5,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// The command line arguments of the action. This will be only set if
	// explicitly requested.
	Arguments []string `protobuf:"bytes,6,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The list of environment variables to be set before executing the command.
	EnvironmentVariables []*KeyValuePair `protobuf:"bytes,7,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty"`
	// The set of input dep sets that the action depends upon. If the action does
	// input discovery, the contents of this set might change during execution.
	InputDepSetIds []uint32 `protobuf:"varint,8,rep,packed,name=input_dep_set_ids,json=inputDepSetIds,proto3" json:"input_dep_set_ids,omitempty"`
	// The list of Artifact IDs that represent the output files that this action
	// will generate.
	OutputIds []uint32 `protobuf:"varint,9,rep,packed,name=output_ids,json=outputIds,proto3" json:"output_ids,omitempty"`
	// True iff the action does input discovery during execution.
	DiscoversInputs bool `protobuf:"varint,10,opt,name=discovers_inputs,json=discoversInputs,proto3" json:"discovers_inputs,omitempty"`
	// Execution info for the action.  Remote execution services may use this
	// information to modify the execution environment, but actions will
	// generally not be aware of it.
	ExecutionInfo []*KeyValuePair `protobuf:"bytes,11,rep,name=execution_info,json=executionInfo,proto3" json:"execution_info,omitempty"`
	// The list of param files. This will be only set if explicitly requested.
	ParamFiles []*ParamFile `protobuf:"bytes,12,rep,name=param_files,json=paramFiles,proto3" json:"param_files,omitempty"`
	// The id to an Artifact that is the primary output of this action.
	PrimaryOutputId uint32 `protobuf:"varint,13,opt,name=primary_output_id,json=primaryOutputId,proto3" json:"primary_output_id,omitempty"`
	// The execution platform for this action. Empty if the action has no
	// execution platform.
	ExecutionPlatform string `protobuf:"bytes,14,opt,name=execution_platform,json=executionPlatform,proto3" json:"execution_platform,omitempty"`
	// The template content of the action, if it is TemplateExpand action.
	TemplateContent string `protobuf:"bytes,15,opt,name=template_content,json=templateContent,proto3" json:"template_content,omitempty"`
	// The list of substitution should be performed on the template. The key is
	// the string to be substituted and the value is the string to be substituted
	// to.
	Substitutions []*KeyValuePair `protobuf:"bytes,16,rep,name=substitutions,proto3" json:"substitutions,omitempty"`
	// The contents of the file for the actions.write() action
	// (guarded by the --include_file_write_contents flag).
	FileContents string `protobuf:"bytes,17,opt,name=file_contents,json=fileContents,proto3" json:"file_contents,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{2}
}

func (x *Action) GetTargetId() uint32 {
	if x != nil {
		return x.TargetId
	}
	return 0
}

func (x *Action) GetAspectDescriptorIds() []uint32 {
	if x != nil {
		return x.AspectDescriptorIds
	}
	return nil
}

func (x *Action) GetActionKey() string {
	if x != nil {
		return x.ActionKey
	}
	return ""
}

func (x *Action) GetMnemonic() string {
	if x != nil {
		return x.Mnemonic
	}
	return ""
}

func (x *Action) GetConfigurationId() uint32 {
	if x != nil {
		return x.ConfigurationId
	}
	return 0
}

func (x *Action) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *Action) GetEnvironmentVariables() []*KeyValuePair {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *Action) GetInputDepSetIds() []uint32 {
	if x != nil {
		return x.InputDepSetIds
	}
	return nil
}

func (x *Action) GetOutputIds() []uint32 {
	if x != nil {
		return x.OutputIds
	}
	return nil
}

func (x *Action) GetDiscoversInputs() bool {
	if x != nil {
		return x.DiscoversInputs
	}
	return false
}

func (x *Action) GetExecutionInfo() []*KeyValuePair {
	if x != nil {
		return x.ExecutionInfo
	}
	return nil
}

func (x *Action) GetParamFiles() []*ParamFile {
	if x != nil {
		return x.ParamFiles
	}
	return nil
}

func (x *Action) GetPrimaryOutputId() uint32 {
	if x != nil {
		return x.PrimaryOutputId
	}
	return 0
}

func (x *Action) GetExecutionPlatform() string {
	if x != nil {
		return x.ExecutionPlatform
	}
	return ""
}

func (x *Action) GetTemplateContent() string {
	if x != nil {
		return x.TemplateContent
	}
	return ""
}

func (x *Action) GetSubstitutions() []*KeyValuePair {
	if x != nil {
		return x.Substitutions
	}
	return nil
}

func (x *Action) GetFileContents() string {
	if x != nil {
		return x.FileContents
	}
	return ""
}

// Represents a single target (without configuration information) that is
// associated with an action.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this target; this is a uint32, only valid for this
	// particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Label of the target, e.g. //foo:bar.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// Class of the rule.
	RuleClassId uint32 `protobuf:"varint,3,opt,name=rule_class_id,json=ruleClassId,proto3" json:"rule_class_id,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{3}
}

func (x *Target) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Target) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Target) GetRuleClassId() uint32 {
	if x != nil {
		return x.RuleClassId
	}
	return 0
}

type RuleClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this rule class; this is a uint32, only valid for
	// this particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the rule class, e.g. cc_library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RuleClass) Reset() {
	*x = RuleClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleClass) ProtoMessage() {}

func (x *RuleClass) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleClass.ProtoReflect.Descriptor instead.
func (*RuleClass) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{4}
}

func (x *RuleClass) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *RuleClass) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents an invocation specific descriptor of an aspect.
type AspectDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this aspect descriptor; this is a uint32, only valid
	// for the particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the corresponding aspect. For native aspects, it's the Java
	// class name, for Starlark aspects it's the bzl file followed by a % sign
	// followed by the name of the aspect.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The list of parameters bound to a particular invocation of that aspect on
	// a target. Note that aspects can be executed multiple times on the same
	// target in different order.
	Parameters []*KeyValuePair `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *AspectDescriptor) Reset() {
	*x = AspectDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectDescriptor) ProtoMessage() {}

func (x *AspectDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectDescriptor.ProtoReflect.Descriptor instead.
func (*AspectDescriptor) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{5}
}

func (x *AspectDescriptor) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *AspectDescriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectDescriptor) GetParameters() []*KeyValuePair {
	if x != nil {
		return x.Parameters
	}
	return nil
}

type DepSetOfFiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this named set of files; this is a uint32, only
	// valid for the particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Other transitively included named set of files.
	TransitiveDepSetIds []uint32 `protobuf:"varint,2,rep,packed,name=transitive_dep_set_ids,json=transitiveDepSetIds,proto3" json:"transitive_dep_set_ids,omitempty"`
	// The list of input artifact IDs that are immediately contained in this set.
	DirectArtifactIds []uint32 `protobuf:"varint,3,rep,packed,name=direct_artifact_ids,json=directArtifactIds,proto3" json:"direct_artifact_ids,omitempty"`
}

func (x *DepSetOfFiles) Reset() {
	*x = DepSetOfFiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DepSetOfFiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DepSetOfFiles) ProtoMessage() {}

func (x *DepSetOfFiles) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DepSetOfFiles.ProtoReflect.Descriptor instead.
func (*DepSetOfFiles) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{6}
}

func (x *DepSetOfFiles) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *DepSetOfFiles) GetTransitiveDepSetIds() []uint32 {
	if x != nil {
		return x.TransitiveDepSetIds
	}
	return nil
}

func (x *DepSetOfFiles) GetDirectArtifactIds() []uint32 {
	if x != nil {
		return x.DirectArtifactIds
	}
	return nil
}

type Configuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this configuration; this is a uint32, only valid for
	// the particular dump of the analysis.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The mnemonic representing the build configuration.
	Mnemonic string `protobuf:"bytes,2,opt,name=mnemonic,proto3" json:"mnemonic,omitempty"`
	// The platform string.
	PlatformName string `protobuf:"bytes,3,opt,name=platform_name,json=platformName,proto3" json:"platform_name,omitempty"`
	// The checksum representation of the configuration options;
	Checksum string `protobuf:"bytes,4,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Whether this configuration is used for building tools.
	IsTool bool `protobuf:"varint,5,opt,name=is_tool,json=isTool,proto3" json:"is_tool,omitempty"`
}

func (x *Configuration) Reset() {
	*x = Configuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration) ProtoMessage() {}

func (x *Configuration) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration.ProtoReflect.Descriptor instead.
func (*Configuration) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{7}
}

func (x *Configuration) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Configuration) GetMnemonic() string {
	if x != nil {
		return x.Mnemonic
	}
	return ""
}

func (x *Configuration) GetPlatformName() string {
	if x != nil {
		return x.PlatformName
	}
	return ""
}

func (x *Configuration) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *Configuration) GetIsTool() bool {
	if x != nil {
		return x.IsTool
	}
	return false
}

type KeyValuePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The variable name.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The variable value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *KeyValuePair) Reset() {
	*x = KeyValuePair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValuePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValuePair) ProtoMessage() {}

func (x *KeyValuePair) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValuePair.ProtoReflect.Descriptor instead.
func (*KeyValuePair) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{8}
}

func (x *KeyValuePair) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValuePair) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type ConfiguredTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target. We use blaze_query.Target defined in build.proto instead of
	// the Target defined in this file because blaze_query.Target is much heavier
	// and will output proto results similar to what users are familiar with from
	// regular blaze query.
	Target *build.Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// DEPRECATED. Use configuration_id instead.
	//
	// Deprecated: Do not use.
	Configuration *Configuration `protobuf:"bytes,2,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// The id of the configuration this target is configured for. The actual
	// Configuration message can be found in CqueryResults. If the target doesn't
	// have a configuration, the value will be 0.
	ConfigurationId uint32 `protobuf:"varint,3,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
}

func (x *ConfiguredTarget) Reset() {
	*x = ConfiguredTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfiguredTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfiguredTarget) ProtoMessage() {}

func (x *ConfiguredTarget) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfiguredTarget.ProtoReflect.Descriptor instead.
func (*ConfiguredTarget) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{9}
}

func (x *ConfiguredTarget) GetTarget() *build.Target {
	if x != nil {
		return x.Target
	}
	return nil
}

// Deprecated: Do not use.
func (x *ConfiguredTarget) GetConfiguration() *Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

func (x *ConfiguredTarget) GetConfigurationId() uint32 {
	if x != nil {
		return x.ConfigurationId
	}
	return 0
}

// Container for cquery results
type CqueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All the configuredtargets returns by cquery
	Results []*ConfiguredTarget `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// All the Configurations referenced by results.
	Configurations []*Configuration `protobuf:"bytes,2,rep,name=configurations,proto3" json:"configurations,omitempty"`
}

func (x *CqueryResult) Reset() {
	*x = CqueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CqueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CqueryResult) ProtoMessage() {}

func (x *CqueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CqueryResult.ProtoReflect.Descriptor instead.
func (*CqueryResult) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{10}
}

func (x *CqueryResult) GetResults() []*ConfiguredTarget {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *CqueryResult) GetConfigurations() []*Configuration {
	if x != nil {
		return x.Configurations
	}
	return nil
}

// Content of a param file.
type ParamFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exec path of the param file artifact.
	ExecPath string `protobuf:"bytes,1,opt,name=exec_path,json=execPath,proto3" json:"exec_path,omitempty"`
	// The arguments in the param file.
	// Each argument corresponds to a line in the param file.
	Arguments []string `protobuf:"bytes,2,rep,name=arguments,proto3" json:"arguments,omitempty"`
}

func (x *ParamFile) Reset() {
	*x = ParamFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParamFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParamFile) ProtoMessage() {}

func (x *ParamFile) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParamFile.ProtoReflect.Descriptor instead.
func (*ParamFile) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{11}
}

func (x *ParamFile) GetExecPath() string {
	if x != nil {
		return x.ExecPath
	}
	return ""
}

func (x *ParamFile) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

// The path fragment that makes up a full path.
type PathFragment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this path fragment.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The label of the section in the path.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// The id of the parent path fragment.
	ParentId uint32 `protobuf:"varint,3,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
}

func (x *PathFragment) Reset() {
	*x = PathFragment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PathFragment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PathFragment) ProtoMessage() {}

func (x *PathFragment) ProtoReflect() protoreflect.Message {
	mi := &file_src_main_protobuf_analysis_v2_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PathFragment.ProtoReflect.Descriptor instead.
func (*PathFragment) Descriptor() ([]byte, []int) {
	return file_src_main_protobuf_analysis_v2_proto_rawDescGZIP(), []int{12}
}

func (x *PathFragment) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PathFragment) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *PathFragment) GetParentId() uint32 {
	if x != nil {
		return x.ParentId
	}
	return 0
}

var File_src_main_protobuf_analysis_v2_proto protoreflect.FileDescriptor

var file_src_main_protobuf_analysis_v2_proto_rawDesc = []byte{
	0x0a, 0x23, 0x73, 0x72, 0x63, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x76, 0x32, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x1a,
	0x1d, 0x73, 0x72, 0x63, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3,
	0x03, 0x0a, 0x14, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x09,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x12, 0x40, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x6f, 0x66, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x44, 0x65, 0x70, 0x53, 0x65, 0x74, 0x4f, 0x66, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x53, 0x65, 0x74, 0x4f, 0x66, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x12, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x11, 0x61, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x36, 0x0a,
	0x0c, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0b, 0x72, 0x75, 0x6c, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0e, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x66, 0x72,
	0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x46, 0x72, 0x61,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x70, 0x61, 0x74, 0x68, 0x46, 0x72, 0x61, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0x6e, 0x0a, 0x08, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x28, 0x0a, 0x10, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x66, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x70, 0x61, 0x74, 0x68,
	0x46, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x73,
	0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x73, 0x54, 0x72, 0x65, 0x65, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x22, 0xfd, 0x05, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x13, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x1a, 0x0a, 0x08, 0x6d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x12, 0x29, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x4b, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x14, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x12, 0x29, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x65, 0x70, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x0e, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x44, 0x65, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0d,
	0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x64, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x73,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x3c, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72,
	0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0x52, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x0d, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x72, 0x75, 0x6c,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x49, 0x64, 0x22, 0x2f, 0x0a, 0x09, 0x52, 0x75, 0x6c, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x10, 0x41, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x36, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x0d, 0x44, 0x65,
	0x70, 0x53, 0x65, 0x74, 0x4f, 0x66, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x33, 0x0a, 0x16, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x13, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73,
	0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x11, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x73,
	0x22, 0x95, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x12, 0x23,
	0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12,
	0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x69, 0x73, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x36, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0xad, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x62, 0x6c, 0x61, 0x7a, 0x65, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x41, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x85, 0x01, 0x0a, 0x0c, 0x43, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x34, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x46, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x65, 0x63, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x22, 0x51, 0x0a, 0x0c, 0x50, 0x61, 0x74, 0x68, 0x46, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x42, 0x3a, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x6c, 0x69, 0x62, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x10, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_src_main_protobuf_analysis_v2_proto_rawDescOnce sync.Once
	file_src_main_protobuf_analysis_v2_proto_rawDescData = file_src_main_protobuf_analysis_v2_proto_rawDesc
)

func file_src_main_protobuf_analysis_v2_proto_rawDescGZIP() []byte {
	file_src_main_protobuf_analysis_v2_proto_rawDescOnce.Do(func() {
		file_src_main_protobuf_analysis_v2_proto_rawDescData = protoimpl.X.CompressGZIP(file_src_main_protobuf_analysis_v2_proto_rawDescData)
	})
	return file_src_main_protobuf_analysis_v2_proto_rawDescData
}

var file_src_main_protobuf_analysis_v2_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_src_main_protobuf_analysis_v2_proto_goTypes = []interface{}{
	(*ActionGraphContainer)(nil), // 0: analysis.ActionGraphContainer
	(*Artifact)(nil),             // 1: analysis.Artifact
	(*Action)(nil),               // 2: analysis.Action
	(*Target)(nil),               // 3: analysis.Target
	(*RuleClass)(nil),            // 4: analysis.RuleClass
	(*AspectDescriptor)(nil),     // 5: analysis.AspectDescriptor
	(*DepSetOfFiles)(nil),        // 6: analysis.DepSetOfFiles
	(*Configuration)(nil),        // 7: analysis.Configuration
	(*KeyValuePair)(nil),         // 8: analysis.KeyValuePair
	(*ConfiguredTarget)(nil),     // 9: analysis.ConfiguredTarget
	(*CqueryResult)(nil),         // 10: analysis.CqueryResult
	(*ParamFile)(nil),            // 11: analysis.ParamFile
	(*PathFragment)(nil),         // 12: analysis.PathFragment
	(*build.Target)(nil),         // 13: blaze_query.Target
}
var file_src_main_protobuf_analysis_v2_proto_depIdxs = []int32{
	1,  // 0: analysis.ActionGraphContainer.artifacts:type_name -> analysis.Artifact
	2,  // 1: analysis.ActionGraphContainer.actions:type_name -> analysis.Action
	3,  // 2: analysis.ActionGraphContainer.targets:type_name -> analysis.Target
	6,  // 3: analysis.ActionGraphContainer.dep_set_of_files:type_name -> analysis.DepSetOfFiles
	7,  // 4: analysis.ActionGraphContainer.configuration:type_name -> analysis.Configuration
	5,  // 5: analysis.ActionGraphContainer.aspect_descriptors:type_name -> analysis.AspectDescriptor
	4,  // 6: analysis.ActionGraphContainer.rule_classes:type_name -> analysis.RuleClass
	12, // 7: analysis.ActionGraphContainer.path_fragments:type_name -> analysis.PathFragment
	8,  // 8: analysis.Action.environment_variables:type_name -> analysis.KeyValuePair
	8,  // 9: analysis.Action.execution_info:type_name -> analysis.KeyValuePair
	11, // 10: analysis.Action.param_files:type_name -> analysis.ParamFile
	8,  // 11: analysis.Action.substitutions:type_name -> analysis.KeyValuePair
	8,  // 12: analysis.AspectDescriptor.parameters:type_name -> analysis.KeyValuePair
	13, // 13: analysis.ConfiguredTarget.target:type_name -> blaze_query.Target
	7,  // 14: analysis.ConfiguredTarget.configuration:type_name -> analysis.Configuration
	9,  // 15: analysis.CqueryResult.results:type_name -> analysis.ConfiguredTarget
	7,  // 16: analysis.CqueryResult.configurations:type_name -> analysis.Configuration
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_src_main_protobuf_analysis_v2_proto_init() }
func file_src_main_protobuf_analysis_v2_proto_init() {
	if File_src_main_protobuf_analysis_v2_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_src_main_protobuf_analysis_v2_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionGraphContainer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Artifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DepSetOfFiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Configuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValuePair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfiguredTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CqueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParamFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_src_main_protobuf_analysis_v2_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PathFragment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_src_main_protobuf_analysis_v2_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_src_main_protobuf_analysis_v2_proto_goTypes,
		DependencyIndexes: file_src_main_protobuf_analysis_v2_proto_depIdxs,
		MessageInfos:      file_src_main_protobuf_analysis_v2_proto_msgTypes,
	}.Build()
	File_src_main_protobuf_analysis_v2_proto = out.File
	file_src_main_protobuf_analysis_v2_proto_rawDesc = nil
	file_src_main_protobuf_analysis_v2_proto_goTypes = nil
	file_src_main_protobuf_analysis_v2_proto_depIdxs = nil
}
