% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNull.R
\name{checkNull}
\alias{checkNull}
\alias{check_null}
\alias{assertNull}
\alias{assert_null}
\alias{testNull}
\alias{test_null}
\title{Check if an argument is NULL}
\usage{
checkNull(x)

check_null(x)

assertNull(x, .var.name = vname(x), add = NULL)

assert_null(x, .var.name = vname(x), add = NULL)

testNull(x)

test_null(x)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertNull}/\code{assert_null} return 
 \code{x} invisibly, whereas
 \code{checkNull}/\code{check_null} and 
 \code{testNull}/\code{test_null} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertNull}/\code{assert_null}
 throws an error message, 
 \code{testNull}/\code{test_null}
 returns \code{FALSE},
 and \code{checkNull}/\code{check_null} 
 return a string with the error message.
 The function \code{expect_null} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is NULL
}
\examples{
testNull(NULL)
testNull(1)
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomic}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkInteger}()},
\code{\link{checkIntegerish}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}
}
\concept{basetypes}
