% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignettes.R
\name{build_vignettes}
\alias{build_vignettes}
\title{Build package vignettes.}
\usage{
build_vignettes(
  pkg = ".",
  dependencies = "VignetteBuilder",
  clean = TRUE,
  upgrade = "never",
  quiet = FALSE,
  install = TRUE,
  keep_md = TRUE
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).

The value "soft" means the same as \code{TRUE}, "hard" means the same as \code{NA}.

You can also specify dependencies from one or more additional fields,
common ones include:
\itemize{
\item Config/Needs/website - for dependencies used in building the pkgdown site.
\item Config/Needs/coverage for dependencies used in calculating test coverage.
}}

\item{clean}{Remove all files generated by the build, even if there
    were copies there before.}

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{quiet}{If \code{TRUE}, suppresses most output. Set to \code{FALSE}
if you need to debug.}

\item{install}{If \code{TRUE}, install the package before building
vignettes.}

\item{keep_md}{If \code{TRUE}, move md intermediates as well as rendered
outputs. Most useful when using the \code{keep_md} YAML option for Rmarkdown
outputs. See
\url{https://bookdown.org/yihui/rmarkdown/html-document.html#keeping-markdown}.}
}
\description{
Builds package vignettes using the same algorithm that \verb{R CMD build}
does. This means including non-Sweave vignettes, using makefiles (if
present), and copying over extra files. The files are copied in the 'doc'
directory and an vignette index is created in 'Meta/vignette.rds', as they
would be in a built package. 'doc' and 'Meta' are added to
\code{.Rbuildignore}, so will not be included in the built package. These
files can be checked into version control, so they can be viewed with
\code{browseVignettes()} and \code{vignette()} if the package has been
loaded with \code{load_all()} without needing to re-build them locally.
}
\seealso{
\code{\link[=clean_vignettes]{clean_vignettes()}} to remove the pdfs in
\file{doc} created from vignettes

\code{\link[=clean_vignettes]{clean_vignettes()}} to remove build tex/pdf files.
}
\keyword{programming}
