% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA.R
\docType{package}
\name{rle-package}
\alias{rle}
\alias{rle-package}
\title{rle: Common Functions for Run-Length Encoded Vectors}
\description{
Common \code{\link{base}} and \code{\link{stats}}
methods for \code{\link{rle}} objects, aiming to make it possible to treat
them transparently as vectors.
}
\section{History}{


This package grew out of the needs of the \code{ergm} package for a
run-length encoded representation of extremely long vectors with a
small number of contiguous runs, and these functions were originally
implemented in the \code{statnet.common} package.

It has been split out into its own package to enable others to use
this functionality without installing any unnecessary dependencies
and to facilitate contributions under a simplified license.
}

\section{What works and what doesn't}{


The long-run aim of this package is to make it possible to treat
\code{\link{rle}} objects transparently as unnamed vectors. As of this
writing, the biggest unimplemented feature are:
\itemize{
\item It is possible to use the indexing (\code{[} and \code{[[}) operators to
extract by positive numeric indices but not by logical or
negative numeric indices, and the implementation is far from
optimal. It is not possible to replace individual elements of the
vector represented by an \code{rle} object. See \link{Extract.rle} for more
details.
\item Method \code{\link{rep.rle}} currently has limited functionality.
}
}

\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/statnet/rle/issues}
}

}
\author{
\strong{Maintainer}: Pavel N. Krivitsky \email{pavel@statnet.org} (\href{https://orcid.org/0000-0002-9101-3362}{ORCID})

}
