# desktop-edit

A lossless parser and editor for .desktop files as specified by [freedesktop.org Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/).

This library preserves all whitespace, comments, and formatting while providing a structured way to read and modify .desktop files.

## Features

- **Lossless parsing**: All whitespace, comments, and formatting are preserved
- **FreeDesktop .desktop file support**: Full support for the freedesktop.org Desktop Entry specification
- **Locale support**: Handle localized keys like `Name[de]=...`

## Example

```rust
use desktop_edit::Desktop;
use std::str::FromStr;

# let input = r#"[Desktop Entry]
# Name=Example Application
# Type=Application
# Exec=example
# Icon=example.png
# "#;
# let desktop = Desktop::from_str(input).unwrap();
# assert_eq!(desktop.groups().count(), 1);
# let group = desktop.groups().nth(0).unwrap();
# assert_eq!(group.name(), Some("Desktop Entry".to_string()));
```

## License

Apache-2.0
