// AUTOGENERATED FROM index-big5.txt, ORIGINAL COMMENT FOLLOWS:
//
// Any copyright is dedicated to the Public Domain.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// For details on index index-big5.txt see the Encoding Standard
// https://encoding.spec.whatwg.org/
//
// Identifier: 8dfc771062e7be0810919082c2c06baa2236147909e0ecc235b1cb9ad782ac82
// Date: 2016-01-20

#[allow(dead_code)] const X: u16 = 0xffff;

const FORWARD_TABLE: &'static [u16] = &[
    17392, 19506, 17923, 17830, 17784, 29287, 19831, 17843, 31921, 19682,
    31941, 15253, 18230, 18244, 19527, 19520, 17087, 13847, 29522, 28299,
    28882, 19543, 41809, 18255, 17882, 19589, 31852, 19719, 19108, 18081,
    27427, 29221, 23124, 6755, 15878, 16225, 26189, 22267, X, 32149, 22813,
    35769, 15860, 38708, 31727, 23515, 7518, 23204, 13861, 40624, 23249, 23479,
    23804, 26478, 34195, 39237, 29793, 29853, 14453, 7507, 13982, 24609, 16108,
    22750, 15093, 31484, 40855, 16737, 35085, 12778, 2698, 12894, 17162, 33924,
    40854, 37935, 18736, 34323, 22678, 38730, 37400, 31184, 31282, 26208,
    27177, 34973, 29772, 31685, 26498, 31276, 21071, 36934, 13542, 29636,
    23993, 29894, 40903, 22451, 18735, 21580, 16689, 13966, 22552, 31346,
    31589, 35727, 18094, 28296, 16769, 23961, 31662, 9404, 40904, 9409, 9417,
    9420, 40905, 34052, 13755, 16564, 40906, 17633, 44543, 25281, 28782, 40907,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 12736, 12737, 12738, 12739, 12740, 268, 12741, 209, 205,
    12742, 12743, 203, 8168, 12744, 202, 12745, 12746, 12747, 12748, 270,
    12749, 12750, 256, 193, 461, 192, 274, 201, 282, 200, 332, 211, 465, 210,
    0, 7870, 1, 7872, 202, 257, 225, 462, 224, 593, 275, 233, 283, 232, 299,
    237, 464, 236, 333, 243, 466, 242, 363, 250, 468, 249, 470, 472, 474, 476,
    252, 2, 7871, 3, 7873, 234, 609, 9178, 9179, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    41897, 4421, X, 25866, X, X, 20029, 28381, 40270, 37343, X, X, 30517,
    25745, 20250, 20264, 20392, 20822, 20852, 20892, 20964, 21153, 21160,
    21307, 21326, 21457, 21464, 22242, 22768, 22788, 22791, 22834, 22836,
    23398, 23454, 23455, 23706, 24198, 24635, 25993, 26622, 26628, 26725,
    27982, 28860, 30005, 32420, 32428, 32442, 32455, 32463, 32479, 32518,
    32567, 33402, 33487, 33647, 35270, 35774, 35810, 36710, 36711, 36718,
    29713, 31996, 32205, 26950, 31433, 21031, X, X, X, X, 37260, 30904, 37214,
    32956, X, 36107, 33014, 2535, X, X, 32927, 40647, 19661, 40393, 40460,
    19518, 40438, 28686, 40458, 41267, 13761, X, 28314, 33342, 29977, X, 18705,
    39532, 39567, 40857, 31111, 33900, 7626, 1488, 10982, 20004, 20097, 20096,
    20103, 20159, 20203, 20279, 13388, 20413, 15944, 20483, 20616, 13437,
    13459, 13477, 20870, 22789, 20955, 20988, 20997, 20105, 21113, 21136,
    21287, 13767, 21417, 13649, 21424, 13651, 21442, 21539, 13677, 13682,
    13953, 21651, 21667, 21684, 21689, 21712, 21743, 21784, 21795, 21800,
    13720, 21823, 13733, 13759, 21975, 13765, 32132, 21797, X, 3138, 3349,
    20779, 21904, 11462, 14828, 833, 36422, 19896, 38117, 16467, 32958, 30586,
    11320, 14900, 18389, 33117, 27122, 19946, 25821, 3452, 4020, 3285, 4340,
    25741, 36478, 3734, 3083, 3940, 11433, 33366, 17619, X, 3398, 39501, 33001,
    18420, 20135, 11458, 39602, 14951, 38388, 16365, 13574, 21191, 38868,
    30920, 11588, 40302, 38933, X, 17369, 24741, 25780, 21731, 11596, 11210,
    4215, 14843, 4207, 26330, 26390, 31136, 25834, 20562, 3139, 36456, 8609,
    35660, 1841, X, 18443, 425, 16378, 22643, 11661, X, 17864, 1276, 24727,
    3916, 3478, 21881, 16571, 17338, X, 19124, 10854, 4253, 33194, 39157, 3484,
    25465, 14846, 10101, 36288, 22177, 25724, 15939, X, 42497, 3593, 10959,
    11465, X, 4296, 14786, 14738, 14854, 33435, 13688, 24137, 8391, 22098,
    3889, 11442, 38688, 13500, 27709, 20027, X, X, 30068, 11915, 8712, 42587,
    36045, 3706, 3124, 26652, 32659, 4303, 10243, 10553, 13819, 20963, 3724,
    3981, 3754, 16275, 3888, 3399, 4431, 3660, X, 3755, 2985, 3400, 4288, 4413,
    16377, 9878, 25650, 4013, 13300, 30265, 11214, 3454, 3455, 11345, 11349,
    14872, 3736, 4295, 3886, 42546, 27472, 36050, 36249, 36042, 38314, 21708,
    33476, 21945, X, 40643, 39974, 39606, 30558, 11758, 28992, 33133, 33004,
    23580, 25970, 33076, 14231, 21343, 32957, 37302, 3834, 3599, 3703, 3835,
    13789, 19947, 13833, 3286, 22191, 10165, 4297, 3600, 3704, 4216, 4424,
    33287, 5205, 3705, 20048, 11684, 23124, 4125, 4126, 4341, 4342, 22428,
    3601, 30356, 33485, 4021, 3707, 20862, 14083, 4022, 4480, 21208, 41661,
    18906, 6202, 16759, 33404, 22681, 21096, 13850, 22333, 31666, 23400, 18432,
    19244, 40743, 18919, 39967, 39821, 23412, 12605, 22011, 13810, 22153,
    20008, 22786, 7105, 63608, 38737, 134, 20059, 20155, 13630, 23587, 24401,
    24516, 14586, 25164, 25909, 27514, 27701, 27706, 28780, 29227, 20012,
    29357, 18665, 32594, 31035, 31993, 32595, 25194, 13505, X, 25419, 32770,
    32896, 26130, 26961, 21341, 34916, 35265, 30898, 35744, 36125, 38021,
    38264, 38271, 38376, 36367, 38886, 39029, 39118, 39134, 39267, 38928,
    40060, 40479, 40644, 27503, 63751, 20023, 135, 38429, 25143, 38050, X,
    20539, 28158, 40051, 40870, 15817, 34959, 16718, 28791, 23797, 19232,
    20941, 13657, 23856, 24866, 35378, 36775, 37366, 29073, 26393, 29626,
    12929, 41223, 15499, 6528, 19216, 30948, 29698, 20910, 34575, 16393, 27235,
    41658, 16931, 34319, 2671, 31274, 39239, 35562, 38741, 28749, 21284, 8318,
    37876, 30425, 35299, 40871, 30685, 20131, 20464, 20668, 20015, 20247,
    40872, 21556, 32139, 22674, 22736, 7606, 24210, 24217, 24514, 10002, 25995,
    13305, 26905, 27203, 15459, 27903, X, 29184, 17669, 29580, 16091, 18963,
    23317, 29881, 35715, 23716, 22165, 31379, 31724, 31939, 32364, 33528,
    34199, 40873, 34960, 40874, 36537, 40875, 36815, 34143, 39392, 37409,
    40876, 36281, 5183, 16497, 17058, 23066, X, X, X, 39016, 26475, 17014,
    22333, X, 34262, 18811, 33471, 28941, 19585, 28020, 23931, 27413, 28606,
    40877, 40878, 23446, 40879, 26343, 32347, 28247, 31178, 15752, 17603,
    12886, 10134, 17306, 17718, X, 23765, 15130, 35577, 23672, 15634, 13649,
    23928, 40882, 29015, 17752, 16620, 7715, 19575, 14712, 13386, 420, 27713,
    35532, 20404, 569, 22975, 33132, 38998, 39162, 24379, 2975, X, 8641, 35181,
    16642, 18107, 36985, 16135, 40883, 41397, 16632, 14294, 18167, 27718,
    16764, 34482, 29695, 17773, 14548, 21658, 17761, 17691, 19849, 19579,
    19830, 17898, 16328, 19215, 13921, 17630, 17597, 16877, 23870, 23880,
    23894, 15868, 14351, 23972, 23993, 14368, 14392, 24130, 24253, 24357,
    24451, 14600, 14612, 14655, 14669, 24791, 24893, 23781, 14729, 25015,
    25017, 25039, 14776, 25132, 25232, 25317, 25368, 14840, 22193, 14851,
    25570, 25595, 25607, 25690, 14923, 25792, 23829, 22049, 40863, 14999,
    25990, 15037, 26111, 26195, 15090, 26258, 15138, 26390, 15170, 26532,
    26624, 15192, 26698, 26756, 15218, 15217, 15227, 26889, 26947, 29276,
    26980, 27039, 27013, 15292, 27094, 15325, 27237, 27252, 27249, 27266,
    15340, 27289, 15346, 27307, 27317, 27348, 27382, 27521, 27585, 27626,
    27765, 27818, 15563, 27906, 27910, 27942, 28033, 15599, 28068, 28081,
    28181, 28184, 28201, 28294, 35264, 28347, 28386, 28378, 40831, 28392,
    28393, 28452, 28468, 15686, 16193, 28545, 28606, 15722, 15733, 29111,
    23705, 15754, 28716, 15761, 28752, 28756, 28783, 28799, 28809, 805, 17345,
    13809, 3800, 16087, 22462, 28371, 28990, 22496, 13902, 27042, 35817, 23412,
    31305, 22753, 38105, 31333, 31357, 22956, 31419, 31408, 31426, 31427,
    29137, 25741, 16842, 31450, 31453, 31466, 16879, 21682, 23553, 31499,
    31573, 31529, 21262, 23806, 31650, 31599, 33692, 23476, 27775, 31696,
    33825, 31634, 31672, 23840, 15789, 23653, 33938, 31738, 31750, 31797,
    23745, 31812, 31875, 18562, 31910, 26237, 17784, 31945, 31943, 31974,
    31860, 31987, 31989, 31950, 32359, 17693, 28228, 32093, 28374, 29837,
    32137, 32171, 28981, 32179, 32210, 16471, 24617, 32228, 15635, 32245, 6137,
    32229, 33645, 32285, 24865, 24922, 32366, 32402, 17195, 37996, 32295,
    32576, 32577, 32583, 31030, 25296, 39393, 32663, 25425, 32675, 5729, 104,
    17756, 14182, 17667, 33594, 32762, 25737, 32773, 32776, 32797, 32808,
    32815, 41095, 27843, 32827, 32828, 32865, 10004, 18825, 26150, 15843,
    26344, 26405, 32935, 35400, 33031, 33050, 22704, 9974, 27775, 25752, 20408,
    25831, 5258, 33304, 6238, 27219, 19045, 19093, 17530, 33321, 2829, 27218,
    15742, 20473, 5373, 34018, 33634, 27402, 18855, 13616, 6003, 15864, 33450,
    26907, 63892, 16859, 34123, 33488, 33562, 3606, 6068, 14017, 12669, 13658,
    33403, 33506, 33560, 16011, 28067, 27397, 27543, 13774, 15807, 33565,
    21996, 33669, 17675, 28069, 33708, 33729, 33747, 13438, 28372, 27223,
    34138, 13462, 28226, 12015, 33880, 23524, 33905, 15827, 17636, 27303,
    33866, 15541, 31064, 33960, 27542, 28279, 28227, 34014, 33807, 33681,
    17568, 33939, 34020, 23697, 16960, 23744, 17731, 34100, 23282, 28313,
    17703, 34163, 17686, 26559, 34326, 34341, 34363, 34241, 28808, 34306, 5506,
    28877, 63922, 17770, 34344, 13896, 6306, 21495, 29594, 34430, 34673, 41208,
    34798, 11303, 34737, 34778, 34831, 22113, 34412, 26710, 17935, 34885,
    34886, 30176, 15801, 30180, 34910, 34972, 18011, 34996, 34997, 25537,
    35013, 30583, 30479, 35207, 35210, 35238, 35241, 35239, 35260, 35365,
    35303, 31012, 31421, 35484, 30611, 37374, 35472, 31321, 31465, 31546,
    16271, 18195, 31544, 29052, 35596, 35615, 21552, 21861, 35647, 35660,
    35661, 35497, 19066, 35728, 35739, 35503, 5855, 17941, 34895, 35995, 32084,
    32143, 63956, 14117, 32083, 36054, 32152, 32189, 36114, 36099, 6416, 36059,
    28764, 36113, 19657, 16080, 36215, 36265, 32770, 4116, 18826, 15228, 33212,
    28940, 31463, 36525, 36534, 36547, 37588, 36633, 36653, 33637, 33810,
    36773, 37635, 41631, 2640, 36787, 18730, 35294, 34109, 15803, 24312, 12898,
    36857, 40980, 34492, 34049, 8997, 14720, 28375, 36919, 34108, 31422, 36961,
    34156, 34315, 37032, 34579, 37060, 34534, 37038, 37117, 37223, 15088,
    37289, 37316, 31916, 35123, 7817, 37390, 27807, 37441, 37474, 21945, 37561,
    35526, 15515, 35596, 21979, 3377, 37676, 37739, 35553, 35819, 28815, 23235,
    35554, 35557, 18789, 37444, 35820, 35897, 35839, 37747, 37979, 36540,
    38277, 38310, 37926, 38304, 28662, 17081, 9850, 34520, 4732, 15918, 18911,
    27676, 38523, 38550, 16748, 38563, 28373, 25050, 38582, 30965, 35552,
    38589, 21452, 18849, 27832, 628, 25616, 37039, 37093, 19153, 6421, 13066,
    38705, 34370, 38710, 18959, 17725, 17797, 19177, 28789, 23361, 38683,
    38748, 37333, 38743, 23370, 37355, 38751, 37925, 20688, 12471, 12476,
    38793, 38815, 38833, 38846, 38848, 38866, 38880, 21612, 38894, 29724,
    37939, 38911, 38901, 37917, 31098, 19153, 38964, 38963, 38987, 39014,
    15118, 29045, 15697, 1584, 16732, 22278, 39114, 39095, 39112, 39111, 19199,
    27943, 5843, 21936, 39137, 39142, 39148, 37752, 39225, 18985, 19314, 38999,
    39173, 39413, 39436, 39483, 39440, 39512, 22309, 14020, 37041, 39893,
    39648, 39650, 39685, 39668, 19470, 39700, 39725, 34304, 20532, 39732,
    27048, 14531, 12413, 39760, 39744, 40254, 23109, 6243, 39822, 16971, 39938,
    39935, 39948, 40552, 40404, 40887, 41362, 41387, 41185, 41251, 41439,
    40318, 40323, 41268, 40462, 26760, 40388, 8539, 41363, 41504, 6459, 41523,
    40249, 41145, 41652, 40592, 40597, 40606, 40610, 19764, 40618, 40623,
    17252, 40641, 15200, 14821, 15645, 20274, 14270, 35883, 40706, 40712,
    19350, 37924, 28066, 40727, 40726, 40761, 22175, 22154, 40773, 39352,
    37003, 38898, 33919, 40802, 40809, 31452, 40846, 29206, 19390, 18805,
    18875, 29047, 18936, 17224, 19025, 29598, 35802, 6394, 31135, 35198, 36406,
    37737, 37875, 35396, 37612, 37761, 37835, 35180, 17593, 29207, 16107,
    30578, 31299, 28880, 17523, 17400, 29054, 6127, 28835, 6334, 13721, 16071,
    6277, 21551, 6136, 14114, 5883, 6201, 14049, 6004, 6353, 24395, 14115,
    5824, 22363, 18981, 5118, 4776, 5062, 5302, 34051, 13990, 34051, 33877,
    18836, 29029, 15921, 21852, 16123, 28754, 17652, 14062, 39325, 28454,
    26617, 14131, 15381, 15847, 22636, 6434, 26640, 16471, 14143, 16609, 16523,
    16655, 27681, 21707, 22174, 26289, 22162, 4063, 2984, 3597, 37830, 35603,
    37788, 20216, 20779, 14361, 17462, 20156, 1125, 895, 20299, 20362, 22097,
    23144, 427, 971, 14745, 778, 1044, 13365, 20265, 704, 36531, 629, 35546,
    524, 20120, 20685, 20749, 20386, 20227, 18958, 16010, 20290, 20526, 20588,
    20609, 20428, 20453, 20568, 20732, 20825, 20827, 20829, 20830, 28278,
    13717, 15929, 16063, 28018, 6276, 16009, 20904, 20931, 1504, 17629, 1187,
    1170, 1169, 36218, 35484, 1806, 21081, 21156, 2163, 21217, 37742, 18042,
    29068, 17292, 3104, 18860, 4324, 27089, 3613, 29817, 16094, 29849, 29716,
    29782, 29592, 19342, 19132, 16525, 21456, 13700, 29199, 16585, 21940, 837,
    21709, 3014, 22301, 37469, 38644, 37734, 22493, 22413, 22399, 13886, 22731,
    23193, 35398, 5882, 5999, 5904, 23084, 22968, 37519, 23166, 23247, 23058,
    22854, 6643, 6241, 17045, 14069, 27909, 29763, 23073, 24195, 23169, 35799,
    1043, 37856, 29836, 4867, 28933, 18802, 37896, 35323, 37821, 14240, 23582,
    23710, 24158, 24136, 6550, 6524, 15086, 24269, 23375, 6403, 6404, 14081,
    6304, 14045, 5886, 14035, 33066, 35399, 7610, 13426, 35240, 24332, 24334,
    6439, 6059, 23147, 5947, 23364, 34324, 30205, 34912, 24702, 10336, 9771,
    24539, 16056, 9647, 9662, 37000, 28531, 25024, 62, 70, 9755, 24985, 24984,
    24693, 11419, 11527, 18132, 37197, 25713, 18021, 11114, 14889, 11042,
    13392, 39146, 11896, 25399, 42075, 25782, 25393, 25553, 18915, 11623,
    25252, 11425, 25659, 25963, 26994, 15348, 12430, 12973, 18825, 12971,
    21773, 13024, 6361, 37951, 26318, 12937, 12723, 15072, 16784, 21892, 35618,
    21903, 5884, 21851, 21541, 30958, 12547, 6186, 12852, 13412, 12815, 12674,
    17097, 26254, 27940, 26219, 19347, 26160, 30832, 7659, 26211, 13010, 13025,
    26142, 22642, 14545, 14394, 14268, 15257, 14242, 13310, 29904, 15254,
    26511, 17962, 26806, 26654, 15300, 27326, 14435, 14293, 17543, 27187,
    27218, 27337, 27397, 6418, 25873, 26776, 27212, 15319, 27258, 27479, 16320,
    15514, 37792, 37618, 35818, 35531, 37513, 32798, 35292, 37991, 28069,
    28427, 18924, 28007, 16255, 15759, 28164, 16444, 23101, 28170, 22599,
    27940, 30786, 28987, 17178, 17014, 28913, 29264, 29319, 29332, 18319,
    18213, 20857, 19108, 1515, 29818, 16120, 13919, 19018, 18711, 24545, 16134,
    16049, 19167, 35875, 16181, 24743, 16115, 29900, 29756, 37767, 29751,
    17567, 28138, 17745, 30083, 16227, 19673, 19718, 16216, 30037, 30323,
    42438, 15129, 29800, 35532, 18859, 18830, 15099, 15821, 19022, 16127,
    18885, 18675, 37370, 22322, 37698, 35555, 6244, 20703, 21025, 20967, 30584,
    12850, 30478, 30479, 30587, 18071, 14209, 14942, 18672, 29752, 29851,
    16063, 19130, 19143, 16584, 19094, 25006, 37639, 21889, 30750, 30861,
    30856, 30930, 29648, 31065, 30529, 22243, 16654, 31131, 33942, 31141,
    27181, 16122, 31290, 31220, 16750, 5862, 16690, 37429, 31217, 3404, 18828,
    665, 15802, 5998, 13719, 21867, 13680, 13994, 468, 3085, 31458, 23129,
    9973, 23215, 23196, 23053, 603, 30960, 23082, 23494, 31486, 16889, 31837,
    31853, 16913, 23475, 24252, 24230, 31949, 18937, 6064, 31886, 31868, 31918,
    27314, 32220, 32263, 32211, 32590, 25185, 24924, 31560, 32151, 24194,
    17002, 27509, 2326, 26582, 78, 13775, 22468, 25618, 25592, 18786, 32733,
    31527, 2092, 23273, 23875, 31500, 24078, 39398, 34373, 39523, 27164, 13375,
    14818, 18935, 26029, 39455, 26016, 33920, 28967, 27857, 17642, 33079,
    17410, 32966, 33033, 33090, 26548, 39107, 27202, 33378, 33381, 27217,
    33875, 28071, 34320, 29211, 23174, 16767, 6208, 23339, 6305, 23268, 6360,
    34464, 63932, 15759, 34861, 29730, 23042, 34926, 20293, 34951, 35007,
    35046, 35173, 35149, 22147, 35156, 30597, 30596, 35829, 35801, 35740,
    35321, 16045, 33955, 18165, 18127, 14322, 35389, 35356, 37960, 24397,
    37419, 17028, 26068, 28969, 28868, 6213, 40301, 35999, 36073, 32220, 22938,
    30659, 23024, 17262, 14036, 36394, 36519, 19465, 36656, 36682, 17140,
    27736, 28603, 8993, 18587, 28537, 28299, 6106, 39913, 14005, 18735, 37051,
    37015, 21873, 18694, 37307, 37892, 35403, 16482, 35580, 37927, 35869,
    35899, 34021, 35371, 38297, 38311, 38295, 38294, 36148, 29765, 16066,
    18687, 19010, 17386, 16103, 12837, 38543, 36583, 36454, 36453, 16076,
    18925, 19064, 16366, 29714, 29803, 16124, 38721, 37040, 26695, 18973,
    37011, 22495, 38749, 37736, 35209, 35878, 35631, 25534, 37562, 23313,
    35689, 18748, 29689, 16923, 38811, 38769, 39224, 3878, 24001, 35781, 19122,
    38943, 38106, 37622, 38359, 37349, 17600, 35664, 19047, 35684, 39132,
    35397, 16128, 37418, 18725, 33812, 39227, 39245, 31494, 15869, 39323,
    19311, 39338, 39516, 35685, 22728, 27279, 39457, 23294, 39471, 39153,
    19344, 39240, 39356, 19389, 19351, 37757, 22642, 4866, 22562, 18872, 5352,
    30788, 10015, 15800, 26821, 15741, 37976, 14631, 24912, 10113, 10603,
    24839, 40015, 40019, 40059, 39989, 39952, 39807, 39887, 40493, 39839,
    41461, 41214, 40225, 19630, 16644, 40472, 19632, 40204, 41396, 41197,
    41203, 39215, 40357, 33981, 28178, 28639, 27522, 34300, 17715, 28068,
    28292, 28144, 33824, 34286, 28160, 14295, 24676, 31202, 13724, 13888,
    18733, 18910, 15714, 37851, 37566, 37704, 703, 30905, 37495, 37965, 20452,
    13376, 36964, 21853, 30781, 30804, 30902, 30795, 5975, 12745, 18753, 13978,
    20338, 28634, 28633, 28702, 28702, 21524, 16821, 22459, 22771, 22410,
    40214, 22487, 28980, 13487, 16812, 29163, 27712, 20375, 23336, 6069, 35401,
    24844, 23246, 23051, 17084, 17544, 14124, 19323, 35324, 37819, 37816, 6358,
    3869, 33906, 27840, 5139, 17146, 11302, 17345, 22932, 15799, 26433, 32168,
    24923, 24740, 18873, 18827, 35322, 37605, 29666, 16105, 29876, 35683, 6303,
    16097, 19123, 27352, 29683, 29691, 16086, 19006, 19092, 6105, 19046, 935,
    5156, 18917, 29768, 18710, 28837, 18806, 37508, 29670, 37727, 1278, 37681,
    35534, 35350, 37766, 35815, 21973, 18741, 35458, 29035, 18755, 3327, 22180,
    1562, 3051, 3256, 21762, 31172, 6138, 32254, 5826, 19024, 6226, 17710,
    37889, 14090, 35520, 18861, 22960, 6335, 6275, 29828, 23201, 14050, 15707,
    14000, 37471, 23161, 35457, 6242, 37748, 15565, 2740, 19094, 14730, 20724,
    15721, 15692, 5020, 29045, 17147, 33304, 28175, 37092, 17643, 27991, 32335,
    28775, 27823, 15574, 16365, 15917, 28162, 28428, 15727, 1013, 30033, 14012,
    13512, 18048, 16090, 18545, 22980, 37486, 18750, 36673, 35868, 27584,
    22546, 22472, 14038, 5202, 28926, 17250, 19057, 12259, 4784, 9149, 26809,
    26983, 5016, 13541, 31732, 14047, 35459, 14294, 13306, 19615, 27162, 13997,
    27831, 33854, 17631, 17614, 27942, 27985, 27778, 28638, 28439, 28937,
    33597, 5946, 33773, 27776, 28755, 6107, 22921, 23170, 6067, 23137, 23153,
    6405, 16892, 14125, 23023, 5948, 14023, 29070, 37776, 26266, 17061, 23150,
    23083, 17043, 27179, 16121, 30518, 17499, 17098, 28957, 16985, 35297,
    20400, 27944, 23746, 17614, 32333, 17341, 27148, 16982, 4868, 28838, 28979,
    17385, 15781, 27871, 63525, 19023, 32357, 23019, 23855, 15859, 24412,
    19037, 6111, 32164, 33830, 21637, 15098, 13056, 532, 22398, 2261, 1561,
    16357, 8094, 41654, 28675, 37211, 23920, 29583, 31955, 35417, 37920, 20424,
    32743, 29389, 29456, 31476, 29496, 29497, 22262, 29505, 29512, 16041,
    31512, 36972, 29173, 18674, 29665, 33270, 16074, 30476, 16081, 27810,
    22269, 29721, 29726, 29727, 16098, 16112, 16116, 16122, 29907, 16142,
    16211, 30018, 30061, 30066, 30093, 16252, 30152, 30172, 16320, 30285,
    16343, 30324, 16348, 30330, 20316, 29064, 22051, 35200, 22633, 16413,
    30531, 16441, 26465, 16453, 13787, 30616, 16490, 16495, 23646, 30654,
    30667, 22770, 30744, 28857, 30748, 16552, 30777, 30791, 30801, 30822,
    33864, 21813, 31027, 26627, 31026, 16643, 16649, 31121, 31129, 36795,
    31238, 36796, 16743, 31377, 16818, 31420, 33401, 16836, 31439, 31451,
    16847, 20001, 31586, 31596, 31611, 31762, 31771, 16992, 17018, 31867,
    31900, 17036, 31928, 17044, 31981, 36755, 28864, 3279, 32207, 32212, 32208,
    32253, 32686, 32692, 29343, 17303, 32800, 32805, 31545, 32814, 32817,
    32852, 15820, 22452, 28832, 32951, 33001, 17389, 33036, 29482, 33038,
    33042, 30048, 33044, 17409, 15161, 33110, 33113, 33114, 17427, 22586,
    33148, 33156, 17445, 33171, 17453, 33189, 22511, 33217, 33252, 33364,
    17551, 33446, 33398, 33482, 33496, 33535, 17584, 33623, 38505, 27018,
    33797, 28917, 33892, 24803, 33928, 17668, 33982, 34017, 34040, 34064,
    34104, 34130, 17723, 34159, 34160, 34272, 17783, 34418, 34450, 34482,
    34543, 38469, 34699, 17926, 17943, 34990, 35071, 35108, 35143, 35217,
    31079, 35369, 35384, 35476, 35508, 35921, 36052, 36082, 36124, 18328,
    22623, 36291, 18413, 20206, 36410, 21976, 22356, 36465, 22005, 36528,
    18487, 36558, 36578, 36580, 36589, 36594, 36791, 36801, 36810, 36812,
    36915, 39364, 18605, 39136, 37395, 18718, 37416, 37464, 37483, 37553,
    37550, 37567, 37603, 37611, 37619, 37620, 37629, 37699, 37764, 37805,
    18757, 18769, 40639, 37911, 21249, 37917, 37933, 37950, 18794, 37972,
    38009, 38189, 38306, 18855, 38388, 38451, 18917, 26528, 18980, 38720,
    18997, 38834, 38850, 22100, 19172, 24808, 39097, 19225, 39153, 22596,
    39182, 39193, 20916, 39196, 39223, 39234, 39261, 39266, 19312, 39365,
    19357, 39484, 39695, 31363, 39785, 39809, 39901, 39921, 39924, 19565,
    39968, 14191, 7106, 40265, 39994, 40702, 22096, 40339, 40381, 40384, 40444,
    38134, 36790, 40571, 40620, 40625, 40637, 40646, 38108, 40674, 40689,
    40696, 31432, 40772, 148, 695, 928, 26906, 38083, 22956, 1239, 22592,
    38081, 14265, 1493, 1557, 1654, 5818, 22359, 29043, 2754, 2765, 3007,
    21610, 63547, 3019, 21662, 3067, 3131, 3155, 3173, 3196, 24807, 3213,
    22138, 3253, 3293, 3309, 3439, 3506, 3528, 26965, 39983, 34725, 3588, 3598,
    3799, 3984, 3885, 3699, 23584, 4028, 24075, 4188, 4175, 4214, 26398, 4219,
    4232, 4246, 13895, 4287, 4307, 4399, 4411, 21348, 33965, 4835, 4981, 4918,
    35713, 5495, 5657, 6083, 6087, 20088, 28859, 6189, 6506, 6701, 6725, 7210,
    7280, 7340, 7880, 25283, 7893, 7957, 29080, 26709, 8261, 27113, 14024,
    8828, 9175, 9210, 10026, 10353, 10575, 33533, 10599, 10643, 10965, 35237,
    10984, 36768, 11022, 38840, 11071, 38983, 39613, 11340, X, 11400, 11447,
    23528, 11528, 11538, 11703, 11669, 11842, 12148, 12236, 12339, 12390,
    13087, 13278, 24497, 26184, 26303, 31353, 13671, 13811, 29185, 18874,
    30679, 13850, 14102, 32391, 838, 22709, 26382, 26904, 15015, 30295, 24546,
    15889, 16057, 30206, 8346, 18640, 19128, 16665, 35482, 17134, 17165, 16443,
    17204, 17302, 19013, 1482, 20946, 1553, 22943, 7848, 15294, 15615, 17412,
    17622, 22408, 18036, 14747, 18223, 34280, 39369, 14178, 8643, 35678, 35662,
    39382, 18450, 18683, 18965, 29193, 19136, 3192, 22885, 20133, 20358, 1913,
    36570, 20524, 21135, 22335, 29041, 21145, 21529, 16202, 19111, 21948,
    21574, 21614, 27474, 37332, 13427, 21823, 30258, 21854, 18200, 21858,
    21862, 22471, 18751, 22621, 20582, 13563, 13260, 24798, 22787, 18300,
    35144, 23214, 23433, 23558, 7568, 22433, 29009, 28598, 24834, 31762, 36950,
    25010, 20378, 35682, 25602, 25674, 23899, 27639, 36662, 25732, 6428, 35562,
    18934, 25736, 16367, 25874, 19392, 26047, 26293, 10011, 37989, 22497,
    24981, 23079, 63693, 20411, 22201, 17697, 26364, 20074, 18740, 38486,
    28047, 27837, 13848, 35191, 26521, 26734, 25617, 26718, 29151, 26823,
    31554, 37056, 2577, 26918, 37124, 26937, 31301, 40432, 27130, 39462, 27181,
    13919, 25705, 33, 31107, 27188, 27483, 23852, 13593, 33743, 27549, 18128,
    27812, 30011, 34917, 28078, 22710, 14108, 9613, 28747, 29133, 15444, 29312,
    29317, 37505, 8570, 29323, 37680, 29414, 18896, 27705, 38047, 29776, 3832,
    34855, 35061, 10534, 33907, 6065, 28344, 18986, 6176, 14756, 14009, 23568,
    31203, 17727, 26294, 40109, 39076, 35139, 30668, 30808, 22230, 16607, 5642,
    14753, 14127, 33000, 5061, 29101, 33638, 31197, 37288, 23143, 19639, 28847,
    35243, 31229, 31242, 31499, 32102, 16762, 31555, 31102, 32777, 28597,
    41695, 27139, 33560, 21410, 28167, 37823, 26678, 38749, 33135, 32803,
    27061, 5101, 12847, 32840, 23941, 35888, 32899, 22293, 38947, 35145, 23979,
    18824, 26046, 27093, 21458, 19109, 16257, 15377, 26422, 32912, 33012,
    33070, 8097, 33103, 33161, 33199, 33306, 33542, 33583, 33674, 13770, 33896,
    34474, 18682, 25574, 35158, 30728, 37461, 35256, 17394, 35303, 17375,
    35304, 35654, 35796, 23032, 35849, 36619, 36805, 37100, 31569, 37136,
    37180, 15863, 37214, 19146, 36816, 29327, 22155, 38119, 38377, 38320,
    38328, 38706, 39121, 39241, 39274, 39363, 39464, 39694, 40282, 40347,
    32415, 40696, 40739, 19620, 38215, 41619, 29090, 41727, 19857, 36882,
    42443, 19868, 3228, 36798, 21953, 36794, 9392, 36793, 19091, 17673, 32383,
    28502, 27313, 20202, 13540, 35628, 30877, 14138, 36480, 6133, 32804, 35692,
    35737, 31294, 26287, 15851, 30293, 15543, 22069, 22870, 20122, 24193,
    25176, 22207, 3693, 36366, 23405, 16008, 19614, 25566, 25296, 6134, 6267,
    25904, 22061, 23626, 21530, 21265, 15814, 40344, 19581, 22050, 22046,
    32585, 24280, 22901, 15680, 34672, 19996, 4074, 3401, 14010, 33047, 40286,
    36120, 30267, 40005, 30286, 30649, 37701, 21554, 33096, 33527, 22053,
    33074, 33816, 32957, 21994, 31074, 22083, 21526, 3741, 13774, 22021, 22001,
    26353, 33506, 13869, 30004, 22000, 21946, 21655, 21874, 3137, 3222, 24272,
    20808, 3702, 11362, 3746, 40619, 32090, 21982, 4213, 25245, 38765, 21652,
    36045, 29174, 37238, 25596, 25529, 25598, 21865, 11075, 40050, 11955,
    20890, 13535, 3495, 20903, 21581, 21790, 21779, 30310, 36397, 26762, 30129,
    32950, 34820, 34694, 35015, 33206, 33820, 4289, 17644, 29444, 18182, 23440,
    33547, 26771, 22139, 9972, 32047, 16803, 32115, 28368, 29366, 37232, 4569,
    37384, 15612, 42665, 3756, 3833, 29286, 7330, 18254, 20418, 32761, 4075,
    16634, 40029, 25887, 11680, 18675, 18400, 40316, 4076, 3594, 24674, 30115,
    4077, X, 24648, 4487, 29091, 32398, 40272, 19994, 19972, 13687, 23309,
    27826, 21351, 13996, 14812, 21373, 13989, 17944, 22682, 19310, 33325,
    21579, 22442, 23189, 2425, X, 14930, 9317, 29556, 40620, 19721, 39917,
    15614, 40752, 19547, 20393, 38302, 40926, 33884, 15798, 29362, 26547,
    14112, 25390, 32037, 16119, 15916, 14890, 36872, 21196, 15988, 13946,
    17897, 1166, 30272, 23280, 3766, 30842, 32558, 22695, 16575, 22140, 39819,
    23924, 30292, 42036, 40581, 19681, 30201, 14331, 24857, 12506, 17394, X,
    22109, 4777, 22439, 18787, 40454, 21044, 28846, 13741, 27722, 40316, 31830,
    39737, 22494, 5996, 23635, 25811, 38096, 25397, 29028, 34477, 3368, 27938,
    19170, 3441, X, 20990, 7951, 23950, 38659, 7633, 40577, 36940, 31519,
    39682, 23761, 31651, 25192, 25397, 39679, 31695, 39722, 31870, 39726,
    31810, 31878, 39957, 31740, 39689, 40727, 39963, 18750, 40794, 21875,
    23491, 20477, 40600, 20466, 21088, 15878, 21201, 22375, 20566, 22967,
    24082, 38856, 40363, 36700, 21609, 38836, 39232, 38842, 21292, 24880,
    26924, 21466, 39946, 40194, 19515, 38465, 27008, 20646, 30022, 5997, 39386,
    21107, X, 37209, 38529, 37212, X, 37201, 36503, 25471, 27939, 27338, 22033,
    37262, 30074, 25221, 1020, 29519, 31856, 23585, 15613, X, 18713, 30422,
    39837, 20010, 3284, 33726, 34882, X, 23626, 27072, 20717, 22394, 21023,
    24053, 20174, 27697, 498, 20281, 21660, 21722, 21146, 36226, 13822, 24332,
    13811, X, 27474, 37244, 40869, 39831, 38958, 39092, 39610, 40616, 40580,
    29050, 31508, X, 27642, 34840, 32632, X, 22048, 42570, 36471, 40787, X,
    36308, 36431, 40476, 36353, 25218, 33661, 36392, 36469, 31443, 19063,
    31294, 30936, 27882, 35431, 30215, 35418, 40742, 27854, 34774, 30147,
    41650, 30803, 63552, 36108, 29410, 29553, 35629, 29442, 29937, 36075,
    19131, 34351, 24506, 34976, 17591, X, 6203, 28165, X, 35454, 9499, X,
    24829, 30311, 39639, 40260, 37742, 39823, 34805, X, 34831, 36087, 29484,
    38689, 39856, 13782, 29362, 19463, 31825, 39242, 24921, 24921, 19460,
    40598, 24957, X, 22367, 24943, 25254, 25145, 25294, 14940, 25058, 21418,
    13301, 25444, 26626, 13778, 23895, 35778, 36826, 36409, X, 20697, 7494,
    30982, 21298, 38456, 3899, 16485, X, 30718, X, 31938, 24346, 31962, 31277,
    32870, 32867, 32077, 29957, 29938, 35220, 33306, 26380, 32866, 29830,
    32859, 29936, 33027, 30500, 35209, 26572, 30035, 28369, 34729, 34766,
    33224, 34700, 35401, 36013, 35651, 30507, 29944, 34010, 13877, 27058,
    36262, X, 35241, 29800, 28089, 34753, 16401, 29927, 15835, 29046, 24740,
    24988, 15569, 29026, 24695, X, 32625, 35629, 29264, 24809, 19326, 21024,
    15384, 15559, 24279, 30294, 21809, 6468, 4862, 39171, 28124, 28845, 23745,
    25005, 35343, 13943, 238, 26694, 20238, 17762, 23327, 25420, 40784, 40614,
    25195, 12288, 65292, 12289, 12290, 65294, 8231, 65307, 65306, 65311, 65281,
    65072, 8230, 8229, 65104, 65105, 65106, 183, 65108, 65109, 65110, 65111,
    65372, 8211, 65073, 8212, 65075, 9588, 65076, 65103, 65288, 65289, 65077,
    65078, 65371, 65373, 65079, 65080, 12308, 12309, 65081, 65082, 12304,
    12305, 65083, 65084, 12298, 12299, 65085, 65086, 12296, 12297, 65087,
    65088, 12300, 12301, 65089, 65090, 12302, 12303, 65091, 65092, 65113,
    65114, 65115, 65116, 65117, 65118, 8216, 8217, 8220, 8221, 12317, 12318,
    8245, 8242, 65283, 65286, 65290, 8251, 167, 12291, 9675, 9679, 9651, 9650,
    9678, 9734, 9733, 9671, 9670, 9633, 9632, 9661, 9660, 12963, 8453, 175,
    65507, 65343, 717, 65097, 65098, 65101, 65102, 65099, 65100, 65119, 65120,
    65121, 65291, 65293, 215, 247, 177, 8730, 65308, 65310, 65309, 8806, 8807,
    8800, 8734, 8786, 8801, 65122, 65123, 65124, 65125, 65126, 65374, 8745,
    8746, 8869, 8736, 8735, 8895, 13266, 13265, 8747, 8750, 8757, 8756, 9792,
    9794, 8853, 8857, 8593, 8595, 8592, 8594, 8598, 8599, 8601, 8600, 8741,
    8739, 65295, 65340, 8725, 65128, 65284, 65509, 12306, 65504, 65505, 65285,
    65312, 8451, 8457, 65129, 65130, 65131, 13269, 13212, 13213, 13214, 13262,
    13217, 13198, 13199, 13252, 176, 20825, 20827, 20830, 20829, 20833, 20835,
    21991, 29929, 31950, 9601, 9602, 9603, 9604, 9605, 9606, 9607, 9608, 9615,
    9614, 9613, 9612, 9611, 9610, 9609, 9532, 9524, 9516, 9508, 9500, 9620,
    9472, 9474, 9621, 9484, 9488, 9492, 9496, 9581, 9582, 9584, 9583, 9552,
    9566, 9578, 9569, 9698, 9699, 9701, 9700, 9585, 9586, 9587, 65296, 65297,
    65298, 65299, 65300, 65301, 65302, 65303, 65304, 65305, 8544, 8545, 8546,
    8547, 8548, 8549, 8550, 8551, 8552, 8553, 12321, 12322, 12323, 12324,
    12325, 12326, 12327, 12328, 12329, 21313, 21316, 21317, 65313, 65314,
    65315, 65316, 65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324,
    65325, 65326, 65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334,
    65335, 65336, 65337, 65338, 65345, 65346, 65347, 65348, 65349, 65350,
    65351, 65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360,
    65361, 65362, 65363, 65364, 65365, 65366, 65367, 65368, 65369, 65370, 913,
    914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928,
    929, 931, 932, 933, 934, 935, 936, 937, 945, 946, 947, 948, 949, 950, 951,
    952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 964, 965, 966, 967,
    968, 969, 12549, 12550, 12551, 12552, 12553, 12554, 12555, 12556, 12557,
    12558, 12559, 12560, 12561, 12562, 12563, 12564, 12565, 12566, 12567,
    12568, 12569, 12570, 12571, 12572, 12573, 12574, 12575, 12576, 12577,
    12578, 12579, 12580, 12581, 12582, 12583, 12584, 12585, 729, 713, 714, 711,
    715, 9216, 9217, 9218, 9219, 9220, 9221, 9222, 9223, 9224, 9225, 9226,
    9227, 9228, 9229, 9230, 9231, 9232, 9233, 9234, 9235, 9236, 9237, 9238,
    9239, 9240, 9241, 9242, 9243, 9244, 9245, 9246, 9247, 9249, 8364, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 19968, 20057, 19969, 19971, 20035, 20061, 20102, 20108, 20154, 20799,
    20837, 20843, 20960, 20992, 20993, 21147, 21269, 21313, 21340, 21448,
    19977, 19979, 19976, 19978, 20011, 20024, 20961, 20037, 20040, 20063,
    20062, 20110, 20129, 20800, 20995, 21242, 21315, 21449, 21475, 22303,
    22763, 22805, 22823, 22899, 23376, 23377, 23379, 23544, 23567, 23586,
    23608, 23665, 24029, 24037, 24049, 24050, 24051, 24062, 24178, 24318,
    24331, 24339, 25165, 19985, 19984, 19981, 20013, 20016, 20025, 20043,
    23609, 20104, 20113, 20117, 20114, 20116, 20130, 20161, 20160, 20163,
    20166, 20167, 20173, 20170, 20171, 20164, 20803, 20801, 20839, 20845,
    20846, 20844, 20887, 20982, 20998, 20999, 21000, 21243, 21246, 21247,
    21270, 21305, 21320, 21319, 21317, 21342, 21380, 21451, 21450, 21453,
    22764, 22825, 22827, 22826, 22829, 23380, 23569, 23588, 23610, 23663,
    24052, 24187, 24319, 24340, 24341, 24515, 25096, 25142, 25163, 25166,
    25903, 25991, 26007, 26020, 26041, 26085, 26352, 26376, 26408, 27424,
    27490, 27513, 27595, 27604, 27611, 27663, 27700, 28779, 29226, 29238,
    29243, 29255, 29273, 29275, 29356, 29579, 19993, 19990, 19989, 19988,
    19992, 20027, 20045, 20047, 20046, 20197, 20184, 20180, 20181, 20182,
    20183, 20195, 20196, 20185, 20190, 20805, 20804, 20873, 20874, 20908,
    20985, 20986, 20984, 21002, 21152, 21151, 21253, 21254, 21271, 21277,
    20191, 21322, 21321, 21345, 21344, 21359, 21358, 21435, 21487, 21476,
    21491, 21484, 21486, 21481, 21480, 21500, 21496, 21493, 21483, 21478,
    21482, 21490, 21489, 21488, 21477, 21485, 21499, 22235, 22234, 22806,
    22830, 22833, 22900, 22902, 23381, 23427, 23612, 24040, 24039, 24038,
    24066, 24067, 24179, 24188, 24321, 24344, 24343, 24517, 25098, 25171,
    25172, 25170, 25169, 26021, 26086, 26414, 26412, 26410, 26411, 26413,
    27491, 27597, 27665, 27664, 27704, 27713, 27712, 27710, 29359, 29572,
    29577, 29916, 29926, 29976, 29983, 29992, 29993, 30000, 30001, 30002,
    30003, 30091, 30333, 30382, 30399, 30446, 30683, 30690, 30707, 31034,
    31166, 31348, 31435, 19998, 19999, 20050, 20051, 20073, 20121, 20132,
    20134, 20133, 20223, 20233, 20249, 20234, 20245, 20237, 20240, 20241,
    20239, 20210, 20214, 20219, 20208, 20211, 20221, 20225, 20235, 20809,
    20807, 20806, 20808, 20840, 20849, 20877, 20912, 21015, 21009, 21010,
    21006, 21014, 21155, 21256, 21281, 21280, 21360, 21361, 21513, 21519,
    21516, 21514, 21520, 21505, 21515, 21508, 21521, 21517, 21512, 21507,
    21518, 21510, 21522, 22240, 22238, 22237, 22323, 22320, 22312, 22317,
    22316, 22319, 22313, 22809, 22810, 22839, 22840, 22916, 22904, 22915,
    22909, 22905, 22914, 22913, 23383, 23384, 23431, 23432, 23429, 23433,
    23546, 23574, 23673, 24030, 24070, 24182, 24180, 24335, 24347, 24537,
    24534, 25102, 25100, 25101, 25104, 25187, 25179, 25176, 25910, 26089,
    26088, 26092, 26093, 26354, 26355, 26377, 26429, 26420, 26417, 26421,
    27425, 27492, 27515, 27670, 27741, 27735, 27737, 27743, 27744, 27728,
    27733, 27745, 27739, 27725, 27726, 28784, 29279, 29277, 30334, 31481,
    31859, 31992, 32566, 32650, 32701, 32769, 32771, 32780, 32786, 32819,
    32895, 32905, 32907, 32908, 33251, 33258, 33267, 33276, 33292, 33307,
    33311, 33390, 33394, 33406, 34411, 34880, 34892, 34915, 35199, 38433,
    20018, 20136, 20301, 20303, 20295, 20311, 20318, 20276, 20315, 20309,
    20272, 20304, 20305, 20285, 20282, 20280, 20291, 20308, 20284, 20294,
    20323, 20316, 20320, 20271, 20302, 20278, 20313, 20317, 20296, 20314,
    20812, 20811, 20813, 20853, 20918, 20919, 21029, 21028, 21033, 21034,
    21032, 21163, 21161, 21162, 21164, 21283, 21363, 21365, 21533, 21549,
    21534, 21566, 21542, 21582, 21543, 21574, 21571, 21555, 21576, 21570,
    21531, 21545, 21578, 21561, 21563, 21560, 21550, 21557, 21558, 21536,
    21564, 21568, 21553, 21547, 21535, 21548, 22250, 22256, 22244, 22251,
    22346, 22353, 22336, 22349, 22343, 22350, 22334, 22352, 22351, 22331,
    22767, 22846, 22941, 22930, 22952, 22942, 22947, 22937, 22934, 22925,
    22948, 22931, 22922, 22949, 23389, 23388, 23386, 23387, 23436, 23435,
    23439, 23596, 23616, 23617, 23615, 23614, 23696, 23697, 23700, 23692,
    24043, 24076, 24207, 24199, 24202, 24311, 24324, 24351, 24420, 24418,
    24439, 24441, 24536, 24524, 24535, 24525, 24561, 24555, 24568, 24554,
    25106, 25105, 25220, 25239, 25238, 25216, 25206, 25225, 25197, 25226,
    25212, 25214, 25209, 25203, 25234, 25199, 25240, 25198, 25237, 25235,
    25233, 25222, 25913, 25915, 25912, 26097, 26356, 26463, 26446, 26447,
    26448, 26449, 26460, 26454, 26462, 26441, 26438, 26464, 26451, 26455,
    27493, 27599, 27714, 27742, 27801, 27777, 27784, 27785, 27781, 27803,
    27754, 27770, 27792, 27760, 27788, 27752, 27798, 27794, 27773, 27779,
    27762, 27774, 27764, 27782, 27766, 27789, 27796, 27800, 27778, 28790,
    28796, 28797, 28792, 29282, 29281, 29280, 29380, 29378, 29590, 29996,
    29995, 30007, 30008, 30338, 30447, 30691, 31169, 31168, 31167, 31350,
    31995, 32597, 32918, 32915, 32925, 32920, 32923, 32922, 32946, 33391,
    33426, 33419, 33421, 35211, 35282, 35328, 35895, 35910, 35925, 35997,
    36196, 36208, 36275, 36523, 36554, 36763, 36784, 36802, 36806, 36805,
    36804, 24033, 37009, 37026, 37034, 37030, 37027, 37193, 37318, 37324,
    38450, 38446, 38449, 38442, 38444, 20006, 20054, 20083, 20107, 20123,
    20126, 20139, 20140, 20335, 20381, 20365, 20339, 20351, 20332, 20379,
    20363, 20358, 20355, 20336, 20341, 20360, 20329, 20347, 20374, 20350,
    20367, 20369, 20346, 20820, 20818, 20821, 20841, 20855, 20854, 20856,
    20925, 20989, 21051, 21048, 21047, 21050, 21040, 21038, 21046, 21057,
    21182, 21179, 21330, 21332, 21331, 21329, 21350, 21367, 21368, 21369,
    21462, 21460, 21463, 21619, 21621, 21654, 21624, 21653, 21632, 21627,
    21623, 21636, 21650, 21638, 21628, 21648, 21617, 21622, 21644, 21658,
    21602, 21608, 21643, 21629, 21646, 22266, 22403, 22391, 22378, 22377,
    22369, 22374, 22372, 22396, 22812, 22857, 22855, 22856, 22852, 22868,
    22974, 22971, 22996, 22969, 22958, 22993, 22982, 22992, 22989, 22987,
    22995, 22986, 22959, 22963, 22994, 22981, 23391, 23396, 23395, 23447,
    23450, 23448, 23452, 23449, 23451, 23578, 23624, 23621, 23622, 23735,
    23713, 23736, 23721, 23723, 23729, 23731, 24088, 24090, 24086, 24085,
    24091, 24081, 24184, 24218, 24215, 24220, 24213, 24214, 24310, 24358,
    24359, 24361, 24448, 24449, 24447, 24444, 24541, 24544, 24573, 24565,
    24575, 24591, 24596, 24623, 24629, 24598, 24618, 24597, 24609, 24615,
    24617, 24619, 24603, 25110, 25109, 25151, 25150, 25152, 25215, 25289,
    25292, 25284, 25279, 25282, 25273, 25298, 25307, 25259, 25299, 25300,
    25291, 25288, 25256, 25277, 25276, 25296, 25305, 25287, 25293, 25269,
    25306, 25265, 25304, 25302, 25303, 25286, 25260, 25294, 25918, 26023,
    26044, 26106, 26132, 26131, 26124, 26118, 26114, 26126, 26112, 26127,
    26133, 26122, 26119, 26381, 26379, 26477, 26507, 26517, 26481, 26524,
    26483, 26487, 26503, 26525, 26519, 26479, 26480, 26495, 26505, 26494,
    26512, 26485, 26522, 26515, 26492, 26474, 26482, 27427, 27494, 27495,
    27519, 27667, 27675, 27875, 27880, 27891, 27825, 27852, 27877, 27827,
    27837, 27838, 27836, 27874, 27819, 27861, 27859, 27832, 27844, 27833,
    27841, 27822, 27863, 27845, 27889, 27839, 27835, 27873, 27867, 27850,
    27820, 27887, 27868, 27862, 27872, 28821, 28814, 28818, 28810, 28825,
    29228, 29229, 29240, 29256, 29287, 29289, 29376, 29390, 29401, 29399,
    29392, 29609, 29608, 29599, 29611, 29605, 30013, 30109, 30105, 30106,
    30340, 30402, 30450, 30452, 30693, 30717, 31038, 31040, 31041, 31177,
    31176, 31354, 31353, 31482, 31998, 32596, 32652, 32651, 32773, 32954,
    32933, 32930, 32945, 32929, 32939, 32937, 32948, 32938, 32943, 33253,
    33278, 33293, 33459, 33437, 33433, 33453, 33469, 33439, 33465, 33457,
    33452, 33445, 33455, 33464, 33443, 33456, 33470, 33463, 34382, 34417,
    21021, 34920, 36555, 36814, 36820, 36817, 37045, 37048, 37041, 37046,
    37319, 37329, 38263, 38272, 38428, 38464, 38463, 38459, 38468, 38466,
    38585, 38632, 38738, 38750, 20127, 20141, 20142, 20449, 20405, 20399,
    20415, 20448, 20433, 20431, 20445, 20419, 20406, 20440, 20447, 20426,
    20439, 20398, 20432, 20420, 20418, 20442, 20430, 20446, 20407, 20823,
    20882, 20881, 20896, 21070, 21059, 21066, 21069, 21068, 21067, 21063,
    21191, 21193, 21187, 21185, 21261, 21335, 21371, 21402, 21467, 21676,
    21696, 21672, 21710, 21705, 21688, 21670, 21683, 21703, 21698, 21693,
    21674, 21697, 21700, 21704, 21679, 21675, 21681, 21691, 21673, 21671,
    21695, 22271, 22402, 22411, 22432, 22435, 22434, 22478, 22446, 22419,
    22869, 22865, 22863, 22862, 22864, 23004, 23000, 23039, 23011, 23016,
    23043, 23013, 23018, 23002, 23014, 23041, 23035, 23401, 23459, 23462,
    23460, 23458, 23461, 23553, 23630, 23631, 23629, 23627, 23769, 23762,
    24055, 24093, 24101, 24095, 24189, 24224, 24230, 24314, 24328, 24365,
    24421, 24456, 24453, 24458, 24459, 24455, 24460, 24457, 24594, 24605,
    24608, 24613, 24590, 24616, 24653, 24688, 24680, 24674, 24646, 24643,
    24684, 24683, 24682, 24676, 25153, 25308, 25366, 25353, 25340, 25325,
    25345, 25326, 25341, 25351, 25329, 25335, 25327, 25324, 25342, 25332,
    25361, 25346, 25919, 25925, 26027, 26045, 26082, 26149, 26157, 26144,
    26151, 26159, 26143, 26152, 26161, 26148, 26359, 26623, 26579, 26609,
    26580, 26576, 26604, 26550, 26543, 26613, 26601, 26607, 26564, 26577,
    26548, 26586, 26597, 26552, 26575, 26590, 26611, 26544, 26585, 26594,
    26589, 26578, 27498, 27523, 27526, 27573, 27602, 27607, 27679, 27849,
    27915, 27954, 27946, 27969, 27941, 27916, 27953, 27934, 27927, 27963,
    27965, 27966, 27958, 27931, 27893, 27961, 27943, 27960, 27945, 27950,
    27957, 27918, 27947, 28843, 28858, 28851, 28844, 28847, 28845, 28856,
    28846, 28836, 29232, 29298, 29295, 29300, 29417, 29408, 29409, 29623,
    29642, 29627, 29618, 29645, 29632, 29619, 29978, 29997, 30031, 30028,
    30030, 30027, 30123, 30116, 30117, 30114, 30115, 30328, 30342, 30343,
    30344, 30408, 30406, 30403, 30405, 30465, 30457, 30456, 30473, 30475,
    30462, 30460, 30471, 30684, 30722, 30740, 30732, 30733, 31046, 31049,
    31048, 31047, 31161, 31162, 31185, 31186, 31179, 31359, 31361, 31487,
    31485, 31869, 32002, 32005, 32000, 32009, 32007, 32004, 32006, 32568,
    32654, 32703, 32772, 32784, 32781, 32785, 32822, 32982, 32997, 32986,
    32963, 32964, 32972, 32993, 32987, 32974, 32990, 32996, 32989, 33268,
    33314, 33511, 33539, 33541, 33507, 33499, 33510, 33540, 33509, 33538,
    33545, 33490, 33495, 33521, 33537, 33500, 33492, 33489, 33502, 33491,
    33503, 33519, 33542, 34384, 34425, 34427, 34426, 34893, 34923, 35201,
    35284, 35336, 35330, 35331, 35998, 36000, 36212, 36211, 36276, 36557,
    36556, 36848, 36838, 36834, 36842, 36837, 36845, 36843, 36836, 36840,
    37066, 37070, 37057, 37059, 37195, 37194, 37325, 38274, 38480, 38475,
    38476, 38477, 38754, 38761, 38859, 38893, 38899, 38913, 39080, 39131,
    39135, 39318, 39321, 20056, 20147, 20492, 20493, 20515, 20463, 20518,
    20517, 20472, 20521, 20502, 20486, 20540, 20511, 20506, 20498, 20497,
    20474, 20480, 20500, 20520, 20465, 20513, 20491, 20505, 20504, 20467,
    20462, 20525, 20522, 20478, 20523, 20489, 20860, 20900, 20901, 20898,
    20941, 20940, 20934, 20939, 21078, 21084, 21076, 21083, 21085, 21290,
    21375, 21407, 21405, 21471, 21736, 21776, 21761, 21815, 21756, 21733,
    21746, 21766, 21754, 21780, 21737, 21741, 21729, 21769, 21742, 21738,
    21734, 21799, 21767, 21757, 21775, 22275, 22276, 22466, 22484, 22475,
    22467, 22537, 22799, 22871, 22872, 22874, 23057, 23064, 23068, 23071,
    23067, 23059, 23020, 23072, 23075, 23081, 23077, 23052, 23049, 23403,
    23640, 23472, 23475, 23478, 23476, 23470, 23477, 23481, 23480, 23556,
    23633, 23637, 23632, 23789, 23805, 23803, 23786, 23784, 23792, 23798,
    23809, 23796, 24046, 24109, 24107, 24235, 24237, 24231, 24369, 24466,
    24465, 24464, 24665, 24675, 24677, 24656, 24661, 24685, 24681, 24687,
    24708, 24735, 24730, 24717, 24724, 24716, 24709, 24726, 25159, 25331,
    25352, 25343, 25422, 25406, 25391, 25429, 25410, 25414, 25423, 25417,
    25402, 25424, 25405, 25386, 25387, 25384, 25421, 25420, 25928, 25929,
    26009, 26049, 26053, 26178, 26185, 26191, 26179, 26194, 26188, 26181,
    26177, 26360, 26388, 26389, 26391, 26657, 26680, 26696, 26694, 26707,
    26681, 26690, 26708, 26665, 26803, 26647, 26700, 26705, 26685, 26612,
    26704, 26688, 26684, 26691, 26666, 26693, 26643, 26648, 26689, 27530,
    27529, 27575, 27683, 27687, 27688, 27686, 27684, 27888, 28010, 28053,
    28040, 28039, 28006, 28024, 28023, 27993, 28051, 28012, 28041, 28014,
    27994, 28020, 28009, 28044, 28042, 28025, 28037, 28005, 28052, 28874,
    28888, 28900, 28889, 28872, 28879, 29241, 29305, 29436, 29433, 29437,
    29432, 29431, 29574, 29677, 29705, 29678, 29664, 29674, 29662, 30036,
    30045, 30044, 30042, 30041, 30142, 30149, 30151, 30130, 30131, 30141,
    30140, 30137, 30146, 30136, 30347, 30384, 30410, 30413, 30414, 30505,
    30495, 30496, 30504, 30697, 30768, 30759, 30776, 30749, 30772, 30775,
    30757, 30765, 30752, 30751, 30770, 31061, 31056, 31072, 31071, 31062,
    31070, 31069, 31063, 31066, 31204, 31203, 31207, 31199, 31206, 31209,
    31192, 31364, 31368, 31449, 31494, 31505, 31881, 32033, 32023, 32011,
    32010, 32032, 32034, 32020, 32016, 32021, 32026, 32028, 32013, 32025,
    32027, 32570, 32607, 32660, 32709, 32705, 32774, 32792, 32789, 32793,
    32791, 32829, 32831, 33009, 33026, 33008, 33029, 33005, 33012, 33030,
    33016, 33011, 33032, 33021, 33034, 33020, 33007, 33261, 33260, 33280,
    33296, 33322, 33323, 33320, 33324, 33467, 33579, 33618, 33620, 33610,
    33592, 33616, 33609, 33589, 33588, 33615, 33586, 33593, 33590, 33559,
    33600, 33585, 33576, 33603, 34388, 34442, 34474, 34451, 34468, 34473,
    34444, 34467, 34460, 34928, 34935, 34945, 34946, 34941, 34937, 35352,
    35344, 35342, 35340, 35349, 35338, 35351, 35347, 35350, 35343, 35345,
    35912, 35962, 35961, 36001, 36002, 36215, 36524, 36562, 36564, 36559,
    36785, 36865, 36870, 36855, 36864, 36858, 36852, 36867, 36861, 36869,
    36856, 37013, 37089, 37085, 37090, 37202, 37197, 37196, 37336, 37341,
    37335, 37340, 37337, 38275, 38498, 38499, 38497, 38491, 38493, 38500,
    38488, 38494, 38587, 39138, 39340, 39592, 39640, 39717, 39730, 39740,
    20094, 20602, 20605, 20572, 20551, 20547, 20556, 20570, 20553, 20581,
    20598, 20558, 20565, 20597, 20596, 20599, 20559, 20495, 20591, 20589,
    20828, 20885, 20976, 21098, 21103, 21202, 21209, 21208, 21205, 21264,
    21263, 21273, 21311, 21312, 21310, 21443, 26364, 21830, 21866, 21862,
    21828, 21854, 21857, 21827, 21834, 21809, 21846, 21839, 21845, 21807,
    21860, 21816, 21806, 21852, 21804, 21859, 21811, 21825, 21847, 22280,
    22283, 22281, 22495, 22533, 22538, 22534, 22496, 22500, 22522, 22530,
    22581, 22519, 22521, 22816, 22882, 23094, 23105, 23113, 23142, 23146,
    23104, 23100, 23138, 23130, 23110, 23114, 23408, 23495, 23493, 23492,
    23490, 23487, 23494, 23561, 23560, 23559, 23648, 23644, 23645, 23815,
    23814, 23822, 23835, 23830, 23842, 23825, 23849, 23828, 23833, 23844,
    23847, 23831, 24034, 24120, 24118, 24115, 24119, 24247, 24248, 24246,
    24245, 24254, 24373, 24375, 24407, 24428, 24425, 24427, 24471, 24473,
    24478, 24472, 24481, 24480, 24476, 24703, 24739, 24713, 24736, 24744,
    24779, 24756, 24806, 24765, 24773, 24763, 24757, 24796, 24764, 24792,
    24789, 24774, 24799, 24760, 24794, 24775, 25114, 25115, 25160, 25504,
    25511, 25458, 25494, 25506, 25509, 25463, 25447, 25496, 25514, 25457,
    25513, 25481, 25475, 25499, 25451, 25512, 25476, 25480, 25497, 25505,
    25516, 25490, 25487, 25472, 25467, 25449, 25448, 25466, 25949, 25942,
    25937, 25945, 25943, 21855, 25935, 25944, 25941, 25940, 26012, 26011,
    26028, 26063, 26059, 26060, 26062, 26205, 26202, 26212, 26216, 26214,
    26206, 26361, 21207, 26395, 26753, 26799, 26786, 26771, 26805, 26751,
    26742, 26801, 26791, 26775, 26800, 26755, 26820, 26797, 26758, 26757,
    26772, 26781, 26792, 26783, 26785, 26754, 27442, 27578, 27627, 27628,
    27691, 28046, 28092, 28147, 28121, 28082, 28129, 28108, 28132, 28155,
    28154, 28165, 28103, 28107, 28079, 28113, 28078, 28126, 28153, 28088,
    28151, 28149, 28101, 28114, 28186, 28085, 28122, 28139, 28120, 28138,
    28145, 28142, 28136, 28102, 28100, 28074, 28140, 28095, 28134, 28921,
    28937, 28938, 28925, 28911, 29245, 29309, 29313, 29468, 29467, 29462,
    29459, 29465, 29575, 29701, 29706, 29699, 29702, 29694, 29709, 29920,
    29942, 29943, 29980, 29986, 30053, 30054, 30050, 30064, 30095, 30164,
    30165, 30133, 30154, 30157, 30350, 30420, 30418, 30427, 30519, 30526,
    30524, 30518, 30520, 30522, 30827, 30787, 30798, 31077, 31080, 31085,
    31227, 31378, 31381, 31520, 31528, 31515, 31532, 31526, 31513, 31518,
    31534, 31890, 31895, 31893, 32070, 32067, 32113, 32046, 32057, 32060,
    32064, 32048, 32051, 32068, 32047, 32066, 32050, 32049, 32573, 32670,
    32666, 32716, 32718, 32722, 32796, 32842, 32838, 33071, 33046, 33059,
    33067, 33065, 33072, 33060, 33282, 33333, 33335, 33334, 33337, 33678,
    33694, 33688, 33656, 33698, 33686, 33725, 33707, 33682, 33674, 33683,
    33673, 33696, 33655, 33659, 33660, 33670, 33703, 34389, 24426, 34503,
    34496, 34486, 34500, 34485, 34502, 34507, 34481, 34479, 34505, 34899,
    34974, 34952, 34987, 34962, 34966, 34957, 34955, 35219, 35215, 35370,
    35357, 35363, 35365, 35377, 35373, 35359, 35355, 35362, 35913, 35930,
    36009, 36012, 36011, 36008, 36010, 36007, 36199, 36198, 36286, 36282,
    36571, 36575, 36889, 36877, 36890, 36887, 36899, 36895, 36893, 36880,
    36885, 36894, 36896, 36879, 36898, 36886, 36891, 36884, 37096, 37101,
    37117, 37207, 37326, 37365, 37350, 37347, 37351, 37357, 37353, 38281,
    38506, 38517, 38515, 38520, 38512, 38516, 38518, 38519, 38508, 38592,
    38634, 38633, 31456, 31455, 38914, 38915, 39770, 40165, 40565, 40575,
    40613, 40635, 20642, 20621, 20613, 20633, 20625, 20608, 20630, 20632,
    20634, 26368, 20977, 21106, 21108, 21109, 21097, 21214, 21213, 21211,
    21338, 21413, 21883, 21888, 21927, 21884, 21898, 21917, 21912, 21890,
    21916, 21930, 21908, 21895, 21899, 21891, 21939, 21934, 21919, 21822,
    21938, 21914, 21947, 21932, 21937, 21886, 21897, 21931, 21913, 22285,
    22575, 22570, 22580, 22564, 22576, 22577, 22561, 22557, 22560, 22777,
    22778, 22880, 23159, 23194, 23167, 23186, 23195, 23207, 23411, 23409,
    23506, 23500, 23507, 23504, 23562, 23563, 23601, 23884, 23888, 23860,
    23879, 24061, 24133, 24125, 24128, 24131, 24190, 24266, 24257, 24258,
    24260, 24380, 24429, 24489, 24490, 24488, 24785, 24801, 24754, 24758,
    24800, 24860, 24867, 24826, 24853, 24816, 24827, 24820, 24936, 24817,
    24846, 24822, 24841, 24832, 24850, 25119, 25161, 25507, 25484, 25551,
    25536, 25577, 25545, 25542, 25549, 25554, 25571, 25552, 25569, 25558,
    25581, 25582, 25462, 25588, 25578, 25563, 25682, 25562, 25593, 25950,
    25958, 25954, 25955, 26001, 26000, 26031, 26222, 26224, 26228, 26230,
    26223, 26257, 26234, 26238, 26231, 26366, 26367, 26399, 26397, 26874,
    26837, 26848, 26840, 26839, 26885, 26847, 26869, 26862, 26855, 26873,
    26834, 26866, 26851, 26827, 26829, 26893, 26898, 26894, 26825, 26842,
    26990, 26875, 27454, 27450, 27453, 27544, 27542, 27580, 27631, 27694,
    27695, 27692, 28207, 28216, 28244, 28193, 28210, 28263, 28234, 28192,
    28197, 28195, 28187, 28251, 28248, 28196, 28246, 28270, 28205, 28198,
    28271, 28212, 28237, 28218, 28204, 28227, 28189, 28222, 28363, 28297,
    28185, 28238, 28259, 28228, 28274, 28265, 28255, 28953, 28954, 28966,
    28976, 28961, 28982, 29038, 28956, 29260, 29316, 29312, 29494, 29477,
    29492, 29481, 29754, 29738, 29747, 29730, 29733, 29749, 29750, 29748,
    29743, 29723, 29734, 29736, 29989, 29990, 30059, 30058, 30178, 30171,
    30179, 30169, 30168, 30174, 30176, 30331, 30332, 30358, 30355, 30388,
    30428, 30543, 30701, 30813, 30828, 30831, 31245, 31240, 31243, 31237,
    31232, 31384, 31383, 31382, 31461, 31459, 31561, 31574, 31558, 31568,
    31570, 31572, 31565, 31563, 31567, 31569, 31903, 31909, 32094, 32080,
    32104, 32085, 32043, 32110, 32114, 32097, 32102, 32098, 32112, 32115,
    21892, 32724, 32725, 32779, 32850, 32901, 33109, 33108, 33099, 33105,
    33102, 33081, 33094, 33086, 33100, 33107, 33140, 33298, 33308, 33769,
    33795, 33784, 33805, 33760, 33733, 33803, 33729, 33775, 33777, 33780,
    33879, 33802, 33776, 33804, 33740, 33789, 33778, 33738, 33848, 33806,
    33796, 33756, 33799, 33748, 33759, 34395, 34527, 34521, 34541, 34516,
    34523, 34532, 34512, 34526, 34903, 35009, 35010, 34993, 35203, 35222,
    35387, 35424, 35413, 35422, 35388, 35393, 35412, 35419, 35408, 35398,
    35380, 35386, 35382, 35414, 35937, 35970, 36015, 36028, 36019, 36029,
    36033, 36027, 36032, 36020, 36023, 36022, 36031, 36024, 36234, 36229,
    36225, 36302, 36317, 36299, 36314, 36305, 36300, 36315, 36294, 36603,
    36600, 36604, 36764, 36910, 36917, 36913, 36920, 36914, 36918, 37122,
    37109, 37129, 37118, 37219, 37221, 37327, 37396, 37397, 37411, 37385,
    37406, 37389, 37392, 37383, 37393, 38292, 38287, 38283, 38289, 38291,
    38290, 38286, 38538, 38542, 38539, 38525, 38533, 38534, 38541, 38514,
    38532, 38593, 38597, 38596, 38598, 38599, 38639, 38642, 38860, 38917,
    38918, 38920, 39143, 39146, 39151, 39145, 39154, 39149, 39342, 39341,
    40643, 40653, 40657, 20098, 20653, 20661, 20658, 20659, 20677, 20670,
    20652, 20663, 20667, 20655, 20679, 21119, 21111, 21117, 21215, 21222,
    21220, 21218, 21219, 21295, 21983, 21992, 21971, 21990, 21966, 21980,
    21959, 21969, 21987, 21988, 21999, 21978, 21985, 21957, 21958, 21989,
    21961, 22290, 22291, 22622, 22609, 22616, 22615, 22618, 22612, 22635,
    22604, 22637, 22602, 22626, 22610, 22603, 22887, 23233, 23241, 23244,
    23230, 23229, 23228, 23219, 23234, 23218, 23913, 23919, 24140, 24185,
    24265, 24264, 24338, 24409, 24492, 24494, 24858, 24847, 24904, 24863,
    24819, 24859, 24825, 24833, 24840, 24910, 24908, 24900, 24909, 24894,
    24884, 24871, 24845, 24838, 24887, 25121, 25122, 25619, 25662, 25630,
    25642, 25645, 25661, 25644, 25615, 25628, 25620, 25613, 25654, 25622,
    25623, 25606, 25964, 26015, 26032, 26263, 26249, 26247, 26248, 26262,
    26244, 26264, 26253, 26371, 27028, 26989, 26970, 26999, 26976, 26964,
    26997, 26928, 27010, 26954, 26984, 26987, 26974, 26963, 27001, 27014,
    26973, 26979, 26971, 27463, 27506, 27584, 27583, 27603, 27645, 28322,
    28335, 28371, 28342, 28354, 28304, 28317, 28359, 28357, 28325, 28312,
    28348, 28346, 28331, 28369, 28310, 28316, 28356, 28372, 28330, 28327,
    28340, 29006, 29017, 29033, 29028, 29001, 29031, 29020, 29036, 29030,
    29004, 29029, 29022, 28998, 29032, 29014, 29242, 29266, 29495, 29509,
    29503, 29502, 29807, 29786, 29781, 29791, 29790, 29761, 29759, 29785,
    29787, 29788, 30070, 30072, 30208, 30192, 30209, 30194, 30193, 30202,
    30207, 30196, 30195, 30430, 30431, 30555, 30571, 30566, 30558, 30563,
    30585, 30570, 30572, 30556, 30565, 30568, 30562, 30702, 30862, 30896,
    30871, 30872, 30860, 30857, 30844, 30865, 30867, 30847, 31098, 31103,
    31105, 33836, 31165, 31260, 31258, 31264, 31252, 31263, 31262, 31391,
    31392, 31607, 31680, 31584, 31598, 31591, 31921, 31923, 31925, 32147,
    32121, 32145, 32129, 32143, 32091, 32622, 32617, 32618, 32626, 32681,
    32680, 32676, 32854, 32856, 32902, 32900, 33137, 33136, 33144, 33125,
    33134, 33139, 33131, 33145, 33146, 33126, 33285, 33351, 33922, 33911,
    33853, 33841, 33909, 33894, 33899, 33865, 33900, 33883, 33852, 33845,
    33889, 33891, 33897, 33901, 33862, 34398, 34396, 34399, 34553, 34579,
    34568, 34567, 34560, 34558, 34555, 34562, 34563, 34566, 34570, 34905,
    35039, 35028, 35033, 35036, 35032, 35037, 35041, 35018, 35029, 35026,
    35228, 35299, 35435, 35442, 35443, 35430, 35433, 35440, 35463, 35452,
    35427, 35488, 35441, 35461, 35437, 35426, 35438, 35436, 35449, 35451,
    35390, 35432, 35938, 35978, 35977, 36042, 36039, 36040, 36036, 36018,
    36035, 36034, 36037, 36321, 36319, 36328, 36335, 36339, 36346, 36330,
    36324, 36326, 36530, 36611, 36617, 36606, 36618, 36767, 36786, 36939,
    36938, 36947, 36930, 36948, 36924, 36949, 36944, 36935, 36943, 36942,
    36941, 36945, 36926, 36929, 37138, 37143, 37228, 37226, 37225, 37321,
    37431, 37463, 37432, 37437, 37440, 37438, 37467, 37451, 37476, 37457,
    37428, 37449, 37453, 37445, 37433, 37439, 37466, 38296, 38552, 38548,
    38549, 38605, 38603, 38601, 38602, 38647, 38651, 38649, 38646, 38742,
    38772, 38774, 38928, 38929, 38931, 38922, 38930, 38924, 39164, 39156,
    39165, 39166, 39347, 39345, 39348, 39649, 40169, 40578, 40718, 40723,
    40736, 20711, 20718, 20709, 20694, 20717, 20698, 20693, 20687, 20689,
    20721, 20686, 20713, 20834, 20979, 21123, 21122, 21297, 21421, 22014,
    22016, 22043, 22039, 22013, 22036, 22022, 22025, 22029, 22030, 22007,
    22038, 22047, 22024, 22032, 22006, 22296, 22294, 22645, 22654, 22659,
    22675, 22666, 22649, 22661, 22653, 22781, 22821, 22818, 22820, 22890,
    22889, 23265, 23270, 23273, 23255, 23254, 23256, 23267, 23413, 23518,
    23527, 23521, 23525, 23526, 23528, 23522, 23524, 23519, 23565, 23650,
    23940, 23943, 24155, 24163, 24149, 24151, 24148, 24275, 24278, 24330,
    24390, 24432, 24505, 24903, 24895, 24907, 24951, 24930, 24931, 24927,
    24922, 24920, 24949, 25130, 25735, 25688, 25684, 25764, 25720, 25695,
    25722, 25681, 25703, 25652, 25709, 25723, 25970, 26017, 26071, 26070,
    26274, 26280, 26269, 27036, 27048, 27029, 27073, 27054, 27091, 27083,
    27035, 27063, 27067, 27051, 27060, 27088, 27085, 27053, 27084, 27046,
    27075, 27043, 27465, 27468, 27699, 28467, 28436, 28414, 28435, 28404,
    28457, 28478, 28448, 28460, 28431, 28418, 28450, 28415, 28399, 28422,
    28465, 28472, 28466, 28451, 28437, 28459, 28463, 28552, 28458, 28396,
    28417, 28402, 28364, 28407, 29076, 29081, 29053, 29066, 29060, 29074,
    29246, 29330, 29334, 29508, 29520, 29796, 29795, 29802, 29808, 29805,
    29956, 30097, 30247, 30221, 30219, 30217, 30227, 30433, 30435, 30596,
    30589, 30591, 30561, 30913, 30879, 30887, 30899, 30889, 30883, 31118,
    31119, 31117, 31278, 31281, 31402, 31401, 31469, 31471, 31649, 31637,
    31627, 31605, 31639, 31645, 31636, 31631, 31672, 31623, 31620, 31929,
    31933, 31934, 32187, 32176, 32156, 32189, 32190, 32160, 32202, 32180,
    32178, 32177, 32186, 32162, 32191, 32181, 32184, 32173, 32210, 32199,
    32172, 32624, 32736, 32737, 32735, 32862, 32858, 32903, 33104, 33152,
    33167, 33160, 33162, 33151, 33154, 33255, 33274, 33287, 33300, 33310,
    33355, 33993, 33983, 33990, 33988, 33945, 33950, 33970, 33948, 33995,
    33976, 33984, 34003, 33936, 33980, 34001, 33994, 34623, 34588, 34619,
    34594, 34597, 34612, 34584, 34645, 34615, 34601, 35059, 35074, 35060,
    35065, 35064, 35069, 35048, 35098, 35055, 35494, 35468, 35486, 35491,
    35469, 35489, 35475, 35492, 35498, 35493, 35496, 35480, 35473, 35482,
    35495, 35946, 35981, 35980, 36051, 36049, 36050, 36203, 36249, 36245,
    36348, 36628, 36626, 36629, 36627, 36771, 36960, 36952, 36956, 36963,
    36953, 36958, 36962, 36957, 36955, 37145, 37144, 37150, 37237, 37240,
    37239, 37236, 37496, 37504, 37509, 37528, 37526, 37499, 37523, 37532,
    37544, 37500, 37521, 38305, 38312, 38313, 38307, 38309, 38308, 38553,
    38556, 38555, 38604, 38610, 38656, 38780, 38789, 38902, 38935, 38936,
    39087, 39089, 39171, 39173, 39180, 39177, 39361, 39599, 39600, 39654,
    39745, 39746, 40180, 40182, 40179, 40636, 40763, 40778, 20740, 20736,
    20731, 20725, 20729, 20738, 20744, 20745, 20741, 20956, 21127, 21128,
    21129, 21133, 21130, 21232, 21426, 22062, 22075, 22073, 22066, 22079,
    22068, 22057, 22099, 22094, 22103, 22132, 22070, 22063, 22064, 22656,
    22687, 22686, 22707, 22684, 22702, 22697, 22694, 22893, 23305, 23291,
    23307, 23285, 23308, 23304, 23534, 23532, 23529, 23531, 23652, 23653,
    23965, 23956, 24162, 24159, 24161, 24290, 24282, 24287, 24285, 24291,
    24288, 24392, 24433, 24503, 24501, 24950, 24935, 24942, 24925, 24917,
    24962, 24956, 24944, 24939, 24958, 24999, 24976, 25003, 24974, 25004,
    24986, 24996, 24980, 25006, 25134, 25705, 25711, 25721, 25758, 25778,
    25736, 25744, 25776, 25765, 25747, 25749, 25769, 25746, 25774, 25773,
    25771, 25754, 25772, 25753, 25762, 25779, 25973, 25975, 25976, 26286,
    26283, 26292, 26289, 27171, 27167, 27112, 27137, 27166, 27161, 27133,
    27169, 27155, 27146, 27123, 27138, 27141, 27117, 27153, 27472, 27470,
    27556, 27589, 27590, 28479, 28540, 28548, 28497, 28518, 28500, 28550,
    28525, 28507, 28536, 28526, 28558, 28538, 28528, 28516, 28567, 28504,
    28373, 28527, 28512, 28511, 29087, 29100, 29105, 29096, 29270, 29339,
    29518, 29527, 29801, 29835, 29827, 29822, 29824, 30079, 30240, 30249,
    30239, 30244, 30246, 30241, 30242, 30362, 30394, 30436, 30606, 30599,
    30604, 30609, 30603, 30923, 30917, 30906, 30922, 30910, 30933, 30908,
    30928, 31295, 31292, 31296, 31293, 31287, 31291, 31407, 31406, 31661,
    31665, 31684, 31668, 31686, 31687, 31681, 31648, 31692, 31946, 32224,
    32244, 32239, 32251, 32216, 32236, 32221, 32232, 32227, 32218, 32222,
    32233, 32158, 32217, 32242, 32249, 32629, 32631, 32687, 32745, 32806,
    33179, 33180, 33181, 33184, 33178, 33176, 34071, 34109, 34074, 34030,
    34092, 34093, 34067, 34065, 34083, 34081, 34068, 34028, 34085, 34047,
    34054, 34690, 34676, 34678, 34656, 34662, 34680, 34664, 34649, 34647,
    34636, 34643, 34907, 34909, 35088, 35079, 35090, 35091, 35093, 35082,
    35516, 35538, 35527, 35524, 35477, 35531, 35576, 35506, 35529, 35522,
    35519, 35504, 35542, 35533, 35510, 35513, 35547, 35916, 35918, 35948,
    36064, 36062, 36070, 36068, 36076, 36077, 36066, 36067, 36060, 36074,
    36065, 36205, 36255, 36259, 36395, 36368, 36381, 36386, 36367, 36393,
    36383, 36385, 36382, 36538, 36637, 36635, 36639, 36649, 36646, 36650,
    36636, 36638, 36645, 36969, 36974, 36968, 36973, 36983, 37168, 37165,
    37159, 37169, 37255, 37257, 37259, 37251, 37573, 37563, 37559, 37610,
    37548, 37604, 37569, 37555, 37564, 37586, 37575, 37616, 37554, 38317,
    38321, 38660, 38662, 38663, 38665, 38752, 38797, 38795, 38799, 38945,
    38955, 38940, 39091, 39178, 39187, 39186, 39192, 39389, 39376, 39391,
    39387, 39377, 39381, 39378, 39385, 39607, 39662, 39663, 39719, 39749,
    39748, 39799, 39791, 40198, 40201, 40195, 40617, 40638, 40654, 22696,
    40786, 20754, 20760, 20756, 20752, 20757, 20864, 20906, 20957, 21137,
    21139, 21235, 22105, 22123, 22137, 22121, 22116, 22136, 22122, 22120,
    22117, 22129, 22127, 22124, 22114, 22134, 22721, 22718, 22727, 22725,
    22894, 23325, 23348, 23416, 23536, 23566, 24394, 25010, 24977, 25001,
    24970, 25037, 25014, 25022, 25034, 25032, 25136, 25797, 25793, 25803,
    25787, 25788, 25818, 25796, 25799, 25794, 25805, 25791, 25810, 25812,
    25790, 25972, 26310, 26313, 26297, 26308, 26311, 26296, 27197, 27192,
    27194, 27225, 27243, 27224, 27193, 27204, 27234, 27233, 27211, 27207,
    27189, 27231, 27208, 27481, 27511, 27653, 28610, 28593, 28577, 28611,
    28580, 28609, 28583, 28595, 28608, 28601, 28598, 28582, 28576, 28596,
    29118, 29129, 29136, 29138, 29128, 29141, 29113, 29134, 29145, 29148,
    29123, 29124, 29544, 29852, 29859, 29848, 29855, 29854, 29922, 29964,
    29965, 30260, 30264, 30266, 30439, 30437, 30624, 30622, 30623, 30629,
    30952, 30938, 30956, 30951, 31142, 31309, 31310, 31302, 31308, 31307,
    31418, 31705, 31761, 31689, 31716, 31707, 31713, 31721, 31718, 31957,
    31958, 32266, 32273, 32264, 32283, 32291, 32286, 32285, 32265, 32272,
    32633, 32690, 32752, 32753, 32750, 32808, 33203, 33193, 33192, 33275,
    33288, 33368, 33369, 34122, 34137, 34120, 34152, 34153, 34115, 34121,
    34157, 34154, 34142, 34691, 34719, 34718, 34722, 34701, 34913, 35114,
    35122, 35109, 35115, 35105, 35242, 35238, 35558, 35578, 35563, 35569,
    35584, 35548, 35559, 35566, 35582, 35585, 35586, 35575, 35565, 35571,
    35574, 35580, 35947, 35949, 35987, 36084, 36420, 36401, 36404, 36418,
    36409, 36405, 36667, 36655, 36664, 36659, 36776, 36774, 36981, 36980,
    36984, 36978, 36988, 36986, 37172, 37266, 37664, 37686, 37624, 37683,
    37679, 37666, 37628, 37675, 37636, 37658, 37648, 37670, 37665, 37653,
    37678, 37657, 38331, 38567, 38568, 38570, 38613, 38670, 38673, 38678,
    38669, 38675, 38671, 38747, 38748, 38758, 38808, 38960, 38968, 38971,
    38967, 38957, 38969, 38948, 39184, 39208, 39198, 39195, 39201, 39194,
    39405, 39394, 39409, 39608, 39612, 39675, 39661, 39720, 39825, 40213,
    40227, 40230, 40232, 40210, 40219, 40664, 40660, 40845, 40860, 20778,
    20767, 20769, 20786, 21237, 22158, 22144, 22160, 22149, 22151, 22159,
    22741, 22739, 22737, 22734, 23344, 23338, 23332, 23418, 23607, 23656,
    23996, 23994, 23997, 23992, 24171, 24396, 24509, 25033, 25026, 25031,
    25062, 25035, 25138, 25140, 25806, 25802, 25816, 25824, 25840, 25830,
    25836, 25841, 25826, 25837, 25986, 25987, 26329, 26326, 27264, 27284,
    27268, 27298, 27292, 27355, 27299, 27262, 27287, 27280, 27296, 27484,
    27566, 27610, 27656, 28632, 28657, 28639, 28640, 28635, 28644, 28651,
    28655, 28544, 28652, 28641, 28649, 28629, 28654, 28656, 29159, 29151,
    29166, 29158, 29157, 29165, 29164, 29172, 29152, 29237, 29254, 29552,
    29554, 29865, 29872, 29862, 29864, 30278, 30274, 30284, 30442, 30643,
    30634, 30640, 30636, 30631, 30637, 30703, 30967, 30970, 30964, 30959,
    30977, 31143, 31146, 31319, 31423, 31751, 31757, 31742, 31735, 31756,
    31712, 31968, 31964, 31966, 31970, 31967, 31961, 31965, 32302, 32318,
    32326, 32311, 32306, 32323, 32299, 32317, 32305, 32325, 32321, 32308,
    32313, 32328, 32309, 32319, 32303, 32580, 32755, 32764, 32881, 32882,
    32880, 32879, 32883, 33222, 33219, 33210, 33218, 33216, 33215, 33213,
    33225, 33214, 33256, 33289, 33393, 34218, 34180, 34174, 34204, 34193,
    34196, 34223, 34203, 34183, 34216, 34186, 34407, 34752, 34769, 34739,
    34770, 34758, 34731, 34747, 34746, 34760, 34763, 35131, 35126, 35140,
    35128, 35133, 35244, 35598, 35607, 35609, 35611, 35594, 35616, 35613,
    35588, 35600, 35905, 35903, 35955, 36090, 36093, 36092, 36088, 36091,
    36264, 36425, 36427, 36424, 36426, 36676, 36670, 36674, 36677, 36671,
    36991, 36989, 36996, 36993, 36994, 36992, 37177, 37283, 37278, 37276,
    37709, 37762, 37672, 37749, 37706, 37733, 37707, 37656, 37758, 37740,
    37723, 37744, 37722, 37716, 38346, 38347, 38348, 38344, 38342, 38577,
    38584, 38614, 38684, 38686, 38816, 38867, 38982, 39094, 39221, 39425,
    39423, 39854, 39851, 39850, 39853, 40251, 40255, 40587, 40655, 40670,
    40668, 40669, 40667, 40766, 40779, 21474, 22165, 22190, 22745, 22744,
    23352, 24413, 25059, 25139, 25844, 25842, 25854, 25862, 25850, 25851,
    25847, 26039, 26332, 26406, 27315, 27308, 27331, 27323, 27320, 27330,
    27310, 27311, 27487, 27512, 27567, 28681, 28683, 28670, 28678, 28666,
    28689, 28687, 29179, 29180, 29182, 29176, 29559, 29557, 29863, 29887,
    29973, 30294, 30296, 30290, 30653, 30655, 30651, 30652, 30990, 31150,
    31329, 31330, 31328, 31428, 31429, 31787, 31783, 31786, 31774, 31779,
    31777, 31975, 32340, 32341, 32350, 32346, 32353, 32338, 32345, 32584,
    32761, 32763, 32887, 32886, 33229, 33231, 33290, 34255, 34217, 34253,
    34256, 34249, 34224, 34234, 34233, 34214, 34799, 34796, 34802, 34784,
    35206, 35250, 35316, 35624, 35641, 35628, 35627, 35920, 36101, 36441,
    36451, 36454, 36452, 36447, 36437, 36544, 36681, 36685, 36999, 36995,
    37000, 37291, 37292, 37328, 37780, 37770, 37782, 37794, 37811, 37806,
    37804, 37808, 37784, 37786, 37783, 38356, 38358, 38352, 38357, 38626,
    38620, 38617, 38619, 38622, 38692, 38819, 38822, 38829, 38905, 38989,
    38991, 38988, 38990, 38995, 39098, 39230, 39231, 39229, 39214, 39333,
    39438, 39617, 39683, 39686, 39759, 39758, 39757, 39882, 39881, 39933,
    39880, 39872, 40273, 40285, 40288, 40672, 40725, 40748, 20787, 22181,
    22750, 22751, 22754, 23541, 40848, 24300, 25074, 25079, 25078, 25077,
    25856, 25871, 26336, 26333, 27365, 27357, 27354, 27347, 28699, 28703,
    28712, 28698, 28701, 28693, 28696, 29190, 29197, 29272, 29346, 29560,
    29562, 29885, 29898, 29923, 30087, 30086, 30303, 30305, 30663, 31001,
    31153, 31339, 31337, 31806, 31807, 31800, 31805, 31799, 31808, 32363,
    32365, 32377, 32361, 32362, 32645, 32371, 32694, 32697, 32696, 33240,
    34281, 34269, 34282, 34261, 34276, 34277, 34295, 34811, 34821, 34829,
    34809, 34814, 35168, 35167, 35158, 35166, 35649, 35676, 35672, 35657,
    35674, 35662, 35663, 35654, 35673, 36104, 36106, 36476, 36466, 36487,
    36470, 36460, 36474, 36468, 36692, 36686, 36781, 37002, 37003, 37297,
    37294, 37857, 37841, 37855, 37827, 37832, 37852, 37853, 37846, 37858,
    37837, 37848, 37860, 37847, 37864, 38364, 38580, 38627, 38698, 38695,
    38753, 38876, 38907, 39006, 39000, 39003, 39100, 39237, 39241, 39446,
    39449, 39693, 39912, 39911, 39894, 39899, 40329, 40289, 40306, 40298,
    40300, 40594, 40599, 40595, 40628, 21240, 22184, 22199, 22198, 22196,
    22204, 22756, 23360, 23363, 23421, 23542, 24009, 25080, 25082, 25880,
    25876, 25881, 26342, 26407, 27372, 28734, 28720, 28722, 29200, 29563,
    29903, 30306, 30309, 31014, 31018, 31020, 31019, 31431, 31478, 31820,
    31811, 31821, 31983, 31984, 36782, 32381, 32380, 32386, 32588, 32768,
    33242, 33382, 34299, 34297, 34321, 34298, 34310, 34315, 34311, 34314,
    34836, 34837, 35172, 35258, 35320, 35696, 35692, 35686, 35695, 35679,
    35691, 36111, 36109, 36489, 36481, 36485, 36482, 37300, 37323, 37912,
    37891, 37885, 38369, 38704, 39108, 39250, 39249, 39336, 39467, 39472,
    39479, 39477, 39955, 39949, 40569, 40629, 40680, 40751, 40799, 40803,
    40801, 20791, 20792, 22209, 22208, 22210, 22804, 23660, 24013, 25084,
    25086, 25885, 25884, 26005, 26345, 27387, 27396, 27386, 27570, 28748,
    29211, 29351, 29910, 29908, 30313, 30675, 31824, 32399, 32396, 32700,
    34327, 34349, 34330, 34851, 34850, 34849, 34847, 35178, 35180, 35261,
    35700, 35703, 35709, 36115, 36490, 36493, 36491, 36703, 36783, 37306,
    37934, 37939, 37941, 37946, 37944, 37938, 37931, 38370, 38712, 38713,
    38706, 38911, 39015, 39013, 39255, 39493, 39491, 39488, 39486, 39631,
    39764, 39761, 39981, 39973, 40367, 40372, 40386, 40376, 40605, 40687,
    40729, 40796, 40806, 40807, 20796, 20795, 22216, 22218, 22217, 23423,
    24020, 24018, 24398, 25087, 25892, 27402, 27489, 28753, 28760, 29568,
    29924, 30090, 30318, 30316, 31155, 31840, 31839, 32894, 32893, 33247,
    35186, 35183, 35324, 35712, 36118, 36119, 36497, 36499, 36705, 37192,
    37956, 37969, 37970, 38717, 38718, 38851, 38849, 39019, 39253, 39509,
    39501, 39634, 39706, 40009, 39985, 39998, 39995, 40403, 40407, 40756,
    40812, 40810, 40852, 22220, 24022, 25088, 25891, 25899, 25898, 26348,
    27408, 29914, 31434, 31844, 31843, 31845, 32403, 32406, 32404, 33250,
    34360, 34367, 34865, 35722, 37008, 37007, 37987, 37984, 37988, 38760,
    39023, 39260, 39514, 39515, 39511, 39635, 39636, 39633, 40020, 40023,
    40022, 40421, 40607, 40692, 22225, 22761, 25900, 28766, 30321, 30322,
    30679, 32592, 32648, 34870, 34873, 34914, 35731, 35730, 35734, 33399,
    36123, 37312, 37994, 38722, 38728, 38724, 38854, 39024, 39519, 39714,
    39768, 40031, 40441, 40442, 40572, 40573, 40711, 40823, 40818, 24307,
    27414, 28771, 31852, 31854, 34875, 35264, 36513, 37313, 38002, 38000,
    39025, 39262, 39638, 39715, 40652, 28772, 30682, 35738, 38007, 38857,
    39522, 39525, 32412, 35740, 36522, 37317, 38013, 38014, 38012, 40055,
    40056, 40695, 35924, 38015, 40474, 29224, 39530, 39729, 40475, 40478,
    31858, 9312, 9313, 9314, 9315, 9316, 9317, 9318, 9319, 9320, 9321, 9332,
    9333, 9334, 9335, 9336, 9337, 9338, 9339, 9340, 9341, 8560, 8561, 8562,
    8563, 8564, 8565, 8566, 8567, 8568, 8569, 20022, 20031, 20101, 20128,
    20866, 20886, 20907, 21241, 21304, 21353, 21430, 22794, 23424, 24027,
    12083, 24191, 24308, 24400, 24417, 25908, 26080, 30098, 30326, 36789,
    38582, 168, 710, 12541, 12542, 12445, 12446, 12291, 20189, 12293, 12294,
    12295, 12540, 65339, 65341, 10045, 12353, 12354, 12355, 12356, 12357,
    12358, 12359, 12360, 12361, 12362, 12363, 12364, 12365, 12366, 12367,
    12368, 12369, 12370, 12371, 12372, 12373, 12374, 12375, 12376, 12377,
    12378, 12379, 12380, 12381, 12382, 12383, 12384, 12385, 12386, 12387,
    12388, 12389, 12390, 12391, 12392, 12393, 12394, 12395, 12396, 12397,
    12398, 12399, 12400, 12401, 12402, 12403, 12404, 12405, 12406, 12407,
    12408, 12409, 12410, 12411, 12412, 12413, 12414, 12415, 12416, 12417,
    12418, 12419, 12420, 12421, 12422, 12423, 12424, 12425, 12426, 12427,
    12428, 12429, 12430, 12431, 12432, 12433, 12434, 12435, 12449, 12450,
    12451, 12452, 12453, 12454, 12455, 12456, 12457, 12458, 12459, 12460,
    12461, 12462, 12463, 12464, 12465, 12466, 12467, 12468, 12469, 12470,
    12471, 12472, 12473, 12474, 12475, 12476, 12477, 12478, 12479, 12480,
    12481, 12482, 12483, 12484, 12485, 12486, 12487, 12488, 12489, 12490,
    12491, 12492, 12493, 12494, 12495, 12496, 12497, 12498, 12499, 12500,
    12501, 12502, 12503, 12504, 12505, 12506, 12507, 12508, 12509, 12510,
    12511, 12512, 12513, 12514, 12515, 12516, 12517, 12518, 12519, 12520,
    12521, 12522, 12523, 12524, 12525, 12526, 12527, 12528, 12529, 12530,
    12531, 12532, 12533, 12534, 1040, 1041, 1042, 1043, 1044, 1045, 1025, 1046,
    1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058,
    1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070,
    1071, 1072, 1073, 1074, 1075, 1076, 1077, 1105, 1078, 1079, 1080, 1081,
    1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093,
    1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 8679, 8632,
    8633, 12751, 204, 20058, 138, 20994, 17553, 40880, 20872, 40881, 30215, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 65506, 65508, 65287, 65282,
    12849, 8470, 8481, 12443, 12444, 11904, 11908, 11910, 11911, 11912, 11914,
    11916, 11917, 11925, 11932, 11933, 11941, 11943, 11946, 11948, 11950,
    11958, 11964, 11966, 11974, 11978, 11980, 11981, 11983, 11990, 11991,
    11998, 12003, X, X, X, 643, 592, 603, 596, 629, 339, 248, 331, 650, 618,
    20034, 20060, 20981, 21274, 21378, 19975, 19980, 20039, 20109, 22231,
    64012, 23662, 24435, 19983, 20871, 19982, 20014, 20115, 20162, 20169,
    20168, 20888, 21244, 21356, 21433, 22304, 22787, 22828, 23568, 24063,
    26081, 27571, 27596, 27668, 29247, 20017, 20028, 20200, 20188, 20201,
    20193, 20189, 20186, 21004, 21276, 21324, 22306, 22307, 22807, 22831,
    23425, 23428, 23570, 23611, 23668, 23667, 24068, 24192, 24194, 24521,
    25097, 25168, 27669, 27702, 27715, 27711, 27707, 29358, 29360, 29578,
    31160, 32906, 38430, 20238, 20248, 20268, 20213, 20244, 20209, 20224,
    20215, 20232, 20253, 20226, 20229, 20258, 20243, 20228, 20212, 20242,
    20913, 21011, 21001, 21008, 21158, 21282, 21279, 21325, 21386, 21511,
    22241, 22239, 22318, 22314, 22324, 22844, 22912, 22908, 22917, 22907,
    22910, 22903, 22911, 23382, 23573, 23589, 23676, 23674, 23675, 23678,
    24031, 24181, 24196, 24322, 24346, 24436, 24533, 24532, 24527, 25180,
    25182, 25188, 25185, 25190, 25186, 25177, 25184, 25178, 25189, 26095,
    26094, 26430, 26425, 26424, 26427, 26426, 26431, 26428, 26419, 27672,
    27718, 27730, 27740, 27727, 27722, 27732, 27723, 27724, 28785, 29278,
    29364, 29365, 29582, 29994, 30335, 31349, 32593, 33400, 33404, 33408,
    33405, 33407, 34381, 35198, 37017, 37015, 37016, 37019, 37012, 38434,
    38436, 38432, 38435, 20310, 20283, 20322, 20297, 20307, 20324, 20286,
    20327, 20306, 20319, 20289, 20312, 20269, 20275, 20287, 20321, 20879,
    20921, 21020, 21022, 21025, 21165, 21166, 21257, 21347, 21362, 21390,
    21391, 21552, 21559, 21546, 21588, 21573, 21529, 21532, 21541, 21528,
    21565, 21583, 21569, 21544, 21540, 21575, 22254, 22247, 22245, 22337,
    22341, 22348, 22345, 22347, 22354, 22790, 22848, 22950, 22936, 22944,
    22935, 22926, 22946, 22928, 22927, 22951, 22945, 23438, 23442, 23592,
    23594, 23693, 23695, 23688, 23691, 23689, 23698, 23690, 23686, 23699,
    23701, 24032, 24074, 24078, 24203, 24201, 24204, 24200, 24205, 24325,
    24349, 24440, 24438, 24530, 24529, 24528, 24557, 24552, 24558, 24563,
    24545, 24548, 24547, 24570, 24559, 24567, 24571, 24576, 24564, 25146,
    25219, 25228, 25230, 25231, 25236, 25223, 25201, 25211, 25210, 25200,
    25217, 25224, 25207, 25213, 25202, 25204, 25911, 26096, 26100, 26099,
    26098, 26101, 26437, 26439, 26457, 26453, 26444, 26440, 26461, 26445,
    26458, 26443, 27600, 27673, 27674, 27768, 27751, 27755, 27780, 27787,
    27791, 27761, 27759, 27753, 27802, 27757, 27783, 27797, 27804, 27750,
    27763, 27749, 27771, 27790, 28788, 28794, 29283, 29375, 29373, 29379,
    29382, 29377, 29370, 29381, 29589, 29591, 29587, 29588, 29586, 30010,
    30009, 30100, 30101, 30337, 31037, 32820, 32917, 32921, 32912, 32914,
    32924, 33424, 33423, 33413, 33422, 33425, 33427, 33418, 33411, 33412,
    35960, 36809, 36799, 37023, 37025, 37029, 37022, 37031, 37024, 38448,
    38440, 38447, 38445, 20019, 20376, 20348, 20357, 20349, 20352, 20359,
    20342, 20340, 20361, 20356, 20343, 20300, 20375, 20330, 20378, 20345,
    20353, 20344, 20368, 20380, 20372, 20382, 20370, 20354, 20373, 20331,
    20334, 20894, 20924, 20926, 21045, 21042, 21043, 21062, 21041, 21180,
    21258, 21259, 21308, 21394, 21396, 21639, 21631, 21633, 21649, 21634,
    21640, 21611, 21626, 21630, 21605, 21612, 21620, 21606, 21645, 21615,
    21601, 21600, 21656, 21603, 21607, 21604, 22263, 22265, 22383, 22386,
    22381, 22379, 22385, 22384, 22390, 22400, 22389, 22395, 22387, 22388,
    22370, 22376, 22397, 22796, 22853, 22965, 22970, 22991, 22990, 22962,
    22988, 22977, 22966, 22972, 22979, 22998, 22961, 22973, 22976, 22984,
    22964, 22983, 23394, 23397, 23443, 23445, 23620, 23623, 23726, 23716,
    23712, 23733, 23727, 23720, 23724, 23711, 23715, 23725, 23714, 23722,
    23719, 23709, 23717, 23734, 23728, 23718, 24087, 24084, 24089, 24360,
    24354, 24355, 24356, 24404, 24450, 24446, 24445, 24542, 24549, 24621,
    24614, 24601, 24626, 24587, 24628, 24586, 24599, 24627, 24602, 24606,
    24620, 24610, 24589, 24592, 24622, 24595, 24593, 24588, 24585, 24604,
    25108, 25149, 25261, 25268, 25297, 25278, 25258, 25270, 25290, 25262,
    25267, 25263, 25275, 25257, 25264, 25272, 25917, 26024, 26043, 26121,
    26108, 26116, 26130, 26120, 26107, 26115, 26123, 26125, 26117, 26109,
    26129, 26128, 26358, 26378, 26501, 26476, 26510, 26514, 26486, 26491,
    26520, 26502, 26500, 26484, 26509, 26508, 26490, 26527, 26513, 26521,
    26499, 26493, 26497, 26488, 26489, 26516, 27429, 27520, 27518, 27614,
    27677, 27795, 27884, 27883, 27886, 27865, 27830, 27860, 27821, 27879,
    27831, 27856, 27842, 27834, 27843, 27846, 27885, 27890, 27858, 27869,
    27828, 27786, 27805, 27776, 27870, 27840, 27952, 27853, 27847, 27824,
    27897, 27855, 27881, 27857, 28820, 28824, 28805, 28819, 28806, 28804,
    28817, 28822, 28802, 28826, 28803, 29290, 29398, 29387, 29400, 29385,
    29404, 29394, 29396, 29402, 29388, 29393, 29604, 29601, 29613, 29606,
    29602, 29600, 29612, 29597, 29917, 29928, 30015, 30016, 30014, 30092,
    30104, 30383, 30451, 30449, 30448, 30453, 30712, 30716, 30713, 30715,
    30714, 30711, 31042, 31039, 31173, 31352, 31355, 31483, 31861, 31997,
    32821, 32911, 32942, 32931, 32952, 32949, 32941, 33312, 33440, 33472,
    33451, 33434, 33432, 33435, 33461, 33447, 33454, 33468, 33438, 33466,
    33460, 33448, 33441, 33449, 33474, 33444, 33475, 33462, 33442, 34416,
    34415, 34413, 34414, 35926, 36818, 36811, 36819, 36813, 36822, 36821,
    36823, 37042, 37044, 37039, 37043, 37040, 38457, 38461, 38460, 38458,
    38467, 20429, 20421, 20435, 20402, 20425, 20427, 20417, 20436, 20444,
    20441, 20411, 20403, 20443, 20423, 20438, 20410, 20416, 20409, 20460,
    21060, 21065, 21184, 21186, 21309, 21372, 21399, 21398, 21401, 21400,
    21690, 21665, 21677, 21669, 21711, 21699, 33549, 21687, 21678, 21718,
    21686, 21701, 21702, 21664, 21616, 21692, 21666, 21694, 21618, 21726,
    21680, 22453, 22430, 22431, 22436, 22412, 22423, 22429, 22427, 22420,
    22424, 22415, 22425, 22437, 22426, 22421, 22772, 22797, 22867, 23009,
    23006, 23022, 23040, 23025, 23005, 23034, 23037, 23036, 23030, 23012,
    23026, 23031, 23003, 23017, 23027, 23029, 23008, 23038, 23028, 23021,
    23464, 23628, 23760, 23768, 23756, 23767, 23755, 23771, 23774, 23770,
    23753, 23751, 23754, 23766, 23763, 23764, 23759, 23752, 23750, 23758,
    23775, 23800, 24057, 24097, 24098, 24099, 24096, 24100, 24240, 24228,
    24226, 24219, 24227, 24229, 24327, 24366, 24406, 24454, 24631, 24633,
    24660, 24690, 24670, 24645, 24659, 24647, 24649, 24667, 24652, 24640,
    24642, 24671, 24612, 24644, 24664, 24678, 24686, 25154, 25155, 25295,
    25357, 25355, 25333, 25358, 25347, 25323, 25337, 25359, 25356, 25336,
    25334, 25344, 25363, 25364, 25338, 25365, 25339, 25328, 25921, 25923,
    26026, 26047, 26166, 26145, 26162, 26165, 26140, 26150, 26146, 26163,
    26155, 26170, 26141, 26164, 26169, 26158, 26383, 26384, 26561, 26610,
    26568, 26554, 26588, 26555, 26616, 26584, 26560, 26551, 26565, 26603,
    26596, 26591, 26549, 26573, 26547, 26615, 26614, 26606, 26595, 26562,
    26553, 26574, 26599, 26608, 26546, 26620, 26566, 26605, 26572, 26542,
    26598, 26587, 26618, 26569, 26570, 26563, 26602, 26571, 27432, 27522,
    27524, 27574, 27606, 27608, 27616, 27680, 27681, 27944, 27956, 27949,
    27935, 27964, 27967, 27922, 27914, 27866, 27955, 27908, 27929, 27962,
    27930, 27921, 27904, 27933, 27970, 27905, 27928, 27959, 27907, 27919,
    27968, 27911, 27936, 27948, 27912, 27938, 27913, 27920, 28855, 28831,
    28862, 28849, 28848, 28833, 28852, 28853, 28841, 29249, 29257, 29258,
    29292, 29296, 29299, 29294, 29386, 29412, 29416, 29419, 29407, 29418,
    29414, 29411, 29573, 29644, 29634, 29640, 29637, 29625, 29622, 29621,
    29620, 29675, 29631, 29639, 29630, 29635, 29638, 29624, 29643, 29932,
    29934, 29998, 30023, 30024, 30119, 30122, 30329, 30404, 30472, 30467,
    30468, 30469, 30474, 30455, 30459, 30458, 30695, 30696, 30726, 30737,
    30738, 30725, 30736, 30735, 30734, 30729, 30723, 30739, 31050, 31052,
    31051, 31045, 31044, 31189, 31181, 31183, 31190, 31182, 31360, 31358,
    31441, 31488, 31489, 31866, 31864, 31865, 31871, 31872, 31873, 32003,
    32008, 32001, 32600, 32657, 32653, 32702, 32775, 32782, 32783, 32788,
    32823, 32984, 32967, 32992, 32977, 32968, 32962, 32976, 32965, 32995,
    32985, 32988, 32970, 32981, 32969, 32975, 32983, 32998, 32973, 33279,
    33313, 33428, 33497, 33534, 33529, 33543, 33512, 33536, 33493, 33594,
    33515, 33494, 33524, 33516, 33505, 33522, 33525, 33548, 33531, 33526,
    33520, 33514, 33508, 33504, 33530, 33523, 33517, 34423, 34420, 34428,
    34419, 34881, 34894, 34919, 34922, 34921, 35283, 35332, 35335, 36210,
    36835, 36833, 36846, 36832, 37105, 37053, 37055, 37077, 37061, 37054,
    37063, 37067, 37064, 37332, 37331, 38484, 38479, 38481, 38483, 38474,
    38478, 20510, 20485, 20487, 20499, 20514, 20528, 20507, 20469, 20468,
    20531, 20535, 20524, 20470, 20471, 20503, 20508, 20512, 20519, 20533,
    20527, 20529, 20494, 20826, 20884, 20883, 20938, 20932, 20933, 20936,
    20942, 21089, 21082, 21074, 21086, 21087, 21077, 21090, 21197, 21262,
    21406, 21798, 21730, 21783, 21778, 21735, 21747, 21732, 21786, 21759,
    21764, 21768, 21739, 21777, 21765, 21745, 21770, 21755, 21751, 21752,
    21728, 21774, 21763, 21771, 22273, 22274, 22476, 22578, 22485, 22482,
    22458, 22470, 22461, 22460, 22456, 22454, 22463, 22471, 22480, 22457,
    22465, 22798, 22858, 23065, 23062, 23085, 23086, 23061, 23055, 23063,
    23050, 23070, 23091, 23404, 23463, 23469, 23468, 23555, 23638, 23636,
    23788, 23807, 23790, 23793, 23799, 23808, 23801, 24105, 24104, 24232,
    24238, 24234, 24236, 24371, 24368, 24423, 24669, 24666, 24679, 24641,
    24738, 24712, 24704, 24722, 24705, 24733, 24707, 24725, 24731, 24727,
    24711, 24732, 24718, 25113, 25158, 25330, 25360, 25430, 25388, 25412,
    25413, 25398, 25411, 25572, 25401, 25419, 25418, 25404, 25385, 25409,
    25396, 25432, 25428, 25433, 25389, 25415, 25395, 25434, 25425, 25400,
    25431, 25408, 25416, 25930, 25926, 26054, 26051, 26052, 26050, 26186,
    26207, 26183, 26193, 26386, 26387, 26655, 26650, 26697, 26674, 26675,
    26683, 26699, 26703, 26646, 26673, 26652, 26677, 26667, 26669, 26671,
    26702, 26692, 26676, 26653, 26642, 26644, 26662, 26664, 26670, 26701,
    26682, 26661, 26656, 27436, 27439, 27437, 27441, 27444, 27501, 32898,
    27528, 27622, 27620, 27624, 27619, 27618, 27623, 27685, 28026, 28003,
    28004, 28022, 27917, 28001, 28050, 27992, 28002, 28013, 28015, 28049,
    28045, 28143, 28031, 28038, 27998, 28007, 28000, 28055, 28016, 28028,
    27999, 28034, 28056, 27951, 28008, 28043, 28030, 28032, 28036, 27926,
    28035, 28027, 28029, 28021, 28048, 28892, 28883, 28881, 28893, 28875,
    32569, 28898, 28887, 28882, 28894, 28896, 28884, 28877, 28869, 28870,
    28871, 28890, 28878, 28897, 29250, 29304, 29303, 29302, 29440, 29434,
    29428, 29438, 29430, 29427, 29435, 29441, 29651, 29657, 29669, 29654,
    29628, 29671, 29667, 29673, 29660, 29650, 29659, 29652, 29661, 29658,
    29655, 29656, 29672, 29918, 29919, 29940, 29941, 29985, 30043, 30047,
    30128, 30145, 30139, 30148, 30144, 30143, 30134, 30138, 30346, 30409,
    30493, 30491, 30480, 30483, 30482, 30499, 30481, 30485, 30489, 30490,
    30498, 30503, 30755, 30764, 30754, 30773, 30767, 30760, 30766, 30763,
    30753, 30761, 30771, 30762, 30769, 31060, 31067, 31055, 31068, 31059,
    31058, 31057, 31211, 31212, 31200, 31214, 31213, 31210, 31196, 31198,
    31197, 31366, 31369, 31365, 31371, 31372, 31370, 31367, 31448, 31504,
    31492, 31507, 31493, 31503, 31496, 31498, 31502, 31497, 31506, 31876,
    31889, 31882, 31884, 31880, 31885, 31877, 32030, 32029, 32017, 32014,
    32024, 32022, 32019, 32031, 32018, 32015, 32012, 32604, 32609, 32606,
    32608, 32605, 32603, 32662, 32658, 32707, 32706, 32704, 32790, 32830,
    32825, 33018, 33010, 33017, 33013, 33025, 33019, 33024, 33281, 33327,
    33317, 33587, 33581, 33604, 33561, 33617, 33573, 33622, 33599, 33601,
    33574, 33564, 33570, 33602, 33614, 33563, 33578, 33544, 33596, 33613,
    33558, 33572, 33568, 33591, 33583, 33577, 33607, 33605, 33612, 33619,
    33566, 33580, 33611, 33575, 33608, 34387, 34386, 34466, 34472, 34454,
    34445, 34449, 34462, 34439, 34455, 34438, 34443, 34458, 34437, 34469,
    34457, 34465, 34471, 34453, 34456, 34446, 34461, 34448, 34452, 34883,
    34884, 34925, 34933, 34934, 34930, 34944, 34929, 34943, 34927, 34947,
    34942, 34932, 34940, 35346, 35911, 35927, 35963, 36004, 36003, 36214,
    36216, 36277, 36279, 36278, 36561, 36563, 36862, 36853, 36866, 36863,
    36859, 36868, 36860, 36854, 37078, 37088, 37081, 37082, 37091, 37087,
    37093, 37080, 37083, 37079, 37084, 37092, 37200, 37198, 37199, 37333,
    37346, 37338, 38492, 38495, 38588, 39139, 39647, 39727, 20095, 20592,
    20586, 20577, 20574, 20576, 20563, 20555, 20573, 20594, 20552, 20557,
    20545, 20571, 20554, 20578, 20501, 20549, 20575, 20585, 20587, 20579,
    20580, 20550, 20544, 20590, 20595, 20567, 20561, 20944, 21099, 21101,
    21100, 21102, 21206, 21203, 21293, 21404, 21877, 21878, 21820, 21837,
    21840, 21812, 21802, 21841, 21858, 21814, 21813, 21808, 21842, 21829,
    21772, 21810, 21861, 21838, 21817, 21832, 21805, 21819, 21824, 21835,
    22282, 22279, 22523, 22548, 22498, 22518, 22492, 22516, 22528, 22509,
    22525, 22536, 22520, 22539, 22515, 22479, 22535, 22510, 22499, 22514,
    22501, 22508, 22497, 22542, 22524, 22544, 22503, 22529, 22540, 22513,
    22505, 22512, 22541, 22532, 22876, 23136, 23128, 23125, 23143, 23134,
    23096, 23093, 23149, 23120, 23135, 23141, 23148, 23123, 23140, 23127,
    23107, 23133, 23122, 23108, 23131, 23112, 23182, 23102, 23117, 23097,
    23116, 23152, 23145, 23111, 23121, 23126, 23106, 23132, 23410, 23406,
    23489, 23488, 23641, 23838, 23819, 23837, 23834, 23840, 23820, 23848,
    23821, 23846, 23845, 23823, 23856, 23826, 23843, 23839, 23854, 24126,
    24116, 24241, 24244, 24249, 24242, 24243, 24374, 24376, 24475, 24470,
    24479, 24714, 24720, 24710, 24766, 24752, 24762, 24787, 24788, 24783,
    24804, 24793, 24797, 24776, 24753, 24795, 24759, 24778, 24767, 24771,
    24781, 24768, 25394, 25445, 25482, 25474, 25469, 25533, 25502, 25517,
    25501, 25495, 25515, 25486, 25455, 25479, 25488, 25454, 25519, 25461,
    25500, 25453, 25518, 25468, 25508, 25403, 25503, 25464, 25477, 25473,
    25489, 25485, 25456, 25939, 26061, 26213, 26209, 26203, 26201, 26204,
    26210, 26392, 26745, 26759, 26768, 26780, 26733, 26734, 26798, 26795,
    26966, 26735, 26787, 26796, 26793, 26741, 26740, 26802, 26767, 26743,
    26770, 26748, 26731, 26738, 26794, 26752, 26737, 26750, 26779, 26774,
    26763, 26784, 26761, 26788, 26744, 26747, 26769, 26764, 26762, 26749,
    27446, 27443, 27447, 27448, 27537, 27535, 27533, 27534, 27532, 27690,
    28096, 28075, 28084, 28083, 28276, 28076, 28137, 28130, 28087, 28150,
    28116, 28160, 28104, 28128, 28127, 28118, 28094, 28133, 28124, 28125,
    28123, 28148, 28106, 28093, 28141, 28144, 28090, 28117, 28098, 28111,
    28105, 28112, 28146, 28115, 28157, 28119, 28109, 28131, 28091, 28922,
    28941, 28919, 28951, 28916, 28940, 28912, 28932, 28915, 28944, 28924,
    28927, 28934, 28947, 28928, 28920, 28918, 28939, 28930, 28942, 29310,
    29307, 29308, 29311, 29469, 29463, 29447, 29457, 29464, 29450, 29448,
    29439, 29455, 29470, 29576, 29686, 29688, 29685, 29700, 29697, 29693,
    29703, 29696, 29690, 29692, 29695, 29708, 29707, 29684, 29704, 30052,
    30051, 30158, 30162, 30159, 30155, 30156, 30161, 30160, 30351, 30345,
    30419, 30521, 30511, 30509, 30513, 30514, 30516, 30515, 30525, 30501,
    30523, 30517, 30792, 30802, 30793, 30797, 30794, 30796, 30758, 30789,
    30800, 31076, 31079, 31081, 31082, 31075, 31083, 31073, 31163, 31226,
    31224, 31222, 31223, 31375, 31380, 31376, 31541, 31559, 31540, 31525,
    31536, 31522, 31524, 31539, 31512, 31530, 31517, 31537, 31531, 31533,
    31535, 31538, 31544, 31514, 31523, 31892, 31896, 31894, 31907, 32053,
    32061, 32056, 32054, 32058, 32069, 32044, 32041, 32065, 32071, 32062,
    32063, 32074, 32059, 32040, 32611, 32661, 32668, 32669, 32667, 32714,
    32715, 32717, 32720, 32721, 32711, 32719, 32713, 32799, 32798, 32795,
    32839, 32835, 32840, 33048, 33061, 33049, 33051, 33069, 33055, 33068,
    33054, 33057, 33045, 33063, 33053, 33058, 33297, 33336, 33331, 33338,
    33332, 33330, 33396, 33680, 33699, 33704, 33677, 33658, 33651, 33700,
    33652, 33679, 33665, 33685, 33689, 33653, 33684, 33705, 33661, 33667,
    33676, 33693, 33691, 33706, 33675, 33662, 33701, 33711, 33672, 33687,
    33712, 33663, 33702, 33671, 33710, 33654, 33690, 34393, 34390, 34495,
    34487, 34498, 34497, 34501, 34490, 34480, 34504, 34489, 34483, 34488,
    34508, 34484, 34491, 34492, 34499, 34493, 34494, 34898, 34953, 34965,
    34984, 34978, 34986, 34970, 34961, 34977, 34975, 34968, 34983, 34969,
    34971, 34967, 34980, 34988, 34956, 34963, 34958, 35202, 35286, 35289,
    35285, 35376, 35367, 35372, 35358, 35897, 35899, 35932, 35933, 35965,
    36005, 36221, 36219, 36217, 36284, 36290, 36281, 36287, 36289, 36568,
    36574, 36573, 36572, 36567, 36576, 36577, 36900, 36875, 36881, 36892,
    36876, 36897, 37103, 37098, 37104, 37108, 37106, 37107, 37076, 37099,
    37100, 37097, 37206, 37208, 37210, 37203, 37205, 37356, 37364, 37361,
    37363, 37368, 37348, 37369, 37354, 37355, 37367, 37352, 37358, 38266,
    38278, 38280, 38524, 38509, 38507, 38513, 38511, 38591, 38762, 38916,
    39141, 39319, 20635, 20629, 20628, 20638, 20619, 20643, 20611, 20620,
    20622, 20637, 20584, 20636, 20626, 20610, 20615, 20831, 20948, 21266,
    21265, 21412, 21415, 21905, 21928, 21925, 21933, 21879, 22085, 21922,
    21907, 21896, 21903, 21941, 21889, 21923, 21906, 21924, 21885, 21900,
    21926, 21887, 21909, 21921, 21902, 22284, 22569, 22583, 22553, 22558,
    22567, 22563, 22568, 22517, 22600, 22565, 22556, 22555, 22579, 22591,
    22582, 22574, 22585, 22584, 22573, 22572, 22587, 22881, 23215, 23188,
    23199, 23162, 23202, 23198, 23160, 23206, 23164, 23205, 23212, 23189,
    23214, 23095, 23172, 23178, 23191, 23171, 23179, 23209, 23163, 23165,
    23180, 23196, 23183, 23187, 23197, 23530, 23501, 23499, 23508, 23505,
    23498, 23502, 23564, 23600, 23863, 23875, 23915, 23873, 23883, 23871,
    23861, 23889, 23886, 23893, 23859, 23866, 23890, 23869, 23857, 23897,
    23874, 23865, 23881, 23864, 23868, 23858, 23862, 23872, 23877, 24132,
    24129, 24408, 24486, 24485, 24491, 24777, 24761, 24780, 24802, 24782,
    24772, 24852, 24818, 24842, 24854, 24837, 24821, 24851, 24824, 24828,
    24830, 24769, 24835, 24856, 24861, 24848, 24831, 24836, 24843, 25162,
    25492, 25521, 25520, 25550, 25573, 25576, 25583, 25539, 25757, 25587,
    25546, 25568, 25590, 25557, 25586, 25589, 25697, 25567, 25534, 25565,
    25564, 25540, 25560, 25555, 25538, 25543, 25548, 25547, 25544, 25584,
    25559, 25561, 25906, 25959, 25962, 25956, 25948, 25960, 25957, 25996,
    26013, 26014, 26030, 26064, 26066, 26236, 26220, 26235, 26240, 26225,
    26233, 26218, 26226, 26369, 26892, 26835, 26884, 26844, 26922, 26860,
    26858, 26865, 26895, 26838, 26871, 26859, 26852, 26870, 26899, 26896,
    26867, 26849, 26887, 26828, 26888, 26992, 26804, 26897, 26863, 26822,
    26900, 26872, 26832, 26877, 26876, 26856, 26891, 26890, 26903, 26830,
    26824, 26845, 26846, 26854, 26868, 26833, 26886, 26836, 26857, 26901,
    26917, 26823, 27449, 27451, 27455, 27452, 27540, 27543, 27545, 27541,
    27581, 27632, 27634, 27635, 27696, 28156, 28230, 28231, 28191, 28233,
    28296, 28220, 28221, 28229, 28258, 28203, 28223, 28225, 28253, 28275,
    28188, 28211, 28235, 28224, 28241, 28219, 28163, 28206, 28254, 28264,
    28252, 28257, 28209, 28200, 28256, 28273, 28267, 28217, 28194, 28208,
    28243, 28261, 28199, 28280, 28260, 28279, 28245, 28281, 28242, 28262,
    28213, 28214, 28250, 28960, 28958, 28975, 28923, 28974, 28977, 28963,
    28965, 28962, 28978, 28959, 28968, 28986, 28955, 29259, 29274, 29320,
    29321, 29318, 29317, 29323, 29458, 29451, 29488, 29474, 29489, 29491,
    29479, 29490, 29485, 29478, 29475, 29493, 29452, 29742, 29740, 29744,
    29739, 29718, 29722, 29729, 29741, 29745, 29732, 29731, 29725, 29737,
    29728, 29746, 29947, 29999, 30063, 30060, 30183, 30170, 30177, 30182,
    30173, 30175, 30180, 30167, 30357, 30354, 30426, 30534, 30535, 30532,
    30541, 30533, 30538, 30542, 30539, 30540, 30686, 30700, 30816, 30820,
    30821, 30812, 30829, 30833, 30826, 30830, 30832, 30825, 30824, 30814,
    30818, 31092, 31091, 31090, 31088, 31234, 31242, 31235, 31244, 31236,
    31385, 31462, 31460, 31562, 31547, 31556, 31560, 31564, 31566, 31552,
    31576, 31557, 31906, 31902, 31912, 31905, 32088, 32111, 32099, 32083,
    32086, 32103, 32106, 32079, 32109, 32092, 32107, 32082, 32084, 32105,
    32081, 32095, 32078, 32574, 32575, 32613, 32614, 32674, 32672, 32673,
    32727, 32849, 32847, 32848, 33022, 32980, 33091, 33098, 33106, 33103,
    33095, 33085, 33101, 33082, 33254, 33262, 33271, 33272, 33273, 33284,
    33340, 33341, 33343, 33397, 33595, 33743, 33785, 33827, 33728, 33768,
    33810, 33767, 33764, 33788, 33782, 33808, 33734, 33736, 33771, 33763,
    33727, 33793, 33757, 33765, 33752, 33791, 33761, 33739, 33742, 33750,
    33781, 33737, 33801, 33807, 33758, 33809, 33798, 33730, 33779, 33749,
    33786, 33735, 33745, 33770, 33811, 33731, 33772, 33774, 33732, 33787,
    33751, 33762, 33819, 33755, 33790, 34520, 34530, 34534, 34515, 34531,
    34522, 34538, 34525, 34539, 34524, 34540, 34537, 34519, 34536, 34513,
    34888, 34902, 34901, 35002, 35031, 35001, 35000, 35008, 35006, 34998,
    35004, 34999, 35005, 34994, 35073, 35017, 35221, 35224, 35223, 35293,
    35290, 35291, 35406, 35405, 35385, 35417, 35392, 35415, 35416, 35396,
    35397, 35410, 35400, 35409, 35402, 35404, 35407, 35935, 35969, 35968,
    36026, 36030, 36016, 36025, 36021, 36228, 36224, 36233, 36312, 36307,
    36301, 36295, 36310, 36316, 36303, 36309, 36313, 36296, 36311, 36293,
    36591, 36599, 36602, 36601, 36582, 36590, 36581, 36597, 36583, 36584,
    36598, 36587, 36593, 36588, 36596, 36585, 36909, 36916, 36911, 37126,
    37164, 37124, 37119, 37116, 37128, 37113, 37115, 37121, 37120, 37127,
    37125, 37123, 37217, 37220, 37215, 37218, 37216, 37377, 37386, 37413,
    37379, 37402, 37414, 37391, 37388, 37376, 37394, 37375, 37373, 37382,
    37380, 37415, 37378, 37404, 37412, 37401, 37399, 37381, 37398, 38267,
    38285, 38284, 38288, 38535, 38526, 38536, 38537, 38531, 38528, 38594,
    38600, 38595, 38641, 38640, 38764, 38768, 38766, 38919, 39081, 39147,
    40166, 40697, 20099, 20100, 20150, 20669, 20671, 20678, 20654, 20676,
    20682, 20660, 20680, 20674, 20656, 20673, 20666, 20657, 20683, 20681,
    20662, 20664, 20951, 21114, 21112, 21115, 21116, 21955, 21979, 21964,
    21968, 21963, 21962, 21981, 21952, 21972, 21956, 21993, 21951, 21970,
    21901, 21967, 21973, 21986, 21974, 21960, 22002, 21965, 21977, 21954,
    22292, 22611, 22632, 22628, 22607, 22605, 22601, 22639, 22613, 22606,
    22621, 22617, 22629, 22619, 22589, 22627, 22641, 22780, 23239, 23236,
    23243, 23226, 23224, 23217, 23221, 23216, 23231, 23240, 23227, 23238,
    23223, 23232, 23242, 23220, 23222, 23245, 23225, 23184, 23510, 23512,
    23513, 23583, 23603, 23921, 23907, 23882, 23909, 23922, 23916, 23902,
    23912, 23911, 23906, 24048, 24143, 24142, 24138, 24141, 24139, 24261,
    24268, 24262, 24267, 24263, 24384, 24495, 24493, 24823, 24905, 24906,
    24875, 24901, 24886, 24882, 24878, 24902, 24879, 24911, 24873, 24896,
    25120, 37224, 25123, 25125, 25124, 25541, 25585, 25579, 25616, 25618,
    25609, 25632, 25636, 25651, 25667, 25631, 25621, 25624, 25657, 25655,
    25634, 25635, 25612, 25638, 25648, 25640, 25665, 25653, 25647, 25610,
    25626, 25664, 25637, 25639, 25611, 25575, 25627, 25646, 25633, 25614,
    25967, 26002, 26067, 26246, 26252, 26261, 26256, 26251, 26250, 26265,
    26260, 26232, 26400, 26982, 26975, 26936, 26958, 26978, 26993, 26943,
    26949, 26986, 26937, 26946, 26967, 26969, 27002, 26952, 26953, 26933,
    26988, 26931, 26941, 26981, 26864, 27000, 26932, 26985, 26944, 26991,
    26948, 26998, 26968, 26945, 26996, 26956, 26939, 26955, 26935, 26972,
    26959, 26961, 26930, 26962, 26927, 27003, 26940, 27462, 27461, 27459,
    27458, 27464, 27457, 27547, 64013, 27643, 27644, 27641, 27639, 27640,
    28315, 28374, 28360, 28303, 28352, 28319, 28307, 28308, 28320, 28337,
    28345, 28358, 28370, 28349, 28353, 28318, 28361, 28343, 28336, 28365,
    28326, 28367, 28338, 28350, 28355, 28380, 28376, 28313, 28306, 28302,
    28301, 28324, 28321, 28351, 28339, 28368, 28362, 28311, 28334, 28323,
    28999, 29012, 29010, 29027, 29024, 28993, 29021, 29026, 29042, 29048,
    29034, 29025, 28994, 29016, 28995, 29003, 29040, 29023, 29008, 29011,
    28996, 29005, 29018, 29263, 29325, 29324, 29329, 29328, 29326, 29500,
    29506, 29499, 29498, 29504, 29514, 29513, 29764, 29770, 29771, 29778,
    29777, 29783, 29760, 29775, 29776, 29774, 29762, 29766, 29773, 29780,
    29921, 29951, 29950, 29949, 29981, 30073, 30071, 27011, 30191, 30223,
    30211, 30199, 30206, 30204, 30201, 30200, 30224, 30203, 30198, 30189,
    30197, 30205, 30361, 30389, 30429, 30549, 30559, 30560, 30546, 30550,
    30554, 30569, 30567, 30548, 30553, 30573, 30688, 30855, 30874, 30868,
    30863, 30852, 30869, 30853, 30854, 30881, 30851, 30841, 30873, 30848,
    30870, 30843, 31100, 31106, 31101, 31097, 31249, 31256, 31257, 31250,
    31255, 31253, 31266, 31251, 31259, 31248, 31395, 31394, 31390, 31467,
    31590, 31588, 31597, 31604, 31593, 31602, 31589, 31603, 31601, 31600,
    31585, 31608, 31606, 31587, 31922, 31924, 31919, 32136, 32134, 32128,
    32141, 32127, 32133, 32122, 32142, 32123, 32131, 32124, 32140, 32148,
    32132, 32125, 32146, 32621, 32619, 32615, 32616, 32620, 32678, 32677,
    32679, 32731, 32732, 32801, 33124, 33120, 33143, 33116, 33129, 33115,
    33122, 33138, 26401, 33118, 33142, 33127, 33135, 33092, 33121, 33309,
    33353, 33348, 33344, 33346, 33349, 34033, 33855, 33878, 33910, 33913,
    33935, 33933, 33893, 33873, 33856, 33926, 33895, 33840, 33869, 33917,
    33882, 33881, 33908, 33907, 33885, 34055, 33886, 33847, 33850, 33844,
    33914, 33859, 33912, 33842, 33861, 33833, 33753, 33867, 33839, 33858,
    33837, 33887, 33904, 33849, 33870, 33868, 33874, 33903, 33989, 33934,
    33851, 33863, 33846, 33843, 33896, 33918, 33860, 33835, 33888, 33876,
    33902, 33872, 34571, 34564, 34551, 34572, 34554, 34518, 34549, 34637,
    34552, 34574, 34569, 34561, 34550, 34573, 34565, 35030, 35019, 35021,
    35022, 35038, 35035, 35034, 35020, 35024, 35205, 35227, 35295, 35301,
    35300, 35297, 35296, 35298, 35292, 35302, 35446, 35462, 35455, 35425,
    35391, 35447, 35458, 35460, 35445, 35459, 35457, 35444, 35450, 35900,
    35915, 35914, 35941, 35940, 35942, 35974, 35972, 35973, 36044, 36200,
    36201, 36241, 36236, 36238, 36239, 36237, 36243, 36244, 36240, 36242,
    36336, 36320, 36332, 36337, 36334, 36304, 36329, 36323, 36322, 36327,
    36338, 36331, 36340, 36614, 36607, 36609, 36608, 36613, 36615, 36616,
    36610, 36619, 36946, 36927, 36932, 36937, 36925, 37136, 37133, 37135,
    37137, 37142, 37140, 37131, 37134, 37230, 37231, 37448, 37458, 37424,
    37434, 37478, 37427, 37477, 37470, 37507, 37422, 37450, 37446, 37485,
    37484, 37455, 37472, 37479, 37487, 37430, 37473, 37488, 37425, 37460,
    37475, 37456, 37490, 37454, 37459, 37452, 37462, 37426, 38303, 38300,
    38302, 38299, 38546, 38547, 38545, 38551, 38606, 38650, 38653, 38648,
    38645, 38771, 38775, 38776, 38770, 38927, 38925, 38926, 39084, 39158,
    39161, 39343, 39346, 39344, 39349, 39597, 39595, 39771, 40170, 40173,
    40167, 40576, 40701, 20710, 20692, 20695, 20712, 20723, 20699, 20714,
    20701, 20708, 20691, 20716, 20720, 20719, 20707, 20704, 20952, 21120,
    21121, 21225, 21227, 21296, 21420, 22055, 22037, 22028, 22034, 22012,
    22031, 22044, 22017, 22035, 22018, 22010, 22045, 22020, 22015, 22009,
    22665, 22652, 22672, 22680, 22662, 22657, 22655, 22644, 22667, 22650,
    22663, 22673, 22670, 22646, 22658, 22664, 22651, 22676, 22671, 22782,
    22891, 23260, 23278, 23269, 23253, 23274, 23258, 23277, 23275, 23283,
    23266, 23264, 23259, 23276, 23262, 23261, 23257, 23272, 23263, 23415,
    23520, 23523, 23651, 23938, 23936, 23933, 23942, 23930, 23937, 23927,
    23946, 23945, 23944, 23934, 23932, 23949, 23929, 23935, 24152, 24153,
    24147, 24280, 24273, 24279, 24270, 24284, 24277, 24281, 24274, 24276,
    24388, 24387, 24431, 24502, 24876, 24872, 24897, 24926, 24945, 24947,
    24914, 24915, 24946, 24940, 24960, 24948, 24916, 24954, 24923, 24933,
    24891, 24938, 24929, 24918, 25129, 25127, 25131, 25643, 25677, 25691,
    25693, 25716, 25718, 25714, 25715, 25725, 25717, 25702, 25766, 25678,
    25730, 25694, 25692, 25675, 25683, 25696, 25680, 25727, 25663, 25708,
    25707, 25689, 25701, 25719, 25971, 26016, 26273, 26272, 26271, 26373,
    26372, 26402, 27057, 27062, 27081, 27040, 27086, 27030, 27056, 27052,
    27068, 27025, 27033, 27022, 27047, 27021, 27049, 27070, 27055, 27071,
    27076, 27069, 27044, 27092, 27065, 27082, 27034, 27087, 27059, 27027,
    27050, 27041, 27038, 27097, 27031, 27024, 27074, 27061, 27045, 27078,
    27466, 27469, 27467, 27550, 27551, 27552, 27587, 27588, 27646, 28366,
    28405, 28401, 28419, 28453, 28408, 28471, 28411, 28462, 28425, 28494,
    28441, 28442, 28455, 28440, 28475, 28434, 28397, 28426, 28470, 28531,
    28409, 28398, 28461, 28480, 28464, 28476, 28469, 28395, 28423, 28430,
    28483, 28421, 28413, 28406, 28473, 28444, 28412, 28474, 28447, 28429,
    28446, 28424, 28449, 29063, 29072, 29065, 29056, 29061, 29058, 29071,
    29051, 29062, 29057, 29079, 29252, 29267, 29335, 29333, 29331, 29507,
    29517, 29521, 29516, 29794, 29811, 29809, 29813, 29810, 29799, 29806,
    29952, 29954, 29955, 30077, 30096, 30230, 30216, 30220, 30229, 30225,
    30218, 30228, 30392, 30593, 30588, 30597, 30594, 30574, 30592, 30575,
    30590, 30595, 30898, 30890, 30900, 30893, 30888, 30846, 30891, 30878,
    30885, 30880, 30892, 30882, 30884, 31128, 31114, 31115, 31126, 31125,
    31124, 31123, 31127, 31112, 31122, 31120, 31275, 31306, 31280, 31279,
    31272, 31270, 31400, 31403, 31404, 31470, 31624, 31644, 31626, 31633,
    31632, 31638, 31629, 31628, 31643, 31630, 31621, 31640, 21124, 31641,
    31652, 31618, 31931, 31935, 31932, 31930, 32167, 32183, 32194, 32163,
    32170, 32193, 32192, 32197, 32157, 32206, 32196, 32198, 32203, 32204,
    32175, 32185, 32150, 32188, 32159, 32166, 32174, 32169, 32161, 32201,
    32627, 32738, 32739, 32741, 32734, 32804, 32861, 32860, 33161, 33158,
    33155, 33159, 33165, 33164, 33163, 33301, 33943, 33956, 33953, 33951,
    33978, 33998, 33986, 33964, 33966, 33963, 33977, 33972, 33985, 33997,
    33962, 33946, 33969, 34000, 33949, 33959, 33979, 33954, 33940, 33991,
    33996, 33947, 33961, 33967, 33960, 34006, 33944, 33974, 33999, 33952,
    34007, 34004, 34002, 34011, 33968, 33937, 34401, 34611, 34595, 34600,
    34667, 34624, 34606, 34590, 34593, 34585, 34587, 34627, 34604, 34625,
    34622, 34630, 34592, 34610, 34602, 34605, 34620, 34578, 34618, 34609,
    34613, 34626, 34598, 34599, 34616, 34596, 34586, 34608, 34577, 35063,
    35047, 35057, 35058, 35066, 35070, 35054, 35068, 35062, 35067, 35056,
    35052, 35051, 35229, 35233, 35231, 35230, 35305, 35307, 35304, 35499,
    35481, 35467, 35474, 35471, 35478, 35901, 35944, 35945, 36053, 36047,
    36055, 36246, 36361, 36354, 36351, 36365, 36349, 36362, 36355, 36359,
    36358, 36357, 36350, 36352, 36356, 36624, 36625, 36622, 36621, 37155,
    37148, 37152, 37154, 37151, 37149, 37146, 37156, 37153, 37147, 37242,
    37234, 37241, 37235, 37541, 37540, 37494, 37531, 37498, 37536, 37524,
    37546, 37517, 37542, 37530, 37547, 37497, 37527, 37503, 37539, 37614,
    37518, 37506, 37525, 37538, 37501, 37512, 37537, 37514, 37510, 37516,
    37529, 37543, 37502, 37511, 37545, 37533, 37515, 37421, 38558, 38561,
    38655, 38744, 38781, 38778, 38782, 38787, 38784, 38786, 38779, 38788,
    38785, 38783, 38862, 38861, 38934, 39085, 39086, 39170, 39168, 39175,
    39325, 39324, 39363, 39353, 39355, 39354, 39362, 39357, 39367, 39601,
    39651, 39655, 39742, 39743, 39776, 39777, 39775, 40177, 40178, 40181,
    40615, 20735, 20739, 20784, 20728, 20742, 20743, 20726, 20734, 20747,
    20748, 20733, 20746, 21131, 21132, 21233, 21231, 22088, 22082, 22092,
    22069, 22081, 22090, 22089, 22086, 22104, 22106, 22080, 22067, 22077,
    22060, 22078, 22072, 22058, 22074, 22298, 22699, 22685, 22705, 22688,
    22691, 22703, 22700, 22693, 22689, 22783, 23295, 23284, 23293, 23287,
    23286, 23299, 23288, 23298, 23289, 23297, 23303, 23301, 23311, 23655,
    23961, 23959, 23967, 23954, 23970, 23955, 23957, 23968, 23964, 23969,
    23962, 23966, 24169, 24157, 24160, 24156, 32243, 24283, 24286, 24289,
    24393, 24498, 24971, 24963, 24953, 25009, 25008, 24994, 24969, 24987,
    24979, 25007, 25005, 24991, 24978, 25002, 24993, 24973, 24934, 25011,
    25133, 25710, 25712, 25750, 25760, 25733, 25751, 25756, 25743, 25739,
    25738, 25740, 25763, 25759, 25704, 25777, 25752, 25974, 25978, 25977,
    25979, 26034, 26035, 26293, 26288, 26281, 26290, 26295, 26282, 26287,
    27136, 27142, 27159, 27109, 27128, 27157, 27121, 27108, 27168, 27135,
    27116, 27106, 27163, 27165, 27134, 27175, 27122, 27118, 27156, 27127,
    27111, 27200, 27144, 27110, 27131, 27149, 27132, 27115, 27145, 27140,
    27160, 27173, 27151, 27126, 27174, 27143, 27124, 27158, 27473, 27557,
    27555, 27554, 27558, 27649, 27648, 27647, 27650, 28481, 28454, 28542,
    28551, 28614, 28562, 28557, 28553, 28556, 28514, 28495, 28549, 28506,
    28566, 28534, 28524, 28546, 28501, 28530, 28498, 28496, 28503, 28564,
    28563, 28509, 28416, 28513, 28523, 28541, 28519, 28560, 28499, 28555,
    28521, 28543, 28565, 28515, 28535, 28522, 28539, 29106, 29103, 29083,
    29104, 29088, 29082, 29097, 29109, 29085, 29093, 29086, 29092, 29089,
    29098, 29084, 29095, 29107, 29336, 29338, 29528, 29522, 29534, 29535,
    29536, 29533, 29531, 29537, 29530, 29529, 29538, 29831, 29833, 29834,
    29830, 29825, 29821, 29829, 29832, 29820, 29817, 29960, 29959, 30078,
    30245, 30238, 30233, 30237, 30236, 30243, 30234, 30248, 30235, 30364,
    30365, 30366, 30363, 30605, 30607, 30601, 30600, 30925, 30907, 30927,
    30924, 30929, 30926, 30932, 30920, 30915, 30916, 30921, 31130, 31137,
    31136, 31132, 31138, 31131, 27510, 31289, 31410, 31412, 31411, 31671,
    31691, 31678, 31660, 31694, 31663, 31673, 31690, 31669, 31941, 31944,
    31948, 31947, 32247, 32219, 32234, 32231, 32215, 32225, 32259, 32250,
    32230, 32246, 32241, 32240, 32238, 32223, 32630, 32684, 32688, 32685,
    32749, 32747, 32746, 32748, 32742, 32744, 32868, 32871, 33187, 33183,
    33182, 33173, 33186, 33177, 33175, 33302, 33359, 33363, 33362, 33360,
    33358, 33361, 34084, 34107, 34063, 34048, 34089, 34062, 34057, 34061,
    34079, 34058, 34087, 34076, 34043, 34091, 34042, 34056, 34060, 34036,
    34090, 34034, 34069, 34039, 34027, 34035, 34044, 34066, 34026, 34025,
    34070, 34046, 34088, 34077, 34094, 34050, 34045, 34078, 34038, 34097,
    34086, 34023, 34024, 34032, 34031, 34041, 34072, 34080, 34096, 34059,
    34073, 34095, 34402, 34646, 34659, 34660, 34679, 34785, 34675, 34648,
    34644, 34651, 34642, 34657, 34650, 34641, 34654, 34669, 34666, 34640,
    34638, 34655, 34653, 34671, 34668, 34682, 34670, 34652, 34661, 34639,
    34683, 34677, 34658, 34663, 34665, 34906, 35077, 35084, 35092, 35083,
    35095, 35096, 35097, 35078, 35094, 35089, 35086, 35081, 35234, 35236,
    35235, 35309, 35312, 35308, 35535, 35526, 35512, 35539, 35537, 35540,
    35541, 35515, 35543, 35518, 35520, 35525, 35544, 35523, 35514, 35517,
    35545, 35902, 35917, 35983, 36069, 36063, 36057, 36072, 36058, 36061,
    36071, 36256, 36252, 36257, 36251, 36384, 36387, 36389, 36388, 36398,
    36373, 36379, 36374, 36369, 36377, 36390, 36391, 36372, 36370, 36376,
    36371, 36380, 36375, 36378, 36652, 36644, 36632, 36634, 36640, 36643,
    36630, 36631, 36979, 36976, 36975, 36967, 36971, 37167, 37163, 37161,
    37162, 37170, 37158, 37166, 37253, 37254, 37258, 37249, 37250, 37252,
    37248, 37584, 37571, 37572, 37568, 37593, 37558, 37583, 37617, 37599,
    37592, 37609, 37591, 37597, 37580, 37615, 37570, 37608, 37578, 37576,
    37582, 37606, 37581, 37589, 37577, 37600, 37598, 37607, 37585, 37587,
    37557, 37601, 37574, 37556, 38268, 38316, 38315, 38318, 38320, 38564,
    38562, 38611, 38661, 38664, 38658, 38746, 38794, 38798, 38792, 38864,
    38863, 38942, 38941, 38950, 38953, 38952, 38944, 38939, 38951, 39090,
    39176, 39162, 39185, 39188, 39190, 39191, 39189, 39388, 39373, 39375,
    39379, 39380, 39374, 39369, 39382, 39384, 39371, 39383, 39372, 39603,
    39660, 39659, 39667, 39666, 39665, 39750, 39747, 39783, 39796, 39793,
    39782, 39798, 39797, 39792, 39784, 39780, 39788, 40188, 40186, 40189,
    40191, 40183, 40199, 40192, 40185, 40187, 40200, 40197, 40196, 40579,
    40659, 40719, 40720, 20764, 20755, 20759, 20762, 20753, 20958, 21300,
    21473, 22128, 22112, 22126, 22131, 22118, 22115, 22125, 22130, 22110,
    22135, 22300, 22299, 22728, 22717, 22729, 22719, 22714, 22722, 22716,
    22726, 23319, 23321, 23323, 23329, 23316, 23315, 23312, 23318, 23336,
    23322, 23328, 23326, 23535, 23980, 23985, 23977, 23975, 23989, 23984,
    23982, 23978, 23976, 23986, 23981, 23983, 23988, 24167, 24168, 24166,
    24175, 24297, 24295, 24294, 24296, 24293, 24395, 24508, 24989, 25000,
    24982, 25029, 25012, 25030, 25025, 25036, 25018, 25023, 25016, 24972,
    25815, 25814, 25808, 25807, 25801, 25789, 25737, 25795, 25819, 25843,
    25817, 25907, 25983, 25980, 26018, 26312, 26302, 26304, 26314, 26315,
    26319, 26301, 26299, 26298, 26316, 26403, 27188, 27238, 27209, 27239,
    27186, 27240, 27198, 27229, 27245, 27254, 27227, 27217, 27176, 27226,
    27195, 27199, 27201, 27242, 27236, 27216, 27215, 27220, 27247, 27241,
    27232, 27196, 27230, 27222, 27221, 27213, 27214, 27206, 27477, 27476,
    27478, 27559, 27562, 27563, 27592, 27591, 27652, 27651, 27654, 28589,
    28619, 28579, 28615, 28604, 28622, 28616, 28510, 28612, 28605, 28574,
    28618, 28584, 28676, 28581, 28590, 28602, 28588, 28586, 28623, 28607,
    28600, 28578, 28617, 28587, 28621, 28591, 28594, 28592, 29125, 29122,
    29119, 29112, 29142, 29120, 29121, 29131, 29140, 29130, 29127, 29135,
    29117, 29144, 29116, 29126, 29146, 29147, 29341, 29342, 29545, 29542,
    29543, 29548, 29541, 29547, 29546, 29823, 29850, 29856, 29844, 29842,
    29845, 29857, 29963, 30080, 30255, 30253, 30257, 30269, 30259, 30268,
    30261, 30258, 30256, 30395, 30438, 30618, 30621, 30625, 30620, 30619,
    30626, 30627, 30613, 30617, 30615, 30941, 30953, 30949, 30954, 30942,
    30947, 30939, 30945, 30946, 30957, 30943, 30944, 31140, 31300, 31304,
    31303, 31414, 31416, 31413, 31409, 31415, 31710, 31715, 31719, 31709,
    31701, 31717, 31706, 31720, 31737, 31700, 31722, 31714, 31708, 31723,
    31704, 31711, 31954, 31956, 31959, 31952, 31953, 32274, 32289, 32279,
    32268, 32287, 32288, 32275, 32270, 32284, 32277, 32282, 32290, 32267,
    32271, 32278, 32269, 32276, 32293, 32292, 32579, 32635, 32636, 32634,
    32689, 32751, 32810, 32809, 32876, 33201, 33190, 33198, 33209, 33205,
    33195, 33200, 33196, 33204, 33202, 33207, 33191, 33266, 33365, 33366,
    33367, 34134, 34117, 34155, 34125, 34131, 34145, 34136, 34112, 34118,
    34148, 34113, 34146, 34116, 34129, 34119, 34147, 34110, 34139, 34161,
    34126, 34158, 34165, 34133, 34151, 34144, 34188, 34150, 34141, 34132,
    34149, 34156, 34403, 34405, 34404, 34715, 34703, 34711, 34707, 34706,
    34696, 34689, 34710, 34712, 34681, 34695, 34723, 34693, 34704, 34705,
    34717, 34692, 34708, 34716, 34714, 34697, 35102, 35110, 35120, 35117,
    35118, 35111, 35121, 35106, 35113, 35107, 35119, 35116, 35103, 35313,
    35552, 35554, 35570, 35572, 35573, 35549, 35604, 35556, 35551, 35568,
    35528, 35550, 35553, 35560, 35583, 35567, 35579, 35985, 35986, 35984,
    36085, 36078, 36081, 36080, 36083, 36204, 36206, 36261, 36263, 36403,
    36414, 36408, 36416, 36421, 36406, 36412, 36413, 36417, 36400, 36415,
    36541, 36662, 36654, 36661, 36658, 36665, 36663, 36660, 36982, 36985,
    36987, 36998, 37114, 37171, 37173, 37174, 37267, 37264, 37265, 37261,
    37263, 37671, 37662, 37640, 37663, 37638, 37647, 37754, 37688, 37692,
    37659, 37667, 37650, 37633, 37702, 37677, 37646, 37645, 37579, 37661,
    37626, 37669, 37651, 37625, 37623, 37684, 37634, 37668, 37631, 37673,
    37689, 37685, 37674, 37652, 37644, 37643, 37630, 37641, 37632, 37627,
    37654, 38332, 38349, 38334, 38329, 38330, 38326, 38335, 38325, 38333,
    38569, 38612, 38667, 38674, 38672, 38809, 38807, 38804, 38896, 38904,
    38965, 38959, 38962, 39204, 39199, 39207, 39209, 39326, 39406, 39404,
    39397, 39396, 39408, 39395, 39402, 39401, 39399, 39609, 39615, 39604,
    39611, 39670, 39674, 39673, 39671, 39731, 39808, 39813, 39815, 39804,
    39806, 39803, 39810, 39827, 39826, 39824, 39802, 39829, 39805, 39816,
    40229, 40215, 40224, 40222, 40212, 40233, 40221, 40216, 40226, 40208,
    40217, 40223, 40584, 40582, 40583, 40622, 40621, 40661, 40662, 40698,
    40722, 40765, 20774, 20773, 20770, 20772, 20768, 20777, 21236, 22163,
    22156, 22157, 22150, 22148, 22147, 22142, 22146, 22143, 22145, 22742,
    22740, 22735, 22738, 23341, 23333, 23346, 23331, 23340, 23335, 23334,
    23343, 23342, 23419, 23537, 23538, 23991, 24172, 24170, 24510, 24507,
    25027, 25013, 25020, 25063, 25056, 25061, 25060, 25064, 25054, 25839,
    25833, 25827, 25835, 25828, 25832, 25985, 25984, 26038, 26074, 26322,
    27277, 27286, 27265, 27301, 27273, 27295, 27291, 27297, 27294, 27271,
    27283, 27278, 27285, 27267, 27304, 27300, 27281, 27263, 27302, 27290,
    27269, 27276, 27282, 27483, 27565, 27657, 28620, 28585, 28660, 28628,
    28643, 28636, 28653, 28647, 28646, 28638, 28658, 28637, 28642, 28648,
    29153, 29169, 29160, 29170, 29156, 29168, 29154, 29555, 29550, 29551,
    29847, 29874, 29867, 29840, 29866, 29869, 29873, 29861, 29871, 29968,
    29969, 29970, 29967, 30084, 30275, 30280, 30281, 30279, 30372, 30441,
    30645, 30635, 30642, 30647, 30646, 30644, 30641, 30632, 30704, 30963,
    30973, 30978, 30971, 30972, 30962, 30981, 30969, 30974, 30980, 31147,
    31144, 31324, 31323, 31318, 31320, 31316, 31322, 31422, 31424, 31425,
    31749, 31759, 31730, 31744, 31743, 31739, 31758, 31732, 31755, 31731,
    31746, 31753, 31747, 31745, 31736, 31741, 31750, 31728, 31729, 31760,
    31754, 31976, 32301, 32316, 32322, 32307, 38984, 32312, 32298, 32329,
    32320, 32327, 32297, 32332, 32304, 32315, 32310, 32324, 32314, 32581,
    32639, 32638, 32637, 32756, 32754, 32812, 33211, 33220, 33228, 33226,
    33221, 33223, 33212, 33257, 33371, 33370, 33372, 34179, 34176, 34191,
    34215, 34197, 34208, 34187, 34211, 34171, 34212, 34202, 34206, 34167,
    34172, 34185, 34209, 34170, 34168, 34135, 34190, 34198, 34182, 34189,
    34201, 34205, 34177, 34210, 34178, 34184, 34181, 34169, 34166, 34200,
    34192, 34207, 34408, 34750, 34730, 34733, 34757, 34736, 34732, 34745,
    34741, 34748, 34734, 34761, 34755, 34754, 34764, 34743, 34735, 34756,
    34762, 34740, 34742, 34751, 34744, 34749, 34782, 34738, 35125, 35123,
    35132, 35134, 35137, 35154, 35127, 35138, 35245, 35247, 35246, 35314,
    35315, 35614, 35608, 35606, 35601, 35589, 35595, 35618, 35599, 35602,
    35605, 35591, 35597, 35592, 35590, 35612, 35603, 35610, 35919, 35952,
    35954, 35953, 35951, 35989, 35988, 36089, 36207, 36430, 36429, 36435,
    36432, 36428, 36423, 36675, 36672, 36997, 36990, 37176, 37274, 37282,
    37275, 37273, 37279, 37281, 37277, 37280, 37793, 37763, 37807, 37732,
    37718, 37703, 37756, 37720, 37724, 37750, 37705, 37712, 37713, 37728,
    37741, 37775, 37708, 37738, 37753, 37719, 37717, 37714, 37711, 37745,
    37751, 37755, 37729, 37726, 37731, 37735, 37760, 37710, 37721, 38343,
    38336, 38345, 38339, 38341, 38327, 38574, 38576, 38572, 38688, 38687,
    38680, 38685, 38681, 38810, 38817, 38812, 38814, 38813, 38869, 38868,
    38897, 38977, 38980, 38986, 38985, 38981, 38979, 39205, 39211, 39212,
    39210, 39219, 39218, 39215, 39213, 39217, 39216, 39320, 39331, 39329,
    39426, 39418, 39412, 39415, 39417, 39416, 39414, 39419, 39421, 39422,
    39420, 39427, 39614, 39678, 39677, 39681, 39676, 39752, 39834, 39848,
    39838, 39835, 39846, 39841, 39845, 39844, 39814, 39842, 39840, 39855,
    40243, 40257, 40295, 40246, 40238, 40239, 40241, 40248, 40240, 40261,
    40258, 40259, 40254, 40247, 40256, 40253, 32757, 40237, 40586, 40585,
    40589, 40624, 40648, 40666, 40699, 40703, 40740, 40739, 40738, 40788,
    40864, 20785, 20781, 20782, 22168, 22172, 22167, 22170, 22173, 22169,
    22896, 23356, 23657, 23658, 24000, 24173, 24174, 25048, 25055, 25069,
    25070, 25073, 25066, 25072, 25067, 25046, 25065, 25855, 25860, 25853,
    25848, 25857, 25859, 25852, 26004, 26075, 26330, 26331, 26328, 27333,
    27321, 27325, 27361, 27334, 27322, 27318, 27319, 27335, 27316, 27309,
    27486, 27593, 27659, 28679, 28684, 28685, 28673, 28677, 28692, 28686,
    28671, 28672, 28667, 28710, 28668, 28663, 28682, 29185, 29183, 29177,
    29187, 29181, 29558, 29880, 29888, 29877, 29889, 29886, 29878, 29883,
    29890, 29972, 29971, 30300, 30308, 30297, 30288, 30291, 30295, 30298,
    30374, 30397, 30444, 30658, 30650, 30975, 30988, 30995, 30996, 30985,
    30992, 30994, 30993, 31149, 31148, 31327, 31772, 31785, 31769, 31776,
    31775, 31789, 31773, 31782, 31784, 31778, 31781, 31792, 32348, 32336,
    32342, 32355, 32344, 32354, 32351, 32337, 32352, 32343, 32339, 32693,
    32691, 32759, 32760, 32885, 33233, 33234, 33232, 33375, 33374, 34228,
    34246, 34240, 34243, 34242, 34227, 34229, 34237, 34247, 34244, 34239,
    34251, 34254, 34248, 34245, 34225, 34230, 34258, 34340, 34232, 34231,
    34238, 34409, 34791, 34790, 34786, 34779, 34795, 34794, 34789, 34783,
    34803, 34788, 34772, 34780, 34771, 34797, 34776, 34787, 34724, 34775,
    34777, 34817, 34804, 34792, 34781, 35155, 35147, 35151, 35148, 35142,
    35152, 35153, 35145, 35626, 35623, 35619, 35635, 35632, 35637, 35655,
    35631, 35644, 35646, 35633, 35621, 35639, 35622, 35638, 35630, 35620,
    35643, 35645, 35642, 35906, 35957, 35993, 35992, 35991, 36094, 36100,
    36098, 36096, 36444, 36450, 36448, 36439, 36438, 36446, 36453, 36455,
    36443, 36442, 36449, 36445, 36457, 36436, 36678, 36679, 36680, 36683,
    37160, 37178, 37179, 37182, 37288, 37285, 37287, 37295, 37290, 37813,
    37772, 37778, 37815, 37787, 37789, 37769, 37799, 37774, 37802, 37790,
    37798, 37781, 37768, 37785, 37791, 37773, 37809, 37777, 37810, 37796,
    37800, 37812, 37795, 37797, 38354, 38355, 38353, 38579, 38615, 38618,
    24002, 38623, 38616, 38621, 38691, 38690, 38693, 38828, 38830, 38824,
    38827, 38820, 38826, 38818, 38821, 38871, 38873, 38870, 38872, 38906,
    38992, 38993, 38994, 39096, 39233, 39228, 39226, 39439, 39435, 39433,
    39437, 39428, 39441, 39434, 39429, 39431, 39430, 39616, 39644, 39688,
    39684, 39685, 39721, 39733, 39754, 39756, 39755, 39879, 39878, 39875,
    39871, 39873, 39861, 39864, 39891, 39862, 39876, 39865, 39869, 40284,
    40275, 40271, 40266, 40283, 40267, 40281, 40278, 40268, 40279, 40274,
    40276, 40287, 40280, 40282, 40590, 40588, 40671, 40705, 40704, 40726,
    40741, 40747, 40746, 40745, 40744, 40780, 40789, 20788, 20789, 21142,
    21239, 21428, 22187, 22189, 22182, 22183, 22186, 22188, 22746, 22749,
    22747, 22802, 23357, 23358, 23359, 24003, 24176, 24511, 25083, 25863,
    25872, 25869, 25865, 25868, 25870, 25988, 26078, 26077, 26334, 27367,
    27360, 27340, 27345, 27353, 27339, 27359, 27356, 27344, 27371, 27343,
    27341, 27358, 27488, 27568, 27660, 28697, 28711, 28704, 28694, 28715,
    28705, 28706, 28707, 28713, 28695, 28708, 28700, 28714, 29196, 29194,
    29191, 29186, 29189, 29349, 29350, 29348, 29347, 29345, 29899, 29893,
    29879, 29891, 29974, 30304, 30665, 30666, 30660, 30705, 31005, 31003,
    31009, 31004, 30999, 31006, 31152, 31335, 31336, 31795, 31804, 31801,
    31788, 31803, 31980, 31978, 32374, 32373, 32376, 32368, 32375, 32367,
    32378, 32370, 32372, 32360, 32587, 32586, 32643, 32646, 32695, 32765,
    32766, 32888, 33239, 33237, 33380, 33377, 33379, 34283, 34289, 34285,
    34265, 34273, 34280, 34266, 34263, 34284, 34290, 34296, 34264, 34271,
    34275, 34268, 34257, 34288, 34278, 34287, 34270, 34274, 34816, 34810,
    34819, 34806, 34807, 34825, 34828, 34827, 34822, 34812, 34824, 34815,
    34826, 34818, 35170, 35162, 35163, 35159, 35169, 35164, 35160, 35165,
    35161, 35208, 35255, 35254, 35318, 35664, 35656, 35658, 35648, 35667,
    35670, 35668, 35659, 35669, 35665, 35650, 35666, 35671, 35907, 35959,
    35958, 35994, 36102, 36103, 36105, 36268, 36266, 36269, 36267, 36461,
    36472, 36467, 36458, 36463, 36475, 36546, 36690, 36689, 36687, 36688,
    36691, 36788, 37184, 37183, 37296, 37293, 37854, 37831, 37839, 37826,
    37850, 37840, 37881, 37868, 37836, 37849, 37801, 37862, 37834, 37844,
    37870, 37859, 37845, 37828, 37838, 37824, 37842, 37863, 38269, 38362,
    38363, 38625, 38697, 38699, 38700, 38696, 38694, 38835, 38839, 38838,
    38877, 38878, 38879, 39004, 39001, 39005, 38999, 39103, 39101, 39099,
    39102, 39240, 39239, 39235, 39334, 39335, 39450, 39445, 39461, 39453,
    39460, 39451, 39458, 39456, 39463, 39459, 39454, 39452, 39444, 39618,
    39691, 39690, 39694, 39692, 39735, 39914, 39915, 39904, 39902, 39908,
    39910, 39906, 39920, 39892, 39895, 39916, 39900, 39897, 39909, 39893,
    39905, 39898, 40311, 40321, 40330, 40324, 40328, 40305, 40320, 40312,
    40326, 40331, 40332, 40317, 40299, 40308, 40309, 40304, 40297, 40325,
    40307, 40315, 40322, 40303, 40313, 40319, 40327, 40296, 40596, 40593,
    40640, 40700, 40749, 40768, 40769, 40781, 40790, 40791, 40792, 21303,
    22194, 22197, 22195, 22755, 23365, 24006, 24007, 24302, 24303, 24512,
    24513, 25081, 25879, 25878, 25877, 25875, 26079, 26344, 26339, 26340,
    27379, 27376, 27370, 27368, 27385, 27377, 27374, 27375, 28732, 28725,
    28719, 28727, 28724, 28721, 28738, 28728, 28735, 28730, 28729, 28736,
    28731, 28723, 28737, 29203, 29204, 29352, 29565, 29564, 29882, 30379,
    30378, 30398, 30445, 30668, 30670, 30671, 30669, 30706, 31013, 31011,
    31015, 31016, 31012, 31017, 31154, 31342, 31340, 31341, 31479, 31817,
    31816, 31818, 31815, 31813, 31982, 32379, 32382, 32385, 32384, 32698,
    32767, 32889, 33243, 33241, 33291, 33384, 33385, 34338, 34303, 34305,
    34302, 34331, 34304, 34294, 34308, 34313, 34309, 34316, 34301, 34841,
    34832, 34833, 34839, 34835, 34838, 35171, 35174, 35257, 35319, 35680,
    35690, 35677, 35688, 35683, 35685, 35687, 35693, 36270, 36486, 36488,
    36484, 36697, 36694, 36695, 36693, 36696, 36698, 37005, 37187, 37185,
    37303, 37301, 37298, 37299, 37899, 37907, 37883, 37920, 37903, 37908,
    37886, 37909, 37904, 37928, 37913, 37901, 37877, 37888, 37879, 37895,
    37902, 37910, 37906, 37882, 37897, 37880, 37898, 37887, 37884, 37900,
    37878, 37905, 37894, 38366, 38368, 38367, 38702, 38703, 38841, 38843,
    38909, 38910, 39008, 39010, 39011, 39007, 39105, 39106, 39248, 39246,
    39257, 39244, 39243, 39251, 39474, 39476, 39473, 39468, 39466, 39478,
    39465, 39470, 39480, 39469, 39623, 39626, 39622, 39696, 39698, 39697,
    39947, 39944, 39927, 39941, 39954, 39928, 40000, 39943, 39950, 39942,
    39959, 39956, 39945, 40351, 40345, 40356, 40349, 40338, 40344, 40336,
    40347, 40352, 40340, 40348, 40362, 40343, 40353, 40346, 40354, 40360,
    40350, 40355, 40383, 40361, 40342, 40358, 40359, 40601, 40603, 40602,
    40677, 40676, 40679, 40678, 40752, 40750, 40795, 40800, 40798, 40797,
    40793, 40849, 20794, 20793, 21144, 21143, 22211, 22205, 22206, 23368,
    23367, 24011, 24015, 24305, 25085, 25883, 27394, 27388, 27395, 27384,
    27392, 28739, 28740, 28746, 28744, 28745, 28741, 28742, 29213, 29210,
    29209, 29566, 29975, 30314, 30672, 31021, 31025, 31023, 31828, 31827,
    31986, 32394, 32391, 32392, 32395, 32390, 32397, 32589, 32699, 32816,
    33245, 34328, 34346, 34342, 34335, 34339, 34332, 34329, 34343, 34350,
    34337, 34336, 34345, 34334, 34341, 34857, 34845, 34843, 34848, 34852,
    34844, 34859, 34890, 35181, 35177, 35182, 35179, 35322, 35705, 35704,
    35653, 35706, 35707, 36112, 36116, 36271, 36494, 36492, 36702, 36699,
    36701, 37190, 37188, 37189, 37305, 37951, 37947, 37942, 37929, 37949,
    37948, 37936, 37945, 37930, 37943, 37932, 37952, 37937, 38373, 38372,
    38371, 38709, 38714, 38847, 38881, 39012, 39113, 39110, 39104, 39256,
    39254, 39481, 39485, 39494, 39492, 39490, 39489, 39482, 39487, 39629,
    39701, 39703, 39704, 39702, 39738, 39762, 39979, 39965, 39964, 39980,
    39971, 39976, 39977, 39972, 39969, 40375, 40374, 40380, 40385, 40391,
    40394, 40399, 40382, 40389, 40387, 40379, 40373, 40398, 40377, 40378,
    40364, 40392, 40369, 40365, 40396, 40371, 40397, 40370, 40570, 40604,
    40683, 40686, 40685, 40731, 40728, 40730, 40753, 40782, 40805, 40804,
    40850, 20153, 22214, 22213, 22219, 22897, 23371, 23372, 24021, 24017,
    24306, 25889, 25888, 25894, 25890, 27403, 27400, 27401, 27661, 28757,
    28758, 28759, 28754, 29214, 29215, 29353, 29567, 29912, 29909, 29913,
    29911, 30317, 30381, 31029, 31156, 31344, 31345, 31831, 31836, 31833,
    31835, 31834, 31988, 31985, 32401, 32591, 32647, 33246, 33387, 34356,
    34357, 34355, 34348, 34354, 34358, 34860, 34856, 34854, 34858, 34853,
    35185, 35263, 35262, 35323, 35710, 35716, 35714, 35718, 35717, 35711,
    36117, 36501, 36500, 36506, 36498, 36496, 36502, 36503, 36704, 36706,
    37191, 37964, 37968, 37962, 37963, 37967, 37959, 37957, 37960, 37961,
    37958, 38719, 38883, 39018, 39017, 39115, 39252, 39259, 39502, 39507,
    39508, 39500, 39503, 39496, 39498, 39497, 39506, 39504, 39632, 39705,
    39723, 39739, 39766, 39765, 40006, 40008, 39999, 40004, 39993, 39987,
    40001, 39996, 39991, 39988, 39986, 39997, 39990, 40411, 40402, 40414,
    40410, 40395, 40400, 40412, 40401, 40415, 40425, 40409, 40408, 40406,
    40437, 40405, 40413, 40630, 40688, 40757, 40755, 40754, 40770, 40811,
    40853, 40866, 20797, 21145, 22760, 22759, 22898, 23373, 24024, 34863,
    24399, 25089, 25091, 25092, 25897, 25893, 26006, 26347, 27409, 27410,
    27407, 27594, 28763, 28762, 29218, 29570, 29569, 29571, 30320, 30676,
    31847, 31846, 32405, 33388, 34362, 34368, 34361, 34364, 34353, 34363,
    34366, 34864, 34866, 34862, 34867, 35190, 35188, 35187, 35326, 35724,
    35726, 35723, 35720, 35909, 36121, 36504, 36708, 36707, 37308, 37986,
    37973, 37981, 37975, 37982, 38852, 38853, 38912, 39510, 39513, 39710,
    39711, 39712, 40018, 40024, 40016, 40010, 40013, 40011, 40021, 40025,
    40012, 40014, 40443, 40439, 40431, 40419, 40427, 40440, 40420, 40438,
    40417, 40430, 40422, 40434, 40432, 40418, 40428, 40436, 40435, 40424,
    40429, 40642, 40656, 40690, 40691, 40710, 40732, 40760, 40759, 40758,
    40771, 40783, 40817, 40816, 40814, 40815, 22227, 22221, 23374, 23661,
    25901, 26349, 26350, 27411, 28767, 28769, 28765, 28768, 29219, 29915,
    29925, 30677, 31032, 31159, 31158, 31850, 32407, 32649, 33389, 34371,
    34872, 34871, 34869, 34891, 35732, 35733, 36510, 36511, 36512, 36509,
    37310, 37309, 37314, 37995, 37992, 37993, 38629, 38726, 38723, 38727,
    38855, 38885, 39518, 39637, 39769, 40035, 40039, 40038, 40034, 40030,
    40032, 40450, 40446, 40455, 40451, 40454, 40453, 40448, 40449, 40457,
    40447, 40445, 40452, 40608, 40734, 40774, 40820, 40821, 40822, 22228,
    25902, 26040, 27416, 27417, 27415, 27418, 28770, 29222, 29354, 30680,
    30681, 31033, 31849, 31851, 31990, 32410, 32408, 32411, 32409, 33248,
    33249, 34374, 34375, 34376, 35193, 35194, 35196, 35195, 35327, 35736,
    35737, 36517, 36516, 36515, 37998, 37997, 37999, 38001, 38003, 38729,
    39026, 39263, 40040, 40046, 40045, 40459, 40461, 40464, 40463, 40466,
    40465, 40609, 40693, 40713, 40775, 40824, 40827, 40826, 40825, 22302,
    28774, 31855, 34876, 36274, 36518, 37315, 38004, 38008, 38006, 38005,
    39520, 40052, 40051, 40049, 40053, 40468, 40467, 40694, 40714, 40868,
    28776, 28773, 31991, 34410, 34878, 34877, 34879, 35742, 35996, 36521,
    36553, 38731, 39027, 39028, 39116, 39265, 39339, 39524, 39526, 39527,
    39716, 40469, 40471, 40776, 25095, 27422, 29223, 34380, 36520, 38018,
    38016, 38017, 39529, 39528, 39726, 40473, 29225, 34379, 35743, 38019,
    40057, 40631, 30325, 39531, 40058, 40477, 28777, 28778, 40612, 40830,
    40777, 40856, 30849, 37561, 35023, 22715, 24658, 31911, 23290, 9556, 9574,
    9559, 9568, 9580, 9571, 9562, 9577, 9565, 9554, 9572, 9557, 9566, 9578,
    9569, 9560, 9575, 9563, 9555, 9573, 9558, 9567, 9579, 9570, 9561, 9576,
    9564, 9553, 9552, 9581, 9582, 9584, 9583, 65517, 1351, 37595, 1503, 16325,
    34124, 17077, 29679, 20917, 13897, 18754, 35300, 37700, 6619, 33518, 15560,
    30780, 26436, 25311, 18739, 35242, 672, 27571, 4869, 20395, 9453, 20488,
    27945, 31364, 13824, 19121, 9491, 20521, 894, 24484, 896, 839, 28379, 1055,
    20605, 20737, 13434, 20750, 39020, 14147, 33814, 18852, 1159, 20832, 13236,
    20842, 3071, 8444, 741, 9520, 1422, 12851, 6531, 23426, 34685, 1459, 15513,
    20914, 20920, 40244, 20937, 20943, 20945, 15580, 20947, 19110, 20915,
    20962, 21314, 20973, 33741, 26942, 14125, 24443, 21003, 21030, 21052,
    21173, 21079, 21140, 21177, 21189, 31765, 34114, 21216, 34317, 27411,
    21253, 35550, 21833, 28377, 16256, 2388, 16364, 21299, 21316, 3042, 27851,
    5926, 26651, 29653, 24650, 16042, 14540, 5864, 29149, 17570, 21357, 21364,
    34475, 21374, 21375, 5526, 5651, 30694, 21395, 35483, 21408, 21419, 21422,
    29607, 22386, 16217, 29596, 21441, 21445, 27721, 20041, 22526, 21465,
    15019, 2959, 21472, 16363, 11683, 21494, 3191, 21523, 28793, 21803, 26199,
    27995, 21613, 27475, 3444, 21853, 21647, 21668, 18342, 5901, 3805, 15796,
    3405, 35260, 9880, 21831, 19693, 21551, 29719, 21894, 21929, 22021, 6359,
    16442, 17746, 17461, 26291, 4276, 22071, 26317, 12938, 26276, 26285, 22093,
    22095, 30961, 22257, 38791, 21502, 22272, 22255, 22253, 35686, 13859, 4687,
    22342, 16805, 27758, 28811, 22338, 14001, 27774, 22502, 5142, 22531, 5204,
    17251, 22566, 19445, 22620, 22698, 13665, 22752, 22748, 4668, 22779, 23551,
    22339, 41296, 17016, 37843, 13729, 22815, 26790, 14019, 28249, 5694, 23076,
    21843, 5778, 34053, 22985, 3406, 27777, 27946, 6108, 23001, 6139, 6066,
    28070, 28017, 6184, 5845, 23033, 28229, 23211, 23139, 14054, 18857, 23159,
    14088, 23190, 29797, 23251, 28577, 9556, 15749, 6417, 14130, 5816, 24195,
    21200, 23414, 25992, 23420, 31246, 16388, 18525, 516, 23509, 24928, 6708,
    22988, 1445, 23539, 23453, 19728, 23557, 6980, 23571, 29646, 23572, 7333,
    27432, 23625, 18653, 23685, 23785, 23791, 23947, 7673, 7735, 23824, 23832,
    23878, 7844, 23738, 24023, 33532, 14381, 18689, 8265, 8563, 33415, 14390,
    15298, 24110, 27274, 24181, 24186, 17596, 3283, 21414, 20151, 24272, 21416,
    6001, 24073, 24308, 33922, 24313, 24315, 14496, 24316, 26686, 37915, 24333,
    449, 63636, 15070, 18606, 4922, 24378, 26760, 9168, 24408, 9329, 24419,
    38845, 28270, 24434, 37696, 35382, 24487, 23990, 15711, 21072, 8042, 28920,
    9832, 37334, 670, 35369, 24625, 26245, 6263, 14691, 15815, 13881, 22416,
    10164, 31089, 15936, 24734, 24740, 24755, 18818, 18831, 31315, 29860,
    20705, 23200, 24932, 33828, 24898, 63654, 28370, 24961, 20980, 1622, 24967,
    23466, 16311, 10335, 25043, 35741, 39261, 25040, 14642, 10624, 10433,
    24611, 24924, 25886, 25483, 280, 25285, 6000, 25301, 11789, 25452, 18911,
    14871, 25656, 25592, 5006, 6140, 25744, 28554, 11830, 38932, 16524, 22301,
    25825, 25829, 38011, 14950, 25658, 14935, 25933, 28438, 18984, 18979,
    25989, 25965, 25951, 12414, 26037, 18752, 19255, 26065, 16600, 6185, 26080,
    26083, 24543, 13312, 26136, 12791, 12792, 26180, 12708, 12709, 26187, 3701,
    26215, 20966, 26227, 26228, 7741, 12849, 34292, 12744, 21267, 30661, 10487,
    39332, 26370, 17308, 18977, 15147, 27130, 14274, 26462, 26471, 26466,
    16845, 37101, 26583, 17641, 26658, 28240, 37436, 26625, 13286, 28064,
    26717, 13423, 27105, 27147, 35551, 26995, 26819, 13773, 26881, 26880,
    15666, 14849, 13884, 15232, 26540, 26977, 35402, 17148, 26934, 27032,
    15265, 969, 33635, 20624, 27129, 13913, 8490, 27205, 14083, 27293, 15347,
    26545, 27336, 37276, 15373, 27421, 2339, 24798, 27445, 27508, 10189, 28341,
    15067, 949, 6488, 14144, 21537, 15194, 27617, 16124, 27612, 27703, 9355,
    18673, 27473, 27738, 33318, 27769, 15804, 17605, 15805, 16804, 18700,
    18688, 15561, 14053, 15595, 3378, 39811, 12793, 9361, 32655, 26679, 27941,
    28065, 28139, 28054, 27996, 28284, 28420, 18815, 16517, 28274, 34099,
    28532, 20935, 27804, 28189, 33838, 35617, 28207, 15919, 29779, 16258,
    31180, 28239, 23185, 12363, 28664, 14093, 28573, 15920, 28410, 5271, 16445,
    17749, 37872, 28484, 28508, 15694, 28532, 37232, 15675, 28575, 16708,
    28627, 16529, 16725, 16441, 16368, 16308, 16703, 20959, 16726, 16727,
    16704, 25053, 28747, 28798, 28839, 28801, 28876, 28885, 28886, 28895,
    16644, 15848, 29108, 29078, 17015, 28971, 28997, 23176, 29002, 29038,
    23708, 17253, 29007, 37730, 17089, 28972, 17498, 18983, 18978, 29114,
    35816, 28861, 29198, 37954, 29205, 22801, 37955, 29220, 37697, 22021,
    29230, 29248, 18804, 26813, 29269, 29271, 15957, 12356, 26637, 28477,
    29314, 29482, 29483, 18467, 34859, 18669, 34820, 29480, 29486, 29647,
    29610, 3130, 27182, 29641, 29769, 16866, 5863, 18980, 26147, 14021, 18871,
    18829, 18939, 29687, 29717, 26883, 18982, 29753, 1475, 16087, 29788, 10413,
    29792, 36530, 29767, 29668, 29814, 33721, 29804, 14128, 29812, 37873,
    27180, 29826, 18771, 19084, 16735, 19065, 35727, 23366, 35843, 6302, 29896,
    6536, 29966, 29929, 29982, 36569, 6731, 23511, 36524, 37765, 30029, 30026,
    30055, 30062, 20354, 16132, 19731, 30094, 29789, 30110, 30132, 30210,
    30252, 30289, 30287, 30319, 30326, 25589, 30352, 33263, 14328, 26897,
    26894, 30369, 30373, 30391, 30412, 28575, 33890, 20637, 20861, 7708, 30494,
    30502, 30528, 25775, 21024, 30552, 12972, 30639, 35172, 35176, 5825, 30708,
    30729, 4982, 18962, 26826, 30895, 30919, 30931, 38565, 31022, 21984, 30935,
    31028, 30897, 30220, 36792, 34948, 35627, 24707, 9756, 31110, 35072, 26882,
    31104, 22615, 31133, 31545, 31036, 31145, 28202, 28966, 16040, 31174,
    37133, 31188,
]; // 18840 entries

const FORWARD_TABLE_MORE: &'static [u32] = &[
    1147077920, 3095548431, 1073742072, 72263968, 0, 68404, 0, 0, 0, 201326592,
    64, 0, 5768192, 60, 1551892480, 3153321133, 3991815113, 3240497060,
    4025644699, 4160420830, 2940482063, 4278054910, 11558929, 2165907712,
    2827489312, 610869600, 3297330176, 1073938432, 2218983477, 1754485041, 514,
    0, 0, 16793600, 2187635840, 2426506304, 3563081732, 405459456, 2536859805,
    553179215, 672957124, 43283842, 2711633976, 1299255493, 3113749956,
    1124162398, 2013501855, 136307232, 1086914953, 2584544007, 1339118224,
    553780092, 326025248, 4124816771, 1334867941, 389454359, 3127771148,
    1415589641, 1752702464, 2656464930, 3079598885, 3874425623, 458954615,
    2375553217, 3484817426, 443691265, 3233164379, 1556341280, 3672120194,
    1087800782, 3490403497, 1078216719, 1087637776, 509885358, 135736132,
    406225542, 2632419744, 58984539, 3968915970, 3213199323, 2392698274,
    622893213, 2672164934, 3386237823, 1305932932, 414638854, 2322, 1024, 32,
    512, 0, 536870912, 0, 0, 0, 2382364680, 1063218808, 4148026750, 2935790588,
    1804599250, 3133138929, 4011290286, 3057559516, 2462676917, 1253483991,
    2176424814, 1425958733, 4267875313, 920081007, 1160364030, 1706948993,
    3752614, 2405450240, 1077974016, 3520573394, 2560622811, 1376156594,
    3356923936, 2365, 1, 145885697, 128, 337676292, 19472, 1151401988,
    21037072, 4030728192, 151519, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2189426688, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    3190490752, 4272953022, 528396, 2567449034, 202063888, 2449467, 411227178,
    2184044104, 411509781, 562094360, 2022888193, 2466480659, 885346509,
    2913085632, 1478007164, 1120150034, 1049514914, 1162011085, 259952692,
    24412416, 965050898, 3724552519, 2281783650, 2174567329, 4760008,
]; // 589 entries

/// Returns the index code point for pointer `code` in this index.
#[inline]
pub fn forward(code: u16) -> u32 {
    let code = (code as usize).wrapping_sub(942);
    if code < 18840 {
        (FORWARD_TABLE[code] as u32) | (((FORWARD_TABLE_MORE[code >> 5] >> (code & 31)) & 1) << 17)
    } else {
        X as u32
    }
}

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_LOWER: &'static [u16] = &[
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4874, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4400, 3326, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 3300, 3449, 1875, X, X, X, X, 1897, X, X, X, X, X, X, X, X, X, 2668,
    4701, X, X, X, X, X, X, 2512, X, X, X, X, X, X, X, X, X, 7160, 12652, 7158,
    7159, 12642, 12658, 4669, 7149, 1942, 6105, 6099, 6104, 11598, 6103, 6089,
    6088, 6101, X, X, X, X, 4558, X, X, 10244, 10241, X, 17393, 17397, 17401,
    19499, 2968, 4794, 17758, 17755, 17764, X, 17763, 9993, 16946, 1987, 16957,
    9995, 16964, X, 16953, X, 16948, 19298, X, 16965, 16944, 16955, 3345,
    15825, 16436, X, 1792, 9720, 19494, 16451, 9724, 9727, 16422, X, 9723,
    2973, 16449, 16450, 16440, 4814, 8981, 15260, 8995, 15244, X, 15263, X, X,
    15228, 15249, 8984, 8993, 8991, 15230, 15251, 13909, 14552, 2908, 19472,
    14578, 8545, 14575, 8542, 14569, 8553, 14560, 14589, X, X, X, X, 19259, X,
    X, X, X, X, X, X, 2730, X, X, X, 19503, X, X, X, X, X, X, X, X, X, X, X, X,
    5465, X, X, X, 5046, 5048, X, X, X, 5091, 5092, X, X, 5093, 5094, X, X,
    5146, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2984, X, 1149, 1131, 1153,
    X, 1157, X, 1159, X, 1160, X, 1161, X, 1162, X, X, X, 11294, X, X, X, X, X,
    X, 11302, X, X, X, X, X, 1943, X, X, X, X, X, 12209, 6752, 6744, 6746,
    6751, 11440, 11436, 11438, 5880, 11435, 11442, 11437, X, 4736, X, X, X, X,
    6093, 6102, 6100, 17377, 17375, 10401, X, X, 10404, 10403, 10402, 10552,
    18065, 10553, 17742, 10644, 18318, 10645, 10728, 2878, 16388, 9973, 16924,
    X, 16385, 16387, 9974, 9690, 9972, 9689, 9976, 16389, 9686, X, 1939, 9331,
    9683, 15768, 15764, 9337, 4255, 16384, X, 2883, 2882, 9335, 15763, 4990,
    16382, X, 15767, 19261, 15186, 8952, 8953, 19363, 15183, 15772, 9321, 8053,
    X, 15185, 9328, 15177, X, 9322, 4919, 3368, X, 15174, 15175, 15180, 9324,
    15187, X, 8956, 4913, 8955, 15182, 19383, 9323, 15171, 8954, 14493, 15170,
    19365, X, 8502, 14485, 14489, 8948, 8493, 14482, 14483, 8950, 8501, 8503,
    8500, 14491, 4772, X, 14487, X, 8505, X, 14486, 8509, X, X, X, 15184, X,
    1934, 8504, 8949, 13829, X, 8059, 13821, 13815, 8049, 13818, X, 13827,
    4696, 8491, 8496, 8046, 13828, X, 8494, 8050, 8054, 13816, 8495, 8052,
    13820, 8056, 14481, 13822, 8497, 8048, 8051, 13823, 4894, 13824, 13830,
    13225, 13825, X, 13223, 13814, 7599, 7606, 7610, 13217, 13809, 13221, 7595,
    13811, 13224, 13813, 13213, 7593, X, 12624, 7591, 4989, X, X, 3023, 7594,
    X, X, X, X, X, X, X, 2115, X, X, X, X, X, X, X, X, 2688, 19603, X, X, 4479,
    X, X, X, X, 2904, X, 4920, X, 6407, 11867, 11860, 6402, 6421, 11856, 11863,
    11865, 14494, 8510, 8511, 14496, 14498, 14497, X, 15189, X, 15188, 8958,
    15190, 1941, 15774, 9339, X, 7166, 12672, 12670, 12671, 7167, 12669, X, X,
    X, X, 7657, 7658, 13258, 7659, 7656, 16940, 16939, 9989, 9990, 17749,
    19414, 1958, 5626, 19254, 1295, X, 1789, 13873, X, X, X, 19582, 16973,
    10020, X, X, 10008, 3435, 3434, 10012, 16975, 16981, 16979, 10010, 17415,
    17410, X, 3684, 16476, 17411, 10253, 17407, X, 10250, 17420, 10251, 17408,
    17409, 17413, 10256, 18093, 18096, 18088, 18325, 18326, 18330, 18331, X,
    18328, 18329, 18327, 19594, 10654, 1766, X, X, 6847, 6850, 12354, 12353,
    12352, 6844, 12361, 12351, 1746, 6846, 12794, X, 12358, 12356, 10734,
    18660, 18659, 18661, 5754, 12346, 7247, 7747, 13387, 5755, 11373, 5650,
    1798, X, 11466, 3687, 15914, 15917, 15920, X, X, 16516, 16513, 16514, 9757,
    16512, 16518, 16517, 16515, X, 16992, 16993, 14677, 3699, 14674, 15333,
    9038, 8604, X, X, 3700, 14679, 14678, X, 15336, 15334, 9415, 4800, 3694,
    13380, 14018, 7745, X, X, 7744, 13378, 13381, 7746, X, 7743, 7742, 13377,
    13386, X, 9436, X, 2312, X, 16546, X, 16548, 3747, 16547, 16539, 16543,
    16542, 16540, 9772, 9773, 18338, X, X, 10660, 18663, 18765, X, 4138, 18833,
    18834, 10871, 5771, 6878, 1773, 14070, X, 12884, 7796, X, 13469, 7798,
    13471, 7797, 13470, X, X, X, 3792, X, 14107, 8241, 17463, 10285, 17469,
    10284, X, 17470, 17467, 10281, 17468, 17461, 10282, 10280, 17814, 17465, X,
    X, 15415, X, 9083, 15410, X, 9082, 15400, X, 15402, 9075, 15407, 15406,
    15409, 9080, 8234, 4422, 8235, X, 8236, 2070, 8232, X, 14104, X, X, X, X,
    X, X, X, 3064, X, X, X, X, X, X, X, X, 3732, X, X, X, X, 3734, X, X, X,
    3831, X, X, X, X, X, X, X, X, X, X, X, X, X, 1010, X, X, 19310, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 5010, 4706, 4351, 4307, X, X, X, X, 4308, X, X,
    X, X, X, 4311, X, X, X, X, 3599, X, X, X, X, X, X, X, X, X, X, X, 2898, X,
    X, X, X, 4691, X, X, X, X, X, X, X, X, X, X, X, 1304, X, X, X, X, X, 4090,
    X, X, X, X, X, X, X, X, X, X, 3030, 19542, X, X, X, X, 3213, 3212, X, X, X,
    X, X, X, X, X, X, X, 2658, 1644, 4888, X, X, X, X, 4124, X, X, X, X, X, X,
    X, X, X, X, X, 19519, X, X, X, X, 3228, X, X, X, X, X, X, X, X, X, X, X,
    2885, X, X, X, X, 2887, X, X, X, X, X, X, X, X, X, X, X, 19509, X, X, X, X,
    3010, 4387, 19066, 4201, X, X, X, X, X, X, X, X, 3807, X, X, 1856, X, X, X,
    X, X, 19264, X, X, X, X, X, X, X, X, X, X, 19514, X, X, X, X, X, 4372, X,
    X, X, X, X, X, X, X, X, X, 3101, X, X, X, X, 19342, X, 3369, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1768, X, 19616, X, X, X, X, X, X, X, 2936, 3645,
    X, X, X, X, X, 2508, X, X, X, X, X, X, X, X, X, X, 3495, 3254, 3622, 19226,
    X, X, 3671, 4326, X, X, X, X, X, X, X, 19232, 19423, 2931, X, X, 4080, X,
    X, 2945, X, X, X, X, X, X, X, X, X, X, X, X, X, 4036, X, X, 3357, 2831,
    3657, 19019, X, X, X, X, X, X, X, X, X, X, 2958, X, X, X, X, X, 952, X, X,
    X, X, X, X, X, X, X, X, 2407, X, X, X, X, X, X, 3127, X, X, X, X, X, X, X,
    X, X, 2703, 1562, X, X, X, X, X, X, 4203, X, X, X, X, X, X, X, X, X, 19422,
    X, X, X, X, X, X, 4339, 942, X, 4411, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 4663, X, 5172, 5170, 5173, 5171, X, X, 5174, 5175, 5177, 5176, X, X,
    X, X, X, X, 2842, X, X, X, X, X, X, X, X, X, 1584, X, X, X, X, X, X, 3835,
    X, X, X, X, X, X, X, 3837, X, X, 2734, X, X, X, X, X, 1272, X, X, 19020, X,
    X, 6616, 6604, 1775, 7019, 4756, 7024, 12513, 12512, 12517, 12518, 7006,
    2185, 7015, X, X, 4754, 7028, X, 2502, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 2879, X, 3250, X, X, X, 2386, X, X, X, X, X, X, X, X, X, X, 2274, X,
    X, X, X, X, 5165, 5164, X, X, X, X, X, X, X, X, X, X, 2174, X, X, X, X, X,
    2751, X, X, X, 2651, X, X, 3409, X, X, X, 3640, X, 2820, X, X, X, X, X, X,
    X, X, X, X, 5427, X, X, X, X, X, X, 4062, X, X, X, X, X, X, 1504, X, X,
    1454, X, X, X, 1420, X, X, 1519, X, X, X, X, X, X, 4278, X, X, X, X, X, X,
    X, X, X, 4061, X, X, X, X, X, X, X, 1495, X, X, X, X, X, X, X, X, 963, X,
    X, X, 4660, X, X, X, X, 3947, X, X, X, X, X, X, X, X, X, X, X, 19533, X, X,
    X, 2005, 19480, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1920, 2402, X,
    1962, X, X, 1006, X, X, X, X, X, 3045, X, X, X, X, 3957, X, X, X, X, X, X,
    X, X, X, X, X, 19131, X, X, X, X, 4914, X, X, 4909, X, X, X, X, X, X, 2543,
    X, 1063, X, X, 2234, X, X, X, X, 19460, 3174, 3561, 4589, X, X, X, 949, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 2888, X, X, 2565, 2577, X, X, X, X, X,
    X, X, X, X, X, X, X, 2360, X, X, X, 2406, X, X, X, X, X, X, X, X, X, X, X,
    X, 19263, X, X, X, 4594, X, X, X, X, X, X, X, X, X, X, X, X, 4605, 4803,
    4658, 4169, 19568, 2677, X, X, X, X, X, X, X, 2752, X, X, X, X, X, X, 3337,
    X, X, X, X, 4355, X, X, X, X, 1413, X, X, X, X, X, X, X, X, X, X, 2339,
    4391, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3257, 19337, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2934, 4618, X, X, 19135, 1625, X, X, X, X,
    X, X, X, X, X, X, X, 2576, X, X, X, X, 3385, X, X, X, X, X, X, X, X, X, X,
    2696, 19530, 19291, X, X, X, X, X, X, X, X, X, X, 19529, X, X, X, 3085, X,
    X, X, X, X, X, X, X, X, X, X, X, 4114, X, X, X, 4135, X, X, X, X, X, X, X,
    X, X, X, X, X, 1559, X, X, X, 3468, X, X, 19194, X, X, X, X, X, X, X, X, X,
    3217, 3480, 2835, 3461, X, X, X, 2497, X, X, X, X, X, X, X, X, X, X, X,
    2917, 1532, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2300, 2289, X, X,
    X, 2291, X, X, X, X, X, X, X, X, X, X, X, 2262, X, X, X, X, 19648, X, X, X,
    X, X, X, X, X, X, X, X, 3432, X, X, X, X, X, 2008, X, X, 2009, 8165, 7719,
    8147, 13964, 8161, X, 13952, 13325, X, 3569, 13970, 2993, 7706, X, X, X, X,
    2996, X, X, X, X, 3559, 13314, X, 13342, X, 7729, 7717, 7728, 7707, 13326,
    13344, 13336, 7708, 7702, 13350, X, 13343, 13345, 7710, 7718, 13347, 13324,
    13341, 13329, 13349, 7723, 7699, 7721, 13334, 13332, 13333, 7712, 13328,
    13327, 7701, 13321, 13351, 7703, 13331, 7733, X, 7727, 13320, 7724, 7722,
    7731, 13338, 7726, 12735, 13339, 7725, 13346, 7698, 13335, 7716, 13323,
    7715, X, 7713, 7705, 7704, 13949, 13348, 1728, X, 11954, 6502, 11951,
    11948, 6500, 11955, X, 11949, 6504, 11957, X, X, X, X, 12323, 12769, 12777,
    12765, X, 7236, X, X, X, X, X, X, X, X, X, X, 7738, 13997, 8176, 14005,
    14003, X, 14004, 8174, X, 14008, 3230, X, 19607, 19617, X, 14001, 13999,
    14662, 4229, 14646, 14663, 14645, X, 8600, 1867, 14657, 8587, 14666, X,
    8592, 14650, 8597, 14661, 14660, 4197, 14652, 4022, X, 3556, 4988, 2622,
    14653, X, 4840, 15324, 2321, 9031, 2647, X, 19727, X, X, 17012, 19728,
    17444, X, X, X, 18104, 18103, X, 18516, 5768, 11985, 17797, 10432, 10566,
    X, 17438, 10567, 4578, 4895, X, 10659, 18337, X, 10738, 18515, 10737,
    19719, 16536, 16530, 16535, 16532, 9766, 16534, X, X, 9767, X, 9768, 4519,
    16533, 16531, X, X, 14722, X, 14727, 14719, 14723, X, 19741, 14728, 14724,
    8630, 8638, X, 8633, 14720, 12826, 12830, 12828, 12827, X, 12831, X, X, X,
    12832, 12833, 12825, X, 12824, 19736, 7275, 7276, X, 12834, 12829, 4962,
    13423, 19737, 12835, 7277, 7274, X, 4974, X, 13417, X, 13416, 19738, X, X,
    3742, 14063, 14065, 14061, 14062, X, X, 14066, 14068, 14069, 14064, 14067,
    8216, 14721, 9057, 8641, 8634, X, 8639, 8632, 14726, 8640, 14725, 8636,
    8631, 8637, 14729, 15361, 15363, 15362, 15357, 15360, 15365, 9054, 15359,
    X, 9434, 15950, 15949, X, 9437, 9435, 15947, 9433, 15948, 10046, 17020,
    17016, 10044, 17019, 17014, 17018, 17017, X, 4522, 17448, 10271, 10272,
    10269, 3751, 10270, 17022, 17801, 18111, 5773, 19747, X, X, 11995, 11990,
    11992, 11994, 11993, 11991, 6530, 4943, X, 14109, 14106, 13472, X, 8242,
    2094, 18961, 14108, X, X, X, 2405, X, 3133, 14780, 17471, X, X, 17811, X,
    2089, X, 10442, 10440, 17813, X, 17815, 17812, 10441, 10438, 10439, 10065,
    9791, 16581, 16571, 9789, 16575, 9793, 16572, 16577, 9792, 16580, 16583,
    1807, X, X, X, 15992, X, X, X, 3136, 9798, 9803, 9796, 16603, 16594, 16606,
    16598, 16604, 15426, 15425, 15422, X, 15430, 15427, 15431, 9104, X, 15443,
    9093, 15432, 15433, 1321, 15429, 3800, 14783, 8677, X, 14790, 14794, 14786,
    14782, X, 14781, 2110, X, 1781, 14792, 14784, 14788, 8678, 7806, 7812,
    7811, 7807, X, 13473, 13476, X, 13475, 7803, 13477, 13486, 7804, 13474,
    13483, 13484, 10066, X, 10069, X, X, X, 2099, 10286, 17065, X, 17817, X,
    17816, 3796, 18128, 10577, 10740, X, X, 10789, 10788, 10790, 18665, 18664,
    X, 18836, 18769, 18837, 10857, 3123, 10858, 18885, 17047, 17057, 17054,
    17056, X, 17044, 2088, 10060, X, 17055, 17064, 17052, 10064, 10061, 17050,
    17045, 8667, 9460, X, X, 9456, 1029, 9458, 9459, X, 9788, 15980, 15974,
    9462, X, 15977, 4739, 14773, 14772, 14769, 14771, 14767, 9076, 14776, 8666,
    14775, X, X, 3786, X, X, X, X, 1544, X, X, X, X, X, 19653, 4031, X, X, X,
    X, 19269, X, X, X, X, X, X, X, X, X, X, X, 19009, X, X, X, X, 19045, X, X,
    X, X, X, X, X, X, X, X, X, 2871, X, X, X, X, 4170, X, X, X, X, X, X, X, X,
    X, X, X, 2913, 19742, 2911, X, X, 19750, 1800, X, 4185, X, X, X, X, X, X,
    X, X, X, X, 3827, X, X, X, X, X, X, 4127, X, X, X, X, X, X, X, X, X, 4606,
    X, X, X, X, X, X, 19078, X, X, X, 19081, X, 6266, 11733, X, 6265, X, 6264,
    X, 6629, 12074, X, 11731, 6634, X, 12075, 6630, 6633, 6632, 6631, 6628,
    1032, 7477, 7957, X, 8879, 19369, 11306, 5588, X, 5677, 5675, 5676, X,
    1382, 6256, 4725, X, 13070, X, 13048, X, 7467, 4761, 13069, 2744, X, 7462,
    13055, 7458, 13050, 13046, 13060, 14378, 14381, 8421, 8422, 14375, 8420,
    14384, 8426, 14385, X, 14380, 8427, 1776, 14369, 8424, 14370, 15068, 8875,
    X, 15061, 3552, 9256, 15681, X, 15678, 9257, X, 9255, 2745, 15685, 15682,
    15675, 15677, 17355, 9947, 10393, 17721, 17722, X, 10636, 10637, 18307,
    18306, 10720, 10719, 18636, X, 5504, 19044, 5210, 8878, 5211, X, 5505, X,
    5583, 5808, 6251, 19046, 5506, 5586, 5584, 5585, X, 5567, 5569, 11321,
    5570, 5568, X, X, 2731, 5783, 4484, 6224, X, X, 6225, 6599, 11383, 5802,
    11387, 2735, 11391, 11388, X, X, 11385, 5788, 5790, 5803, X, 5792, 11377,
    5795, 5967, 11502, 11489, 5965, 11492, X, X, 11494, X, 6241, 11711, 11723,
    6233, X, 11724, 6228, 12071, 12061, 6619, 6610, 6618, 12056, X, 12068,
    3691, 12059, 6614, 12060, 2742, 12055, 6621, 6608, 12521, 7020, 12509,
    7002, X, 7005, 7004, 12522, 7018, 7007, 7027, 7029, 12516, 7026, 2739,
    12524, 7952, 2741, 13689, 13682, X, 7949, X, 13690, 1375, X, X, 13680,
    13683, 7948, 13684, X, 1839, X, X, X, 967, X, X, X, X, X, X, X, X, X, X,
    2891, X, X, X, X, X, 4190, X, 1453, X, X, X, X, X, X, X, X, 2256, X, X, X,
    X, X, X, 3530, X, 3487, 3716, X, X, X, X, 3282, X, 3483, X, 2641, 1004, X,
    X, X, 1426, X, X, X, 2692, X, X, X, X, X, X, X, X, 2171, X, X, X, X, X, X,
    X, 3261, X, X, X, X, X, X, X, X, X, 1036, X, X, X, X, X, X, 5156, X, X, X,
    X, X, X, X, X, X, X, 4340, X, X, X, X, X, 2964, 3602, 3406, X, X, X, X, X,
    X, X, X, 1602, X, X, X, X, X, X, X, X, 1641, X, X, X, X, X, X, X, 4502,
    19348, X, 1731, X, X, 3814, 3046, X, X, 1825, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 2554, X, 10916, 10917, 10918, 10919, 10920, 10921, 10922,
    10923, 10924, 10925, X, X, X, X, X, X, 19099, X, X, X, X, X, X, X, X, X,
    983, X, X, X, X, X, X, 3745, X, X, X, X, X, X, X, X, X, X, 4152, X, X, X,
    X, X, 1797, X, X, X, X, X, X, X, X, X, X, 2710, X, X, X, X, X, X, 3470,
    2279, X, X, X, X, X, X, X, X, 4445, X, X, X, X, X, X, X, 4682, X, X, X, X,
    X, X, X, X, X, 4133, X, X, X, X, X, X, 2821, X, X, X, X, X, X, X, X, X, X,
    4084, X, X, X, X, X, 19584, 19590, 19591, X, X, X, X, 2511, X, X, 19688,
    4314, X, X, X, X, X, X, X, X, X, 1643, X, X, X, 3412, 19392, 2251, 2090, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 2072, X, 19725, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 3160, X, 3612, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 19726, X, 3648, X, 1771, 19007, X, X, 4412, 4414, X, X, X, X, X, X, X,
    3146, X, X, X, X, X, X, X, X, X, 3616, X, X, 2361, 1838, X, X, 2680, 3621,
    X, X, X, X, X, X, X, X, X, X, X, X, 2774, X, X, X, 19710, X, X, X, X, X, X,
    X, X, X, X, X, X, 19735, X, X, X, 4568, X, X, X, X, X, X, X, X, X, X, X, X,
    4001, X, X, X, 2828, 2723, X, X, X, X, X, X, X, X, X, X, 19034, 5190, 5290,
    5291, 5292, 5293, 5294, 5295, 5296, 5297, 5298, 5299, 5300, 5301, 5302,
    5303, 5304, 5034, 5047, X, 5049, 5051, 5055, 5056, 5059, 5060, 5063, 5064,
    5067, 5068, 5071, 5072, 5075, 18301, 10635, 2614, 10634, 18483, 18482,
    10717, 10718, X, 2615, 10776, 18633, 10775, X, 18748, 18749, 8865, X,
    17352, 17351, 17350, 17714, 4868, 1655, 17718, 17717, 17716, 17715, 10392,
    18046, 18299, 10632, 18628, 4003, 18737, 18738, 10818, 18876, 18901, 10886,
    4004, 14365, 16883, 17348, 18045, 15056, 3988, 17349, 18736, 8417, X,
    16314, 9941, 16881, 16882, X, 9940, X, 17347, 10217, 10215, 10216, 10214,
    17710, 17345, 3998, X, X, 10539, 10630, 18627, 18945, X, X, X, 7946, 9250,
    3999, 9642, 3935, 2584, 18043, 10536, 10538, 18042, 2585, 4915, 10537,
    4755, 18291, 18293, 18292, 18473, 10713, 2586, 10817, 18871, 18874, 18873,
    18900, 18899, 18925, X, 18926, 3386, 18939, 10889, 10893, 4854, 18949,
    10894, 1717, 4282, X, 18727, 18732, 18731, 18624, 18723, 18717, 18721,
    10847, 10848, 18716, 3993, 18815, 18806, 18814, 3992, 18452, 10711, 18458,
    2575, 18457, X, 18453, 18465, 1342, 18454, 18615, 18468, 18470, 18461,
    18455, 18022, 18017, 18036, 2571, 18019, 18033, 18024, 18040, 18020, 10531,
    18018, 18025, 18026, X, X, X, 2769, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4257, X, X, 11260, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2462, 4433,
    X, X, X, X, X, X, X, 4434, X, X, X, X, X, X, X, 1449, 1557, 1563, 4514, X,
    X, 3099, 19153, 19223, X, 19441, 3060, 19052, 2932, X, X, X, X, X, X, X, X,
    X, X, X, 2881, 19766, X, X, X, 2920, X, X, X, X, X, X, X, X, X, X, X, X,
    3156, X, X, X, 19302, 4809, 1438, 1613, X, X, X, X, X, X, 4039, X, X, 3588,
    X, 19196, 1622, X, X, X, X, X, X, X, X, X, X, 1434, 1611, X, X, X, X, 4297,
    X, X, X, X, X, X, X, X, X, X, X, 1694, 5020, X, X, X, 2877, 19551, X, X, X,
    X, X, X, X, X, X, X, X, 3189, X, X, X, X, 3695, X, X, X, X, X, X, X, X, X,
    X, X, 2566, X, X, X, X, 3389, 1893, X, X, X, X, X, X, X, X, X, X, 2792, X,
    X, X, X, X, X, 4356, X, X, X, X, X, X, X, X, X, 1111, X, X, X, X, X, X, X,
    1621, X, X, X, X, X, X, X, X, 4008, X, X, X, X, X, X, X, 3417, 5131, 5132,
    5148, 5149, 5150, 5151, 5152, X, 5183, 5193, 5194, 5195, X, X, X, X, 2357,
    X, X, X, X, X, X, X, X, 1627, 1628, X, 1864, X, X, X, X, X, X, X, X, 2205,
    X, X, X, X, X, 1805, X, X, X, X, X, X, X, X, X, X, 1467, X, X, X, X, X,
    4413, 3576, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2445, 4249, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 2517, 3387, X, X, X, X, X, X, 4350,
    X, X, X, X, X, X, X, X, 3702, X, X, X, X, X, X, X, 12944, 7374, 2208,
    12928, 2200, 12939, 12935, 2215, 12954, X, 8741, X, X, X, X, 3207, 15534,
    9158, X, X, 15545, 15544, X, 15539, 9160, 9519, 16119, 9521, 9522, 16112,
    9523, 16118, 16114, 16115, 16116, 9159, X, X, X, 16690, 16702, 17544,
    17545, 17167, 17539, 3211, X, 10469, 17879, 17882, 17884, 17877, 17878,
    17881, 17883, 10470, 10468, 10860, 1701, X, X, X, X, 1313, X, X, X, X, X,
    X, X, X, X, 4287, X, X, X, X, X, X, 11274, X, 11275, X, X, 11276, X, 11277,
    X, 11278, X, 5278, 5279, 5280, 5281, 5282, 5283, 5284, 5285, 5286, X, X, X,
    X, X, X, 1855, X, X, X, X, X, X, X, X, X, 1890, X, X, X, X, X, X, 1431, X,
    X, X, X, X, X, X, X, X, X, 4098, X, X, X, X, X, 3049, X, X, X, X, X, X, X,
    X, X, X, 3040, X, X, X, X, X, X, 19400, X, X, X, X, X, X, X, X, X, 1256, X,
    X, X, X, X, X, 3953, X, X, X, X, X, X, X, X, X, X, 4099, X, X, X, X, X,
    19199, X, X, X, X, X, X, X, X, X, X, 1566, 1489, X, X, X, X, X, 19049, X,
    X, X, X, X, X, X, X, X, X, 4515, X, X, X, X, X, 4649, X, X, X, X, X, X,
    3114, X, X, X, 19087, X, 1842, X, X, X, X, X, X, X, X, X, X, 19488, X,
    2720, X, X, X, X, 2777, X, X, X, X, X, X, X, X, X, X, X, 3116, X, X, X, X,
    1439, 1629, 1630, X, X, X, X, X, X, X, X, X, 4613, X, X, X, X, X, X, 1000,
    X, X, X, X, X, X, X, X, X, X, 1361, X, X, X, X, X, 3637, X, X, X, X, X, X,
    X, X, X, X, 1612, X, X, X, X, X, X, 1363, X, 4107, X, X, X, X, X, X, X,
    3323, X, X, X, X, X, X, X, X, 1336, X, X, X, X, X, X, X, X, 4176, X, X, X,
    X, X, X, X, 19370, X, X, X, X, X, X, X, X, X, 4280, X, X, X, X, X, X, 2724,
    X, X, X, X, X, X, X, X, X, X, 4081, X, X, X, X, X, 19548, X, X, X, X, X,
    2695, 19402, 2788, X, X, 4612, X, X, X, X, X, X, X, X, X, X, X, X, X,
    19150, X, X, 2381, X, X, X, X, X, X, X, X, X, X, X, X, X, 2182, X, X, 4042,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 2760, 1913, 3609, 4153, X, X, X, X,
    X, X, X, X, X, X, X, X, 19276, X, X, 11737, 19116, 11738, X, 12081, 12080,
    12083, 12082, 6642, X, 13079, 7047, 12544, 7046, 5689, 5688, X, 11511,
    4068, X, 6271, 4638, X, 10935, X, X, 11327, 19108, 5691, 5690, 5820, 5819,
    11399, 5990, 1767, X, X, 1387, X, X, 7044, X, 4771, 13078, X, 8438, 19085,
    2770, 8436, 8437, 8435, X, 8434, X, X, 15075, X, 15076, X, X, X, 15690,
    1386, 9654, X, 9655, 19080, X, 17723, 18309, 18308, 18637, 4825, 5510, X,
    X, X, 5680, 4757, 12535, 12541, X, X, X, X, X, 1648, 7961, 7478, 13072,
    13074, 13073, 13075, 7479, 11397, 5813, 5814, 11395, X, X, 5816, 5812, X,
    X, X, X, 11505, 6575, 11506, 4817, 13071, 19063, 4164, 19065, 13692, X, X,
    14386, 15072, X, X, 1381, 9262, 9653, 16322, 19589, 5507, 5521, 19068, X,
    1276, X, X, X, X, X, X, X, X, 19070, X, X, 11824, 11825, 11826, 1927, 6364,
    6365, 11823, 6366, X, X, X, 6714, 12179, X, 19344, 11836, 11841, 11838,
    6379, X, 12182, X, 12183, X, 1294, X, X, X, X, 1874, X, X, X, X, 1488, X,
    2719, X, X, X, X, 19168, X, X, X, X, X, X, X, X, X, X, 4064, 4050, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 3799, 4009, X, X, X, X, X, X, 3497, X,
    X, X, X, X, X, X, X, 3558, X, 4398, X, X, X, X, X, 5231, X, X, X, X, X, X,
    X, 5230, X, X, X, 5118, X, X, X, X, X, X, X, X, X, X, X, X, X, 2310, 2391,
    X, 1141, 1139, X, X, X, X, X, X, 1146, 1144, 1168, X, 1150, 1148, X, X,
    1154, 1152, X, X, X, 5136, 11300, 1158, 1156, X, 1163, X, X, X, 11299, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 4470, X, X, 4666, X, X, X, 4601, X, X,
    X, X, X, X, X, X, X, 3360, X, X, X, X, X, X, X, 4274, X, X, X, X, X, X, X,
    X, 1871, X, X, X, 1907, X, 4504, X, X, 6696, 6693, 6695, 6697, 6694, 12598,
    12144, X, 19372, X, 12600, 12599, 7100, X, 2826, 3624, 13759, 13756, X,
    3190, X, 19609, X, 13757, 13760, 13764, X, 13160, 13766, 13165, 3627, X, X,
    X, X, X, 8007, 13748, 3544, 13745, 13762, 13750, 13763, 2814, 8009, 13147,
    13168, 13156, 13151, 1626, 13141, 13169, 13153, 13140, 3111, 7538, 13158,
    13171, 13155, 13143, 13148, 13139, 3626, 7537, 19237, 13152, 13149, 7533,
    4349, 2718, 13166, 7534, 2863, 13150, 13146, 3638, X, 19627, 17735, X,
    10641, 5536, 5714, 11352, X, 5848, 5849, X, 6309, 982, X, 19213, 8006,
    13741, 7529, X, X, 4189, X, 8471, X, 8915, 8914, 15114, X, 9292, 9675, X,
    12584, 7072, 7075, 3150, X, 12575, 12581, 3586, X, X, 7074, 12570, X, 6672,
    13119, 12582, X, 12573, X, 7073, 12572, X, 3444, X, X, X, X, 13110, 2801,
    4712, 7517, 7521, 13126, 13108, 13122, 7522, 13124, 19193, 13130, X, 13134,
    X, X, 13125, 13113, 13121, 3839, 13135, 13133, 13123, 13118, 13111, 13727,
    13109, 7526, 13116, 7527, 7523, 13106, 13128, 13114, 19129, X, 1512, X, X,
    3519, 10394, 17728, 17729, 10541, X, 17730, 17726, 17731, 17727, 10222,
    1614, 16325, 9666, 16332, 16328, 9280, X, 9670, 16334, 9662, 9659, 4037,
    4595, 4687, X, 16899, 16901, 15701, 15695, 15692, 4533, X, 13702, 15698, X,
    15691, 15697, 15696, X, 15693, 19174, 9278, 19175, 4847, 1955, 4505, 3738,
    X, 4527, X, 15079, X, 9276, 15707, X, 15704, 4498, 9270, 9282, 8885, 15086,
    15088, X, 15091, 4537, 8890, X, 8897, 8891, X, X, 15081, 8892, 8893, 15084,
    14394, 8446, 14403, 8441, 14399, 14406, 14408, 1411, 3898, 14412, 8450,
    14392, 8444, 14397, 4556, 8439, 1419, 13697, 13710, 13704, 7977, 13716, X,
    X, 7973, 7993, 7986, X, 7975, 7972, X, 7983, 13102, 7512, X, 7498, 7495,
    13093, 7492, 19156, 13099, 19090, 7499, 13103, X, 13083, 13097, 7502, 1402,
    X, X, X, X, X, 12093, X, X, X, 4824, X, X, X, 12103, X, 7051, 3523, 12566,
    12554, 12558, 7056, 7067, 12555, 7062, 12560, 12567, 13094, 2914, 12565,
    7069, 6290, 11742, 6287, 1398, 4560, 6282, 6280, 4545, 11756, X, 6294, X,
    4823, X, 4029, X, 12559, 7055, 12550, X, X, X, 12562, 12563, X, 7057,
    12561, 7053, 7068, X, 12553, 12097, 12085, 12100, 1399, 19148, 12087, 6650,
    6664, 6646, 6663, 6655, 6660, 6644, 12086, 12092, 6659, 6016, 11526, 6004,
    6001, X, 11519, 6000, 11529, 6003, X, 6007, 4647, 1041, 4575, 5998, 11525,
    5708, 5707, 5706, 5695, X, 5702, 19136, 2273, 5701, X, X, 5711, 5700, X,
    19179, X, 19125, 1393, 7490, X, 19126, X, X, 5514, 5532, 5603, 5602, 2457,
    5604, X, X, 1740, 8047, X, X, X, 8506, 15169, 14492, X, 14484, 15168, X,
    14488, 14490, 8058, 8498, X, 13826, 13831, 13819, 8508, 3371, 8499, 8057,
    13817, 13832, 3454, 8507, 8055, 8492, 8045, 8042, 13812, 3856, 13214, X,
    7597, 4035, 3958, 4998, X, X, X, X, X, X, 4161, X, X, X, X, X, 19449, X, X,
    X, 1551, X, X, 19437, 3058, X, X, X, X, X, X, X, X, 3869, 946, X, X, X, X,
    X, X, X, 4146, X, X, X, X, X, X, X, X, 3367, X, X, X, X, X, X, X, X, 3344,
    X, X, X, X, X, X, X, 4758, X, X, X, X, X, X, X, X, X, 2412, X, X, X, X, X,
    X, 11298, X, X, X, X, X, X, X, X, X, X, 4513, 4614, 4622, 4626, X, X, 1531,
    X, X, X, X, 4117, X, X, X, X, X, X, X, X, 1667, X, X, X, X, X, X, X, 3316,
    X, X, X, X, X, X, 4051, 1580, X, 1747, X, X, X, X, X, X, X, 2919, 19171, X,
    X, X, X, X, 19631, X, X, X, X, X, X, X, X, X, X, 3743, X, X, X, X, X, X,
    4140, X, X, X, X, X, X, X, X, X, 4267, X, 1649, X, X, X, X, X, 1298, X, X,
    X, X, X, 13286, X, 13270, 13271, 13275, 2691, X, 12698, 7201, 12699, X,
    12687, 7190, 7202, X, 12680, 19100, 12689, 12697, 2960, 12679, 6776, 6784,
    6796, 6773, 6775, X, 3147, 19459, 12249, 6793, 6786, 12275, 12246, 6795,
    6790, 12255, 3950, X, X, X, 1967, X, X, X, X, X, X, X, 19481, X, 12273,
    6779, 6122, 3744, 19456, X, X, X, X, 19455, X, X, 6460, 1831, 11889, 6440,
    995, 6450, 7956, 13887, 19448, 8538, 15224, 15223, X, X, 5632, 5890, 11887,
    6439, 4956, 6438, 4144, 12240, 15221, 15220, 8975, X, 19172, X, X, X, 8976,
    15799, 15802, 9365, X, 19173, 9364, 15803, 1025, 13260, 13264, 2944, 7662,
    13259, 7664, 19436, 7663, X, 13885, 2939, 13880, X, 8091, 8095, 6764,
    12227, 12232, 19660, 6770, 6762, 12231, 6765, 6768, X, X, 12234, X, 6763,
    12239, 6766, 11611, 6110, 11614, 11613, 11612, 11615, X, X, X, X, 6426,
    11878, 11874, 11883, X, 1960, 8529, X, 15795, 15796, X, 19418, 16941,
    10236, 18825, 5629, X, 11872, 6425, 6760, 4384, 12225, 4497, X, 13866,
    16405, 10945, 1678, 5883, 11610, 6109, 6107, X, 6108, X, 11870, 6423, 6757,
    1953, 9693, 9700, 16401, 9698, 9692, X, 9699, X, 16398, 9980, 9694, X,
    9701, 9979, 16397, 15210, 8966, 8081, 15208, 8961, X, X, X, 8960, 15215,
    1951, 15193, 15206, 15194, 15205, 8964, 8072, 2901, 8070, 13857, X, 13847,
    8074, 13864, 13856, 13865, 8082, 8080, 13854, 13853, 4493, 13851, 13256,
    7624, 7616, X, X, 13243, 8077, 7620, 13251, 1508, 7642, 7639, 13247, 13230,
    X, 4792, 12221, 6749, 12639, 7144, 6754, 12206, 12214, 6750, 12213, 12210,
    12218, 12220, 6743, 6747, 6753, 7146, 11603, 11600, 11608, 6098, 11609, X,
    6091, 11606, X, 6097, 11602, 11601, 6095, 11607, 6096, 6393, 10780, 18645,
    X, 18646, 18647, X, X, 18928, 5621, 11364, 5733, X, 5877, 5878, 5876, X,
    7645, X, 13257, 7652, 7651, 7644, 7647, 7650, 7646, X, X, 13870, 7643,
    8084, 19416, 9982, 19404, 9987, 16935, 16937, 19405, 9984, 2173, 16938,
    16934, 1479, 16936, 9985, 9988, X, 16933, 15209, 13850, X, X, X, 15216,
    15201, 8967, 15788, 9340, X, 15214, 15213, 8969, 15775, 9341, 13845, 8073,
    1948, 8071, 12647, 13838, 4406, 14529, 13839, 8066, 8079, 14501, X, 8075,
    8076, 13840, 7638, 13253, 13229, 7627, 7631, 13252, X, 13239, 7632, 7626,
    13228, 19385, 8063, 13255, 13237, 7637, 12215, 6745, 6756, 12208, X, X, X,
    6748, 7145, 6742, X, 12205, 12212, 12204, 12207, 12211, 6090, 11604, 4856,
    11594, 6087, 4798, 6106, 11599, 11605, 6092, 6094, X, 11595, X, 11596,
    11597, 5879, 6086, 6085, X, 11854, 6389, 6388, X, X, 12637, 7611, 7612, X,
    X, X, 8060, 19378, X, X, 19375, X, X, 17379, X, 17371, X, 2452, X, X, X,
    16932, 17372, 15760, 15759, 9682, 15773, 16386, 16925, 9687, 1937, 16392,
    1938, 16390, X, 16926, X, 9688, 16391, 15178, 19368, 9325, 15757, X, X, X,
    19371, X, 15762, 9685, 15756, 16393, 15771, 9333, X, 2900, 13226, 12660,
    12654, 4737, 12645, 2897, 12663, 12648, 7155, 13249, 12651, 7157, 7148, X,
    5893, X, 11452, 5892, 5894, 4390, X, 11447, 11446, 11449, 11448, 11451,
    5891, 11445, 11450, 16411, X, X, X, 9710, X, 9707, 9711, 16409, 9708,
    16412, 16413, 16418, 19170, 2918, 16414, 13882, X, X, X, 8535, 19345,
    14537, 8532, 8533, 8531, 14542, 14541, 14538, 8537, 2937, X, 19469, 15815,
    X, 15811, 15807, 15827, 15824, 9370, 4094, X, 15831, 15814, 9381, 15821, X,
    13308, X, X, 13940, 13943, 8131, 13941, 8130, 13942, X, 14597, X, X, 15267,
    15268, 17766, 10731, 5635, 5745, 5896, 6125, 6463, 6464, X, X, 6797, X, X,
    12712, X, 1719, 10785, 18652, 18653, 18757, X, X, 10855, 18828, 18826,
    18827, 18829, X, X, 19502, 18929, X, 13979, 8169, 13963, 13318, X, 2750,
    13989, 13987, 13991, X, X, 19545, X, X, X, 3490, 13401, 13390, 13388,
    19665, 13389, 3311, 13396, 3491, 13397, 13393, 7752, 13398, 3082, X, 12799,
    12790, 12801, 19101, 12793, 12804, 12805, 12791, 12803, 12800, 12798,
    12802, 7253, X, 9058, X, 15959, 15960, 9439, X, 19753, 15958, 15961, 9441,
    9438, 15954, 15951, 15956, 15953, 16560, 16556, 16557, 16554, 1752, 16551,
    X, 9778, 9775, 16550, 16552, X, 9777, 16558, 2929, 10054, 17454, 17456,
    17455, 17451, 17452, X, X, 17806, X, 10434, X, 17803, 17805, 17802, 17807,
    X, 12417, 12908, 1546, 7328, 13489, 12907, 2137, X, X, 7815, 13492, 13490,
    13491, 7814, X, 3860, 2187, X, 2248, 3270, X, 16065, 16066, 16053, 16052,
    16048, 9502, X, 9494, 16068, 16072, 16063, X, 19550, 2253, X, X, X, 3863,
    X, X, 16027, X, 9492, 16651, X, 3882, X, 7872, 4954, 14240, 8314, 14242,
    14241, X, X, 14911, 8745, 15546, 15549, 15548, 7395, 7404, 12997, 7401, X,
    7398, 7402, 7400, 7394, X, X, 7881, 3224, 7875, 13608, 7880, 2314, 9173,
    15556, 9167, 3886, 9529, 15558, X, 9172, 15554, 9174, X, 2311, X, 9163, X,
    4015, X, 4011, X, X, X, X, X, X, X, X, X, X, X, X, X, 19377, X, X, 1581, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 2867, 4151, X, 964, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4477, X, 1124, 1122, X, X, X, X, X, X, 1128, 1126,
    1137, X, X, X, X, X, 19277, 11562, X, 11557, 11559, 11561, 11558, 6064,
    11555, X, 11556, 7551, X, 8934, 15136, 9303, 9304, X, 15733, 9964, 17366,
    17367, X, 10642, 18753, 11315, 5614, 13777, 8021, X, 14456, X, X, X, 9963,
    5545, 5565, 5613, 11357, 5721, X, 6060, 6059, 6057, 6058, X, X, 11800,
    6342, 6343, 11801, 6341, 19275, 4813, 6702, 12145, 6701, 6699, 6700, 7107,
    7105, X, 4714, 12603, 7106, 12602, X, 7095, 13176, X, X, 7552, 7553, 3750,
    X, 15729, 15727, 15725, X, 15731, X, 15730, 9298, 9293, X, 9295, 9297,
    4636, X, 15732, 4681, X, 2254, 15123, 15721, 9296, 15724, 15723, 15726,
    15728, 18962, 9294, X, 15722, 3347, 15720, 16351, 3308, X, 16350, 16349,
    1801, 16352, 16345, X, 16346, 16354, 16347, X, 9676, 16356, 5019, 16355,
    16348, X, 16910, 9961, 16908, 16913, 16912, 3451, X, 9960, 3193, 16911,
    16907, 16915, 16914, 9959, X, 16909, X, 9677, X, X, X, 10225, X, X, X,
    17365, 17736, 17737, 17738, 10547, 2475, X, 10548, 2865, 18058, 19691,
    18314, 18313, X, 2480, 18490, 18491, 18641, 18752, 2846, 5539, 5540, X,
    5541, 5610, 5719, 11417, 5859, 5860, X, 6051, 6052, 6050, 6049, X, 6331,
    7541, 8014, 13172, 8013, 2049, 8923, 19253, 15133, 9678, X, 9962, 16916,
    19255, 10549, X, 10724, 10938, 11354, 19054, 5720, 11355, 5863, X, 5861,
    5862, 5864, X, 6054, 6053, X, 11551, 6055, 4592, X, 11552, 11798, X, 11799,
    1846, 6334, 6336, 6338, 6335, 6339, 6337, 19266, 1290, 1291, 7096, X, X,
    7097, 7099, 7101, 7098, 993, 7103, 7102, X, X, X, X, X, 7546, 13175, 13174,
    7545, 4753, 7544, 7543, 7547, 7542, X, X, 13774, 13771, 8016, 13770, 13775,
    X, 992, X, 19244, X, 15118, 8920, 8919, 8921, 15130, 15120, 15126, 15115,
    15129, 15128, 15132, 14451, 19563, 8010, 13767, 13743, 13753, 19242, 13758,
    X, 2806, 8008, 8011, 13765, 13768, 13747, 13744, 19362, 3539, 13746, X,
    989, 13751, 13749, 8012, X, 13761, X, 19236, 13752, X, 13754, 13742, 14439,
    14437, 8480, 8478, 14447, 14438, 14448, 14444, 14436, 14450, 14435, 14442,
    8477, 8476, 8475, 14440, 14445, 8472, 8479, 2424, 14433, X, 14443, 14432,
    14441, 8473, 14446, 14434, 8474, 14449, 3455, 2815, 15125, 8916, 15124,
    8922, 3195, 15117, 8917, X, 15131, 8918, 15119, 15122, 15127, 15121, 15116,
    X, 5716, 1287, X, 1288, X, X, 5850, 5851, X, X, X, 11409, X, 6036, X, 6305,
    11774, X, 6307, X, 6306, 4760, 11775, 6304, 6303, 11765, X, 11764, X,
    11762, 6032, 6026, 11538, X, 3899, X, X, 4021, X, X, X, 2665, X, X, X,
    4918, 6027, 11533, 19190, 19208, X, 11534, 19186, 6029, X, 11536, 6025,
    11537, 11535, 6028, 6030, 6033, 5842, X, 3052, 5841, 11408, X, X, X, X, X,
    X, 6034, X, 1833, 6031, 4196, 11329, X, 11350, 11351, X, X, X, X, 5843,
    5847, 11407, X, 5845, 5844, 11406, 5846, 19180, 12568, 12569, 7070, 7071,
    X, X, 13105, 7514, 7516, 13104, 7515, 13719, 7994, X, X, 8086, 8087, 13869,
    13872, 8085, 13867, 13871, X, 13868, 2907, 8527, 19415, X, 14534, 9983,
    9986, 10230, 16403, 10229, X, X, 10235, 17384, X, 10233, 10234, 17387,
    17383, 10231, 17381, 15776, 2889, 15197, 15198, 15195, 15200, 15196, 15217,
    8963, 9342, 8965, 8970, 1513, 15199, X, 15211, 13863, 14500, 13848, 13843,
    8078, 13849, 13846, X, 19395, 8083, X, 1949, 4564, X, 4566, X, 12688,
    12682, 12683, 12696, 12690, 4368, 19539, 7181, 7185, 12704, 12684, 7197,
    7193, 19315, X, 4466, 3134, 10239, 17402, 1992, 17399, 17400, 10243, 17394,
    17398, 10242, X, 17395, 2962, X, 2007, 7700, 13317, 13316, 7720, X, 13322,
    7714, 4983, 13340, 13352, 7697, 13337, 13330, 7732, 12758, 12733, 12728,
    7221, 7233, 7214, 19543, 12741, 12746, X, X, X, X, X, X, X, 2965, 3458, X,
    X, X, X, X, X, X, 11282, X, X, X, 11283, X, 11284, 11285, X, 11286, 11013,
    11014, 11015, 11016, 11017, 11018, 11019, 11020, 11021, 11022, 11023,
    11024, 11025, 11026, 11027, 11028, 11096, 11097, 11098, 11099, 11100,
    11101, 11102, 11103, 11104, 11105, 11106, 11107, 11108, 11109, 11110,
    11111, 1099, 1100, 1101, 1102, 1103, 1105, 1108, 1109, 1112, 1114, 1115,
    1116, 1117, 1119, 1120, 11204, 19681, X, 19249, 2686, X, X, X, X, X, X,
    4471, X, X, X, X, X, 12972, 12969, 12967, X, X, 7380, 12970, 7385, 12964,
    12979, X, 8329, 8767, X, 14937, 14936, 14938, X, 15560, 15561, 9176, 9857,
    9544, 9858, X, 17196, 9545, 9555, 9551, 9552, 9548, 16148, 9547, 16154,
    16151, 3235, 9554, 4881, 9549, 9550, 16725, X, 15028, 15026, 15027, 8834,
    8835, 2448, 15029, 8833, 9224, X, 9226, 9225, X, 15632, X, 5316, 5317,
    5318, 5319, 5320, 5321, 5322, 5323, 5324, 5325, 5326, 5327, 5328, 5329,
    5330, 5037, 5038, 5039, X, 5041, 5042, 5043, 5044, X, 5085, 5086, 5087,
    5088, 5089, 5090, 5130, 10399, 18305, 18484, X, 10777, 18634, 1016, 1008,
    18955, 1358, X, X, 9943, X, X, 1956, 18047, 18048, 18632, 18744, 4006,
    2609, 18819, 18878, 18927, 18954, 9252, 10219, 17719, 18049, 18481, 18745,
    17712, 17711, 2599, X, X, X, 18739, 10851, 2600, 18877, 18902, X, X, X,
    8863, 16315, 10390, X, 4002, X, 18295, 18294, 18297, 18296, 10631, X, X,
    18474, X, 18476, 18475, 10714, 18044, 2592, 18735, 8415, 1718, X, 4000,
    1340, 17346, X, X, X, 10869, 8416, 9643, 10213, 18817, 18875, 2587, X,
    18952, 7945, 5022, 15674, 4838, 9641, 2589, 4554, 3997, 16880, 16879, 2590,
    15055, 4730, 8862, 16313, 4839, 4692, 16877, 16878, 16876, 17343, 17342,
    10212, 17709, 17344, 17708, X, 1666, 3985, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 3298, X, X, 8468, 14429, 14417, 14426, X, X, 14416, 3740, X, 8464,
    2689, 8466, X, 14421, 4014, X, X, X, 3962, X, X, 2997, 13728, 14420, 8467,
    8470, 8465, 14419, 14423, 14418, 8003, 8001, 3358, 13725, 7998, 13729,
    19198, 13724, 13726, 13720, 7996, X, 13739, 13738, 13735, 7995, 13112,
    13131, 7524, 19195, 13137, 7518, 7520, 13120, 13115, 7076, 7519, 13117,
    13132, 13136, 13127, X, 1946, 18054, 18056, 10544, 18055, 10543, 10542, X,
    4259, X, X, 10545, 18311, 18312, 4487, 9950, 16902, 16900, 16898, 16897,
    9952, 16896, 9953, X, 1663, 2608, 4430, 16894, 16895, 9949, 9954, 3989, X,
    1529, 9277, 3956, X, X, 9279, 15699, 9657, 15700, X, X, 4700, 16333, X,
    13717, 13703, 13709, 13711, 13699, 13714, 7969, 13698, 19161, 7976, 7992,
    7988, 13700, 7982, X, 3260, 4546, 4752, X, 13080, 13081, 13701, X, 1498, X,
    7967, 7970, 13712, 7990, 13715, 7050, 12557, 12548, 4577, 7058, X, X,
    12547, 1404, X, 12552, X, X, X, 4576, X, 7497, 13088, 7510, 7505, 13096,
    7494, X, X, 4567, 7493, 3105, X, X, X, X, 4007, X, X, X, X, X, X, X, X, X,
    X, X, 2197, X, X, X, X, 4927, 13227, X, 7621, 7641, 7640, X, 7629, 19391,
    13245, 13241, 13238, 4494, 11858, 6400, 6403, 6404, 19389, 6418, 6419,
    6417, 6411, 6415, 6401, 6740, X, X, 19014, 11365, 5737, 5736, 5734, 5735,
    X, X, X, 5882, 11439, 11441, 5881, 11433, X, 11434, X, 12676, 7172, 1961,
    X, X, X, 19141, X, 13262, 7661, 13261, 13263, 7660, 7665, 12674, 11885,
    11884, 11876, 6428, 6427, 6435, X, X, 19428, X, X, X, 12230, 12236, 2947,
    6767, 10946, 11334, 6761, 19425, X, 5630, 5739, X, 5885, 5884, X, X, 5886,
    5887, 11444, 11443, 15219, 8972, 16408, X, 5628, 5738, X, 6424, 11871, X,
    12224, 6759, 7655, X, 13876, 8090, 18496, 18495, 18498, 10781, 10729,
    18649, 18497, X, X, 18648, 10783, 10782, 10821, 18754, 18824, 5625, 9347,
    15789, 9344, 9360, 1469, X, 2899, X, X, X, X, 9695, 9696, 16399, 9705,
    9702, 14525, 14520, X, 14508, X, X, X, X, X, X, X, 15207, X, 15192, 15203,
    X, 13290, 13287, X, 13280, 13279, 7675, 13283, 13298, 13266, X, 13299,
    13285, 13303, 13291, 7674, 12706, 7180, 19461, X, X, 12705, 12700, X,
    12701, 7188, 7199, 12691, X, 12692, 12702, 12693, 12267, 6774, 12243, 6791,
    7194, 6780, 12260, 12259, 12248, 2685, 12276, X, 12269, X, 1296, 6772,
    12250, 12242, 12263, 12279, 6783, 12252, 12270, X, 12244, 12277, 12278,
    12281, 12272, 12257, 12265, 6789, 6455, 11902, 11891, 6458, 11909, 6442, X,
    6449, 11894, 11903, 6457, X, 6444, 6448, X, 11901, 6115, 6116, X, 6123, X,
    11619, 6118, 6124, X, 11618, 11624, X, 6117, 11622, 6119, 6112, 5631, 4539,
    5888, 5889, 6111, X, 11886, 6771, 7176, 7666, X, X, 7491, X, 8100, 8101,
    14540, 8096, 1963, X, 14544, 14539, 8534, 8530, 8536, 14543, 3636, X, X,
    8977, X, 15222, 2941, 6769, 12228, 12233, 12237, 12229, 12226, X, X, 12238,
    12235, X, X, X, X, X, 4089, X, X, X, X, X, X, X, X, X, X, 1476, X, X, X, X,
    X, 997, X, 1763, 3351, 4437, X, X, X, X, X, X, 3933, X, X, X, X, X, X, X,
    X, X, X, 2441, X, X, X, X, X, 2178, 3496, 3327, X, X, X, X, X, X, X, X,
    3774, X, X, X, X, 2449, X, 3094, X, 2509, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 19336, 19353, X, X, 1514, X, X, X, X, 1373, X, X, X, X, X, X, X,
    19429, 19430, 19536, X, X, X, X, X, X, 2684, X, X, X, X, X, X, X, X, X,
    3597, X, X, X, 3555, X, X, X, 1001, X, X, X, X, X, X, X, X, X, X, 988, X,
    2694, X, X, X, X, X, X, X, X, X, X, 1869, X, X, X, 19015, 4263, X, X, X, X,
    X, X, X, X, X, 4750, 4215, 2324, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 4128, 3676, X, X, X, X, X, X, X, X, X, 2466, X, X, X, X, X, 4482, X, X,
    X, X, X, X, X, X, X, X, 3121, X, X, X, X, X, X, 2143, X, X, X, X, X, X, X,
    X, X, 1929, X, X, X, X, X, X, X, 19446, X, X, X, X, X, X, X, X, 2562, X, X,
    X, X, X, X, X, 1442, X, 1578, X, X, X, X, 4535, X, X, 2690, X, X, X, X,
    2861, X, X, X, X, X, X, X, X, 3225, X, X, X, X, X, X, X, 4548, X, X, X, X,
    X, 4456, X, X, X, 4065, X, X, X, X, X, X, X, X, X, X, X, X, 4302, X, X, X,
    2963, X, X, X, X, X, X, X, X, X, X, X, X, X, 3653, X, 3563, 2546, X, X, X,
    X, X, X, X, X, X, X, 2394, X, X, X, X, 19442, X, X, X, X, X, X, X, X, X, X,
    X, 4677, X, X, X, X, X, 13934, X, X, X, X, 13892, X, 4773, X, X, 14588,
    13916, 13929, 8115, 13889, 13931, 8105, 13897, 8108, 8107, X, 8124, X,
    13891, 13925, 13926, 8110, 13268, 13300, 13284, 7672, 7685, X, 13293, 7678,
    2972, X, X, 13292, 13269, 7686, X, 7688, 7195, 7192, X, 7184, 7187, 4092,
    2285, X, X, X, X, X, X, 19467, X, X, 2014, X, X, X, X, X, 2017, 2018, X,
    15301, 9024, 15290, 15295, 9013, 15876, 9025, 9010, 15276, 19546, 15305,
    9014, 15302, 15315, 15282, 15291, 2988, 3570, 15313, 15303, 9009, 15298,
    9015, 9017, 9000, 2020, 15300, 15292, 15279, 9016, 15308, 15311, 15288,
    15299, 19641, 9006, 9388, 9407, 15877, 15860, 15887, 9402, X, 9392, 15880,
    X, 15884, 15889, 15878, 15866, 9395, 9398, 9406, 15881, X, 15856, 15874,
    15873, 15886, 15864, 9403, X, X, X, X, X, 19567, 16473, 19580, 16491, 9732,
    16490, 9738, 9744, 4361, 4230, X, 16484, 9740, 16479, 3249, 16467, 16472,
    2024, 16483, 10011, 10018, 16982, 16974, 10013, X, 16978, 16977, 16983,
    10019, X, 10014, 10017, 16976, 10021, 10015, 17771, 17774, 17775, 17776,
    17779, X, 17417, 17770, 10415, 17777, 17781, 17773, 2030, X, X, 18084,
    18761, 18759, 18830, 10856, 10870, 18905, 18884, 3564, 18904, 18950, 18951,
    5642, 1682, X, 1066, 2034, 12326, 12325, X, 6830, 12328, 12329, X, 12322,
    6834, 3755, 6829, 4079, 1300, 19623, 12324, X, 1319, 3292, X, 2783, 19666,
    14035, 19159, X, 3713, 14036, 8196, 2496, 14042, 3714, 3715, 7251, 3706,
    3482, 12796, 19677, 12792, 3505, 12795, 12806, 12797, 7252, 12355, X, 7248,
    7250, 19003, 6849, X, 12348, 12359, 1035, 12350, 12360, 12357, 12349,
    19655, 6845, 12362, 12347, 6848, 19271, 19651, 11975, 11971, 11974, X,
    11970, 6520, 11973, 19121, 6517, 6516, 19652, 6519, 11976, 11972, X, X,
    6860, 6861, 6858, 6859, X, 12368, X, X, 12369, 6857, X, X, X, X, 2460,
    2728, X, X, X, X, X, X, X, X, X, X, 1011, X, X, X, X, X, 3513, X, X, X, X,
    X, 2417, X, X, X, X, 4718, 2676, X, X, X, X, X, X, X, X, X, X, 4603, X, X,
    X, X, X, X, 3698, X, X, X, X, X, X, X, X, X, 3892, X, X, X, X, X, X, X,
    2041, X, X, X, X, X, X, X, X, 1957, X, X, X, X, X, X, X, X, 4486, X, X, X,
    X, X, X, X, 954, X, X, X, X, X, X, X, X, X, 4225, X, X, X, X, X, X, 5182,
    X, X, X, X, 5138, X, X, X, 5145, 5158, 5245, 5255, 5256, 5257, 5050, X, X,
    X, X, X, X, X, X, X, X, X, X, 2390, 2378, X, X, 2370, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 4285, 19654, X, 3545, 3515, 3601, X, X, X, X, X, X, X, X,
    X, X, X, X, 3126, X, X, X, 972, X, X, X, X, 19274, X, X, X, X, X, X, X,
    8526, 1950, X, 14504, 14523, 14528, 14516, 8522, 14533, 8519, 13240, 13254,
    7636, X, 13834, X, 7617, 13235, 7622, 7633, X, 7628, 13244, 13234, 13232,
    13250, 12640, 6755, X, 12216, 12217, 12219, 6741, X, 1944, X, X, X, X, X,
    X, X, 1645, X, X, 4357, X, X, X, X, X, 3145, X, X, X, X, X, X, X, X, X, X,
    4192, X, X, X, X, X, X, 4245, 3167, 2623, 3129, X, 19664, X, X, X, X, 4290,
    X, X, X, X, X, X, X, X, X, X, X, 2662, X, X, X, X, 3538, X, 4958, X, X, X,
    X, X, X, X, X, X, 19511, X, X, X, X, X, X, X, 3607, 2459, X, X, X, X, 4266,
    X, X, 2228, 2242, 2106, 19235, X, X, X, X, X, X, X, X, X, X, 4650, X, X, X,
    X, X, X, 3035, X, X, X, X, X, X, X, X, X, 3757, X, X, X, X, X, X, X, 959,
    X, X, 4139, X, X, X, X, X, 2535, X, X, X, X, X, X, X, X, X, X, 4678, 1909,
    X, X, X, X, X, 1417, X, X, X, X, X, X, X, X, X, X, 19618, 3644, X, X, X, X,
    3477, 1468, X, X, X, X, X, X, X, X, X, X, 1906, X, X, X, X, X, X, 3002,
    19606, 19210, X, X, X, X, X, X, X, 11259, X, X, X, X, X, X, X, X, X, 2639,
    X, X, 19301, X, X, X, 3210, X, X, X, X, X, X, X, X, X, X, X, X, 4096, X, X,
    X, 3592, X, X, X, X, X, X, X, X, X, X, X, X, 11314, 14598, X, X, 2559, X,
    X, 18257, 18263, 18261, 18255, 18266, 4775, 18254, 2561, 10628, 18262, X,
    2819, 3546, 2556, 3055, X, X, X, X, X, X, X, X, X, X, X, 4067, X, 1565, X,
    X, 4120, X, X, X, X, X, X, X, X, X, X, X, X, X, 1341, X, X, 14466, 14458,
    X, 14460, X, 14465, 14464, 8481, X, 13780, 14462, X, X, 8482, 8023, 13785,
    13790, X, X, 13787, 1918, 4930, X, 13793, X, 4239, X, X, 14463, X, 5011,
    3651, X, X, X, 12162, 12155, 12161, 12154, 12156, 12150, 12148, X, 12163,
    12160, 6061, 6062, 11560, 11563, 6063, 11564, X, X, X, 2028, 1292, X,
    19612, 11815, 2839, 11809, 11804, 6345, 11812, 11810, 11803, 11816, 11819,
    11814, 11807, 6347, 11813, 6348, 11808, 11811, 11802, 11806, 11818, 6349,
    X, 6350, X, 11805, 11817, 6344, 6346, X, 19287, X, X, X, X, X, 4473, 4495,
    X, 2655, 2120, 3525, 19228, 19397, X, X, X, 19293, X, X, X, X, X, X, 4310,
    X, X, X, X, X, 3008, X, X, X, X, X, X, X, X, X, 4175, 4187, X, X, X, X, X,
    X, 3072, X, X, 4427, X, X, X, X, X, 2307, X, X, X, 19343, X, X, X, X, X, X,
    3681, X, X, X, X, X, X, X, 1458, X, X, 11304, 5499, X, 5522, X, 11311,
    5523, 19128, X, 5564, X, 5657, 5659, 5658, 10929, 5527, 5571, 1774, 5784,
    5786, 5785, X, 5946, X, X, 6226, 6227, 6600, 6601, X, 3578, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1314, X, 7441, 7439, 7440, 7444, X, X, X, X,
    3851, 7925, 13668, 7933, 13667, X, 13670, 17254, X, X, 17256, X, 17257,
    10193, 17253, 10192, 17255, 10189, 10190, 10191, 16806, X, X, 18887, 6197,
    6963, 13005, 13007, 13006, X, 13620, 7894, X, 13618, X, 7893, 13621, 15577,
    4855, 15567, 15572, 15578, 15575, 15574, 15573, X, 15566, 15571, X, X,
    15569, 4489, 9563, 17204, X, X, 17203, 17589, 10329, 17580, 17579, X,
    10324, 17585, 17584, 17576, 17587, 17581, 10328, 18782, 10861, X, 18857,
    18856, 18855, 18888, 3243, 18932, 18913, 10879, 6198, 7411, 2363, X, X,
    13581, 7864, X, 14226, 14225, 8309, X, 8734, 16109, 9517, X, 9518, 2292, X,
    8808, 8797, X, 14978, X, 1033, 8802, X, 14979, 8795, 8794, 4731, 8805,
    8804, 8803, 16187, X, 9876, 16186, 9874, 9873, 16752, 9582, 9875, 16753,
    9878, 16754, 9877, 10166, 17210, 10165, 10799, 6207, X, X, 11482, 7426, X,
    3259, 11480, 11478, X, 11481, X, X, 11690, 11687, 12049, 6583, 12045,
    12048, 12046, 6581, 6584, X, 6582, X, X, 3258, X, 12489, 12493, 12490,
    13638, 12488, 13640, 13641, 13639, 8365, X, X, X, 14309, 16756, 14310,
    14307, 2400, 8367, 14306, 15585, 15591, 15586, 15583, 15590, X, 16196,
    9585, 17594, 16193, 16194, 16192, 14304, 9584, 16197, 16191, 13030, 4790,
    7430, 13649, X, 13650, 13646, 7916, 13647, 4786, 13648, X, 4788, X, 1331,
    14318, 16204, 16201, 16202, 9590, 16203, 16198, 16199, 9587, X, 9588,
    16200, 9589, 1329, 16763, 4796, 16764, 17219, 17217, 17213, 10172, X,
    17599, X, 17600, 17598, 2403, 17602, 10336, 10337, 17929, 10495, 17601,
    10836, 10862, 18786, 18889, 2404, 10880, 6213, 6585, X, 8814, X, 10613,
    6214, 6981, 7917, 8370, 10338, 6586, X, 12498, 4206, 13033, 19341, 7435,
    7433, 7437, 13035, X, 7436, 7434, X, 1265, 14329, 14321, 14336, 14324,
    14334, 14341, 14333, 8378, 4604, 8374, 14322, X, 14328, 8376, 2408, 14327,
    14993, 15012, 15021, 14996, 8825, 3097, 15009, 8815, 8817, 8829, 14994, X,
    19463, 8818, 8820, 8830, 8819, 2410, X, X, 2428, 8828, 15002, X, 14991,
    8826, 15001, 8822, 15019, 8827, 15017, 15005, 15015, 8824, 14992, 15018,
    15013, 4409, 15020, 8816, 3920, X, 8831, 8821, X, 2798, 14998, 3543, 15006,
    15010, 2411, 15014, 8823, 14997, 14995, 15007, X, X, X, 3921, 15004, 15003,
    3580, 15008, 15011, X, 15016, X, X, X, 15599, 3419, 9207, 15609, 15601,
    9212, 9216, 15618, 15626, 15611, 9208, 4309, 15615, 14999, 3504, 9209,
    15622, 15627, 15619, 2983, 15621, 15630, 15623, 15605, 15614, 2813, 15602,
    15620, 15617, 15612, 15598, 15597, 15606, 15625, 9215, 15628, 15604, 15608,
    9595, X, 3923, X, 17309, 4733, 10377, 17674, 17675, 10378, X, 17673, 4747,
    17995, 17994, 17997, 10526, 17996, 3975, 9243, 15663, 1455, 16283, 16843,
    X, 1593, 9630, 9928, 16841, 4837, 16844, 9929, 4113, 17306, 16842, 17987,
    3346, 17986, 17989, 17984, 17982, 4284, 17988, X, 18244, 18242, 10623,
    18241, 18247, 18245, 3348, 18232, 10621, 10620, 18237, 18580, 10763, 18424,
    10699, 18423, 18234, X, 18581, 10806, 3969, 10866, 18865, 10842, 10865,
    18864, 18916, 18917, 1711, X, X, X, X, X, X, X, X, X, X, 4697, X, X, X, X,
    X, 2928, X, X, X, X, X, X, X, X, X, 2654, 3170, X, X, X, X, X, X, X, X, X,
    X, X, X, 3168, X, X, 4721, 4793, 2938, 19540, 3611, 2518, 3650, 19023,
    19225, X, X, X, X, X, 3663, X, X, X, X, X, X, X, X, X, X, 3660, 3281, X, X,
    X, X, X, 1046, X, X, X, X, X, X, X, X, X, X, 19281, X, X, X, X, X, X, 3119,
    X, X, X, X, X, X, X, X, X, 2141, X, X, X, X, X, X, X, 3450, X, X, 4235, X,
    X, X, X, X, 3214, X, X, X, X, X, X, X, X, X, 2431, 3690, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1900, 4317, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19588, 19419, 3431, 19006, 3517, X, X, X, X, X, X, X, X, X, X, X,
    X, 4713, 4782, 3103, 2809, 19388, 19307, X, 2192, 2660, X, X, X, X, X, X,
    X, X, X, X, X, 1443, X, 3109, X, X, 4553, X, X, X, X, X, X, X, 1554, 1561,
    4607, X, X, X, 2519, X, 19233, X, X, X, X, X, X, X, X, X, 2334, 3130, 4323,
    19229, 3625, 2202, 3452, X, X, X, X, X, X, X, X, X, X, 1903, X, X, X, X, X,
    3287, 3286, X, X, X, X, X, X, X, X, X, 2193, X, X, X, X, X, X, X, 10952,
    5430, X, 5428, 5429, 5431, X, 5123, X, X, 5098, X, X, 5097, X, X, X, X, X,
    5102, X, X, X, X, 2681, X, X, X, X, X, X, X, X, X, X, X, 11301, 1129, 1151,
    X, X, 1125, 1143, X, X, X, X, X, X, 1127, 1145, X, X, X, X, 1061, X, X, X,
    X, X, X, 1499, X, X, X, 4686, 3789, X, X, X, X, X, X, X, X, X, 3144, X, X,
    X, X, X, 19510, X, X, X, X, X, X, X, X, X, X, 3675, X, X, X, X, X, 4717, X,
    X, X, X, X, X, X, X, X, X, 5782, 4262, X, X, X, X, X, 4344, 2669, X, X, X,
    X, X, X, X, X, X, 3303, X, X, X, X, X, X, 19638, X, X, X, X, X, X, X, X, X,
    X, 19338, X, X, X, X, X, 19166, 2711, X, X, X, X, X, X, X, X, X, 1940, X,
    X, X, X, X, X, X, 2886, 4119, X, X, X, X, X, X, X, 2153, X, X, X, X, X, X,
    X, X, 4049, 2040, X, X, X, X, 19151, X, X, 4610, X, X, 19273, X, X, X, X,
    X, X, 4086, X, X, X, 4104, X, X, X, X, X, X, X, X, X, X, X, X, 4222, X, X,
    X, 2319, X, X, X, X, 4211, X, X, X, X, X, X, X, 5002, 19011, 19531, X, X,
    X, X, X, X, 4313, X, X, X, X, X, X, X, X, X, 19250, X, 4020, X, X, X, X, X,
    2237, X, 4481, X, X, X, X, X, X, X, X, 19393, 1577, X, X, X, X, X, X, X,
    2903, X, X, X, X, X, X, X, X, 5103, 10951, X, X, X, X, X, X, 5120, 5144,
    5147, X, X, X, X, 5142, 5143, X, X, X, X, X, X, X, X, 4550, X, X, X, X, X,
    X, X, 2021, X, X, X, X, X, 3554, X, 19576, X, 1973, 1972, X, X, X, X, X, X,
    X, X, 1974, 2359, X, X, X, 3668, 984, X, X, 4425, X, X, X, X, 1919, 3338,
    X, X, 2833, X, X, X, X, X, X, X, X, X, X, X, X, X, 1932, X, X, 1990, 19497,
    2909, X, X, X, X, X, X, X, X, X, X, X, X, 19500, X, X, X, 1348, 2572, X, X,
    X, X, X, X, X, X, X, X, X, 2772, X, X, X, X, X, 4557, 4058, 1473, 1619, X,
    X, 4060, X, X, X, X, 19351, 1615, X, X, X, X, X, X, X, X, X, X, 2145, X, X,
    X, X, X, 5235, 5238, X, X, X, X, X, X, X, X, X, X, 2808, 2657, 2926, X,
    2852, X, 4985, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1002, X, 2051, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 4645, X, 2138, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 4224, 3113, 3620, 19224, 3613, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 3654, X, X, 19122, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3594, X, X, 19453, X, X, X, X, X, X, X, X, X, X, X, X, X, 3465, X, X, 1788,
    X, 2158, X, X, X, X, X, X, 4252, X, X, X, 3362, 4227, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4057, 1617, 1632, X, X, X, X, 2201, X, X, X, X, X,
    X, 2779, X, X, 19220, X, X, X, X, X, X, X, X, X, X, X, X, X, 19258, X, X,
    11308, X, 5601, X, X, X, X, X, 11402, X, X, X, 11513, 11514, 7488, 5287,
    19069, 5531, 5288, 5289, X, 5598, 5597, 5687, 5686, X, 11349, 11401, 1280,
    X, 3937, X, X, X, 5681, 5682, X, 5818, 11510, 11734, 11735, X, 6639, 12543,
    7485, 12076, 6638, 12077, 6637, X, 19082, X, 6635, X, 6636, X, X, 4675,
    12542, X, X, 4624, 7128, 6738, 7129, 12199, 12622, 6731, 7133, 6737, 6736,
    6735, 7132, 12200, 7134, 7130, X, 18960, 12188, 12184, 7131, X, X, 12198,
    7127, 12621, 12191, X, 12620, 12186, 12195, 6725, 6383, 11845, 19382,
    12196, 6726, 11834, 6384, 6728, 6385, 6381, 6386, 11844, 11833, 11848,
    6378, 12193, 12623, 12194, 6734, 12197, 12187, 6733, 12189, X, 12190,
    19102, X, 12192, 6729, X, X, 16424, 2966, 16420, 9725, X, X, 9714, 9719,
    9715, 16434, 16445, 9713, 16426, 16435, 15232, 15226, 4978, 15252, 8989,
    15261, 15227, 8986, X, 15248, X, 8987, 15234, 15245, 15241, 15243, 8543,
    19482, 14551, 8556, 1978, 14567, 14547, 3596, 8549, 14571, 14555, 8550,
    14564, 8540, 8125, 14573, 13903, 13911, 8121, 13902, 13914, 13933, X,
    13922, 4145, 1791, 4010, 2195, X, X, X, X, 3108, X, X, X, X, X, X, X, X, X,
    X, X, 2128, X, X, X, X, 19013, 11616, 6121, 11617, 11621, 6120, X, 11625,
    11620, 11623, 6113, 6114, 10407, X, X, 18072, 18073, X, 10557, 1848, 18071,
    10649, X, 18651, 10784, 18755, 18756, X, 9382, X, 9376, 15822, 15809,
    15841, 15806, 15834, 9373, 3605, 15816, 3164, 15817, 9372, 9369, 15229,
    15255, 2047, 8996, 15246, 15262, 8994, 15238, 8979, 15240, 15254, 8988,
    15233, 8992, 8982, 15242, 14572, 14577, 14557, 1976, 14574, 14554, 1322, X,
    14561, 14562, 8548, 14581, 14579, X, 14550, 14584, 14568, 13895, 8116,
    13904, 13928, 8111, 13901, 13898, 13915, 8114, 8104, 8126, 13918, 13917, X,
    X, 18658, 18762, 19629, 973, 18831, 18930, 10890, 18940, 5643, 1683, 6505,
    6506, 19632, X, 6870, X, 12373, 12374, 12375, X, 6877, 12372, 6873, 12376,
    6874, 3709, X, 3061, 3062, 11988, 11987, 6527, 11986, 6528, 11989, X,
    12377, 6872, 6871, 12379, 12378, 6876, X, 6875, X, 12404, X, 4860, X, X, X,
    X, 12872, 7308, 2063, 3781, 2616, 2064, X, 7938, 2057, 16568, 15970, 15972,
    15971, 16567, 16565, 16569, 16566, X, 9785, 2056, 3777, X, 17041, 10059,
    13449, 3775, 7786, 1806, 13448, 7787, 8228, 8227, 8226, 14094, X, X, X, X,
    14762, 8664, 18519, 18520, 1045, X, 5776, 11469, 6174, X, 11999, 6537,
    6536, 12000, X, 2054, 12403, 6892, 9448, X, X, 2643, 16562, 4281, 9782,
    16564, 16563, 2050, 15391, 9784, 9783, 9780, 9781, X, 6547, 6183, X, 6551,
    12009, 4582, 3817, 12008, X, 6544, X, 1332, 4530, X, X, 12430, 6915, 6916,
    12432, 3177, 12426, 12429, 12438, 12436, X, 6917, 12442, 6920, 12439, 7340,
    7338, 12916, 7346, 7343, 12918, 1335, X, 7345, 12917, 12915, 12920, 7350,
    7348, 14138, X, 15500, 16076, 16666, 16668, 16667, X, 10121, 17136, 17515,
    18907, 5939, 2284, 12035, 12036, 12034, 13569, 7861, 3872, 13572, 13575,
    7858, 7856, 13564, 13573, 13571, 13568, 13576, 13577, 13579, 13580, 13563,
    8307, 14223, X, 14212, 8304, X, 14891, 14221, 14209, 8302, 14214, 8305,
    14218, 14216, 8308, 8301, 8727, 14897, 8730, 8731, 14887, 14900, 8732,
    8726, 8725, 14896, 8733, 14886, 14889, 14899, 14895, X, 13008, 7412, 13009,
    7413, X, X, 13627, 13623, X, 4193, 7895, 13626, 13625, 13624, 7896, 14970,
    14969, 14974, 8788, X, 14971, 14967, 14972, 14973, 8789, 8791, 4419, X,
    15582, 15581, X, 17275, X, 17280, 17276, 17279, 10201, 4112, 17070, 17278,
    17277, 2505, 10366, 10364, 10367, 10365, 2491, 10761, 3955, 10760, 18698,
    18699, 10841, 18794, 4764, 10874, X, 6989, 8403, 15647, 15646, 16254,
    10618, 2467, 10695, X, 985, 18415, 2469, X, 10693, 10694, 18416, X, X,
    10758, 10759, 18575, 17260, 10194, X, 17631, 10511, X, 2453, X, 10195,
    6595, X, 7447, 13038, 2456, X, 13671, 18218, 10617, 10692, 18414, 18413,
    18412, X, X, 1708, X, X, X, X, X, X, X, 19662, 3359, 3478, 4137, 2621, X,
    X, X, X, 4242, X, X, X, 4246, 2147, X, X, X, 2061, X, X, 3397, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 4158, X, X, 4212, X, X, 2325, 4213, X, X, X, X,
    X, X, X, X, X, 1894, X, 4615, X, X, X, X, X, 2037, X, X, X, X, X, X, X, X,
    X, X, 2950, X, X, X, X, X, 2085, X, X, X, X, X, X, X, X, X, X, 2159, X, X,
    X, X, X, X, 4665, 3473, 3363, 2290, 3102, 2379, 19525, 19527, X, X, 4722,
    X, X, X, X, X, X, 2473, X, X, X, X, X, X, 3510, X, X, X, X, X, X, X, X, X,
    2896, X, X, X, X, X, X, X, 1748, X, X, X, X, X, X, X, X, 19570, X, X, X, X,
    X, X, X, X, 2858, X, 19016, 4352, X, X, X, X, 4416, X, X, 2827, X, 3215,
    2627, X, X, X, X, X, 2790, X, X, X, X, X, X, X, X, X, X, X, X, 2985, X,
    2377, X, 11135, 11136, 11137, 11138, 11139, 11140, 11142, 11143, 11144,
    11145, 11146, 11147, 11148, 11149, 11150, 11151, 10896, 10897, 10898,
    10899, 10900, 10901, 10902, 10903, 10904, 10905, X, X, X, X, X, X, 1567, X,
    19155, X, X, X, X, X, X, X, 3285, X, X, X, X, X, X, X, X, 4013, X, X, X, X,
    X, X, X, X, 4364, X, X, X, X, X, X, X, 1669, 1722, X, X, 11207, X, X, X, X,
    X, 4653, X, X, X, X, X, X, X, X, X, X, 2501, X, X, X, X, X, 10906, 10907,
    10908, 10909, 10910, 10911, 10912, 10913, 10914, 10915, X, X, 5108, 5107,
    X, X, X, X, X, X, X, X, 5117, 5116, X, X, 5251, 5252, 5254, 5253, X, X, X,
    X, X, X, X, X, X, X, 3618, 2864, 3632, X, X, X, 1870, X, X, X, X, X, X, X,
    X, X, X, X, X, 3727, X, X, X, 1759, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4857, X, X, 4540, X, X, X, X, X, X, X, X, X, X, X, X, X, 19593, X, X, 3182,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 19474, 2213, 3149, 2191, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 4726, 1750, X, X, 19053, X, X, X, X,
    19695, X, X, X, X, X, X, X, 947, X, X, X, X, X, X, X, X, 6587, 1706, X,
    13663, 14343, 16238, 17952, X, 1707, 18410, X, 19625, 19628, 10755, 18571,
    18574, 18570, 18572, 18573, 18567, 18568, 18565, 3420, X, 18569, 18201,
    3531, X, 10615, 3263, X, 18216, 18203, 2834, 18208, 18210, 18188, 18213,
    18199, 18204, 18192, 17935, 10497, 17950, 19211, 17943, 17946, 10503,
    10508, 10506, 17939, 17934, 3414, 10501, 10502, 17930, 10498, 10346, 17620,
    17622, 10343, 17625, 17603, X, 17606, 3463, X, X, 3462, X, 2836, X, 4367,
    3635, 17621, 17605, X, 10339, 17615, 10341, 10349, 10347, 17617, 10348,
    17607, 2707, 17608, 17613, 17618, 10186, 17243, X, 2432, 3547, 10178,
    17229, 17244, 2524, 17238, 16771, 17245, 17226, 3355, 10183, X, 10769,
    18608, 18603, 18607, 3375, 18610, 18606, X, 18602, 3987, 10771, 18605,
    18609, 10770, 18600, 18006, 3980, X, X, 3981, X, X, 18256, 18259, X, X, X,
    X, 10384, X, 2560, 4906, X, X, X, X, 17686, 17689, X, 17687, 17691, X, X,
    X, 17692, X, 17684, 16859, 9933, 16858, 16857, X, 16861, X, 4834, X, X,
    17312, 17315, X, 4807, 17314, 3380, 16297, 16293, X, X, 16292, 16296,
    16295, 9636, X, X, 16860, 16855, 16853, 16862, 16854, 3377, 2552, 10706,
    18439, X, 10705, 18597, 18596, X, 10845, 18798, 7941, 15051, X, X, X,
    15670, 18705, X, 10844, 10868, 18924, 7452, X, 9633, 9932, 17676, 4740,
    18594, X, 2545, 4742, 13041, 18592, 10812, 10766, 10810, 10811, 18797,
    10867, 4896, 7451, X, X, X, 17672, X, X, 13040, 10702, 18430, 18429, 10701,
    18428, 10700, 18427, X, 18587, 18589, 18588, X, 18585, 10765, 18582, 18586,
    9623, 9626, 9628, 16274, 16275, 9627, 4182, 16281, 16279, 9629, 4783, 9625,
    16271, 9622, X, 9624, 15652, X, 15651, 9237, X, 9238, X, 15653, 16264,
    9240, 9618, X, 9239, X, 3963, X, 4277, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 5007, X, 3065, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2910, X,
    2464, X, X, X, X, X, X, X, X, X, X, X, X, X, 3020, 1739, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 3600, 3410, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19374, 19325, X, X, X, X, X, X, 4097, X, X, X, X, X, X, X, X,
    4503, X, X, 4443, X, X, X, X, 2383, X, X, X, X, X, X, X, X, X, X, X, 966,
    X, X, X, X, X, 4038, X, X, 3522, X, X, X, X, X, X, X, 4214, X, X, X, X, X,
    X, X, X, 19420, X, X, X, X, X, X, X, X, 4337, X, X, X, X, X, X, X, 1308, X,
    X, X, X, X, X, X, X, X, 4912, 2125, 3476, 3140, X, X, X, 19018, X, X, X, X,
    X, X, X, X, X, X, X, X, 4672, 3568, 2444, 19558, 2977, X, X, X, X, 19000,
    X, X, X, X, X, X, X, X, X, X, 4442, X, X, X, X, X, 4676, X, X, X, X, X, X,
    X, X, X, X, X, X, 4655, X, X, X, 4449, X, X, X, X, X, X, X, X, X, X, X,
    2373, 4659, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4395, 2012, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 1911, 2135, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 2693, 4668, X, X, X, X, X, X, X, X, X, X, X, X, 19073,
    X, 4342, 4510, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4101, 4460, X,
    X, X, X, X, X, X, X, X, X, X, 1053, X, X, X, 4126, X, X, X, X, X, X, X, X,
    X, X, X, X, 1104, X, 1118, X, 1055, X, X, X, X, X, X, X, 1056, X, X, 1057,
    X, X, X, 2930, X, X, X, X, X, X, X, X, X, X, X, X, 1494, X, 3507, X, 19381,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4109, X, 4260, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4157, X, 3017, 4148, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 4303, X, X, 19657, X, X, X, X, X, X, X, X, X, X, X, X, X, 1569, X,
    X, 4552, X, X, X, X, X, X, X, X, X, X, X, X, X, 3982, X, X, 11796, 6333,
    6332, 11797, 1289, X, 1652, 6692, X, 7094, 12597, 4490, 13173, X, 7081,
    2816, 7086, X, 12591, 12588, 12593, 7082, 12587, 1826, 7085, 7083, X,
    12595, 7084, 7088, 2824, X, 7089, 19218, 7091, X, 4256, X, 7090, 3118,
    3639, 2811, 12589, 12590, X, 14430, 3356, 1490, 15101, 8902, 15107, X, X,
    8907, 15103, 15110, 15095, 8909, 8903, 15100, 9284, 15099, 15108, 8904, X,
    8908, 15098, 15104, 15109, 15094, 8906, 15102, X, X, 15106, 15112, 15096,
    15105, 1782, 8905, 15111, X, 1020, X, 15097, 1647, 4644, X, 9288, 15711,
    9286, 9285, 15713, 15718, X, 15714, X, 15717, 9291, 4685, 9644, 9290,
    19201, 15710, 15716, X, 9289, 15715, 2168, 15712, X, 9287, X, 4143, 4301,
    X, X, X, 16341, 18959, 16343, 16338, 9672, 16340, 1783, 9957, 16906, 9956,
    16904, 9955, 16903, X, 10224, 10223, 17732, 17734, 19204, 17733, 10395,
    10396, 1284, X, 3753, 3441, 12120, X, X, X, X, 8004, 8005, 19206, 14431,
    8910, 15113, 15719, 11540, X, X, X, 6313, 11778, X, 6311, 6312, 6310,
    12586, X, X, X, 6678, 6677, 11410, 5858, 5857, 5854, 5852, 11412, X, X, X,
    3623, 6047, X, X, 6044, 11545, 11548, 11543, 11550, 11546, 6041, 6045,
    6048, 11541, 11549, 6039, X, X, X, 4012, X, 6319, 6327, 11792, 11785, X,
    11788, 3579, 6330, 6321, 11795, 11793, 19222, 6326, 6324, 11784, 6323,
    11782, 11781, 12140, 12123, X, 6683, 12133, 6686, 6689, X, 6684, 12137,
    6687, 3666, 7087, 12143, 12125, 3631, 3239, 12127, 12134, 12138, 12142,
    12139, 12132, 12135, 4417, 19234, 12129, 6691, 12131, 12130, 12141, 6682,
    12126, 6690, 3202, 6685, X, X, X, X, X, 7093, 12594, 3456, 7092, 3115, X,
    12592, 7535, 7531, 13170, 13154, 13157, 2555, 7539, 13167, 13159, 7532,
    7540, X, 13164, 13162, X, X, 8971, 15218, 9706, 9361, 15791, 9362, 9363,
    15793, 15792, 15794, 16407, X, X, 16406, 10405, 17385, X, 17386, 17382, X,
    10232, 17743, X, 17746, 1259, X, 17747, 17745, 17748, 10406, 9346, 1269,
    9352, 9349, X, 9350, 15777, 15780, 15790, 9358, 9356, X, 15781, 13842,
    9343, 15787, 14505, 14532, 14514, 14515, 14506, 14526, 14517, 14527, 14519,
    X, 8515, 15191, 8518, 8516, 14531, 14522, 13836, 13835, X, X, X, X, X, X,
    X, 4565, X, X, X, 13231, 13852, X, 11906, 1030, 11904, 11896, 11888, 11895,
    6447, X, 6453, X, 6441, 11899, 11898, 11890, 2957, 14546, 14816, 15225,
    16419, X, 2163, 10238, 10558, 5633, X, 5742, 5743, 5741, 5744, 5740, X,
    1986, X, X, 1985, X, 16429, X, X, X, 2975, X, X, X, 10000, 16961, 15812,
    9375, X, 9368, X, 15835, 15838, 15819, 16432, 1026, X, 3641, 19684, 3090,
    X, X, 14021, 14028, X, 8184, 14027, 14024, 19649, 8186, 3821, 19644, 4904,
    14026, 19650, X, 8650, X, 8651, 14733, 14736, 14744, 8645, 8646, 14742,
    14732, X, X, X, 15373, 9059, 8644, 19760, 15366, 9061, 15368, X, 3427, X,
    1330, 3418, 9440, 15952, 9444, X, 9442, X, 8676, 14796, 8674, 14793, 981,
    15436, 3142, X, X, X, X, 9089, 15428, 9476, 15438, 7805, 13481, 7810, 7800,
    7808, 13478, 7799, 13482, X, X, 13485, X, X, 4951, 14126, 14117, 10578,
    18527, 18344, 2101, 18526, 2102, 18838, 18906, 5916, 1689, X, 6175, 1320,
    12003, 6539, X, 13536, X, 13543, X, 2217, 7850, 13557, 13552, 7845, 7843,
    13548, 13544, 13530, 7834, 13535, 8287, 8283, 8291, 14192, 8284, 14184,
    14168, X, 8276, 14160, 14194, 14203, 14167, 8290, 14208, 14179, 14882,
    8715, 19732, 8716, 3855, 14836, 8708, 14840, 14878, 8717, X, 8709, 8711,
    8718, 14884, 14871, 15498, 15476, 9132, X, 15471, X, 15491, X, 9135, 15470,
    15464, 15480, 9139, 3394, 3859, 9127, 3862, 9498, 16051, 9497, 9501, 16046,
    16054, 9491, 16070, 16074, 9493, X, 16037, 16057, 16061, 16034, 3867,
    16653, X, 2257, X, 16656, 17132, 17113, 17118, 17131, 17117, 17109, 17114,
    X, 10112, X, 14930, 14926, 14929, 14927, 8758, 14921, 8753, X, X, X, 15555,
    9162, 9165, X, 15557, 16704, 16716, 16705, X, 16711, X, 9841, 9847, 16717,
    X, 4244, 9843, X, 9853, 9848, 16719, 17551, 17557, X, 17550, X, 17552,
    17561, 17559, X, 10319, 17566, 17564, 17555, 17565, 17556, 2326, 10748,
    4073, 18550, 1803, 18549, 18552, 18551, X, 18686, X, 10798, 18685, 18683,
    X, 18684, 1047, 14263, 14262, 8330, X, 14940, 14941, 14939, X, X, 8769,
    8768, X, 9178, 9177, X, 16147, 16727, 16726, 3890, 16728, 9860, 16724, X,
    4903, 10153, 17199, 10150, 10154, 10152, 10151, 17572, X, 15633, 16244,
    2450, 16243, 19755, X, 9898, 9899, 16814, 9900, X, 17261, X, 17259, X,
    4288, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5015, X, 19537, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 3682, X, 1009, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 2844, X, 4802, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4492,
    3604, 2461, 4271, 3151, X, X, X, X, X, X, X, X, X, X, X, X, X, 19390, X, X,
    2093, X, X, X, X, X, X, X, X, X, X, X, X, X, 2186, X, X, 2935, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 9942, 2617, X, 1483, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 19693, 3486, 2850, 3194, 2272, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19647, X, X, 8456, 8457, 14414, 4379, 8901, X, 8900, X, 15709,
    16336, 16335, 2797, 18883, 5534, 6022, 19177, X, X, X, X, X, 11760, X,
    11761, 6300, 979, X, 3712, X, 6666, 5838, 11404, 1283, X, 6023, 11532, X,
    11531, X, X, 6021, 6024, X, 19182, 11530, 19181, 10639, 10638, 10640,
    18310, X, 18487, 18486, X, 10721, 10723, 10722, 18488, 10778, 18751, X, X,
    15204, X, X, 15779, X, 8959, 9345, 16400, 15784, 15783, 15785, 1440, X,
    15782, 14502, X, 14503, 8512, 8521, 14510, 8524, 8525, 14511, X, 14524,
    14530, 8520, X, 8514, 14509, 7614, 7634, 7618, 8062, 13248, 7619, X, 7615,
    7630, 7625, 7623, 13236, 7635, 13233, 13246, 13242, 12665, 12653, 7151,
    12646, 12643, 12644, 7152, 12659, 12666, 7154, 12650, 12649, 7162, 7161,
    7147, 7153, 11868, 6416, X, 11864, 11857, 6414, 11861, X, 11869, 6399, X,
    11866, 6409, 6408, 11859, 6397, 9691, X, 9977, 10228, 9978, X, 5622, 1724,
    X, 4921, 11593, X, X, 11855, 6391, 6390, 16928, X, 4924, 10227, 16930,
    16929, 9975, 16927, 16931, 17380, 17376, 17378, X, 17373, 17374, X, 12222,
    X, 12223, X, 6758, 12668, X, 7163, 7164, 12667, X, X, 19410, X, 7649,
    16396, X, 9703, 4715, 9704, X, 16395, 16394, 9981, 16404, 9697, 16402, X,
    1435, X, X, 8559, X, 19506, X, 15968, 9729, 10248, 5636, 1679, 5897, X, X,
    11912, 6465, 5634, 5895, X, 6462, X, 11910, X, X, 12282, X, X, X, 12707,
    12709, X, 12708, 17754, 17396, X, X, X, 10409, X, 17753, 18077, X, 18076,
    17762, 10559, X, 18080, 18081, 10003, 16951, 9996, 9999, 16959, 16947,
    16962, 2235, 16958, X, X, 1991, 10240, 17403, 10245, 10246, 16444, 9722,
    9721, 1757, 16438, 1984, 16421, 16423, 16425, 16443, 16437, 9717, X, 16428,
    X, 16442, 15804, 9371, 9379, 4363, 15833, 9380, 15805, 15839, 15826, 15832,
    9377, 19470, 3655, 15829, X, 15836, 15259, 15235, X, 15253, 8539, 8980,
    15231, 15258, 19486, 15236, 15250, 8985, 8978, X, 15256, 1979, 8546, X,
    14586, 14565, 14570, 14563, 19485, 14582, 14549, 14556, X, 14580, 14590,
    14566, 19072, 14553, 8106, 13905, X, 8117, 13900, X, 13927, 8113, 13919,
    13932, 13894, 13899, 13893, X, 8112, 13912, 13295, 7689, 7671, 13276,
    13297, X, 19214, 7677, 7687, 13278, 13288, 13273, 13277, 7682, 13272, 7670,
    13289, 7669, 7690, 7680, 1971, 7684, 7683, 13267, 2574, 13296, 13302,
    13294, 13301, X, X, 13282, 7196, 7203, 7186, 7198, 12695, 7200, 7183, 3297,
    7182, 12681, 1970, 12685, 7191, 12703, 12694, 12686, 1968, 19464, 4928,
    3765, 1297, X, X, X, X, X, X, X, X, 19640, X, X, 3711, X, X, X, X, X, X, X,
    1999, 6479, 6495, 11922, 6486, 3565, 11937, 6130, 6153, 6144, 11632, 6133,
    6148, 11640, 6131, 6132, 11935, 11633, 6139, 6150, 11647, 11634, 5903,
    5906, X, X, X, 11645, 11643, 11630, 6140, 11637, 6135, 11631, X, 11639,
    19188, 11636, 5751, 5750, 6127, 11368, X, X, 11454, X, X, 19127, 4708,
    11460, 11461, 5908, 5909, 11457, 12289, 12290, X, 7207, 7211, 12721, 7210,
    7208, 7209, X, 13313, 7695, 8136, X, 8134, 8135, 15848, 15847, 15850,
    16461, 16460, 9730, 16462, X, 10007, 16969, X, 17406, 17768, 18502, X,
    5640, 12288, 19515, 12719, 12718, 12716, X, 12715, 12720, 12717, X, 1997,
    7693, 7694, X, X, 8133, 8560, 1996, X, 15270, 15271, 9386, 9387, 16459,
    16458, 17405, 18655, 5637, 11336, 5746, X, 6126, 17767, X, 10653, 11335, X,
    6800, 12285, 7206, X, X, 7692, X, 8132, 13944, X, 8561, 15269, X, 15845,
    15844, 9385, 15843, 15846, 16455, X, X, 16456, 16457, X, 16968, 10005,
    10249, 11911, 1995, 12283, 6798, 12284, X, 6799, X, 12714, 7205, 7204, X,
    13312, 13310, 13311, 13309, 9383, 15842, 4831, X, 16453, 16452, 16454,
    2976, X, 9728, X, 16967, 10004, X, 17404, 10247, 18324, X, 18320, 18322,
    10651, 2969, X, X, 18500, 18501, 10730, 18499, X, X, X, 18654, 17761,
    17756, X, 10412, 1993, X, X, X, 3489, 17757, 10411, 9998, 17760, 10410,
    17765, 17759, 10002, 16960, 16966, 16954, 9994, 16956, 16945, 10001, X,
    1989, 16963, 16950, 9997, 19496, 16952, 16949, 16439, 16431, 2967, 2177,
    16441, 16448, 16447, 2225, 9718, 9716, 16433, 16430, X, 16427, 16446, 9726,
    8990, 2778, X, 8983, 15247, 4385, 1982, X, X, 15257, X, X, X, X, X, X,
    4591, X, X, X, X, X, X, X, X, X, 1969, X, X, X, X, X, X, X, 4121, X, X, X,
    X, X, X, X, X, 11201, X, X, X, X, X, X, X, X, 2172, X, X, X, X, X, X, X,
    19407, 1456, X, X, X, X, X, X, X, X, 4628, X, X, X, X, X, X, X, 945, X, X,
    X, X, X, X, X, X, X, 3157, X, X, X, X, X, X, 5036, 5035, 5029, X, X, X, X,
    X, X, X, X, 1424, X, X, X, X, X, X, X, 19295, X, 1924, X, X, X, X, X, X, X,
    1528, X, X, X, X, X, X, X, X, 4440, X, X, X, X, X, X, X, 1497, X, X, X, X,
    X, 1507, X, X, X, 4070, X, X, X, X, X, X, X, X, X, X, X, X, 4640, X, X, X,
    2550, X, X, X, X, X, X, X, X, 19104, X, X, X, 19347, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 1604, 1427, X, 11295, 1142, X, X, 11297, X, X, X, X, X,
    X, 11296, X, X, X, X, 3247, X, X, X, X, X, X, 3557, 19484, X, X, X, 2252,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 19780, X, X, 4435, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 4305, X, X, 962, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 19734, 1637, X, 3474, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2073, X,
    3173, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4270, X, 2385, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 3614, 3396, 4600, 4966, 19367, 2043, 2224,
    2451, 2108, 2388, X, X, X, X, X, X, X, X, 6191, X, 13609, X, 13610, 14933,
    15559, 16145, 10148, 6960, 7408, 7409, 13002, 13001, 13614, X, 7890, 7888,
    7885, 7889, 7887, 7886, 4972, X, 8331, 18387, 2351, 2346, 10678, 18388,
    18554, 10749, 10750, 4518, 18688, X, 10835, 3891, 1704, X, X, 9831, 16680,
    17532, 4046, X, X, X, 4967, 17138, 10127, 17142, 17139, 17146, 17152,
    16682, 16683, 16673, 16672, 16686, X, 16676, 16671, 16677, X, 16688, 16669,
    16687, 16684, 9830, 9829, 17141, 2280, 17161, 10124, 17155, 17144, 17156,
    17151, 17158, 17143, 10129, 10128, 17145, 17159, 17137, 17157, 10122, 4984,
    17149, 17148, 17153, 17140, 10126, X, 10130, 17147, 17154, 10131, 17150, X,
    4968, X, 8360, 8362, 3913, 14301, 8359, 8363, 2389, 8361, X, X, X, 8799,
    14980, 8807, 14977, 9191, 2392, 9197, 9194, 3423, X, X, 16189, 9580, 9578,
    X, 16190, 3703, 9581, 9579, 16188, 10170, 10168, 10169, 10334, 10167,
    17209, 16755, 10333, 10335, X, 10492, 10493, X, 18181, X, 10800, 11692,
    11688, 6208, 6211, X, 11689, 6210, 11691, 2395, X, 6209, X, X, X, 2399,
    12047, 13019, 7427, 7429, 13022, 13029, 13024, X, X, 7913, 13645, 13637,
    13643, 13644, 7914, X, 13636, 14981, 14984, 8809, X, 14986, X, 14985, 8810,
    9201, 9200, 15589, 15592, 15584, 15588, 9202, 15587, 17926, 18183, X,
    18182, 18396, 18397, 18395, 18564, 10754, 6212, 6980, 6979, 7432, 7431,
    13031, 13032, 4602, X, 15594, 15596, 9206, 9203, 4563, 9205, 9204, 15595,
    15593, X, 4832, X, X, X, 3797, X, X, X, X, X, X, X, 6200, 8357, X, X, 8792,
    6201, 7415, 8793, 2375, 17925, 10949, 3995, 3909, 19762, 4461, 4459, 3771,
    3773, X, 4457, 11686, 12487, 12485, 6968, 12484, 6973, 6970, 6967, X, 6974,
    X, 6969, 6972, X, 6971, 12486, X, 3961, 8411, X, 8854, 1506, 15043, X, X,
    15044, 16265, X, 8853, 8855, 8856, X, 1485, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 2766, X, 2905, X, X, X, X, X, X, X, 1445, X, X, X, X, X, X,
    5016, X, X, X, X, X, X, X, X, X, 4318, 4608, 1606, 1609, X, X, X, X, 19246,
    X, X, X, X, X, X, X, X, X, X, X, 2943, X, X, X, X, 19587, X, X, 19373, X,
    X, X, X, X, X, X, X, 2974, X, X, X, X, X, 1983, X, X, 19477, X, X, X, X, X,
    X, X, X, 19579, X, X, X, X, 2588, X, X, X, X, X, X, X, X, X, X, X, 1749, X,
    X, X, X, 5662, 5663, 5664, 5665, 5661, 5668, 11346, X, 11342, 10958, 5669,
    5685, 5955, X, 2596, 11500, 5952, X, 5970, 1370, 5960, 4822, 5959, 11488,
    5963, 5958, 11493, 11501, 11702, 11714, 11721, 6237, 11707, 11700, 6236,
    11703, 6240, 11706, 2716, 6235, X, 6230, X, 6245, 6606, 6602, X, X, 3421,
    2743, X, X, X, X, X, X, 12073, X, 7025, 7003, 13066, 13054, X, 7460, X,
    13059, 13065, 7459, 13052, 7463, 13056, 13049, 7461, 13053, 7466, 7471,
    19490, 7951, 13688, X, 13678, 13677, 7953, X, 7954, 7950, 7955, 13676,
    13687, 13685, 13679, X, 4693, 951, X, X, X, X, X, X, X, X, X, X, 19157, X,
    X, 15737, 15739, 9306, 15740, X, 15735, X, 15734, 15744, X, 15742, 9305,
    15745, 15736, 3686, 14457, 14461, X, 4689, X, X, 15143, 1865, 15150, 15141,
    1841, 15148, 15139, 15147, 15151, 15138, 15142, 15137, X, 8935, 4376,
    15140, 8936, 15146, 15145, 15144, 19280, X, 15149, 4727, X, 18493, 10726,
    X, 10725, 18492, 10779, 19288, 18642, X, X, 10939, X, 5547, 5868, 11424,
    17368, 3317, 17634, 17739, X, X, 18059, 18060, X, 10551, X, 18315, X,
    10643, X, 18316, 15741, 15743, 15738, X, 1921, X, X, 16361, 16366, 16360,
    16365, 4382, 16358, 16368, 16364, 16369, 16363, 16359, 16367, X, 16370,
    16362, 19335, 16919, 9968, 1922, 9966, X, 9965, 9967, X, X, 16943, X, X, X,
    9992, X, 17392, 9991, 17390, 17391, 10237, 10408, 17752, X, 15810, 15820,
    9378, 15840, X, 15837, 15823, 15808, 19491, 19452, 15828, 15830, 9374,
    15818, 15813, 4779, X, 8547, 14701, X, 1980, 8554, X, X, X, 3852, X, X,
    15239, 15237, X, 14596, 14594, 14593, X, 14592, 14591, 8558, 14595, 8997,
    15264, 15266, 8998, 15265, 9384, X, 15275, 9026, X, 9004, 15274, 15307,
    9028, 15278, 15294, 19569, 15280, 15310, 15306, 9002, 9012, 9007, 15316,
    9011, 9018, 2019, 15277, 15852, 15286, X, 9005, 9023, 9020, 9008, 15296,
    15281, 9021, 15871, 9391, 15870, 15882, 9393, 15868, 4465, 15872, 9404, X,
    15863, 9396, 19575, 15875, 16470, 9408, 10016, 2023, 15867, X, 9390, 15862,
    9394, 15854, 9022, 15858, 19399, 15883, 15859, 15857, 9399, X, 17791,
    10423, 17790, 17789, 17787, 17788, 10656, 18099, 18509, 18832, X, 5649,
    1685, 11371, 5753, 14671, 14670, 9036, 15332, 3006, 15331, 9037, 15330,
    15908, X, 15909, 9414, X, 16510, 16511, 3806, 8182, 7741, 19642, X, 8181,
    14016, 14015, 3005, 14013, 14014, X, 14017, 14669, 14668, 14672, 4429,
    12335, X, 6838, 12336, 6840, X, 12781, 12780, 12779, 7241, X, 13374, 13375,
    7740, 13373, 13376, 6160, 6159, 6158, 11650, X, X, 4609, 6509, X, 6510,
    11959, X, 12334, X, 12337, 6839, 3004, X, 8602, 15329, X, 19636, 9413,
    19637, 10422, 5647, 14012, 5648, 1977, 5912, 11463, 5911, 19633, 12331,
    12778, X, 15328, X, 10033, 5646, 6508, 12332, 12333, 14011, 8180, X, X,
    14667, 6837, X, X, X, X, 10032, 5644, X, 6507, 7240, 8601, 5645, X, 7739,
    9035, 11338, 10563, X, X, 18097, 18098, 19626, 2618, 2640, X, 18334, 18333,
    10655, X, 18332, 18507, 18508, 1796, 4136, 17785, 17424, X, 17786, 10420,
    17784, X, 4186, 17783, X, 17782, 10421, 19624, 2791, 16989, 16985, 16987,
    X, 10030, 3704, 4562, X, 10260, 17423, X, 10257, 10258, 17425, 10259,
    17422, 15320, 15326, 15322, X, 9033, 15321, 15325, 15317, 3737, 15319,
    9032, X, 2773, X, 3634, 15323, 15318, 1744, 9034, X, 9029, X, 19605, 15327,
    4091, 9030, 15896, 15893, 15905, 15899, 15901, 9409, 15895, 15903, 4450,
    4630, 15902, 15900, X, 15906, 9412, 15897, 15904, X, 9410, 4345, X, 15892,
    15894, 9411, 15891, 15907, 19604, 15898, X, 2027, 16495, 9751, 19621, X,
    16506, 16504, 9745, 16494, 16497, 16498, 16493, 9755, 9756, 16492, 16507,
    16502, 9749, 9746, 16501, 16499, X, X, 9752, 16503, 9747, 2060, 9748, X,
    16500, 9750, 16496, X, 16505, 9753, 16508, 16509, 9754, 19106, X, 4273,
    10031, 16984, 16990, X, 16988, 10027, 10026, 10023, 16986, X, X, 3448,
    10029, 10028, 10025, X, 9052, X, 9053, 9432, 9770, 16538, 9769, X, 17013,
    10043, X, 17446, 18106, 5770, 6169, 7270, X, X, X, 8214, 14717, X, 19729,
    15356, X, 9431, 16537, X, 17445, 18105, 5769, 18662, 10823, 10824, 3038,
    3733, 18946, 10948, X, 6862, 12370, 3735, 8210, 8211, 5767, 5913, 11468,
    4680, X, 10041, 17008, X, X, 10040, 17011, 17009, 17010, X, X, 10042, 3731,
    4521, 19718, 14710, 15353, X, 9051, 15355, 15352, 15349, X, X, 15936,
    15940, 15942, 15938, 15937, 15935, 9425, 8620, 8623, 8622, 8627, 8626,
    14714, 14712, 14705, 14709, 4694, 8624, 14711, 14707, 14715, 14706, 8625,
    13411, 13410, 13406, X, 7764, 7765, X, 14057, 8207, 8206, 14051, 8204,
    3729, 14054, 8208, 14055, 12814, 4581, 7262, 7263, 19714, 7766, 12820, X,
    7268, 7266, 12821, 12816, 7265, 7264, 7259, 12819, 16527, X, X, 3032,
    17007, X, 10430, 10429, X, X, 10736, 5766, 11983, 3726, 19711, 7763, 7762,
    X, 3725, X, X, X, 8617, 14700, 8618, 14699, 4797, X, X, 15347, 15933, 9422,
    3824, X, 7761, 13404, 13403, 7759, 7760, 19706, X, X, 8202, 8201, 14049,
    3724, 19707, 14048, 11981, X, 3723, X, X, X, 4781, 12366, 12367, X, 19705,
    6856, 6854, 19704, 6855, 6853, 17003, 17004, 17005, 17436, 17435, 10265,
    17796, 18336, 5758, 1353, 6851, X, 7757, 14698, 19698, 5759, 7754, 14694,
    9763, 10428, 10735, 18764, 5757, 4986, 11979, 5213, X, X, 12363, X, 12364,
    X, 10055, 17025, X, 17032, 17029, 4937, X, X, 17453, X, X, 17450, X, 10273,
    X, 18528, 2127, 10791, 10793, 18666, 10792, 18770, 18840, 18842, 18839,
    18841, 10877, X, X, 4444, 17473, 17479, 10292, 17482, 10287, 10288, 17474,
    17481, 17476, 10293, 10290, 1849, 17472, X, 10289, 17478, 9804, 9797,
    16591, 16597, 16607, 16600, 16605, 16593, X, X, 16601, 9799, 16599, 2123,
    9801, 16595, 3802, X, 2114, 3137, 3801, X, X, 15990, 9468, 9477, 9473,
    15987, 3135, 9470, 9474, 15999, 9092, 15442, 9098, 15423, 3672, X, 15439,
    15420, 3475, 15441, 15424, 2111, 9105, 9102, 15440, 15434, 8244, 14124,
    14121, 14113, 14122, 8246, 14114, X, 14110, X, 4555, 8679, 14119, 2107,
    8243, 14125, 6899, 12415, 6897, 12413, 6902, 6898, 6903, 6901, 12414, 6900,
    7315, 7314, 12900, 7323, 12893, 12899, 4801, X, 10895, 5915, 2100, 12002,
    X, X, 12408, 12409, 12407, 3791, 3132, 6896, 4741, 12410, 17063, 9787,
    3787, X, X, 19083, X, X, X, 17462, X, 3788, 17460, 17466, 10283, 17464,
    2079, X, X, X, 16579, 16574, X, X, 16584, 9786, 16576, 9790, 16582, 16573,
    16570, 16585, 15404, 15403, 2081, X, 9079, 9074, 15405, 9077, 15411, 15413,
    X, 15408, 15401, 9078, X, X, 2999, 7780, 3361, 13433, X, 3759, 13426,
    13428, 13430, 3428, 13431, 13429, 7781, X, 8671, 14778, 8672, 14779, 8673,
    X, X, 3794, 9084, 15419, 15416, 15418, 9085, 9086, 15417, 10443, X, 4743,
    10575, 2091, 18127, X, 18126, 18124, 18123, 18125, X, 10574, 10576, X, X,
    4945, 1808, X, 15982, X, 2098, 15983, 2097, 9463, 15985, 15984, 3128, 2103,
    X, 7376, 7371, 12925, 7369, 7368, 7373, 12947, 7365, 7372, 12453, 14158,
    12942, 3617, X, 12932, 7846, X, 7838, 13528, 13533, 13550, 13556, 7851,
    13529, 13541, 13547, 7841, 2220, X, 13558, 13551, 14169, 14189, 14164,
    14198, 3334, X, 19041, X, 4529, X, X, 14206, 4587, X, X, X, 3836, X, 16015,
    X, 16018, 9490, 16017, 9489, 9485, 9486, 9487, 16014, 16013, 16625, 16619,
    16628, 9811, 16627, 16623, 4586, 16629, X, 16622, 10100, 17090, 17096,
    10104, 10106, 10103, 10102, 3840, 10101, 10099, 17091, 17094, 10098, 17095,
    4969, 10105, 17093, X, 17092, 10299, X, 10300, 17490, 17488, 17489, X, X,
    17837, X, 17836, 10454, 18137, 10585, 18136, X, 18354, 18531, 10744, 18843,
    18844, 10794, 5929, 3841, 6554, 14148, 9120, 10107, 17097, 5930, X, 7353,
    7352, 14149, 19723, 7354, 12922, 7829, X, 14153, 8701, X, 9122, 9815,
    10108, 10301, 18138, 5933, 6556, X, X, 3823, X, 3825, 13516, 7823, 4516,
    13507, 13509, 2167, 13510, X, 13518, 13514, 13512, 7827, X, 4528, X, 1601,
    X, X, 3175, X, 8266, 14147, X, X, 14145, 8268, X, 16675, 9506, 9828, 16685,
    16681, 4584, 16679, 16674, 16689, X, 3875, 4970, 9832, X, 16670, 15531,
    15523, 15517, 15501, 9147, 15524, X, 9150, 15528, X, 15522, 9144, 15520, X,
    15514, 9142, 15505, 15513, 15525, 15511, X, X, 15515, X, X, X, X, X, 9515,
    14893, 16094, 16103, 16093, 16089, 16086, 9516, 16084, 9149, 16077, 9514,
    16083, 9513, 16088, 16085, 16101, 16096, 16090, 16095, 9509, 16087, 16106,
    16078, 16079, 16102, 9510, 16107, 9512, 16108, 16092, 15504, 16098, 16091,
    16100, 16097, 4511, 2276, X, 16082, 9507, 16105, 9508, 16080, 9511, 16678,
    16099, 16104, X, 19055, X, X, 16631, 5931, 6924, X, 3707, 14150, 14151,
    14152, 9121, 9814, 5932, X, 6555, 12443, 7355, 13520, 8272, X, 9123, 15459,
    16019, X, 2175, X, 4955, 5934, 8273, 14823, 9124, 5935, 12011, 12444, 6925,
    X, X, 12924, 19523, X, 7358, 2181, 7356, 7357, 7359, 4646, X, 12923, 14826,
    X, 14827, X, 14825, 14828, X, 8702, X, 14824, X, 9125, X, X, 16024, 16020,
    11473, X, X, 11682, 11683, 11677, X, 19294, X, X, 11681, 6186, X, 6187,
    11678, 11676, 12013, X, 12028, 12030, 1588, X, X, X, X, X, 3846, X, X, X,
    X, 1311, 12451, 6939, 6934, 6927, 6932, 6928, 6947, 12449, 12941, 6935, X,
    4593, 12461, 12090, X, X, 3179, 14140, 14821, X, 8267, 14144, 4525, X,
    14141, 8263, 8269, 14146, 8265, 14143, 14809, 14822, 14814, X, 14808, 8694,
    8700, 14819, X, 14812, X, 8697, 1880, 1597, 8695, 14820, 8692, 8691, 14815,
    8696, 8271, X, 14818, 14810, 8693, 8698, 8699, X, 3833, X, X, 9118, 9114,
    X, 9119, 15454, 3834, X, 15453, 15455, 9116, 15452, 9117, 15458, 15457,
    15456, X, 9115, 9488, X, 16016, 16012, X, 3838, 16620, 16630, 9813, 9812,
    1505, 16624, 16626, X, 16621, X, 8312, 14237, X, 2295, 2296, 14233, 14235,
    14230, 14229, 14227, X, 14234, 14236, 14232, 3206, 14909, X, 8744, X, 8736,
    8743, 14901, 14228, 8739, 8737, 14907, 14906, 8738, 8740, 14905, 8735,
    19768, 14238, 9153, X, X, 16110, 16117, 9520, X, 16121, 9524, 16113, 16111,
    X, 16120, X, 13653, X, 13654, 13652, 7918, 1743, 13660, 13655, 13657, 3051,
    X, X, 14332, 2313, 14331, 8377, 8379, 14330, 3917, 8371, 8372, 14342,
    14340, 1022, 14339, 14325, X, 14337, X, 8375, X, 10204, 17294, 17305,
    17665, 17668, 17670, 17669, X, 17663, 17667, 17662, 2531, 17664, 10375,
    17661, 17290, 17289, 17286, 17285, X, 10203, X, 3967, 3315, 2525, 17660,
    3335, 17659, 10372, 10370, 10371, 18226, X, 18227, 18228, 18419, 10698,
    2506, 10697, 1830, 18578, 18577, 10762, 19039, X, X, 10805, 2493, 18418, X,
    18576, X, 18795, 1710, X, X, X, X, X, X, 6990, 2495, X, 2763, 2762, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 1915, X, 2066, 3325, X, X, 1853, X, 19526,
    X, X, X, X, X, X, X, X, 3610, X, 3019, X, X, X, X, X, X, 2873, X, X, X, X,
    X, X, 3070, 3730, X, X, X, X, X, X, X, 1910, X, X, X, X, X, X, X, 4134, X,
    X, X, X, X, X, X, X, 3104, 1407, X, X, X, X, X, X, X, 19346, X, X, X, 4496,
    X, X, X, X, 19639, X, X, X, X, X, X, 19564, X, X, X, X, 2675, X, X, X, X,
    X, X, X, X, X, X, X, 3541, X, X, X, X, 1659, X, X, X, X, X, X, X, X, X, X,
    X, 3312, X, X, X, X, 1804, X, X, X, X, X, X, X, X, X, X, X, 1535, X, X, X,
    X, 1840, X, X, X, X, X, X, X, X, X, X, X, 4304, X, X, X, X, 19024, X, X, X,
    X, X, X, X, X, X, X, X, 2481, X, X, X, X, 4334, X, X, X, X, X, X, X, X, X,
    X, X, 2180, X, X, X, X, X, 4033, X, X, X, X, X, X, X, X, X, X, 3001, X, X,
    X, X, X, 1268, 3643, X, X, X, X, X, X, X, X, X, 4087, X, X, X, X, X, X, X,
    3883, X, X, X, X, X, X, X, X, 1720, X, X, X, X, X, X, X, X, 4375, X, X, X,
    X, X, X, X, 2880, X, X, X, X, X, X, X, 3148, X, 19327, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 2650, 3536, 2348, 19248, 2970, X, X, 2465, X, X, X, X,
    X, X, 4243, X, X, X, 19027, X, X, X, X, X, X, X, 4892, X, X, X, X, 4160, X,
    X, X, X, X, X, X, X, X, X, X, 1539, X, X, X, X, 19634, 2620, 3503, X, X, X,
    X, 1836, X, X, X, 19547, 19757, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 3165, 19427, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1823, 2810, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4041, 2759, X, X, X, X, X, X, X,
    X, X, X, 3011, X, X, X, X, 3498, X, X, X, X, X, X, X, X, X, X, X, 4030, X,
    X, X, 19047, 19031, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1761,
    5331, 5332, 5333, 5334, 5335, 5336, 5337, 5338, 5339, 5340, 5341, 5057,
    5045, 5058, 5153, X, 1886, X, 4179, X, X, X, X, X, X, X, X, X, X, X, X,
    1898, X, X, 3191, 2246, X, 19107, X, X, X, X, X, X, X, X, X, X, X, X, X,
    10965, X, X, 4929, X, X, X, 4907, X, X, X, X, 3746, X, 1610, X, X, 1523, X,
    X, X, X, X, X, 2721, X, 4174, X, X, X, X, 970, X, X, X, X, X, X, X, X, X,
    X, X, 1952, X, X, X, X, 1502, X, X, X, 4154, X, X, X, X, X, X, X, 4671,
    3013, 3642, 3091, 2679, 19516, X, X, X, 19645, X, X, X, X, X, X, X, X, X,
    X, X, X, 2443, X, X, X, 975, X, X, X, X, X, X, X, X, X, X, X, X, 1988, X,
    X, X, 3722, X, X, X, X, 3036, 19123, X, X, X, X, X, X, 19465, X, X, X, X,
    X, X, X, X, X, 11202, 11203, X, X, X, X, X, X, 4936, X, X, X, X, X, X, X,
    X, X, 1822, X, X, X, X, X, X, 2472, X, X, X, X, X, X, X, X, X, X, 19493, X,
    X, X, X, X, 2890, X, X, X, X, X, X, X, X, X, X, 2892, 4673, X, X, X, X, X,
    7943, X, X, X, 10629, 18472, 3996, 10849, 10850, X, 7944, 18811, 18812,
    18805, 18808, 18816, 18810, 18809, 18807, X, 18813, 1347, 18869, 1343,
    18870, 2573, 18872, 18616, 18618, 18612, 10772, 2563, 18625, 18623, 10773,
    18622, 18621, 18614, 18611, 18617, 18626, 18613, 18619, 18273, X, 18271,
    3990, 18276, X, 18288, 18279, 18272, 18268, 18281, 18274, 18277, 18270,
    18284, 18267, 4632, 10387, 17703, 17694, 17704, X, 17700, 17702, 17706,
    17699, 17707, 17697, 17693, 10388, 4517, 17705, 16866, 3383, 16872, 9935,
    X, 16864, 9936, X, 9937, 16869, X, X, X, 17341, 17328, 17329, 18804, X,
    18802, 18799, X, X, 18801, 18800, 18866, X, X, X, X, 18868, 18867, X, 2661,
    X, X, X, X, 3464, 19163, 3196, 2916, X, X, X, X, X, X, 4483, X, X, X, X, X,
    X, X, X, X, 7450, X, X, 15050, X, 15049, X, 9242, 2533, 17666, X, X, 17992,
    17981, 10524, X, X, 10525, 17980, 17985, 17991, 17983, 17990, 3169, 4769,
    17658, 3968, 17977, X, 10522, X, 17976, 17975, 10523, 4911, 18236, 18235,
    3336, 18233, X, 4547, 1416, 1481, X, X, X, X, X, X, X, X, X, X, X, X, 5197,
    5198, 5199, X, 1692, X, X, X, X, X, X, 3575, X, X, X, X, X, X, X, 4074, X,
    X, X, X, X, X, X, X, 4410, X, X, X, 19154, X, X, X, 3299, X, X, X, X, X, X,
    X, X, X, X, X, X, 1545, X, X, X, 2342, 2338, X, X, X, X, X, X, X, X, X, X,
    X, 1541, X, X, X, X, 2196, X, X, X, X, X, X, X, X, X, X, X, 2722, X, X, X,
    X, X, 1510, X, X, X, X, X, X, X, X, X, X, 4354, X, X, X, 19256, X, 5205,
    5137, X, X, X, X, X, 5040, X, X, X, X, X, X, X, X, 1493, X, X, X, X, X, X,
    X, 1459, X, X, X, X, X, X, X, X, X, 3034, X, X, X, X, X, X, 1345, X, X, X,
    X, X, X, X, X, X, 4491, 2756, 2737, 2209, X, X, X, X, 2231, X, X, X, 4118,
    X, X, X, X, X, X, X, 1832, X, X, X, 3790, X, X, X, X, X, 3572, X, X, X, X,
    X, X, 4799, X, X, X, 4032, X, X, X, X, X, X, X, X, X, X, X, X, 1533, X, X,
    X, 1377, X, X, 2227, X, X, X, X, X, X, X, X, X, 3244, X, X, X, X, X, X,
    4415, X, X, X, X, X, 1484, X, 4181, X, 11168, 11169, 11170, 11171, 11172,
    11173, 11175, 11176, 11177, 11178, 11179, 11180, 11181, 11182, 11183,
    11184, 5240, X, X, X, 5241, X, X, X, 5242, X, X, X, 5234, X, X, X, 11290,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 4347, X, X, 960, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 1737, X, X, 4248, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 2551, 19417, X, 19026, 3319, 3488, X, X, X, X, X, X, 3071, 4882, 2787,
    X, X, X, 3125, 2077, X, X, X, X, X, X, X, X, X, X, X, 2558, X, X, X, X,
    3407, X, X, X, X, X, X, X, X, X, X, X, 1418, X, X, X, X, 3401, X, X, X,
    1049, X, X, 961, X, X, X, X, 2309, X, X, X, X, X, X, X, X, X, X, X, 3685,
    X, X, 4426, X, 11185, 11186, 11187, 11188, 11189, 11190, 11191, 11192,
    11193, 11194, 11195, 11196, 11197, 11198, 11199, 11200, 5247, 18990, 18972,
    18981, 18963, 18974, 18983, 18965, 18978, 18987, 18969, 18980, 18989,
    18971, 5248, 18984, 5024, 5026, 5027, 5104, X, 10959, 10960, 10961, 5073,
    5074, 5069, 5070, 5077, 5078, 5081, 5082, 11029, 11030, 11031, 11032,
    11033, 11034, 11035, 11036, 11037, 11038, 11039, 11040, 11041, 11042,
    11043, 11044, 11112, 11113, 11114, 11115, 11116, 11117, 11118, 11119,
    11120, 11121, 11122, 11123, 11124, 11125, 11126, 11127, 3422, X, X, X, X,
    X, X, X, X, X, 1873, X, 1371, X, X, X, 4207, X, X, X, X, X, X, 19037, X, X,
    1376, 2223, X, 19202, X, X, X, X, X, X, X, X, X, X, X, 1395, X, X, 3222, X,
    X, X, X, X, 19724, X, X, 4695, X, X, X, X, 3951, X, X, X, X, X, X, X, X, X,
    X, X, 4218, X, X, X, X, 1452, X, X, X, X, X, X, X, X, X, X, X, 1155, X, X,
    X, X, 3795, X, X, X, X, X, X, X, X, X, X, X, 1147, X, X, X, X, 3779, X, X,
    X, X, X, 2062, X, X, X, X, 3782, 3849, X, X, X, X, X, X, 4886, X, X, X, X,
    X, 1914, X, X, 7947, 13681, X, X, 4780, X, X, X, X, X, 8425, 8419, 14372,
    8428, 15071, 19361, X, 15070, 15065, 8868, 15057, 8866, 15060, 8877, 15063,
    X, 15067, 4815, 8867, 15069, 16890, 9946, 16888, X, 16889, 16887, 16886, X,
    X, 16891, 9944, 2709, X, 17356, 17357, X, 3783, X, X, 1364, X, 6220, X,
    1664, X, 4808, 5519, 1684, 5561, 11320, 1777, 19267, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 3340, 5495, 5497, X, 5498, 4634, X, X, 11309, 5517,
    5515, 5518, 5516, 11310, 5560, 11319, 11317, 5559, 5558, X, X, 5654, 5653,
    5652, X, 5655, 5651, 4633, X, 4512, X, 5778, 5779, 5562, 11339, 5945,
    11697, X, X, 10926, 1721, 5520, 5563, X, 5656, 11340, 1262, X, 10927, 1366,
    1365, 8418, 14366, 14367, 10928, 5501, 1367, 5566, 1384, X, 6223, 5502,
    11312, 5526, X, 971, X, X, X, X, X, X, X, X, X, X, X, X, 1048, X, 1824, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 19320, X, 2949, X, X, 1902, X, X, X,
    X, X, X, X, X, X, X, X, X, 3266, X, X, X, 4439, X, X, X, X, X, 4177, X, X,
    X, X, X, X, 2427, X, X, X, X, 3941, X, X, X, X, X, 4071, 19749, X, X, X, X,
    X, X, X, X, X, 4396, X, X, X, X, X, X, 19247, X, X, 1852, X, 2029, X, X, X,
    X, 2992, 3717, X, X, 3024, 3718, X, X, X, X, X, 3719, X, 3294, X, X, 3048,
    2922, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3843, 4296, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2470, 957, X, X, X, X, X, X, 956, X, X, X,
    X, X, X, X, X, 1462, X, X, X, X, X, X, X, 5917, 1309, 6904, 12764, 7326, X,
    X, 7813, 14127, 14128, 18132, 18131, 10582, X, X, X, 18349, 4141, 18347, X,
    18345, 18348, 10663, 18350, 4631, 10662, 17074, 10083, 17068, 10078, 17081,
    10082, 10075, 17075, 10086, 17073, X, X, 17077, X, X, X, 17830, X, 10449,
    17831, 18530, 10827, 18771, 5918, 6542, 6541, 12418, 6905, 19538, 9106,
    4995, 8683, 15444, X, 9480, 16000, 9481, 4845, 9805, 16613, 16611, 16612,
    17086, 17085, 17084, 2131, 2132, X, 16610, 10090, 17083, X, 2133, 10294,
    4507, 17829, 17828, 10583, 18351, 3138, 18529, 10826, 11470, 1687, 1690,
    6540, 6176, X, X, 12416, X, X, 12906, 12901, 12905, 12903, 7327, 12904,
    12902, X, 13488, X, 14129, 14130, 14799, 14800, 8681, 8682, 14798, 14801,
    14797, 8680, X, 14175, X, 8275, 8295, 3853, 14190, 8297, X, 14186, 8286,
    8280, 8288, 8277, 8294, 2244, 14866, 2232, 3466, 14847, 14846, 8707, 14832,
    8704, 14856, 14833, 14854, X, X, 14843, 14879, 2613, 9136, 15472, 15466, X,
    9129, 14872, 9128, 15483, X, 9126, 9141, 9134, 15484, 15473, 15465, 15492,
    16071, 9500, X, 9499, 16026, 9503, 16064, 16036, 16056, 16030, 16044,
    16039, 9495, 9496, 16058, 16075, 17102, 17126, 17128, 17101, 10111, 17130,
    17122, 10118, 17129, 17115, 10120, 17107, 16660, 17123, 17120, 17103,
    10307, 17508, X, 17498, 17493, 17499, 17509, 17513, 17512, 10309, 10308, X,
    X, 17500, 17514, 17503, 3868, 17845, 17861, 17854, 10459, 10460, 17858, X,
    17846, 10455, 10457, 17841, 17849, 17843, 3404, 17859, 3188, 10589, X,
    1019, 2866, X, 2260, 10665, 18355, 18361, 10667, 18145, 18360, X, 18367,
    18358, 6948, X, 12960, 12959, 7379, 7852, 13562, X, X, 13561, X, 8300,
    8721, X, 8720, 8722, 3197, 12975, 12961, 7386, 7383, 12973, X, 12976,
    12962, 7384, 7381, X, X, 4719, X, 7862, 7855, 13566, 13565, 13578, 7857,
    13567, 7859, 7854, 13570, 7863, X, 7860, 13574, X, X, X, 13532, 13534,
    13539, 13559, 7847, 7837, X, 13531, 7848, 7849, 13542, 13549, 13555, 8278,
    14180, 14205, 14173, 14166, 14177, X, 14165, 14163, 8274, 14197, 14172,
    14200, 3619, 14201, 8282, 14885, 14837, 14870, 3186, 14883, 2674, 14831,
    8285, 2230, 14845, 14844, 8712, 4664, 14848, 14850, 14865, 15493, 15462,
    15481, 3219, 15461, X, X, 15479, 2239, 15486, 15474, 15469, 15467, 4069,
    15468, 15487, 16029, X, 16059, 2671, 1059, 19221, 9505, 14849, 16041,
    16032, 16035, 16073, 16042, 16033, 16031, 16028, 16659, 16640, 16646,
    16650, 16644, 16664, 16661, 16658, 9821, 9822, 9826, 16637, 16665, 9825,
    16655, 3866, 17106, 17116, 17127, 17108, 17110, X, 10310, 17104, 10119,
    10303, 10110, X, X, X, X, 10116, 10305, 17856, 17510, X, X, 10458, 1835,
    17848, 17852, 17844, 17847, X, 17855, 10456, 17860, 17853, 18146, 18143,
    2265, X, 18148, 18150, 10591, 10593, X, 18149, 10594, 10592, 18151, 19086,
    X, 1760, 18669, X, 2468, 18773, X, 3162, 18845, 18846, 18847, X, X, 18941,
    18931, 11476, 6573, X, 16132, 9526, 16131, 16133, 16134, 9537, 16136,
    16140, 16144, 2729, 9541, 9846, 16709, 16715, 16712, 10143, X, 17181,
    17549, 17563, 17558, 17560, 17548, 10318, X, 17547, 10321, 10320, 4878,
    17562, 17554, 10600, X, X, X, 10675, X, X, 10676, 18383, 18382, 18385,
    18386, X, 10677, 18548, 18553, 17193, 17195, 17194, 10149, X, 17568, 17904,
    17903, 11684, 7407, 7406, 13000, X, 13613, X, X, 14210, 14213, 8306, X,
    14211, X, 14222, 14220, 14215, 14217, 14219, 8303, X, 3873, 15516, 15508,
    9145, 15502, 15529, 9146, 15526, 15527, 15503, 9151, 15518, X, 15512,
    15519, 15506, X, 3910, 6202, X, 6205, 6204, 6203, X, X, 11685, 3911, 12039,
    3912, 12041, 6578, 1817, 6966, X, X, X, 7421, 13011, 13017, 7418, 7425,
    2382, 7420, 13014, 13016, 7423, 13010, 13013, 7419, 7416, 13012, 7422,
    13015, 7424, 7417, X, 4674, X, X, 13631, 13634, 7898, X, 7908, 7904, 13632,
    4453, X, 7912, 7905, 7910, 7900, X, 7897, 7899, 7911, 13633, 7903, 7906,
    7902, 7907, 13635, 7909, 7901, 13630, X, X, X, X, X, X, X, X, 14300, 8358,
    14302, 8801, 8806, 14976, 8796, 8798, 8800, 4233, X, 9192, 9195, X, 9199,
    9193, 9198, 9196, X, 9923, X, X, 16827, 17281, X, 16829, 9920, 16830,
    17284, 17282, 17283, 17288, 10373, 17287, 17654, 17655, 17656, 10368, X, X,
    1881, 17970, 10519, 17968, X, 10520, 17967, 17969, 10518, 18229, 16253, X,
    2492, 10200, 17273, 17272, 17651, 17649, 17652, 17650, X, X, 10516, 17964,
    17965, 17966, 3952, 3295, 10838, 18792, 10840, X, 18791, 18793, 10839,
    18863, 1021, 18915, X, X, X, X, 4047, X, X, X, X, 1517, 4623, X, X, 2704,
    4048, 1607, 2374, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1884, 19017,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4316, 18405, 18411, 10690,
    10686, X, 10687, 18401, 18408, 10689, 18406, 10688, 18400, 18404, 18403,
    3940, 18399, 19573, 19683, X, 2633, 1769, 18200, 18214, 18202, 18209,
    17936, 18207, 18190, 18212, 10616, 18194, 18211, 17949, X, 17933, 10499,
    17947, X, 2705, 17931, 10500, X, 17942, 2637, 17938, 10505, 17948, 17932,
    2979, 17220, 10342, 17626, 17623, 17627, 17614, 17610, 17624, 17940, 17612,
    X, 10345, 3932, 10344, 17222, 17250, 2636, 10176, 17221, 3931, 19703, 3511,
    3027, 17616, 17609, 10340, X, 17604, 17619, 17611, 17235, 19332, 19630,
    3053, 3930, 19008, 4523, 16778, 17225, 3416, 17230, 10179, 10181, 17236,
    10175, 17251, 17242, 17231, 17232, 17241, X, 10188, 17240, 17224, 17239,
    17227, 17252, 10187, 10185, 17228, X, 17247, 3506, 17233, 17246, 19615,
    17248, 17223, 10180, 2800, 17249, 3302, 2632, 17237, 2420, 10184, 17234,
    2771, X, 10892, 7453, 16849, 2548, 17677, X, 17998, X, 4711, 18438, 18595,
    7454, X, 15666, 15667, 2539, 8860, 2540, 15664, X, X, 9244, 15665, X, X, X,
    16285, 16284, 9931, 9631, 9632, 18591, X, 18590, 18583, 18584, 10764,
    18701, 10809, 2534, 18702, 10807, 10808, 3342, X, 18796, 10843, 1819, 2136,
    9926, 16837, 16835, 16834, 3161, 16840, X, 16839, 16838, X, 16833, 9925,
    16832, X, 4723, X, X, 19145, X, X, X, X, X, X, X, 1436, X, 1573, 1574,
    2510, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19132, 5187, 5188,
    11254, 5121, 11255, 5185, X, X, X, X, X, X, X, 18996, X, X, 4821, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 3741, X, X, 5780, 5781, X, X, 6221, X, 6998,
    5496, 11206, 1670, 11305, 5500, 5525, 5524, 5573, 5572, 11322, 5574, 5580,
    X, 5575, 5576, 11324, 11323, 5578, 5579, X, 5577, 4819, X, 1355, X, X, X,
    X, X, X, X, X, X, X, X, X, 3918, X, 1050, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 2507, X, 4341, X, X, 4327, X, X, X, X, X, X, X, X, X, X, X, X,
    3583, 3268, X, X, 4931, X, X, 3318, X, X, X, X, X, X, X, X, X, X, 4293, X,
    X, X, X, X, X, 19777, 3172, X, X, X, X, X, X, X, X, 4448, X, X, X, X, X, X,
    X, X, 2344, X, X, X, X, X, X, X, 6996, 13675, 17291, 6997, X, 3339, 15655,
    15654, 16831, X, 2418, 19534, X, X, X, X, X, X, X, X, X, X, X, X, X, 3819,
    X, X, 11389, X, X, X, X, X, 1271, 2725, X, X, 11379, 11499, X, 5968, 6238,
    X, 3433, 6231, 11705, 6239, 11704, 11708, 11715, 11713, 6247, 6242, 11699,
    11701, 6244, 6232, 6617, 6607, X, 12057, 12062, X, 12069, 6615, 6612,
    12064, 6620, 12067, 12063, 6609, 6622, 6613, 12510, 12525, X, 12514, 2547,
    12523, X, 12515, X, X, X, 1727, 7010, X, X, X, 6999, X, X, 14368, 19304, X,
    18485, 5503, 1671, 2712, X, X, 1368, 5793, 5794, 11393, 11390, 11381, 5791,
    X, 1778, 11378, 5789, 1270, X, X, 11386, X, X, 5725, 5726, 11360, X, 5869,
    X, X, 19308, 11566, 4055, 6066, X, 11567, X, 8033, 8034, X, 8035, 14473,
    14475, 14477, 8486, 8485, 8032, 14476, 14474, 2845, 15158, X, 6081, X,
    11583, 11592, 6374, X, 11589, 6083, X, 11587, 11590, X, 6373, X, 6375,
    18063, 18064, 1787, 5620, 1675, 5732, X, X, X, 11363, X, X, 6078, 6080, X,
    11432, 11579, 11578, 11577, X, 11431, 11430, 5875, 6079, 6077, 5874, X,
    2872, X, 6371, 11831, 19426, 6372, 11584, X, 11586, 11585, 11832, X, X,
    11581, X, 6084, 6082, X, 11580, 11582, 11588, 11591, X, X, X, X, X, X, X,
    X, 11852, 11839, 11837, 11851, 11846, 6727, 6376, 11847, 11850, 6723,
    11849, 6377, 6382, 6380, 11840, X, 11835, 11842, 6387, 11853, 6724, 11843,
    X, 8041, X, 13211, 13212, 7605, X, 1933, 7604, 13215, 7609, 13219, 7602,
    13216, 4220, 7607, 13209, 13218, 8043, 19356, 7596, 7601, 8044, 13220,
    7608, 13810, 13210, 7600, 7603, 7598, 13208, 13222, 13206, X, 12627, X,
    7139, 12631, 7142, 12633, X, X, 7137, 12632, 12635, 12629, 19354, 7136,
    6730, X, 12185, X, X, 2884, X, 4993, X, X, X, X, X, X, 2869, 7590, 12626,
    12628, X, 12630, 7135, 7141, 13207, 12634, 12625, 7592, 13205, X, 7140,
    7138, 12636, X, 15770, 15761, X, 9336, X, X, 9330, 16383, 9684, 15769,
    9332, 9334, 15766, 9338, 15765, 9327, 15172, 15176, 15173, 15179, 8957,
    9320, 8951, X, 15758, 15181, X, 9326, 4916, 9329, X, 1065, 6398, 4088,
    6396, 19387, 6420, 6412, 6406, 6394, 11862, 6405, 6395, 6413, 4922, 12203,
    6392, 6739, 12201, 12202, X, X, 12638, 7143, 7613, 8061, 13833, 5623, 1677,
    5557, 5624, X, 7175, 7168, 7171, 19431, 7174, X, 12675, 4131, 7169, 12673,
    19434, 7173, 978, X, 7170, 6433, X, 6431, 11879, 11875, 11882, 6430, 6437,
    11877, 11873, 6436, 11880, 6429, 11881, 6432, 6434, 13877, 19421, 13878,
    14536, 3229, X, 8974, 8973, X, X, 16942, 17389, X, 17751, 17750, 18070,
    8089, 8088, 14535, X, 17388, 10648, 18650, 5627, X, 7165, X, 7654, 7653,
    13874, 13875, 8528, 17744, 2971, X, 18069, 10555, 18068, 18067, 18066,
    10554, 10556, X, 18319, 10647, 10646, 19384, 4617, 15778, X, 9359, 15786,
    8962, 9348, 15202, X, X, 9351, X, 9355, 9357, 9354, 9353, 19739, 14518, X,
    1568, 14507, 8968, 14521, 8523, 14513, 19394, 14512, 19408, 2906, X, 8517,
    8513, 15212, 8065, 2297, 13858, 13841, 13855, 14499, 8068, 13859, 13862,
    8067, 13844, 13861, 13860, 8069, 13837, 8064, 7156, 12662, X, X, 12656,
    7150, 12641, 12664, 12655, 12657, 12661, X, X, X, X, X, 4083, X, X, X, X,
    X, 19700, X, X, X, X, 1570, 4926, X, X, X, 1790, 3603, X, X, X, 2954, X,
    3077, X, X, 2923, X, X, X, X, X, X, X, X, X, X, 2925, 3584, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 3199, 19092, 4388, 19560, X, X, X, X, X, X,
    X, X, X, X, X, X, 2318, 4620, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4111, 2870, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4066, 1564, 4588,
    X, X, X, X, X, 1579, 1521, 1616, X, X, X, X, X, 1547, 1640, X, X, X, X, X,
    X, 4629, X, X, X, X, X, X, X, X, 4223, 4381, X, X, X, X, X, X, 3661, X, X,
    X, X, X, X, X, 2084, X, X, 3776, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4662, X, 1136, 1167, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1709,
    4716, X, X, X, X, X, X, X, X, 2052, 3321, X, X, X, X, X, 1930, X, X, X, X,
    X, X, X, X, X, X, X, X, 2416, X, X, X, 1729, X, X, X, X, X, X, X, X, X, X,
    X, X, 5009, X, X, X, 4599, X, X, X, X, X, X, X, X, X, X, X, X, 3736, X, X,
    X, 3158, X, X, X, X, X, X, X, X, X, X, X, X, 4219, X, X, X, 4598, 19528,
    19187, X, X, X, X, X, X, 3447, X, X, X, 2902, X, 3499, X, X, X, X, X, X,
    2989, 3289, X, X, 4231, X, X, X, X, X, X, X, X, X, X, X, X, X, 19507, X, X,
    3590, 19197, 2591, 19613, X, X, X, X, X, X, X, X, X, X, 4016, X, X, X, X,
    2597, X, 2203, X, 19215, 2536, 19661, X, 3633, 4095, X, X, X, X, X, X, X,
    19282, X, X, X, X, X, 19440, X, X, 2953, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 4488, X, X, 3529, X, X, X, X, X, X, X, X, X, X, X, 2176, X, 19583, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 2682, X, 2068, X, X, X, X, 4226, X,
    X, X, X, X, X, X, X, X, 19386, X, X, X, X, X, X, X, 1460, X, X, X, X, X, X,
    X, X, 3903, X, X, X, X, X, X, X, X, 2549, X, X, X, X, X, X, X, 1908, 948,
    X, X, X, X, X, X, X, X, 2320, 19773, 2317, X, X, X, X, X, 5233, X, X, X, X,
    X, X, X, 5232, X, X, X, 10940, X, X, X, X, X, X, X, X, X, X, X, X, X, 4353,
    X, X, 3201, X, X, X, X, X, X, X, X, X, X, X, X, X, 19403, X, X, 1600, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 1660, X, X, 3153, 4703, X, X, X, X, X, X,
    X, X, X, X, X, X, 2843, X, X, X, 1548, X, X, X, X, X, X, X, X, X, X, X, X,
    3793, X, X, X, 2144, 3858, X, X, X, X, 4463, X, 2218, X, X, X, X, 2006,
    2987, X, X, X, X, 7730, 13315, 13319, X, 7711, 7709, 12751, 2004, 12745,
    12754, 12752, 7231, 12737, 7216, 7215, 7223, 7229, 12749, 7228, 12734,
    7696, 4265, 12742, 19231, 2754, X, 7226, 12757, 12725, 7219, 7218, 7230,
    12722, 12755, 12743, 12756, 12750, 12736, 12740, 12727, 12730, 12723,
    12724, 7232, 7217, 2990, 12748, 7227, 7213, X, 7222, 12731, 7224, 12732,
    12314, 6808, 12308, X, X, X, X, X, X, X, X, X, X, X, 1299, X, 19597, 11956,
    11958, 11953, 11950, 11952, X, X, 2036, 6503, 19189, X, X, 6501, 2423,
    2644, 12761, 12767, 12760, 12770, 19599, 19600, 12766, 7235, 7237, 12775,
    X, 12759, 12762, 12768, 19601, 13362, X, X, 13366, X, X, X, 13356, X, 8172,
    8173, 14010, 8179, 3646, 13998, 14007, 1596, 14649, 14656, 14658, 14664,
    19608, 8598, 14644, X, 8590, 19610, 14659, 8595, 14665, 8586, 19614, 14648,
    14655, 4992, 14647, 8589, 8596, 8594, 8591, 8599, 8588, 14654, 3516, 8593,
    X, 8178, X, 11667, 6168, X, 6525, X, 6863, 6864, 6865, 13413, 12822, 7269,
    X, X, 7769, 13412, 17440, 19717, 10268, 17441, 4690, X, 10266, 17442,
    10267, 17439, 17443, X, 17437, X, X, 10431, 9423, 9428, 9429, 15939, 9426,
    15934, 9427, 9047, 15941, 9424, X, X, 19716, 16529, X, 16528, 8619, 8621,
    19715, 14704, X, X, X, 4866, 15350, 9050, 15354, 9049, 15351, 9048, X,
    14703, 8209, 14052, 8203, 8205, 14056, X, 14053, 14050, X, X, X, X, X,
    14713, X, 14702, 12818, 12815, 7267, 4871, 12817, 7260, X, 7261, 3728, X,
    7767, 13408, 13409, 7768, 13405, 13407, 15348, 9046, 10947, X, 11665,
    11666, X, X, 11984, 6523, 6524, X, X, 6522, 19713, X, 17804, X, 18113,
    18116, 18112, 10568, 18114, 18115, 18117, 10569, 10571, 10570, 18339,
    19756, 18341, 7291, 12855, 12854, 12853, 12849, 7290, 7294, 7297, 2238,
    3083, 7298, 12850, 12852, 7296, 7295, 7293, 19770, 8655, 14747, 4289, X, X,
    19767, 1359, 15387, X, 15380, 15381, X, 9066, 9064, 9065, 15964, 15963,
    15966, X, 16561, 3089, 9779, 10056, 17034, 19775, 10057, 17033, 17458,
    17457, 10274, X, 2157, 4957, 4950, 16010, X, 4949, 16011, X, X, X, X,
    16618, X, X, 10096, 10095, 10093, 10094, 10097, X, 17487, 10298, 10297,
    17835, 18135, X, X, X, 10743, 10742, 5925, 1696, X, 12713, X, 8690, 8260,
    8689, 9112, X, 5926, 11375, 5927, 5928, X, X, 12005, 11672, X, 11673, 6178,
    X, 11670, 6177, X, 6180, 11671, 6182, 6181, 11674, 6179, X, 1339, 12431,
    12428, X, X, 14139, 12437, 6912, 12440, 12425, 12434, 6914, 6919, 12435,
    6923, 6921, X, 18672, 18537, 18535, 18533, 18534, 18538, X, 10795, 18670,
    18668, 18673, 18671, X, 18674, 10796, 12981, 12965, 3871, 7382, 12982,
    12977, 12963, 12968, 12978, 12974, 12971, X, 7387, 12980, 12966, X, 9180,
    9181, 9179, 3889, 15562, 2343, 15564, X, 16150, 16152, 2349, 9553, 16153,
    9546, 16149, 14952, 14945, 14953, 14950, 14951, 9184, 15565, X, X, 9183, X,
    16158, 16156, X, X, 9557, 14955, 8778, 14962, 14961, 8785, X, 8786, 14963,
    8780, 14960, 8784, 14965, 14956, X, 14958, 8781, 16742, 9862, X, 16733,
    9863, 9866, 16738, X, 16735, 9865, 3897, X, 16739, 16740, 16734, 16743,
    4472, 10609, 10611, X, 18174, 10610, 18172, 10484, 18173, 10608, 10679,
    10681, 18391, 10680, 18390, X, 2489, 3954, 17961, 4768, X, 17963, 17962,
    4110, 18222, 4770, 18223, X, 19329, 2490, 18417, 17262, 4905, 17639, 17638,
    10359, 17640, 17960, 10514, 17959, 17956, 10513, 17957, 17958, X, 18220,
    18221, 14352, 4787, X, 14351, 8395, 8391, 8392, 14347, 14349, 14350, 8387,
    8389, X, 8393, 8388, 3284, 10352, 17630, 17628, 17629, 10350, 10353, 10351,
    X, X, X, 17953, 17954, 10510, X, 18217, 18219, 18934, 18935, 18933, 18943,
    X, 1705, X, X, X, X, X, X, X, X, X, X, 1472, X, X, X, 1572, X, 19450,
    19620, 19413, 19659, 2666, 19668, 19619, 19412, 2526, 4325, X, X, X, X, X,
    2369, X, X, X, X, X, X, X, 2122, X, X, 2356, X, X, X, X, X, X, 4360, X, X,
    X, X, X, X, 953, 2956, X, X, 2952, X, X, X, X, X, X, 1854, X, X, X, X, X,
    X, X, 1013, X, 4501, X, 19444, X, X, X, X, X, X, X, X, X, X, X, X, 19048,
    X, X, X, 4570, X, X, X, X, X, X, X, X, X, X, X, X, 6589, 1723, 11376, X,
    18724, 18729, 18719, 18722, 10816, 18726, X, 18733, 18620, X, 18720, 18730,
    18734, 18725, 18718, 18275, 18280, 18282, 18285, 18269, 3393, 18289, 18290,
    18283, 18287, 18278, 4765, 18464, 18467, X, 10709, 10389, 10532, X, X, X,
    X, X, 17326, 18041, 18032, 10534, 18028, 10535, 3233, 1464, 18037, 17332,
    17330, X, 17324, 19060, X, 17327, 17337, 17331, 2581, X, 10210, X, 17339,
    17336, 10211, 16307, X, 4776, 9640, 16312, 16311, 9638, 16306, 16310, 9639,
    X, X, 3388, X, X, X, 19670, X, X, X, X, X, X, 4163, X, X, X, X, X, 4105, X,
    X, X, X, X, X, X, X, X, X, 4401, X, X, X, X, X, 5204, X, X, X, X, X, X, X,
    X, X, 5200, X, 1390, X, 1392, X, X, X, X, X, 1738, X, X, X, X, X, X, 1503,
    X, X, X, X, X, X, X, X, X, 2582, X, X, X, X, X, X, 3949, X, 1656, X, X, X,
    X, X, X, X, X, 19339, X, X, X, X, X, X, X, 10573, 18122, X, 5914, 6538,
    12001, 1007, 6895, 3120, 6894, 7937, X, 3110, 8230, 14096, 8229, 14095,
    2362, X, 2316, 2065, 14763, X, 9071, 15399, 9072, 17042, 17043, 2058, 2059,
    10278, 10279, X, 10572, 4005, 1323, 10787, 5777, X, X, X, 3780, 8665, X,
    14761, 14760, X, X, X, X, 15396, 9070, 9069, 15397, 15398, X, 9453, 9452,
    12402, 6893, X, 3976, 7306, 12867, 12865, 12871, 7307, 12866, 12870, 12868,
    12869, X, X, 13447, 10277, 10275, 10276, X, X, 2053, X, 17809, 17810,
    10437, X, 10436, 18120, 18121, 18119, X, 13515, 13519, 7824, 7828, 13508,
    X, 13517, X, 7826, 2854, 7825, 13513, 13511, X, 7822, 9113, 8264, 14142,
    8270, 8262, 8261, 3828, X, X, 3829, 3830, 14813, 14811, X, 14817, X, 10123,
    10125, 17528, 17526, X, 4870, 17533, 17530, 17534, 2281, 17519, 17527,
    17538, 17160, 17523, 10314, 16081, 17518, 17531, 17525, 17522, 17517,
    17516, 17537, X, 17521, 17520, 10312, 17529, 2278, 10311, 17862, 17535,
    17875, 17864, 4583, 10463, 17870, X, 17872, 17867, 17874, 17869, 17868,
    10464, X, 2282, 18372, 10670, 10669, 10668, 18373, 18543, 18541, 4319,
    18540, 18369, 18542, 18375, 18539, 3200, 18677, 18643, 5940, 12475, 4811,
    12983, 12984, 2287, 2288, X, 14224, X, 18376, 18777, 5941, 6952, 12476,
    2336, 7388, 12990, 12988, X, 12995, 12986, 12987, 7389, X, 7393, X, X,
    12996, 7392, 12994, 12991, 1813, 13588, 7868, 13599, X, 13583, 7869, 13595,
    13591, 13593, 13587, 13594, 2293, 1027, 7865, 13590, 14231, 8310, 8311, X,
    X, 2298, X, 4585, X, 14239, 8742, 14902, 14908, 14903, 14904, 18958, 15543,
    15535, 15536, 9152, 9154, 4320, 15541, 15533, 9156, 9155, 15537, 15542,
    15540, 9157, 15538, 3879, 16692, 16696, 9835, 17163, X, 17162, 10133,
    17168, 10135, X, X, 10132, 17164, 10136, 17165, X, 1820, X, 8373, 14338,
    14323, 14326, 14335, 3919, X, 3332, 3227, X, 15631, 15000, X, 16288, 16287,
    16286, 2542, X, 16845, 16848, X, 16847, 16846, 9930, 17310, 17308, 17307,
    4738, 18894, X, 10875, 3163, 18921, 10876, 18922, 18923, 18937, 18936,
    10891, 18947, 1356, X, X, X, 2761, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4333, X, X, 5342, 5343, 5344, 5345, 5346, 5347, 5348, 5349, 5350, 5351,
    5352, 5353, 5354, 5355, 5356, 5432, 5433, 5434, 5435, 5436, 5437, 5438,
    5439, 5440, 5441, 5442, 5443, 5444, 5445, 5446, 5447, 5166, X, 5167, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 4393, X, 5357, 5358, X, 5359, 5360,
    5361, 5362, 5363, 5364, 5365, X, X, X, X, X, X, 4072, X, X, X, 19322, X, X,
    X, X, X, 3598, X, X, X, X, X, X, X, X, X, X, 2895, X, X, X, X, X, 1430, X,
    X, X, X, X, X, X, X, X, X, X, X, 19702, X, X, X, 3391, X, X, X, X, 2277, X,
    X, X, X, X, 3382, X, 5157, X, X, 5179, X, 5178, X, X, X, 5154, 5155, 5162,
    X, X, 5163, X, 5215, 5216, 5217, 5218, 5219, 5220, 5221, 5222, 5229, 5228,
    5227, 5226, 5225, 5224, 5223, 10981, 10982, 10983, 10984, 10985, 10986,
    10987, 10988, 10989, 10990, 10991, 10992, 10993, 10994, 10995, 10996,
    11064, 11065, 11066, 11067, 11068, 11069, 11070, 11071, 11072, 11073,
    11074, 11075, 11076, 11077, 11078, 11079, 5401, 5402, 5403, 5404, 5405,
    5406, 5407, 5408, 5409, 5410, 5411, 5412, 5413, 5414, 5415, 5416, 3542,
    19191, X, X, X, 3256, X, X, X, 4328, X, X, 3574, X, X, X, 2853, 3241, X,
    3587, X, X, X, X, X, X, 2851, X, X, 4652, X, X, X, X, 19409, X, X, X, X,
    4923, X, 3066, X, 2849, X, 1638, X, X, X, X, 19241, X, 3532, X, X, 19566,
    X, X, 1964, X, X, X, X, X, X, X, X, 19451, X, X, X, X, 4447, X, X, X, X, X,
    X, X, X, X, 3384, X, 1904, 5018, X, X, X, X, X, X, X, 2269, X, X, 1901, X,
    X, 12537, X, 7041, 12540, 7039, 19079, X, 2767, 12536, 7042, 7040, 7043,
    12538, 12539, 5508, 5509, 11208, 5529, X, 1383, 5589, 5590, 5591, 11396,
    5678, 19075, 11347, X, 5815, X, 14379, 14377, X, 14373, 8423, 14371, 8429,
    14376, 14383, 14374, 14382, X, 2732, 8876, 8873, 9254, 19036, 9258, 15676,
    9253, 9261, 15679, 15680, 9259, 9260, 15686, 15683, 15684, 2733, 19038, X,
    4452, X, X, X, X, X, X, X, X, X, X, 4455, X, X, X, 6222, X, X, X, X, 4078,
    X, X, X, X, X, 7455, 13042, 5799, 11382, 5796, 5800, 11392, 11380, 5797,
    11384, 2708, X, X, 5798, X, 5801, X, 5787, 5956, 5957, 11495, 11491, 5962,
    5954, 11487, 5950, 11498, 5971, 5974, 5953, 5966, 5972, 5951, 11496, 3649,
    X, 12058, 12066, 1877, 6603, 6611, 6623, X, 12072, 12070, 4258, X, 1372, X,
    6605, 7016, X, X, 1374, X, 12506, 7009, 12507, 19022, 7030, X, 7021, 7000,
    7001, 12526, 7472, 13047, 13045, 13057, 13063, 13064, 7464, 4217, X, 13686,
    13061, 13044, 13062, 2740, 7474, 13067, 7473, 2484, 8874, X, 15066, 15058,
    8872, 8869, 15059, X, 4935, 8871, 15062, X, 15064, X, 3056, 9649, 16321,
    9646, 16318, 9648, 9650, X, 16319, 9647, X, 16320, X, 16317, X, X, 9945,
    5528, 5582, X, 5581, 5671, 5670, 5806, 5805, 5807, 5804, X, 5976, 5975,
    5977, X, X, 8487, 5556, 5618, 5619, X, 5731, 5730, X, 11428, 5873, X,
    11574, X, 6072, 12618, 7123, X, 12617, X, 7577, 13200, 7578, 13201, X,
    19323, 1883, 8036, X, X, X, 15154, 8941, 8939, X, 8940, 15152, 15153, X,
    8937, 15749, 15747, 2840, 9308, 8029, 13804, 1925, 8030, 13803, 8027, X, X,
    2841, X, 14470, 14472, 8483, 14471, 14469, 14468, 14467, 5549, 5550, 5551,
    5615, 4818, X, 6705, X, 12166, X, X, X, 8026, 5552, 11333, 11565, 6206,
    7567, X, X, 5548, 5724, 5723, 5722, X, X, 6065, X, X, 7117, X, 6356, 4763,
    X, 11821, 6354, 6353, 11820, 6351, 11822, 6352, 6355, X, 6706, X, 6708,
    12170, 12167, 12168, 12169, 12171, 6707, X, X, 12612, 12611, X, 7119, X,
    7118, 19297, X, 18317, 18494, 10854, 10942, X, 6363, 6070, 2380, 19311,
    6712, 19312, 19314, X, 5554, 5617, 4549, 15156, 15162, 8942, 15163, 15160,
    8943, 15157, 15155, 15161, 9311, 15751, 15159, 9313, 15752, 9312, 15748,
    9309, 9307, 8938, X, X, 16373, 16371, 16372, 15746, 16921, 9969, 16920,
    17369, 17370, 16374, 17740, X, 5553, 5727, 5871, 11425, 5870, X, 6357,
    8484, 19300, 5616, 5728, 6709, 8031, 10941, 11361, X, 11362, 19251, 11426,
    X, 1293, 6068, 11571, 11569, 6069, 11568, 11570, 11572, X, 6067, 6710, X,
    12174, 12176, 12173, 12177, 6711, 7122, 12613, X, 12615, 7120, 12616, 7121,
    12614, X, 10944, 6074, 19328, 6073, 6715, X, 12619, X, 7581, 7853, 7582,
    7580, 8037, X, 15166, 14478, X, X, 15165, 15164, X, 8945, X, 9316, 15754,
    9681, 16380, 9970, 3226, 10727, 18644, 10943, 1674, X, X, 11827, X, 12180,
    7579, 13805, 8488, X, X, 3669, 10226, X, X, 6794, 12262, 12254, 6787,
    12274, 12266, X, 6781, 12280, 12253, 6777, 12271, 12261, 6782, 6792, 19498,
    12268, 12258, 6785, 12256, 6778, 12251, 6788, 12264, 12245, 12247, X, X, X,
    2259, 6451, 6443, 6461, 6445, 11897, 6456, 11892, 6446, 11907, 11908,
    11900, 11893, 6459, 11905, 6454, 6452, 12241, X, 12677, 12678, 7177, 7178,
    1965, 7179, 13265, 1745, X, 7668, X, 8103, 4059, 8102, 15798, 9367, 15800,
    19167, 9366, 15797, 4332, 15801, 9712, 9709, 16417, 16416, X, 16415, 16410,
    4132, 8092, 13883, 13886, 19438, 8093, X, 8094, 8099, 14545, 13884, 8097,
    13881, 13879, 2095, 8098, X, 14585, 14587, 8552, 8544, 4044, 13274, 14558,
    14576, 14559, 8541, 8557, 14583, 8555, 8551, 14548, 19476, 19475, 19769,
    19667, 13890, 8109, 13930, 13906, 13908, 1975, 13921, 13920, 13888, 8120,
    8122, 13896, 7679, 7676, 13281, 7189, 13910, 7673, 2959, X, X, 3595, X, X,
    X, 19635, X, X, 15289, 9003, 9001, 9019, 19411, 3615, 15287, 15284, 15285,
    X, 15309, X, 15314, 15312, 15297, 15851, X, 15304, 19574, X, X, X, X, X, X,
    X, X, X, 15283, 15861, 9401, X, 15869, 15293, 19577, X, 15865, 15888, 9397,
    3252, 9400, 15890, 9389, 15879, 15853, 15885, 9743, 9733, 16485, 16465,
    9735, 16477, 9742, 9737, 16475, 16971, 16481, 16487, 16480, 16463, 16478,
    16489, 9739, 9736, 9731, 9734, 16471, X, 15855, 16466, 16469, 16486, 16474,
    16464, 16970, 16488, 16468, 16482, 10022, 10009, 16980, X, 16972, X, 2439,
    17419, 19565, X, 10254, 17416, 17418, X, 10252, 17414, 10561, 18087, 10562,
    18095, 18086, 18083, X, 18085, 18089, 18092, 18091, 18094, 18082, X, 10560,
    18090, 5910, 11462, X, X, 11648, 2474, 6154, 1734, 6157, 19139, 11649, X,
    6155, 6156, 19595, 2035, 3798, X, X, X, 3231, 12772, 12773, 12774, 7238, X,
    7234, 12763, 19598, 12771, 12776, 7239, 13367, X, 13371, X, 13360, 2832,
    13365, X, X, 7735, 7736, 13370, 13358, 13354, 13372, X, 12811, 7758, X, X,
    8199, 8200, X, 5760, 5761, 11467, 6165, 6164, 6852, 12365, 14047, 4960,
    4880, 4953, X, 12809, 12810, 7755, 7756, 4975, X, X, 14046, X, 14697,
    14696, 14695, 17428, 17430, 17434, 17795, X, 17793, 1037, X, 19694, X,
    10427, 17792, 3025, X, X, 10565, 16521, 16525, X, 9759, 19360, 17001,
    10038, 10263, 10039, 10036, 16998, 16996, X, 16999, X, 17002, 9421, 15925,
    19685, 9419, X, 15927, 15924, 15921, 15928, 15922, 15923, 9418, 2830, 2109,
    X, X, 7771, 13414, 7770, X, 4806, X, X, 1770, 14060, 7772, 8215, 14718,
    8628, 8629, 19722, X, 14059, 8213, X, 14058, 8212, X, X, 14716, 9430,
    15946, 15943, 15944, 15945, X, 18340, 3766, 3764, 19759, 18517, 2134, X,
    18766, 18835, 5774, 1688, 19774, 11668, 6531, 11997, 7292, 13441, 4532,
    13439, 13435, 7782, X, 13436, 7783, 13437, 13438, 13440, X, 7784, X, X,
    17447, 3238, 17800, 19445, X, 10433, X, 17798, 17799, 3752, 18107, 18110,
    18108, 18109, 12386, 12383, 12384, 12391, 6880, X, X, X, 3754, X, X, X,
    3756, 7282, 3078, 7288, 13434, 3760, 13427, 4873, 3426, X, X, X, X, X, X,
    X, 14075, 8218, 14083, X, 8250, 8252, 14112, X, X, 8251, 14115, 8245,
    14123, 14116, 14120, X, 14118, 8248, 14111, 7319, 12892, 12898, 12896,
    7318, 7320, 12895, 7313, 12894, 7324, 7321, 7325, 7322, 12891, 12890,
    12897, 12411, 12412, X, 2092, 12883, 12889, 4744, X, 12887, 7311, 12885, X,
    12886, 12888, 3131, X, 10109, 5937, X, 13526, 14157, 3845, 10834, 11471,
    3778, 1310, 2206, 11472, 11474, 5938, 11475, 6570, 6564, X, 6557, 12024,
    12018, 12031, 6572, 6568, 6563, 12023, 7360, 12021, 6561, 6571, 1837,
    12464, 6938, 12459, 12469, 12456, 12460, 12463, 4526, 1810, 12448, 12468,
    12462, 19289, 4102, 12447, 3848, 7366, 12929, 7362, 12953, 7363, X, 12931,
    3850, X, X, X, X, X, X, X, X, 3141, X, X, X, X, X, X, X, 3994, X, X, X, X,
    X, X, X, X, X, 4269, X, X, X, X, X, X, 5390, 5391, 5392, 5393, 5394, 5395,
    5396, 5397, 5398, 5399, 5400, 3106, X, 1396, X, X, X, X, 4635, 1526, X, X,
    X, X, X, X, X, 3429, X, X, X, X, X, X, X, X, 2876, X, X, 2611, X, X, X, X,
    1461, X, X, X, X, X, X, X, X, X, X, X, 1500, X, X, X, X, X, 3679, X, X, X,
    X, X, X, X, X, X, X, 3469, X, X, X, X, X, 4480, 5004, 4147, X, X, X, X, X,
    X, X, X, 1038, 1054, 1058, 1062, 1067, X, X, X, X, 1437, 1635, 1639, X, X,
    X, X, X, 4054, X, X, X, 3537, 2755, 2653, X, X, X, X, X, X, X, X, X, X,
    4946, X, X, X, X, X, 2478, X, X, X, X, X, X, X, X, X, X, 19057, 2978, 2415,
    X, X, X, X, 974, X, X, X, X, X, X, X, X, X, X, X, 19134, 19094, 3567, 3291,
    4247, 3067, 19520, 3705, 3050, X, X, X, X, X, X, X, 4184, X, X, X, 3279,
    19740, 3057, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3652, X, 1003, X, X,
    X, X, X, X, X, 2116, X, X, X, X, X, X, 11271, X, X, X, X, X, X, 11272,
    11273, X, X, 4178, X, X, X, X, X, X, X, X, X, X, X, X, 3984, 2921, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 1410, 19313, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 4572, 1923, X, X, X, X, X, X, X, X, X, X, X, X, 19290, X,
    X, 19296, X, 2961, X, X, X, X, X, X, X, X, X, X, X, X, 4424, X, X, X, 2568,
    X, X, X, X, X, X, X, X, X, X, X, X, 3236, X, X, X, 2396, X, X, X, X, X, X,
    X, X, X, X, X, X, 2055, X, X, X, 4667, 3180, X, X, X, X, X, X, X, X, X, X,
    X, 2927, 2678, 3424, 4210, X, 3185, 2183, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 19457, X, X, 1480, X, X, X, X, X, X, X, X, X, X, X, X, X, 4082, X, X,
    2857, X, X, X, X, X, X, X, X, X, X, X, X, X, 4040, X, X, 2266, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 3895, X, X, 7958, 4784, 7959, 7960, X, 8431,
    14388, 1385, 14387, 14389, 14390, 8432, X, 8430, 5000, 11507, X, X, 5982,
    5981, 19076, 1324, 5985, 5983, 5984, X, X, X, 6262, X, 5809, X, X, 1274,
    5978, 6253, 6252, 6254, 3009, X, X, 7031, X, X, X, 2758, 12531, 12532,
    7037, 19552, 12533, 19061, 12530, 7038, 7036, 7035, 12534, 19062, 5811,
    11394, 19058, 19067, 3965, 19004, 5979, 5980, 19059, 11504, X, X, 11726,
    6255, 11727, X, 7014, 7013, 12508, 7017, 13058, 7008, 12519, 7023, 7022,
    7012, 12511, 12520, X, 12505, 7011, 13043, X, 13051, 13068, 7469, 7468,
    7465, 7470, X, X, 7456, X, X, 7457, X, X, 1785, X, X, 6361, 6362, 6359, X,
    1786, 6358, 12175, 6360, X, X, X, 7570, 13194, X, 7569, 7571, 7568, X, X,
    X, X, 8028, 13193, X, 5729, 11427, X, 6071, 11573, X, 12178, 6713, X, 8944,
    5555, 2859, 19317, 2860, 5872, 9315, 15753, 9310, 9314, X, 16379, 16377,
    16376, 16378, 16375, X, X, 10400, X, 18061, 18062, 12172, 13195, 13198,
    13199, 13196, 7575, 7574, 7572, 7573, 13197, X, X, X, 1926, 7576, X, 4130,
    15755, X, X, 9319, 15167, 9318, X, 8947, 4884, 16923, 16381, 9971, 16922,
    17741, 7588, 7587, X, X, 19030, 13807, 13806, 19334, 8040, 8038, 8039,
    13808, 8489, 14480, 8490, 14479, 7126, 7125, 7124, X, X, X, 13203, 7583,
    7586, 7584, X, 13202, 7589, X, 7585, 13204, 8946, 9317, 19331, 11316,
    11429, X, 11576, 6075, 11575, 6076, X, 19074, 6370, 11830, 11829, 6369,
    6367, 6368, 11828, 1928, X, 6717, 12181, 6720, 6716, 6722, 6718, 6719,
    6721, X, X, X, 19473, 7681, 3364, 13913, 13935, 13924, 8123, 19751, 8118,
    13907, 8119, 13923, X, 12710, 7691, 13305, 12711, 19505, 13304, 13306,
    13307, 13936, 8128, 13937, 13939, 8129, 8127, 13938, 18075, 18079, X,
    18074, X, X, 1994, X, 18323, 18078, 10652, 10650, 18321, X, X, X, 12787,
    12784, X, 12786, 7246, 7245, 7243, 12783, 12788, 7242, 7244, 12785, 13384,
    6515, 11969, 11965, X, 11966, X, 11960, 6514, 11962, 6513, 11967, X, 11964,
    X, X, 12342, 11372, X, 4908, X, 11464, 11465, X, X, X, X, 11656, X, X,
    11652, X, 11651, 6511, 11655, 6162, 11653, 6161, 11657, 11654, X, X, 11963,
    12338, 11961, 11968, 3693, 6512, X, 13418, 13419, 13421, 13420, 13425,
    7776, 7773, 7777, 13415, 7778, 13424, 7775, 13422, 7774, X, 9455, 1651, X,
    9457, 15981, X, 15973, 2082, 15979, X, X, X, X, 15975, X, 17839, 3183,
    17840, 17838, 3184, 10586, X, 18139, 18140, X, 18532, 18667, 18772, 5936,
    6184, 12012, 12026, 12032, 6569, 12029, 6566, 3844, 12019, 12025, 12027,
    2194, 12014, 6565, 6560, 12020, 6567, 12467, 12458, 2207, 6929, 12466,
    6933, 6931, 6926, 12450, X, 12465, 12454, 12457, 12470, 19010, 6946, 7375,
    12933, 12937, 7378, 12927, 12951, X, 12950, 12958, 7367, 7364, 12956,
    12952, 12943, 12938, 7370, 13554, X, X, X, X, X, X, X, X, 19679, X, X, X,
    7840, 4810, 14174, 3403, 2080, X, 14161, 19364, X, 3673, X, X, 14859, X,
    14881, 8656, 14864, 19555, 14862, 3171, X, 8703, X, 1015, X, 14839, X,
    3857, X, X, X, X, 14835, 14873, 14834, 15477, 9140, 15496, 9137, 15495, X,
    15489, 15494, X, X, 4976, 15497, X, X, 2243, X, 18544, 10745, 18681, 18680,
    X, 18679, 4268, X, 18848, 18849, 18851, 18850, X, 11477, 5943, 14916,
    14915, 14917, 8746, 14914, 14913, 14919, 2308, 15552, 15550, X, 15551,
    16127, 16125, X, X, 13525, 13522, 13524, 7830, 7832, 7831, 13521, 7833,
    13523, X, 14154, 14155, 1352, 14156, 16023, 16025, 16022, 16021, 3842,
    16632, 16633, 16634, 9816, 9817, 17099, 17098, 17100, X, 17492, 17491,
    11675, 11679, 6185, 11680, 12445, X, X, X, 12016, 6559, 12015, 12017, X,
    6558, 12022, 6562, 2199, 6942, 6936, 6944, 6941, 12452, 12455, 6937, 3847,
    12446, X, 6930, 6940, X, 6943, 6945, 12946, X, 12936, X, 12945, 12930,
    12934, 12957, 7377, 12949, 12940, 7361, 12955, 12926, X, 12948, 13527,
    2245, 7842, 7844, 13540, 13537, 7839, 13553, 7836, 13538, 13560, 13546,
    2076, 13545, 7835, X, 9838, 16697, 16699, 3880, 9836, 16691, 16695, X,
    16698, 9834, 9837, 16701, 16693, 16694, 16700, 10467, 17880, 17876, 18159,
    10597, 3208, 18160, X, X, 18378, 10672, 18380, 10673, 18377, 18379, 10746,
    16126, 16703, 17173, 17174, 10317, X, 17888, 18162, 10599, X, 18381, 18547,
    10747, X, 18682, 18852, 8323, 14257, 14255, X, 8321, 8317, 8328, 14251,
    14252, 14249, X, 8322, X, X, 8318, X, 9217, X, 9213, 15603, 15616, 9211,
    15610, 9210, 15624, 15607, 15600, 9214, 15629, X, X, 6189, 12480, 6955,
    13604, 13602, X, X, 13603, 14244, 14245, 14918, 14243, X, 14912, 8316,
    14923, 8760, 8755, X, X, 8750, 4865, 8766, 8751, X, 8747, 8762, 8759, 8761,
    X, 3922, 9603, 9598, 16237, 16234, 16210, 9593, X, 2413, 3307, 9592, 9599,
    X, 3415, 3924, 16208, 9597, 16220, 16206, 16207, 9591, 16236, 9601, 16223,
    16228, 16222, 16782, 16218, 16226, 16224, 16211, 16205, 16232, 9600, 16233,
    2366, 16227, X, 16216, 16214, 16209, X, 18998, X, 16217, 16230, 16213,
    16229, 16235, X, 3925, 9596, 3481, 16225, 16231, 16221, 16215, 9594, 3926,
    2635, X, 15613, 16219, 9602, 16212, 2980, 3927, 3928, X, 3322, 16788, 9883,
    16787, 16784, 16803, 9887, 3929, 16800, 16792, 16802, 16777, 16790, 2372,
    9889, X, 16769, 3076, 16767, 16801, X, 16799, 16798, 16781, 16780, 16770,
    9891, X, 16776, 16786, 16797, 9894, 16804, X, 10182, 9896, 9890, 16774, X,
    16783, 16766, 16768, 9881, 9893, 9886, 16775, 16791, 16785, 9892, 16765,
    10177, 16793, 16796, 9888, 2419, 16779, 9895, 9885, 4312, 3508, X, 9884,
    16789, 16795, 9882, X, 16772, 16794, X, X, 16773, X, X, X, 17688, 18007,
    18013, 10529, 18008, X, 18011, 18015, 10530, 18010, 3979, 18002, X, 2140,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19396, X, 4149, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4129, X, 5005, X, X, X, 3763, X, X, X, X, X, X, X,
    X, X, 4208, 1582, 19521, 4205, 19144, X, X, X, X, X, X, X, 4291, X, X, X,
    X, 1633, X, X, X, X, X, X, X, X, X, X, X, 19646, X, X, X, X, 2634, 3330,
    2807, 2855, 2165, 3453, 19483, 3264, X, X, X, X, 3276, X, X, X, X, X, X, X,
    X, X, X, X, 1676, X, X, X, X, X, 14892, 14898, 14888, 14894, 8723, 14890,
    8729, X, X, 8728, X, 3900, 10483, 17915, 10488, 4859, 10485, 4849, 17914,
    X, 10487, 17918, 10482, X, 1441, X, 1668, 6597, X, X, 1765, 8844, 2479,
    15635, X, 16249, 9908, 2477, 3301, 6598, 2482, 7934, 8396, 14353, 14355,
    8398, 8397, 8399, 8400, 14354, 8838, 8839, 8837, 9227, 8836, 15030, X,
    1106, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19029, 2714, 5258, 5259,
    5260, 5261, 5262, 5263, 5264, 5265, 5266, 5267, 5031, 5030, 5139, 5141,
    5140, 5032, 11210, 11212, 1866, 1892, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 1450, X, X, 1169, X, X, X, X, X, X, X, X, 11303, X, X, X, X, X, 1935, X,
    X, 7112, 19278, 7111, X, 12604, 7108, 12606, 19279, 12146, 4734, 6704,
    12158, 12159, 1859, 12157, 12149, 12147, 6703, 12153, 12151, X, X, 12152,
    12164, 7113, 12607, X, X, 7116, 1735, 7114, 12608, 12165, 12610, X, 7110,
    994, 7109, X, 12605, 12609, 7115, X, X, X, X, 7555, 7554, X, X, X, 13178,
    13182, 13184, 7556, 13187, 19283, 7560, 13189, X, 7562, 1954, 7558, 7566,
    19284, 7563, 13180, 7557, X, 13179, 13177, 13191, 13181, X, 7559, 13190,
    7564, 13186, 13185, 7565, 13183, 7561, X, X, 4292, X, 13192, 3667, 13188,
    13792, 13799, 13788, 8024, 13784, 13800, 13778, 13797, 13795, 13789, X,
    13798, 13791, 1916, 13783, 13801, 13781, 13794, 13779, X, 13802, 19285,
    8025, 1917, 13796, 14459, 13782, 8022, X, 13786, X, 5546, X, 11359, 11358,
    X, X, X, 1862, 5867, 11421, 11422, 11420, X, 11423, X, 6698, X, 12601,
    7104, 19268, X, 7550, 7549, 7548, 8019, 8020, 13776, 8933, 9680, 5543,
    8018, 13773, 8015, 8017, 13772, 19260, 14452, 19701, 14453, 14454, X, 987,
    X, X, 8924, 8932, 15134, 8926, 8930, 15135, 8931, 8927, 8928, 8925, 8929,
    9301, 13769, 9302, 9300, X, 9299, 16357, 9679, 16917, 16918, 19265, X,
    10398, 10550, X, 5542, X, 5865, X, X, X, X, 19207, 4329, 5611, 11356,
    19270, 19272, 11418, 5866, X, X, X, 6340, X, 1599, X, 2838, 14455, 4053, X,
    5544, 1673, 5612, 11419, X, X, 11553, X, 11554, X, 6056, X, X, X, 12596, X,
    13145, 7530, 13755, 13144, 13163, X, X, 7536, 2995, 13161, X, 9671, 16342,
    X, X, 9674, 16344, 9673, 16337, 16339, X, 2805, X, X, 9958, 16905, 19203,
    X, 10397, 18057, 10546, X, X, 18639, 18638, 10820, X, 5535, 5605, X, X,
    6035, 7528, X, 8912, X, 8913, 8911, X, 5537, X, 5606, 5608, 5607, 11331,
    5609, 5715, 11353, 17364, 18489, 18640, 5538, 5717, 4509, 5718, 11415,
    5853, 5856, X, 11413, 11411, 5855, 11414, 11416, 11547, X, 6038, 6046,
    3472, X, 6043, 11544, 11542, 6042, 3237, X, X, 6037, 6040, 4166, 3535,
    11790, 11783, 6328, 11794, 11779, 11786, 4762, 2812, 6318, 11780, 6316,
    11787, 11791, 6315, 1879, 6322, 6320, 6329, 6325, 6317, X, 11789, X, 6681,
    19227, 6688, 12136, 6680, 12128, 12124, X, 8459, 8469, 14415, 8463, 14422,
    X, 8461, 8460, 14425, 8462, 14427, 19200, 14424, 8458, 3893, 7999, 8000,
    12571, 13732, 7997, 7525, 13734, 13721, 13737, 13736, 3832, 13740, X,
    14428, X, 13733, 13129, X, 3585, X, 13107, X, X, X, 1044, 13722, X, 13731,
    13730, 8002, 13723, X, 10819, X, 18750, 18823, X, 4338, 11313, X, X, 5713,
    5712, X, 5840, 5839, 11405, 9951, X, 2701, 16893, X, 10221, X, 17360,
    17358, 17363, 17361, X, 17359, 17362, 2699, 2607, 16326, 2283, 9669, 16330,
    9661, 9665, 16329, X, 9664, 9660, 9663, 9658, 9668, 16331, 16327, 9667,
    9283, X, 9273, 15702, 9275, 15694, 9281, 19169, 15706, 9272, 15708, 9271,
    X, 15703, 15705, 9274, 8898, 4795, 15082, 15087, 8889, 15080, 8895, 8887,
    X, X, X, 8886, 15085, 15090, 4506, 8896, 4543, 4538, 14410, X, X, 3901,
    8899, 8894, X, 15093, 15089, 1661, 15083, 8888, 8884, 15092, 14398, 4458,
    14413, 14391, 14400, 8452, 8453, 8445, 14409, 8455, 14396, 14395, 14393,
    14411, 8443, 14405, 7968, 13708, 7974, 7980, 8255, X, 19160, 7978, 13705,
    7991, 7971, 7979, 13713, 14404, 13718, 13706, 13091, 7500, 13095, 7511,
    13085, 13090, 13089, 7052, 7506, 13098, X, 13101, 13082, X, 7984, 1408,
    6645, 6656, 6653, 12089, 6657, 12095, 12096, 6652, 6658, 6648, X, 2698,
    1587, 2795, 6647, 12088, 12098, 6291, 12102, 6278, 11750, 6279, 6292, 6285,
    6281, X, 11746, 6284, 6289, 6298, 11747, 11740, 6014, 19513, X, 1394,
    11528, 11522, 5997, 5999, 11527, 6006, 11517, 6018, 6020, 5994, 6011,
    19158, 19133, 16324, 10220, 5533, 5694, 5709, 5704, X, 5699, 5698, 5705,
    5703, 5696, 5710, 5697, 5693, 19118, X, 4365, X, 13695, 7966, 19303, 13696,
    19306, 1389, 4925, 19119, 15078, 8883, 19120, X, 6270, 6267, 6269, 6268, X,
    X, 6640, X, X, 7965, X, 5513, 1699, 5600, 1603, 7484, 13694, 13693, X, X,
    5511, 5595, 5683, X, 7486, 11307, X, 11348, 5684, X, 11400, 19252, 4759,
    7480, 13077, X, 7483, 13076, 7667, 7482, 7481, X, 7964, X, 7963, 7962,
    8433, 15073, 15074, 8881, 8880, 15412, X, X, 9263, 9264, 9265, 9267, 15687,
    15688, 9266, X, 4195, 6261, 11732, 11729, 11730, 4705, 11728, 6263, 6259,
    6258, X, 6260, 6257, 19077, X, X, X, 1405, X, 1414, 12545, 7066, 1406, X,
    13086, 19140, 7509, 13100, 7507, 7504, 12104, 6661, 2067, 6651, 1400, X,
    12094, 12091, 6649, 1401, 12084, 6662, 12099, 6654, 12101, 6665, 11755,
    11754, 6295, 11757, 11759, 11748, 11751, 11758, 6296, 4767, 4026, 11745,
    11749, 19143, X, 11753, 5827, 5831, 5837, 19138, 3438, X, 4534, X, 11523,
    11520, 4500, 6005, 11521, 5993, 5995, 6019, 2789, 1281, 4386, X, 6276, X,
    6275, 6277, 1282, 19130, 4774, 6643, X, X, X, 7048, 5821, 5822, 11512,
    5991, 19109, 5992, X, 6272, 6273, 6274, X, 6641, 12079, 4641, 19111, 7045,
    15077, 8882, 4938, 19095, 16323, X, X, 18053, 10934, 5596, X, 1279, 11736,
    12078, 7489, 7487, 9268, 15689, X, 9656, 16892, 9948, X, 17724, 10540,
    10933, 5530, 5592, 11326, X, 5593, 5594, 5679, 1277, X, 5817, 2768, X,
    11398, X, 1278, 5987, 5988, 5986, 5989, 11508, 11509, X, 6626, 6625, 12529,
    12528, 7476, 10931, 5587, 11325, X, 4571, X, 1275, X, 11725, X, 11344, X,
    5666, 5667, 5660, X, X, 11341, 11343, 4467, 1369, X, X, 3896, X, 3934, X,
    19686, X, X, X, X, X, X, X, X, X, X, X, X, X, 2500, X, X, 4872, X, 2583, X,
    3683, X, X, X, 1758, X, X, 1642, X, X, 11174, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 19690, 4423, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    4478, 19466, 19541, 2603, 2210, 3400, 2219, 19230, 3187, X, X, X, X, X, X,
    4300, X, 19556, 2924, X, X, X, X, X, X, X, X, 19764, 4469, 4996, X, 3305,
    19578, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19731, 3405, X, X, X,
    X, 4889, X, 4366, X, X, X, X, X, X, X, X, 3562, 12729, 7220, 7225, 19142,
    19544, X, 12738, 12744, 11940, 6811, 6806, 12300, 12292, 6825, 6817, 12311,
    6822, 6820, 12303, 6814, 12295, 6815, 6816, 12296, 12316, X, 12319, X,
    2998, 6809, 2003, 6821, 12291, 6823, 6807, 6827, 12317, 12293, 6824, 12747,
    12321, 12305, 12297, X, X, X, 12753, 6813, 12310, 12302, 12304, 6818, X,
    12307, 6812, 12294, 12306, 12309, 2001, 12312, 12301, 2822, 2002, 12315,
    12318, 12320, 12298, 6805, 6810, 12726, 6826, 12313, 7212, 6489, 11931,
    6470, X, 6819, X, X, X, 11944, X, X, X, X, X, 1794, 6499, 6492, 6478, 6468,
    X, 6473, X, 11923, 6469, 11946, 4864, 11917, 11916, 11930, 11918, 6496,
    11925, 11947, 11932, 6481, 11921, 6480, 6498, 6487, X, 11919, 12299, 6493,
    6497, 11933, 11938, 3662, 11939, 6485, 11926, 11928, 6483, 6488, 11929,
    11942, X, 6804, 6494, 19098, 6472, 11941, 4869, 11945, 11943, 6471, 4637,
    6474, 11934, X, 11920, 11924, 6482, 6484, 11927, 6491, 6477, 6475, 6476,
    6490, 6137, X, 6142, 11915, 6151, 11641, 6141, X, 6152, 6129, 11638, 6134,
    11642, 11936, X, 2409, 6138, 11635, 6145, 11644, 6147, 1998, 6149, X,
    11629, 19524, 6136, 11646, X, 6143, 6146, 2170, 5904, X, 11455, X, 11459,
    5905, X, 5900, 3248, 5901, 19522, 5907, 11456, 5899, 6128, 5902, 13948,
    4820, X, 8999, 5641, 1680, 11367, 19518, 5749, 4315, 1681, 11370, X, 1534,
    5752, 11369, 5748, 5747, X, 6466, 11337, 11366, 5898, X, 11453, 11627,
    11628, 6467, 2446, 11914, X, 6803, 13945, X, 13946, 13947, X, X, X, 14602,
    14603, 14601, 4843, 14599, 14600, 8563, 15272, 15849, 11626, X, 6801, 8562,
    5638, X, 12286, 6802, 12287, X, 10006, 5639, 19517, X, 11913, X, 10255, X,
    X, 17412, 10418, 17772, 17778, 10419, 17769, 10416, 10413, 17780, 10417,
    3436, 10414, 2032, 10732, 18506, X, 2033, 18503, 18504, 18505, 10733, X,
    18657, 18656, 2350, 18760, 10822, 18758, 3816, 12327, X, 2649, 6836, 3502,
    3658, 19596, X, 12330, X, 6828, 6831, 6833, 6835, 6832, 13359, 3003, X,
    13361, 13357, 3854, 13369, 13355, 13368, 7734, 13353, 14000, 13363, 7737,
    3589, 13364, 8175, 14002, 14006, 3659, 3445, 2112, 8177, X, X, X, 14009,
    3000, X, X, 2044, X, 3573, X, 4965, 7254, 3037, X, X, X, 7258, 7257, 12812,
    7256, 7255, X, 12813, 5762, 5763, 5764, 5765, 4542, 1301, X, 6166, 6167,
    11664, 11663, 4298, X, 6521, 11982, 11980, 15344, X, 15345, 15346, 9045,
    4952, X, 15932, 15931, X, X, 16526, 9764, 9765, 19696, 17006, 2955, X, X,
    3720, 10658, 18512, 10657, 18514, 18511, 18513, 10786, 18763, 5756, 11978,
    12807, 12808, 10037, 17000, 16995, X, 3484, 17429, 17432, 17794, 17427,
    1802, 18102, 17433, X, 10426, 17431, 10264, 16997, X, 16523, X, 16522,
    16524, X, 16994, 9760, 2782, 16520, 3069, 9758, 999, 9762, 9761, 9043,
    15339, 15341, 15338, 19682, 15340, 19678, X, X, 2780, 3012, X, 15929,
    15926, 9420, 16519, 19674, 998, 15337, 9041, 9040, 19243, X, 15342, 3041,
    9417, 9042, 3293, 19680, 9044, 15343, 8607, 14688, 14684, 14683, 19559,
    14693, 8609, 2784, 14685, X, 8614, 8608, 8615, 8616, 19712, 8611, 8610,
    14686, 8612, 14690, 2823, 14680, 3277, 14691, 19676, 3500, 19656, 14681,
    14682, 1028, 14692, 14689, 14687, 14033, 14039, 14045, 8189, 8194, 8192,
    8193, 3028, 3068, 19669, 8187, X, 3026, X, X, 8613, 14044, 14037, 8190,
    14041, 14040, 8191, 8197, X, 8198, 14043, 8188, 14034, 14032, 14038, 14031,
    8195, 13395, 13392, 1753, 7750, 13391, 7748, 7751, 13394, 13402, 7249,
    7749, 13400, 13399, 7753, X, X, 6526, 6868, 12371, 6869, 6867, X, 6866,
    12823, 7271, X, 19730, 7272, 7273, X, 3098, X, X, 3093, X, 13445, 13446,
    13444, X, 13443, 7785, X, X, X, X, 19093, X, X, X, X, X, X, X, X, X, X, X,
    1889, X, X, X, X, 1302, X, X, X, X, X, X, X, 1303, X, X, X, 13505, X, X,
    7821, 13504, 13506, X, 7820, X, X, X, X, 14136, 14132, 14133, 14131, 2139,
    8686, 14803, 14802, 14804, 8685, 8684, X, X, 16001, 16003, 3804, 9482,
    16002, 16614, 9806, 17484, 3805, 17483, 10451, 17832, 10453, 10452, 18133,
    18352, 10664, 5919, 12419, 6906, 12911, 7330, 12910, 12909, X, 7329, X,
    13498, X, 13500, 13493, 13494, 7816, 13495, 7817, 13499, 13496, 13497,
    7818, X, 8256, 8257, X, 14134, X, X, X, 14805, 14806, 3154, 15448, 9109,
    9107, 9108, 15445, 15446, X, 15447, 16008, 3692, 16009, 9483, 16006, 16005,
    16007, 16004, 9809, 16615, 9807, 9808, 17088, 10091, 17087, 17340, X,
    17485, 17486, 10295, 2146, 10296, 10092, 17833, 17834, 18134, 10584, 5920,
    1695, 5921, 6907, 2148, 7331, 12420, 2149, X, X, 8258, 5922, 6909, 12421,
    12422, 6908, 6910, 5923, X, 12423, 7333, 12912, 7335, 7332, 7334, X, 13503,
    7819, 2150, 13502, 13501, 3808, 14807, X, X, 15449, 3809, 9484, X, 2151,
    16617, 16616, X, 17089, X, 3811, 2152, 18353, 3812, X, 5924, 11669, 12004,
    6911, 12424, X, 12914, X, 2155, 2156, 7336, 12913, 7337, 14137, 14135,
    8259, X, 3813, X, 8687, X, 8688, X, 9111, 4959, 15451, 15450, 9110, X,
    16648, 3864, 16639, 16663, 16657, 16635, 17119, 16641, 9819, 2226, 16652,
    X, 16662, 9827, 1818, 17134, 10114, X, 996, 10115, 17105, 17121, 1811,
    17133, 17124, 17111, 10117, 10113, 17125, 17112, 17135, 17495, 2263, 17497,
    17496, 17502, 17507, 17494, 17501, 17506, 10306, X, 17504, X, 10304, 17505,
    10302, 17857, 17842, 17850, X, X, X, 18147, 10461, 17851, 10588, 10590,
    10587, 3398, 18152, 18144, 18142, 18365, 18364, 18141, 18359, 17511, 18368,
    18357, 18362, 2270, 18366, 18356, X, 18536, 10666, 18363, 4883, 12033,
    6574, 3870, 12474, 12472, X, X, 12471, X, 6949, 6951, 6950, 12473, X, 2275,
    X, 10147, 17567, 17902, X, 18687, 6192, 12998, 7405, 7883, 14935, 14934,
    9542, 16146, 9543, 17192, 14266, X, 8774, 8333, 8338, 14268, 8340, 8339,
    8342, 14267, 14264, 8336, 8332, 8334, 14265, 8341, 6196, X, 12483, 6962,
    6961, X, 13003, 2354, 13004, 13617, 2764, 13616, X, 13615, X, X, 10313,
    17524, 17536, 4900, 17865, 17866, X, 10465, 17863, 10462, 17871, X, 10466,
    17873, 18154, 18155, X, 18157, 10595, 10596, 18158, 18156, 4844, 18153, X,
    18371, 18374, 18370, X, 10671, 18675, 10797, 18676, 18678, X, 18776, 10828,
    18775, 18774, 10829, X, 10859, 18886, 18909, 18908, 18910, 2868, 9833,
    10830, 5942, 1700, 4299, X, 12477, 6576, 12479, 12478, 6953, X, 12985,
    3203, 12992, 12989, 7390, 7391, 12993, 19763, X, X, 3205, 7866, 13582, X,
    7871, 13598, 7870, 13600, 1732, 4885, 13589, 13585, X, 13596, X, X, 13592,
    13584, X, 13586, 7867, 13597, X, 3878, X, 6977, X, 6978, 2397, 12492, X,
    12494, 12496, X, 6975, 12495, X, X, 6976, X, 18919, 3970, 1714, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 2683, X, X, 2268, X, X, X, X, X, X, X, X, X,
    3198, X, X, X, 1132, 1130, X, X, X, 5135, X, X, X, X, X, X, X, X, 4643, X,
    X, X, X, X, X, X, 1895, X, X, X, X, X, X, X, X, X, 4198, X, X, X, X, X, X,
    3039, X, X, X, X, 4454, X, X, X, X, 19319, X, X, X, X, X, X, X, X, X, X, X,
    1113, 1110, 11205, 1107, X, X, 4023, X, X, X, X, X, X, X, X, X, X, 4024, X,
    X, 19097, X, X, X, X, X, X, X, X, 3521, X, X, X, X, 19262, X, X, X, X, X,
    X, X, X, X, X, X, 2579, X, X, X, X, 19432, 19433, X, X, X, X, X, X, X, X,
    X, X, 1585, X, X, 1542, X, X, 1583, X, X, X, X, X, X, X, X, X, X, X, X, X,
    2267, X, X, 19549, X, X, X, X, 2241, X, X, X, X, X, X, X, X, 1305, X, X, X,
    X, X, X, X, 1306, 17480, 10291, 17477, 17475, X, 3665, X, 2104, 17827,
    10447, 10448, 10444, 1809, 10445, 2126, 17823, 16596, 16592, 16602, 9800,
    16609, 16608, X, 2130, X, 17076, 17072, 10079, X, 17066, 10073, 10089,
    9464, 15991, X, 9472, 2117, 2121, 15994, 15989, 9471, 9475, 15988, X, 9469,
    X, 15998, 9466, 9088, 9096, 9095, 2113, 9094, 9100, X, 15421, 9101, 15435,
    9097, 9087, 15437, 9090, 9091, 9099, 8253, 7801, 8249, 8254, X, X, X, X, X,
    8675, 14787, 14789, 14791, 14795, X, 14785, 7316, 7312, 7317, X, X, 4670,
    X, X, 13487, 13480, X, 8247, 13479, X, 7802, 7809, 16589, 16590, 16586,
    3688, 16587, 9794, 9795, 16588, X, 10071, 4947, X, 10067, 10072, 10068,
    10070, 10661, 4910, X, 18343, 18342, X, 4710, 18521, X, 18523, 18525,
    18524, 18522, 3122, X, 10741, 17061, 17062, 17046, 17053, 17051, X, X,
    10063, 17058, 16578, 2087, 17049, 4746, 17059, 10062, 17048, 9461, 9073,
    2074, 4735, 15414, X, X, X, X, X, X, X, 15976, 9454, 1052, 15978, 8668,
    14774, 3784, 14777, 14765, 14770, 14764, 8670, X, 14768, X, X, 3785, 14766,
    8669, 2075, 14103, X, 4275, 4358, 14099, 14105, 8233, 13451, 14100, 8231,
    14097, 8238, 14101, 8237, 14102, 8239, 12405, 12406, X, X, 12874, 12876,
    7309, X, 12878, 12881, 12879, 2069, 3159, X, 12880, 12877, 12873, 7310,
    12882, 12875, 4841, X, X, X, 13458, 7793, 13467, 7790, X, 13460, 7794,
    4732, 7788, X, 13455, 13468, 13456, 13453, 7792, 3155, 7789, 2071, 13459,
    13462, 7791, 13463, 7795, 13464, 13454, 13461, 13465, 13457, 13452, 13450,
    X, X, 13466, 3810, X, 14098, X, X, X, X, 3549, X, X, X, X, X, X, X, X, X,
    X, X, 3251, X, X, X, X, 13642, 12491, 13018, 13027, 13025, 13020, 13021,
    13026, 13028, 7428, X, 13023, 14312, 14311, 8364, 14315, 4279, 14314,
    14303, 14313, 14308, 8366, X, 14987, X, 14982, 14988, 14983, 9583, 9586,
    16195, 16757, 9879, 16758, 16759, X, 17211, 10171, 17595, 17596, X, X,
    17597, 17927, 14320, 14316, 14319, 8368, 14317, 8369, X, 2401, 14495, 8813,
    8812, X, 8811, X, 14989, 14990, 16761, 16762, 9880, 16760, X, X, X, X, X,
    17215, 17212, 17214, 10174, 17218, 10173, 17216, 17928, 10494, 18186,
    18187, 10612, 18185, 1605, 18184, X, 18398, 10684, 3262, 18692, 18785,
    18784, X, 17293, X, 17292, 19447, 10374, 17978, 17979, 10622, X, 3341,
    18920, 7449, 8414, 8413, 15045, 18422, 18230, 18231, 3181, 10619, X, 18421,
    2516, 2515, 18420, 2513, 18579, 18918, X, 1712, X, 4165, X, X, X, 4018, X,
    X, X, 3680, 3520, X, X, X, X, X, 4122, X, X, X, X, X, X, X, X, X, X, 4156,
    19117, 2765, X, X, X, 5008, X, 2529, X, X, X, X, X, X, X, X, X, X, 4150, X,
    X, X, X, X, 2753, 19586, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1518,
    19050, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1475, 1556, 1530, X, X,
    X, X, X, X, X, X, X, 4940, X, X, X, X, 4596, 3112, 2169, X, X, X, X, X, X,
    X, X, X, 19699, X, X, X, X, X, X, 3220, X, 1896, X, X, X, X, X, X, X, X,
    19324, X, 4580, X, X, X, X, X, 2541, X, X, X, X, X, X, X, X, 4441, X, 5268,
    5269, 5270, 5271, 5272, 5273, 5274, 5275, 5276, 5277, X, X, X, X, X, X,
    3095, 19658, 19105, X, X, X, X, X, X, X, 4240, X, X, X, X, X, X, X, X, 969,
    X, 4656, X, X, X, X, X, X, 3656, X, X, 3647, X, X, X, X, X, X, 4399, X, X,
    X, X, X, X, X, X, X, 19340, X, X, X, X, X, X, X, 4791, X, X, X, X, X, X, X,
    X, 19043, X, X, X, X, X, X, 4679, X, 4100, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 2875, X, 3471, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2184, X,
    2249, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5017, X, 2700, X, X, X,
    4251, X, X, X, X, X, X, X, X, X, X, 1878, X, X, X, X, X, X, 3501, 3016, X,
    4805, X, X, X, X, X, X, 4407, X, X, X, X, X, X, X, X, X, 4116, X, X, X, X,
    X, X, X, 2564, X, X, X, X, X, X, X, X, 4573, X, X, X, X, X, X, X, X, 2442,
    X, X, X, X, X, X, X, 4019, X, X, X, X, X, X, X, X, X, 2255, X, X, X, X, X,
    X, 1378, X, X, X, X, X, X, X, X, X, 3446, 2837, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 5159, 5115, 5114, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 2569, 991, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4597, 1478,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3007, 1624, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 2229, 19380, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19185, 2664, 19746, 3527, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3915, 19321, X, 1042, 3096, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    19089, 19471, 3296, 2537, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1346,
    X, 2567, X, X, X, X, X, X, X, X, X, X, X, 3390, X, X, 11141, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 5013, 4276, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 4250, 3467, X, X, 2154, X, X, X, X, X, X, X, X, X, X, X, X,
    3629, X, X, X, 4462, 3494, 2179, 3074, X, X, X, X, X, X, X, X, X, 19778,
    3701, 19103, X, X, 3218, X, X, 943, X, X, X, X, X, X, X, X, 4777, X, X,
    1344, X, 3031, 19165, X, X, 19572, X, X, 1868, X, X, X, 2142, X, X, X, 944,
    X, X, 3876, X, X, X, X, X, X, X, X, 2286, 1751, X, X, X, X, X, X, X, X,
    3960, X, X, X, X, X, X, 976, X, X, X, X, X, X, X, X, X, 1872, X, X, X, X,
    X, X, X, 4103, X, X, X, 3370, X, X, X, X, 4173, X, X, X, X, X, X, X, X, X,
    X, X, 1060, X, X, X, X, 19042, X, X, 2190, X, 19239, X, 3043, 2776, 3534,
    X, X, 2948, X, X, X, X, X, X, X, X, X, X, X, X, X, 19021, X, X, 1522, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 1553, X, X, 2893, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 3353, 2619, X, 11209, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3029, 1653, X, X, X, X, X, X, X, X, X, X, 1487, X, X, X, X, 6195, X, 7892,
    7891, 14943, 14944, X, 9182, 16729, 9556, 16730, 17200, 1511, 13622, 13619,
    3894, X, 14283, 8353, 14275, 14281, X, X, 8348, 8351, 14274, 8346, 14278,
    9560, 16167, 16172, 16174, 16171, 16164, 16166, 16176, 16173, 16168, 16177,
    16165, 16175, 9561, 9567, 9565, 17578, 17586, 17577, 10325, 10327, 17582,
    10326, 17583, 1482, 17588, 17916, X, 10486, 17913, X, 17917, 3902, X, 8787,
    X, X, X, 2364, X, X, 1815, 9568, X, 2434, 16744, X, X, 10316, X, X, X,
    17887, 17886, X, 18161, 10598, X, 2306, 10674, 18546, 18545, 14250, 8320,
    X, X, 14253, 14254, 8324, X, 14256, 4971, 14258, X, 14259, 14247, 14246,
    14260, 9536, X, 9532, X, 3887, X, 9539, X, 16130, 9540, 16142, 16135, 9525,
    16143, 16137, 9535, 9845, 9850, 9851, X, 10145, 17179, 17188, 17185, 17187,
    X, 10142, 17180, 2322, 17186, 10138, 17182, 17889, 17898, 17900, 17893,
    17895, 17897, 17894, 17901, 10473, 10479, 10475, X, 10472, 18165, 4180,
    10604, 1703, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1307, 17821, X,
    17825, 10450, 17826, 17819, 17818, 17822, 17820, 10446, 17824, 18129,
    10581, 10580, 18130, 4464, 17078, 10081, 10077, 17069, 10084, 10087, 17080,
    10076, 17071, 10085, 17082, 17079, 17067, 10080, 10074, 10088, 15997,
    15996, 9478, 15750, 9465, 2119, 15995, 15986, X, 9479, 15993, 9467, X,
    3803, 3526, X, 14196, X, 2222, 8298, 14193, 14183, 14204, 14178, 14860, X,
    14207, 8296, 14176, 14188, 8299, 14838, X, 14863, 14855, 14880, 14858,
    8719, 14875, 3762, 8710, 2236, 14861, 14869, 14842, 14868, X, 17166, 17169,
    4335, 10134, X, 17543, 3881, X, 17546, X, 17540, 17542, 3209, X, 17541,
    3739, 6954, 13601, 8313, X, 14910, 10315, 2301, 17885, 4963, 2302, 6188, X,
    X, X, 7873, 6190, X, 6957, 6958, 12481, X, X, 12482, 6956, X, 7399, X,
    7397, X, 7396, 7403, 8752, 8757, 8748, 8749, 14931, 14928, 14920, 14925, X,
    8763, 14932, 8764, 8754, X, 4891, 14922, 16138, X, 9534, 16141, 9528,
    16139, 16129, 9527, 16714, 9533, X, 9530, 1876, 9538, X, 16128, 10146,
    17178, 17183, 17190, 16710, 17184, 17177, 10139, 17176, 10140, 17191,
    10141, 17189, 10144, 17175, 2323, 18163, X, 4236, 18167, X, 18168, 10602,
    18169, 18166, 3309, 18164, 10605, 10601, 18170, X, 10603, 10322, 3888, X,
    X, 10887, 6193, 12037, 12999, X, X, 7884, X, 13611, 13612, X, 14261, 8337,
    8335, 8776, 8775, 8773, 8777, X, 8771, 8772, X, 8770, X, 14942, 4561, X,
    15563, 14270, 8345, 4826, X, 14269, 8344, X, X, X, 14271, 8343, X, 14946,
    14949, 14947, 14948, 14959, 8350, X, 14273, 4852, 14279, 14276, 14282,
    14272, 14280, 8349, 8352, 14277, 8347, X, 8779, 16159, 9566, 9562, 16160,
    16162, 16161, 16169, 16170, 4858, 9564, 3242, 9559, X, 4579, 16163, X,
    17955, 10354, 10512, X, 18790, X, X, 6596, 7936, 7935, X, X, X, X, 8401,
    11693, 6217, 6215, 3948, X, X, X, X, 4939, 12050, 12053, 6592, 12052,
    12051, X, 6591, 14346, 8383, 8385, 8384, 8380, X, 3275, 3274, 8832, 3272,
    X, 15025, 15023, X, 15024, 15022, 10802, X, 18693, 10801, 10803, 4253, X,
    2986, 18788, 18789, 10837, 18787, 2129, 18859, 18858, 18860, 18196, 18215,
    18206, 18189, 18193, 18195, 18205, 3936, 10614, 18198, X, 19316, X, 3938,
    X, X, 7882, 7876, X, 7877, X, 13606, X, 3884, 7874, 3271, 13607, 7879, X,
    X, 2188, 19489, X, X, 4346, X, X, X, X, X, X, X, X, 1312, 14162, 2221,
    14191, 14199, 14202, 8279, 14170, 14195, 14171, 14185, 8292, 14181, 8289,
    19071, 14182, 4294, 14841, 8706, 14857, 14877, 14853, 8714, 14876, 14851,
    8293, 14867, 14852, 14874, 8713, 8705, 3608, 14830, 9138, 15499, 2086,
    2247, 15482, X, 3088, 15460, 15490, 9130, 15475, 15485, 9133, 15478, 9131,
    15463, 16067, 14829, 16045, 16049, 16043, X, 16062, 16047, 3861, 16069,
    16040, 16038, 16050, 16060, 16055, 9504, 16642, 16645, 19084, 9823, 16647,
    16636, 16643, 16649, 9820, 9824, 9818, 2198, 19001, 16638, 16654, X, 15547,
    16122, 16124, 16123, 4106, 2303, 2305, X, 2304, 9839, X, 10137, 17170,
    17172, 17171, 13605, 7878, X, X, 8325, X, 8327, X, 3885, 14248, 8326, 8315,
    8319, 3223, 8765, 14924, 8756, 9166, X, 9164, 9168, 9170, 9161, 9175, 9171,
    2329, 9169, 15553, X, X, X, 2333, 16713, 9844, 16706, 9854, 16707, 16708,
    9855, 9852, 9531, 1861, 9842, 16720, 9856, X, 9849, 16718, 17892, 10471,
    17899, 4973, X, 18384, 10478, 17553, 17890, 10474, 17891, 17896, 2327,
    2328, 10476, 10477, 2331, X, 10832, 10831, 18778, 18779, 10833, X, 18853,
    18854, 10872, 2332, 10878, X, 18911, 18942, 16723, 16721, 16722, 9859,
    17198, 17197, X, 17571, 17570, 17569, 17905, 2337, 18912, 6194, 6959, 3234,
    17575, X, 17574, 2347, 17573, 10323, 17906, 17907, 10480, 17908, 10481,
    1334, 4875, 10607, X, 10606, 16155, 16157, X, 9558, X, 16731, 4979, 16732,
    10155, 2355, 17910, 17912, 17909, 17911, 18171, 18389, 14954, 14957, 14964,
    8782, 14966, X, X, X, X, X, 8783, X, 9185, 15570, 15576, 15568, 16736,
    16741, 9864, X, 9861, 16737, 1423, 17206, 10158, 10156, 10159, 10157,
    17205, 17202, 17201, 4853, 18559, 10751, 18558, 10752, 18556, 18555, 18560,
    18561, 18689, X, 18557, X, X, 18783, 18780, 18781, 10330, X, 17919, 2365,
    X, X, X, X, X, 18914, 6199, 6577, 6965, 6964, 3904, 7414, 13628, 13629,
    3905, X, 3906, 14290, 14288, 14292, 14293, 14299, X, 14295, 14297, 3907,
    14289, 14284, 15579, 15580, 9187, 9189, 9186, 9188, 16184, 16185, 16180,
    2367, 16181, 9570, 9575, 9569, 9576, 9571, 3245, X, 16748, 9870, 16751,
    16747, 4241, 16750, 9869, 16749, X, 9867, X, X, 10161, 10164, 17923, 17921,
    17920, 17924, 10489, 18178, 18176, 18177, 18179, 18175, 18180, 18393, 4766,
    18394, 18392, 10682, 4108, X, X, 9190, X, 2371, 9872, 1742, 9871, X, X, X,
    X, 10491, 10579, 10683, 4428, 6580, 12038, 12040, 6579, 12043, 12042,
    12044, X, X, 4932, X, X, X, X, X, 4093, X, X, X, 19292, X, X, X, X, X, X,
    2160, X, X, X, X, X, X, X, X, X, 4720, X, X, X, X, X, X, X, 19771, X, X, X,
    X, X, 4216, X, X, 1433, X, X, X, X, X, X, X, 4283, X, X, X, X, X, 2538, X,
    X, X, X, X, X, X, X, X, X, 19585, 19164, 4159, 2994, 19571, X, X, 19708, X,
    X, X, 4191, X, X, X, X, X, X, X, X, X, 3073, X, X, X, X, X, X, X, 5014, X,
    X, X, X, X, X, X, X, 4063, 2271, 19005, X, X, X, X, 2046, X, 1397, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 1134, 1165, 18966, 5250, 18986, 18968,
    18973, 18982, 18964, 18979, 18988, 18970, 5249, 18985, 18967, 5243, 5244,
    5246, 5065, 5066, 5186, X, 5061, 5062, X, X, X, X, X, X, X, 5095, 5096, X,
    11258, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4362, 19209, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 4370, 3533, X, X, X, X, X, 2414, X, X,
    X, X, 2982, 3042, X, 3509, X, 11152, 11153, 11154, 11155, 11156, 11157,
    11158, 11159, 11160, 11161, 11162, 11163, 11164, 11165, 11166, 11167, 5236,
    X, 5237, X, X, X, X, X, X, X, X, X, 5239, X, X, X, 5191, X, 5119, X, X, X,
    5192, X, X, X, X, X, X, 19113, X, X, X, X, X, X, X, X, X, 4476, X, X, 3216,
    19376, X, X, 1741, X, X, X, 19333, X, X, X, X, X, X, X, X, X, 19443, 3430,
    X, X, X, X, X, X, 2240, 2212, X, X, X, X, X, 4295, X, X, 3395, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 19733, X, X, 4237, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 1491, X, X, 4183, X, X, X, X, X, X, X, X, X, X, X, X, X, 4373, X,
    X, 4123, X, X, X, X, X, X, X, X, X, X, X, X, X, 3944, X, X, 1315, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 1959, X, X, 1863, 2118, X, X, X, X, X, X, X,
    X, X, 2595, X, X, 3265, X, X, 4941, X, X, X, X, 3748, X, X, X, X, 3749,
    2250, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3221, 1736, X, X, X, X,
    X, X, X, X, X, X, X, 1654, X, X, X, 4619, X, X, X, X, X, X, 4405, X, X, X,
    X, X, 1257, X, X, 1620, X, X, X, X, X, X, 1558, 3593, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 3518, 1362, X, X, X, X, 4017, X, X, X, X, X, X, X,
    X, X, 18999, 5305, 5306, 5307, 5308, 5309, 5310, 5311, 5312, 5313, 5314,
    5315, 10963, 5181, 10964, X, 5122, 5076, 5079, 5080, 5083, 5084, X, X, X,
    X, 5124, 5125, 5128, 5129, 5126, 5127, 5052, 18747, 18746, 10853, X, 18820,
    18821, 18822, 10852, 18879, 18882, 18881, 18880, X, X, 18953, 2016, 18298,
    18480, 18631, 18630, 10774, 18629, 18743, 18742, 18741, 2606, X, 9251, X,
    16885, 10218, X, 4394, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19217, X,
    977, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1043, X, 2717, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 2736, X, 2124, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 1005, X, 2697, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4272,
    X, 950, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1843, X, 3349, X, X, X,
    X, X, X, X, X, 1882, X, X, X, X, X, 4306, X, X, X, X, X, X, X, X, X, X, X,
    X, 4621, X, X, X, 2580, X, X, X, X, X, X, X, X, X, X, X, X, 1646, X, X, X,
    2706, X, X, X, X, X, X, X, X, X, X, X, X, 4261, X, X, X, 4625, X, X, X, X,
    X, X, X, X, X, X, X, X, 19687, X, X, X, 4221, X, X, X, X, X, X, X, X, X, X,
    X, X, 4125, X, X, X, 1793, X, X, X, X, X, X, X, X, X, X, X, X, 1496, X, X,
    X, 4076, X, X, X, 4077, X, X, X, X, X, X, X, X, 4348, X, X, X, X, X, X, X,
    2796, X, X, X, X, 4028, X, X, X, X, 5006, X, X, X, X, X, X, X, X, X, X, X,
    2862, X, X, X, X, 1463, X, X, X, X, X, X, X, 1471, X, X, X, 19495, X, X, X,
    X, X, X, X, X, X, X, X, X, 1552, X, X, X, 19114, X, X, X, X, X, 4075, X, X,
    X, X, X, X, 2817, X, X, X, X, X, X, X, X, X, 6993, 14362, X, X, 15042,
    15649, 15650, 9235, 16822, 17274, 2612, 6991, X, 2499, 9232, X, 16823,
    10363, 17653, 10517, X, 18224, 18225, 2498, 9610, 10515, 6987, X, X, X,
    9910, X, 10804, 6988, 13672, X, 14358, 4559, 14360, X, 19318, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 19051, X, 1575, X, X, X, 1576, X, X, X, X, X,
    X, X, X, X, X, 4404, 19110, X, X, X, X, 19744, X, X, X, 19745, X, X, X,
    2638, 1887, X, X, 1899, X, X, X, X, X, X, X, X, X, 2384, X, X, X, 3021, X,
    X, 3304, X, X, X, X, 2598, X, X, X, X, 3560, 2463, X, X, X, X, X, X, 4421,
    19458, X, X, 19675, 2727, X, X, X, X, X, X, X, X, X, X, X, X, 4964, X, X,
    X, 19359, X, X, X, X, X, 2315, X, X, X, X, X, X, 4642, X, X, X, X, 3107, X,
    4639, X, X, X, 19184, X, 990, X, X, X, X, X, X, X, 4541, X, X, 3166, X, X,
    2594, X, X, X, X, X, X, 1421, X, X, X, 2233, X, X, X, X, X, X, X, 4987, X,
    X, X, X, 11518, X, X, X, X, X, X, X, X, X, X, X, 2000, X, 3548, X, X, 3278,
    X, X, X, X, 2652, X, X, 3708, X, 3288, X, X, X, 1555, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 1634, X, X, 4232, X, X, X, X, X, X, X, X, X, X, X, X, X,
    5012, 3075, X, 19245, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19192,
    2078, 3402, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2991, 19592, X, X,
    X, 19581, X, X, X, X, X, X, X, X, X, 1733, X, 4485, 3143, 2825, X, X, X, X,
    X, X, X, X, X, X, X, X, 19479, X, X, X, 2645, X, X, X, X, X, X, X, X, X, X,
    X, X, 19205, X, X, X, 2818, X, X, X, X, X, X, X, X, X, X, X, X, 1981, X,
    4168, X, 19478, X, 1947, X, X, 1524, X, X, X, X, X, X, X, X, X, 4199, X, X,
    X, X, X, X, 19366, X, X, X, X, X, X, X, X, X, 2096, X, X, X, X, X, X, X,
    11287, 11288, X, X, X, X, X, X, 11289, X, 11049, 11050, 11051, 11052,
    11053, 11054, 11055, 11056, 11057, 11058, 11059, 11060, 11061, 11062,
    11063, 11128, 11129, 11130, 11131, 11132, 11133, 11134, X, X, X, X, X,
    10962, 10953, 10954, X, 5161, 5160, X, X, 5196, X, X, X, X, X, X, X, X, X,
    X, 2628, X, X, X, X, X, 3022, X, X, X, X, X, X, X, X, X, X, 4438, X, X, X,
    X, X, 19152, X, X, X, X, X, X, X, X, X, X, 2214, 3331, X, X, X, 19709, X,
    3018, 1891, X, X, X, X, X, X, 3721, X, 4389, X, X, X, 2687, X, X, 5001, X,
    X, X, X, X, X, X, 2485, X, X, X, X, 2486, X, X, X, 2161, X, X, X, X, X, X,
    X, X, X, X, X, X, 4056, X, X, X, 2847, 2848, 3628, X, X, X, X, X, X, X, X,
    X, X, 4238, X, X, X, X, X, 1425, X, 4431, X, X, X, X, X, X, X, X, 18997, X,
    X, X, X, X, X, X, X, 4403, X, X, X, 1360, X, X, X, 3485, 3328, 3343, 19183,
    X, X, X, X, X, 4475, X, X, X, 1591, X, X, X, X, X, X, X, X, X, X, X, X,
    4336, X, X, X, 4378, X, X, X, X, X, X, X, X, X, X, X, X, 4194, X, X, X,
    19765, X, X, X, X, X, X, X, X, X, X, X, X, 2951, X, X, X, 1447, X, X, 4171,
    X, X, X, X, X, X, X, X, X, 1945, X, X, 1474, X, X, 1509, X, 2659, 3540, X,
    X, 19532, 19238, X, X, X, X, X, X, X, X, X, 4661, X, X, X, X, X, X, 4704,
    X, X, X, X, X, X, X, X, X, 2624, X, X, X, X, X, X, X, 5113, 5112, X, X, X,
    5105, X, X, 5109, 5106, 10997, 10998, 10999, 11000, 11001, 11002, 11003,
    11004, 11005, 11006, 11007, 11008, 11009, 11010, 11011, 11012, 11080,
    11081, 11082, 11083, 11084, 11085, 11086, 11087, 11088, 11089, 11090,
    11091, 11092, 11093, 11094, 11095, 5417, 5418, 5419, 5420, 5421, 5422,
    5423, 5424, 5425, 5426, X, X, X, X, X, X, 4321, X, X, X, X, X, X, X, X, X,
    4432, X, X, X, X, X, X, 3333, X, X, X, X, 2376, X, X, 3411, X, 1040, 3350,
    X, X, 2940, X, X, 2601, 3354, X, X, X, X, X, 3973, X, X, 1665, 11330, 1285,
    1380, 11539, 1286, X, X, 10937, X, 11777, 12121, 12585, 7077, 6679, 6676,
    X, 12122, 6314, 6675, X, 7078, 7079, X, 7080, X, 13138, X, X, X, 1039,
    3815, 12105, 12579, X, 12578, 12583, 12574, 3440, 12577, 12576, 2042,
    12580, 11767, 11766, 11763, 11772, 11773, 11770, 11768, 6302, X, X, 4816,
    11771, 6308, 11776, 3678, 2803, 11769, X, 6667, 6301, X, X, X, X, 4172, X,
    3442, 6668, 12109, 2802, X, 12115, 19350, X, X, 6674, 12113, 12119, X,
    12110, 12114, 12116, 12118, 12112, 1631, 12111, 12106, 12107, 6669, 4228,
    6671, 6670, 12108, 12117, X, 4702, X, X, 4648, X, X, X, 6673, X, 8451,
    14407, 8447, 8448, 8454, 8442, 5212, 8440, 14401, 4531, X, 2216, X, X,
    8449, 2520, 7989, 7985, 7981, 2793, 13707, X, X, X, 1589, 4544, 7987, 4202,
    X, X, 14402, 13084, 13087, 13092, 19219, X, 7503, 7501, 7513, X, X, X, X,
    7508, 19146, 7496, 7648, 12564, 7061, 12546, 1470, 12551, 7054, 7065,
    12549, 7049, 7059, 7064, 12556, X, 7060, 7063, 1403, 6283, 11741, 11743, X,
    6286, 3674, 6288, 11739, 11744, X, X, 6297, 6293, 11752, 6299, 19147,
    11515, 6017, 4524, 6002, 1780, 6012, 6013, 11516, 6010, 6008, X, 6009,
    6015, 11524, 5996, X, 5828, X, 5834, 5830, X, 5836, 11403, 5833, 5823,
    5826, 5829, 5825, 5832, 5835, 5824, 1391, X, 9269, X, 17725, X, 10936, X,
    X, 11328, X, 5692, X, X, X, X, 16821, X, X, 16820, 9911, 16819, 17267,
    3313, 17269, 17271, 17270, 2488, 16818, 9903, 16817, 9906, X, X, 9904, X,
    17264, 17266, X, 2476, 10197, 17265, 10198, 17263, 7929, 13669, 8394, 7927,
    7930, 7926, 7931, 7932, 7928, X, X, 2447, 13666, 8390, 14348, X, 5033,
    11257, 5099, 5184, 5189, 5100, 11256, 5053, 5054, 5101, 5133, 5025, 5134,
    5028, 5180, 17354, X, 18635, X, 18903, 4833, 1730, 1772, 1779, 1812, 1814,
    1816, 1821, 1844, 1845, 1847, 5021, X, 9645, 4850, 17353, 17720, 18050,
    18051, 18052, 18304, 4751, 18300, 10716, 18303, 18302, 10633, 16316, X,
    16884, 8864, X, 10391, 2605, 2604, 18478, 10715, 18479, 18477, 18740, X,
    18818, X, 4729, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2667, X, 2022, X,
    X, X, X, X, X, X, X, 4200, X, X, X, X, X, 2211, X, X, X, X, 2189, X, X, X,
    X, X, 3381, X, X, X, X, X, X, X, X, X, X, 4155, X, X, X, X, X, X, 1446, X,
    X, X, X, X, X, X, X, X, 1540, X, X, X, X, X, X, X, 3512, 19622, 2048, 2981,
    2422, 2429, X, X, X, 4446, X, X, X, X, X, X, X, X, X, X, X, X, 968, X, X,
    X, 4322, X, X, X, X, X, X, X, X, X, X, X, X, 2494, X, 4204, X, 1698, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 3306, X, 3084, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 19330, X, 4436, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    1594, X, 1516, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4684, X, 1121,
    1138, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1755, 4377, X, X, X, X,
    X, X, X, X, 2430, X, 3269, X, X, X, X, 1457, X, X, X, X, X, X, X, X, X, X,
    X, 1014, X, X, X, X, X, 2713, X, X, X, X, X, X, X, X, X, X, 1860, X, X, X,
    X, X, 19721, X, X, 3152, X, X, X, X, X, X, X, 19149, X, X, X, X, X, X, X,
    X, X, 1051, X, X, X, X, X, X, 5168, X, X, X, 5169, X, X, X, X, X, X, 1784,
    X, X, X, 2856, X, X, X, X, X, 3439, X, X, X, X, X, X, X, X, X, X, 4848, X,
    X, X, X, X, 19257, X, X, X, X, 1756, X, X, X, X, X, X, 2672, X, X, X, X, X,
    X, 3606, X, X, 3280, X, X, 4162, X, X, X, X, 3015, X, X, X, 3047, 3664,
    2083, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 19468, 2894, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2648, 3192, X, X, X, X, 3232, X, X, X, X,
    X, X, X, X, X, X, 4499, X, X, X, X, X, 4420, X, X, X, X, X, X, X, X, X, X,
    19492, X, X, X, X, X, 3014, 19025, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 2874, 4085, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2702, 2775,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4025, 2726, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1357, 16836, 9927, X, X, 17296, 2530, 17300,
    17297, 17299, 17298, 17295, 17301, 17304, 17302, 17303, 10205, 9919, 16266,
    9620, 9619, 16267, 16270, 16268, 16269, 9621, 3964, 9924, 9922, 3966, X,
    9921, 16828, 9912, X, 16826, 2504, 2503, 16824, X, 9915, 9913, 9917, X,
    9914, X, X, X, X, 1444, X, X, X, X, X, X, X, X, X, X, X, 6994, 3329, X,
    1713, 6995, 8847, 8848, 8851, 8849, 19401, 1465, 15648, 9233, 9234, X, X,
    16261, 9616, 16256, 16255, 3320, 15640, 15644, 15641, 15639, 15643, 9231,
    X, 19178, 16252, 2487, 16250, 9612, X, 9611, 16251, 9613, 9229, X, 16248,
    4728, 9606, 16246, 9607, 9608, 16247, 9609, X, 16816, X, 9905, 9902, 9907,
    6983, 12501, X, 12502, 12499, X, 4264, X, 7445, X, X, 7442, 13036, 7443,
    7446, 13037, 16242, 9605, X, X, X, 16812, 16810, 17258, X, 16808, 16809,
    9897, 16805, 16813, 16807, 16811, 10864, 18861, 10863, 18862, 18890, 18893,
    18892, 10873, 18891, 3943, X, 19406, 10883, 10881, 10882, 10888, 18191, X,
    X, X, 2602, 2483, 2437, 3267, 18197, 18402, 18407, 10691, 18409, 3939,
    10685, 1017, 2829, 10496, 10504, 17945, 10507, X, 17941, 17951, 10509, X,
    X, X, 17937, X, 17944, X, 18897, 4569, 18896, 18895, 18898, X, 10884,
    10885, 18944, 18948, 3374, 1716, X, X, X, 19056, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 3379, X, X, 5366, 5367, 5368, 5369, 5370, 5371, 5372, 5373,
    5374, 5375, 5376, 5377, 5378, 5379, 5380, 5448, 5449, 5450, 5451, 5452,
    5453, 5454, 5455, 5456, 5457, 5458, 5459, 5460, 5461, 5462, 5463, 11263, X,
    X, X, 11264, X, 11265, 11266, 11267, X, 11268, X, 11269, 11270, X, X, 2656,
    2663, X, 2341, X, X, X, X, X, X, 3459, 3630, X, X, 1966, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 2630, X, 5381, 5382, X, 5383, 5384, 5385, 5386,
    5387, 5388, 5389, X, X, X, X, X, X, 2670, X, X, X, X, X, X, X, X, X, 3689,
    4867, X, X, X, X, X, 2933, X, X, X, X, X, X, X, X, X, X, X, X, 2393, X, X,
    X, 19692, X, X, X, X, X, 4418, X, X, X, X, X, X, 19002, X, X, X, 2440, X,
    X, 3457, X, X, X, 3399, X, X, 1857, X, X, X, X, 3865, X, 2471, X, 4331,
    1018, X, X, X, X, 3514, X, X, X, X, X, X, 3310, X, 3581, X, 3124, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 3240, X, 2031, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 1672, X, 19212, X, X, X, 1409, X, X, X, X, X, X, X, 4707, X,
    X, 19379, X, X, X, X, X, X, X, X, X, X, X, X, 1931, 2593, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 4286, 2387, X, X, X, X, X, X, X, X, 1936, 3551,
    X, X, X, X, X, 7942, 14364, 15054, X, 8861, 15052, X, X, 15053, X, X, 9228,
    16245, 16815, 9901, 10196, 17632, 17636, 10356, 17633, 10357, 10355, 17637,
    10358, 17635, 11485, 5944, 11483, 11486, 11484, X, X, X, 11694, X, 6218, X,
    6219, 11696, 6216, 11695, 6588, X, 6982, 7438, X, 2435, 13664, X, 13665,
    7924, X, 8382, 14345, 14344, 8386, 8381, 18566, 10756, 10757, X, 3942,
    18694, X, 18696, 3366, X, X, 2433, X, 18695, 18697, X, 15671, 15672, 9249,
    9247, 15673, 9248, 16305, X, 16308, 16302, 16309, 16301, 16303, X, 16304,
    18260, 18604, X, X, 18601, 4520, 18598, X, 18599, 10768, 18709, 18711,
    18714, 18710, 18715, 3372, 3376, X, 18258, 10627, 18265, 4745, X, 18264, X,
    X, X, 4749, 18442, 18441, X, 1657, 10386, 17685, X, 17683, 17690, X, 17682,
    17681, 10385, 10383, 10382, X, X, X, X, 3378, 17322, 17317, 17321, X,
    17319, 17318, 17316, X, 17313, X, 10208, 10207, X, 10209, 10206, 17323,
    16850, 3978, 16856, 19535, X, 16851, 17320, 16852, 16863, X, X, 4688, X,
    1658, 2557, 4899, 15668, 15669, X, X, 16299, X, 16294, 16291, 16298, 3977,
    X, X, 16300, X, X, 9637, 2553, 9245, 9246, 16290, 9635, 9634, 16289, X,
    17311, X, 17678, 17680, 17679, 10381, 10380, 10379, 18251, 18253, 18252, X,
    2544, 18434, 18437, 18435, 18436, 18593, 10767, X, X, X, 18703, 18704,
    17671, 10376, 17993, X, X, X, 18250, 18248, X, X, 18249, X, X, 18433, X,
    10704, 10624, 18240, 18238, X, 18239, 10626, 18243, 10625, 18246, 18425,
    18431, 2532, 3974, 18426, 10703, 18432, 15047, 8858, 15046, 8857, 8859,
    15048, X, X, 2610, 15657, 15659, 15658, 3352, 15661, X, X, 13034, 7920,
    13656, 3324, 7919, 7921, 13661, 7923, 13658, 13659, 13651, 7922, 13662, X,
    9241, 15660, 15656, 3914, 3972, X, 15662, X, 16277, X, 16280, 16282, 16272,
    16276, 16273, 3916, 2521, 7448, 13039, X, 13674, 2522, 8407, X, 8410, 8408,
    14363, 2523, 8412, X, 8409, 16260, 9614, X, 4380, 9918, X, 16257, 16262,
    16259, 16258, X, 9615, X, 9916, 4835, 16825, 10199, 17268, 17647, 10360,
    17645, 17648, 10361, X, 17643, X, 17646, 17644, 17641, 10362, 17642, X,
    1422, X, X, X, 2794, 4142, 19032, X, X, X, X, X, X, X, X, 4343, 1451, X, X,
    X, X, X, X, 2026, X, X, X, X, X, X, X, 3365, X, X, 1888, 3767, 19602, X, X,
    X, X, 3768, X, X, X, X, 3086, X, 4991, X, X, X, X, 3566, X, X, X, X, X,
    19064, X, X, X, 3033, X, X, X, X, X, X, X, X, X, X, X, X, X, 1432, X, X,
    1702, X, X, X, X, X, X, X, X, X, X, X, X, X, 1650, X, X, 1697, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 2204, X, X, 19357, X, X, X, X, X, 4383, 2912,
    2358, 3479, 3100, 19663, 3044, 19358, 2045, 4254, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 3493, X, 3139, X, X, X, X, X, X, X, X, 1691, 5023, X, X,
    X, X, 1538, X, X, X, X, X, X, X, X, X, X, X, 1525, X, X, X, X, 4392, X, X,
    X, X, X, X, X, X, X, X, X, 1170, 1171, X, X, X, X, 955, X, X, X, X, X, X,
    X, X, X, 4611, 965, 3971, X, 2527, X, X, X, X, X, X, X, X, 3460, X, X,
    4999, X, 2038, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2786, X, 3826,
    3176, X, X, X, X, X, X, X, X, X, X, X, X, X, 1123, 1140, X, 5464, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 3392, 1715, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 986, 2942, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    958, 3528, 2625, X, X, X, X, X, X, X, X, X, X, X, 3670, X, X, 4234, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 19673, X, X, 4698, X, X, X, X, X, 2646, X,
    X, X, X, X, X, X, 11279, X, X, X, X, X, 11280, X, 11281, X, 10966, 10967,
    10968, 10969, 10970, 10971, 10972, 10973, 10974, 10975, 10976, 10977,
    10978, 10979, 10980, 11045, 11046, 11047, 11048, X, X, X, X, X, X, X,
    11261, 11262, 10955, 10956, X, 5201, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 4451, 2578, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4397, 2455,
    2421, 2425, 3054, X, 2426, X, X, X, X, 1764, X, X, X, X, X, 4468, X, 1034,
    X, X, X, X, X, X, X, X, X, 2352, X, X, X, X, X, X, 2631, X, X, 4933, X, X,
    X, X, X, X, 2335, X, 3877, X, X, X, X, X, X, X, X, 2162, X, X, X, X, X, X,
    X, 3550, X, X, X, X, X, X, X, X, X, 1527, X, X, X, X, X, X, 5111, 5110, X,
    X, X, X, X, X, X, X, X, 1686, X, X, X, X, X, X, 2398, X, X, X, X, X, X, X,
    X, X, 1429, X, X, X, X, X, X, X, 2528, X, X, X, X, X, X, X, X, 19137, 4188,
    X, X, X, 4034, X, X, X, 4052, X, 19435, 4551, 1608, 1618, 1623, 1543, 1636,
    X, X, X, X, 19286, X, X, X, 4167, X, X, X, X, X, X, X, 11213, X, X, X, X,
    19761, X, X, X, 4371, 4474, X, X, X, X, X, X, X, X, X, X, X, 4027, X, X, X,
    X, 2340, X, X, X, X, X, X, X, X, X, X, X, 1012, X, X, X, X, X, 3283, X, X,
    X, X, X, X, X, X, X, 4374, 2915, 2946, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 1595, X, 3591, X, X, X, X, X, 4861, 3290, 19689, 2330, X, X, X, X, X,
    2261, X, X, X, X, X, X, X, X, X, X, 1549, X, X, X, X, X, X, 1477, X, X, X,
    X, X, X, X, X, X, 4043, X, X, X, X, X, X, X, 5003, 4508, X, X, X, X, X, X,
    X, 2258, X, X, X, X, 1905, X, 2105, X, X, 6249, X, 6248, 6250, 1273, 6624,
    X, 2746, 12527, 2747, 7475, 2748, 2749, 13691, 9651, X, 10930, X, X, X,
    1379, 11318, 11211, 5672, 5673, X, X, 5810, X, 11503, 6627, X, 7034, X,
    7032, 7033, X, 4574, 2757, X, 9652, 10932, 5674, X, 1754, X, 11497, 2738,
    5961, X, 3204, 5964, 5949, 5973, 11490, X, 2715, 11709, 5947, 5969, 5948,
    11716, 6246, 11720, X, 11718, 11722, 6243, 11710, 11698, X, 11712, 6234,
    11717, 6229, 11719, X, 2458, X, X, X, X, X, 3946, X, X, X, X, X, X, X, X,
    2264, X, X, X, X, X, X, X, 2011, X, 13954, 8164, X, 3253, X, 14634, 14633,
    14607, 8144, 8140, 13982, 8146, 8150, 8145, 8154, 13986, 13977, 2010,
    19776, 13959, 8159, 8153, 13971, 8137, 13983, 13976, 8141, 13965, 8156,
    13994, 13995, X, 8138, 13981, 8158, 13969, 13955, 13956, 8162, 13960,
    13967, 13961, X, 8160, 8168, 13957, 13950, 13951, X, 13953, 8143, 13966, X,
    8157, 8166, 19562, 19462, 13968, 13992, 13984, 8139, 13990, 8151, 1850,
    8149, 19216, 13996, 8148, 13974, 13962, 13972, 8171, 13978, 13975, 13958,
    8167, 13988, 13985, 13993, 8142, 13973, 8170, X, 13980, X, X, 8152, 8155,
    8569, X, 14632, 14610, 14611, X, 8579, 14641, 8574, 14631, 1351, 14604,
    8580, 8570, 14619, 14609, 14612, 14636, 8564, 14643, 14635, 8573, 14624,
    8584, X, X, 8583, 8577, X, X, 14642, 8565, 14622, 14613, 14626, 14638,
    8585, 19508, 8567, 14621, 4324, 14614, 8576, 2013, 8575, 14617, 14627,
    14637, 14608, 14618, 8568, 14628, 8581, 8572, 14615, 8571, 14606, 14620,
    14640, 8163, 9027, 14623, 15273, 14625, 14639, 8578, 14616, 8566, 8582,
    9405, 14605, X, 14630, 19091, 2015, 19033, 14629, 1263, X, X, 11662, 11660,
    11661, 11658, 6163, 11659, 2785, X, X, X, 19124, 11977, 2626, 6518, 10034,
    4877, 10035, 16991, 4654, 10262, 17426, 10261, 10424, X, 10425, 10564,
    18101, 18100, 18335, 18510, 9039, 15335, 15911, X, X, X, X, 9416, 15910,
    15919, 15918, 15916, X, 15915, 15912, 15913, 14020, 14022, 14025, 14023,
    8185, 14029, 8183, 8603, 3696, 3697, 14676, 14675, 14673, X, 8606, 8605,
    12782, 12789, 4879, X, 4590, X, X, 13379, 13383, X, 13382, 14019, 14030, X,
    X, 13385, 6842, 6843, 4876, 12345, 12339, X, 12344, X, 12340, 6841, 12343,
    12341, X, X, X, X, 3677, X, X, X, X, X, X, X, X, X, X, X, 2294, X, X, X, X,
    17039, X, 17037, 10058, 17038, X, 17040, 17036, 17035, X, X, 17459, 15392,
    9068, 1024, X, X, X, X, 9450, X, 15969, 3092, 9451, 9447, 9449, 4862, 9446,
    8660, X, 14756, X, X, X, 15395, X, 15394, X, 1762, 15390, 1031, 4948, 9067,
    15393, 14759, 14750, 14753, 14757, 8661, 14755, X, 14754, 14751, 14752,
    8659, 14758, 8658, X, 8663, 8662, 8225, X, 14089, 14091, 14093, 8224, 3772,
    X, 8222, X, 14090, 8223, 14092, 8221, X, X, 6879, 12390, X, 12385, 12382,
    X, 4408, 12389, X, X, 6881, 6882, 12388, 12387, 7279, 12848, 7289, 12846,
    7283, 12839, X, 7284, 7281, 3758, X, X, 19012, 3425, X, X, 2642, X, X, X,
    X, 2299, 3059, 8635, 1428, 3063, 15358, 9055, 15364, 9056, 9771, 16541,
    16544, 16545, X, 9774, X, 10048, 17021, X, 10045, 17015, 10047, 10049, X,
    19743, 14730, X, 5772, 6170, X, 6529, 19115, 12380, 12381, 7278, X, X,
    14071, 8217, 8642, 10050, 7287, 12844, 12838, 12836, X, 7285, 13432, 7280,
    12841, 12845, 12847, 12843, 12837, 7286, 12842, 12840, 14072, X, 14084, X,
    14073, 14074, 3761, X, 14082, 14081, 14078, 7779, 8219, 14076, 14079, 8220,
    14080, 14077, X, X, X, X, X, X, X, 14741, 4683, 14745, 8649, X, 15371,
    8652, 14743, 18956, X, 14740, 14735, 14737, 14738, 14731, 3080, 8648, X, X,
    8647, 3079, 8643, 14734, 15375, 14739, 15377, 9063, 15378, 15374, X, 9060,
    15370, 9062, 15367, 15372, 15376, 15369, X, 19752, 9445, 15955, 3081,
    19754, 15957, 9443, X, 19758, 4863, X, 9776, 16555, X, 16549, 16553, 16559,
    3117, 19176, 17028, 17023, 10053, 2454, X, 10051, X, 17030, 10052, 17026,
    17027, 17024, 17031, 17449, 6532, 6533, 11996, X, 12396, 12395, 6883, 6886,
    6885, 6884, 12392, 12394, 12393, X, X, 12851, 14088, 19352, 14087, 14086,
    14085, X, X, X, X, 14749, 8653, X, 14746, 14748, 4359, 8654, 15389, 3769,
    15388, 15385, 15384, 15383, 15382, 15386, 15379, 3770, 15962, 3087, 15965,
    19772, X, 2629, 17808, 10435, 18118, 10739, 18518, X, 18768, 18767, 11374,
    6887, 6888, 13442, X, 8657, 5775, 6173, 6172, 6171, X, X, 3524, 11998,
    19779, X, 6535, 6534, 1851, 6891, 19561, 12398, 12401, 12399, 1023, 6889,
    6890, X, 19781, 12397, 12400, X, 7305, X, X, X, 12862, 12864, 12863, 7302,
    12858, X, 3408, 4330, 7299, X, 7303, 7301, X, 7304, 12861, 12856, 12857,
    12860, 12859, X, 6548, 6546, 12007, X, 6545, X, 2164, X, 6550, 6552, 6549,
    X, 12010, 12006, 6553, 12427, 6918, X, 12433, 6922, 6913, 12441, X, X,
    3818, X, X, 1598, 7342, X, 7351, 12921, 12919, 7339, 4961, X, 7341, 7344,
    2166, 7347, 3178, 7349, X, 3820, X, 3822, X, 15532, 15521, 8724, X, X, X,
    X, 9148, 15509, 15530, 15510, 9143, X, 15507, X, 14296, 3908, X, 14298,
    14291, 14294, 14285, 8355, 14287, 14286, 8354, 8356, X, 8790, 14968, 16182,
    X, X, 16183, 16179, 9577, 9573, X, X, 9572, 9574, X, 16178, 2368, 16746,
    9868, 17208, 3582, 10162, 17207, 10160, 10163, 17590, 17591, 17592, 10331,
    3246, 17593, X, 10332, 10490, 17922, 18562, 10753, 18563, 18691, 18690, X,
    1316, 1317, X, X, X, X, X, X, 1318, X, 9236, 16263, 9617, 4836, X, 10202,
    2514, 17657, 3959, 10369, 17973, 10521, 17972, 17974, 17971, 18700, 6992,
    7939, 7940, 13673, 8404, 8405, 14361, 8406, X, 8850, X, 8852, 15040, 15041,
    15039, 14359, 3314, 15038, 15035, 8845, X, 8846, 15036, 15037, X, 15637,
    15642, 9230, 15636, 15638, 15645, 14357, 14356, 8402, X, 2799, 15034, 8843,
    8840, 15033, 8842, 15031, 8841, X, 15032, X, 15634, 6590, 4778, 6594,
    12054, 6593, 3874, X, X, X, X, 12503, 6984, 6985, 6986, 12504, 12500, 2438,
    9218, 3945, 9221, 9223, 9222, 2436, 3273, 9219, 9220, 1586, 16240, 16239,
    9604, 16241, X, 18466, 18471, 18469, 10710, 18460, 18450, 18449, 10712,
    18462, 18463, 18459, 18451, 3991, 18456, 18286, 18031, 18021, 10533, 18034,
    18029, 18030, X, 18016, 18023, 18038, X, 18035, 4709, 18027, 2570, 18039,
    17338, 17325, 17334, 17335, 4897, 17333, X, X, X, 3986, 17696, 17698,
    17701, X, 1264, 17695, 16873, X, 9938, X, 16868, 9934, 3443, 16865, 16871,
    16874, X, 9939, X, 16870, 16867, 16875, 18708, X, 18706, 3373, 10813,
    18712, 10815, 10814, 18707, 18713, X, X, X, 4616, 18803, 10846, 3983,
    18448, X, 18444, 18447, 10708, 1592, X, 18445, 18446, X, 18440, 18443,
    10707, X, 4045, 18001, 18014, 18005, X, 18003, 18012, 18004, 10528, 10527,
    3255, 17999, 18000, 18009, 4657, X, X, 1725, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19501, X, X, 3413, X, X, X, X, X, X, 3553, 2025, X, X, X, X, 3571,
    2353, 3710, X, X, X, X, 3492, 19671, X, X, 3577, 1799, X, X, 2781, X,
    19487, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5202, 5203, 19512, X, X,
    19040, X, X, X, X, X, X, X, X, X, X, X, X, X, 2345, X, X, 4209, X, X, X, X,
    X, X, 1571, X, X, X, X, X, X, 4977, X, X, X, 19349, X, X, X, X, 2804, X,
    1349, X, X, X, 1412, X, 1388, X, X, 4402, X, X, X, 4536, X, 2039, 1662,
    4829, X, X, X, X, X, X, X, 1550, X, X, 4827, X, 1912, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 1064,
]; // 34086 entries

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_UPPER: &'static [u16] = &[
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9822, 16982, 5985, 26351, 4419, 4433, 30950,
    9569, 17456, 0, 9555, 4446, 17439, 0, 0, 0, 0, 0, 32349, 245, 0, 0, 0, 0,
    0, 0, 0, 13750, 24247, 5045, 258, 0, 0, 0, 9524, 1336, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 21285, 21336, 31487, 31566, 0, 0, 0, 27487, 10997, 28899,
    17121, 17283, 25172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 28801, 19655, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 212, 13642, 9538, 0, 0, 0, 0, 0, 0, 199, 0, 0, 0, 0, 0, 28928,
    8456, 3337, 0, 0, 0, 27070, 2833, 0, 1191, 0, 16621, 0, 0, 13588, 0, 0,
    8139, 21409, 1299, 0, 226, 9838, 0, 0, 31042, 2756, 27316, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32286, 0, 0, 21301, 31503, 32364, 0, 0,
    0, 11013, 11088, 0, 0, 0, 0, 0, 0, 0, 0, 28915, 17137, 19956, 4386, 0,
    17299, 28817, 8155, 21424, 9980, 27332, 11102, 30312, 0, 11116, 0, 32614,
    0, 0, 0, 21317, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16490, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31519, 22897, 3752, 32457, 6598,
    29992, 17150, 0, 0, 0, 0, 19969, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17315,
    28833, 3767, 0, 32472, 21440, 30328, 6614, 17331, 32488, 30007, 21456,
    30344, 6630, 17347, 30023, 22683, 21472, 30360, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    6646, 0, 0, 0, 0, 0, 0, 28848, 0, 0, 0, 0, 0, 0, 4399, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 33978, 16864, 32503, 0, 20876, 30038, 0, 0, 0, 0, 0,
    4054, 17363, 0, 31595, 17376, 0, 17088, 27299, 17075, 16879, 22945, 32550,
    17422, 17000, 0, 0, 31687, 0, 20891, 17391, 22699, 10976, 16064, 31702,
    22928, 34038, 16504, 0, 34053, 3990, 5134, 29747, 34023, 28784, 31733,
    34068, 7725, 28799, 1803, 29734, 21488, 19820, 21501, 30277, 2931, 21530,
    7674, 31533, 6662, 33994, 0, 22911, 0, 0, 2782, 27315, 19805, 0, 26369, 0,
    17405, 1430, 2885, 22961, 13660, 0, 0, 7687, 3966, 0, 0, 22944, 0, 13717,
    17673, 0, 24122, 7598, 19685, 5009, 31716, 9901, 0, 13730, 27623, 31749,
    16518, 18886, 9686, 0, 13704, 29761, 30262, 29957, 9804, 16673, 21375,
    16535, 21515, 13606, 0, 0, 8103, 1463, 29062, 0, 17658, 22927, 1446, 18871,
    3819, 21544, 2418, 31547, 13570, 31732, 9871, 1429, 20709, 33976, 29942,
    22975, 14258, 16590, 9915, 33931, 30104, 0, 0, 0, 29373, 0, 0, 14289, 0, 0,
    0, 29791, 32153, 1413, 0, 0, 29076, 0, 14272, 9856, 7445, 33945, 32124,
    17731, 31685, 19622, 30073, 2800, 29774, 479, 9884, 5027, 0, 0, 0, 7461,
    9661, 0, 11742, 0, 0, 27547, 16030, 29805, 33961, 2707, 17747, 30089, 0, 0,
    0, 0, 16603, 32166, 11139, 0, 29818, 0, 0, 16046, 771, 8714, 3871, 31081,
    18809, 0, 5116, 2861, 2720, 29090, 17656, 0, 0, 8373, 9581, 28766, 1156, 0,
    10849, 32138, 0, 0, 27436, 0, 0, 7430, 16471, 18869, 17763, 0, 19636,
    17468, 7067, 15999, 7580, 0, 31668, 11152, 0, 29106, 0, 9597, 17047, 20042,
    17451, 2814, 31624, 0, 0, 0, 13762, 30986, 0, 10356, 0, 0, 0, 31670, 0, 0,
    964, 0, 22734, 32329, 3603, 18967, 1172, 32346, 784, 1219, 0, 0, 0, 0,
    16188, 17764, 27727, 16487, 17484, 16015, 4122, 1490, 9550, 20055, 32826,
    2692, 31637, 13775, 27576, 21571, 4991, 16649, 0, 13624, 1503, 0, 11637,
    8400, 0, 27589, 32578, 0, 0, 0, 33207, 0, 9939, 3619, 0, 17641, 25852,
    29107, 17780, 0, 27035, 0, 9757, 0, 8121, 32298, 0, 0, 9744, 0, 8085,
    31024, 0, 0, 3795, 23101, 17434, 27743, 0, 0, 19918, 0, 10154, 0, 8759, 0,
    26780, 27421, 0, 0, 4138, 12873, 29136, 2738, 18854, 30388, 31653, 7404,
    25139, 17702, 9898, 10884, 0, 32918, 0, 0, 3620, 20919, 0, 17781, 6880,
    17417, 3847, 0, 0, 0, 0, 0, 32596, 16530, 16547, 0, 1264, 1458, 3637, 0,
    27605, 29123, 11666, 0, 0, 17562, 32314, 32331, 30404, 0, 27712, 3636, 0,
    0, 0, 1475, 0, 0, 27561, 17797, 1396, 11995, 4490, 2666, 0, 21556, 3653,
    8548, 0, 14396, 0, 27098, 17561, 0, 14284, 0, 0, 0, 19936, 8436, 21647, 0,
    0, 0, 0, 0, 0, 17578, 17594, 17545, 17610, 8728, 18823, 9632, 21660, 17626,
    2571, 8744, 19042, 18839, 14301, 25124, 21676, 2587, 19058, 18981, 14317,
    32887, 21692, 2603, 18997, 14333, 32903, 1233, 21708, 2619, 19013, 14349,
    1249, 21724, 23190, 2635, 19029, 14365, 2492, 21740, 23206, 2651, 14381,
    17498, 2508, 21616, 21756, 17514, 2524, 21632, 21772, 17530, 2540, 21788,
    32840, 2556, 23146, 32856, 25109, 32872, 23175, 23159, 4264, 4280, 2477,
    21601, 4248, 23131, 24953, 2461, 21585, 4232, 23115, 24937, 4216, 25094,
    2446, 10215, 24921, 4200, 25078, 10199, 24905, 4184, 25062, 10184, 24889,
    4168, 25046, 10168, 4152, 24874, 30637, 4913, 25030, 24858, 4898, 30621,
    25014, 24842, 30606, 4882, 29786, 24998, 24826, 30590, 4835, 4866, 24982,
    24810, 4804, 30574, 4850, 4819, 7035, 24966, 24794, 4788, 30558, 7050,
    7019, 24778, 4772, 7004, 30542, 24762, 4756, 30526, 24746, 4740, 24730,
    4724, 24714, 4708, 6989, 24698, 4692, 6973, 24682, 4676, 6957, 12935,
    24666, 12919, 12903, 6456, 12887, 6440, 6424, 6408, 6392, 6376, 30463,
    30479, 30495, 30511, 30447, 4613, 4629, 4645, 4661, 6942, 24651, 6926,
    24635, 6910, 24619, 6894, 12055, 12071, 12087, 12103, 12119, 24508, 12135,
    24524, 12151, 30418, 4582, 24540, 6361, 12167, 30434, 4598, 24556, 12183,
    24572, 12199, 24588, 12215, 24604, 12231, 12247, 12263, 12024, 12040,
    24493, 12279, 4551, 4567, 4535, 4519, 6282, 6298, 6314, 6330, 6266, 6346,
    6091, 6075, 6107, 6123, 6139, 6155, 6171, 12009, 6187, 6203, 6219, 4504,
    6235, 6251, 24416, 24432, 24448, 24400, 24464, 24480, 6028, 6044, 6060,
    6012, 24385, 5996, 8609, 8625, 8641, 8593, 24274, 24258, 24290, 24306,
    24322, 24338, 24354, 24370, 8578, 8562, 14426, 14442, 14410, 14489, 14505,
    14473, 14457, 21879, 21863, 19072, 21894, 21910, 23233, 21847, 21831,
    21957, 21973, 21989, 23220, 22005, 23280, 19087, 21941, 23264, 21925,
    23248, 21802, 4294, 21818, 22036, 22052, 22020, 23343, 23359, 23327, 23311,
    23295, 19118, 19134, 19150, 19102, 19166, 19182, 10261, 4309, 10277, 10245,
    10229, 19245, 19261, 19229, 461, 19213, 445, 19197, 4959, 429, 4943, 413,
    4927, 397, 381, 365, 349, 19292, 5608, 333, 19276, 5592, 317, 5576, 13045,
    301, 5433, 5560, 507, 13029, 19323, 7111, 285, 5417, 5544, 92, 491, 13013,
    19307, 7095, 269, 5401, 5528, 8251, 76, 5623, 12997, 19466, 7079, 5385,
    5512, 8235, 12981, 12357, 19450, 5369, 5496, 6518, 8219, 12965, 12341,
    19434, 7222, 5353, 5480, 6502, 12949, 12325, 19418, 7206, 5337, 13076,
    5464, 6486, 12309, 19402, 7190, 5321, 13060, 5448, 6470, 12293, 538, 19386,
    7174, 5305, 522, 19370, 7158, 5289, 19354, 7142, 5273, 7365, 19338, 7126,
    5257, 22146, 5670, 7349, 5241, 22130, 5654, 14519, 10384, 7333, 5225,
    22114, 12388, 5638, 10368, 7317, 5209, 22098, 12372, 7301, 5193, 22082,
    7285, 5177, 22066, 7269, 13282, 5161, 7253, 6533, 13266, 7784, 5145, 7237,
    13250, 7768, 13234, 22193, 23372, 7752, 13218, 10447, 22177, 10339, 7736,
    13202, 10431, 22161, 10323, 170, 14550, 13186, 10415, 10307, 154, 13552,
    5685, 14534, 13170, 10399, 12419, 10291, 138, 13536, 13154, 12403, 122,
    13520, 13138, 6548, 106, 13504, 13122, 23403, 13488, 5732, 13106, 23387,
    14565, 13472, 5716, 13090, 13456, 5700, 13440, 13424, 13408, 25520, 13392,
    25504, 13376, 25488, 13360, 25472, 13344, 25456, 13328, 25440, 13312,
    25424, 13296, 25408, 25392, 25376, 25360, 25344, 25328, 25312, 25296,
    25280, 20131, 25264, 20115, 20099, 20083, 6579, 20067, 6563, 1846, 1862,
    1878, 1894, 1830, 1814, 32952, 32968, 32984, 33000, 33016, 5747, 32936,
    33032, 33048, 33064, 33080, 33096, 7798, 14580, 7814, 22207, 14596, 7830,
    22223, 14612, 7846, 22239, 14628, 7862, 22255, 7878, 22271, 551, 7894,
    22287, 567, 25535, 7910, 22303, 583, 25551, 7926, 22319, 20146, 1909,
    25567, 7942, 22335, 20162, 1925, 25583, 22351, 20178, 1941, 25599, 20194,
    1957, 20210, 1973, 14819, 14835, 14851, 14867, 14883, 14899, 14915, 14803,
    14787, 14771, 10461, 14755, 14739, 14723, 14707, 14691, 14675, 14659,
    14643, 23448, 23464, 23432, 33190, 23416, 33174, 661, 12433, 33158, 645,
    33142, 629, 33126, 613, 33110, 8005, 597, 7989, 5776, 7973, 5760, 25806,
    7957, 25790, 25774, 25758, 25742, 25726, 25710, 22430, 25694, 22414, 25678,
    22398, 25662, 15138, 22382, 25646, 15122, 22366, 25630, 15106, 25614,
    15090, 15074, 15058, 20321, 8019, 15042, 20305, 15026, 20289, 15010, 20273,
    14994, 20257, 2020, 14978, 20241, 2004, 14962, 20225, 22460, 1988, 14946,
    25820, 22444, 14930, 10492, 10476, 2050, 2066, 23479, 2082, 2034, 2098,
    33327, 2114, 676, 33343, 2130, 22505, 692, 33359, 2146, 33297, 22521,
    33375, 33313, 15342, 22537, 33391, 33407, 33423, 12448, 33439, 12464, 5791,
    33455, 5807, 33471, 15153, 5823, 20336, 22475, 33487, 20352, 22491, 33503,
    20368, 33519, 20384, 33535, 33551, 33567, 33583, 25835, 33283, 33267,
    33251, 33235, 10571, 33219, 21017, 10555, 21001, 10539, 20985, 10523,
    20969, 10507, 20953, 20937, 26715, 26731, 26747, 26763, 26699, 753, 26683,
    2334, 737, 15328, 26667, 23494, 2318, 15312, 2193, 26651, 2302, 15296, 723,
    2177, 15373, 26635, 2286, 15280, 22584, 707, 2161, 15357, 15387, 26619,
    2270, 12511, 15264, 22568, 26603, 2254, 12495, 15248, 22552, 26587, 2238,
    12479, 15232, 26571, 2222, 15216, 26555, 27962, 2206, 15200, 26539, 27946,
    17847, 15184, 26523, 27930, 17831, 15168, 25864, 856, 26507, 27914, 0, 0,
    11684, 0, 0, 17815, 17892, 17908, 17924, 17876, 17860, 5838, 25893, 25909,
    25925, 25941, 25957, 25973, 25989, 26005, 26021, 26037, 25877, 26053,
    20399, 20415, 20431, 20447, 33598, 10586, 10600, 20463, 33614, 10616,
    33630, 15541, 21032, 15557, 15776, 21048, 15792, 15808, 15824, 15447,
    15840, 15463, 15479, 15495, 15511, 15666, 15527, 15682, 15698, 23666,
    15714, 23682, 23509, 22599, 15730, 23698, 23525, 22615, 15746, 23714,
    23541, 22631, 15762, 3671, 23730, 15402, 23557, 22647, 28291, 18112, 12526,
    23746, 15418, 23573, 28307, 27977, 18128, 12542, 17939, 15434, 23589,
    28323, 27993, 18144, 12558, 17955, 23605, 28339, 18160, 12574, 17971,
    23621, 5853, 28355, 18176, 12590, 17987, 5869, 28371, 26068, 18192, 12606,
    18003, 26084, 18208, 18019, 26100, 18224, 18035, 26116, 18240, 18051,
    26132, 20478, 18256, 18067, 10631, 26148, 6673, 20494, 18083, 10647, 18099,
    10663, 18333, 24133, 10679, 33645, 18349, 15588, 15604, 15620, 15636,
    15652, 15572, 13951, 13935, 13967, 13983, 21063, 21079, 26209, 21095,
    26225, 21111, 26241, 21127, 8868, 26257, 21143, 26273, 21159, 26289, 15855,
    21175, 15871, 3686, 21191, 15887, 3702, 23761, 21207, 28008, 3718, 23777,
    23636, 28024, 5884, 28386, 27833, 3734, 23838, 23652, 23793, 28040, 5900,
    28277, 28402, 27849, 23809, 23854, 28056, 12621, 5916, 28418, 27865, 28072,
    18271, 12637, 28434, 27881, 28088, 18287, 12653, 28450, 27897, 28104,
    18303, 12669, 28466, 27913, 8761, 0, 0, 29059, 0, 0, 0, 0, 13889, 26163,
    28120, 6688, 18319, 12685, 28482, 13905, 26179, 28136, 20509, 6704, 12701,
    28498, 13921, 0, 0, 0, 0, 27755, 26195, 28152, 20525, 28514, 8806, 27771,
    28168, 20541, 28530, 8822, 27787, 28184, 20557, 28546, 8838, 27803, 24148,
    20573, 28562, 8854, 27819, 28578, 10694, 28594, 33660, 10710, 28610, 33676,
    28626, 33692, 28642, 33708, 0, 0, 14123, 28658, 14139, 18364, 28674, 14155,
    18380, 18396, 18412, 18428, 13998, 8883, 18444, 14014, 8899, 14030, 8915,
    14046, 8931, 26304, 26792, 14062, 8947, 26808, 14078, 8963, 26824, 14094,
    8979, 26840, 14110, 8995, 26856, 9011, 26872, 9027, 9043, 32027, 15902,
    9059, 15918, 21222, 9075, 9091, 9107, 9123, 9139, 9155, 23824, 9171, 23869,
    23885, 23901, 23917, 23933, 23949, 23965, 23981, 23997, 18649, 18665,
    18681, 11337, 18633, 11321, 18617, 11305, 18601, 11289, 31440, 18585,
    11273, 28263, 31424, 18569, 11257, 31822, 28247, 31408, 20652, 18553,
    33928, 0, 5931, 3100, 0, 22665, 0, 0, 29045, 0, 18931, 0, 0, 11241, 31806,
    28231, 33803, 31392, 8792, 20636, 10789, 1408, 0, 20755, 31790, 28215,
    33787, 31376, 8776, 30681, 20620, 6719, 12716, 10773, 24179, 31774, 28199,
    33771, 31360, 30665, 20604, 10757, 18507, 24163, 29603, 33755, 31344,
    30649, 32090, 20588, 10741, 18491, 15981, 29587, 33739, 31328, 32074,
    31295, 10725, 18475, 15965, 9250, 0, 0, 29571, 33723, 26903, 31312, 32058,
    14170, 11512, 31279, 18459, 15949, 16845, 9234, 26319, 0, 0, 18949, 26887,
    32013, 32042, 11496, 18744, 31263, 15933, 16829, 9218, 31997, 11480, 18728,
    21253, 0, 31247, 0, 16813, 9202, 31981, 11464, 18712, 21237, 9186, 31965,
    11448, 18696, 31949, 11432, 31933, 11416, 31917, 11400, 31901, 11384,
    31885, 24010, 33914, 11368, 8511, 31869, 33898, 11352, 31853, 33882, 16780,
    31455, 0, 0, 0, 0, 0, 0, 31760, 31837, 20834, 33866, 16764, 20818, 33850,
    16748, 20802, 33834, 3305, 16732, 20786, 33818, 3289, 16716, 20770, 3273,
    16700, 3257, 0, 0, 0, 0, 0, 16684, 6862, 3241, 6846, 3225, 6830, 3209,
    6814, 3193, 6798, 30744, 3177, 29244, 6782, 30728, 3161, 29228, 12837,
    6766, 30712, 24228, 22771, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16242, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8497, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3145, 29212,
    6750, 3558, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30696, 24212, 3129, 29196, 6734,
    16452, 0, 0, 0, 0, 0, 0, 0, 0, 18792, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12731, 1266, 16260, 0, 9351, 0, 11059,
    7062, 0, 0, 26404, 24194, 12733, 0, 11877, 19900, 0, 0, 0, 0, 0, 0, 0, 0,
    4321, 0, 29618, 10351, 0, 18806, 182, 33202, 0, 27217, 0, 3936, 0, 8031, 0,
    999, 18552, 3542, 31246, 0, 3882, 0, 16949, 0, 10860, 0, 32105, 0, 0,
    24196, 16435, 0, 4366, 9608, 3919, 0, 0, 17058, 0, 3113, 0, 0, 0, 0, 30997,
    0, 27144, 15996, 21266, 0, 0, 11041, 0, 11909, 0, 0, 0, 0, 30169, 0, 0, 0,
    29620, 0, 975, 31468, 20847, 29180, 16402, 0, 0, 26918, 0, 18775, 0, 4036,
    0, 27281, 0, 0, 0, 0, 0, 0, 0, 0, 14187, 0, 0, 14185, 0, 0, 0, 8278, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 3402, 0, 0, 0, 0, 3318, 0, 0, 0, 0, 0, 22745, 0, 0,
    0, 3041, 195, 0, 0, 25847, 0, 8355, 0, 0, 0, 0, 0, 0, 4018, 0, 0, 11527, 0,
    0, 0, 18535, 16436, 0, 32727, 0, 0, 26775, 26418, 0, 0, 0, 4105, 0, 0, 0,
    0, 0, 0, 0, 18776, 18536, 1138, 31230, 29494, 0, 26432, 16419, 9446, 0,
    31229, 2346, 16860, 17071, 16199, 32657, 1082, 7657, 0, 11648, 4350, 3415,
    23084, 29164, 0, 8411, 28703, 18964, 3365, 0, 16386, 18759, 0, 13687,
    27263, 4119, 32807, 0, 0, 0, 18519, 10137, 0, 0, 1714, 0, 19846, 32670,
    29540, 7625, 9460, 2913, 0, 9713, 0, 14220, 0, 10090, 5083, 27005, 29463,
    0, 31307, 0, 27695, 4349, 11978, 22783, 0, 31213, 5051, 0, 0, 3570, 0, 0,
    10121, 30130, 26989, 9950, 1378, 1346, 0, 4333, 19587, 7670, 3931, 3948, 0,
    0, 19571, 8531, 29147, 0, 0, 0, 19603, 0, 0, 0, 0, 8067, 0, 0, 0, 0, 0,
    29925, 27402, 0, 0, 16573, 0, 0, 58, 29163, 0, 0, 13700, 11529, 1096, 0, 0,
    21346, 0, 0, 0, 17713, 24027, 7488, 0, 0, 9643, 0, 29028, 30761, 0, 1727,
    16414, 16369, 0, 3429, 0, 0, 1305, 10944, 0, 31576, 0, 0, 4472, 12820, 0,
    0, 0, 0, 0, 0, 0, 16888, 23098, 28938, 0, 0, 0, 0, 0, 0, 2762, 29553, 0,
    29261, 0, 0, 24025, 0, 0, 10151, 0, 9784, 27418, 9473, 27080, 9986, 4088,
    16385, 2843, 11122, 0, 22708, 9425, 9441, 0, 0, 29511, 9489, 29476, 1049,
    31139, 8652, 0, 0, 1065, 892, 31155, 19860, 8526, 16073, 22796, 12854,
    12870, 16277, 0, 16795, 0, 30044, 30143, 16293, 7639, 26449, 29506, 8325,
    4060, 20025, 11223, 1201, 0, 0, 0, 2363, 0, 29938, 0, 0, 23067, 26444,
    19477, 0, 16586, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2358, 0, 0, 0, 0,
    0, 0, 0, 6877, 0, 0, 0, 0, 0, 2937, 0, 0, 0, 0, 31212, 0, 0, 9727, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 16631, 7501, 0, 0, 0, 10120, 0, 31052, 3972, 30759,
    14237, 9333, 0, 3083, 11135, 19829, 0, 0, 0, 0, 1120, 0, 32682, 0, 16224,
    7376, 0, 0, 11207, 867, 0, 0, 0, 0, 9667, 0, 0, 12750, 29259, 0, 0, 0,
    3524, 0, 0, 0, 0, 0, 28685, 0, 0, 1016, 0, 2867, 0, 0, 13669, 0, 0, 20738,
    0, 0, 16655, 0, 0, 1652, 0, 8665, 0, 0, 12852, 0, 16467, 0, 0, 0, 30823, 0,
    0, 0, 0, 0, 0, 8480, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1281, 0, 0, 0, 0, 0, 0,
    0, 0, 10073, 0, 11611, 0, 3801, 0, 0, 0, 0, 0, 0, 11070, 16275, 909, 12748,
    0, 11860, 11892, 0, 27678, 0, 0, 16306, 0, 26988, 0, 14232, 0, 0, 11961, 0,
    31196, 27161, 0, 0, 0, 0, 0, 3385, 2380, 0, 0, 0, 27126, 7410, 0, 11023, 0,
    0, 0, 0, 0, 27017, 0, 10104, 3853, 0, 0, 0, 0, 16960, 1014, 3777, 0, 9962,
    19784, 0, 0, 0, 20038, 0, 0, 0, 0, 11595, 19570, 27159, 0, 0, 32433, 0,
    11924, 0, 0, 7607, 0, 0, 30370, 32789, 11844, 0, 27632, 0, 27401, 9740, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20901, 0, 0, 0, 0, 0, 26972, 20858, 4000,
    0, 11926, 0, 27709, 19554, 3096, 0, 2672, 0, 0, 0, 0, 0, 20658, 0, 0, 0, 0,
    0, 2895, 32639, 1697, 29635, 11992, 0, 27245, 926, 14202, 5065, 1360, 0, 0,
    0, 9695, 8545, 0, 0, 29523, 0, 9813, 0, 29011, 26929, 1647, 13579, 0, 0,
    32756, 0, 12803, 0, 0, 3829, 29042, 0, 0, 10926, 16323, 0, 0, 20751, 0, 0,
    27385, 0, 0, 0, 0, 0, 0, 0, 0, 904, 0, 0, 0, 0, 29446, 0, 8493, 0, 0, 0, 0,
    11873, 16085, 0, 2428, 17188, 11546, 0, 0, 30113, 0, 9256, 0, 0, 11905, 0,
    0, 20007, 0, 0, 0, 32204, 12834, 0, 26461, 3398, 28967, 0, 8037, 7470,
    1631, 0, 32738, 3380, 0, 20719, 4102, 0, 5098, 0, 2397, 0, 0, 1079, 32754,
    0, 7562, 7546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2375, 19741, 24044, 16613, 19489,
    16368, 0, 0, 16352, 0, 31138, 31122, 23081, 0, 0, 0, 0, 0, 0, 21357, 0, 0,
    18912, 0, 11206, 0, 3585, 16055, 0, 0, 1316, 0, 27649, 11190, 0, 0, 1710,
    31195, 8382, 0, 29908, 11594, 31179, 0, 28775, 29278, 10003, 31091, 3888,
    0, 11578, 19877, 0, 29536, 5126, 11827, 11811, 0, 0, 7590, 0, 11544, 0,
    19843, 30241, 10087, 2773, 0, 0, 0, 0, 0, 10866, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27692, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5000, 0, 0, 943, 12767, 9614, 0, 31003, 0, 0, 0, 981, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29459, 0, 0, 22820, 0, 9795,
    9766, 0, 0, 1559, 0, 0, 0, 0, 11843, 16102, 0, 27178, 19521, 0, 0, 10894,
    0, 0, 30126, 9514, 27615, 24042, 11708, 1575, 0, 0, 0, 0, 17025, 0, 0,
    26955, 0, 8094, 0, 16556, 0, 0, 0, 30055, 30776, 0, 29276, 29873, 19537, 0,
    0, 14249, 11724, 0, 22837, 26971, 0, 10001, 0, 28744, 0, 470, 0, 0, 4071,
    19875, 0, 0, 3506, 0, 7516, 0, 1664, 30805, 0, 9405, 29889, 2948, 12765,
    8260, 0, 0, 19754, 31063, 23050, 0, 11975, 27526, 0, 16119, 0, 0, 17221,
    27108, 0, 8446, 921, 1329, 3983, 32400, 1031, 0, 11943, 22751, 10827,
    16205, 0, 16318, 30302, 0, 19798, 0, 3066, 4969, 0, 10056, 27176, 0, 9315,
    32447, 2392, 0, 0, 9678, 0, 8417, 0, 29921, 6588, 0, 0, 8463, 22871, 30254,
    0, 0, 2878, 0, 11941, 0, 0, 0, 0, 29982, 0, 0, 0, 0, 16990, 0, 0, 0, 0,
    26359, 1102, 0, 0, 0, 16666, 27644, 0, 762, 0, 0, 0, 938, 0, 0, 13562, 0,
    8676, 0, 0, 0, 0, 0, 27368, 0, 0, 0, 0, 0, 19553, 0, 0, 29025, 16569, 0, 0,
    0, 0, 0, 12817, 0, 0, 0, 0, 0, 32621, 22853, 1680, 27227, 1614, 7529, 9421,
    0, 20021, 16335, 32218, 16097, 27661, 10798, 3812, 2964, 19767, 8288,
    29295, 2411, 20673, 32236, 31105, 32416, 7421, 32771, 29429, 27539, 955,
    17203, 8692, 11561, 10908, 0, 11794, 0, 0, 0, 0, 0, 10020, 0, 0, 0, 0, 0,
    0, 0, 0, 3864, 17095, 0, 0, 0, 0, 0, 0, 0, 0, 12784, 0, 0, 32557, 17007, 0,
    0, 8365, 3079, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13650, 0, 0, 3435, 0, 0, 0, 0,
    16136, 0, 27384, 0, 0, 0, 0, 2683, 0, 0, 0, 0, 0, 27195, 0, 0, 0, 0, 19724,
    0, 0, 28758, 9360, 30284, 13596, 4085, 0, 0, 0, 0, 0, 30224, 0, 0, 23064,
    0, 0, 0, 28994, 0, 0, 0, 0, 0, 0, 0, 0, 17238, 0, 9846, 0, 0, 13813, 0, 0,
    0, 0, 17171, 0, 4982, 0, 0, 0, 22869, 0, 0, 1630, 0, 0, 0, 26376, 0, 0,
    19909, 2790, 0, 0, 2982, 20734, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 29964, 9267, 7545, 1148, 0, 30866, 0, 0, 9495, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 24059, 0, 23032, 10841, 0, 19504, 0, 0, 5034, 0, 8048, 16351, 0, 5109,
    0, 0, 7573, 0, 29293, 0, 0, 8476, 3596, 0, 0, 0, 0, 1693, 8077, 68, 19990,
    8393, 32187, 0, 0, 0, 10070, 0, 0, 0, 0, 11657, 34, 32234, 0, 0, 0, 0, 0,
    0, 28712, 0, 27675, 0, 0, 0, 0, 5017, 29312, 10018, 0, 29442, 0, 0, 0,
    29563, 16805, 0, 0, 0, 0, 23014, 0, 1542, 0, 0, 0, 0, 0, 0, 0, 0, 22832, 0,
    0, 0, 3899, 10037, 0, 0, 0, 13631, 0, 0, 0, 0, 0, 0, 0, 0, 16114, 8128, 0,
    0, 17216, 9343, 0, 17037, 0, 19892, 0, 12782, 0, 31161, 0, 10877, 0, 0,
    27193, 16131, 0, 2980, 0, 0, 13830, 0, 0, 31121, 11577, 19737, 0, 0, 0, 0,
    31031, 0, 2745, 0, 0, 0, 0, 2999, 0, 0, 0, 32603, 0, 0, 0, 29904, 0, 1130,
    8196, 0, 32816, 0, 0, 0, 22802, 0, 0, 8305, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    11958, 0, 0, 0, 22886, 0, 13614, 0, 17233, 0, 30237, 1387, 8429, 0, 0, 0,
    0, 0, 19781, 0, 29310, 0, 0, 11691, 0, 0, 0, 0, 29839, 32430, 0, 11173, 0,
    0, 0, 0, 0, 0, 0, 8111, 32251, 0, 0, 0, 0, 0, 0, 11810, 0, 0, 0, 0, 0,
    9625, 3452, 10035, 0, 0, 0, 0, 0, 30883, 0, 0, 0, 31014, 29008, 12800, 0,
    0, 30149, 0, 3741, 0, 10810, 2728, 0, 0, 0, 0, 0, 0, 0, 17185, 0, 0, 0, 0,
    0, 20004, 0, 0, 9283, 27506, 0, 0, 0, 0, 0, 32201, 28695, 0, 0, 0, 0, 0, 0,
    0, 25191, 27210, 0, 7382, 32586, 29412, 0, 32799, 0, 0, 13828, 0, 0, 0, 0,
    22672, 0, 23027, 29710, 0, 0, 0, 0, 16913, 0, 0, 14212, 29329, 13847, 0,
    27043, 1555, 0, 0, 4481, 0, 0, 0, 3016, 2997, 1370, 4043, 0, 30881, 0, 0,
    0, 0, 19926, 992, 0, 0, 0, 28726, 0, 0, 8177, 8300, 11187, 23047, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 30787, 3912, 8209, 0, 0, 24075, 0, 8271, 10824, 28977,
    0, 11704, 19520, 0, 0, 27089, 0, 0, 29327, 0, 50, 0, 0, 29856, 10053, 0,
    3447, 8334, 27522, 13845, 0, 0, 0, 0, 9297, 0, 0, 3014, 0, 16148, 0, 0,
    25207, 0, 0, 19707, 873, 29872, 25255, 28991, 0, 0, 8348, 0, 30900, 26498,
    17250, 27288, 0, 0, 0, 13880, 0, 0, 0, 0, 7480, 0, 0, 0, 0, 3465, 0, 25239,
    29854, 29346, 0, 13864, 0, 0, 27457, 0, 0, 0, 16153, 3062, 0, 0, 32926, 0,
    805, 0, 26484, 13810, 0, 20927, 3048, 0, 18922, 0, 0, 0, 8060, 1042, 0, 0,
    0, 0, 13796, 0, 0, 0, 0, 3470, 0, 0, 0, 0, 11232, 0, 821, 0, 0, 4464, 0, 0,
    9776, 0, 0, 0, 0, 0, 0, 17168, 0, 0, 0, 1287, 0, 0, 0, 0, 0, 9388, 0, 0,
    19987, 0, 0, 9404, 0, 0, 8317, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    32263, 0, 0, 29425, 0, 0, 0, 1780, 5952, 32691, 0, 0, 34012, 0, 22762, 0,
    0, 0, 24087, 0, 0, 0, 0, 0, 0, 1764, 0, 0, 16216, 30898, 30917, 0, 0, 885,
    0, 0, 0, 30207, 0, 0, 0, 0, 0, 0, 0, 0, 11674, 0, 32399, 0, 4450, 0, 32184,
    17805, 0, 0, 0, 0, 0, 17262, 0, 0, 0, 16233, 11076, 0, 0, 27367, 0, 0,
    17154, 0, 19973, 16966, 0, 0, 5969, 0, 29723, 0, 2920, 16165, 0, 0, 4403,
    0, 0, 0, 3482, 1585, 3661, 0, 19944, 22655, 0, 9326, 0, 0, 0, 0, 0, 0, 0,
    32383, 833, 0, 29836, 0, 0, 0, 0, 30849, 0, 0, 0, 0, 29344, 1113, 0, 0, 0,
    0, 0, 27351, 0, 0, 16926, 3516, 19720, 1597, 18939, 0, 33998, 0, 22997, 0,
    0, 0, 0, 0, 0, 7691, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30934, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 3955, 20698, 229, 32704, 0, 16250, 0, 0, 0,
    30220, 1613, 0, 13734, 0, 0, 32113, 32280, 0, 0, 21320, 0, 11777, 32170,
    28867, 0, 17720, 0, 32522, 1525, 0, 0, 0, 0, 3533, 4374, 0, 0, 0, 30815, 0,
    29395, 0, 32268, 0, 0, 29822, 0, 11170, 0, 27118, 11049, 17, 9968, 0, 0,
    20684, 11156, 20864, 0, 0, 0, 0, 0, 0, 0, 0, 8174, 0, 0, 0, 0, 30177,
    30862, 802, 0, 0, 0, 0, 0, 0, 0, 13862, 0, 0, 8160, 0, 0, 31600, 0, 0, 0,
    0, 0, 0, 0, 4026, 7719, 7707, 0, 32782, 1785, 0, 0, 0, 0, 0, 0, 29641,
    29667, 0, 27271, 32631, 0, 30952, 23010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1797, 0, 24092, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 788, 0, 0,
    1538, 19611, 27237, 29653, 31550, 9650, 0, 10952, 16896, 11793, 10981,
    3031, 1734, 27489, 10918, 8703, 28959, 24104, 31583, 0, 0, 8192, 26935, 0,
    0, 28883, 27439, 32538, 17678, 19690, 29408, 25222, 0, 17105, 33, 30190, 0,
    25174, 28945, 0, 2850, 18905, 10964, 30832, 9371, 31613, 18891, 29680,
    30968, 0, 0, 0, 0, 0, 0, 0, 0, 26467, 26481, 0, 0, 0, 0, 0, 24116, 0, 0, 0,
    0, 0, 1208, 0, 16638, 0, 0, 0, 0, 19657, 0, 0, 32567, 0, 0, 9506, 0, 0,
    27135, 21380, 29706, 0, 27024, 11032, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 31172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3784, 22716, 16909, 3339, 27455,
    27505, 0, 29692, 0, 13779, 25190, 0, 22980, 1507, 17267, 0, 25238, 0, 9920,
    29484, 0, 0, 22813, 16170, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25143, 9387, 1747,
    7647, 0, 0, 0, 0, 0, 0, 0, 0, 19673, 30160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    19639, 0, 3355, 0, 4009, 30377, 30980, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1763, 13793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22728, 0, 0, 0,
    32382, 0, 0, 0, 32648, 0, 0, 0, 0, 16182, 0, 0, 30915, 21363, 29361, 26948,
    0, 32366, 0, 7393, 5935, 30061, 0, 0, 26323, 0, 0, 17691, 0, 0, 0, 0, 0,
    13677, 0, 24232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27054, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 28737, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19703, 0, 0, 21270, 0,
    0, 0, 0, 0, 0, 0, 0, 2817, 0, 11730, 0, 29378, 0, 11619, 0, 0, 0, 0, 0,
    17017, 30294, 0, 31472, 0, 0, 0, 7615, 0, 0, 0, 11747, 27350, 30203, 0, 0,
    2903, 0, 0, 30845, 11776, 0, 0, 0, 0, 0, 0, 0, 27254, 0, 1175, 0, 0, 0,
    11631, 0, 0, 0, 0, 0, 0, 9704, 0, 0, 20908, 0, 0, 27472, 21393, 10935, 0,
    22993, 9933, 0, 28866, 0, 0, 0, 1521, 3487, 3499, 0, 27334, 0, 30798, 0, 0,
    32521, 29391, 0, 0, 0, 0, 0, 11760, 0, 25157, 0, 28850, 0, 32505, 0, 0, 0,
    0, 0, 5967, 0, 0, 0, 0, 3836, 0, 0, 0, 0, 0, 0, 0, 0, 850, 0, 838, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26386, 0, 0, 0,
    30932, 0, 0, 5949, 31069, 16931, 0, 0, 0, 0, 2435, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 34070, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9308, 32709,
    16, 0, 0, 5073, 0, 26398, 29974, 0, 3322, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 16943, 0, 26337, 0, 32721,
]; // 12190 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_LOWER: &'static [(u16, u16)] = &[
    (179, 227), (4098, 4264), (42777, 168), (10357, 10360), (200, 228),
    (4181, 4490), (42778, 710), (10352, 10362), (10193, 10259), (192, 226),
    (4087, 4524), (9974, 9984), (10259, 10319), (228, 230), (4196, 4241),
    (4108, 4523), (9954, 9974), (18021, 18049), (4168, 4226), (42791, 10045),
    (9998, 10349), (157, 179), (4082, 4163), (37012, 12306), (4336, 4345),
    (4448, 4485), (10011, 10321), (4176, 4263), (43084, 12849), (32860, 13542),
    (407, 518), (584, 797), (33699, 13386), (33865, 13809), (1281, 1286),
    (34550, 13365), (34616, 13700), (34759, 13412), (2162, 2165), (2480, 2505),
    (35401, 13512), (35572, 13787), (3265, 3277), (36228, 13770),
    (36294, 13540), (3594, 3694), (36533, 13741), (3885, 3888), (3965, 3988),
    (50863, 13434), (18260, 18271), (32816, 13861), (33223, 13953), (660, 708),
    (953, 971), (33872, 13902), (34029, 14017), (34097, 13896), (34167, 14117),
    (34362, 14020), (34423, 14270), (1714, 1745), (1862, 1912), (34933, 13994),
    (2280, 2315), (2490, 2518), (2590, 2646), (2688, 2692), (3042, 3075),
    (35889, 13895), (35921, 14024), (36004, 14178), (3325, 3387),
    (36297, 14138), (36367, 13869), (3697, 3701), (3735, 3754), (36803, 13877),
    (50831, 13897), (50866, 14147), (18242, 18308), (51175, 13881),
    (18570, 18591), (51392, 14093), (18719, 18740), (51550, 14328),
    (32826, 14453), (479, 582), (33502, 14586), (930, 1004), (34213, 14720),
    (1608, 1780), (2007, 2022), (34992, 14818), (35193, 14631), (35377, 14730),
    (36000, 14747), (3385, 3400), (36466, 14812), (50930, 14540),
    (18348, 18438), (11, 65), (488, 515), (582, 636), (1005, 1049),
    (1417, 1461), (34333, 15118), (34419, 15200), (1950, 2033), (2098, 2125),
    (35653, 15161), (35994, 15294), (3710, 3732), (36749, 14940),
    (50957, 15019), (18354, 18379), (18451, 18556), (32810, 15860), (789, 808),
    (910, 922), (33745, 15868), (1058, 1177), (1272, 1292), (34335, 15697),
    (34421, 15645), (1745, 1747), (34818, 15759), (34872, 15821), (2396, 2472),
    (2606, 2630), (2719, 2727), (35640, 15820), (36132, 15444), (3447, 3484),
    (3537, 3561), (4045, 4060), (50890, 15580), (50978, 15796), (51073, 15749),
    (18394, 18407), (18535, 18662), (32830, 16108), (33199, 15944), (516, 625),
    (33625, 16091), (949, 969), (34179, 16080), (1699, 1711), (34607, 16094),
    (34699, 16056), (2076, 2129), (2276, 2390), (2541, 2551), (35403, 16090),
    (2739, 2793), (36502, 15988), (36584, 15878), (18161, 18182),
    (51179, 15936), (18696, 18768), (51604, 16040), (100, 120), (484, 558),
    (814, 974), (1120, 1125), (34023, 16859), (34275, 16748), (34518, 16471),
    (34748, 16784), (2131, 2250), (35091, 16482), (2799, 2841), (36165, 16607),
    (3673, 3745), (36767, 16485), (51083, 16388), (51248, 16600),
    (51428, 16644), (0, 73), (525, 559), (817, 915), (1096, 1187),
    (34076, 16960), (34266, 17081), (2182, 2306), (35283, 17084),
    (35383, 17147), (2847, 2878), (3469, 3472), (50828, 17077), (51310, 17148),
    (3, 25), (32889, 17633), (911, 973), (1163, 1328), (1529, 1531),
    (34507, 17652), (34586, 17629), (2087, 2090), (2232, 2235), (35151, 17600),
    (35225, 17715), (2588, 2669), (2884, 2928), (36157, 17727), (36289, 17673),
    (36415, 17644), (36504, 17897), (36712, 17591), (36844, 17762),
    (43035, 17553), (18165, 18224), (51286, 17641), (18584, 18631), (2, 107),
    (489, 511), (947, 955), (1344, 1394), (34598, 18042), (2278, 2280),
    (35402, 18048), (2934, 2954), (3269, 3355), (36437, 18254), (50975, 18342),
    (76, 99), (33181, 18705), (33313, 18443), (711, 715), (33985, 18825),
    (1434, 1517), (34659, 18802), (2309, 2470), (2572, 2640), (2961, 3008),
    (35979, 18640), (36231, 18682), (36445, 18675), (18316, 18380),
    (18705, 18745), (32796, 19108), (33328, 19124), (712, 810), (1528, 1678),
    (34612, 19342), (34766, 19347), (2356, 2413), (2518, 2609), (3009, 3032),
    (3212, 3308), (36825, 19326), (51246, 19255), (1, 28), (399, 403),
    (897, 967), (1601, 1647), (2442, 2446), (35808, 19565), (3408, 3563),
    (3714, 3836), (3967, 3973), (50983, 19693), (51093, 19728), (320, 331),
    (422, 443), (722, 743), (33547, 20023), (832, 837), (33703, 20404),
    (34011, 20473), (34422, 20274), (1766, 1802), (35030, 20293), (2479, 2492),
    (35475, 20400), (35517, 20424), (35609, 20001), (35722, 20206),
    (35904, 20088), (3316, 3321), (3525, 3543), (36338, 19996), (3691, 3693),
    (3812, 3815), (3866, 3881), (4553, 4586), (4616, 4639), (4709, 4744),
    (4836, 4862), (5003, 5033), (5278, 5306), (5657, 5682), (6056, 6087),
    (39281, 20094), (40244, 20098), (9984, 9988), (42784, 20189),
    (43032, 20058), (10362, 10405), (10435, 10452), (10545, 10561),
    (10755, 10783), (11113, 11132), (11570, 11577), (44868, 20095),
    (13424, 13427), (50311, 20153), (50846, 20395), (50954, 20041),
    (51130, 20151), (331, 335), (432, 441), (33553, 20539), (812, 835),
    (34310, 20688), (34373, 20532), (1767, 1817), (34835, 20857),
    (34882, 20703), (35378, 20724), (35791, 20916), (35990, 20946),
    (36043, 20582), (3629, 3633), (36551, 20990), (3819, 3839), (36641, 20717),
    (36761, 20697), (4268, 4270), (4562, 4587), (4639, 4647), (4728, 4736),
    (4862, 4870), (5033, 5039), (5306, 5315), (5682, 5686), (6058, 6097),
    (6514, 6536), (7005, 7016), (7477, 7488), (7924, 7938), (8311, 8321),
    (8704, 8712), (9002, 9006), (42219, 20787), (9694, 9696), (9777, 9779),
    (9988, 9991), (43037, 20872), (10364, 10384), (43220, 20913),
    (10561, 10563), (10783, 10786), (11563, 11593), (12101, 12130),
    (12734, 12751), (13427, 13445), (14115, 14131), (14733, 14745),
    (15375, 15381), (15944, 15950), (16413, 16416), (16779, 16781),
    (17364, 17366), (50462, 20797), (18062, 18129), (18419, 18428),
    (51316, 20624), (51378, 20935), (51415, 20959), (32858, 21071), (335, 341),
    (33150, 21031), (441, 452), (33429, 21343), (33474, 21096), (33525, 21341),
    (33593, 21284), (34099, 21495), (34283, 21452), (1825, 1848),
    (35763, 21249), (35894, 21348), (36021, 21135), (3423, 3445), (3696, 3700),
    (3733, 3764), (3815, 3843), (3875, 3884), (3983, 3997), (36826, 21024),
    (4345, 4348), (4566, 4592), (4647, 4663), (4736, 4770), (4870, 4881),
    (5039, 5051), (5315, 5336), (38401, 21021), (5686, 5702), (6097, 6107),
    (6536, 6549), (39493, 21207), (7016, 7025), (7488, 7497), (7938, 7942),
    (8321, 8328), (8712, 8715), (41774, 21237), (42046, 21474), (42366, 21240),
    (9991, 9995), (43034, 20994), (10365, 10408), (10453, 10461),
    (10563, 10573), (10786, 10797), (11132, 11142), (11593, 11603),
    (12130, 12138), (12751, 12755), (13445, 13449), (14131, 14137),
    (47238, 21124), (14745, 14749), (15381, 15383), (48718, 21236),
    (16781, 16784), (49879, 21303), (17366, 17368), (50463, 21145),
    (18127, 18195), (51005, 21502), (51078, 21200), (18361, 18365),
    (32867, 21580), (452, 478), (528, 557), (645, 648), (33487, 22011),
    (33606, 21556), (33893, 21682), (34042, 21996), (34346, 21936),
    (34524, 21707), (1851, 1854), (34740, 21773), (34931, 21867),
    (35086, 21873), (35264, 21524), (35349, 21762), (35500, 21637),
    (2956, 2960), (3084, 3088), (36028, 21948), (36284, 21953), (3558, 3636),
    (36473, 21579), (3810, 3826), (3881, 3883), (37038, 21991), (4881, 4896),
    (5051, 5079), (5336, 5358), (5702, 5724), (6107, 6128), (6550, 6572),
    (39474, 21855), (7025, 7052), (40081, 21892), (7497, 7514), (7942, 7958),
    (43229, 21511), (10573, 10588), (10797, 10818), (11142, 11163),
    (11603, 11626), (12138, 12162), (12755, 12777), (13449, 13472),
    (14141, 14152), (50916, 21833), (18196, 18220), (51045, 21843),
    (51339, 21537), (32805, 22267), (32865, 22451), (33109, 22242), (570, 588),
    (672, 690), (33489, 22153), (33659, 22333), (1004, 1014), (33868, 22462),
    (34109, 22113), (1665, 1667), (34491, 22363), (1757, 1760), (1855, 1862),
    (34878, 22322), (34976, 22468), (2498, 2503), (35345, 22180),
    (35412, 22472), (35504, 22398), (35538, 22269), (35564, 22051),
    (35641, 22452), (35665, 22511), (35725, 22356), (35782, 22100),
    (35815, 22096), (3079, 3096), (35998, 22408), (36022, 22335),
    (36054, 22433), (36085, 22201), (36164, 22230), (36205, 22293),
    (36256, 22155), (3545, 3596), (36421, 22139), (36474, 22442), (3745, 3771),
    (36586, 22375), (36621, 22033), (36642, 22394), (36673, 22048),
    (36744, 22367), (37360, 22303), (4770, 4772), (4896, 4906), (5079, 5093),
    (5358, 5367), (5724, 5733), (6128, 6134), (6572, 6586), (39820, 22285),
    (7514, 7516), (7943, 7960), (8328, 8342), (8715, 8729), (9007, 9013),
    (9279, 9281), (42220, 22181), (9599, 9604), (9696, 9699), (9779, 9782),
    (42604, 22220), (42645, 22225), (10371, 10388), (10408, 10410),
    (10462, 10467), (10588, 10597), (10818, 10835), (11163, 11178),
    (11626, 11643), (12162, 12194), (12760, 12786), (46240, 22292),
    (14137, 14150), (14749, 14768), (15383, 15395), (15951, 15961),
    (16416, 16422), (16784, 16790), (17112, 17115), (17368, 17371),
    (17544, 17547), (17808, 17810), (50649, 22228), (50709, 22302),
    (50955, 22526), (18227, 18267), (51176, 22416), (32808, 22813),
    (32846, 22678), (32870, 22552), (342, 347), (33206, 22789), (33316, 22643),
    (705, 724), (840, 842), (33705, 22975), (33994, 22704), (34515, 22636),
    (1863, 1871), (34823, 22599), (2295, 2298), (2414, 2417), (35267, 22771),
    (35298, 22932), (35361, 22960), (2637, 2644), (2681, 2690), (35492, 23019),
    (2798, 2812), (35658, 22586), (35719, 22623), (35788, 22596), (3070, 3073),
    (3201, 3248), (36127, 22710), (36243, 23032), (36335, 22901),
    (36470, 22682), (36511, 22695), (36588, 22967), (4593, 4597), (4663, 4668),
    (4772, 4777), (4906, 4917), (5093, 5107), (5367, 5389), (5733, 5750),
    (6134, 6146), (6576, 6588), (7053, 7065), (7516, 7530), (7960, 7974),
    (8342, 8351), (41470, 22696), (8729, 8734), (9013, 9017), (9281, 9283),
    (9453, 9456), (42372, 22756), (42467, 22804), (42646, 22761),
    (42763, 22794), (10388, 10412), (10467, 10475), (10597, 10609),
    (10835, 10854), (11178, 11202), (11629, 11645), (12165, 12197),
    (12778, 12800), (13473, 13490), (14152, 14173), (14768, 14778),
    (15395, 15403), (15961, 15965), (49190, 22896), (16790, 16794),
    (49883, 22755), (50315, 22897), (17696, 17699), (50785, 22715),
    (18253, 18293), (51453, 22801), (45, 52), (347, 350), (33452, 23124),
    (33478, 23400), (33627, 23317), (884, 905), (33875, 23412), (34080, 23282),
    (34250, 23235), (1533, 1539), (34381, 23109), (34544, 23144), (1864, 1885),
    (1904, 1924), (34821, 23101), (2169, 2177), (2248, 2261), (35134, 23313),
    (35173, 23294), (2509, 2515), (2597, 2603), (2682, 2698), (36082, 23079),
    (36175, 23143), (36316, 23405), (36418, 23440), (36462, 23309),
    (36507, 23280), (36579, 23491), (36845, 23327), (4597, 4601),
    (37436, 23380), (4777, 4779), (4917, 4924), (5107, 5114), (5389, 5398),
    (5743, 5756), (6139, 6162), (6588, 6606), (7065, 7077), (7530, 7539),
    (7974, 7991), (8351, 8361), (8734, 8738), (9017, 9021), (42051, 23352),
    (42224, 23541), (9605, 9609), (42550, 23423), (42764, 23424),
    (10412, 10414), (43243, 23382), (10609, 10611), (10854, 10858),
    (11184, 11203), (11645, 11659), (12197, 12234), (12800, 12834),
    (13490, 13513), (14173, 14194), (14778, 14791), (15403, 15416),
    (15965, 15977), (49191, 23356), (16794, 16797), (49884, 23365),
    (17371, 17373), (17548, 17550), (50467, 23373), (50578, 23374),
    (50788, 23290), (50880, 23426), (18265, 18325), (18420, 18431),
    (51389, 23185), (51435, 23176), (18749, 18760), (32820, 23804),
    (33118, 23706), (33425, 23580), (33499, 23587), (33561, 23797), (899, 924),
    (974, 1013), (33854, 23705), (1896, 1898), (35143, 24001), (2709, 2745),
    (35576, 23646), (35879, 23584), (36065, 23899), (36118, 23852),
    (36155, 23568), (3434, 3441), (3747, 3793), (3871, 3877), (36756, 23895),
    (36837, 23745), (4601, 4624), (4669, 4674), (4779, 4783), (4924, 4927),
    (5114, 5124), (38032, 24033), (5398, 5409), (5756, 5764), (6153, 6176),
    (6606, 6626), (7077, 7085), (7539, 7541), (7991, 7995), (8361, 8365),
    (41506, 23566), (9021, 9027), (42377, 24009), (9700, 9702), (9783, 9785),
    (42605, 24022), (42765, 24027), (10373, 10418), (10476, 10483),
    (10611, 10624), (10858, 10878), (11203, 11225), (11659, 11669),
    (12234, 12251), (12834, 12861), (13513, 13526), (14194, 14210),
    (14791, 14804), (15416, 15429), (48745, 23991), (16424, 16427),
    (49460, 24002), (49565, 24003), (17117, 17119), (17373, 17375),
    (17550, 17552), (50468, 24024), (50579, 23661), (18326, 18347),
    (51161, 23990), (51438, 23708), (33119, 24198), (732, 734), (843, 846),
    (941, 987), (34206, 24312), (1898, 1931), (35052, 24397), (35495, 24412),
    (35881, 24075), (35956, 24497), (36375, 24272), (36589, 24082),
    (36710, 24506), (4611, 4615), (4674, 4679), (4783, 4791), (4927, 4934),
    (5124, 5143), (5409, 5434), (5764, 5781), (6176, 6185), (6626, 6648),
    (39679, 24426), (7085, 7099), (7541, 7549), (7995, 8006), (8365, 8378),
    (41507, 24394), (9027, 9030), (42052, 24413), (42226, 24300),
    (42553, 24398), (42680, 24307), (9999, 10003), (10374, 10422),
    (10483, 10491), (10624, 10651), (10878, 10891), (11225, 11240),
    (11669, 11678), (12251, 12263), (12861, 12867), (13526, 13539),
    (14210, 14226), (14804, 14814), (15429, 15440), (15978, 15982),
    (16427, 16429), (16798, 16800), (17119, 17123), (50143, 24305),
    (50320, 24306), (50470, 24399), (18088, 18133), (51077, 24195),
    (18355, 18393), (51252, 24543), (33120, 24635), (33566, 24866), (991, 998),
    (34278, 25050), (1927, 1943), (34849, 24743), (2426, 2430), (35280, 24844),
    (35682, 24803), (35784, 24808), (35861, 24807), (3278, 3314),
    (36450, 24674), (36522, 24857), (36598, 24880), (3952, 3983), (4047, 4057),
    (5434, 5446), (5781, 5797), (6185, 6201), (6648, 6669), (7099, 7118),
    (7549, 7568), (8006, 8016), (8378, 8397), (8740, 8749), (9030, 9035),
    (42053, 25059), (9459, 9463), (9610, 9612), (9702, 9704), (42554, 25087),
    (43417, 24576), (10891, 10912), (11240, 11259), (11678, 11695),
    (12263, 12284), (12867, 12891), (13539, 13552), (14226, 14246),
    (14814, 14832), (15440, 15452), (15982, 15991), (16429, 16439),
    (49568, 25083), (49891, 25081), (50144, 25085), (50786, 24658),
    (50928, 24650), (51087, 24928), (18402, 18442), (32891, 25281),
    (33334, 25465), (735, 783), (999, 1008), (34123, 25537), (1955, 1963),
    (35914, 25283), (36232, 25574), (3551, 3553), (3616, 3625), (36495, 25390),
    (3794, 3857), (36682, 25218), (3978, 3986), (37383, 25165), (4679, 4683),
    (4791, 4796), (4934, 4941), (5143, 5165), (5446, 5480), (5797, 5815),
    (6201, 6221), (6669, 6701), (7118, 7142), (7568, 7570), (40784, 25130),
    (41165, 25134), (41517, 25136), (9035, 9037), (42054, 25139),
    (42606, 25088), (10422, 10424), (10491, 10501), (10651, 10668),
    (10912, 10928), (11259, 11280), (11695, 11725), (12284, 12315),
    (12891, 12924), (13552, 13588), (14246, 14249), (47600, 25133),
    (17703, 17706), (50754, 25095), (50840, 25311), (18443, 18454), (317, 354),
    (493, 538), (33339, 25724), (33394, 25650), (33504, 25909), (33615, 25995),
    (1008, 1019), (33999, 25831), (1947, 1966), (34797, 25873), (35055, 26068),
    (36210, 26046), (36323, 25904), (36443, 25887), (36541, 25811),
    (4683, 4689), (4796, 4798), (4941, 4946), (5165, 5169), (5481, 5485),
    (5815, 5820), (6221, 6226), (6701, 6718), (7139, 7149), (7570, 7588),
    (8017, 8033), (8398, 8422), (8750, 8765), (9037, 9049), (9287, 9295),
    (9463, 9465), (9612, 9615), (9704, 9707), (42555, 25892), (9839, 9842),
    (42647, 25900), (10003, 10005), (43160, 26081), (10501, 10503),
    (10668, 10674), (10928, 10942), (11280, 11284), (11725, 11731),
    (12315, 12317), (12900, 12937), (13560, 13595), (14249, 14278),
    (14833, 14855), (15452, 15467), (15991, 16001), (16439, 16448),
    (16801, 16810), (17124, 17129), (50145, 25883), (17553, 17557),
    (17706, 17709), (50580, 25901), (17882, 17884), (51080, 25992),
    (18442, 18484), (51565, 25775), (36, 54), (83, 89), (33122, 26622),
    (33571, 26393), (889, 907), (1019, 1026), (33921, 26237), (33989, 26405),
    (34085, 26559), (34511, 26617), (1976, 2016), (34973, 26582),
    (35462, 26266), (35570, 26465), (35776, 26528), (35885, 26398),
    (3189, 3203), (36158, 26294), (36216, 26422), (36365, 26353),
    (36782, 26380), (4689, 4692), (4798, 4803), (4946, 4953), (5169, 5183),
    (5485, 5520), (5820, 5855), (6226, 6253), (39317, 26364), (6718, 6727),
    (39782, 26368), (7149, 7162), (7588, 7597), (8033, 8036), (8422, 8426),
    (8765, 8771), (9049, 9051), (9295, 9297), (9465, 9467), (9615, 9617),
    (42475, 26345), (42610, 26348), (10503, 10511), (10674, 10684),
    (10931, 10968), (11284, 11340), (11731, 11737), (12317, 12324),
    (12937, 12946), (13595, 13605), (46642, 26401), (14278, 14284),
    (14855, 14862), (15467, 15478), (48769, 26322), (16448, 16451),
    (49578, 26334), (17129, 17132), (50477, 26347), (17813, 17815),
    (50839, 26436), (50967, 26199), (18225, 18232), (51171, 26245),
    (18486, 18557), (51486, 26147), (355, 381), (33617, 26905), (1026, 1041),
    (33873, 27042), (34021, 26907), (34111, 26710), (34400, 26760),
    (34517, 26640), (34604, 27089), (34734, 26994), (2017, 2031),
    (35123, 26695), (35190, 26821), (2653, 2655), (35591, 26627),
    (35678, 27018), (35836, 26906), (35870, 26965), (3150, 3153),
    (35971, 26904), (3426, 3444), (3831, 3838), (36640, 27072), (36754, 26626),
    (36804, 27058), (6238, 6262), (6727, 6749), (7162, 7185), (7597, 7616),
    (8036, 8055), (8428, 8440), (11737, 11765), (12324, 12362), (12946, 12994),
    (13605, 13649), (46527, 27011), (14284, 14322), (14865, 14899),
    (50898, 26942), (50926, 26651), (51040, 26790), (51141, 26686),
    (18510, 18550), (51365, 26679), (18693, 18726), (18809, 18828),
    (32852, 27177), (33505, 27514), (33545, 27503), (815, 851), (1042, 1056),
    (34003, 27219), (1283, 1294), (2020, 2035), (34916, 27181), (2192, 2223),
    (35171, 27279), (35315, 27352), (35431, 27162), (2699, 2714),
    (36189, 27139), (36292, 27313), (36620, 27338), (3889, 3902), (4692, 4698),
    (4803, 4805), (4953, 4956), (5183, 5185), (5520, 5524), (5855, 5861),
    (6262, 6265), (6749, 6753), (7185, 7192), (7616, 7622), (8055, 8057),
    (8426, 8446), (8771, 8788), (9051, 9065), (9297, 9308), (9467, 9471),
    (42385, 27372), (9708, 9712), (9788, 9790), (42611, 27408), (42681, 27414),
    (10393, 10395), (43452, 27600), (10968, 10972), (11340, 11347),
    (11765, 11779), (12362, 12371), (12994, 13006), (13649, 13662),
    (14322, 14331), (14862, 14908), (47794, 27510), (15478, 15518),
    (16002, 16027), (16451, 16464), (16811, 16826), (17132, 17140),
    (17378, 17383), (17557, 17560), (17710, 17714), (50583, 27411),
    (17884, 17888), (50755, 27422), (51124, 27274), (18528, 18576),
    (51510, 27180), (33125, 27982), (33360, 27709), (738, 740), (33554, 28158),
    (33620, 27903), (1056, 1066), (33996, 27775), (1467, 1505), (34580, 28018),
    (34648, 27909), (2045, 2057), (35074, 27736), (2620, 2624), (35488, 27871),
    (35537, 27810), (36091, 28047), (36141, 27705), (36463, 27826),
    (36534, 27722), (36646, 27697), (3922, 3928), (36809, 28089), (4698, 4700),
    (4805, 4811), (4956, 4968), (5185, 5212), (5524, 5558), (5861, 5886),
    (6265, 6292), (6753, 6792), (7192, 7195), (40825, 27699), (41556, 27653),
    (41833, 27656), (10395, 10429), (10511, 10520), (10685, 10706),
    (10972, 11006), (11347, 11380), (11779, 11817), (12371, 12411),
    (13006, 13008), (14905, 14909), (15518, 15521), (48795, 27657),
    (49232, 27659), (49594, 27660), (50328, 27661), (18156, 18201),
    (51014, 27758), (51057, 28017), (18576, 18603), (33089, 28381),
    (33177, 28314), (33676, 28247), (1066, 1083), (34265, 28662),
    (34576, 28278), (2046, 2055), (2307, 2312), (2492, 2494), (2617, 2629),
    (35441, 28439), (36056, 28598), (3382, 3420), (36291, 28502), (6764, 6778),
    (7195, 7230), (7622, 7644), (8058, 8087), (8446, 8467), (8789, 8803),
    (9066, 9081), (9310, 9313), (12376, 12384), (13008, 13055), (13662, 13702),
    (14331, 14375), (14909, 14949), (15521, 15550), (16028, 16042),
    (16472, 16478), (50859, 28379), (50917, 28377), (51042, 28249),
    (18457, 18470), (51288, 28240), (51334, 28341), (18603, 18641),
    (51467, 28477), (51602, 28202), (32892, 28782), (33126, 28860),
    (33422, 28992), (33508, 28780), (792, 803), (33592, 28749), (33693, 29015),
    (1085, 1119), (33938, 28981), (34147, 29052), (34176, 28764),
    (34249, 28815), (34300, 28789), (34448, 29047), (1702, 1708),
    (34599, 29068), (34658, 28933), (2058, 2062), (2288, 2290), (2494, 2507),
    (2560, 2575), (2614, 2623), (35415, 28926), (2692, 2718), (35510, 28675),
    (35530, 29173), (2795, 2814), (2856, 2875), (35680, 28917), (35848, 29043),
    (3137, 3150), (36023, 29041), (36055, 29009), (36099, 29151),
    (36171, 29101), (36276, 29090), (36388, 29174), (36456, 29091),
    (36666, 29050), (4046, 4051), (37468, 28779), (37736, 28784), (5212, 5216),
    (5558, 5563), (5886, 5895), (6292, 6298), (6792, 6797), (7230, 7238),
    (7644, 7659), (8087, 8093), (8467, 8471), (8803, 8815), (9081, 9090),
    (9308, 9319), (9471, 9478), (9618, 9621), (42480, 28748), (9790, 9792),
    (42648, 28766), (9914, 9929), (43288, 28785), (10706, 10708),
    (11006, 11017), (11380, 11389), (11817, 11836), (12411, 12431),
    (13055, 13069), (13702, 13725), (14375, 14386), (14949, 14966),
    (15534, 15568), (16042, 16049), (16465, 16484), (16827, 16840),
    (17140, 17155), (17383, 17390), (17561, 17565), (17714, 17716),
    (17816, 17820), (50656, 28770), (50710, 28774), (17962, 17964),
    (18008, 18010), (50932, 29149), (50965, 28793), (51015, 28811),
    (18652, 18682), (32799, 29221), (32861, 29636), (741, 744), (33572, 29626),
    (854, 857), (33803, 29276), (1676, 1699), (1843, 1850), (2062, 2065),
    (34908, 29648), (35137, 29689), (2540, 2564), (2745, 2765), (2864, 2880),
    (35962, 29185), (36012, 29193), (36255, 29327), (3648, 3668),
    (36480, 29556), (36626, 29519), (3934, 3938), (3962, 3967), (4701, 4709),
    (4811, 4814), (4969, 4971), (5216, 5222), (5563, 5579), (5895, 5909),
    (6298, 6312), (6797, 6811), (7238, 7245), (7659, 7665), (8093, 8098),
    (8471, 8475), (41583, 29544), (9090, 9094), (9319, 9321), (9478, 9484),
    (9621, 9623), (9713, 9715), (42560, 29568), (42716, 29224), (43164, 29247),
    (10429, 10432), (10521, 10525), (10708, 10721), (11017, 11036),
    (11389, 11421), (11836, 11865), (12431, 12460), (13069, 13089),
    (13725, 13738), (14386, 14395), (14966, 14979), (15568, 15577),
    (16049, 16052), (16482, 16485), (16840, 16850), (17155, 17160),
    (17390, 17394), (17565, 17569), (17716, 17720), (50588, 29219),
    (17889, 17891), (17988, 17999), (50829, 29679), (18159, 18183),
    (51097, 29646), (18682, 18736), (56, 58), (86, 96), (33127, 30005),
    (33145, 29713), (33179, 29977), (33579, 29698), (33628, 29881),
    (33935, 29837), (34322, 29724), (1838, 1843), (1881, 1889), (34781, 29904),
    (2070, 2100), (2126, 2128), (2335, 2352), (2542, 2559), (35399, 30033),
    (2771, 2788), (35650, 30048), (36124, 30011), (36368, 30004),
    (36407, 30129), (36520, 30201), (36607, 30022), (36623, 30074),
    (3929, 3939), (4010, 4045), (37039, 29929), (4814, 4825), (5222, 5226),
    (5579, 5583), (5909, 5920), (6307, 6327), (6806, 6827), (7245, 7268),
    (7665, 7686), (8098, 8105), (8475, 8481), (8816, 8824), (9094, 9098),
    (9321, 9324), (9484, 9489), (42391, 29903), (9715, 9717), (9793, 9795),
    (42612, 29914), (42773, 30098), (43293, 29994), (10721, 10725),
    (11036, 11043), (11421, 11428), (11865, 11880), (12449, 12470),
    (13089, 13116), (13738, 13774), (14395, 14407), (14979, 14992),
    (15577, 15586), (16052, 16066), (16485, 16495), (16850, 16855),
    (49928, 29882), (50162, 29975), (17569, 17573), (17821, 17823),
    (50985, 29719), (51069, 29797), (51186, 29860), (51385, 29779),
    (18714, 18773), (33254, 30586), (828, 832), (1357, 1371), (34468, 30578),
    (2096, 2122), (35064, 30659), (2767, 2811), (35964, 30679), (3577, 3581),
    (36404, 30310), (3738, 3749), (36632, 30422), (3924, 3954), (4001, 4033),
    (4825, 4832), (37739, 30334), (5226, 5229), (5583, 5589), (5920, 5937),
    (6327, 6337), (6827, 6837), (7268, 7276), (7677, 7701), (8105, 8116),
    (8481, 8496), (8824, 8833), (9098, 9109), (9324, 9331), (9489, 9492),
    (9624, 9626), (9717, 9719), (9795, 9797), (9881, 9883), (42697, 30682),
    (42774, 30326), (43294, 30335), (43493, 30337), (11043, 11054),
    (11428, 11440), (11880, 11894), (12470, 12484), (13116, 13130),
    (13761, 13789), (14407, 14424), (14992, 15009), (15586, 15607),
    (16066, 16081), (16495, 16507), (16855, 16860), (17161, 17170),
    (17395, 17397), (17573, 17575), (17720, 17722), (50591, 30677),
    (17891, 17893), (50772, 30325), (50941, 30694), (51271, 30661),
    (18773, 18806), (32849, 31184), (388, 418), (33514, 31035), (33578, 30948),
    (33677, 31178), (33960, 31030), (34064, 31064), (34280, 30965),
    (34455, 31135), (34755, 30958), (34825, 30786), (2136, 2176),
    (35187, 30788), (2466, 2487), (35350, 31172), (2812, 2829), (3347, 3418),
    (36234, 30728), (36358, 31074), (36509, 30842), (3921, 3932),
    (36763, 30982), (4832, 4834), (5229, 5232), (5589, 5594), (5937, 5950),
    (6337, 6364), (6837, 6844), (7276, 7279), (7701, 7716), (8116, 8125),
    (8496, 8504), (8833, 8838), (9109, 9116), (9331, 9333), (9492, 9494),
    (9626, 9630), (42565, 31155), (43200, 31160), (43494, 31037),
    (11054, 11057), (11440, 11460), (11894, 11923), (12484, 12505),
    (13130, 13147), (13789, 13808), (14424, 14448), (15009, 15025),
    (15607, 15620), (16081, 16093), (16507, 16517), (16860, 16867),
    (17170, 17177), (17397, 17400), (17575, 17577), (17824, 17827),
    (50661, 31033), (50782, 30849), (50838, 30780), (51002, 30961),
    (51178, 31089), (51387, 31180), (18810, 18840), (65, 111), (33149, 31433),
    (33477, 31666), (33588, 31274), (864, 866), (1108, 1146), (34142, 31465),
    (34188, 31463), (1674, 1702), (2150, 2179), (2213, 2218), (2830, 2869),
    (35802, 31363), (35831, 31432), (3333, 3340), (36184, 31555),
    (36248, 31569), (3790, 3805), (3899, 3921), (36774, 31277), (4834, 4836),
    (37740, 31481), (38000, 31350), (5594, 5597), (5950, 5954), (6364, 6369),
    (6844, 6854), (6995, 6997), (7279, 7298), (7716, 7729), (8125, 8142),
    (8504, 8521), (8838, 8852), (9116, 9124), (9333, 9338), (9494, 9496),
    (9630, 9632), (42613, 31434), (43295, 31349), (11057, 11060),
    (11460, 11465), (11923, 11941), (12505, 12527), (13147, 13164),
    (13808, 13836), (14448, 14474), (15027, 15040), (15620, 15644),
    (16093, 16121), (49285, 31327), (16867, 16869), (17177, 17181),
    (17577, 17579), (32807, 32149), (378, 380), (33515, 31993), (839, 867),
    (1146, 1180), (34231, 31916), (2180, 2201), (35301, 32168), (35352, 32254),
    (2730, 2747), (2845, 2862), (36381, 32090), (36496, 32037), (3768, 3803),
    (36627, 31856), (36736, 31825), (4003, 4010), (4973, 4975), (38001, 31995),
    (38365, 31998), (5954, 5962), (6369, 6384), (6854, 6871), (7299, 7313),
    (7729, 7738), (8142, 8164), (8521, 8538), (8845, 8854), (9118, 9131),
    (9338, 9345), (9496, 9502), (9632, 9637), (42487, 31824), (9798, 9800),
    (9846, 9849), (9915, 9917), (42721, 31858), (11060, 11062), (11465, 11474),
    (11941, 11959), (12527, 12546), (13164, 13185), (13836, 13855),
    (14474, 14502), (47576, 32243), (15040, 15058), (15644, 15649),
    (16102, 16124), (16518, 16530), (16869, 16876), (17181, 17187),
    (17400, 17403), (17579, 17586), (17722, 17724), (50595, 31850),
    (17894, 17897), (17943, 17965), (50787, 31911), (50909, 31765), (360, 368),
    (33372, 32659), (745, 749), (867, 908), (1162, 1205), (2194, 2213),
    (2723, 2751), (2862, 2864), (35967, 32391), (3502, 3566), (36457, 32398),
    (36671, 32632), (36821, 32625), (4975, 4978), (38002, 32597), (5598, 5601),
    (5962, 5965), (6384, 6389), (6871, 6877), (7314, 7316), (7738, 7745),
    (8164, 8168), (8538, 8542), (8854, 8868), (9131, 9151), (9345, 9355),
    (9502, 9512), (9638, 9642), (9720, 9723), (9849, 9886), (42703, 32412),
    (43296, 32593), (11474, 11478), (44590, 32569), (11959, 11970),
    (12546, 12559), (13185, 13193), (13855, 13865), (14502, 14507),
    (15050, 15068), (15649, 15674), (16124, 16147), (49166, 32757),
    (16530, 16545), (16876, 16893), (17187, 17193), (17403, 17411),
    (17586, 17589), (50492, 32405), (17828, 17830), (17897, 17901),
    (51364, 32655), (390, 398), (33331, 33194), (655, 660), (753, 755),
    (33706, 33132), (1206, 1226), (34680, 33066), (2233, 2238), (35533, 33270),
    (2866, 2900), (3574, 3645), (4007, 4028), (4978, 4991), (5235, 5242),
    (5602, 5614), (5965, 5983), (6389, 6412), (6877, 6887), (7316, 7330),
    (7745, 7759), (8168, 8180), (8542, 8549), (8869, 8873), (9151, 9166),
    (9355, 9359), (42280, 33240), (9642, 9644), (9800, 9853), (43201, 32906),
    (10727, 10733), (11062, 11069), (11478, 11502), (44539, 32898),
    (11970, 11980), (12559, 12578), (13193, 13211), (13865, 13881),
    (14507, 14517), (15068, 15077), (15674, 15690), (16147, 16156),
    (16545, 16549), (16893, 16896), (17193, 17196), (17411, 17413),
    (50357, 33246), (17901, 17903), (51549, 33263), (368, 371), (33178, 33342),
    (33414, 33476), (868, 896), (33902, 33692), (1233, 1304), (2241, 2243),
    (2675, 2678), (35604, 33401), (2900, 2909), (35928, 33533), (36120, 33743),
    (36172, 33638), (36352, 33527), (36419, 33547), (36472, 33325),
    (36636, 33726), (36781, 33306), (4991, 4997), (5242, 5246), (5614, 5631),
    (5983, 6006), (6412, 6437), (6887, 6910), (7330, 7358), (7759, 7761),
    (8180, 8184), (8873, 8876), (9166, 9168), (42127, 33290), (42412, 33382),
    (42660, 33399), (10529, 10534), (10733, 10742), (11069, 11091),
    (43916, 33549), (11502, 11529), (11980, 12017), (12578, 12619),
    (13211, 13267), (13881, 13919), (47285, 33301), (15077, 15084),
    (15690, 15693), (16156, 16159), (16549, 16551), (16896, 16899),
    (17196, 17199), (50358, 33387), (50493, 33388), (50598, 33389),
    (50836, 33518), (50897, 33741), (18347, 18353), (51315, 33635),
    (51349, 33318), (51505, 33721), (32822, 34195), (32841, 33924),
    (32885, 34052), (869, 877), (33661, 34262), (1138, 1145), (1245, 1257),
    (1284, 1322), (34439, 33919), (1729, 1733), (34914, 33942), (34997, 33920),
    (35012, 33875), (35045, 33955), (35096, 34021), (35160, 33812),
    (2452, 2463), (35292, 33906), (35434, 33854), (35499, 33830),
    (35588, 33864), (2911, 2927), (35895, 33965), (36355, 33816),
    (36413, 33820), (36490, 33884), (36802, 34010), (7333, 7356),
    (40482, 33836), (7761, 7778), (8184, 8200), (8549, 8564), (8876, 8886),
    (9168, 9179), (9360, 9369), (9513, 9520), (9645, 9649), (13219, 13265),
    (13887, 13944), (14518, 14558), (15084, 15134), (15693, 15724),
    (16159, 16194), (16551, 16573), (16899, 16920), (17200, 17211),
    (50827, 34124), (50867, 33814), (50910, 34114), (51047, 34053),
    (51190, 33828), (18608, 18614), (51558, 33890), (32845, 34323),
    (33586, 34319), (1318, 1343), (34294, 34370), (34692, 34324), (2220, 2256),
    (2928, 2934), (35872, 34725), (36337, 34672), (36410, 34694),
    (36545, 34477), (3928, 3959), (4025, 4043), (37765, 34411), (5631, 5633),
    (6006, 6010), (6437, 6446), (6910, 6922), (7358, 7367), (7778, 7792),
    (8200, 8210), (8564, 8575), (8886, 8891), (9179, 9190), (9369, 9373),
    (9520, 9525), (9647, 9653), (9723, 9726), (9853, 9855), (43302, 34381),
    (11091, 11095), (11529, 11533), (12017, 12041), (12619, 12639),
    (13267, 13282), (13944, 13959), (14558, 14591), (15134, 15167),
    (15724, 15748), (16194, 16220), (16569, 16597), (16921, 16932),
    (17199, 17210), (17413, 17427), (17591, 17597), (17726, 17733),
    (50599, 34371), (17903, 17906), (17965, 18000), (50881, 34685),
    (50912, 34317), (32853, 34973), (33139, 35270), (758, 760), (33558, 34959),
    (33639, 34960), (1340, 1395), (34694, 34912), (2258, 2270), (35565, 35200),
    (2936, 2941), (35932, 35237), (36094, 35191), (3357, 3394), (3641, 3644),
    (36637, 34882), (36670, 34840), (36711, 34976), (4012, 4022), (4998, 5002),
    (5246, 5248), (38402, 34920), (6010, 6014), (6446, 6452), (6922, 6932),
    (7367, 7373), (7792, 7805), (8210, 8219), (8575, 8583), (8891, 8898),
    (9190, 9196), (9373, 9376), (9521, 9529), (9653, 9658), (9726, 9733),
    (9803, 9806), (42623, 34865), (9886, 9919), (43303, 35198), (11533, 11539),
    (12041, 12055), (12639, 12663), (13282, 13304), (13959, 13978),
    (14591, 14611), (15167, 15186), (15748, 15762), (16220, 16233),
    (16593, 16605), (16920, 16947), (17211, 17221), (17427, 17440),
    (17597, 17606), (50469, 34863), (17733, 17741), (17832, 17836),
    (17906, 17911), (17944, 17969), (50784, 35023), (18821, 18827),
    (32873, 35727), (372, 374), (33529, 35744), (33629, 35715), (919, 935),
    (1369, 1392), (34555, 35546), (2281, 2283), (2329, 2368), (2942, 2946),
    (35899, 35713), (36006, 35678), (3294, 3303), (3923, 3950), (4029, 4032),
    (38016, 35328), (6014, 6017), (6452, 6463), (6932, 6941), (7373, 7387),
    (7805, 7825), (8219, 8234), (8583, 8600), (8899, 8915), (9196, 9205),
    (9376, 9380), (9529, 9538), (9658, 9664), (9733, 9736), (42574, 35712),
    (9856, 9937), (11539, 11541), (44823, 35346), (12663, 12667),
    (13304, 13319), (13978, 13991), (14611, 14617), (15186, 15203),
    (15762, 15779), (16233, 16250), (16605, 16625), (16947, 16960),
    (17221, 17229), (17440, 17445), (17606, 17612), (17741, 17745),
    (17836, 17838), (17911, 17913), (17969, 18001), (33160, 36107),
    (33337, 36288), (33530, 36125), (1395, 1414), (34590, 36218), (2292, 2294),
    (2946, 2953), (3576, 3620), (3884, 3962), (4030, 4038), (5249, 5256),
    (6017, 6022), (6463, 6468), (6941, 6953), (7387, 7412), (7825, 7845),
    (8234, 8244), (8600, 8617), (8915, 8919), (9205, 9214), (9380, 9382),
    (9538, 9540), (9664, 9666), (42504, 36115), (9807, 9809), (9893, 9946),
    (43510, 35960), (43863, 35926), (44309, 36210), (12056, 12066),
    (12667, 12681), (13319, 13342), (13991, 14025), (14617, 14635),
    (15203, 15217), (15779, 15791), (16250, 16259), (16625, 16634),
    (16960, 16971), (49997, 36270), (17445, 17448), (50380, 36117),
    (17745, 17747), (17945, 17971), (374, 377), (481, 500), (33308, 36456),
    (33568, 36775), (873, 876), (1421, 1441), (34260, 36540), (2300, 2305),
    (35408, 36673), (2829, 2856), (2955, 2971), (35821, 36790), (35934, 36768),
    (36019, 36570), (36067, 36662), (3477, 3548), (36405, 36397),
    (36592, 36700), (3907, 3918), (36758, 36826), (5256, 5264), (5635, 5639),
    (6022, 6033), (6469, 6484), (6953, 6955), (7412, 7416), (7845, 7852),
    (8244, 8249), (8617, 8636), (8919, 8931), (9214, 9223), (9382, 9391),
    (9540, 9550), (42405, 36782), (9666, 9670), (9737, 9742), (9809, 9812),
    (9919, 9938), (42775, 36789), (10743, 10745), (11096, 11103),
    (11542, 11546), (12066, 12076), (12681, 12688), (13342, 13358),
    (14025, 14033), (14624, 14641), (15217, 15244), (15791, 15810),
    (16259, 16267), (16634, 16652), (16971, 16984), (17230, 17239),
    (17448, 17453), (17613, 17622), (17747, 17750), (17838, 17842),
    (17913, 17916), (17946, 17991), (51588, 36792), (32859, 36934),
    (33091, 37343), (387, 390), (33431, 37302), (33569, 37366), (34139, 37374),
    (1447, 1463), (34877, 37370), (2316, 2321), (35150, 37349), (35249, 36964),
    (35529, 36972), (35739, 36915), (3264, 3292), (36105, 37124),
    (36279, 36882), (36389, 37238), (36428, 37232), (36500, 36872),
    (36557, 36940), (3844, 3891), (5265, 5273), (5639, 5645), (6033, 6040),
    (6474, 6496), (6955, 6982), (7416, 7429), (7852, 7873), (8249, 8265),
    (8636, 8649), (8931, 8939), (9223, 9233), (9391, 9397), (9550, 9554),
    (9670, 9672), (42510, 37306), (42580, 37192), (9857, 9859), (9894, 9939),
    (10536, 10541), (10745, 10751), (11103, 11108), (11546, 11557),
    (12070, 12094), (12688, 12721), (13358, 13391), (46321, 37224),
    (14034, 14049), (14641, 14655), (15244, 15263), (15810, 15823),
    (16267, 16278), (16652, 16661), (16984, 16988), (17239, 17246),
    (17453, 17457), (50390, 37191), (50518, 37308), (17842, 17845),
    (50715, 37315), (51167, 37334), (32848, 37400), (33595, 37876),
    (33646, 37409), (1424, 1431), (1466, 1491), (34350, 37752), (1690, 1696),
    (1763, 1766), (34597, 37742), (1856, 1872), (1887, 1895), (2037, 2042),
    (34853, 37767), (34879, 37698), (34902, 37639), (34923, 37429),
    (35053, 37419), (2360, 2391), (35181, 37757), (2472, 2478), (2520, 2522),
    (35307, 37605), (2562, 2570), (2601, 2606), (35406, 37486), (35461, 37776),
    (2975, 2991), (3367, 3371), (36193, 37823), (36235, 37461), (36349, 37701),
    (36430, 37384), (7429, 7438), (7873, 7890), (8265, 8276), (8649, 8662),
    (8939, 8955), (9233, 9247), (9397, 9408), (9554, 9568), (42442, 37885),
    (13379, 13401), (14049, 14080), (14655, 14690), (15263, 15296),
    (15823, 15863), (16278, 16311), (16661, 16686), (16988, 17010),
    (17248, 17273), (18056, 18067), (51037, 37843), (51158, 37696),
    (51289, 37436), (51399, 37872), (18673, 18689), (51509, 37873),
    (51529, 37765), (32843, 37935), (33412, 38314), (763, 784), (33955, 37996),
    (1491, 1542), (34428, 37924), (34660, 37896), (34812, 37991), (2321, 2334),
    (35192, 37976), (35246, 37965), (35357, 37889), (2994, 3074),
    (36079, 37989), (36142, 38047), (36274, 38215), (5645, 5647),
    (38808, 38274), (39264, 38275), (39750, 38281), (7438, 7445),
    (40658, 38296), (8276, 8282), (8662, 8664), (41723, 38331), (9247, 9252),
    (9408, 9412), (42336, 38364), (9672, 9676), (9743, 9751), (9813, 9947),
    (12721, 12724), (13401, 13405), (14080, 14084), (15296, 15301),
    (15863, 15872), (16311, 16317), (16686, 16689), (17010, 17013),
    (17246, 17278), (17457, 17473), (17623, 17633), (17751, 17756),
    (17845, 17848), (17916, 18002), (51142, 37915), (51232, 38011),
    (18683, 18687), (32811, 38708), (32847, 38730), (33494, 38737), (768, 782),
    (33591, 38741), (1505, 1558), (34438, 38898), (34625, 38644), (2342, 2373),
    (2909, 2933), (3006, 3014), (35936, 38840), (36090, 38486), (36385, 38765),
    (36554, 38659), (3822, 3846), (3963, 3998), (37770, 38433), (5273, 5278),
    (5647, 5657), (6041, 6050), (6497, 6506), (6983, 6995), (7445, 7462),
    (7891, 7905), (8282, 8291), (8664, 8672), (8956, 8970), (9252, 9259),
    (9412, 9422), (9569, 9576), (42444, 38704), (9751, 9754), (9816, 9820),
    (42630, 38760), (9896, 9933), (43202, 38430), (10541, 10545),
    (10751, 10755), (11108, 11113), (11557, 11563), (12094, 12097),
    (12724, 12731), (13405, 13419), (14084, 14097), (14690, 14706),
    (15301, 15313), (15872, 15882), (16317, 16333), (16689, 16712),
    (17013, 17025), (17278, 17284), (17473, 17477), (17633, 17635),
    (17756, 17758), (17848, 17854), (50689, 38729), (50741, 38731),
    (51004, 38791), (51155, 38845), (51581, 38565), (523, 565), (769, 773),
    (877, 889), (33707, 38998), (33962, 39393), (1561, 1589), (34436, 39352),
    (2219, 2240), (2373, 2411), (2972, 2975), (3017, 3031), (35938, 38983),
    (36008, 39382), (36206, 38947), (3827, 3842), (3893, 3895), (36737, 39242),
    (6050, 6056), (6506, 6508), (6997, 6999), (7462, 7473), (7905, 7918),
    (8291, 8300), (8672, 8688), (8970, 8986), (9259, 9264), (9422, 9433),
    (9576, 9582), (9677, 9681), (9755, 9758), (9820, 9925), (44865, 39139),
    (12731, 12734), (13419, 13422), (14097, 14107), (14706, 14721),
    (15313, 15341), (15882, 15899), (48896, 38984), (16333, 16363),
    (16712, 16719), (17025, 17038), (17284, 17296), (17477, 17483),
    (17635, 17640), (50526, 38912), (17922, 17924), (17974, 17979),
    (50865, 39020), (51227, 38932), (51273, 39332), (414, 416), (33281, 39602),
    (33419, 39606), (33484, 39821), (1589, 1619), (2221, 2228), (35081, 39913),
    (2400, 2407), (2435, 2439), (3032, 3040), (35939, 39613), (36110, 39462),
    (36483, 39917), (3746, 3806), (3865, 3896), (3954, 3965), (6508, 6513),
    (39767, 39770), (40686, 39649), (8300, 8305), (8688, 8696), (8986, 8992),
    (9262, 9268), (9433, 9445), (9582, 9589), (9681, 9685), (9758, 9765),
    (9822, 9826), (9865, 9871), (9901, 9951), (12098, 12100), (14107, 14110),
    (14721, 14729), (15341, 15359), (15899, 15922), (16352, 16382),
    (16719, 16751), (17038, 17074), (17296, 17318), (17483, 17498),
    (17640, 17656), (17759, 17764), (17854, 17857), (17952, 18006),
    (51361, 39811), (33090, 40270), (33168, 40393), (33290, 40302),
    (33418, 39974), (33483, 39967), (33542, 40060), (1617, 1640),
    (35059, 40301), (2430, 2452), (35269, 40214), (3041, 3052), (35871, 39983),
    (36108, 40432), (3575, 3579), (36395, 40050), (3674, 3691), (3767, 3835),
    (36723, 40260), (39768, 40165), (40687, 40169), (8305, 8308), (8696, 8699),
    (8992, 8998), (9268, 9270), (9445, 9448), (9589, 9594), (9685, 9687),
    (9765, 9771), (9826, 9832), (9871, 9944), (46190, 40166), (14110, 14113),
    (14729, 14732), (15359, 15371), (15922, 15934), (16382, 16400),
    (16751, 16766), (17074, 17100), (17312, 17349), (17498, 17530),
    (17656, 17685), (17764, 17793), (17857, 17874), (17924, 17957),
    (18002, 18007), (50886, 40244), (66, 75), (96, 126), (398, 417),
    (33481, 40743), (775, 789), (830, 838), (870, 880), (902, 925),
    (33718, 40883), (33782, 40863), (33842, 40831), (1631, 1676),
    (35212, 40472), (35761, 40639), (3046, 3065), (36380, 40619),
    (36518, 40581), (3788, 3814), (3891, 3927), (36741, 40598), (4079, 4081),
    (7001, 7005), (7473, 7476), (7920, 7924), (8308, 8311), (8699, 8704),
    (8998, 9002), (9270, 9278), (9448, 9458), (9594, 9598), (9687, 9694),
    (9771, 9777), (9832, 9836), (9875, 9877), (9907, 9953), (10268, 10271),
    (46191, 40697), (14113, 14115), (47500, 40615), (15371, 15375),
    (15934, 15944), (16400, 16413), (16766, 16779), (17100, 17111),
    (17349, 17364), (17530, 17543), (17685, 17694), (17793, 17808),
    (17863, 17881), (17927, 17962), (17983, 18014), (33546, 63751),
    (43140, 64012), (46424, 64013), (4083, 4400), (10021, 10023),
    (10312, 10316), (50822, 65517), (162, 177), (33314, 425), (727, 933),
    (33967, 104), (1777, 1939), (2166, 2207), (35833, 148), (36114, 33),
    (36647, 498), (36841, 238), (10263, 10266), (18376, 18445), (33248, 833),
    (33704, 569), (33863, 805), (34286, 628), (1772, 1853), (2159, 2175),
    (2475, 2736), (3066, 3068), (35968, 838), (36625, 1020), (18075, 18108),
    (18317, 18401), (18546, 18569), (420, 553), (1771, 1887), (34837, 1515),
    (35333, 1278), (3071, 3222), (36505, 1166), (18055, 18115), (51090, 1445),
    (51496, 1475), (33311, 1841), (34336, 1584), (34592, 1806), (2578, 2739),
    (3076, 3251), (51196, 1622), (33162, 2535), (1827, 2215), (35505, 2261),
    (36476, 2425), (50919, 2388), (51329, 2339), (32838, 2698), (33388, 2985),
    (819, 943), (34008, 2829), (34200, 2640), (1761, 1855), (2579, 2608),
    (3081, 3089), (36103, 2577), (18105, 18191), (474, 672), (34244, 3377),
    (34601, 3104), (2157, 2168), (2576, 2581), (35625, 3279), (3089, 3102),
    (36014, 3192), (3514, 3632), (3778, 3782), (36635, 3284), (18195, 18361),
    (51360, 3378), (51479, 3130), (495, 698), (33866, 3800), (34027, 3606),
    (1760, 1838), (35142, 3878), (35291, 3869), (3105, 3113), (36144, 3832),
    (3546, 3741), (36766, 3899), (50977, 3805), (51261, 3701), (315, 699),
    (34183, 4116), (34603, 4324), (3114, 3126), (3615, 3688), (50994, 4276),
    (34269, 4732), (1725, 1890), (35183, 4866), (2613, 2716), (3128, 3131),
    (3402, 3432), (36527, 4777), (36833, 4862), (50845, 4869), (18243, 18455),
    (51575, 4982), (33448, 5205), (33649, 5183), (1232, 1325), (34496, 5302),
    (2418, 2647), (35900, 5495), (18171, 18255), (51396, 5271), (1178, 1261),
    (34160, 5855), (34345, 5843), (1706, 1723), (1866, 1923), (34752, 5884),
    (2153, 2189), (35080, 6106), (2487, 2586), (2676, 2730), (35846, 5818),
    (3133, 3136), (3381, 3399), (3531, 3554), (36539, 5996), (36608, 5997),
    (18157, 18209), (18275, 18309), (51133, 6001), (18446, 18456),
    (51484, 5863), (51572, 5825), (33470, 6202), (33576, 6528), (34002, 6238),
    (34098, 6306), (34174, 6416), (34291, 6421), (1614, 1749), (34581, 6276),
    (1876, 2029), (34881, 6244), (2250, 2291), (2522, 2605), (35454, 6405),
    (3138, 3140), (36069, 6428), (36152, 6176), (36322, 6267), (36714, 6203),
    (36832, 6468), (18067, 18112), (50989, 6359), (18290, 18307),
    (51172, 6263), (51249, 6185), (51337, 6488), (18751, 18754), (32801, 6755),
    (33492, 7105), (3043, 3142), (18320, 18328), (51526, 6731), (46, 60),
    (33187, 7626), (33610, 7606), (1914, 2002), (3142, 3286), (3668, 3788),
    (36762, 7494), (18331, 18340), (32937, 8168), (33696, 7715), (34233, 7817),
    (35508, 8094), (3145, 3453), (36552, 7951), (18340, 18499), (51561, 7708),
    (541, 587), (826, 945), (34402, 8539), (3151, 3369), (50874, 8444),
    (18350, 18352), (51319, 8490), (33366, 8712), (34212, 8997), (2308, 2653),
    (3154, 3157), (51151, 9168), (111, 116), (1932, 1934), (3361, 3519),
    (36479, 9317), (36718, 9499), (18079, 18109), (18304, 18596), (568, 674),
    (846, 914), (1216, 1228), (34267, 9850), (1929, 1940), (34938, 9973),
    (2420, 2428), (3157, 3311), (36422, 9972), (50981, 9880), (18398, 18410),
    (51333, 10189), (51592, 9756), (606, 608), (34696, 10336), (35196, 10603),
    (3158, 3380), (18432, 18505), (51499, 10413), (421, 631), (1949, 1952),
    (3163, 3170), (36394, 11075), (478, 684), (34105, 11303), (1943, 1964),
    (35296, 11302), (3172, 3181), (3610, 3677), (50961, 11683), (33365, 11915),
    (34055, 12015), (34722, 11896), (35418, 12259), (3181, 3629),
    (18448, 18459), (32837, 12778), (33486, 12605), (34030, 12669),
    (1543, 1610), (1968, 1994), (35256, 12745), (3184, 3186), (36523, 12506),
    (18475, 18698), (32839, 12894), (33396, 13300), (805, 913), (1439, 1525),
    (1969, 2013), (34886, 12850), (35109, 12837), (2661, 2735), (3186, 3278),
    (36200, 12847), (36752, 13301), (18103, 18111), (50997, 12938),
    (18499, 18524), (51568, 12972), (32886, 13755), (33690, 13649),
    (1249, 1272), (1709, 1953), (2207, 2224), (35235, 13724), (35424, 13541),
    (3192, 3352), (18485, 18533), (17, 102), (33969, 14182), (1730, 1752),
    (2009, 2124), (2464, 2469), (2658, 2665), (3197, 3199), (36168, 14127),
    (3573, 3727), (36840, 13943), (18083, 18132), (18511, 18554),
    (33348, 14786), (34776, 14394), (33686, 15130), (34670, 15086),
    (2733, 3205), (18567, 18573), (33619, 15459), (1219, 1474), (34804, 15514),
    (34928, 15802), (35025, 15759), (35189, 15800), (2531, 2600),
    (35995, 15615), (3539, 3569), (3663, 3724), (36629, 15613), (36828, 15559),
    (18069, 18116), (18583, 18590), (34, 36), (1080, 1100), (34035, 16011),
    (34144, 16271), (34270, 15918), (1735, 1815), (2035, 2150), (35117, 16366),
    (2625, 2701), (3207, 3306), (36214, 16257), (36317, 16008), (3729, 3731),
    (50826, 16325), (18150, 18193), (51199, 16311), (18574, 18646),
    (32835, 16737), (703, 792), (33695, 16620), (33941, 16471), (34337, 16732),
    (1752, 1755), (1846, 1851), (34820, 16444), (2443, 2506), (35455, 16892),
    (3213, 3218), (36183, 16762), (36424, 16803), (36811, 16401),
    (18222, 18246), (18460, 18747), (32784, 17087), (1616, 1705), (1832, 2061),
    (2286, 2371), (2527, 2530), (2648, 2719), (3215, 3220), (36524, 17394),
    (18255, 18269), (51275, 17308), (18664, 18675), (505, 552), (33623, 17669),
    (33922, 17784), (1697, 1770), (34791, 17543), (35284, 17544), (2702, 2711),
    (3228, 3319), (18224, 18360), (51444, 17498), (1945, 2123), (3231, 3234),
    (3649, 3702), (33469, 18906), (33512, 18665), (33662, 18811),
    (33919, 18562), (34016, 18855), (34184, 18826), (1678, 1682),
    (34501, 18836), (34602, 18860), (1960, 1971), (2047, 2226), (2315, 2348),
    (35185, 18872), (2470, 2490), (2536, 2593), (35531, 18674), (35963, 18874),
    (3241, 3322), (36140, 18896), (36209, 18824), (36529, 18787),
    (36576, 18750), (36631, 18713), (18064, 18101), (51065, 18857),
    (51117, 18689), (18415, 18417), (18450, 18478), (18578, 18606),
    (18692, 18723), (33626, 18963), (33737, 19215), (1236, 1238),
    (34156, 19066), (1522, 1532), (34352, 18985), (1683, 1725), (34562, 18958),
    (34613, 19132), (2068, 2133), (2338, 2386), (2546, 2587), (35417, 19057),
    (2722, 2729), (3220, 3260), (36151, 18986), (3445, 3521), (36471, 19310),
    (36548, 19170), (3919, 3941), (18084, 18125), (51025, 19445),
    (18470, 18509), (18677, 18748), (51576, 18962), (482, 670), (34178, 19657),
    (2092, 2303), (35430, 19615), (36318, 19614), (51536, 19731), (511, 683),
    (33998, 20408), (35276, 20375), (35562, 20316), (3248, 3294), (3670, 3720),
    (36843, 20238), (51534, 20354), (476, 796), (34884, 20967), (36020, 20524),
    (36376, 20808), (51263, 20966), (18791, 18793), (518, 700), (33898, 21262),
    (34883, 21025), (36024, 21145), (36327, 21265), (18395, 18503),
    (51566, 21024), (33729, 21658), (1382, 1553), (1712, 1737), (1981, 2136),
    (2482, 2572), (35589, 21813), (3257, 3272), (36831, 21809), (51583, 21984),
    (708, 864), (33871, 22496), (1570, 1594), (34543, 22097), (2143, 2359),
    (35524, 22262), (3272, 3313), (36308, 22069), (50948, 22386),
    (51229, 22301), (51457, 22021), (32831, 22750), (1109, 1114), (1875, 2007),
    (35170, 22728), (3274, 3542), (51089, 22988), (51597, 22615),
    (32800, 23124), (33485, 23412), (1135, 1290), (2171, 2216), (3176, 3284),
    (36475, 23189), (94, 110), (797, 863), (1126, 1310), (34984, 23875),
    (36052, 23558), (36325, 23626), (36628, 23585), (33353, 24137),
    (1720, 1884), (2075, 2219), (35974, 24546), (3543, 3567), (4004, 4062),
    (32829, 24609), (526, 554), (1174, 1184), (2133, 2199), (2465, 2536),
    (3289, 3293), (36454, 24648), (3970, 4071), (18651, 18824), (749, 753),
    (1193, 1197), (2197, 2365), (3544, 3776), (4078, 4082), (51547, 25589),
    (33426, 25970), (1119, 1520), (2209, 2229), (3295, 3346), (534, 536),
    (33523, 26130), (1218, 1221), (34526, 26289), (35006, 26548),
    (35300, 26433), (3309, 3726), (36790, 26572), (491, 757), (34375, 27048),
    (3328, 3431), (3638, 3653), (36842, 26694), (51150, 26760), (18783, 18785),
    (32798, 27427), (33408, 27472), (33668, 27413), (1241, 1299), (2203, 2244),
    (35223, 27522), (35410, 27584), (3263, 3354), (18076, 18333),
    (51347, 27473), (51480, 27182), (898, 956), (33904, 27775), (1212, 1278),
    (1517, 1577), (34429, 28066), (34523, 27681), (34764, 27940),
    (34856, 28138), (2231, 2246), (2458, 2526), (2665, 2709), (3324, 3359),
    (3779, 3852), (36835, 28124), (50849, 27945), (18250, 18289),
    (51292, 28064), (18598, 18601), (19, 108), (33669, 28606), (1101, 1167),
    (1282, 1314), (1446, 1510), (34510, 28454), (34703, 28531), (2453, 2464),
    (35440, 28638), (36192, 28167), (36426, 28368), (3947, 4025),
    (18293, 18426), (18607, 18610), (51557, 28575), (32788, 28882),
    (33172, 28686), (33664, 28941), (1322, 1739), (34998, 28967), (2674, 2680),
    (3362, 3410), (3764, 3777), (36836, 28845), (51165, 28920), (51603, 28966),
    (5, 19), (33726, 29695), (34100, 29594), (35015, 29211), (3365, 3725),
    (33364, 30068), (1347, 1350), (34693, 30205), (35027, 29730),
    (35364, 29828), (3209, 3684), (36784, 29830), (33094, 30517), (629, 692),
    (34126, 30479), (2142, 2272), (35469, 30518), (3205, 3395), (36306, 30293),
    (36830, 30294), (43039, 30215), (51587, 30220), (520, 537), (33528, 30898),
    (1367, 1560), (34768, 30832), (35709, 31079), (3395, 3529), (44, 105),
    (1368, 1450), (34967, 31560), (35163, 31494), (2657, 2761), (35959, 31353),
    (3412, 3536), (50850, 31364), (18314, 18418), (51599, 31545), (8, 27),
    (33239, 32132), (1396, 1404), (35062, 32220), (3290, 3658), (2621, 2712),
    (3671, 3743), (485, 663), (1414, 1419), (34810, 32798), (3401, 3533),
    (504, 705), (1180, 1204), (34195, 33637), (35384, 33304), (3422, 3599),
    (36683, 33661), (33186, 33900), (1428, 1452), (3234, 3462), (18368, 18501),
    (813, 958), (1319, 1605), (36230, 34474), (50936, 34475), (32836, 35085),
    (829, 946), (33838, 35264), (1435, 1465), (1688, 1697), (1893, 1917),
    (34811, 35292), (2275, 2362), (2519, 2539), (35474, 35297), (36049, 35144),
    (3410, 3473), (18065, 18075), (50980, 35260), (18704, 18804),
    (32809, 35769), (33310, 35660), (799, 823), (33874, 35817), (33991, 35400),
    (34133, 35365), (1472, 1514), (1685, 1693), (34532, 35603), (1823, 1914),
    (34750, 35618), (2039, 2041), (2100, 2113), (2272, 2275), (2322, 2402),
    (2511, 2604), (35427, 35459), (35515, 35417), (3214, 3240), (3473, 3475),
    (3527, 3535), (36693, 35418), (36757, 35778), (4054, 4072), (18147, 18176),
    (51009, 35686), (18391, 18435), (18529, 18542), (51382, 35617),
    (51448, 35816), (51516, 35727), (51590, 35627), (600, 644), (33648, 36281),
    (1488, 1657), (34847, 35875), (2326, 2363), (35409, 35868), (3435, 3477),
    (51518, 35843), (33535, 36367), (1689, 1786), (2343, 2346), (36246, 36805),
    (3849, 3992), (18733, 18761), (33716, 36985), (1520, 1670), (1934, 1947),
    (2354, 2358), (35386, 37092), (35511, 37211), (3334, 3485), (18516, 18637),
    (51606, 37133), (483, 516), (33878, 38105), (1555, 1559), (34743, 37951),
    (2283, 2382), (35516, 37920), (3489, 3775), (519, 591), (36261, 38706),
    (32823, 39237), (773, 941), (1586, 1742), (34721, 39146), (2407, 2451),
    (36003, 39369), (3392, 3498), (36834, 39171), (51203, 39261),
    (33276, 39501), (1596, 1600), (3498, 3500), (33171, 40438), (33555, 40051),
    (34380, 40254), (3391, 3680), (32817, 40624), (33417, 40643), (1620, 1623),
    (35205, 40493), (3503, 3763), (33174, 41267), (806, 952), (1211, 1442),
    (1623, 1641), (2439, 2450), (51035, 41296), (32790, 41809), (33082, 41897),
    (700, 817), (1431, 1642), (35509, 41654), (3420, 3510), (36698, 41650),
    (1956, 2098), (3512, 3750), (574, 640), (3664, 3907), (32890, 44543),
    (33493, 63608), (1254, 1399), (35024, 63932), (35489, 63525), (3085, 3316),
    (36700, 63552), (18377, 18425),
]; // 3395 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_UPPER: &'static [u16] = &[
    0, 4, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 13, 15, 18, 20, 20, 20,
    20, 21, 27, 29, 51, 86, 101, 117, 141, 161, 178, 191, 214, 225, 240, 252,
    263, 310, 370, 435, 485, 575, 651, 728, 794, 851, 902, 948, 1009, 1075,
    1121, 1185, 1237, 1276, 1363, 1432, 1502, 1561, 1624, 1677, 1736, 1788,
    1836, 1893, 1946, 1997, 2056, 2105, 2149, 2209, 2270, 2328, 2376, 2437,
    2488, 2533, 2579, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630,
    2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630,
    2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630,
    2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630, 2630,
    2631, 2633, 2633, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637, 2637,
    2649, 2662, 2671, 2677, 2683, 2693, 2707, 2719, 2725, 2736, 2744, 2766,
    2792, 2797, 2805, 2813, 2820, 2825, 2832, 2845, 2851, 2855, 2862, 2868,
    2877, 2892, 2901, 2913, 2915, 2919, 2933, 2950, 2966, 2977, 2987, 2990,
    3020, 3045, 3051, 3059, 3065, 3072, 3081, 3092, 3099, 3105, 3112, 3118,
    3127, 3133, 3137, 3145, 3152, 3163, 3181, 3196, 3207, 3212, 3219, 3229,
    3235, 3245, 3250, 3252, 3256, 3262, 3266, 3270, 3285, 3317, 3325, 3331,
    3340, 3340, 3347, 3349, 3358, 3361, 3365, 3370, 3376, 3383, 3385, 3387,
    3387, 3387, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388,
    3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388,
    3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388, 3388,
    3388, 3388, 3388, 3388, 3395,
]; // 382 entries

/// Returns the index pointer for code point `code` in this index.
#[inline]
#[cfg(not(feature = "no-optimized-legacy-encoding"))]
pub fn backward(code: u32) -> u16 {
    let offset = (code >> 4) as usize;
    let offset = if offset < 12190 {BACKWARD_TABLE_UPPER[offset] as usize} else {0};
    // BACKWARD_TABLE_LOWER stores the actual (pre-mapped) value
    // so we don't have to call premap_backward here.
    BACKWARD_TABLE_LOWER[offset + ((code & 15) as usize)]
}

/// Returns the index pointer for code point `code` in this index.
#[cfg(feature = "no-optimized-legacy-encoding")]
pub fn backward(code: u32) -> u16 {
    // avoid mistaking a placeholder for the actual value
    if code == X as u32 { return 0xffff; }
    let codelo = (code & 0xffff) as u16;
    let codehi = code >> 16;
    #[inline] fn verify_and_map(codehi: u32, i: u16) -> Option<u16> {
        let hi = ((FORWARD_TABLE_MORE[i as usize >> 5] >> (i & 31)) & 1) << 1;
        if hi != codehi { return None; }
        Some((i) + 942)
    }
    let offset = (code >> 9) as usize;
    let (start, end) = if offset < 381 {
        (BACKWARD_SEARCH_UPPER[offset], BACKWARD_SEARCH_UPPER[offset+1])
    } else {
        (0, 0)
    };
    for &(s, e) in &BACKWARD_SEARCH_LOWER[(start as usize)..(end as usize)] {
        if s >= 0x8000 {
            if e == codelo {
                if let Some(i_) = verify_and_map(codehi, s & 0x7fff) { return i_; }
            }
        } else {
            for i in s..e {
                if FORWARD_TABLE[i as usize] == codelo {
                    if let Some(i_) = verify_and_map(codehi, i) { return i_; }
                }
            }
        }
    }
    X
}

#[cfg(test)]
multi_byte_tests! {
    dups = [
        1133, 1135, 1164, 1166, 2673, 3437, 4369, 4748, 4828, 4898, 4902, 4981,
        4982, 4997, 5206, 5207, 5208, 5209, 5214, 5512, 5599, 6410, 6422, 6543,
        6732, 7300, 7410, 7915, 8240, 8281, 8870, 9081, 9103, 9741, 9802, 9810,
        9840, 9909, 10024, 10696, 10825, 10950, 10957, 11332, 11345, 11458,
        11479, 12065, 12497, 12739, 13142, 14159, 14187, 14305, 14651, 14708,
        14975, 15488, 15930, 15967, 16278, 16353, 16745, 17060, 17421, 17713,
        18346, 18728, 18938, 18957, 18975, 18976, 18977, 18991, 18992, 18993,
        18994, 18995, 19028, 19035, 19088, 19096, 19112, 19162, 19240, 19299,
        19305, 19309, 19326, 19355, 19398, 19424, 19439, 19454, 19504, 19553,
        19554, 19557, 19611, 19643, 19672, 19697, 19720, 19748,
    ]
}
