/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelApplet;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;

class PointEditDialog
extends ObjectEditDialog {
    public String xaxis_variable;
    public String yaxis_variable;
    TextFieldAction X;
    TextFieldAction Y;
    MyTextField Away;
    MyTextField Bound;
    MyTextField Increment;
    Checkbox Fixed;
    Checkbox Close;
    Checkbox Restricted;
    Checkbox Alternate;
    Checkbox Inside;
    IconBar TypeIB;
    ZirkelCanvas ZC;
    Button BoundButton;

    public PointEditDialog(Frame frame, PointObject pointObject) {
        super(frame, Zirkel.name("edit.point.title"), pointObject);
    }

    public PointEditDialog(ZirkelCanvas zirkelCanvas, PointObject pointObject) {
        this(zirkelCanvas.getFrame(), pointObject);
        this.ZC = zirkelCanvas;
    }

    public void addFirst(Panel panel) {
        this.xaxis_variable = ZirkelApplet.xaxis_variable;
        this.yaxis_variable = ZirkelApplet.yaxis_variable;
        PointObject pointObject = (PointObject)this.O;
        this.X = new TextFieldAction(this, this.xaxis_variable, "" + pointObject.round(pointObject.getX()), 30);
        panel.add(new MyLabel("" + this.xaxis_variable + ""));
        panel.add(this.X);
        this.Y = new TextFieldAction(this, this.yaxis_variable, "" + pointObject.round(pointObject.getY()), 30);
        panel.add(new MyLabel("" + this.yaxis_variable + ""));
        panel.add(this.Y);
        if (pointObject.moveablePoint()) {
            this.Fixed = new Checkbox("");
            this.Fixed.setState(pointObject.fixed());
            panel.add(new MyLabel(Zirkel.name("edit.fixed")));
            panel.add(this.Fixed);
            if (pointObject.fixed()) {
                this.X.setText(pointObject.getEX());
                this.Y.setText(pointObject.getEY());
            }
            panel.add(new MyLabel(Zirkel.name("edit.point.increment")));
            this.Increment = new MyTextField("" + pointObject.round(pointObject.getIncrement()));
            panel.add(this.Increment);
        } else {
            this.X.setEditable(false);
            this.Y.setEditable(false);
        }
        if (pointObject instanceof IntersectionObject && ((IntersectionObject)pointObject).isSwitchable()) {
            this.Away = new MyTextField("", 5);
            this.Away.setText(((IntersectionObject)pointObject).away());
            this.Close = new CheckboxAction(this, Zirkel.name("edit.point.close"));
            this.Close.setState(!((IntersectionObject)pointObject).stayAway());
            panel.add(new MyLabel(Zirkel.name("edit.point.intersection")));
            MyPanel myPanel = new MyPanel();
            myPanel.setLayout(new GridLayout(1, 2));
            myPanel.add(this.Away);
            myPanel.add(this.Close);
            panel.add(myPanel);
        }
        if (pointObject instanceof IntersectionObject) {
            panel.add(new MyLabel(Zirkel.name("edit.plumb.restricted")));
            this.Restricted = new CheckboxAction(this, "", "Restricted");
            this.Restricted.setState(((IntersectionObject)pointObject).isRestricted());
            panel.add(this.Restricted);
            if (((IntersectionObject)pointObject).canAlternate()) {
                panel.add(new MyLabel(Zirkel.name("edit.intersection.alternate")));
                this.Alternate = new CheckboxAction(this, "", "Alternate");
                this.Alternate.setState(((IntersectionObject)pointObject).isAlternate());
                panel.add(this.Alternate);
            }
        }
        if (pointObject.isPointOn()) {
            panel.add(new MyLabel(Zirkel.name("edit.point.bound")));
            this.Bound = new MyTextField(pointObject.getBound().getName());
            panel.add(this.Bound);
            this.Bound.setEditable(false);
            if (pointObject.getBound() instanceof InsideObject) {
                panel.add(new MyLabel(Zirkel.name("edit.point.inside")));
                this.Inside = new CheckboxAction(this, "", "Inside");
                panel.add(this.Inside);
                this.Inside.setState(pointObject.isInside());
            }
            if (this.Fixed != null) {
                this.Fixed.setState(pointObject.useAlpha());
            }
        }
    }

    public void addButton(Panel panel) {
        PointObject pointObject = (PointObject)this.O;
        if (pointObject.moveablePoint()) {
            this.BoundButton = pointObject.isPointOn() ? new ButtonAction(this, Zirkel.name("bound.release"), "Release") : new ButtonAction(this, Zirkel.name("bound.bind"), "Bind");
            panel.add(this.BoundButton);
            panel.add(new MyLabel(" "));
        } else if (pointObject instanceof IntersectionObject && ((IntersectionObject)pointObject).isSwitchable()) {
            panel.add(new ButtonAction(this, Zirkel.name("edit.point.away"), "SetAway"));
            panel.add(new ButtonAction(this, Zirkel.name("edit.point.close"), "SetClose"));
            if (!((IntersectionObject)pointObject).away().equals("")) {
                panel.add(new ButtonAction(this, Zirkel.name("edit.point.free"), "SetFree"));
            }
            panel.add(new MyLabel(" "));
        }
    }

    public void addSecond(Panel panel) {
        PointObject pointObject = (PointObject)this.O;
        this.TypeIB = new IconBar(this.F);
        this.TypeIB.addToggleGroupLeft("type", 6);
        this.TypeIB.toggle("type", pointObject.getType());
        panel.add(new MyLabel(""));
        panel.add(this.TypeIB);
    }

    public void doAction(String string) {
        if ((string.equals(this.xaxis_variable) || string.equals(this.yaxis_variable)) && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        }
        if ((string.equals("Y") || string.equals("X")) && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else if (string.equals("Release")) {
            ((PointObject)this.O).setBound("");
            this.O.getConstruction().updateCircleDep();
            if (this.Fixed != null) {
                this.Fixed.setState(false);
            }
            super.doAction("OK");
        } else if (string.equals("Bind")) {
            this.ZC.bind((PointObject)this.O);
            super.doAction("OK");
        } else if (string.equals("SetAway")) {
            this.ZC.setAway((IntersectionObject)this.O, true);
            super.doAction("OK");
        } else if (string.equals("SetClose")) {
            this.ZC.setAway((IntersectionObject)this.O, false);
            super.doAction("OK");
        } else if (string.equals("SetFree")) {
            ((IntersectionObject)this.O).setAway("");
            this.Away = null;
            super.doAction("OK");
        } else if (string.equals("OK")) {
            if (this.Fixed != null && this.X.isChanged() || this.Y.isChanged()) {
                this.Fixed.setState(true);
            }
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void setAction() {
        double d2;
        double d3;
        PointObject pointObject = (PointObject)this.O;
        if ((this.X.isChanged() || this.Y.isChanged()) && pointObject.isPointOn()) {
            try {
                d3 = new Expression(this.X.getText(), pointObject.getConstruction(), pointObject).getValue();
                d2 = new Expression(this.Y.getText(), pointObject.getConstruction(), pointObject).getValue();
                pointObject.move(d3, d2);
                pointObject.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.Fixed != null && this.Fixed.getState()) {
            if (pointObject.isPointOn()) {
                pointObject.setUseAlpha(true);
            } else {
                pointObject.setFixed(this.X.getText(), this.Y.getText());
            }
        } else {
            try {
                d3 = new Expression(this.X.getText(), pointObject.getConstruction(), pointObject).getValue();
                d2 = new Expression(this.Y.getText(), pointObject.getConstruction(), pointObject).getValue();
                if (pointObject.moveable()) {
                    pointObject.move(d3, d2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.Fixed != null && !this.Fixed.getState()) {
            if (pointObject.isPointOn()) {
                pointObject.setUseAlpha(false);
            } else {
                pointObject.setFixed(false);
            }
        }
        if (this.Away != null && !((IntersectionObject)pointObject).setAway(this.Away.getText(), !this.Close.getState())) {
            Warning warning = new Warning(this.F, Zirkel.name("bound.error"), Zirkel.name("warning"));
            warning.center(this.F);
            warning.setVisible(true);
        }
        if (this.Restricted != null) {
            ((IntersectionObject)pointObject).setRestricted(this.Restricted.getState());
        }
        if (this.Alternate != null) {
            ((IntersectionObject)pointObject).setAlternate(this.Alternate.getState());
        }
        if (this.Increment != null) {
            try {
                pointObject.setIncrement(new Expression(this.Increment.getText(), pointObject.getConstruction(), pointObject).getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pointObject.setType(this.TypeIB.getToggleState("type"));
        if (this.Inside != null) {
            pointObject.setInside(this.Inside.getState());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.X.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }
}

